/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.security.EvaluateCertGUI;
import com.ca.commons.security.KeystoreGUI;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JXTrustManager
implements X509TrustManager {
    public static String CERTSTORE = "lbecacerts";
    public static String CERTSTORE_PASSWORD = "changeit";
    private X509TrustManager trustManager;
    private EvaluateCertGUI verifier;
    private Frame owner;
    private KeyStore caKeyStore;
    private String caKeyStorePath;
    private String caKeyStoreType;
    private char[] caPassphrase;

    public static X509TrustManager[] convert(TrustManager[] arrayOfTrustManagers, KeyStore keystore, String caKeystorePath, char[] caPassphrase, String caKeystoreType, Frame rootFrame) throws SSLException {
        int numberOfManagers = arrayOfTrustManagers.length;
        X509TrustManager[] returnArray = new X509TrustManager[numberOfManagers];
        for (int i = 0; i < numberOfManagers; ++i) {
            TrustManager old = arrayOfTrustManagers[i];
            if (old == null) {
                throw new SSLException("unexpected SSL error - null trust manager found in trust array: element " + i + " of " + numberOfManagers);
            }
            try {
                returnArray[i] = new JXTrustManager((X509TrustManager)old, keystore, caKeystorePath, caPassphrase, caKeystoreType, rootFrame);
                continue;
            }
            catch (ClassCastException e) {
                throw new SSLException("unexpected SSL error - non X509 trust manager found in trust array: element " + i + " of " + numberOfManagers + " is of type " + old.getClass());
            }
        }
        return returnArray;
    }

    private JXTrustManager(X509TrustManager baseTrustManager, KeyStore keystore, String certAuthorityKeystorePath, char[] certAuthorityPassphrase, String certAuthorityKeystoreType, Frame rootFrame) {
        this.trustManager = baseTrustManager;
        this.caKeyStore = keystore;
        this.caKeyStorePath = certAuthorityKeystorePath;
        this.caKeyStoreType = certAuthorityKeystoreType;
        this.caPassphrase = certAuthorityPassphrase;
        this.owner = rootFrame;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private X509Certificate getCACert(X509Certificate[] chain) {
        X509Certificate ca = chain[chain.length - 1];
        if (ca.getSubjectDN().equals(ca.getIssuerDN())) {
            return ca;
        }
        return null;
    }

    private boolean rootCertIsKnown(X509Certificate caCert) {
        X509Certificate[] certificates = this.getAcceptedIssuers();
        if (certificates == null) {
            return false;
        }
        for (int i = 0; i < certificates.length; ++i) {
            if (!caCert.equals(certificates[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            if ("false".equals(System.getProperty("option.ssl.import.cert.during.connection"))) {
                throw e;
            }
            X509Certificate certificateAuthorityCert = this.getCACert(chain);
            if (certificateAuthorityCert == null) {
                throw new CertificateException("Invalid Server Certificate: server certificate could not be verified, and the CA certificate is missing from the certificate chain. raw error: " + e);
            }
            if (this.rootCertIsKnown(certificateAuthorityCert)) {
                throw new CertificateException("Invalid Server Certificate: The server certificate could not be verified, as it has a bad chain back to a known CA.  raw error: " + e);
            }
            if (this.verifier == null) {
                this.verifier = new EvaluateCertGUI(this.owner);
            }
            switch (this.verifier.isTrusted(certificateAuthorityCert)) {
                case 0: {
                    throw new CertificateException("user chose not to trust unknown certificate");
                }
                case 1: {
                    return;
                }
                case 2: {
                    try {
                        this.saveStore(certificateAuthorityCert);
                    }
                    catch (KeyStoreException e1) {
                        throw new CertificateException("unable to save certificate in keystore! " + e1);
                    }
                    return;
                }
            }
        }
    }

    private void saveStore(X509Certificate cert) throws KeyStoreException {
        try {
            if (this.caPassphrase == null) {
                this.caPassphrase = "changeit".toCharArray();
            }
            try {
                this.caKeyStore.load(new FileInputStream(this.caKeyStorePath), this.caPassphrase);
            }
            catch (IOException e) {
                this.setupKeyStoreAndPassword();
            }
            if (this.caKeyStore == null) {
                throw new KeyStoreException("unable to open keystore - no valid password or no valid file.");
            }
            String alias = cert.getSubjectDN() + " (" + cert.getSerialNumber().toString() + ")";
            this.caKeyStore.setCertificateEntry(alias, cert);
            FileOutputStream fos = new FileOutputStream(this.caKeyStorePath);
            this.caKeyStore.store(fos, this.caPassphrase);
            fos.close();
        }
        catch (IOException e) {
            KeyStoreException kse = new KeyStoreException("unable to access keystore file");
            kse.initCause(e);
            throw kse;
        }
        catch (GeneralSecurityException e) {
            if (e instanceof KeyStoreException) {
                throw (KeyStoreException)e;
            }
            throw new KeyStoreException("unable to save keystore " + this.caKeyStorePath + " error was: " + e);
        }
    }

    private boolean setupKeyStoreAndPassword() {
        String message = CBIntText.get("Enter Key Store Password");
        while ((this.caPassphrase = KeystoreGUI.getPassword(this.owner, message)) != null) {
            this.caKeyStore = KeystoreGUI.readKeyStore(this.caPassphrase, this.caKeyStoreType, this.caKeyStorePath);
            if (this.caKeyStore != null) {
                return true;
            }
            message = CBIntText.get("Password incorrect. Please try again.");
        }
        return false;
    }
}

