// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/ads/admob/v1/admob_resources.proto

package admob

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The sorting order.
type SortOrder int32

const (
	// Default value for an unset field. Do not use.
	SortOrder_SORT_ORDER_UNSPECIFIED SortOrder = 0
	// Sort dimension value or metric value in ascending order.
	SortOrder_ASCENDING SortOrder = 1
	// Sort dimension value or metric value in descending order.
	SortOrder_DESCENDING SortOrder = 2
)

// Enum value maps for SortOrder.
var (
	SortOrder_name = map[int32]string{
		0: "SORT_ORDER_UNSPECIFIED",
		1: "ASCENDING",
		2: "DESCENDING",
	}
	SortOrder_value = map[string]int32{
		"SORT_ORDER_UNSPECIFIED": 0,
		"ASCENDING":              1,
		"DESCENDING":             2,
	}
)

func (x SortOrder) Enum() *SortOrder {
	p := new(SortOrder)
	*p = x
	return p
}

func (x SortOrder) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SortOrder) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ads_admob_v1_admob_resources_proto_enumTypes[0].Descriptor()
}

func (SortOrder) Type() protoreflect.EnumType {
	return &file_google_ads_admob_v1_admob_resources_proto_enumTypes[0]
}

func (x SortOrder) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SortOrder.Descriptor instead.
func (SortOrder) EnumDescriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{0}
}

// The dimensions of the network report. Dimensions are data attributes to
// break down or refine the quantitative measurements (metrics) by certain
// attributes, such as the ad format or the platform an ad was viewed on.
type NetworkReportSpec_Dimension int32

const (
	// Default value for an unset field. Do not use.
	NetworkReportSpec_DIMENSION_UNSPECIFIED NetworkReportSpec_Dimension = 0
	// A date in the YYYY-MM-DD format (for example, "2018-12-21"). Requests can
	// specify at most one time dimension.
	NetworkReportSpec_DATE NetworkReportSpec_Dimension = 1
	// A month in the YYYY-MM format (for example, "2018-12"). Requests can
	// specify at most one time dimension.
	NetworkReportSpec_MONTH NetworkReportSpec_Dimension = 2
	// The date of the first day of a week in the YYYY-MM-DD format
	// (for example, "2018-12-21"). Requests can specify at most one time
	// dimension.
	NetworkReportSpec_WEEK NetworkReportSpec_Dimension = 3
	// The unique ID of the ad unit (for example, "ca-app-pub-1234/1234").
	// If AD_UNIT dimension is specified, then APP is included automatically.
	NetworkReportSpec_AD_UNIT NetworkReportSpec_Dimension = 4
	// The unique ID of the mobile application (for example,
	// "ca-app-pub-1234~1234").
	NetworkReportSpec_APP NetworkReportSpec_Dimension = 5
	// CLDR country code of the place where the ad views/clicks occur (for
	// example, "US" or "FR"). This is a geography dimension.
	NetworkReportSpec_COUNTRY NetworkReportSpec_Dimension = 7
	// Format of the ad unit (for example, "banner", "native"), an ad delivery
	// dimension.
	NetworkReportSpec_FORMAT NetworkReportSpec_Dimension = 8
	// Mobile OS platform of the app (for example, "Android" or "iOS").
	NetworkReportSpec_PLATFORM NetworkReportSpec_Dimension = 9
)

// Enum value maps for NetworkReportSpec_Dimension.
var (
	NetworkReportSpec_Dimension_name = map[int32]string{
		0: "DIMENSION_UNSPECIFIED",
		1: "DATE",
		2: "MONTH",
		3: "WEEK",
		4: "AD_UNIT",
		5: "APP",
		7: "COUNTRY",
		8: "FORMAT",
		9: "PLATFORM",
	}
	NetworkReportSpec_Dimension_value = map[string]int32{
		"DIMENSION_UNSPECIFIED": 0,
		"DATE":                  1,
		"MONTH":                 2,
		"WEEK":                  3,
		"AD_UNIT":               4,
		"APP":                   5,
		"COUNTRY":               7,
		"FORMAT":                8,
		"PLATFORM":              9,
	}
)

func (x NetworkReportSpec_Dimension) Enum() *NetworkReportSpec_Dimension {
	p := new(NetworkReportSpec_Dimension)
	*p = x
	return p
}

func (x NetworkReportSpec_Dimension) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkReportSpec_Dimension) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ads_admob_v1_admob_resources_proto_enumTypes[1].Descriptor()
}

func (NetworkReportSpec_Dimension) Type() protoreflect.EnumType {
	return &file_google_ads_admob_v1_admob_resources_proto_enumTypes[1]
}

func (x NetworkReportSpec_Dimension) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkReportSpec_Dimension.Descriptor instead.
func (NetworkReportSpec_Dimension) EnumDescriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{1, 0}
}

// The metrics of the network report. Metrics are quantitative measurements
// indicating how the publisher business is performing. They are aggregated
// from the individual ad events and grouped by the report dimensions. The
// metric value is either integer, or decimal (without rounding).
type NetworkReportSpec_Metric int32

const (
	// Default value for an unset field. Do not use.
	NetworkReportSpec_METRIC_UNSPECIFIED NetworkReportSpec_Metric = 0
	// The number of ad requests. The value is an integer.
	NetworkReportSpec_AD_REQUESTS NetworkReportSpec_Metric = 1
	// The number of times a user clicks an ad. The value is an integer.
	NetworkReportSpec_CLICKS NetworkReportSpec_Metric = 2
	// The estimated earnings of the AdMob publisher. The currency unit (USD,
	// EUR, or other) of the earning metrics are determined by the localization
	// setting for currency. The amount is in micros. For example, $6.50 would
	// be represented as 6500000.
	NetworkReportSpec_ESTIMATED_EARNINGS NetworkReportSpec_Metric = 3
	// The total number of ads shown to users. The value is an integer.
	NetworkReportSpec_IMPRESSIONS NetworkReportSpec_Metric = 4
	// The ratio of clicks over impressions. The value is a double precision
	// (approximate) decimal value.
	NetworkReportSpec_IMPRESSION_CTR NetworkReportSpec_Metric = 5
	// The estimated earnings per thousand ad impressions. The value is in
	// micros. For example, $1.03 would be represented as 1030000.
	NetworkReportSpec_IMPRESSION_RPM NetworkReportSpec_Metric = 6
	// The number of times ads are returned in response to a request. The value
	// is an integer.
	NetworkReportSpec_MATCHED_REQUESTS NetworkReportSpec_Metric = 7
	// The ratio of matched ad requests over the total ad requests. The value is
	// a double precision (approximate) decimal value.
	NetworkReportSpec_MATCH_RATE NetworkReportSpec_Metric = 8
	// The ratio of ads that are displayed over ads that are returned, defined
	// as impressions / matched requests. The value is a double precision
	// (approximate) decimal value.
	NetworkReportSpec_SHOW_RATE NetworkReportSpec_Metric = 9
)

// Enum value maps for NetworkReportSpec_Metric.
var (
	NetworkReportSpec_Metric_name = map[int32]string{
		0: "METRIC_UNSPECIFIED",
		1: "AD_REQUESTS",
		2: "CLICKS",
		3: "ESTIMATED_EARNINGS",
		4: "IMPRESSIONS",
		5: "IMPRESSION_CTR",
		6: "IMPRESSION_RPM",
		7: "MATCHED_REQUESTS",
		8: "MATCH_RATE",
		9: "SHOW_RATE",
	}
	NetworkReportSpec_Metric_value = map[string]int32{
		"METRIC_UNSPECIFIED": 0,
		"AD_REQUESTS":        1,
		"CLICKS":             2,
		"ESTIMATED_EARNINGS": 3,
		"IMPRESSIONS":        4,
		"IMPRESSION_CTR":     5,
		"IMPRESSION_RPM":     6,
		"MATCHED_REQUESTS":   7,
		"MATCH_RATE":         8,
		"SHOW_RATE":          9,
	}
)

func (x NetworkReportSpec_Metric) Enum() *NetworkReportSpec_Metric {
	p := new(NetworkReportSpec_Metric)
	*p = x
	return p
}

func (x NetworkReportSpec_Metric) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkReportSpec_Metric) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ads_admob_v1_admob_resources_proto_enumTypes[2].Descriptor()
}

func (NetworkReportSpec_Metric) Type() protoreflect.EnumType {
	return &file_google_ads_admob_v1_admob_resources_proto_enumTypes[2]
}

func (x NetworkReportSpec_Metric) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkReportSpec_Metric.Descriptor instead.
func (NetworkReportSpec_Metric) EnumDescriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{1, 1}
}

// The dimensions of the mediation report. Dimensions are data attributes to
// break down or refine the quantitative measurements (metrics) by certain
// attributes, such as the ad format or the platform an ad was viewed on.
type MediationReportSpec_Dimension int32

const (
	// Default value for an unset field. Do not use.
	MediationReportSpec_DIMENSION_UNSPECIFIED MediationReportSpec_Dimension = 0
	// A date in the YYYY-MM-DD format (for example, "2018-12-21"). Requests can
	// specify at most one time dimension.
	MediationReportSpec_DATE MediationReportSpec_Dimension = 1
	// A month in the YYYY-MM format (for example, "2018-12"). Requests can
	// specify at most one time dimension.
	MediationReportSpec_MONTH MediationReportSpec_Dimension = 2
	// The date of the first day of a week in the YYYY-MM-DD format
	// (for example, "2018-12-21"). Requests can specify at most one time
	// dimension.
	MediationReportSpec_WEEK MediationReportSpec_Dimension = 3
	// The unique ID of the ad source (for example, "5450213213286189855" and
	// "AdMob Network" as label value).
	MediationReportSpec_AD_SOURCE MediationReportSpec_Dimension = 4
	// The unique ID of the ad source instance (for example,
	// "ca-app-pub-1234#5678" and "AdMob (default)" as label value).
	// Warning: The dimension is incompatible with ESTIMATED_EARNINGS and
	// OBSERVED_ECPM metrics.
	MediationReportSpec_AD_SOURCE_INSTANCE MediationReportSpec_Dimension = 5
	// The unique ID of the ad unit (for example, "ca-app-pub-1234/8790").
	// If AD_UNIT dimension is specified, then APP is included automatically.
	MediationReportSpec_AD_UNIT MediationReportSpec_Dimension = 6
	// The unique ID of the mobile application (for example,
	// "ca-app-pub-1234~1234").
	MediationReportSpec_APP MediationReportSpec_Dimension = 7
	// The unique ID of the mediation group (for example,
	// "ca-app-pub-1234:mg:1234" and "AdMob (default)" as label value).
	// Warning: The dimension is incompatible with ESTIMATED_EARNINGS and
	// OBSERVED_ECPM metrics.
	MediationReportSpec_MEDIATION_GROUP MediationReportSpec_Dimension = 11
	// CLDR country code of the place where the ad views/clicks occur (for
	// example, "US" or "FR"). This is a geography dimension.
	MediationReportSpec_COUNTRY MediationReportSpec_Dimension = 8
	// Format of the ad unit (for example, "banner", "native"), an ad delivery
	// dimension.
	MediationReportSpec_FORMAT MediationReportSpec_Dimension = 9
	// Mobile OS platform of the app (for example, "Android" or "iOS").
	MediationReportSpec_PLATFORM MediationReportSpec_Dimension = 10
)

// Enum value maps for MediationReportSpec_Dimension.
var (
	MediationReportSpec_Dimension_name = map[int32]string{
		0:  "DIMENSION_UNSPECIFIED",
		1:  "DATE",
		2:  "MONTH",
		3:  "WEEK",
		4:  "AD_SOURCE",
		5:  "AD_SOURCE_INSTANCE",
		6:  "AD_UNIT",
		7:  "APP",
		11: "MEDIATION_GROUP",
		8:  "COUNTRY",
		9:  "FORMAT",
		10: "PLATFORM",
	}
	MediationReportSpec_Dimension_value = map[string]int32{
		"DIMENSION_UNSPECIFIED": 0,
		"DATE":                  1,
		"MONTH":                 2,
		"WEEK":                  3,
		"AD_SOURCE":             4,
		"AD_SOURCE_INSTANCE":    5,
		"AD_UNIT":               6,
		"APP":                   7,
		"MEDIATION_GROUP":       11,
		"COUNTRY":               8,
		"FORMAT":                9,
		"PLATFORM":              10,
	}
)

func (x MediationReportSpec_Dimension) Enum() *MediationReportSpec_Dimension {
	p := new(MediationReportSpec_Dimension)
	*p = x
	return p
}

func (x MediationReportSpec_Dimension) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MediationReportSpec_Dimension) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ads_admob_v1_admob_resources_proto_enumTypes[3].Descriptor()
}

func (MediationReportSpec_Dimension) Type() protoreflect.EnumType {
	return &file_google_ads_admob_v1_admob_resources_proto_enumTypes[3]
}

func (x MediationReportSpec_Dimension) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MediationReportSpec_Dimension.Descriptor instead.
func (MediationReportSpec_Dimension) EnumDescriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{2, 0}
}

// The metrics of the mediation report. Metrics are quantitative measurements
// indicating how the publisher business is performing. They are aggregated
// from the individual ad events and grouped by the report dimensions. The
// metric value is either integer, or decimal (without rounding).
type MediationReportSpec_Metric int32

const (
	// Default value for an unset field. Do not use.
	MediationReportSpec_METRIC_UNSPECIFIED MediationReportSpec_Metric = 0
	// The number of requests. The value is an integer.
	MediationReportSpec_AD_REQUESTS MediationReportSpec_Metric = 1
	// The number of times a user clicks an ad. The value is an integer.
	MediationReportSpec_CLICKS MediationReportSpec_Metric = 2
	// The estimated earnings of the AdMob publisher. The currency unit (USD,
	// EUR, or other) of the earning metrics are determined by the localization
	// setting for currency. The amount is in micros. For example, $6.50 would
	// be represented as 6500000.
	// Warning: The metric is incompatible with AD_SOURCE_INSTANCE and
	// MEDIATION_GROUP dimensions.
	MediationReportSpec_ESTIMATED_EARNINGS MediationReportSpec_Metric = 3
	// The total number of ads shown to users. The value is an integer.
	MediationReportSpec_IMPRESSIONS MediationReportSpec_Metric = 4
	// The ratio of clicks over impressions. The value is a double precision
	// (approximate) decimal value.
	MediationReportSpec_IMPRESSION_CTR MediationReportSpec_Metric = 5
	// The number of times ads are returned in response to a request. The value
	// is an integer.
	MediationReportSpec_MATCHED_REQUESTS MediationReportSpec_Metric = 6
	// The ratio of matched ad requests over the total ad requests. The value is
	// a double precision (approximate) decimal value.
	MediationReportSpec_MATCH_RATE MediationReportSpec_Metric = 7
	// The third-party ad network's estimated average eCPM. The currency unit
	// (USD, EUR, or other) of the earning metrics are determined by the
	// localization setting for currency. The amount is in micros. For example,
	// $2.30 would be represented as 2300000.
	// Warning: The metric is incompatible with AD_SOURCE_INSTANCE and
	// MEDIATION_GROUP dimensions.
	MediationReportSpec_OBSERVED_ECPM MediationReportSpec_Metric = 8
)

// Enum value maps for MediationReportSpec_Metric.
var (
	MediationReportSpec_Metric_name = map[int32]string{
		0: "METRIC_UNSPECIFIED",
		1: "AD_REQUESTS",
		2: "CLICKS",
		3: "ESTIMATED_EARNINGS",
		4: "IMPRESSIONS",
		5: "IMPRESSION_CTR",
		6: "MATCHED_REQUESTS",
		7: "MATCH_RATE",
		8: "OBSERVED_ECPM",
	}
	MediationReportSpec_Metric_value = map[string]int32{
		"METRIC_UNSPECIFIED": 0,
		"AD_REQUESTS":        1,
		"CLICKS":             2,
		"ESTIMATED_EARNINGS": 3,
		"IMPRESSIONS":        4,
		"IMPRESSION_CTR":     5,
		"MATCHED_REQUESTS":   6,
		"MATCH_RATE":         7,
		"OBSERVED_ECPM":      8,
	}
)

func (x MediationReportSpec_Metric) Enum() *MediationReportSpec_Metric {
	p := new(MediationReportSpec_Metric)
	*p = x
	return p
}

func (x MediationReportSpec_Metric) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MediationReportSpec_Metric) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ads_admob_v1_admob_resources_proto_enumTypes[4].Descriptor()
}

func (MediationReportSpec_Metric) Type() protoreflect.EnumType {
	return &file_google_ads_admob_v1_admob_resources_proto_enumTypes[4]
}

func (x MediationReportSpec_Metric) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MediationReportSpec_Metric.Descriptor instead.
func (MediationReportSpec_Metric) EnumDescriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{2, 1}
}

// Warning type.
type ReportWarning_Type int32

const (
	// Default value for an unset field. Do not use.
	ReportWarning_TYPE_UNSPECIFIED ReportWarning_Type = 0
	// Some data in this report is aggregated based on a time zone different
	// from the requested time zone. This could happen if a local time-zone
	// report has the start time before the last time this time zone changed.
	// The description field will contain the date of the last time zone
	// change.
	ReportWarning_DATA_BEFORE_ACCOUNT_TIMEZONE_CHANGE ReportWarning_Type = 1
	// There is an unusual delay in processing the source data for the
	// requested date range. The report results might be less up to date than
	// usual. AdMob is aware of the issue and is actively working to resolve
	// it.
	ReportWarning_DATA_DELAYED ReportWarning_Type = 2
	// Warnings that are exposed without a specific type. Useful when new
	// warning types are added but the API is not changed yet.
	ReportWarning_OTHER ReportWarning_Type = 3
	// The currency being requested is not the account currency. The earning
	// metrics will be based on the requested currency, and thus not a good
	// estimation of the final payment anymore, due to the currency rate
	// fluctuation.
	ReportWarning_REPORT_CURRENCY_NOT_ACCOUNT_CURRENCY ReportWarning_Type = 4
)

// Enum value maps for ReportWarning_Type.
var (
	ReportWarning_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DATA_BEFORE_ACCOUNT_TIMEZONE_CHANGE",
		2: "DATA_DELAYED",
		3: "OTHER",
		4: "REPORT_CURRENCY_NOT_ACCOUNT_CURRENCY",
	}
	ReportWarning_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":                     0,
		"DATA_BEFORE_ACCOUNT_TIMEZONE_CHANGE":  1,
		"DATA_DELAYED":                         2,
		"OTHER":                                3,
		"REPORT_CURRENCY_NOT_ACCOUNT_CURRENCY": 4,
	}
)

func (x ReportWarning_Type) Enum() *ReportWarning_Type {
	p := new(ReportWarning_Type)
	*p = x
	return p
}

func (x ReportWarning_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReportWarning_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ads_admob_v1_admob_resources_proto_enumTypes[5].Descriptor()
}

func (ReportWarning_Type) Type() protoreflect.EnumType {
	return &file_google_ads_admob_v1_admob_resources_proto_enumTypes[5]
}

func (x ReportWarning_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReportWarning_Type.Descriptor instead.
func (ReportWarning_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{4, 0}
}

// A publisher account contains information relevant to the use of this API,
// such as the time zone used for the reports.
type PublisherAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of this account.
	// Format is accounts/{publisher_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique ID by which this publisher account can be identified
	// in the API requests (for example, pub-1234567890).
	PublisherId string `protobuf:"bytes,2,opt,name=publisher_id,json=publisherId,proto3" json:"publisher_id,omitempty"`
	// The time zone that is used in reports that are generated for this account.
	// The value is a time-zone ID as specified by the CLDR project,
	// for example, "America/Los_Angeles".
	ReportingTimeZone string `protobuf:"bytes,3,opt,name=reporting_time_zone,json=reportingTimeZone,proto3" json:"reporting_time_zone,omitempty"`
	// Currency code of the earning-related metrics, which is the 3-letter code
	// defined in ISO 4217. The daily average rate is used for the currency
	// conversion.
	CurrencyCode string `protobuf:"bytes,4,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
}

func (x *PublisherAccount) Reset() {
	*x = PublisherAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherAccount) ProtoMessage() {}

func (x *PublisherAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherAccount.ProtoReflect.Descriptor instead.
func (*PublisherAccount) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{0}
}

func (x *PublisherAccount) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PublisherAccount) GetPublisherId() string {
	if x != nil {
		return x.PublisherId
	}
	return ""
}

func (x *PublisherAccount) GetReportingTimeZone() string {
	if x != nil {
		return x.ReportingTimeZone
	}
	return ""
}

func (x *PublisherAccount) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

// The specification for generating an AdMob Network report.
// For example, the specification to get clicks and estimated earnings for only
// the 'US' and 'CN' countries can look like the following example:
//
//     {
//       'date_range': {
//         'start_date': {'year': 2018, 'month': 9, 'day': 1},
//         'end_date': {'year': 2018, 'month': 9, 'day': 30}
//       },
//       'dimensions': ['DATE', 'APP', 'COUNTRY'],
//       'metrics': ['CLICKS', 'ESTIMATED_EARNINGS'],
//       'dimension_filters': [
//         {
//           'dimension': 'COUNTRY',
//           'matches_any': {'values': [{'value': 'US', 'value': 'CN'}]}
//         }
//       ],
//       'sort_conditions': [
//         {'dimension':'APP', order: 'ASCENDING'},
//         {'metric':'CLICKS', order: 'DESCENDING'}
//       ],
//       'localization_settings': {
//         'currency_code': 'USD',
//         'language_code': 'en-US'
//       }
//     }
//
// For a better understanding, you can treat the preceding specification like
// the following pseudo SQL:
//
//     SELECT DATE, APP, COUNTRY, CLICKS, ESTIMATED_EARNINGS
//     FROM NETWORK_REPORT
//     WHERE DATE >= '2018-09-01' AND DATE <= '2018-09-30'
//         AND COUNTRY IN ('US', 'CN')
//     GROUP BY DATE, APP, COUNTRY
//     ORDER BY APP ASC, CLICKS DESC;
type NetworkReportSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The date range for which the report is generated.
	DateRange *DateRange `protobuf:"bytes,1,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// List of dimensions of the report. The value combination of these dimensions
	// determines the row of the report. If no dimensions are specified, the
	// report returns a single row of requested metrics for the entire account.
	Dimensions []NetworkReportSpec_Dimension `protobuf:"varint,2,rep,packed,name=dimensions,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Dimension" json:"dimensions,omitempty"`
	// List of metrics of the report. A report must specify at least one metric.
	Metrics []NetworkReportSpec_Metric `protobuf:"varint,3,rep,packed,name=metrics,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Metric" json:"metrics,omitempty"`
	// Describes which report rows to match based on their dimension values.
	DimensionFilters []*NetworkReportSpec_DimensionFilter `protobuf:"bytes,4,rep,name=dimension_filters,json=dimensionFilters,proto3" json:"dimension_filters,omitempty"`
	// Describes the sorting of report rows. The order of the condition in the
	// list defines its precedence; the earlier the condition, the higher its
	// precedence. If no sort conditions are specified, the row ordering is
	// undefined.
	SortConditions []*NetworkReportSpec_SortCondition `protobuf:"bytes,5,rep,name=sort_conditions,json=sortConditions,proto3" json:"sort_conditions,omitempty"`
	// Localization settings of the report.
	LocalizationSettings *LocalizationSettings `protobuf:"bytes,6,opt,name=localization_settings,json=localizationSettings,proto3" json:"localization_settings,omitempty"`
	// Maximum number of report data rows to return. If the value is not set, the
	// API returns as many rows as possible, up to 100000. Acceptable values are
	// 1-100000, inclusive. Any other values are treated as 100000.
	MaxReportRows int32 `protobuf:"varint,7,opt,name=max_report_rows,json=maxReportRows,proto3" json:"max_report_rows,omitempty"`
}

func (x *NetworkReportSpec) Reset() {
	*x = NetworkReportSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkReportSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkReportSpec) ProtoMessage() {}

func (x *NetworkReportSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkReportSpec.ProtoReflect.Descriptor instead.
func (*NetworkReportSpec) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{1}
}

func (x *NetworkReportSpec) GetDateRange() *DateRange {
	if x != nil {
		return x.DateRange
	}
	return nil
}

func (x *NetworkReportSpec) GetDimensions() []NetworkReportSpec_Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *NetworkReportSpec) GetMetrics() []NetworkReportSpec_Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *NetworkReportSpec) GetDimensionFilters() []*NetworkReportSpec_DimensionFilter {
	if x != nil {
		return x.DimensionFilters
	}
	return nil
}

func (x *NetworkReportSpec) GetSortConditions() []*NetworkReportSpec_SortCondition {
	if x != nil {
		return x.SortConditions
	}
	return nil
}

func (x *NetworkReportSpec) GetLocalizationSettings() *LocalizationSettings {
	if x != nil {
		return x.LocalizationSettings
	}
	return nil
}

func (x *NetworkReportSpec) GetMaxReportRows() int32 {
	if x != nil {
		return x.MaxReportRows
	}
	return 0
}

// The specification for generating an AdMob Mediation report.
// For example, the specification to get observed ECPM sliced by ad source and
// app for the 'US' and 'CN' countries can look like the following example:
//
//     {
//       "date_range": {
//         "start_date": {"year": 2018, "month": 9, "day": 1},
//         "end_date": {"year": 2018, "month": 9, "day": 30}
//       },
//       "dimensions": ["AD_SOURCE", "APP", "COUNTRY"],
//       "metrics": ["OBSERVED_ECPM"],
//       "dimension_filters": [
//         {
//           "dimension": "COUNTRY",
//           "matches_any": {"values": [{"value": "US", "value": "CN"}]}
//         }
//       ],
//       "sort_conditions": [
//         {"dimension":"APP", order: "ASCENDING"}
//       ],
//       "localization_settings": {
//         "currency_code": "USD",
//         "language_code": "en-US"
//       }
//     }
//
// For a better understanding, you can treat the preceding specification like
// the following pseudo SQL:
//
//     SELECT AD_SOURCE, APP, COUNTRY, OBSERVED_ECPM
//     FROM MEDIATION_REPORT
//     WHERE DATE >= '2018-09-01' AND DATE <= '2018-09-30'
//         AND COUNTRY IN ('US', 'CN')
//     GROUP BY AD_SOURCE, APP, COUNTRY
//     ORDER BY APP ASC;
type MediationReportSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The date range for which the report is generated.
	DateRange *DateRange `protobuf:"bytes,1,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// List of dimensions of the report. The value combination of these dimensions
	// determines the row of the report. If no dimensions are specified, the
	// report returns a single row of requested metrics for the entire account.
	Dimensions []MediationReportSpec_Dimension `protobuf:"varint,2,rep,packed,name=dimensions,proto3,enum=google.ads.admob.v1.MediationReportSpec_Dimension" json:"dimensions,omitempty"`
	// List of metrics of the report. A report must specify at least one metric.
	Metrics []MediationReportSpec_Metric `protobuf:"varint,3,rep,packed,name=metrics,proto3,enum=google.ads.admob.v1.MediationReportSpec_Metric" json:"metrics,omitempty"`
	// Describes which report rows to match based on their dimension values.
	DimensionFilters []*MediationReportSpec_DimensionFilter `protobuf:"bytes,4,rep,name=dimension_filters,json=dimensionFilters,proto3" json:"dimension_filters,omitempty"`
	// Describes the sorting of report rows. The order of the condition in the
	// list defines its precedence; the earlier the condition, the higher its
	// precedence. If no sort conditions are specified, the row ordering is
	// undefined.
	SortConditions []*MediationReportSpec_SortCondition `protobuf:"bytes,5,rep,name=sort_conditions,json=sortConditions,proto3" json:"sort_conditions,omitempty"`
	// Localization settings of the report.
	LocalizationSettings *LocalizationSettings `protobuf:"bytes,6,opt,name=localization_settings,json=localizationSettings,proto3" json:"localization_settings,omitempty"`
	// Maximum number of report data rows to return. If the value is not set, the
	// API returns as many rows as possible, up to 100000. Acceptable values are
	// 1-100000, inclusive. Any other values are treated as 100000.
	MaxReportRows int32 `protobuf:"varint,7,opt,name=max_report_rows,json=maxReportRows,proto3" json:"max_report_rows,omitempty"`
}

func (x *MediationReportSpec) Reset() {
	*x = MediationReportSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MediationReportSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MediationReportSpec) ProtoMessage() {}

func (x *MediationReportSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MediationReportSpec.ProtoReflect.Descriptor instead.
func (*MediationReportSpec) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{2}
}

func (x *MediationReportSpec) GetDateRange() *DateRange {
	if x != nil {
		return x.DateRange
	}
	return nil
}

func (x *MediationReportSpec) GetDimensions() []MediationReportSpec_Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *MediationReportSpec) GetMetrics() []MediationReportSpec_Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *MediationReportSpec) GetDimensionFilters() []*MediationReportSpec_DimensionFilter {
	if x != nil {
		return x.DimensionFilters
	}
	return nil
}

func (x *MediationReportSpec) GetSortConditions() []*MediationReportSpec_SortCondition {
	if x != nil {
		return x.SortConditions
	}
	return nil
}

func (x *MediationReportSpec) GetLocalizationSettings() *LocalizationSettings {
	if x != nil {
		return x.LocalizationSettings
	}
	return nil
}

func (x *MediationReportSpec) GetMaxReportRows() int32 {
	if x != nil {
		return x.MaxReportRows
	}
	return 0
}

// A row of the returning report.
type ReportRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of dimension values in a row, with keys as enum name of the dimensions.
	DimensionValues map[string]*ReportRow_DimensionValue `protobuf:"bytes,1,rep,name=dimension_values,json=dimensionValues,proto3" json:"dimension_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Map of metric values in a row, with keys as enum name of the metrics. If
	// a metric being requested has no value returned, the map will not include
	// it.
	MetricValues map[string]*ReportRow_MetricValue `protobuf:"bytes,2,rep,name=metric_values,json=metricValues,proto3" json:"metric_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ReportRow) Reset() {
	*x = ReportRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRow) ProtoMessage() {}

func (x *ReportRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRow.ProtoReflect.Descriptor instead.
func (*ReportRow) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{3}
}

func (x *ReportRow) GetDimensionValues() map[string]*ReportRow_DimensionValue {
	if x != nil {
		return x.DimensionValues
	}
	return nil
}

func (x *ReportRow) GetMetricValues() map[string]*ReportRow_MetricValue {
	if x != nil {
		return x.MetricValues
	}
	return nil
}

// Warnings associated with generation of the report.
type ReportWarning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the warning.
	Type ReportWarning_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.admob.v1.ReportWarning_Type" json:"type,omitempty"`
	// Describes the details of the warning message, in English.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *ReportWarning) Reset() {
	*x = ReportWarning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportWarning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportWarning) ProtoMessage() {}

func (x *ReportWarning) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportWarning.ProtoReflect.Descriptor instead.
func (*ReportWarning) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{4}
}

func (x *ReportWarning) GetType() ReportWarning_Type {
	if x != nil {
		return x.Type
	}
	return ReportWarning_TYPE_UNSPECIFIED
}

func (x *ReportWarning) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Groups data helps to treat the generated report. Always sent as a first
// message in the stream response.
type ReportHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The date range for which the report is generated. This is identical to the
	// range specified in the report request.
	DateRange *DateRange `protobuf:"bytes,1,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// Localization settings of the report. This is identical to the settings
	// in the report request.
	LocalizationSettings *LocalizationSettings `protobuf:"bytes,2,opt,name=localization_settings,json=localizationSettings,proto3" json:"localization_settings,omitempty"`
	// The report time zone. The value is a time-zone ID as specified by the CLDR
	// project, for example, "America/Los_Angeles".
	ReportingTimeZone string `protobuf:"bytes,3,opt,name=reporting_time_zone,json=reportingTimeZone,proto3" json:"reporting_time_zone,omitempty"`
}

func (x *ReportHeader) Reset() {
	*x = ReportHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportHeader) ProtoMessage() {}

func (x *ReportHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportHeader.ProtoReflect.Descriptor instead.
func (*ReportHeader) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{5}
}

func (x *ReportHeader) GetDateRange() *DateRange {
	if x != nil {
		return x.DateRange
	}
	return nil
}

func (x *ReportHeader) GetLocalizationSettings() *LocalizationSettings {
	if x != nil {
		return x.LocalizationSettings
	}
	return nil
}

func (x *ReportHeader) GetReportingTimeZone() string {
	if x != nil {
		return x.ReportingTimeZone
	}
	return ""
}

// Groups data available after report generation, for example, warnings and row
// counts. Always sent as the last message in the stream response.
type ReportFooter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Warnings associated with generation of the report.
	Warnings []*ReportWarning `protobuf:"bytes,1,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Total number of rows that did match the request.
	MatchingRowCount int64 `protobuf:"varint,2,opt,name=matching_row_count,json=matchingRowCount,proto3" json:"matching_row_count,omitempty"`
}

func (x *ReportFooter) Reset() {
	*x = ReportFooter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportFooter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportFooter) ProtoMessage() {}

func (x *ReportFooter) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportFooter.ProtoReflect.Descriptor instead.
func (*ReportFooter) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ReportFooter) GetWarnings() []*ReportWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *ReportFooter) GetMatchingRowCount() int64 {
	if x != nil {
		return x.MatchingRowCount
	}
	return 0
}

// Specification of a single date range. Both dates are inclusive.
type DateRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start date of the date range, inclusive. Must be less than or equal to the
	// end date.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of the date range, inclusive. Must be greater than or equal to the
	// start date.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *DateRange) Reset() {
	*x = DateRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateRange) ProtoMessage() {}

func (x *DateRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateRange.ProtoReflect.Descriptor instead.
func (*DateRange) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{7}
}

func (x *DateRange) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *DateRange) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

// Localization settings for reports, such as currency and language. It affects
// how metrics are calculated.
type LocalizationSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Currency code of the earning related metrics, which is the 3-letter code
	// defined in ISO 4217. The daily average rate is used for the currency
	// conversion. Defaults to the account currency code if unspecified.
	CurrencyCode string `protobuf:"bytes,1,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Language used for any localized text, such as some dimension value display
	// labels. The language tag defined in the IETF BCP47. Defaults to 'en-US' if
	// unspecified.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *LocalizationSettings) Reset() {
	*x = LocalizationSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalizationSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalizationSettings) ProtoMessage() {}

func (x *LocalizationSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalizationSettings.ProtoReflect.Descriptor instead.
func (*LocalizationSettings) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{8}
}

func (x *LocalizationSettings) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *LocalizationSettings) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// List of string values.
type StringList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The string values.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *StringList) Reset() {
	*x = StringList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StringList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringList) ProtoMessage() {}

func (x *StringList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringList.ProtoReflect.Descriptor instead.
func (*StringList) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{9}
}

func (x *StringList) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Describes which report rows to match based on their dimension values.
type NetworkReportSpec_DimensionFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Applies the filter criterion to the specified dimension.
	Dimension NetworkReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Dimension" json:"dimension,omitempty"`
	// Filter operator to be applied.
	//
	// Types that are assignable to Operator:
	//	*NetworkReportSpec_DimensionFilter_MatchesAny
	Operator isNetworkReportSpec_DimensionFilter_Operator `protobuf_oneof:"operator"`
}

func (x *NetworkReportSpec_DimensionFilter) Reset() {
	*x = NetworkReportSpec_DimensionFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkReportSpec_DimensionFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkReportSpec_DimensionFilter) ProtoMessage() {}

func (x *NetworkReportSpec_DimensionFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkReportSpec_DimensionFilter.ProtoReflect.Descriptor instead.
func (*NetworkReportSpec_DimensionFilter) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *NetworkReportSpec_DimensionFilter) GetDimension() NetworkReportSpec_Dimension {
	if x != nil {
		return x.Dimension
	}
	return NetworkReportSpec_DIMENSION_UNSPECIFIED
}

func (m *NetworkReportSpec_DimensionFilter) GetOperator() isNetworkReportSpec_DimensionFilter_Operator {
	if m != nil {
		return m.Operator
	}
	return nil
}

func (x *NetworkReportSpec_DimensionFilter) GetMatchesAny() *StringList {
	if x, ok := x.GetOperator().(*NetworkReportSpec_DimensionFilter_MatchesAny); ok {
		return x.MatchesAny
	}
	return nil
}

type isNetworkReportSpec_DimensionFilter_Operator interface {
	isNetworkReportSpec_DimensionFilter_Operator()
}

type NetworkReportSpec_DimensionFilter_MatchesAny struct {
	// Matches a row if its value for the specified dimension is in one of the
	// values specified in this condition.
	MatchesAny *StringList `protobuf:"bytes,2,opt,name=matches_any,json=matchesAny,proto3,oneof"`
}

func (*NetworkReportSpec_DimensionFilter_MatchesAny) isNetworkReportSpec_DimensionFilter_Operator() {}

// Sorting direction to be applied on a dimension or a metric.
type NetworkReportSpec_SortCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies which values to sort on.
	//
	// Types that are assignable to SortOn:
	//	*NetworkReportSpec_SortCondition_Dimension
	//	*NetworkReportSpec_SortCondition_Metric
	SortOn isNetworkReportSpec_SortCondition_SortOn `protobuf_oneof:"sort_on"`
	// Sorting order of the dimension or metric.
	Order SortOrder `protobuf:"varint,3,opt,name=order,proto3,enum=google.ads.admob.v1.SortOrder" json:"order,omitempty"`
}

func (x *NetworkReportSpec_SortCondition) Reset() {
	*x = NetworkReportSpec_SortCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkReportSpec_SortCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkReportSpec_SortCondition) ProtoMessage() {}

func (x *NetworkReportSpec_SortCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkReportSpec_SortCondition.ProtoReflect.Descriptor instead.
func (*NetworkReportSpec_SortCondition) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{1, 1}
}

func (m *NetworkReportSpec_SortCondition) GetSortOn() isNetworkReportSpec_SortCondition_SortOn {
	if m != nil {
		return m.SortOn
	}
	return nil
}

func (x *NetworkReportSpec_SortCondition) GetDimension() NetworkReportSpec_Dimension {
	if x, ok := x.GetSortOn().(*NetworkReportSpec_SortCondition_Dimension); ok {
		return x.Dimension
	}
	return NetworkReportSpec_DIMENSION_UNSPECIFIED
}

func (x *NetworkReportSpec_SortCondition) GetMetric() NetworkReportSpec_Metric {
	if x, ok := x.GetSortOn().(*NetworkReportSpec_SortCondition_Metric); ok {
		return x.Metric
	}
	return NetworkReportSpec_METRIC_UNSPECIFIED
}

func (x *NetworkReportSpec_SortCondition) GetOrder() SortOrder {
	if x != nil {
		return x.Order
	}
	return SortOrder_SORT_ORDER_UNSPECIFIED
}

type isNetworkReportSpec_SortCondition_SortOn interface {
	isNetworkReportSpec_SortCondition_SortOn()
}

type NetworkReportSpec_SortCondition_Dimension struct {
	// Sort by the specified dimension.
	Dimension NetworkReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Dimension,oneof"`
}

type NetworkReportSpec_SortCondition_Metric struct {
	// Sort by the specified metric.
	Metric NetworkReportSpec_Metric `protobuf:"varint,2,opt,name=metric,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Metric,oneof"`
}

func (*NetworkReportSpec_SortCondition_Dimension) isNetworkReportSpec_SortCondition_SortOn() {}

func (*NetworkReportSpec_SortCondition_Metric) isNetworkReportSpec_SortCondition_SortOn() {}

// Describes which report rows to match based on their dimension values.
type MediationReportSpec_DimensionFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Applies the filter criterion to the specified dimension.
	Dimension MediationReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.MediationReportSpec_Dimension" json:"dimension,omitempty"`
	// Filter operator to be applied.
	//
	// Types that are assignable to Operator:
	//	*MediationReportSpec_DimensionFilter_MatchesAny
	Operator isMediationReportSpec_DimensionFilter_Operator `protobuf_oneof:"operator"`
}

func (x *MediationReportSpec_DimensionFilter) Reset() {
	*x = MediationReportSpec_DimensionFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MediationReportSpec_DimensionFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MediationReportSpec_DimensionFilter) ProtoMessage() {}

func (x *MediationReportSpec_DimensionFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MediationReportSpec_DimensionFilter.ProtoReflect.Descriptor instead.
func (*MediationReportSpec_DimensionFilter) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *MediationReportSpec_DimensionFilter) GetDimension() MediationReportSpec_Dimension {
	if x != nil {
		return x.Dimension
	}
	return MediationReportSpec_DIMENSION_UNSPECIFIED
}

func (m *MediationReportSpec_DimensionFilter) GetOperator() isMediationReportSpec_DimensionFilter_Operator {
	if m != nil {
		return m.Operator
	}
	return nil
}

func (x *MediationReportSpec_DimensionFilter) GetMatchesAny() *StringList {
	if x, ok := x.GetOperator().(*MediationReportSpec_DimensionFilter_MatchesAny); ok {
		return x.MatchesAny
	}
	return nil
}

type isMediationReportSpec_DimensionFilter_Operator interface {
	isMediationReportSpec_DimensionFilter_Operator()
}

type MediationReportSpec_DimensionFilter_MatchesAny struct {
	// Matches a row if its value for the specified dimension is in one of the
	// values specified in this condition.
	MatchesAny *StringList `protobuf:"bytes,2,opt,name=matches_any,json=matchesAny,proto3,oneof"`
}

func (*MediationReportSpec_DimensionFilter_MatchesAny) isMediationReportSpec_DimensionFilter_Operator() {
}

// Sorting direction to be applied on a dimension or a metric.
type MediationReportSpec_SortCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies which values to sort on.
	//
	// Types that are assignable to SortOn:
	//	*MediationReportSpec_SortCondition_Dimension
	//	*MediationReportSpec_SortCondition_Metric
	SortOn isMediationReportSpec_SortCondition_SortOn `protobuf_oneof:"sort_on"`
	// Sorting order of the dimension or metric.
	Order SortOrder `protobuf:"varint,3,opt,name=order,proto3,enum=google.ads.admob.v1.SortOrder" json:"order,omitempty"`
}

func (x *MediationReportSpec_SortCondition) Reset() {
	*x = MediationReportSpec_SortCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MediationReportSpec_SortCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MediationReportSpec_SortCondition) ProtoMessage() {}

func (x *MediationReportSpec_SortCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MediationReportSpec_SortCondition.ProtoReflect.Descriptor instead.
func (*MediationReportSpec_SortCondition) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{2, 1}
}

func (m *MediationReportSpec_SortCondition) GetSortOn() isMediationReportSpec_SortCondition_SortOn {
	if m != nil {
		return m.SortOn
	}
	return nil
}

func (x *MediationReportSpec_SortCondition) GetDimension() MediationReportSpec_Dimension {
	if x, ok := x.GetSortOn().(*MediationReportSpec_SortCondition_Dimension); ok {
		return x.Dimension
	}
	return MediationReportSpec_DIMENSION_UNSPECIFIED
}

func (x *MediationReportSpec_SortCondition) GetMetric() MediationReportSpec_Metric {
	if x, ok := x.GetSortOn().(*MediationReportSpec_SortCondition_Metric); ok {
		return x.Metric
	}
	return MediationReportSpec_METRIC_UNSPECIFIED
}

func (x *MediationReportSpec_SortCondition) GetOrder() SortOrder {
	if x != nil {
		return x.Order
	}
	return SortOrder_SORT_ORDER_UNSPECIFIED
}

type isMediationReportSpec_SortCondition_SortOn interface {
	isMediationReportSpec_SortCondition_SortOn()
}

type MediationReportSpec_SortCondition_Dimension struct {
	// Sort by the specified dimension.
	Dimension MediationReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.MediationReportSpec_Dimension,oneof"`
}

type MediationReportSpec_SortCondition_Metric struct {
	// Sort by the specified metric.
	Metric MediationReportSpec_Metric `protobuf:"varint,2,opt,name=metric,proto3,enum=google.ads.admob.v1.MediationReportSpec_Metric,oneof"`
}

func (*MediationReportSpec_SortCondition_Dimension) isMediationReportSpec_SortCondition_SortOn() {}

func (*MediationReportSpec_SortCondition_Metric) isMediationReportSpec_SortCondition_SortOn() {}

// Representation of a dimension value.
type ReportRow_DimensionValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dimension value in the format specified in the report's spec Dimension
	// enum.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The localized string representation of the value. If unspecified, the
	// display label should be derived from the value.
	DisplayLabel string `protobuf:"bytes,2,opt,name=display_label,json=displayLabel,proto3" json:"display_label,omitempty"`
}

func (x *ReportRow_DimensionValue) Reset() {
	*x = ReportRow_DimensionValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRow_DimensionValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRow_DimensionValue) ProtoMessage() {}

func (x *ReportRow_DimensionValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRow_DimensionValue.ProtoReflect.Descriptor instead.
func (*ReportRow_DimensionValue) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ReportRow_DimensionValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *ReportRow_DimensionValue) GetDisplayLabel() string {
	if x != nil {
		return x.DisplayLabel
	}
	return ""
}

// Representation of a metric value.
type ReportRow_MetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metric value in the format specified in the report's spec Metric enum
	// name.
	//
	// Types that are assignable to Value:
	//	*ReportRow_MetricValue_IntegerValue
	//	*ReportRow_MetricValue_DoubleValue
	//	*ReportRow_MetricValue_MicrosValue
	Value isReportRow_MetricValue_Value `protobuf_oneof:"value"`
}

func (x *ReportRow_MetricValue) Reset() {
	*x = ReportRow_MetricValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRow_MetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRow_MetricValue) ProtoMessage() {}

func (x *ReportRow_MetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_admob_v1_admob_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRow_MetricValue.ProtoReflect.Descriptor instead.
func (*ReportRow_MetricValue) Descriptor() ([]byte, []int) {
	return file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP(), []int{3, 1}
}

func (m *ReportRow_MetricValue) GetValue() isReportRow_MetricValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *ReportRow_MetricValue) GetIntegerValue() int64 {
	if x, ok := x.GetValue().(*ReportRow_MetricValue_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (x *ReportRow_MetricValue) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*ReportRow_MetricValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *ReportRow_MetricValue) GetMicrosValue() int64 {
	if x, ok := x.GetValue().(*ReportRow_MetricValue_MicrosValue); ok {
		return x.MicrosValue
	}
	return 0
}

type isReportRow_MetricValue_Value interface {
	isReportRow_MetricValue_Value()
}

type ReportRow_MetricValue_IntegerValue struct {
	// Metric integer value.
	IntegerValue int64 `protobuf:"varint,1,opt,name=integer_value,json=integerValue,proto3,oneof"`
}

type ReportRow_MetricValue_DoubleValue struct {
	// Double precision (approximate) decimal values. Rates are from 0 to 1.
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type ReportRow_MetricValue_MicrosValue struct {
	// Amount in micros. One million is equivalent to one unit. Currency value
	// is in the unit (USD, EUR or other) specified by the request.
	// For example, $6.50 whould be represented as 6500000 micros.
	MicrosValue int64 `protobuf:"varint,3,opt,name=micros_value,json=microsValue,proto3,oneof"`
}

func (*ReportRow_MetricValue_IntegerValue) isReportRow_MetricValue_Value() {}

func (*ReportRow_MetricValue_DoubleValue) isReportRow_MetricValue_Value() {}

func (*ReportRow_MetricValue_MicrosValue) isReportRow_MetricValue_Value() {}

var File_google_ads_admob_v1_admob_resources_proto protoreflect.FileDescriptor

var file_google_ads_admob_v1_admob_resources_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x61, 0x64, 0x6d,
	0x6f, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31,
	0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9e, 0x01, 0x0a, 0x10, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65,
	0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xa6, 0x0a, 0x0a, 0x11, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x3d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x50,
	0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x47, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x63, 0x0a, 0x11, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x10, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x5d,
	0x0a, 0x0f, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x53, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5e, 0x0a,
	0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x6f, 0x77, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x6f, 0x77, 0x73, 0x1a, 0xb1, 0x01, 0x0a, 0x0f, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4e, 0x0a, 0x09, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0b, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x5f, 0x61, 0x6e, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x41, 0x6e, 0x79, 0x42, 0x0a, 0x0a,
	0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x1a, 0xeb, 0x01, 0x0a, 0x0d, 0x53, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x09, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a,
	0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x00, 0x52, 0x06,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x34, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x72, 0x74,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x09, 0x0a, 0x07,
	0x73, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x09, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f,
	0x4e, 0x54, 0x48, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x57, 0x45, 0x45, 0x4b, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x41, 0x44, 0x5f, 0x55, 0x4e, 0x49, 0x54, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03,
	0x41, 0x50, 0x50, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x52, 0x59,
	0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x10, 0x08, 0x12, 0x0c,
	0x0a, 0x08, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x10, 0x09, 0x22, 0xc3, 0x01, 0x0a,
	0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x54, 0x52, 0x49,
	0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x41, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x53, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x53, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12,
	0x45, 0x53, 0x54, 0x49, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x45, 0x41, 0x52, 0x4e, 0x49, 0x4e,
	0x47, 0x53, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x53, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x54, 0x52, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4d, 0x50,
	0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x50, 0x4d, 0x10, 0x06, 0x12, 0x14, 0x0a,
	0x10, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54,
	0x53, 0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x52, 0x41, 0x54,
	0x45, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x48, 0x4f, 0x57, 0x5f, 0x52, 0x41, 0x54, 0x45,
	0x10, 0x09, 0x22, 0xe2, 0x0a, 0x0a, 0x13, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3d, 0x0a, 0x0a, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x52, 0x0a, 0x0a, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x49, 0x0a,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x65, 0x0a, 0x11, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x10, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x5f, 0x0a, 0x0f, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x73, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x5e, 0x0a, 0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x14, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72,
	0x6f, 0x77, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x73, 0x1a, 0xb3, 0x01, 0x0a, 0x0f, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x50, 0x0a, 0x09,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42,
	0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x61, 0x6e, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x41,
	0x6e, 0x79, 0x42, 0x0a, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x1a, 0xef,
	0x01, 0x0a, 0x0d, 0x53, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x52, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12,
	0x34, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x05,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x6e,
	0x22, 0xbe, 0x01, 0x0a, 0x09, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19,
	0x0a, 0x15, 0x44, 0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54,
	0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x02, 0x12, 0x08,
	0x0a, 0x04, 0x57, 0x45, 0x45, 0x4b, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x44, 0x5f, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x5f, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x05, 0x12,
	0x0b, 0x0a, 0x07, 0x41, 0x44, 0x5f, 0x55, 0x4e, 0x49, 0x54, 0x10, 0x06, 0x12, 0x07, 0x0a, 0x03,
	0x41, 0x50, 0x50, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x0b, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x52, 0x59, 0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x4f, 0x52, 0x4d, 0x41,
	0x54, 0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x10,
	0x0a, 0x22, 0xb3, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x16, 0x0a, 0x12,
	0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45,
	0x53, 0x54, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x53, 0x10,
	0x02, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x53, 0x54, 0x49, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x45,
	0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x53, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x50,
	0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4d,
	0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x54, 0x52, 0x10, 0x05, 0x12, 0x14,
	0x0a, 0x10, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x53, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x52, 0x41,
	0x54, 0x45, 0x10, 0x07, 0x12, 0x11, 0x0a, 0x0d, 0x4f, 0x42, 0x53, 0x45, 0x52, 0x56, 0x45, 0x44,
	0x5f, 0x45, 0x43, 0x50, 0x4d, 0x10, 0x08, 0x22, 0xf9, 0x04, 0x0a, 0x09, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x6f, 0x77, 0x12, 0x5e, 0x0a, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x2e,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x4b, 0x0a, 0x0e,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x1a, 0x87, 0x01, 0x0a, 0x0b, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x71, 0x0a, 0x14, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x43, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6b, 0x0a, 0x11, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x40, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xfd, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x57, 0x61,
	0x72, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x27, 0x0a, 0x23, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x42, 0x45, 0x46, 0x4f,
	0x52, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5a,
	0x4f, 0x4e, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x45, 0x44, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x03, 0x12, 0x28, 0x0a, 0x24, 0x52, 0x45, 0x50,
	0x4f, 0x52, 0x54, 0x5f, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43,
	0x59, 0x10, 0x04, 0x22, 0xdd, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x5e, 0x0a, 0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x14, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x5a,
	0x6f, 0x6e, 0x65, 0x22, 0x7c, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x12, 0x3e, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f,
	0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x10, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0x6b, 0x0a, 0x09, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x30,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65,
	0x12, 0x2c, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x22, 0x60,
	0x0a, 0x14, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x22, 0x24, 0x0a, 0x0a, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x2a, 0x46, 0x0a, 0x09, 0x53, 0x6f, 0x72, 0x74, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x4f, 0x52, 0x44, 0x45,
	0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x41, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x44, 0x45, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x42, 0x67,
	0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x41, 0x64, 0x4d, 0x6f, 0x62,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x38, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x2f, 0x76,
	0x31, 0x3b, 0x61, 0x64, 0x6d, 0x6f, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_admob_v1_admob_resources_proto_rawDescOnce sync.Once
	file_google_ads_admob_v1_admob_resources_proto_rawDescData = file_google_ads_admob_v1_admob_resources_proto_rawDesc
)

func file_google_ads_admob_v1_admob_resources_proto_rawDescGZIP() []byte {
	file_google_ads_admob_v1_admob_resources_proto_rawDescOnce.Do(func() {
		file_google_ads_admob_v1_admob_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_admob_v1_admob_resources_proto_rawDescData)
	})
	return file_google_ads_admob_v1_admob_resources_proto_rawDescData
}

var file_google_ads_admob_v1_admob_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_ads_admob_v1_admob_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_ads_admob_v1_admob_resources_proto_goTypes = []interface{}{
	(SortOrder)(0),                              // 0: google.ads.admob.v1.SortOrder
	(NetworkReportSpec_Dimension)(0),            // 1: google.ads.admob.v1.NetworkReportSpec.Dimension
	(NetworkReportSpec_Metric)(0),               // 2: google.ads.admob.v1.NetworkReportSpec.Metric
	(MediationReportSpec_Dimension)(0),          // 3: google.ads.admob.v1.MediationReportSpec.Dimension
	(MediationReportSpec_Metric)(0),             // 4: google.ads.admob.v1.MediationReportSpec.Metric
	(ReportWarning_Type)(0),                     // 5: google.ads.admob.v1.ReportWarning.Type
	(*PublisherAccount)(nil),                    // 6: google.ads.admob.v1.PublisherAccount
	(*NetworkReportSpec)(nil),                   // 7: google.ads.admob.v1.NetworkReportSpec
	(*MediationReportSpec)(nil),                 // 8: google.ads.admob.v1.MediationReportSpec
	(*ReportRow)(nil),                           // 9: google.ads.admob.v1.ReportRow
	(*ReportWarning)(nil),                       // 10: google.ads.admob.v1.ReportWarning
	(*ReportHeader)(nil),                        // 11: google.ads.admob.v1.ReportHeader
	(*ReportFooter)(nil),                        // 12: google.ads.admob.v1.ReportFooter
	(*DateRange)(nil),                           // 13: google.ads.admob.v1.DateRange
	(*LocalizationSettings)(nil),                // 14: google.ads.admob.v1.LocalizationSettings
	(*StringList)(nil),                          // 15: google.ads.admob.v1.StringList
	(*NetworkReportSpec_DimensionFilter)(nil),   // 16: google.ads.admob.v1.NetworkReportSpec.DimensionFilter
	(*NetworkReportSpec_SortCondition)(nil),     // 17: google.ads.admob.v1.NetworkReportSpec.SortCondition
	(*MediationReportSpec_DimensionFilter)(nil), // 18: google.ads.admob.v1.MediationReportSpec.DimensionFilter
	(*MediationReportSpec_SortCondition)(nil),   // 19: google.ads.admob.v1.MediationReportSpec.SortCondition
	(*ReportRow_DimensionValue)(nil),            // 20: google.ads.admob.v1.ReportRow.DimensionValue
	(*ReportRow_MetricValue)(nil),               // 21: google.ads.admob.v1.ReportRow.MetricValue
	nil,                                         // 22: google.ads.admob.v1.ReportRow.DimensionValuesEntry
	nil,                                         // 23: google.ads.admob.v1.ReportRow.MetricValuesEntry
	(*date.Date)(nil),                           // 24: google.type.Date
}
var file_google_ads_admob_v1_admob_resources_proto_depIdxs = []int32{
	13, // 0: google.ads.admob.v1.NetworkReportSpec.date_range:type_name -> google.ads.admob.v1.DateRange
	1,  // 1: google.ads.admob.v1.NetworkReportSpec.dimensions:type_name -> google.ads.admob.v1.NetworkReportSpec.Dimension
	2,  // 2: google.ads.admob.v1.NetworkReportSpec.metrics:type_name -> google.ads.admob.v1.NetworkReportSpec.Metric
	16, // 3: google.ads.admob.v1.NetworkReportSpec.dimension_filters:type_name -> google.ads.admob.v1.NetworkReportSpec.DimensionFilter
	17, // 4: google.ads.admob.v1.NetworkReportSpec.sort_conditions:type_name -> google.ads.admob.v1.NetworkReportSpec.SortCondition
	14, // 5: google.ads.admob.v1.NetworkReportSpec.localization_settings:type_name -> google.ads.admob.v1.LocalizationSettings
	13, // 6: google.ads.admob.v1.MediationReportSpec.date_range:type_name -> google.ads.admob.v1.DateRange
	3,  // 7: google.ads.admob.v1.MediationReportSpec.dimensions:type_name -> google.ads.admob.v1.MediationReportSpec.Dimension
	4,  // 8: google.ads.admob.v1.MediationReportSpec.metrics:type_name -> google.ads.admob.v1.MediationReportSpec.Metric
	18, // 9: google.ads.admob.v1.MediationReportSpec.dimension_filters:type_name -> google.ads.admob.v1.MediationReportSpec.DimensionFilter
	19, // 10: google.ads.admob.v1.MediationReportSpec.sort_conditions:type_name -> google.ads.admob.v1.MediationReportSpec.SortCondition
	14, // 11: google.ads.admob.v1.MediationReportSpec.localization_settings:type_name -> google.ads.admob.v1.LocalizationSettings
	22, // 12: google.ads.admob.v1.ReportRow.dimension_values:type_name -> google.ads.admob.v1.ReportRow.DimensionValuesEntry
	23, // 13: google.ads.admob.v1.ReportRow.metric_values:type_name -> google.ads.admob.v1.ReportRow.MetricValuesEntry
	5,  // 14: google.ads.admob.v1.ReportWarning.type:type_name -> google.ads.admob.v1.ReportWarning.Type
	13, // 15: google.ads.admob.v1.ReportHeader.date_range:type_name -> google.ads.admob.v1.DateRange
	14, // 16: google.ads.admob.v1.ReportHeader.localization_settings:type_name -> google.ads.admob.v1.LocalizationSettings
	10, // 17: google.ads.admob.v1.ReportFooter.warnings:type_name -> google.ads.admob.v1.ReportWarning
	24, // 18: google.ads.admob.v1.DateRange.start_date:type_name -> google.type.Date
	24, // 19: google.ads.admob.v1.DateRange.end_date:type_name -> google.type.Date
	1,  // 20: google.ads.admob.v1.NetworkReportSpec.DimensionFilter.dimension:type_name -> google.ads.admob.v1.NetworkReportSpec.Dimension
	15, // 21: google.ads.admob.v1.NetworkReportSpec.DimensionFilter.matches_any:type_name -> google.ads.admob.v1.StringList
	1,  // 22: google.ads.admob.v1.NetworkReportSpec.SortCondition.dimension:type_name -> google.ads.admob.v1.NetworkReportSpec.Dimension
	2,  // 23: google.ads.admob.v1.NetworkReportSpec.SortCondition.metric:type_name -> google.ads.admob.v1.NetworkReportSpec.Metric
	0,  // 24: google.ads.admob.v1.NetworkReportSpec.SortCondition.order:type_name -> google.ads.admob.v1.SortOrder
	3,  // 25: google.ads.admob.v1.MediationReportSpec.DimensionFilter.dimension:type_name -> google.ads.admob.v1.MediationReportSpec.Dimension
	15, // 26: google.ads.admob.v1.MediationReportSpec.DimensionFilter.matches_any:type_name -> google.ads.admob.v1.StringList
	3,  // 27: google.ads.admob.v1.MediationReportSpec.SortCondition.dimension:type_name -> google.ads.admob.v1.MediationReportSpec.Dimension
	4,  // 28: google.ads.admob.v1.MediationReportSpec.SortCondition.metric:type_name -> google.ads.admob.v1.MediationReportSpec.Metric
	0,  // 29: google.ads.admob.v1.MediationReportSpec.SortCondition.order:type_name -> google.ads.admob.v1.SortOrder
	20, // 30: google.ads.admob.v1.ReportRow.DimensionValuesEntry.value:type_name -> google.ads.admob.v1.ReportRow.DimensionValue
	21, // 31: google.ads.admob.v1.ReportRow.MetricValuesEntry.value:type_name -> google.ads.admob.v1.ReportRow.MetricValue
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_ads_admob_v1_admob_resources_proto_init() }
func file_google_ads_admob_v1_admob_resources_proto_init() {
	if File_google_ads_admob_v1_admob_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkReportSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MediationReportSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportWarning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportFooter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalizationSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StringList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkReportSpec_DimensionFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkReportSpec_SortCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MediationReportSpec_DimensionFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MediationReportSpec_SortCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRow_DimensionValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_admob_v1_admob_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRow_MetricValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_admob_v1_admob_resources_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*NetworkReportSpec_DimensionFilter_MatchesAny)(nil),
	}
	file_google_ads_admob_v1_admob_resources_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*NetworkReportSpec_SortCondition_Dimension)(nil),
		(*NetworkReportSpec_SortCondition_Metric)(nil),
	}
	file_google_ads_admob_v1_admob_resources_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*MediationReportSpec_DimensionFilter_MatchesAny)(nil),
	}
	file_google_ads_admob_v1_admob_resources_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*MediationReportSpec_SortCondition_Dimension)(nil),
		(*MediationReportSpec_SortCondition_Metric)(nil),
	}
	file_google_ads_admob_v1_admob_resources_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*ReportRow_MetricValue_IntegerValue)(nil),
		(*ReportRow_MetricValue_DoubleValue)(nil),
		(*ReportRow_MetricValue_MicrosValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_admob_v1_admob_resources_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_admob_v1_admob_resources_proto_goTypes,
		DependencyIndexes: file_google_ads_admob_v1_admob_resources_proto_depIdxs,
		EnumInfos:         file_google_ads_admob_v1_admob_resources_proto_enumTypes,
		MessageInfos:      file_google_ads_admob_v1_admob_resources_proto_msgTypes,
	}.Build()
	File_google_ads_admob_v1_admob_resources_proto = out.File
	file_google_ads_admob_v1_admob_resources_proto_rawDesc = nil
	file_google_ads_admob_v1_admob_resources_proto_goTypes = nil
	file_google_ads_admob_v1_admob_resources_proto_depIdxs = nil
}
