/*
 * Decompiled with CFR 0.152.
 */
package sbt.inc;

import java.io.File;
import sbt.Logger;
import sbt.inc.Analysis;
import sbt.inc.ClassfileManager;
import sbt.inc.ClassfileManager$;
import sbt.inc.IncOptions;
import sbt.inc.Incremental;
import sbt.inc.IncrementalAntStyle;
import sbt.inc.IncrementalCommon;
import sbt.inc.IncrementalDefaultImpl;
import sbt.inc.IncrementalNameHashing;
import sbt.inc.InitialChanges;
import sbt.inc.ReadStamps;
import sbt.inc.Stamp;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Equiv;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import xsbti.compile.DependencyChanges;

public final class Incremental$ {
    public static final Incremental$ MODULE$;
    private final String incDebugProp;
    private final String apiDebugProp;

    static {
        new Incremental$();
    }

    public Tuple2<Object, Analysis> compile(Set<File> sources, Function1<String, Option<File>> entry2, Analysis previous, ReadStamps current, Function1<File, Option<Analysis>> forEntry, Function2<Set<File>, DependencyChanges, Analysis> doCompile2, Logger log2, IncOptions options, Equiv<Stamp> equivS) {
        IncrementalCommon incremental = options.nameHashing() ? new IncrementalNameHashing(new Incremental.PrefixingLogger("[naha] ", log2), options) : (options.antStyle() ? new IncrementalAntStyle(log2, options) : new IncrementalDefaultImpl(log2, options));
        InitialChanges initialChanges = incremental.changedInitial(entry2, sources, previous, current, forEntry, equivS);
        DependencyChanges binaryChanges = new DependencyChanges(initialChanges){
            private final File[] modifiedBinaries;
            private final String[] modifiedClasses;

            public File[] modifiedBinaries() {
                return this.modifiedBinaries;
            }

            public String[] modifiedClasses() {
                return this.modifiedClasses;
            }

            public boolean isEmpty() {
                return Predef$.MODULE$.refArrayOps((Object[])this.modifiedBinaries()).isEmpty() && Predef$.MODULE$.refArrayOps((Object[])this.modifiedClasses()).isEmpty();
            }
            {
                this.modifiedBinaries = (File[])initialChanges$1.binaryDeps().toArray(ClassTag$.MODULE$.apply(File.class));
                this.modifiedClasses = (String[])initialChanges$1.external().allModified().toArray(ClassTag$.MODULE$.apply(String.class));
            }
        };
        Set<File> initialInv = incremental.invalidateInitial(previous.relations(), initialChanges);
        log2.debug((Function0)new Serializable(initialInv){
            public static final long serialVersionUID = 0L;
            private final Set initialInv$1;

            public final String apply() {
                return new StringBuilder().append((Object)"All initially invalidated sources: ").append((Object)this.initialInv$1).append((Object)"\n").toString();
            }
            {
                this.initialInv$1 = initialInv$1;
            }
        });
        Analysis analysis = (Analysis)this.manageClassfiles(options, (Function1)new Serializable(sources, previous, doCompile2, incremental, binaryChanges, initialInv){
            public static final long serialVersionUID = 0L;
            private final Set sources$1;
            private final Analysis previous$1;
            private final Function2 doCompile$1;
            private final IncrementalCommon incremental$1;
            private final DependencyChanges binaryChanges$1;
            private final Set initialInv$1;

            public final Analysis apply(ClassfileManager classfileManager) {
                return this.incremental$1.cycle((Set<File>)this.initialInv$1, (Set<File>)this.sources$1, this.binaryChanges$1, this.previous$1, (Function2<Set<File>, DependencyChanges, Analysis>)this.doCompile$1, classfileManager, 1);
            }
            {
                this.sources$1 = sources$1;
                this.previous$1 = previous$1;
                this.doCompile$1 = doCompile$1;
                this.incremental$1 = incremental$1;
                this.binaryChanges$1 = binaryChanges$1;
                this.initialInv$1 = initialInv$1;
            }
        });
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)initialInv.nonEmpty()), (Object)analysis);
    }

    public String incDebugProp() {
        return this.incDebugProp;
    }

    public String apiDebugProp() {
        return this.apiDebugProp;
    }

    public boolean apiDebug(IncOptions options) {
        return options.apiDebug() || Boolean.getBoolean(this.apiDebugProp());
    }

    public Analysis prune(Set<File> invalidatedSrcs, Analysis previous) {
        return this.prune(invalidatedSrcs, previous, (ClassfileManager)ClassfileManager$.MODULE$.deleteImmediately().apply());
    }

    public Analysis prune(Set<File> invalidatedSrcs, Analysis previous, ClassfileManager classfileManager) {
        classfileManager.delete((Iterable<File>)((Iterable)invalidatedSrcs.flatMap((Function1)new Serializable(previous){
            public static final long serialVersionUID = 0L;
            private final Analysis previous$2;

            public final Set<File> apply(File src) {
                return this.previous$2.relations().products(src);
            }
            {
                this.previous$2 = previous$2;
            }
        }, Set$.MODULE$.canBuildFrom())));
        return previous.$minus$minus((Iterable<File>)invalidatedSrcs);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T manageClassfiles(IncOptions options, Function1<ClassfileManager, T> run) {
        Object result;
        ClassfileManager classfileManager = (ClassfileManager)options.newClassfileManager().apply();
        try {
            result = run.apply((Object)classfileManager);
            classfileManager.complete(true);
        }
        catch (Exception exception) {
            void var3_3;
            var3_3.complete(false);
            throw exception;
        }
        return (T)result;
    }

    private Incremental$() {
        MODULE$ = this;
        this.incDebugProp = "xsbt.inc.debug";
        this.apiDebugProp = "xsbt.api.debug";
    }
}

