/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Whitespace;

public class XSLPackage
extends XSLModuleRoot {
    private String nameAtt = null;
    private PackageVersion packageVersion = null;

    public String getName() {
        if (this.nameAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.nameAtt = "default";
            }
        }
        return this.nameAtt;
    }

    public DecimalValue getVersion() {
        if (this.version == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.version = DecimalValue.THREE;
            }
        }
        return this.version;
    }

    public PackageVersion getPackageVersion() {
        if (this.packageVersion == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.packageVersion = PackageVersion.ONE_ZERO;
            }
        }
        return this.packageVersion;
    }

    protected void prepareAttributes() throws XPathException {
        String inputTypeAnnotationsAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String val;
            String f = atts.getQName(a);
            if (f.equals("name") && this.getLocalPart().equals("package")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("id")) continue;
            if (f.equals("version")) {
                String in = Whitespace.trim(atts.getValue(a));
                this.version = new DecimalValue(new BigDecimal(in));
                continue;
            }
            if (f.equals("package-version") && this.getLocalPart().equals("package")) {
                String pversion = Whitespace.trim(atts.getValue(a));
                try {
                    this.packageVersion = new PackageVersion(pversion);
                    continue;
                }
                catch (XPathException ex) {
                    throw new XPathException("Error in xsl:package - The package-version attribute has incorrect character(s): " + pversion);
                }
            }
            if (f.equals("default-mode")) {
                if (!this.isXslt30Processor()) {
                    this.compileError("The @default-mode attribute requires XSLT 3.0");
                }
                if ("#unnamed".equals(val = Whitespace.trim(atts.getValue(a)))) continue;
                try {
                    this.defaultMode = this.makeQName(atts.getValue(a));
                    continue;
                }
                catch (NamespaceException err) {
                    throw new XPathException(err.getMessage(), "XTST0030");
                }
            }
            if (f.equals("default-validation")) {
                val = Whitespace.trim(atts.getValue(a));
                this.defaultValidation = Validation.getCode(val);
                if (this.defaultValidation == -1) {
                    this.compileError("Invalid value for default-validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                    continue;
                }
                if (this.isSchemaAware() || this.defaultValidation == 4) continue;
                this.defaultValidation = 4;
                this.compileError("default-validation='" + val + "' requires a schema-aware processor", "XTSE1660");
                continue;
            }
            if (f.equals("input-type-annotations")) {
                inputTypeAnnotationsAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.nameAtt == null) {
            this.nameAtt = "default";
            if (this.getLocalPart().equals("package")) {
                this.reportAbsence("name");
            }
        }
        if (this.packageVersion == null) {
            this.packageVersion = PackageVersion.ONE_ZERO;
        }
        if (this.version == null) {
            this.version = DecimalValue.THREE;
            this.reportAbsence("version");
        }
        if (!(inputTypeAnnotationsAtt == null || inputTypeAnnotationsAtt.equals("strip") || inputTypeAnnotationsAtt.equals("preserve") || inputTypeAnnotationsAtt.equals("unspecified"))) {
            this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
        }
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return false;
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            int fp = child.getFingerprint();
            if (child.getNodeKind() == 3 || child instanceof StyleElement && ((StyleElement)child).isDeclaration() || child instanceof DataElement || this.getLocalPart().equals("package") && (fp == 204 || fp == 148) || !"http://www.w3.org/1999/XSL/Transform".equals(child.getURI()) && !"".equals(child.getURI()) || child instanceof AbsentExtensionElement && ((StyleElement)child).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(child.getURI())) {
                ((StyleElement)child).compileError("Element " + child.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            ((StyleElement)child).compileError("Element " + child.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }
}

