// NOTE:
//    This file is generated automatically.

use crate::Lang;
use crate::trigrams::Trigram;

pub type LangProfile = &'static [Trigram];
pub type LangProfileList = &'static [(Lang, LangProfile)];

/// Languages for script Latin
pub static LATIN_LANGS: LangProfileList = &[
    (
        Lang::Spa,
        &[
            Trigram(' ', 'd', 'e'),
            Trigram('o', 's', ' '),
            Trigram('d', 'e', ' '),
            Trigram(' ', 'l', 'a'),
            Trigram('l', 'a', ' '),
            Trigram(' ', 'y', ' '),
            Trigram(' ', 'a', ' '),
            Trigram('e', 's', ' '),
            Trigram('ó', 'n', ' '),
            Trigram('i', 'ó', 'n'),
            Trigram('r', 'e', 'c'),
            Trigram('e', 'r', 'e'),
            Trigram('d', 'e', 'r'),
            Trigram(' ', 'c', 'o'),
            Trigram('e', ' ', 'l'),
            Trigram('e', 'l', ' '),
            Trigram('e', 'n', ' '),
            Trigram('i', 'e', 'n'),
            Trigram('c', 'h', 'o'),
            Trigram('e', 'n', 't'),
            Trigram('e', 'c', 'h'),
            Trigram('c', 'i', 'ó'),
            Trigram('a', 'c', 'i'),
            Trigram('o', ' ', 'a'),
            Trigram('a', ' ', 'p'),
            Trigram(' ', 'e', 'l'),
            Trigram('a', ' ', 'l'),
            Trigram('a', 'l', ' '),
            Trigram('a', 's', ' '),
            Trigram('e', ' ', 'd'),
            Trigram(' ', 'e', 'n'),
            Trigram('n', 'a', ' '),
            Trigram('o', 'n', 'a'),
            Trigram('s', ' ', 'd'),
            Trigram('d', 'a', ' '),
            Trigram('n', 't', 'e'),
            Trigram(' ', 't', 'o'),
            Trigram('a', 'd', ' '),
            Trigram('e', 'n', 'e'),
            Trigram('c', 'o', 'n'),
            Trigram(' ', 'p', 'r'),
            Trigram(' ', 's', 'u'),
            Trigram('t', 'o', 'd'),
            Trigram(' ', 's', 'e'),
            Trigram('h', 'o', ' '),
            Trigram('l', 'o', 's'),
            Trigram(' ', 'p', 'e'),
            Trigram('p', 'e', 'r'),
            Trigram('e', 'r', 's'),
            Trigram(' ', 'l', 'o'),
            Trigram('o', ' ', 'd'),
            Trigram(' ', 't', 'i'),
            Trigram('c', 'i', 'a'),
            Trigram('n', ' ', 'd'),
            Trigram('c', 'i', 'o'),
            Trigram(' ', 'e', 's'),
            Trigram('i', 'd', 'a'),
            Trigram('r', 'e', 's'),
            Trigram('a', ' ', 't'),
            Trigram('t', 'i', 'e'),
            Trigram('i', 'o', 'n'),
            Trigram('r', 's', 'o'),
            Trigram('t', 'e', ' '),
            Trigram('d', 'o', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram('s', 'o', 'n'),
            Trigram(' ', 'r', 'e'),
            Trigram(' ', 'l', 'i'),
            Trigram('t', 'o', ' '),
            Trigram('d', 'a', 'd'),
            Trigram('t', 'a', 'd'),
            Trigram('e', ' ', 's'),
            Trigram('e', 's', 't'),
            Trigram('p', 'r', 'o'),
            Trigram('q', 'u', 'e'),
            Trigram('m', 'e', 'n'),
            Trigram(' ', 'p', 'o'),
            Trigram('a', ' ', 'e'),
            Trigram('o', 'd', 'a'),
            Trigram('n', 'c', 'i'),
            Trigram(' ', 'q', 'u'),
            Trigram(' ', 'u', 'n'),
            Trigram('u', 'e', ' '),
            Trigram('n', 'e', ' '),
            Trigram('n', ' ', 'e'),
            Trigram('s', ' ', 'y'),
            Trigram('l', 'i', 'b'),
            Trigram('s', 'u', ' '),
            Trigram(' ', 'n', 'a'),
            Trigram('s', ' ', 'e'),
            Trigram('n', 'a', 'c'),
            Trigram('i', 'a', ' '),
            Trigram('e', ' ', 'e'),
            Trigram('t', 'r', 'a'),
            Trigram(' ', 'p', 'a'),
            Trigram('o', 'r', ' '),
            Trigram('a', 'd', 'o'),
            Trigram('a', ' ', 'd'),
            Trigram('n', 'e', 's'),
            Trigram('r', 'a', ' '),
            Trigram('s', 'e', ' '),
            Trigram('u', 'a', 'l'),
            Trigram('a', ' ', 'c'),
            Trigram('e', 'r', ' '),
            Trigram('p', 'o', 'r'),
            Trigram('c', 'o', 'm'),
            Trigram('n', 'a', 'l'),
            Trigram('r', 't', 'a'),
            Trigram('a', ' ', 's'),
            Trigram('b', 'e', 'r'),
            Trigram(' ', 'o', ' '),
            Trigram('o', 'n', 'e'),
            Trigram('s', ' ', 'p'),
            Trigram('d', 'o', 's'),
            Trigram('r', 'á', ' '),
            Trigram('s', 't', 'a'),
            Trigram('l', 'e', 's'),
            Trigram('d', 'e', 's'),
            Trigram('i', 'b', 'e'),
            Trigram('s', 'e', 'r'),
            Trigram('e', 'r', 'a'),
            Trigram('a', 'r', ' '),
            Trigram('e', 'r', 't'),
            Trigram('t', 'e', 'r'),
            Trigram(' ', 'd', 'i'),
            Trigram('a', 'l', 'e'),
            Trigram('l', ' ', 'd'),
            Trigram('n', 't', 'o'),
            Trigram('h', 'o', 's'),
            Trigram('d', 'e', 'l'),
            Trigram('i', 'c', 'a'),
            Trigram('a', ' ', 'a'),
            Trigram('s', ' ', 'n'),
            Trigram('n', ' ', 'c'),
            Trigram('o', 'c', 'i'),
            Trigram('i', 'm', 'i'),
            Trigram('i', 'o', ' '),
            Trigram('o', ' ', 'e'),
            Trigram('r', 'e', ' '),
            Trigram('y', ' ', 'l'),
            Trigram('e', ' ', 'c'),
            Trigram('a', 'n', 't'),
            Trigram('c', 'c', 'i'),
            Trigram(' ', 'a', 's'),
            Trigram('l', 'a', 's'),
            Trigram('p', 'a', 'r'),
            Trigram('a', 'm', 'e'),
            Trigram(' ', 'c', 'u'),
            Trigram('i', 'c', 'i'),
            Trigram('a', 'r', 'a'),
            Trigram('e', 'n', 'c'),
            Trigram('s', ' ', 't'),
            Trigram('n', 'd', 'i'),
            Trigram(' ', 's', 'o'),
            Trigram('o', ' ', 's'),
            Trigram('m', 'i', 'e'),
            Trigram('t', 'o', 's'),
            Trigram('u', 'n', 'a'),
            Trigram('b', 'r', 'e'),
            Trigram('d', 'i', 'c'),
            Trigram('c', 'l', 'a'),
            Trigram('s', ' ', 'l'),
            Trigram('e', ' ', 'a'),
            Trigram('l', ' ', 'p'),
            Trigram('p', 'r', 'e'),
            Trigram('n', 't', 'r'),
            Trigram('o', ' ', 't'),
            Trigram('i', 'a', 'l'),
            Trigram('y', ' ', 'a'),
            Trigram('n', 'i', 'd'),
            Trigram('n', ' ', 'p'),
            Trigram('a', ' ', 'y'),
            Trigram('m', 'a', 'n'),
            Trigram('o', 'm', 'o'),
            Trigram('s', 'o', ' '),
            Trigram('n', ' ', 'l'),
            Trigram(' ', 'a', 'l'),
            Trigram('a', 'l', 'i'),
            Trigram('s', ' ', 'a'),
            Trigram('n', 'o', ' '),
            Trigram(' ', 'i', 'g'),
            Trigram('s', ' ', 's'),
            Trigram('e', ' ', 'p'),
            Trigram('n', 't', 'a'),
            Trigram('u', 'm', 'a'),
            Trigram('t', 'e', 'n'),
            Trigram('g', 'u', 'a'),
            Trigram('a', 'd', 'e'),
            Trigram('y', ' ', 'e'),
            Trigram('s', 'o', 'c'),
            Trigram('m', 'o', ' '),
            Trigram(' ', 'f', 'u'),
            Trigram('i', 'g', 'u'),
            Trigram('o', ' ', 'p'),
            Trigram('n', ' ', 't'),
            Trigram('h', 'u', 'm'),
            Trigram('d', ' ', 'd'),
            Trigram('r', 'a', 'n'),
            Trigram('r', 'i', 'a'),
            Trigram('y', ' ', 'd'),
            Trigram('a', 'd', 'a'),
            Trigram('t', 'i', 'v'),
            Trigram('l', ' ', 'e'),
            Trigram('c', 'a', 's'),
            Trigram(' ', 'c', 'a'),
            Trigram('v', 'i', 'd'),
            Trigram('l', ' ', 't'),
            Trigram('s', ' ', 'c'),
            Trigram('i', 'd', 'o'),
            Trigram('d', 'a', 's'),
            Trigram('d', 'i', 's'),
            Trigram('s', ' ', 'i'),
            Trigram(' ', 'h', 'u'),
            Trigram('s', ' ', 'o'),
            Trigram('n', 'a', 'd'),
            Trigram('f', 'u', 'n'),
            Trigram(' ', 'm', 'a'),
            Trigram('r', 'a', 'c'),
            Trigram('n', 'd', 'a'),
            Trigram('e', 'l', 'i'),
            Trigram('s', 'a', 'r'),
            Trigram('u', 'n', 'd'),
            Trigram(' ', 'a', 'c'),
            Trigram('u', 'n', 'i'),
            Trigram('m', 'b', 'r'),
            Trigram('a', ' ', 'u'),
            Trigram('d', 'i', 'e'),
            Trigram('e', ' ', 'i'),
            Trigram('q', 'u', 'i'),
            Trigram('a', ' ', 'i'),
            Trigram(' ', 'h', 'a'),
            Trigram('l', 'a', 'r'),
            Trigram(' ', 't', 'r'),
            Trigram('o', 'd', 'o'),
            Trigram('c', 'a', ' '),
            Trigram('t', 'i', 'c'),
            Trigram('o', ' ', 'y'),
            Trigram('c', 't', 'i'),
            Trigram('l', 'i', 'd'),
            Trigram('o', 'r', 'i'),
            Trigram('n', 'd', 'o'),
            Trigram('a', 'r', 'i'),
            Trigram(' ', 'm', 'e'),
            Trigram('t', 'a', ' '),
            Trigram('i', 'n', 'd'),
            Trigram('e', 's', 'a'),
            Trigram('c', 'u', 'a'),
            Trigram('u', 'n', ' '),
            Trigram('i', 'e', 'r'),
            Trigram('t', 'a', 'l'),
            Trigram('e', 's', 'p'),
            Trigram('s', 'e', 'g'),
            Trigram('e', 'l', 'e'),
            Trigram('o', 'n', 's'),
            Trigram('i', 't', 'o'),
            Trigram('o', 'n', 't'),
            Trigram('i', 'v', 'a'),
            Trigram('s', ' ', 'h'),
            Trigram('d', ' ', 'y'),
            Trigram('n', 'o', 's'),
            Trigram('i', 's', 't'),
            Trigram('r', 's', 'e'),
            Trigram(' ', 'l', 'e'),
            Trigram('c', 'i', 'e'),
            Trigram('i', 'd', 'e'),
            Trigram('e', 'd', 'i'),
            Trigram('e', 'c', 'c'),
            Trigram('i', 'o', 's'),
            Trigram('l', ' ', 'm'),
            Trigram('r', ' ', 'e'),
            Trigram('m', 'e', 'd'),
            Trigram('t', 'o', 'r'),
            Trigram('s', 't', 'i'),
            Trigram('n', ' ', 'a'),
            Trigram('r', 'i', 'm'),
            Trigram('u', 'i', 'e'),
            Trigram('p', 'l', 'e'),
            Trigram('t', 'r', 'i'),
            Trigram('i', 'b', 'r'),
            Trigram('s', 'u', 's'),
            Trigram('l', 'o', ' '),
            Trigram('e', 'c', 't'),
            Trigram('p', 'e', 'n'),
            Trigram('y', ' ', 'c'),
            Trigram('a', 'n', ' '),
            Trigram('e', ' ', 'h'),
            Trigram('n', ' ', 's'),
            Trigram('e', 'r', 'n'),
            Trigram('t', 'a', 'r'),
            Trigram('l', ' ', 'y'),
            Trigram('e', 'g', 'u'),
            Trigram('g', 'u', 'r'),
            Trigram('u', 'r', 'a'),
            Trigram('i', 'n', 't'),
            Trigram('o', 'n', 'd'),
            Trigram('m', 'a', 't'),
            Trigram('l', ' ', 'r'),
            Trigram('r', ' ', 'a'),
            Trigram('i', 's', 'f'),
            Trigram('o', 't', 'e'),
        ],
    ),
    (
        Lang::Eng,
        &[
            Trigram(' ', 't', 'h'),
            Trigram('t', 'h', 'e'),
            Trigram(' ', 'a', 'n'),
            Trigram('h', 'e', ' '),
            Trigram('n', 'd', ' '),
            Trigram('a', 'n', 'd'),
            Trigram('i', 'o', 'n'),
            Trigram(' ', 'o', 'f'),
            Trigram('o', 'f', ' '),
            Trigram('t', 'i', 'o'),
            Trigram(' ', 't', 'o'),
            Trigram('t', 'o', ' '),
            Trigram('o', 'n', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram('a', 'l', ' '),
            Trigram('a', 't', 'i'),
            Trigram('i', 'g', 'h'),
            Trigram('g', 'h', 't'),
            Trigram('r', 'i', 'g'),
            Trigram(' ', 'r', 'i'),
            Trigram('o', 'r', ' '),
            Trigram('e', 'n', 't'),
            Trigram('a', 's', ' '),
            Trigram('e', 'd', ' '),
            Trigram('i', 's', ' '),
            Trigram('l', 'l', ' '),
            Trigram('i', 'n', ' '),
            Trigram(' ', 'b', 'e'),
            Trigram('e', ' ', 'r'),
            Trigram('n', 'e', ' '),
            Trigram('o', 'n', 'e'),
            Trigram('v', 'e', 'r'),
            Trigram('a', 'l', 'l'),
            Trigram('s', ' ', 't'),
            Trigram('e', 'v', 'e'),
            Trigram('t', ' ', 't'),
            Trigram(' ', 'f', 'r'),
            Trigram('s', ' ', 'a'),
            Trigram(' ', 'h', 'a'),
            Trigram(' ', 'r', 'e'),
            Trigram('t', 'y', ' '),
            Trigram('e', 'r', 'y'),
            Trigram(' ', 'o', 'r'),
            Trigram('d', ' ', 't'),
            Trigram(' ', 'p', 'r'),
            Trigram('h', 't', ' '),
            Trigram(' ', 'c', 'o'),
            Trigram(' ', 'e', 'v'),
            Trigram('e', ' ', 'h'),
            Trigram('e', ' ', 'a'),
            Trigram('n', 'g', ' '),
            Trigram('t', 's', ' '),
            Trigram('h', 'i', 's'),
            Trigram('i', 'n', 'g'),
            Trigram('b', 'e', ' '),
            Trigram('y', 'o', 'n'),
            Trigram(' ', 's', 'h'),
            Trigram('c', 'e', ' '),
            Trigram('r', 'e', 'e'),
            Trigram('f', 'r', 'e'),
            Trigram('r', 'y', 'o'),
            Trigram('n', ' ', 't'),
            Trigram('h', 'e', 'r'),
            Trigram('m', 'e', 'n'),
            Trigram('n', 'a', 't'),
            Trigram('s', 'h', 'a'),
            Trigram('p', 'r', 'o'),
            Trigram('n', 'a', 'l'),
            Trigram('y', ' ', 'a'),
            Trigram('h', 'a', 's'),
            Trigram('e', 's', ' '),
            Trigram('f', 'o', 'r'),
            Trigram(' ', 'h', 'i'),
            Trigram('h', 'a', 'l'),
            Trigram('f', ' ', 't'),
            Trigram('n', ' ', 'a'),
            Trigram('n', ' ', 'o'),
            Trigram('n', 't', ' '),
            Trigram(' ', 'p', 'e'),
            Trigram('s', ' ', 'o'),
            Trigram(' ', 'f', 'o'),
            Trigram('d', ' ', 'i'),
            Trigram('n', 'c', 'e'),
            Trigram('e', 'r', ' '),
            Trigram('o', 'n', 's'),
            Trigram('r', 'e', 's'),
            Trigram('e', ' ', 's'),
            Trigram('e', 'c', 't'),
            Trigram('i', 't', 'y'),
            Trigram('l', 'y', ' '),
            Trigram('l', ' ', 'b'),
            Trigram('r', 'y', ' '),
            Trigram('e', ' ', 'e'),
            Trigram('e', 'r', 's'),
            Trigram('e', ' ', 'i'),
            Trigram('a', 'n', ' '),
            Trigram('e', ' ', 'o'),
            Trigram(' ', 'd', 'e'),
            Trigram('c', 't', 'i'),
            Trigram('d', 'o', 'm'),
            Trigram('e', 'd', 'o'),
            Trigram('e', 'e', 'd'),
            Trigram('h', 't', 's'),
            Trigram('t', 'e', 'r'),
            Trigram('o', 'n', 'a'),
            Trigram('r', 'e', ' '),
            Trigram(' ', 'n', 'o'),
            Trigram(' ', 'w', 'h'),
            Trigram(' ', 'a', ' '),
            Trigram(' ', 'u', 'n'),
            Trigram('d', ' ', 'f'),
            Trigram(' ', 'a', 's'),
            Trigram('n', 'y', ' '),
            Trigram('l', ' ', 'a'),
            Trigram('e', ' ', 'p'),
            Trigram('e', 'r', 'e'),
            Trigram(' ', 'e', 'n'),
            Trigram(' ', 'n', 'a'),
            Trigram(' ', 'w', 'i'),
            Trigram('n', 'i', 't'),
            Trigram('n', 't', 'e'),
            Trigram('d', ' ', 'a'),
            Trigram('a', 'n', 'y'),
            Trigram('t', 'e', 'd'),
            Trigram(' ', 'd', 'i'),
            Trigram('n', 's', ' '),
            Trigram('s', 't', 'a'),
            Trigram('t', 'h', ' '),
            Trigram('p', 'e', 'r'),
            Trigram('i', 't', 'h'),
            Trigram('e', ' ', 't'),
            Trigram('s', 't', ' '),
            Trigram('e', ' ', 'c'),
            Trigram('y', ' ', 't'),
            Trigram('o', 'm', ' '),
            Trigram('s', 'o', 'c'),
            Trigram(' ', 'a', 'r'),
            Trigram('c', 'h', ' '),
            Trigram('t', ' ', 'o'),
            Trigram('d', ' ', 'o'),
            Trigram('n', 't', 'i'),
            Trigram('s', ' ', 'e'),
            Trigram('e', 'q', 'u'),
            Trigram('v', 'e', ' '),
            Trigram('o', 'c', 'i'),
            Trigram('m', 'a', 'n'),
            Trigram(' ', 'f', 'u'),
            Trigram('o', 't', 'e'),
            Trigram('o', 't', 'h'),
            Trigram('e', 's', 's'),
            Trigram(' ', 'a', 'l'),
            Trigram(' ', 'a', 'c'),
            Trigram('w', 'i', 't'),
            Trigram('i', 'a', 'l'),
            Trigram(' ', 'm', 'a'),
            Trigram('u', 'n', 'i'),
            Trigram(' ', 's', 'e'),
            Trigram('r', 'e', 'a'),
            Trigram(' ', 's', 'o'),
            Trigram(' ', 'o', 'n'),
            Trigram('l', 'i', 't'),
            Trigram('i', 'n', 't'),
            Trigram('r', ' ', 't'),
            Trigram('y', ' ', 'o'),
            Trigram('e', 'n', 'c'),
            Trigram('t', 'h', 'i'),
            Trigram('u', 'a', 'l'),
            Trigram('t', ' ', 'a'),
            Trigram(' ', 'e', 'q'),
            Trigram('t', 'a', 't'),
            Trigram('q', 'u', 'a'),
            Trigram('i', 'v', 'e'),
            Trigram(' ', 's', 't'),
            Trigram('a', 'l', 'i'),
            Trigram('e', ' ', 'w'),
            Trigram('l', ' ', 'o'),
            Trigram('a', 'r', 'e'),
            Trigram('f', ' ', 'h'),
            Trigram('c', 'o', 'n'),
            Trigram('t', 'e', ' '),
            Trigram('l', 'e', 'd'),
            Trigram(' ', 'i', 's'),
            Trigram('u', 'n', 'd'),
            Trigram('c', 'i', 'a'),
            Trigram('e', ' ', 'f'),
            Trigram('l', 'e', ' '),
            Trigram(' ', 'l', 'a'),
            Trigram('y', ' ', 'i'),
            Trigram('u', 'm', 'a'),
            Trigram('b', 'y', ' '),
            Trigram(' ', 'b', 'y'),
            Trigram('h', 'u', 'm'),
            Trigram('f', ' ', 'a'),
            Trigram('i', 'c', ' '),
            Trigram(' ', 'h', 'u'),
            Trigram('a', 'v', 'e'),
            Trigram('g', 'e', ' '),
            Trigram('r', ' ', 'a'),
            Trigram(' ', 'w', 'o'),
            Trigram('o', ' ', 'a'),
            Trigram('m', 's', ' '),
            Trigram('c', 'o', 'm'),
            Trigram(' ', 'm', 'e'),
            Trigram('e', 'a', 's'),
            Trigram('s', ' ', 'd'),
            Trigram('t', 'e', 'c'),
            Trigram(' ', 'l', 'i'),
            Trigram('n', ' ', 'e'),
            Trigram('e', 'n', ' '),
            Trigram('r', 'a', 't'),
            Trigram('t', 'i', 't'),
            Trigram('p', 'l', 'e'),
            Trigram('w', 'h', 'e'),
            Trigram('a', 't', 'e'),
            Trigram('o', ' ', 't'),
            Trigram('s', ' ', 'r'),
            Trigram('t', ' ', 'f'),
            Trigram('r', 'o', 't'),
            Trigram(' ', 'c', 'h'),
            Trigram('c', 'i', 'e'),
            Trigram('d', 'i', 's'),
            Trigram('a', 'g', 'e'),
            Trigram('a', 'r', 'y'),
            Trigram('o', ' ', 'o'),
            Trigram('a', 'n', 'c'),
            Trigram('e', 'l', 'i'),
            Trigram('n', 'o', ' '),
            Trigram(' ', 'f', 'a'),
            Trigram(' ', 's', 'u'),
            Trigram('s', 'o', 'n'),
            Trigram('i', 'n', 'c'),
            Trigram('a', 't', ' '),
            Trigram('n', 'd', 'a'),
            Trigram('h', 'o', 'u'),
            Trigram('w', 'o', 'r'),
            Trigram('t', ' ', 'i'),
            Trigram('n', 'd', 'e'),
            Trigram('r', 'o', 'm'),
            Trigram('o', 'm', 's'),
            Trigram(' ', 'o', 't'),
            Trigram('g', ' ', 't'),
            Trigram('e', 'm', 'e'),
            Trigram('t', 'l', 'e'),
            Trigram('i', 't', 'i'),
            Trigram('g', 'n', 'i'),
            Trigram('s', ' ', 'w'),
            Trigram('i', 't', 'l'),
            Trigram('d', 'u', 'c'),
            Trigram('d', ' ', 'w'),
            Trigram('w', 'h', 'i'),
            Trigram('a', 'c', 't'),
            Trigram('h', 'i', 'c'),
            Trigram('a', 'w', ' '),
            Trigram('l', 'a', 'w'),
            Trigram(' ', 'h', 'e'),
            Trigram('i', 'c', 'h'),
            Trigram('m', 'i', 'n'),
            Trigram('i', 'm', 'i'),
            Trigram('o', 'r', 't'),
            Trigram('o', ' ', 's'),
            Trigram('s', 'e', ' '),
            Trigram('e', ' ', 'b'),
            Trigram('n', 't', 'r'),
            Trigram('t', 'r', 'a'),
            Trigram('e', 'd', 'u'),
            Trigram('o', 'u', 'n'),
            Trigram('t', 'a', 'n'),
            Trigram('e', ' ', 'd'),
            Trigram('n', 's', 't'),
            Trigram('l', ' ', 'p'),
            Trigram('d', ' ', 'n'),
            Trigram('l', 'd', ' '),
            Trigram('n', 't', 'a'),
            Trigram('s', ' ', 'i'),
            Trigram('b', 'l', 'e'),
            Trigram('n', ' ', 'p'),
            Trigram(' ', 'p', 'u'),
            Trigram('n', ' ', 's'),
            Trigram(' ', 'a', 't'),
            Trigram('i', 'l', 'y'),
            Trigram('r', 't', 'h'),
            Trigram('t', 'h', 'o'),
            Trigram('f', 'u', 'l'),
            Trigram('s', 's', 'i'),
            Trigram('d', 'e', 'r'),
            Trigram('o', ' ', 'e'),
            Trigram('c', 'a', 't'),
            Trigram('u', 'c', 'a'),
            Trigram('u', 'n', 't'),
            Trigram('i', 'e', 'n'),
            Trigram(' ', 'e', 'd'),
            Trigram('o', ' ', 'p'),
            Trigram('h', ' ', 'a'),
            Trigram('e', 'r', 'a'),
            Trigram('i', 'n', 'd'),
            Trigram('p', 'e', 'n'),
            Trigram('s', 'e', 'c'),
            Trigram('n', ' ', 'w'),
            Trigram('o', 'm', 'm'),
            Trigram('r', ' ', 's'),
        ],
    ),
    (
        Lang::Por,
        &[
            Trigram('o', 's', ' '),
            Trigram('d', 'e', ' '),
            Trigram(' ', 'd', 'e'),
            Trigram(' ', 'a', ' '),
            Trigram(' ', 'e', ' '),
            Trigram('o', ' ', 'd'),
            Trigram('t', 'o', ' '),
            Trigram('ã', 'o', ' '),
            Trigram(' ', 'd', 'i'),
            Trigram('e', 'n', 't'),
            Trigram('d', 'a', ' '),
            Trigram('i', 't', 'o'),
            Trigram('e', 'm', ' '),
            Trigram(' ', 'c', 'o'),
            Trigram('e', 'i', 't'),
            Trigram('a', 's', ' '),
            Trigram('d', 'i', 'r'),
            Trigram('e', 's', ' '),
            Trigram('i', 'r', 'e'),
            Trigram('r', 'e', 'i'),
            Trigram(' ', 's', 'e'),
            Trigram('ç', 'ã', 'o'),
            Trigram('a', 'd', 'e'),
            Trigram('a', ' ', 'p'),
            Trigram('d', 'a', 'd'),
            Trigram('e', ' ', 'd'),
            Trigram('s', ' ', 'd'),
            Trigram('m', 'e', 'n'),
            Trigram('n', 't', 'e'),
            Trigram('d', 'o', ' '),
            Trigram('s', ' ', 'e'),
            Trigram(' ', 'p', 'r'),
            Trigram(' ', 'p', 'e'),
            Trigram('d', 'o', 's'),
            Trigram(' ', 't', 'o'),
            Trigram(' ', 'd', 'a'),
            Trigram('a', ' ', 'a'),
            Trigram('o', ' ', 'e'),
            Trigram(' ', 'o', ' '),
            Trigram('o', ' ', 'a'),
            Trigram('e', 's', 's'),
            Trigram('c', 'o', 'n'),
            Trigram('t', 'o', 'd'),
            Trigram('q', 'u', 'e'),
            Trigram(' ', 'q', 'u'),
            Trigram('t', 'e', ' '),
            Trigram('e', ' ', 'a'),
            Trigram(' ', 'd', 'o'),
            Trigram('a', 'l', ' '),
            Trigram('r', 'e', 's'),
            Trigram('i', 'd', 'a'),
            Trigram('m', ' ', 'd'),
            Trigram(' ', 'i', 'n'),
            Trigram(' ', 'o', 'u'),
            Trigram('e', 'r', ' '),
            Trigram('s', 's', 'o'),
            Trigram(' ', 'n', 'a'),
            Trigram(' ', 'r', 'e'),
            Trigram(' ', 'p', 'o'),
            Trigram('a', ' ', 's'),
            Trigram(' ', 'l', 'i'),
            Trigram('u', 'm', 'a'),
            Trigram('c', 'i', 'a'),
            Trigram('a', 'r', ' '),
            Trigram('p', 'r', 'o'),
            Trigram('e', ' ', 'e'),
            Trigram('a', ' ', 'd'),
            Trigram(' ', 't', 'e'),
            Trigram('a', 'ç', 'ã'),
            Trigram('a', ' ', 't'),
            Trigram(' ', 'e', 's'),
            Trigram(' ', 's', 'u'),
            Trigram('o', 'u', ' '),
            Trigram('u', 'e', ' '),
            Trigram('s', ' ', 'p'),
            Trigram('t', 'o', 's'),
            Trigram('a', ' ', 'e'),
            Trigram('d', 'e', 's'),
            Trigram('r', 'a', ' '),
            Trigram('c', 'o', 'm'),
            Trigram('n', 'o', ' '),
            Trigram('a', 'm', 'e'),
            Trigram('i', 'a', ' '),
            Trigram('e', ' ', 'p'),
            Trigram('t', 'e', 'm'),
            Trigram('n', 't', 'o'),
            Trigram(' ', 'p', 'a'),
            Trigram('i', 's', ' '),
            Trigram('e', 's', 't'),
            Trigram('t', 'r', 'a'),
            Trigram('õ', 'e', 's'),
            Trigram('n', 'a', ' '),
            Trigram('s', ' ', 'o'),
            Trigram('o', 'd', 'a'),
            Trigram('d', 'a', 's'),
            Trigram('s', 'e', 'r'),
            Trigram('s', 'o', 'a'),
            Trigram('s', ' ', 'n'),
            Trigram('p', 'e', 's'),
            Trigram('o', ' ', 'p'),
            Trigram('s', ' ', 'a'),
            Trigram('o', ' ', 's'),
            Trigram('e', ' ', 'o'),
            Trigram(' ', 'e', 'm'),
            Trigram(' ', 'a', 's'),
            Trigram(' ', 'à', ' '),
            Trigram('o', ' ', 'o'),
            Trigram('a', 'i', 's'),
            Trigram('b', 'e', 'r'),
            Trigram('a', 'd', 'o'),
            Trigram('o', 'a', ' '),
            Trigram('o', ' ', 't'),
            Trigram('e', ' ', 's'),
            Trigram('m', 'a', 'n'),
            Trigram('s', 'u', 'a'),
            Trigram('u', 'a', ' '),
            Trigram(' ', 'n', 'o'),
            Trigram(' ', 'o', 's'),
            Trigram('a', ' ', 'c'),
            Trigram('t', 'e', 'r'),
            Trigram('ç', 'õ', 'e'),
            Trigram('e', 'r', 'd'),
            Trigram('l', 'i', 'b'),
            Trigram('r', 'd', 'a'),
            Trigram('s', ' ', 's'),
            Trigram('n', 'c', 'i'),
            Trigram('i', 'b', 'e'),
            Trigram('e', ' ', 'n'),
            Trigram('i', 'c', 'a'),
            Trigram('o', 'd', 'o'),
            Trigram('s', 'o', ' '),
            Trigram('n', 'a', 'l'),
            Trigram('n', 't', 'r'),
            Trigram('s', ' ', 't'),
            Trigram('h', 'u', 'm'),
            Trigram('u', 'r', 'a'),
            Trigram(' ', 'a', 'o'),
            Trigram('o', 'n', 'a'),
            Trigram('u', 'a', 'l'),
            Trigram(' ', 's', 'o'),
            Trigram('o', 'r', ' '),
            Trigram('m', 'a', ' '),
            Trigram('s', 't', 'a'),
            Trigram('o', ' ', 'c'),
            Trigram('a', ' ', 'n'),
            Trigram('p', 'r', 'e'),
            Trigram('a', 'r', 'a'),
            Trigram('e', 'r', 'a'),
            Trigram('o', 'n', 's'),
            Trigram('e', ' ', 't'),
            Trigram('r', ' ', 'a'),
            Trigram('p', 'a', 'r'),
            Trigram('o', ' ', 'à'),
            Trigram(' ', 'h', 'u'),
            Trigram('i', 'n', 'd'),
            Trigram('p', 'o', 'r'),
            Trigram('c', 'i', 'o'),
            Trigram('r', 'i', 'a'),
            Trigram('m', ' ', 'a'),
            Trigram('s', ' ', 'c'),
            Trigram(' ', 'u', 'm'),
            Trigram('a', ' ', 'l'),
            Trigram('g', 'u', 'a'),
            Trigram('r', 'a', 'n'),
            Trigram(' ', 'e', 'n'),
            Trigram('n', 'd', 'i'),
            Trigram('o', ' ', 'i'),
            Trigram('e', ' ', 'c'),
            Trigram('r', 'a', 'ç'),
            Trigram('i', 'o', 'n'),
            Trigram('n', 'i', 'd'),
            Trigram('a', 'c', 'i'),
            Trigram('a', 'n', 'o'),
            Trigram('s', 'o', 'c'),
            Trigram('e', ' ', 'r'),
            Trigram('o', 'c', 'i'),
            Trigram(' ', 'a', 'c'),
            Trigram('u', 'n', 'd'),
            Trigram('s', 'e', 'n'),
            Trigram('n', 'o', 's'),
            Trigram('n', 's', 'i'),
            Trigram('r', 'e', 'c'),
            Trigram('i', 'm', 'e'),
            Trigram('a', 'l', 'i'),
            Trigram('i', 'n', 't'),
            Trigram('u', 'm', ' '),
            Trigram('p', 'e', 'r'),
            Trigram('n', 'a', 'c'),
            Trigram(' ', 'a', 'l'),
            Trigram('m', ' ', 'o'),
            Trigram('r', ' ', 'p'),
            Trigram(' ', 'f', 'u'),
            Trigram('n', 'd', 'o'),
            Trigram('o', 'n', 't'),
            Trigram('a', 'ç', 'õ'),
            Trigram(' ', 'i', 'g'),
            Trigram('i', 'g', 'u'),
            Trigram('f', 'u', 'n'),
            Trigram('n', 't', 'a'),
            Trigram(' ', 'm', 'a'),
            Trigram('u', 'n', 'i'),
            Trigram('c', 'ç', 'ã'),
            Trigram('e', 'r', 'e'),
            Trigram(' ', 'e', 'x'),
            Trigram('a', ' ', 'i'),
            Trigram(' ', 'm', 'e'),
            Trigram('e', 's', 'e'),
            Trigram('r', 'i', 'o'),
            Trigram('l', ' ', 'd'),
            Trigram('a', ' ', 'o'),
            Trigram('s', ' ', 'h'),
            Trigram('p', 'e', 'l'),
            Trigram('a', 'd', 'a'),
            Trigram('p', 'r', 'i'),
            Trigram('i', 'd', 'e'),
            Trigram('a', 'm', ' '),
            Trigram('m', ' ', 'p'),
            Trigram('p', 'o', 'd'),
            Trigram('s', ' ', 'f'),
            Trigram('é', 'm', ' '),
            Trigram('a', ' ', 'f'),
            Trigram('i', 'o', ' '),
            Trigram('o', 'd', 'e'),
            Trigram('c', 'a', ' '),
            Trigram('i', 't', 'a'),
            Trigram('l', 'i', 'd'),
            Trigram('t', 'i', 'v'),
            Trigram('e', ' ', 'f'),
            Trigram('v', 'i', 'd'),
            Trigram('r', ' ', 'e'),
            Trigram('e', 's', 'p'),
            Trigram('n', 'd', 'a'),
            Trigram('o', 'm', 'o'),
            Trigram('e', ' ', 'l'),
            Trigram('n', 'a', 'ç'),
            Trigram('o', ' ', 'r'),
            Trigram('a', 'n', 't'),
            Trigram('a', ' ', 'q'),
            Trigram('t', 'a', 'd'),
            Trigram('l', 'i', 'c'),
            Trigram('i', 'v', 'a'),
            Trigram(' ', 'f', 'a'),
            Trigram('v', 'e', 'r'),
            Trigram('s', ' ', 'l'),
            Trigram('i', 'a', 'l'),
            Trigram('c', 'l', 'a'),
            Trigram('n', 'g', 'u'),
            Trigram('i', 'n', 'g'),
            Trigram(' ', 'c', 'a'),
            Trigram('m', 'o', ' '),
            Trigram('d', 'e', 'r'),
            Trigram(' ', 'v', 'i'),
            Trigram('e', 'l', 'i'),
            Trigram('i', 's', 't'),
            Trigram('t', 'a', ' '),
            Trigram('s', 'e', ' '),
            Trigram('a', 't', 'i'),
            Trigram('i', 'o', 's'),
            Trigram('i', 'd', 'o'),
            Trigram('r', ' ', 'o'),
            Trigram('e', 'c', 'i'),
            Trigram('d', 'i', 's'),
            Trigram(' ', 'u', 'n'),
            Trigram('e', ' ', 'i'),
            Trigram('r', ' ', 'd'),
            Trigram('e', 'c', 'ç'),
            Trigram('o', ' ', 'q'),
            Trigram('s', ' ', 'i'),
            Trigram('q', 'u', 'a'),
            Trigram('ê', 'n', 'c'),
            Trigram('a', ' ', 'm'),
            Trigram('s', 'e', 'u'),
            Trigram('s', 't', 'i'),
            Trigram('n', 'i', 'n'),
            Trigram('u', 'e', 'r'),
            Trigram('r', 'a', 'r'),
            Trigram('c', 'a', 's'),
            Trigram('a', 'o', 's'),
            Trigram('e', 'n', 's'),
            Trigram('g', 'u', 'é'),
            Trigram('i', 'a', 's'),
            Trigram('s', 'i', 'd'),
            Trigram('u', 'é', 'm'),
            Trigram('t', 'u', 'r'),
            Trigram('d', 'a', 'm'),
            Trigram('s', 's', 'e'),
            Trigram('a', 'o', ' '),
            Trigram('e', 'l', 'a'),
            Trigram('l', ' ', 'e'),
            Trigram('f', 'o', 'r'),
            Trigram('t', 'e', 'c'),
            Trigram('o', 't', 'e'),
            Trigram(' ', 'p', 'l'),
            Trigram('e', 'n', 'a'),
            Trigram(' ', 't', 'r'),
            Trigram('m', ' ', 'c'),
            Trigram('t', 'r', 'o'),
            Trigram(' ', 'n', 'i'),
            Trigram('i', 'c', 'o'),
            Trigram('r', 'o', 't'),
        ],
    ),
    (
        Lang::Ind,
        &[
            Trigram('a', 'n', ' '),
            Trigram('a', 'n', 'g'),
            Trigram(' ', 'd', 'a'),
            Trigram('n', 'g', ' '),
            Trigram(' ', 'p', 'e'),
            Trigram('a', 'k', ' '),
            Trigram(' ', 'k', 'e'),
            Trigram(' ', 'm', 'e'),
            Trigram('a', 't', 'a'),
            Trigram(' ', 's', 'e'),
            Trigram('d', 'a', 'n'),
            Trigram('k', 'a', 'n'),
            Trigram(' ', 'd', 'i'),
            Trigram(' ', 'b', 'e'),
            Trigram('h', 'a', 'k'),
            Trigram('b', 'e', 'r'),
            Trigram('p', 'e', 'r'),
            Trigram('r', 'a', 'n'),
            Trigram('n', 'g', 'a'),
            Trigram('y', 'a', 'n'),
            Trigram('e', 'n', 'g'),
            Trigram(' ', 'y', 'a'),
            Trigram(' ', 'h', 'a'),
            Trigram('a', 's', 'a'),
            Trigram('g', 'a', 'n'),
            Trigram('m', 'e', 'n'),
            Trigram('a', 'r', 'a'),
            Trigram('n', 'y', 'a'),
            Trigram('n', ' ', 'p'),
            Trigram('n', ' ', 'd'),
            Trigram('n', ' ', 'k'),
            Trigram('a', ' ', 'd'),
            Trigram('t', 'a', 'n'),
            Trigram(' ', 'a', 't'),
            Trigram('a', 't', ' '),
            Trigram('o', 'r', 'a'),
            Trigram('a', 'l', 'a'),
            Trigram('s', 'a', 'n'),
            Trigram(' ', 'b', 'a'),
            Trigram('a', 'p', ' '),
            Trigram('e', 'r', 'h'),
            Trigram('n', ' ', 'b'),
            Trigram('r', 'h', 'a'),
            Trigram('y', 'a', ' '),
            Trigram(' ', 'm', 'a'),
            Trigram('g', ' ', 'b'),
            Trigram('a', ' ', 's'),
            Trigram('p', 'e', 'n'),
            Trigram('e', 'b', 'a'),
            Trigram('a', 's', ' '),
            Trigram('a', 'a', 'n'),
            Trigram('u', 'k', ' '),
            Trigram('n', 't', 'u'),
            Trigram(' ', 'o', 'r'),
            Trigram('e', 't', 'i'),
            Trigram('t', 'a', 's'),
            Trigram('a', 'k', 'a'),
            Trigram('t', 'i', 'a'),
            Trigram('b', 'a', 'n'),
            Trigram('s', 'e', 't'),
            Trigram(' ', 'u', 'n'),
            Trigram('n', ' ', 's'),
            Trigram('t', 'e', 'r'),
            Trigram('n', ' ', 'y'),
            Trigram(' ', 't', 'e'),
            Trigram('k', ' ', 'm'),
            Trigram('t', 'u', 'k'),
            Trigram('b', 'a', 's'),
            Trigram('i', 'a', 'p'),
            Trigram('l', 'a', 'm'),
            Trigram('b', 'e', 'b'),
            Trigram('a', 'm', ' '),
            Trigram(' ', 'd', 'e'),
            Trigram('k', ' ', 'a'),
            Trigram('k', 'e', 'b'),
            Trigram('n', ' ', 'm'),
            Trigram('i', ' ', 'd'),
            Trigram('u', 'n', 't'),
            Trigram('a', 'm', 'a'),
            Trigram('d', 'a', 'l'),
            Trigram('a', 'h', ' '),
            Trigram('i', 'k', 'a'),
            Trigram('d', 'a', 'k'),
            Trigram('e', 'b', 'e'),
            Trigram('p', ' ', 'o'),
            Trigram('s', 'a', ' '),
            Trigram('p', 'u', 'n'),
            Trigram('m', 'e', 'm'),
            Trigram('n', ' ', 'h'),
            Trigram('e', 'n', 'd'),
            Trigram('d', 'e', 'n'),
            Trigram('r', 'a', ' '),
            Trigram('e', 'l', 'a'),
            Trigram('r', 'i', ' '),
            Trigram('n', 'd', 'a'),
            Trigram(' ', 's', 'a'),
            Trigram('d', 'i', ' '),
            Trigram('m', 'a', ' '),
            Trigram('a', ' ', 'm'),
            Trigram('n', ' ', 't'),
            Trigram('k', ' ', 'd'),
            Trigram('n', ' ', 'a'),
            Trigram('n', 'g', 'g'),
            Trigram('t', 'a', 'u'),
            Trigram('m', 'a', 'n'),
            Trigram('g', 'a', 'r'),
            Trigram('e', 'r', 'i'),
            Trigram('a', 's', 'i'),
            Trigram(' ', 't', 'i'),
            Trigram('u', 'n', ' '),
            Trigram('a', 'l', ' '),
            Trigram('a', 'd', 'a'),
            Trigram('u', 'm', ' '),
            Trigram('a', ' ', 'p'),
            Trigram('l', 'a', 'k'),
            Trigram('a', 'r', 'i'),
            Trigram('a', 'u', ' '),
            Trigram(' ', 'n', 'e'),
            Trigram('n', 'e', 'g'),
            Trigram('a', ' ', 'b'),
            Trigram('n', 'g', 's'),
            Trigram('t', 'a', ' '),
            Trigram('o', 'l', 'e'),
            Trigram('l', 'e', 'h'),
            Trigram('e', 'r', 't'),
            Trigram('e', 'r', 's'),
            Trigram('i', 'd', 'a'),
            Trigram('k', ' ', 'h'),
            Trigram('a', 'n', 'a'),
            Trigram('g', 's', 'a'),
            Trigram('d', 'a', 'r'),
            Trigram('u', 'k', 'a'),
            Trigram('t', 'i', 'd'),
            Trigram('b', 'a', 't'),
            Trigram('s', 'i', 'a'),
            Trigram('e', 'r', 'a'),
            Trigram('e', 'h', ' '),
            Trigram('d', 'a', 'p'),
            Trigram('i', 'l', 'a'),
            Trigram('d', 'i', 'l'),
            Trigram('h', ' ', 'd'),
            Trigram('a', 't', 'u'),
            Trigram('s', 'a', 'm'),
            Trigram('i', 'a', ' '),
            Trigram('i', ' ', 'm'),
            Trigram(' ', 'i', 'n'),
            Trigram('l', 'a', 'n'),
            Trigram('a', 'h', 'a'),
            Trigram('u', 'a', 'n'),
            Trigram('t', 'u', ' '),
            Trigram('a', 'i', ' '),
            Trigram('t', ' ', 'd'),
            Trigram('a', ' ', 'a'),
            Trigram('g', ' ', 'd'),
            Trigram('h', 'a', 'r'),
            Trigram('s', 'e', 'm'),
            Trigram('n', 'a', ' '),
            Trigram('a', 'p', 'a'),
            Trigram('s', 'e', 'r'),
            Trigram('e', 'n', 'a'),
            Trigram('k', 'a', 't'),
            Trigram('u', 'a', 't'),
            Trigram('e', 'r', 'b'),
            Trigram('e', 'r', 'l'),
            Trigram('m', 'a', 's'),
            Trigram('r', 't', 'a'),
            Trigram('e', 'g', 'a'),
            Trigram('u', 'n', 'g'),
            Trigram('n', 'a', 'n'),
            Trigram('e', 'm', 'p'),
            Trigram('n', ' ', 'u'),
            Trigram('k', 'u', 'm'),
            Trigram('l', ' ', 'd'),
            Trigram('g', ' ', 's'),
            Trigram(' ', 'h', 'u'),
            Trigram('k', 'a', ' '),
            Trigram('e', 'n', 't'),
            Trigram('p', 'a', 't'),
            Trigram('m', 'b', 'a'),
            Trigram('a', 'g', 'a'),
            Trigram('n', 't', 'a'),
            Trigram('a', 'd', 'i'),
            Trigram(' ', 's', 'u'),
            Trigram('e', 'n', 'i'),
            Trigram('u', 'k', 'u'),
            Trigram('n', ' ', 'i'),
            Trigram('h', 'u', 'k'),
            Trigram('i', 'n', 'd'),
            Trigram('a', 'r', ' '),
            Trigram('r', 'g', 'a'),
            Trigram('i', ' ', 's'),
            Trigram('a', 'k', 'u'),
            Trigram('n', 'd', 'i'),
            Trigram('s', 'u', 'a'),
            Trigram('n', 'i', ' '),
            Trigram('r', 'u', 's'),
            Trigram('h', 'a', 'n'),
            Trigram('s', 'i', ' '),
            Trigram('c', 'a', 'r'),
            Trigram('n', 'n', 'y'),
            Trigram(' ', 'l', 'a'),
            Trigram('i', 'n', ' '),
            Trigram('u', ' ', 'd'),
            Trigram('i', 'k', ' '),
            Trigram('u', 'a', ' '),
            Trigram('l', 'a', 'h'),
            Trigram('r', 'i', 'k'),
            Trigram('u', 's', 'i'),
            Trigram('e', 'm', 'b'),
            Trigram('a', 'n', 'n'),
            Trigram('m', 'e', 'r'),
            Trigram('i', 'a', 'n'),
            Trigram('g', 'g', 'a'),
            Trigram('l', 'a', 'i'),
            Trigram('m', 'i', 'n'),
            Trigram('a', ' ', 'u'),
            Trigram('l', 'u', 'a'),
            Trigram('e', 'm', 'a'),
            Trigram('e', 'm', 'u'),
            Trigram('a', 'r', 'g'),
            Trigram('d', 'u', 'n'),
            Trigram('d', 'i', 'p'),
            Trigram('a', ' ', 't'),
            Trigram('m', 'a', 't'),
            Trigram('a', 'y', 'a'),
            Trigram('r', 'b', 'u'),
            Trigram('a', 'r', 'u'),
            Trigram('e', 'r', 'k'),
            Trigram('r', 'k', 'a'),
            Trigram('i', 'n', 'i'),
            Trigram('e', 'k', 'a'),
            Trigram('a', ' ', 'k'),
            Trigram('r', 'a', 'k'),
            Trigram('k', 'e', 's'),
            Trigram('y', 'a', 't'),
            Trigram('i', 'b', 'a'),
            Trigram('n', 'a', 's'),
            Trigram('r', 'm', 'a'),
            Trigram('e', 'r', 'n'),
            Trigram('e', 's', 'e'),
            Trigram('s', ' ', 'p'),
            Trigram('n', 'u', 's'),
            Trigram(' ', 'p', 'u'),
            Trigram('a', 'n', 'u'),
            Trigram('i', 'n', 'a'),
            Trigram(' ', 't', 'a'),
            Trigram('m', 'e', 'l'),
            Trigram('m', 'u', 'a'),
            Trigram('k', 'e', 'l'),
            Trigram('k', ' ', 's'),
            Trigram('u', 's', ' '),
            Trigram('n', 'd', 'u'),
            Trigram('n', 'a', 'k'),
            Trigram('d', 'a', ' '),
            Trigram('s', 'y', 'a'),
            Trigram('d', 'a', 's'),
            Trigram('p', 'e', 'm'),
            Trigram('l', 'i', 'n'),
            Trigram('u', 't', ' '),
            Trigram('y', 'a', 'r'),
            Trigram('a', 'm', 'i'),
            Trigram('u', 'p', 'u'),
            Trigram('s', 'e', 'o'),
            Trigram('a', 'i', 'k'),
            Trigram('e', 'o', 'r'),
            Trigram('i', 'n', 'y'),
            Trigram('a', 'u', 'p'),
            Trigram('t', 'a', 'k'),
            Trigram('i', 'p', 'e'),
            Trigram('i', 'n', 'g'),
            Trigram('t', 'i', 'n'),
            Trigram(' ', 'a', 'n'),
            Trigram('d', 'i', 'k'),
            Trigram('u', 'a', 'r'),
            Trigram('i', 'l', 'i'),
            Trigram('g', ' ', 't'),
            Trigram('r', 's', 'e'),
            Trigram('s', 'a', 'r'),
            Trigram('a', 'n', 't'),
            Trigram('g', ' ', 'p'),
            Trigram('a', ' ', 'n'),
            Trigram('a', 'k', 's'),
            Trigram('a', 'i', 'n'),
            Trigram(' ', 'j', 'a'),
            Trigram('t', ' ', 'p'),
            Trigram(' ', 'u', 'm'),
            Trigram('g', ' ', 'm'),
            Trigram('d', 'i', 'r'),
            Trigram('k', 's', 'a'),
            Trigram('u', 'm', 'u'),
            Trigram('k', 'e', 'p'),
            Trigram('m', 'u', 'm'),
            Trigram('i', ' ', 'k'),
            Trigram('e', 'c', 'a'),
            Trigram('r', 'a', 't'),
            Trigram('m', ' ', 'p'),
            Trigram('h', ' ', 'p'),
            Trigram('a', 'b', 'a'),
            Trigram('s', 'e', 's'),
            Trigram('m', ' ', 'm'),
        ],
    ),
    (
        Lang::Fra,
        &[
            Trigram(' ', 'd', 'e'),
            Trigram('e', 's', ' '),
            Trigram('d', 'e', ' '),
            Trigram('i', 'o', 'n'),
            Trigram('n', 't', ' '),
            Trigram('e', 't', ' '),
            Trigram('t', 'i', 'o'),
            Trigram(' ', 'e', 't'),
            Trigram('e', 'n', 't'),
            Trigram(' ', 'l', 'a'),
            Trigram('l', 'a', ' '),
            Trigram('e', ' ', 'd'),
            Trigram('o', 'n', ' '),
            Trigram('n', 'e', ' '),
            Trigram('o', 'i', 't'),
            Trigram('e', ' ', 'l'),
            Trigram('l', 'e', ' '),
            Trigram(' ', 'l', 'e'),
            Trigram('s', ' ', 'd'),
            Trigram('e', ' ', 'p'),
            Trigram('t', ' ', 'd'),
            Trigram('a', 't', 'i'),
            Trigram('r', 'o', 'i'),
            Trigram(' ', 'd', 'r'),
            Trigram('d', 'r', 'o'),
            Trigram('i', 't', ' '),
            Trigram(' ', 'à', ' '),
            Trigram(' ', 'c', 'o'),
            Trigram('t', 'é', ' '),
            Trigram('n', 's', ' '),
            Trigram('t', 'e', ' '),
            Trigram('e', ' ', 's'),
            Trigram('m', 'e', 'n'),
            Trigram('r', 'e', ' '),
            Trigram(' ', 't', 'o'),
            Trigram('c', 'o', 'n'),
            Trigram(' ', 'l', '’'),
            Trigram('t', 'o', 'u'),
            Trigram('q', 'u', 'e'),
            Trigram(' ', 'q', 'u'),
            Trigram('l', 'e', 's'),
            Trigram(' ', 's', 'o'),
            Trigram('d', 'e', 's'),
            Trigram('s', 'o', 'n'),
            Trigram(' ', 'p', 'e'),
            Trigram('o', 'n', 's'),
            Trigram(' ', 'u', 'n'),
            Trigram('s', ' ', 'l'),
            Trigram('s', ' ', 'e'),
            Trigram(' ', 'p', 'r'),
            Trigram('u', 'e', ' '),
            Trigram(' ', 'p', 'a'),
            Trigram('e', ' ', 'c'),
            Trigram('t', ' ', 'l'),
            Trigram('t', 's', ' '),
            Trigram('o', 'n', 'n'),
            Trigram(' ', 'a', 'u'),
            Trigram('e', ' ', 'a'),
            Trigram('e', 'm', 'e'),
            Trigram('e', ' ', 'e'),
            Trigram(' ', 'l', 'i'),
            Trigram('o', 'n', 't'),
            Trigram('a', 'n', 't'),
            Trigram('o', 'u', 't'),
            Trigram('u', 't', 'e'),
            Trigram('t', ' ', 'à'),
            Trigram('r', 'e', 's'),
            Trigram('e', 'r', 's'),
            Trigram(' ', 's', 'a'),
            Trigram('c', 'e', ' '),
            Trigram(' ', 'a', ' '),
            Trigram('t', 'r', 'e'),
            Trigram('p', 'e', 'r'),
            Trigram('a', ' ', 'd'),
            Trigram('c', 't', 'i'),
            Trigram('e', 'r', ' '),
            Trigram('l', 'i', 'b'),
            Trigram('i', 't', 'é'),
            Trigram(' ', 'e', 'n'),
            Trigram('u', 'x', ' '),
            Trigram(' ', 'r', 'e'),
            Trigram('e', 'n', ' '),
            Trigram('r', 's', 'o'),
            Trigram('à', ' ', 'l'),
            Trigram(' ', 'o', 'u'),
            Trigram(' ', 'i', 'n'),
            Trigram('l', 'l', 'e'),
            Trigram('u', 'n', ' '),
            Trigram('n', 'a', 't'),
            Trigram('o', 'u', ' '),
            Trigram('n', 'n', 'e'),
            Trigram('n', ' ', 'd'),
            Trigram('u', 'n', 'e'),
            Trigram(' ', 'd', '’'),
            Trigram(' ', 's', 'e'),
            Trigram('p', 'a', 'r'),
            Trigram('n', 't', 'e'),
            Trigram('u', 's', ' '),
            Trigram('u', 'r', ' '),
            Trigram('s', ' ', 's'),
            Trigram('a', 'n', 's'),
            Trigram('d', 'a', 'n'),
            Trigram('a', ' ', 'p'),
            Trigram('r', ' ', 'l'),
            Trigram('p', 'r', 'o'),
            Trigram('i', 't', 's'),
            Trigram('é', 's', ' '),
            Trigram('t', ' ', 'p'),
            Trigram('i', 'r', 'e'),
            Trigram('e', ' ', 't'),
            Trigram('s', ' ', 'p'),
            Trigram('s', 'a', ' '),
            Trigram(' ', 'd', 'é'),
            Trigram('o', 'n', 'd'),
            Trigram('é', ' ', 'd'),
            Trigram('a', ' ', 'l'),
            Trigram('n', 'c', 'e'),
            Trigram('e', 'r', 't'),
            Trigram('a', 'u', 'x'),
            Trigram('o', 'm', 'm'),
            Trigram('n', 'a', 'l'),
            Trigram('m', 'e', ' '),
            Trigram(' ', 'n', 'a'),
            Trigram(' ', 'f', 'o'),
            Trigram('i', 'q', 'u'),
            Trigram(' ', 'c', 'e'),
            Trigram('r', 't', 'é'),
            Trigram('e', 'c', 't'),
            Trigram('a', 'l', 'e'),
            Trigram('b', 'e', 'r'),
            Trigram('t', ' ', 'a'),
            Trigram('s', ' ', 'a'),
            Trigram(' ', 'd', 'a'),
            Trigram('m', 'm', 'e'),
            Trigram('i', 'b', 'e'),
            Trigram('s', 'a', 'n'),
            Trigram('e', ' ', 'r'),
            Trigram(' ', 'p', 'o'),
            Trigram('c', 'o', 'm'),
            Trigram('a', 'l', ' '),
            Trigram('s', ' ', 'c'),
            Trigram('q', 'u', 'i'),
            Trigram('o', 'u', 'r'),
            Trigram('t', ' ', 'e'),
            Trigram(' ', 'n', 'e'),
            Trigram('e', ' ', 'n'),
            Trigram('o', 'u', 's'),
            Trigram('r', ' ', 'd'),
            Trigram('a', 'l', 'i'),
            Trigram('t', 'e', 'r'),
            Trigram(' ', 'd', 'i'),
            Trigram('f', 'o', 'n'),
            Trigram('e', ' ', 'o'),
            Trigram('a', 'u', ' '),
            Trigram(' ', 'c', 'h'),
            Trigram('a', 'i', 'r'),
            Trigram('u', 'i', ' '),
            Trigram('e', 'l', 'l'),
            Trigram(' ', 'e', 's'),
            Trigram('l', 'i', 't'),
            Trigram('s', ' ', 'n'),
            Trigram('i', 's', 's'),
            Trigram('é', 'r', 'a'),
            Trigram('t', 'e', 's'),
            Trigram('s', 'o', 'c'),
            Trigram('a', 'u', 't'),
            Trigram('o', 'c', 'i'),
            Trigram('ê', 't', 'r'),
            Trigram('i', 'e', 'n'),
            Trigram('i', 'n', 't'),
            Trigram('d', 'u', ' '),
            Trigram('e', 's', 't'),
            Trigram('é', 't', 'é'),
            Trigram('t', 'r', 'a'),
            Trigram('p', 'o', 'u'),
            Trigram(' ', 'p', 'l'),
            Trigram('r', 'a', 't'),
            Trigram('a', 'r', ' '),
            Trigram('r', 'a', 'n'),
            Trigram('r', 'a', 'i'),
            Trigram('s', ' ', 'o'),
            Trigram('o', 'n', 'a'),
            Trigram('a', 'i', 'n'),
            Trigram('c', 'l', 'a'),
            Trigram('é', 'g', 'a'),
            Trigram('a', 'n', 'c'),
            Trigram('r', 's', ' '),
            Trigram('e', 'u', 'r'),
            Trigram('p', 'r', 'i'),
            Trigram('n', ' ', 'c'),
            Trigram('e', ' ', 'm'),
            Trigram('s', ' ', 't'),
            Trigram('à', ' ', 'u'),
            Trigram(' ', 'd', 'o'),
            Trigram('u', 'r', 'e'),
            Trigram('b', 'r', 'e'),
            Trigram('u', 't', ' '),
            Trigram(' ', 'ê', 't'),
            Trigram('a', 'g', 'e'),
            Trigram(' ', 'é', 't'),
            Trigram('n', 's', 'i'),
            Trigram('s', 'u', 'r'),
            Trigram('e', 'i', 'n'),
            Trigram('s', 'e', 'n'),
            Trigram('s', 'e', 'r'),
            Trigram('n', 'd', 'i'),
            Trigram('e', 'n', 's'),
            Trigram('e', 's', 's'),
            Trigram('n', 't', 'r'),
            Trigram('i', 'r', ' '),
            Trigram(' ', 'm', 'a'),
            Trigram('c', 'i', 'a'),
            Trigram('n', ' ', 'p'),
            Trigram('s', 't', ' '),
            Trigram('a', ' ', 'c'),
            Trigram(' ', 'd', 'u'),
            Trigram('l', ' ', 'e'),
            Trigram(' ', 's', 'u'),
            Trigram('b', 'l', 'i'),
            Trigram('g', 'e', ' '),
            Trigram('r', 'é', 's'),
            Trigram(' ', 'r', 'é'),
            Trigram('e', ' ', 'q'),
            Trigram('a', 's', 's'),
            Trigram('n', 'd', 'a'),
            Trigram('p', 'e', 'u'),
            Trigram('é', 'e', ' '),
            Trigram('l', '’', 'a'),
            Trigram(' ', 't', 'e'),
            Trigram('a', ' ', 's'),
            Trigram('t', 'a', 't'),
            Trigram('i', 'l', ' '),
            Trigram('t', 'é', 's'),
            Trigram('a', 'i', 's'),
            Trigram('u', ' ', 'd'),
            Trigram('i', 'n', 'e'),
            Trigram('i', 'n', 'd'),
            Trigram('é', ' ', 'e'),
            Trigram('q', 'u', '’'),
            Trigram(' ', 'a', 'c'),
            Trigram('s', ' ', 'i'),
            Trigram('n', ' ', 't'),
            Trigram('t', ' ', 'c'),
            Trigram('n', ' ', 'a'),
            Trigram('l', '’', 'h'),
            Trigram('t', ' ', 'q'),
            Trigram('s', 'o', 'i'),
            Trigram('t', ' ', 's'),
            Trigram('c', 'u', 'n'),
            Trigram('r', 'i', 't'),
            Trigram(' ', 'é', 'g'),
            Trigram('o', 'i', 'r'),
            Trigram('’', 'e', 'n'),
            Trigram('n', 't', 'a'),
            Trigram('h', 'o', 'm'),
            Trigram(' ', 'o', 'n'),
            Trigram('n', ' ', 'e'),
            Trigram(' ', 'm', 'o'),
            Trigram('i', 'e', ' '),
            Trigram('i', 'g', 'n'),
            Trigram('r', 'e', 'l'),
            Trigram('n', 'n', 'a'),
            Trigram('t', ' ', 'i'),
            Trigram('l', ' ', 'n'),
            Trigram(' ', 't', 'r'),
            Trigram('i', 'l', 'l'),
            Trigram('p', 'l', 'e'),
            Trigram('s', ' ', 'é'),
            Trigram('l', '’', 'e'),
            Trigram('r', 'e', 'c'),
            Trigram('a', ' ', 'r'),
            Trigram('o', 't', 'e'),
            Trigram('s', 's', 'e'),
            Trigram('u', 'n', 'i'),
            Trigram('i', 'd', 'é'),
            Trigram('i', 'v', 'e'),
            Trigram('s', ' ', 'u'),
            Trigram('t', ' ', 'ê'),
            Trigram('i', 'n', 's'),
            Trigram('a', 'c', 't'),
            Trigram(' ', 'f', 'a'),
            Trigram('n', ' ', 's'),
            Trigram(' ', 'v', 'i'),
            Trigram('g', 'a', 'l'),
            Trigram(' ', 'a', 's'),
            Trigram('l', 'i', 'g'),
            Trigram('s', 's', 'a'),
            Trigram('p', 'r', 'é'),
            Trigram('l', 'e', 'u'),
            Trigram('e', ' ', 'f'),
            Trigram('l', 'i', 'c'),
            Trigram('d', 'i', 's'),
            Trigram('v', 'e', 'r'),
            Trigram(' ', 'n', 'u'),
            Trigram('t', 'e', 'n'),
            Trigram('s', 's', 'i'),
            Trigram('r', 'o', 't'),
            Trigram('t', 'e', 'c'),
            Trigram('s', ' ', 'm'),
            Trigram('a', 'b', 'l'),
        ],
    ),
    (
        Lang::Deu,
        &[
            Trigram('e', 'n', ' '),
            Trigram('e', 'r', ' '),
            Trigram('d', 'e', 'r'),
            Trigram(' ', 'u', 'n'),
            Trigram('n', 'd', ' '),
            Trigram('u', 'n', 'd'),
            Trigram('e', 'i', 'n'),
            Trigram('u', 'n', 'g'),
            Trigram('c', 'h', 't'),
            Trigram(' ', 'd', 'e'),
            Trigram('i', 'c', 'h'),
            Trigram('s', 'c', 'h'),
            Trigram('n', 'g', ' '),
            Trigram(' ', 'g', 'e'),
            Trigram('i', 'e', ' '),
            Trigram('c', 'h', 'e'),
            Trigram('e', 'c', 'h'),
            Trigram(' ', 'd', 'i'),
            Trigram('d', 'i', 'e'),
            Trigram('r', 'e', 'c'),
            Trigram('g', 'e', 'n'),
            Trigram('i', 'n', 'e'),
            Trigram('e', 'i', 't'),
            Trigram(' ', 'r', 'e'),
            Trigram('c', 'h', ' '),
            Trigram(' ', 'd', 'a'),
            Trigram('n', ' ', 'd'),
            Trigram('v', 'e', 'r'),
            Trigram('h', 'e', 'n'),
            Trigram(' ', 'z', 'u'),
            Trigram('t', ' ', 'd'),
            Trigram(' ', 'a', 'u'),
            Trigram('h', 't', ' '),
            Trigram(' ', 'h', 'a'),
            Trigram('l', 'i', 'c'),
            Trigram('i', 't', ' '),
            Trigram('t', 'e', 'n'),
            Trigram('r', 'e', 'i'),
            Trigram(' ', 'b', 'e'),
            Trigram('i', 'n', ' '),
            Trigram(' ', 'v', 'e'),
            Trigram(' ', 'i', 'n'),
            Trigram(' ', 'e', 'i'),
            Trigram('n', 'd', 'e'),
            Trigram('a', 'u', 'f'),
            Trigram('d', 'e', 'n'),
            Trigram('e', 'd', 'e'),
            Trigram('z', 'u', ' '),
            Trigram('n', ' ', 's'),
            Trigram('u', 'f', ' '),
            Trigram('f', 'r', 'e'),
            Trigram('n', 'e', ' '),
            Trigram('t', 'e', 'r'),
            Trigram('e', 's', ' '),
            Trigram(' ', 'j', 'e'),
            Trigram('j', 'e', 'd'),
            Trigram('n', ' ', 'u'),
            Trigram(' ', 'a', 'n'),
            Trigram('s', 'e', 'i'),
            Trigram('a', 'n', 'd'),
            Trigram(' ', 'f', 'r'),
            Trigram('r', 'u', 'n'),
            Trigram('a', 't', ' '),
            Trigram(' ', 's', 'e'),
            Trigram('e', ' ', 'u'),
            Trigram('d', 'a', 's'),
            Trigram('h', 'e', 'i'),
            Trigram('s', ' ', 'r'),
            Trigram('h', 't', 'e'),
            Trigram('h', 'a', 't'),
            Trigram('n', 's', 'c'),
            Trigram('n', 'g', 'e'),
            Trigram('r', ' ', 'h'),
            Trigram('a', 's', ' '),
            Trigram('e', 'n', 's'),
            Trigram(' ', 'a', 'l'),
            Trigram('e', 'r', 'e'),
            Trigram('l', 'l', 'e'),
            Trigram('t', ' ', 'a'),
            Trigram(' ', 'w', 'e'),
            Trigram('n', ' ', 'g'),
            Trigram('r', 'd', 'e'),
            Trigram('n', 't', 'e'),
            Trigram('e', 's', 'e'),
            Trigram('m', 'e', 'n'),
            Trigram(' ', 'o', 'd'),
            Trigram('o', 'd', 'e'),
            Trigram('n', 'e', 'r'),
            Trigram('g', ' ', 'd'),
            Trigram('a', 'l', 'l'),
            Trigram('t', ' ', 'u'),
            Trigram('e', 'r', 's'),
            Trigram('t', 'e', ' '),
            Trigram('n', 'e', 'n'),
            Trigram(' ', 's', 'o'),
            Trigram('d', ' ', 'd'),
            Trigram('n', ' ', 'a'),
            Trigram('b', 'e', 'n'),
            Trigram('l', 'e', 'i'),
            Trigram(' ', 'g', 'r'),
            Trigram(' ', 'v', 'o'),
            Trigram('w', 'e', 'r'),
            Trigram('e', ' ', 'a'),
            Trigram('e', 'g', 'e'),
            Trigram('i', 'o', 'n'),
            Trigram(' ', 's', 't'),
            Trigram('i', 'g', 'e'),
            Trigram('l', 'e', ' '),
            Trigram('c', 'h', 'a'),
            Trigram(' ', 'm', 'e'),
            Trigram('h', 'a', 'f'),
            Trigram('a', 'f', 't'),
            Trigram('n', ' ', 'j'),
            Trigram('r', 'e', 'n'),
            Trigram(' ', 'e', 'r'),
            Trigram('e', 'r', 'k'),
            Trigram('e', 'n', 't'),
            Trigram('b', 'e', 'i'),
            Trigram(' ', 's', 'i'),
            Trigram('e', 'i', 'h'),
            Trigram('i', 'h', 'e'),
            Trigram('k', 'e', 'i'),
            Trigram('e', 'r', 'd'),
            Trigram('t', 'i', 'g'),
            Trigram('n', ' ', 'i'),
            Trigram('o', 'n', ' '),
            Trigram('l', 'u', 'n'),
            Trigram('r', ' ', 'd'),
            Trigram('l', 'e', 'n'),
            Trigram('g', 'e', 'm'),
            Trigram('i', 'e', 's'),
            Trigram('g', 'r', 'u'),
            Trigram('t', 'l', 'i'),
            Trigram('u', 'n', 't'),
            Trigram('c', 'h', 'u'),
            Trigram('e', 'r', 'n'),
            Trigram('g', 'e', 's'),
            Trigram('e', 'n', 'd'),
            Trigram('e', ' ', 's'),
            Trigram('f', 't', ' '),
            Trigram('s', 't', ' '),
            Trigram('i', 's', 't'),
            Trigram('t', 'i', 'o'),
            Trigram('a', 't', 'i'),
            Trigram(' ', 'g', 'l'),
            Trigram('s', 't', 'a'),
            Trigram('g', 'u', 'n'),
            Trigram('m', 'i', 't'),
            Trigram('s', 'e', 'n'),
            Trigram('n', ' ', 'n'),
            Trigram(' ', 'n', 'a'),
            Trigram('n', ' ', 'z'),
            Trigram('i', 't', 'e'),
            Trigram(' ', 'w', 'i'),
            Trigram('r', ' ', 'g'),
            Trigram('e', 'i', 'c'),
            Trigram('e', ' ', 'e'),
            Trigram('e', 'i', ' '),
            Trigram('l', 'i', 'e'),
            Trigram('r', ' ', 's'),
            Trigram('n', ' ', 'w'),
            Trigram('g', 'l', 'e'),
            Trigram('m', 'e', 'i'),
            Trigram('d', 'e', ' '),
            Trigram('u', 'c', 'h'),
            Trigram('e', 'm', ' '),
            Trigram('c', 'h', 'l'),
            Trigram('n', 'a', 't'),
            Trigram('r', 'c', 'h'),
            Trigram('t', ' ', 'w'),
            Trigram('d', 'e', 's'),
            Trigram('n', ' ', 'e'),
            Trigram('h', 'r', 'e'),
            Trigram('a', 'l', 'e'),
            Trigram('s', 'p', 'r'),
            Trigram('d', ' ', 'f'),
            Trigram('a', 'c', 'h'),
            Trigram('s', 's', 'e'),
            Trigram('r', ' ', 'e'),
            Trigram(' ', 's', 'c'),
            Trigram('u', 'r', 'c'),
            Trigram('r', ' ', 'm'),
            Trigram('n', 'i', 'e'),
            Trigram('e', ' ', 'f'),
            Trigram('f', 'e', 'n'),
            Trigram('e', ' ', 'g'),
            Trigram('e', ' ', 'd'),
            Trigram(' ', 'n', 'i'),
            Trigram('d', 'u', 'r'),
            Trigram('d', 'a', 'r'),
            Trigram('i', 'n', 't'),
            Trigram(' ', 'd', 'u'),
            Trigram('g', 'e', 'h'),
            Trigram('i', 'e', 'd'),
            Trigram('t', ' ', 's'),
            Trigram(' ', 'm', 'i'),
            Trigram('a', 'l', 't'),
            Trigram('h', 'e', 'r'),
            Trigram('h', 'a', 'b'),
            Trigram('f', ' ', 'g'),
            Trigram('s', 'i', 'c'),
            Trigram('s', 't', 'e'),
            Trigram('t', 'a', 'a'),
            Trigram('a', 'a', 't'),
            Trigram('h', 'e', ' '),
            Trigram('a', 'n', 'g'),
            Trigram('r', 'u', 'c'),
            Trigram('h', 'l', 'i'),
            Trigram('t', 'z', ' '),
            Trigram('e', 'm', 'e'),
            Trigram('a', 'b', 'e'),
            Trigram('h', ' ', 'a'),
            Trigram('n', ' ', 'v'),
            Trigram('n', 'u', 'n'),
            Trigram('g', 'e', 'g'),
            Trigram('a', 'r', 'f'),
            Trigram('r', 'f', ' '),
            Trigram('e', 'h', 'e'),
            Trigram('p', 'r', 'u'),
            Trigram(' ', 'i', 's'),
            Trigram('e', 'r', 'f'),
            Trigram('e', ' ', 'm'),
            Trigram('a', 'n', 's'),
            Trigram('n', 'd', 'l'),
            Trigram('e', ' ', 'b'),
            Trigram('t', 'u', 'n'),
            Trigram('n', ' ', 'o'),
            Trigram('d', ' ', 'g'),
            Trigram('n', ' ', 'r'),
            Trigram('r', ' ', 'v'),
            Trigram('w', 'i', 'e'),
            Trigram('b', 'e', 'r'),
            Trigram('r', ' ', 'a'),
            Trigram('a', 'r', 'b'),
            Trigram('b', 'e', 's'),
            Trigram('t', ' ', 'i'),
            Trigram('h', ' ', 'd'),
            Trigram('r', ' ', 'w'),
            Trigram('r', ' ', 'b'),
            Trigram(' ', 'i', 'h'),
            Trigram('d', ' ', 's'),
            Trigram('i', 'g', 'k'),
            Trigram('g', 'k', 'e'),
            Trigram('n', 's', 'p'),
            Trigram('d', 'i', 'g'),
            Trigram('e', 'm', 'a'),
            Trigram('e', 'l', 'l'),
            Trigram('e', 'r', 'u'),
            Trigram('n', ' ', 'f'),
            Trigram('i', 'n', 's'),
            Trigram('r', 'b', 'e'),
            Trigram('f', 'f', 'e'),
            Trigram('e', 's', 'c'),
            Trigram('i', 'g', 'u'),
            Trigram('g', 'e', 'r'),
            Trigram('s', 't', 'r'),
            Trigram('k', 'e', 'n'),
            Trigram('e', ' ', 'v'),
            Trigram('g', 'e', 'w'),
            Trigram('h', 'a', 'n'),
            Trigram('i', 'n', 'd'),
            Trigram('r', 't', ' '),
            Trigram(' ', 'a', 'r'),
            Trigram('i', 'e', 'ß'),
            Trigram('n', ' ', 'h'),
            Trigram('r', 'n', ' '),
            Trigram('m', 'a', 'n'),
            Trigram('r', ' ', 'i'),
            Trigram('h', 'u', 't'),
            Trigram('u', 't', 'z'),
            Trigram('d', ' ', 'a'),
            Trigram('l', 's', ' '),
            Trigram('e', 'b', 'e'),
            Trigram('v', 'o', 'n'),
            Trigram('l', 't', 'e'),
            Trigram('r', ' ', 'o'),
            Trigram('r', 'l', 'i'),
            Trigram('e', 't', 'z'),
            Trigram('t', 'r', 'a'),
            Trigram('a', 'u', 's'),
            Trigram('d', 'e', 't'),
            Trigram('h', 'u', 'l'),
            Trigram('e', ' ', 'i'),
            Trigram('o', 'n', 'e'),
            Trigram('n', 'n', 'e'),
            Trigram('i', 's', 'c'),
            Trigram('s', 'o', 'n'),
            Trigram('s', 'e', 'l'),
            Trigram('e', 't', ' '),
            Trigram('o', 'h', 'n'),
            Trigram('t', ' ', 'g'),
            Trigram('s', 'a', 'm'),
            Trigram(' ', 'f', 'a'),
            Trigram('r', 's', 't'),
            Trigram('r', 'k', 'l'),
            Trigram('s', 'e', 'r'),
            Trigram('i', 'e', 'm'),
            Trigram('g', ' ', 'v'),
            Trigram('t', ' ', 'z'),
            Trigram('e', 'r', 'r'),
        ],
    ),
    (
        Lang::Jav,
        &[
            Trigram('n', 'g', ' '),
            Trigram('a', 'n', ' '),
            Trigram('a', 'n', 'g'),
            Trigram(' ', 'k', 'a'),
            Trigram('i', 'n', 'g'),
            Trigram('k', 'a', 'n'),
            Trigram(' ', 's', 'a'),
            Trigram('a', 'k', ' '),
            Trigram('l', 'a', 'n'),
            Trigram(' ', 'l', 'a'),
            Trigram('h', 'a', 'k'),
            Trigram(' ', 'h', 'a'),
            Trigram(' ', 'p', 'a'),
            Trigram(' ', 'm', 'a'),
            Trigram('n', 'g', 'g'),
            Trigram('a', 'r', 'a'),
            Trigram('s', 'a', ' '),
            Trigram('a', 'b', 'e'),
            Trigram('n', 'e', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram('n', ' ', 'k'),
            Trigram('a', 'n', 't'),
            Trigram(' ', 'n', 'g'),
            Trigram('t', 'a', 'n'),
            Trigram('n', 'i', 'n'),
            Trigram(' ', 'a', 'n'),
            Trigram('n', 'g', 'a'),
            Trigram('a', 't', 'a'),
            Trigram('e', 'n', ' '),
            Trigram('r', 'a', 'n'),
            Trigram(' ', 'b', 'a'),
            Trigram('m', 'a', 'n'),
            Trigram('b', 'a', 'n'),
            Trigram('a', 'n', 'e'),
            Trigram('h', 'i', ' '),
            Trigram('n', ' ', 'u'),
            Trigram('o', 'n', 'g'),
            Trigram('r', 'a', ' '),
            Trigram('n', 't', 'h'),
            Trigram('a', 'k', 'e'),
            Trigram('k', 'e', ' '),
            Trigram('t', 'h', 'i'),
            Trigram(' ', 'd', 'a'),
            Trigram('w', 'o', 'n'),
            Trigram('u', 'w', 'o'),
            Trigram('u', 'n', 'g'),
            Trigram('n', 'g', 's'),
            Trigram(' ', 'u', 'w'),
            Trigram('a', 's', 'a'),
            Trigram('g', 's', 'a'),
            Trigram('b', 'e', 'n'),
            Trigram('s', 'a', 'b'),
            Trigram('a', 'n', 'a'),
            Trigram('a', 'k', 'a'),
            Trigram('b', 'e', 'b'),
            Trigram('a', ' ', 'k'),
            Trigram('g', ' ', 'p'),
            Trigram('n', 'a', 'n'),
            Trigram('n', 'd', 'a'),
            Trigram('a', 'd', 'i'),
            Trigram('a', 't', ' '),
            Trigram('a', 'w', 'a'),
            Trigram('s', 'a', 'n'),
            Trigram('n', 'i', ' '),
            Trigram('d', 'a', 'n'),
            Trigram('g', ' ', 'k'),
            Trigram('p', 'a', 'n'),
            Trigram('e', 'b', 'a'),
            Trigram(' ', 'b', 'e'),
            Trigram('e', ' ', 'k'),
            Trigram('g', ' ', 's'),
            Trigram('a', 'n', 'i'),
            Trigram('b', 'a', 's'),
            Trigram(' ', 'p', 'r'),
            Trigram('d', 'h', 'a'),
            Trigram('a', 'y', 'a'),
            Trigram('g', 'a', 'n'),
            Trigram('y', 'a', ' '),
            Trigram('w', 'a', ' '),
            Trigram('d', 'i', ' '),
            Trigram('m', 'a', 'r'),
            Trigram('n', ' ', 's'),
            Trigram(' ', 'w', 'a'),
            Trigram('t', 'a', ' '),
            Trigram('a', ' ', 's'),
            Trigram('g', ' ', 'u'),
            Trigram(' ', 'n', 'a'),
            Trigram('e', ' ', 'h'),
            Trigram('a', 'r', 'b'),
            Trigram('a', ' ', 'n'),
            Trigram('a', ' ', 'b'),
            Trigram('a', ' ', 'l'),
            Trigram('n', ' ', 'n'),
            Trigram(' ', 'u', 't'),
            Trigram('y', 'a', 'n'),
            Trigram('n', ' ', 'p'),
            Trigram('a', 's', 'i'),
            Trigram('g', ' ', 'd'),
            Trigram('h', 'a', 'n'),
            Trigram('a', 'h', ' '),
            Trigram('g', ' ', 'n'),
            Trigram(' ', 't', 'u'),
            Trigram(' ', 'u', 'm'),
            Trigram('a', 's', ' '),
            Trigram('w', 'e', 'n'),
            Trigram('d', 'a', 'k'),
            Trigram('r', 'b', 'e'),
            Trigram('d', 'a', 'r'),
            Trigram(' ', 'd', 'i'),
            Trigram('g', 'g', 'o'),
            Trigram('s', 'a', 'r'),
            Trigram('m', 'a', 't'),
            Trigram('k', ' ', 'h'),
            Trigram('a', ' ', 'a'),
            Trigram('i', 'y', 'a'),
            Trigram(' ', 'u', 'n'),
            Trigram('u', 'n', 'd'),
            Trigram('e', 'n', 'i'),
            Trigram('k', 'a', 'b'),
            Trigram('b', 'e', ' '),
            Trigram('a', 'r', 't'),
            Trigram('k', 'a', ' '),
            Trigram('u', 'm', 'a'),
            Trigram('o', 'r', 'a'),
            Trigram('n', ' ', 'b'),
            Trigram('a', 'l', 'a'),
            Trigram('n', ' ', 'm'),
            Trigram('n', 'g', 'k'),
            Trigram('r', 't', 'a'),
            Trigram('i', ' ', 'h'),
            Trigram(' ', 'o', 'r'),
            Trigram('g', 'a', 'r'),
            Trigram('y', 'a', 't'),
            Trigram('k', 'a', 'r'),
            Trigram('a', 'l', ' '),
            Trigram('a', ' ', 'm'),
            Trigram('n', ' ', 'i'),
            Trigram('n', 'a', ' '),
            Trigram('g', ' ', 'b'),
            Trigram('e', 'g', 'a'),
            Trigram('p', 'r', 'a'),
            Trigram('i', 'n', 'a'),
            Trigram('k', 'a', 'k'),
            Trigram('g', ' ', 'a'),
            Trigram('a', ' ', 'p'),
            Trigram('t', 'u', 'm'),
            Trigram('n', 'y', 'a'),
            Trigram('k', 'a', 'l'),
            Trigram('g', 'e', 'r'),
            Trigram('g', 'g', 'e'),
            Trigram(' ', 't', 'a'),
            Trigram('k', 'a', 't'),
            Trigram('i', ' ', 'k'),
            Trigram('e', 'n', 'a'),
            Trigram('o', 'n', 'i'),
            Trigram('k', 'a', 's'),
            Trigram(' ', 'p', 'e'),
            Trigram('d', 'a', 'd'),
            Trigram('a', 'g', 'a'),
            Trigram('g', ' ', 'm'),
            Trigram('d', 'u', 'w'),
            Trigram('k', ' ', 'k'),
            Trigram('u', 't', 'a'),
            Trigram('u', 'w', 'e'),
            Trigram(' ', 's', 'i'),
            Trigram(' ', 'n', 'e'),
            Trigram('a', 'd', 'h'),
            Trigram('p', 'a', ' '),
            Trigram('n', ' ', 'a'),
            Trigram('g', 'o', ' '),
            Trigram('a', 'n', 'd'),
            Trigram('i', ' ', 'l'),
            Trigram(' ', 'k', 'e'),
            Trigram('n', 'u', 'n'),
            Trigram('n', 'a', 'l'),
            Trigram('n', 'g', 'u'),
            Trigram('u', 'j', 'u'),
            Trigram('a', 'p', 'a'),
            Trigram('a', ' ', 'd'),
            Trigram('t', ' ', 'm'),
            Trigram('i', ' ', 'p'),
            Trigram('m', 'i', 'n'),
            Trigram('i', 'b', 'a'),
            Trigram('e', 'r', ' '),
            Trigram(' ', 'l', 'i'),
            Trigram('a', 'n', 'u'),
            Trigram('s', 'a', 'k'),
            Trigram('p', 'e', 'r'),
            Trigram('a', 'm', 'a'),
            Trigram('g', 'a', 'y'),
            Trigram('w', 'a', 'r'),
            Trigram('p', 'a', 'd'),
            Trigram('g', 'g', 'u'),
            Trigram('h', 'a', ' '),
            Trigram('i', 'n', 'd'),
            Trigram('t', 'a', 'w'),
            Trigram('r', 'a', 's'),
            Trigram('n', ' ', 'l'),
            Trigram('a', 'l', 'i'),
            Trigram('e', 'n', 'g'),
            Trigram('a', 'w', 'i'),
            Trigram('a', ' ', 'u'),
            Trigram(' ', 'b', 'i'),
            Trigram('w', 'e', ' '),
            Trigram('b', 'a', 'd'),
            Trigram('n', 'd', 'u'),
            Trigram('u', 'w', 'a'),
            Trigram('a', 'w', 'e'),
            Trigram('b', 'a', 'k'),
            Trigram('a', 's', 'e'),
            Trigram('e', 'h', ' '),
            Trigram(' ', 'm', 'e'),
            Trigram('n', 'e', 'g'),
            Trigram('p', 'r', 'i'),
            Trigram(' ', 'k', 'u'),
            Trigram('r', 'o', 'n'),
            Trigram('i', 'h', ' '),
            Trigram('g', ' ', 't'),
            Trigram('b', 'i', 's'),
            Trigram('i', 'j', 'i'),
            Trigram('i', ' ', 't'),
            Trigram('e', ' ', 'p'),
            Trigram(' ', 'p', 'i'),
            Trigram('a', 'b', 'a'),
            Trigram('i', 's', 'a'),
            Trigram('m', 'b', 'a'),
            Trigram('i', 'n', 'i'),
            Trigram('a', ' ', 'w'),
            Trigram('g', ' ', 'l'),
            Trigram('i', 'k', 'a'),
            Trigram('n', ' ', 't'),
            Trigram('e', 'b', 'u'),
            Trigram('n', 'd', 'h'),
            Trigram('a', 'r', ' '),
            Trigram('s', 'i', 'n'),
            Trigram('l', 'a', 'k'),
            Trigram('u', 'r', ' '),
            Trigram('m', 'r', 'a'),
            Trigram('m', 'e', 'n'),
            Trigram('k', 'u', ' '),
            Trigram(' ', 'w', 'e'),
            Trigram('e', ' ', 's'),
            Trigram('a', ' ', 'i'),
            Trigram('l', 'i', 'y'),
            Trigram(' ', 'i', 'k'),
            Trigram('a', 'y', 'o'),
            Trigram('r', 'i', 'b'),
            Trigram('n', 'g', 'l'),
            Trigram('a', 'm', 'i'),
            Trigram('a', 'r', 'g'),
            Trigram('n', 'a', 's'),
            Trigram('y', 'o', 'm'),
            Trigram('w', 'a', 'e'),
            Trigram('u', 't', ' '),
            Trigram('k', 'o', 'n'),
            Trigram('a', 'e', ' '),
            Trigram('r', 'a', 'p'),
            Trigram('a', 'k', 'u'),
            Trigram(' ', 't', 'e'),
            Trigram('d', 'i', 'l'),
            Trigram('t', 'i', 'n'),
            Trigram('r', 'g', 'a'),
            Trigram('j', 'u', 'd'),
            Trigram('u', 'm', 'u'),
            Trigram(' ', 'a', 's'),
            Trigram('r', 'a', 'k'),
            Trigram('b', 'e', 'd'),
            Trigram('k', ' ', 'b'),
            Trigram('i', 'l', ' '),
            Trigram('k', 'a', 'p'),
            Trigram('h', ' ', 'k'),
            Trigram('j', 'i', 'n'),
            Trigram('k', ' ', 'a'),
            Trigram(' ', 'n', 'd'),
            Trigram('e', ' ', 'd'),
            Trigram('i', ' ', 's'),
            Trigram(' ', 'l', 'u'),
            Trigram('i', ' ', 'w'),
            Trigram('e', 'k', 'a'),
            Trigram('m', 'u', 'm'),
            Trigram('u', 'm', ' '),
            Trigram('u', 'h', 'a'),
            Trigram('a', 't', 'e'),
            Trigram(' ', 'm', 'i'),
            Trigram('k', ' ', 'p'),
            Trigram('g', 'o', 'n'),
            Trigram('e', 'd', 'a'),
            Trigram(' ', 't', 'i'),
            Trigram('b', 'u', 't'),
            Trigram('n', ' ', 'd'),
            Trigram('r', ' ', 'k'),
            Trigram('o', 'n', 'a'),
            Trigram('u', 't', 'o'),
            Trigram('t', 'o', 'w'),
            Trigram('w', 'a', 't'),
            Trigram('g', 'k', 'a'),
            Trigram('s', 'i', ' '),
            Trigram('u', 'm', 'r'),
            Trigram('k', ' ', 'l'),
            Trigram('o', 'm', 'a'),
        ],
    ),
    (
        Lang::Vie,
        &[
            Trigram('n', 'g', ' '),
            Trigram('̣', 'c', ' '),
            Trigram('́', 'c', ' '),
            Trigram(' ', 'q', 'u'),
            Trigram(' ', 't', 'h'),
            Trigram('a', '̀', ' '),
            Trigram('n', 'h', ' '),
            Trigram(' ', 'n', 'g'),
            Trigram('̣', 'i', ' '),
            Trigram(' ', 'n', 'h'),
            Trigram('v', 'a', '̀'),
            Trigram(' ', 'v', 'a'),
            Trigram('̀', 'n', ' '),
            Trigram('u', 'y', 'ê'),
            Trigram(' ', 'p', 'h'),
            Trigram(' ', 'c', 'a'),
            Trigram('q', 'u', 'y'),
            Trigram('ê', '̀', 'n'),
            Trigram('y', 'ê', '̀'),
            Trigram('̀', 'i', ' '),
            Trigram(' ', 'c', 'h'),
            Trigram('̀', 'n', 'h'),
            Trigram(' ', 't', 'r'),
            Trigram(' ', 'c', 'u'),
            Trigram('n', 'g', 'ư'),
            Trigram('i', ' ', 'n'),
            Trigram('g', 'ư', 'ơ'),
            Trigram('ư', 'ơ', '̀'),
            Trigram('́', 't', ' '),
            Trigram('ơ', '̀', 'i'),
            Trigram(' ', 'g', 'i'),
            Trigram('a', '́', 'c'),
            Trigram(' ', 'c', 'o'),
            Trigram('̣', 't', ' '),
            Trigram('o', '́', ' '),
            Trigram('c', ' ', 't'),
            Trigram('ư', '̣', ' '),
            Trigram('n', ' ', 't'),
            Trigram('c', 'a', '́'),
            Trigram('ô', 'n', 'g'),
            Trigram(' ', 'k', 'h'),
            Trigram('ư', 'ơ', '̣'),
            Trigram('ơ', '̣', 'c'),
            Trigram(' ', 't', 'ư'),
            Trigram(' ', 'đ', 'ư'),
            Trigram('i', 'ê', '̣'),
            Trigram('đ', 'ư', 'ơ'),
            Trigram('i', '̀', 'n'),
            Trigram('́', 'i', ' '),
            Trigram(' ', 'h', 'a'),
            Trigram('c', 'o', '́'),
            Trigram('i', ' ', 'đ'),
            Trigram('g', 'i', 'a'),
            Trigram(' ', 'đ', 'ê'),
            Trigram('p', 'h', 'a'),
            Trigram(' ', 'm', 'o'),
            Trigram('o', '̣', 'i'),
            Trigram('m', 'o', '̣'),
            Trigram('n', 'h', 'ư'),
            Trigram('n', ' ', 'n'),
            Trigram('c', 'u', '̉'),
            Trigram(' ', 'b', 'a'),
            Trigram('̣', 'n', ' '),
            Trigram('̉', 'a', ' '),
            Trigram('u', '̉', 'a'),
            Trigram('n', ' ', 'c'),
            Trigram('̀', 'u', ' '),
            Trigram('̃', 'n', 'g'),
            Trigram('â', 'n', ' '),
            Trigram('ê', '̀', 'u'),
            Trigram('â', '́', 't'),
            Trigram(' ', 'b', 'i'),
            Trigram('t', 'ư', '̣'),
            Trigram('h', 'ô', 'n'),
            Trigram(' ', 'v', 'i'),
            Trigram('g', ' ', 't'),
            Trigram(' ', 'l', 'a'),
            Trigram('n', ' ', 'đ'),
            Trigram('đ', 'ê', '̀'),
            Trigram('n', 'h', 'â'),
            Trigram(' ', 't', 'i'),
            Trigram('t', ' ', 'c'),
            Trigram(' ', 'đ', 'ô'),
            Trigram('ê', 'n', ' '),
            Trigram('b', 'a', '̉'),
            Trigram('h', 'i', 'ê'),
            Trigram('u', ' ', 'c'),
            Trigram(' ', 't', 'ô'),
            Trigram('d', 'o', ' '),
            Trigram('h', 'â', 'n'),
            Trigram(' ', 'd', 'o'),
            Trigram('c', 'h', ' '),
            Trigram('́', ' ', 'q'),
            Trigram('̀', ' ', 't'),
            Trigram(' ', 'n', 'a'),
            Trigram('́', 'n', ' '),
            Trigram('a', 'y', ' '),
            Trigram(' ', 'h', 'i'),
            Trigram('a', '̀', 'n'),
            Trigram('̣', ' ', 'd'),
            Trigram('ơ', '́', 'i'),
            Trigram('h', 'a', '́'),
            Trigram(' ', 'đ', 'i'),
            Trigram('h', 'a', 'y'),
            Trigram('g', ' ', 'n'),
            Trigram(' ', 'm', 'ô'),
            Trigram('ô', '́', 'c'),
            Trigram('u', 'ô', '́'),
            Trigram('n', ' ', 'v'),
            Trigram('ô', '̣', 'i'),
            Trigram('h', 'ư', '̃'),
            Trigram('t', 'h', 'ư'),
            Trigram('́', 'p', ' '),
            Trigram('q', 'u', 'ô'),
            Trigram(' ', 'h', 'o'),
            Trigram('̣', 'p', ' '),
            Trigram('n', 'a', '̀'),
            Trigram('a', '̀', 'o'),
            Trigram('̀', 'n', 'g'),
            Trigram('̉', 'n', ' '),
            Trigram('i', '̣', ' '),
            Trigram('́', 'c', 'h'),
            Trigram('ô', 'n', ' '),
            Trigram('̀', 'o', ' '),
            Trigram('k', 'h', 'ô'),
            Trigram('c', ' ', 'h'),
            Trigram('i', ' ', 'c'),
            Trigram('c', ' ', 'đ'),
            Trigram(' ', 'h', 'ô'),
            Trigram('i', ' ', 'v'),
            Trigram('t', 'r', 'o'),
            Trigram(' ', 'đ', 'a'),
            Trigram('́', 'n', 'g'),
            Trigram('m', 'ô', '̣'),
            Trigram('i', ' ', 't'),
            Trigram('ô', '̣', 't'),
            Trigram('g', ' ', 'v'),
            Trigram('i', 'a', ' '),
            Trigram('̣', 'n', 'g'),
            Trigram('a', '̉', 'n'),
            Trigram('ư', 'ơ', '́'),
            Trigram('ư', '̃', 'n'),
            Trigram('̉', 'n', 'g'),
            Trigram('h', ' ', 't'),
            Trigram('h', 'ư', ' '),
            Trigram('ê', '̣', 'n'),
            Trigram('n', ' ', 'b'),
            Trigram('ô', '̣', 'c'),
            Trigram('a', '̉', ' '),
            Trigram('l', 'a', '̀'),
            Trigram('c', ' ', 'c'),
            Trigram('g', ' ', 'c'),
            Trigram(' ', 'đ', 'o'),
            Trigram('̉', ' ', 'c'),
            Trigram('n', ' ', 'h'),
            Trigram('h', 'a', '̀'),
            Trigram('h', 'ô', '̣'),
            Trigram(' ', 'b', 'â'),
            Trigram('a', '̃', ' '),
            Trigram('̀', 'y', ' '),
            Trigram(' ', 'v', 'ơ'),
            Trigram('̣', ' ', 't'),
            Trigram('̉', 'i', ' '),
            Trigram('i', 'ê', '́'),
            Trigram(' ', 'c', 'ô'),
            Trigram('t', ' ', 't'),
            Trigram('g', ' ', 'đ'),
            Trigram('ư', '́', 'c'),
            Trigram('i', 'ê', 'n'),
            Trigram(' ', 'v', 'ê'),
            Trigram('v', 'i', 'ê'),
            Trigram('v', 'ơ', '́'),
            Trigram('h', ' ', 'v'),
            Trigram('ơ', '́', 'c'),
            Trigram('ư', '̣', 'c'),
            Trigram('â', '̣', 't'),
            Trigram('t', 'h', 'a'),
            Trigram('̉', 'm', ' '),
            Trigram('r', 'o', 'n'),
            Trigram('o', 'n', 'g'),
            Trigram('a', '́', 'p'),
            Trigram('g', ' ', 'b'),
            Trigram('h', 'ư', 'ơ'),
            Trigram(' ', 's', 'ư'),
            Trigram('a', ' ', 'c'),
            Trigram('s', 'ư', '̣'),
            Trigram('̉', 'o', ' '),
            Trigram('a', '̉', 'o'),
            Trigram('h', ' ', 'c'),
            Trigram('ê', '̉', ' '),
            Trigram('o', ' ', 'v'),
            Trigram('u', 'â', '̣'),
            Trigram('a', ' ', 'm'),
            Trigram('ê', '́', ' '),
            Trigram('i', 'a', '́'),
            Trigram('̀', ' ', 'c'),
            Trigram('c', 'h', 'o'),
            Trigram('q', 'u', 'a'),
            Trigram('h', 'a', '̣'),
            Trigram('u', '̣', 'c'),
            Trigram(' ', 'm', 'i'),
            Trigram('̀', ' ', 'n'),
            Trigram('p', 'h', 'â'),
            Trigram('c', ' ', 'q'),
            Trigram('c', 'ô', 'n'),
            Trigram('o', ' ', 'c'),
            Trigram('a', '́', ' '),
            Trigram('i', ' ', 'h'),
            Trigram('a', '̣', 'i'),
            Trigram(' ', 'h', 'ơ'),
            Trigram('̃', ' ', 'h'),
            Trigram(' ', 'c', 'ư'),
            Trigram('n', ' ', 'l'),
            Trigram('b', 'i', '̣'),
            Trigram(' ', 'l', 'u'),
            Trigram('b', 'â', '́'),
            Trigram('c', 'a', '̉'),
            Trigram('i', '́', 'n'),
            Trigram('h', ' ', 'đ'),
            Trigram(' ', 'x', 'a'),
            Trigram('đ', 'ô', '̣'),
            Trigram('g', ' ', 'h'),
            Trigram('c', ' ', 'n'),
            Trigram('c', ' ', 'p'),
            Trigram('t', 'h', 'u'),
            Trigram('a', '̉', 'i'),
            Trigram('ê', '̣', ' '),
            Trigram(' ', 'h', 'ư'),
            Trigram('́', ' ', 'c'),
            Trigram('o', ' ', 'n'),
            Trigram(' ', 'n', 'ư'),
            Trigram('ô', '́', 'n'),
            Trigram('́', 'o', ' '),
            Trigram('a', '́', 'o'),
            Trigram('x', 'a', '̃'),
            Trigram('o', 'a', '̀'),
            Trigram('y', ' ', 't'),
            Trigram('h', 'a', '̉'),
            Trigram('t', 'ô', '̣'),
            Trigram('̣', ' ', 'c'),
            Trigram(' ', 't', 'â'),
            Trigram('t', 'h', 'ô'),
            Trigram(' ', 'd', 'u'),
            Trigram('m', ' ', 'v'),
            Trigram('m', 'i', '̀'),
            Trigram('h', 'o', ' '),
            Trigram('h', 'ư', '́'),
            Trigram('ê', '̣', 'c'),
            Trigram('́', ' ', 't'),
            Trigram('h', 'ơ', '̣'),
            Trigram('a', '́', 'n'),
            Trigram('n', ' ', 'p'),
            Trigram('c', 'u', '̃'),
            Trigram('u', '̃', 'n'),
            Trigram('i', 'ê', '̉'),
            Trigram('ô', '́', 'i'),
            Trigram('t', 'i', 'ê'),
            Trigram('ê', '̀', ' '),
            Trigram('h', 'â', '́'),
            Trigram('ơ', '̣', 'p'),
            Trigram('h', 'o', 'a'),
            Trigram('y', ' ', 'đ'),
            Trigram('c', 'h', 'i'),
            Trigram('o', ' ', 'h'),
            Trigram('ơ', '̉', ' '),
            Trigram('a', '̀', 'y'),
            Trigram('̉', ' ', 't'),
            Trigram('đ', 'o', '́'),
            Trigram('c', ' ', 'l'),
            Trigram('v', 'ê', '̀'),
            Trigram('̀', ' ', 'đ'),
            Trigram('i', ' ', 'b'),
            Trigram('k', 'h', 'a'),
            Trigram('c', ' ', 'b'),
            Trigram(' ', 'đ', 'â'),
            Trigram('l', 'u', 'â'),
            Trigram('a', 'i', ' '),
            Trigram('̉', ' ', 'n'),
            Trigram('đ', 'ô', '́'),
            Trigram('ê', '́', 't'),
            Trigram('h', 'ư', '̣'),
            Trigram('t', 'r', 'i'),
            Trigram('p', ' ', 'q'),
            Trigram('n', 'ư', 'ơ'),
            Trigram('d', 'u', '̣'),
            Trigram('h', 'i', '́'),
            Trigram('g', ' ', 'q'),
            Trigram('y', 'ê', 'n'),
            Trigram('h', 'o', '̣'),
            Trigram('́', 'n', 'h'),
            Trigram(' ', 't', 'a'),
            Trigram(' ', 'b', 'ă'),
            Trigram('c', ' ', 'g'),
            Trigram('n', ' ', 'g'),
            Trigram('t', 'h', 'ê'),
            Trigram('o', ' ', 't'),
            Trigram('c', ' ', 'v'),
            Trigram('a', 'm', ' '),
            Trigram('c', ' ', 'm'),
            Trigram('a', 'n', ' '),
        ],
    ),
    (
        Lang::Ita,
        &[
            Trigram(' ', 'd', 'i'),
            Trigram('t', 'o', ' '),
            Trigram(' ', 'd', 'e'),
            Trigram('i', 'o', 'n'),
            Trigram(' ', 'i', 'n'),
            Trigram('l', 'a', ' '),
            Trigram('e', ' ', 'd'),
            Trigram('d', 'i', ' '),
            Trigram('n', 'e', ' '),
            Trigram(' ', 'e', ' '),
            Trigram('z', 'i', 'o'),
            Trigram('r', 'e', ' '),
            Trigram('l', 'e', ' '),
            Trigram('n', 'i', ' '),
            Trigram('e', 'l', 'l'),
            Trigram('o', 'n', 'e'),
            Trigram('l', 'l', 'a'),
            Trigram('r', 'i', 't'),
            Trigram('a', ' ', 'd'),
            Trigram('o', ' ', 'd'),
            Trigram('d', 'e', 'l'),
            Trigram('i', 't', 't'),
            Trigram('i', 'r', 'i'),
            Trigram('d', 'i', 'r'),
            Trigram(' ', 'c', 'o'),
            Trigram('t', 'i', ' '),
            Trigram('e', 's', 's'),
            Trigram('e', 'n', 't'),
            Trigram(' ', 'a', 'l'),
            Trigram('a', 'z', 'i'),
            Trigram('t', 't', 'o'),
            Trigram('t', 'e', ' '),
            Trigram('i', ' ', 'd'),
            Trigram('i', ' ', 'i'),
            Trigram('e', 'r', 'e'),
            Trigram('t', 'à', ' '),
            Trigram(' ', 'p', 'r'),
            Trigram('n', 'd', 'i'),
            Trigram('e', ' ', 'l'),
            Trigram('a', 'l', 'e'),
            Trigram('o', ' ', 'a'),
            Trigram('i', 'n', 'd'),
            Trigram('e', ' ', 'e'),
            Trigram('e', ' ', 'i'),
            Trigram('g', 'n', 'i'),
            Trigram('n', 't', 'e'),
            Trigram('c', 'o', 'n'),
            Trigram('i', ' ', 'e'),
            Trigram('l', 'i', ' '),
            Trigram('a', ' ', 's'),
            Trigram(' ', 'u', 'n'),
            Trigram('m', 'e', 'n'),
            Trigram('o', 'g', 'n'),
            Trigram(' ', 'n', 'e'),
            Trigram('u', 'o', ' '),
            Trigram(' ', 'o', 'g'),
            Trigram('i', 'd', 'u'),
            Trigram('e', ' ', 'a'),
            Trigram('i', 'v', 'i'),
            Trigram('d', 'u', 'o'),
            Trigram('v', 'i', 'd'),
            Trigram(' ', 'e', 's'),
            Trigram('t', 't', 'i'),
            Trigram(' ', 'h', 'a'),
            Trigram('d', 'i', 'v'),
            Trigram(' ', 'l', 'i'),
            Trigram('a', ' ', 'p'),
            Trigram('n', 'o', ' '),
            Trigram('a', 'l', 'l'),
            Trigram('p', 'r', 'o'),
            Trigram('z', 'a', ' '),
            Trigram('a', 't', 'o'),
            Trigram('p', 'e', 'r'),
            Trigram('s', 's', 'e'),
            Trigram('s', 'e', 'r'),
            Trigram(' ', 's', 'o'),
            Trigram('i', ' ', 's'),
            Trigram(' ', 'l', 'a'),
            Trigram(' ', 's', 'u'),
            Trigram('e', ' ', 'p'),
            Trigram(' ', 'p', 'e'),
            Trigram('i', 'b', 'e'),
            Trigram('n', 'a', ' '),
            Trigram('a', ' ', 'l'),
            Trigram(' ', 'i', 'l'),
            Trigram('b', 'e', 'r'),
            Trigram('e', ' ', 'n'),
            Trigram('i', 'l', ' '),
            Trigram('a', 'l', 'i'),
            Trigram('l', 'i', 'b'),
            Trigram('h', 'a', ' '),
            Trigram('c', 'h', 'e'),
            Trigram('i', 'n', ' '),
            Trigram('o', ' ', 's'),
            Trigram('e', ' ', 's'),
            Trigram(' ', 'q', 'u'),
            Trigram('o', ' ', 'e'),
            Trigram('i', 'a', ' '),
            Trigram('e', ' ', 'c'),
            Trigram(' ', 'r', 'i'),
            Trigram('n', 'z', 'a'),
            Trigram('t', 'a', ' '),
            Trigram('n', 't', 'o'),
            Trigram('h', 'e', ' '),
            Trigram('o', 'n', 'i'),
            Trigram('o', ' ', 'i'),
            Trigram(' ', 'o', ' '),
            Trigram('s', 't', 'a'),
            Trigram('o', ' ', 'c'),
            Trigram('n', 'e', 'l'),
            Trigram(' ', 'a', ' '),
            Trigram('o', ' ', 'p'),
            Trigram('n', 'a', 'z'),
            Trigram('e', ' ', 'o'),
            Trigram('s', 'o', ' '),
            Trigram(' ', 'p', 'o'),
            Trigram('o', ' ', 'h'),
            Trigram('g', 'l', 'i'),
            Trigram('i', ' ', 'u'),
            Trigram('o', 'n', 'd'),
            Trigram('i', ' ', 'c'),
            Trigram('e', 'r', 's'),
            Trigram('a', 'm', 'e'),
            Trigram('i', ' ', 'p'),
            Trigram('l', 'l', 'e'),
            Trigram('u', 'n', ' '),
            Trigram('e', 'r', 'a'),
            Trigram('r', 'i', ' '),
            Trigram('v', 'e', 'r'),
            Trigram('r', 'o', ' '),
            Trigram('e', 'l', ' '),
            Trigram('u', 'n', 'a'),
            Trigram('a', ' ', 'c'),
            Trigram(' ', 'c', 'h'),
            Trigram('e', 'r', 't'),
            Trigram('u', 'a', ' '),
            Trigram('i', ' ', 'a'),
            Trigram('s', 's', 'i'),
            Trigram('r', 't', 'à'),
            Trigram('a', ' ', 'e'),
            Trigram('e', 'i', ' '),
            Trigram('d', 'i', 's'),
            Trigram('a', 'n', 't'),
            Trigram(' ', 'l', ' '),
            Trigram('t', 'a', 't'),
            Trigram('a', ' ', 'a'),
            Trigram('o', 'n', 'a'),
            Trigram('u', 'a', 'l'),
            Trigram(' ', 'l', 'e'),
            Trigram('i', 't', 'à'),
            Trigram('a', 'r', 'e'),
            Trigram('t', 'e', 'r'),
            Trigram(' ', 'a', 'd'),
            Trigram('n', 'i', 't'),
            Trigram(' ', 'd', 'a'),
            Trigram('p', 'r', 'i'),
            Trigram('d', 'e', 'i'),
            Trigram('à', ' ', 'e'),
            Trigram('c', 'i', 'a'),
            Trigram(' ', 's', 't'),
            Trigram(' ', 's', 'i'),
            Trigram('n', 'a', 'l'),
            Trigram('e', 's', 't'),
            Trigram('t', 'u', 't'),
            Trigram('i', 's', 't'),
            Trigram('c', 'o', 'm'),
            Trigram('u', 'n', 'i'),
            Trigram(' ', 'e', 'd'),
            Trigram('o', 'n', 'o'),
            Trigram(' ', 'n', 'a'),
            Trigram('s', 'u', 'a'),
            Trigram('a', 'l', ' '),
            Trigram('s', 'i', ' '),
            Trigram('a', 'n', 'z'),
            Trigram(' ', 'p', 'a'),
            Trigram(' ', 'r', 'e'),
            Trigram('r', 'a', 'z'),
            Trigram('g', 'u', 'a'),
            Trigram('i', 't', 'a'),
            Trigram('r', 'e', 's'),
            Trigram('d', 'e', 'r'),
            Trigram('s', 'o', 'c'),
            Trigram('m', 'a', 'n'),
            Trigram('o', ' ', 'o'),
            Trigram('a', 'd', ' '),
            Trigram('i', ' ', 'o'),
            Trigram('e', 's', 'e'),
            Trigram('q', 'u', 'e'),
            Trigram('e', 'n', 'z'),
            Trigram('e', 'd', ' '),
            Trigram(' ', 's', 'e'),
            Trigram('i', 'o', ' '),
            Trigram('e', 't', 't'),
            Trigram('o', 'n', ' '),
            Trigram(' ', 't', 'u'),
            Trigram('d', 'i', 'c'),
            Trigram('à', ' ', 'd'),
            Trigram('s', 'i', 'a'),
            Trigram('i', ' ', 'r'),
            Trigram('r', 's', 'o'),
            Trigram('o', 'c', 'i'),
            Trigram('r', 'i', 'o'),
            Trigram('a', 'r', 'i'),
            Trigram('q', 'u', 'a'),
            Trigram('i', 'a', 'l'),
            Trigram('p', 'r', 'e'),
            Trigram('i', 'c', 'h'),
            Trigram('r', 'a', 't'),
            Trigram('i', 'e', 'n'),
            Trigram('t', 'r', 'a'),
            Trigram('a', 'n', 'i'),
            Trigram('u', 'm', 'a'),
            Trigram('s', 'e', ' '),
            Trigram('l', 'l', ' '),
            Trigram('e', 'r', 'i'),
            Trigram('a', ' ', 'n'),
            Trigram('o', ' ', 'n'),
            Trigram(' ', 'u', 'm'),
            Trigram('d', 'o', ' '),
            Trigram('a', 'r', 'a'),
            Trigram('a', ' ', 't'),
            Trigram('z', 'z', 'a'),
            Trigram('e', 'r', ' '),
            Trigram('t', 'r', 'i'),
            Trigram('a', 't', 't'),
            Trigram('i', 'c', 'o'),
            Trigram('p', 'o', 's'),
            Trigram('s', 'c', 'i'),
            Trigram('i', ' ', 'l'),
            Trigram('s', 'o', 'n'),
            Trigram('n', 'd', 'a'),
            Trigram('p', 'a', 'r'),
            Trigram('e', ' ', 'u'),
            Trigram('f', 'o', 'n'),
            Trigram(' ', 'f', 'o'),
            Trigram('n', 't', 'i'),
            Trigram('u', 'z', 'i'),
            Trigram('s', 't', 'r'),
            Trigram('u', 't', 't'),
            Trigram('a', 't', 'i'),
            Trigram('s', 'e', 'n'),
            Trigram('i', 'n', 't'),
            Trigram('n', 'e', 's'),
            Trigram('i', 'a', 'r'),
            Trigram(' ', 'i', ' '),
            Trigram('h', 'i', 'a'),
            Trigram('n', ' ', 'c'),
            Trigram('s', 't', 'i'),
            Trigram('c', 'h', 'i'),
            Trigram('a', 'n', 'n'),
            Trigram('r', 'a', ' '),
            Trigram(' ', 'e', 'g'),
            Trigram('e', 'g', 'u'),
            Trigram('i', 's', 'p'),
            Trigram('b', 'i', 'l'),
            Trigram('o', 'n', 't'),
            Trigram('a', ' ', 'r'),
            Trigram(' ', 'n', 'o'),
            Trigram('r', 'o', 'p'),
            Trigram(' ', 'm', 'e'),
            Trigram('o', 'p', 'r'),
            Trigram('o', 's', 't'),
            Trigram(' ', 'm', 'a'),
            Trigram('u', 'e', 's'),
            Trigram('i', 'c', 'a'),
            Trigram('s', 's', 'o'),
            Trigram('t', 'a', 'l'),
            Trigram('c', 'i', 'e'),
            Trigram('s', 'u', 'n'),
            Trigram('l', 'i', 't'),
            Trigram('o', 'r', 'e'),
            Trigram('i', 'n', 'a'),
            Trigram('i', 't', 'e'),
            Trigram('t', 'a', 'n'),
            Trigram(' ', 'r', 'a'),
            Trigram('n', 'o', 'n'),
            Trigram('g', 'i', 'o'),
            Trigram('d', ' ', 'a'),
            Trigram('e', ' ', 'r'),
            Trigram('d', 'e', 'v'),
            Trigram('i', ' ', 'm'),
            Trigram('l', ' ', 'i'),
            Trigram('e', 'z', 'z'),
            Trigram('i', 'z', 'i'),
            Trigram(' ', 'c', 'u'),
            Trigram('n', 'n', 'o'),
            Trigram('r', 'à', ' '),
            Trigram('a', ' ', 'i'),
            Trigram('t', 't', 'a'),
            Trigram('r', 'i', 'a'),
            Trigram('l', 'i', 'a'),
            Trigram('c', 'o', 's'),
            Trigram('s', 's', 'u'),
            Trigram('d', 'a', 'l'),
            Trigram('l', ' ', 'p'),
            Trigram(' ', 'a', 's'),
            Trigram('a', 's', 's'),
            Trigram('o', 'p', 'o'),
            Trigram('v', 'e', ' '),
            Trigram('e', 'v', 'e'),
        ],
    ),
    (
        Lang::Tur,
        &[
            Trigram(' ', 'v', 'e'),
            Trigram(' ', 'h', 'a'),
            Trigram('v', 'e', ' '),
            Trigram('l', 'e', 'r'),
            Trigram('l', 'a', 'r'),
            Trigram('i', 'r', ' '),
            Trigram('i', 'n', ' '),
            Trigram('h', 'a', 'k'),
            Trigram(' ', 'h', 'e'),
            Trigram('h', 'e', 'r'),
            Trigram('b', 'i', 'r'),
            Trigram('e', 'r', ' '),
            Trigram('a', 'n', ' '),
            Trigram('a', 'r', 'ı'),
            Trigram('e', 'r', 'i'),
            Trigram('y', 'a', ' '),
            Trigram(' ', 'b', 'i'),
            Trigram('a', 'k', ' '),
            Trigram('r', ' ', 'h'),
            Trigram('e', 't', 'i'),
            Trigram('ı', 'n', ' '),
            Trigram('i', 'y', 'e'),
            Trigram('y', 'e', 't'),
            Trigram(' ', 'k', 'a'),
            Trigram('a', 's', 'ı'),
            Trigram('ı', 'n', 'ı'),
            Trigram(' ', 'o', 'l'),
            Trigram('t', 'l', 'e'),
            Trigram('e', 'y', 'a'),
            Trigram('k', 'k', 'ı'),
            Trigram('a', 'r', 'a'),
            Trigram('a', 'k', 'k'),
            Trigram('e', 't', 'l'),
            Trigram('s', 'ı', 'n'),
            Trigram('e', 's', 'i'),
            Trigram('n', 'a', ' '),
            Trigram('d', 'e', ' '),
            Trigram('e', 'k', ' '),
            Trigram(' ', 't', 'a'),
            Trigram('n', 'd', 'a'),
            Trigram('i', 'n', 'i'),
            Trigram(' ', 'b', 'u'),
            Trigram('i', 'l', 'e'),
            Trigram('r', 'ı', 'n'),
            Trigram('r', 'i', 'n'),
            Trigram('v', 'e', 'y'),
            Trigram('n', 'e', ' '),
            Trigram('k', 'l', 'a'),
            Trigram('e', ' ', 'h'),
            Trigram('i', 'n', 'e'),
            Trigram('ı', 'r', ' '),
            Trigram('e', 'r', 'e'),
            Trigram('a', 'm', 'a'),
            Trigram('d', 'ı', 'r'),
            Trigram('n', ' ', 'h'),
            Trigram(' ', 's', 'a'),
            Trigram('ı', 'n', 'a'),
            Trigram('s', 'i', 'n'),
            Trigram('e', ' ', 'k'),
            Trigram('l', 'e', ' '),
            Trigram(' ', 'g', 'e'),
            Trigram('m', 'a', 's'),
            Trigram('ı', 'n', 'd'),
            Trigram('n', 'ı', 'n'),
            Trigram('ı', ' ', 'v'),
            Trigram(' ', 'v', 'a'),
            Trigram('l', 'a', 'n'),
            Trigram('l', 'm', 'a'),
            Trigram('e', 'r', 'k'),
            Trigram('r', 'k', 'e'),
            Trigram('n', 'm', 'a'),
            Trigram('t', 'i', 'n'),
            Trigram('r', 'l', 'e'),
            Trigram(' ', 't', 'e'),
            Trigram('n', 'i', 'n'),
            Trigram('a', 'k', 'l'),
            Trigram('a', ' ', 'v'),
            Trigram('d', 'a', ' '),
            Trigram(' ', 'd', 'e'),
            Trigram('l', 'e', 't'),
            Trigram('i', 'l', 'l'),
            Trigram('e', ' ', 'm'),
            Trigram('a', 'r', 'd'),
            Trigram('e', 'n', ' '),
            Trigram('r', 'i', 'y'),
            Trigram('a', 'y', 'a'),
            Trigram('n', 'ı', ' '),
            Trigram(' ', 'h', 'ü'),
            Trigram(' ', 'ş', 'a'),
            Trigram('e', ' ', 'b'),
            Trigram('k', ' ', 'v'),
            Trigram('k', 'ı', 'n'),
            Trigram('k', ' ', 'h'),
            Trigram(' ', 'm', 'e'),
            Trigram('m', 'i', 'l'),
            Trigram('s', 'a', 'n'),
            Trigram(' ', 'i', 'l'),
            Trigram('s', 'i', ' '),
            Trigram('r', 'd', 'ı'),
            Trigram('e', ' ', 'd'),
            Trigram('d', 'a', 'n'),
            Trigram('h', 'ü', 'r'),
            Trigram('v', 'a', 'r'),
            Trigram('a', 'n', 'a'),
            Trigram('e', ' ', 'a'),
            Trigram('k', 'e', 's'),
            Trigram('e', 't', ' '),
            Trigram('m', 'e', 's'),
            Trigram('ş', 'a', 'h'),
            Trigram('d', 'i', 'r'),
            Trigram(' ', 'm', 'i'),
            Trigram('r', 'e', 't'),
            Trigram('r', 'r', 'i'),
            Trigram(' ', 's', 'e'),
            Trigram('o', 'l', 'a'),
            Trigram('ü', 'r', 'r'),
            Trigram('i', 'r', 'l'),
            Trigram('b', 'u', ' '),
            Trigram('m', 'a', 'k'),
            Trigram(' ', 'm', 'a'),
            Trigram('m', 'e', 'k'),
            Trigram('n', ' ', 'e'),
            Trigram('k', 'ı', ' '),
            Trigram('n', ' ', 'v'),
            Trigram('n', ' ', 'i'),
            Trigram('l', 'i', 'k'),
            Trigram('l', 'l', 'e'),
            Trigram(' ', 'e', 'd'),
            Trigram(' ', 'h', 'i'),
            Trigram('n', ' ', 'b'),
            Trigram('a', ' ', 'h'),
            Trigram(' ', 'b', 'a'),
            Trigram('n', 's', 'a'),
            Trigram(' ', 'i', 'ş'),
            Trigram('e', 'l', 'i'),
            Trigram('k', 'a', 'r'),
            Trigram(' ', 'i', 'ç'),
            Trigram('ı', ' ', 'h'),
            Trigram('a', 'l', 'a'),
            Trigram('l', 'i', ' '),
            Trigram('u', 'l', 'u'),
            Trigram('r', 'a', 'k'),
            Trigram('e', 'v', 'l'),
            Trigram('e', ' ', 'i'),
            Trigram('n', 'i', ' '),
            Trigram('r', 'e', ' '),
            Trigram('r', ' ', 'ş'),
            Trigram('e', 'm', 'e'),
            Trigram('e', 't', 'm'),
            Trigram('e', ' ', 't'),
            Trigram('i', 'k', ' '),
            Trigram('e', ' ', 's'),
            Trigram('a', ' ', 'b'),
            Trigram('i', 'ş', ' '),
            Trigram('n', ' ', 'k'),
            Trigram('h', 'a', 'i'),
            Trigram('n', 'd', 'e'),
            Trigram('a', 'i', 'z'),
            Trigram(' ', 'e', 'ş'),
            Trigram('i', 'z', 'd'),
            Trigram('u', 'n', ' '),
            Trigram('o', 'l', 'm'),
            Trigram('h', 'i', 'ç'),
            Trigram('z', 'd', 'i'),
            Trigram('a', 'r', ' '),
            Trigram('u', 'n', 'm'),
            Trigram('m', 'a', ' '),
            Trigram(' ', 'g', 'ö'),
            Trigram('i', 'l', 'm'),
            Trigram('l', 'm', 'e'),
            Trigram('i', 'm', ' '),
            Trigram('n', ' ', 't'),
            Trigram('t', 'i', 'r'),
            Trigram('d', 'i', 'l'),
            Trigram('m', 'a', 'l'),
            Trigram('e', ' ', 'g'),
            Trigram('i', ' ', 'v'),
            Trigram(' ', 'k', 'o'),
            Trigram('l', 'u', 'n'),
            Trigram('e', ' ', 'e'),
            Trigram('m', 'e', 'l'),
            Trigram('k', 'e', 't'),
            Trigram('ı', 'k', ' '),
            Trigram('n', ' ', 's'),
            Trigram('e', 'l', 'e'),
            Trigram('l', 'a', ' '),
            Trigram('e', 'l', ' '),
            Trigram('r', ' ', 'v'),
            Trigram('e', 'd', 'e'),
            Trigram('ş', 'i', 't'),
            Trigram('i', 'l', 'i'),
            Trigram('e', 'ş', 'i'),
            Trigram('y', 'l', 'a'),
            Trigram('a', ' ', 'i'),
            Trigram(' ', 'a', 'n'),
            Trigram('a', 'n', 'ı'),
            Trigram(' ', 'e', 't'),
            Trigram('r', 'ı', ' '),
            Trigram('a', 'h', 's'),
            Trigram(' ', 'y', 'a'),
            Trigram('s', 'ı', ' '),
            Trigram('e', 'd', 'i'),
            Trigram('s', 'i', 'y'),
            Trigram('t', ' ', 'v'),
            Trigram('i', ' ', 'b'),
            Trigram('s', 'e', ' '),
            Trigram('i', 'ç', 'i'),
            Trigram('ç', 'i', 'n'),
            Trigram('b', 'u', 'l'),
            Trigram('a', 'm', 'e'),
            Trigram(' ', 'd', 'a'),
            Trigram('m', 'i', 'ş'),
            Trigram('m', 'a', 'y'),
            Trigram('t', 'i', 'm'),
            Trigram('a', ' ', 'k'),
            Trigram('t', 'm', 'e'),
            Trigram('r', ' ', 'b'),
            Trigram('i', 'n', 's'),
            Trigram('y', 'a', 'n'),
            Trigram('n', 'l', 'a'),
            Trigram('m', 'l', 'e'),
            Trigram(' ', 'd', 'i'),
            Trigram('e', 'y', 'e'),
            Trigram('g', 'e', 'r'),
            Trigram('y', 'e', ' '),
            Trigram('u', 'ğ', 'u'),
            Trigram('e', 'r', 'd'),
            Trigram('d', 'i', 'n'),
            Trigram('s', 'e', 'r'),
            Trigram(' ', 'm', 'ü'),
            Trigram('m', 'e', 'm'),
            Trigram('v', 'l', 'e'),
            Trigram(' ', 'k', 'e'),
            Trigram('n', 'a', 'm'),
            Trigram('i', 'n', 'd'),
            Trigram('l', 'e', 'n'),
            Trigram('e', 'k', 'e'),
            Trigram('e', 's', ' '),
            Trigram(' ', 'k', 'i'),
            Trigram('n', ' ', 'm'),
            Trigram('i', 't', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram(' ', 'k', 'u'),
            Trigram('r', 'ş', 'ı'),
            Trigram('a', ' ', 's'),
            Trigram('a', 'r', 'ş'),
            Trigram(' ', 'a', 'y'),
            Trigram('e', 'm', 'l'),
            Trigram('l', 'e', 'k'),
            Trigram('o', 'r', 'u'),
            Trigram('r', 'm', 'e'),
            Trigram('k', 'o', 'r'),
            Trigram('r', 'd', 'e'),
            Trigram('i', ' ', 'm'),
            Trigram(' ', 's', 'o'),
            Trigram('t', 'ü', 'r'),
            Trigram('a', 'l', ' '),
            Trigram('l', 'a', 'm'),
            Trigram('e', 'n', 'i'),
            Trigram('n', 'u', 'n'),
            Trigram(' ', 'u', 'y'),
            Trigram('k', 'e', 'n'),
            Trigram('h', 's', 'ı'),
            Trigram('i', ' ', 'i'),
            Trigram('a', ' ', 'd'),
            Trigram('r', 'i', ' '),
            Trigram('d', 'e', 'v'),
            Trigram('ü', 'n', ' '),
            Trigram('a', ' ', 'm'),
            Trigram('r', ' ', 'a'),
            Trigram('m', 'e', 'y'),
            Trigram('c', 'a', 'k'),
            Trigram('ı', 'y', 'l'),
            Trigram('m', 'a', 'z'),
            Trigram('e', ' ', 'v'),
            Trigram('e', 'c', 'e'),
            Trigram('a', 'd', 'e'),
            Trigram('i', 'ç', ' '),
            Trigram('ş', 'm', 'a'),
            Trigram('m', 's', 'e'),
            Trigram('t', 'e', ' '),
            Trigram('t', 'ü', 'n'),
            Trigram('i', 'm', 's'),
            Trigram('k', 'i', 'm'),
            Trigram('e', ' ', 'y'),
            Trigram('ş', 'ı', ' '),
            Trigram('e', 'n', 'd'),
            Trigram('k', ' ', 'g'),
            Trigram('n', 'd', 'i'),
            Trigram('a', 'l', 'ı'),
            Trigram(' ', 'c', 'e'),
            Trigram('l', 'e', 'm'),
            Trigram('ö', 'ğ', 'r'),
            Trigram('ü', 't', 'ü'),
            Trigram('k', ' ', 'i'),
            Trigram('r', ' ', 't'),
            Trigram(' ', 'ö', 'ğ'),
            Trigram('b', 'ü', 't'),
            Trigram('a', 'n', 'l'),
            Trigram(' ', 'b', 'ü'),
        ],
    ),
    (
        Lang::Pol,
        &[
            Trigram(' ', 'p', 'r'),
            Trigram('n', 'i', 'e'),
            Trigram(' ', 'i', ' '),
            Trigram('i', 'e', ' '),
            Trigram('p', 'r', 'a'),
            Trigram(' ', 'p', 'o'),
            Trigram('a', 'n', 'i'),
            Trigram('r', 'a', 'w'),
            Trigram('i', 'a', ' '),
            Trigram('n', 'i', 'a'),
            Trigram('w', 'i', 'e'),
            Trigram('g', 'o', ' '),
            Trigram(' ', 'd', 'o'),
            Trigram('c', 'h', ' '),
            Trigram('e', 'g', 'o'),
            Trigram('i', 'e', 'k'),
            Trigram('o', 'w', 'i'),
            Trigram(' ', 'n', 'i'),
            Trigram('ś', 'c', 'i'),
            Trigram('c', 'i', ' '),
            Trigram('a', ' ', 'p'),
            Trigram('d', 'o', ' '),
            Trigram('a', 'w', 'o'),
            Trigram(' ', 'c', 'z'),
            Trigram('o', 'ś', 'c'),
            Trigram('y', 'c', 'h'),
            Trigram(' ', 'm', 'a'),
            Trigram('e', 'k', ' '),
            Trigram('r', 'z', 'e'),
            Trigram(' ', 'n', 'a'),
            Trigram('p', 'r', 'z'),
            Trigram(' ', 'w', ' '),
            Trigram('w', 'o', ' '),
            Trigram('e', 'j', ' '),
            Trigram(' ', 'z', 'a'),
            Trigram('n', 'o', 'ś'),
            Trigram('c', 'z', 'ł'),
            Trigram('z', 'ł', 'o'),
            Trigram('e', 'n', 'i'),
            Trigram('w', 'a', ' '),
            Trigram(' ', 'j', 'e'),
            Trigram('ł', 'o', 'w'),
            Trigram('i', ' ', 'p'),
            Trigram('w', 'o', 'l'),
            Trigram('o', 'l', 'n'),
            Trigram(' ', 'l', 'u'),
            Trigram('r', 'o', 'd'),
            Trigram(' ', 'k', 'a'),
            Trigram(' ', 'w', 'o'),
            Trigram('l', 'n', 'o'),
            Trigram('w', 's', 'z'),
            Trigram('y', ' ', 'c'),
            Trigram('m', 'a', ' '),
            Trigram('n', 'y', ' '),
            Trigram('k', 'a', 'ż'),
            Trigram('a', 'ż', 'd'),
            Trigram('o', ' ', 'd'),
            Trigram('s', 't', 'w'),
            Trigram('o', 'w', 'a'),
            Trigram('d', 'y', ' '),
            Trigram('ż', 'd', 'y'),
            Trigram(' ', 'w', 'y'),
            Trigram('r', 'z', 'y'),
            Trigram('s', 't', 'a'),
            Trigram('e', 'c', 'z'),
            Trigram(' ', 's', 'w'),
            Trigram('d', 'z', 'i'),
            Trigram('i', ' ', 'w'),
            Trigram('e', ' ', 'p'),
            Trigram('c', 'z', 'n'),
            Trigram('t', 'w', 'a'),
            Trigram('n', 'a', ' '),
            Trigram('z', 'y', 's'),
            Trigram('ó', 'w', ' '),
            Trigram('s', 'z', 'y'),
            Trigram('u', 'b', ' '),
            Trigram('l', 'u', 'b'),
            Trigram('a', ' ', 'w'),
            Trigram('e', 's', 't'),
            Trigram('k', 'i', 'e'),
            Trigram('k', ' ', 'm'),
            Trigram('w', 'a', 'n'),
            Trigram(' ', 's', 'p'),
            Trigram('a', 'j', 'ą'),
            Trigram(' ', 'w', 's'),
            Trigram('e', ' ', 'w'),
            Trigram('p', 'o', 'w'),
            Trigram('p', 'o', 's'),
            Trigram('n', 'y', 'c'),
            Trigram('r', 'a', 'c'),
            Trigram('s', 'p', 'o'),
            Trigram('a', 'ć', ' '),
            Trigram('a', ' ', 'i'),
            Trigram('c', 'z', 'e'),
            Trigram('s', 'z', 'e'),
            Trigram('n', 'e', 'g'),
            Trigram('y', 's', 't'),
            Trigram('j', 'a', 'k'),
            Trigram(' ', 'j', 'a'),
            Trigram('o', ' ', 'p'),
            Trigram('p', 'o', 'd'),
            Trigram('a', 'c', 'j'),
            Trigram('n', 'e', ' '),
            Trigram('ń', 's', 't'),
            Trigram('a', 'r', 'o'),
            Trigram('m', 'i', ' '),
            Trigram(' ', 'z', ' '),
            Trigram('i', ' ', 'i'),
            Trigram('n', 'a', 'r'),
            Trigram(' ', 'k', 'o'),
            Trigram('o', 'b', 'o'),
            Trigram('a', 'w', 'a'),
            Trigram(' ', 'r', 'o'),
            Trigram('i', ' ', 'n'),
            Trigram('j', 'ą', 'c'),
            Trigram('z', 'e', 'c'),
            Trigram('z', 'n', 'e'),
            Trigram('z', 'a', 'n'),
            Trigram('d', 'o', 'w'),
            Trigram(' ', 'r', 'ó'),
            Trigram('i', 'e', 'j'),
            Trigram('z', 'y', ' '),
            Trigram('z', 'e', 'n'),
            Trigram('n', 'i', 'c'),
            Trigram('o', 'n', 'y'),
            Trigram('a', 'w', ' '),
            Trigram('i', ' ', 'z'),
            Trigram('c', 'z', 'y'),
            Trigram('n', 'o', ' '),
            Trigram('n', 'e', 'j'),
            Trigram('o', ' ', 's'),
            Trigram('r', 'ó', 'w'),
            Trigram('o', 'd', 'n'),
            Trigram('c', 'y', ' '),
            Trigram('ó', 'w', 'n'),
            Trigram('o', 'd', 'z'),
            Trigram('o', ' ', 'w'),
            Trigram('o', ' ', 'z'),
            Trigram('j', 'e', 'g'),
            Trigram('e', 'd', 'n'),
            Trigram('o', ' ', 'o'),
            Trigram('a', 'k', 'i'),
            Trigram('m', 'i', 'e'),
            Trigram('i', 'e', 'n'),
            Trigram('k', 'o', 'l'),
            Trigram(' ', 'i', 'n'),
            Trigram('z', 'i', 'e'),
            Trigram('b', 'e', 'z'),
            Trigram('a', 'm', 'i'),
            Trigram('e', 'ń', 's'),
            Trigram('o', 'w', 'o'),
            Trigram('d', 'n', 'o'),
            Trigram(' ', 'o', 'b'),
            Trigram(' ', 'o', 'r'),
            Trigram(' ', 's', 't'),
            Trigram('a', ' ', 's'),
            Trigram('n', 'i', ' '),
            Trigram('o', 'r', 'z'),
            Trigram('o', ' ', 'u'),
            Trigram('y', 'm', ' '),
            Trigram('s', 't', 'ę'),
            Trigram('t', 'ę', 'p'),
            Trigram('ł', 'e', 'c'),
            Trigram('j', 'e', 'd'),
            Trigram('i', ' ', 'k'),
            Trigram(' ', 'o', 's'),
            Trigram('w', ' ', 'c'),
            Trigram('l', 'w', 'i'),
            Trigram('e', 'z', ' '),
            Trigram('o', 'l', 'w'),
            Trigram('o', 'ł', 'e'),
            Trigram('p', 'o', 'ł'),
            Trigram('c', 'j', 'i'),
            Trigram('y', ' ', 'w'),
            Trigram('o', ' ', 'n'),
            Trigram('w', 'i', 'a'),
            Trigram(' ', 'b', 'e'),
            Trigram('k', 't', 'ó'),
            Trigram('a', ' ', 'j'),
            Trigram('z', 'n', 'a'),
            Trigram('z', 'y', 'n'),
            Trigram('o', 'w', 'e'),
            Trigram('w', 'o', 'b'),
            Trigram('k', 'a', ' '),
            Trigram('w', 'y', 'c'),
            Trigram('o', 'w', 'y'),
            Trigram('j', 'i', ' '),
            Trigram(' ', 'o', 'd'),
            Trigram('a', 'l', 'n'),
            Trigram('i', 'n', 'n'),
            Trigram('j', 'e', 's'),
            Trigram('i', 'c', 'z'),
            Trigram('h', ' ', 'p'),
            Trigram('i', ' ', 's'),
            Trigram('s', 'i', 'ę'),
            Trigram('a', ' ', 'o'),
            Trigram('j', 'ą', ' '),
            Trigram('o', 's', 't'),
            Trigram('k', 'r', 'a'),
            Trigram('s', 't', ' '),
            Trigram('s', 'z', 'a'),
            Trigram('s', 'w', 'o'),
            Trigram('w', 'a', 'r'),
            Trigram('c', 'z', 'a'),
            Trigram('r', 'o', 'z'),
            Trigram('y', ' ', 's'),
            Trigram('r', 'a', 'z'),
            Trigram('n', 'i', 'k'),
            Trigram('a', 'r', 'a'),
            Trigram('o', 'r', 'a'),
            Trigram('l', 'u', 'd'),
            Trigram('i', ' ', 'o'),
            Trigram('a', ' ', 'z'),
            Trigram('z', 'e', 's'),
            Trigram(' ', 'k', 'r'),
            Trigram('r', 'a', 'n'),
            Trigram('o', 'w', 's'),
            Trigram('e', 'c', 'h'),
            Trigram('w', ' ', 'p'),
            Trigram('d', 'ó', 'w'),
            Trigram('ą', ' ', 'p'),
            Trigram('p', 'o', 'p'),
            Trigram('a', ' ', 'n'),
            Trigram('t', 'k', 'i'),
            Trigram('s', 't', 'k'),
            Trigram('g', 'a', 'n'),
            Trigram('z', 'o', 'n'),
            Trigram('r', 'a', 'j'),
            Trigram('e', ' ', 'o'),
            Trigram('i', 'e', 'c'),
            Trigram('i', ' ', 'l'),
            Trigram(' ', 's', 'i'),
            Trigram('ż', 'e', ' '),
            Trigram('e', 'k', 'a'),
            Trigram(' ', 'k', 't'),
            Trigram(' ', 'd', 'e'),
            Trigram('e', 'm', ' '),
            Trigram('t', 'ó', 'r'),
            Trigram('i', 'ę', ' '),
            Trigram('w', 'n', 'i'),
            Trigram('l', 'n', 'i'),
            Trigram('e', 'j', 's'),
            Trigram('i', 'n', 'i'),
            Trigram('o', 'd', 'o'),
            Trigram('d', 'n', 'i'),
            Trigram('e', 'ł', 'n'),
            Trigram('k', 'o', 'w'),
            Trigram('p', 'e', 'ł'),
            Trigram('a', ' ', 'd'),
            Trigram('r', 'o', 'n'),
            Trigram('d', 'e', 'k'),
            Trigram('p', 'i', 'e'),
            Trigram('u', 'd', 'z'),
            Trigram('b', 'o', 'd'),
            Trigram('n', 'a', 'n'),
            Trigram('h', ' ', 'i'),
            Trigram('d', 's', 't'),
            Trigram('i', 'e', 'g'),
            Trigram('t', 'a', 'w'),
            Trigram('z', ' ', 'p'),
            Trigram('z', ' ', 'w'),
            Trigram('z', 'e', 'ń'),
            Trigram('g', 'o', 'd'),
            Trigram('i', 'u', ' '),
            Trigram('a', 'n', 'o'),
            Trigram('l', 'a', 'r'),
            Trigram(' ', 't', 'o'),
            Trigram('y', ' ', 'z'),
            Trigram('a', ' ', 'k'),
            Trigram('a', 'l', 'e'),
            Trigram('k', 'l', 'a'),
            Trigram('t', 'r', 'z'),
            Trigram('z', 'a', 'w'),
            Trigram('i', 'c', 'h'),
            Trigram('e', ' ', 'i'),
            Trigram('i', 'e', 'r'),
            Trigram('i', 'k', 'o'),
            Trigram('d', 'z', 'y'),
            Trigram('c', 'h', 'n'),
            Trigram('w', ' ', 'z'),
            Trigram('b', 'y', ' '),
            Trigram('k', 'ó', 'w'),
            Trigram('a', 'd', 'z'),
            Trigram('e', 'k', 'l'),
            Trigram('y', 'w', 'a'),
            Trigram('j', 'u', ' '),
            Trigram('o', 'c', 'h'),
            Trigram('k', 'o', 'r'),
            Trigram('s', 'o', 'b'),
            Trigram('o', 'c', 'z'),
            Trigram('o', 's', 'o'),
            Trigram('u', ' ', 'p'),
            Trigram('d', 'u', ' '),
            Trigram('t', 'y', 'c'),
            Trigram('t', 'a', 'n'),
            Trigram('ę', 'd', 'z'),
            Trigram(' ', 'm', 'i'),
            Trigram('e', ' ', 's'),
            Trigram(' ', 't', 'a'),
            Trigram('k', 'i', ' '),
        ],
    ),
    (
        Lang::Ron,
        &[
            Trigram(' ', 'd', 'e'),
            Trigram('ș', 'i', ' '),
            Trigram(' ', 'ș', 'i'),
            Trigram('r', 'e', ' '),
            Trigram(' ', 'î', 'n'),
            Trigram('a', 'r', 'e'),
            Trigram('t', 'e', ' '),
            Trigram('d', 'e', ' '),
            Trigram('e', 'a', ' '),
            Trigram('u', 'l', ' '),
            Trigram('r', 'e', 'p'),
            Trigram('l', 'e', ' '),
            Trigram('e', 'p', 't'),
            Trigram('d', 'r', 'e'),
            Trigram('e', ' ', 'd'),
            Trigram(' ', 'd', 'r'),
            Trigram('i', 'e', ' '),
            Trigram('î', 'n', ' '),
            Trigram('e', ' ', 'a'),
            Trigram('a', 't', 'e'),
            Trigram('p', 't', 'u'),
            Trigram(' ', 's', 'a'),
            Trigram('t', 'u', 'l'),
            Trigram(' ', 'p', 'r'),
            Trigram('o', 'r', ' '),
            Trigram('e', ' ', 'p'),
            Trigram(' ', 'p', 'e'),
            Trigram('l', 'a', ' '),
            Trigram('e', ' ', 's'),
            Trigram('o', 'r', 'i'),
            Trigram(' ', 'l', 'a'),
            Trigram(' ', 'c', 'o'),
            Trigram('l', 'o', 'r'),
            Trigram(' ', 'o', 'r'),
            Trigram('i', 'i', ' '),
            Trigram('r', 'e', 'a'),
            Trigram('c', 'e', ' '),
            Trigram('a', 'u', ' '),
            Trigram('t', 'a', 't'),
            Trigram('a', 'ț', 'i'),
            Trigram(' ', 'a', ' '),
            Trigram(' ', 'c', 'a'),
            Trigram('e', 'n', 't'),
            Trigram(' ', 'f', 'i'),
            Trigram('a', 'l', 'e'),
            Trigram('ă', ' ', 'a'),
            Trigram('a', ' ', 's'),
            Trigram(' ', 'a', 'r'),
            Trigram('e', 'r', 's'),
            Trigram('p', 'e', 'r'),
            Trigram('i', 'c', 'e'),
            Trigram(' ', 'l', 'i'),
            Trigram('u', 'r', 'i'),
            Trigram('a', ' ', 'd'),
            Trigram('a', 'l', ' '),
            Trigram(' ', 'r', 'e'),
            Trigram('e', ' ', 'c'),
            Trigram('r', 'i', 'c'),
            Trigram('n', 'ă', ' '),
            Trigram('i', ' ', 's'),
            Trigram('e', ' ', 'o'),
            Trigram('e', 'i', ' '),
            Trigram('t', 'u', 'r'),
            Trigram(' ', 's', 'ă'),
            Trigram('l', 'i', 'b'),
            Trigram('c', 'o', 'n'),
            Trigram('m', 'e', 'n'),
            Trigram('i', 'b', 'e'),
            Trigram('b', 'e', 'r'),
            Trigram('r', 's', 'o'),
            Trigram('s', 'ă', ' '),
            Trigram('t', 'ă', 'ț'),
            Trigram('s', 'a', 'u'),
            Trigram(' ', 'a', 'c'),
            Trigram('i', 'l', 'o'),
            Trigram('p', 'r', 'i'),
            Trigram('ă', 'ț', 'i'),
            Trigram('i', ' ', 'a'),
            Trigram('i', ' ', 'l'),
            Trigram('c', 'a', 'r'),
            Trigram('l', ' ', 'l'),
            Trigram('t', 'e', 'r'),
            Trigram(' ', 'i', 'n'),
            Trigram('ț', 'i', 'e'),
            Trigram('c', 'ă', ' '),
            Trigram('s', 'o', 'a'),
            Trigram('o', 'a', 'n'),
            Trigram('ț', 'i', 'i'),
            Trigram('l', 'ă', ' '),
            Trigram('t', 'e', 'a'),
            Trigram('r', 'i', ' '),
            Trigram('a', ' ', 'p'),
            Trigram(' ', 'a', 'l'),
            Trigram('r', 'i', 'l'),
            Trigram('e', ' ', 'ș'),
            Trigram('a', 'n', 'ă'),
            Trigram('i', 'n', ' '),
            Trigram('n', 'a', 'l'),
            Trigram('p', 'r', 'e'),
            Trigram('i', ' ', 'î'),
            Trigram('u', 'n', 'i'),
            Trigram('u', 'i', ' '),
            Trigram('s', 'e', ' '),
            Trigram('e', ' ', 'f'),
            Trigram('e', 'r', 'e'),
            Trigram('i', ' ', 'd'),
            Trigram('e', ' ', 'î'),
            Trigram('i', 't', 'a'),
            Trigram(' ', 'u', 'n'),
            Trigram('e', 'r', 't'),
            Trigram('i', 'l', 'e'),
            Trigram('t', 'ă', ' '),
            Trigram('a', ' ', 'o'),
            Trigram(' ', 's', 'e'),
            Trigram('i', ' ', 'ș'),
            Trigram('p', 'e', 'n'),
            Trigram('i', 'a', ' '),
            Trigram('e', 'l', 'e'),
            Trigram('f', 'i', 'e'),
            Trigram('i', ' ', 'c'),
            Trigram('a', ' ', 'l'),
            Trigram('a', 'c', 'e'),
            Trigram('n', 't', 'e'),
            Trigram('n', 't', 'r'),
            Trigram('e', 'n', 'i'),
            Trigram(' ', 'c', 'ă'),
            Trigram('a', 'l', 'ă'),
            Trigram(' ', 'n', 'i'),
            Trigram('i', 'r', 'e'),
            Trigram('ă', ' ', 'd'),
            Trigram('p', 'r', 'o'),
            Trigram('e', 's', 't'),
            Trigram('a', ' ', 'c'),
            Trigram(' ', 'c', 'u'),
            Trigram(' ', 'n', 'u'),
            Trigram('n', ' ', 'c'),
            Trigram('l', 'u', 'i'),
            Trigram('e', 'r', 'i'),
            Trigram('o', 'n', 'a'),
            Trigram(' ', 'a', 's'),
            Trigram('s', 'a', 'l'),
            Trigram('â', 'n', 'd'),
            Trigram('n', 'a', 'ț'),
            Trigram('e', 'c', 'u'),
            Trigram('i', ' ', 'p'),
            Trigram('r', 'i', 'n'),
            Trigram('i', 'n', 'ț'),
            Trigram(' ', 's', 'u'),
            Trigram('r', 'ă', ' '),
            Trigram('e', ' ', 'n'),
            Trigram(' ', 'o', 'm'),
            Trigram('i', 'c', 'i'),
            Trigram('n', 'u', ' '),
            Trigram('i', ' ', 'n'),
            Trigram('o', 'a', 't'),
            Trigram('ă', 'r', 'i'),
            Trigram('l', ' ', 'd'),
            Trigram(' ', 't', 'o'),
            Trigram('t', 'o', 'r'),
            Trigram(' ', 'd', 'i'),
            Trigram(' ', 'n', 'a'),
            Trigram('i', 'u', 'n'),
            Trigram(' ', 'p', 'o'),
            Trigram('o', 'c', 'i'),
            Trigram('t', 'r', 'e'),
            Trigram('n', 'i', ' '),
            Trigram('s', 't', 'e'),
            Trigram('s', 'o', 'c'),
            Trigram('e', 'g', 'a'),
            Trigram('i', ' ', 'o'),
            Trigram('g', 'a', 'l'),
            Trigram(' ', 's', 'o'),
            Trigram(' ', 't', 'r'),
            Trigram('ă', ' ', 'p'),
            Trigram('a', ' ', 'a'),
            Trigram('n', ' ', 'm'),
            Trigram('s', 't', 'a'),
            Trigram('v', 'a', ' '),
            Trigram('ă', ' ', 'î'),
            Trigram('f', 'i', ' '),
            Trigram('r', 'e', 's'),
            Trigram('r', 'e', 'c'),
            Trigram('u', 'l', 'u'),
            Trigram('n', 'i', 'c'),
            Trigram('d', 'i', 'n'),
            Trigram('s', 'a', ' '),
            Trigram('c', 'l', 'a'),
            Trigram('n', 'd', ' '),
            Trigram(' ', 'm', 'o'),
            Trigram(' ', 'c', 'e'),
            Trigram(' ', 'a', 'u'),
            Trigram('a', 'r', 'a'),
            Trigram('l', 'i', 't'),
            Trigram('i', 'n', 't'),
            Trigram('i', ' ', 'e'),
            Trigram('c', 'e', 's'),
            Trigram('u', 'i', 'e'),
            Trigram('a', 't', ' '),
            Trigram('r', 'a', 'r'),
            Trigram('r', 'e', 'l'),
            Trigram('i', 'e', 'i'),
            Trigram('o', 'n', 's'),
            Trigram('e', ' ', 'e'),
            Trigram('l', 'e', 'g'),
            Trigram('n', 'i', 't'),
            Trigram('ă', ' ', 'f'),
            Trigram(' ', 'î', 'm'),
            Trigram('a', ' ', 'î'),
            Trigram('a', 'c', 't'),
            Trigram('e', ' ', 'l'),
            Trigram('r', 'u', ' '),
            Trigram('u', ' ', 'd'),
            Trigram('n', 't', 'a'),
            Trigram('a', ' ', 'f'),
            Trigram('i', 'a', 'l'),
            Trigram('r', 'a', ' '),
            Trigram('ă', ' ', 'c'),
            Trigram(' ', 'e', 'g'),
            Trigram('ț', 'ă', ' '),
            Trigram(' ', 'f', 'a'),
            Trigram('i', ' ', 'f'),
            Trigram('r', 't', 'ă'),
            Trigram('t', 'r', 'u'),
            Trigram('t', 'a', 'r'),
            Trigram('ț', 'i', ' '),
            Trigram('ă', ' ', 'ș'),
            Trigram('i', 'o', 'n'),
            Trigram('n', 't', 'u'),
            Trigram('d', 'e', 'p'),
            Trigram('a', 'm', 'e'),
            Trigram('i', ' ', 'i'),
            Trigram('r', 'e', 'b'),
            Trigram('e', 'c', 't'),
            Trigram('a', 'l', 'i'),
            Trigram('l', ' ', 'c'),
            Trigram('e', 'm', 'e'),
            Trigram('n', 'd', 'e'),
            Trigram('n', ' ', 'a'),
            Trigram('i', 't', 'e'),
            Trigram('e', 'b', 'u'),
            Trigram('b', 'u', 'i'),
            Trigram('â', 't', ' '),
            Trigram('i', 'l', 'i'),
            Trigram('t', 'o', 'a'),
            Trigram('d', 'e', 'c'),
            Trigram(' ', 'o', ' '),
            Trigram('p', 'l', 'i'),
            Trigram('v', 'ă', 'ț'),
            Trigram('n', 't', ' '),
            Trigram('e', ' ', 'r'),
            Trigram('u', ' ', 'c'),
            Trigram('ț', 'a', ' '),
            Trigram('t', ' ', 'î'),
            Trigram('l', ' ', 'ș'),
            Trigram('c', 'u', ' '),
            Trigram('r', 't', 'a'),
            Trigram('c', 'i', 'a'),
            Trigram('a', 'n', 'e'),
            Trigram('ț', 'i', 'o'),
            Trigram('c', 'a', ' '),
            Trigram('i', 't', 'ă'),
            Trigram('p', 'o', 'a'),
            Trigram('c', 'ț', 'i'),
            Trigram('î', 'm', 'p'),
            Trigram('b', 'i', 'l'),
            Trigram('r', ' ', 'ș'),
            Trigram(' ', 's', 't'),
            Trigram('o', 'm', 'u'),
            Trigram('ă', 'ț', 'ă'),
            Trigram('ț', 'i', 'u'),
            Trigram('r', 'i', 'e'),
            Trigram('u', 'm', 'a'),
            Trigram('m', 'â', 'n'),
            Trigram(' ', 'm', 'a'),
            Trigram('a', 'n', 'i'),
            Trigram('n', 'ț', 'a'),
            Trigram('c', 'u', 'r'),
            Trigram('e', 'r', 'a'),
            Trigram('u', ' ', 'a'),
            Trigram('t', 'r', 'a'),
            Trigram('o', 'a', 'r'),
            Trigram(' ', 'e', 'x'),
            Trigram('t', ' ', 's'),
            Trigram('i', 'i', 'l'),
            Trigram('t', 'a', ' '),
            Trigram('r', 'i', 't'),
            Trigram('r', 'o', 't'),
            Trigram('m', 'o', 'd'),
            Trigram('t', 'r', 'i'),
            Trigram('r', 'i', 'v'),
            Trigram('o', 'd', ' '),
            Trigram('l', 'i', 'c'),
            Trigram('r', 'i', 'i'),
            Trigram('e', 'z', 'e'),
            Trigram('m', 'a', 'n'),
            Trigram('î', 'n', 'v'),
            Trigram('n', 'e', ' '),
            Trigram('n', 'v', 'ă'),
            Trigram('a', ' ', 'ș'),
            Trigram('c', 't', 'i'),
        ],
    ),
    (
        Lang::Hrv,
        &[
            Trigram(' ', 'p', 'r'),
            Trigram(' ', 'i', ' '),
            Trigram('j', 'e', ' '),
            Trigram('r', 'a', 'v'),
            Trigram('p', 'r', 'a'),
            Trigram('m', 'a', ' '),
            Trigram(' ', 'n', 'a'),
            Trigram('i', 'm', 'a'),
            Trigram(' ', 's', 'v'),
            Trigram('n', 'a', ' '),
            Trigram('t', 'i', ' '),
            Trigram('a', ' ', 'p'),
            Trigram('n', 'j', 'e'),
            Trigram(' ', 'p', 'o'),
            Trigram('a', ' ', 's'),
            Trigram('a', 'n', 'j'),
            Trigram('a', ' ', 'i'),
            Trigram('v', 'o', ' '),
            Trigram('k', 'o', ' '),
            Trigram('d', 'a', ' '),
            Trigram('v', 'a', 't'),
            Trigram('v', 'a', ' '),
            Trigram('n', 'o', ' '),
            Trigram(' ', 'z', 'a'),
            Trigram('i', ' ', 's'),
            Trigram('o', ' ', 'i'),
            Trigram('j', 'a', ' '),
            Trigram('a', 'v', 'o'),
            Trigram(' ', 'u', ' '),
            Trigram(' ', 'i', 'm'),
            Trigram('s', 'v', 'a'),
            Trigram('i', ' ', 'p'),
            Trigram(' ', 'b', 'i'),
            Trigram('e', ' ', 's'),
            Trigram('j', 'u', ' '),
            Trigram('t', 'k', 'o'),
            Trigram('o', ' ', 'n'),
            Trigram('l', 'i', ' '),
            Trigram('i', 'l', 'i'),
            Trigram('v', 'a', 'n'),
            Trigram('a', 'v', 'a'),
            Trigram(' ', 's', 'l'),
            Trigram('i', 'h', ' '),
            Trigram('n', 'e', ' '),
            Trigram('o', 's', 't'),
            Trigram(' ', 'd', 'r'),
            Trigram('i', 'j', 'e'),
            Trigram(' ', 'n', 'e'),
            Trigram('j', 'e', 'd'),
            Trigram('s', 'l', 'o'),
            Trigram(' ', 'r', 'a'),
            Trigram('u', ' ', 's'),
            Trigram('l', 'o', 'b'),
            Trigram('o', 'b', 'o'),
            Trigram(' ', 'o', 's'),
            Trigram('b', 'o', 'd'),
            Trigram(' ', 'd', 'a'),
            Trigram(' ', 'k', 'o'),
            Trigram('o', 'v', 'a'),
            Trigram('n', 'j', 'a'),
            Trigram('k', 'o', 'j'),
            Trigram('i', ' ', 'd'),
            Trigram('a', 't', 'k'),
            Trigram('i', 't', 'i'),
            Trigram(' ', 'i', 'l'),
            Trigram('s', 't', 'v'),
            Trigram('p', 'r', 'i'),
            Trigram('o', 'm', ' '),
            Trigram('i', 'm', ' '),
            Trigram(' ', 'j', 'e'),
            Trigram(' ', 'o', 'b'),
            Trigram(' ', 's', 'u'),
            Trigram(' ', 'k', 'a'),
            Trigram('i', ' ', 'i'),
            Trigram('i', ' ', 'n'),
            Trigram('e', ' ', 'i'),
            Trigram('v', 'j', 'e'),
            Trigram('i', ' ', 'u'),
            Trigram('s', 'e', ' '),
            Trigram('d', 'r', 'u'),
            Trigram('b', 'i', 't'),
            Trigram('v', 'o', 'j'),
            Trigram('a', 't', 'i'),
            Trigram('i', ' ', 'o'),
            Trigram('ć', 'e', 'n'),
            Trigram('a', ' ', 'o'),
            Trigram('o', ' ', 'p'),
            Trigram('a', ' ', 'b'),
            Trigram('a', ' ', 'n'),
            Trigram('u', 'ć', 'i'),
            Trigram(' ', 's', 'e'),
            Trigram('e', 'n', 'j'),
            Trigram('s', 't', 'i'),
            Trigram('a', ' ', 'u'),
            Trigram('e', 'd', 'n'),
            Trigram('d', 'j', 'e'),
            Trigram('l', 'o', ' '),
            Trigram('ć', 'a', 'v'),
            Trigram(' ', 'm', 'o'),
            Trigram('r', 'a', 'z'),
            Trigram('u', ' ', 'p'),
            Trigram(' ', 'o', 'd'),
            Trigram('r', 'a', 'n'),
            Trigram('n', 'i', ' '),
            Trigram('r', 'o', 'd'),
            Trigram('a', ' ', 'k'),
            Trigram('s', 'u', ' '),
            Trigram('a', 'r', 'o'),
            Trigram('d', 'r', 'ć'),
            Trigram('s', 'v', 'o'),
            Trigram('a', 'k', 'o'),
            Trigram('u', ' ', 'i'),
            Trigram('r', 'ć', 'a'),
            Trigram('a', ' ', 'j'),
            Trigram('m', 'i', 'j'),
            Trigram('j', 'i', ' '),
            Trigram('n', 'i', 'h'),
            Trigram('e', 'n', 'i'),
            Trigram('e', ' ', 'n'),
            Trigram('e', ' ', 'o'),
            Trigram(' ', 'n', 'j'),
            Trigram('p', 'r', 'e'),
            Trigram('p', 'o', 's'),
            Trigram('ć', 'i', 'v'),
            Trigram('o', 'j', 'e'),
            Trigram('e', 'n', 'o'),
            Trigram('e', ' ', 'p'),
            Trigram('n', 'a', 'r'),
            Trigram('o', 'd', 'a'),
            Trigram('n', 'i', 'm'),
            Trigram('o', 'v', 'o'),
            Trigram('a', 'j', 'u'),
            Trigram('r', 'a', ' '),
            Trigram('ć', 'i', ' '),
            Trigram('o', 'g', ' '),
            Trigram('n', 'o', 'v'),
            Trigram('i', 'v', 'a'),
            Trigram('a', ' ', 'd'),
            Trigram('n', 'o', 's'),
            Trigram('b', 'r', 'a'),
            Trigram('b', 'i', 'l'),
            Trigram('i', ' ', 'b'),
            Trigram('a', 'v', 'n'),
            Trigram('a', ' ', 'z'),
            Trigram('j', 'e', 'n'),
            Trigram('e', ' ', 'd'),
            Trigram('v', 'e', ' '),
            Trigram('o', 'r', 'a'),
            Trigram('t', 'v', 'a'),
            Trigram('j', 'e', 'l'),
            Trigram('s', 't', 'a'),
            Trigram('m', 'o', 'r'),
            Trigram('u', ' ', 'o'),
            Trigram('c', 'i', 'j'),
            Trigram('p', 'r', 'o'),
            Trigram('o', 'v', 'i'),
            Trigram('z', 'a', ' '),
            Trigram('j', 'e', 'r'),
            Trigram('k', 'a', ' '),
            Trigram('s', 'n', 'o'),
            Trigram('i', 'l', 'o'),
            Trigram('j', 'e', 'm'),
            Trigram('r', 'e', 'd'),
            Trigram('e', 'm', ' '),
            Trigram('l', 'j', 'u'),
            Trigram('o', 's', 'n'),
            Trigram('o', 'j', 'i'),
            Trigram(' ', 'i', 'z'),
            Trigram('a', 'c', 'i'),
            Trigram(' ', 'd', 'o'),
            Trigram('l', 'j', 'e'),
            Trigram('i', ' ', 'm'),
            Trigram(' ', 'n', 'i'),
            Trigram('o', 'd', 'n'),
            Trigram('n', 'o', 'm'),
            Trigram('j', 'e', 'g'),
            Trigram(' ', 'd', 'j'),
            Trigram('v', 'n', 'o'),
            Trigram('v', 'i', 'm'),
            Trigram('e', 'l', 'j'),
            Trigram('u', ' ', 'z'),
            Trigram('o', ' ', 'd'),
            Trigram('r', 'a', 'd'),
            Trigram('o', ' ', 'o'),
            Trigram('m', ' ', 'i'),
            Trigram('d', 'u', ' '),
            Trigram('u', 'j', 'e'),
            Trigram(' ', 's', 'a'),
            Trigram('n', 'i', 't'),
            Trigram('e', ' ', 'b'),
            Trigram(' ', 's', 't'),
            Trigram('o', 'j', ' '),
            Trigram('t', 'i', 't'),
            Trigram('a', ' ', 'ć'),
            Trigram('d', 'n', 'o'),
            Trigram('e', ' ', 'u'),
            Trigram('o', ' ', 's'),
            Trigram('u', ' ', 'd'),
            Trigram('e', 'ć', 'u'),
            Trigram('a', 'n', 'i'),
            Trigram('d', 'n', 'a'),
            Trigram('n', 'a', 'k'),
            Trigram('n', 's', 't'),
            Trigram('s', 't', 'u'),
            Trigram(' ', 's', 'm'),
            Trigram('e', ' ', 'k'),
            Trigram('u', ' ', 'u'),
            Trigram('a', 'n', ' '),
            Trigram('g', 'o', 'v'),
            Trigram('n', 'j', 'u'),
            Trigram('j', 'u', 'ć'),
            Trigram('a', 'l', 'n'),
            Trigram('m', ' ', 's'),
            Trigram('t', 'u', ' '),
            Trigram('a', ' ', 'r'),
            Trigram('ć', 'o', 'v'),
            Trigram('j', 'a', 'n'),
            Trigram('u', ' ', 'n'),
            Trigram('o', ' ', 'k'),
            Trigram('i', 's', 't'),
            Trigram('ć', 'u', ' '),
            Trigram('t', 'e', ' '),
            Trigram('t', 'v', 'o'),
            Trigram('a', 'n', 's'),
            Trigram('š', 't', 'i'),
            Trigram('n', 'u', ' '),
            Trigram('a', 'r', 'a'),
            Trigram('n', 'a', 'p'),
            Trigram('m', ' ', 'p'),
            Trigram('n', 'i', 'ć'),
            Trigram('o', 'l', 'j'),
            Trigram('b', 'u', 'd'),
            Trigram(' ', 'b', 'u'),
            Trigram('e', 'd', 'i'),
            Trigram('o', 'v', 'j'),
            Trigram('i', ' ', 'v'),
            Trigram('p', 'o', 'd'),
            Trigram('s', 'a', 'm'),
            Trigram('o', 'b', 'r'),
            Trigram('t', 'e', 'l'),
            Trigram(' ', 'm', 'i'),
            Trigram('i', 'n', 'a'),
            Trigram('z', 'a', 'š'),
            Trigram('e', ' ', 'm'),
            Trigram('a', 'š', 't'),
            Trigram(' ', 'v', 'j'),
            Trigram('o', 'n', 'a'),
            Trigram('n', 'j', 'i'),
            Trigram('j', 'e', 'k'),
            Trigram(' ', 't', 'a'),
            Trigram('d', 'u', 'ć'),
            Trigram('i', 'j', 'a'),
            Trigram(' ', 'ć', 'o'),
            Trigram('t', 'u', 'p'),
            Trigram('h', ' ', 'p'),
            Trigram('o', 'j', 'a'),
            Trigram('s', 'm', 'i'),
            Trigram('a', 'd', 'a'),
            Trigram(' ', 'o', 'p'),
            Trigram('o', 's', 'o'),
            Trigram('u', 'n', 'a'),
            Trigram('s', 'o', 'b'),
            Trigram('o', 'd', 'u'),
            Trigram('d', 'n', 'i'),
            Trigram('r', 'u', 'g'),
            Trigram('u', 'd', 'u'),
            Trigram('a', 'o', ' '),
            Trigram('d', 'i', ' '),
            Trigram('a', 'v', 'i'),
            Trigram('t', 'n', 'o'),
            Trigram('j', 'i', 'm'),
            Trigram('i', 't', 'u'),
            Trigram('i', 't', 'k'),
            Trigram('ć', 'e', ' '),
            Trigram('o', 'd', 'r'),
            Trigram('a', 'v', 'e'),
            Trigram('m', 'e', 'ć'),
            Trigram('n', 'o', 'g'),
            Trigram('d', 'i', 'n'),
            Trigram('s', 'v', 'i'),
            Trigram(' ', 'ć', 'i'),
            Trigram('k', 'a', 'k'),
            Trigram('k', 'l', 'a'),
            Trigram('r', 'i', 'm'),
            Trigram('a', 'k', 'v'),
            Trigram('e', 'l', 'o'),
            Trigram('š', 't', 'v'),
            Trigram('i', 't', 'e'),
            Trigram('v', 'o', 'l'),
            Trigram('j', 'e', 't'),
            Trigram('o', 'p', 'ć'),
            Trigram('p', 'o', 't'),
            Trigram('t', 'a', 'n'),
            Trigram('a', 'k', ' '),
            Trigram('n', 'i', 'c'),
            Trigram('n', 'a', 'c'),
            Trigram('u', 'ć', 'e'),
            Trigram(' ', 's', 'k'),
            Trigram(' ', 'm', 'e'),
            Trigram('v', 'e', 'n'),
        ],
    ),
    (
        Lang::Nld,
        &[
            Trigram('e', 'n', ' '),
            Trigram('d', 'e', ' '),
            Trigram('a', 'n', ' '),
            Trigram(' ', 'd', 'e'),
            Trigram('v', 'a', 'n'),
            Trigram(' ', 'v', 'a'),
            Trigram(' ', 'e', 'n'),
            Trigram(' ', 'h', 'e'),
            Trigram('i', 'n', 'g'),
            Trigram('c', 'h', 't'),
            Trigram('d', 'e', 'r'),
            Trigram('n', 'g', ' '),
            Trigram('n', ' ', 'd'),
            Trigram('n', ' ', 'v'),
            Trigram('e', 't', ' '),
            Trigram('e', 'e', 'n'),
            Trigram(' ', 'g', 'e'),
            Trigram('e', 'c', 'h'),
            Trigram('n', ' ', 'e'),
            Trigram('v', 'e', 'r'),
            Trigram('r', 'e', 'c'),
            Trigram('n', 'd', 'e'),
            Trigram(' ', 'e', 'e'),
            Trigram(' ', 'r', 'e'),
            Trigram(' ', 'b', 'e'),
            Trigram('e', 'd', 'e'),
            Trigram('e', 'r', ' '),
            Trigram('e', ' ', 'v'),
            Trigram('g', 'e', 'n'),
            Trigram('d', 'e', 'n'),
            Trigram('h', 'e', 't'),
            Trigram('t', 'e', 'n'),
            Trigram(' ', 't', 'e'),
            Trigram(' ', 'i', 'n'),
            Trigram(' ', 'o', 'p'),
            Trigram('n', ' ', 'i'),
            Trigram(' ', 'v', 'e'),
            Trigram('l', 'i', 'j'),
            Trigram(' ', 'z', 'i'),
            Trigram('e', 'r', 'e'),
            Trigram('e', 'l', 'i'),
            Trigram('z', 'i', 'j'),
            Trigram('i', 'j', 'k'),
            Trigram('t', 'e', ' '),
            Trigram('o', 'o', 'r'),
            Trigram('h', 't', ' '),
            Trigram('e', 'n', 's'),
            Trigram('n', ' ', 'o'),
            Trigram('a', 'n', 'd'),
            Trigram('t', ' ', 'o'),
            Trigram('i', 'j', 'n'),
            Trigram('i', 'e', 'd'),
            Trigram('k', 'e', ' '),
            Trigram(' ', 'o', 'n'),
            Trigram('e', 'i', 'd'),
            Trigram('o', 'p', ' '),
            Trigram(' ', 'v', 'o'),
            Trigram('j', 'n', ' '),
            Trigram('i', 'd', ' '),
            Trigram('o', 'n', 'd'),
            Trigram('i', 'n', ' '),
            Trigram('s', 'c', 'h'),
            Trigram(' ', 'v', 'r'),
            Trigram('a', 'a', 'r'),
            Trigram('n', ' ', 'z'),
            Trigram('a', 'a', 'n'),
            Trigram(' ', 'i', 'e'),
            Trigram('r', 'd', 'e'),
            Trigram('r', 'i', 'j'),
            Trigram('m', 'e', 'n'),
            Trigram('r', 'e', 'n'),
            Trigram('o', 'r', 'd'),
            Trigram('h', 'e', 'i'),
            Trigram('h', 't', 'e'),
            Trigram(' ', 'w', 'e'),
            Trigram('e', 'f', 't'),
            Trigram('n', ' ', 'g'),
            Trigram('f', 't', ' '),
            Trigram('n', ' ', 'w'),
            Trigram('o', 'r', ' '),
            Trigram('n', ' ', 'h'),
            Trigram('e', 'e', 'f'),
            Trigram('v', 'r', 'i'),
            Trigram('w', 'o', 'r'),
            Trigram(' ', 'm', 'e'),
            Trigram('h', 'e', 'e'),
            Trigram('a', 'l', ' '),
            Trigram('t', ' ', 'r'),
            Trigram('o', 'f', ' '),
            Trigram('l', 'e', ' '),
            Trigram(' ', 'o', 'f'),
            Trigram('a', 't', 'i'),
            Trigram('g', ' ', 'v'),
            Trigram('e', ' ', 'b'),
            Trigram('e', 'n', 'i'),
            Trigram(' ', 'a', 'a'),
            Trigram('l', 'l', 'e'),
            Trigram(' ', 'w', 'o'),
            Trigram('n', ' ', 'a'),
            Trigram('e', ' ', 'o'),
            Trigram('n', 'd', ' '),
            Trigram('r', ' ', 'h'),
            Trigram('v', 'o', 'o'),
            Trigram(' ', 'a', 'l'),
            Trigram('e', 'g', 'e'),
            Trigram('n', ' ', 't'),
            Trigram('e', 'r', 'k'),
            Trigram(' ', 'd', 'a'),
            Trigram(' ', 'n', 'a'),
            Trigram('t', ' ', 'h'),
            Trigram('s', 't', 'a'),
            Trigram('j', 'k', 'e'),
            Trigram('a', 't', ' '),
            Trigram('n', 'a', 't'),
            Trigram('n', 'g', 'e'),
            Trigram('e', ' ', 'e'),
            Trigram('e', 'n', 'd'),
            Trigram(' ', 's', 't'),
            Trigram('o', 'm', ' '),
            Trigram('e', ' ', 'g'),
            Trigram('t', 'i', 'e'),
            Trigram('n', ' ', 'b'),
            Trigram('s', 't', 'e'),
            Trigram('d', 'i', 'e'),
            Trigram('e', ' ', 'r'),
            Trigram('e', 'r', 'w'),
            Trigram('w', 'e', 'l'),
            Trigram('e', ' ', 's'),
            Trigram('r', ' ', 'd'),
            Trigram(' ', 'o', 'm'),
            Trigram('i', 'j', ' '),
            Trigram('d', 'i', 'g'),
            Trigram('t', ' ', 'e'),
            Trigram('i', 'g', 'e'),
            Trigram('t', 'e', 'r'),
            Trigram('i', 'e', ' '),
            Trigram('g', 'e', 'l'),
            Trigram('r', 'e', ' '),
            Trigram('j', 'h', 'e'),
            Trigram('t', ' ', 'd'),
            Trigram(' ', 'z', 'a'),
            Trigram('e', ' ', 'm'),
            Trigram('e', 'r', 's'),
            Trigram('i', 'j', 'h'),
            Trigram('n', 'i', 'g'),
            Trigram('z', 'a', 'l'),
            Trigram('n', 'i', 'e'),
            Trigram('d', ' ', 'v'),
            Trigram('n', 's', ' '),
            Trigram('d', ' ', 'e'),
            Trigram('e', ' ', 'w'),
            Trigram('e', ' ', 'n'),
            Trigram('e', 's', 't'),
            Trigram('e', 'l', 'e'),
            Trigram('b', 'e', 's'),
            Trigram(' ', 'd', 'o'),
            Trigram('g', ' ', 'e'),
            Trigram('c', 'h', 'e'),
            Trigram('v', 'o', 'l'),
            Trigram('g', 'e', ' '),
            Trigram('e', 'z', 'e'),
            Trigram('e', ' ', 'd'),
            Trigram('i', 'g', ' '),
            Trigram('g', 'i', 'n'),
            Trigram('d', 'a', 't'),
            Trigram('h', 'a', 'p'),
            Trigram('c', 'h', 'a'),
            Trigram('e', 'k', 'e'),
            Trigram(' ', 'd', 'i'),
            Trigram('o', 'n', 'a'),
            Trigram('e', ' ', 'a'),
            Trigram('l', 'k', 'e'),
            Trigram('n', 's', 't'),
            Trigram('a', 'r', 'd'),
            Trigram(' ', 'g', 'r'),
            Trigram('t', 'e', 'l'),
            Trigram('m', 'i', 'n'),
            Trigram(' ', 't', 'o'),
            Trigram('w', 'a', 'a'),
            Trigram('l', 'e', 'n'),
            Trigram('e', 'l', 'k'),
            Trigram('l', 'i', 'n'),
            Trigram('e', 'm', 'e'),
            Trigram('j', 'k', ' '),
            Trigram('n', ' ', 's'),
            Trigram('d', 'e', 'l'),
            Trigram('s', 't', 'r'),
            Trigram('h', 'a', 'n'),
            Trigram('e', 'v', 'e'),
            Trigram('g', 'r', 'o'),
            Trigram('i', 'c', 'h'),
            Trigram('v', 'e', 'n'),
            Trigram('d', 'o', 'o'),
            Trigram(' ', 'w', 'a'),
            Trigram('t', ' ', 'v'),
            Trigram('i', 't', ' '),
            Trigram('o', 'v', 'e'),
            Trigram('r', 'i', 'n'),
            Trigram('a', 'a', 't'),
            Trigram('n', ' ', 'n'),
            Trigram('w', 'e', 't'),
            Trigram('u', 'i', 't'),
            Trigram('i', 'j', 'd'),
            Trigram('z', 'e', ' '),
            Trigram(' ', 'z', 'o'),
            Trigram('i', 'o', 'n'),
            Trigram(' ', 'o', 'v'),
            Trigram('d', 'e', 'z'),
            Trigram('g', 'e', 'm'),
            Trigram('m', 'e', 't'),
            Trigram('t', 'i', 'o'),
            Trigram('b', 'b', 'e'),
            Trigram('a', 'c', 'h'),
            Trigram(' ', 'n', 'i'),
            Trigram('h', 'e', 'd'),
            Trigram('s', 't', ' '),
            Trigram('a', 'l', 'l'),
            Trigram('i', 'e', 's'),
            Trigram('p', 'e', 'r'),
            Trigram('h', 'e', 'b'),
            Trigram('e', 'b', 'b'),
            Trigram('e', ' ', 'i'),
            Trigram('t', 'o', 'e'),
            Trigram('e', 's', ' '),
            Trigram('t', 'a', 'a'),
            Trigram('n', ' ', 'm'),
            Trigram('n', 't', 'e'),
            Trigram('i', 'e', 'n'),
            Trigram('e', 'l', ' '),
            Trigram('n', 'i', 'n'),
            Trigram('a', 'l', 'e'),
            Trigram('b', 'e', 'n'),
            Trigram('d', 'a', 'a'),
            Trigram('s', 't', 'i'),
            Trigram(' ', 'm', 'a'),
            Trigram('m', 'e', 'e'),
            Trigram('k', 'i', 'n'),
            Trigram('p', 'e', 'n'),
            Trigram('e', ' ', 'h'),
            Trigram('w', 'e', 'r'),
            Trigram('o', 'n', 't'),
            Trigram('i', 'e', 't'),
            Trigram('t', 'i', 'g'),
            Trigram('g', ' ', 'o'),
            Trigram('s', ' ', 'e'),
            Trigram(' ', 'e', 'r'),
            Trigram('i', 'g', 'd'),
            Trigram('e', 't', 'e'),
            Trigram('a', 'n', 'g'),
            Trigram('l', 'a', 'n'),
            Trigram('n', 's', 'c'),
            Trigram('e', 'm', 'a'),
            Trigram('m', 'a', 'n'),
            Trigram('t', ' ', 'g'),
            Trigram('i', 's', ' '),
            Trigram('b', 'e', 'g'),
            Trigram('h', 'e', 'r'),
            Trigram('e', 's', 'c'),
            Trigram('b', 'i', 'j'),
            Trigram('d', ' ', 'o'),
            Trigram('r', 'o', 'n'),
            Trigram('t', 'i', 'n'),
            Trigram('n', 'a', 'l'),
            Trigram('e', 'e', 'r'),
            Trigram('p', ' ', 'v'),
            Trigram('e', 'd', 'i'),
            Trigram('e', 'r', 'm'),
            Trigram('i', 't', 'e'),
            Trigram('t', ' ', 'w'),
            Trigram('t', ' ', 'a'),
            Trigram(' ', 'h', 'u'),
            Trigram('r', 'w', 'i'),
            Trigram('w', 'i', 'j'),
            Trigram('i', 'j', 's'),
            Trigram('r', ' ', 'e'),
            Trigram('w', 'e', 'g'),
            Trigram('j', 's', ' '),
            Trigram('r', 'm', 'i'),
            Trigram('n', 'a', 'a'),
            Trigram('t', ' ', 'b'),
            Trigram('a', 'p', 'p'),
            Trigram('r', 'w', 'e'),
            Trigram(' ', 'b', 'i'),
            Trigram('t', ' ', 'z'),
            Trigram('k', 'e', 'r'),
            Trigram('a', 'm', 'e'),
            Trigram('e', 'r', 'i'),
            Trigram('k', 'e', 'n'),
            Trigram(' ', 'a', 'n'),
            Trigram('a', 'r', ' '),
            Trigram(' ', 'l', 'a'),
            Trigram('t', 'r', 'e'),
            Trigram('g', 'e', 'r'),
            Trigram('r', 'd', 'i'),
            Trigram('t', 'a', 'n'),
            Trigram('e', 'i', 't'),
            Trigram('g', 'd', 'e'),
            Trigram('g', ' ', 'i'),
            Trigram('d', ' ', 'z'),
            Trigram('o', 'e', 'p'),
        ],
    ),
    (
        Lang::Uzb,
        &[
            Trigram('l', 'a', 'r'),
            Trigram('i', 's', 'h'),
            Trigram('a', 'n', ' '),
            Trigram('g', 'a', ' '),
            Trigram('a', 'r', ' '),
            Trigram(' ', 'v', 'a'),
            Trigram(' ', 'b', 'i'),
            Trigram('d', 'a', ' '),
            Trigram('v', 'a', ' '),
            Trigram('i', 'r', ' '),
            Trigram(' ', 'h', 'u'),
            Trigram('i', 'g', 'a'),
            Trigram('s', 'h', ' '),
            Trigram('u', 'q', 'u'),
            Trigram('s', 'h', 'i'),
            Trigram('b', 'i', 'r'),
            Trigram('q', 'u', 'q'),
            Trigram('h', 'u', 'q'),
            Trigram('g', 'a', 'n'),
            Trigram(' ', 'b', 'o'),
            Trigram(' ', 'h', 'a'),
            Trigram('i', 'n', 'i'),
            Trigram('n', 'g', ' '),
            Trigram('a', ' ', 'e'),
            Trigram('r', ' ', 'b'),
            Trigram(' ', 't', 'a'),
            Trigram('l', 'i', 's'),
            Trigram('n', 'i', ' '),
            Trigram('i', 'n', 'g'),
            Trigram('l', 'i', 'k'),
            Trigram('i', 'd', 'a'),
            Trigram('o', 'ʻ', 'l'),
            Trigram('i', 'l', 'i'),
            Trigram('a', 'r', 'i'),
            Trigram('n', 'i', 'n'),
            Trigram('o', 'n', ' '),
            Trigram('i', 'n', 's'),
            Trigram(' ', 'i', 'n'),
            Trigram('a', 'd', 'i'),
            Trigram('n', 's', 'o'),
            Trigram('s', 'o', 'n'),
            Trigram('i', 'y', ' '),
            Trigram(' ', 'o', 'ʻ'),
            Trigram('l', 'a', 'n'),
            Trigram(' ', 'm', 'a'),
            Trigram('d', 'i', 'r'),
            Trigram('h', 'i', ' '),
            Trigram('k', 'i', 'n'),
            Trigram('h', 'a', 'r'),
            Trigram('i', ' ', 'b'),
            Trigram('a', 's', 'h'),
            Trigram(' ', 'y', 'o'),
            Trigram('b', 'o', 'ʻ'),
            Trigram(' ', 'm', 'u'),
            Trigram('d', 'a', 'n'),
            Trigram('u', 'q', 'i'),
            Trigram('i', 'l', 'a'),
            Trigram('e', 'g', 'a'),
            Trigram('q', 'l', 'a'),
            Trigram('r', ' ', 'i'),
            Trigram('q', 'i', 'g'),
            Trigram('o', 'ʻ', 'z'),
            Trigram(' ', 'e', 'g'),
            Trigram('k', 'l', 'a'),
            Trigram('a', ' ', 'b'),
            Trigram('q', 'i', 'l'),
            Trigram('e', 'r', 'k'),
            Trigram('k', 'i', ' '),
            Trigram(' ', 'e', 'r'),
            Trigram('o', 'l', 'i'),
            Trigram('n', 'l', 'i'),
            Trigram('a', 't', ' '),
            Trigram(' ', 'o', 'l'),
            Trigram('g', 'a', 'd'),
            Trigram('l', 'g', 'a'),
            Trigram('r', 'k', 'i'),
            Trigram('o', 'k', 'i'),
            Trigram('i', ' ', 'h'),
            Trigram('a', ' ', 'o'),
            Trigram(' ', 'q', 'a'),
            Trigram('y', 'o', 'k'),
            Trigram('l', 'i', 'g'),
            Trigram('o', 's', 'h'),
            Trigram('i', 'g', 'i'),
            Trigram('i', 'b', ' '),
            Trigram('l', 'a', 's'),
            Trigram('n', ' ', 'b'),
            Trigram('a', 't', 'l'),
            Trigram('n', ' ', 'm'),
            Trigram(' ', 'b', 'a'),
            Trigram('a', 'r', 'a'),
            Trigram(' ', 'q', 'i'),
            Trigram('r', 'i', ' '),
            Trigram(' ', 's', 'h'),
            Trigram('i', 'y', 'a'),
            Trigram('a', 'l', 'a'),
            Trigram('l', 'a', 't'),
            Trigram('i', 'n', ' '),
            Trigram('h', 'a', 'm'),
            Trigram('b', 'i', 'l'),
            Trigram('a', ' ', 't'),
            Trigram('a', ' ', 'y'),
            Trigram('b', 'o', 's'),
            Trigram('r', ' ', 'h'),
            Trigram('s', 'i', 'y'),
            Trigram('n', ' ', 'o'),
            Trigram('y', 'a', 't'),
            Trigram('i', 'n', 'l'),
            Trigram('i', 'k', ' '),
            Trigram('a', ' ', 'q'),
            Trigram('c', 'h', 'a'),
            Trigram('a', ' ', 'h'),
            Trigram(' ', 'e', 't'),
            Trigram('e', 't', 'i'),
            Trigram('n', 'i', 's'),
            Trigram('a', ' ', 's'),
            Trigram('t', 'i', 'l'),
            Trigram('a', 'n', 'i'),
            Trigram('h', ' ', 'h'),
            Trigram('i', ' ', 'v'),
            Trigram('m', 'a', 's'),
            Trigram('t', 'l', 'a'),
            Trigram('o', 's', 'i'),
            Trigram('a', 's', 'i'),
            Trigram(' ', 'q', 'o'),
            Trigram('ʻ', 'l', 'i'),
            Trigram('a', 't', 'i'),
            Trigram('i', ' ', 'm'),
            Trigram('r', 'n', 'i'),
            Trigram('i', 'm', ' '),
            Trigram('u', 'q', 'l'),
            Trigram('a', 'r', 'n'),
            Trigram('r', 'i', 's'),
            Trigram('q', 'a', 'r'),
            Trigram('a', ' ', 'i'),
            Trigram('g', 'i', ' '),
            Trigram(' ', 'd', 'a'),
            Trigram('n', ' ', 'h'),
            Trigram('h', 'a', ' '),
            Trigram('s', 'h', 'a'),
            Trigram('i', ' ', 't'),
            Trigram('m', 'l', 'a'),
            Trigram('r', 'c', 'h'),
            Trigram(' ', 'x', 'a'),
            Trigram('i', ' ', 'o'),
            Trigram('l', 'i', ' '),
            Trigram('h', 'u', 'n'),
            Trigram('b', 'a', 'r'),
            Trigram('l', 'i', 'n'),
            Trigram('ʻ', 'z', ' '),
            Trigram('a', 'r', 'c'),
            Trigram('r', 'l', 'a'),
            Trigram(' ', 'b', 'u'),
            Trigram('a', ' ', 'm'),
            Trigram('a', ' ', 'a'),
            Trigram(' ', 'a', 's'),
            Trigram('m', 'u', 'm'),
            Trigram(' ', 'b', 'e'),
            Trigram(' ', 't', 'u'),
            Trigram('a', 'r', 'o'),
            Trigram('r', ' ', 'v'),
            Trigram('i', 'k', 'l'),
            Trigram('l', 'i', 'b'),
            Trigram('t', 'a', 'ʼ'),
            Trigram('h', ' ', 'v'),
            Trigram('t', 'g', 'a'),
            Trigram('t', 'i', 'b'),
            Trigram('u', 'n', ' '),
            Trigram('l', 'l', 'a'),
            Trigram('m', 'd', 'a'),
            Trigram(' ', 'k', 'e'),
            Trigram('s', 'h', 'g'),
            Trigram(' ', 't', 'o'),
            Trigram('n', ' ', 'q'),
            Trigram('s', 'i', 'd'),
            Trigram('n', ' ', 'e'),
            Trigram('m', 'a', 't'),
            Trigram('a', 'm', 'd'),
            Trigram('s', 'h', 'u'),
            Trigram('h', 'g', 'a'),
            Trigram(' ', 't', 'e'),
            Trigram('t', 'a', 's'),
            Trigram('a', 'l', 'i'),
            Trigram('u', 'm', 'k'),
            Trigram('o', 'y', 'a'),
            Trigram('h', 'l', 'a'),
            Trigram('o', 'l', 'a'),
            Trigram('a', 'm', 'l'),
            Trigram('i', 'r', 'o'),
            Trigram('i', 'l', 'l'),
            Trigram('t', 'i', 's'),
            Trigram('i', 'r', 'i'),
            Trigram('r', 'g', 'a'),
            Trigram('m', 'k', 'i'),
            Trigram('i', 'r', 'l'),
            Trigram(' ', 'y', 'a'),
            Trigram('x', 'a', 'l'),
            Trigram('d', 'a', 'm'),
            Trigram(' ', 'd', 'e'),
            Trigram('g', 'i', 'n'),
            Trigram('e', 'n', 'g'),
            Trigram('r', 'd', 'a'),
            Trigram('t', 'a', 'r'),
            Trigram('u', 's', 'h'),
            Trigram('r', 'a', 'k'),
            Trigram('a', 'y', 'o'),
            Trigram(' ', 'e', 'ʼ'),
            Trigram(' ', 's', 'o'),
            Trigram('t', 'e', 'n'),
            Trigram('a', 'l', 'q'),
            Trigram(' ', 's', 'a'),
            Trigram('u', 'r', ' '),
            Trigram(' ', 'i', 's'),
            Trigram('i', 'm', 'o'),
            Trigram('r', ' ', 't'),
            Trigram(' ', 'k', 'i'),
            Trigram('m', 'i', 'l'),
            Trigram(' ', 'm', 'i'),
            Trigram('e', 'r', 'a'),
            Trigram('z', 'a', 'r'),
            Trigram('h', 'q', 'a'),
            Trigram('a', 'z', 'a'),
            Trigram('k', ' ', 'b'),
            Trigram(' ', 's', 'i'),
            Trigram('n', 'd', 'a'),
            Trigram('h', 'd', 'a'),
            Trigram('k', 'a', 't'),
            Trigram('a', 'k', ' '),
            Trigram('o', 'ʻ', 'r'),
            Trigram('n', ' ', 'v'),
            Trigram('a', ' ', 'k'),
            Trigram('o', 'r', ' '),
            Trigram('r', 'a', 't'),
            Trigram('a', 'd', 'a'),
            Trigram('ʻ', 'l', 'g'),
            Trigram('m', 'i', 'y'),
            Trigram('t', 'n', 'i'),
            Trigram('i', ' ', 'q'),
            Trigram('s', 'h', 'q'),
            Trigram('o', 'd', 'a'),
            Trigram('s', 'h', 'l'),
            Trigram('b', 'u', ' '),
            Trigram('d', 'a', 'v'),
            Trigram('n', 'i', 'd'),
            Trigram('y', ' ', 't'),
            Trigram('c', 'h', ' '),
            Trigram('a', 's', 'l'),
            Trigram('s', 'o', 's'),
            Trigram('i', 'l', 'g'),
            Trigram('a', 's', 'o'),
            Trigram('n', ' ', 't'),
            Trigram('a', 't', 'n'),
            Trigram('s', 'i', 'n'),
            Trigram('a', 'm', ' '),
            Trigram('t', 'i', ' '),
            Trigram('a', 's', ' '),
            Trigram('a', 'n', 'a'),
            Trigram('r', 'i', 'n'),
            Trigram('s', 'i', 'z'),
            Trigram('y', 'o', 't'),
            Trigram('l', 'i', 'm'),
            Trigram('u', 'n', 'i'),
            Trigram('n', 'g', 'a'),
            Trigram('l', 'a', 'k'),
            Trigram('n', ' ', 'i'),
            Trigram('a', ' ', 'u'),
            Trigram('q', 'o', 'n'),
            Trigram('i', ' ', 'a'),
            Trigram('h', ' ', 'k'),
            Trigram('v', 'l', 'a'),
            Trigram('a', 'v', 'l'),
            Trigram('a', 'm', 'i'),
            Trigram('d', 'e', 'k'),
            Trigram(' ', 'j', 'a'),
            Trigram('e', 'm', 'a'),
            Trigram('a', ' ', 'd'),
            Trigram('n', 'a', ' '),
            Trigram(' ', 'e', 'm'),
            Trigram('e', 'k', 'l'),
            Trigram('g', 'ʻ', 'i'),
            Trigram('s', 'i', ' '),
            Trigram('i', ' ', 'e'),
            Trigram('i', 'n', 'o'),
            Trigram(' ', 'k', 'a'),
            Trigram('u', 'c', 'h'),
            Trigram('b', 'o', 'r'),
            Trigram('k', 'e', 'r'),
            Trigram(' ', 'c', 'h'),
            Trigram('l', 'm', 'a'),
            Trigram('l', 'i', 'y'),
            Trigram('a', ' ', 'v'),
            Trigram('ʼ', 't', 'i'),
            Trigram('l', 'l', 'i'),
            Trigram('a', 'k', 'a'),
            Trigram('m', 'u', 'h'),
            Trigram('r', 'i', 'g'),
            Trigram('e', 'c', 'h'),
            Trigram('i', ' ', 'y'),
            Trigram('u', 'r', 'i'),
            Trigram('r', 'o', 'r'),
        ],
    ),
    (
        Lang::Tgl,
        &[
            Trigram('n', 'g', ' '),
            Trigram('a', 'n', 'g'),
            Trigram(' ', 'p', 'a'),
            Trigram('a', 'n', ' '),
            Trigram('s', 'a', ' '),
            Trigram(' ', 's', 'a'),
            Trigram('a', 't', ' '),
            Trigram(' ', 'k', 'a'),
            Trigram(' ', 'n', 'g'),
            Trigram(' ', 'm', 'a'),
            Trigram('a', 'l', 'a'),
            Trigram('g', ' ', 'p'),
            Trigram('a', 'p', 'a'),
            Trigram(' ', 'n', 'a'),
            Trigram('a', 't', 'a'),
            Trigram('p', 'a', 'g'),
            Trigram('p', 'a', 'n'),
            Trigram(' ', 'a', 'n'),
            Trigram(' ', 'a', 't'),
            Trigram('a', 'y', ' '),
            Trigram('a', 'r', 'a'),
            Trigram('g', 'a', ' '),
            Trigram('a', ' ', 'p'),
            Trigram('t', 'a', 'n'),
            Trigram('g', ' ', 'm'),
            Trigram('m', 'g', 'a'),
            Trigram(' ', 'm', 'g'),
            Trigram('n', ' ', 'n'),
            Trigram('p', 'a', 't'),
            Trigram(' ', 'b', 'a'),
            Trigram('n', ' ', 'a'),
            Trigram('a', 'y', 'a'),
            Trigram('n', 'a', ' '),
            Trigram('a', 'm', 'a'),
            Trigram('g', ' ', 'k'),
            Trigram('a', 'w', 'a'),
            Trigram('k', 'a', 'r'),
            Trigram('a', ' ', 'k'),
            Trigram('l', 'a', 'n'),
            Trigram('r', 'a', 'p'),
            Trigram('g', 'k', 'a'),
            Trigram('n', 'g', 'a'),
            Trigram('n', ' ', 's'),
            Trigram('g', ' ', 'n'),
            Trigram('a', 'h', 'a'),
            Trigram('g', ' ', 'b'),
            Trigram('a', ' ', 'a'),
            Trigram(' ', 't', 'a'),
            Trigram('a', 'g', 'k'),
            Trigram('g', 'a', 'n'),
            Trigram('t', 'a', 'o'),
            Trigram('a', 's', 'a'),
            Trigram('a', 'k', 'a'),
            Trigram('y', 'a', 'n'),
            Trigram('a', 'o', ' '),
            Trigram('a', ' ', 'm'),
            Trigram('m', 'a', 'y'),
            Trigram('m', 'a', 'n'),
            Trigram('k', 'a', 'l'),
            Trigram('i', 'n', 'g'),
            Trigram('a', ' ', 's'),
            Trigram('n', 'a', 'n'),
            Trigram('a', 'g', 'a'),
            Trigram(' ', 'l', 'a'),
            Trigram('b', 'a', 'n'),
            Trigram('a', 'l', 'i'),
            Trigram('g', ' ', 'a'),
            Trigram('a', 'n', 'a'),
            Trigram('y', ' ', 'm'),
            Trigram('k', 'a', 't'),
            Trigram('s', 'a', 'n'),
            Trigram('k', 'a', 'n'),
            Trigram('g', ' ', 'i'),
            Trigram('o', 'n', 'g'),
            Trigram('p', 'a', 'm'),
            Trigram('m', 'a', 'g'),
            Trigram('a', ' ', 'n'),
            Trigram('o', ' ', 'a'),
            Trigram('b', 'a', 'w'),
            Trigram('i', 's', 'a'),
            Trigram('w', 'a', 't'),
            Trigram(' ', 'y', ' '),
            Trigram('l', 'a', 'y'),
            Trigram('g', ' ', 's'),
            Trigram('y', ' ', 'k'),
            Trigram('i', 'n', ' '),
            Trigram('i', 'l', 'a'),
            Trigram('t', ' ', 't'),
            Trigram(' ', 'a', 'y'),
            Trigram('a', 'a', 'n'),
            Trigram('o', ' ', 'y'),
            Trigram('k', 'a', 's'),
            Trigram('i', 'n', 'a'),
            Trigram('t', ' ', 'n'),
            Trigram('a', 'g', ' '),
            Trigram('t', ' ', 'p'),
            Trigram('w', 'a', 'l'),
            Trigram('u', 'n', 'a'),
            Trigram('y', 'o', 'n'),
            Trigram(' ', 'o', ' '),
            Trigram(' ', 'i', 't'),
            Trigram('n', 'a', 'g'),
            Trigram('l', 'a', 'l'),
            Trigram('t', 'a', 'y'),
            Trigram('p', 'i', 'n'),
            Trigram('i', 'l', 'i'),
            Trigram('a', 'n', 's'),
            Trigram('i', 't', 'o'),
            Trigram('n', 's', 'a'),
            Trigram('l', 'a', 'h'),
            Trigram('k', 'a', 'k'),
            Trigram('a', 'n', 'y'),
            Trigram('a', ' ', 'i'),
            Trigram('n', 't', 'a'),
            Trigram('n', 'y', 'a'),
            Trigram('t', 'o', ' '),
            Trigram('h', 'a', 'y'),
            Trigram('g', 'a', 'l'),
            Trigram('m', 'a', 'm'),
            Trigram('a', 'b', 'a'),
            Trigram('r', 'a', 'n'),
            Trigram('a', 'n', 't'),
            Trigram('a', 'g', 't'),
            Trigram('o', 'n', ' '),
            Trigram('t', ' ', 's'),
            Trigram('a', 'g', 'p'),
            Trigram(' ', 'w', 'a'),
            Trigram(' ', 'g', 'a'),
            Trigram('g', 'a', 'w'),
            Trigram('h', 'a', 'n'),
            Trigram('k', 'a', 'p'),
            Trigram('o', ' ', 'm'),
            Trigram('l', 'i', 'p'),
            Trigram('y', 'a', ' '),
            Trigram('a', 's', ' '),
            Trigram('g', ' ', 't'),
            Trigram('h', 'a', 't'),
            Trigram('y', ' ', 'n'),
            Trigram('n', 'g', 'k'),
            Trigram('u', 'n', 'g'),
            Trigram('n', 'o', ' '),
            Trigram('g', ' ', 'l'),
            Trigram('g', 'p', 'a'),
            Trigram('w', 'a', ' '),
            Trigram('l', 'a', 'g'),
            Trigram('g', 't', 'a'),
            Trigram('t', ' ', 'm'),
            Trigram('k', 'a', 'i'),
            Trigram('y', 'a', 'a'),
            Trigram('s', 'a', 'l'),
            Trigram('a', 'r', 'i'),
            Trigram('l', 'i', 'n'),
            Trigram('a', ' ', 'l'),
            Trigram('p', 'a', 'p'),
            Trigram('a', 'h', 'i'),
            Trigram(' ', 'i', 's'),
            Trigram(' ', 'd', 'i'),
            Trigram('i', 't', 'a'),
            Trigram(' ', 'p', 'i'),
            Trigram('p', 'u', 'n'),
            Trigram('a', 'g', 'i'),
            Trigram('i', 'p', 'i'),
            Trigram('m', 'a', 'k'),
            Trigram('a', ' ', 'b'),
            Trigram('y', ' ', 's'),
            Trigram('b', 'a', 't'),
            Trigram('y', 'a', 'g'),
            Trigram('a', 'g', 's'),
            Trigram('o', ' ', 'n'),
            Trigram('a', 'k', 'i'),
            Trigram('t', 'a', 't'),
            Trigram('p', 'a', 'h'),
            Trigram('l', 'a', ' '),
            Trigram('g', 'a', 'y'),
            Trigram('h', 'i', 'n'),
            Trigram(' ', 's', 'i'),
            Trigram('d', 'i', ' '),
            Trigram('i', ' ', 'n'),
            Trigram('s', 'a', 's'),
            Trigram('i', 't', 'i'),
            Trigram('a', ' ', 't'),
            Trigram('t', ' ', 'k'),
            Trigram('m', 'a', 'l'),
            Trigram('a', 'i', 's'),
            Trigram('s', ' ', 'n'),
            Trigram('t', ' ', 'a'),
            Trigram('a', 'l', ' '),
            Trigram('i', 'p', 'u'),
            Trigram('i', 'k', 'a'),
            Trigram('l', 'i', 't'),
            Trigram('g', 'i', 'n'),
            Trigram(' ', 'i', 'p'),
            Trigram('a', 'n', 'o'),
            Trigram('g', 's', 'a'),
            Trigram('a', 'l', 'o'),
            Trigram('n', 'i', 'n'),
            Trigram('u', 'm', 'a'),
            Trigram('h', 'a', 'l'),
            Trigram('i', 'r', 'a'),
            Trigram('a', 'p', ' '),
            Trigram('a', 'n', 'i'),
            Trigram('o', 'd', ' '),
            Trigram('i', ' ', 'a'),
            Trigram('g', 'g', 'a'),
            Trigram('y', ' ', 'p'),
            Trigram('p', 'a', 'r'),
            Trigram('t', 'a', 's'),
            Trigram('i', 'g', ' '),
            Trigram('s', 'a', 'p'),
            Trigram('i', 'h', 'i'),
            Trigram('n', 'a', 'h'),
            Trigram('i', 'n', 'i'),
            Trigram(' ', 'b', 'u'),
            Trigram('n', 'g', 'i'),
            Trigram('s', 'y', 'o'),
            Trigram('o', ' ', 's'),
            Trigram('n', 'a', 'p'),
            Trigram('o', ' ', 'p'),
            Trigram('a', ' ', 'g'),
            Trigram(' ', 'h', 'a'),
            Trigram('u', 'k', 'a'),
            Trigram('a', ' ', 'h'),
            Trigram('a', 'r', 'u'),
            Trigram('a', ' ', 'o'),
            Trigram('m', 'a', 'h'),
            Trigram('i', 'b', 'a'),
            Trigram('a', 's', 'y'),
            Trigram('l', 'i', ' '),
            Trigram('u', 's', 'a'),
            Trigram('g', ' ', 'e'),
            Trigram('u', 'h', 'a'),
            Trigram('i', 'p', 'a'),
            Trigram('m', 'b', 'a'),
            Trigram('l', 'a', 'm'),
            Trigram('k', 'i', 'n'),
            Trigram('k', 'i', 'l'),
            Trigram('d', 'u', 'k'),
            Trigram('n', ' ', 'o'),
            Trigram('i', 'g', 'a'),
            Trigram(' ', 'd', 'a'),
            Trigram('d', 'a', 'i'),
            Trigram('a', 'i', 'g'),
            Trigram('i', 'g', 'd'),
            Trigram('g', 'd', 'i'),
            Trigram('p', 'i', 'l'),
            Trigram('d', 'i', 'g'),
            Trigram('p', 'a', 'k'),
            Trigram(' ', 't', 'u'),
            Trigram('d', ' ', 'n'),
            Trigram('s', 'a', 'm'),
            Trigram('n', 'a', 's'),
            Trigram('n', 'a', 'k'),
            Trigram('b', 'a', ' '),
            Trigram('a', 'd', ' '),
            Trigram('l', 'i', 'm'),
            Trigram('s', 'i', 'n'),
            Trigram('b', 'u', 'h'),
            Trigram('r', 'i', ' '),
            Trigram('l', 'a', 'b'),
            Trigram('i', 't', ' '),
            Trigram('t', 'a', 'g'),
            Trigram('g', ' ', 'g'),
            Trigram('l', 'u', 'n'),
            Trigram('a', 'i', 'n'),
            Trigram('a', 'n', 'd'),
            Trigram('n', 'd', 'a'),
            Trigram('p', 'a', 's'),
            Trigram('k', 'a', 'b'),
            Trigram('a', 'h', 'o'),
            Trigram('l', 'i', 'g'),
            Trigram('n', 'a', 'r'),
            Trigram('u', 'l', 'a'),
            Trigram(' ', 'e', 'd'),
            Trigram('e', 'd', 'u'),
            Trigram(' ', 'i', 'b'),
            Trigram('g', 'i', 't'),
            Trigram('m', 'a', ' '),
            Trigram('m', 'a', 's'),
            Trigram('a', 'g', 'b'),
            Trigram('a', 'm', 'i'),
            Trigram('a', 'g', 'g'),
            Trigram('g', 'i', ' '),
            Trigram('s', 'a', 'r'),
            Trigram('i', ' ', 'm'),
            Trigram('s', 'i', 'y'),
            Trigram('g', ' ', 'w'),
            Trigram('a', 'p', 'i'),
            Trigram('p', 'u', 'l'),
            Trigram('i', 'y', 'a'),
            Trigram('a', 'm', 'b'),
            Trigram('n', 'i', 'l'),
            Trigram('a', 'g', 'l'),
            Trigram('s', 't', 'a'),
            Trigram('u', 'l', 'i'),
            Trigram('i', 'n', 'o'),
            Trigram('a', 'b', 'u'),
            Trigram('a', 'u', 'n'),
            Trigram('a', 'y', 'u'),
            Trigram(' ', 'a', 'l'),
            Trigram('i', 'y', 'o'),
        ],
    ),
    (
        Lang::Hun,
        &[
            Trigram(' ', 's', 'z'),
            Trigram(' ', 'a', ' '),
            Trigram('e', 'n', ' '),
            Trigram(' ', 'v', 'a'),
            Trigram('é', 's', ' '),
            Trigram(' ', 'é', 's'),
            Trigram('m', 'i', 'n'),
            Trigram('e', 'k', ' '),
            Trigram(' ', 'm', 'i'),
            Trigram(' ', 'j', 'o'),
            Trigram('j', 'o', 'g'),
            Trigram('i', 'n', 'd'),
            Trigram('a', 'n', ' '),
            Trigram('n', 'e', 'k'),
            Trigram('s', 'z', 'e'),
            Trigram('s', 'á', 'g'),
            Trigram(' ', 'a', 'z'),
            Trigram('g', 'y', ' '),
            Trigram('s', 'z', 'a'),
            Trigram('n', 'd', 'e'),
            Trigram('a', 'l', 'a'),
            Trigram('a', 'z', ' '),
            Trigram('d', 'e', 'n'),
            Trigram('a', ' ', 'v'),
            Trigram('v', 'a', 'l'),
            Trigram('e', 'l', 'e'),
            Trigram(' ', 'e', 'l'),
            Trigram('o', 'g', 'a'),
            Trigram('m', 'é', 'l'),
            Trigram('e', 'g', 'y'),
            Trigram(' ', 'e', 'g'),
            Trigram('n', ' ', 'a'),
            Trigram('g', 'a', ' '),
            Trigram('z', 'a', 'b'),
            Trigram(' ', 'm', 'e'),
            Trigram('z', 'e', 'm'),
            Trigram('e', 'm', 'é'),
            Trigram('a', 'b', 'a'),
            Trigram('i', 'n', 't'),
            Trigram('v', 'a', 'n'),
            Trigram('b', 'a', 'd'),
            Trigram('t', 'e', 'l'),
            Trigram('t', 'e', 't'),
            Trigram(' ', 't', 'e'),
            Trigram('a', 'k', ' '),
            Trigram('t', 'á', 's'),
            Trigram('é', 'n', 'y'),
            Trigram('t', ' ', 'a'),
            Trigram(' ', 'n', 'e'),
            Trigram('g', 'y', 'e'),
            Trigram('é', 'l', 'y'),
            Trigram('t', 't', ' '),
            Trigram('n', ' ', 's'),
            Trigram('b', 'e', 'n'),
            Trigram('s', 'é', 'g'),
            Trigram('z', 'e', 't'),
            Trigram('l', 'a', 'm'),
            Trigram('m', 'e', 'g'),
            Trigram('n', 'a', 'k'),
            Trigram('n', 'i', ' '),
            Trigram(' ', 's', 'e'),
            Trigram('e', 't', 'e'),
            Trigram('s', 'e', 'n'),
            Trigram('a', 'g', 'y'),
            Trigram('l', 'e', 't'),
            Trigram('l', 'y', 'n'),
            Trigram('s', ' ', 'a'),
            Trigram('y', 'n', 'e'),
            Trigram('r', 'a', ' '),
            Trigram('z', ' ', 'e'),
            Trigram('e', 't', ' '),
            Trigram(' ', 'a', 'l'),
            Trigram('m', 'e', 'l'),
            Trigram('k', 'i', 'n'),
            Trigram('k', ' ', 'j'),
            Trigram('e', 't', 'é'),
            Trigram('o', 'k', ' '),
            Trigram('t', 'e', 'k'),
            Trigram(' ', 'k', 'i'),
            Trigram('v', 'a', 'g'),
            Trigram('r', 'e', ' '),
            Trigram('n', ' ', 'm'),
            Trigram('o', 'z', ' '),
            Trigram('h', 'o', 'z'),
            Trigram('e', 'z', ' '),
            Trigram('s', ' ', 's'),
            Trigram('e', 't', 't'),
            Trigram('g', 'o', 'k'),
            Trigram('o', 'g', 'y'),
            Trigram(' ', 'k', 'ö'),
            Trigram('m', 'b', 'e'),
            Trigram('e', 's', ' '),
            Trigram('e', 'm', ' '),
            Trigram('n', 'e', 'm'),
            Trigram('e', 'l', 'y'),
            Trigram(' ', 'l', 'e'),
            Trigram('e', 'l', 'l'),
            Trigram('e', 'm', 'b'),
            Trigram('h', 'o', 'g'),
            Trigram('k', ' ', 'a'),
            Trigram('a', 't', 'á'),
            Trigram('k', 'ö', 'z'),
            Trigram('n', 't', ' '),
            Trigram(' ', 'h', 'o'),
            Trigram('y', 'e', 'n'),
            Trigram('h', 'e', 'z'),
            Trigram('e', 'l', ' '),
            Trigram('z', ' ', 'a'),
            Trigram('l', 'e', 'n'),
            Trigram('d', 's', 'á'),
            Trigram('á', 's', 'á'),
            Trigram('t', 'é', 's'),
            Trigram('a', 'd', 's'),
            Trigram('k', ' ', 'm'),
            Trigram(' ', 'á', 'l'),
            Trigram(' ', 'e', 'm'),
            Trigram('a', ' ', 's'),
            Trigram('n', 't', 'e'),
            Trigram('a', ' ', 'm'),
            Trigram('s', 'z', 't'),
            Trigram('a', ' ', 't'),
            Trigram('á', 'l', 'l'),
            Trigram('á', 's', ' '),
            Trigram('y', ' ', 'a'),
            Trigram('o', 'g', 'o'),
            Trigram('s', 'e', 'm'),
            Trigram('a', ' ', 'h'),
            Trigram('e', 'n', 'k'),
            Trigram('n', 'y', 'e'),
            Trigram('e', 's', 'e'),
            Trigram('n', 'k', 'i'),
            Trigram('á', 'g', 'o'),
            Trigram('t', ' ', 's'),
            Trigram('l', 'a', 'p'),
            Trigram('a', 'm', 'e'),
            Trigram('b', 'e', 'r'),
            Trigram('l', 'ó', ' '),
            Trigram('k', ' ', 'é'),
            Trigram('n', 'y', 'i'),
            Trigram('b', 'a', 'n'),
            Trigram('m', 'é', 'n'),
            Trigram('s', ' ', 'e'),
            Trigram('i', ' ', 'm'),
            Trigram('t', ' ', 'm'),
            Trigram(' ', 'v', 'é'),
            Trigram('l', 'l', 'a'),
            Trigram('l', 'y', ' '),
            Trigram('é', 'b', 'e'),
            Trigram('l', 'a', 't'),
            Trigram('á', 'g', ' '),
            Trigram('a', 'm', 'i'),
            Trigram('o', 'n', ' '),
            Trigram('m', 'z', 'e'),
            Trigram('n', ' ', 'v'),
            Trigram('e', 'm', 'z'),
            Trigram('f', 'e', 'l'),
            Trigram('a', ' ', 'n'),
            Trigram('l', 'ő', ' '),
            Trigram('a', ' ', 'a'),
            Trigram('e', 'k', 'i'),
            Trigram('e', 'r', 'i'),
            Trigram('y', 'e', 's'),
            Trigram(' ', 'c', 's'),
            Trigram('l', 'l', 'e'),
            Trigram('t', 'a', 't'),
            Trigram('e', 'l', 'ő'),
            Trigram('n', 'd', ' '),
            Trigram('i', ' ', 'é'),
            Trigram('é', 'g', ' '),
            Trigram('é', 's', 'é'),
            Trigram('l', 'i', 's'),
            Trigram('y', 'i', 'l'),
            Trigram('v', 'e', 't'),
            Trigram('á', 't', ' '),
            Trigram('k', 'ü', 'l'),
            Trigram('é', 'r', 't'),
            Trigram(' ', 'k', 'e'),
            Trigram('é', 't', 'e'),
            Trigram('r', 'é', 's'),
            Trigram('l', ' ', 'a'),
            Trigram('h', 'e', 't'),
            Trigram('s', 'z', 'o'),
            Trigram('a', 'r', 't'),
            Trigram('a', 'l', 'á'),
            Trigram(' ', 'n', 'y'),
            Trigram('t', 'a', 'r'),
            Trigram('k', 'o', 'z'),
            Trigram(' ', 'a', 'm'),
            Trigram('a', ' ', 'j'),
            Trigram('é', 's', 'z'),
            Trigram('e', 'n', 'l'),
            Trigram('e', 'l', 'é'),
            Trigram('ó', 'l', ' '),
            Trigram('s', ' ', 'k'),
            Trigram('t', 'á', 'r'),
            Trigram('s', ' ', 'é'),
            Trigram('é', 'l', 'e'),
            Trigram('s', ' ', 't'),
            Trigram('l', 'e', 'm'),
            Trigram('s', 'í', 't'),
            Trigram('g', 'e', 's'),
            Trigram('o', 't', 't'),
            Trigram(' ', 'f', 'e'),
            Trigram('n', ' ', 'k'),
            Trigram('t', 'k', 'o'),
            Trigram('z', 'á', 's'),
            Trigram('t', ' ', 'é'),
            Trigram('k', 'e', 'l'),
            Trigram('j', 'a', ' '),
            Trigram(' ', 'h', 'a'),
            Trigram('a', 'l', 'ó'),
            Trigram('z', 'é', 's'),
            Trigram('n', 'l', 'ő'),
            Trigram('é', 's', 'e'),
            Trigram('o', 't', ' '),
            Trigram('r', 'i', ' '),
            Trigram('l', 'e', 'k'),
            Trigram('m', 'á', 's'),
            Trigram('t', 'ő', ' '),
            Trigram('v', 'e', 'l'),
            Trigram('i', ' ', 'j'),
            Trigram('s', 'e', ' '),
            Trigram('e', 'h', 'e'),
            Trigram('t', 'e', 's'),
            Trigram('e', 'v', 'e'),
            Trigram('s', 's', 'á'),
            Trigram('t', 'o', 't'),
            Trigram('t', ' ', 'k'),
            Trigram('o', 'l', 'g'),
            Trigram('e', 'z', 'e'),
            Trigram('i', ' ', 'v'),
            Trigram('á', 'z', 'a'),
            Trigram('l', 'e', 'h'),
            Trigram('n', ' ', 'e'),
            Trigram('ü', 'l', ' '),
            Trigram('t', 't', 'e'),
            Trigram('o', 's', ' '),
            Trigram('t', 'i', ' '),
            Trigram('a', 't', 'k'),
            Trigram('z', 't', 'o'),
            Trigram('e', ' ', 'a'),
            Trigram('t', 'o', 's'),
            Trigram('á', 'n', 'y'),
            Trigram('á', 'n', 'a'),
            Trigram('z', 't', 'e'),
            Trigram('f', 'e', 'j'),
            Trigram('d', 'e', 'l'),
            Trigram('á', 'r', 's'),
            Trigram('k', ' ', 'k'),
            Trigram('k', 'o', 'r'),
            Trigram('é', 'g', 'e'),
            Trigram('s', 'z', 'á'),
            Trigram('t', ' ', 'n'),
            Trigram(' ', 'b', 'i'),
            Trigram('z', 'a', 't'),
            Trigram('v', 'é', 'd'),
            Trigram('n', 'e', 'v'),
            Trigram('e', 'l', 'm'),
            Trigram('é', 'd', 'e'),
            Trigram('z', 'e', 'r'),
            Trigram('t', 'é', 'b'),
            Trigram('b', 'i', 'z'),
            Trigram('r', 'r', 'a'),
            Trigram('i', 'f', 'e'),
            Trigram('i', 'z', 't'),
            Trigram('e', 'r', 'e'),
            Trigram('a', 't', ' '),
            Trigram('l', 'l', ' '),
            Trigram('k', ' ', 'e'),
            Trigram('n', 'y', ' '),
            Trigram('s', 'e', 'l'),
            Trigram(' ', 'n', 'é'),
            Trigram('á', 'b', 'a'),
            Trigram('l', 't', ' '),
            Trigram('a', 'i', ' '),
            Trigram('s', 'ü', 'l'),
            Trigram('h', 'á', 'z'),
            Trigram('k', 'i', 'f'),
            Trigram('t', ' ', 'e'),
            Trigram(' ', 'a', 'r'),
            Trigram('l', 'e', 'g'),
            Trigram('d', ' ', 'a'),
            Trigram('i', 's', ' '),
            Trigram('i', ' ', 'e'),
            Trigram('a', 'r', 'r'),
            Trigram('t', ' ', 't'),
            Trigram('á', 's', 'o'),
            Trigram('i', 't', ' '),
            Trigram('e', 't', 'ő'),
            Trigram('a', 'l', ' '),
            Trigram(' ', 'm', 'á'),
            Trigram('t', ' ', 'v'),
            Trigram(' ', 'b', 'á'),
            Trigram('b', 'á', 'r'),
            Trigram('a', ' ', 'é'),
            Trigram('e', 's', 'ü'),
            Trigram('l', 'y', 'e'),
            Trigram('m', ' ', 'l'),
            Trigram(' ', 'e', 's'),
            Trigram('n', 'y', 'o'),
        ],
    ),
    (
        Lang::Aze,
        &[
            Trigram(' ', 'v', 'ə'),
            Trigram('v', 'ə', ' '),
            Trigram('ə', 'r', ' '),
            Trigram('l', 'a', 'r'),
            Trigram(' ', 'h', 'ə'),
            Trigram('i', 'n', ' '),
            Trigram('i', 'r', ' '),
            Trigram(' ', 'o', 'l'),
            Trigram(' ', 'h', 'ü'),
            Trigram(' ', 'b', 'i'),
            Trigram('h', 'ü', 'q'),
            Trigram('ü', 'q', 'u'),
            Trigram('q', 'u', 'q'),
            Trigram('n', 'a', ' '),
            Trigram('l', 'ə', 'r'),
            Trigram('d', 'ə', ' '),
            Trigram('h', 'ə', 'r'),
            Trigram(' ', 'ş', 'ə'),
            Trigram('b', 'i', 'r'),
            Trigram('a', 'n', ' '),
            Trigram('l', 'i', 'k'),
            Trigram(' ', 't', 'ə'),
            Trigram('r', ' ', 'b'),
            Trigram('m', 'a', 'l'),
            Trigram('l', 'm', 'a'),
            Trigram('a', 's', 'ı'),
            Trigram('i', 'n', 'i'),
            Trigram('r', ' ', 'h'),
            Trigram('ə', 'x', 's'),
            Trigram('ş', 'ə', 'x'),
            Trigram('ə', 'n', ' '),
            Trigram('a', 'r', 'ı'),
            Trigram('q', 'l', 'a'),
            Trigram('a', ' ', 'm'),
            Trigram('d', 'i', 'r'),
            Trigram('a', 'q', ' '),
            Trigram('u', 'q', 'u'),
            Trigram('a', 'l', 'i'),
            Trigram(' ', 'm', 'a'),
            Trigram('u', 'n', 'a'),
            Trigram('i', 'l', 'ə'),
            Trigram('ı', 'n', ' '),
            Trigram('y', 'ə', 't'),
            Trigram(' ', 'y', 'a'),
            Trigram('a', 'r', 'a'),
            Trigram('i', 'k', 'd'),
            Trigram('ə', 'r', 'i'),
            Trigram('a', 'r', ' '),
            Trigram('ə', 's', 'i'),
            Trigram('ə', 't', 'i'),
            Trigram('r', ' ', 'ş'),
            Trigram('r', 'i', 'n'),
            Trigram('y', 'y', 'ə'),
            Trigram('n', ' ', 'h'),
            Trigram(' ', 'a', 'z'),
            Trigram('d', 'ə', 'n'),
            Trigram('n', 'i', 'n'),
            Trigram('ə', 'r', 'ə'),
            Trigram('t', 'i', 'n'),
            Trigram('i', 'y', 'y'),
            Trigram('m', 'ə', 'k'),
            Trigram('z', 'a', 'd'),
            Trigram(' ', 'm', 'ü'),
            Trigram('s', 'i', 'n'),
            Trigram(' ', 'm', 'ə'),
            Trigram('n', 'i', ' '),
            Trigram('n', 'd', 'a'),
            Trigram('ə', 't', ' '),
            Trigram('n', 'd', 'ə'),
            Trigram('a', 'z', 'a'),
            Trigram('r', 'ı', 'n'),
            Trigram('ü', 'n', ' '),
            Trigram('ı', 'n', 'ı'),
            Trigram('ə', ' ', 'a'),
            Trigram('i', ' ', 'v'),
            Trigram('n', 'ı', 'n'),
            Trigram('o', 'l', 'u'),
            Trigram('q', 'u', 'n'),
            Trigram(' ', 'q', 'a'),
            Trigram(' ', 'e', 't'),
            Trigram('i', 'l', 'm'),
            Trigram('l', 'ı', 'q'),
            Trigram('ə', ' ', 'y'),
            Trigram('ə', 'k', ' '),
            Trigram('l', 'm', 'ə'),
            Trigram('l', 'ə', ' '),
            Trigram('k', 'd', 'i'),
            Trigram('i', 'n', 'd'),
            Trigram('ı', 'n', 'a'),
            Trigram('o', 'l', 'm'),
            Trigram('l', 'u', 'n'),
            Trigram('m', 'a', 's'),
            Trigram('x', 's', ' '),
            Trigram('s', 'ı', 'n'),
            Trigram('ə', ' ', 'b'),
            Trigram(' ', 'i', 'n'),
            Trigram('n', ' ', 'm'),
            Trigram('q', ' ', 'v'),
            Trigram('n', 'ə', ' '),
            Trigram('ə', 'm', 'i'),
            Trigram('n', ' ', 't'),
            Trigram('y', 'a', ' '),
            Trigram('d', 'a', ' '),
            Trigram(' ', 'b', 'ə'),
            Trigram('t', 'm', 'ə'),
            Trigram('d', 'l', 'ı'),
            Trigram('a', 'd', 'l'),
            Trigram('b', 'ə', 'r'),
            Trigram(' ', 'o', 'n'),
            Trigram('ə', 'y', 'a'),
            Trigram('ə', ' ', 'h'),
            Trigram('s', 'ı', ' '),
            Trigram('n', 'u', 'n'),
            Trigram('m', 'a', 'q'),
            Trigram('d', 'a', 'n'),
            Trigram('i', 'n', 'ə'),
            Trigram('e', 't', 'm'),
            Trigram('u', 'n', ' '),
            Trigram('ə', ' ', 'v'),
            Trigram('r', 'l', 'ə'),
            Trigram('n', ' ', 'b'),
            Trigram('s', 'i', ' '),
            Trigram('r', 'a', 'q'),
            Trigram(' ', 'v', 'a'),
            Trigram('ə', ' ', 'm'),
            Trigram('n', ' ', 'a'),
            Trigram('ı', 'n', 'd'),
            Trigram('r', 'ı', ' '),
            Trigram('a', 'n', 'ı'),
            Trigram(' ', 'ö', 'z'),
            Trigram('ə', 'r', 'a'),
            Trigram('n', 'm', 'a'),
            Trigram('n', ' ', 'i'),
            Trigram('a', 'm', 'a'),
            Trigram('a', ' ', 'b'),
            Trigram('i', 'r', 'l'),
            Trigram('a', 'l', 'a'),
            Trigram('l', 'i', ' '),
            Trigram('i', 'n', 's'),
            Trigram('b', 'i', 'l'),
            Trigram('i', 'k', ' '),
            Trigram(' ', 'a', 'l'),
            Trigram(' ', 'd', 'i'),
            Trigram('ı', 'ğ', 'ı'),
            Trigram('ə', ' ', 'd'),
            Trigram('l', 'ə', 't'),
            Trigram('i', 'l', ' '),
            Trigram('ə', 'l', 'ə'),
            Trigram('ə', ' ', 'i'),
            Trigram('ı', 'q', ' '),
            Trigram('n', 'ı', ' '),
            Trigram('n', 'l', 'a'),
            Trigram('d', 'i', 'l'),
            Trigram('m', 'ü', 'd'),
            Trigram('n', ' ', 'v'),
            Trigram('ə', ' ', 'e'),
            Trigram('u', 'n', 'm'),
            Trigram('a', 'l', 'ı'),
            Trigram(' ', 's', 'ə'),
            Trigram('x', 's', 'i'),
            Trigram('ə', ' ', 'o'),
            Trigram('u', 'q', ' '),
            Trigram('u', 'q', 'l'),
            Trigram('n', 's', 'a'),
            Trigram('ə', 't', 'l'),
            Trigram(' ', 'd', 'ə'),
            Trigram('i', 'l', 'i'),
            Trigram('ü', 'd', 'a'),
            Trigram('a', 's', 'i'),
            Trigram(' ', 'h', 'e'),
            Trigram('o', 'l', 'a'),
            Trigram('s', 'a', 'n'),
            Trigram('ə', 'n', 'i'),
            Trigram('m', 'ə', 's'),
            Trigram(' ', 'd', 'a'),
            Trigram('l', 'a', 'n'),
            Trigram(' ', 'b', 'u'),
            Trigram('t', 'ə', 'r'),
            Trigram('h', 'ə', 'm'),
            Trigram('d', 'ı', 'r'),
            Trigram('k', 'i', 'l'),
            Trigram('i', 'ş', ' '),
            Trigram('u', ' ', 'v'),
            Trigram(' ', 'k', 'i'),
            Trigram('m', 'i', 'n'),
            Trigram('e', 'y', 'n'),
            Trigram('m', 'i', ' '),
            Trigram('y', 'i', 'n'),
            Trigram(' ', 'h', 'a'),
            Trigram('s', 'o', 's'),
            Trigram('h', 'e', 'ç'),
            Trigram('b', 'u', ' '),
            Trigram('e', 'ç', ' '),
            Trigram(' ', 'e', 'd'),
            Trigram('k', 'i', 'm'),
            Trigram('l', 'ı', 'ğ'),
            Trigram('a', 'l', 'q'),
            Trigram('x', 'a', 'l'),
            Trigram(' ', 'a', 's'),
            Trigram('s', 'i', 'a'),
            Trigram('o', 's', 'i'),
            Trigram('r', ' ', 'v'),
            Trigram('q', ' ', 'h'),
            Trigram('r', 'ə', ' '),
            Trigram('y', 'a', 'n'),
            Trigram('i', ' ', 's'),
            Trigram(' ', 'ə', 's'),
            Trigram('d', 'a', 'f'),
            Trigram('a', 'f', 'i'),
            Trigram(' ', 'i', 'ş'),
            Trigram('ı', ' ', 'h'),
            Trigram('f', 'i', 'ə'),
            Trigram(' ', 't', 'a'),
            Trigram('ə', ' ', 'q'),
            Trigram('ı', 'q', 'l'),
            Trigram('a', ' ', 'q'),
            Trigram('y', 'a', 'r'),
            Trigram('s', 'a', 's'),
            Trigram('l', 'ı', ' '),
            Trigram('i', 'l', 'l'),
            Trigram('m', 'i', 'l'),
            Trigram('ə', 's', 'a'),
            Trigram('l', 'i', 'y'),
            Trigram('t', 'l', 'ə'),
            Trigram('s', 'i', 'y'),
            Trigram('a', ' ', 'h'),
            Trigram('m', 'ə', 'z'),
            Trigram('t', 'ü', 'n'),
            Trigram('ə', ' ', 't'),
            Trigram(' ', 'i', 's'),
            Trigram('i', 's', 't'),
            Trigram('i', 'y', 'i'),
            Trigram(' ', 's', 'o'),
            Trigram('n', ' ', 'ə'),
            Trigram('a', 'l', ' '),
            Trigram('i', 'f', 'a'),
            Trigram('i', 'n', 'a'),
            Trigram('l', 'ı', 'd'),
            Trigram('ı', ' ', 'o'),
            Trigram('ı', 'd', 'ı'),
            Trigram('ə', 'm', 'ə'),
            Trigram('ı', 'r', ' '),
            Trigram('ə', 'd', 'ə'),
            Trigram('i', 'a', 'l'),
            Trigram(' ', 'm', 'i'),
            Trigram('ə', 'y', 'i'),
            Trigram('m', 'i', 'y'),
            Trigram('ç', 'ü', 'n'),
            Trigram('n', ' ', 'e'),
            Trigram('i', 'y', 'a'),
            Trigram('e', 'd', 'i'),
            Trigram(' ', 'c', 'ə'),
            Trigram(' ', 'b', 'ü'),
            Trigram('b', 'ü', 't'),
            Trigram('ü', 't', 'ü'),
            Trigram('x', 'i', 'l'),
            Trigram('ü', 'ç', 'ü'),
            Trigram('m', 'ə', 'n'),
            Trigram('a', 'd', 'ə'),
            Trigram('t', ' ', 'v'),
            Trigram('a', ' ', 'v'),
            Trigram('a', 'x', 'i'),
            Trigram('d', 'a', 'x'),
            Trigram('r', ' ', 'a'),
            Trigram('o', 'n', 'u'),
            Trigram(' ', 'ü', 'ç'),
            Trigram('s', 'e', 'ç'),
            Trigram(' ', 'n', 'ə'),
            Trigram(' ', 's', 'e'),
            Trigram('m', 'a', 'n'),
            Trigram('r', 'i', 'l'),
            Trigram('s', 'i', 'l'),
            Trigram('ə', 'z', ' '),
            Trigram('i', 'ə', ' '),
            Trigram('ö', 'z', ' '),
            Trigram('ı', 'l', 'ı'),
            Trigram('a', 'y', 'a'),
            Trigram('q', 'a', 'n'),
            Trigram('i', ' ', 't'),
            Trigram('ş', 'ə', 'r'),
            Trigram('t', 'ə', 'm'),
            Trigram('u', 'l', 'm'),
            Trigram('r', 'ə', 'f'),
            Trigram('m', 'ə', 'h'),
            Trigram(' ', 'x', 'a'),
            Trigram('ğ', 'ı', 'n'),
            Trigram(' ', 'd', 'ö'),
            Trigram(' ', 'n', 'i'),
            Trigram('s', 't', 'i'),
            Trigram('i', 'l', 'd'),
            Trigram('a', 'm', 'ə'),
            Trigram('q', 'u', ' '),
            Trigram('n', 'a', 'm'),
            Trigram('n', ' ', 'o'),
            Trigram('n', ' ', 'd'),
            Trigram('v', 'a', 'r'),
            Trigram('a', 'd', ' '),
            Trigram('z', 'a', 'm'),
            Trigram('t', 'a', 'm'),
            Trigram('t', 'ə', 'h'),
        ],
    ),
    (
        Lang::Ces,
        &[
            Trigram(' ', 'p', 'r'),
            Trigram(' ', 'a', ' '),
            Trigram('n', 'í', ' '),
            Trigram(' ', 'n', 'e'),
            Trigram('p', 'r', 'á'),
            Trigram('r', 'á', 'v'),
            Trigram('o', 's', 't'),
            Trigram(' ', 's', 'v'),
            Trigram(' ', 'p', 'o'),
            Trigram('n', 'a', ' '),
            Trigram('c', 'h', ' '),
            Trigram('h', 'o', ' '),
            Trigram(' ', 'n', 'a'),
            Trigram('n', 'o', 's'),
            Trigram('o', ' ', 'n'),
            Trigram(' ', 'r', 'o'),
            Trigram('á', 'n', 'í'),
            Trigram('t', 'i', ' '),
            Trigram('v', 'o', ' '),
            Trigram('n', 'e', 'b'),
            Trigram('á', 'v', 'o'),
            Trigram('m', 'á', ' '),
            Trigram('b', 'o', ' '),
            Trigram('e', 'b', 'o'),
            Trigram(' ', 'm', 'á'),
            Trigram('k', 'a', 'ž'),
            Trigram(' ', 'k', 'a'),
            Trigram('o', 'u', ' '),
            Trigram('a', 'ž', 'd'),
            Trigram(' ', 'z', 'a'),
            Trigram(' ', 'j', 'e'),
            Trigram('d', 'ý', ' '),
            Trigram('s', 'v', 'o'),
            Trigram('ž', 'd', 'ý'),
            Trigram(' ', 'p', 'ř'),
            Trigram('a', ' ', 's'),
            Trigram(' ', 's', 't'),
            Trigram('s', 't', 'i'),
            Trigram('á', ' ', 'p'),
            Trigram(' ', 'v', ' '),
            Trigram('o', 'b', 'o'),
            Trigram('v', 'o', 'b'),
            Trigram(' ', 's', 'p'),
            Trigram('b', 'o', 'd'),
            Trigram(' ', 'z', 'á'),
            Trigram('ý', 'c', 'h'),
            Trigram('p', 'r', 'o'),
            Trigram('r', 'o', 'd'),
            Trigram('v', 'á', 'n'),
            Trigram('e', 'n', 'í'),
            Trigram('n', 'é', ' '),
            Trigram('ý', ' ', 'm'),
            Trigram('é', 'h', 'o'),
            Trigram(' ', 'b', 'y'),
            Trigram(' ', 'n', 'á'),
            Trigram('s', 'p', 'o'),
            Trigram('n', 'ě', ' '),
            Trigram('o', ' ', 'p'),
            Trigram('m', 'i', ' '),
            Trigram('í', ' ', 'a'),
            Trigram('t', 'e', 'r'),
            Trigram('r', 'o', 'z'),
            Trigram('o', 'v', 'á'),
            Trigram('t', 'o', ' '),
            Trigram(' ', 'j', 'a'),
            Trigram(' ', 'l', 'i'),
            Trigram('á', 'r', 'o'),
            Trigram('n', 'á', 'r'),
            Trigram('b', 'y', ' '),
            Trigram('j', 'a', 'k'),
            Trigram('a', ' ', 'p'),
            Trigram('a', ' ', 'z'),
            Trigram('n', 'y', ' '),
            Trigram(' ', 'v', 'š'),
            Trigram('k', 't', 'e'),
            Trigram('i', ' ', 'a'),
            Trigram('l', 'i', 'd'),
            Trigram('í', 'm', ' '),
            Trigram('o', ' ', 'v'),
            Trigram('í', ' ', 'p'),
            Trigram('u', ' ', 'p'),
            Trigram('m', 'u', ' '),
            Trigram('a', 't', ' '),
            Trigram(' ', 'v', 'y'),
            Trigram('o', 'd', 'n'),
            Trigram(' ', 's', 'o'),
            Trigram(' ', 'm', 'a'),
            Trigram('a', ' ', 'v'),
            Trigram(' ', 'k', 't'),
            Trigram('í', ' ', 'n'),
            Trigram('z', 'á', 'k'),
            Trigram('l', 'i', ' '),
            Trigram('o', 'l', 'i'),
            Trigram('v', 'í', ' '),
            Trigram('k', 'l', 'a'),
            Trigram('t', 'n', 'í'),
            Trigram('p', 'o', 'd'),
            Trigram('s', 't', 'á'),
            Trigram('e', 'n', ' '),
            Trigram('d', 'o', ' '),
            Trigram('t', ' ', 's'),
            Trigram('m', 'í', ' '),
            Trigram('j', 'e', ' '),
            Trigram('e', 'm', ' '),
            Trigram('á', 'v', 'a'),
            Trigram(' ', 'd', 'o'),
            Trigram('b', 'y', 'l'),
            Trigram(' ', 's', 'e'),
            Trigram('b', 'ý', 't'),
            Trigram('í', ' ', 's'),
            Trigram('r', 'o', 'v'),
            Trigram(' ', 'k', ' '),
            Trigram('č', 'i', 'n'),
            Trigram(' ', 'v', 'e'),
            Trigram('ý', 't', ' '),
            Trigram('í', ' ', 'b'),
            Trigram('i', 't', ' '),
            Trigram('d', 'n', 'í'),
            Trigram('v', 'š', 'e'),
            Trigram('p', 'o', 'l'),
            Trigram('o', ' ', 's'),
            Trigram(' ', 'b', 'ý'),
            Trigram('t', 'v', 'í'),
            Trigram('n', 'ý', 'c'),
            Trigram('s', 't', 'n'),
            Trigram('n', 'o', 'u'),
            Trigram('e', 'j', 'n'),
            Trigram('s', 'o', 'u'),
            Trigram('r', 'a', 'n'),
            Trigram('c', 'i', ' '),
            Trigram('v', 'o', 'l'),
            Trigram('s', 'e', ' '),
            Trigram('n', 'e', 's'),
            Trigram('a', ' ', 'n'),
            Trigram('p', 'ř', 'í'),
            Trigram('e', 'h', 'o'),
            Trigram('n', 'ý', 'm'),
            Trigram('t', 'á', 't'),
            Trigram('v', 'a', ' '),
            Trigram('n', 'í', 'm'),
            Trigram('m', 'e', 'z'),
            Trigram('a', 'j', 'í'),
            Trigram('i', ' ', 's'),
            Trigram('s', 't', 'v'),
            Trigram('k', 'é', ' '),
            Trigram('í', 'c', 'h'),
            Trigram('e', 'č', 'n'),
            Trigram('ž', 'e', 'n'),
            Trigram('e', ' ', 's'),
            Trigram('v', 'é', ' '),
            Trigram('o', 'v', 'a'),
            Trigram('s', 'v', 'é'),
            Trigram('ý', 'm', ' '),
            Trigram('k', 'o', 'l'),
            Trigram('d', 'u', ' '),
            Trigram('u', ' ', 's'),
            Trigram('j', 'e', 'h'),
            Trigram('k', 'o', 'n'),
            Trigram('a', 'v', 'e'),
            Trigram('e', 'c', 'h'),
            Trigram('e', 'r', 'é'),
            Trigram('n', 'u', ' '),
            Trigram(' ', 'z', 'e'),
            Trigram('i', ' ', 'v'),
            Trigram('o', ' ', 'd'),
            Trigram('í', ' ', 'v'),
            Trigram('h', 'r', 'a'),
            Trigram('i', 'd', 's'),
            Trigram('m', ' ', 'p'),
            Trigram('é', 'm', 'u'),
            Trigram('o', 'l', 'e'),
            Trigram('y', ' ', 's'),
            Trigram(' ', 'i', ' '),
            Trigram('m', 'a', 'j'),
            Trigram('o', ' ', 'z'),
            Trigram(' ', 't', 'o'),
            Trigram('a', 'b', 'y'),
            Trigram('s', 't', 'a'),
            Trigram(' ', 'a', 'b'),
            Trigram('m', ' ', 'a'),
            Trigram('p', 'r', 'a'),
            Trigram(' ', 't', 'a'),
            Trigram('c', 'h', 'n'),
            Trigram(' ', 'n', 'i'),
            Trigram('ž', 'e', ' '),
            Trigram('o', 'v', 'n'),
            Trigram('a', 'k', 'o'),
            Trigram('n', 'é', 'h'),
            Trigram('l', 'e', 'n'),
            Trigram('d', 's', 'k'),
            Trigram('r', 'a', 'c'),
            Trigram('l', 'a', 'd'),
            Trigram('c', 'h', 'r'),
            Trigram(' ', 'ž', 'e'),
            Trigram('v', 'a', 't'),
            Trigram(' ', 'o', 's'),
            Trigram('s', 'o', 'b'),
            Trigram('a', 'k', 'é'),
            Trigram('i', ' ', 'p'),
            Trigram('s', 'm', 'í'),
            Trigram('e', 's', 'm'),
            Trigram('s', 't', ' '),
            Trigram('i', ' ', 'n'),
            Trigram('m', ' ', 'n'),
            Trigram('a', ' ', 'm'),
            Trigram('l', 'n', 'ě'),
            Trigram('l', 'n', 'í'),
            Trigram('p', 'ř', 'i'),
            Trigram('b', 'e', 'z'),
            Trigram('d', 'y', ' '),
            Trigram('á', 'l', 'n'),
            Trigram('e', 'n', 's'),
            Trigram('z', 'e', 'm'),
            Trigram('t', ' ', 'v'),
            Trigram('č', 'e', 'n'),
            Trigram('l', 'e', 'č'),
            Trigram('k', 'd', 'o'),
            Trigram('ý', 'm', 'i'),
            Trigram(' ', 'j', 'i'),
            Trigram('o', 'c', 'i'),
            Trigram('i', ' ', 'k'),
            Trigram(' ', 's', ' '),
            Trigram('í', ' ', 'm'),
            Trigram('j', 'í', ' '),
            Trigram(' ', 'č', 'i'),
            Trigram('á', 'v', ' '),
            Trigram('s', 't', 'e'),
            Trigram('o', 'c', 'h'),
            Trigram(' ', 'o', 'c'),
            Trigram('v', 'o', 'u'),
            Trigram('á', 'k', 'l'),
            Trigram(' ', 'v', 'z'),
            Trigram('r', 'a', 'v'),
            Trigram('o', 'd', 'u'),
            Trigram('n', 'e', 'z'),
            Trigram('i', 'n', 'n'),
            Trigram('s', 'k', 'ý'),
            Trigram('n', 'i', 't'),
            Trigram('i', 'v', 'o'),
            Trigram('a', ' ', 'j'),
            Trigram('u', ' ', 'k'),
            Trigram('i', 'á', 'l'),
            Trigram(' ', 'm', 'e'),
            Trigram('e', 'z', 'i'),
            Trigram('s', 'k', 'é'),
            Trigram('v', 'e', 'n'),
            Trigram('s', 't', 'u'),
            Trigram('u', ' ', 'a'),
            Trigram('t', 'e', 'j'),
            Trigram('o', 'l', 'n'),
            Trigram('s', 'l', 'u'),
            Trigram('z', 'e', 'n'),
            Trigram('í', ' ', 'z'),
            Trigram('y', ' ', 'b'),
            Trigram('o', 'k', 'o'),
            Trigram('z', 'a', 'c'),
            Trigram('n', 'í', 'c'),
            Trigram('j', 'i', 'n'),
            Trigram('k', 'y', ' '),
            Trigram('a', ' ', 'o'),
            Trigram('ř', 'í', 's'),
            Trigram('o', 'b', 'e'),
            Trigram('u', ' ', 'v'),
            Trigram('t', 'a', 'k'),
            Trigram('v', 'ě', 'd'),
            Trigram('o', 'j', 'e'),
            Trigram(' ', 'v', 'ý'),
            Trigram('i', 'k', 'd'),
            Trigram('h', ' ', 'n'),
            Trigram(' ', 'o', 'd'),
            Trigram('č', 'n', 'o'),
            Trigram('o', 's', 'o'),
            Trigram('c', 'i', 'á'),
            Trigram('h', ' ', 'p'),
            Trigram(' ', 'd', 'e'),
            Trigram('a', ' ', 't'),
            Trigram('ů', 'm', ' '),
            Trigram('s', 'o', 'c'),
            Trigram('j', 'í', 'c'),
            Trigram('o', 'd', 'ů'),
            Trigram('n', 'ě', 'n'),
            Trigram('a', 'd', 'n'),
            Trigram('t', 'u', 'p'),
            Trigram('d', 'ů', ' '),
            Trigram('d', 'ě', 'l'),
            Trigram('j', 'n', 'o'),
            Trigram('k', 'é', 'h'),
            Trigram('p', 'o', 'r'),
            Trigram('o', 'ž', 'e'),
            Trigram('h', 'o', 'v'),
            Trigram('a', 'c', 'i'),
            Trigram('n', 'e', 'm'),
            Trigram('é', ' ', 'v'),
            Trigram('r', 'o', 'k'),
            Trigram('i', ' ', 'j'),
            Trigram('u', ' ', 'o'),
            Trigram('o', 'd', ' '),
            Trigram('í', 'h', 'o'),
            Trigram('v', 'i', 'n'),
            Trigram('o', 'd', 'i'),
        ],
    ),
    (
        Lang::Zul,
        &[
            Trigram('n', 'g', 'e'),
            Trigram('o', 'k', 'u'),
            Trigram('l', 'o', ' '),
            Trigram(' ', 'n', 'g'),
            Trigram('a', ' ', 'n'),
            Trigram('u', 'n', 'g'),
            Trigram('n', 'g', 'a'),
            Trigram('l', 'e', ' '),
            Trigram('l', 'u', 'n'),
            Trigram(' ', 'n', 'o'),
            Trigram('e', 'l', 'o'),
            Trigram('w', 'a', ' '),
            Trigram('l', 'a', ' '),
            Trigram('e', ' ', 'n'),
            Trigram('e', 'l', 'e'),
            Trigram('n', 't', 'u'),
            Trigram('g', 'e', 'l'),
            Trigram('t', 'u', ' '),
            Trigram('w', 'e', ' '),
            Trigram('n', 'g', 'o'),
            Trigram(' ', 'u', 'm'),
            Trigram('e', ' ', 'u'),
            Trigram('t', 'h', 'i'),
            Trigram('u', 't', 'h'),
            Trigram('k', 'e', ' '),
            Trigram('h', 'i', ' '),
            Trigram('l', 'e', 'k'),
            Trigram('n', 'i', ' '),
            Trigram('e', 'z', 'i'),
            Trigram(' ', 'k', 'u'),
            Trigram('m', 'a', ' '),
            Trigram('n', 'o', 'm'),
            Trigram('o', ' ', 'n'),
            Trigram('p', 'h', 'a'),
            Trigram('g', 'o', 'k'),
            Trigram('n', 'k', 'e'),
            Trigram('o', 'n', 'k'),
            Trigram('a', ' ', 'u'),
            Trigram('n', 'e', 'l'),
            Trigram('u', 'l', 'u'),
            Trigram('o', 'm', 'a'),
            Trigram('o', ' ', 'e'),
            Trigram('o', ' ', 'l'),
            Trigram('k', 'w', 'e'),
            Trigram('u', 'n', 't'),
            Trigram('a', 'n', 'g'),
            Trigram('l', 'u', 'l'),
            Trigram('k', 'u', 'l'),
            Trigram(' ', 'u', 'k'),
            Trigram('a', ' ', 'k'),
            Trigram('e', 'n', 'i'),
            Trigram('u', 'k', 'u'),
            Trigram('h', 'l', 'a'),
            Trigram(' ', 'n', 'e'),
            Trigram(' ', 'w', 'o'),
            Trigram('m', 'u', 'n'),
            Trigram(' ', 'l', 'o'),
            Trigram('k', 'e', 'l'),
            Trigram('a', 'm', 'a'),
            Trigram('a', 't', 'h'),
            Trigram('u', 'm', 'u'),
            Trigram('h', 'o', ' '),
            Trigram('e', 'l', 'a'),
            Trigram('l', 'w', 'a'),
            Trigram('w', 'o', 'n'),
            Trigram('z', 'w', 'e'),
            Trigram('b', 'a', 'n'),
            Trigram('e', 'l', 'w'),
            Trigram('u', 'l', 'e'),
            Trigram('a', ' ', 'i'),
            Trigram(' ', 'u', 'n'),
            Trigram('a', 'n', 'a'),
            Trigram('u', 'n', 'e'),
            Trigram('l', 'o', 'k'),
            Trigram('i', 'n', 'g'),
            Trigram('e', 'l', 'u'),
            Trigram('w', 'e', 'n'),
            Trigram('a', 'k', 'a'),
            Trigram('t', 'h', 'o'),
            Trigram('a', 'b', 'a'),
            Trigram(' ', 'k', 'w'),
            Trigram('g', 'a', 'n'),
            Trigram('k', 'o', ' '),
            Trigram('a', 'l', 'a'),
            Trigram('e', 'n', 'z'),
            Trigram('o', ' ', 'y'),
            Trigram('k', 'h', 'e'),
            Trigram('a', 'k', 'h'),
            Trigram('t', 'h', 'u'),
            Trigram('u', ' ', 'u'),
            Trigram('n', 'a', ' '),
            Trigram('e', 'n', 'k'),
            Trigram('k', 'h', 'o'),
            Trigram('a', ' ', 'e'),
            Trigram('z', 'i', 'n'),
            Trigram('g', 'e', 'n'),
            Trigram('i', ' ', 'n'),
            Trigram('k', 'u', 'n'),
            Trigram('a', 'l', 'u'),
            Trigram('m', 'a', 'l'),
            Trigram('l', 'e', 'l'),
            Trigram('e', ' ', 'k'),
            Trigram('n', 'k', 'u'),
            Trigram('e', ' ', 'a'),
            Trigram('e', 'k', 'o'),
            Trigram(' ', 'n', 'a'),
            Trigram('k', 'a', 't'),
            Trigram('l', 'a', 'n'),
            Trigram('h', 'e', ' '),
            Trigram('h', 'a', 'k'),
            Trigram(' ', 'e', 'z'),
            Trigram('o', ' ', 'a'),
            Trigram('k', 'w', 'a'),
            Trigram('o', ' ', 'o'),
            Trigram('a', 'y', 'o'),
            Trigram('o', 'k', 'w'),
            Trigram('k', 'u', 't'),
            Trigram('k', 'u', 'b'),
            Trigram('l', 'w', 'e'),
            Trigram(' ', 'e', 'm'),
            Trigram('y', 'o', ' '),
            Trigram('n', 'z', 'i'),
            Trigram('a', 'n', 'e'),
            Trigram('o', 'b', 'u'),
            Trigram(' ', 'o', 'k'),
            Trigram('e', 't', 'h'),
            Trigram('h', 'e', 't'),
            Trigram('i', 's', 'e'),
            Trigram('s', 'o', ' '),
            Trigram('i', 'l', 'e'),
            Trigram('n', 'o', 'k'),
            Trigram(' ', 'b', 'a'),
            Trigram('b', 'e', 'n'),
            Trigram('e', 'k', 'i'),
            Trigram('n', 'y', 'e'),
            Trigram('i', 'k', 'e'),
            Trigram('i', ' ', 'k'),
            Trigram('i', 's', 'i'),
            Trigram(' ', 'i', 's'),
            Trigram('a', 'p', 'h'),
            Trigram('e', 's', 'i'),
            Trigram('n', 'h', 'l'),
            Trigram('m', 'p', 'h'),
            Trigram(' ', 'a', 'b'),
            Trigram('f', 'a', 'n'),
            Trigram('e', ' ', 'i'),
            Trigram('i', 's', 'a'),
            Trigram(' ', 'y', 'e'),
            Trigram('n', 'e', 'n'),
            Trigram('i', 'n', 'i'),
            Trigram('g', 'a', ' '),
            Trigram('z', 'i', ' '),
            Trigram('f', 'u', 't'),
            Trigram(' ', 'f', 'u'),
            Trigram('u', 'b', 'a'),
            Trigram('u', 'k', 'h'),
            Trigram('k', 'a', ' '),
            Trigram('a', 'n', 't'),
            Trigram('u', 'h', 'l'),
            Trigram('h', 'o', 'l'),
            Trigram('b', 'a', ' '),
            Trigram('a', 'n', 'd'),
            Trigram('d', 'o', ' '),
            Trigram('k', 'u', 'k'),
            Trigram('a', 'b', 'e'),
            Trigram('z', 'a', ' '),
            Trigram('n', 'd', 'a'),
            Trigram(' ', 'y', 'a'),
            Trigram('e', ' ', 'w'),
            Trigram('k', 'i', 'l'),
            Trigram('t', 'h', 'e'),
            Trigram(' ', 'i', 'm'),
            Trigram('e', 'k', 'e'),
            Trigram('a', ' ', 'a'),
            Trigram('o', 'l', 'o'),
            Trigram('s', 'a', ' '),
            Trigram('o', 'l', 'u'),
            Trigram('i', 't', 'h'),
            Trigram('k', 'u', 'h'),
            Trigram('o', ' ', 'u'),
            Trigram('y', 'e', ' '),
            Trigram('n', 'i', 's'),
            Trigram(' ', 'i', 'n'),
            Trigram('e', 'k', 'h'),
            Trigram('e', ' ', 'e'),
            Trigram(' ', 'a', 'k'),
            Trigram('i', ' ', 'w'),
            Trigram('a', 'n', 'y'),
            Trigram('k', 'h', 'u'),
            Trigram('e', 'n', 'g'),
            Trigram('e', 'l', 'i'),
            Trigram('y', 'o', 'k'),
            Trigram('n', 'e', ' '),
            Trigram('n', 'o', ' '),
            Trigram('u', 'm', 'e'),
            Trigram('n', 'd', 'l'),
            Trigram('i', 'p', 'h'),
            Trigram('a', 'm', 'b'),
            Trigram('e', 'm', 'p'),
            Trigram(' ', 'k', 'o'),
            Trigram('i', ' ', 'i'),
            Trigram(' ', 'l', 'e'),
            Trigram('i', 's', 'w'),
            Trigram('z', 'o', ' '),
            Trigram('a', ' ', 'o'),
            Trigram('e', 'm', 'i'),
            Trigram('u', 'n', 'y'),
            Trigram('m', 'e', 'l'),
            Trigram('e', 'k', 'a'),
            Trigram('m', 't', 'h'),
            Trigram('u', 'p', 'h'),
            Trigram('n', 'd', 'o'),
            Trigram('v', 'i', 'k'),
            Trigram(' ', 'y', 'o'),
            Trigram('h', 'l', 'o'),
            Trigram('a', 'l', 'o'),
            Trigram('k', 'u', 'f'),
            Trigram('y', 'e', 'n'),
            Trigram('e', 'n', 'h'),
            Trigram('o', ' ', 'w'),
            Trigram('n', 'a', 'y'),
            Trigram('l', 'i', 'n'),
            Trigram('h', 'u', 'l'),
            Trigram('e', 'z', 'w'),
            Trigram('i', 'n', 'd'),
            Trigram('e', 'z', 'e'),
            Trigram('e', 'b', 'e'),
            Trigram('k', 'a', 'n'),
            Trigram('k', 'u', 'z'),
            Trigram('p', 'h', 'e'),
            Trigram('k', 'u', 'g'),
            Trigram('n', 'e', 'z'),
            Trigram('a', 'k', 'e'),
            Trigram('n', 'y', 'a'),
            Trigram('w', 'e', 'z'),
            Trigram('w', 'a', 'm'),
            Trigram('s', 'e', 'b'),
            Trigram('u', 'f', 'a'),
            Trigram('b', 'o', ' '),
            Trigram('d', 'i', 'n'),
            Trigram('a', 'h', 'l'),
            Trigram('a', 'z', 'w'),
            Trigram('f', 'u', 'n'),
            Trigram('y', 'e', 'z'),
            Trigram('u', 'n', 'd'),
            Trigram('a', ' ', 'l'),
            Trigram('l', 'i', ' '),
            Trigram('b', 'u', 's'),
            Trigram('a', 'l', 'e'),
            Trigram('u', 'l', 'a'),
            Trigram('k', 'u', 'q'),
            Trigram('o', 'l', 'a'),
            Trigram('i', 'z', 'i'),
            Trigram('i', 'n', 'k'),
            Trigram('i', ' ', 'e'),
            Trigram('d', 'a', ' '),
            Trigram('n', 'a', 'n'),
            Trigram('a', 's', 'e'),
            Trigram('p', 'h', 'i'),
            Trigram('a', 'n', 'o'),
            Trigram('n', 'e', 'm'),
            Trigram('h', 'e', 'l'),
            Trigram('a', ' ', 'y'),
            Trigram('h', 'u', 't'),
            Trigram('k', 'i', 's'),
            Trigram('k', 'u', 'p'),
            Trigram('s', 'w', 'a'),
            Trigram('h', 'a', 'n'),
            Trigram('i', 'l', 'i'),
            Trigram('m', 'b', 'i'),
            Trigram('k', 'u', 'v'),
            Trigram('o', ' ', 'k'),
            Trigram('k', 'e', 'k'),
            Trigram('o', 'm', 'p'),
            Trigram('p', 'h', 'o'),
            Trigram('k', 'o', 'l'),
            Trigram('i', ' ', 'u'),
            Trigram('o', 'k', 'o'),
            Trigram('i', 'z', 'w'),
            Trigram('l', 'o', 'n'),
            Trigram('e', ' ', 'l'),
            Trigram(' ', 'e', 'l'),
            Trigram('u', 'k', 'e'),
            Trigram('k', 'u', 's'),
            Trigram('k', 'o', 'm'),
            Trigram('u', 'l', 'o'),
            Trigram('z', 'i', 's'),
            Trigram('h', 'u', 'n'),
            Trigram('n', 'j', 'e'),
            Trigram('l', 'a', 'k'),
            Trigram('u', ' ', 'n'),
            Trigram('h', 'u', 'k'),
            Trigram('s', 'e', 'k'),
            Trigram('h', 'a', 'm'),
            Trigram(' ', 'o', 'l'),
            Trigram('a', 'n', 'i'),
            Trigram('o', ' ', 'i'),
            Trigram('u', 'b', 'u'),
            Trigram('m', 'b', 'a'),
            Trigram(' ', 'a', 'm'),
        ],
    ),
    (
        Lang::Swe,
        &[
            Trigram(' ', 'o', 'c'),
            Trigram('o', 'c', 'h'),
            Trigram('c', 'h', ' '),
            Trigram('e', 'r', ' '),
            Trigram('i', 'n', 'g'),
            Trigram('f', 'ö', 'r'),
            Trigram('t', 't', ' '),
            Trigram('a', 'r', ' '),
            Trigram('e', 'n', ' '),
            Trigram('ä', 't', 't'),
            Trigram('n', 'd', 'e'),
            Trigram(' ', 'f', 'ö'),
            Trigram('r', 'ä', 't'),
            Trigram('i', 'l', 'l'),
            Trigram('e', 't', ' '),
            Trigram('a', 'n', 'd'),
            Trigram(' ', 'r', 'ä'),
            Trigram(' ', 'e', 'n'),
            Trigram(' ', 't', 'i'),
            Trigram(' ', 'd', 'e'),
            Trigram('t', 'i', 'l'),
            Trigram('h', 'e', 't'),
            Trigram('l', 'l', ' '),
            Trigram('d', 'e', ' '),
            Trigram('o', 'm', ' '),
            Trigram('v', 'a', 'r'),
            Trigram('l', 'i', 'g'),
            Trigram('g', 'e', 'n'),
            Trigram(' ', 'f', 'r'),
            Trigram('e', 'l', 'l'),
            Trigram('s', 'k', 'a'),
            Trigram('n', 'i', 'n'),
            Trigram('n', 'g', ' '),
            Trigram('t', 'e', 'r'),
            Trigram(' ', 'h', 'a'),
            Trigram('a', 's', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram('k', 'a', ' '),
            Trigram('a', 't', 't'),
            Trigram('l', 'l', 'e'),
            Trigram('d', 'e', 'r'),
            Trigram('s', 'a', 'm'),
            Trigram(' ', 'i', ' '),
            Trigram('u', 'n', 'd'),
            Trigram('l', 'l', 'a'),
            Trigram('g', 'h', 'e'),
            Trigram('f', 'r', 'i'),
            Trigram('a', 'l', 'l'),
            Trigram('e', 'n', 's'),
            Trigram('e', 't', 'e'),
            Trigram('n', 'a', ' '),
            Trigram('l', 'e', 'r'),
            Trigram(' ', 'a', 't'),
            Trigram('ö', 'r', ' '),
            Trigram('d', 'e', 'n'),
            Trigram(' ', 'e', 'l'),
            Trigram('a', 'v', ' '),
            Trigram(' ', 'a', 'v'),
            Trigram(' ', 's', 'o'),
            Trigram('i', 'g', 'h'),
            Trigram('r', ' ', 'h'),
            Trigram('n', 'v', 'a'),
            Trigram('g', 'a', ' '),
            Trigram('r', ' ', 'r'),
            Trigram('e', 'n', 'v'),
            Trigram('l', 'a', ' '),
            Trigram('t', 'i', 'g'),
            Trigram('n', 's', 'k'),
            Trigram('i', 'g', 'a'),
            Trigram('h', 'a', 'r'),
            Trigram('t', ' ', 'a'),
            Trigram('s', 'o', 'm'),
            Trigram('t', 't', 'i'),
            Trigram(' ', 'u', 't'),
            Trigram('i', 'o', 'n'),
            Trigram('t', ' ', 't'),
            Trigram('a', ' ', 's'),
            Trigram('n', 'g', 'e'),
            Trigram('n', 's', ' '),
            Trigram('a', ' ', 'f'),
            Trigram('r', ' ', 's'),
            Trigram('m', 'ä', 'n'),
            Trigram('a', ' ', 'o'),
            Trigram(' ', 's', 'k'),
            Trigram(' ', 's', 'i'),
            Trigram('r', 'n', 'a'),
            Trigram('i', 's', 'k'),
            Trigram('a', 'n', ' '),
            Trigram(' ', 's', 't'),
            Trigram('ä', 'r', ' '),
            Trigram('r', 'a', ' '),
            Trigram(' ', 'v', 'i'),
            Trigram(' ', 'a', 'l'),
            Trigram('t', ' ', 'f'),
            Trigram(' ', 's', 'a'),
            Trigram('a', ' ', 'r'),
            Trigram('a', 't', 'i'),
            Trigram(' ', 'ä', 'r'),
            Trigram(' ', 'm', 'e'),
            Trigram(' ', 'b', 'e'),
            Trigram('n', ' ', 's'),
            Trigram(' ', 'a', 'n'),
            Trigram('t', 'i', 'o'),
            Trigram('n', 'n', 'a'),
            Trigram('l', 'a', 'n'),
            Trigram('e', 'r', 'n'),
            Trigram('t', ' ', 'e'),
            Trigram('m', 'e', 'd'),
            Trigram(' ', 'v', 'a'),
            Trigram('i', 'g', ' '),
            Trigram('ä', 'n', 's'),
            Trigram(' ', 'å', 't'),
            Trigram('s', 't', 'a'),
            Trigram('t', 'a', ' '),
            Trigram('n', 'a', 't'),
            Trigram(' ', 'u', 'n'),
            Trigram('k', 'l', 'i'),
            Trigram('t', 'e', 'n'),
            Trigram(' ', 'g', 'r'),
            Trigram('v', 'i', 's'),
            Trigram('ä', 'l', 'l'),
            Trigram(' ', 'l', 'a'),
            Trigram('o', 'n', 'e'),
            Trigram('h', 'a', 'n'),
            Trigram('ä', 'n', 'd'),
            Trigram('t', ' ', 's'),
            Trigram('s', 't', 'ä'),
            Trigram('t', ' ', 'i'),
            Trigram('n', 'e', 'r'),
            Trigram('a', 'n', 's'),
            Trigram('g', 'r', 'u'),
            Trigram(' ', 'g', 'e'),
            Trigram('v', 'e', 'r'),
            Trigram(' ', 'm', 'å'),
            Trigram(' ', 'l', 'i'),
            Trigram('l', 'i', 'k'),
            Trigram('i', 'h', 'e'),
            Trigram('e', 'r', 's'),
            Trigram('r', 'i', 'h'),
            Trigram('r', ' ', 'a'),
            Trigram(' ', 'r', 'e'),
            Trigram('m', 'å', ' '),
            Trigram('s', 'n', 'i'),
            Trigram('n', ' ', 'f'),
            Trigram('t', ' ', 'o'),
            Trigram(' ', 'm', 'ä'),
            Trigram(' ', 'n', 'a'),
            Trigram('r', ' ', 'e'),
            Trigram('r', 'i', ' '),
            Trigram('a', 'd', ' '),
            Trigram('e', 'n', 't'),
            Trigram('k', 'l', 'a'),
            Trigram('d', 'e', 't'),
            Trigram(' ', 'v', 'ä'),
            Trigram('r', 'u', 'n'),
            Trigram('r', 'k', 'l'),
            Trigram('d', 'a', ' '),
            Trigram('h', ' ', 'r'),
            Trigram('u', 'p', 'p'),
            Trigram('d', 'r', 'a'),
            Trigram('r', 'i', 'n'),
            Trigram('i', 'g', 't'),
            Trigram('d', 'i', 'g'),
            Trigram('n', ' ', 'e'),
            Trigram('e', 'r', 'k'),
            Trigram('k', 'a', 'p'),
            Trigram('t', 't', 'a'),
            Trigram('e', 'd', ' '),
            Trigram('d', ' ', 'f'),
            Trigram('r', 'a', 'n'),
            Trigram('e', ' ', 's'),
            Trigram('t', 'a', 'n'),
            Trigram('u', 't', 'a'),
            Trigram('n', 'o', 'm'),
            Trigram('l', 'a', 'r'),
            Trigram('g', 't', ' '),
            Trigram('s', ' ', 'f'),
            Trigram(' ', 'p', 'å'),
            Trigram(' ', 'o', 'm'),
            Trigram('k', 't', 'e'),
            Trigram('l', 'i', 'n'),
            Trigram('r', ' ', 'u'),
            Trigram('v', 'i', 'd'),
            Trigram('g', ' ', 'o'),
            Trigram('ä', 'n', 'n'),
            Trigram('e', 'r', 'v'),
            Trigram('i', 'k', 'a'),
            Trigram('a', 'r', 'i'),
            Trigram('a', ' ', 'i'),
            Trigram('l', 'a', 'g'),
            Trigram('r', 'v', 'i'),
            Trigram('i', 'd', ' '),
            Trigram('r', ' ', 'o'),
            Trigram('s', ' ', 's'),
            Trigram('v', 'i', 'l'),
            Trigram('r', ' ', 'm'),
            Trigram('ö', 'r', 'k'),
            Trigram('o', 't', ' '),
            Trigram('n', 'd', 'l'),
            Trigram('s', 't', 'r'),
            Trigram('e', 'l', 's'),
            Trigram('r', 'o', ' '),
            Trigram('a', ' ', 'm'),
            Trigram('m', 'o', 't'),
            Trigram(' ', 'm', 'o'),
            Trigram('i', ' ', 'o'),
            Trigram('p', 'å', ' '),
            Trigram('r', ' ', 'd'),
            Trigram('o', 'n', ' '),
            Trigram('d', 'e', 'l'),
            Trigram('i', 's', 'n'),
            Trigram('s', 'k', 'y'),
            Trigram('e', ' ', 'm'),
            Trigram('r', 'a', 's'),
            Trigram(' ', 'h', 'ä'),
            Trigram('r', ' ', 'f'),
            Trigram('i', ' ', 's'),
            Trigram('a', ' ', 'n'),
            Trigram('n', 'a', 'd'),
            Trigram('n', ' ', 'o'),
            Trigram('g', 'a', 'n'),
            Trigram('t', 'n', 'i'),
            Trigram('e', 'r', 'a'),
            Trigram('ä', 'r', 'd'),
            Trigram('a', ' ', 'd'),
            Trigram('t', 'ä', 'l'),
            Trigram('b', 'e', 'r'),
            Trigram('n', 'g', 'a'),
            Trigram('r', ' ', 'i'),
            Trigram('e', 'n', 'n'),
            Trigram('n', 'd', ' '),
            Trigram('n', ' ', 'a'),
            Trigram(' ', 'u', 'p'),
            Trigram('s', 'i', 'n'),
            Trigram('d', 'd', ' '),
            Trigram('ö', 'r', 's'),
            Trigram('j', 'e', ' '),
            Trigram('i', 't', 't'),
            Trigram('k', 'a', 'l'),
            Trigram('n', ' ', 'm'),
            Trigram('a', 'm', 't'),
            Trigram('n', ' ', 'i'),
            Trigram('k', 'i', 'l'),
            Trigram('l', 's', 'e'),
            Trigram('s', 'k', 'i'),
            Trigram('n', 'a', 's'),
            Trigram('e', 'n', 'd'),
            Trigram('s', ' ', 'e'),
            Trigram(' ', 's', 'å'),
            Trigram('i', 'n', 'n'),
            Trigram('t', 'a', 't'),
            Trigram('p', 'e', 'r'),
            Trigram('t', ' ', 'v'),
            Trigram('a', 'r', 'j'),
            Trigram('e', ' ', 'f'),
            Trigram('l', ' ', 'a'),
            Trigram('r', 'e', 'l'),
            Trigram('t', ' ', 'b'),
            Trigram('i', 'n', 't'),
            Trigram('t', 'e', 't'),
            Trigram('g', ' ', 'a'),
            Trigram('ö', 'r', 'a'),
            Trigram('l', ' ', 'v'),
            Trigram('k', 'y', 'd'),
            Trigram('y', 'd', 'd'),
            Trigram('r', 'j', 'e'),
            Trigram(' ', 'f', 'a'),
            Trigram('b', 'e', 't'),
            Trigram('s', 'e', ' '),
            Trigram('t', ' ', 'l'),
            Trigram('l', 'i', 't'),
            Trigram('s', 'a', ' '),
            Trigram('n', 'ä', 'r'),
            Trigram('h', 'ä', 'l'),
            Trigram('l', ' ', 's'),
            Trigram('n', 'd', 'r'),
            Trigram('n', 'i', 's'),
            Trigram('y', 'c', 'k'),
            Trigram('h', ' ', 'a'),
            Trigram('l', 'l', 'm'),
            Trigram('l', 'k', 'e'),
            Trigram('h', ' ', 'f'),
            Trigram('a', 'r', 'b'),
            Trigram('l', 'm', 'ä'),
            Trigram('n', 'd', 'a'),
            Trigram('b', 'a', 'r'),
            Trigram('c', 'k', 'l'),
            Trigram('v', ' ', 's'),
            Trigram('r', 'ä', 'n'),
            Trigram('g', 'a', 'r'),
            Trigram('t', 'r', 'a'),
            Trigram('r', 'e', ' '),
            Trigram('e', 'g', 'e'),
            Trigram('r', ' ', 'g'),
            Trigram('a', 'r', 'a'),
            Trigram('e', 's', 's'),
            Trigram('d', ' ', 'e'),
            Trigram('v', 'ä', 'r'),
            Trigram('m', 't', ' '),
            Trigram('a', 'p', ' '),
        ],
    ),
    (
        Lang::Aka,
        &[
            Trigram('s', 'ɛ', ' '),
            Trigram('a', ' ', 'a'),
            Trigram(' ', 's', 'ɛ'),
            Trigram('n', 'e', ' '),
            Trigram('r', 'a', ' '),
            Trigram('a', ' ', 'n'),
            Trigram(' ', 'w', 'ɔ'),
            Trigram(' ', 'a', ' '),
            Trigram('a', 'r', 'a'),
            Trigram('a', 'n', ' '),
            Trigram('e', 'ɛ', ' '),
            Trigram('n', 'o', ' '),
            Trigram(' ', 'n', 'e'),
            Trigram(' ', 'b', 'i'),
            Trigram(' ', 'n', 'o'),
            Trigram(' ', 'a', 's'),
            Trigram('i', 'a', 'r'),
            Trigram('b', 'i', 'a'),
            Trigram('y', 'ɛ', ' '),
            Trigram('m', 'u', ' '),
            Trigram('a', 'a', ' '),
            Trigram(' ', 'a', 'n'),
            Trigram('ɛ', ' ', 's'),
            Trigram('e', ' ', 'a'),
            Trigram('m', 'a', ' '),
            Trigram(' ', 'h', 'o'),
            Trigram('b', 'i', ' '),
            Trigram('m', 'a', 'n'),
            Trigram('d', 'e', 'ɛ'),
            Trigram(' ', 'm', 'u'),
            Trigram('h', 'o', ' '),
            Trigram('ɛ', ' ', 'a'),
            Trigram('n', 'a', ' '),
            Trigram('a', ' ', 'ɛ'),
            Trigram(' ', 'o', 'b'),
            Trigram('o', 'b', 'i'),
            Trigram('e', ' ', 'n'),
            Trigram('a', ' ', 'b'),
            Trigram('n', ' ', 'a'),
            Trigram('s', 'o', ' '),
            Trigram('o', ' ', 'n'),
            Trigram('p', 'a', ' '),
            Trigram('a', 'm', 'a'),
            Trigram('ɛ', ' ', 'o'),
            Trigram('o', ' ', 'a'),
            Trigram('i', 'p', 'a'),
            Trigram('n', 'i', 'p'),
            Trigram('ɛ', ' ', 'n'),
            Trigram('n', 'a', 'a'),
            Trigram(' ', 'n', 'a'),
            Trigram('a', ' ', 'w'),
            Trigram('a', 'n', 'a'),
            Trigram(' ', 's', 'o'),
            Trigram(' ', 'a', 'd'),
            Trigram(' ', 'n', 'n'),
            Trigram('ɛ', ' ', 'ɔ'),
            Trigram('ɛ', 'd', 'e'),
            Trigram('a', 's', 'ɛ'),
            Trigram('k', 'w', 'a'),
            Trigram(' ', 'o', 'n'),
            Trigram('o', 'n', 'i'),
            Trigram('w', 'a', 'n'),
            Trigram(' ', 'a', 'm'),
            Trigram('a', ' ', 'ɔ'),
            Trigram('s', 'ɛ', 'd'),
            Trigram('w', 'ɔ', ' '),
            Trigram(' ', 'a', 'h'),
            Trigram('ɛ', 'y', 'ɛ'),
            Trigram(' ', 'n', 'y'),
            Trigram('o', 'ɔ', ' '),
            Trigram(' ', 'n', ' '),
            Trigram('m', 'm', 'a'),
            Trigram('i', ' ', 'a'),
            Trigram(' ', 'm', 'm'),
            Trigram('n', 'n', 'i'),
            Trigram(' ', 'k', 'w'),
            Trigram('i', 'e', ' '),
            Trigram('w', 'ɔ', 'n'),
            Trigram('ɛ', ' ', 'w'),
            Trigram('d', 'e', ' '),
            Trigram(' ', 'ɛ', 'y'),
            Trigram(' ', 'b', 'a'),
            Trigram('a', 's', 'e'),
            Trigram('ɔ', ' ', 'n'),
            Trigram('o', ' ', 'b'),
            Trigram('i', ' ', 'm'),
            Trigram('ɔ', ' ', 'a'),
            Trigram('u', 'o', ' '),
            Trigram('n', ' ', 'n'),
            Trigram('a', ' ', 'm'),
            Trigram('o', ' ', 's'),
            Trigram('i', 'r', 'i'),
            Trigram(' ', 'y', 'i'),
            Trigram('n', 'i', ' '),
            Trigram('e', ' ', 's'),
            Trigram('n', 'y', 'i'),
            Trigram('d', 'i', ' '),
            Trigram('u', ' ', 'n'),
            Trigram('a', ' ', 'o'),
            Trigram('a', 'h', 'o'),
            Trigram(' ', 'd', 'e'),
            Trigram('t', 'u', 'm'),
            Trigram(' ', 'ɛ', 'n'),
            Trigram('ɔ', 'n', ' '),
            Trigram('n', 'y', 'a'),
            Trigram('i', ' ', 'n'),
            Trigram('ɔ', 'm', 'a'),
            Trigram('e', ' ', 'm'),
            Trigram('a', 'd', 'w'),
            Trigram(' ', 'y', 'ɛ'),
            Trigram('u', 'm', 'i'),
            Trigram('d', 'i', 'e'),
            Trigram('m', 'i', ' '),
            Trigram('ɛ', ' ', 'ɛ'),
            Trigram('o', ' ', 'k'),
            Trigram(' ', 'a', 'b'),
            Trigram('ɛ', 'm', ' '),
            Trigram('a', ' ', 's'),
            Trigram(' ', 'm', 'a'),
            Trigram('n', 'a', 'm'),
            Trigram(' ', 'ɔ', 'm'),
            Trigram(' ', 'ɛ', 's'),
            Trigram('y', 'i', 'n'),
            Trigram(' ', 'a', 't'),
            Trigram(' ', 'b', 'ɔ'),
            Trigram('o', ' ', 'd'),
            Trigram('i', 'n', 'a'),
            Trigram('p', 'ɛ', ' '),
            Trigram('s', 'ɛ', 'm'),
            Trigram('u', 'a', ' '),
            Trigram('n', ' ', 's'),
            Trigram('b', 'ɔ', ' '),
            Trigram('a', 'd', 'i'),
            Trigram('y', 'a', ' '),
            Trigram('e', ' ', 'h'),
            Trigram('a', 's', 'o'),
            Trigram('m', 'a', 'r'),
            Trigram('a', 'n', 'i'),
            Trigram('k', 'u', 'o'),
            Trigram('r', 'ɛ', ' '),
            Trigram('f', 'a', ' '),
            Trigram('a', ' ', 'k'),
            Trigram('ɔ', 'd', 'e'),
            Trigram('a', ' ', 'h'),
            Trigram('b', 'a', ' '),
            Trigram('n', ' ', 'b'),
            Trigram('r', 'e', ' '),
            Trigram('u', 'm', 'a'),
            Trigram('w', 'u', 'm'),
            Trigram('o', 'm', ' '),
            Trigram('ɔ', ' ', 'h'),
            Trigram('m', ' ', 'n'),
            Trigram('y', 'i', ' '),
            Trigram('u', ' ', 'a'),
            Trigram(' ', 's', 'a'),
            Trigram('s', 'e', ' '),
            Trigram('d', 'w', 'u'),
            Trigram('ɔ', ' ', 'b'),
            Trigram(' ', 'n', 't'),
            Trigram('m', ' ', 'a'),
            Trigram('e', 'r', 'ɛ'),
            Trigram(' ', 'k', 'ɔ'),
            Trigram('a', ' ', 'y'),
            Trigram('o', 'r', 'ɔ'),
            Trigram(' ', 'n', 'k'),
            Trigram(' ', 'b', 'ɛ'),
            Trigram(' ', 'ɔ', 'd'),
            Trigram('t', 'e', 'n'),
            Trigram('r', 'ɔ', ' '),
            Trigram('h', 'y', 'ɛ'),
            Trigram('s', 'a', 'a'),
            Trigram('k', 'a', ' '),
            Trigram('ɛ', ' ', 'b'),
            Trigram('e', ' ', 'b'),
            Trigram('i', ' ', 's'),
            Trigram('a', 'd', 'e'),
            Trigram('a', 'm', ' '),
            Trigram('n', 'k', 'a'),
            Trigram('k', 'o', 'r'),
            Trigram('i', ' ', 'ɛ'),
            Trigram('e', 'n', 'e'),
            Trigram('e', 'n', 'a'),
            Trigram(' ', 'n', 's'),
            Trigram('b', 'a', 'n'),
            Trigram('ɛ', 'n', 's'),
            Trigram(' ', 'k', 'u'),
            Trigram('ɛ', 's', 'ɛ'),
            Trigram('a', 'n', 'e'),
            Trigram('n', 's', 'ɛ'),
            Trigram('f', 'o', 'f'),
            Trigram('ɛ', 'ɛ', ' '),
            Trigram(' ', 'f', 'i'),
            Trigram('g', 'y', 'e'),
            Trigram('ɔ', 't', 'u'),
            Trigram(' ', 'd', 'i'),
            Trigram('a', 'n', 'o'),
            Trigram('i', ' ', 'k'),
            Trigram('o', ' ', 'm'),
            Trigram(' ', 'ɔ', 't'),
            Trigram(' ', 'k', 'o'),
            Trigram('y', 'ɛ', 'ɛ'),
            Trigram('b', 'i', 'r'),
            Trigram(' ', 'a', 'k'),
            Trigram('i', 'm', ' '),
            Trigram('k', 'y', 'e'),
            Trigram(' ', 'p', 'ɛ'),
            Trigram('a', ' ', 'd'),
            Trigram('y', 'i', 'e'),
            Trigram('k', 'o', ' '),
            Trigram('n', 't', 'i'),
            Trigram('i', ' ', 'b'),
            Trigram('e', 't', 'e'),
            Trigram('o', 'f', 'o'),
            Trigram('a', 'm', 'm'),
            Trigram('y', 'e', ' '),
            Trigram('r', 'i', ' '),
            Trigram('f', 'o', 'ɔ'),
            Trigram('k', 'ɔ', ' '),
            Trigram('b', 'o', 'm'),
            Trigram('a', 'b', 'o'),
            Trigram('ɔ', ' ', 's'),
            Trigram('ɔ', 'n', 'e'),
            Trigram(' ', 'ɛ', 'b'),
            Trigram('s', 'o', 'ɔ'),
            Trigram('f', 'o', 'r'),
            Trigram('i', 's', 'ɛ'),
            Trigram('m', ' ', 'k'),
            Trigram('a', 's', 'a'),
            Trigram('n', 'o', 'd'),
            Trigram('ɛ', ' ', 'm'),
            Trigram('f', 'i', 'r'),
            Trigram('t', 'i', ' '),
            Trigram(' ', 'd', 'a'),
            Trigram('e', ' ', 'y'),
            Trigram('s', 'u', 'a'),
            Trigram(' ', 'b', 'e'),
            Trigram('n', 'i', 'i'),
            Trigram('s', 'e', 'ɛ'),
            Trigram('w', 'a', ' '),
            Trigram('b', 'e', 'r'),
            Trigram(' ', 'a', 'w'),
            Trigram('d', 'w', 'e'),
            Trigram('n', ' ', 'f'),
            Trigram(' ', 'f', 'o'),
            Trigram('o', ' ', 'ɛ'),
            Trigram('i', ' ', 'h'),
            Trigram('u', ' ', 'b'),
            Trigram('ɔ', ' ', 'm'),
            Trigram(' ', 'm', 'f'),
            Trigram('h', 'ɔ', ' '),
            Trigram('k', 'a', 'b'),
            Trigram('w', 'ɛ', ' '),
            Trigram('t', 'o', ' '),
            Trigram('r', 'i', 'b'),
            Trigram('h', 'w', 'ɛ'),
            Trigram('i', 'b', 'i'),
            Trigram(' ', 'd', 'w'),
            Trigram('d', 'i', 's'),
            Trigram('n', 's', 'o'),
            Trigram('a', 'n', 's'),
            Trigram('t', 'i', 'r'),
            Trigram('u', ' ', 'ɛ'),
            Trigram(' ', 't', 'i'),
            Trigram(' ', 'h', 'ɔ'),
            Trigram('s', 'a', ' '),
            Trigram('e', ' ', 'o'),
            Trigram(' ', 't', 'u'),
            Trigram('o', 'd', 'i'),
            Trigram('ɛ', ' ', 'y'),
            Trigram('i', 'a', ' '),
            Trigram('o', 'f', 'a'),
            Trigram(' ', 'ɔ', 'n'),
            Trigram('o', ' ', 'w'),
            Trigram('ɛ', 'b', 'ɛ'),
            Trigram('a', 'b', 'a'),
            Trigram(' ', 'k', 'a'),
            Trigram('i', 'i', ' '),
            Trigram('w', 'e', 'n'),
            Trigram('ɛ', 's', 'i'),
            Trigram('m', ' ', 'm'),
            Trigram('s', 'i', 'a'),
            Trigram('a', 'd', 'a'),
            Trigram('y', 'e', 'r'),
            Trigram('i', 'a', 'n'),
            Trigram('d', 'a', ' '),
            Trigram('s', 'e', 't'),
            Trigram(' ', 'g', 'y'),
            Trigram('d', 'u', 'a'),
            Trigram('i', ' ', 'd'),
            Trigram('s', 'o', 'm'),
            Trigram('m', 'f', 'a'),
            Trigram('ɔ', ' ', 'w'),
            Trigram(' ', 'a', 'f'),
            Trigram('i', ' ', 'y'),
            Trigram('a', 'n', 'y'),
            Trigram('o', 'r', 'a'),
            Trigram('r', 'i', 'm'),
            Trigram('w', 'ɔ', 'd'),
            Trigram('d', 'w', 'a'),
            Trigram('n', 's', 'i'),
        ],
    ),
    (
        Lang::Sna,
        &[
            Trigram('w', 'a', ' '),
            Trigram('a', ' ', 'k'),
            Trigram('a', 'n', 'a'),
            Trigram('r', 'o', ' '),
            Trigram('n', 'a', ' '),
            Trigram(' ', 'k', 'u'),
            Trigram(' ', 'm', 'u'),
            Trigram('n', 'h', 'u'),
            Trigram('d', 'z', 'e'),
            Trigram('h', 'u', ' '),
            Trigram('a', ' ', 'm'),
            Trigram(' ', 'z', 'v'),
            Trigram('m', 'u', 'n'),
            Trigram('o', 'k', 'u'),
            Trigram('c', 'h', 'i'),
            Trigram('a', ' ', 'n'),
            Trigram('a', 'k', 'a'),
            Trigram('d', 'z', 'i'),
            Trigram('k', 'a', ' '),
            Trigram('z', 'e', 'r'),
            Trigram('e', 'r', 'o'),
            Trigram(' ', 'c', 'h'),
            Trigram('c', 'h', 'e'),
            Trigram('s', 'e', ' '),
            Trigram('u', 'n', 'h'),
            Trigram('o', 'd', 'z'),
            Trigram('r', 'w', 'a'),
            Trigram('r', 'a', ' '),
            Trigram('k', 'o', 'd'),
            Trigram('z', 'v', 'i'),
            Trigram(' ', 'n', 'e'),
            Trigram(' ', 'p', 'a'),
            Trigram('k', 'a', 'n'),
            Trigram(' ', 'w', 'e'),
            Trigram(' ', 'd', 'z'),
            Trigram(' ', 'n', 'o'),
            Trigram('i', 'k', 'a'),
            Trigram('v', 'a', ' '),
            Trigram('i', 'r', 'i'),
            Trigram(' ', 'a', 'n'),
            Trigram('k', 'u', 't'),
            Trigram('n', 'y', 'i'),
            Trigram('o', ' ', 'y'),
            Trigram('y', 'i', 'k'),
            Trigram('v', 'a', 'n'),
            Trigram('n', 'e', 'k'),
            Trigram('e', 's', 'e'),
            Trigram('e', 'k', 'o'),
            Trigram('z', 'v', 'a'),
            Trigram('i', 'd', 'z'),
            Trigram('e', ' ', 'a'),
            Trigram(' ', 'k', 'a'),
            Trigram('a', 'n', 'e'),
            Trigram('a', 'n', 'o'),
            Trigram('n', 'g', 'u'),
            Trigram('e', 'k', 'u'),
            Trigram('c', 'h', 'a'),
            Trigram('u', 'n', 'g'),
            Trigram(' ', 'y', 'o'),
            Trigram('r', 'i', ' '),
            Trigram('a', 'k', 'e'),
            Trigram('k', 'e', ' '),
            Trigram('a', 'c', 'h'),
            Trigram('u', 'd', 'z'),
            Trigram('i', 'r', 'o'),
            Trigram('a', ' ', 'z'),
            Trigram('u', ' ', 'w'),
            Trigram(' ', 'v', 'a'),
            Trigram('i', 'r', 'a'),
            Trigram('w', 'e', 's'),
            Trigram('a', 'n', 'g'),
            Trigram('e', 'c', 'h'),
            Trigram('n', 'g', 'e'),
            Trigram('i', ' ', 'p'),
            Trigram('e', 'n', 'g'),
            Trigram('y', 'o', 'k'),
            Trigram('n', 'o', 'k'),
            Trigram('e', 'd', 'z'),
            Trigram('o', ' ', 'i'),
            Trigram('i', 'r', 'w'),
            Trigram('a', 'n', 'i'),
            Trigram('i', 'n', 'o'),
            Trigram('u', 'v', 'a'),
            Trigram('i', 'c', 'h'),
            Trigram('n', 'g', 'a'),
            Trigram('t', 'i', ' '),
            Trigram('z', 'i', 'r'),
            Trigram('a', 'n', 'h'),
            Trigram('r', 'i', 'r'),
            Trigram('k', 'o', ' '),
            Trigram('d', 'z', 'a'),
            Trigram('o', ' ', 'n'),
            Trigram('w', 'a', 'n'),
            Trigram('w', 'o', ' '),
            Trigram('t', 'a', 'n'),
            Trigram('s', 'u', 'n'),
            Trigram('i', 'p', 'i'),
            Trigram('d', 'z', 'w'),
            Trigram('e', 'n', 'y'),
            Trigram('a', 's', 'i'),
            Trigram('h', 'e', 'n'),
            Trigram('z', 'v', 'e'),
            Trigram('k', 'u', 'r'),
            Trigram('v', 'a', 'k'),
            Trigram('a', ' ', 'p'),
            Trigram('s', 'h', 'a'),
            Trigram('u', 'n', 'u'),
            Trigram('z', 'w', 'a'),
            Trigram('i', 't', 'a'),
            Trigram('k', 'w', 'a'),
            Trigram('e', ' ', 'k'),
            Trigram('r', 'u', 'd'),
            Trigram('n', 'u', 'n'),
            Trigram('u', 'r', 'u'),
            Trigram('g', 'u', 'k'),
            Trigram('a', ' ', 'c'),
            Trigram('a', ' ', 'd'),
            Trigram(' ', 'y', 'a'),
            Trigram('a', ' ', 'y'),
            Trigram('b', 'a', 't'),
            Trigram('p', 'a', 's'),
            Trigram('e', 'z', 'v'),
            Trigram('t', 'a', ' '),
            Trigram('e', ' ', 'n'),
            Trigram('u', 't', 'i'),
            Trigram(' ', 'k', 'w'),
            Trigram('o', ' ', 'k'),
            Trigram('o', ' ', 'c'),
            Trigram('o', ' ', 'm'),
            Trigram('a', 'r', 'a'),
            Trigram(' ', 'm', 'a'),
            Trigram('s', 'i', ' '),
            Trigram('g', 'a', ' '),
            Trigram('u', 'k', 'o'),
            Trigram('a', 't', 'a'),
            Trigram('o', 's', 'e'),
            Trigram('e', 'm', 'a'),
            Trigram('d', 'z', 'o'),
            Trigram('u', 'c', 'h'),
            Trigram('h', 'i', 'p'),
            Trigram('k', 'u', 'v'),
            Trigram('n', 'o', ' '),
            Trigram('r', 'u', 's'),
            Trigram('h', 'e', 'c'),
            Trigram('o', 'm', 'u'),
            Trigram('i', ' ', 'z'),
            Trigram('w', 'a', 'k'),
            Trigram('o', ' ', 'r'),
            Trigram('k', 'u', 's'),
            Trigram('k', 'w', 'e'),
            Trigram('e', 'r', 'e'),
            Trigram('r', 'e', ' '),
            Trigram(' ', 'r', 'w'),
            Trigram(' ', 'p', 'o'),
            Trigram('o', ' ', 'a'),
            Trigram('m', 'w', 'e'),
            Trigram('y', 'a', 'k'),
            Trigram('m', 'o', ' '),
            Trigram('u', 's', 'u'),
            Trigram('i', 's', 'i'),
            Trigram('z', 'a', ' '),
            Trigram('s', 'a', ' '),
            Trigram('e', ' ', 'z'),
            Trigram('u', 't', 'a'),
            Trigram('g', 'a', 'r'),
            Trigram(' ', 'i', 'n'),
            Trigram('h', 'i', 'n'),
            Trigram('n', 'e', 'm'),
            Trigram('p', 'a', 'c'),
            Trigram('k', 'u', 'c'),
            Trigram('w', 'e', ' '),
            Trigram('e', 't', 'e'),
            Trigram(' ', 'y', 'e'),
            Trigram('t', 'w', 'a'),
            Trigram('p', 'o', 's'),
            Trigram('o', ' ', 'd'),
            Trigram('a', ' ', 'i'),
            Trigram('h', 'u', 'r'),
            Trigram('g', 'e', 't'),
            Trigram('a', 'r', 'i'),
            Trigram('o', 'n', 'g'),
            Trigram('p', 'a', 'n'),
            Trigram('e', 'r', 'w'),
            Trigram('u', 'k', 'a'),
            Trigram('r', 'w', 'o'),
            Trigram('v', 'o', ' '),
            Trigram(' ', 'a', 'k'),
            Trigram('t', 'e', 'm'),
            Trigram('z', 'o', ' '),
            Trigram('e', 'm', 'u'),
            Trigram('e', 'm', 'o'),
            Trigram('o', 'r', 'u'),
            Trigram(' ', 'h', 'a'),
            Trigram('u', 'i', 't'),
            Trigram('w', 'e', 'n'),
            Trigram('u', 'y', 'e'),
            Trigram('k', 'u', 'i'),
            Trigram(' ', 'u', 'y'),
            Trigram('v', 'i', 'n'),
            Trigram('h', 'a', 'k'),
            Trigram('k', 'u', 'b'),
            Trigram('i', ' ', 'm'),
            Trigram('a', ' ', 'a'),
            Trigram('k', 'u', 'd'),
            Trigram(' ', 's', 'e'),
            Trigram(' ', 'k', 'o'),
            Trigram('y', 'o', ' '),
            Trigram('a', 'n', 'd'),
            Trigram('d', 'a', ' '),
            Trigram('n', 'o', 'r'),
            Trigram('s', 'i', 'n'),
            Trigram('u', 'b', 'a'),
            Trigram('a', ' ', 's'),
            Trigram('a', ' ', 'u'),
            Trigram(' ', 'i', 'c'),
            Trigram('z', 'v', 'o'),
            Trigram('m', 'u', 't'),
            Trigram('m', 'a', 't'),
            Trigram('n', 'e', 'z'),
            Trigram('e', ' ', 'm'),
            Trigram('a', ' ', 'w'),
            Trigram('a', 'd', 'z'),
            Trigram('u', 'r', 'a'),
            Trigram('e', 'v', 'a'),
            Trigram('a', 'v', 'a'),
            Trigram('p', 'i', ' '),
            Trigram('a', ' ', 'r'),
            Trigram('e', 'r', 'a'),
            Trigram('u', 't', 'e'),
            Trigram('o', 'k', 'o'),
            Trigram('v', 'i', 's'),
            Trigram(' ', 'i', 'y'),
            Trigram('h', 'a', ' '),
            Trigram('u', ' ', 'a'),
            Trigram('h', 'a', 'n'),
            Trigram('c', 'h', 'o'),
            Trigram('a', 'r', 'u'),
            Trigram('a', 's', 'a'),
            Trigram('f', 'a', 'n'),
            Trigram('a', 'a', 'n'),
            Trigram('p', 'i', 'r'),
            Trigram('i', 'n', 'a'),
            Trigram('g', 'u', 'v'),
            Trigram('u', 's', 'h'),
            Trigram('t', 'o', 'n'),
            Trigram(' ', 'h', 'u'),
            Trigram('u', 'n', 'y'),
            Trigram('e', 'n', 'z'),
            Trigram('r', 'a', 'n'),
            Trigram('y', 'o', 'r'),
            Trigram('t', 'e', 'd'),
            Trigram('a', 'i', 't'),
            Trigram('h', 'e', 'k'),
            Trigram(' ', 'n', 'y'),
            Trigram('u', 'r', 'i'),
            Trigram('h', 'o', 'k'),
            Trigram('n', 'e', 'n'),
            Trigram('o', 's', 'h'),
            Trigram(' ', 'a', 'c'),
            Trigram('n', 'g', 'i'),
            Trigram('m', 'u', 'k'),
            Trigram('n', 'g', 'o'),
            Trigram('o', ' ', 'z'),
            Trigram('a', 'z', 'v'),
            Trigram('k', 'u', 'n'),
            Trigram('n', 'i', 'd'),
            Trigram('u', 'm', 'a'),
            Trigram('i', ' ', 'h'),
            Trigram('v', 'e', 'm'),
            Trigram('a', ' ', 'h'),
            Trigram('m', 'i', 'r'),
            Trigram('u', 's', 'a'),
            Trigram('o', ' ', 'p'),
            Trigram('i', ' ', 'n'),
            Trigram('a', ' ', 'v'),
            Trigram('i', ' ', 'k'),
            Trigram('a', 'm', 'b'),
            Trigram('z', 'a', 'n'),
            Trigram('n', 'z', 'a'),
            Trigram('k', 'u', 'z'),
            Trigram('z', 'i', ' '),
            Trigram('k', 'a', 'k'),
            Trigram('i', 'n', 'g'),
            Trigram('u', ' ', 'v'),
            Trigram('n', 'g', 'w'),
            Trigram('m', 'u', 'm'),
            Trigram('m', 'b', 'a'),
            Trigram('n', 'i', 'r'),
            Trigram('s', 'a', 'r'),
            Trigram('e', 'w', 'o'),
            Trigram('e', ' ', 'p'),
            Trigram('u', 'w', 'a'),
            Trigram('v', 'i', 'c'),
            Trigram('i', ' ', 'i'),
            Trigram('g', 'w', 'a'),
            Trigram('a', 'g', 'a'),
            Trigram('a', 'm', 'a'),
            Trigram('g', 'o', ' '),
            Trigram('y', 'e', 'w'),
            Trigram('p', 'a', 'm'),
        ],
    ),
    (
        Lang::Afr,
        &[
            Trigram('i', 'e', ' '),
            Trigram('d', 'i', 'e'),
            Trigram('e', 'n', ' '),
            Trigram(' ', 'd', 'i'),
            Trigram(' ', 'e', 'n'),
            Trigram('a', 'n', ' '),
            Trigram('i', 'n', 'g'),
            Trigram('n', 'g', ' '),
            Trigram('v', 'a', 'n'),
            Trigram(' ', 'v', 'a'),
            Trigram('t', 'e', ' '),
            Trigram('e', ' ', 'v'),
            Trigram('r', 'e', 'g'),
            Trigram(' ', 'r', 'e'),
            Trigram('n', ' ', 'd'),
            Trigram(' ', 'g', 'e'),
            Trigram('e', 'n', 's'),
            Trigram('e', 't', ' '),
            Trigram('e', ' ', 'r'),
            Trigram('e', ' ', 'e'),
            Trigram(' ', 't', 'e'),
            Trigram(' ', 'b', 'e'),
            Trigram('l', 'e', ' '),
            Trigram('v', 'e', 'r'),
            Trigram('e', 'e', 'n'),
            Trigram(' ', 'i', 'n'),
            Trigram('k', 'e', ' '),
            Trigram(' ', 'v', 'e'),
            Trigram(' ', 'h', 'e'),
            Trigram('e', 'g', ' '),
            Trigram('h', 'e', 't'),
            Trigram('l', 'k', 'e'),
            Trigram('l', 'i', 'k'),
            Trigram('n', ' ', 'h'),
            Trigram('d', 'e', ' '),
            Trigram('n', 'i', 'e'),
            Trigram('a', 'a', 'n'),
            Trigram('t', ' ', 'd'),
            Trigram('i', 'd', ' '),
            Trigram('m', 'e', 'n'),
            Trigram(' ', 'v', 'r'),
            Trigram('n', 'd', 'e'),
            Trigram('e', 'i', 'd'),
            Trigram('e', ' ', 'o'),
            Trigram(' ', 'a', 'a'),
            Trigram('i', 'n', ' '),
            Trigram('o', 'f', ' '),
            Trigram('d', 'e', 'r'),
            Trigram('h', 'e', 'i'),
            Trigram('o', 'm', ' '),
            Trigram('g', ' ', 'v'),
            Trigram(' ', 'o', 'p'),
            Trigram(' ', 'n', 'i'),
            Trigram('e', ' ', 'b'),
            Trigram(' ', 'e', 'l'),
            Trigram('a', 'l', ' '),
            Trigram('a', 'n', 'd'),
            Trigram('e', 'l', 'k'),
            Trigram('e', 'r', ' '),
            Trigram(' ', 'm', 'e'),
            Trigram('o', 'r', 'd'),
            Trigram('e', ' ', 'w'),
            Trigram('g', ' ', 't'),
            Trigram(' ', 't', 'o'),
            Trigram(' ', 'o', 'f'),
            Trigram('e', 'r', 's'),
            Trigram(' ', 'w', 'e'),
            Trigram(' ', 's', 'a'),
            Trigram(' ', 'v', 'o'),
            Trigram('o', 't', ' '),
            Trigram('e', 'r', 'k'),
            Trigram('n', ' ', 'v'),
            Trigram('v', 'r', 'y'),
            Trigram('g', 'e', ' '),
            Trigram('k', 'e', 'e'),
            Trigram('a', 's', 'i'),
            Trigram('t', 'o', 't'),
            Trigram(' ', 'w', 'a'),
            Trigram('s', 'i', 'e'),
            Trigram('e', 'r', 'e'),
            Trigram(' ', 'o', 'm'),
            Trigram('a', 'a', 'r'),
            Trigram('s', 'a', 'l'),
            Trigram('d', 'i', 'g'),
            Trigram('w', 'o', 'r'),
            Trigram('e', 'g', 't'),
            Trigram('g', 't', 'e'),
            Trigram('r', 'd', 'i'),
            Trigram('r', 'd', ' '),
            Trigram('a', 't', ' '),
            Trigram('n', 'd', ' '),
            Trigram('e', ' ', 's'),
            Trigram('e', 'd', 'e'),
            Trigram('i', 'g', 'e'),
            Trigram(' ', 'd', 'e'),
            Trigram(' ', '’', 'n'),
            Trigram('n', ' ', 'a'),
            Trigram('e', 'n', 'i'),
            Trigram(' ', 'w', 'o'),
            Trigram('e', ' ', 'g'),
            Trigram(' ', 'o', 'n'),
            Trigram('n', ' ', 's'),
            Trigram('’', 'n', ' '),
            Trigram('e', ' ', 't'),
            Trigram('e', 'r', 'd'),
            Trigram('n', 's', ' '),
            Trigram('o', 'o', 'r'),
            Trigram('b', 'e', 's'),
            Trigram('o', 'n', 'd'),
            Trigram('s', 'e', ' '),
            Trigram('s', 'k', 'a'),
            Trigram('a', 'a', 'k'),
            Trigram('n', 'i', 'g'),
            Trigram('l', 'l', 'e'),
            Trigram('y', 'h', 'e'),
            Trigram('r', 'y', 'h'),
            Trigram('i', 's', ' '),
            Trigram('e', 'l', 'i'),
            Trigram('e', 's', 'k'),
            Trigram('i', 'e', 'n'),
            Trigram('s', 't', 'a'),
            Trigram('v', 'o', 'l'),
            Trigram('e', 'l', 'e'),
            Trigram('e', ' ', 'm'),
            Trigram(' ', 'v', 'i'),
            Trigram('i', 'k', ' '),
            Trigram('r', ' ', 'd'),
            Trigram('v', 'i', 'r'),
            Trigram('e', 'd', 'i'),
            Trigram('k', 'a', 'p'),
            Trigram('g', ' ', 'e'),
            Trigram('i', 'r', ' '),
            Trigram('e', 's', ' '),
            Trigram('s', 'y', ' '),
            Trigram('a', 'n', 'g'),
            Trigram('d', 'i', 'n'),
            Trigram(' ', 's', 't'),
            Trigram('e', 'w', 'e'),
            Trigram('g', 'e', 'm'),
            Trigram('g', 'e', 'l'),
            Trigram('g', ' ', 'o'),
            Trigram(' ', 'i', 's'),
            Trigram('e', 'l', ' '),
            Trigram('e', ' ', 'i'),
            Trigram('o', 'p', ' '),
            Trigram('k', 'e', 'r'),
            Trigram('a', 'k', ' '),
            Trigram('u', 'i', 't'),
            Trigram('i', 'k', 'e'),
            Trigram('n', 's', 'e'),
            Trigram('h', 'i', 'e'),
            Trigram('u', 'r', ' '),
            Trigram('e', 'u', 'r'),
            Trigram(' ', 'a', 'l'),
            Trigram('e', ' ', 'a'),
            Trigram('n', 'a', 's'),
            Trigram('e', ' ', 'n'),
            Trigram('n', 'g', 'e'),
            Trigram('i', 'e', 'r'),
            Trigram('n', ' ', 'o'),
            Trigram('w', 'e', 'r'),
            Trigram('e', ' ', 'd'),
            Trigram('a', 'p', ' '),
            Trigram(' ', 'h', 'u'),
            Trigram('a', 'l', 'e'),
            Trigram('r', 'i', 'n'),
            Trigram(' ', 'h', 'i'),
            Trigram('e', 'm', 'e'),
            Trigram('d', 'e', 'u'),
            Trigram('m', 'i', 'n'),
            Trigram('w', 'a', 't'),
            Trigram('n', ' ', 'e'),
            Trigram('s', ' ', 'o'),
            Trigram(' ', 'a', 's'),
            Trigram(' ', 's', 'o'),
            Trigram('a', 's', ' '),
            Trigram('e', ' ', 'h'),
            Trigram('d', 'e', 'l'),
            Trigram('d', ' ', 'v'),
            Trigram('t', 'e', 'r'),
            Trigram('t', 'e', 'n'),
            Trigram('g', 'i', 'n'),
            Trigram('e', 'n', 'd'),
            Trigram('k', 'i', 'n'),
            Trigram('i', 't', ' '),
            Trigram(' ', 'd', 'a'),
            Trigram(' ', 's', 'y'),
            Trigram('p', 'e', 'r'),
            Trigram('r', 'e', ' '),
            Trigram('n', ' ', 'w'),
            Trigram('g', 'e', 's'),
            Trigram('w', 'e', 't'),
            Trigram('g', 'e', 'r'),
            Trigram('e', ' ', 'k'),
            Trigram('o', 'e', 'd'),
            Trigram('s', ' ', 'v'),
            Trigram('n', 't', 'e'),
            Trigram('s', ' ', 'e'),
            Trigram('o', 'n', 'a'),
            Trigram('n', 'a', 'l'),
            Trigram('w', 'a', 'a'),
            Trigram('d', ' ', 't'),
            Trigram('e', 'e', 's'),
            Trigram('s', 'o', 'o'),
            Trigram(' ', 'm', 'a'),
            Trigram('d', ' ', 's'),
            Trigram('i', 'e', 's'),
            Trigram('t', 'e', 'l'),
            Trigram('e', 'm', 'a'),
            Trigram('d', ' ', 'e'),
            Trigram('r', 'e', 'd'),
            Trigram('i', 't', 'e'),
            Trigram(' ', 'n', 'a'),
            Trigram('s', 'k', 'e'),
            Trigram('e', 'l', 'y'),
            Trigram('l', 'y', 'k'),
            Trigram('r', 'e', 'n'),
            Trigram('n', 's', 'k'),
            Trigram('d', ' ', 'o'),
            Trigram('o', 'o', 'n'),
            Trigram('t', ' ', 'e'),
            Trigram('e', 'k', 'e'),
            Trigram('e', 's', 'i'),
            Trigram('e', 's', 'e'),
            Trigram('e', 'r', 'i'),
            Trigram('h', 'u', 'l'),
            Trigram(' ', 'g', 'r'),
            Trigram('i', 'g', ' '),
            Trigram('s', 'i', 'o'),
            Trigram('m', 'a', 'n'),
            Trigram('r', 'd', 'e'),
            Trigram('i', 'o', 'n'),
            Trigram('n', ' ', 'b'),
            Trigram('n', ' ', 'g'),
            Trigram('v', 'o', 'o'),
            Trigram('h', 'e', 'd'),
            Trigram('i', 'n', 'd'),
            Trigram('t', 'e', 'e'),
            Trigram(' ', 'p', 'e'),
            Trigram('r', 's', 'o'),
            Trigram('t', ' ', 'v'),
            Trigram('s', ' ', 'd'),
            Trigram('a', 'l', 'l'),
            Trigram('n', ' ', 't'),
            Trigram('r', 's', 'e'),
            Trigram('n', ' ', 'i'),
            Trigram('e', 'e', 'm'),
            Trigram('d', ' ', 'w'),
            Trigram('o', 'r', 't'),
            Trigram('n', 'd', 'i'),
            Trigram('d', 'a', 'a'),
            Trigram('m', 'a', 'a'),
            Trigram('t', ' ', 'g'),
            Trigram('e', 'r', 'm'),
            Trigram('o', 'n', 't'),
            Trigram('e', 'n', 't'),
            Trigram('a', 'n', 's'),
            Trigram('a', 'm', 'e'),
            Trigram('y', 'k', 'e'),
            Trigram('a', 'r', 'i'),
            Trigram('n', ' ', 'm'),
            Trigram('l', 'a', 'n'),
            Trigram('v', 'o', 'e'),
            Trigram('n', ' ', '’'),
            Trigram('n', 'l', 'i'),
            Trigram('r', 'k', 'l'),
            Trigram('r', ' ', 'm'),
            Trigram('s', 'i', 'a'),
            Trigram('o', 'd', 's'),
            Trigram('a', 'r', 'd'),
            Trigram('i', 'e', 'm'),
            Trigram('g', ' ', 's'),
            Trigram('w', 'e', 'e'),
            Trigram('r', ' ', 'e'),
            Trigram('l', ' ', 'g'),
            Trigram('t', 'a', 'a'),
            Trigram('s', 'e', 'k'),
            Trigram('b', 'a', 'r'),
            Trigram('g', 't', 'i'),
            Trigram('n', ' ', 'n'),
            Trigram('l', 'i', 'n'),
            Trigram('s', 'e', 'n'),
            Trigram('t', ' ', 'o'),
            Trigram('t', ' ', 'a'),
            Trigram('r', 'a', 'a'),
            Trigram('e', 'n', 'e'),
            Trigram('o', 'p', 'v'),
            Trigram('p', 'v', 'o'),
            Trigram('e', 't', 'e'),
            Trigram(' ', 't', 'y'),
            Trigram('a', 'r', 'b'),
            Trigram(' ', 's', 'l'),
            Trigram('i', 'g', 'h'),
            Trigram('d', 'e', 'e'),
            Trigram('g', ' ', 'a'),
            Trigram('s', 't', 'r'),
            Trigram('n', 's', 'l'),
            Trigram('s', 'e', 'l'),
            Trigram('e', 'r', 'n'),
            Trigram('s', 't', 'e'),
        ],
    ),
    (
        Lang::Fin,
        &[
            Trigram('e', 'n', ' '),
            Trigram('i', 's', 'e'),
            Trigram('j', 'a', ' '),
            Trigram('i', 's', 't'),
            Trigram(' ', 'j', 'a'),
            Trigram('o', 'n', ' '),
            Trigram('t', 'a', ' '),
            Trigram('s', 't', 'a'),
            Trigram('a', 'n', ' '),
            Trigram('n', ' ', 'j'),
            Trigram('a', 'i', 's'),
            Trigram('s', 'e', 'n'),
            Trigram('n', ' ', 'o'),
            Trigram('k', 'e', 'u'),
            Trigram('i', 'k', 'e'),
            Trigram('o', 'i', 'k'),
            Trigram('l', 'i', 's'),
            Trigram(' ', 'v', 'a'),
            Trigram('e', 'l', 'l'),
            Trigram('l', 'l', 'a'),
            Trigram('n', ' ', 't'),
            Trigram('u', 'k', 's'),
            Trigram(' ', 'o', 'n'),
            Trigram('k', 's', 'i'),
            Trigram(' ', 'o', 'i'),
            Trigram('n', ' ', 'k'),
            Trigram(' ', 'k', 'a'),
            Trigram('a', 'a', 'n'),
            Trigram('e', 'e', 'n'),
            Trigram('l', 'a', ' '),
            Trigram('l', 'l', 'i'),
            Trigram('k', 'a', 'i'),
            Trigram('a', ' ', 'j'),
            Trigram(' ', 't', 'a'),
            Trigram('s', 'a', ' '),
            Trigram('i', 'n', ' '),
            Trigram('m', 'i', 's'),
            Trigram(' ', 'j', 'o'),
            Trigram('a', ' ', 'o'),
            Trigram('ä', 'ä', 'n'),
            Trigram('ä', 'n', ' '),
            Trigram('s', 'e', 'l'),
            Trigram('n', ' ', 's'),
            Trigram('k', 's', 'e'),
            Trigram('a', ' ', 't'),
            Trigram('a', ' ', 'k'),
            Trigram('t', 'a', 'i'),
            Trigram('u', 's', ' '),
            Trigram('t', 't', 'a'),
            Trigram('a', 'n', 's'),
            Trigram('s', 's', 'a'),
            Trigram('k', 'u', 'n'),
            Trigram('d', 'e', 'n'),
            Trigram('t', 'ä', ' '),
            Trigram('e', 'u', 's'),
            Trigram('n', 'e', 'n'),
            Trigram('k', 'a', 'n'),
            Trigram('n', 's', 'a'),
            Trigram('a', 'p', 'a'),
            Trigram('a', 'l', 'l'),
            Trigram('e', 's', 't'),
            Trigram(' ', 's', 'e'),
            Trigram('e', 'i', 's'),
            Trigram('i', 'l', 'l'),
            Trigram('i', 'e', 'n'),
            Trigram('s', 'e', 'e'),
            Trigram('t', 'a', 'a'),
            Trigram(' ', 'y', 'h'),
            Trigram('j', 'o', 'k'),
            Trigram('n', ' ', 'y'),
            Trigram('v', 'a', 'p'),
            Trigram('a', ' ', 'v'),
            Trigram('t', 't', 'ä'),
            Trigram('o', 'k', 'a'),
            Trigram('n', ' ', 'v'),
            Trigram('a', 'i', ' '),
            Trigram('i', 't', 't'),
            Trigram('a', 'a', ' '),
            Trigram('a', 'i', 'k'),
            Trigram('e', 't', 't'),
            Trigram('t', 'u', 'k'),
            Trigram('t', 'i', ' '),
            Trigram('u', 's', 't'),
            Trigram(' ', 'k', 'u'),
            Trigram('i', 's', 'i'),
            Trigram('s', 't', 'ä'),
            Trigram('s', 'e', 's'),
            Trigram(' ', 't', 'ä'),
            Trigram(' ', 't', 'u'),
            Trigram('l', 'a', 'i'),
            Trigram('n', ' ', 'p'),
            Trigram('s', 't', 'i'),
            Trigram('a', 's', 't'),
            Trigram('n', ' ', 'e'),
            Trigram('n', ' ', 'm'),
            Trigram('t', 'ä', 'ä'),
            Trigram('s', 'i', 'a'),
            Trigram('u', 'n', 'n'),
            Trigram('ä', ' ', 'j'),
            Trigram('u', 'd', 'e'),
            Trigram('ä', ' ', 'o'),
            Trigram('s', 't', 'e'),
            Trigram('s', 'i', ' '),
            Trigram('t', 'e', 'i'),
            Trigram('i', 'n', 'e'),
            Trigram('p', 'e', 'r'),
            Trigram('a', ' ', 's'),
            Trigram('i', 'a', ' '),
            Trigram('k', 'ä', ' '),
            Trigram('ä', 'n', 'e'),
            Trigram(' ', 'm', 'i'),
            Trigram('m', 'a', 'a'),
            Trigram(' ', 'p', 'e'),
            Trigram('a', ' ', 'p'),
            Trigram('e', 's', 's'),
            Trigram('a', ' ', 'm'),
            Trigram('a', 'i', 'n'),
            Trigram('ä', 'm', 'ä'),
            Trigram('t', 'a', 'm'),
            Trigram('y', 'h', 't'),
            Trigram(' ', 'j', 'u'),
            Trigram('j', 'u', 'l'),
            Trigram('y', 'k', 's'),
            Trigram('h', 'ä', 'n'),
            Trigram('ä', ' ', 't'),
            Trigram(' ', 'h', 'ä'),
            Trigram('u', 't', 't'),
            Trigram('i', 'd', 'e'),
            Trigram('e', 't', ' '),
            Trigram('l', 'l', 'ä'),
            Trigram('v', 'a', 'l'),
            Trigram('s', 'e', 'k'),
            Trigram('s', 't', 'u'),
            Trigram('n', ' ', 'a'),
            Trigram('l', 'ä', ' '),
            Trigram('a', 'm', 'i'),
            Trigram('h', 'm', 'i'),
            Trigram(' ', 'k', 'e'),
            Trigram('i', 'k', 'k'),
            Trigram('l', 'l', 'e'),
            Trigram('i', 'i', 'n'),
            Trigram('s', 'ä', ' '),
            Trigram('e', 'u', 'k'),
            Trigram('t', 'ä', 'm'),
            Trigram('i', 'h', 'm'),
            Trigram('t', 'e', 'e'),
            Trigram(' ', 'i', 'h'),
            Trigram('l', 't', 'a'),
            Trigram('p', 'a', 'u'),
            Trigram(' ', 's', 'a'),
            Trigram('i', 's', 'k'),
            Trigram('m', 'ä', 'ä'),
            Trigram('o', 'i', 's'),
            Trigram('u', 'n', ' '),
            Trigram('t', 'a', 'v'),
            Trigram('t', 'e', 'n'),
            Trigram('d', 'i', 's'),
            Trigram('h', 't', 'e'),
            Trigram('n', ' ', 'h'),
            Trigram('i', 's', 's'),
            Trigram('s', 's', 'ä'),
            Trigram('a', ' ', 'h'),
            Trigram('a', 'v', 'a'),
            Trigram(' ', 'm', 'a'),
            Trigram('a', ' ', 'y'),
            Trigram(' ', 'e', 'i'),
            Trigram(' ', 't', 'e'),
            Trigram(' ', 's', 'i'),
            Trigram(' ', 'o', 'l'),
            Trigram('e', 'k', 'ä'),
            Trigram('s', 't', 'y'),
            Trigram('a', 'l', 't'),
            Trigram('t', 'o', 'i'),
            Trigram('a', 't', 't'),
            Trigram('o', 'l', 'l'),
            Trigram('t', 'e', 't'),
            Trigram(' ', 'j', 'ä'),
            Trigram(' ', 'r', 'a'),
            Trigram('v', 'a', 't'),
            Trigram(' ', 'm', 'u'),
            Trigram('i', 'e', 'l'),
            Trigram(' ', 't', 'o'),
            Trigram('m', 'a', 'i'),
            Trigram('s', 'a', 'l'),
            Trigram('i', 's', 'u'),
            Trigram('a', ' ', 'a'),
            Trigram('k', 'k', 'i'),
            Trigram('a', 't', ' '),
            Trigram('s', 'u', 'u'),
            Trigram('n', ' ', 'l'),
            Trigram('v', 'ä', 'l'),
            Trigram('ä', 'ä', ' '),
            Trigram('u', 'l', 'i'),
            Trigram('t', 'u', 'n'),
            Trigram('t', 'i', 'e'),
            Trigram('e', 'r', 'u'),
            Trigram(' ', 'y', 'k'),
            Trigram('e', 't', 'u'),
            Trigram('v', 'a', 'a'),
            Trigram('r', 'u', 's'),
            Trigram('m', 'u', 'k'),
            Trigram(' ', 'h', 'e'),
            Trigram('e', 'i', ' '),
            Trigram('a', ' ', 'e'),
            Trigram('k', 'i', 'e'),
            Trigram('s', 'k', 'u'),
            Trigram('e', 'i', 'd'),
            Trigram('i', 'i', 't'),
            Trigram(' ', 's', 'u'),
            Trigram('n', 'n', 'a'),
            Trigram('s', 'i', 'l'),
            Trigram('o', 'm', 'a'),
            Trigram('m', 'i', 'n'),
            Trigram(' ', 'y', 'l'),
            Trigram('l', 'i', 'n'),
            Trigram('a', 'u', 't'),
            Trigram('u', 'u', 't'),
            Trigram('s', 'k', 'o'),
            Trigram(' ', 'k', 'o'),
            Trigram('t', 't', 'i'),
            Trigram('l', 'e', ' '),
            Trigram('s', 'i', 'e'),
            Trigram('k', 'a', 'a'),
            Trigram('a', ' ', 'r'),
            Trigram(' ', 'r', 'i'),
            Trigram('s', 'i', 'i'),
            Trigram('n', 'n', 'o'),
            Trigram('e', 'l', 'i'),
            Trigram('t', 'u', 'r'),
            Trigram('s', 'a', 'a'),
            Trigram('a', 'a', 't'),
            Trigram('l', 'e', 'i'),
            Trigram('o', 'l', 'i'),
            Trigram('n', 'a', ' '),
            Trigram(' ', 'l', 'a'),
            Trigram('o', 'o', 'n'),
            Trigram('u', 'r', 'v'),
            Trigram('l', 'm', 'a'),
            Trigram('r', 'v', 'a'),
            Trigram('i', 't', 'e'),
            Trigram('m', 'i', 'e'),
            Trigram('v', 'a', 's'),
            Trigram('ä', ' ', 'm'),
            Trigram(' ', 'e', 'd'),
            Trigram('t', 'u', 's'),
            Trigram('i', 'a', 'a'),
            Trigram('i', 't', 'ä'),
            Trigram('ä', ' ', 'v'),
            Trigram('u', 'o', 'l'),
            Trigram('y', 'l', 'e'),
            Trigram(' ', 'a', 'l'),
            Trigram('l', 'i', 't'),
            Trigram('s', 'u', 'o'),
            Trigram('a', 'm', 'a'),
            Trigram('j', 'o', 'i'),
            Trigram('u', 'n', 't'),
            Trigram('u', 't', 'e'),
            Trigram('i', ' ', 'o'),
            Trigram('t', 'y', 'k'),
            Trigram('n', ' ', 'r'),
            Trigram('a', 'l', 'i'),
            Trigram('l', 'i', 'i'),
            Trigram('n', 'e', 'e'),
            Trigram('p', 'a', 'a'),
            Trigram('a', 'v', 'i'),
            Trigram('o', 'm', 'i'),
            Trigram('o', 'i', 't'),
            Trigram('j', 'e', 'n'),
            Trigram('k', 'ä', 'ä'),
            Trigram('v', 'o', 'i'),
            Trigram('y', 'h', 'd'),
            Trigram('ä', ' ', 'k'),
            Trigram(' ', 'k', 'i'),
            Trigram('e', 'e', 't'),
            Trigram('e', 'k', 's'),
            Trigram(' ', 's', 'y'),
            Trigram('i', 't', 'y'),
            Trigram('i', 'l', 'ö'),
            Trigram('i', 'l', 'm'),
            Trigram('o', 'i', 'm'),
            Trigram('o', 'l', 'e'),
            Trigram('s', 'i', 't'),
            Trigram('i', 't', 'a'),
            Trigram('u', 'o', 'm'),
            Trigram('v', 'a', 'i'),
            Trigram('u', 's', 'k'),
            Trigram('a', 'l', 'a'),
            Trigram('h', 'e', 'n'),
            Trigram('o', 'p', 'e'),
            Trigram(' ', 'p', 'u'),
            Trigram('a', 'u', 'k'),
            Trigram('p', 'e', 't'),
            Trigram('o', 'j', 'a'),
            Trigram('i', ' ', 's'),
            Trigram('r', 'i', 'i'),
            Trigram('u', 'u', 'd'),
            Trigram('h', 'd', 'i'),
            Trigram('ä', 'l', 'i'),
            Trigram('v', 'a', ' '),
            Trigram(' ', 'o', 'm'),
        ],
    ),
    (
        Lang::Slk,
        &[
            Trigram(' ', 'p', 'r'),
            Trigram(' ', 'a', ' '),
            Trigram('p', 'r', 'á'),
            Trigram('r', 'á', 'v'),
            Trigram(' ', 'p', 'o'),
            Trigram('i', 'e', ' '),
            Trigram('c', 'h', ' '),
            Trigram('o', 's', 't'),
            Trigram(' ', 'r', 'o'),
            Trigram('h', 'o', ' '),
            Trigram(' ', 'n', 'a'),
            Trigram('v', 'o', ' '),
            Trigram('a', 'n', 'i'),
            Trigram('n', 'a', ' '),
            Trigram(' ', 'n', 'e'),
            Trigram('n', 'o', 's'),
            Trigram('a', 'ž', 'd'),
            Trigram('k', 't', 'o'),
            Trigram('k', 'a', 'ž'),
            Trigram(' ', 'k', 'a'),
            Trigram('m', 'á', ' '),
            Trigram('n', 'é', ' '),
            Trigram('á', 'v', 'o'),
            Trigram('o', 'm', ' '),
            Trigram(' ', 'm', 'á'),
            Trigram('e', 'b', 'o'),
            Trigram('t', 'i', ' '),
            Trigram(' ', 'v', ' '),
            Trigram(' ', 'a', 'l'),
            Trigram('a', 'l', 'e'),
            Trigram('l', 'e', 'b'),
            Trigram('b', 'o', ' '),
            Trigram(' ', 'j', 'e'),
            Trigram(' ', 'z', 'a'),
            Trigram('ý', 'c', 'h'),
            Trigram('o', ' ', 'n'),
            Trigram('ž', 'd', 'ý'),
            Trigram('d', 'ý', ' '),
            Trigram('i', 'a', ' '),
            Trigram(' ', 's', 'l'),
            Trigram('m', 'i', ' '),
            Trigram('o', 'v', 'a'),
            Trigram('s', 't', 'i'),
            Trigram('n', 'i', 'e'),
            Trigram('v', 'a', 'n'),
            Trigram('t', 'o', ' '),
            Trigram('e', 'n', 'i'),
            Trigram('n', 'e', ' '),
            Trigram('á', 'v', 'a'),
            Trigram('l', 'o', 'b'),
            Trigram('é', 'h', 'o'),
            Trigram('s', 'l', 'o'),
            Trigram('r', 'o', 'd'),
            Trigram('t', 'o', 'r'),
            Trigram('r', 'o', 'v'),
            Trigram(' ', 's', 'p'),
            Trigram(' ', 'z', 'á'),
            Trigram('á', ' ', 'p'),
            Trigram('o', ' ', 'v'),
            Trigram('a', ' ', 'p'),
            Trigram(' ', 'k', 't'),
            Trigram('ý', ' ', 'm'),
            Trigram(' ', 's', 'v'),
            Trigram('v', 'o', 'j'),
            Trigram('b', 'o', 'd'),
            Trigram('o', 'b', 'o'),
            Trigram('n', 'i', 'a'),
            Trigram(' ', 'n', 'á'),
            Trigram(' ', 'v', 'y'),
            Trigram('e', 'j', ' '),
            Trigram('j', 'e', ' '),
            Trigram('a', 'ť', ' '),
            Trigram('o', ' ', 'p'),
            Trigram('a', ' ', 'v'),
            Trigram('a', ' ', 's'),
            Trigram('á', 'r', 'o'),
            Trigram('a', ' ', 'z'),
            Trigram(' ', 's', 'a'),
            Trigram(' ', 'm', 'a'),
            Trigram('a', ' ', 'n'),
            Trigram('e', ' ', 'a'),
            Trigram('e', ' ', 's'),
            Trigram('m', 'u', ' '),
            Trigram('m', 'i', 'e'),
            Trigram('k', 'l', 'a'),
            Trigram('n', 'á', 'r'),
            Trigram('s', 'v', 'o'),
            Trigram('s', 'p', 'o'),
            Trigram(' ', 'b', 'y'),
            Trigram('o', 'v', 'n'),
            Trigram('b', 'y', ' '),
            Trigram('r', 'o', 'z'),
            Trigram('s', 'a', ' '),
            Trigram('ľ', 'u', 'd'),
            Trigram('i', 'ť', ' '),
            Trigram('o', 'd', 'n'),
            Trigram(' ', 'v', 'š'),
            Trigram('o', 'v', ' '),
            Trigram('i', ' ', 'a'),
            Trigram('n', 'é', 'h'),
            Trigram('v', 'š', 'e'),
            Trigram('o', ' ', 's'),
            Trigram('v', 'a', ' '),
            Trigram('o', ' ', 'a'),
            Trigram(' ', 'ľ', 'u'),
            Trigram('o', 'c', 'i'),
            Trigram('p', 'r', 'e'),
            Trigram('n', 'u', ' '),
            Trigram('a', ' ', 'm'),
            Trigram('u', ' ', 'a'),
            Trigram('e', 'n', 'ý'),
            Trigram('e', ' ', 'v'),
            Trigram('n', 'ý', ' '),
            Trigram('n', 'e', 's'),
            Trigram('a', ' ', 'k'),
            Trigram('z', 'á', 'k'),
            Trigram('p', 'o', 'd'),
            Trigram('n', 'ý', 'm'),
            Trigram(' ', 'd', 'o'),
            Trigram('u', ' ', 'p'),
            Trigram(' ', 'k', ' '),
            Trigram('u', ' ', 's'),
            Trigram('á', 'c', 'i'),
            Trigram('a', 'j', 'ú'),
            Trigram('b', 'y', 'ť'),
            Trigram('y', 'ť', ' '),
            Trigram('n', 'ý', 'c'),
            Trigram('e', 'h', 'o'),
            Trigram('r', 'a', 'n'),
            Trigram('p', 'o', 'l'),
            Trigram('t', 'á', 't'),
            Trigram('s', 't', 'n'),
            Trigram('j', 'e', 'h'),
            Trigram('a', ' ', 'r'),
            Trigram('š', 'e', 't'),
            Trigram('ý', 'm', 'i'),
            Trigram('l', 'a', 'd'),
            Trigram('č', 'i', 'n'),
            Trigram('é', 'm', 'u'),
            Trigram('a', ' ', 'o'),
            Trigram('e', 'd', 'z'),
            Trigram('ť', ' ', 's'),
            Trigram('k', 'o', 'n'),
            Trigram('s', 't', 'v'),
            Trigram('o', 'r', 'é'),
            Trigram(' ', 's', 'ú'),
            Trigram(' ', 'n', 'i'),
            Trigram('e', ' ', 'z'),
            Trigram('p', 'r', 'i'),
            Trigram('o', 'c', 'h'),
            Trigram('n', 'y', ' '),
            Trigram('š', 't', 'á'),
            Trigram('s', 'ť', ' '),
            Trigram('o', 'j', 'e'),
            Trigram('v', 'n', 'a'),
            Trigram('t', 'r', 'e'),
            Trigram('u', ' ', 'k'),
            Trigram(' ', 'č', 'i'),
            Trigram('k', 'o', ' '),
            Trigram('é', ' ', 'p'),
            Trigram('m', 'a', 'j'),
            Trigram('s', 'm', 'i'),
            Trigram('a', ' ', 'a'),
            Trigram('e', 't', 'k'),
            Trigram('n', 'a', 'k'),
            Trigram('ý', 'm', ' '),
            Trigram('m', 'e', 'd'),
            Trigram('d', 'o', 'v'),
            Trigram('p', 'r', 'í'),
            Trigram(' ', 'o', 'b'),
            Trigram('i', 'u', ' '),
            Trigram('u', 'd', 's'),
            Trigram('o', 's', 'ť'),
            Trigram('e', 's', 'm'),
            Trigram('e', ' ', 'b'),
            Trigram('m', ' ', 'a'),
            Trigram('h', 'r', 'a'),
            Trigram('i', ' ', 's'),
            Trigram('r', 'á', 'c'),
            Trigram('b', 'e', 'z'),
            Trigram('v', 'a', 'ť'),
            Trigram('c', 'h', 'r'),
            Trigram('e', ' ', 'p'),
            Trigram(' ', 'a', 'b'),
            Trigram('j', 'ú', ' '),
            Trigram(' ', 'š', 't'),
            Trigram('ž', 'e', 'n'),
            Trigram(' ', 'h', 'o'),
            Trigram('č', 'e', 'n'),
            Trigram(' ', 'd', 'e'),
            Trigram('i', ' ', 'p'),
            Trigram('ť', ' ', 'v'),
            Trigram(' ', 'v', 'o'),
            Trigram('d', 's', 'k'),
            Trigram('p', 'r', 'o'),
            Trigram('n', 'o', 'm'),
            Trigram(' ', 'i', 'n'),
            Trigram('o', 'u', ' '),
            Trigram('d', 'u', ' '),
            Trigram('ž', 'e', ' '),
            Trigram('a', 'b', 'y'),
            Trigram('e', 's', 't'),
            Trigram(' ', 'b', 'o'),
            Trigram('r', 'é', ' '),
            Trigram('b', 'o', 'l'),
            Trigram(' ', 's', 'o'),
            Trigram('n', 'ú', ' '),
            Trigram('o', 'l', 'o'),
            Trigram('k', 'e', 'j'),
            Trigram('á', 'l', 'n'),
            Trigram(' ', 'o', 'c'),
            Trigram('o', 'b', 'e'),
            Trigram('k', 'y', ' '),
            Trigram('d', 'z', 'i'),
            Trigram('d', 'o', 'm'),
            Trigram('á', 'v', ' '),
            Trigram('p', 'o', 'r'),
            Trigram('l', 'n', 'e'),
            Trigram('r', 'a', 'v'),
            Trigram('a', 'k', 'é'),
            Trigram('e', 'n', 's'),
            Trigram('p', 'r', 'a'),
            Trigram('o', 'k', ' '),
            Trigram(' ', 'ž', 'e'),
            Trigram('t', 'n', 'é'),
            Trigram(' ', 't', 'a'),
            Trigram('a', 'k', 'o'),
            Trigram('r', 'e', 's'),
            Trigram(' ', 'v', 'z'),
            Trigram('i', ' ', 'k'),
            Trigram('a', 'm', 'i'),
            Trigram(' ', 't', 'r'),
            Trigram(' ', 'a', 'k'),
            Trigram('n', 'í', ' '),
            Trigram('l', 'e', 'n'),
            Trigram('o', ' ', 'd'),
            Trigram('d', 'e', 'l'),
            Trigram('s', 'k', 'ý'),
            Trigram('c', 'h', 'o'),
            Trigram('a', 'c', 'h'),
            Trigram('i', 'v', 'o'),
            Trigram('h', ' ', 'p'),
            Trigram('o', 'ž', 'e'),
            Trigram('i', 'á', 'l'),
            Trigram('i', 'n', 'n'),
            Trigram('s', 'l', 'u'),
            Trigram('k', 'r', 'a'),
            Trigram('l', 'o', 'č'),
            Trigram('o', 'č', 'n'),
            Trigram('j', 'u', ' '),
            Trigram(' ', 'o', 's'),
            Trigram('a', 'n', 'u'),
            Trigram('o', 'j', 'u'),
            Trigram('v', 'o', 'ľ'),
            Trigram('á', 'k', 'l'),
            Trigram('s', 't', 'r'),
            Trigram('é', ' ', 's'),
            Trigram('e', 'n', 'é'),
            Trigram(' ', 'ž', 'i'),
            Trigram('n', 'i', 'u'),
            Trigram('s', 't', 'a'),
            Trigram(' ', 's', 't'),
            Trigram('v', 'e', 'd'),
            Trigram('t', 'v', 'o'),
            Trigram(' ', 'm', 'e'),
            Trigram('d', 'n', 'o'),
            Trigram('m', ' ', 'p'),
            Trigram('d', 'e', ' '),
            Trigram('k', 'é', ' '),
            Trigram('k', 'ý', 'm'),
            Trigram('i', 'k', 't'),
            Trigram('s', 't', 'u'),
            Trigram('é', ' ', 'v'),
            Trigram('i', ' ', 'v'),
            Trigram('v', 'y', 'h'),
            Trigram(' ', 't', 'o'),
            Trigram('v', ' ', 'a'),
            Trigram('o', 'd', 'u'),
            Trigram('h', 'o', 'c'),
            Trigram('a', ' ', 't'),
            Trigram('í', 'm', ' '),
            Trigram('l', 'y', ' '),
            Trigram('h', 'o', 'v'),
            Trigram('y', ' ', 's'),
            Trigram('s', 'o', 'c'),
            Trigram('j', 'ú', 'c'),
            Trigram('ú', ' ', 'p'),
            Trigram('o', 'd', 'i'),
            Trigram('v', 'o', 'd'),
            Trigram('l', 'i', 'v'),
            Trigram('a', 'n', 'í'),
            Trigram('c', 'i', 'á'),
            Trigram(' ', 'v', 'e'),
            Trigram('r', 'e', 'j'),
            Trigram('k', 'u', ' '),
            Trigram('c', 'i', ' '),
            Trigram('s', 'k', 'e'),
            Trigram('s', 'o', 'b'),
            Trigram('č', 'n', 'o'),
            Trigram('o', 's', 'o'),
        ],
    ),
    (
        Lang::Tuk,
        &[
            Trigram('l', 'a', 'r'),
            Trigram(' ', 'w', 'e'),
            Trigram('w', 'e', ' '),
            Trigram(' ', 'b', 'i'),
            Trigram('y', 'ň', ' '),
            Trigram('a', 'r', 'y'),
            Trigram('a', 'd', 'a'),
            Trigram('d', 'a', ' '),
            Trigram(' ', 'h', 'e'),
            Trigram(' ', 'h', 'a'),
            Trigram('a', 'n', ' '),
            Trigram('y', 'n', 'y'),
            Trigram('k', 'l', 'a'),
            Trigram('d', 'a', 'm'),
            Trigram('d', 'e', ' '),
            Trigram(' ', 'a', 'd'),
            Trigram('y', 'n', 'a'),
            Trigram('e', 'r', ' '),
            Trigram('n', 'a', ' '),
            Trigram(' ', 'ý', 'a'),
            Trigram('i', 'r', ' '),
            Trigram('d', 'y', 'r'),
            Trigram('i', 'ň', ' '),
            Trigram('b', 'i', 'r'),
            Trigram('r', ' ', 'b'),
            Trigram('y', 'd', 'y'),
            Trigram('l', 'e', 'r'),
            Trigram('a', 'r', 'a'),
            Trigram('a', 'm', ' '),
            Trigram('y', 'r', ' '),
            Trigram('i', 'n', 'i'),
            Trigram('l', 'a', 'n'),
            Trigram('r', ' ', 'a'),
            Trigram('k', 'l', 'y'),
            Trigram('l', 'y', 'd'),
            Trigram(' ', 'ö', 'z'),
            Trigram('m', 'a', 'g'),
            Trigram('n', 'y', 'ň'),
            Trigram('ö', 'z', ' '),
            Trigram('h', 'e', 'r'),
            Trigram('g', 'y', 'n'),
            Trigram('a', 'g', 'a'),
            Trigram('e', 'n', ' '),
            Trigram('r', 'y', 'n'),
            Trigram('a', 'k', 'l'),
            Trigram('a', 'l', 'a'),
            Trigram('d', 'a', 'n'),
            Trigram('h', 'a', 'k'),
            Trigram('e', 'r', 'i'),
            Trigram('n', 'e', ' '),
            Trigram('u', 'k', 'u'),
            Trigram('a', 'r', ' '),
            Trigram('r', ' ', 'h'),
            Trigram('g', 'a', ' '),
            Trigram('n', 'y', ' '),
            Trigram('h', 'u', 'k'),
            Trigram(' ', 'd', 'e'),
            Trigram('i', 'l', 'i'),
            Trigram('y', 'g', 'y'),
            Trigram('l', 'i', ' '),
            Trigram('k', 'u', 'k'),
            Trigram('a', ' ', 'h'),
            Trigram('n', 'd', 'a'),
            Trigram('a', 's', 'y'),
            Trigram('l', 'e', 'n'),
            Trigram(' ', 'e', 'd'),
            Trigram('b', 'i', 'l'),
            Trigram('a', 't', 'l'),
            Trigram('i', 'n', 'e'),
            Trigram('e', 'd', 'i'),
            Trigram('n', 'i', 'ň'),
            Trigram('l', 'y', 'g'),
            Trigram(' ', 'h', 'u'),
            Trigram(' ', 'g', 'a'),
            Trigram('e', ' ', 'h'),
            Trigram('n', 'd', 'e'),
            Trigram('d', 'i', 'l'),
            Trigram('r', 'y', 'ň'),
            Trigram('a', 'z', 'a'),
            Trigram('z', 'a', 't'),
            Trigram('a', ' ', 'g'),
            Trigram('‐', 'd', 'a'),
            Trigram('a', '‐', 'd'),
            Trigram('e', 't', 'i'),
            Trigram('u', 'k', 'l'),
            Trigram(' ', 'g', 'ö'),
            Trigram('l', 'y', ' '),
            Trigram(' ', 'b', 'o'),
            Trigram('t', 'l', 'y'),
            Trigram('g', 'i', 'n'),
            Trigram(' ', 'a', 'z'),
            Trigram('l', 'm', 'a'),
            Trigram('a', 'm', 'a'),
            Trigram('h', 'e', 'm'),
            Trigram('d', 'i', 'r'),
            Trigram('y', 'k', 'l'),
            Trigram('‐', 'd', 'e'),
            Trigram('e', ' ', 'd'),
            Trigram('i', 'l', 'e'),
            Trigram('ý', 'a', 'n'),
            Trigram('a', ' ', 'd'),
            Trigram('ý', 'e', 't'),
            Trigram('ý', 'a', '‐'),
            Trigram('y', 'n', 'd'),
            Trigram('l', 'y', 'k'),
            Trigram('a', 'ý', 'y'),
            Trigram('e', ' ', 'a'),
            Trigram('ü', 'n', 'd'),
            Trigram('g', 'e', ' '),
            Trigram(' ', 'g', 'o'),
            Trigram('e', 'g', 'i'),
            Trigram('i', 'l', 'm'),
            Trigram('s', 'y', ' '),
            Trigram('n', 'i', ' '),
            Trigram('e', 't', 'm'),
            Trigram('e', 'm', '‐'),
            Trigram('l', 'm', 'e'),
            Trigram('m', '‐', 'd'),
            Trigram('a', 'l', 'y'),
            Trigram('a', 'n', 'y'),
            Trigram(' ', 'b', 'e'),
            Trigram('t', 'l', 'e'),
            Trigram('s', 'y', 'n'),
            Trigram('r', 'i', 'n'),
            Trigram('y', ' ', 'b'),
            Trigram('l', 'e', 't'),
            Trigram('m', 'a', 'k'),
            Trigram('a', ' ', 'w'),
            Trigram('a', ' ', 'ý'),
            Trigram('d', 'e', 'n'),
            Trigram('ä', 'g', 'e'),
            Trigram('r', 'a', ' '),
            Trigram(' ', 'ä', 'h'),
            Trigram('m', 'ä', 'g'),
            Trigram(' ', 'd', 'u'),
            Trigram('n', ' ', 'e'),
            Trigram('b', 'o', 'l'),
            Trigram('m', 'e', 'g'),
            Trigram('e', 'l', 'e'),
            Trigram('ň', ' ', 'h'),
            Trigram(' ', 'e', 't'),
            Trigram('i', 'g', 'i'),
            Trigram('ň', ' ', 'w'),
            Trigram('i', 'm', ' '),
            Trigram('i', 'ý', 'a'),
            Trigram(' ', 'ý', 'e'),
            Trigram(' ', 'd', 'i'),
            Trigram('r', ' ', 'e'),
            Trigram('e', 'k', ' '),
            Trigram(' ', 'b', 'a'),
            Trigram('a', 'k', ' '),
            Trigram('e', 's', 'i'),
            Trigram('r', 'i', 'l'),
            Trigram('a', ' ', 'b'),
            Trigram('i', 'n', ' '),
            Trigram('p', ' ', 'b'),
            Trigram('d', 'e', 'ň'),
            Trigram('e', 't', 'l'),
            Trigram('a', 'g', 'y'),
            Trigram(' ', 'b', 'u'),
            Trigram(' ', 'j', 'e'),
            Trigram('b', 'u', ' '),
            Trigram('e', ' ', 'ö'),
            Trigram('y', ' ', 'd'),
            Trigram(' ', 'h', 'i'),
            Trigram('m', 'e', 'z'),
            Trigram(' ', 'e', 's'),
            Trigram('a', 'r', 'd'),
            Trigram(' ', 's', 'a'),
            Trigram('ä', 'h', 'l'),
            Trigram('e', ' ', 'b'),
            Trigram('y', 'l', 'y'),
            Trigram(' ', 'k', 'a'),
            Trigram('e', 's', 'a'),
            Trigram('m', 'e', 'k'),
            Trigram(' ', 'g', 'u'),
            Trigram('n', ' ', 'a'),
            Trigram('e', ' ', 't'),
            Trigram('l', 'i', 'k'),
            Trigram(' ', 'd', 'o'),
            Trigram('e', ' ', 'g'),
            Trigram('s', 'a', 's'),
            Trigram('i', 'l', 'l'),
            Trigram('n', 'm', 'a'),
            Trigram('ň', ' ', 'a'),
            Trigram('r', 'a', 'm'),
            Trigram('o', 'l', 'a'),
            Trigram('h', 'a', 'l'),
            Trigram('y', ' ', 'w'),
            Trigram('ý', 'a', 'r'),
            Trigram(' ', 'a', 'r'),
            Trigram('a', 'n', 'm'),
            Trigram('m', 'e', 'l'),
            Trigram('i', 'r', 'i'),
            Trigram('s', 'i', 'ý'),
            Trigram('n', 'd', 'i'),
            Trigram('e', 'd', 'e'),
            Trigram('g', 'a', 'l'),
            Trigram('e', 'n', 'd'),
            Trigram('m', 'i', 'l'),
            Trigram('r', 'l', 'a'),
            Trigram('g', 'ö', 'z'),
            Trigram(' ', 'm', 'a'),
            Trigram('n', ' ', 'b'),
            Trigram('e', ' ', 'ý'),
            Trigram('ö', 'ň', 'ü'),
            Trigram('ň', 'ü', 'n'),
            Trigram('n', ' ', 'h'),
            Trigram(' ', 't', 'u'),
            Trigram('h', 'i', 'ç'),
            Trigram('y', 'ý', 'e'),
            Trigram(' ', 'g', 'e'),
            Trigram('m', 'y', ' '),
            Trigram('i', 'ç', ' '),
            Trigram(' ', 'ö', 'ň'),
            Trigram('n', ' ', 'ý'),
            Trigram('t', 'l', 'a'),
            Trigram('ň', ' ', 'ý'),
            Trigram('l', 'i', 'n'),
            Trigram('r', 'd', 'a'),
            Trigram('a', 'l', ' '),
            Trigram('l', 'i', 'g'),
            Trigram('g', 'a', 'r'),
            Trigram(' ', 'm', 'i'),
            Trigram('i', ' ', 'g'),
            Trigram('d', 'a', 'l'),
            Trigram('r', 'l', 'e'),
            Trigram('m', 'a', 'l'),
            Trigram('k', 'a', 'n'),
            Trigram('g', 'a', 't'),
            Trigram('t', 'm', 'e'),
            Trigram('s', 'i', 'n'),
            Trigram('a', 'n', 'd'),
            Trigram('ň', ' ', 'g'),
            Trigram('g', 'o', 'r'),
            Trigram(' ', 't', 'a'),
            Trigram('ö', 'w', 'l'),
            Trigram('ý', 'l', 'e'),
            Trigram('y', ' ', 'g'),
            Trigram('e', ' ', 'w'),
            Trigram('o', 'r', 'a'),
            Trigram('t', 'i', 'ň'),
            Trigram('e', 'k', 'l'),
            Trigram(' ', 'y', 'n'),
            Trigram('a', 'l', 'k'),
            Trigram('d', 'ö', 'w'),
            Trigram(' ', 'd', 'ö'),
            Trigram('e', 'r', 'e'),
            Trigram('m', ' ', 'h'),
            Trigram(' ', 'm', 'e'),
            Trigram('d', 'u', 'r'),
            Trigram(' ', 'e', 'r'),
            Trigram('a', 's', 'i'),
            Trigram('t', 'u', 't'),
            Trigram('a', 't', ' '),
            Trigram('ç', 'i', 'n'),
            Trigram('i', 'r', 'l'),
            Trigram('u', 'm', 'y'),
            Trigram('e', 'l', 'i'),
            Trigram('e', 'r', 'k'),
            Trigram('n', 'm', 'e'),
            Trigram('w', 'l', 'e'),
            Trigram('g', 'u', 'r'),
            Trigram('a', ' ', 'ö'),
            Trigram('a', 'ý', 'a'),
            Trigram(' ', 'ç', 'ä'),
            Trigram('n', 'u', 'n'),
            Trigram(' ', 'k', 'i'),
            Trigram('r', 'a', 's'),
            Trigram('a', 'm', 'l'),
            Trigram('u', 'p', ' '),
            Trigram('ý', 'a', 'ş'),
            Trigram('t', 'y', 'n'),
            Trigram(' ', 'a', 'ý'),
            Trigram('r', 'y', ' '),
            Trigram('ň', ' ', 'd'),
            Trigram('b', 'a', 'ş'),
            Trigram('i', 'p', ' '),
            Trigram('g', 'i', ' '),
            Trigram('z', ' ', 'h'),
            Trigram('k', 'i', 'n'),
            Trigram('z', ' ', 'ö'),
            Trigram('n', ' ', 'w'),
            Trigram('t', 'e', 'r'),
            Trigram('i', 'n', 'm'),
            Trigram('e', 'ý', 'l'),
            Trigram('i', ' ', 'ý'),
            Trigram('k', 'i', 'm'),
            Trigram('n', 'a', 'm'),
            Trigram('e', 'ň', ' '),
            Trigram('b', 'e', 'ý'),
            Trigram('d', 'o', 'l'),
            Trigram(' ', 's', 'e'),
            Trigram(' ', 't', 'e'),
            Trigram('r', ' ', 'd'),
            Trigram('u', 't', 'u'),
            Trigram('g', 'y', 'ý'),
            Trigram('e', 'z', ' '),
            Trigram('u', 'm', 'u'),
            Trigram('m', 'u', 'm'),
        ],
    ),
    (
        Lang::Dan,
        &[
            Trigram('e', 'r', ' '),
            Trigram('o', 'g', ' '),
            Trigram(' ', 'o', 'g'),
            Trigram('d', 'e', 'r'),
            Trigram(' ', 'd', 'e'),
            Trigram('f', 'o', 'r'),
            Trigram('e', 'n', ' '),
            Trigram('e', 't', ' '),
            Trigram('t', 'i', 'l'),
            Trigram(' ', 'f', 'o'),
            Trigram(' ', 't', 'i'),
            Trigram('i', 'n', 'g'),
            Trigram('d', 'e', ' '),
            Trigram('n', 'd', 'e'),
            Trigram('r', 'e', 't'),
            Trigram(' ', 'r', 'e'),
            Trigram('h', 'e', 'd'),
            Trigram('i', 'l', ' '),
            Trigram('l', 'i', 'g'),
            Trigram(' ', 'h', 'a'),
            Trigram('l', 'l', 'e'),
            Trigram('d', 'e', 'n'),
            Trigram(' ', 'e', 'n'),
            Trigram('e', 'd', ' '),
            Trigram('v', 'e', 'r'),
            Trigram('e', 'l', 's'),
            Trigram('u', 'n', 'd'),
            Trigram('a', 'r', ' '),
            Trigram(' ', 'f', 'r'),
            Trigram(' ', 'm', 'e'),
            Trigram('s', 'e', ' '),
            Trigram('l', 's', 'e'),
            Trigram('a', 'n', 'd'),
            Trigram('h', 'a', 'r'),
            Trigram('g', 'e', 'n'),
            Trigram('e', 'd', 'e'),
            Trigram('g', 'e', ' '),
            Trigram('e', 'l', 'l'),
            Trigram('n', 'g', ' '),
            Trigram('a', 't', ' '),
            Trigram(' ', 'a', 'f'),
            Trigram('n', 'n', 'e'),
            Trigram('l', 'e', ' '),
            Trigram('n', 'g', 'e'),
            Trigram('e', ' ', 'f'),
            Trigram('g', 'h', 'e'),
            Trigram('e', ' ', 'o'),
            Trigram('i', 'g', 'h'),
            Trigram('e', 's', ' '),
            Trigram('a', 'f', ' '),
            Trigram('e', 'n', 'n'),
            Trigram(' ', 'a', 't'),
            Trigram('l', 'e', 'r'),
            Trigram(' ', 'i', ' '),
            Trigram('s', 'k', 'e'),
            Trigram('h', 'v', 'e'),
            Trigram('e', ' ', 'e'),
            Trigram('r', ' ', 'h'),
            Trigram('n', 'e', ' '),
            Trigram('e', 'n', 'h'),
            Trigram('t', ' ', 't'),
            Trigram('i', 'g', 'e'),
            Trigram('e', 's', 'k'),
            Trigram(' ', 'e', 'l'),
            Trigram(' ', 'b', 'e'),
            Trigram('i', 'g', ' '),
            Trigram('t', 'i', 'g'),
            Trigram('f', 'r', 'i'),
            Trigram('o', 'r', ' '),
            Trigram('s', 'k', 'a'),
            Trigram('n', 'i', 'n'),
            Trigram('e', ' ', 's'),
            Trigram('i', 'o', 'n'),
            Trigram(' ', 'e', 'r'),
            Trigram('n', 'h', 'v'),
            Trigram('r', 'e', ' '),
            Trigram('m', 'e', 'n'),
            Trigram('r', ' ', 'o'),
            Trigram('e', ' ', 'a'),
            Trigram(' ', 's', 't'),
            Trigram('a', 't', 'i'),
            Trigram(' ', 's', 'k'),
            Trigram(' ', 'i', 'n'),
            Trigram('l', ' ', 'a'),
            Trigram('t', 'i', 'o'),
            Trigram(' ', 'p', 'å'),
            Trigram('e', 't', 't'),
            Trigram('e', 'n', 's'),
            Trigram('a', 'l', ' '),
            Trigram('t', 't', 'i'),
            Trigram('m', 'e', 'd'),
            Trigram('r', ' ', 'f'),
            Trigram('o', 'm', ' '),
            Trigram('e', 'n', 'd'),
            Trigram('r', ' ', 'e'),
            Trigram('d', 'e', 'l'),
            Trigram('g', ' ', 'f'),
            Trigram('k', 'e', ' '),
            Trigram(' ', 's', 'o'),
            Trigram('p', 'å', ' '),
            Trigram('e', 'l', 'i'),
            Trigram('g', ' ', 'o'),
            Trigram(' ', 'a', 'n'),
            Trigram('r', ' ', 'r'),
            Trigram('n', 's', ' '),
            Trigram(' ', 'a', 'l'),
            Trigram('n', 'a', 't'),
            Trigram('h', 'a', 'n'),
            Trigram(' ', 'v', 'e'),
            Trigram('r', ' ', 's'),
            Trigram('r', ' ', 'a'),
            Trigram(' ', 'u', 'n'),
            Trigram(' ', 'h', 'e'),
            Trigram('t', ' ', 'f'),
            Trigram('l', 'i', 'n'),
            Trigram(' ', 's', 'i'),
            Trigram('r', ' ', 'd'),
            Trigram('t', 'e', 'r'),
            Trigram('e', 'r', 'e'),
            Trigram('n', 'e', 's'),
            Trigram('d', 'e', 't'),
            Trigram('e', ' ', 'r'),
            Trigram(' ', 'u', 'd'),
            Trigram('a', 'l', 'e'),
            Trigram('s', 'a', 'm'),
            Trigram('i', 'h', 'e'),
            Trigram('l', 'a', 'n'),
            Trigram('t', 't', 'e'),
            Trigram('r', 'i', 'n'),
            Trigram('r', 'i', 'h'),
            Trigram('e', 'n', 't'),
            Trigram('n', 'd', 'l'),
            Trigram('e', ' ', 'm'),
            Trigram('i', 's', 'k'),
            Trigram('e', 'r', 'k'),
            Trigram('a', 'n', 's'),
            Trigram('t', ' ', 's'),
            Trigram('k', 'a', 'l'),
            Trigram(' ', 'n', 'a'),
            Trigram('s', 'o', 'm'),
            Trigram('h', 'o', 'l'),
            Trigram('l', 'd', 'e'),
            Trigram('i', 'n', 'd'),
            Trigram('e', ' ', 'n'),
            Trigram('r', 'e', 'n'),
            Trigram('n', ' ', 's'),
            Trigram('n', 'e', 'r'),
            Trigram('k', 'e', 'l'),
            Trigram('o', 'l', 'd'),
            Trigram('d', 'i', 'g'),
            Trigram('t', 'e', ' '),
            Trigram('o', 'r', 's'),
            Trigram('e', ' ', 'i'),
            Trigram(' ', 'h', 'v'),
            Trigram('s', 'n', 'i'),
            Trigram('s', 'k', 'y'),
            Trigram('e', 'n', 'e'),
            Trigram('v', 'æ', 'r'),
            Trigram(' ', 'l', 'i'),
            Trigram(' ', 's', 'a'),
            Trigram('s', ' ', 'f'),
            Trigram('d', ' ', 'd'),
            Trigram('e', 'r', 's'),
            Trigram('s', 't', 'e'),
            Trigram('n', 't', 'e'),
            Trigram('m', 'm', 'e'),
            Trigram('o', 'v', 'e'),
            Trigram('e', ' ', 'h'),
            Trigram('n', 'a', 'l'),
            Trigram('o', 'n', 'a'),
            Trigram('g', 'e', 'r'),
            Trigram(' ', 'g', 'r'),
            Trigram('a', 'g', 'e'),
            Trigram('g', ' ', 'a'),
            Trigram('v', 'i', 'l'),
            Trigram('a', 'l', 'l'),
            Trigram('e', ' ', 'd'),
            Trigram('f', 'r', 'e'),
            Trigram('t', 'e', 'l'),
            Trigram('s', ' ', 'o'),
            Trigram('g', ' ', 'h'),
            Trigram('t', ' ', 'o'),
            Trigram('t', ' ', 'd'),
            Trigram('r', ' ', 'i'),
            Trigram('e', ' ', 't'),
            Trigram(' ', 'o', 'm'),
            Trigram('a', 'r', 'b'),
            Trigram('d', ' ', 'e'),
            Trigram('e', 'r', 'n'),
            Trigram('r', ' ', 'u'),
            Trigram(' ', 'v', 'æ'),
            Trigram('d', ' ', 'o'),
            Trigram('r', 'e', 's'),
            Trigram('g', ' ', 't'),
            Trigram('k', 'l', 'æ'),
            Trigram('ø', 'r', 'e'),
            Trigram('n', ' ', 'f'),
            Trigram(' ', 'v', 'i'),
            Trigram(' ', 'm', 'å'),
            Trigram('v', 'e', 'n'),
            Trigram('s', 'k', ' '),
            Trigram(' ', 'l', 'a'),
            Trigram('g', 't', 'e'),
            Trigram('k', 'a', 'b'),
            Trigram('s', 't', 'r'),
            Trigram('n', ' ', 'm'),
            Trigram('r', 'e', 'l'),
            Trigram('e', ' ', 'b'),
            Trigram('r', 'u', 'n'),
            Trigram('r', 'b', 'e'),
            Trigram('b', 'e', 'j'),
            Trigram('t', ' ', 'i'),
            Trigram('e', 'j', 'd'),
            Trigram('k', 'k', 'e'),
            Trigram('t', ' ', 'e'),
            Trigram('g', ' ', 'd'),
            Trigram('r', 'k', 'l'),
            Trigram('i', 'l', 'k'),
            Trigram('g', 'r', 'u'),
            Trigram('v', 'e', 'd'),
            Trigram('b', 'e', 's'),
            Trigram(' ', 'd', 'a'),
            Trigram('n', 'd', ' '),
            Trigram(' ', 'f', 'u'),
            Trigram('l', 'æ', 'r'),
            Trigram('æ', 'r', 'i'),
            Trigram('r', 'd', 'i'),
            Trigram('æ', 'r', 'd'),
            Trigram('l', 'd', ' '),
            Trigram('t', ' ', 'm'),
            Trigram('d', 'l', 'i'),
            Trigram('f', 'u', 'n'),
            Trigram('s', 'i', 'g'),
            Trigram(' ', 'm', 'o'),
            Trigram('s', 't', 'a'),
            Trigram('n', 's', 't'),
            Trigram('r', 't', ' '),
            Trigram('o', 'd', ' '),
            Trigram(' ', 'a', 'r'),
            Trigram(' ', 'o', 'p'),
            Trigram('v', 'i', 's'),
            Trigram('i', 'g', 't'),
            Trigram('æ', 'r', 'e'),
            Trigram('t', 'e', 't'),
            Trigram('t', ' ', 'a'),
            Trigram('e', 'm', 'm'),
            Trigram('g', ' ', 'e'),
            Trigram('m', 'o', 'd'),
            Trigram('r', 'h', 'o'),
            Trigram('i', 'e', ' '),
            Trigram('g', ' ', 'u'),
            Trigram('k', 'e', 'r'),
            Trigram('r', 'e', 'm'),
            Trigram(' ', 'n', 'o'),
            Trigram('n', ' ', 'h'),
            Trigram(' ', 'f', 'a'),
            Trigram('r', 's', 'k'),
            Trigram('o', 'r', 'm'),
            Trigram('e', ' ', 'u'),
            Trigram('s', ' ', 's'),
            Trigram('e', 'm', ' '),
            Trigram('d', ' ', 'h'),
            Trigram(' ', 'g', 'e'),
            Trigram('e', 't', 's'),
            Trigram('e', ' ', 'g'),
            Trigram('g', ' ', 's'),
            Trigram('p', 'e', 'r'),
            Trigram(' ', 'e', 't'),
            Trigram('l', 'e', 'm'),
            Trigram(' ', 't', 'r'),
            Trigram('i', ' ', 's'),
            Trigram('d', 'a', ' '),
            Trigram('d', 'r', 'e'),
            Trigram('n', ' ', 'a'),
            Trigram('d', 'e', 's'),
            Trigram('d', 't', ' '),
            Trigram('k', 'y', 't'),
            Trigram('r', 'd', 'e'),
            Trigram('y', 't', 't'),
            Trigram('e', 'r', 'i'),
            Trigram('h', 'e', 'n'),
            Trigram('e', 'r', 'v'),
            Trigram('l', ' ', 'e'),
            Trigram('r', 'v', 'i'),
            Trigram('f', 'f', 'e'),
            Trigram('o', 'f', 'f'),
            Trigram('i', 's', 'n'),
            Trigram('r', ' ', 't'),
            Trigram(' ', 'o', 'f'),
            Trigram('k', 'e', 'n'),
            Trigram('l', ' ', 'h'),
            Trigram('r', 'k', 'e'),
            Trigram('g', ' ', 'i'),
            Trigram('t', 'a', 'l'),
            Trigram('m', 'å', ' '),
            Trigram('r', ' ', 'k'),
            Trigram('l', 'k', 'e'),
            Trigram('g', 't', ' '),
            Trigram('t', ' ', 'v'),
            Trigram('t', ' ', 'b'),
        ],
    ),
    (
        Lang::Nob,
        &[
            Trigram('e', 'r', ' '),
            Trigram(' ', 'o', 'g'),
            Trigram('o', 'g', ' '),
            Trigram('e', 'n', ' '),
            Trigram(' ', 'd', 'e'),
            Trigram('f', 'o', 'r'),
            Trigram('t', 'i', 'l'),
            Trigram('i', 'n', 'g'),
            Trigram('e', 't', 't'),
            Trigram(' ', 't', 'i'),
            Trigram('e', 't', ' '),
            Trigram(' ', 'h', 'a'),
            Trigram(' ', 'f', 'o'),
            Trigram(' ', 'r', 'e'),
            Trigram('r', 'e', 't'),
            Trigram('i', 'l', ' '),
            Trigram('h', 'e', 't'),
            Trigram('l', 'l', 'e'),
            Trigram('v', 'e', 'r'),
            Trigram('t', 't', ' '),
            Trigram('a', 'r', ' '),
            Trigram('n', 'n', 'e'),
            Trigram(' ', 'e', 'n'),
            Trigram('o', 'm', ' '),
            Trigram('e', 'l', 'l'),
            Trigram('n', 'g', ' '),
            Trigram('h', 'a', 'r'),
            Trigram(' ', 'm', 'e'),
            Trigram('e', 'n', 'n'),
            Trigram('t', 'e', 'r'),
            Trigram('d', 'e', ' '),
            Trigram('l', 'i', 'g'),
            Trigram(' ', 'f', 'r'),
            Trigram(' ', 's', 'o'),
            Trigram('r', ' ', 'h'),
            Trigram('l', 'e', 'r'),
            Trigram('a', 'v', ' '),
            Trigram('l', 'e', ' '),
            Trigram('d', 'e', 'n'),
            Trigram('a', 'n', 'd'),
            Trigram(' ', 'i', ' '),
            Trigram(' ', 'e', 'r'),
            Trigram('s', 'o', 'm'),
            Trigram(' ', 'å', ' '),
            Trigram('h', 'v', 'e'),
            Trigram('o', 'r', ' '),
            Trigram('t', ' ', 't'),
            Trigram('n', 'e', ' '),
            Trigram(' ', 'e', 'l'),
            Trigram('e', 'l', 's'),
            Trigram('r', 'e', ' '),
            Trigram(' ', 'a', 'v'),
            Trigram('s', 'e', ' '),
            Trigram('e', 's', 'k'),
            Trigram('e', 'n', 'h'),
            Trigram('n', 'g', 'e'),
            Trigram('s', 'k', 'a'),
            Trigram('n', 'd', 'e'),
            Trigram('e', ' ', 'o'),
            Trigram('e', 't', 'e'),
            Trigram('g', 'e', 'n'),
            Trigram('k', 'e', ' '),
            Trigram('l', 's', 'e'),
            Trigram('g', 'h', 'e'),
            Trigram('t', 'e', 'n'),
            Trigram('m', 'e', 'n'),
            Trigram(' ', 's', 't'),
            Trigram('r', ' ', 's'),
            Trigram('f', 'r', 'i'),
            Trigram('i', 'g', 'h'),
            Trigram('i', 'g', ' '),
            Trigram(' ', 'b', 'e'),
            Trigram('e', ' ', 'e'),
            Trigram('n', 'h', 'v'),
            Trigram('r', ' ', 'r'),
            Trigram('t', 't', 'e'),
            Trigram('s', 'k', 'e'),
            Trigram('t', 'e', ' '),
            Trigram(' ', 'p', 'å'),
            Trigram(' ', 'u', 't'),
            Trigram(' ', 's', 'k'),
            Trigram('a', 'l', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram('s', 'j', 'o'),
            Trigram('p', 'å', ' '),
            Trigram('d', 'e', 'r'),
            Trigram('e', ' ', 's'),
            Trigram('n', 'e', 'r'),
            Trigram('r', 'i', 'n'),
            Trigram('j', 'o', 'n'),
            Trigram('t', ' ', 'o'),
            Trigram('u', 'n', 'n'),
            Trigram('e', ' ', 'f'),
            Trigram('h', 'a', 'n'),
            Trigram('a', 's', 'j'),
            Trigram('t', 'i', 'g'),
            Trigram('e', 'd', ' '),
            Trigram('e', 's', ' '),
            Trigram('g', ' ', 'f'),
            Trigram('s', 'a', 'm'),
            Trigram('e', 'n', 't'),
            Trigram('t', 't', 'i'),
            Trigram('e', 'n', 'e'),
            Trigram('n', 'e', 's'),
            Trigram('m', 'e', 'd'),
            Trigram('g', 'e', ' '),
            Trigram(' ', 'a', 'l'),
            Trigram('r', ' ', 'o'),
            Trigram('e', 'n', 's'),
            Trigram('r', ' ', 'e'),
            Trigram('e', 'l', 'i'),
            Trigram('i', 's', 'k'),
            Trigram('l', 'i', 'n'),
            Trigram(' ', 'v', 'e'),
            Trigram('n', 'i', 'n'),
            Trigram('g', ' ', 'o'),
            Trigram(' ', 's', 'a'),
            Trigram(' ', 'a', 'n'),
            Trigram('t', ' ', 'f'),
            Trigram('i', 't', 't'),
            Trigram('l', 'i', 'k'),
            Trigram('e', 'n', 'd'),
            Trigram('k', 'a', 'l'),
            Trigram('r', ' ', 'f'),
            Trigram('t', ' ', 's'),
            Trigram('r', 'i', 'h'),
            Trigram('i', 'h', 'e'),
            Trigram('n', 'a', 's'),
            Trigram('n', 't', 'e'),
            Trigram('e', ' ', 'r'),
            Trigram('n', 's', ' '),
            Trigram(' ', 's', 'i'),
            Trigram('l', 'a', 'n'),
            Trigram('g', ' ', 's'),
            Trigram('m', 'm', 'e'),
            Trigram('i', 'g', 'e'),
            Trigram('l', ' ', 'å'),
            Trigram('e', 'r', 'k'),
            Trigram('d', 'i', 'g'),
            Trigram(' ', 'g', 'r'),
            Trigram('n', ' ', 's'),
            Trigram('r', 'e', 'n'),
            Trigram('r', ' ', 'a'),
            Trigram('a', 'l', 'l'),
            Trigram(' ', 'n', 'a'),
            Trigram('k', 't', 'e'),
            Trigram('e', 'r', 'd'),
            Trigram('e', 'r', 'e'),
            Trigram('e', ' ', 'm'),
            Trigram('u', 'n', 'd'),
            Trigram('r', ' ', 'u'),
            Trigram('r', 'e', 's'),
            Trigram('t', 'e', 'l'),
            Trigram('s', 't', 'e'),
            Trigram('g', 'r', 'u'),
            Trigram('i', 'n', 'n'),
            Trigram('l', 'æ', 'r'),
            Trigram('e', 'r', 's'),
            Trigram(' ', 'u', 'n'),
            Trigram('d', 'e', 't'),
            Trigram('t', ' ', 'e'),
            Trigram('a', 'r', 'b'),
            Trigram('a', 'l', 'e'),
            Trigram('d', 'e', 'l'),
            Trigram('e', 'k', 't'),
            Trigram('v', 'e', 'n'),
            Trigram('t', ' ', 'i'),
            Trigram('g', ' ', 'e'),
            Trigram('b', 'e', 'i'),
            Trigram('e', 'i', 'd'),
            Trigram('e', ' ', 'a'),
            Trigram('n', ' ', 'm'),
            Trigram('e', ' ', 'd'),
            Trigram(' ', 'a', 'r'),
            Trigram('r', 'b', 'e'),
            Trigram('e', ' ', 'g'),
            Trigram(' ', 'b', 'l'),
            Trigram('a', 'n', 's'),
            Trigram('k', 'l', 'æ'),
            Trigram(' ', 'l', 'i'),
            Trigram(' ', 'h', 'e'),
            Trigram('g', ' ', 't'),
            Trigram('æ', 'r', 'i'),
            Trigram('s', 'k', 'y'),
            Trigram('r', 'u', 'n'),
            Trigram('r', 'k', 'l'),
            Trigram(' ', 'l', 'a'),
            Trigram('s', 't', 'a'),
            Trigram('s', 'n', 'i'),
            Trigram('k', 'k', 'e'),
            Trigram('m', ' ', 'e'),
            Trigram('r', 't', ' '),
            Trigram('m', 'o', 't'),
            Trigram(' ', 'm', 'o'),
            Trigram('e', ' ', 'n'),
            Trigram('t', 'a', 't'),
            Trigram('a', 't', ' '),
            Trigram('e', ' ', 'h'),
            Trigram('e', ' ', 'b'),
            Trigram('o', 'v', 'e'),
            Trigram('e', ' ', 't'),
            Trigram('j', 'e', 'n'),
            Trigram('t', ' ', 'd'),
            Trigram('s', 't', 'r'),
            Trigram(' ', 'm', 'å'),
            Trigram('r', ' ', 'm'),
            Trigram('n', ' ', 'e'),
            Trigram('o', 'r', 's'),
            Trigram('r', 'e', 'l'),
            Trigram('k', 'e', 'r'),
            Trigram(' ', 'e', 't'),
            Trigram('n', ' ', 'a'),
            Trigram('b', 'e', 's'),
            Trigram('o', 'n', 'e'),
            Trigram(' ', 'v', 'i'),
            Trigram('n', 'n', ' '),
            Trigram('g', ' ', 'r'),
            Trigram('e', ' ', 'i'),
            Trigram('k', 'a', 'p'),
            Trigram('s', 'k', ' '),
            Trigram('o', 't', ' '),
            Trigram('n', 'd', 'i'),
            Trigram('n', 'n', 'l'),
            Trigram('i', ' ', 's'),
            Trigram(' ', 'd', 'a'),
            Trigram('s', ' ', 'o'),
            Trigram(' ', 'n', 'o'),
            Trigram('i', 'd', ' '),
            Trigram('g', 'e', 'r'),
            Trigram('g', ' ', 'h'),
            Trigram('v', 'i', 's'),
            Trigram('n', ' ', 'o'),
            Trigram('b', 'a', 'r'),
            Trigram('s', ' ', 'f'),
            Trigram('n', 'd', 'l'),
            Trigram('t', ' ', 'm'),
            Trigram('g', ' ', 'a'),
            Trigram('o', 'p', 'p'),
            Trigram('t', ' ', 'a'),
            Trigram('d', 'i', 's'),
            Trigram('n', 'a', 'l'),
            Trigram('r', ' ', 'd'),
            Trigram('p', 'e', 'r'),
            Trigram('d', 'r', 'e'),
            Trigram('o', 'n', 'a'),
            Trigram('æ', 'r', 'e'),
            Trigram('r', 'd', 'i'),
            Trigram('d', 'a', ' '),
            Trigram('u', 't', 'e'),
            Trigram('n', 's', 'e'),
            Trigram('b', 'l', 'i'),
            Trigram('o', 'r', 'e'),
            Trigram('t', 'e', 't'),
            Trigram('r', 'i', 't'),
            Trigram(' ', 'o', 'p'),
            Trigram('k', 'r', 'a'),
            Trigram('e', 'r', 'i'),
            Trigram('h', 'o', 'l'),
            Trigram('o', 'l', 'd'),
            Trigram(' ', 'k', 'r'),
            Trigram('y', 't', 't'),
            Trigram('k', 'y', 't'),
            Trigram('f', 'f', 'e'),
            Trigram('e', 'm', 'm'),
            Trigram('g', ' ', 'd'),
            Trigram('l', ' ', 'f'),
            Trigram(' ', 'o', 'm'),
            Trigram('i', 's', 'n'),
            Trigram(' ', 'g', 'j'),
            Trigram('å', ' ', 'd'),
            Trigram('s', 'e', 'r'),
            Trigram('r', ' ', 'b'),
            Trigram(' ', 'd', 'i'),
            Trigram(' ', 'f', 'a'),
            Trigram('n', ' ', 't'),
            Trigram('r', ' ', 'k'),
            Trigram('l', 't', ' '),
            Trigram('s', 'e', 't'),
            Trigram(' ', 's', 'l'),
            Trigram('d', 'o', 'm'),
            Trigram('r', 'v', 'i'),
            Trigram('m', 'e', ' '),
            Trigram('l', ' ', 'e'),
            Trigram('g', 'r', 'e'),
            Trigram('å', ' ', 's'),
            Trigram('m', 'å', ' '),
            Trigram(' ', 't', 'r'),
            Trigram('n', 'd', ' '),
            Trigram('m', ' ', 's'),
            Trigram('g', ' ', 'i'),
            Trigram('i', 'k', 'k'),
            Trigram('n', ' ', 'h'),
            Trigram(' ', 'a', 't'),
            Trigram('t', 'e', 's'),
            Trigram('v', 'i', 'l'),
            Trigram('d', 'l', 'i'),
            Trigram('g', ' ', 'b'),
            Trigram('d', ' ', 'd'),
            Trigram(' ', 'h', 'v'),
            Trigram('r', 'a', 'v'),
        ],
    ),
    (
        Lang::Cat,
        &[
            Trigram(' ', 'd', 'e'),
            Trigram(' ', 'i', ' '),
            Trigram('e', 's', ' '),
            Trigram('d', 'e', ' '),
            Trigram('l', 'a', ' '),
            Trigram(' ', 'l', 'a'),
            Trigram(' ', 'a', ' '),
            Trigram(' ', 'p', 'e'),
            Trigram('p', 'e', 'r'),
            Trigram('i', 'ó', ' '),
            Trigram('e', 'n', 't'),
            Trigram('t', 'a', 't'),
            Trigram(' ', 's', 'e'),
            Trigram('n', 't', ' '),
            Trigram('r', 'e', 't'),
            Trigram('t', 's', ' '),
            Trigram('d', 'r', 'e'),
            Trigram('a', 't', ' '),
            Trigram(' ', 'e', 'l'),
            Trigram('l', 's', ' '),
            Trigram(' ', 'd', 'r'),
            Trigram('m', 'e', 'n'),
            Trigram('a', 'c', 'i'),
            Trigram('a', ' ', 'p'),
            Trigram('c', 'i', 'ó'),
            Trigram('o', 'n', 'a'),
            Trigram(' ', 'c', 'o'),
            Trigram('a', ' ', 'l'),
            Trigram('a', 'l', ' '),
            Trigram('n', 'a', ' '),
            Trigram('s', ' ', 'd'),
            Trigram('q', 'u', 'e'),
            Trigram('e', 'n', ' '),
            Trigram('e', 'l', ' '),
            Trigram(' ', 't', 'o'),
            Trigram('s', ' ', 'i'),
            Trigram(' ', 'q', 'u'),
            Trigram(' ', 'e', 'n'),
            Trigram('e', ' ', 'l'),
            Trigram('n', 's', ' '),
            Trigram('t', 'o', 't'),
            Trigram('e', 't', ' '),
            Trigram('t', ' ', 'a'),
            Trigram('e', 'r', 's'),
            Trigram(' ', 'p', 'r'),
            Trigram('t', ' ', 'd'),
            Trigram('o', 'n', 's'),
            Trigram('e', 'r', ' '),
            Trigram(' ', 'l', 'l'),
            Trigram('i', 'o', 'n'),
            Trigram('a', ' ', 's'),
            Trigram('t', 'a', ' '),
            Trigram('a', ' ', 't'),
            Trigram('c', 'o', 'n'),
            Trigram('e', 'l', 's'),
            Trigram('s', ' ', 'e'),
            Trigram(' ', 'l', '’'),
            Trigram('r', 's', 'o'),
            Trigram('r', 'e', 's'),
            Trigram('a', 'l', 's'),
            Trigram('s', 'o', 'n'),
            Trigram(' ', 'u', 'n'),
            Trigram('e', 's', 't'),
            Trigram('c', 'i', 'o'),
            Trigram(' ', 'r', 'e'),
            Trigram('p', 'r', 'o'),
            Trigram('i', 't', 'a'),
            Trigram('c', 'i', 'a'),
            Trigram(' ', 'i', 'n'),
            Trigram('l', 'e', 's'),
            Trigram(' ', 'o', ' '),
            Trigram('u', 'e', ' '),
            Trigram('d', 'e', 'l'),
            Trigram('l', 'l', 'i'),
            Trigram('t', 'é', ' '),
            Trigram(' ', 't', 'é'),
            Trigram('i', 'a', ' '),
            Trigram('a', 'm', 'e'),
            Trigram('é', ' ', 'd'),
            Trigram('s', 'e', 'v'),
            Trigram('o', 't', 'a'),
            Trigram('n', 'a', 'c'),
            Trigram('i', ' ', 'l'),
            Trigram(' ', 'a', 'l'),
            Trigram('s', ' ', 'p'),
            Trigram('a', ' ', 'd'),
            Trigram('a', 'r', ' '),
            Trigram('a', ' ', 'i'),
            Trigram('u', 'a', 'l'),
            Trigram('n', 'a', 'l'),
            Trigram('a', ' ', 'c'),
            Trigram('a', 'n', 't'),
            Trigram('n', 'c', 'i'),
            Trigram(' ', 'l', 'e'),
            Trigram('e', 'r', 't'),
            Trigram('s', 't', 'a'),
            Trigram('r', 't', 'a'),
            Trigram('s', 'e', 'r'),
            Trigram('t', ' ', 'i'),
            Trigram('i', ' ', 'a'),
            Trigram('l', ' ', 'd'),
            Trigram(' ', 'n', 'o'),
            Trigram('v', 'a', ' '),
            Trigram('a', 't', 's'),
            Trigram(' ', 'd', '’'),
            Trigram('s', ' ', 'n'),
            Trigram('r', 'e', ' '),
            Trigram('s', ' ', 'a'),
            Trigram('e', ' ', 'c'),
            Trigram('e', 'v', 'a'),
            Trigram(' ', 'n', 'a'),
            Trigram('r', 'à', ' '),
            Trigram(' ', 'c', 'a'),
            Trigram('u', 'e', 's'),
            Trigram('c', 'o', 'm'),
            Trigram('l', 'i', 'b'),
            Trigram('é', 's', ' '),
            Trigram(' ', 's', 'o'),
            Trigram('i', 'b', 'e'),
            Trigram(' ', 'e', 's'),
            Trigram('e', 't', 's'),
            Trigram('b', 'e', 'r'),
            Trigram('d', 'a', ' '),
            Trigram('r', ' ', 'a'),
            Trigram('n', 'o', ' '),
            Trigram('u', 'n', 'a'),
            Trigram('l', '’', 'e'),
            Trigram('s', ' ', 'l'),
            Trigram('t', 'e', 'r'),
            Trigram('s', 'e', 'n'),
            Trigram('r', 'a', 'n'),
            Trigram('u', 'r', 'e'),
            Trigram('d', 'e', 's'),
            Trigram('m', 'a', 'n'),
            Trigram('i', ' ', 'e'),
            Trigram('l', ' ', 'p'),
            Trigram('t', ' ', 'e'),
            Trigram('n', ' ', 'd'),
            Trigram('e', ' ', 'd'),
            Trigram('e', ' ', 'e'),
            Trigram('o', 'm', ' '),
            Trigram(' ', 'd', 'i'),
            Trigram('c', 'c', 'i'),
            Trigram('i', 'g', 'u'),
            Trigram('a', ' ', 'a'),
            Trigram('s', ' ', 't'),
            Trigram(' ', 'p', 'a'),
            Trigram('i', ' ', 'd'),
            Trigram('t', 'r', 'a'),
            Trigram('s', ' ', 'o'),
            Trigram('a', 'q', 'u'),
            Trigram('t', 'r', 'e'),
            Trigram('v', 'o', 'l'),
            Trigram('e', 'c', 't'),
            Trigram('a', ' ', 'u'),
            Trigram('l', ' ', 'i'),
            Trigram('g', 'u', 'a'),
            Trigram('i', 'd', 'e'),
            Trigram('s', ' ', 's'),
            Trigram('a', 'd', 'a'),
            Trigram('e', 'n', 'e'),
            Trigram('i', 'a', 'l'),
            Trigram('n', 't', 'a'),
            Trigram('n', 't', 'r'),
            Trigram('e', 'n', 's'),
            Trigram('s', 'o', 'c'),
            Trigram('c', 't', 'e'),
            Trigram('r', 'a', ' '),
            Trigram('o', 'c', 'i'),
            Trigram('h', 'u', 'm'),
            Trigram('u', 'm', 'a'),
            Trigram('c', 'l', 'a'),
            Trigram('a', 'l', 'i'),
            Trigram('l', 'i', 't'),
            Trigram('e', 'r', 'à'),
            Trigram('c', 't', 'i'),
            Trigram(' ', 'a', 'q'),
            Trigram(' ', 'h', 'u'),
            Trigram('i', 'c', 'i'),
            Trigram('p', 'r', 'e'),
            Trigram('e', 'r', 'a'),
            Trigram('e', 's', 's'),
            Trigram('u', 'n', 'i'),
            Trigram('n', 't', 'e'),
            Trigram(' ', 'f', 'o'),
            Trigram(' ', 'n', 'i'),
            Trigram('b', 'l', 'e'),
            Trigram('s', 's', 'e'),
            Trigram('t', 'e', 's'),
            Trigram('a', 'l', 't'),
            Trigram('e', 'm', 'e'),
            Trigram('a', 's', 's'),
            Trigram('i', 'c', 'a'),
            Trigram('s', 'e', 'g'),
            Trigram('o', ' ', 's'),
            Trigram('o', 't', 'e'),
            Trigram('r', 'a', 'c'),
            Trigram(' ', 'i', 'g'),
            Trigram(' ', 'p', 'o'),
            Trigram('a', 'n', 's'),
            Trigram(' ', 'é', 's'),
            Trigram('a', ' ', 'e'),
            Trigram('u', 'n', ' '),
            Trigram('u', 's', ' '),
            Trigram('m', 'i', 't'),
            Trigram(' ', 'm', 'a'),
            Trigram('r', ' ', 's'),
            Trigram('s', 'e', ' '),
            Trigram('s', 's', 'i'),
            Trigram('s', ' ', 'h'),
            Trigram('a', ' ', 'm'),
            Trigram('r', ' ', 'l'),
            Trigram('n', 'i', 't'),
            Trigram('l', ' ', 't'),
            Trigram('è', 'n', 'c'),
            Trigram('ó', ' ', 'd'),
            Trigram('t', 'e', 'n'),
            Trigram(' ', 't', 'e'),
            Trigram('i', 'r', ' '),
            Trigram('i', ' ', 'p'),
            Trigram('t', 'a', 'l'),
            Trigram('e', 't', 'a'),
            Trigram('d', 'i', 'c'),
            Trigram('i', ' ', 'i'),
            Trigram('h', 'o', 'm'),
            Trigram('t', ' ', 'q'),
            Trigram('p', 'a', 'r'),
            Trigram('e', 'g', 'u'),
            Trigram('s', ' ', 'f'),
            Trigram(' ', 'a', 's'),
            Trigram('n', ' ', 'l'),
            Trigram('r', 'i', 'a'),
            Trigram(' ', 'm', 'i'),
            Trigram(' ', 'a', 'c'),
            Trigram('l', 'i', 'c'),
            Trigram('i', 'n', 't'),
            Trigram(' ', 't', 'r'),
            Trigram('a', 'c', 't'),
            Trigram('e', 'i', 'x'),
            Trigram('n', ' ', 'e'),
            Trigram('s', ' ', 'c'),
            Trigram('o', 'n', 't'),
            Trigram('n', 's', 'e'),
            Trigram('e', 'c', 'c'),
            Trigram('t', ' ', 't'),
            Trigram('l', 't', 'r'),
            Trigram('a', 'm', 'b'),
            Trigram('q', 'u', 'a'),
            Trigram('l', '’', 'a'),
            Trigram('e', 'l', 'i'),
            Trigram('u', 'r', 'a'),
            Trigram('a', 'n', ' '),
            Trigram('i', 's', 't'),
            Trigram('e', ' ', 't'),
            Trigram('ó', ' ', 'a'),
            Trigram('o', 'n', 'e'),
            Trigram('n', 'a', 'm'),
            Trigram('i', 'n', 'g'),
            Trigram('l', 'a', 'r'),
            Trigram('o', ' ', 'p'),
            Trigram('e', 's', 'p'),
            Trigram('r', 'e', 'c'),
            Trigram('l', 'i', 'g'),
            Trigram('a', ' ', 'f'),
            Trigram(' ', 'h', 'a'),
            Trigram('i', 'v', 'a'),
            Trigram(' ', 'a', 'm'),
            Trigram('l', 'l', 'e'),
            Trigram('t', ' ', 's'),
            Trigram('r', 'o', 't'),
            Trigram('m', 'a', 't'),
            Trigram('l', 'i', 'u'),
            Trigram('t', 'i', 'u'),
            Trigram('i', 'u', 'r'),
            Trigram('n', ' ', 'a'),
            Trigram('f', 'o', 'n'),
            Trigram('o', 't', 's'),
            Trigram('i', 'n', 'c'),
            Trigram('n', 'd', 'i'),
            Trigram('e', ' ', 'p'),
            Trigram('s', 'e', 'u'),
            Trigram('o', 'l', 'u'),
            Trigram('g', 'u', 'r'),
            Trigram('i', ' ', 'c'),
            Trigram('m', 'é', 's'),
            Trigram('d', 'e', 'r'),
            Trigram('r', 'n', 'a'),
            Trigram('i', 'n', 'a'),
            Trigram('f', 'o', 'r'),
            Trigram('i', 'g', 'i'),
            Trigram('c', 'i', 'e'),
            Trigram('b', 'l', 'i'),
            Trigram('i', 'c', ' '),
            Trigram('m', 'b', ' '),
            Trigram('i', 'n', ' '),
            Trigram('a', 'r', 't'),
            Trigram('o', 'l', ' '),
            Trigram('r', 'o', 'm'),
            Trigram('n', 'i', 'n'),
            Trigram('o', 'm', 'p'),
        ],
    ),
    (
        Lang::Lit,
        &[
            Trigram('a', 's', ' '),
            Trigram('i', 'r', ' '),
            Trigram(' ', 'i', 'r'),
            Trigram('e', 'i', 's'),
            Trigram('t', 'e', 'i'),
            Trigram(' ', 't', 'e'),
            Trigram('s', ' ', 't'),
            Trigram('o', 's', ' '),
            Trigram('u', 'r', 'i'),
            Trigram('t', 'i', ' '),
            Trigram('u', 's', ' '),
            Trigram('i', 's', ' '),
            Trigram('i', 'e', 'k'),
            Trigram(' ', 'p', 'a'),
            Trigram('a', 'i', ' '),
            Trigram(' ', 'v', 'i'),
            Trigram('v', 'i', 'e'),
            Trigram('t', 'u', 'r'),
            Trigram(' ', 'k', 'i'),
            Trigram('r', 'i', ' '),
            Trigram('ž', 'm', 'o'),
            Trigram(' ', 't', 'u'),
            Trigram(' ', 'ž', 'm'),
            Trigram('i', 'e', 'n'),
            Trigram('ė', 's', ' '),
            Trigram('i', 'ų', ' '),
            Trigram('a', 'l', 'i'),
            Trigram('a', 'i', 's'),
            Trigram('m', 'o', 'g'),
            Trigram('v', 'i', 's'),
            Trigram(' ', 'k', 'a'),
            Trigram('l', 'a', 'i'),
            Trigram(' ', 'l', 'a'),
            Trigram('i', 'n', 'i'),
            Trigram('i', ' ', 't'),
            Trigram('s', ' ', 'i'),
            Trigram('s', ' ', 'ž'),
            Trigram('s', 'ę', ' '),
            Trigram(' ', 'į', ' '),
            Trigram('i', 's', 'ę'),
            Trigram('e', 'n', 'a'),
            Trigram(' ', 'n', 'e'),
            Trigram(' ', 'p', 'r'),
            Trigram(' ', 'b', 'ū'),
            Trigram(' ', 'j', 'o'),
            Trigram('p', 'r', 'i'),
            Trigram('k', 'i', 'e'),
            Trigram(' ', 't', 'a'),
            Trigram('k', 'v', 'i'),
            Trigram('n', 'a', 's'),
            Trigram(' ', 's', 'u'),
            Trigram('e', 'k', 'v'),
            Trigram('m', 'a', 's'),
            Trigram('g', 'u', 's'),
            Trigram('b', 'ū', 't'),
            Trigram('t', 'i', 'n'),
            Trigram('i', 's', 'v'),
            Trigram('s', ' ', 's'),
            Trigram('o', 'g', 'u'),
            Trigram('i', 's', 'i'),
            Trigram('m', 'ą', ' '),
            Trigram('m', 'o', ' '),
            Trigram('a', 'n', 't'),
            Trigram(' ', 'a', 'r'),
            Trigram('s', ' ', 'k'),
            Trigram('a', 'm', 'a'),
            Trigram('k', 'a', 'i'),
            Trigram('ū', 't', 'i'),
            Trigram('s', ' ', 'a'),
            Trigram('s', ' ', 'v'),
            Trigram('a', 'c', 'i'),
            Trigram(' ', 't', 'i'),
            Trigram('s', ' ', 'n'),
            Trigram(' ', 's', 'a'),
            Trigram('s', ' ', 'p'),
            Trigram('o', 'k', 'i'),
            Trigram('c', 'i', 'j'),
            Trigram('i', 'n', 'ė'),
            Trigram('a', 'r', ' '),
            Trigram('v', 'a', 'l'),
            Trigram('m', 's', ' '),
            Trigram('t', 'a', 'i'),
            Trigram('j', 'o', ' '),
            Trigram('i', ' ', 'b'),
            Trigram(' ', 'n', 'a'),
            Trigram('g', 'a', 'l'),
            Trigram('s', 'a', 'v'),
            Trigram('k', 'u', 'r'),
            Trigram('a', 'u', 's'),
            Trigram('m', 'e', 'n'),
            Trigram('r', 'i', 'n'),
            Trigram(' ', 'a', 'p'),
            Trigram('i', 'm', 'ą'),
            Trigram('m', 'a', ' '),
            Trigram('s', 't', 'a'),
            Trigram('ę', ' ', 'į'),
            Trigram('i', 'n', 'a'),
            Trigram('i', ' ', 'p'),
            Trigram('i', 'm', 'o'),
            Trigram('n', 'i', 'm'),
            Trigram('i', ' ', 'k'),
            Trigram(' ', 'n', 'u'),
            Trigram('i', 'm', 'a'),
            Trigram('o', 't', 'i'),
            Trigram('m', 'i', 's'),
            Trigram(' ', 'k', 'u'),
            Trigram('j', 'o', 's'),
            Trigram('l', 'y', 'g'),
            Trigram('d', 'a', 'r'),
            Trigram('i', 'š', 'k'),
            Trigram('j', 'e', ' '),
            Trigram(' ', 'a', 't'),
            Trigram('t', 'a', 's'),
            Trigram('k', 'a', 'd'),
            Trigram('r', ' ', 't'),
            Trigram('t', 'ų', ' '),
            Trigram('a', 'd', ' '),
            Trigram('t', 'i', 'k'),
            Trigram('i', ' ', 'i'),
            Trigram('n', 'ė', 's'),
            Trigram('a', 'r', 'b'),
            Trigram('i', ' ', 'v'),
            Trigram('i', 'j', 'o'),
            Trigram('e', 'i', 'k'),
            Trigram('a', 'u', 't'),
            Trigram('s', ' ', 'b'),
            Trigram(' ', 'į', 's'),
            Trigram(' ', 'r', 'e'),
            Trigram('i', 'a', 'm'),
            Trigram('s', 'i', 'n'),
            Trigram('s', 'u', 'o'),
            Trigram(' ', 'b', 'e'),
            Trigram('i', 's', 'u'),
            Trigram(' ', 'v', 'a'),
            Trigram('l', 'i', ' '),
            Trigram('s', 't', 'y'),
            Trigram('a', 's', 'i'),
            Trigram('t', 'i', 'e'),
            Trigram('a', 'r', 'a'),
            Trigram('l', 'i', 'n'),
            Trigram('i', 's', 'ė'),
            Trigram('i', ' ', 's'),
            Trigram('ą', ' ', 'i'),
            Trigram('j', 'ų', ' '),
            Trigram(' ', 'l', 'y'),
            Trigram(' ', 'g', 'a'),
            Trigram('v', 'o', ' '),
            Trigram('s', 'i', ' '),
            Trigram('r', ' ', 'p'),
            Trigram('t', 'u', 'o'),
            Trigram('a', 'i', 'k'),
            Trigram('r', 'i', 'e'),
            Trigram(' ', 'm', 'o'),
            Trigram('d', 'i', 'n'),
            Trigram('p', 'a', 's'),
            Trigram('m', 'o', 'k'),
            Trigram('i', 'p', ' '),
            Trigram('i', ' ', 'n'),
            Trigram('r', 'e', 'i'),
            Trigram('y', 'b', 'ė'),
            Trigram('m', 'o', 's'),
            Trigram('a', 'i', 'p'),
            Trigram('r', ' ', 'l'),
            Trigram('n', 't', 'u'),
            Trigram('į', 's', 't'),
            Trigram('į', ' ', 't'),
            Trigram('g', 'y', 'v'),
            Trigram(' ', 'i', 'š'),
            Trigram('n', 't', 'i'),
            Trigram('t', 'y', 'b'),
            Trigram('ų', ' ', 'i'),
            Trigram('p', 'a', 'g'),
            Trigram('k', 'i', 'a'),
            Trigram('k', 'i', 't'),
            Trigram('e', 's', ' '),
            Trigram('u', 'o', 't'),
            Trigram(' ', 's', 'k'),
            Trigram('j', 'i', 'm'),
            Trigram('t', 'i', 's'),
            Trigram(' ', 'o', 'r'),
            Trigram('a', 'u', 'd'),
            Trigram('y', 'v', 'e'),
            Trigram('v', 'e', 'n'),
            Trigram('m', 'ų', ' '),
            Trigram('a', 'l', 's'),
            Trigram('ų', ' ', 't'),
            Trigram('n', 'a', 'c'),
            Trigram('a', 'v', 'o'),
            Trigram('d', 'a', 'm'),
            Trigram('ą', ' ', 'k'),
            Trigram('i', ' ', 'a'),
            Trigram('s', ' ', 'j'),
            Trigram('o', 'j', 'e'),
            Trigram('a', 'g', 'r'),
            Trigram('k', 'l', 'a'),
            Trigram('g', 'a', 'u'),
            Trigram('n', 'e', 'g'),
            Trigram('n', 'i', 'ų'),
            Trigram('o', ' ', 'k'),
            Trigram('e', 'g', 'a'),
            Trigram('i', 'k', 'i'),
            Trigram('a', 'u', 'g'),
            Trigram('e', 'k', ' '),
            Trigram('t', 'a', 't'),
            Trigram('i', 'e', 'š'),
            Trigram('t', 'a', 'r'),
            Trigram('i', 'a', ' '),
            Trigram(' ', 'š', 'i'),
            Trigram('i', 'o', 's'),
            Trigram('š', 'k', 'a'),
            Trigram('s', 'v', 'a'),
            Trigram(' ', 't', 'o'),
            Trigram('t', 'a', 'u'),
            Trigram('i', 'n', 't'),
            Trigram('s', 'a', 'u'),
            Trigram('u', 't', 'i'),
            Trigram(' ', 'a', 's'),
            Trigram('i', 'o', ' '),
            Trigram('o', 'g', 'a'),
            Trigram('s', 'a', 'n'),
            Trigram('m', 'o', 'n'),
            Trigram('o', 'm', 'i'),
            Trigram('k', 'i', 'n'),
            Trigram('i', 't', 'o'),
            Trigram('s', ' ', 'g'),
            Trigram('o', 'm', 'e'),
            Trigram('r', ' ', 'j'),
            Trigram(' ', 'v', 'e'),
            Trigram('a', 't', 'y'),
            Trigram('k', 'i', 'm'),
            Trigram('n', 't', ' '),
            Trigram('i', 'a', 'i'),
            Trigram('l', 's', 't'),
            Trigram(' ', 'd', 'a'),
            Trigram('j', 'ą', ' '),
            Trigram('m', 'i', 'n'),
            Trigram('r', ' ', 'k'),
            Trigram('o', ' ', 't'),
            Trigram('n', 'u', 'o'),
            Trigram('t', 'u', ' '),
            Trigram('v', 'e', 'r'),
            Trigram('k', 'a', 'l'),
            Trigram('a', 'm', ' '),
            Trigram('u', 's', 'i'),
            Trigram('o', ' ', 'n'),
            Trigram('o', ' ', 'a'),
            Trigram('y', 'm', 'o'),
            Trigram('t', 'y', 'm'),
            Trigram('v', 'ę', ' '),
            Trigram('a', 't', 'i'),
            Trigram(' ', 'j', 'i'),
            Trigram('o', ' ', 'p'),
            Trigram('t', 'i', 'm'),
            Trigram('ų', ' ', 'n'),
            Trigram('p', 'a', 'ž'),
            Trigram('t', 'e', 'r'),
            Trigram('s', ' ', 'š'),
            Trigram(' ', 'v', 'y'),
            Trigram('a', 'l', 't'),
            Trigram('k', 's', 'l'),
            Trigram('i', 'n', 'g'),
            Trigram('ų', ' ', 's'),
            Trigram('o', 'm', 'a'),
            Trigram('š', 'a', 'l'),
            Trigram('r', 'a', 'n'),
            Trigram('e', ' ', 't'),
            Trigram(' ', 'n', 'i'),
            Trigram(' ', 'š', 'a'),
            Trigram('a', 'v', 'a'),
            Trigram('a', 'v', 'i'),
            Trigram('n', 'i', 'e'),
            Trigram('u', 'o', 'm'),
            Trigram('i', 'r', 't'),
            Trigram('e', 'l', 'g'),
            Trigram('j', 'a', 'm'),
            Trigram('i', 'p', 'a'),
            Trigram('k', 'i', 'ų'),
            Trigram('t', 'o', 'k'),
            Trigram('e', 'k', 'a'),
            Trigram('t', 'o', 's'),
            Trigram('o', 'j', 'a'),
            Trigram('k', 'i', 'o'),
            Trigram('e', 'n', 'y'),
            Trigram('n', 'a', 'm'),
            Trigram('s', ' ', 'd'),
            Trigram('n', 'd', 'i'),
            Trigram('a', 'm', 'o'),
            Trigram('y', 't', 'i'),
            Trigram('g', 'r', 'i'),
            Trigram('s', 'v', 'ę'),
            Trigram(' ', 'g', 'y'),
            Trigram('l', 'i', 'e'),
            Trigram('ė', 'm', 'i'),
            Trigram('a', 't', 's'),
            Trigram('y', 'g', 'i'),
            Trigram('s', 'o', 'c'),
            Trigram('s', 'i', 'e'),
            Trigram('o', 'c', 'i'),
            Trigram('p', 'a', 't'),
            Trigram('c', 'i', 'a'),
        ],
    ),
    (
        Lang::Slv,
        &[
            Trigram(' ', 'p', 'r'),
            Trigram('i', 'n', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram('r', 'a', 'v'),
            Trigram('p', 'r', 'a'),
            Trigram('d', 'o', ' '),
            Trigram('a', 'n', 'j'),
            Trigram('t', 'i', ' '),
            Trigram('a', 'v', 'i'),
            Trigram('j', 'e', ' '),
            Trigram('n', 'j', 'e'),
            Trigram('n', 'o', ' '),
            Trigram('v', 'i', 'c'),
            Trigram(' ', 'd', 'o'),
            Trigram('i', 'h', ' '),
            Trigram(' ', 'p', 'o'),
            Trigram('l', 'i', ' '),
            Trigram('o', ' ', 'd'),
            Trigram(' ', 'z', 'a'),
            Trigram(' ', 'v', 's'),
            Trigram('o', 's', 't'),
            Trigram('a', ' ', 'p'),
            Trigram('e', 'g', 'a'),
            Trigram('o', ' ', 'i'),
            Trigram('n', 'e', ' '),
            Trigram(' ', 'd', 'r'),
            Trigram(' ', 'n', 'a'),
            Trigram(' ', 'v', ' '),
            Trigram('g', 'a', ' '),
            Trigram(' ', 's', 'v'),
            Trigram('j', 'a', ' '),
            Trigram('v', 'a', 'n'),
            Trigram('s', 'v', 'o'),
            Trigram('a', 'k', 'o'),
            Trigram('p', 'r', 'i'),
            Trigram('c', 'o', ' '),
            Trigram('i', 'c', 'o'),
            Trigram('i', ' ', 's'),
            Trigram('e', ' ', 's'),
            Trigram('o', ' ', 'p'),
            Trigram(' ', 'k', 'a'),
            Trigram('a', 'l', 'i'),
            Trigram('s', 't', 'v'),
            Trigram('s', 't', 'i'),
            Trigram('v', 's', 'a'),
            Trigram(' ', 'n', 'e'),
            Trigram(' ', 'i', 'm'),
            Trigram('s', 'a', 'k'),
            Trigram('i', 'm', 'a'),
            Trigram('j', 'o', ' '),
            Trigram('d', 'r', 'u'),
            Trigram('n', 'o', 's'),
            Trigram('k', 'd', 'o'),
            Trigram('i', ' ', 'd'),
            Trigram('a', 'k', 'd'),
            Trigram('i', ' ', 'p'),
            Trigram('n', 'j', 'a'),
            Trigram('o', ' ', 's'),
            Trigram('n', 'i', 'h'),
            Trigram(' ', 'a', 'l'),
            Trigram('o', ' ', 'v'),
            Trigram('m', 'a', ' '),
            Trigram('i', ' ', 'i'),
            Trigram(' ', 'd', 'e'),
            Trigram('e', ' ', 'n'),
            Trigram('p', 'r', 'e'),
            Trigram('v', 'o', ' '),
            Trigram('i', ' ', 'v'),
            Trigram('n', 'i', ' '),
            Trigram('r', 'e', 'd'),
            Trigram('o', 'b', 'o'),
            Trigram('v', 'o', 'b'),
            Trigram('a', 'v', 'n'),
            Trigram('n', 'e', 'g'),
            Trigram(' ', 'b', 'i'),
            Trigram('o', 'v', 'a'),
            Trigram(' ', 'i', 'z'),
            Trigram('o', 'v', 'e'),
            Trigram('i', 't', 'i'),
            Trigram('l', 'o', 'v'),
            Trigram('k', 'i', ' '),
            Trigram('j', 'a', 'n'),
            Trigram('a', ' ', 'v'),
            Trigram('n', 'a', ' '),
            Trigram(' ', 's', 'o'),
            Trigram('e', 'm', ' '),
            Trigram(' ', 'n', 'j'),
            Trigram('a', ' ', 'i'),
            Trigram('s', 'e', ' '),
            Trigram(' ', 't', 'e'),
            Trigram('t', 'v', 'a'),
            Trigram('o', 'l', 'i'),
            Trigram('b', 'o', 'd'),
            Trigram('r', 'u', 'ž'),
            Trigram('e', ' ', 'i'),
            Trigram(' ', 'r', 'a'),
            Trigram(' ', 's', 'k'),
            Trigram('a', 't', 'i'),
            Trigram('e', ' ', 'p'),
            Trigram('a', 'r', 'o'),
            Trigram('i', ' ', 'k'),
            Trigram(' ', 'o', 'b'),
            Trigram('a', ' ', 'd'),
            Trigram(' ', 'č', 'l'),
            Trigram('e', 'v', 'a'),
            Trigram('r', 'ž', 'a'),
            Trigram('d', 'r', 'ž'),
            Trigram(' ', 's', 'p'),
            Trigram('k', 'o', ' '),
            Trigram('i', ' ', 'n'),
            Trigram(' ', 's', 'e'),
            Trigram(' ', 'k', 'i'),
            Trigram('e', 'n', 'a'),
            Trigram('s', 't', 'o'),
            Trigram('e', ' ', 'v'),
            Trigram('ž', 'e', 'n'),
            Trigram('n', 'a', 'k'),
            Trigram('k', 'a', 'k'),
            Trigram('i', ' ', 'z'),
            Trigram('v', 'a', 'r'),
            Trigram('t', 'e', 'r'),
            Trigram('ž', 'a', 'v'),
            Trigram(' ', 'm', 'o'),
            Trigram('d', 'i', ' '),
            Trigram('g', 'o', 'v'),
            Trigram('i', 'm', 'i'),
            Trigram('v', 'a', ' '),
            Trigram('k', 'o', 'l'),
            Trigram('n', ' ', 's'),
            Trigram(' ', 'z', ' '),
            Trigram('m', 'i', ' '),
            Trigram('o', 'v', 'o'),
            Trigram('r', 'o', 'd'),
            Trigram('v', 'o', 'j'),
            Trigram(' ', 'e', 'n'),
            Trigram('n', 'a', 'r'),
            Trigram('v', 'e', ' '),
            Trigram(' ', 'j', 'e'),
            Trigram('p', 'o', 's'),
            Trigram('a', ' ', 's'),
            Trigram('e', 'g', 'o'),
            Trigram('v', 'l', 'j'),
            Trigram('j', 'e', 'g'),
            Trigram(' ', 's', 't'),
            Trigram('h', ' ', 'p'),
            Trigram('e', 'r', ' '),
            Trigram('k', 'a', 't'),
            Trigram('č', 'l', 'o'),
            Trigram('a', 't', 'e'),
            Trigram('a', ' ', 'z'),
            Trigram('e', 'n', 'j'),
            Trigram('n', ' ', 'p'),
            Trigram('d', 'e', 'l'),
            Trigram('i', ' ', 'o'),
            Trigram('l', 'j', 'a'),
            Trigram('p', 'o', 'l'),
            Trigram('č', 'i', 'n'),
            Trigram('a', ' ', 'n'),
            Trigram('e', 'd', ' '),
            Trigram('s', 'm', 'e'),
            Trigram('j', 'e', 'n'),
            Trigram('e', 'n', 'i'),
            Trigram(' ', 't', 'a'),
            Trigram('o', 'd', 'n'),
            Trigram(' ', 'v', 'e'),
            Trigram(' ', 'n', 'i'),
            Trigram('e', ' ', 'b'),
            Trigram('e', 'n', ' '),
            Trigram(' ', 'm', 'e'),
            Trigram('j', 'e', 'm'),
            Trigram('k', 'o', 'n'),
            Trigram('n', 'a', 'n'),
            Trigram('e', 'l', 'j'),
            Trigram('s', 'a', 'm'),
            Trigram('d', 'a', ' '),
            Trigram('l', 'j', 'e'),
            Trigram('z', 'a', 'k'),
            Trigram('o', 'v', 'i'),
            Trigram('š', 'č', 'i'),
            Trigram('r', 'a', 'z'),
            Trigram('a', 'n', 's'),
            Trigram('j', 'u', ' '),
            Trigram('b', 'i', 't'),
            Trigram('i', 'c', ' '),
            Trigram(' ', 's', 'm'),
            Trigram('j', 'i', ' '),
            Trigram('n', 's', 'k'),
            Trigram('v', ' ', 's'),
            Trigram(' ', 's', ' '),
            Trigram('n', ' ', 'v'),
            Trigram('t', 'v', 'o'),
            Trigram('e', 'n', 'e'),
            Trigram('a', ' ', 'k'),
            Trigram('m', 'e', ' '),
            Trigram('v', 'a', 't'),
            Trigram('o', 'r', 'a'),
            Trigram('k', 'r', 'š'),
            Trigram('n', 'i', 'm'),
            Trigram('s', 't', 'a'),
            Trigram('ž', 'i', 'v'),
            Trigram('e', 'b', 'n'),
            Trigram('e', 'v', ' '),
            Trigram('r', 'i', ' '),
            Trigram('e', 'k', 'o'),
            Trigram('o', ' ', 'k'),
            Trigram('n', ' ', 'n'),
            Trigram('s', 'o', ' '),
            Trigram('z', 'a', ' '),
            Trigram('i', 'č', 'n'),
            Trigram('s', 'k', 'i'),
            Trigram('e', ' ', 'd'),
            Trigram(' ', 'v', 'a'),
            Trigram('o', ' ', 'z'),
            Trigram('a', 'c', 'i'),
            Trigram('c', 'i', 'j'),
            Trigram('e', 'j', 'a'),
            Trigram('e', 'l', 'o'),
            Trigram('d', 'e', 'j'),
            Trigram('s', 'i', ' '),
            Trigram('n', 'j', 'u'),
            Trigram('v', 'o', 'l'),
            Trigram('k', 'i', 'h'),
            Trigram('i', ' ', 'm'),
            Trigram('n', 's', 't'),
            Trigram('k', 'u', 'p'),
            Trigram('k', 'o', 'v'),
            Trigram('u', 'ž', 'i'),
            Trigram('l', 'a', ' '),
            Trigram('m', 'o', 'r'),
            Trigram('v', 'i', 'h'),
            Trigram(' ', 'd', 'a'),
            Trigram('h', ' ', 'i'),
            Trigram('l', 'j', 'u'),
            Trigram('o', 't', 'r'),
            Trigram('m', 'e', 'd'),
            Trigram('o', ' ', 'a'),
            Trigram('s', 'k', 'u'),
            Trigram('r', 'u', 'g'),
            Trigram('o', 'd', 'o'),
            Trigram('i', 'j', 'o'),
            Trigram('d', 's', 't'),
            Trigram('s', 'p', 'o'),
            Trigram('t', 'a', 'k'),
            Trigram('z', 'n', 'a'),
            Trigram('e', 'd', 'n'),
            Trigram('v', 'n', 'e'),
            Trigram('a', 'r', 'a'),
            Trigram('r', 'š', 'n'),
            Trigram('i', 't', 'v'),
            Trigram('o', 'd', 'i'),
            Trigram('u', ' ', 's'),
            Trigram('č', 'e', 'n'),
            Trigram('b', 'o', 'š'),
            Trigram('n', 'i', 'k'),
            Trigram('a', 'v', 'l'),
            Trigram('a', 'k', 'r'),
            Trigram('e', ' ', 'o'),
            Trigram('v', 'e', 'k'),
            Trigram('d', 'n', 'o'),
            Trigram('o', 'l', 'n'),
            Trigram('o', ' ', 'o'),
            Trigram('o', 'š', 'č'),
            Trigram('e', ' ', 'm'),
            Trigram('t', 'a', ' '),
            Trigram('v', 'i', 'č'),
            Trigram('b', 'i', ' '),
            Trigram('p', 'n', 'o'),
            Trigram('č', 'n', 'o'),
            Trigram('m', 'e', 'l'),
            Trigram('e', 'm', 'e'),
            Trigram('o', 'l', 'j'),
            Trigram('o', 'd', 'e'),
            Trigram('r', 's', 't'),
            Trigram('r', 'e', 'm'),
            Trigram('o', 'v', ' '),
            Trigram('a', 'r', 's'),
            Trigram(' ', 'b', 'o'),
            Trigram('n', ' ', 'd'),
            Trigram('e', 'r', 'e'),
            Trigram('d', 'o', 'v'),
            Trigram('a', 'j', 'o'),
            Trigram('k', 'l', 'a'),
            Trigram('i', 'c', 'e'),
            Trigram('v', 'e', 'z'),
            Trigram('v', 'n', 'i'),
            Trigram(' ', 'k', 'o'),
            Trigram('o', 's', 'e'),
            Trigram('t', 'e', 'v'),
            Trigram('b', 'n', 'o'),
            Trigram('u', 'ž', 'b'),
            Trigram('a', 'v', 'a'),
            Trigram('v', 'e', 'r'),
            Trigram('e', ' ', 'z'),
            Trigram('l', 'j', 'n'),
            Trigram('m', 'u', ' '),
            Trigram('a', ' ', 'b'),
            Trigram('v', 'i', ' '),
            Trigram('d', 'o', 'l'),
            Trigram('k', 'e', 'r'),
            Trigram('r', ' ', 's'),
        ],
    ),
    (
        Lang::Epo,
        &[
            Trigram('a', 'j', ' '),
            Trigram(' ', 'l', 'a'),
            Trigram('l', 'a', ' '),
            Trigram('k', 'a', 'j'),
            Trigram(' ', 'k', 'a'),
            Trigram('o', 'j', ' '),
            Trigram(' ', 'd', 'e'),
            Trigram('o', 'n', ' '),
            Trigram('d', 'e', ' '),
            Trigram('r', 'a', 'j'),
            Trigram(' ', 'r', 'a'),
            Trigram('i', 'u', ' '),
            Trigram('a', 'j', 't'),
            Trigram('a', 's', ' '),
            Trigram('o', ' ', 'k'),
            Trigram(' ', 'ĉ', 'i'),
            Trigram('e', ' ', 'l'),
            Trigram('j', ' ', 'k'),
            Trigram(' ', 'l', 'i'),
            Trigram(' ', 'p', 'r'),
            Trigram('e', 'c', 'o'),
            Trigram('a', 'ŭ', ' '),
            Trigram('ĉ', 'i', 'u'),
            Trigram('j', 'n', ' '),
            Trigram('i', 'a', ' '),
            Trigram('j', 't', 'o'),
            Trigram('e', 's', 't'),
            Trigram(' ', 'e', 's'),
            Trigram(' ', 'a', 'l'),
            Trigram('a', 'n', ' '),
            Trigram(' ', 'k', 'i'),
            Trigram('p', 'r', 'o'),
            Trigram('i', 'o', ' '),
            Trigram(' ', 'k', 'o'),
            Trigram('e', 'n', ' '),
            Trigram('n', ' ', 'k'),
            Trigram('k', 'o', 'n'),
            Trigram(' ', 't', 'i'),
            Trigram('c', 'o', ' '),
            Trigram('j', ' ', 'p'),
            Trigram('o', ' ', 'd'),
            Trigram(' ', 'p', 'o'),
            Trigram('i', 'b', 'e'),
            Trigram(' ', 'a', 'ŭ'),
            Trigram('r', 'o', ' '),
            Trigram('t', 'a', 's'),
            Trigram('l', 'i', 'b'),
            Trigram('b', 'e', 'r'),
            Trigram('a', 'c', 'i'),
            Trigram('t', 'o', 'j'),
            Trigram(' ', 'e', 'n'),
            Trigram('a', ' ', 'p'),
            Trigram(' ', 'n', 'e'),
            Trigram('c', 'i', 'o'),
            Trigram('e', 'r', 'e'),
            Trigram('t', 'a', ' '),
            Trigram(' ', 'i', 'n'),
            Trigram('t', 'o', ' '),
            Trigram('d', 'o', ' '),
            Trigram('o', ' ', 'e'),
            Trigram('j', ' ', 'l'),
            Trigram('n', ' ', 'a'),
            Trigram('j', ' ', 'd'),
            Trigram(' ', 's', 'e'),
            Trigram('a', ' ', 'k'),
            Trigram('j', ' ', 'r'),
            Trigram('a', 'l', 'a'),
            Trigram('j', ' ', 'e'),
            Trigram('t', 'a', 'j'),
            Trigram(' ', 'r', 'e'),
            Trigram('r', 'e', 'c'),
            Trigram('i', 'u', 'j'),
            Trigram('k', 'i', 'u'),
            Trigram(' ', 'p', 'e'),
            Trigram('o', ' ', 'a'),
            Trigram('i', 't', 'a'),
            Trigram('a', 'j', 'n'),
            Trigram('a', 'd', 'o'),
            Trigram('n', ' ', 'd'),
            Trigram('s', 't', 'a'),
            Trigram('n', 'a', 'c'),
            Trigram('a', ' ', 'a'),
            Trigram('n', 't', 'a'),
            Trigram('l', 'i', 'a'),
            Trigram('e', 'k', 't'),
            Trigram('e', 'n', 'i'),
            Trigram('i', 'a', 'j'),
            Trigram('t', 'e', 'r'),
            Trigram('u', 'j', ' '),
            Trigram('p', 'e', 'r'),
            Trigram('t', 'o', 'n'),
            Trigram('i', 'n', 't'),
            Trigram(' ', 's', 'i'),
            Trigram('c', 'i', 'a'),
            Trigram(' ', 'h', 'a'),
            Trigram('s', 't', 'u'),
            Trigram('a', ' ', 'l'),
            Trigram('j', 'e', ' '),
            Trigram(' ', 'j', 'e'),
            Trigram('a', 'l', ' '),
            Trigram('o', ' ', 'ĉ'),
            Trigram('n', ' ', 'p'),
            Trigram('j', 't', 'a'),
            Trigram('t', 'u', ' '),
            Trigram(' ', 'r', 'i'),
            Trigram('v', 'a', 's'),
            Trigram('s', 'e', 'n'),
            Trigram('h', 'a', 'v'),
            Trigram('h', 'o', 'm'),
            Trigram(' ', 'd', 'i'),
            Trigram(' ', 'h', 'o'),
            Trigram('n', 't', 'e'),
            Trigram('a', ' ', 'e'),
            Trigram('a', 'l', 'i'),
            Trigram('e', 'n', 't'),
            Trigram(' ', 's', 'o'),
            Trigram('n', 'e', 'c'),
            Trigram('t', 'r', 'a'),
            Trigram('a', ' ', 's'),
            Trigram('a', 'v', 'a'),
            Trigram('p', 'o', 'r'),
            Trigram('a', ' ', 'r'),
            Trigram(' ', 'n', 'a'),
            Trigram('i', 'g', 'i'),
            Trigram('t', 'i', 'u'),
            Trigram('s', 'i', 'a'),
            Trigram('o', ' ', 'p'),
            Trigram('n', ' ', 'l'),
            Trigram('e', 'g', 'a'),
            Trigram('o', 'r', ' '),
            Trigram(' ', 'a', 'j'),
            Trigram('s', 'o', 'c'),
            Trigram('j', ' ', 'ĉ'),
            Trigram('s', ' ', 'l'),
            Trigram('o', 'c', 'i'),
            Trigram('n', 'o', ' '),
            Trigram(' ', 'p', 'l'),
            Trigram('j', ' ', 'n'),
            Trigram('k', 't', 'o'),
            Trigram('e', 'v', 'i'),
            Trigram('s', ' ', 'r'),
            Trigram('j', ' ', 's'),
            Trigram('o', 'j', 'n'),
            Trigram('l', 'a', 'j'),
            Trigram('u', ' ', 'a'),
            Trigram('r', 'e', ' '),
            Trigram(' ', 'e', 'g'),
            Trigram('j', ' ', 'a'),
            Trigram('g', 'a', 'l'),
            Trigram('e', 'r', 's'),
            Trigram('k', 'e', ' '),
            Trigram('p', 'r', 'e'),
            Trigram('i', 'g', 'o'),
            Trigram('e', 'r', ' '),
            Trigram('l', 'a', 'n'),
            Trigram('n', ' ', 'j'),
            Trigram('p', 'r', 'i'),
            Trigram(' ', 'k', 'u'),
            Trigram('e', 'r', 'a'),
            Trigram('i', 'a', 'n'),
            Trigram('r', 'i', 'm'),
            Trigram(' ', 'f', 'a'),
            Trigram('e', ' ', 's'),
            Trigram(' ', 'j', 'u'),
            Trigram('e', ' ', 'a'),
            Trigram('i', 'k', 'a'),
            Trigram('a', 't', 'a'),
            Trigram('n', 't', 'r'),
            Trigram('e', 'l', ' '),
            Trigram('i', 's', ' '),
            Trigram('u', ' ', 'h'),
            Trigram('l', 'i', ' '),
            Trigram('i', 'o', 'j'),
            Trigram('d', 'o', 'n'),
            Trigram('o', 'n', 't'),
            Trigram('t', 'a', 't'),
            Trigram('o', 'n', 's'),
            Trigram(' ', 'e', 'l'),
            Trigram(' ', 's', 'u'),
            Trigram('g', 'o', ' '),
            Trigram('u', 'n', ' '),
            Trigram(' ', 'k', 'e'),
            Trigram('e', 'b', 'l'),
            Trigram('b', 'l', 'a'),
            Trigram('n', ' ', 's'),
            Trigram('o', 'm', 'a'),
            Trigram('ĉ', 'i', ' '),
            Trigram('r', 'a', 'ŭ'),
            Trigram('k', 'l', 'a'),
            Trigram('u', ' ', 'r'),
            Trigram('n', 'e', ' '),
            Trigram('i', 'l', 'i'),
            Trigram('i', 'ĝ', 'o'),
            Trigram('o', ' ', 't'),
            Trigram('s', ' ', 'e'),
            Trigram('t', 'e', 'k'),
            Trigram('m', 'e', 'n'),
            Trigram('n', 'e', 'n'),
            Trigram('j', ' ', 'i'),
            Trigram('n', 'd', 'a'),
            Trigram('c', 'o', 'n'),
            Trigram('a', ' ', 'd'),
            Trigram('e', 'n', 'a'),
            Trigram('c', 'e', 'v'),
            Trigram('m', 'o', 'j'),
            Trigram('i', 'c', 'e'),
            Trigram('r', 'i', 'c'),
            Trigram('p', 'l', 'e'),
            Trigram('s', 'o', 'n'),
            Trigram('a', 'r', 't'),
            Trigram('a', ' ', 'h'),
            Trigram('o', ' ', 'r'),
            Trigram('r', 'e', 's'),
            Trigram(' ', 'u', 'n'),
            Trigram('u', ' ', 's'),
            Trigram('c', 'o', 'j'),
            Trigram('e', ' ', 'p'),
            Trigram('ĝ', 'i', ' '),
            Trigram('f', 'o', 'r'),
            Trigram('a', 't', 'o'),
            Trigram('r', 'e', 'n'),
            Trigram('a', 'r', 'a'),
            Trigram('a', 'm', 'e'),
            Trigram('t', 'a', 'n'),
            Trigram(' ', 'p', 'u'),
            Trigram('o', 't', 'e'),
            Trigram('r', 'o', 't'),
            Trigram(' ', 'm', 'a'),
            Trigram('v', 'i', ' '),
            Trigram('j', ' ', 'f'),
            Trigram('l', 'e', 'n'),
            Trigram('d', 'i', 's'),
            Trigram('i', 'v', 'e'),
            Trigram('a', 'n', 't'),
            Trigram('n', ' ', 'r'),
            Trigram(' ', 'v', 'i'),
            Trigram('a', 'm', 'i'),
            Trigram('i', 'ĝ', 'i'),
            Trigram('s', 't', 'i'),
            Trigram('ĝ', 'o', ' '),
            Trigram('r', ' ', 'l'),
            Trigram('n', ' ', 'ĉ'),
            Trigram('u', ' ', 'l'),
            Trigram(' ', 'a', 'g'),
            Trigram('e', 'r', 'v'),
            Trigram('u', ' ', 'e'),
            Trigram('u', 'n', 'u'),
            Trigram('g', 'n', 'o'),
            Trigram(' ', 'c', 'e'),
            Trigram(' ', 'm', 'e'),
            Trigram('n', 'i', 'u'),
            Trigram('i', 'e', 'l'),
            Trigram('d', 'u', 'k'),
            Trigram('e', 'r', 'n'),
            Trigram(' ', 'ŝ', 't'),
            Trigram('l', 'a', 'ŭ'),
            Trigram('o', ' ', 'n'),
            Trigram('l', 'a', 'b'),
            Trigram('o', 'l', 'o'),
            Trigram('a', 'b', 'o'),
            Trigram('t', 'i', 'o'),
            Trigram('b', 'o', 'r'),
            Trigram('ŝ', 't', 'a'),
            Trigram('i', 'm', 'i'),
            Trigram(' ', 'e', 'd'),
            Trigram('l', 'o', ' '),
            Trigram('k', 'u', 'n'),
            Trigram('e', 'd', 'u'),
            Trigram('k', 'o', 'm'),
            Trigram('d', 'e', 'v'),
            Trigram('e', 'n', 'c'),
            Trigram('n', 'd', 'o'),
            Trigram('l', 'i', 'g'),
            Trigram('e', ' ', 'e'),
            Trigram('a', ' ', 'f'),
            Trigram('t', 'i', 'g'),
            Trigram('i', ' ', 'e'),
            Trigram(' ', 'k', 'r'),
            Trigram(' ', 'p', 'a'),
            Trigram('n', 'a', ' '),
            Trigram('n', ' ', 'i'),
            Trigram('k', 'a', 'd'),
            Trigram('a', 'n', 'd'),
            Trigram('e', ' ', 'd'),
            Trigram('m', 'a', 'l'),
            Trigram('o', 'n', 'o'),
            Trigram('d', 'e', 'k'),
            Trigram('p', 'o', 'l'),
            Trigram('o', 'r', 'o'),
            Trigram('e', 'r', 'i'),
            Trigram('e', 'd', 'o'),
            Trigram('e', ' ', 'k'),
            Trigram('r', 's', 'o'),
            Trigram('t', 'i', ' '),
            Trigram('r', 'a', 'c'),
            Trigram('i', 'o', 'n'),
            Trigram('l', 'o', 'j'),
            Trigram('j', ' ', 'h'),
            Trigram('p', 'l', 'i'),
            Trigram('j', ' ', 'm'),
        ],
    ),
    (
        Lang::Lav,
        &[
            Trigram('a', 's', ' '),
            Trigram('ī', 'b', 'a'),
            Trigram(' ', 'u', 'n'),
            Trigram('u', 'n', ' '),
            Trigram('t', 'i', 'e'),
            Trigram('i', 'e', 's'),
            Trigram('b', 'a', 's'),
            Trigram('a', 'i', ' '),
            Trigram(' ', 't', 'i'),
            Trigram('e', 's', 'ī'),
            Trigram('s', 'ī', 'b'),
            Trigram('i', 'e', 'n'),
            Trigram(' ', 'v', 'i'),
            Trigram('b', 'u', ' '),
            Trigram('v', 'i', 'e'),
            Trigram('i', 'r', ' '),
            Trigram(' ', 'i', 'r'),
            Trigram('ī', 'b', 'u'),
            Trigram('i', 'e', 'm'),
            Trigram(' ', 'v', 'a'),
            Trigram(' ', 'p', 'a'),
            Trigram('e', 'm', ' '),
            Trigram(' ', 'n', 'e'),
            Trigram('s', ' ', 'u'),
            Trigram('a', 'm', ' '),
            Trigram('m', ' ', 'i'),
            Trigram('š', 'a', 'n'),
            Trigram('u', ' ', 'u'),
            Trigram('r', ' ', 't'),
            Trigram('p', 'i', 'e'),
            Trigram(' ', 'c', 'i'),
            Trigram(' ', 's', 'a'),
            Trigram('ā', 's', ' '),
            Trigram(' ', 'u', 'z'),
            Trigram('v', 'a', 'i'),
            Trigram(' ', 'k', 'a'),
            Trigram(' ', 'p', 'i'),
            Trigram('b', 'r', 'ī'),
            Trigram(' ', 'i', 'z'),
            Trigram('r', 'ī', 'v'),
            Trigram(' ', 'b', 'r'),
            Trigram('u', 'z', ' '),
            Trigram('c', 'i', 'j'),
            Trigram('d', 'z', 'ī'),
            Trigram('e', 'n', 'a'),
            Trigram(' ', 'a', 'r'),
            Trigram('a', 'r', ' '),
            Trigram('i', 's', 'k'),
            Trigram('s', ' ', 'p'),
            Trigram('e', 's', ' '),
            Trigram(' ', 'a', 't'),
            Trigram('ā', 'c', 'i'),
            Trigram(' ', 'a', 'p'),
            Trigram('o', 't', ' '),
            Trigram('n', 'a', 'm'),
            Trigram('v', 'i', 'ņ'),
            Trigram('i', 'n', 'ā'),
            Trigram('i', 'k', 'v'),
            Trigram('k', 'v', 'i'),
            Trigram(' ', 'n', 'o'),
            Trigram('s', ' ', 'v'),
            Trigram(' ', 'i', 'e'),
            Trigram('v', 'i', 's'),
            Trigram(' ', 'i', 'k'),
            Trigram('i', ' ', 'i'),
            Trigram('p', 'ā', 'r'),
            Trigram('u', ' ', 'a'),
            Trigram('j', 'u', ' '),
            Trigram('n', 'u', ' '),
            Trigram(' ', 'p', 'r'),
            Trigram('e', 'd', 'r'),
            Trigram('v', 'ī', 'b'),
            Trigram('ī', 'v', 'ī'),
            Trigram('i', 'j', 'u'),
            Trigram('d', 'r', 'ī'),
            Trigram('u', ' ', 'p'),
            Trigram('d', 'a', 'r'),
            Trigram(' ', 's', 't'),
            Trigram('l', 'v', 'ē'),
            Trigram('c', 'i', 'l'),
            Trigram('i', 'l', 'v'),
            Trigram('s', ' ', 't'),
            Trigram(' ', 'l', 'a'),
            Trigram('i', 'ņ', 'a'),
            Trigram('a', 'n', 'a'),
            Trigram('s', ' ', 'i'),
            Trigram('n', ' ', 'i'),
            Trigram('ī', 'd', 'z'),
            Trigram('s', ' ', 's'),
            Trigram('k', 'ā', ' '),
            Trigram('t', 'ī', 'b'),
            Trigram('i', ' ', 'a'),
            Trigram('i', 'j', 'a'),
            Trigram('b', 'a', 'i'),
            Trigram('ī', 'b', 'ā'),
            Trigram('i', 'e', 'd'),
            Trigram('s', ' ', 'n'),
            Trigram('a', 'r', 'b'),
            Trigram('v', 'a', 'l'),
            Trigram('l', 'ī', 'd'),
            Trigram('s', ' ', 'b'),
            Trigram('a', 'i', 'z'),
            Trigram('t', 'u', ' '),
            Trigram('i', 'e', 'c'),
            Trigram('c', 'i', 'e'),
            Trigram('ā', 'm', ' '),
            Trigram('g', 'u', ' '),
            Trigram('v', 'ē', 'k'),
            Trigram('ī', 'g', 'u'),
            Trigram('ī', 'g', 'i'),
            Trigram('k', 'a', ' '),
            Trigram('j', 'a', 's'),
            Trigram('u', 'm', 'u'),
            Trigram('m', 'u', ' '),
            Trigram('t', ' ', 'p'),
            Trigram(' ', 'j', 'ā'),
            Trigram('u', ' ', 'v'),
            Trigram('z', 'ī', 'b'),
            Trigram('s', 'k', 'a'),
            Trigram('l', 's', 't'),
            Trigram('a', 'l', 's'),
            Trigram('k', 'u', 'm'),
            Trigram('g', 'i', ' '),
            Trigram('s', ' ', 'l'),
            Trigram(' ', 't', 'ā'),
            Trigram('j', 'o', 't'),
            Trigram('s', 't', 'ā'),
            Trigram('s', 't', ' '),
            Trigram('n', ' ', 'v'),
            Trigram('v', 'ē', 'r'),
            Trigram('a', ' ', 'p'),
            Trigram('a', 'r', 'ī'),
            Trigram('a', 'u', 't'),
            Trigram('n', ' ', 'p'),
            Trigram('a', 'm', 'a'),
            Trigram('k', 'a', 's'),
            Trigram('u', ' ', 'k'),
            Trigram(' ', 'd', 'a'),
            Trigram(' ', 't', 'a'),
            Trigram('n', 'ī', 'g'),
            Trigram('i', 'z', 's'),
            Trigram('o', 'j', 'o'),
            Trigram('a', 'n', 'u'),
            Trigram('ņ', 'a', ' '),
            Trigram('u', ' ', 'n'),
            Trigram('s', 't', 'a'),
            Trigram('s', ' ', 'a'),
            Trigram('b', 'a', ' '),
            Trigram(' ', 'a', 'i'),
            Trigram(' ', 's', 'o'),
            Trigram('s', ' ', 'd'),
            Trigram('a', ' ', 'u'),
            Trigram('ā', ' ', 'a'),
            Trigram('s', 't', 'ī'),
            Trigram('c', 'ī', 'b'),
            Trigram('m', ' ', 'u'),
            Trigram('i', ' ', 'u'),
            Trigram('s', 'o', 'n'),
            Trigram('n', 'o', 't'),
            Trigram('m', 'a', 't'),
            Trigram('s', 'a', 'v'),
            Trigram('i', 'e', 'v'),
            Trigram('ā', ' ', 'v'),
            Trigram('j', 'u', 'm'),
            Trigram(' ', 'k', 'ā'),
            Trigram('u', ' ', 't'),
            Trigram('n', 'e', 'd'),
            Trigram('a', 'j', 'ā'),
            Trigram('s', ' ', 'k'),
            Trigram('u', ' ', 'i'),
            Trigram('i', ' ', 'v'),
            Trigram('l', 'ī', 't'),
            Trigram('ē', 'r', 'o'),
            Trigram(' ', 'p', 'e'),
            Trigram(' ', 'd', 'z'),
            Trigram('i', ' ', 'n'),
            Trigram('p', 'e', 'r'),
            Trigram('u', ' ', 'd'),
            Trigram('ī', 'k', 's'),
            Trigram('k', 'a', 't'),
            Trigram('n', 'ā', 't'),
            Trigram('l', 'ī', 'b'),
            Trigram('n', 'ā', 'c'),
            Trigram('r', 'd', 'z'),
            Trigram('n', 'ī', 'b'),
            Trigram('p', 'i', 'l'),
            Trigram('r', 'ī', 'k'),
            Trigram('k', 's', 't'),
            Trigram('a', ' ', 's'),
            Trigram('c', 'i', 't'),
            Trigram('p', 'a', 'm'),
            Trigram(' ', 'p', 'ā'),
            Trigram('e', 'k', 'l'),
            Trigram('t', 'a', 'u'),
            Trigram('u', ' ', 's'),
            Trigram('b', 'i', 'e'),
            Trigram('j', 'ā', ' '),
            Trigram(' ', 'r', 'e'),
            Trigram('i', ' ', 'p'),
            Trigram('k', 'u', 'r'),
            Trigram('a', ' ', 'a'),
            Trigram('t', ' ', 'v'),
            Trigram(' ', 'l', 'i'),
            Trigram('e', 'v', 'i'),
            Trigram('t', 'i', 's'),
            Trigram('e', 'v', 'ē'),
            Trigram('b', 'ā', ' '),
            Trigram('m', 'a', ' '),
            Trigram('r', 'ī', 'b'),
            Trigram('a', ' ', 'v'),
            Trigram('o', 's', ' '),
            Trigram('r', 'a', 's'),
            Trigram('a', 'b', 'i'),
            Trigram('n', 'e', 'v'),
            Trigram('i', 'k', 'u'),
            Trigram('s', 'k', 'ā'),
            Trigram(' ', 'v', 'e'),
            Trigram('l', 'i', 'k'),
            Trigram(' ', 'l', 'ī'),
            Trigram('n', 'a', 's'),
            Trigram('t', ' ', 'k'),
            Trigram('a', 'n', 't'),
            Trigram('u', 'm', 'a'),
            Trigram('r', 'o', 'š'),
            Trigram('k', 'ā', 'd'),
            Trigram('z', 's', 'a'),
            Trigram('s', 'a', 'r'),
            Trigram('c', 'i', 'ā'),
            Trigram('m', 'i', 'e'),
            Trigram('a', 'i', 's'),
            Trigram('e', 'c', 'i'),
            Trigram('o', 'c', 'i'),
            Trigram('o', 'š', 'a'),
            Trigram(' ', 'j', 'e'),
            Trigram('j', 'e', 'b'),
            Trigram('b', 'ū', 't'),
            Trigram('a', 't', 'r'),
            Trigram('n', ' ', 'b'),
            Trigram('i', 'e', 'š'),
            Trigram('r', 's', 'o'),
            Trigram('e', 'r', 's'),
            Trigram('s', 'o', 'c'),
            Trigram('e', 'n', 'ā'),
            Trigram('a', ' ', 't'),
            Trigram('t', ' ', 's'),
            Trigram('ī', 'š', 'a'),
            Trigram(' ', 'b', 'e'),
            Trigram('b', 'e', 'z'),
            Trigram('ā', 'd', 'a'),
            Trigram('e', 'b', 'k'),
            Trigram(' ', 'k', 'u'),
            Trigram('g', 'l', 'ī'),
            Trigram('i', 's', 'p'),
            Trigram('t', 'o', 't'),
            Trigram('s', 'p', 'ā'),
            Trigram('r', 'o', 'j'),
            Trigram('l', 'i', 'e'),
            Trigram('p', 'r', 'e'),
            Trigram('r', 'e', 't'),
            Trigram('a', 'u', 'l'),
            Trigram('n', 'a', ' '),
            Trigram('t', 'r', 'a'),
            Trigram('i', 'e', 't'),
            Trigram('d', 'u', ' '),
            Trigram('z', 'g', 'l'),
            Trigram('ā', 't', ' '),
            Trigram('a', 'r', 'd'),
            Trigram('k', 't', ' '),
            Trigram('i', 'e', 'r'),
            Trigram('i', 'z', 'g'),
            Trigram('i', 'k', 't'),
            Trigram('p', 'a', 'š'),
            Trigram('i', 'ā', 'l'),
            Trigram('n', 'o', 'd'),
            Trigram('t', 's', ' '),
            Trigram('e', 'j', 'a'),
            Trigram('ā', ' ', 'u'),
            Trigram('s', 'a', 'b'),
            Trigram('e', 'n', 'o'),
            Trigram('ē', 't', ' '),
            Trigram('t', 'a', ' '),
            Trigram('t', 'i', 'k'),
            Trigram('t', 'ī', 't'),
            Trigram('e', 'c', 'ī'),
            Trigram(' ', 'd', 'e'),
            Trigram('ī', 'g', 'a'),
            Trigram('t', 'a', 'r'),
            Trigram('a', 'r', 'p'),
            Trigram('r', ' ', 'j'),
            Trigram('ī', 's', 't'),
            Trigram('t', 'ā', 's'),
            Trigram('j', 'a', ' '),
            Trigram('e', 'n', 'ī'),
            Trigram('a', 't', 'v'),
            Trigram('v', 'u', ' '),
            Trigram('ā', 'r', 'ē'),
            Trigram('r', 'ē', 'j'),
            Trigram('r', 'i', 'e'),
            Trigram('o', 'š', 'i'),
            Trigram('d', 'r', 'o'),
        ],
    ),
    (
        Lang::Est,
        &[
            Trigram('s', 'e', 'l'),
            Trigram('j', 'a', ' '),
            Trigram(' ', 'j', 'a'),
            Trigram('l', 'e', ' '),
            Trigram('s', 'e', ' '),
            Trigram('u', 's', 't'),
            Trigram('s', 't', 'e'),
            Trigram('u', 's', 'e'),
            Trigram('i', 's', 'e'),
            Trigram('õ', 'i', 'g'),
            Trigram('m', 'i', 's'),
            Trigram(' ', 'v', 'a'),
            Trigram('g', 'u', 's'),
            Trigram('e', 'l', 'e'),
            Trigram('t', 'e', ' '),
            Trigram('i', 'g', 'u'),
            Trigram('u', 's', ' '),
            Trigram('s', 't', ' '),
            Trigram('d', 'u', 's'),
            Trigram(' ', 'õ', 'i'),
            Trigram(' ', 'v', 'õ'),
            Trigram(' ', 'o', 'n'),
            Trigram('o', 'n', ' '),
            Trigram('e', ' ', 'j'),
            Trigram(' ', 'i', 'n'),
            Trigram('i', 'n', 'i'),
            Trigram('n', 'i', 'm'),
            Trigram('m', 'a', ' '),
            Trigram('e', 'l', ' '),
            Trigram('a', ' ', 'v'),
            Trigram('i', 'g', 'a'),
            Trigram('i', 's', 't'),
            Trigram('i', 'm', 'e'),
            Trigram('a', 'l', ' '),
            Trigram('v', 'õ', 'i'),
            Trigram('d', 'a', ' '),
            Trigram(' ', 't', 'e'),
            Trigram('l', 'i', 'k'),
            Trigram(' ', 'i', 'g'),
            Trigram('a', 'd', 'u'),
            Trigram('m', 'e', 's'),
            Trigram('a', 'm', 'i'),
            Trigram('e', 'n', 'd'),
            Trigram('e', ' ', 'k'),
            Trigram('e', ' ', 'v'),
            Trigram('l', ' ', 'o'),
            Trigram(' ', 'k', 'a'),
            Trigram('e', 's', 't'),
            Trigram(' ', 'r', 'a'),
            Trigram(' ', 's', 'e'),
            Trigram('õ', 'i', ' '),
            Trigram('i', 'k', 'u'),
            Trigram(' ', 'k', 'o'),
            Trigram('v', 'a', 'b'),
            Trigram('a', 'b', 'a'),
            Trigram('t', 'u', 's'),
            Trigram('u', 'd', ' '),
            Trigram('a', ' ', 'k'),
            Trigram('e', 's', 'e'),
            Trigram(' ', 'k', 'u'),
            Trigram('l', ' ', 'i'),
            Trigram('g', 'a', 'l'),
            Trigram('t', 's', 'i'),
            Trigram('l', 't', ' '),
            Trigram('e', 's', ' '),
            Trigram('e', 'm', 'a'),
            Trigram('i', 'd', 'a'),
            Trigram('k', 's', ' '),
            Trigram('a', ' ', 'i'),
            Trigram('n', ' ', 'õ'),
            Trigram('l', 'i', 's'),
            Trigram('a', 't', 'u'),
            Trigram('r', 'a', 'h'),
            Trigram('t', 'a', 'm'),
            Trigram('a', 's', 't'),
            Trigram('s', 't', 'a'),
            Trigram('e', ' ', 't'),
            Trigram('s', ' ', 's'),
            Trigram(' ', 'm', 'i'),
            Trigram('t', 'a', ' '),
            Trigram('o', 'l', 'e'),
            Trigram('s', 't', 'u'),
            Trigram('b', 'a', 'd'),
            Trigram('g', 'a', ' '),
            Trigram('v', 'a', 'l'),
            Trigram('i', 'n', 'e'),
            Trigram(' ', 't', 'a'),
            Trigram('n', 'e', ' '),
            Trigram(' ', 'p', 'e'),
            Trigram('n', 'd', 'a'),
            Trigram('e', 'l', 'l'),
            Trigram('a', ' ', 't'),
            Trigram('a', 'l', 'i'),
            Trigram('a', 'v', 'a'),
            Trigram('a', 'd', 'a'),
            Trigram('a', ' ', 'p'),
            Trigram('i', 'k', ' '),
            Trigram('k', 'u', 's'),
            Trigram('e', ' ', 's'),
            Trigram('i', 'o', 'o'),
            Trigram('t', 'e', 's'),
            Trigram('a', 'h', 'e'),
            Trigram('i', 'n', 'g'),
            Trigram('l', 'u', 's'),
            Trigram(' ', 'o', 'l'),
            Trigram('a', ' ', 'a'),
            Trigram('i', 's', ' '),
            Trigram('v', 'a', 'h'),
            Trigram('a', ' ', 's'),
            Trigram('e', 'i', ' '),
            Trigram(' ', 'e', 'i'),
            Trigram('k', 'o', 'n'),
            Trigram('v', 'a', 's'),
            Trigram('t', 'u', 'd'),
            Trigram('a', 'h', 'v'),
            Trigram('t', ' ', 'k'),
            Trigram('a', 's', ' '),
            Trigram('a', ' ', 'r'),
            Trigram('s', ' ', 't'),
            Trigram('e', ' ', 'e'),
            Trigram('i', ' ', 'v'),
            Trigram('e', 'k', 's'),
            Trigram('o', 'o', 'n'),
            Trigram('t', ' ', 'v'),
            Trigram('o', 'n', 'i'),
            Trigram('k', 'õ', 'i'),
            Trigram('s', ' ', 'k'),
            Trigram('s', 'i', 'o'),
            Trigram('s', 'u', 's'),
            Trigram('e', ' ', 'a'),
            Trigram('g', 'i', ' '),
            Trigram('m', 'a', 't'),
            Trigram('m', 'i', 'n'),
            Trigram(' ', 'p', 'i'),
            Trigram('s', ' ', 'v'),
            Trigram('o', 'm', 'a'),
            Trigram('k', 'u', 'l'),
            Trigram('d', 'a', 'd'),
            Trigram(' ', 'n', 'i'),
            Trigram('e', ' ', 'p'),
            Trigram(' ', 'o', 'm'),
            Trigram('i', 'g', 'i'),
            Trigram('t', 'e', 'l'),
            Trigram('a', ' ', 'j'),
            Trigram('e', ' ', 'o'),
            Trigram('n', 'd', 'u'),
            Trigram('d', 's', 'e'),
            Trigram('l', 'l', 'e'),
            Trigram('e', 'e', 's'),
            Trigram('t', 's', 'e'),
            Trigram('u', 't', 'a'),
            Trigram('v', 'u', 's'),
            Trigram('a', 'a', 'l'),
            Trigram('a', 'j', 'a'),
            Trigram('i', ' ', 't'),
            Trigram('d', 'a', 'm'),
            Trigram('a', 't', 's'),
            Trigram('n', 'i', ' '),
            Trigram('e', 't', 'e'),
            Trigram('p', 'i', 'd'),
            Trigram('p', 'e', 'a'),
            Trigram('e', ' ', 'õ'),
            Trigram('i', 't', 's'),
            Trigram('l', 'm', 'a'),
            Trigram('l', 'e', 'v'),
            Trigram('n', 'i', 's'),
            Trigram('d', 'i', 's'),
            Trigram('ü', 'h', 'i'),
            Trigram('s', 'l', 'i'),
            Trigram('i', ' ', 's'),
            Trigram('n', 'e', 'n'),
            Trigram('i', 'e', 'l'),
            Trigram('d', 'e', 's'),
            Trigram('d', 'e', ' '),
            Trigram('t', ' ', 'i'),
            Trigram('e', 't', ' '),
            Trigram('n', 'i', 'n'),
            Trigram('e', 'v', 'a'),
            Trigram('t', 'e', 'g'),
            Trigram('u', 's', 'l'),
            Trigram('e', 'l', 't'),
            Trigram('i', 'l', 'i'),
            Trigram('i', ' ', 'm'),
            Trigram('n', 'g', ' '),
            Trigram(' ', 'e', 'e'),
            Trigram('t', 'e', 'm'),
            Trigram('s', 'e', 's'),
            Trigram('i', 'l', 'm'),
            Trigram('s', 'e', 'k'),
            Trigram('a', 'b', ' '),
            Trigram(' ', 'p', 'õ'),
            Trigram('a', 'i', 't'),
            Trigram(' ', 'n', 'e'),
            Trigram('õ', 'r', 'd'),
            Trigram('s', 'e', 'd'),
            Trigram('v', 'õ', 'r'),
            Trigram('u', 'l', ' '),
            Trigram(' ', 'ü', 'h'),
            Trigram(' ', 'k', 'i'),
            Trigram('a', 'b', 'i'),
            Trigram(' ', 'k', 'õ'),
            Trigram('e', 'g', 'a'),
            Trigram('r', 'd', 's'),
            Trigram(' ', 'v', 'ä'),
            Trigram('o', 't', 's'),
            Trigram(' ', 'e', 't'),
            Trigram(' ', 'r', 'i'),
            Trigram('p', 'õ', 'h'),
            Trigram('e', 'd', ' '),
            Trigram('t', 'ö', 'ö'),
            Trigram('s', 'i', ' '),
            Trigram('a', 'd', ' '),
            Trigram('i', ' ', 'k'),
            Trigram(' ', 't', 'ä'),
            Trigram('a', 't', 'a'),
            Trigram(' ', 'a', 'b'),
            Trigram(' ', 's', 'u'),
            Trigram('e', 'l', 'i'),
            Trigram(' ', 's', 'a'),
            Trigram('s', ' ', 'o'),
            Trigram('s', ' ', 'j'),
            Trigram('s', 'i', 'l'),
            Trigram('n', 'n', 'i'),
            Trigram('a', 'r', 'i'),
            Trigram('a', 's', 'u'),
            Trigram('n', 'n', 'a'),
            Trigram(' ', 'a', 'l'),
            Trigram('n', 'u', 'd'),
            Trigram('u', 'm', 'a'),
            Trigram('s', 'i', 'k'),
            Trigram('h', 'v', 'u'),
            Trigram('o', 'n', 'n'),
            Trigram('e', 'a', 'b'),
            Trigram('e', 'm', 'i'),
            Trigram('r', 'i', 'd'),
            Trigram('a', 'r', 'a'),
            Trigram('s', 'e', 't'),
            Trigram('e', ' ', 'm'),
            Trigram(' ', 'k', 'e'),
            Trigram('a', ' ', 'e'),
            Trigram('t', 'ä', 'i'),
            Trigram('d', ' ', 'k'),
            Trigram('s', ' ', 'p'),
            Trigram('i', ' ', 'e'),
            Trigram('i', 'm', 'i'),
            Trigram('e', 'i', 's'),
            Trigram('e', ' ', 'r'),
            Trigram('n', 'a', ' '),
            Trigram(' ', 'ü', 'l'),
            Trigram('a', ' ', 'ü'),
            Trigram('k', 'o', 'h'),
            Trigram('a', ' ', 'o'),
            Trigram('a', 'k', 's'),
            Trigram('s', ' ', 'e'),
            Trigram('e', ' ', 'n'),
            Trigram(' ', 's', 'o'),
            Trigram('õ', 'i', 'k'),
            Trigram('s', 'a', 'a'),
            Trigram('a', 'n', 'd'),
            Trigram('i', 's', 'i'),
            Trigram('n', 'd', 'e'),
            Trigram('t', 'u', 'm'),
            Trigram('h', 'e', 'l'),
            Trigram('l', 'i', 'i'),
            Trigram('k', 'i', 'n'),
            Trigram('ä', 'ä', 'r'),
            Trigram('s', 'e', 'a'),
            Trigram('i', 's', 'k'),
            Trigram('e', 'e', 'n'),
            Trigram('e', 'a', 'd'),
            Trigram('d', 'u', 'm'),
            Trigram(' ', 'k', 'ä'),
            Trigram('r', 'i', 'i'),
            Trigram('r', 'a', 't'),
            Trigram('l', 'e', 'm'),
            Trigram('u', 'm', 'i'),
            Trigram('k', 'o', 'r'),
            Trigram('s', 'a', ' '),
            Trigram('i', 'd', 'u'),
            Trigram('m', 'u', 's'),
            Trigram('r', 'i', 't'),
            Trigram('h', 'a', 'r'),
            Trigram(' ', 's', 'i'),
            Trigram('v', 'a', 'd'),
            Trigram('i', 't', 'a'),
            Trigram('a', 'l', 'e'),
            Trigram('k', 'a', 'i'),
            Trigram('t', 'e', 'o'),
            Trigram(' ', 'm', 'õ'),
            Trigram('a', 'd', 'e'),
            Trigram('ü', 'k', 's'),
            Trigram('m', 'a', 's'),
            Trigram('l', 's', 'e'),
            Trigram('a', 'l', 's'),
            Trigram('i', 'a', 'a'),
            Trigram('s', 'i', 'a'),
            Trigram('s', 'o', 't'),
            Trigram('j', 'a', 'l'),
            Trigram('i', 'i', 'g'),
            Trigram('i', 't', 'e'),
        ],
    ),
    (
        Lang::Lat,
        &[
            Trigram('i', 's', ' '),
            Trigram('e', 't', ' '),
            Trigram('u', 's', ' '),
            Trigram('u', 'm', ' '),
            Trigram(' ', 'e', 't'),
            Trigram('a', 'e', ' '),
            Trigram('t', 'a', 't'),
            Trigram('a', 't', 'i'),
            Trigram(' ', 'c', 'o'),
            Trigram('q', 'u', 'e'),
            Trigram('u', 'e', ' '),
            Trigram('i', 'o', 'n'),
            Trigram(' ', 'q', 'u'),
            Trigram('e', 'm', ' '),
            Trigram('e', 'n', 't'),
            Trigram('o', 'n', 'i'),
            Trigram('e', 's', 't'),
            Trigram(' ', 's', 'u'),
            Trigram(' ', 'i', 'u'),
            Trigram(' ', 'i', 'n'),
            Trigram(' ', 'p', 'o'),
            Trigram('t', 'i', 'o'),
            Trigram('t', 'e', 's'),
            Trigram('t', 'i', 's'),
            Trigram('a', 't', 'e'),
            Trigram('b', 'u', 's'),
            Trigram('e', ' ', 'i'),
            Trigram('i', 't', 'a'),
            Trigram('i', 'b', 'u'),
            Trigram('i', 'u', 'm'),
            Trigram('i', 'u', 's'),
            Trigram('q', 'u', 'i'),
            Trigram('n', 't', 'i'),
            Trigram('e', 'r', 'i'),
            Trigram('e', 's', ' '),
            Trigram('s', ' ', 'p'),
            Trigram('c', 'o', 'n'),
            Trigram('s', ' ', 'e'),
            Trigram('p', 'e', 'r'),
            Trigram('e', 'n', 'd'),
            Trigram('p', 'o', 't'),
            Trigram('o', 't', 'e'),
            Trigram(' ', 'h', 'a'),
            Trigram('n', 'i', 's'),
            Trigram(' ', 'p', 'r'),
            Trigram('s', ' ', 'i'),
            Trigram('a', 'b', 'e'),
            Trigram('u', 'i', 's'),
            Trigram('a', 'm', ' '),
            Trigram('u', 'a', 'e'),
            Trigram('t', 'e', 'm'),
            Trigram('h', 'a', 'b'),
            Trigram('b', 'e', 't'),
            Trigram('m', ' ', 'h'),
            Trigram('n', 'd', 'i'),
            Trigram(' ', 'h', 'o'),
            Trigram('s', 't', 'a'),
            Trigram(' ', 'd', 'e'),
            Trigram('s', 'u', 'a'),
            Trigram('i', 's', 'q'),
            Trigram('s', 'q', 'u'),
            Trigram('t', 'e', 'r'),
            Trigram('i', 'c', 'i'),
            Trigram('m', 'i', 'n'),
            Trigram('i', 'u', 'r'),
            Trigram('o', 'n', 'e'),
            Trigram(' ', 'r', 'e'),
            Trigram('h', 'o', 'm'),
            Trigram(' ', 'd', 'i'),
            Trigram(' ', 'o', 'm'),
            Trigram('o', 'm', 'n'),
            Trigram('r', 'u', 'm'),
            Trigram('s', ' ', 'a'),
            Trigram('t', ' ', 'c'),
            Trigram('r', 'a', 't'),
            Trigram('l', 'i', 'b'),
            Trigram('i', 'b', 'e'),
            Trigram('m', ' ', 'e'),
            Trigram(' ', 'p', 'e'),
            Trigram('g', 'e', 'n'),
            Trigram(' ', 'l', 'i'),
            Trigram('e', 'r', 't'),
            Trigram('i', 'n', 'e'),
            Trigram('n', 't', 'e'),
            Trigram('n', 'e', 'm'),
            Trigram('r', 'i', ' '),
            Trigram('b', 'e', 'r'),
            Trigram('t', 'i', 'a'),
            Trigram('e', ' ', 'q'),
            Trigram('d', 'i', 's'),
            Trigram(' ', 'i', 'p'),
            Trigram('i', 'p', 's'),
            Trigram(' ', 'a', 'd'),
            Trigram('d', 'i', ' '),
            Trigram('n', 'e', 's'),
            Trigram('e', ' ', 's'),
            Trigram('e', ' ', 'c'),
            Trigram('m', ' ', 'p'),
            Trigram('s', ' ', 'c'),
            Trigram(' ', 'v', 'e'),
            Trigram('e', ' ', 'p'),
            Trigram(' ', 'p', 'a'),
            Trigram('i', 'l', 'i'),
            Trigram(' ', 'g', 'e'),
            Trigram('a', ' ', 'e'),
            Trigram('i', ' ', 'p'),
            Trigram('n', 't', ' '),
            Trigram('o', 'm', 'i'),
            Trigram('a', 't', 'u'),
            Trigram('t', 'u', 'r'),
            Trigram('r', 'i', 't'),
            Trigram(' ', 's', 'i'),
            Trigram('n', 'e', ' '),
            Trigram('p', 's', 'i'),
            Trigram('i', 'n', ' '),
            Trigram('i', 'a', ' '),
            Trigram('r', 'a', ' '),
            Trigram('a', 'r', 'i'),
            Trigram(' ', 'c', 'u'),
            Trigram('v', 'i', 't'),
            Trigram('r', 't', 'a'),
            Trigram('m', 'o', ' '),
            Trigram('t', 'o', ' '),
            Trigram('m', 'n', 'i'),
            Trigram('s', ' ', 'h'),
            Trigram('e', ' ', 'e'),
            Trigram('i', 'n', 't'),
            Trigram('s', 'i', 'u'),
            Trigram('m', ' ', 'c'),
            Trigram('q', 'u', 'a'),
            Trigram('t', ' ', 'p'),
            Trigram('i', 'v', 'i'),
            Trigram('i', 'n', 'i'),
            Trigram('u', 't', ' '),
            Trigram('r', 'e', ' '),
            Trigram('e', 'r', 's'),
            Trigram('i', 't', ' '),
            Trigram('s', ' ', 's'),
            Trigram('i', 'a', 'e'),
            Trigram(' ', 'e', 's'),
            Trigram('t', ' ', 's'),
            Trigram('a', 'n', 'd'),
            Trigram(' ', 'n', 'e'),
            Trigram('p', 'r', 'o'),
            Trigram(' ', 'n', 'u'),
            Trigram('s', 't', ' '),
            Trigram(' ', 'e', 'x'),
            Trigram('n', 'd', 'a'),
            Trigram('c', 'i', 'e'),
            Trigram('n', 'i', 'b'),
            Trigram('t', ' ', 'a'),
            Trigram('e', 'r', 'e'),
            Trigram('t', 'r', 'i'),
            Trigram('n', 'i', 't'),
            Trigram(' ', 'a', 't'),
            Trigram('t', 'i', 'u'),
            Trigram('t', 'a', ' '),
            Trigram('r', 'i', 's'),
            Trigram(' ', 'c', 'i'),
            Trigram('c', 'i', 'v'),
            Trigram('n', 'i', ' '),
            Trigram('u', 'r', 'i'),
            Trigram('u', 'r', ' '),
            Trigram('r', 'i', 'm'),
            Trigram(' ', 'v', 'i'),
            Trigram('p', 'a', 'r'),
            Trigram('a', 'd', ' '),
            Trigram('e', 's', 's'),
            Trigram('l', 'i', 'c'),
            Trigram('i', ' ', 'i'),
            Trigram(' ', 's', 'o'),
            Trigram(' ', 'p', 'u'),
            Trigram(' ', 'o', 'p'),
            Trigram('r', 'a', 'e'),
            Trigram(' ', 'f', 'a'),
            Trigram('s', ' ', 'v'),
            Trigram(' ', 'u', 't'),
            Trigram('d', 'e', 'm'),
            Trigram('s', 'e', ' '),
            Trigram('o', 'n', 's'),
            Trigram('o', ' ', 'e'),
            Trigram('r', 'i', 'a'),
            Trigram(' ', 's', 'e'),
            Trigram('e', ' ', 'a'),
            Trigram(' ', 'm', 'o'),
            Trigram('l', 'e', 'g'),
            Trigram('a', 't', 'q'),
            Trigram('t', 'q', 'u'),
            Trigram('c', 'o', 'm'),
            Trigram('t', 'e', ' '),
            Trigram('n', 'i', 'u'),
            Trigram('i', 'e', 'n'),
            Trigram('v', 'e', 'l'),
            Trigram('e', 'l', ' '),
            Trigram(' ', 'm', 'a'),
            Trigram('t', ' ', 'e'),
            Trigram('i', 'i', 's'),
            Trigram('g', 'n', 'i'),
            Trigram('e', 'q', 'u'),
            Trigram('o', 'c', 'i'),
            Trigram('c', 'i', 'p'),
            Trigram('u', 'r', 'a'),
            Trigram('u', 'n', 't'),
            Trigram('s', ' ', 'd'),
            Trigram('t', ' ', 'i'),
            Trigram('a', 'l', 'i'),
            Trigram('q', 'u', 'o'),
            Trigram('e', 'c', 't'),
            Trigram(' ', 't', 'e'),
            Trigram('a', ' ', 's'),
            Trigram('t', ' ', 'd'),
            Trigram(' ', 'd', 'o'),
            Trigram('t', 'u', 't'),
            Trigram('a', 'n', 't'),
            Trigram('i', 's', 'c'),
            Trigram('i', 'n', 'a'),
            Trigram('m', 'e', 'n'),
            Trigram('s', 'i', 'n'),
            Trigram('u', 'a', ' '),
            Trigram('p', 'r', 'a'),
            Trigram('o', 'r', 'u'),
            Trigram('o', 'm', 'm'),
            Trigram('e', 't', 'a'),
            Trigram('s', ' ', 'n'),
            Trigram('a', ' ', 'p'),
            Trigram('t', 'u', 'm'),
            Trigram('i', 'a', 'm'),
            Trigram('i', 'o', ' '),
            Trigram('i', ' ', 'c'),
            Trigram('s', 't', 'i'),
            Trigram(' ', 'a', 'u'),
            Trigram('v', 'e', 'r'),
            Trigram(' ', 'a', 'e'),
            Trigram('i', 't', 'o'),
            Trigram('d', 'i', 'c'),
            Trigram('i', 'm', 'i'),
            Trigram('s', ' ', 'l'),
            Trigram('e', ' ', 'd'),
            Trigram('f', 'i', 'c'),
            Trigram('c', 'i', 'a'),
            Trigram('t', ' ', 'o'),
            Trigram('p', 'u', 'b'),
            Trigram('u', 'b', 'l'),
            Trigram('b', 'l', 'i'),
            Trigram('m', 'u', 'n'),
            Trigram('i', ' ', 's'),
            Trigram('s', 'o', 'c'),
            Trigram('a', 'r', 'u'),
            Trigram('l', 'a', 'r'),
            Trigram('u', 'l', 'l'),
            Trigram('o', 'r', 'i'),
            Trigram('t', ' ', 'h'),
            Trigram('i', ' ', 'e'),
            Trigram('s', 's', 'e'),
            Trigram('o', 'm', 'o'),
            Trigram('c', 't', 'o'),
            Trigram('i', 't', 'u'),
            Trigram('t', 'u', 's'),
            Trigram(' ', 'e', 'a'),
            Trigram('e', 'a', ' '),
            Trigram('a', 'e', 'q'),
            Trigram('g', 'i', 'o'),
            Trigram('u', 'i', ' '),
            Trigram('m', ' ', 's'),
            Trigram('e', 'r', ' '),
            Trigram('m', ' ', 'r'),
            Trigram(' ', 'r', 'a'),
            Trigram(' ', 'f', 'i'),
            Trigram('f', 'f', 'i'),
            Trigram('c', 'o', 'g'),
            Trigram('d', 'a', ' '),
            Trigram(' ', 'l', 'e'),
            Trigram('m', 'o', 'd'),
            Trigram('a', ' ', 'c'),
            Trigram('m', 'q', 'u'),
            Trigram('n', 'u', 'l'),
            Trigram('e', ' ', 'o'),
            Trigram('e', 'r', 'a'),
            Trigram('t', 'e', 'n'),
            Trigram('n', 't', 'u'),
            Trigram('s', 'p', 'e'),
            Trigram('o', ' ', 'n'),
            Trigram('e', 'm', 'o'),
            Trigram('c', 'r', 'i'),
            Trigram('s', ' ', 'f'),
            Trigram(' ', 'c', 'a'),
            Trigram('d', 'e', ' '),
            Trigram('a', ' ', 'd'),
            Trigram('r', 'e', 'l'),
            Trigram('i', 'i', ' '),
            Trigram('e', 'n', 'e'),
            Trigram(' ', 't', 'u'),
            Trigram('s', 'u', 'i'),
            Trigram('r', 't', 'i'),
            Trigram('s', 'c', 'i'),
            Trigram('n', 'a', 'e'),
            Trigram('m', ' ', 'q'),
            Trigram('m', ' ', 'a'),
            Trigram('e', 'g', 'i'),
            Trigram('c', 'e', 's'),
        ],
    ),
    (
        Lang::Cym,
        &[
            Trigram('y', 'n', ' '),
            Trigram(' ', 'y', 'n'),
            Trigram('d', 'd', ' '),
            Trigram(' ', 'm', 'a'),
            Trigram('a', 'e', ' '),
            Trigram('m', 'a', 'e'),
            Trigram('a', 'u', ' '),
            Trigram(' ', 'y', ' '),
            Trigram('d', ' ', 'y'),
            Trigram('e', 'd', 'd'),
            Trigram(' ', 'r', ' '),
            Trigram('y', 'd', 'd'),
            Trigram(' ', 'a', 'r'),
            Trigram(' ', 'i', ' '),
            Trigram('n', ' ', 'y'),
            Trigram(' ', 'o', ' '),
            Trigram(' ', 'c', 'y'),
            Trigram('t', 'h', ' '),
            Trigram(' ', 'g', 'w'),
            Trigram('d', 'd', 'i'),
            Trigram('e', 't', 'h'),
            Trigram('o', 'e', 'd'),
            Trigram('o', 'l', ' '),
            Trigram('a', 'r', ' '),
            Trigram(' ', 'g', 'y'),
            Trigram(' ', 'd', 'd'),
            Trigram('w', 'y', 'd'),
            Trigram(' ', 'e', 'i'),
            Trigram(' ', 'n', ' '),
            Trigram(' ', 'a', ' '),
            Trigram('y', 'd', ' '),
            Trigram('o', 'd', 'd'),
            Trigram(' ', 'g', 'a'),
            Trigram('a', 'e', 't'),
            Trigram('a', 'n', ' '),
            Trigram(' ', 'r', 'h'),
            Trigram('i', 'a', 'd'),
            Trigram('i', 'o', ' '),
            Trigram('n', ' ', 'a'),
            Trigram('e', 'i', ' '),
            Trigram('y', 'r', ' '),
            Trigram('w', 'n', ' '),
            Trigram('n', ' ', 'c'),
            Trigram(' ', 'l', 'l'),
            Trigram(' ', 'c', 'a'),
            Trigram('n', ' ', 'g'),
            Trigram('d', 'i', ' '),
            Trigram('w', 'e', 'd'),
            Trigram(' ', 'm', 'e'),
            Trigram('o', 'd', ' '),
            Trigram('e', 'l', ' '),
            Trigram('n', ' ', 'd'),
            Trigram('e', 'd', 'i'),
            Trigram('r', ' ', 'y'),
            Trigram('i', 't', 'h'),
            Trigram(' ', 'w', 'e'),
            Trigram('a', 'd', ' '),
            Trigram(' ', 'f', 'e'),
            Trigram('e', 'r', ' '),
            Trigram('r', ' ', 'a'),
            Trigram('d', 'a', 'u'),
            Trigram(' ', 'd', 'a'),
            Trigram(' ', 'a', 'm'),
            Trigram('d', ' ', 'a'),
            Trigram('o', 'n', ' '),
            Trigram('c', 'h', ' '),
            Trigram('l', ' ', 'y'),
            Trigram('d', 'd', 'o'),
            Trigram(' ', 'h', 'e'),
            Trigram(' ', 'c', 'h'),
            Trigram('r', 'o', 'e'),
            Trigram(' ', 'h', 'y'),
            Trigram('e', ' ', 'r'),
            Trigram(' ', 'd', 'i'),
            Trigram('y', 'n', 'n'),
            Trigram(' ', 'y', 'r'),
            Trigram('d', 'd', 'a'),
            Trigram('r', ' ', 'g'),
            Trigram('g', 'a', 'n'),
            Trigram('i', 'r', ' '),
            Trigram('e', 'w', 'n'),
            Trigram(' ', 'r', 'o'),
            Trigram('e', 'n', ' '),
            Trigram(' ', 'd', 'y'),
            Trigram('f', 'o', 'd'),
            Trigram(' ', 'f', 'f'),
            Trigram('i', 'a', 'u'),
            Trigram('l', 'l', ' '),
            Trigram('m', 'e', 'w'),
            Trigram(' ', 'y', 'm'),
            Trigram(' ', 'd', 'e'),
            Trigram('i', 'd', ' '),
            Trigram(' ', 's', 'y'),
            Trigram('y', 'w', ' '),
            Trigram('d', 'i', 'a'),
            Trigram('h', 'y', 'n'),
            Trigram('f', 'y', 'd'),
            Trigram('i', ' ', 'g'),
            Trigram(' ', 'u', 'n'),
            Trigram('e', 'u', ' '),
            Trigram('i', ' ', 'd'),
            Trigram('n', 'o', 'l'),
            Trigram('l', 'l', 'a'),
            Trigram('u', ' ', 'a'),
            Trigram('e', 'i', 't'),
            Trigram(' ', 'a', 'c'),
            Trigram('d', 'o', 'l'),
            Trigram('i', ' ', 'r'),
            Trigram('w', 'y', ' '),
            Trigram('d', 'i', 'o'),
            Trigram('c', 'y', 'n'),
            Trigram('f', 'e', 'l'),
            Trigram(' ', 'n', 'i'),
            Trigram('o', ' ', 'r'),
            Trigram('i', 'd', 'd'),
            Trigram('r', 't', 'h'),
            Trigram(' ', 'g', 'o'),
            Trigram('l', ' ', 'a'),
            Trigram('a', 'i', ' '),
            Trigram('e', 'f', 'y'),
            Trigram('d', 'y', 'n'),
            Trigram(' ', 'b', 'o'),
            Trigram('r', 'h', 'a'),
            Trigram('e', 'd', ' '),
            Trigram(' ', 'd', 'r'),
            Trigram('r', 'w', 'y'),
            Trigram('a', 'd', 'a'),
            Trigram('n', ' ', 'f'),
            Trigram('w', 'y', 'r'),
            Trigram('f', 'e', 'r'),
            Trigram('a', 'c', ' '),
            Trigram('n', ' ', 'e'),
            Trigram('r', 'd', 'd'),
            Trigram('a', 'i', 'd'),
            Trigram('a', 'e', 'l'),
            Trigram('a', 'l', 'l'),
            Trigram('n', 't', ' '),
            Trigram('i', 'o', 'n'),
            Trigram(' ', 't', 'r'),
            Trigram('n', 'y', 'd'),
            Trigram('a', 'c', 'h'),
            Trigram('g', 'y', 'f'),
            Trigram('c', 'y', 'f'),
            Trigram('r', ' ', 'd'),
            Trigram('i', 'g', ' '),
            Trigram('h', ' ', 'y'),
            Trigram('c', 'h', 'w'),
            Trigram('e', 'l', 'l'),
            Trigram('n', ' ', 'b'),
            Trigram('d', ' ', 'e'),
            Trigram('n', ' ', 'o'),
            Trigram(' ', 'b', 'y'),
            Trigram(' ', 'n', 'e'),
            Trigram('d', 'a', ' '),
            Trigram(' ', 'b', 'e'),
            Trigram('h', 'a', 'n'),
            Trigram('n', 'i', 'a'),
            Trigram(' ', 'o', 'e'),
            Trigram('d', ' ', 'o'),
            Trigram('r', ' ', 'c'),
            Trigram('d', ' ', 'g'),
            Trigram('d', 'd', 'e'),
            Trigram('r', ' ', 'o'),
            Trigram('a', 'f', ' '),
            Trigram('a', 'r', 'a'),
            Trigram('n', 'i', ' '),
            Trigram('n', ' ', 's'),
            Trigram(' ', 'p', 'e'),
            Trigram('l', 'w', 'y'),
            Trigram('g', 'w', 'e'),
            Trigram('i', ' ', 'a'),
            Trigram('w', 'r', ' '),
            Trigram(' ', 'b', 'r'),
            Trigram('i', 'n', ' '),
            Trigram('g', 'o', 'l'),
            Trigram(' ', 'g', 'e'),
            Trigram('r', 'c', 'h'),
            Trigram('h', 'e', 'f'),
            Trigram(' ', 'a', 'd'),
            Trigram('n', 'o', 'd'),
            Trigram('n', 'n', 'a'),
            Trigram('g', 'y', 'd'),
            Trigram(' ', 'f', 'a'),
            Trigram('u', 'n', ' '),
            Trigram('d', ' ', 'h'),
            Trigram(' ', 'y', 's'),
            Trigram('d', ' ', 'i'),
            Trigram('y', ' ', 'd'),
            Trigram('e', ' ', 'n'),
            Trigram('r', 'i', 'a'),
            Trigram('e', 's', ' '),
            Trigram(' ', 'a', 'n'),
            Trigram('d', 'w', 'y'),
            Trigram('a', 'm', ' '),
            Trigram('y', 's', 'g'),
            Trigram('y', ' ', 'g'),
            Trigram('w', 'y', 'n'),
            Trigram('u', ' ', 'c'),
            Trigram('l', ' ', 'e'),
            Trigram('i', ' ', 'f'),
            Trigram('g', 'w', 'y'),
            Trigram('e', 'f', 'n'),
            Trigram('d', 'd', 'y'),
            Trigram('y', ' ', 'c'),
            Trigram('d', 'i', 'g'),
            Trigram('w', 'y', 's'),
            Trigram(' ', 'e', 'u'),
            Trigram('y', 'd', 'a'),
            Trigram('n', ' ', 'h'),
            Trigram('y', 'c', 'h'),
            Trigram('t', 'h', 'i'),
            Trigram('a', 'n', 't'),
            Trigram(' ', 'y', 'w'),
            Trigram('w', 'e', 'i'),
            Trigram(' ', 'b', 'a'),
            Trigram('d', ' ', 'c'),
            Trigram('n', ' ', 'n'),
            Trigram('s', ' ', 'y'),
            Trigram('y', 's', 't'),
            Trigram('r', 'y', 'd'),
            Trigram('n', 'a', ' '),
            Trigram('o', ' ', 'a'),
            Trigram('i', ' ', 'n'),
            Trigram('n', ' ', 'm'),
            Trigram('u', ' ', 'g'),
            Trigram('d', ' ', 'd'),
            Trigram('l', 'a', 'w'),
            Trigram('i', ' ', 'w'),
            Trigram('n', ' ', 'i'),
            Trigram('n', ' ', 'r'),
            Trigram(' ', 'f', 'o'),
            Trigram('y', 's', ' '),
            Trigram('i', 'a', 'e'),
            Trigram(' ', 'c', 'o'),
            Trigram('d', 'o', ' '),
            Trigram('l', 'i', 'a'),
            Trigram('r', 'e', 'd'),
            Trigram('n', 'd', ' '),
            Trigram('y', ' ', 'n'),
            Trigram('h', 'a', 'u'),
            Trigram(' ', 'h', 'a'),
            Trigram('n', 'e', 'u'),
            Trigram('u', ' ', 'y'),
            Trigram('r', 'h', 'y'),
            Trigram('u', ' ', 'r'),
            Trigram('b', 'o', 'd'),
            Trigram(' ', 'p', 'r'),
            Trigram(' ', 'c', 'e'),
            Trigram('r', 'a', 'e'),
            Trigram('g', 'o', 'r'),
            Trigram('e', 'n', 'n'),
            Trigram('g', 'w', 'a'),
            Trigram(' ', 'p', 'a'),
            Trigram('i', ' ', 'c'),
            Trigram(' ', 'e', 'r'),
            Trigram('l', 'y', 'n'),
            Trigram('r', 'a', 'i'),
            Trigram('r', 'i', 'f'),
            Trigram('i', 'a', 'n'),
            Trigram('l', 'l', 'i'),
            Trigram('n', 'a', 'u'),
            Trigram('r', ' ', 'h'),
            Trigram('l', 'a', 'n'),
            Trigram('n', 'w', 'y'),
            Trigram('y', 'f', 'e'),
            Trigram('t', 'h', 'a'),
            Trigram('r', ' ', 'e'),
            Trigram('d', ' ', 'm'),
            Trigram('d', 'i', 'w'),
            Trigram('o', 's', ' '),
            Trigram('l', 'l', 'e'),
            Trigram('a', 'n', 'g'),
            Trigram(' ', 's', 'e'),
            Trigram('d', 'd', 'w'),
            Trigram('a', 'l', ' '),
            Trigram('l', 'a', 'd'),
            Trigram('o', ' ', 'g'),
            Trigram('c', 'a', 'e'),
            Trigram('a', 'n', 'n'),
            Trigram('o', 'l', 'i'),
            Trigram('a', ' ', 'r'),
            Trigram('r', ' ', 'b'),
            Trigram('r', 'i', 'o'),
            Trigram('h', 'y', 'd'),
            Trigram('a', 'i', 't'),
            Trigram('a', 'e', 'n'),
            Trigram('u', ' ', 'd'),
            Trigram('n', 'o', ' '),
            Trigram('d', ' ', 'b'),
            Trigram(' ', 's', 'i'),
            Trigram('f', 'a', 'n'),
            Trigram('l', 'l', 'y'),
            Trigram('u', ' ', 'h'),
            Trigram('o', ' ', 'd'),
            Trigram('i', ' ', 'b'),
            Trigram('d', 'a', 'r'),
            Trigram('s', 'g', 'o'),
            Trigram('y', 'n', 'g'),
            Trigram('d', 'o', 'd'),
            Trigram('u', ' ', 'n'),
        ],
    ),
];

/// Languages for script Cyrillic
pub static CYRILLIC_LANGS: LangProfileList = &[
    (
        Lang::Rus,
        &[
            Trigram(' ', 'п', 'р'),
            Trigram(' ', 'и', ' '),
            Trigram('р', 'а', 'в'),
            Trigram('с', 'т', 'в'),
            Trigram(' ', 'н', 'а'),
            Trigram('п', 'р', 'а'),
            Trigram('г', 'о', ' '),
            Trigram('е', 'н', 'и'),
            Trigram('о', 'в', 'е'),
            Trigram('в', 'о', ' '),
            Trigram(' ', 'к', 'а'),
            Trigram('а', 'н', 'и'),
            Trigram('т', 'ь', ' '),
            Trigram(' ', 'в', ' '),
            Trigram(' ', 'п', 'о'),
            Trigram(' ', 'о', 'б'),
            Trigram('и', 'я', ' '),
            Trigram('с', 'в', 'о'),
            Trigram(' ', 'с', 'в'),
            Trigram('л', 'о', 'в'),
            Trigram('н', 'а', ' '),
            Trigram(' ', 'ч', 'е'),
            Trigram('е', 'л', 'о'),
            Trigram('о', ' ', 'н'),
            Trigram(' ', 'с', 'о'),
            Trigram('о', 'с', 'т'),
            Trigram('ч', 'е', 'л'),
            Trigram('и', 'е', ' '),
            Trigram('о', 'г', 'о'),
            Trigram('е', 'т', ' '),
            Trigram('н', 'и', 'я'),
            Trigram('е', 'с', 'т'),
            Trigram('а', 'в', 'о'),
            Trigram('ы', 'й', ' '),
            Trigram('а', 'ж', 'д'),
            Trigram(' ', 'и', 'м'),
            Trigram('н', 'и', 'е'),
            Trigram('в', 'е', 'к'),
            Trigram(' ', 'н', 'е'),
            Trigram('л', 'ь', 'н'),
            Trigram('л', 'и', ' '),
            Trigram('о', 'в', 'а'),
            Trigram('и', 'м', 'е'),
            Trigram('а', 'т', 'ь'),
            Trigram('п', 'р', 'и'),
            Trigram('т', ' ', 'п'),
            Trigram('и', ' ', 'п'),
            Trigram('к', 'а', 'ж'),
            Trigram('и', 'л', 'и'),
            Trigram('о', 'б', 'о'),
            Trigram(' ', 'р', 'а'),
            Trigram('ы', 'х', ' '),
            Trigram('ж', 'д', 'ы'),
            Trigram(' ', 'д', 'о'),
            Trigram('д', 'ы', 'й'),
            Trigram('в', 'о', 'б'),
            Trigram('е', 'к', ' '),
            Trigram('б', 'о', 'д'),
            Trigram('в', 'а', ' '),
            Trigram('й', ' ', 'ч'),
            Trigram('е', 'г', 'о'),
            Trigram('с', 'я', ' '),
            Trigram('и', ' ', 'с'),
            Trigram('и', 'и', ' '),
            Trigram('а', 'ц', 'и'),
            Trigram('е', 'е', 'т'),
            Trigram('н', 'о', ' '),
            Trigram('м', 'е', 'е'),
            Trigram('и', ' ', 'и'),
            Trigram('л', 'е', 'н'),
            Trigram('о', 'й', ' '),
            Trigram('т', 'в', 'а'),
            Trigram('н', 'ы', 'х'),
            Trigram('т', 'о', ' '),
            Trigram(' ', 'и', 'л'),
            Trigram('к', ' ', 'и'),
            Trigram('е', 'н', 'н'),
            Trigram(' ', 'б', 'ы'),
            Trigram('и', 'ю', ' '),
            Trigram(' ', 'з', 'а'),
            Trigram('м', 'и', ' '),
            Trigram('т', 'в', 'о'),
            Trigram('и', ' ', 'н'),
            Trigram('о', ' ', 'п'),
            Trigram('в', 'а', 'н'),
            Trigram('о', ' ', 'с'),
            Trigram('с', 'т', 'о'),
            Trigram('а', 'л', 'ь'),
            Trigram(' ', 'в', 'с'),
            Trigram('о', 'м', ' '),
            Trigram('о', ' ', 'в'),
            Trigram('ь', 'н', 'о'),
            Trigram('и', 'х', ' '),
            Trigram('н', 'о', 'г'),
            Trigram('и', ' ', 'в'),
            Trigram('н', 'о', 'в'),
            Trigram('а', 'к', 'о'),
            Trigram('п', 'р', 'о'),
            Trigram('и', 'й', ' '),
            Trigram('с', 'т', 'и'),
            Trigram('и', ' ', 'о'),
            Trigram('п', 'о', 'л'),
            Trigram('о', 'л', 'ж'),
            Trigram('д', 'о', 'л'),
            Trigram('о', 'е', ' '),
            Trigram('б', 'р', 'а'),
            Trigram('я', ' ', 'в'),
            Trigram(' ', 'о', 'с'),
            Trigram('н', 'ы', 'м'),
            Trigram('ж', 'е', 'н'),
            Trigram('р', 'а', 'з'),
            Trigram('т', 'и', ' '),
            Trigram('н', 'о', 'с'),
            Trigram('я', ' ', 'и'),
            Trigram(' ', 'в', 'о'),
            Trigram('т', 'о', 'р'),
            Trigram('в', 'с', 'е'),
            Trigram(' ', 'е', 'г'),
            Trigram('е', 'й', ' '),
            Trigram('т', 'е', 'л'),
            Trigram('н', 'е', ' '),
            Trigram('и', ' ', 'р'),
            Trigram('р', 'е', 'д'),
            Trigram('е', 'л', 'ь'),
            Trigram('т', 'в', 'е'),
            Trigram('о', 'д', 'и'),
            Trigram(' ', 'к', 'о'),
            Trigram('о', 'б', 'щ'),
            Trigram('о', ' ', 'и'),
            Trigram(' ', 'д', 'е'),
            Trigram('и', 'м', 'а'),
            Trigram('а', ' ', 'и'),
            Trigram('ч', 'е', 'с'),
            Trigram('н', 'и', 'м'),
            Trigram('с', 'н', 'о'),
            Trigram('к', 'а', 'к'),
            Trigram(' ', 'л', 'и'),
            Trigram('щ', 'е', 'с'),
            Trigram('в', 'л', 'е'),
            Trigram('ь', 'с', 'я'),
            Trigram('н', 'н', 'ы'),
            Trigram('а', 'с', 'т'),
            Trigram('т', 'ь', 'с'),
            Trigram('н', 'н', 'о'),
            Trigram('о', 'с', 'у'),
            Trigram('е', ' ', 'д'),
            Trigram(' ', 'о', 'т'),
            Trigram('п', 'р', 'е'),
            Trigram('ш', 'е', 'н'),
            Trigram('а', ' ', 'с'),
            Trigram('б', 'щ', 'е'),
            Trigram('о', 'с', 'н'),
            Trigram('о', 'д', 'н'),
            Trigram('б', 'ы', 'т'),
            Trigram('с', 'о', 'в'),
            Trigram('ы', 'т', 'ь'),
            Trigram('л', 'ж', 'н'),
            Trigram('р', 'а', 'н'),
            Trigram('н', 'и', 'ю'),
            Trigram('и', 'ч', 'е'),
            Trigram('а', 'к', ' '),
            Trigram('ы', 'м', ' '),
            Trigram('в', 'а', 'т'),
            Trigram('ч', 'т', 'о'),
            Trigram('с', 'т', 'у'),
            Trigram('ч', 'е', 'н'),
            Trigram('е', ' ', 'в'),
            Trigram(' ', 'с', 'т'),
            Trigram('р', 'е', 'с'),
            Trigram('о', 'л', 'ь'),
            Trigram(' ', 'н', 'и'),
            Trigram('н', 'о', 'м'),
            Trigram('р', 'о', 'д'),
            Trigram('л', 'я', ' '),
            Trigram('н', 'а', 'р'),
            Trigram('в', 'е', 'н'),
            Trigram('д', 'у', ' '),
            Trigram('о', 'ж', 'е'),
            Trigram('н', 'ы', ' '),
            Trigram('е', ' ', 'и'),
            Trigram(' ', 'т', 'о'),
            Trigram('в', 'е', 'р'),
            Trigram('а', ' ', 'о'),
            Trigram('з', 'о', 'в'),
            Trigram('м', ' ', 'и'),
            Trigram('н', 'а', 'ц'),
            Trigram('д', 'е', 'н'),
            Trigram('р', 'и', 'н'),
            Trigram('т', 'у', 'п'),
            Trigram('е', 'ж', 'д'),
            Trigram('с', 'т', 'р'),
            Trigram(' ', 'ч', 'т'),
            Trigram('я', ' ', 'п'),
            Trigram('о', 'н', 'а'),
            Trigram('д', 'о', 'с'),
            Trigram('х', ' ', 'и'),
            Trigram('й', ' ', 'и'),
            Trigram('т', 'о', 'я'),
            Trigram('е', 'с', 'п'),
            Trigram('л', 'и', 'ч'),
            Trigram('б', 'е', 'с'),
            Trigram('о', 'б', 'р'),
            Trigram('о', 'т', 'о'),
            Trigram('о', ' ', 'б'),
            Trigram('ь', 'н', 'ы'),
            Trigram('ь', ' ', 'в'),
            Trigram('н', 'и', 'и'),
            Trigram('е', ' ', 'м'),
            Trigram('у', 'ю', ' '),
            Trigram(' ', 'м', 'о'),
            Trigram('е', 'м', ' '),
            Trigram(' ', 'м', 'е'),
            Trigram('а', 'р', 'о'),
            Trigram(' ', 'р', 'е'),
            Trigram('а', 'в', 'а'),
            Trigram('к', 'о', 'т'),
            Trigram('а', 'в', ' '),
            Trigram(' ', 'в', 'ы'),
            Trigram('а', 'м', ' '),
            Trigram('ж', 'н', 'о'),
            Trigram('с', 'т', 'а'),
            Trigram('а', 'я', ' '),
            Trigram('п', 'о', 'д'),
            Trigram('и', ' ', 'к'),
            Trigram('н', 'о', 'е'),
            Trigram(' ', 'к', ' '),
            Trigram(' ', 'т', 'а'),
            Trigram(' ', 'г', 'о'),
            Trigram('г', 'о', 'с'),
            Trigram('с', 'у', 'д'),
            Trigram('е', 'о', 'б'),
            Trigram('я', ' ', 'н'),
            Trigram('е', 'н', ' '),
            Trigram('и', ' ', 'д'),
            Trigram('м', 'о', 'ж'),
            Trigram('е', 'с', 'к'),
            Trigram('е', 'л', 'и'),
            Trigram('а', 'в', 'н'),
            Trigram('в', 'е', ' '),
            Trigram('е', 'ч', 'е'),
            Trigram('у', 'щ', 'е'),
            Trigram('п', 'е', 'ч'),
            Trigram('д', 'н', 'о'),
            Trigram('о', ' ', 'д'),
            Trigram('х', 'о', 'д'),
            Trigram('к', 'а', ' '),
            Trigram(' ', 'д', 'л'),
            Trigram('д', 'л', 'я'),
            Trigram('о', 'в', 'о'),
            Trigram('а', 'т', 'е'),
            Trigram('л', 'ь', 'с'),
            Trigram('ю', ' ', 'и'),
            Trigram('в', ' ', 'к'),
            Trigram('н', 'е', 'н'),
            Trigram('ц', 'и', 'и'),
            Trigram('н', 'о', 'й'),
            Trigram('у', 'д', 'а'),
            Trigram('в', 'о', 'в'),
            Trigram(' ', 'б', 'е'),
            Trigram('о', 'р', 'о'),
            Trigram('н', 'с', 'т'),
            Trigram('а', 'м', 'и'),
            Trigram('ц', 'и', 'а'),
            Trigram('к', 'о', 'н'),
            Trigram('с', 'е', 'м'),
            Trigram('е', ' ', 'о'),
            Trigram('в', 'н', 'о'),
            Trigram(' ', 'э', 'т'),
            Trigram('а', 'з', 'о'),
            Trigram('х', ' ', 'п'),
            Trigram('н', 'и', ' '),
            Trigram('ж', 'д', 'е'),
            Trigram('м', ' ', 'п'),
            Trigram('к', 'о', 'г'),
            Trigram('о', 'т', ' '),
            Trigram('д', 'с', 'т'),
            Trigram('в', 'н', 'ы'),
            Trigram('с', 'т', 'ь'),
            Trigram('ы', 'е', ' '),
            Trigram('о', ' ', 'о'),
            Trigram('п', 'о', 'с'),
            Trigram('с', 'р', 'е'),
            Trigram('т', 'р', 'а'),
            Trigram('е', 'й', 'с'),
            Trigram('т', 'а', 'к'),
            Trigram('и', ' ', 'б'),
            Trigram('д', 'о', 'в'),
            Trigram('м', 'у', ' '),
            Trigram('я', ' ', 'к'),
            Trigram('н', 'а', 'л'),
            Trigram('д', 'р', 'у'),
            Trigram(' ', 'д', 'р'),
            Trigram('к', 'о', 'й'),
            Trigram('т', 'е', 'р'),
            Trigram('ь', ' ', 'п'),
            Trigram('а', 'р', 'с'),
            Trigram('и', 'з', 'н'),
            Trigram('с', 'о', 'ц'),
            Trigram('е', 'д', 'и'),
            Trigram('о', 'л', 'н'),
        ],
    ),
    (
        Lang::Ukr,
        &[
            Trigram('н', 'а', ' '),
            Trigram(' ', 'п', 'р'),
            Trigram(' ', 'і', ' '),
            Trigram('п', 'р', 'а'),
            Trigram('р', 'а', 'в'),
            Trigram(' ', 'н', 'а'),
            Trigram('н', 'я', ' '),
            Trigram('н', 'н', 'я'),
            Trigram(' ', 'з', 'а'),
            Trigram('о', 'г', 'о'),
            Trigram(' ', 'п', 'о'),
            Trigram('т', 'и', ' '),
            Trigram('г', 'о', ' '),
            Trigram('л', 'ю', 'д'),
            Trigram(' ', 'л', 'ю'),
            Trigram('в', 'о', ' '),
            Trigram(' ', 'к', 'о'),
            Trigram(' ', 'м', 'а'),
            Trigram('л', 'ь', 'н'),
            Trigram('ю', 'д', 'и'),
            Trigram('и', 'х', ' '),
            Trigram('о', ' ', 'н'),
            Trigram(' ', 'н', 'е'),
            Trigram('а', 'в', 'о'),
            Trigram('а', 'н', 'н'),
            Trigram('д', 'и', 'н'),
            Trigram(' ', 'с', 'в'),
            Trigram('с', 'в', 'о'),
            Trigram('о', 'ж', 'н'),
            Trigram('к', 'о', 'ж'),
            Trigram('е', 'н', 'н'),
            Trigram('п', 'о', 'в'),
            Trigram('ж', 'н', 'а'),
            Trigram(' ', 'д', 'о'),
            Trigram('а', 'т', 'и'),
            Trigram('и', 'н', 'а'),
            Trigram('а', 'є', ' '),
            Trigram('а', ' ', 'л'),
            Trigram(' ', 'б', 'у'),
            Trigram('а', 'ц', 'і'),
            Trigram('н', 'е', ' '),
            Trigram('у', 'в', 'а'),
            Trigram('о', 'б', 'о'),
            Trigram(' ', 'о', 'с'),
            Trigram(' ', 'я', 'к'),
            Trigram('м', 'а', 'є'),
            Trigram(' ', 'в', 'и'),
            Trigram('н', 'и', 'х'),
            Trigram('а', 'л', 'ь'),
            Trigram('а', 'б', 'о'),
            Trigram('є', ' ', 'п'),
            Trigram(' ', 'т', 'а'),
            Trigram('н', 'і', ' '),
            Trigram('т', 'ь', ' '),
            Trigram('о', 'в', 'и'),
            Trigram('б', 'о', ' '),
            Trigram(' ', 'в', 'і'),
            Trigram(' ', 'а', 'б'),
            Trigram('е', 'р', 'е'),
            Trigram('і', ' ', 'п'),
            Trigram('а', ' ', 'м'),
            Trigram('в', 'и', 'н'),
            Trigram('б', 'е', 'з'),
            Trigram('п', 'р', 'и'),
            Trigram('і', 'л', 'ь'),
            Trigram('н', 'о', 'г'),
            Trigram('о', ' ', 'п'),
            Trigram('м', 'и', ' '),
            Trigram('т', 'а', ' '),
            Trigram('о', 'м', ' '),
            Trigram('о', 'ю', ' '),
            Trigram('б', 'о', 'д'),
            Trigram('с', 'т', 'а'),
            Trigram('в', 'о', 'б'),
            Trigram(' ', 'б', 'е'),
            Trigram('д', 'о', ' '),
            Trigram('в', 'а', ' '),
            Trigram('т', 'і', ' '),
            Trigram(' ', 'о', 'б'),
            Trigram('о', ' ', 'в'),
            Trigram('о', 'с', 'т'),
            Trigram(' ', 'в', ' '),
            Trigram(' ', 'щ', 'о'),
            Trigram('и', 'й', ' '),
            Trigram('с', 'я', ' '),
            Trigram('і', ' ', 'с'),
            Trigram(' ', 'с', 'п'),
            Trigram('и', 'н', 'н'),
            Trigram('в', 'і', 'д'),
            Trigram('с', 'т', 'в'),
            Trigram('и', ' ', 'п'),
            Trigram('в', 'а', 'н'),
            Trigram('н', 'о', 'в'),
            Trigram('н', 'а', 'н'),
            Trigram('к', 'о', 'н'),
            Trigram(' ', 'у', ' '),
            Trigram('в', 'а', 'т'),
            Trigram('о', 'н', 'а'),
            Trigram('і', 'ї', ' '),
            Trigram('н', 'о', ' '),
            Trigram('д', 'н', 'о'),
            Trigram('і', 'й', ' '),
            Trigram('е', 'з', 'п'),
            Trigram('п', 'е', 'р'),
            Trigram(' ', 'д', 'е'),
            Trigram('у', 'т', 'и'),
            Trigram('ь', 'н', 'о'),
            Trigram('и', 'с', 'т'),
            Trigram('п', 'і', 'д'),
            Trigram('с', 'т', 'і'),
            Trigram('б', 'у', 'т'),
            Trigram(' ', 'м', 'о'),
            Trigram('и', ' ', 'і'),
            Trigram('і', 'д', 'н'),
            Trigram('а', 'к', 'о'),
            Trigram('н', 'н', 'і'),
            Trigram('і', 'д', ' '),
            Trigram('т', 'и', 'с'),
            Trigram('щ', 'о', ' '),
            Trigram('р', 'о', 'д'),
            Trigram('і', ' ', 'в'),
            Trigram('а', ' ', 'з'),
            Trigram('а', 'в', 'а'),
            Trigram(' ', 'п', 'е'),
            Trigram('м', 'у', ' '),
            Trigram('і', ' ', 'н'),
            Trigram('а', ' ', 'п'),
            Trigram('с', 'о', 'б'),
            Trigram('о', 'ї', ' '),
            Trigram('а', ' ', 'в'),
            Trigram('с', 'п', 'р'),
            Trigram('і', 'в', ' '),
            Trigram('н', 'и', 'й'),
            Trigram('я', 'к', 'о'),
            Trigram('д', 'у', ' '),
            Trigram('в', 'н', 'о'),
            Trigram('і', ' ', 'д'),
            Trigram('н', 'у', ' '),
            Trigram('а', 'р', 'о'),
            Trigram('и', ' ', 'с'),
            Trigram(' ', 'і', 'н'),
            Trigram('л', 'я', ' '),
            Trigram('р', 'і', 'в'),
            Trigram('у', ' ', 'в'),
            Trigram(' ', 'р', 'і'),
            Trigram('и', ' ', 'д'),
            Trigram('н', 'а', 'р'),
            Trigram('н', 'е', 'н'),
            Trigram('о', 'в', 'а'),
            Trigram('о', 'м', 'у'),
            Trigram('л', 'е', 'н'),
            Trigram('н', 'а', 'ц'),
            Trigram('н', 'и', 'м'),
            Trigram('и', 'с', 'я'),
            Trigram('ч', 'и', ' '),
            Trigram('а', 'в', ' '),
            Trigram('і', ' ', 'р'),
            Trigram('н', 'о', 'м'),
            Trigram(' ', 'р', 'о'),
            Trigram('н', 'о', 'с'),
            Trigram('в', 'і', ' '),
            Trigram('в', 'н', 'и'),
            Trigram('о', 'в', 'н'),
            Trigram(' ', 'ї', 'ї'),
            Trigram('о', 'в', 'і'),
            Trigram('м', 'о', 'ж'),
            Trigram('в', 'і', 'л'),
            Trigram('у', ' ', 'п'),
            Trigram(' ', 'п', 'і'),
            Trigram(' ', 'с', 'у'),
            Trigram('ї', 'ї', ' '),
            Trigram('о', 'д', 'н'),
            Trigram(' ', 'в', 'с'),
            Trigram('о', 'в', 'о'),
            Trigram('ю', 'т', 'ь'),
            Trigram('і', 'с', 'т'),
            Trigram('с', 'т', 'ь'),
            Trigram('і', ' ', 'з'),
            Trigram(' ', 'с', 'т'),
            Trigram('б', 'у', 'д'),
            Trigram(' ', 'р', 'а'),
            Trigram('ч', 'е', 'н'),
            Trigram('п', 'р', 'о'),
            Trigram('р', 'о', 'з'),
            Trigram('і', 'в', 'н'),
            Trigram('о', 'д', 'у'),
            Trigram('а', ' ', 'о'),
            Trigram('ь', 'н', 'и'),
            Trigram('н', 'и', ' '),
            Trigram('о', ' ', 'с'),
            Trigram('с', 'н', 'о'),
            Trigram('з', 'н', 'а'),
            Trigram('р', 'а', 'ц'),
            Trigram('и', 'м', ' '),
            Trigram('о', ' ', 'д'),
            Trigram('и', 'м', 'и'),
            Trigram('я', ' ', 'і'),
            Trigram('ц', 'і', 'ї'),
            Trigram('х', ' ', 'п'),
            Trigram('д', 'е', 'р'),
            Trigram('ч', 'и', 'н'),
            Trigram(' ', 'с', 'о'),
            Trigram('а', ' ', 'с'),
            Trigram('е', 'р', 'ж'),
            Trigram('и', ' ', 'з'),
            Trigram('и', ' ', 'в'),
            Trigram('е', ' ', 'п'),
            Trigram('д', 'и', ' '),
            Trigram('з', 'а', 'б'),
            Trigram('о', 'с', 'о'),
            Trigram('у', ' ', 'с'),
            Trigram('е', ' ', 'б'),
            Trigram('с', 'і', ' '),
            Trigram('т', 'е', 'р'),
            Trigram('н', 'і', 'х'),
            Trigram('я', ' ', 'н'),
            Trigram('і', ' ', 'б'),
            Trigram('к', 'л', 'а'),
            Trigram('с', 'п', 'і'),
            Trigram('в', ' ', 'і'),
            Trigram(' ', 'н', 'і'),
            Trigram('о', ' ', 'з'),
            Trigram('р', 'ж', 'а'),
            Trigram('с', 'т', 'у'),
            Trigram('ї', 'х', ' '),
            Trigram('а', ' ', 'н'),
            Trigram('н', 'н', 'а'),
            Trigram('т', 'а', 'к'),
            Trigram('я', ' ', 'п'),
            Trigram('з', 'п', 'е'),
            Trigram(' ', 'о', 'д'),
            Trigram('а', 'б', 'е'),
            Trigram('д', 'л', 'я'),
            Trigram('т', 'у', ' '),
            Trigram('і', ' ', 'м'),
            Trigram('п', 'е', 'ч'),
            Trigram(' ', 'д', 'л'),
            Trigram('ж', 'е', ' '),
            Trigram('к', 'и', ' '),
            Trigram('в', 'і', 'т'),
            Trigram('н', 'і', 'с'),
            Trigram('г', 'а', 'л'),
            Trigram('а', 'г', 'а'),
            Trigram('е', ' ', 'м'),
            Trigram('а', 'м', 'и'),
            Trigram('з', 'а', 'х'),
            Trigram('р', 'и', 'м'),
            Trigram('ї', ' ', 'о'),
            Trigram('т', 'а', 'н'),
            Trigram('к', 'о', 'г'),
            Trigram('р', 'е', 'с'),
            Trigram('у', 'д', 'ь'),
            Trigram(' ', 'р', 'е'),
            Trigram('т', 'о', ' '),
            Trigram('к', 'о', 'в'),
            Trigram('т', 'о', 'р'),
            Trigram('а', 'р', 'а'),
            Trigram('с', 'в', 'і'),
            Trigram('т', 'в', 'а'),
            Trigram('а', ' ', 'б'),
            Trigram('о', 'ж', 'е'),
            Trigram('с', 'о', 'ц'),
            Trigram('о', 'ц', 'і'),
            Trigram('ц', 'і', 'а'),
            Trigram('о', 'с', 'н'),
            Trigram('р', 'о', 'б'),
            Trigram('д', 'ь', '‐'),
            Trigram('ь', '‐', 'я'),
            Trigram('‐', 'я', 'к'),
            Trigram('і', ' ', 'і'),
            Trigram('з', 'а', 'г'),
            Trigram('а', 'х', 'и'),
            Trigram('х', 'и', 'с'),
            Trigram('п', 'і', 'л'),
            Trigram('ц', 'і', 'й'),
            Trigram('х', ' ', 'в'),
            Trigram('л', 'и', 'в'),
            Trigram('о', 'с', 'в'),
            Trigram('і', 'а', 'л'),
            Trigram('р', 'у', 'ч'),
            Trigram('ь', ' ', 'п'),
            Trigram('і', 'н', 'ш'),
            Trigram('в', ' ', 'я'),
            Trigram('г', 'и', ' '),
            Trigram('а', 'г', 'и'),
            Trigram(' ', 'д', 'і'),
            Trigram('к', 'о', 'м'),
            Trigram('и', 'н', 'и'),
            Trigram('а', ' ', 'і'),
            Trigram('о', 'д', 'и'),
            Trigram('н', 'а', 'л'),
            Trigram('т', 'в', 'о'),
            Trigram('к', 'о', 'ї'),
            Trigram('в', 'с', 'і'),
            Trigram('я', ' ', 'в'),
            Trigram('н', 'о', 'ю'),
            Trigram('о', 'б', ' '),
            Trigram('о', ' ', 'у'),
            Trigram('о', ' ', 'о'),
            Trigram('і', ' ', 'о'),
        ],
    ),
    (
        Lang::Srp,
        &[
            Trigram(' ', 'п', 'р'),
            Trigram(' ', 'и', ' '),
            Trigram('р', 'а', 'в'),
            Trigram('п', 'р', 'а'),
            Trigram(' ', 'н', 'а'),
            Trigram('н', 'а', ' '),
            Trigram(' ', 'п', 'о'),
            Trigram('м', 'а', ' '),
            Trigram(' ', 'с', 'в'),
            Trigram('д', 'а', ' '),
            Trigram('и', 'м', 'а'),
            Trigram('а', ' ', 'п'),
            Trigram('а', ' ', 'и'),
            Trigram('в', 'о', ' '),
            Trigram('к', 'о', ' '),
            Trigram('в', 'а', ' '),
            Trigram('т', 'и', ' '),
            Trigram('и', ' ', 'п'),
            Trigram(' ', 'у', ' '),
            Trigram('а', 'к', 'о'),
            Trigram(' ', 'д', 'а'),
            Trigram('а', ' ', 'с'),
            Trigram('а', 'в', 'о'),
            Trigram('и', ' ', 'с'),
            Trigram('о', 'с', 'т'),
            Trigram(' ', 'з', 'а'),
            Trigram('о', ' ', 'и'),
            Trigram('с', 'в', 'а'),
            Trigram(' ', 'и', 'м'),
            Trigram('в', 'а', 'к'),
            Trigram('а', 'в', 'а'),
            Trigram('ј', 'е', ' '),
            Trigram('е', ' ', 'с'),
            Trigram(' ', 'с', 'л'),
            Trigram(' ', 'к', 'о'),
            Trigram('о', ' ', 'н'),
            Trigram('њ', 'а', ' '),
            Trigram('н', 'о', ' '),
            Trigram('н', 'е', ' '),
            Trigram(' ', 'н', 'е'),
            Trigram('о', 'м', ' '),
            Trigram('л', 'и', ' '),
            Trigram(' ', 'д', 'р'),
            Trigram('и', 'л', 'и'),
            Trigram('у', ' ', 'с'),
            Trigram('с', 'л', 'о'),
            Trigram('о', 'б', 'о'),
            Trigram('к', 'о', 'ј'),
            Trigram('и', 'х', ' '),
            Trigram('л', 'о', 'б'),
            Trigram('б', 'о', 'д'),
            Trigram('и', 'м', ' '),
            Trigram('а', ' ', 'н'),
            Trigram('ј', 'у', ' '),
            Trigram(' ', 'и', 'л'),
            Trigram('с', 'т', 'в'),
            Trigram(' ', 'б', 'и'),
            Trigram('с', 'т', 'и'),
            Trigram('а', ' ', 'о'),
            Trigram('п', 'р', 'и'),
            Trigram('а', ' ', 'у'),
            Trigram(' ', 'р', 'а'),
            Trigram('ј', 'е', 'д'),
            Trigram('о', 'г', ' '),
            Trigram(' ', 'ј', 'е'),
            Trigram('е', ' ', 'п'),
            Trigram('њ', 'е', ' '),
            Trigram('н', 'и', ' '),
            Trigram('у', ' ', 'п'),
            Trigram('а', ' ', 'д'),
            Trigram('е', 'д', 'н'),
            Trigram('и', 'т', 'и'),
            Trigram('а', ' ', 'к'),
            Trigram('н', 'о', 'с'),
            Trigram('и', ' ', 'у'),
            Trigram('о', ' ', 'д'),
            Trigram('п', 'р', 'о'),
            Trigram(' ', 'с', 'у'),
            Trigram('а', 'њ', 'е'),
            Trigram('о', 'в', 'а'),
            Trigram('е', ' ', 'и'),
            Trigram('в', 'а', 'њ'),
            Trigram('и', ' ', 'и'),
            Trigram('ц', 'и', 'ј'),
            Trigram(' ', 'о', 'с'),
            Trigram('с', 'е', ' '),
            Trigram('д', 'р', 'у'),
            Trigram('с', 'т', 'а'),
            Trigram('а', 'ј', 'у'),
            Trigram('а', 'њ', 'а'),
            Trigram('и', ' ', 'о'),
            Trigram(' ', 'о', 'б'),
            Trigram('р', 'о', 'д'),
            Trigram('о', 'в', 'е'),
            Trigram(' ', 'к', 'а'),
            Trigram(' ', 'д', 'е'),
            Trigram('е', ' ', 'о'),
            Trigram('а', 'ц', 'и'),
            Trigram('ј', 'а', ' '),
            Trigram('о', 'в', 'о'),
            Trigram(' ', 'н', 'и'),
            Trigram(' ', 'о', 'д'),
            Trigram('и', ' ', 'д'),
            Trigram(' ', 'с', 'е'),
            Trigram('в', 'е', ' '),
            Trigram('у', 'ј', 'е'),
            Trigram('е', 'н', 'и'),
            Trigram('и', 'ј', 'а'),
            Trigram('а', 'в', 'н'),
            Trigram('ж', 'а', 'в'),
            Trigram(' ', 'с', 'т'),
            Trigram('у', ' ', 'и'),
            Trigram('м', ' ', 'и'),
            Trigram('д', 'н', 'а'),
            Trigram('с', 'у', ' '),
            Trigram('р', 'е', 'д'),
            Trigram('и', ' ', 'н'),
            Trigram('о', 'ј', 'а'),
            Trigram('е', ' ', 'б'),
            Trigram('а', 'р', 'а'),
            Trigram('ш', 'т', 'о'),
            Trigram('н', 'о', 'в'),
            Trigram('р', 'ж', 'а'),
            Trigram('в', 'о', 'ј'),
            Trigram('д', 'р', 'ж'),
            Trigram('т', 'в', 'а'),
            Trigram('о', 'д', 'и'),
            Trigram('у', ' ', 'о'),
            Trigram('а', ' ', 'б'),
            Trigram('о', 'д', 'н'),
            Trigram('п', 'о', 'ш'),
            Trigram('о', 'ш', 'т'),
            Trigram('н', 'и', 'м'),
            Trigram('а', ' ', 'ј'),
            Trigram('к', 'а', ' '),
            Trigram('р', 'а', 'н'),
            Trigram('у', ' ', 'у'),
            Trigram(' ', 'о', 'в'),
            Trigram('а', 'р', 'о'),
            Trigram('е', ' ', 'д'),
            Trigram('с', 'н', 'о'),
            Trigram('е', 'њ', 'а'),
            Trigram('у', ' ', 'з'),
            Trigram('р', 'а', 'з'),
            Trigram(' ', 'и', 'з'),
            Trigram('о', 'с', 'н'),
            Trigram('а', ' ', 'з'),
            Trigram('о', ' ', 'п'),
            Trigram('а', 'в', 'е'),
            Trigram('п', 'р', 'е'),
            Trigram('д', 'е', ' '),
            Trigram('б', 'и', 'т'),
            Trigram('н', 'и', 'х'),
            Trigram('ш', 'т', 'и'),
            Trigram('в', 'у', ' '),
            Trigram('у', ' ', 'д'),
            Trigram('д', 'у', ' '),
            Trigram('т', 'у', ' '),
            Trigram(' ', 'т', 'р'),
            Trigram('н', 'а', 'р'),
            Trigram(' ', 'с', 'а'),
            Trigram('г', 'о', 'в'),
            Trigram('з', 'а', ' '),
            Trigram('б', 'е', 'з'),
            Trigram('о', 'ј', 'и'),
            Trigram('у', ' ', 'н'),
            Trigram('в', 'н', 'о'),
            Trigram('и', 'ч', 'н'),
            Trigram('е', 'ђ', 'у'),
            Trigram('л', 'о', ' '),
            Trigram('а', 'н', ' '),
            Trigram('ч', 'н', 'о'),
            Trigram('ј', 'и', ' '),
            Trigram('н', 'а', 'к'),
            Trigram('о', 'д', 'а'),
            Trigram(' ', 'м', 'е'),
            Trigram('в', 'и', 'м'),
            Trigram('т', 'о', ' '),
            Trigram('с', 'в', 'о'),
            Trigram('а', 'н', 'и'),
            Trigram('н', 'а', 'ц'),
            Trigram(' ', 'њ', 'е'),
            Trigram('н', 'и', 'к'),
            Trigram('њ', 'е', 'г'),
            Trigram('т', 'и', 'т'),
            Trigram('о', 'ј', ' '),
            Trigram('м', 'е', ' '),
            Trigram('н', 'о', 'м'),
            Trigram('м', ' ', 'с'),
            Trigram('е', ' ', 'у'),
            Trigram('о', ' ', 'к'),
            Trigram('к', 'у', ' '),
            Trigram(' ', 'д', 'о'),
            Trigram('и', 'к', 'а'),
            Trigram('и', 'к', 'о'),
            Trigram('е', ' ', 'к'),
            Trigram('п', 'о', 'с'),
            Trigram('а', 'ш', 'т'),
            Trigram('т', 'р', 'е'),
            Trigram('а', 'л', 'н'),
            Trigram('н', 'о', 'г'),
            Trigram(' ', 'в', 'р'),
            Trigram('р', 'е', 'б'),
            Trigram('н', 'с', 'т'),
            Trigram(' ', 'к', 'р'),
            Trigram('с', 'т', 'у'),
            Trigram('д', 'н', 'о'),
            Trigram('е', 'м', ' '),
            Trigram('в', 'а', 'р'),
            Trigram('е', ' ', 'н'),
            Trigram('р', 'и', 'в'),
            Trigram('т', 'у', 'п'),
            Trigram('ж', 'и', 'в'),
            Trigram('т', 'е', ' '),
            Trigram('ч', 'о', 'в'),
            Trigram('с', 'т', ' '),
            Trigram('о', 'в', 'и'),
            Trigram('д', 'н', 'и'),
            Trigram('а', 'о', ' '),
            Trigram('с', 'м', 'е'),
            Trigram('б', 'р', 'а'),
            Trigram('а', 'в', 'и'),
            Trigram(' ', 'л', 'и'),
            Trigram('к', 'а', 'о'),
            Trigram('в', 'о', 'љ'),
            Trigram('и', 'л', 'о'),
            Trigram('о', ' ', 'с'),
            Trigram('ш', 'т', 'в'),
            Trigram('и', ' ', 'м'),
            Trigram('з', 'а', 'ш'),
            Trigram('њ', 'у', ' '),
            Trigram('р', 'у', 'г'),
            Trigram('т', 'а', 'в'),
            Trigram('а', 'н', 'с'),
            Trigram('е', 'н', 'о'),
            Trigram('п', 'о', 'р'),
            Trigram('к', 'р', 'и'),
            Trigram('и', ' ', 'б'),
            Trigram('о', 'д', 'у'),
            Trigram('а', ' ', 'р'),
            Trigram('л', 'а', ' '),
            Trigram(' ', 'ч', 'о'),
            Trigram('а', ' ', 'т'),
            Trigram('р', 'у', 'ш'),
            Trigram('у', 'ш', 'т'),
            Trigram(' ', 'б', 'у'),
            Trigram('б', 'у', 'д'),
            Trigram('а', 'в', 'љ'),
            Trigram('у', 'г', 'и'),
            Trigram('м', ' ', 'п'),
            Trigram('к', 'о', 'м'),
            Trigram('о', 'ј', 'е'),
            Trigram('в', 'е', 'р'),
            Trigram(' ', 'в', 'е'),
            Trigram('п', 'о', 'д'),
            Trigram('и', ' ', 'в'),
            Trigram('м', 'е', 'ђ'),
            Trigram('е', 'г', 'о'),
            Trigram('в', 'р', 'е'),
            Trigram('а', 'к', 'в'),
            Trigram('е', 'д', 'и'),
            Trigram('т', 'в', 'о'),
            Trigram(' ', 'с', 'м'),
            Trigram('о', 'д', ' '),
            Trigram('д', 'е', 'л'),
            Trigram('е', 'н', 'а'),
            Trigram('р', 'а', 'д'),
            Trigram('б', 'а', ' '),
            Trigram(' ', 'м', 'о'),
            Trigram('н', 'у', ' '),
            Trigram('о', ' ', 'ј'),
            Trigram('д', 'с', 'т'),
            Trigram('к', 'л', 'а'),
            Trigram(' ', 'о', 'п'),
            Trigram('к', 'а', 'к'),
            Trigram('с', 'а', 'м'),
            Trigram('е', 'р', 'е'),
            Trigram('р', 'и', 'м'),
            Trigram('в', 'и', 'ч'),
            Trigram('и', 'в', 'а'),
            Trigram('о', ' ', 'о'),
            Trigram(' ', 'о', 'н'),
            Trigram('в', 'н', 'и'),
            Trigram('т', 'е', 'р'),
            Trigram('з', 'б', 'е'),
            Trigram('х', ' ', 'п'),
            Trigram('н', 'и', 'ц'),
            Trigram('е', 'б', 'а'),
            Trigram('е', ' ', 'р'),
            Trigram('у', ' ', 'в'),
            Trigram('и', 'с', 'т'),
            Trigram('в', 'е', 'к'),
            Trigram('р', 'е', 'м'),
            Trigram('с', 'в', 'и'),
            Trigram('б', 'и', 'л'),
            Trigram('ш', 'т', 'е'),
            Trigram('е', 'з', 'б'),
            Trigram('ј', 'у', 'ћ'),
            Trigram('њ', 'е', 'н'),
            Trigram('г', 'л', 'а'),
        ],
    ),
    (
        Lang::Bel,
        &[
            Trigram(' ', 'і', ' '),
            Trigram(' ', 'п', 'р'),
            Trigram('п', 'р', 'а'),
            Trigram('а', 'в', 'а'),
            Trigram(' ', 'н', 'а'),
            Trigram('н', 'а', ' '),
            Trigram(' ', 'п', 'а'),
            Trigram('р', 'а', 'в'),
            Trigram('н', 'ы', ' '),
            Trigram('ц', 'ь', ' '),
            Trigram('а', 'б', 'о'),
            Trigram(' ', 'а', 'б'),
            Trigram('в', 'а', ' '),
            Trigram('а', 'ц', 'ы'),
            Trigram('а', 'в', 'е'),
            Trigram('а', 'е', ' '),
            Trigram(' ', 'ч', 'а'),
            Trigram('н', 'н', 'я'),
            Trigram('а', 'н', 'н'),
            Trigram('л', 'ь', 'н'),
            Trigram(' ', 'м', 'а'),
            Trigram(' ', 'с', 'в'),
            Trigram('с', 'в', 'а'),
            Trigram('а', 'л', 'а'),
            Trigram('н', 'е', ' '),
            Trigram('ч', 'а', 'л'),
            Trigram('л', 'а', 'в'),
            Trigram('н', 'я', ' '),
            Trigram('а', 'й', ' '),
            Trigram('ы', 'х', ' '),
            Trigram(' ', 'я', 'к'),
            Trigram('г', 'а', ' '),
            Trigram('в', 'е', 'к'),
            Trigram('е', ' ', 'п'),
            Trigram(' ', 'а', 'д'),
            Trigram('а', ' ', 'н'),
            Trigram(' ', 'н', 'е'),
            Trigram('п', 'р', 'ы'),
            Trigram('а', 'г', 'а'),
            Trigram(' ', 'к', 'о'),
            Trigram('а', ' ', 'п'),
            Trigram(' ', 'з', 'а'),
            Trigram('к', 'о', 'ж'),
            Trigram('о', 'ж', 'н'),
            Trigram('ы', ' ', 'ч'),
            Trigram('б', 'о', 'д'),
            Trigram('д', 'н', 'а'),
            Trigram('ж', 'н', 'ы'),
            Trigram('в', 'а', 'б'),
            Trigram('ц', 'ц', 'а'),
            Trigram('ц', 'а', ' '),
            Trigram(' ', 'ў', ' '),
            Trigram('а', ' ', 'а'),
            Trigram('е', 'к', ' '),
            Trigram('м', 'а', 'е'),
            Trigram('і', ' ', 'п'),
            Trigram('н', 'н', 'е'),
            Trigram('н', 'ы', 'х'),
            Trigram('а', 'с', 'ц'),
            Trigram('а', ' ', 'с'),
            Trigram('п', 'а', 'в'),
            Trigram('б', 'о', ' '),
            Trigram('а', 'м', ' '),
            Trigram('с', 'т', 'а'),
            Trigram(' ', 'с', 'а'),
            Trigram(' ', 'в', 'ы'),
            Trigram('в', 'а', 'н'),
            Trigram('ь', 'н', 'а'),
            Trigram(' ', 'д', 'а'),
            Trigram('а', 'р', 'а'),
            Trigram('д', 'з', 'е'),
            Trigram('о', 'д', 'н'),
            Trigram('г', 'о', ' '),
            Trigram('н', 'а', 'г'),
            Trigram('в', 'і', 'н'),
            Trigram('а', 'ц', 'ь'),
            Trigram('о', 'ў', 'н'),
            Trigram('ц', 'ы', 'я'),
            Trigram('м', 'і', ' '),
            Trigram('т', 'о', ' '),
            Trigram(' ', 'р', 'а'),
            Trigram('і', ' ', 'а'),
            Trigram('т', 'в', 'а'),
            Trigram(' ', 'а', 'с'),
            Trigram('с', 'т', 'в'),
            Trigram('л', 'е', 'н'),
            Trigram('а', 'в', 'і'),
            Trigram('а', 'д', ' '),
            Trigram('і', ' ', 'с'),
            Trigram('е', 'н', 'н'),
            Trigram('і', ' ', 'н'),
            Trigram('а', 'л', 'ь'),
            Trigram('н', 'а', 'й'),
            Trigram('а', 'в', 'о'),
            Trigram('р', 'а', 'ц'),
            Trigram('а', 'р', 'о'),
            Trigram('ц', 'і', ' '),
            Trigram('с', 'ц', 'і'),
            Trigram('п', 'а', 'д'),
            Trigram('а', 'м', 'а'),
            Trigram(' ', 'б', 'ы'),
            Trigram(' ', 'я', 'г'),
            Trigram('я', 'г', 'о'),
            Trigram('к', ' ', 'м'),
            Trigram('і', 'х', ' '),
            Trigram('р', 'ы', 'м'),
            Trigram('ы', 'м', ' '),
            Trigram('э', 'н', 'н'),
            Trigram('ш', 'т', 'о'),
            Trigram('і', ' ', 'і'),
            Trigram('р', 'о', 'д'),
            Trigram(' ', 'т', 'а'),
            Trigram('н', 'а', 'н'),
            Trigram(' ', 'д', 'з'),
            Trigram('н', 'і', ' '),
            Trigram('я', ' ', 'а'),
            Trigram('г', 'э', 'т'),
            Trigram('н', 'а', 'с'),
            Trigram('а', 'н', 'а'),
            Trigram(' ', 'г', 'э'),
            Trigram('і', 'н', 'н'),
            Trigram('а', ' ', 'б'),
            Trigram('ы', 'ц', 'ь'),
            Trigram('д', 'а', ' '),
            Trigram('ы', 'і', ' '),
            Trigram('о', 'ў', ' '),
            Trigram('ч', 'ы', 'н'),
            Trigram(' ', 'ш', 'т'),
            Trigram('а', ' ', 'ў'),
            Trigram('ц', 'ы', 'і'),
            Trigram('я', 'к', 'і'),
            Trigram('д', 'з', 'я'),
            Trigram('а', ' ', 'і'),
            Trigram('а', 'г', 'у'),
            Trigram('я', ' ', 'п'),
            Trigram('н', 'ы', 'м'),
            Trigram('н', 'а', 'ц'),
            Trigram(' ', 'у', ' '),
            Trigram(' ', 'ў', 'с'),
            Trigram('ы', 'я', ' '),
            Trigram('ь', 'н', 'ы'),
            Trigram('о', 'л', 'ь'),
            Trigram('н', 'а', 'р'),
            Trigram('ў', 'н', 'а'),
            Trigram('х', ' ', 'п'),
            Trigram('і', ' ', 'д'),
            Trigram('ў', ' ', 'і'),
            Trigram(' ', 'г', 'р'),
            Trigram('а', 'м', 'і'),
            Trigram('ы', 'м', 'і'),
            Trigram('а', 'х', ' '),
            Trigram(' ', 'у', 'с'),
            Trigram('а', 'д', 'з'),
            Trigram(' ', 'н', 'і'),
            Trigram('э', 'т', 'а'),
            Trigram('л', 'я', ' '),
            Trigram('в', 'о', 'ў'),
            Trigram('ы', 'м', 'а'),
            Trigram('р', 'а', 'д'),
            Trigram('ы', ' ', 'п'),
            Trigram('з', 'н', 'а'),
            Trigram('ч', 'э', 'н'),
            Trigram('н', 'е', 'н'),
            Trigram('а', 'б', 'а'),
            Trigram(' ', 'к', 'а'),
            Trigram('ў', 'л', 'е'),
            Trigram('і', 'н', 'а'),
            Trigram('б', 'ы', 'ц'),
            Trigram('х', 'о', 'д'),
            Trigram(' ', 'і', 'н'),
            Trigram('о', ' ', 'п'),
            Trigram(' ', 'с', 'т'),
            Trigram('е', 'р', 'а'),
            Trigram('у', 'л', 'ь'),
            Trigram('а', 'ў', ' '),
            Trigram('а', 'с', 'н'),
            Trigram('с', 'а', 'м'),
            Trigram('р', 'а', 'м'),
            Trigram('р', 'ы', ' '),
            Trigram(' ', 'с', 'у'),
            Trigram('н', 'а', 'л'),
            Trigram('д', 'у', ' '),
            Trigram('ь', ' ', 'с'),
            Trigram('ч', 'ы', ' '),
            Trigram('к', 'л', 'а'),
            Trigram('а', 'н', 'ы'),
            Trigram('ж', 'н', 'а'),
            Trigram('і', ' ', 'р'),
            Trigram('п', 'е', 'р'),
            Trigram('і', ' ', 'з'),
            Trigram('ь', ' ', 'у'),
            Trigram('м', 'а', 'ю'),
            Trigram('а', 'к', 'о'),
            Trigram('ы', 'ц', 'ц'),
            Trigram('я', 'к', 'о'),
            Trigram('д', 'л', 'я'),
            Trigram('у', 'ю', ' '),
            Trigram('г', 'р', 'а'),
            Trigram('у', 'к', 'а'),
            Trigram('е', ' ', 'і'),
            Trigram('н', 'а', 'е'),
            Trigram('а', 'д', 'с'),
            Trigram('і', ' ', 'ў'),
            Trigram('к', 'а', 'ц'),
            Trigram('ў', 'н', 'ы'),
            Trigram('а', ' ', 'з'),
            Trigram(' ', 'д', 'л'),
            Trigram('я', 'ў', 'л'),
            Trigram('а', ' ', 'р'),
            Trigram('а', 'ю', 'ч'),
            Trigram('ю', 'ч', 'ы'),
            Trigram('о', 'д', 'у'),
            Trigram(' ', 'п', 'е'),
            Trigram(' ', 'р', 'о'),
            Trigram('ы', ' ', 'і'),
            Trigram('в', 'ы', ' '),
            Trigram('і', ' ', 'м'),
            Trigram('а', 'с', 'а'),
            Trigram('е', ' ', 'м'),
            Trigram('а', 'д', 'у'),
            Trigram('х', ' ', 'н'),
            Trigram('о', 'д', 'а'),
            Trigram('а', 'д', 'н'),
            Trigram('н', 'н', 'і'),
            Trigram('к', 'і', ' '),
            Trigram(' ', 'ш', 'л'),
            Trigram('а', 'л', 'е'),
            Trigram('р', 'а', 'з'),
            Trigram('а', 'д', 'а'),
            Trigram('х', ' ', 'і'),
            Trigram('а', 'в', 'я'),
            Trigram('н', 'а', 'в'),
            Trigram('а', 'л', 'і'),
            Trigram('р', 'а', 'б'),
            Trigram('ы', ' ', 'ў'),
            Trigram('н', 'н', 'а'),
            Trigram('м', 'а', 'д'),
            Trigram('р', 'о', 'ў'),
            Trigram('к', 'а', 'н'),
            Trigram('з', 'е', ' '),
            Trigram('д', 'с', 'т'),
            Trigram('ж', 'ы', 'ц'),
            Trigram('а', 'н', 'і'),
            Trigram('н', 'с', 'т'),
            Trigram('з', 'я', 'р'),
            Trigram('р', 'ж', 'а'),
            Trigram('з', 'а', 'к'),
            Trigram('д', 'з', 'і'),
            Trigram('л', 'ю', 'б'),
            Trigram('а', 'ю', 'ц'),
            Trigram('б', 'а', 'р'),
            Trigram('і', 'м', ' '),
            Trigram('е', 'н', 'ы'),
            Trigram('б', 'е', 'с'),
            Trigram('т', 'а', 'н'),
            Trigram('м', ' ', 'п'),
            Trigram('д', 'у', 'к'),
            Trigram('е', ' ', 'а'),
            Trigram('г', 'у', 'л'),
            Trigram('я', ' ', 'ў'),
            Trigram(' ', 'д', 'э'),
            Trigram('в', 'е', ' '),
            Trigram('ж', 'а', 'в'),
            Trigram('а', 'ц', 'ц'),
            Trigram('а', 'х', 'о'),
            Trigram('з', 'а', 'б'),
            Trigram('а', ' ', 'в'),
            Trigram('а', 'в', 'ы'),
            Trigram('г', 'а', 'н'),
            Trigram('о', ' ', 'н'),
            Trigram('в', 'а', 'г'),
            Trigram('я', ' ', 'і'),
            Trigram('ч', 'н', 'а'),
            Trigram('я', ' ', 'я'),
            Trigram('с', 'а', 'ц'),
            Trigram('т', 'а', 'к'),
            Trigram('о', 'д', ' '),
            Trigram('я', 'р', 'ж'),
            Trigram('с', 'о', 'б'),
            Trigram('м', ' ', 'н'),
            Trigram('с', 'е', ' '),
            Trigram('ч', 'а', 'ц'),
            Trigram('н', 'і', 'ч'),
            Trigram('ы', 'я', 'л'),
            Trigram('я', 'л', 'ь'),
            Trigram('ц', 'ц', 'я'),
            Trigram('ь', ' ', 'п'),
            Trigram('о', ' ', 'с'),
            Trigram('в', 'о', 'л'),
            Trigram('д', 'э', 'к'),
            Trigram(' ', 'б', 'е'),
            Trigram('н', 'у', ' '),
            Trigram('о', 'г', 'а'),
            Trigram(' ', 'р', 'э'),
            Trigram('р', 'а', 'с'),
            Trigram('б', 'у', 'д'),
            Trigram('а', ' ', 'т'),
            Trigram('а', 'с', 'о'),
            Trigram('с', 'н', 'о'),
            Trigram('е', 'й', 'н'),
        ],
    ),
    (
        Lang::Bul,
        &[
            Trigram(' ', 'н', 'а'),
            Trigram('н', 'а', ' '),
            Trigram(' ', 'п', 'р'),
            Trigram('т', 'о', ' '),
            Trigram(' ', 'и', ' '),
            Trigram('р', 'а', 'в'),
            Trigram('д', 'а', ' '),
            Trigram('п', 'р', 'а'),
            Trigram(' ', 'д', 'а'),
            Trigram('а', ' ', 'с'),
            Trigram('с', 'т', 'в'),
            Trigram('в', 'а', ' '),
            Trigram('т', 'а', ' '),
            Trigram('а', ' ', 'п'),
            Trigram('и', 'т', 'е'),
            Trigram('н', 'о', ' '),
            Trigram('в', 'о', ' '),
            Trigram('е', 'н', 'и'),
            Trigram('а', ' ', 'н'),
            Trigram('е', ' ', 'н'),
            Trigram(' ', 'з', 'а'),
            Trigram('о', ' ', 'и'),
            Trigram('о', 'т', 'о'),
            Trigram('в', 'а', 'н'),
            Trigram('н', 'е', ' '),
            Trigram(' ', 'в', 'с'),
            Trigram('т', 'е', ' '),
            Trigram('к', 'и', ' '),
            Trigram(' ', 'н', 'е'),
            Trigram('о', ' ', 'н'),
            Trigram('о', 'в', 'е'),
            Trigram(' ', 'п', 'о'),
            Trigram('а', ' ', 'и'),
            Trigram('а', 'в', 'а'),
            Trigram('ч', 'о', 'в'),
            Trigram('н', 'и', ' '),
            Trigram('а', 'н', 'е'),
            Trigram('и', 'я', ' '),
            Trigram(' ', 'ч', 'о'),
            Trigram('а', 'в', 'о'),
            Trigram('и', 'е', ' '),
            Trigram(' ', 'с', 'в'),
            Trigram('е', ' ', 'п'),
            Trigram('а', ' ', 'д'),
            Trigram(' ', 'о', 'б'),
            Trigram('в', 'е', 'к'),
            Trigram('е', 'с', 'т'),
            Trigram('с', 'в', 'о'),
            Trigram(' ', 'и', 'м'),
            Trigram('и', 'м', 'а'),
            Trigram('о', 'с', 'т'),
            Trigram('и', ' ', 'д'),
            Trigram('и', ' ', 'ч'),
            Trigram('а', 'н', 'и'),
            Trigram('и', 'л', 'и'),
            Trigram('в', 'с', 'е'),
            Trigram('л', 'и', ' '),
            Trigram('т', 'в', 'о'),
            Trigram('и', ' ', 'с'),
            Trigram('н', 'и', 'е'),
            Trigram('в', 'о', 'т'),
            Trigram('а', ' ', 'в'),
            Trigram('в', 'а', 'т'),
            Trigram('м', 'а', ' '),
            Trigram(' ', 'р', 'а'),
            Trigram('и', ' ', 'п'),
            Trigram('и', ' ', 'н'),
            Trigram(' ', 'в', ' '),
            Trigram('е', 'к', ' '),
            Trigram('с', 'е', 'к'),
            Trigram('е', 'к', 'и'),
            Trigram('а', ' ', 'о'),
            Trigram(' ', 'и', 'л'),
            Trigram('е', ' ', 'и'),
            Trigram('п', 'р', 'и'),
            Trigram(' ', 'с', 'е'),
            Trigram('о', 'в', 'а'),
            Trigram('е', 'т', 'о'),
            Trigram('а', 'т', 'а'),
            Trigram('в', 'о', 'б'),
            Trigram('о', 'б', 'о'),
            Trigram('б', 'о', 'д'),
            Trigram('а', 'ц', 'и'),
            Trigram('а', 'т', ' '),
            Trigram('п', 'р', 'е'),
            Trigram('о', 'д', 'и'),
            Trigram('к', ' ', 'и'),
            Trigram(' ', 'б', 'ъ'),
            Trigram(' ', 'с', 'ъ'),
            Trigram('р', 'а', 'з'),
            Trigram(' ', 'о', 'с'),
            Trigram('р', 'е', 'д'),
            Trigram(' ', 'к', 'а'),
            Trigram('а', ' ', 'б'),
            Trigram('о', ' ', 'д'),
            Trigram('с', 'е', ' '),
            Trigram(' ', 'к', 'о'),
            Trigram('б', 'ъ', 'д'),
            Trigram('л', 'н', 'о'),
            Trigram('н', 'и', 'я'),
            Trigram('о', ' ', 'п'),
            Trigram(' ', 'о', 'т'),
            Trigram('ъ', 'д', 'е'),
            Trigram('о', ' ', 'в'),
            Trigram('з', 'а', ' '),
            Trigram('я', 'т', 'а'),
            Trigram(' ', 'е', ' '),
            Trigram(' ', 'т', 'р'),
            Trigram('и', ' ', 'и'),
            Trigram('о', ' ', 'с'),
            Trigram('т', 'е', 'л'),
            Trigram('и', ' ', 'в'),
            Trigram('н', 'и', 'т'),
            Trigram('е', ' ', 'с'),
            Trigram('р', 'а', 'н'),
            Trigram(' ', 'д', 'е'),
            Trigram('о', 'т', ' '),
            Trigram('о', 'б', 'щ'),
            Trigram('д', 'е', ' '),
            Trigram('к', 'а', ' '),
            Trigram('б', 'р', 'а'),
            Trigram('е', 'н', ' '),
            Trigram('я', 'в', 'а'),
            Trigram('ц', 'и', 'я'),
            Trigram('п', 'р', 'о'),
            Trigram('а', 'л', 'н'),
            Trigram('и', ' ', 'о'),
            Trigram('и', 'я', 'т'),
            Trigram('с', 'т', ' '),
            Trigram('н', 'о', 'в'),
            Trigram(' ', 'д', 'о'),
            Trigram('е', 'г', 'о'),
            Trigram('к', 'а', 'к'),
            Trigram('а', 'т', 'о'),
            Trigram(' ', 'и', 'з'),
            Trigram('н', 'е', 'г'),
            Trigram('а', ' ', 'т'),
            Trigram('д', 'е', 'н'),
            Trigram('а', ' ', 'к'),
            Trigram('щ', 'е', 'с'),
            Trigram('а', ' ', 'р'),
            Trigram('т', 'р', 'я'),
            Trigram('а', ' ', 'ч'),
            Trigram('р', 'я', 'б'),
            Trigram('о', ' ', 'о'),
            Trigram('в', 'е', 'н'),
            Trigram('я', 'б', 'в'),
            Trigram('б', 'в', 'а'),
            Trigram('д', 'ъ', 'р'),
            Trigram('г', 'о', 'в'),
            Trigram('н', 'а', 'ц'),
            Trigram('е', 'н', 'о'),
            Trigram('т', 'в', 'е'),
            Trigram('ъ', 'р', 'ж'),
            Trigram('е', ' ', 'д'),
            Trigram('н', 'о', 'с'),
            Trigram('р', 'ж', 'а'),
            Trigram('а', ' ', 'з'),
            Trigram('в', 'и', 'т'),
            Trigram('з', 'и', ' '),
            Trigram('а', 'к', 'в'),
            Trigram('л', 'е', 'н'),
            Trigram(' ', 'т', 'а'),
            Trigram('е', 'ж', 'д'),
            Trigram('и', ' ', 'з'),
            Trigram('р', 'о', 'д'),
            Trigram('е', ' ', 'о'),
            Trigram('о', 'б', 'р'),
            Trigram('н', 'о', 'т'),
            Trigram(' ', 'н', 'и'),
            Trigram(' ', 'с', ' '),
            Trigram('т', ' ', 'с'),
            Trigram('н', 'а', 'р'),
            Trigram('о', ' ', 'т'),
            Trigram('о', 'н', 'а'),
            Trigram('е', 'з', ' '),
            Trigram('й', 'с', 'т'),
            Trigram('к', 'а', 'т'),
            Trigram('и', 'ч', 'е'),
            Trigram(' ', 'б', 'е'),
            Trigram('ж', 'а', 'в'),
            Trigram('е', ' ', 'т'),
            Trigram('е', ' ', 'в'),
            Trigram('т', 'в', 'а'),
            Trigram('з', 'а', 'к'),
            Trigram('а', 'р', 'о'),
            Trigram('к', 'о', 'й'),
            Trigram('о', 'с', 'н'),
            Trigram(' ', 'л', 'и'),
            Trigram('у', 'в', 'а'),
            Trigram('а', 'в', 'н'),
            Trigram('е', 'й', 'с'),
            Trigram('с', 'н', 'о'),
            Trigram('р', 'е', 'с'),
            Trigram('п', 'о', 'л'),
            Trigram('н', 'е', 'н'),
            Trigram('в', 'н', 'и'),
            Trigram('б', 'е', 'з'),
            Trigram('р', 'и', ' '),
            Trigram('с', 'т', 'р'),
            Trigram(' ', 'с', 'т'),
            Trigram('с', 'т', 'о'),
            Trigram('п', 'о', 'д'),
            Trigram('ч', 'к', 'и'),
            Trigram('в', 'и', 'д'),
            Trigram('г', 'а', 'н'),
            Trigram('с', 'и', ' '),
            Trigram('д', 'и', ' '),
            Trigram('и', ' ', 'к'),
            Trigram('н', 'с', 'т'),
            Trigram(' ', 'т', 'е'),
            Trigram('а', ' ', 'е'),
            Trigram('в', 'с', 'и'),
            Trigram('е', 'о', 'б'),
            Trigram(' ', 'д', 'ъ'),
            Trigram('с', 'и', 'ч'),
            Trigram('и', 'ч', 'к'),
            Trigram('е', 'д', 'в'),
            Trigram('ж', 'е', 'н'),
            Trigram('н', 'и', 'к'),
            Trigram('о', 'д', 'а'),
            Trigram('т', ' ', 'н'),
            Trigram('о', ' ', 'р'),
            Trigram('а', 'к', 'а'),
            Trigram('е', 'л', 'и'),
            Trigram('о', 'д', 'н'),
            Trigram('е', 'л', 'н'),
            Trigram('л', 'и', 'ч'),
            Trigram(' ', 'ч', 'е'),
            Trigram('ч', 'е', 'с'),
            Trigram('б', 'щ', 'е'),
            Trigram(' ', 'р', 'е'),
            Trigram('и', ' ', 'м'),
            Trigram(' ', 'с', 'р'),
            Trigram('с', 'р', 'е'),
            Trigram('и', ' ', 'р'),
            Trigram('с', 'а', ' '),
            Trigram('л', 'н', 'и'),
            Trigram(' ', 'с', 'и'),
            Trigram('д', 'в', 'и'),
            Trigram('и', 'ч', 'н'),
            Trigram('ж', 'д', 'а'),
            Trigram(' ', 'к', 'ъ'),
            Trigram('о', 'е', 'т'),
            Trigram('и', 'р', 'а'),
            Trigram('я', ' ', 'н'),
            Trigram('д', 'е', 'й'),
            Trigram(' ', 'м', 'е'),
            Trigram('е', 'д', 'и'),
            Trigram('д', 'р', 'у'),
            Trigram('х', 'о', 'д'),
            Trigram('е', 'м', 'е'),
            Trigram('к', 'р', 'и'),
            Trigram('ч', 'е', ' '),
            Trigram('д', 'о', 'с'),
            Trigram('с', 'т', 'а'),
            Trigram('г', 'р', 'а'),
            Trigram(' ', 'т', 'о'),
            Trigram('о', 'й', ' '),
            Trigram('т', 'ъ', 'п'),
            Trigram('в', 'ъ', 'з'),
            Trigram('и', 'к', 'о'),
            Trigram('и', ' ', 'у'),
            Trigram('н', 'е', 'т'),
            Trigram(' ', 'с', 'о'),
            Trigram('а', 'в', 'и'),
            Trigram('т', 'о', 'й'),
            Trigram('е', 'л', 'с'),
            Trigram('м', 'е', 'ж'),
            Trigram('ч', 'и', 'т'),
            Trigram('и', 'т', 'а'),
            Trigram('щ', 'о', ' '),
            Trigram('ъ', 'м', ' '),
            Trigram('а', 'з', 'о'),
            Trigram('з', 'о', 'в'),
            Trigram('н', 'и', 'ч'),
            Trigram('н', 'а', 'л'),
            Trigram('д', 'н', 'о'),
            Trigram(' ', 'м', 'о'),
            Trigram('и', 'н', 'е'),
            Trigram('а', ' ', 'у'),
            Trigram('т', 'н', 'о'),
            Trigram('т', 'а', 'з'),
            Trigram('к', 'о', 'н'),
            Trigram('л', 'и', 'т'),
            Trigram('а', 'н', ' '),
            Trigram('к', 'л', 'ю'),
            Trigram('л', 'ю', 'ч'),
            Trigram('п', 'о', 'с'),
            Trigram('т', 'в', 'и'),
            Trigram('а', ' ', 'м'),
            Trigram('й', ' ', 'н'),
            Trigram('т', ' ', 'и'),
            Trigram('и', 'з', 'в'),
            Trigram('р', 'е', 'з'),
            Trigram('а', 'з', 'и'),
            Trigram('р', 'а', ' '),
            Trigram('о', 'я', 'т'),
            Trigram('н', 'е', 'о'),
            Trigram('ч', 'р', 'е'),
        ],
    ),
    (
        Lang::Mkd,
        &[
            Trigram(' ', 'н', 'а'),
            Trigram('н', 'а', ' '),
            Trigram(' ', 'п', 'р'),
            Trigram(' ', 'и', ' '),
            Trigram('в', 'о', ' '),
            Trigram(' ', 'с', 'е'),
            Trigram('т', 'о', ' '),
            Trigram('и', 'т', 'е'),
            Trigram('т', 'е', ' '),
            Trigram('р', 'а', 'в'),
            Trigram('т', 'а', ' '),
            Trigram('а', ' ', 'с'),
            Trigram('п', 'р', 'а'),
            Trigram('у', 'в', 'а'),
            Trigram('д', 'а', ' '),
            Trigram(' ', 'д', 'а'),
            Trigram(' ', 'н', 'е'),
            Trigram('в', 'а', ' '),
            Trigram('а', ' ', 'п'),
            Trigram('а', ' ', 'н'),
            Trigram('и', ' ', 'с'),
            Trigram('а', 'т', 'а'),
            Trigram('о', ' ', 'н'),
            Trigram('е', 'к', 'о'),
            Trigram('а', ' ', 'и'),
            Trigram(' ', 'п', 'о'),
            Trigram('н', 'о', ' '),
            Trigram('о', 'ј', ' '),
            Trigram('к', 'о', 'ј'),
            Trigram(' ', 'с', 'о'),
            Trigram(' ', 'з', 'а'),
            Trigram(' ', 'в', 'о'),
            Trigram('с', 'т', 'в'),
            Trigram('ј', 'а', ' '),
            Trigram('њ', 'е', ' '),
            Trigram('а', 'њ', 'е'),
            Trigram('а', 'в', 'о'),
            Trigram('н', 'и', ' '),
            Trigram(' ', 'и', 'м'),
            Trigram('о', 'т', ' '),
            Trigram('е', ' ', 'п'),
            Trigram('е', ' ', 'н'),
            Trigram('м', 'а', ' '),
            Trigram('а', 'т', ' '),
            Trigram('в', 'а', 'њ'),
            Trigram('о', 'с', 'т'),
            Trigram('а', ' ', 'д'),
            Trigram('о', ' ', 'с'),
            Trigram('е', ' ', 'и'),
            Trigram('с', 'е', ' '),
            Trigram('о', 'в', 'а'),
            Trigram('и', 'ј', 'а'),
            Trigram('и', ' ', 'п'),
            Trigram(' ', 'с', 'л'),
            Trigram('а', ' ', 'о'),
            Trigram('и', 'м', 'а'),
            Trigram('с', 'е', 'к'),
            Trigram('с', 'л', 'о'),
            Trigram('о', 'т', 'о'),
            Trigram('л', 'и', ' '),
            Trigram('о', ' ', 'д'),
            Trigram('а', 'в', 'а'),
            Trigram('о', 'б', 'о'),
            Trigram('о', ' ', 'и'),
            Trigram(' ', 'и', 'л'),
            Trigram('и', 'л', 'и'),
            Trigram(' ', 'б', 'и'),
            Trigram('б', 'о', 'д'),
            Trigram('и', ' ', 'н'),
            Trigram('л', 'о', 'б'),
            Trigram(' ', 'о', 'д'),
            Trigram('б', 'и', 'д'),
            Trigram('р', 'е', 'д'),
            Trigram('е', 'н', ' '),
            Trigram('п', 'р', 'и'),
            Trigram('в', 'о', 'т'),
            Trigram('и', 'д', 'е'),
            Trigram('а', ' ', 'в'),
            Trigram('с', 'т', 'а'),
            Trigram(' ', 'о', 'б'),
            Trigram('и', ' ', 'и'),
            Trigram('и', ' ', 'д'),
            Trigram('п', 'р', 'е'),
            Trigram('н', 'о', 'с'),
            Trigram('с', 'т', ' '),
            Trigram('е', ' ', 'с'),
            Trigram(' ', 'н', 'и'),
            Trigram(' ', 'ќ', 'е'),
            Trigram('о', 'в', 'е'),
            Trigram('а', 'а', 'т'),
            Trigram('а', 'ц', 'и'),
            Trigram('ќ', 'е', ' '),
            Trigram('с', 'о', ' '),
            Trigram('о', 'в', 'и'),
            Trigram('п', 'р', 'о'),
            Trigram('ј', ' ', 'и'),
            Trigram('т', 'в', 'о'),
            Trigram(' ', 'р', 'а'),
            Trigram('е', 'с', 'т'),
            Trigram('ш', 'т', 'о'),
            Trigram(' ', 'д', 'е'),
            Trigram('т', ' ', 'и'),
            Trigram('а', 'к', 'в'),
            Trigram(' ', 'к', 'о'),
            Trigram('р', 'а', 'з'),
            Trigram('г', 'о', 'в'),
            Trigram('е', 'г', 'о'),
            Trigram('н', 'е', 'г'),
            Trigram('а', 'н', 'и'),
            Trigram('е', 'д', 'н'),
            Trigram('а', 'к', 'о'),
            Trigram('ц', 'и', 'ј'),
            Trigram('б', 'р', 'а'),
            Trigram('о', 'д', ' '),
            Trigram('а', ' ', 'з'),
            Trigram('е', ' ', 'б'),
            Trigram('и', ' ', 'о'),
            Trigram('а', ' ', 'б'),
            Trigram('о', ' ', 'п'),
            Trigram('в', 'а', 'т'),
            Trigram(' ', 'е', ' '),
            Trigram(' ', 'д', 'р'),
            Trigram('е', 'т', 'о'),
            Trigram('в', 'а', 'а'),
            Trigram('к', 'а', 'к'),
            Trigram('д', 'и', ' '),
            Trigram('т', ' ', 'с'),
            Trigram(' ', 'к', 'а'),
            Trigram(' ', 'ч', 'о'),
            Trigram('е', 'н', 'и'),
            Trigram('а', 'л', 'н'),
            Trigram('о', 'д', 'н'),
            Trigram('е', 'н', 'о'),
            Trigram(' ', 'с', 'и'),
            Trigram('ч', 'о', 'в'),
            Trigram(' ', 'ш', 'т'),
            Trigram('а', ' ', 'г'),
            Trigram('а', ' ', 'е'),
            Trigram('в', 'е', 'н'),
            Trigram('н', 'и', 'т'),
            Trigram(' ', 'ј', 'а'),
            Trigram('д', 'е', ' '),
            Trigram('о', 'д', 'и'),
            Trigram('е', ' ', 'о'),
            Trigram('р', 'а', 'н'),
            Trigram('и', ' ', 'з'),
            Trigram('с', 'н', 'о'),
            Trigram('н', 'о', 'т'),
            Trigram(' ', 'е', 'д'),
            Trigram('т', 'и', 'т'),
            Trigram('л', 'н', 'о'),
            Trigram('в', 'и', ' '),
            Trigram('ј', 'а', 'т'),
            Trigram('д', 'е', 'н'),
            Trigram('т', ' ', 'н'),
            Trigram('н', 'а', 'ц'),
            Trigram(' ', 'о', 'п'),
            Trigram(' ', 'д', 'о'),
            Trigram(' ', 'о', 'с'),
            Trigram('и', ' ', 'в'),
            Trigram('о', 'с', 'н'),
            Trigram('к', 'о', 'н'),
            Trigram('д', 'н', 'а'),
            Trigram('е', ' ', 'д'),
            Trigram(' ', 'с', 'т'),
            Trigram('в', 'е', 'к'),
            Trigram('о', ' ', 'о'),
            Trigram('р', 'о', 'д'),
            Trigram('с', 'т', 'о'),
            Trigram('с', 'и', 'т'),
            Trigram('е', 'м', 'е'),
            Trigram('а', 'р', 'а'),
            Trigram('д', 'н', 'о'),
            Trigram('о', 'б', 'р'),
            Trigram('ј', ' ', 'н'),
            Trigram('п', 'ш', 'т'),
            Trigram('е', 'д', 'и'),
            Trigram('о', 'п', 'ш'),
            Trigram('з', 'а', ' '),
            Trigram('н', 'и', 'е'),
            Trigram('а', 'р', 'о'),
            Trigram('н', 'о', 'в'),
            Trigram('а', ' ', 'к'),
            Trigram('в', 'н', 'и'),
            Trigram('д', 'р', 'у'),
            Trigram(' ', 'о', 'в'),
            Trigram('т', 'в', 'е'),
            Trigram('ж', 'и', 'в'),
            Trigram('ш', 'т', 'е'),
            Trigram('д', ' ', 'н'),
            Trigram('и', 'е', ' '),
            Trigram(' ', 'м', 'е'),
            Trigram('е', 'д', ' '),
            Trigram('и', 'о', 'т'),
            Trigram('и', ' ', 'м'),
            Trigram('о', ' ', 'в'),
            Trigram('ќ', 'и', ' '),
            Trigram('д', 'а', 'т'),
            Trigram('ш', 'т', 'и'),
            Trigram('ј', 'ќ', 'и'),
            Trigram('б', 'е', 'з'),
            Trigram('б', 'е', 'д'),
            Trigram('к', 'и', ' '),
            Trigram('к', 'о', 'в'),
            Trigram('к', 'о', ' '),
            Trigram('а', ' ', 'р'),
            Trigram('н', 'а', 'р'),
            Trigram('ч', 'н', 'о'),
            Trigram('д', 'н', 'и'),
            Trigram(' ', 'в', 'р'),
            Trigram('е', 'л', 'и'),
            Trigram('н', 'а', 'к'),
            Trigram('а', 'ш', 'т'),
            Trigram('и', 'ч', 'н'),
            Trigram('к', 'а', ' '),
            Trigram('е', 'м', 'а'),
            Trigram('ц', 'е', 'л'),
            Trigram('з', 'е', 'м'),
            Trigram('е', 'д', 'у'),
            Trigram('ч', 'у', 'в'),
            Trigram('т', 'е', 'с'),
            Trigram('д', 'р', 'ж'),
            Trigram('н', 'и', 'к'),
            Trigram('т', ' ', 'п'),
            Trigram('л', 'у', 'ч'),
            Trigram('а', 'а', ' '),
            Trigram('д', 'е', 'ј'),
            Trigram('н', 'с', 'т'),
            Trigram('н', 'е', ' '),
            Trigram('а', ' ', 'ч'),
            Trigram('р', 'у', 'г'),
            Trigram('о', 'д', 'а'),
            Trigram('и', 'в', 'н'),
            Trigram(' ', 'ц', 'е'),
            Trigram('н', 'и', 'в'),
            Trigram('д', 'и', 'н'),
            Trigram('а', 'в', 'н'),
            Trigram(' ', 'з', 'е'),
            Trigram('н', 'и', 'о'),
            Trigram('п', 'о', 'р'),
            Trigram('а', ' ', 'м'),
            Trigram('з', 'а', 'ш'),
            Trigram('л', 'а', 'с'),
            Trigram('в', 'и', 'т'),
            Trigram('д', 'е', 'к'),
            Trigram('г', 'о', ' '),
            Trigram('и', 'н', 'е'),
            Trigram('е', 'л', 'о'),
            Trigram('н', 'е', 'т'),
            Trigram('е', 'з', ' '),
            Trigram('т', 'е', 'н'),
            Trigram(' ', 'р', 'е'),
            Trigram(' ', 'и', 'з'),
            Trigram('п', 'о', 'д'),
            Trigram('р', 'а', 'б'),
            Trigram('а', 'б', 'о'),
            Trigram('б', 'о', 'т'),
            Trigram('д', 'у', 'в'),
            Trigram('н', 'у', 'в'),
            Trigram(' ', 'б', 'е'),
            Trigram('е', 'њ', 'е'),
            Trigram('е', 'д', 'е'),
            Trigram('о', 'н', ' '),
            Trigram('њ', 'е', 'т'),
            Trigram('з', 'о', 'в'),
            Trigram('и', 'т', 'у'),
            Trigram('в', 'а', 'н'),
            Trigram('н', ' ', 'и'),
            Trigram('а', 'ѓ', 'а'),
            Trigram('е', ' ', 'в'),
            Trigram('е', 'ѓ', 'у'),
            Trigram('р', 'е', 'м'),
            Trigram('д', 'е', 'л'),
            Trigram('о', ' ', 'к'),
            Trigram('к', 'о', 'т'),
            Trigram('и', 'м', ' '),
            Trigram(' ', 'ж', 'и'),
            Trigram('д', 'о', 'с'),
            Trigram('в', 'р', 'е'),
            Trigram('м', 'е', 'ѓ'),
            Trigram('о', 'л', 'н'),
            Trigram('н', 'а', 'п'),
            Trigram(' ', 'г', 'о'),
            Trigram('е', 'м', 'ј'),
            Trigram('к', 'р', 'и'),
            Trigram('у', 'н', 'а'),
            Trigram('н', 'е', 'м'),
            Trigram('о', 'ј', 'а'),
            Trigram(' ', 'с', 'у'),
            Trigram('и', 'т', 'а'),
            Trigram('а', 'з', 'о'),
            Trigram('л', 'и', 'т'),
            Trigram('т', 'о', 'р'),
            Trigram('и', 'н', 'с'),
            Trigram('о', 'р', 'а'),
            Trigram('о', 'г', 'л'),
            Trigram('и', 'п', 'а'),
            Trigram('п', 'о', 'т'),
            Trigram('с', 'л', 'у'),
            Trigram('к', 'в', 'и'),
        ],
    ),
];

/// Languages for script Arabic
pub static ARABIC_LANGS: LangProfileList = &[
    (
        Lang::Ara,
        &[
            Trigram(' ', 'ا', 'ل'),
            Trigram('ي', 'ة', ' '),
            Trigram(' ', 'ف', 'ي'),
            Trigram('ا', 'ل', 'ح'),
            Trigram('ف', 'ي', ' '),
            Trigram(' ', 'و', 'ا'),
            Trigram('و', 'ا', 'ل'),
            Trigram(' ', 'أ', 'و'),
            Trigram('ة', ' ', 'ا'),
            Trigram('أ', 'و', ' '),
            Trigram('ا', 'ل', 'م'),
            Trigram('ا', 'ل', 'ت'),
            Trigram('ل', 'ح', 'ق'),
            Trigram('ح', 'ق', ' '),
            Trigram('ل', 'ى', ' '),
            Trigram('ك', 'ل', ' '),
            Trigram('ا', 'ن', ' '),
            Trigram('ة', ' ', 'و'),
            Trigram('ا', 'ل', 'أ'),
            Trigram(' ', 'ل', 'ك'),
            Trigram('ل', 'ك', 'ل'),
            Trigram('ن', ' ', 'ا'),
            Trigram('ه', 'ا', ' '),
            Trigram('ق', ' ', 'ف'),
            Trigram('ا', 'ت', ' '),
            Trigram('م', 'ة', ' '),
            Trigram('و', 'ن', ' '),
            Trigram('أ', 'ن', ' '),
            Trigram('م', 'ا', ' '),
            Trigram('ا', 'ء', ' '),
            Trigram('ت', 'ه', ' '),
            Trigram('و', ' ', 'ا'),
            Trigram('ا', 'ل', 'ع'),
            Trigram('ي', ' ', 'ا'),
            Trigram('ش', 'خ', 'ص'),
            Trigram('ي', ' ', 'أ'),
            Trigram(' ', 'أ', 'ن'),
            Trigram('ا', 'ل', 'إ'),
            Trigram('م', ' ', 'ا'),
            Trigram('ح', 'ر', 'ي'),
            Trigram(' ', 'ع', 'ل'),
            Trigram('ة', ' ', 'ل'),
            Trigram('م', 'ن', ' '),
            Trigram('ا', 'ل', 'ا'),
            Trigram('ح', 'ق', 'و'),
            Trigram('ع', 'ل', 'ى'),
            Trigram('ق', 'و', 'ق'),
            Trigram('ت', ' ', 'ا'),
            Trigram('أ', 'ي', ' '),
            Trigram('ر', 'د', ' '),
            Trigram(' ', 'ش', 'خ'),
            Trigram(' ', 'ل', 'ل'),
            Trigram(' ', 'أ', 'ي'),
            Trigram('ق', ' ', 'ا'),
            Trigram('ل', 'ا', ' '),
            Trigram('ف', 'ر', 'د'),
            Trigram('ر', 'ي', 'ة'),
            Trigram(' ', 'و', 'ل'),
            Trigram(' ', 'م', 'ن'),
            Trigram('د', ' ', 'ا'),
            Trigram(' ', 'ك', 'ا'),
            Trigram(' ', 'إ', 'ل'),
            Trigram('خ', 'ص', ' '),
            Trigram('و', 'ق', ' '),
            Trigram('ا', ' ', 'ا'),
            Trigram('ة', ' ', 'أ'),
            Trigram('ا', ' ', 'ي'),
            Trigram('ل', ' ', 'ف'),
            Trigram('ه', ' ', 'ا'),
            Trigram('ن', 'س', 'ا'),
            Trigram('ج', 'ت', 'م'),
            Trigram('ن', ' ', 'ي'),
            Trigram('ا', 'م', 'ة'),
            Trigram('ك', 'ا', 'ن'),
            Trigram('د', 'ة', ' '),
            Trigram(' ', 'ح', 'ق'),
            Trigram('ا', 'م', ' '),
            Trigram('ا', 'ل', 'ق'),
            Trigram('ة', ' ', 'م'),
            Trigram(' ', 'ف', 'ر'),
            Trigram('ا', 'ي', 'ة'),
            Trigram('س', 'ا', 'ن'),
            Trigram('ل', ' ', 'ش'),
            Trigram('ي', 'ن', ' '),
            Trigram('ن', ' ', 'ت'),
            Trigram('إ', 'ن', 'س'),
            Trigram('ا', ' ', 'ل'),
            Trigram(' ', 'ل', 'ا'),
            Trigram('ذ', 'ا', ' '),
            Trigram('ه', 'ذ', 'ا'),
            Trigram('ن', ' ', 'أ'),
            Trigram('ل', 'ة', ' '),
            Trigram('ي', ' ', 'ح'),
            Trigram(' ', 'د', 'و'),
            Trigram('ه', ' ', 'ل'),
            Trigram('ل', 'ك', ' '),
            Trigram('ت', 'ر', 'ا'),
            Trigram('ل', 'ت', 'ع'),
            Trigram('ا', 'ً', ' '),
            Trigram('ل', 'ه', ' '),
            Trigram('إ', 'ل', 'ى'),
            Trigram(' ', 'ع', 'ن'),
            Trigram('ى', ' ', 'ا'),
            Trigram('ه', ' ', 'و'),
            Trigram('ع', ' ', 'ا'),
            Trigram('م', 'ا', 'ع'),
            Trigram('د', ' ', 'أ'),
            Trigram('ا', 'س', 'ي'),
            Trigram(' ', 'ح', 'ر'),
            Trigram('ة', ' ', 'ع'),
            Trigram('م', 'ع', ' '),
            Trigram('ا', 'ل', 'د'),
            Trigram('ن', 'و', 'ن'),
            Trigram(' ', 'ب', 'ا'),
            Trigram('ل', 'ح', 'ر'),
            Trigram('ل', 'ع', 'ا'),
            Trigram('ن', ' ', 'و'),
            Trigram('،', ' ', 'و'),
            Trigram('ي', 'ا', 'ت'),
            Trigram('ي', ' ', 'ت'),
            Trigram('ا', 'ل', 'ج'),
            Trigram(' ', 'ه', 'ذ'),
            Trigram('ي', 'ر', ' '),
            Trigram('ب', 'ا', 'ل'),
            Trigram('د', 'و', 'ل'),
            Trigram('ل', 'إ', 'ن'),
            Trigram('ع', 'ي', 'ة'),
            Trigram('ا', 'ل', 'ف'),
            Trigram('ص', ' ', 'ا'),
            Trigram(' ', 'و', 'ي'),
            Trigram('ا', 'ل', 'و'),
            Trigram('ل', 'أ', 'س'),
            Trigram(' ', 'إ', 'ن'),
            Trigram('أ', 'س', 'ا'),
            Trigram('س', 'ا', 'س'),
            Trigram('م', 'ا', 'ي'),
            Trigram('ح', 'م', 'ا'),
            Trigram('ر', 'ا', 'م'),
            Trigram('س', 'ي', 'ة'),
            Trigram('ا', 'ن', 'و'),
            Trigram('م', 'ل', ' '),
            Trigram('ي', ' ', 'و'),
            Trigram('ع', 'ا', 'م'),
            Trigram('ا', ' ', 'و'),
            Trigram('ت', 'م', 'ا'),
            Trigram(' ', 'م', 'ت'),
            Trigram('ة', ' ', 'ت'),
            Trigram('ع', 'ل', 'ي'),
            Trigram('ع', ' ', 'ب'),
            Trigram('ك', ' ', 'ا'),
            Trigram(' ', 'ل', 'ه'),
            Trigram('ة', ' ', 'ف'),
            Trigram('ق', 'ا', 'ن'),
            Trigram('ى', ' ', 'أ'),
            Trigram('و', 'ل', ' '),
            Trigram('ه', 'م', ' '),
            Trigram('ا', 'ل', 'ب'),
            Trigram('ة', ' ', 'ب'),
            Trigram('س', 'ا', 'و'),
            Trigram('ل', 'ق', 'ا'),
            Trigram('ا', 'ل', 'ر'),
            Trigram('ل', 'ج', 'م'),
            Trigram('ا', ' ', 'ك'),
            Trigram('ت', 'م', 'ت'),
            Trigram('ل', 'ي', 'ه'),
            Trigram('ل', 'ت', 'م'),
            Trigram('ل', 'م', 'ت'),
            Trigram('ا', 'ن', 'ت'),
            Trigram(' ', 'ق', 'د'),
            Trigram('ا', 'د', ' '),
            Trigram('ه', ' ', 'أ'),
            Trigram(' ', 'ي', 'ج'),
            Trigram('ر', 'ي', 'ا'),
            Trigram('ق', ' ', 'و'),
            Trigram('ل', ' ', 'ا'),
            Trigram('ا', ' ', 'ب'),
            Trigram('ا', 'ل', ' '),
            Trigram('ي', 'ه', ' '),
            Trigram('ا', 'ع', 'ي'),
            Trigram('ل', 'د', 'و'),
            Trigram('ل', ' ', 'و'),
            Trigram('ل', 'إ', 'ع'),
            Trigram('ل', 'م', 'ي'),
            Trigram('ل', 'م', 'ج'),
            Trigram('ل', 'أ', 'م'),
            Trigram('ت', 'ع', ' '),
            Trigram('د', 'م', ' '),
            Trigram('ت', 'س', 'ا'),
            Trigram('ع', 'م', 'ل'),
            Trigram('ا', 'ت', 'ه'),
            Trigram('ل', 'ا', 'د'),
            Trigram('ر', 'ة', ' '),
            Trigram('ا', 'ة', ' '),
            Trigram('غ', 'ي', 'ر'),
            Trigram('ق', 'د', 'م'),
            Trigram('و', 'ز', ' '),
            Trigram('ج', 'و', 'ز'),
            Trigram('ي', 'ج', 'و'),
            Trigram('ع', 'ا', 'ل'),
            Trigram('ل', 'ا', 'ن'),
            Trigram('م', 'ت', 'ع'),
            Trigram('م', 'ا', 'ن'),
            Trigram('ف', 'ي', 'ه'),
            Trigram('ا', 'ج', 'ت'),
            Trigram('م', ' ', 'و'),
            Trigram('ي', 'د', ' '),
            Trigram('ت', 'ع', 'ل'),
            Trigram('ن', ' ', 'ل'),
            Trigram('ر', ' ', 'ا'),
            Trigram(' ', 'ي', 'ع'),
            Trigram(' ', 'ك', 'ل'),
            Trigram('م', 'م', ' '),
            Trigram('م', 'ج', 'ت'),
            Trigram('ت', 'م', 'ع'),
            Trigram('د', 'و', 'ن'),
            Trigram(' ', 'م', 'ع'),
            Trigram('ت', 'م', 'ي'),
            Trigram('ذ', 'ل', 'ك'),
            Trigram('ك', 'ر', 'ا'),
            Trigram('ي', 'ه', 'ا'),
            Trigram(' ', 'م', 'س'),
            Trigram('م', 'ي', 'ع'),
            Trigram('إ', 'ع', 'ل'),
            Trigram('ع', 'ل', 'ا'),
            Trigram(' ', 'ت', 'م'),
            Trigram(' ', 'ع', 'ا'),
            Trigram('م', 'ل', 'ا'),
            Trigram('ا', 'ع', 'ا'),
            Trigram('ل', 'ا', 'ج'),
            Trigram('ن', 'ي', ' '),
            Trigram('ل', 'ي', 'م'),
            Trigram('م', 'ت', 'س'),
            Trigram('ي', 'ي', 'ز'),
            Trigram('ي', 'م', ' '),
            Trigram('ا', 'ع', 'ت'),
            Trigram('ا', 'ل', 'ش'),
            Trigram(' ', 'ت', 'ع'),
            Trigram('م', 'ي', 'ي'),
            Trigram('ع', 'ن', ' '),
            Trigram('ت', 'ن', 'ا'),
            Trigram(' ', 'ب', 'ح'),
            Trigram('ل', 'م', 'ا'),
            Trigram('ي', ' ', 'ي'),
            Trigram('ي', 'ز', ' '),
            Trigram('و', 'د', ' '),
            Trigram('أ', 'م', 'م'),
            Trigram('ل', 'ا', 'ت'),
            Trigram('أ', 'س', 'ر'),
            Trigram('ش', 'ت', 'ر'),
            Trigram('ت', 'ي', ' '),
            Trigram(' ', 'ج', 'م'),
            Trigram('ه', ' ', 'ع'),
            Trigram('ر', ' ', 'و'),
            Trigram('ي', ' ', 'إ'),
            Trigram('ت', 'ح', 'د'),
            Trigram('ح', 'د', 'ة'),
            Trigram(' ', 'أ', 'س'),
            Trigram('ع', 'ة', ' '),
            Trigram('ي', ' ', 'م'),
            Trigram('ة', '،', ' '),
            Trigram('م', 'ع', 'ي'),
            Trigram('ن', ' ', 'م'),
            Trigram('ل', 'م', 'س'),
            Trigram('م', ' ', 'ب'),
            Trigram('ا', 'ق', ' '),
            Trigram('ج', 'م', 'ي'),
            Trigram('ل', 'ي', ' '),
            Trigram('م', 'ي', 'ة'),
            Trigram('ا', 'ل', 'ض'),
            Trigram('ا', 'ل', 'س'),
            Trigram('ل', 'ض', 'م'),
            Trigram('ض', 'م', 'ا'),
            Trigram('ل', 'ف', 'ر'),
            Trigram(' ', 'و', 'س'),
            Trigram('ل', 'ح', 'م'),
            Trigram('ا', 'م', 'ل'),
            Trigram('ق', ' ', 'م'),
            Trigram('ر', 'ا', ' '),
            Trigram('ا', ' ', 'ح'),
            Trigram('ن', 'ت', ' '),
            Trigram(' ', 'ت', 'ن'),
            Trigram('ي', 'ت', 'ه'),
            Trigram(' ', 'أ', 'م'),
            Trigram('إ', 'ل', 'ي'),
            Trigram('و', 'ا', 'ج'),
            Trigram('د', ' ', 'و'),
            Trigram('ل', 'ت', 'ي'),
            Trigram(' ', 'م', 'ر'),
            Trigram('م', 'ر', 'ا'),
            Trigram('م', 'ت', 'ح'),
            Trigram(' ', 'ذ', 'ل'),
            Trigram(' ', 'و', 'أ'),
            Trigram(' ', 'ت', 'ح'),
            Trigram('ا', ' ', 'ف'),
            Trigram(' ', 'ب', 'ه'),
            Trigram(' ', 'و', 'م'),
            Trigram(' ', 'ب', 'م'),
            Trigram('و', 'ي', 'ة'),
            Trigram('و', 'ل', 'ي'),
            Trigram('ل', 'ز', 'و'),
        ],
    ),
    (
        Lang::Urd,
        &[
            Trigram('و', 'ر', ' '),
            Trigram(' ', 'ا', 'و'),
            Trigram('ا', 'و', 'ر'),
            Trigram(' ', 'ک', 'ی'),
            Trigram('ک', 'ے', ' '),
            Trigram(' ', 'ک', 'ے'),
            Trigram('ی', 'ں', ' '),
            Trigram(' ', 'ک', 'ا'),
            Trigram('ک', 'ی', ' '),
            Trigram(' ', 'ح', 'ق'),
            Trigram('ے', ' ', 'ک'),
            Trigram('ا', 'ی', 'ٔ'),
            Trigram('ک', 'ا', ' '),
            Trigram('ی', 'ٔ', 'ے'),
            Trigram(' ', 'ک', 'و'),
            Trigram('ی', 'ا', ' '),
            Trigram('ن', 'ے', ' '),
            Trigram('س', 'ے', ' '),
            Trigram(' ', 'ا', 'س'),
            Trigram('ٔ', 'ے', ' '),
            Trigram('م', 'ی', 'ں'),
            Trigram('ک', 'و', ' '),
            Trigram(' ', 'ہ', 'ے'),
            Trigram(' ', 'م', 'ی'),
            Trigram('ے', ' ', 'ا'),
            Trigram(' ', 'ا', 'ن'),
            Trigram('و', 'ں', ' '),
            Trigram(' ', 'ک', 'ر'),
            Trigram(' ', 'ہ', 'و'),
            Trigram('ا', 'س', ' '),
            Trigram('ی', ' ', 'ا'),
            Trigram('ر', ' ', 'ا'),
            Trigram('ش', 'خ', 'ص'),
            Trigram(' ', 'ش', 'خ'),
            Trigram('ح', 'ق', ' '),
            Trigram(' ', 'س', 'ے'),
            Trigram(' ', 'ج', 'ا'),
            Trigram('خ', 'ص', ' '),
            Trigram('ہ', 'ر', ' '),
            Trigram('ا', 'م', ' '),
            Trigram('ے', ' ', 'م'),
            Trigram('ں', ' ', 'ک'),
            Trigram('ہ', 'ی', 'ں'),
            Trigram(' ', 'ی', 'ا'),
            Trigram('س', 'ی', ' '),
            Trigram('ا', 'د', 'ی'),
            Trigram('آ', 'ز', 'ا'),
            Trigram(' ', 'آ', 'ز'),
            Trigram('ز', 'ا', 'د'),
            Trigram('ص', ' ', 'ک'),
            Trigram('ہ', ' ', 'ا'),
            Trigram('ہ', 'ے', ' '),
            Trigram('ج', 'ا', 'ی'),
            Trigram('ا', ' ', 'ح'),
            Trigram('ر', ' ', 'ش'),
            Trigram('ت', ' ', 'ک'),
            Trigram('ک', 'ہ', ' '),
            Trigram('م', ' ', 'ک'),
            Trigram(' ', 'پ', 'ر'),
            Trigram('ی', ' ', 'ک'),
            Trigram('ا', 'ن', ' '),
            Trigram('پ', 'ر', ' '),
            Trigram('۔', 'ہ', 'ر'),
            Trigram('د', 'ی', ' '),
            Trigram('ی', 'ٔ', 'ی'),
            Trigram('س', ' ', 'ک'),
            Trigram('ا', ' ', 'ج'),
            Trigram('ر', ' ', 'م'),
            Trigram('ہ', 'ے', '۔'),
            Trigram('ق', ' ', 'ہ'),
            Trigram('ں', ' ', 'ا'),
            Trigram('ی', ' ', 'ح'),
            Trigram('و', ' ', 'ا'),
            Trigram('ا', 'ر', ' '),
            Trigram('ن', ' ', 'ک'),
            Trigram('ق', 'و', 'ق'),
            Trigram('ک', 'س', 'ی'),
            Trigram('ح', 'ق', 'و'),
            Trigram('ر', 'ی', ' '),
            Trigram('و', 'ق', ' '),
            Trigram('ے', ' ', 'گ'),
            Trigram(' ', 'ہ', 'ی'),
            Trigram('ی', ' ', 'ج'),
            Trigram(' ', 'م', 'ع'),
            Trigram('س', 'ا', 'ن'),
            Trigram(' ', 'ن', 'ہ'),
            Trigram(' ', 'م', 'ل'),
            Trigram(' ', 'ح', 'ا'),
            Trigram('ٔ', 'ی', ' '),
            Trigram(' ', 'ج', 'و'),
            Trigram('ن', 'ی', ' '),
            Trigram('ک', 'ر', 'ن'),
            Trigram(' ', 'ل', 'ی'),
            Trigram('ت', 'ی', ' '),
            Trigram('ی', ' ', 'ت'),
            Trigram('ن', 'س', 'ا'),
            Trigram('ل', ' ', 'ک'),
            Trigram(' ', 'ک', 'ہ'),
            Trigram('ج', 'و', ' '),
            Trigram('ا', 'ن', 'س'),
            Trigram('ا', 'پ', 'ن'),
            Trigram('ے', ' ', 'ب'),
            Trigram('ن', 'ہ', ' '),
            Trigram(' ', 'ا', 'پ'),
            Trigram('ی', 'ت', ' '),
            Trigram('ا', ' ', 'ا'),
            Trigram('ہ', ' ', 'ک'),
            Trigram(' ', 'ک', 'س'),
            Trigram('ر', ' ', 'ک'),
            Trigram('ر', 'ے', ' '),
            Trigram('ے', ' ', 'ہ'),
            Trigram(' ', 'ا', 'ی'),
            Trigram('م', 'ی', ' '),
            Trigram('ل', ' ', 'ہ'),
            Trigram('۔', ' ', 'ا'),
            Trigram('ے', ' ', 'ل'),
            Trigram('ی', ' ', 'ش'),
            Trigram('ر', 'ن', 'ے'),
            Trigram('و', 'ہ', ' '),
            Trigram('ح', 'ا', 'ص'),
            Trigram('ی', ' ', 'م'),
            Trigram('م', 'ع', 'ا'),
            Trigram('ا', 'ص', 'ل'),
            Trigram('ص', 'ل', ' '),
            Trigram('ی', 'ں', '۔'),
            Trigram('و', 'ی', 'ٔ'),
            Trigram('ن', 'ہ', 'ی'),
            Trigram('م', 'ل', 'ک'),
            Trigram('ا', 'ی', 'س'),
            Trigram('ا', 'ن', 'ہ'),
            Trigram('ا', 'ت', ' '),
            Trigram('ی', ' ', 'ب'),
            Trigram('د', ' ', 'ک'),
            Trigram('ی', ' ', 'ہ'),
            Trigram(' ', 'ت', 'ع'),
            Trigram('ک', 'ی', 'ا'),
            Trigram('ق', ' ', 'ک'),
            Trigram('ر', ' ', 'ہ'),
            Trigram('ا', ' ', 'م'),
            Trigram('د', 'ہ', ' '),
            Trigram(' ', 'م', 'ن'),
            Trigram(' ', 'ب', 'ن'),
            Trigram(' ', 'ق', 'و'),
            Trigram('ے', ' ', 'ج'),
            Trigram('ی', 'ہ', ' '),
            Trigram('ں', ' ', 'م'),
            Trigram('ا', 'ش', 'ر'),
            Trigram('م', 'ل', ' '),
            Trigram(' ', 'د', 'و'),
            Trigram('ع', 'ا', 'ش'),
            Trigram('ق', 'و', 'م'),
            Trigram('ر', ' ', 'ب'),
            Trigram('ا', 'ن', 'ی'),
            Trigram('و', 'ا', 'م'),
            Trigram('ق', 'و', 'ا'),
            Trigram('ا', 'ق', 'و'),
            Trigram('ل', 'ی', 'ٔ'),
            Trigram('د', 'ا', 'ر'),
            Trigram(' ', 'و', 'ہ'),
            Trigram(' ', 'و', ' '),
            Trigram(' ', 'ع', 'ا'),
            Trigram('ی', ' ', 'س'),
            Trigram('ب', 'ر', ' '),
            Trigram('ع', 'ل', 'ا'),
            Trigram('ا', 'د', ' '),
            Trigram('ہ', ' ', 'م'),
            Trigram('و', ' ', 'ت'),
            Trigram('ر', ' ', 'ن'),
            Trigram(' ', 'ج', 'س'),
            Trigram('ے', '۔', 'ہ'),
            Trigram('ے', '،', ' '),
            Trigram('ا', 'ن', 'و'),
            Trigram(' ', 'د', 'ی'),
            Trigram('گ', 'ی', ' '),
            Trigram('ل', 'ی', 'م'),
            Trigram('ی', 'و', 'ں'),
            Trigram(' ', 'ق', 'ا'),
            Trigram(' ', 'ی', 'ہ'),
            Trigram('د', 'و', 'س'),
            Trigram('ے', '۔', ' '),
            Trigram('ا', ' ', 'ہ'),
            Trigram('ت', 'ع', 'ل'),
            Trigram('ی', 'م', ' '),
            Trigram('ر', ' ', 'پ'),
            Trigram('ج', 'س', ' '),
            Trigram('ر', 'ی', 'ق'),
            Trigram('ے', ' ', 'ح'),
            Trigram(' ', 'ا', 'ق'),
            Trigram('ن', 'ی', 'ا'),
            Trigram('ل', 'ک', ' '),
            Trigram(' ', 'گ', 'ی'),
            Trigram('ی', 'ن', ' '),
            Trigram('ی', 'ا', 'د'),
            Trigram(' ', 'م', 'س'),
            Trigram('ل', 'ا', 'ق'),
            Trigram('،', ' ', 'ا'),
            Trigram('ی', ' ', 'ن'),
            Trigram('پ', 'ن', 'ے'),
            Trigram('و', 'ر', 'ی'),
            Trigram('م', ' ', 'ا'),
            Trigram(' ', 'ب', 'ا'),
            Trigram('ع', 'ل', 'ی'),
            Trigram('ی', 'ر', ' '),
            Trigram('ی', '،', ' '),
            Trigram('ا', 'ن', 'ے'),
            Trigram('و', 'ن', ' '),
            Trigram('ن', ' ', 'ا'),
            Trigram('ر', ' ', 'ع'),
            Trigram(' ', 'ب', 'ر'),
            Trigram('ی', ' ', 'آ'),
            Trigram('ر', ' ', 'ح'),
            Trigram(' ', 'ر', 'ک'),
            Trigram('ے', ' ', 'پ'),
            Trigram('ک', 'ر', ' '),
            Trigram('گ', 'ا', '۔'),
            Trigram(' ', 'پ', 'ی'),
            Trigram('س', 'ب', ' '),
            Trigram(' ', 'گ', 'ا'),
            Trigram('ن', 'ا', ' '),
            Trigram(' ', 'پ', 'و'),
            Trigram('ی', 'س', 'ے'),
            Trigram('ر', 'ا', 'ی'),
            Trigram(' ', 'م', 'ر'),
            Trigram('ا', 'ر', 'ی'),
            Trigram('ق', 'ا', 'ن'),
            Trigram('ن', 'و', 'ن'),
            Trigram(' ', 'م', 'م'),
            Trigram('ن', 'د', 'گ'),
            Trigram(' ', 'ا', 'ع'),
            Trigram('د', 'گ', 'ی'),
            Trigram('ہ', ' ', 'و'),
            Trigram(' ', 'ہ', 'ر'),
            Trigram('ر', ' ', 'س'),
            Trigram(' ', 'چ', 'ا'),
            Trigram('خ', 'ل', 'ا'),
            Trigram('ا', ' ', 'پ'),
            Trigram('ق', ' ', 'ح'),
            Trigram(' ', 'ب', 'ھ'),
            Trigram('س', ' ', 'م'),
            Trigram(' ', 'ش', 'ا'),
            Trigram('ہ', 'و', 'گ'),
            Trigram('ے', ' ', 'خ'),
            Trigram('و', 'س', 'ر'),
            Trigram('ر', 'ت', 'ی'),
            Trigram('و', 'م', 'ی'),
            Trigram(' ', 'ب', 'ی'),
            Trigram('ر', 'ک', 'ھ'),
            Trigram(' ', 'م', 'ت'),
            Trigram('ک', 'و', 'ی'),
            Trigram('ر', ' ', 'آ'),
            Trigram('پ', 'و', 'ر'),
            Trigram('ا', 'ف', ' '),
            Trigram(' ', 'م', 'ح'),
            Trigram('ے', ' ', 'س'),
            Trigram('ہ', 'و', 'ں'),
            Trigram('ن', 'ک', 'ہ'),
            Trigram('و', 'ن', 'ک'),
            Trigram('ت', ' ', 'ا'),
            Trigram(' ', 'ط', 'ر'),
            Trigram('ے', ' ', 'ع'),
            Trigram('ی', 'ٔ', 'د'),
            Trigram('د', ' ', 'ا'),
            Trigram('ا', 'ل', ' '),
            Trigram('ں', '۔', ' '),
            Trigram('م', ' ', 'م'),
            Trigram('ا', 'ں', ' '),
            Trigram(' ', 'م', 'ق'),
            Trigram('غ', 'ی', 'ر'),
            Trigram('پ', 'ن', 'ی'),
            Trigram(' ', 'ا', 'م'),
            Trigram('ں', '،', ' '),
            Trigram('م', 'ن', ' '),
            Trigram('ہ', 'و', ' '),
            Trigram('ر', 'ی', 'ع'),
            Trigram('و', ' ', 'ک'),
            Trigram('ذ', 'ر', 'ی'),
            Trigram(' ', 'ذ', 'ر'),
            Trigram('ع', 'ا', 'م'),
            Trigram('،', ' ', 'م'),
            Trigram('د', 'ا', 'ن'),
            Trigram('ا', 'د', 'ا'),
            Trigram('ا', 'ع', 'ل'),
            Trigram('م', 'ا', 'م'),
            Trigram('ت', 'م', 'ا'),
            Trigram(' ', 'ع', 'ل'),
            Trigram('د', 'ی', 'و'),
            Trigram('ب', 'ھ', 'ی'),
            Trigram('ھ', 'ی', ' '),
            Trigram('ب', 'ن', 'ی'),
            Trigram('ے', ' ', 'ی'),
            Trigram('ا', ' ', 'ک'),
            Trigram('ا', 'و', 'ی'),
            Trigram('ل', ' ', 'م'),
            Trigram(' ', 'ز', 'ن'),
            Trigram('ی', 'ا', 'س'),
            Trigram('ل', 'ا', 'ن'),
            Trigram('ع', 'م', 'ل'),
            Trigram(' ', 'ع', 'م'),
            Trigram('ت', ' ', 'م'),
            Trigram(' ', 'ب', 'چ'),
        ],
    ),
    (
        Lang::Pes,
        &[
            Trigram(' ', 'و', ' '),
            Trigram(' ', 'ح', 'ق'),
            Trigram(' ', 'ب', 'ا'),
            Trigram('ک', 'ه', ' '),
            Trigram('ن', 'د', ' '),
            Trigram(' ', 'ک', 'ه'),
            Trigram(' ', 'د', 'ر'),
            Trigram('د', 'ر', ' '),
            Trigram('ر', 'د', ' '),
            Trigram(' ', 'د', 'ا'),
            Trigram('د', 'ا', 'ر'),
            Trigram('ا', 'ز', ' '),
            Trigram(' ', 'ا', 'ز'),
            Trigram('ه', 'ر', ' '),
            Trigram(' ', 'ه', 'ر'),
            Trigram('ی', 'ت', ' '),
            Trigram('ر', ' ', 'ک'),
            Trigram('ح', 'ق', ' '),
            Trigram('د', ' ', 'ه'),
            Trigram('ا', 'ی', ' '),
            Trigram('د', ' ', 'و'),
            Trigram('ا', 'ن', ' '),
            Trigram(' ', 'ر', 'ا'),
            Trigram('ی', 'ن', ' '),
            Trigram('و', 'د', ' '),
            Trigram('ی', 'ا', ' '),
            Trigram(' ', 'ی', 'ا'),
            Trigram('ر', 'ا', ' '),
            Trigram('ا', 'ر', 'د'),
            Trigram('ی', ' ', 'و'),
            Trigram('ک', 'س', ' '),
            Trigram(' ', 'ک', 'س'),
            Trigram(' ', 'ب', 'ر'),
            Trigram(' ', 'آ', 'ز'),
            Trigram('ب', 'ا', 'ش'),
            Trigram('ه', ' ', 'ب'),
            Trigram('آ', 'ز', 'ا'),
            Trigram('د', ' ', 'ک'),
            Trigram(' ', 'خ', 'و'),
            Trigram('ه', ' ', 'ا'),
            Trigram('د', ' ', 'ب'),
            Trigram('ز', 'ا', 'د'),
            Trigram(' ', 'ا', 'س'),
            Trigram('ا', 'ر', ' '),
            Trigram(' ', 'آ', 'ن'),
            Trigram('ق', ' ', 'د'),
            Trigram('ش', 'د', ' '),
            Trigram('ح', 'ق', 'و'),
            Trigram('ق', 'و', 'ق'),
            Trigram('ی', ' ', 'ب'),
            Trigram('و', 'ق', ' '),
            Trigram('د', 'ه', ' '),
            Trigram('ه', ' ', 'د'),
            Trigram('ی', 'د', ' '),
            Trigram('ی', ' ', 'ک'),
            Trigram('و', ' ', 'ا'),
            Trigram('و', 'ر', ' '),
            Trigram('ر', ' ', 'م'),
            Trigram('ر', 'ا', 'ی'),
            Trigram('ا', 'ش', 'د'),
            Trigram('خ', 'و', 'د'),
            Trigram('ا', 'د', 'ی'),
            Trigram('ت', 'م', 'ا'),
            Trigram('ر', 'ی', ' '),
            Trigram(' ', 'ا', 'ج'),
            Trigram('ا', 'م', ' '),
            Trigram('د', 'ی', ' '),
            Trigram('ا', 'ی', 'د'),
            Trigram('س', ' ', 'ح'),
            Trigram('ا', 'س', 'ت'),
            Trigram('ر', ' ', 'ا'),
            Trigram('و', ' ', 'م'),
            Trigram(' ', 'ا', 'ن'),
            Trigram('د', ' ', 'ا'),
            Trigram('ن', 'ه', ' '),
            Trigram(' ', 'ب', 'ی'),
            Trigram('ب', 'ا', ' '),
            Trigram(' ', 'ه', 'م'),
            Trigram(' ', 'ن', 'م'),
            Trigram('م', 'ا', 'ی'),
            Trigram(' ', 'ت', 'ا'),
            Trigram('د', '،', ' '),
            Trigram('ی', ' ', 'ا'),
            Trigram('ا', 'ن', 'ه'),
            Trigram('ا', 'ت', ' '),
            Trigram('و', 'ن', ' '),
            Trigram('ا', 'ی', 'ت'),
            Trigram('ا', ' ', 'ب'),
            Trigram('س', 'ت', ' '),
            Trigram(' ', 'ک', 'ن'),
            Trigram('ب', 'ر', 'ا'),
            Trigram('ا', 'ن', 'و'),
            Trigram(' ', 'ب', 'ش'),
            Trigram(' ', 'م', 'و'),
            Trigram('ا', 'ی', 'ن'),
            Trigram(' ', 'م', 'ر'),
            Trigram('ا', 'س', 'ا'),
            Trigram(' ', 'م', 'ل'),
            Trigram('و', 'ا', 'ن'),
            Trigram('ر', ' ', 'ب'),
            Trigram('ج', 'ت', 'م'),
            Trigram(' ', 'ش', 'و'),
            Trigram(' ', 'ا', 'ع'),
            Trigram('ن', ' ', 'ا'),
            Trigram('و', 'ر', 'د'),
            Trigram(' ', 'م', 'ی'),
            Trigram(' ', 'ا', 'ی'),
            Trigram('آ', 'ن', ' '),
            Trigram(' ', 'ب', 'ه'),
            Trigram('و', ' ', 'آ'),
            Trigram('م', 'ل', 'ل'),
            Trigram('ا', ' ', 'م'),
            Trigram('م', 'ا', 'ع'),
            Trigram('ن', 'ی', ' '),
            Trigram('ت', ' ', 'ا'),
            Trigram('،', ' ', 'ا'),
            Trigram('ت', ' ', 'و'),
            Trigram('ئ', 'ی', ' '),
            Trigram('ع', 'ی', ' '),
            Trigram('ا', 'ئ', 'ی'),
            Trigram('ا', 'ج', 'ت'),
            Trigram('و', ' ', 'ب'),
            Trigram('ه', 'ا', 'ی'),
            Trigram('ن', ' ', 'م'),
            Trigram('ی', ' ', 'ی'),
            Trigram('ب', 'ش', 'ر'),
            Trigram('ک', 'ن', 'د'),
            Trigram('ش', 'و', 'د'),
            Trigram(' ', 'م', 'ن'),
            Trigram(' ', 'ز', 'ن'),
            Trigram('ن', ' ', 'و'),
            Trigram('ی', '،', ' '),
            Trigram('ب', 'ا', 'ی'),
            Trigram('ی', ' ', 'ر'),
            Trigram(' ', 'م', 'س'),
            Trigram('م', 'ل', ' '),
            Trigram('م', 'و', 'ر'),
            Trigram('ز', ' ', 'آ'),
            Trigram('ت', 'و', 'ا'),
            Trigram('د', 'ا', 'ن'),
            Trigram('ا', 'ر', 'ی'),
            Trigram('ع', 'ل', 'ا'),
            Trigram('گ', 'ر', 'د'),
            Trigram('ی', 'گ', 'ر'),
            Trigram('ک', 'ا', 'ر'),
            Trigram(' ', 'گ', 'ر'),
            Trigram(' ', 'ب', 'د'),
            Trigram('ن', ' ', 'ب'),
            Trigram('ت', ' ', 'ب'),
            Trigram('ت', ' ', 'م'),
            Trigram('ی', ' ', 'م'),
            Trigram(' ', 'م', 'ق'),
            Trigram('د', ' ', 'آ'),
            Trigram('ش', 'و', 'ر'),
            Trigram('ی', 'ه', ' '),
            Trigram('ا', 'ع', 'ی'),
            Trigram(' ', 'ع', 'م'),
            Trigram('ر', ' ', 'خ'),
            Trigram('ن', ' ', 'ح'),
            Trigram(' ', 'ک', 'ش'),
            Trigram('ر', 'ن', 'د'),
            Trigram('م', 'ی', 'ن'),
            Trigram(' ', 'ا', 'ح'),
            Trigram('ن', ' ', 'ت'),
            Trigram('ی', ' ', 'د'),
            Trigram(' ', 'م', 'ت'),
            Trigram('ه', ' ', 'م'),
            Trigram('د', ' ', 'ش'),
            Trigram(' ', 'ح', 'م'),
            Trigram('و', ' ', 'د'),
            Trigram('د', 'ی', 'گ'),
            Trigram('ل', 'ا', 'م'),
            Trigram('ک', 'ش', 'و'),
            Trigram('ه', 'ٔ', ' '),
            Trigram('ه', ' ', 'و'),
            Trigram('ا', 'ن', 'ی'),
            Trigram('ل', 'ی', ' '),
            Trigram('ت', ' ', 'ک'),
            Trigram(' ', 'م', 'ج'),
            Trigram('ق', ' ', 'م'),
            Trigram('م', 'ی', 'ت'),
            Trigram(' ', 'ک', 'ا'),
            Trigram(' ', 'ش', 'د'),
            Trigram('ا', 'ه', ' '),
            Trigram('ن', 'و', 'ن'),
            Trigram(' ', 'آ', 'م'),
            Trigram('ا', 'د', ' '),
            Trigram('ا', 'د', 'ا'),
            Trigram('ا', 'ع', 'ل'),
            Trigram('د', ' ', 'م'),
            Trigram('ق', ' ', 'و'),
            Trigram('ا', ' ', 'ک'),
            Trigram('م', 'ی', ' '),
            Trigram('ی', ' ', 'ح'),
            Trigram('ل', 'ل', ' '),
            Trigram('ن', 'ج', 'ا'),
            Trigram(' ', 'م', 'ح'),
            Trigram('س', 'ا', 'س'),
            Trigram('ی', 'د', 'ه'),
            Trigram(' ', 'ق', 'ا'),
            Trigram('ب', 'ع', 'ی'),
            Trigram('ق', 'ا', 'ن'),
            Trigram('ر', ' ', 'ش'),
            Trigram('م', 'ق', 'ا'),
            Trigram('ا', ' ', 'د'),
            Trigram('ه', 'د', ' '),
            Trigram('و', 'ی', ' '),
            Trigram('ن', 'و', 'ا'),
            Trigram('گ', 'ی', ' '),
            Trigram('س', 'ا', 'و'),
            Trigram('ر', ' ', 'ت'),
            Trigram('ب', 'ر', ' '),
            Trigram('ا', 'ً', ' '),
            Trigram('ن', 'م', 'ی'),
            Trigram('ا', 'س', 'ی'),
            Trigram('ا', 'د', 'ه'),
            Trigram('ا', 'و', ' '),
            Trigram(' ', 'ا', 'و'),
            Trigram(' ', 'د', 'ی'),
            Trigram(' ', 'ه', 'ی'),
            Trigram('ه', 'ی', 'چ'),
            Trigram('ه', '‌', 'ا'),
            Trigram('‌', 'ه', 'ا'),
            Trigram('ی', 'ر', ' '),
            Trigram('خ', 'و', 'ا'),
            Trigram('د', ' ', 'ت'),
            Trigram('ه', 'م', 'ه'),
            Trigram('ا', ' ', 'ه'),
            Trigram('ت', 'ی', ' '),
            Trigram('ح', 'م', 'ا'),
            Trigram('د', 'گ', 'ی'),
            Trigram('ب', 'ی', 'ن'),
            Trigram('ع', ' ', 'ا'),
            Trigram('س', 'ا', 'ن'),
            Trigram('ر', ' ', 'و'),
            Trigram('ش', 'د', 'ه'),
            Trigram('و', 'م', 'ی'),
            Trigram(' ', 'ع', 'ق'),
            Trigram(' ', 'ب', 'ع'),
            Trigram('ز', ' ', 'ح'),
            Trigram('ش', 'ر', ' '),
            Trigram('م', 'ن', 'د'),
            Trigram(' ', 'ش', 'ر'),
            Trigram('ٔ', 'م', 'ی'),
            Trigram('ا', 'ٔ', 'م'),
            Trigram('ت', 'ا', 'ٔ'),
            Trigram('ا', 'ن', 'ت'),
            Trigram('ا', 'ن', 'د'),
            Trigram('ا', 'و', 'ی'),
            Trigram('م', 'س', 'ا'),
            Trigram('ر', 'د', 'د'),
            Trigram('ب', 'ه', 'ر'),
            Trigram(' ', 'ب', 'م'),
            Trigram('ا', 'ر', 'ن'),
            Trigram('ی', 'ت', 'و'),
            Trigram('ل', ' ', 'م'),
            Trigram('ر', 'ا', 'ن'),
            Trigram('و', ' ', 'ه'),
            Trigram('ر', ' ', 'د'),
            Trigram('م', ' ', 'م'),
            Trigram('ر', 'ا', 'ر'),
            Trigram('ع', 'ق', 'ی'),
            Trigram('س', 'ی', ' '),
            Trigram('و', ' ', 'ت'),
            Trigram('ز', 'ش', ' '),
            Trigram(' ', 'ب', 'و'),
            Trigram('ا', ' ', 'ا'),
            Trigram('ی', ' ', 'ن'),
            Trigram('م', 'و', 'م'),
            Trigram('ج', 'ا', ' '),
            Trigram('ع', 'م', 'و'),
            Trigram('ر', 'ف', 'ت'),
            Trigram('ع', 'ی', 'ت'),
            Trigram(' ', 'ف', 'ر'),
            Trigram('ن', 'د', 'گ'),
            Trigram('و', 'ا', 'ه'),
            Trigram('ز', 'ن', 'د'),
            Trigram('م', ' ', 'و'),
            Trigram('ن', 'م', 'ا'),
            Trigram('ه', ' ', 'ح'),
            Trigram('ا', ' ', 'ر'),
            Trigram('د', 'ی', 'ه'),
            Trigram('ج', 'ا', 'م'),
            Trigram('م', 'ر', 'د'),
            Trigram('ت', '،', ' '),
            Trigram('د', ' ', 'ر'),
            Trigram('م', 'ا', 'م'),
            Trigram(' ', 'ت', 'م'),
            Trigram('م', 'ل', 'ی'),
            Trigram('ن', 'ن', 'د'),
            Trigram('ا', 'ل', 'م'),
            Trigram('ط', 'و', 'ر'),
            Trigram('ی', ' ', 'ت'),
            Trigram('ت', 'خ', 'ا'),
            Trigram('ا', ' ', 'ت'),
            Trigram('ا', 'م', 'ی'),
            Trigram('ا', 'م', 'ل'),
            Trigram('د', 'د', ' '),
            Trigram(' ', 'ش', 'خ'),
            Trigram('ش', 'خ', 'ص'),
        ],
    ),
];

/// Languages for script Devanagari
pub static DEVANAGARI_LANGS: LangProfileList = &[
    (
        Lang::Hin,
        &[
            Trigram('क', 'े', ' '),
            Trigram('प', '्', 'र'),
            Trigram('औ', 'र', ' '),
            Trigram(' ', 'औ', 'र'),
            Trigram(' ', 'क', 'े'),
            Trigram('ो', 'ं', ' '),
            Trigram(' ', 'क', 'ा'),
            Trigram('क', 'ा', 'र'),
            Trigram(' ', 'प', '्'),
            Trigram('क', 'ा', ' '),
            Trigram(' ', 'क', 'ो'),
            Trigram('य', 'ा', ' '),
            Trigram('ं', ' ', 'क'),
            Trigram('त', 'ि', ' '),
            Trigram('ा', 'र', ' '),
            Trigram('क', 'ो', ' '),
            Trigram(' ', 'ह', 'ै'),
            Trigram('ि', 'क', 'ा'),
            Trigram('न', 'े', ' '),
            Trigram('ह', 'ै', ' '),
            Trigram('्', 'र', 'त'),
            Trigram('ध', 'ि', 'क'),
            Trigram(' ', 'अ', 'ध'),
            Trigram('अ', 'ध', 'ि'),
            Trigram('क', 'ी', ' '),
            Trigram('ा', ' ', 'क'),
            Trigram(' ', 'क', 'ि'),
            Trigram(' ', 'क', 'ी'),
            Trigram(' ', 'स', 'म'),
            Trigram('े', 'ं', ' '),
            Trigram('व', '्', 'य'),
            Trigram('्', 'त', 'ि'),
            Trigram('क', '्', 'त'),
            Trigram('स', 'े', ' '),
            Trigram(' ', 'व', '्'),
            Trigram('ा', ' ', 'अ'),
            Trigram('्', 'य', 'क'),
            Trigram('म', 'े', 'ं'),
            Trigram('म', 'ा', 'न'),
            Trigram('ि', ' ', 'क'),
            Trigram(' ', 'स', '्'),
            Trigram(' ', 'म', 'े'),
            Trigram('स', 'ी', ' '),
            Trigram('न', '्', 'त'),
            Trigram(' ', 'ह', 'ो'),
            Trigram('े', ' ', 'क'),
            Trigram('त', 'ा', ' '),
            Trigram('य', 'क', '्'),
            Trigram('क', '्', 'ष'),
            Trigram('ै', ' ', '।'),
            Trigram('ि', 'क', ' '),
            Trigram('त', '्', 'य'),
            Trigram(' ', 'क', 'र'),
            Trigram('्', 'य', ' '),
            Trigram(' ', 'य', 'ा'),
            Trigram('भ', 'ी', ' '),
            Trigram(' ', 'व', 'ि'),
            Trigram('र', 'त', '्'),
            Trigram('र', ' ', 'स'),
            Trigram('ी', ' ', 'स'),
            Trigram(' ', 'ज', 'ा'),
            Trigram('स', '्', 'व'),
            Trigram('र', 'ो', 'ं'),
            Trigram('्', 'य', 'े'),
            Trigram('े', 'क', ' '),
            Trigram('य', 'े', 'क'),
            Trigram('त', '्', 'र'),
            Trigram('ि', 'य', 'ा'),
            Trigram('ा', ' ', 'ज'),
            Trigram('क', ' ', 'व'),
            Trigram('र', ' ', 'ह'),
            Trigram('ि', 'त', ' '),
            Trigram('्', 'र', 'ा'),
            Trigram('क', 'ि', 'स'),
            Trigram(' ', 'अ', 'न'),
            Trigram('ा', ' ', 'स'),
            Trigram('ि', 'स', 'ी'),
            Trigram('ा', ' ', 'ह'),
            Trigram('न', 'ा', ' '),
            Trigram(' ', 'स', 'े'),
            Trigram(' ', 'प', 'र'),
            Trigram('र', ' ', 'क'),
            Trigram(' ', 'स', 'ा'),
            Trigram('द', 'े', 'श'),
            Trigram('ग', 'ा', ' '),
            Trigram(' ', '।', ' '),
            Trigram(' ', 'अ', 'प'),
            Trigram('्', 'त', '्'),
            Trigram('े', ' ', 'स'),
            Trigram('स', 'म', 'ा'),
            Trigram('ा', 'न', ' '),
            Trigram('ी', ' ', 'क'),
            Trigram('्', 'त', ' '),
            Trigram('व', 'ा', 'र'),
            Trigram(' ', '।', 'प'),
            Trigram('ा', ' ', 'प'),
            Trigram(' ', 'र', 'ा'),
            Trigram('ष', 'ा', ' '),
            Trigram('न', ' ', 'क'),
            Trigram('।', 'प', '्'),
            Trigram('ष', '्', 'ट'),
            Trigram('थ', 'ा', ' '),
            Trigram('अ', 'न', '्'),
            Trigram(' ', 'म', 'ा'),
            Trigram('्', 'ष', 'ा'),
            Trigram('्', 'व', 'ा'),
            Trigram('ा', 'र', 'ो'),
            Trigram('त', 'न', '्'),
            Trigram('व', 'त', 'न'),
            Trigram('ट', '्', 'र'),
            Trigram('्', 'व', 'त'),
            Trigram('प', '्', 'त'),
            Trigram('ा', 'प', '्'),
            Trigram('्', 'ट', '्'),
            Trigram('र', 'ा', 'ष'),
            Trigram('ा', 'ष', '्'),
            Trigram(' ', 'इ', 'स'),
            Trigram('े', ' ', 'अ'),
            Trigram(' ', 'उ', 'स'),
            Trigram(' ', 'स', 'ं'),
            Trigram('र', 'ा', 'प'),
            Trigram('क', 'ि', ' '),
            Trigram('त', ' ', 'ह'),
            Trigram('ह', 'ो', ' '),
            Trigram('ं', ' ', 'औ'),
            Trigram('ा', 'र', '्'),
            Trigram('ा', ' ', '।'),
            Trigram('क', 'ि', 'य'),
            Trigram('े', ' ', 'प'),
            Trigram(' ', 'द', 'े'),
            Trigram(' ', 'भ', 'ी'),
            Trigram('क', 'र', 'न'),
            Trigram('र', 'ी', ' '),
            Trigram('ज', 'ा', 'ए'),
            Trigram('ी', ' ', 'प'),
            Trigram(' ', 'न', ' '),
            Trigram('र', ' ', 'अ'),
            Trigram('क', ' ', 'स'),
            Trigram('अ', 'प', 'न'),
            Trigram('े', ' ', 'व'),
            Trigram('ा', 'ओ', 'ं'),
            Trigram('्', 'त', 'र'),
            Trigram('ओ', 'ं', ' '),
            Trigram(' ', 'न', 'ि'),
            Trigram('स', 'भ', 'ी'),
            Trigram('र', 'ा', ' '),
            Trigram(' ', 'त', 'थ'),
            Trigram('त', 'थ', 'ा'),
            Trigram('ि', 'व', 'ा'),
            Trigram('य', 'ो', 'ं'),
            Trigram('प', 'र', ' '),
            Trigram(' ', 'ऐ', 'स'),
            Trigram('र', 'त', 'ा'),
            Trigram('ा', 'र', 'ा'),
            Trigram('्', 'र', 'ी'),
            Trigram('स', 'म', '्'),
            Trigram(' ', 'द', '्'),
            Trigram('ी', 'य', ' '),
            Trigram('ि', 'ए', ' '),
            Trigram('व', ' ', 'क'),
            Trigram('स', 'क', 'े'),
            Trigram('द', '्', 'व'),
            Trigram('ह', 'ो', 'ग'),
            Trigram(' ', 'स', 'भ'),
            Trigram('ं', ' ', 'म'),
            Trigram('म', 'ा', 'ज'),
            Trigram('र', 'न', 'े'),
            Trigram('ि', 'क', '्'),
            Trigram('्', 'य', 'ा'),
            Trigram('ा', ' ', 'व'),
            Trigram('र', ' ', 'प'),
            Trigram(' ', 'ज', 'ि'),
            Trigram('ो', ' ', 'स'),
            Trigram('र', ' ', 'उ'),
            Trigram('र', 'क', '्'),
            Trigram('े', ' ', 'म'),
            Trigram('प', 'ू', 'र'),
            Trigram(' ', 'ल', 'ि'),
            Trigram('ा', 'ए', 'ग'),
            Trigram(' ', 'भ', 'ा'),
            Trigram('इ', 'स', ' '),
            Trigram('त', ' ', 'क'),
            Trigram('ा', 'व', ' '),
            Trigram('स', '्', 'थ'),
            Trigram('प', 'न', 'े'),
            Trigram('ा', ' ', 'औ'),
            Trigram('द', '्', 'ध'),
            Trigram('श', '्', 'य'),
            Trigram('र', '्', 'व'),
            Trigram(' ', 'घ', 'ो'),
            Trigram('घ', 'ो', 'ष'),
            Trigram('र', 'ू', 'प'),
            Trigram('भ', 'ा', 'व'),
            Trigram('ा', 'न', 'े'),
            Trigram('क', 'ृ', 'त'),
            Trigram('ो', ' ', 'प'),
            Trigram('े', ' ', 'ल'),
            Trigram('ल', 'ि', 'ए'),
            Trigram('श', 'ि', 'क'),
            Trigram('ू', 'र', '्'),
            Trigram(' ', 'उ', 'न'),
            Trigram('।', ' ', 'इ'),
            Trigram('ं', ' ', 'स'),
            Trigram('य', ' ', 'क'),
            Trigram('्', 'ध', ' '),
            Trigram('द', 'ी', ' '),
            Trigram('ी', ' ', 'र'),
            Trigram('र', '्', 'य'),
            Trigram('ण', 'ा', ' '),
            Trigram('ए', 'ग', 'ा'),
            Trigram('न', '्', 'य'),
            Trigram('र', 'ी', 'य'),
            Trigram('े', 'श', ' '),
            Trigram('र', 'त', 'ि'),
            Trigram('े', ' ', 'ब'),
            Trigram(' ', 'र', 'ू'),
            Trigram('ू', 'प', ' '),
            Trigram('प', 'र', 'ा'),
            Trigram('्', 'र', ' '),
            Trigram('त', 'र', '्'),
            Trigram(' ', 'प', 'ा'),
            Trigram(' ', 'स', 'ु'),
            Trigram('ज', 'ि', 'स'),
            Trigram('त', 'ि', 'क'),
            Trigram('स', 'ा', 'र'),
            Trigram('ज', 'ो', ' '),
            Trigram('े', 'श', 'ो'),
            Trigram(' ', 'श', 'ि'),
            Trigram('ा', 'न', 'व'),
            Trigram('ी', ' ', 'अ'),
            Trigram('च', 'ि', 'त'),
            Trigram('े', ' ', 'औ'),
            Trigram(' ', 'प', 'ू'),
            Trigram('ि', 'य', 'ो'),
            Trigram('ा', ' ', 'उ'),
            Trigram('म', ' ', 'क'),
            Trigram('ी', ' ', 'भ'),
            Trigram('श', 'ो', 'ं'),
            Trigram(' ', 'ब', 'ु'),
            Trigram('म', '्', 'म'),
            Trigram('स', '्', 'त'),
            Trigram('ि', 'श', '्'),
            Trigram('्', 'र', 'ो'),
            Trigram('्', 'म', ' '),
            Trigram('ो', ' ', 'क'),
            Trigram(' ', 'य', 'ह'),
            Trigram('र', ' ', 'द'),
            Trigram('न', 'व', ' '),
            Trigram('च', 'ा', 'र'),
            Trigram('द', 'ि', 'य'),
            Trigram('े', ' ', 'य'),
            Trigram('र', '्', 'ण'),
            Trigram('र', 'ा', 'ध'),
            Trigram('ो', 'ग', 'ा'),
            Trigram('ल', 'े', ' '),
            Trigram('न', 'ू', 'न'),
            Trigram('ा', 'न', 'ू'),
            Trigram('ो', 'ष', 'ण'),
            Trigram('ष', 'ण', 'ा'),
            Trigram('व', 'ि', 'श'),
            Trigram(' ', 'ज', 'न'),
            Trigram('ा', 'र', 'ी'),
            Trigram('प', 'र', 'ि'),
            Trigram('ग', 'ी', ' '),
            Trigram('व', 'ा', 'ह'),
            Trigram('स', 'ा', 'म'),
            Trigram('ा', 'न', 'ा'),
            Trigram('र', 'क', 'ा'),
            Trigram(' ', 'ज', 'ो'),
            Trigram('ा', 'ज', ' '),
            Trigram('ी', ' ', 'ज'),
            Trigram('ध', ' ', 'क'),
            Trigram('ब', 'न', '्'),
            Trigram('त', 'ा', 'ओ'),
            Trigram('ं', 'क', 'ि'),
            Trigram('ू', 'ं', 'क'),
            Trigram('ा', 'स', ' '),
            Trigram('क', 'र', ' '),
            Trigram('च', 'ू', 'ं'),
            Trigram('ी', ' ', 'व'),
            Trigram('य', ' ', 'ह'),
            Trigram('ा', ' ', 'ग'),
            Trigram('य', ' ', 'स'),
            Trigram('न', ' ', 'स'),
            Trigram('त', ' ', 'र'),
            Trigram('क', 'ो', 'ई'),
            Trigram('ु', 'क', '्'),
            Trigram('ो', 'ई', ' '),
            Trigram(' ', '।', 'क'),
            Trigram('ं', ' ', 'न'),
            Trigram('ह', 'ि', 'त'),
            Trigram('न', 'ि', 'य'),
            Trigram('य', 'ा', 'द'),
            Trigram('ा', 'द', 'ी'),
            Trigram('्', 'म', 'ा'),
            Trigram('्', 'थ', 'ा'),
            Trigram('ा', 'म', 'ा'),
            Trigram('ा', 'ह', ' '),
            Trigram('ी', ' ', 'म'),
            Trigram('े', ' ', 'ज'),
        ],
    ),
    (
        Lang::Mar,
        &[
            Trigram('्', 'य', 'ा'),
            Trigram('य', 'ा', ' '),
            Trigram('त', '्', 'य'),
            Trigram('य', 'ा', 'च'),
            Trigram('च', 'ा', ' '),
            Trigram(' ', 'व', ' '),
            Trigram('ण', '्', 'य'),
            Trigram('प', '्', 'र'),
            Trigram('क', 'ा', 'र'),
            Trigram('ा', 'च', 'ा'),
            Trigram(' ', 'प', '्'),
            Trigram('ध', 'ि', 'क'),
            Trigram('ि', 'क', 'ा'),
            Trigram(' ', 'अ', 'ध'),
            Trigram('अ', 'ध', 'ि'),
            Trigram('च', '्', 'य'),
            Trigram('ा', 'र', ' '),
            Trigram('आ', 'ह', 'े'),
            Trigram(' ', 'आ', 'ह'),
            Trigram('ा', ' ', 'अ'),
            Trigram('ह', 'े', ' '),
            Trigram(' ', 'स', '्'),
            Trigram('्', 'र', 'त'),
            Trigram('्', 'य', 'े'),
            Trigram('ा', ' ', 'क'),
            Trigram('स', '्', 'व'),
            Trigram(' ', 'क', 'र'),
            Trigram('्', 'व', 'ा'),
            Trigram('त', 'ा', ' '),
            Trigram('ा', 'स', ' '),
            Trigram('ा', ' ', 'स'),
            Trigram('ा', ' ', 'व'),
            Trigram('त', '्', 'र'),
            Trigram(' ', 'त', '्'),
            Trigram('व', 'ा', ' '),
            Trigram('ा', 'ं', 'च'),
            Trigram('य', 'ा', 'ं'),
            Trigram('ि', 'क', ' '),
            Trigram('म', 'ा', 'न'),
            Trigram(' ', 'य', 'ा'),
            Trigram('्', 'य', ' '),
            Trigram(' ', 'क', 'ा'),
            Trigram(' ', 'अ', 'स'),
            Trigram('र', 'त', '्'),
            Trigram('ष', '्', 'ट'),
            Trigram('र', '्', 'य'),
            Trigram('य', 'े', 'क'),
            Trigram('ल', '्', 'य'),
            Trigram('र', ' ', 'आ'),
            Trigram('ा', 'ह', 'ि'),
            Trigram('क', '्', 'ष'),
            Trigram(' ', 'क', 'ो'),
            Trigram('ा', 'म', 'ा'),
            Trigram('क', 'ो', 'ण'),
            Trigram(' ', 'स', 'ं'),
            Trigram('ा', 'च', '्'),
            Trigram('ा', 'त', ' '),
            Trigram('ा', ' ', 'न'),
            Trigram(' ', 'र', 'ा'),
            Trigram('ं', 'त', '्'),
            Trigram('ू', 'न', ' '),
            Trigram('े', 'क', 'ा'),
            Trigram(' ', 'स', 'ा'),
            Trigram('र', 'ा', 'ष'),
            Trigram('ा', 'ष', '्'),
            Trigram('च', 'े', ' '),
            Trigram('्', 'ट', '्'),
            Trigram('ट', '्', 'र'),
            Trigram('त', 'ं', 'त'),
            Trigram(' ', 'म', 'ा'),
            Trigram('न', 'े', ' '),
            Trigram('क', 'ि', 'ं'),
            Trigram(' ', 'क', 'ि'),
            Trigram('व', '्', 'य'),
            Trigram('व', 'ा', 'त'),
            Trigram('े', ' ', 'स'),
            Trigram('क', 'र', 'ण'),
            Trigram('ं', 'व', 'ा'),
            Trigram('ि', 'ं', 'व'),
            Trigram('य', 'े', ' '),
            Trigram('क', '्', 'त'),
            Trigram(' ', 'स', 'म'),
            Trigram('ा', ' ', 'प'),
            Trigram('न', 'ा', ' '),
            Trigram(' ', 'म', 'ि'),
            Trigram('क', 'ा', 'स'),
            Trigram('ा', 'त', 'ं'),
            Trigram('्', 'र', '्'),
            Trigram('र', '्', 'व'),
            Trigram('स', 'म', 'ा'),
            Trigram('म', 'ि', 'ळ'),
            Trigram(' ', 'ज', 'ा'),
            Trigram('े', ' ', 'प'),
            Trigram('व', ' ', 'स'),
            Trigram('य', 'ा', 'स'),
            Trigram('ो', 'ण', 'त'),
            Trigram('र', 'ण', '्'),
            Trigram('क', 'ा', 'म'),
            Trigram('ी', 'य', ' '),
            Trigram('ा', ' ', 'आ'),
            Trigram(' ', 'द', 'े'),
            Trigram('े', ' ', 'क'),
            Trigram('ा', 'ं', 'न'),
            Trigram('ह', 'ि', ' '),
            Trigram('र', 'ा', 'ं'),
            Trigram(' ', 'व', '्'),
            Trigram('्', 'य', 'क'),
            Trigram('ा', ' ', 'म'),
            Trigram('ि', 'ळ', 'ण'),
            Trigram('ह', 'ी', ' '),
            Trigram(' ', 'प', 'ा'),
            Trigram('्', 'ष', 'ण'),
            Trigram('ा', 'र', '्'),
            Trigram('ा', 'न', ' '),
            Trigram('े', ' ', 'अ'),
            Trigram(' ', 'आ', 'प'),
            Trigram(' ', 'व', 'ि'),
            Trigram('ळ', 'ण', '्'),
            Trigram('ा', 'ह', 'ी'),
            Trigram('च', 'ी', ' '),
            Trigram('े', ' ', 'व'),
            Trigram('्', 'र', 'ा'),
            Trigram('म', 'ा', ' '),
            Trigram('ल', 'ी', ' '),
            Trigram('ं', 'च', '्'),
            Trigram('ा', 'र', 'ा'),
            Trigram('ा', ' ', 'द'),
            Trigram(' ', 'आ', 'ण'),
            Trigram(' ', 'न', 'ि'),
            Trigram('ण', 'े', ' '),
            Trigram('द', '्', 'ध'),
            Trigram(' ', 'न', 'य'),
            Trigram('ल', 'ा', ' '),
            Trigram('ा', ' ', 'ह'),
            Trigram('न', 'य', 'े'),
            Trigram(' ', 'स', 'र'),
            Trigram('स', 'र', '्'),
            Trigram('्', 'र', 'ी'),
            Trigram('ब', 'ं', 'ध'),
            Trigram('ी', ' ', 'प'),
            Trigram('आ', 'प', 'ल'),
            Trigram('ल', 'े', ' '),
            Trigram('ी', 'ल', ' '),
            Trigram('म', 'ा', 'ज'),
            Trigram(' ', 'ह', 'ो'),
            Trigram('्', 'त', ' '),
            Trigram('त', ' ', 'क'),
            Trigram('ा', 'च', 'े'),
            Trigram('्', 'व', ' '),
            Trigram('ष', 'ण', ' '),
            Trigram('ं', 'न', 'ा'),
            Trigram('ल', 'े', 'ल'),
            Trigram('ी', ' ', 'अ'),
            Trigram('द', 'े', 'श'),
            Trigram('आ', 'ण', 'ि'),
            Trigram('ण', 'ि', ' '),
            Trigram('ध', '्', 'य'),
            Trigram(' ', 'श', 'ि'),
            Trigram('ी', ' ', 'स'),
            Trigram('े', ' ', 'ज'),
            Trigram('श', 'ि', 'क'),
            Trigram('र', 'ी', 'य'),
            Trigram('ा', 'न', 'व'),
            Trigram('प', 'ा', 'ह'),
            Trigram('ह', 'ि', 'ज'),
            Trigram('ि', 'ज', 'े'),
            Trigram('ज', 'े', ' '),
            Trigram('क', ' ', 'स'),
            Trigram('य', 'क', '्'),
            Trigram('न', ' ', 'क'),
            Trigram('व', ' ', 'त'),
            Trigram('ा', ' ', 'ज'),
            Trigram('य', 'ा', 'त'),
            Trigram('प', 'ल', '्'),
            Trigram('न', '्', 'य'),
            Trigram('व', 'ी', ' '),
            Trigram('स', '्', 'थ'),
            Trigram('ज', '्', 'य'),
            Trigram(' ', 'ज', '्'),
            Trigram('े', ' ', 'आ'),
            Trigram('र', 'क', '्'),
            Trigram('त', ' ', 'स'),
            Trigram('ि', 'क', '्'),
            Trigram('ं', 'ब', 'ं'),
            Trigram('स', 'ं', 'ब'),
            Trigram(' ', 'क', 'े'),
            Trigram('क', ' ', 'व'),
            Trigram('क', 'े', 'ल'),
            Trigram('अ', 'स', 'ल'),
            Trigram('य', ' ', 'अ'),
            Trigram('य', ' ', 'क'),
            Trigram('त', ' ', 'व'),
            Trigram('ी', 'त', ' '),
            Trigram('ण', 'त', '्'),
            Trigram('त', '्', 'व'),
            Trigram('ा', 'न', 'े'),
            Trigram(' ', 'उ', 'प'),
            Trigram('्', 'व', 'त'),
            Trigram('भ', 'ा', 'व'),
            Trigram('े', ' ', 'त'),
            Trigram('क', 'र', 'त'),
            Trigram('य', 'ा', 'ह'),
            Trigram('र', 'त', 'ा'),
            Trigram('ि', 'ष', '्'),
            Trigram('व', ' ', 'म'),
            Trigram('क', 'ा', 'ं'),
            Trigram('स', 'ा', 'म'),
            Trigram('र', 'त', 'ि'),
            Trigram('स', 'ा', 'र'),
            Trigram('ं', 'च', 'ा'),
            Trigram('र', ' ', 'व'),
            Trigram('क', ' ', 'आ'),
            Trigram('य', 'ा', 'य'),
            Trigram('ा', 'स', 'ा'),
            Trigram('स', 'ा', 'ठ'),
            Trigram('ा', 'ठ', 'ी'),
            Trigram('्', 'त', 'ी'),
            Trigram('ठ', 'ी', ' '),
            Trigram('े', 'ण', '्'),
            Trigram('र', '्', 'थ'),
            Trigram('ी', 'न', 'े'),
            Trigram('े', ' ', 'य'),
            Trigram('ज', 'ा', 'ह'),
            Trigram('ो', 'ण', 'ा'),
            Trigram('स', 'ं', 'र'),
            Trigram('ा', 'य', 'द'),
            Trigram('च', '्', 'छ'),
            Trigram('स', ' ', 'स'),
            Trigram('ं', 'र', 'क'),
            Trigram('त', 'ी', 'ल'),
            Trigram('ी', ' ', 'व'),
            Trigram('त', ' ', 'आ'),
            Trigram('ी', ' ', 'आ'),
            Trigram('ं', 'ध', 'ा'),
            Trigram('े', 'श', 'ा'),
            Trigram('ि', 'त', ' '),
            Trigram(' ', 'अ', 'श'),
            Trigram('ह', 'ी', 'र'),
            Trigram(' ', 'ह', 'क'),
            Trigram('ह', 'क', '्'),
            Trigram('क', '्', 'क'),
            Trigram('य', ' ', 'व'),
            Trigram('श', 'ा', ' '),
            Trigram('व', ' ', 'आ'),
            Trigram('त', 'ी', 'न'),
            Trigram('ण', ' ', 'म'),
            Trigram('ू', 'र', '्'),
            Trigram('े', 'ल', '्'),
            Trigram('द', '्', 'य'),
            Trigram('े', 'ल', 'े'),
            Trigram('ा', 'ं', 'त'),
            Trigram('ा', ' ', 'य'),
            Trigram('ा', ' ', 'ब'),
            Trigram('ी', ' ', 'म'),
            Trigram('ं', 'च', 'े'),
            Trigram('य', 'ा', 'व'),
            Trigram('द', 'े', 'ण'),
            Trigram('क', 'ृ', 'त'),
            Trigram('ा', 'र', 'ण'),
            Trigram('े', 'त', ' '),
            Trigram('ि', 'व', 'ा'),
            Trigram('व', 'स', '्'),
            Trigram('स', '्', 'त'),
            Trigram('ा', 'च', 'ी'),
            Trigram('न', 'व', 'ी'),
            Trigram(' ', 'अ', 'र'),
            Trigram('थ', 'व', 'ा'),
            Trigram('अ', 'थ', 'व'),
            Trigram('ा', ' ', 'त'),
            Trigram(' ', 'अ', 'थ'),
            Trigram('अ', 'र', '्'),
            Trigram('त', 'ी', ' '),
            Trigram('प', 'ू', 'र'),
            Trigram('इ', 'त', 'र'),
            Trigram('र', '्', 'ण'),
            Trigram('ी', ' ', 'क'),
            Trigram('य', 'त', '्'),
            Trigram(' ', 'इ', 'त'),
            Trigram(' ', 'श', 'ा'),
            Trigram('र', 'क', 'ा'),
            Trigram('त', 'ि', 'ष'),
            Trigram('ण', ' ', 'स'),
            Trigram('त', 'ि', 'क'),
            Trigram('्', 'र', 'क'),
            Trigram('्', 'ध', ' '),
            Trigram('र', 'ण', 'ा'),
            Trigram(' ', 'आ', 'ल'),
            Trigram('े', 'ल', ' '),
            Trigram('ा', 'ज', 'ि'),
            Trigram(' ', 'न', '्'),
            Trigram('ध', 'ा', 'त'),
            Trigram('र', 'ू', 'न'),
            Trigram('श', '्', 'र'),
            Trigram('अ', 'स', 'े'),
            Trigram('ष', '्', 'ठ'),
            Trigram('ु', 'क', '्'),
            Trigram('े', 'श', ' '),
            Trigram('त', 'ो', ' '),
            Trigram('ज', 'ि', 'क'),
            Trigram('े', ' ', 'म'),
        ],
    ),
    (
        Lang::Nep,
        &[
            Trigram('क', 'ो', ' '),
            Trigram(' ', 'र', ' '),
            Trigram('क', 'ा', 'र'),
            Trigram('प', '्', 'र'),
            Trigram('ा', 'र', ' '),
            Trigram('न', 'े', ' '),
            Trigram('ि', 'क', 'ा'),
            Trigram('क', '्', 'त'),
            Trigram('ध', 'ि', 'क'),
            Trigram('्', 'य', 'क'),
            Trigram(' ', 'ग', 'र'),
            Trigram('व', '्', 'य'),
            Trigram('्', 'र', 'त'),
            Trigram(' ', 'प', '्'),
            Trigram('अ', 'ध', 'ि'),
            Trigram('्', 'त', 'ि'),
            Trigram(' ', 'अ', 'ध'),
            Trigram(' ', 'व', '्'),
            Trigram('य', 'क', '्'),
            Trigram('म', 'ा', ' '),
            Trigram('ि', 'क', ' '),
            Trigram('त', '्', 'य'),
            Trigram('ा', 'ई', ' '),
            Trigram('ल', 'ा', 'ई'),
            Trigram('न', '्', 'त'),
            Trigram('म', 'ा', 'न'),
            Trigram(' ', 'स', 'म'),
            Trigram('त', '्', 'र'),
            Trigram('ग', 'र', '्'),
            Trigram('र', '्', 'न'),
            Trigram('क', ' ', 'व'),
            Trigram(' ', 'व', 'ा'),
            Trigram('्', 'न', 'े'),
            Trigram('व', 'ा', ' '),
            Trigram(' ', 'स', '्'),
            Trigram('र', 'त', '्'),
            Trigram('र', ' ', 'स'),
            Trigram('्', 'य', 'े'),
            Trigram('त', 'ि', 'ल'),
            Trigram('य', 'े', 'क'),
            Trigram('े', 'क', ' '),
            Trigram('छ', ' ', '।'),
            Trigram('ो', ' ', 'स'),
            Trigram('ा', ' ', 'स'),
            Trigram('ह', 'र', 'ू'),
            Trigram(' ', 'व', 'ि'),
            Trigram('क', '्', 'ष'),
            Trigram('्', 'त', '्'),
            Trigram('ि', 'ल', 'ा'),
            Trigram(' ', '।', ' '),
            Trigram('स', '्', 'व'),
            Trigram('ह', 'ु', 'न'),
            Trigram('त', 'ि', ' '),
            Trigram(' ', 'ह', 'ु'),
            Trigram('ल', 'े', ' '),
            Trigram(' ', 'र', 'ा'),
            Trigram(' ', 'म', 'ा'),
            Trigram('ष', '्', 'ट'),
            Trigram('स', 'म', 'ा'),
            Trigram('व', 'त', 'न'),
            Trigram('त', 'न', '्'),
            Trigram(' ', 'छ', ' '),
            Trigram('र', ' ', 'छ'),
            Trigram(' ', 'स', 'ं'),
            Trigram('्', 'ट', '्'),
            Trigram('ट', '्', 'र'),
            Trigram('ा', 'ष', '्'),
            Trigram('ो', ' ', 'अ'),
            Trigram('र', 'ा', 'ष'),
            Trigram('्', 'व', 'त'),
            Trigram('ु', 'न', 'े'),
            Trigram('न', 'े', 'छ'),
            Trigram('ह', 'र', 'ु'),
            Trigram('ा', 'न', ' '),
            Trigram('त', 'ा', ' '),
            Trigram('े', ' ', 'अ'),
            Trigram('्', 'र', ' '),
            Trigram(' ', 'क', 'ा'),
            Trigram('ि', 'न', 'े'),
            Trigram('ा', 'क', 'ो'),
            Trigram('ग', 'र', 'ि'),
            Trigram('े', ' ', 'छ'),
            Trigram('न', 'ा', ' '),
            Trigram(' ', 'अ', 'न'),
            Trigram(' ', 'न', 'ि'),
            Trigram('र', 'त', 'ा'),
            Trigram('न', 'ै', ' '),
            Trigram(' ', 'स', 'ा'),
            Trigram('ि', 'त', ' '),
            Trigram('त', 'ि', 'क'),
            Trigram('क', ' ', 'स'),
            Trigram('र', ' ', 'र'),
            Trigram('र', 'ू', ' '),
            Trigram('ा', ' ', 'अ'),
            Trigram('थ', 'ा', ' '),
            Trigram('स', '्', 'त'),
            Trigram('क', 'ु', 'न'),
            Trigram('ा', ' ', 'र'),
            Trigram('ु', 'न', 'ै'),
            Trigram(' ', 'छ', 'ै'),
            Trigram('्', 'त', ' '),
            Trigram('छ', 'ै', 'न'),
            Trigram('ा', ' ', 'प'),
            Trigram('ा', 'र', '्'),
            Trigram('व', 'ा', 'र'),
            Trigram('ा', ' ', 'व'),
            Trigram(' ', 'प', 'र'),
            Trigram('त', 'थ', 'ा'),
            Trigram(' ', 'त', 'थ'),
            Trigram('क', 'ा', ' '),
            Trigram('्', 'य', 'ा'),
            Trigram('ए', 'क', 'ो'),
            Trigram('र', 'ु', ' '),
            Trigram('्', 'ष', 'ा'),
            Trigram('म', 'ा', 'ज'),
            Trigram('र', 'क', '्'),
            Trigram('प', 'र', 'ि'),
            Trigram('द', '्', 'ध'),
            Trigram('।', ' ', 'प'),
            Trigram(' ', 'ल', 'ा'),
            Trigram('स', 'क', 'ो'),
            Trigram('ा', 'म', 'ा'),
            Trigram(' ', 'य', 'स'),
            Trigram('ा', 'ह', 'र'),
            Trigram('े', 'छ', ' '),
            Trigram('ध', 'ा', 'र'),
            Trigram('्', 'र', 'ा'),
            Trigram('ो', ' ', 'प'),
            Trigram('न', 'ि', ' '),
            Trigram('द', 'े', 'श'),
            Trigram('भ', 'ा', 'व'),
            Trigram('ि', 'व', 'ा'),
            Trigram('्', 'य', ' '),
            Trigram('र', ' ', 'ह'),
            Trigram('र', ' ', 'व'),
            Trigram('र', ' ', 'म'),
            Trigram('स', 'ब', 'ै'),
            Trigram('न', ' ', 'अ'),
            Trigram('े', ' ', 'र'),
            Trigram('न', ' ', 'स'),
            Trigram('र', 'क', 'ो'),
            Trigram('अ', 'न', '्'),
            Trigram('त', 'ा', 'क'),
            Trigram('ं', 'र', 'क'),
            Trigram('स', 'ं', 'र'),
            Trigram('्', 'व', 'ा'),
            Trigram(' ', 'त', '्'),
            Trigram('स', 'म', '्'),
            Trigram('र', 'ी', ' '),
            Trigram('ो', ' ', 'व'),
            Trigram('ा', ' ', 'भ'),
            Trigram('र', 'ह', 'र'),
            Trigram(' ', 'क', 'ु'),
            Trigram('्', 'र', 'ि'),
            Trigram('त', ' ', 'र'),
            Trigram('र', 'ि', 'न'),
            Trigram('श', '्', 'य'),
            Trigram('प', 'न', 'ि'),
            Trigram('ै', ' ', 'व'),
            Trigram('य', 'स', '्'),
            Trigram('ा', 'र', 'ा'),
            Trigram('ा', 'न', 'व'),
            Trigram(' ', 'श', 'ि'),
            Trigram('ा', ' ', 'त'),
            Trigram('ल', 'ा', 'ग'),
            Trigram('र', 'ा', ' '),
            Trigram('श', 'ि', 'क'),
            Trigram(' ', 'स', 'ब'),
            Trigram('ा', 'उ', 'न'),
            Trigram('ि', 'क', '्'),
            Trigram('्', 'न', ' '),
            Trigram('ा', 'र', 'क'),
            Trigram('ा', ' ', 'न'),
            Trigram('र', 'ि', 'य'),
            Trigram('्', 'य', 'स'),
            Trigram('द', '्', 'व'),
            Trigram('र', 'त', 'ि'),
            Trigram('च', 'ा', 'र'),
            Trigram(' ', 'स', 'ह'),
            Trigram('्', 'ष', 'ण'),
            Trigram(' ', 'स', 'ु'),
            Trigram('ा', 'र', 'म'),
            Trigram('ु', 'क', '्'),
            Trigram('ु', 'द', '्'),
            Trigram('स', 'ा', 'म'),
            Trigram('ष', 'ा', ' '),
            Trigram('ै', 'न', ' '),
            Trigram(' ', 'अ', 'प'),
            Trigram(' ', 'भ', 'ए'),
            Trigram('ब', 'ा', 'ट'),
            Trigram('ु', 'न', ' '),
            Trigram(' ', 'उ', 'प'),
            Trigram('ा', 'न', '्'),
            Trigram('ो', ' ', 'आ'),
            Trigram('्', 'त', 'र'),
            Trigram('ि', 'य', ' '),
            Trigram('क', 'ा', 'न'),
            Trigram('ि', ' ', 'र'),
            Trigram('र', 'ू', 'क'),
            Trigram('द', '्', 'द'),
            Trigram('र', ' ', 'प'),
            Trigram('ा', 'व', ' '),
            Trigram('ो', ' ', 'ल'),
            Trigram('त', 'ो', ' '),
            Trigram(' ', 'प', 'न'),
            Trigram('ै', 'न', '।'),
            Trigram(' ', 'आ', 'व'),
            Trigram('ा', ' ', 'ग'),
            Trigram('।', 'प', '्'),
            Trigram('ब', 'ै', ' '),
            Trigram('ू', 'र', '्'),
            Trigram('ि', 'ए', 'क'),
            Trigram('र', ' ', 'त'),
            Trigram('न', 'ि', 'ज'),
            Trigram('त', '्', 'प'),
            Trigram(' ', 'भ', 'े'),
            Trigram('ज', 'ि', 'क'),
            Trigram('े', 'छ', '।'),
            Trigram('ि', 'क', 'ो'),
            Trigram('्', 'त', 'ो'),
            Trigram('व', 'ा', 'ह'),
            Trigram('त', ' ', 'स'),
            Trigram('ा', 'ट', ' '),
            Trigram(' ', 'अ', 'र'),
            Trigram('ा', 'ज', 'ि'),
            Trigram('्', 'ध', ' '),
            Trigram(' ', 'उ', 'स'),
            Trigram('र', 'म', 'ा'),
            Trigram('ा', 'त', '्'),
            Trigram('र', '्', 'य'),
            Trigram('न', 'क', 'ो'),
            Trigram('ा', 'य', ' '),
            Trigram('ज', 'क', 'ो'),
            Trigram('ि', 'त', '्'),
            Trigram('ा', 'ग', 'ि'),
            Trigram(' ', 'अ', 'भ'),
            Trigram('न', ' ', 'ग'),
            Trigram('ग', 'ि', ' '),
            Trigram('ा', ' ', 'म'),
            Trigram(' ', 'आ', 'ध'),
            Trigram('स', '्', 'थ'),
            Trigram(' ', 'प', 'ा'),
            Trigram('ा', 'र', 'ह'),
            Trigram('घ', 'ो', 'ष'),
            Trigram('त', '्', 'व'),
            Trigram('य', 'त', 'ा'),
            Trigram('ा', ' ', 'क'),
            Trigram('र', '्', 'द'),
            Trigram(' ', 'म', 'त'),
            Trigram('व', 'ि', 'ध'),
            Trigram(' ', 'स', 'क'),
            Trigram('स', 'ा', 'र'),
            Trigram('प', 'र', 'ा'),
            Trigram('य', 'ु', 'क'),
            Trigram('र', 'ा', 'ध'),
            Trigram(' ', 'घ', 'ो'),
            Trigram('ण', 'क', 'ो'),
            Trigram('अ', 'प', 'र'),
            Trigram('े', ' ', 'स'),
            Trigram('ा', 'र', 'ी'),
            Trigram('।', 'क', 'ु'),
            Trigram(' ', 'द', 'ि'),
            Trigram(' ', 'ज', 'न'),
            Trigram('भ', 'े', 'द'),
            Trigram('र', 'ि', 'व'),
            Trigram('उ', 'स', 'क'),
            Trigram('क', ' ', 'र'),
            Trigram('र', ' ', 'अ'),
            Trigram('ि', ' ', 'स'),
            Trigram('ा', 'न', 'ु'),
            Trigram('ो', ' ', 'ह'),
            Trigram('र', 'ु', 'द'),
            Trigram(' ', 'छ', '।'),
            Trigram('ू', 'क', 'ो'),
            Trigram('र', 'क', 'ा'),
            Trigram('न', 'म', 'ा'),
            Trigram(' ', 'भ', 'न'),
            Trigram('र', '्', 'म'),
            Trigram('ह', 'ि', 'त'),
            Trigram('प', 'ू', 'र'),
            Trigram('न', '्', 'य'),
            Trigram('क', ' ', 'अ'),
            Trigram('ा', ' ', 'ब'),
            Trigram('ो', ' ', 'भ'),
            Trigram('र', 'ा', 'ज'),
            Trigram('अ', 'न', 'ु'),
            Trigram('ो', 'ष', 'ण'),
            Trigram('ष', 'ण', 'ा'),
            Trigram('य', ' ', 'र'),
            Trigram(' ', 'म', 'न'),
            Trigram(' ', 'ब', 'ि'),
            Trigram('्', 'ध', 'ा'),
            Trigram(' ', 'द', 'े'),
            Trigram('न', 'ि', 'र'),
            Trigram('त', 'ा', 'ह'),
            Trigram('र', ' ', 'उ'),
            Trigram('य', 'स', ' '),
            Trigram('उ', 'न', 'े'),
            Trigram('र', 'ण', ' '),
            Trigram('व', 'ि', 'क'),
        ],
    ),
];

/// Languages for script Hebrew
pub static HEBREW_LANGS: LangProfileList = &[
    (
        Lang::Heb,
        &[
            Trigram('ו', 'ת', ' '),
            Trigram('י', 'ם', ' '),
            Trigram('כ', 'ל', ' '),
            Trigram('ת', ' ', 'ה'),
            Trigram(' ', 'כ', 'ל'),
            Trigram('ד', 'ם', ' '),
            Trigram('א', 'ד', 'ם'),
            Trigram('י', 'ו', 'ת'),
            Trigram(' ', 'ש', 'ל'),
            Trigram(' ', 'ז', 'כ'),
            Trigram('ל', ' ', 'א'),
            Trigram(' ', 'א', 'ד'),
            Trigram('ש', 'ל', ' '),
            Trigram('ל', ' ', 'ה'),
            Trigram('א', 'י', ' '),
            Trigram('ו', 'י', 'ו'),
            Trigram('כ', 'א', 'י'),
            Trigram('ת', ' ', 'ו'),
            Trigram('י', ' ', 'ל'),
            Trigram('ז', 'כ', 'א'),
            Trigram(' ', 'ו', 'ל'),
            Trigram('ל', 'א', ' '),
            Trigram(' ', 'ו', 'ה'),
            Trigram('ר', 'ו', 'ת'),
            Trigram('ז', 'כ', 'ו'),
            Trigram('י', 'ת', ' '),
            Trigram('י', 'ר', 'ו'),
            Trigram('י', 'ן', ' '),
            Trigram(' ', 'א', 'ו'),
            Trigram('ם', ' ', 'ז'),
            Trigram(' ', 'ל', 'א'),
            Trigram(' ', 'ה', 'ח'),
            Trigram('א', 'ו', ' '),
            Trigram(' ', 'ה', 'א'),
            Trigram(' ', 'ו', 'ב'),
            Trigram(' ', 'ה', 'מ'),
            Trigram('ח', 'י', 'ר'),
            Trigram('ת', ' ', 'ל'),
            Trigram('י', 'י', 'ם'),
            Trigram('ם', ' ', 'ל'),
            Trigram('א', 'ת', ' '),
            Trigram('ת', ' ', 'ב'),
            Trigram('ת', ' ', 'ש'),
            Trigram('ר', 'ה', ' '),
            Trigram('ו', 'ן', ' '),
            Trigram(' ', 'ל', 'ה'),
            Trigram('נ', 'ה', ' '),
            Trigram('כ', 'ו', 'י'),
            Trigram('ו', 'ת', 'י'),
            Trigram('ה', ' ', 'ש'),
            Trigram('ו', ' ', 'ל'),
            Trigram('ו', ' ', 'ב'),
            Trigram(' ', 'ה', 'ו'),
            Trigram('ת', ' ', 'א'),
            Trigram('ם', ' ', 'ב'),
            Trigram('ם', ' ', 'ו'),
            Trigram('ת', 'ו', ' '),
            Trigram(' ', 'א', 'ת'),
            Trigram('ל', 'ה', ' '),
            Trigram('נ', 'י', ' '),
            Trigram('א', 'ו', 'מ'),
            Trigram(' ', 'ב', 'מ'),
            Trigram('ד', 'ה', ' '),
            Trigram('א', ' ', 'י'),
            Trigram('ה', ' ', 'ה'),
            Trigram('ה', ' ', 'ב'),
            Trigram('ע', 'ל', ' '),
            Trigram('ם', ' ', 'ה'),
            Trigram(' ', 'ע', 'ל'),
            Trigram('ה', 'ו', 'א'),
            Trigram('ו', 'ך', ' '),
            Trigram('ה', ' ', 'א'),
            Trigram('ב', 'ו', 'ד'),
            Trigram('ו', 'ד', ' '),
            Trigram('ו', 'א', 'י'),
            Trigram('נ', 'ו', 'ת'),
            Trigram('ה', ' ', 'ו'),
            Trigram('ת', ' ', 'כ'),
            Trigram('י', ' ', 'ה'),
            Trigram('י', 'ה', ' '),
            Trigram('ם', ' ', 'ש'),
            Trigram('ו', ' ', 'ו'),
            Trigram(' ', 'ש', 'ה'),
            Trigram('ם', ' ', 'א'),
            Trigram('ו', ' ', 'כ'),
            Trigram('י', 'נ', 'ו'),
            Trigram('ן', ' ', 'ה'),
            Trigram(' ', 'ש', 'ו'),
            Trigram('ש', 'ו', 'ו'),
            Trigram('ה', 'ח', 'י'),
            Trigram('כ', 'ו', 'ת'),
            Trigram('ל', 'א', 'ו'),
            Trigram('ב', 'ו', 'ת'),
            Trigram('ד', 'ו', 'ת'),
            Trigram('ה', ' ', 'ל'),
            Trigram('ל', 'י', 'ת'),
            Trigram('ה', ' ', 'מ'),
            Trigram(' ', 'ב', 'י'),
            Trigram('ו', 'ה', ' '),
            Trigram('ו', 'א', ' '),
            Trigram(' ', 'ה', 'י'),
            Trigram(' ', 'ל', 'פ'),
            Trigram('ו', 'ר', ' '),
            Trigram(' ', 'ל', 'ב'),
            Trigram('ל', ' ', 'ב'),
            Trigram('ב', 'ח', 'י'),
            Trigram('ה', 'כ', 'ר'),
            Trigram('ל', 'ו', ' '),
            Trigram('ת', ' ', 'מ'),
            Trigram('ן', ' ', 'ש'),
            Trigram('ה', 'ח', 'ו'),
            Trigram('ה', ' ', 'כ'),
            Trigram(' ', 'ב', 'כ'),
            Trigram('ו', 'מ', 'י'),
            Trigram('ב', 'י', 'ן'),
            Trigram('ן', ' ', 'ו'),
            Trigram('ן', ' ', 'ל'),
            Trigram('ר', 'ו', 'י'),
            Trigram('פ', 'ל', 'י'),
            Trigram('ו', 'ל', 'ה'),
            Trigram('ל', 'י', 'ה'),
            Trigram(' ', 'ה', 'ז'),
            Trigram('ח', 'י', 'נ'),
            Trigram(' ', 'ל', 'ע'),
            Trigram(' ', 'ב', 'נ'),
            Trigram('י', 'ב', 'ו'),
            Trigram('ח', 'ו', 'ק'),
            Trigram(' ', 'א', 'ח'),
            Trigram('ח', 'ב', 'ר'),
            Trigram(' ', 'י', 'ה'),
            Trigram(' ', 'ח', 'י'),
            Trigram('מ', 'י', ' '),
            Trigram('י', 'ר', 'ה'),
            Trigram(' ', 'ח', 'ו'),
            Trigram('ה', 'א', 'ד'),
            Trigram('ו', 'ו', 'ה'),
            Trigram('ח', 'ו', 'פ'),
            Trigram('ו', 'פ', 'ש'),
            Trigram('ו', 'ק', ' '),
            Trigram('נ', 'ו', ' '),
            Trigram('י', 'ו', ' '),
            Trigram('ל', ' ', 'מ'),
            Trigram('מ', 'ד', 'י'),
            Trigram('כ', 'ב', 'ו'),
            Trigram(' ', 'ה', 'ע'),
            Trigram('נ', 'ו', 'ך'),
            Trigram(' ', 'ה', 'ד'),
            Trigram('י', ' ', 'א'),
            Trigram('י', ' ', 'ו'),
            Trigram(' ', 'ה', 'כ'),
            Trigram('ב', 'נ', 'י'),
            Trigram('ע', 'ה', ' '),
            Trigram('ו', ' ', 'א'),
            Trigram('ר', 'צ', 'ו'),
            Trigram('ד', 'י', 'נ'),
            Trigram('ב', 'ז', 'כ'),
            Trigram('מ', 'ו', 'ת'),
            Trigram('י', 'פ', 'ו'),
            Trigram(' ', 'א', 'ל'),
            Trigram('ס', 'ו', 'ד'),
            Trigram('ל', 'ם', ' '),
            Trigram('א', 'י', 'ש'),
            Trigram('ר', 'ך', ' '),
            Trigram(' ', 'א', 'י'),
            Trigram('ה', 'ג', 'נ'),
            Trigram('ה', 'ם', ' '),
            Trigram('פ', 'י', ' '),
            Trigram('ם', ' ', 'כ'),
            Trigram('ח', 'ו', 'ת'),
            Trigram('ל', ' ', 'ו'),
            Trigram('א', 'י', 'ל'),
            Trigram('י', 'ל', 'י'),
            Trigram('ת', 'י', 'ה'),
            Trigram('כ', 'ל', 'ל'),
            Trigram('א', 'ל', 'י'),
            Trigram('י', 'ס', 'ו'),
            Trigram('ה', 'א', 'ו'),
            Trigram('ז', 'ש', ' '),
            Trigram(' ', 'ב', 'א'),
            Trigram('ר', ' ', 'א'),
            Trigram('ו', ' ', 'ה'),
            Trigram('ז', 'ו', ' '),
            Trigram('א', 'ח', 'ר'),
            Trigram(' ', 'ה', 'פ'),
            Trigram(' ', 'ב', 'ע'),
            Trigram(' ', 'ב', 'ז'),
            Trigram('מ', 'ש', 'פ'),
            Trigram(' ', 'ב', 'ה'),
            Trigram(' ', 'ל', 'ח'),
            Trigram('ד', 'ר', 'ך'),
            Trigram('ו', 'מ', 'ו'),
            Trigram(' ', 'ב', 'ח'),
            Trigram(' ', 'ד', 'ר'),
            Trigram(' ', 'מ', 'ע'),
            Trigram('ל', ' ', 'י'),
            Trigram('ת', 'ו', 'ך'),
            Trigram('מ', 'נ', 'ו'),
            Trigram(' ', 'ב', 'ש'),
            Trigram('ל', 'ל', ' '),
            Trigram('ר', 'ב', 'ו'),
            Trigram(' ', 'ל', 'מ'),
            Trigram('פ', 'נ', 'י'),
            Trigram(' ', 'ל', 'ק'),
            Trigram('ת', 'ם', ' '),
            Trigram('ש', 'ה', ' '),
            Trigram('ש', 'י', 'ת'),
            Trigram('ל', 'ל', 'א'),
            Trigram('ל', 'פ', 'י'),
            Trigram('ה', 'י', 'ה'),
            Trigram('מ', 'ע', 'ש'),
            Trigram('ד', 'ו', ' '),
            Trigram('ש', 'ו', 'ת'),
            Trigram('ל', 'ה', 'ג'),
            Trigram('ו', 'צ', 'י'),
            Trigram('ש', 'ו', 'א'),
            Trigram('א', 'י', 'ן'),
            Trigram('ו', 'י', ' '),
            Trigram('ת', 'י', ' '),
            Trigram('ו', 'נ', 'ו'),
            Trigram('ל', 'י', 'ל'),
            Trigram(' ', 'ל', 'ו'),
            Trigram('ח', 'י', 'י'),
            Trigram('ל', ' ', 'ז'),
            Trigram(' ', 'ז', 'ו'),
            Trigram('ה', 'י', 'א'),
            Trigram('י', 'א', ' '),
            Trigram('נ', 'ת', 'ו'),
            Trigram('ה', ' ', 'פ'),
            Trigram('ל', 'ת', ' '),
            Trigram('ו', 'ב', 'י'),
            Trigram(' ', 'ל', 'כ'),
            Trigram('ך', ' ', 'ה'),
            Trigram('י', 'ל', ' '),
            Trigram('י', ' ', 'ש'),
            Trigram('ש', 'י', 'ו'),
            Trigram('ן', ' ', 'ב'),
            Trigram('ע', 'ו', 'ל'),
            Trigram('ה', 'מ', 'ד'),
            Trigram('ו', 'ד', 'ה'),
            Trigram('ו', 'ל', 'ם'),
            Trigram(' ', 'ו', 'מ'),
            Trigram('א', ' ', 'ה'),
            Trigram('ו', 'ל', 'א'),
            Trigram(' ', 'ב', 'ת'),
            Trigram('ה', 'כ', 'ל'),
            Trigram(' ', 'ס', 'ו'),
            Trigram(' ', 'מ', 'ש'),
            Trigram(' ', 'ע', 'ב'),
            Trigram('ס', 'ו', 'צ'),
            Trigram('א', 'ר', 'צ'),
            Trigram(' ', 'א', 'ר'),
            Trigram('צ', 'י', 'א'),
            Trigram('ד', ' ', 'א'),
            Trigram('ל', 'ח', 'י'),
            Trigram('ה', 'ן', ' '),
            Trigram('י', 'ח', 'ס'),
            Trigram(' ', 'י', 'ח'),
            Trigram('י', 'א', 'ל'),
            Trigram('ה', 'ז', 'כ'),
            Trigram('ם', ' ', 'נ'),
            Trigram(' ', 'ש', 'ר'),
            Trigram('ב', 'ו', ' '),
            Trigram('ע', 'ב', 'ו'),
            Trigram('ה', 'י', 'ס'),
            Trigram(' ', 'ל', 'י'),
            Trigram('ת', ' ', 'ז'),
            Trigram('פ', 'ו', 'ל'),
            Trigram('י', 'ה', 'י'),
            Trigram('ג', 'ב', 'ל'),
            Trigram('ת', 'י', 'ו'),
            Trigram('ה', 'מ', 'א'),
            Trigram('ש', 'ה', 'י'),
            Trigram('א', ' ', 'ל'),
            Trigram('מ', 'א', 'ו'),
            Trigram(' ', 'י', 'ו'),
            Trigram('ו', 'ת', 'ו'),
            Trigram('י', 'ש', 'י'),
            Trigram('ג', 'נ', 'ה'),
            Trigram('פ', 'ש', 'י'),
            Trigram('ו', 'ח', 'ד'),
            Trigram('י', 'ה', 'ם'),
            Trigram('ח', 'ר', 'ו'),
            Trigram('ל', 'כ', 'ל'),
            Trigram('י', 'ד', 'ה'),
            Trigram('ע', 'ו', 'ת'),
            Trigram('ו', 'נ', 'ה'),
            Trigram('ו', 'ם', ' '),
            Trigram('ח', 'ה', ' '),
            Trigram('ע', 'ם', ' '),
            Trigram('ש', 'ר', 'י'),
            Trigram('ם', ' ', 'י'),
            Trigram('ש', 'ר', ' '),
            Trigram('ו', 'ה', 'ח'),
            Trigram(' ', 'א', 'ש'),
            Trigram(' ', 'ה', 'ג'),
            Trigram('ק', ' ', 'ב'),
            Trigram('ה', 'פ', 'ל'),
            Trigram('נ', 'ש', 'ו'),
            Trigram('ה', 'ג', 'ב'),
            Trigram('ד', ' ', 'ו'),
        ],
    ),
    (
        Lang::Yid,
        &[
            Trigram(' ', 'פ', 'ֿ'),
            Trigram('ו', 'ן', ' '),
            Trigram('ע', 'ר', ' '),
            Trigram('ן', ' ', 'א'),
            Trigram(' ', 'א', 'ַ'),
            Trigram('ד', 'ע', 'ר'),
            Trigram('ט', ' ', 'א'),
            Trigram(' ', 'א', 'ו'),
            Trigram('א', 'ו', 'ן'),
            Trigram('א', 'ַ', 'ר'),
            Trigram('ע', 'ן', ' '),
            Trigram('פ', 'ֿ', 'ו'),
            Trigram(' ', 'א', 'ױ'),
            Trigram(' ', 'א', 'י'),
            Trigram('ן', ' ', 'פ'),
            Trigram('ֿ', 'ו', 'ן'),
            Trigram('ר', 'ע', 'כ'),
            Trigram(' ', 'ד', 'ע'),
            Trigram(' ', 'ר', 'ע'),
            Trigram('ע', 'כ', 'ט'),
            Trigram('פ', 'ֿ', 'א'),
            Trigram('ן', ' ', 'ד'),
            Trigram('כ', 'ט', ' '),
            Trigram(' ', 'ד', 'י'),
            Trigram('ד', 'י', ' '),
            Trigram('א', 'ַ', ' '),
            Trigram('א', 'ױ', 'ף'),
            Trigram('ױ', 'ף', ' '),
            Trigram('ֿ', 'א', 'ַ'),
            Trigram(' ', 'ז', 'ײ'),
            Trigram(' ', 'ג', 'ע'),
            Trigram('א', 'ַ', 'ל'),
            Trigram('א', 'ָ', 'ס'),
            Trigram(' ', 'א', 'ָ'),
            Trigram('ו', 'נ', 'ג'),
            Trigram(' ', 'ה', 'א'),
            Trigram('ה', 'א', 'ָ'),
            Trigram('ז', 'ײ', 'ַ'),
            Trigram(' ', 'מ', 'ע'),
            Trigram('א', 'ָ', 'ל'),
            Trigram('נ', 'ג', ' '),
            Trigram('װ', 'א', 'ָ'),
            Trigram('ַ', 'ן', ' '),
            Trigram('א', 'ַ', 'נ'),
            Trigram('ר', 'ײ', 'ַ'),
            Trigram(' ', 'װ', 'א'),
            Trigram('ָ', 'ס', ' '),
            Trigram('ב', 'א', 'ַ'),
            Trigram(' ', 'י', 'ע'),
            Trigram('י', 'ע', 'ד'),
            Trigram('נ', 'י', 'ט'),
            Trigram('ן', ' ', 'ז'),
            Trigram('ר', ' ', 'א'),
            Trigram('י', 'ט', ' '),
            Trigram('א', 'ָ', 'ט'),
            Trigram('א', 'ָ', 'ר'),
            Trigram('ע', 'ד', 'ע'),
            Trigram('מ', 'ע', 'ן'),
            Trigram('ז', 'א', 'ָ'),
            Trigram('ָ', 'ט', ' '),
            Trigram('פ', 'ֿ', 'ר'),
            Trigram('ײ', 'ַ', 'ן'),
            Trigram(' ', 'ב', 'א'),
            Trigram('ט', 'ן', ' '),
            Trigram('א', 'י', 'ן'),
            Trigram('ן', ' ', 'ג'),
            Trigram('י', 'ן', ' '),
            Trigram('ן', ' ', 'װ'),
            Trigram('נ', 'א', 'ַ'),
            Trigram('ֿ', 'ר', 'ײ'),
            Trigram('ר', ' ', 'ה'),
            Trigram(' ', 'ז', 'א'),
            Trigram('ל', 'ע', 'כ'),
            Trigram('ע', ' ', 'א'),
            Trigram('א', 'ָ', 'ד'),
            Trigram('ַ', ' ', 'ר'),
            Trigram('ע', 'נ', 'ט'),
            Trigram('א', 'ַ', 'צ'),
            Trigram('ַ', 'צ', 'י'),
            Trigram('א', 'ָ', 'נ'),
            Trigram(' ', 'צ', 'ו'),
            Trigram(' ', 'װ', 'ע'),
            Trigram('י', 'ז', ' '),
            Trigram('מ', 'ע', 'נ'),
            Trigram('ָ', 'ד', 'ע'),
            Trigram('א', 'י', 'ז'),
            Trigram('ן', ' ', 'מ'),
            Trigram('ַ', 'ל', 'ע'),
            Trigram('ב', 'ן', ' '),
            Trigram('ר', ' ', 'מ'),
            Trigram('ט', 'ע', 'ר'),
            Trigram(' ', 'מ', 'י'),
            Trigram(' ', 'פ', 'ּ'),
            Trigram('מ', 'י', 'ט'),
            Trigram('ט', 'ל', 'ע'),
            Trigram('ָ', 'ל', ' '),
            Trigram('ע', 'כ', 'ע'),
            Trigram('ײ', 'ט', ' '),
            Trigram('ַ', 'נ', 'ד'),
            Trigram('ע', ' ', 'פ'),
            Trigram('ל', 'ע', ' '),
            Trigram('ג', 'ע', 'ז'),
            Trigram('ל', 'א', 'ַ'),
            Trigram('א', 'ַ', 'פ'),
            Trigram('ע', 'ז', 'ע'),
            Trigram('ר', 'א', 'ַ'),
            Trigram(' ', 'נ', 'י'),
            Trigram('ַ', 'פ', 'ֿ'),
            Trigram('ר', 'ן', ' '),
            Trigram('ײ', 'ַ', 'נ'),
            Trigram('נ', 'ע', 'ן'),
            Trigram('ט', 'י', 'ק'),
            Trigram('כ', 'ע', ' '),
            Trigram('פ', 'ֿ', 'ע'),
            Trigram('י', 'ע', ' '),
            Trigram('ה', 'ײ', 'ט'),
            Trigram('ַ', 'ה', 'ײ'),
            Trigram('נ', 'ט', 'ש'),
            Trigram('ײ', 'ַ', 'ה'),
            Trigram('ט', ' ', 'ד'),
            Trigram('ן', ' ', 'ב'),
            Trigram('ל', 'ן', ' '),
            Trigram('ן', ' ', 'נ'),
            Trigram('פ', 'ֿ', 'ט'),
            Trigram('ש', 'א', 'ַ'),
            Trigram('ר', 'ו', 'נ'),
            Trigram(' ', 'ז', 'י'),
            Trigram(' ', 'װ', 'י'),
            Trigram('ט', ' ', 'פ'),
            Trigram(' ', 'ד', 'א'),
            Trigram('ט', 'א', 'ָ'),
            Trigram('ד', 'י', 'ק'),
            Trigram('ק', 'ן', ' '),
            Trigram('ר', ' ', 'פ'),
            Trigram('ר', ' ', 'ג'),
            Trigram('י', 'ק', 'ן'),
            Trigram('א', 'ָ', 'ב'),
            Trigram('ף', ' ', 'א'),
            Trigram('א', 'ַ', 'ק'),
            Trigram('ק', 'ע', 'ר'),
            Trigram('ע', 'ר', 'ע'),
            Trigram('כ', 'ע', 'ר'),
            Trigram('י', ' ', 'פ'),
            Trigram('ו', 'ת', ' '),
            Trigram('ַ', 'ר', 'ב'),
            Trigram('פ', 'ּ', 'ר'),
            Trigram('ק', 'ט', ' '),
            Trigram('ע', 'ם', ' '),
            Trigram('י', 'א', 'ָ'),
            Trigram('צ', 'י', 'ע'),
            Trigram('צ', 'י', 'א'),
            Trigram('י', 'ט', '־'),
            Trigram('צ', 'ו', ' '),
            Trigram('י', 'ש', 'ע'),
            Trigram(' ', 'ק', 'ײ'),
            Trigram('ן', ' ', 'ק'),
            Trigram('ס', 'ע', 'ר'),
            Trigram(' ', 'ג', 'ל'),
            Trigram('ד', 'א', 'ָ'),
            Trigram('ו', 'נ', 'ט'),
            Trigram('ג', 'ן', ' '),
            Trigram('ַ', 'ר', 'א'),
            Trigram('י', 'ק', 'ע'),
            Trigram(' ', 'ט', 'א'),
            Trigram('ע', 'נ', 'ע'),
            Trigram('ל', 'ײ', 'ַ'),
            Trigram('ש', 'ן', ' '),
            Trigram('ַ', 'נ', 'ע'),
            Trigram('י', 'ק', ' '),
            Trigram('ט', 'א', 'ַ'),
            Trigram('ס', ' ', 'א'),
            Trigram('ע', 'ט', ' '),
            Trigram('נ', 'ג', 'ע'),
            Trigram('ט', '־', 'א'),
            Trigram('ָ', 'נ', 'א'),
            Trigram('־', 'א', 'י'),
            Trigram('י', 'ק', 'ט'),
            Trigram('נ', 'ט', 'ע'),
            Trigram('ײ', 'נ', 'ע'),
            Trigram('־', 'נ', 'י'),
            Trigram('ָ', 'ר', ' '),
            Trigram('װ', 'ע', 'ר'),
            Trigram('י', ' ', 'א'),
            Trigram('ן', ' ', 'י'),
            Trigram('י', 'ך', ' '),
            Trigram('ז', 'י', 'ך'),
            Trigram('ע', 'ר', '־'),
            Trigram('ע', 'ר', 'ן'),
            Trigram('א', 'ױ', 'ס'),
            Trigram('ָ', 'ב', 'ן'),
            Trigram('נ', 'ד', 'ע'),
            Trigram('ָ', 'ס', 'ע'),
            Trigram('װ', 'י', ' '),
            Trigram('ֿ', 'ע', 'ל'),
            Trigram('ר', '־', 'נ'),
            Trigram('ן', ' ', 'ה'),
            Trigram(' ', 'ג', 'ר'),
            Trigram('ג', 'ל', 'ײ'),
            Trigram(' ', 'צ', 'י'),
            Trigram('ר', 'א', 'ָ'),
            Trigram('ז', 'ע', 'ל'),
            Trigram('ע', 'ל', 'ק'),
            Trigram('נ', 'ד', ' '),
            Trigram('ל', 'ק', 'ע'),
            Trigram('א', 'ָ', 'פ'),
            Trigram(' ', 'כ', 'ּ'),
            Trigram('ט', ' ', 'װ'),
            Trigram('ג', ' ', 'א'),
            Trigram(' ', 'נ', 'א'),
            Trigram('ט', ' ', 'צ'),
            Trigram('ר', ' ', 'ד'),
            Trigram('ע', 'ס', ' '),
            Trigram('ד', 'ו', 'ר'),
            Trigram('ג', 'ע', 'ן'),
            Trigram('ק', 'ע', ' '),
            Trigram('ג', ' ', 'פ'),
            Trigram('ֿ', 'ט', ' '),
            Trigram('ן', ' ', 'ל'),
            Trigram('ש', 'ע', ' '),
            Trigram('ר', ' ', 'ז'),
            Trigram('ר', 'ע', ' '),
            Trigram('ײ', 'ט', 'ן'),
            Trigram('פ', 'ּ', 'ע'),
            Trigram('ק', 'ל', 'א'),
            Trigram('ק', 'ײ', 'ט'),
            Trigram('י', 'ט', 'ע'),
            Trigram('י', 'ם', ' '),
            Trigram('ס', ' ', 'ז'),
            Trigram('ײ', 'ַ', ' '),
            Trigram(' ', 'ד', 'ו'),
            Trigram('א', 'ַ', 'ט'),
            Trigram(' ', 'ל', 'א'),
            Trigram('ר', ' ', 'װ'),
            Trigram('ק', 'ײ', 'נ'),
            Trigram('ע', 'ל', 'ש'),
            Trigram('י', ' ', 'ד'),
            Trigram('ל', 'ש', 'א'),
            Trigram('י', 'ו', 'ת'),
            Trigram('נ', 'ט', ' '),
            Trigram('ַ', 'ר', 'ז'),
            Trigram('ע', ' ', 'ר'),
            Trigram('ל', ' ', 'ז'),
            Trigram('א', 'ַ', 'מ'),
            Trigram('ן', ' ', 'ש'),
            Trigram(' ', 'ש', 'ו'),
            Trigram('א', 'י', 'נ'),
            Trigram('נ', 'ט', 'ל'),
            Trigram(' ', 'ה', 'י'),
            Trigram('ב', 'ע', 'ט'),
            Trigram('ָ', 'פ', 'ּ'),
            Trigram('ף', ' ', 'פ'),
            Trigram('ײ', 'ַ', 'כ'),
            Trigram('ב', 'ע', 'ר'),
            Trigram('ן', ' ', 'צ'),
            Trigram('מ', 'א', 'ָ'),
            Trigram(' ', 'ש', 'ט'),
            Trigram(' ', 'ל', 'ע'),
            Trigram('ג', 'ע', 'ר'),
            Trigram('ו', 'ר', 'ך'),
            Trigram('ר', 'ך', ' '),
            Trigram('נ', 'ע', 'ם'),
            Trigram('ג', 'ר', 'ו'),
            Trigram('פ', 'ֿ', 'ן'),
            Trigram('ל', 'ע', 'ר'),
            Trigram('װ', 'ע', 'ל'),
            Trigram('ע', ' ', 'מ'),
            Trigram('ו', 'ם', ' '),
            Trigram('ש', 'פ', 'ּ'),
            Trigram('ך', ' ', 'א'),
            Trigram('י', 'ו', 'נ'),
            Trigram('ר', 'ב', 'ע'),
            Trigram('ע', 'פ', 'ֿ'),
            Trigram('ט', 'ע', 'ט'),
            Trigram('ן', ' ', 'כ'),
            Trigram('ר', 'ע', 'ס'),
            Trigram('ע', 'ר', 'צ'),
            Trigram('ז', ' ', 'א'),
            Trigram('ע', 'מ', 'ע'),
            Trigram('ם', ' ', 'א'),
            Trigram('ש', 'ט', 'ע'),
            Trigram('כ', 'ן', ' '),
            Trigram('ר', 'ט', ' '),
            Trigram('י', ' ', 'ג'),
            Trigram('ס', 'ן', ' '),
            Trigram('נ', 'ע', 'ר'),
            Trigram('ל', 'י', 'ט'),
            Trigram('ט', ' ', 'ז'),
            Trigram('נ', 'ע', 'מ'),
            Trigram('ּ', 'ר', 'א'),
            Trigram('ה', 'י', 'ו'),
            Trigram('א', 'ַ', 'ש'),
            Trigram('ת', ' ', 'װ'),
            Trigram('א', 'ו', 'מ'),
            Trigram('ק', ' ', 'א'),
            Trigram('י', 'ב', 'ע'),
            Trigram('ֿ', 'ן', ' '),
            Trigram('ץ', ' ', 'א'),
            Trigram('פ', 'ֿ', 'י'),
            Trigram('ײ', 'ן', ' '),
            Trigram('ם', ' ', 'ט'),
        ],
    ),
];
