"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _utils = require("./utils");

var _excluded = ["className", "cssModule", "tag"];
var propTypes = {
  tag: _utils.tagPropType,
  'aria-label': _propTypes.default.string,
  className: _propTypes.default.string,
  cssModule: _propTypes.default.object,
  role: _propTypes.default.string
};
var defaultProps = {
  tag: 'div',
  role: 'toolbar'
};

var ButtonToolbar = function ButtonToolbar(props) {
  var className = props.className,
      cssModule = props.cssModule,
      Tag = props.tag,
      attributes = (0, _objectWithoutPropertiesLoose2.default)(props, _excluded);
  var classes = (0, _utils.mapToCssModules)((0, _classnames.default)(className, 'btn-toolbar'), cssModule);
  return /*#__PURE__*/_react.default.createElement(Tag, (0, _extends2.default)({}, attributes, {
    className: classes
  }));
};

ButtonToolbar.propTypes = propTypes;
ButtonToolbar.defaultProps = defaultProps;
var _default = ButtonToolbar;
exports.default = _default;