/* --------------------------------------------------------------- *\

  file  : imonc.h 
  author: f. meyer 
  mail  : frank at fli4l.de
  copyr : copyright (c) 2000-2003 f. meyer

  start : Mon 12 Mai 2003 07:35:16 CEST

  $Id: imonc.h,v 1.6 2003/05/17 17:33:34 bz-akira Exp $

\* --------------------------------------------------------------- */

/* --------------------------------------------------------------- *\
  
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public Licensse 
  as published by the Free Software Foundation; either version 2 
  of the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
  MA 02111-1307, USA.

\* --------------------------------------------------------------- */

/* --------------------------------------------------------------- *\

  about : small helper to connect to the imond 

\* --------------------------------------------------------------- */

#ifndef _IMONC_H_
#define _IMONC_H_

#ifdef __cplusplus
extern "C"{
#endif

#include <errno.h>
#include <stdio.h>

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

#define MAX_CIRCUITS    16
#define IMOND_PORT      5000
#define TELMOND_PORT    5001
#define GRANULARITY     8192
#define READ_TIMEOUT    5	/* timeout for broken tcp/ip connections */


#define KILOBYTES 1024
#define INV_KILOBYTES 0.0009765625
#define MEGABYTES 1048576
#define INV_MEGABYTES 9.5367432E-07
#define GIGABYTES 1073741824
#define INV_GIGABYTES 9.3132257E-10

#define SECS_PER_MINUTE 60
#define SECS_PER_HOUR 3600
#define SECS_PER_DAY 86400


/*----------------------------------------------------------------------------
 *  service_connect (host_name, port)	- connect to tcp-service
 *----------------------------------------------------------------------------
 */
int service_connect (char *host_name, int port);


/*----------------------------------------------------------------------------
 *  service_disconnect (fd)		- disconnect from service
 *----------------------------------------------------------------------------
 */
void service_disconnect (int fd);


/*----------------------------------------------------------------------------
 *  send_command (fd, str)              - send command str via fd
 *----------------------------------------------------------------------------
 */
void send_command (int fd, char *str);


/*----------------------------------------------------------------------------
 *  get_answer (fd)			- get answer from fd
 *----------------------------------------------------------------------------
 */
char *get_answer (int fd);


/*----------------------------------------------------------------------------
 *  get_lastcall (telmond_port)		- gets last incoming call from telmond
 *----------------------------------------------------------------------------
 */
char *get_lastcall (char *host_name, int port);


/* --------------------------------------------------------------- *\
    
\* --------------------------------------------------------------- */

int imonc_is_pppoe_enabled(int fd);
int imonc_is_user_mode(int fd);
int imonc_is_admin_mode(int fd);

int imonc_user_auth(int fd, const char* pass);
int imonc_admin_auth(int fd, const char* pass);


int imonc_dial_channel(int fd, int channel);
int imonc_hangup_channel(int fd, int channel);

/*
 * channel: -1 pppoe
 *           1 isdn channel 1
 *           2 isdn channel 2 etc
 */

int   imonc_get_channel_status(int fd, int channel);
int   imonc_get_channel_rate(int fd, int channel, int* down_rate, int *up_rate);
char* imonc_get_channel_time(int fd, int channel, char* buf);
char* imonc_get_channel_onlinetime(int fd, int channel, char* buf);

int   imonc_get_cpuload(int fd);
int   imonc_get_uptime(int fd);

char* imonchelp_get_bytes_string(unsigned int bytes, char* buf);
char* imonchelp_get_uptime_string(unsigned int uptime, char* buf);


#ifdef __cplusplus
};
#endif // __cplusplus

#endif // _IMONC_H_

