// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelsv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchCreateCustomVocabularyItem = "BatchCreateCustomVocabularyItem"

// BatchCreateCustomVocabularyItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateCustomVocabularyItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateCustomVocabularyItem for more information on using the BatchCreateCustomVocabularyItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateCustomVocabularyItemRequest method.
//	req, resp := client.BatchCreateCustomVocabularyItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem
func (c *LexModelsV2) BatchCreateCustomVocabularyItemRequest(input *BatchCreateCustomVocabularyItemInput) (req *request.Request, output *BatchCreateCustomVocabularyItemOutput) {
	op := &request.Operation{
		Name:       opBatchCreateCustomVocabularyItem,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchcreate",
	}

	if input == nil {
		input = &BatchCreateCustomVocabularyItemInput{}
	}

	output = &BatchCreateCustomVocabularyItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateCustomVocabularyItem API operation for Amazon Lex Model Building V2.
//
// Create a batch of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BatchCreateCustomVocabularyItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem
func (c *LexModelsV2) BatchCreateCustomVocabularyItem(input *BatchCreateCustomVocabularyItemInput) (*BatchCreateCustomVocabularyItemOutput, error) {
	req, out := c.BatchCreateCustomVocabularyItemRequest(input)
	return out, req.Send()
}

// BatchCreateCustomVocabularyItemWithContext is the same as BatchCreateCustomVocabularyItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateCustomVocabularyItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BatchCreateCustomVocabularyItemWithContext(ctx aws.Context, input *BatchCreateCustomVocabularyItemInput, opts ...request.Option) (*BatchCreateCustomVocabularyItemOutput, error) {
	req, out := c.BatchCreateCustomVocabularyItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteCustomVocabularyItem = "BatchDeleteCustomVocabularyItem"

// BatchDeleteCustomVocabularyItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteCustomVocabularyItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteCustomVocabularyItem for more information on using the BatchDeleteCustomVocabularyItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteCustomVocabularyItemRequest method.
//	req, resp := client.BatchDeleteCustomVocabularyItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem
func (c *LexModelsV2) BatchDeleteCustomVocabularyItemRequest(input *BatchDeleteCustomVocabularyItemInput) (req *request.Request, output *BatchDeleteCustomVocabularyItemOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteCustomVocabularyItem,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchdelete",
	}

	if input == nil {
		input = &BatchDeleteCustomVocabularyItemInput{}
	}

	output = &BatchDeleteCustomVocabularyItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteCustomVocabularyItem API operation for Amazon Lex Model Building V2.
//
// Delete a batch of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BatchDeleteCustomVocabularyItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem
func (c *LexModelsV2) BatchDeleteCustomVocabularyItem(input *BatchDeleteCustomVocabularyItemInput) (*BatchDeleteCustomVocabularyItemOutput, error) {
	req, out := c.BatchDeleteCustomVocabularyItemRequest(input)
	return out, req.Send()
}

// BatchDeleteCustomVocabularyItemWithContext is the same as BatchDeleteCustomVocabularyItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteCustomVocabularyItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BatchDeleteCustomVocabularyItemWithContext(ctx aws.Context, input *BatchDeleteCustomVocabularyItemInput, opts ...request.Option) (*BatchDeleteCustomVocabularyItemOutput, error) {
	req, out := c.BatchDeleteCustomVocabularyItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateCustomVocabularyItem = "BatchUpdateCustomVocabularyItem"

// BatchUpdateCustomVocabularyItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateCustomVocabularyItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateCustomVocabularyItem for more information on using the BatchUpdateCustomVocabularyItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateCustomVocabularyItemRequest method.
//	req, resp := client.BatchUpdateCustomVocabularyItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem
func (c *LexModelsV2) BatchUpdateCustomVocabularyItemRequest(input *BatchUpdateCustomVocabularyItemInput) (req *request.Request, output *BatchUpdateCustomVocabularyItemOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateCustomVocabularyItem,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchupdate",
	}

	if input == nil {
		input = &BatchUpdateCustomVocabularyItemInput{}
	}

	output = &BatchUpdateCustomVocabularyItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateCustomVocabularyItem API operation for Amazon Lex Model Building V2.
//
// Update a batch of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BatchUpdateCustomVocabularyItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem
func (c *LexModelsV2) BatchUpdateCustomVocabularyItem(input *BatchUpdateCustomVocabularyItemInput) (*BatchUpdateCustomVocabularyItemOutput, error) {
	req, out := c.BatchUpdateCustomVocabularyItemRequest(input)
	return out, req.Send()
}

// BatchUpdateCustomVocabularyItemWithContext is the same as BatchUpdateCustomVocabularyItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateCustomVocabularyItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BatchUpdateCustomVocabularyItemWithContext(ctx aws.Context, input *BatchUpdateCustomVocabularyItemInput, opts ...request.Option) (*BatchUpdateCustomVocabularyItemOutput, error) {
	req, out := c.BatchUpdateCustomVocabularyItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBuildBotLocale = "BuildBotLocale"

// BuildBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the BuildBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BuildBotLocale for more information on using the BuildBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BuildBotLocaleRequest method.
//	req, resp := client.BuildBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale
func (c *LexModelsV2) BuildBotLocaleRequest(input *BuildBotLocaleInput) (req *request.Request, output *BuildBotLocaleOutput) {
	op := &request.Operation{
		Name:       opBuildBotLocale,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &BuildBotLocaleInput{}
	}

	output = &BuildBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BuildBotLocale API operation for Amazon Lex Model Building V2.
//
// Builds a bot, its intents, and its slot types into a specific locale. A bot
// can be built into multiple locales. At runtime the locale is used to choose
// a specific build of the bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BuildBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale
func (c *LexModelsV2) BuildBotLocale(input *BuildBotLocaleInput) (*BuildBotLocaleOutput, error) {
	req, out := c.BuildBotLocaleRequest(input)
	return out, req.Send()
}

// BuildBotLocaleWithContext is the same as BuildBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See BuildBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BuildBotLocaleWithContext(ctx aws.Context, input *BuildBotLocaleInput, opts ...request.Option) (*BuildBotLocaleOutput, error) {
	req, out := c.BuildBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBot = "CreateBot"

// CreateBotRequest generates a "aws/request.Request" representing the
// client's request for the CreateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBot for more information on using the CreateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotRequest method.
//	req, resp := client.CreateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot
func (c *LexModelsV2) CreateBotRequest(input *CreateBotInput) (req *request.Request, output *CreateBotOutput) {
	op := &request.Operation{
		Name:       opCreateBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/",
	}

	if input == nil {
		input = &CreateBotInput{}
	}

	output = &CreateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBot API operation for Amazon Lex Model Building V2.
//
// Creates an Amazon Lex conversational bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot
func (c *LexModelsV2) CreateBot(input *CreateBotInput) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	return out, req.Send()
}

// CreateBotWithContext is the same as CreateBot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotWithContext(ctx aws.Context, input *CreateBotInput, opts ...request.Option) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBotAlias = "CreateBotAlias"

// CreateBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotAlias for more information on using the CreateBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotAliasRequest method.
//	req, resp := client.CreateBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias
func (c *LexModelsV2) CreateBotAliasRequest(input *CreateBotAliasInput) (req *request.Request, output *CreateBotAliasOutput) {
	op := &request.Operation{
		Name:       opCreateBotAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botaliases/",
	}

	if input == nil {
		input = &CreateBotAliasInput{}
	}

	output = &CreateBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotAlias API operation for Amazon Lex Model Building V2.
//
// Creates an alias for the specified version of a bot. Use an alias to enable
// you to change the version of a bot without updating applications that use
// the bot.
//
// For example, you can create an alias called "PROD" that your applications
// use to call the Amazon Lex bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias
func (c *LexModelsV2) CreateBotAlias(input *CreateBotAliasInput) (*CreateBotAliasOutput, error) {
	req, out := c.CreateBotAliasRequest(input)
	return out, req.Send()
}

// CreateBotAliasWithContext is the same as CreateBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotAliasWithContext(ctx aws.Context, input *CreateBotAliasInput, opts ...request.Option) (*CreateBotAliasOutput, error) {
	req, out := c.CreateBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBotLocale = "CreateBotLocale"

// CreateBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotLocale for more information on using the CreateBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotLocaleRequest method.
//	req, resp := client.CreateBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale
func (c *LexModelsV2) CreateBotLocaleRequest(input *CreateBotLocaleInput) (req *request.Request, output *CreateBotLocaleOutput) {
	op := &request.Operation{
		Name:       opCreateBotLocale,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/",
	}

	if input == nil {
		input = &CreateBotLocaleInput{}
	}

	output = &CreateBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotLocale API operation for Amazon Lex Model Building V2.
//
// Creates a locale in the bot. The locale contains the intents and slot types
// that the bot uses in conversations with users in the specified language and
// locale. You must add a locale to a bot before you can add intents and slot
// types to the bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale
func (c *LexModelsV2) CreateBotLocale(input *CreateBotLocaleInput) (*CreateBotLocaleOutput, error) {
	req, out := c.CreateBotLocaleRequest(input)
	return out, req.Send()
}

// CreateBotLocaleWithContext is the same as CreateBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotLocaleWithContext(ctx aws.Context, input *CreateBotLocaleInput, opts ...request.Option) (*CreateBotLocaleOutput, error) {
	req, out := c.CreateBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBotReplica = "CreateBotReplica"

// CreateBotReplicaRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotReplica operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotReplica for more information on using the CreateBotReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotReplicaRequest method.
//	req, resp := client.CreateBotReplicaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotReplica
func (c *LexModelsV2) CreateBotReplicaRequest(input *CreateBotReplicaInput) (req *request.Request, output *CreateBotReplicaOutput) {
	op := &request.Operation{
		Name:       opCreateBotReplica,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/replicas/",
	}

	if input == nil {
		input = &CreateBotReplicaInput{}
	}

	output = &CreateBotReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotReplica API operation for Amazon Lex Model Building V2.
//
// Action to create a replication of the source bot in the secondary region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBotReplica for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotReplica
func (c *LexModelsV2) CreateBotReplica(input *CreateBotReplicaInput) (*CreateBotReplicaOutput, error) {
	req, out := c.CreateBotReplicaRequest(input)
	return out, req.Send()
}

// CreateBotReplicaWithContext is the same as CreateBotReplica with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotReplicaWithContext(ctx aws.Context, input *CreateBotReplicaInput, opts ...request.Option) (*CreateBotReplicaOutput, error) {
	req, out := c.CreateBotReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBotVersion = "CreateBotVersion"

// CreateBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotVersion for more information on using the CreateBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotVersionRequest method.
//	req, resp := client.CreateBotVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion
func (c *LexModelsV2) CreateBotVersionRequest(input *CreateBotVersionInput) (req *request.Request, output *CreateBotVersionOutput) {
	op := &request.Operation{
		Name:       opCreateBotVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/",
	}

	if input == nil {
		input = &CreateBotVersionInput{}
	}

	output = &CreateBotVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotVersion API operation for Amazon Lex Model Building V2.
//
// Creates an immutable version of the bot. When you create the first version
// of a bot, Amazon Lex sets the version number to 1. Subsequent bot versions
// increase in an increment of 1. The version number will always represent the
// total number of versions created of the bot, not the current number of versions.
// If a bot version is deleted, that bot version number will not be reused.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBotVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion
func (c *LexModelsV2) CreateBotVersion(input *CreateBotVersionInput) (*CreateBotVersionOutput, error) {
	req, out := c.CreateBotVersionRequest(input)
	return out, req.Send()
}

// CreateBotVersionWithContext is the same as CreateBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotVersionWithContext(ctx aws.Context, input *CreateBotVersionInput, opts ...request.Option) (*CreateBotVersionOutput, error) {
	req, out := c.CreateBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExport = "CreateExport"

// CreateExportRequest generates a "aws/request.Request" representing the
// client's request for the CreateExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExport for more information on using the CreateExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExportRequest method.
//	req, resp := client.CreateExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport
func (c *LexModelsV2) CreateExportRequest(input *CreateExportInput) (req *request.Request, output *CreateExportOutput) {
	op := &request.Operation{
		Name:       opCreateExport,
		HTTPMethod: "PUT",
		HTTPPath:   "/exports/",
	}

	if input == nil {
		input = &CreateExportInput{}
	}

	output = &CreateExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExport API operation for Amazon Lex Model Building V2.
//
// Creates a zip archive containing the contents of a bot or a bot locale. The
// archive contains a directory structure that contains JSON files that define
// the bot.
//
// You can create an archive that contains the complete definition of a bot,
// or you can specify that the archive contain only the definition of a single
// bot locale.
//
// For more information about exporting bots, and about the structure of the
// export archive, see Importing and exporting bots (https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport
func (c *LexModelsV2) CreateExport(input *CreateExportInput) (*CreateExportOutput, error) {
	req, out := c.CreateExportRequest(input)
	return out, req.Send()
}

// CreateExportWithContext is the same as CreateExport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateExportWithContext(ctx aws.Context, input *CreateExportInput, opts ...request.Option) (*CreateExportOutput, error) {
	req, out := c.CreateExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIntent = "CreateIntent"

// CreateIntentRequest generates a "aws/request.Request" representing the
// client's request for the CreateIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIntent for more information on using the CreateIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIntentRequest method.
//	req, resp := client.CreateIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent
func (c *LexModelsV2) CreateIntentRequest(input *CreateIntentInput) (req *request.Request, output *CreateIntentOutput) {
	op := &request.Operation{
		Name:       opCreateIntent,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
	}

	if input == nil {
		input = &CreateIntentInput{}
	}

	output = &CreateIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIntent API operation for Amazon Lex Model Building V2.
//
// Creates an intent.
//
// To define the interaction between the user and your bot, you define one or
// more intents. For example, for a pizza ordering bot you would create an OrderPizza
// intent.
//
// When you create an intent, you must provide a name. You can optionally provide
// the following:
//
//   - Sample utterances. For example, "I want to order a pizza" and "Can I
//     order a pizza." You can't provide utterances for built-in intents.
//
//   - Information to be gathered. You specify slots for the information that
//     you bot requests from the user. You can specify standard slot types, such
//     as date and time, or custom slot types for your application.
//
//   - How the intent is fulfilled. You can provide a Lambda function or configure
//     the intent to return the intent information to your client application.
//     If you use a Lambda function, Amazon Lex invokes the function when all
//     of the intent information is available.
//
//   - A confirmation prompt to send to the user to confirm an intent. For
//     example, "Shall I order your pizza?"
//
//   - A conclusion statement to send to the user after the intent is fulfilled.
//     For example, "I ordered your pizza."
//
//   - A follow-up prompt that asks the user for additional activity. For example,
//     "Do you want a drink with your pizza?"
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent
func (c *LexModelsV2) CreateIntent(input *CreateIntentInput) (*CreateIntentOutput, error) {
	req, out := c.CreateIntentRequest(input)
	return out, req.Send()
}

// CreateIntentWithContext is the same as CreateIntent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateIntentWithContext(ctx aws.Context, input *CreateIntentInput, opts ...request.Option) (*CreateIntentOutput, error) {
	req, out := c.CreateIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourcePolicy = "CreateResourcePolicy"

// CreateResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourcePolicy for more information on using the CreateResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResourcePolicyRequest method.
//	req, resp := client.CreateResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy
func (c *LexModelsV2) CreateResourcePolicyRequest(input *CreateResourcePolicyInput) (req *request.Request, output *CreateResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opCreateResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &CreateResourcePolicyInput{}
	}

	output = &CreateResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Creates a new resource policy with the specified policy statements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy
func (c *LexModelsV2) CreateResourcePolicy(input *CreateResourcePolicyInput) (*CreateResourcePolicyOutput, error) {
	req, out := c.CreateResourcePolicyRequest(input)
	return out, req.Send()
}

// CreateResourcePolicyWithContext is the same as CreateResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateResourcePolicyWithContext(ctx aws.Context, input *CreateResourcePolicyInput, opts ...request.Option) (*CreateResourcePolicyOutput, error) {
	req, out := c.CreateResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourcePolicyStatement = "CreateResourcePolicyStatement"

// CreateResourcePolicyStatementRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourcePolicyStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourcePolicyStatement for more information on using the CreateResourcePolicyStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResourcePolicyStatementRequest method.
//	req, resp := client.CreateResourcePolicyStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement
func (c *LexModelsV2) CreateResourcePolicyStatementRequest(input *CreateResourcePolicyStatementInput) (req *request.Request, output *CreateResourcePolicyStatementOutput) {
	op := &request.Operation{
		Name:       opCreateResourcePolicyStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/policy/{resourceArn}/statements/",
	}

	if input == nil {
		input = &CreateResourcePolicyStatementInput{}
	}

	output = &CreateResourcePolicyStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourcePolicyStatement API operation for Amazon Lex Model Building V2.
//
// Adds a new resource policy statement to a bot or bot alias. If a resource
// policy exists, the statement is added to the current resource policy. If
// a policy doesn't exist, a new policy is created.
//
// You can't create a resource policy statement that allows cross-account access.
//
// You need to add the CreateResourcePolicy or UpdateResourcePolicy action to
// the bot role in order to call the API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateResourcePolicyStatement for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement
func (c *LexModelsV2) CreateResourcePolicyStatement(input *CreateResourcePolicyStatementInput) (*CreateResourcePolicyStatementOutput, error) {
	req, out := c.CreateResourcePolicyStatementRequest(input)
	return out, req.Send()
}

// CreateResourcePolicyStatementWithContext is the same as CreateResourcePolicyStatement with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourcePolicyStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateResourcePolicyStatementWithContext(ctx aws.Context, input *CreateResourcePolicyStatementInput, opts ...request.Option) (*CreateResourcePolicyStatementOutput, error) {
	req, out := c.CreateResourcePolicyStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSlot = "CreateSlot"

// CreateSlotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSlot for more information on using the CreateSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSlotRequest method.
//	req, resp := client.CreateSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot
func (c *LexModelsV2) CreateSlotRequest(input *CreateSlotInput) (req *request.Request, output *CreateSlotOutput) {
	op := &request.Operation{
		Name:       opCreateSlot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
	}

	if input == nil {
		input = &CreateSlotInput{}
	}

	output = &CreateSlotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSlot API operation for Amazon Lex Model Building V2.
//
// Creates a slot in an intent. A slot is a variable needed to fulfill an intent.
// For example, an OrderPizza intent might need slots for size, crust, and number
// of pizzas. For each slot, you define one or more utterances that Amazon Lex
// uses to elicit a response from the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot
func (c *LexModelsV2) CreateSlot(input *CreateSlotInput) (*CreateSlotOutput, error) {
	req, out := c.CreateSlotRequest(input)
	return out, req.Send()
}

// CreateSlotWithContext is the same as CreateSlot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateSlotWithContext(ctx aws.Context, input *CreateSlotInput, opts ...request.Option) (*CreateSlotOutput, error) {
	req, out := c.CreateSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSlotType = "CreateSlotType"

// CreateSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSlotType for more information on using the CreateSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSlotTypeRequest method.
//	req, resp := client.CreateSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType
func (c *LexModelsV2) CreateSlotTypeRequest(input *CreateSlotTypeInput) (req *request.Request, output *CreateSlotTypeOutput) {
	op := &request.Operation{
		Name:       opCreateSlotType,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
	}

	if input == nil {
		input = &CreateSlotTypeInput{}
	}

	output = &CreateSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSlotType API operation for Amazon Lex Model Building V2.
//
// # Creates a custom slot type
//
// To create a custom slot type, specify a name for the slot type and a set
// of enumeration values, the values that a slot of this type can assume.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType
func (c *LexModelsV2) CreateSlotType(input *CreateSlotTypeInput) (*CreateSlotTypeOutput, error) {
	req, out := c.CreateSlotTypeRequest(input)
	return out, req.Send()
}

// CreateSlotTypeWithContext is the same as CreateSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateSlotTypeWithContext(ctx aws.Context, input *CreateSlotTypeInput, opts ...request.Option) (*CreateSlotTypeOutput, error) {
	req, out := c.CreateSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTestSetDiscrepancyReport = "CreateTestSetDiscrepancyReport"

// CreateTestSetDiscrepancyReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateTestSetDiscrepancyReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTestSetDiscrepancyReport for more information on using the CreateTestSetDiscrepancyReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTestSetDiscrepancyReportRequest method.
//	req, resp := client.CreateTestSetDiscrepancyReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport
func (c *LexModelsV2) CreateTestSetDiscrepancyReportRequest(input *CreateTestSetDiscrepancyReportInput) (req *request.Request, output *CreateTestSetDiscrepancyReportOutput) {
	op := &request.Operation{
		Name:       opCreateTestSetDiscrepancyReport,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets/{testSetId}/testsetdiscrepancy",
	}

	if input == nil {
		input = &CreateTestSetDiscrepancyReportInput{}
	}

	output = &CreateTestSetDiscrepancyReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTestSetDiscrepancyReport API operation for Amazon Lex Model Building V2.
//
// Create a report that describes the differences between the bot and the test
// set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateTestSetDiscrepancyReport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport
func (c *LexModelsV2) CreateTestSetDiscrepancyReport(input *CreateTestSetDiscrepancyReportInput) (*CreateTestSetDiscrepancyReportOutput, error) {
	req, out := c.CreateTestSetDiscrepancyReportRequest(input)
	return out, req.Send()
}

// CreateTestSetDiscrepancyReportWithContext is the same as CreateTestSetDiscrepancyReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTestSetDiscrepancyReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateTestSetDiscrepancyReportWithContext(ctx aws.Context, input *CreateTestSetDiscrepancyReportInput, opts ...request.Option) (*CreateTestSetDiscrepancyReportOutput, error) {
	req, out := c.CreateTestSetDiscrepancyReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUploadUrl = "CreateUploadUrl"

// CreateUploadUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreateUploadUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUploadUrl for more information on using the CreateUploadUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUploadUrlRequest method.
//	req, resp := client.CreateUploadUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl
func (c *LexModelsV2) CreateUploadUrlRequest(input *CreateUploadUrlInput) (req *request.Request, output *CreateUploadUrlOutput) {
	op := &request.Operation{
		Name:       opCreateUploadUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/createuploadurl/",
	}

	if input == nil {
		input = &CreateUploadUrlInput{}
	}

	output = &CreateUploadUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUploadUrl API operation for Amazon Lex Model Building V2.
//
// Gets a pre-signed S3 write URL that you use to upload the zip archive when
// importing a bot or a bot locale.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateUploadUrl for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl
func (c *LexModelsV2) CreateUploadUrl(input *CreateUploadUrlInput) (*CreateUploadUrlOutput, error) {
	req, out := c.CreateUploadUrlRequest(input)
	return out, req.Send()
}

// CreateUploadUrlWithContext is the same as CreateUploadUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUploadUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateUploadUrlWithContext(ctx aws.Context, input *CreateUploadUrlInput, opts ...request.Option) (*CreateUploadUrlOutput, error) {
	req, out := c.CreateUploadUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBot = "DeleteBot"

// DeleteBotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBot for more information on using the DeleteBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotRequest method.
//	req, resp := client.DeleteBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot
func (c *LexModelsV2) DeleteBotRequest(input *DeleteBotInput) (req *request.Request, output *DeleteBotOutput) {
	op := &request.Operation{
		Name:       opDeleteBot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/",
	}

	if input == nil {
		input = &DeleteBotInput{}
	}

	output = &DeleteBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBot API operation for Amazon Lex Model Building V2.
//
// Deletes all versions of a bot, including the Draft version. To delete a specific
// version, use the DeleteBotVersion operation.
//
// When you delete a bot, all of the resources contained in the bot are also
// deleted. Deleting a bot removes all locales, intents, slot, and slot types
// defined for the bot.
//
// If a bot has an alias, the DeleteBot operation returns a ResourceInUseException
// exception. If you want to delete the bot and the alias, set the skipResourceInUseCheck
// parameter to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot
func (c *LexModelsV2) DeleteBot(input *DeleteBotInput) (*DeleteBotOutput, error) {
	req, out := c.DeleteBotRequest(input)
	return out, req.Send()
}

// DeleteBotWithContext is the same as DeleteBot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotWithContext(ctx aws.Context, input *DeleteBotInput, opts ...request.Option) (*DeleteBotOutput, error) {
	req, out := c.DeleteBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotAlias = "DeleteBotAlias"

// DeleteBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotAlias for more information on using the DeleteBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotAliasRequest method.
//	req, resp := client.DeleteBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias
func (c *LexModelsV2) DeleteBotAliasRequest(input *DeleteBotAliasInput) (req *request.Request, output *DeleteBotAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteBotAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botaliases/{botAliasId}/",
	}

	if input == nil {
		input = &DeleteBotAliasInput{}
	}

	output = &DeleteBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBotAlias API operation for Amazon Lex Model Building V2.
//
// Deletes the specified bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias
func (c *LexModelsV2) DeleteBotAlias(input *DeleteBotAliasInput) (*DeleteBotAliasOutput, error) {
	req, out := c.DeleteBotAliasRequest(input)
	return out, req.Send()
}

// DeleteBotAliasWithContext is the same as DeleteBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotAliasWithContext(ctx aws.Context, input *DeleteBotAliasInput, opts ...request.Option) (*DeleteBotAliasOutput, error) {
	req, out := c.DeleteBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotLocale = "DeleteBotLocale"

// DeleteBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotLocale for more information on using the DeleteBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotLocaleRequest method.
//	req, resp := client.DeleteBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale
func (c *LexModelsV2) DeleteBotLocaleRequest(input *DeleteBotLocaleInput) (req *request.Request, output *DeleteBotLocaleOutput) {
	op := &request.Operation{
		Name:       opDeleteBotLocale,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &DeleteBotLocaleInput{}
	}

	output = &DeleteBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBotLocale API operation for Amazon Lex Model Building V2.
//
// Removes a locale from a bot.
//
// When you delete a locale, all intents, slots, and slot types defined for
// the locale are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale
func (c *LexModelsV2) DeleteBotLocale(input *DeleteBotLocaleInput) (*DeleteBotLocaleOutput, error) {
	req, out := c.DeleteBotLocaleRequest(input)
	return out, req.Send()
}

// DeleteBotLocaleWithContext is the same as DeleteBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotLocaleWithContext(ctx aws.Context, input *DeleteBotLocaleInput, opts ...request.Option) (*DeleteBotLocaleOutput, error) {
	req, out := c.DeleteBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotReplica = "DeleteBotReplica"

// DeleteBotReplicaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotReplica operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotReplica for more information on using the DeleteBotReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotReplicaRequest method.
//	req, resp := client.DeleteBotReplicaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotReplica
func (c *LexModelsV2) DeleteBotReplicaRequest(input *DeleteBotReplicaInput) (req *request.Request, output *DeleteBotReplicaOutput) {
	op := &request.Operation{
		Name:       opDeleteBotReplica,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/replicas/{replicaRegion}/",
	}

	if input == nil {
		input = &DeleteBotReplicaInput{}
	}

	output = &DeleteBotReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBotReplica API operation for Amazon Lex Model Building V2.
//
// The action to delete the replicated bot in the secondary region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBotReplica for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotReplica
func (c *LexModelsV2) DeleteBotReplica(input *DeleteBotReplicaInput) (*DeleteBotReplicaOutput, error) {
	req, out := c.DeleteBotReplicaRequest(input)
	return out, req.Send()
}

// DeleteBotReplicaWithContext is the same as DeleteBotReplica with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotReplicaWithContext(ctx aws.Context, input *DeleteBotReplicaInput, opts ...request.Option) (*DeleteBotReplicaOutput, error) {
	req, out := c.DeleteBotReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotVersion = "DeleteBotVersion"

// DeleteBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotVersion for more information on using the DeleteBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotVersionRequest method.
//	req, resp := client.DeleteBotVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion
func (c *LexModelsV2) DeleteBotVersionRequest(input *DeleteBotVersionInput) (req *request.Request, output *DeleteBotVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteBotVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/",
	}

	if input == nil {
		input = &DeleteBotVersionInput{}
	}

	output = &DeleteBotVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBotVersion API operation for Amazon Lex Model Building V2.
//
// Deletes a specific version of a bot. To delete all versions of a bot, use
// the DeleteBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBotVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion
func (c *LexModelsV2) DeleteBotVersion(input *DeleteBotVersionInput) (*DeleteBotVersionOutput, error) {
	req, out := c.DeleteBotVersionRequest(input)
	return out, req.Send()
}

// DeleteBotVersionWithContext is the same as DeleteBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotVersionWithContext(ctx aws.Context, input *DeleteBotVersionInput, opts ...request.Option) (*DeleteBotVersionOutput, error) {
	req, out := c.DeleteBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomVocabulary = "DeleteCustomVocabulary"

// DeleteCustomVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomVocabulary for more information on using the DeleteCustomVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomVocabularyRequest method.
//	req, resp := client.DeleteCustomVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary
func (c *LexModelsV2) DeleteCustomVocabularyRequest(input *DeleteCustomVocabularyInput) (req *request.Request, output *DeleteCustomVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomVocabulary,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary",
	}

	if input == nil {
		input = &DeleteCustomVocabularyInput{}
	}

	output = &DeleteCustomVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCustomVocabulary API operation for Amazon Lex Model Building V2.
//
// Removes a custom vocabulary from the specified locale in the specified bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteCustomVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary
func (c *LexModelsV2) DeleteCustomVocabulary(input *DeleteCustomVocabularyInput) (*DeleteCustomVocabularyOutput, error) {
	req, out := c.DeleteCustomVocabularyRequest(input)
	return out, req.Send()
}

// DeleteCustomVocabularyWithContext is the same as DeleteCustomVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteCustomVocabularyWithContext(ctx aws.Context, input *DeleteCustomVocabularyInput, opts ...request.Option) (*DeleteCustomVocabularyOutput, error) {
	req, out := c.DeleteCustomVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExport = "DeleteExport"

// DeleteExportRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExport for more information on using the DeleteExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExportRequest method.
//	req, resp := client.DeleteExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport
func (c *LexModelsV2) DeleteExportRequest(input *DeleteExportInput) (req *request.Request, output *DeleteExportOutput) {
	op := &request.Operation{
		Name:       opDeleteExport,
		HTTPMethod: "DELETE",
		HTTPPath:   "/exports/{exportId}/",
	}

	if input == nil {
		input = &DeleteExportInput{}
	}

	output = &DeleteExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteExport API operation for Amazon Lex Model Building V2.
//
// Removes a previous export and the associated files stored in an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport
func (c *LexModelsV2) DeleteExport(input *DeleteExportInput) (*DeleteExportOutput, error) {
	req, out := c.DeleteExportRequest(input)
	return out, req.Send()
}

// DeleteExportWithContext is the same as DeleteExport with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteExportWithContext(ctx aws.Context, input *DeleteExportInput, opts ...request.Option) (*DeleteExportOutput, error) {
	req, out := c.DeleteExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImport = "DeleteImport"

// DeleteImportRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImport for more information on using the DeleteImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteImportRequest method.
//	req, resp := client.DeleteImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport
func (c *LexModelsV2) DeleteImportRequest(input *DeleteImportInput) (req *request.Request, output *DeleteImportOutput) {
	op := &request.Operation{
		Name:       opDeleteImport,
		HTTPMethod: "DELETE",
		HTTPPath:   "/imports/{importId}/",
	}

	if input == nil {
		input = &DeleteImportInput{}
	}

	output = &DeleteImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImport API operation for Amazon Lex Model Building V2.
//
// Removes a previous import and the associated file stored in an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteImport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport
func (c *LexModelsV2) DeleteImport(input *DeleteImportInput) (*DeleteImportOutput, error) {
	req, out := c.DeleteImportRequest(input)
	return out, req.Send()
}

// DeleteImportWithContext is the same as DeleteImport with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteImportWithContext(ctx aws.Context, input *DeleteImportInput, opts ...request.Option) (*DeleteImportOutput, error) {
	req, out := c.DeleteImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntent = "DeleteIntent"

// DeleteIntentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntent for more information on using the DeleteIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIntentRequest method.
//	req, resp := client.DeleteIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent
func (c *LexModelsV2) DeleteIntentRequest(input *DeleteIntentInput) (req *request.Request, output *DeleteIntentOutput) {
	op := &request.Operation{
		Name:       opDeleteIntent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
	}

	if input == nil {
		input = &DeleteIntentInput{}
	}

	output = &DeleteIntentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntent API operation for Amazon Lex Model Building V2.
//
// Removes the specified intent.
//
// Deleting an intent also deletes the slots associated with the intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent
func (c *LexModelsV2) DeleteIntent(input *DeleteIntentInput) (*DeleteIntentOutput, error) {
	req, out := c.DeleteIntentRequest(input)
	return out, req.Send()
}

// DeleteIntentWithContext is the same as DeleteIntent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteIntentWithContext(ctx aws.Context, input *DeleteIntentInput, opts ...request.Option) (*DeleteIntentOutput, error) {
	req, out := c.DeleteIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy
func (c *LexModelsV2) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Removes an existing policy from a bot or bot alias. If the resource doesn't
// have a policy attached, Amazon Lex returns an exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy
func (c *LexModelsV2) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicyStatement = "DeleteResourcePolicyStatement"

// DeleteResourcePolicyStatementRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicyStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicyStatement for more information on using the DeleteResourcePolicyStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyStatementRequest method.
//	req, resp := client.DeleteResourcePolicyStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement
func (c *LexModelsV2) DeleteResourcePolicyStatementRequest(input *DeleteResourcePolicyStatementInput) (req *request.Request, output *DeleteResourcePolicyStatementOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicyStatement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policy/{resourceArn}/statements/{statementId}/",
	}

	if input == nil {
		input = &DeleteResourcePolicyStatementInput{}
	}

	output = &DeleteResourcePolicyStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePolicyStatement API operation for Amazon Lex Model Building V2.
//
// Deletes a policy statement from a resource policy. If you delete the last
// statement from a policy, the policy is deleted. If you specify a statement
// ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
// a policy attached, Amazon Lex returns an exception.
//
// You need to add the DeleteResourcePolicy or UpdateResourcePolicy action to
// the bot role in order to call the API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteResourcePolicyStatement for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement
func (c *LexModelsV2) DeleteResourcePolicyStatement(input *DeleteResourcePolicyStatementInput) (*DeleteResourcePolicyStatementOutput, error) {
	req, out := c.DeleteResourcePolicyStatementRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyStatementWithContext is the same as DeleteResourcePolicyStatement with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicyStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteResourcePolicyStatementWithContext(ctx aws.Context, input *DeleteResourcePolicyStatementInput, opts ...request.Option) (*DeleteResourcePolicyStatementOutput, error) {
	req, out := c.DeleteResourcePolicyStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlot = "DeleteSlot"

// DeleteSlotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlot for more information on using the DeleteSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlotRequest method.
//	req, resp := client.DeleteSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot
func (c *LexModelsV2) DeleteSlotRequest(input *DeleteSlotInput) (req *request.Request, output *DeleteSlotOutput) {
	op := &request.Operation{
		Name:       opDeleteSlot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
	}

	if input == nil {
		input = &DeleteSlotInput{}
	}

	output = &DeleteSlotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlot API operation for Amazon Lex Model Building V2.
//
// Deletes the specified slot from an intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot
func (c *LexModelsV2) DeleteSlot(input *DeleteSlotInput) (*DeleteSlotOutput, error) {
	req, out := c.DeleteSlotRequest(input)
	return out, req.Send()
}

// DeleteSlotWithContext is the same as DeleteSlot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteSlotWithContext(ctx aws.Context, input *DeleteSlotInput, opts ...request.Option) (*DeleteSlotOutput, error) {
	req, out := c.DeleteSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlotType = "DeleteSlotType"

// DeleteSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlotType for more information on using the DeleteSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlotTypeRequest method.
//	req, resp := client.DeleteSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType
func (c *LexModelsV2) DeleteSlotTypeRequest(input *DeleteSlotTypeInput) (req *request.Request, output *DeleteSlotTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteSlotType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
	}

	if input == nil {
		input = &DeleteSlotTypeInput{}
	}

	output = &DeleteSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlotType API operation for Amazon Lex Model Building V2.
//
// Deletes a slot type from a bot locale.
//
// If a slot is using the slot type, Amazon Lex throws a ResourceInUseException
// exception. To avoid the exception, set the skipResourceInUseCheck parameter
// to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType
func (c *LexModelsV2) DeleteSlotType(input *DeleteSlotTypeInput) (*DeleteSlotTypeOutput, error) {
	req, out := c.DeleteSlotTypeRequest(input)
	return out, req.Send()
}

// DeleteSlotTypeWithContext is the same as DeleteSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteSlotTypeWithContext(ctx aws.Context, input *DeleteSlotTypeInput, opts ...request.Option) (*DeleteSlotTypeOutput, error) {
	req, out := c.DeleteSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTestSet = "DeleteTestSet"

// DeleteTestSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTestSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTestSet for more information on using the DeleteTestSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTestSetRequest method.
//	req, resp := client.DeleteTestSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet
func (c *LexModelsV2) DeleteTestSetRequest(input *DeleteTestSetInput) (req *request.Request, output *DeleteTestSetOutput) {
	op := &request.Operation{
		Name:       opDeleteTestSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/testsets/{testSetId}",
	}

	if input == nil {
		input = &DeleteTestSetInput{}
	}

	output = &DeleteTestSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTestSet API operation for Amazon Lex Model Building V2.
//
// The action to delete the selected test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteTestSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet
func (c *LexModelsV2) DeleteTestSet(input *DeleteTestSetInput) (*DeleteTestSetOutput, error) {
	req, out := c.DeleteTestSetRequest(input)
	return out, req.Send()
}

// DeleteTestSetWithContext is the same as DeleteTestSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTestSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteTestSetWithContext(ctx aws.Context, input *DeleteTestSetInput, opts ...request.Option) (*DeleteTestSetOutput, error) {
	req, out := c.DeleteTestSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUtterances = "DeleteUtterances"

// DeleteUtterancesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUtterances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUtterances for more information on using the DeleteUtterances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUtterancesRequest method.
//	req, resp := client.DeleteUtterancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances
func (c *LexModelsV2) DeleteUtterancesRequest(input *DeleteUtterancesInput) (req *request.Request, output *DeleteUtterancesOutput) {
	op := &request.Operation{
		Name:       opDeleteUtterances,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/utterances/",
	}

	if input == nil {
		input = &DeleteUtterancesInput{}
	}

	output = &DeleteUtterancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUtterances API operation for Amazon Lex Model Building V2.
//
// Deletes stored utterances.
//
// Amazon Lex stores the utterances that users send to your bot. Utterances
// are stored for 15 days for use with the ListAggregatedUtterances (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html)
// operation, and then stored indefinitely for use in improving the ability
// of your bot to respond to user input..
//
// Use the DeleteUtterances operation to manually delete utterances for a specific
// session. When you use the DeleteUtterances operation, utterances stored for
// improving your bot's ability to respond to user input are deleted immediately.
// Utterances stored for use with the ListAggregatedUtterances operation are
// deleted after 15 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteUtterances for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances
func (c *LexModelsV2) DeleteUtterances(input *DeleteUtterancesInput) (*DeleteUtterancesOutput, error) {
	req, out := c.DeleteUtterancesRequest(input)
	return out, req.Send()
}

// DeleteUtterancesWithContext is the same as DeleteUtterances with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUtterances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteUtterancesWithContext(ctx aws.Context, input *DeleteUtterancesInput, opts ...request.Option) (*DeleteUtterancesOutput, error) {
	req, out := c.DeleteUtterancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBot = "DescribeBot"

// DescribeBotRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBot for more information on using the DescribeBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotRequest method.
//	req, resp := client.DescribeBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot
func (c *LexModelsV2) DescribeBotRequest(input *DescribeBotInput) (req *request.Request, output *DescribeBotOutput) {
	op := &request.Operation{
		Name:       opDescribeBot,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/",
	}

	if input == nil {
		input = &DescribeBotInput{}
	}

	output = &DescribeBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBot API operation for Amazon Lex Model Building V2.
//
// Provides metadata information about a bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot
func (c *LexModelsV2) DescribeBot(input *DescribeBotInput) (*DescribeBotOutput, error) {
	req, out := c.DescribeBotRequest(input)
	return out, req.Send()
}

// DescribeBotWithContext is the same as DescribeBot with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotWithContext(ctx aws.Context, input *DescribeBotInput, opts ...request.Option) (*DescribeBotOutput, error) {
	req, out := c.DescribeBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotAlias = "DescribeBotAlias"

// DescribeBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotAlias for more information on using the DescribeBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotAliasRequest method.
//	req, resp := client.DescribeBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias
func (c *LexModelsV2) DescribeBotAliasRequest(input *DescribeBotAliasInput) (req *request.Request, output *DescribeBotAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeBotAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botaliases/{botAliasId}/",
	}

	if input == nil {
		input = &DescribeBotAliasInput{}
	}

	output = &DescribeBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotAlias API operation for Amazon Lex Model Building V2.
//
// Get information about a specific bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias
func (c *LexModelsV2) DescribeBotAlias(input *DescribeBotAliasInput) (*DescribeBotAliasOutput, error) {
	req, out := c.DescribeBotAliasRequest(input)
	return out, req.Send()
}

// DescribeBotAliasWithContext is the same as DescribeBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotAliasWithContext(ctx aws.Context, input *DescribeBotAliasInput, opts ...request.Option) (*DescribeBotAliasOutput, error) {
	req, out := c.DescribeBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotLocale = "DescribeBotLocale"

// DescribeBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotLocale for more information on using the DescribeBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotLocaleRequest method.
//	req, resp := client.DescribeBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale
func (c *LexModelsV2) DescribeBotLocaleRequest(input *DescribeBotLocaleInput) (req *request.Request, output *DescribeBotLocaleOutput) {
	op := &request.Operation{
		Name:       opDescribeBotLocale,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &DescribeBotLocaleInput{}
	}

	output = &DescribeBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotLocale API operation for Amazon Lex Model Building V2.
//
// Describes the settings that a bot has for a specific locale.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale
func (c *LexModelsV2) DescribeBotLocale(input *DescribeBotLocaleInput) (*DescribeBotLocaleOutput, error) {
	req, out := c.DescribeBotLocaleRequest(input)
	return out, req.Send()
}

// DescribeBotLocaleWithContext is the same as DescribeBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotLocaleWithContext(ctx aws.Context, input *DescribeBotLocaleInput, opts ...request.Option) (*DescribeBotLocaleOutput, error) {
	req, out := c.DescribeBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotRecommendation = "DescribeBotRecommendation"

// DescribeBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotRecommendation for more information on using the DescribeBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotRecommendationRequest method.
//	req, resp := client.DescribeBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation
func (c *LexModelsV2) DescribeBotRecommendationRequest(input *DescribeBotRecommendationInput) (req *request.Request, output *DescribeBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opDescribeBotRecommendation,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
	}

	if input == nil {
		input = &DescribeBotRecommendationInput{}
	}

	output = &DescribeBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Provides metadata information about a bot recommendation. This information
// will enable you to get a description on the request inputs, to download associated
// transcripts after processing is complete, and to download intents and slot-types
// generated by the bot recommendation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation
func (c *LexModelsV2) DescribeBotRecommendation(input *DescribeBotRecommendationInput) (*DescribeBotRecommendationOutput, error) {
	req, out := c.DescribeBotRecommendationRequest(input)
	return out, req.Send()
}

// DescribeBotRecommendationWithContext is the same as DescribeBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotRecommendationWithContext(ctx aws.Context, input *DescribeBotRecommendationInput, opts ...request.Option) (*DescribeBotRecommendationOutput, error) {
	req, out := c.DescribeBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotReplica = "DescribeBotReplica"

// DescribeBotReplicaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotReplica operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotReplica for more information on using the DescribeBotReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotReplicaRequest method.
//	req, resp := client.DescribeBotReplicaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotReplica
func (c *LexModelsV2) DescribeBotReplicaRequest(input *DescribeBotReplicaInput) (req *request.Request, output *DescribeBotReplicaOutput) {
	op := &request.Operation{
		Name:       opDescribeBotReplica,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/replicas/{replicaRegion}/",
	}

	if input == nil {
		input = &DescribeBotReplicaInput{}
	}

	output = &DescribeBotReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotReplica API operation for Amazon Lex Model Building V2.
//
// Monitors the bot replication status through the UI console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotReplica for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotReplica
func (c *LexModelsV2) DescribeBotReplica(input *DescribeBotReplicaInput) (*DescribeBotReplicaOutput, error) {
	req, out := c.DescribeBotReplicaRequest(input)
	return out, req.Send()
}

// DescribeBotReplicaWithContext is the same as DescribeBotReplica with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotReplicaWithContext(ctx aws.Context, input *DescribeBotReplicaInput, opts ...request.Option) (*DescribeBotReplicaOutput, error) {
	req, out := c.DescribeBotReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotResourceGeneration = "DescribeBotResourceGeneration"

// DescribeBotResourceGenerationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotResourceGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotResourceGeneration for more information on using the DescribeBotResourceGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotResourceGenerationRequest method.
//	req, resp := client.DescribeBotResourceGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotResourceGeneration
func (c *LexModelsV2) DescribeBotResourceGenerationRequest(input *DescribeBotResourceGenerationInput) (req *request.Request, output *DescribeBotResourceGenerationOutput) {
	op := &request.Operation{
		Name:       opDescribeBotResourceGeneration,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/generations/{generationId}",
	}

	if input == nil {
		input = &DescribeBotResourceGenerationInput{}
	}

	output = &DescribeBotResourceGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotResourceGeneration API operation for Amazon Lex Model Building V2.
//
// Returns information about a request to generate a bot through natural language
// description, made through the StartBotResource API. Use the generatedBotLocaleUrl
// to retrieve the Amazon S3 object containing the bot locale configuration.
// You can then modify and import this configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotResourceGeneration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotResourceGeneration
func (c *LexModelsV2) DescribeBotResourceGeneration(input *DescribeBotResourceGenerationInput) (*DescribeBotResourceGenerationOutput, error) {
	req, out := c.DescribeBotResourceGenerationRequest(input)
	return out, req.Send()
}

// DescribeBotResourceGenerationWithContext is the same as DescribeBotResourceGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotResourceGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotResourceGenerationWithContext(ctx aws.Context, input *DescribeBotResourceGenerationInput, opts ...request.Option) (*DescribeBotResourceGenerationOutput, error) {
	req, out := c.DescribeBotResourceGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotVersion = "DescribeBotVersion"

// DescribeBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotVersion for more information on using the DescribeBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotVersionRequest method.
//	req, resp := client.DescribeBotVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion
func (c *LexModelsV2) DescribeBotVersionRequest(input *DescribeBotVersionInput) (req *request.Request, output *DescribeBotVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeBotVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/",
	}

	if input == nil {
		input = &DescribeBotVersionInput{}
	}

	output = &DescribeBotVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotVersion API operation for Amazon Lex Model Building V2.
//
// Provides metadata about a version of a bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion
func (c *LexModelsV2) DescribeBotVersion(input *DescribeBotVersionInput) (*DescribeBotVersionOutput, error) {
	req, out := c.DescribeBotVersionRequest(input)
	return out, req.Send()
}

// DescribeBotVersionWithContext is the same as DescribeBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotVersionWithContext(ctx aws.Context, input *DescribeBotVersionInput, opts ...request.Option) (*DescribeBotVersionOutput, error) {
	req, out := c.DescribeBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomVocabularyMetadata = "DescribeCustomVocabularyMetadata"

// DescribeCustomVocabularyMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomVocabularyMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomVocabularyMetadata for more information on using the DescribeCustomVocabularyMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomVocabularyMetadataRequest method.
//	req, resp := client.DescribeCustomVocabularyMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata
func (c *LexModelsV2) DescribeCustomVocabularyMetadataRequest(input *DescribeCustomVocabularyMetadataInput) (req *request.Request, output *DescribeCustomVocabularyMetadataOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomVocabularyMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/metadata",
	}

	if input == nil {
		input = &DescribeCustomVocabularyMetadataInput{}
	}

	output = &DescribeCustomVocabularyMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomVocabularyMetadata API operation for Amazon Lex Model Building V2.
//
// Provides metadata information about a custom vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeCustomVocabularyMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata
func (c *LexModelsV2) DescribeCustomVocabularyMetadata(input *DescribeCustomVocabularyMetadataInput) (*DescribeCustomVocabularyMetadataOutput, error) {
	req, out := c.DescribeCustomVocabularyMetadataRequest(input)
	return out, req.Send()
}

// DescribeCustomVocabularyMetadataWithContext is the same as DescribeCustomVocabularyMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomVocabularyMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeCustomVocabularyMetadataWithContext(ctx aws.Context, input *DescribeCustomVocabularyMetadataInput, opts ...request.Option) (*DescribeCustomVocabularyMetadataOutput, error) {
	req, out := c.DescribeCustomVocabularyMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExport = "DescribeExport"

// DescribeExportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExport for more information on using the DescribeExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeExportRequest method.
//	req, resp := client.DescribeExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport
func (c *LexModelsV2) DescribeExportRequest(input *DescribeExportInput) (req *request.Request, output *DescribeExportOutput) {
	op := &request.Operation{
		Name:       opDescribeExport,
		HTTPMethod: "GET",
		HTTPPath:   "/exports/{exportId}/",
	}

	if input == nil {
		input = &DescribeExportInput{}
	}

	output = &DescribeExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExport API operation for Amazon Lex Model Building V2.
//
// Gets information about a specific export.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport
func (c *LexModelsV2) DescribeExport(input *DescribeExportInput) (*DescribeExportOutput, error) {
	req, out := c.DescribeExportRequest(input)
	return out, req.Send()
}

// DescribeExportWithContext is the same as DescribeExport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeExportWithContext(ctx aws.Context, input *DescribeExportInput, opts ...request.Option) (*DescribeExportOutput, error) {
	req, out := c.DescribeExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImport = "DescribeImport"

// DescribeImportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImport for more information on using the DescribeImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImportRequest method.
//	req, resp := client.DescribeImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport
func (c *LexModelsV2) DescribeImportRequest(input *DescribeImportInput) (req *request.Request, output *DescribeImportOutput) {
	op := &request.Operation{
		Name:       opDescribeImport,
		HTTPMethod: "GET",
		HTTPPath:   "/imports/{importId}/",
	}

	if input == nil {
		input = &DescribeImportInput{}
	}

	output = &DescribeImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImport API operation for Amazon Lex Model Building V2.
//
// Gets information about a specific import.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeImport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport
func (c *LexModelsV2) DescribeImport(input *DescribeImportInput) (*DescribeImportOutput, error) {
	req, out := c.DescribeImportRequest(input)
	return out, req.Send()
}

// DescribeImportWithContext is the same as DescribeImport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeImportWithContext(ctx aws.Context, input *DescribeImportInput, opts ...request.Option) (*DescribeImportOutput, error) {
	req, out := c.DescribeImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIntent = "DescribeIntent"

// DescribeIntentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIntent for more information on using the DescribeIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIntentRequest method.
//	req, resp := client.DescribeIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent
func (c *LexModelsV2) DescribeIntentRequest(input *DescribeIntentInput) (req *request.Request, output *DescribeIntentOutput) {
	op := &request.Operation{
		Name:       opDescribeIntent,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
	}

	if input == nil {
		input = &DescribeIntentInput{}
	}

	output = &DescribeIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIntent API operation for Amazon Lex Model Building V2.
//
// Returns metadata about an intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent
func (c *LexModelsV2) DescribeIntent(input *DescribeIntentInput) (*DescribeIntentOutput, error) {
	req, out := c.DescribeIntentRequest(input)
	return out, req.Send()
}

// DescribeIntentWithContext is the same as DescribeIntent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeIntentWithContext(ctx aws.Context, input *DescribeIntentInput, opts ...request.Option) (*DescribeIntentOutput, error) {
	req, out := c.DescribeIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourcePolicy = "DescribeResourcePolicy"

// DescribeResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourcePolicy for more information on using the DescribeResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeResourcePolicyRequest method.
//	req, resp := client.DescribeResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy
func (c *LexModelsV2) DescribeResourcePolicyRequest(input *DescribeResourcePolicyInput) (req *request.Request, output *DescribeResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeResourcePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &DescribeResourcePolicyInput{}
	}

	output = &DescribeResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Gets the resource policy and policy revision for a bot or bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy
func (c *LexModelsV2) DescribeResourcePolicy(input *DescribeResourcePolicyInput) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	return out, req.Send()
}

// DescribeResourcePolicyWithContext is the same as DescribeResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeResourcePolicyWithContext(ctx aws.Context, input *DescribeResourcePolicyInput, opts ...request.Option) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSlot = "DescribeSlot"

// DescribeSlotRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSlot for more information on using the DescribeSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSlotRequest method.
//	req, resp := client.DescribeSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot
func (c *LexModelsV2) DescribeSlotRequest(input *DescribeSlotInput) (req *request.Request, output *DescribeSlotOutput) {
	op := &request.Operation{
		Name:       opDescribeSlot,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
	}

	if input == nil {
		input = &DescribeSlotInput{}
	}

	output = &DescribeSlotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSlot API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about a slot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot
func (c *LexModelsV2) DescribeSlot(input *DescribeSlotInput) (*DescribeSlotOutput, error) {
	req, out := c.DescribeSlotRequest(input)
	return out, req.Send()
}

// DescribeSlotWithContext is the same as DescribeSlot with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeSlotWithContext(ctx aws.Context, input *DescribeSlotInput, opts ...request.Option) (*DescribeSlotOutput, error) {
	req, out := c.DescribeSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSlotType = "DescribeSlotType"

// DescribeSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSlotType for more information on using the DescribeSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSlotTypeRequest method.
//	req, resp := client.DescribeSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType
func (c *LexModelsV2) DescribeSlotTypeRequest(input *DescribeSlotTypeInput) (req *request.Request, output *DescribeSlotTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeSlotType,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
	}

	if input == nil {
		input = &DescribeSlotTypeInput{}
	}

	output = &DescribeSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSlotType API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about a slot type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType
func (c *LexModelsV2) DescribeSlotType(input *DescribeSlotTypeInput) (*DescribeSlotTypeOutput, error) {
	req, out := c.DescribeSlotTypeRequest(input)
	return out, req.Send()
}

// DescribeSlotTypeWithContext is the same as DescribeSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeSlotTypeWithContext(ctx aws.Context, input *DescribeSlotTypeInput, opts ...request.Option) (*DescribeSlotTypeOutput, error) {
	req, out := c.DescribeSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestExecution = "DescribeTestExecution"

// DescribeTestExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestExecution for more information on using the DescribeTestExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestExecutionRequest method.
//	req, resp := client.DescribeTestExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution
func (c *LexModelsV2) DescribeTestExecutionRequest(input *DescribeTestExecutionInput) (req *request.Request, output *DescribeTestExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeTestExecution,
		HTTPMethod: "GET",
		HTTPPath:   "/testexecutions/{testExecutionId}",
	}

	if input == nil {
		input = &DescribeTestExecutionInput{}
	}

	output = &DescribeTestExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestExecution API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestExecution for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution
func (c *LexModelsV2) DescribeTestExecution(input *DescribeTestExecutionInput) (*DescribeTestExecutionOutput, error) {
	req, out := c.DescribeTestExecutionRequest(input)
	return out, req.Send()
}

// DescribeTestExecutionWithContext is the same as DescribeTestExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestExecutionWithContext(ctx aws.Context, input *DescribeTestExecutionInput, opts ...request.Option) (*DescribeTestExecutionOutput, error) {
	req, out := c.DescribeTestExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestSet = "DescribeTestSet"

// DescribeTestSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestSet for more information on using the DescribeTestSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestSetRequest method.
//	req, resp := client.DescribeTestSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet
func (c *LexModelsV2) DescribeTestSetRequest(input *DescribeTestSetInput) (req *request.Request, output *DescribeTestSetOutput) {
	op := &request.Operation{
		Name:       opDescribeTestSet,
		HTTPMethod: "GET",
		HTTPPath:   "/testsets/{testSetId}",
	}

	if input == nil {
		input = &DescribeTestSetInput{}
	}

	output = &DescribeTestSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestSet API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet
func (c *LexModelsV2) DescribeTestSet(input *DescribeTestSetInput) (*DescribeTestSetOutput, error) {
	req, out := c.DescribeTestSetRequest(input)
	return out, req.Send()
}

// DescribeTestSetWithContext is the same as DescribeTestSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestSetWithContext(ctx aws.Context, input *DescribeTestSetInput, opts ...request.Option) (*DescribeTestSetOutput, error) {
	req, out := c.DescribeTestSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestSetDiscrepancyReport = "DescribeTestSetDiscrepancyReport"

// DescribeTestSetDiscrepancyReportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestSetDiscrepancyReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestSetDiscrepancyReport for more information on using the DescribeTestSetDiscrepancyReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestSetDiscrepancyReportRequest method.
//	req, resp := client.DescribeTestSetDiscrepancyReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport
func (c *LexModelsV2) DescribeTestSetDiscrepancyReportRequest(input *DescribeTestSetDiscrepancyReportInput) (req *request.Request, output *DescribeTestSetDiscrepancyReportOutput) {
	op := &request.Operation{
		Name:       opDescribeTestSetDiscrepancyReport,
		HTTPMethod: "GET",
		HTTPPath:   "/testsetdiscrepancy/{testSetDiscrepancyReportId}",
	}

	if input == nil {
		input = &DescribeTestSetDiscrepancyReportInput{}
	}

	output = &DescribeTestSetDiscrepancyReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestSetDiscrepancyReport API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test set discrepancy report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestSetDiscrepancyReport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport
func (c *LexModelsV2) DescribeTestSetDiscrepancyReport(input *DescribeTestSetDiscrepancyReportInput) (*DescribeTestSetDiscrepancyReportOutput, error) {
	req, out := c.DescribeTestSetDiscrepancyReportRequest(input)
	return out, req.Send()
}

// DescribeTestSetDiscrepancyReportWithContext is the same as DescribeTestSetDiscrepancyReport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestSetDiscrepancyReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestSetDiscrepancyReportWithContext(ctx aws.Context, input *DescribeTestSetDiscrepancyReportInput, opts ...request.Option) (*DescribeTestSetDiscrepancyReportOutput, error) {
	req, out := c.DescribeTestSetDiscrepancyReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestSetGeneration = "DescribeTestSetGeneration"

// DescribeTestSetGenerationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestSetGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestSetGeneration for more information on using the DescribeTestSetGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestSetGenerationRequest method.
//	req, resp := client.DescribeTestSetGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration
func (c *LexModelsV2) DescribeTestSetGenerationRequest(input *DescribeTestSetGenerationInput) (req *request.Request, output *DescribeTestSetGenerationOutput) {
	op := &request.Operation{
		Name:       opDescribeTestSetGeneration,
		HTTPMethod: "GET",
		HTTPPath:   "/testsetgenerations/{testSetGenerationId}",
	}

	if input == nil {
		input = &DescribeTestSetGenerationInput{}
	}

	output = &DescribeTestSetGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestSetGeneration API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test set generation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestSetGeneration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration
func (c *LexModelsV2) DescribeTestSetGeneration(input *DescribeTestSetGenerationInput) (*DescribeTestSetGenerationOutput, error) {
	req, out := c.DescribeTestSetGenerationRequest(input)
	return out, req.Send()
}

// DescribeTestSetGenerationWithContext is the same as DescribeTestSetGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestSetGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestSetGenerationWithContext(ctx aws.Context, input *DescribeTestSetGenerationInput, opts ...request.Option) (*DescribeTestSetGenerationOutput, error) {
	req, out := c.DescribeTestSetGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateBotElement = "GenerateBotElement"

// GenerateBotElementRequest generates a "aws/request.Request" representing the
// client's request for the GenerateBotElement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateBotElement for more information on using the GenerateBotElement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateBotElementRequest method.
//	req, resp := client.GenerateBotElementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GenerateBotElement
func (c *LexModelsV2) GenerateBotElementRequest(input *GenerateBotElementInput) (req *request.Request, output *GenerateBotElementOutput) {
	op := &request.Operation{
		Name:       opGenerateBotElement,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/generate",
	}

	if input == nil {
		input = &GenerateBotElementInput{}
	}

	output = &GenerateBotElementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateBotElement API operation for Amazon Lex Model Building V2.
//
// Generates sample utterances for an intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation GenerateBotElement for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GenerateBotElement
func (c *LexModelsV2) GenerateBotElement(input *GenerateBotElementInput) (*GenerateBotElementOutput, error) {
	req, out := c.GenerateBotElementRequest(input)
	return out, req.Send()
}

// GenerateBotElementWithContext is the same as GenerateBotElement with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateBotElement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) GenerateBotElementWithContext(ctx aws.Context, input *GenerateBotElementInput, opts ...request.Option) (*GenerateBotElementOutput, error) {
	req, out := c.GenerateBotElementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestExecutionArtifactsUrl = "GetTestExecutionArtifactsUrl"

// GetTestExecutionArtifactsUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetTestExecutionArtifactsUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestExecutionArtifactsUrl for more information on using the GetTestExecutionArtifactsUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestExecutionArtifactsUrlRequest method.
//	req, resp := client.GetTestExecutionArtifactsUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl
func (c *LexModelsV2) GetTestExecutionArtifactsUrlRequest(input *GetTestExecutionArtifactsUrlInput) (req *request.Request, output *GetTestExecutionArtifactsUrlOutput) {
	op := &request.Operation{
		Name:       opGetTestExecutionArtifactsUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/testexecutions/{testExecutionId}/artifacturl",
	}

	if input == nil {
		input = &GetTestExecutionArtifactsUrlInput{}
	}

	output = &GetTestExecutionArtifactsUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestExecutionArtifactsUrl API operation for Amazon Lex Model Building V2.
//
// The pre-signed Amazon S3 URL to download the test execution result artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation GetTestExecutionArtifactsUrl for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl
func (c *LexModelsV2) GetTestExecutionArtifactsUrl(input *GetTestExecutionArtifactsUrlInput) (*GetTestExecutionArtifactsUrlOutput, error) {
	req, out := c.GetTestExecutionArtifactsUrlRequest(input)
	return out, req.Send()
}

// GetTestExecutionArtifactsUrlWithContext is the same as GetTestExecutionArtifactsUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestExecutionArtifactsUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) GetTestExecutionArtifactsUrlWithContext(ctx aws.Context, input *GetTestExecutionArtifactsUrlInput, opts ...request.Option) (*GetTestExecutionArtifactsUrlOutput, error) {
	req, out := c.GetTestExecutionArtifactsUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAggregatedUtterances = "ListAggregatedUtterances"

// ListAggregatedUtterancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAggregatedUtterances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAggregatedUtterances for more information on using the ListAggregatedUtterances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAggregatedUtterancesRequest method.
//	req, resp := client.ListAggregatedUtterancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances
func (c *LexModelsV2) ListAggregatedUtterancesRequest(input *ListAggregatedUtterancesInput) (req *request.Request, output *ListAggregatedUtterancesOutput) {
	op := &request.Operation{
		Name:       opListAggregatedUtterances,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/aggregatedutterances/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAggregatedUtterancesInput{}
	}

	output = &ListAggregatedUtterancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAggregatedUtterances API operation for Amazon Lex Model Building V2.
//
// Provides a list of utterances that users have sent to the bot.
//
// Utterances are aggregated by the text of the utterance. For example, all
// instances where customers used the phrase "I want to order pizza" are aggregated
// into the same line in the response.
//
// You can see both detected utterances and missed utterances. A detected utterance
// is where the bot properly recognized the utterance and activated the associated
// intent. A missed utterance was not recognized by the bot and didn't activate
// an intent.
//
// Utterances can be aggregated for a bot alias or for a bot version, but not
// both at the same time.
//
// Utterances statistics are not generated under the following conditions:
//
//   - The childDirected field was set to true when the bot was created.
//
//   - You are using slot obfuscation with one or more slots.
//
//   - You opted out of participating in improving Amazon Lex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListAggregatedUtterances for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances
func (c *LexModelsV2) ListAggregatedUtterances(input *ListAggregatedUtterancesInput) (*ListAggregatedUtterancesOutput, error) {
	req, out := c.ListAggregatedUtterancesRequest(input)
	return out, req.Send()
}

// ListAggregatedUtterancesWithContext is the same as ListAggregatedUtterances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAggregatedUtterances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListAggregatedUtterancesWithContext(ctx aws.Context, input *ListAggregatedUtterancesInput, opts ...request.Option) (*ListAggregatedUtterancesOutput, error) {
	req, out := c.ListAggregatedUtterancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAggregatedUtterancesPages iterates over the pages of a ListAggregatedUtterances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAggregatedUtterances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAggregatedUtterances operation.
//	pageNum := 0
//	err := client.ListAggregatedUtterancesPages(params,
//	    func(page *lexmodelsv2.ListAggregatedUtterancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListAggregatedUtterancesPages(input *ListAggregatedUtterancesInput, fn func(*ListAggregatedUtterancesOutput, bool) bool) error {
	return c.ListAggregatedUtterancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAggregatedUtterancesPagesWithContext same as ListAggregatedUtterancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListAggregatedUtterancesPagesWithContext(ctx aws.Context, input *ListAggregatedUtterancesInput, fn func(*ListAggregatedUtterancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAggregatedUtterancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAggregatedUtterancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAggregatedUtterancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotAliasReplicas = "ListBotAliasReplicas"

// ListBotAliasReplicasRequest generates a "aws/request.Request" representing the
// client's request for the ListBotAliasReplicas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotAliasReplicas for more information on using the ListBotAliasReplicas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotAliasReplicasRequest method.
//	req, resp := client.ListBotAliasReplicasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliasReplicas
func (c *LexModelsV2) ListBotAliasReplicasRequest(input *ListBotAliasReplicasInput) (req *request.Request, output *ListBotAliasReplicasOutput) {
	op := &request.Operation{
		Name:       opListBotAliasReplicas,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/replicas/{replicaRegion}/botaliases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotAliasReplicasInput{}
	}

	output = &ListBotAliasReplicasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotAliasReplicas API operation for Amazon Lex Model Building V2.
//
// The action to list the replicated bots created from the source bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotAliasReplicas for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliasReplicas
func (c *LexModelsV2) ListBotAliasReplicas(input *ListBotAliasReplicasInput) (*ListBotAliasReplicasOutput, error) {
	req, out := c.ListBotAliasReplicasRequest(input)
	return out, req.Send()
}

// ListBotAliasReplicasWithContext is the same as ListBotAliasReplicas with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotAliasReplicas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotAliasReplicasWithContext(ctx aws.Context, input *ListBotAliasReplicasInput, opts ...request.Option) (*ListBotAliasReplicasOutput, error) {
	req, out := c.ListBotAliasReplicasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotAliasReplicasPages iterates over the pages of a ListBotAliasReplicas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotAliasReplicas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotAliasReplicas operation.
//	pageNum := 0
//	err := client.ListBotAliasReplicasPages(params,
//	    func(page *lexmodelsv2.ListBotAliasReplicasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotAliasReplicasPages(input *ListBotAliasReplicasInput, fn func(*ListBotAliasReplicasOutput, bool) bool) error {
	return c.ListBotAliasReplicasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotAliasReplicasPagesWithContext same as ListBotAliasReplicasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotAliasReplicasPagesWithContext(ctx aws.Context, input *ListBotAliasReplicasInput, fn func(*ListBotAliasReplicasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotAliasReplicasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotAliasReplicasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotAliasReplicasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotAliases = "ListBotAliases"

// ListBotAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListBotAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotAliases for more information on using the ListBotAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotAliasesRequest method.
//	req, resp := client.ListBotAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases
func (c *LexModelsV2) ListBotAliasesRequest(input *ListBotAliasesInput) (req *request.Request, output *ListBotAliasesOutput) {
	op := &request.Operation{
		Name:       opListBotAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botaliases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotAliasesInput{}
	}

	output = &ListBotAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotAliases API operation for Amazon Lex Model Building V2.
//
// Gets a list of aliases for the specified bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotAliases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases
func (c *LexModelsV2) ListBotAliases(input *ListBotAliasesInput) (*ListBotAliasesOutput, error) {
	req, out := c.ListBotAliasesRequest(input)
	return out, req.Send()
}

// ListBotAliasesWithContext is the same as ListBotAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotAliasesWithContext(ctx aws.Context, input *ListBotAliasesInput, opts ...request.Option) (*ListBotAliasesOutput, error) {
	req, out := c.ListBotAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotAliasesPages iterates over the pages of a ListBotAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotAliases operation.
//	pageNum := 0
//	err := client.ListBotAliasesPages(params,
//	    func(page *lexmodelsv2.ListBotAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotAliasesPages(input *ListBotAliasesInput, fn func(*ListBotAliasesOutput, bool) bool) error {
	return c.ListBotAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotAliasesPagesWithContext same as ListBotAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotAliasesPagesWithContext(ctx aws.Context, input *ListBotAliasesInput, fn func(*ListBotAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotLocales = "ListBotLocales"

// ListBotLocalesRequest generates a "aws/request.Request" representing the
// client's request for the ListBotLocales operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotLocales for more information on using the ListBotLocales
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotLocalesRequest method.
//	req, resp := client.ListBotLocalesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales
func (c *LexModelsV2) ListBotLocalesRequest(input *ListBotLocalesInput) (req *request.Request, output *ListBotLocalesOutput) {
	op := &request.Operation{
		Name:       opListBotLocales,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotLocalesInput{}
	}

	output = &ListBotLocalesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotLocales API operation for Amazon Lex Model Building V2.
//
// Gets a list of locales for the specified bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotLocales for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales
func (c *LexModelsV2) ListBotLocales(input *ListBotLocalesInput) (*ListBotLocalesOutput, error) {
	req, out := c.ListBotLocalesRequest(input)
	return out, req.Send()
}

// ListBotLocalesWithContext is the same as ListBotLocales with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotLocales for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotLocalesWithContext(ctx aws.Context, input *ListBotLocalesInput, opts ...request.Option) (*ListBotLocalesOutput, error) {
	req, out := c.ListBotLocalesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotLocalesPages iterates over the pages of a ListBotLocales operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotLocales method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotLocales operation.
//	pageNum := 0
//	err := client.ListBotLocalesPages(params,
//	    func(page *lexmodelsv2.ListBotLocalesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotLocalesPages(input *ListBotLocalesInput, fn func(*ListBotLocalesOutput, bool) bool) error {
	return c.ListBotLocalesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotLocalesPagesWithContext same as ListBotLocalesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotLocalesPagesWithContext(ctx aws.Context, input *ListBotLocalesInput, fn func(*ListBotLocalesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotLocalesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotLocalesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotLocalesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotRecommendations = "ListBotRecommendations"

// ListBotRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBotRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotRecommendations for more information on using the ListBotRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotRecommendationsRequest method.
//	req, resp := client.ListBotRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations
func (c *LexModelsV2) ListBotRecommendationsRequest(input *ListBotRecommendationsInput) (req *request.Request, output *ListBotRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListBotRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotRecommendationsInput{}
	}

	output = &ListBotRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotRecommendations API operation for Amazon Lex Model Building V2.
//
// Get a list of bot recommendations that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations
func (c *LexModelsV2) ListBotRecommendations(input *ListBotRecommendationsInput) (*ListBotRecommendationsOutput, error) {
	req, out := c.ListBotRecommendationsRequest(input)
	return out, req.Send()
}

// ListBotRecommendationsWithContext is the same as ListBotRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotRecommendationsWithContext(ctx aws.Context, input *ListBotRecommendationsInput, opts ...request.Option) (*ListBotRecommendationsOutput, error) {
	req, out := c.ListBotRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotRecommendationsPages iterates over the pages of a ListBotRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotRecommendations operation.
//	pageNum := 0
//	err := client.ListBotRecommendationsPages(params,
//	    func(page *lexmodelsv2.ListBotRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotRecommendationsPages(input *ListBotRecommendationsInput, fn func(*ListBotRecommendationsOutput, bool) bool) error {
	return c.ListBotRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotRecommendationsPagesWithContext same as ListBotRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotRecommendationsPagesWithContext(ctx aws.Context, input *ListBotRecommendationsInput, fn func(*ListBotRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotReplicas = "ListBotReplicas"

// ListBotReplicasRequest generates a "aws/request.Request" representing the
// client's request for the ListBotReplicas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotReplicas for more information on using the ListBotReplicas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotReplicasRequest method.
//	req, resp := client.ListBotReplicasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotReplicas
func (c *LexModelsV2) ListBotReplicasRequest(input *ListBotReplicasInput) (req *request.Request, output *ListBotReplicasOutput) {
	op := &request.Operation{
		Name:       opListBotReplicas,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/replicas/",
	}

	if input == nil {
		input = &ListBotReplicasInput{}
	}

	output = &ListBotReplicasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotReplicas API operation for Amazon Lex Model Building V2.
//
// The action to list the replicated bots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotReplicas for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotReplicas
func (c *LexModelsV2) ListBotReplicas(input *ListBotReplicasInput) (*ListBotReplicasOutput, error) {
	req, out := c.ListBotReplicasRequest(input)
	return out, req.Send()
}

// ListBotReplicasWithContext is the same as ListBotReplicas with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotReplicas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotReplicasWithContext(ctx aws.Context, input *ListBotReplicasInput, opts ...request.Option) (*ListBotReplicasOutput, error) {
	req, out := c.ListBotReplicasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBotResourceGenerations = "ListBotResourceGenerations"

// ListBotResourceGenerationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBotResourceGenerations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotResourceGenerations for more information on using the ListBotResourceGenerations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotResourceGenerationsRequest method.
//	req, resp := client.ListBotResourceGenerationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotResourceGenerations
func (c *LexModelsV2) ListBotResourceGenerationsRequest(input *ListBotResourceGenerationsInput) (req *request.Request, output *ListBotResourceGenerationsOutput) {
	op := &request.Operation{
		Name:       opListBotResourceGenerations,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/generations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotResourceGenerationsInput{}
	}

	output = &ListBotResourceGenerationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotResourceGenerations API operation for Amazon Lex Model Building V2.
//
// Lists the generation requests made for a bot locale.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotResourceGenerations for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotResourceGenerations
func (c *LexModelsV2) ListBotResourceGenerations(input *ListBotResourceGenerationsInput) (*ListBotResourceGenerationsOutput, error) {
	req, out := c.ListBotResourceGenerationsRequest(input)
	return out, req.Send()
}

// ListBotResourceGenerationsWithContext is the same as ListBotResourceGenerations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotResourceGenerations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotResourceGenerationsWithContext(ctx aws.Context, input *ListBotResourceGenerationsInput, opts ...request.Option) (*ListBotResourceGenerationsOutput, error) {
	req, out := c.ListBotResourceGenerationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotResourceGenerationsPages iterates over the pages of a ListBotResourceGenerations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotResourceGenerations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotResourceGenerations operation.
//	pageNum := 0
//	err := client.ListBotResourceGenerationsPages(params,
//	    func(page *lexmodelsv2.ListBotResourceGenerationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotResourceGenerationsPages(input *ListBotResourceGenerationsInput, fn func(*ListBotResourceGenerationsOutput, bool) bool) error {
	return c.ListBotResourceGenerationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotResourceGenerationsPagesWithContext same as ListBotResourceGenerationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotResourceGenerationsPagesWithContext(ctx aws.Context, input *ListBotResourceGenerationsInput, fn func(*ListBotResourceGenerationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotResourceGenerationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotResourceGenerationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotResourceGenerationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotVersionReplicas = "ListBotVersionReplicas"

// ListBotVersionReplicasRequest generates a "aws/request.Request" representing the
// client's request for the ListBotVersionReplicas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotVersionReplicas for more information on using the ListBotVersionReplicas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotVersionReplicasRequest method.
//	req, resp := client.ListBotVersionReplicasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersionReplicas
func (c *LexModelsV2) ListBotVersionReplicasRequest(input *ListBotVersionReplicasInput) (req *request.Request, output *ListBotVersionReplicasOutput) {
	op := &request.Operation{
		Name:       opListBotVersionReplicas,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/replicas/{replicaRegion}/botversions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotVersionReplicasInput{}
	}

	output = &ListBotVersionReplicasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotVersionReplicas API operation for Amazon Lex Model Building V2.
//
// Contains information about all the versions replication statuses applicable
// for Global Resiliency.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotVersionReplicas for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersionReplicas
func (c *LexModelsV2) ListBotVersionReplicas(input *ListBotVersionReplicasInput) (*ListBotVersionReplicasOutput, error) {
	req, out := c.ListBotVersionReplicasRequest(input)
	return out, req.Send()
}

// ListBotVersionReplicasWithContext is the same as ListBotVersionReplicas with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotVersionReplicas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotVersionReplicasWithContext(ctx aws.Context, input *ListBotVersionReplicasInput, opts ...request.Option) (*ListBotVersionReplicasOutput, error) {
	req, out := c.ListBotVersionReplicasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotVersionReplicasPages iterates over the pages of a ListBotVersionReplicas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotVersionReplicas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotVersionReplicas operation.
//	pageNum := 0
//	err := client.ListBotVersionReplicasPages(params,
//	    func(page *lexmodelsv2.ListBotVersionReplicasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotVersionReplicasPages(input *ListBotVersionReplicasInput, fn func(*ListBotVersionReplicasOutput, bool) bool) error {
	return c.ListBotVersionReplicasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotVersionReplicasPagesWithContext same as ListBotVersionReplicasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotVersionReplicasPagesWithContext(ctx aws.Context, input *ListBotVersionReplicasInput, fn func(*ListBotVersionReplicasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotVersionReplicasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotVersionReplicasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotVersionReplicasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotVersions = "ListBotVersions"

// ListBotVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBotVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotVersions for more information on using the ListBotVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotVersionsRequest method.
//	req, resp := client.ListBotVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions
func (c *LexModelsV2) ListBotVersionsRequest(input *ListBotVersionsInput) (req *request.Request, output *ListBotVersionsOutput) {
	op := &request.Operation{
		Name:       opListBotVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotVersionsInput{}
	}

	output = &ListBotVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotVersions API operation for Amazon Lex Model Building V2.
//
// Gets information about all of the versions of a bot.
//
// The ListBotVersions operation returns a summary of each version of a bot.
// For example, if a bot has three numbered versions, the ListBotVersions operation
// returns for summaries, one for each numbered version and one for the DRAFT
// version.
//
// The ListBotVersions operation always returns at least one version, the DRAFT
// version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions
func (c *LexModelsV2) ListBotVersions(input *ListBotVersionsInput) (*ListBotVersionsOutput, error) {
	req, out := c.ListBotVersionsRequest(input)
	return out, req.Send()
}

// ListBotVersionsWithContext is the same as ListBotVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotVersionsWithContext(ctx aws.Context, input *ListBotVersionsInput, opts ...request.Option) (*ListBotVersionsOutput, error) {
	req, out := c.ListBotVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotVersionsPages iterates over the pages of a ListBotVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotVersions operation.
//	pageNum := 0
//	err := client.ListBotVersionsPages(params,
//	    func(page *lexmodelsv2.ListBotVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotVersionsPages(input *ListBotVersionsInput, fn func(*ListBotVersionsOutput, bool) bool) error {
	return c.ListBotVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotVersionsPagesWithContext same as ListBotVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotVersionsPagesWithContext(ctx aws.Context, input *ListBotVersionsInput, fn func(*ListBotVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBots = "ListBots"

// ListBotsRequest generates a "aws/request.Request" representing the
// client's request for the ListBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBots for more information on using the ListBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotsRequest method.
//	req, resp := client.ListBotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots
func (c *LexModelsV2) ListBotsRequest(input *ListBotsInput) (req *request.Request, output *ListBotsOutput) {
	op := &request.Operation{
		Name:       opListBots,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotsInput{}
	}

	output = &ListBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBots API operation for Amazon Lex Model Building V2.
//
// Gets a list of available bots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBots for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots
func (c *LexModelsV2) ListBots(input *ListBotsInput) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	return out, req.Send()
}

// ListBotsWithContext is the same as ListBots with the addition of
// the ability to pass a context and additional request options.
//
// See ListBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotsWithContext(ctx aws.Context, input *ListBotsInput, opts ...request.Option) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotsPages iterates over the pages of a ListBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBots operation.
//	pageNum := 0
//	err := client.ListBotsPages(params,
//	    func(page *lexmodelsv2.ListBotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotsPages(input *ListBotsInput, fn func(*ListBotsOutput, bool) bool) error {
	return c.ListBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotsPagesWithContext same as ListBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotsPagesWithContext(ctx aws.Context, input *ListBotsInput, fn func(*ListBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBuiltInIntents = "ListBuiltInIntents"

// ListBuiltInIntentsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuiltInIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuiltInIntents for more information on using the ListBuiltInIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBuiltInIntentsRequest method.
//	req, resp := client.ListBuiltInIntentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents
func (c *LexModelsV2) ListBuiltInIntentsRequest(input *ListBuiltInIntentsInput) (req *request.Request, output *ListBuiltInIntentsOutput) {
	op := &request.Operation{
		Name:       opListBuiltInIntents,
		HTTPMethod: "POST",
		HTTPPath:   "/builtins/locales/{localeId}/intents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBuiltInIntentsInput{}
	}

	output = &ListBuiltInIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuiltInIntents API operation for Amazon Lex Model Building V2.
//
// Gets a list of built-in intents provided by Amazon Lex that you can use in
// your bot.
//
// To use a built-in intent as a the base for your own intent, include the built-in
// intent signature in the parentIntentSignature parameter when you call the
// CreateIntent operation. For more information, see CreateIntent (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBuiltInIntents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents
func (c *LexModelsV2) ListBuiltInIntents(input *ListBuiltInIntentsInput) (*ListBuiltInIntentsOutput, error) {
	req, out := c.ListBuiltInIntentsRequest(input)
	return out, req.Send()
}

// ListBuiltInIntentsWithContext is the same as ListBuiltInIntents with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuiltInIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInIntentsWithContext(ctx aws.Context, input *ListBuiltInIntentsInput, opts ...request.Option) (*ListBuiltInIntentsOutput, error) {
	req, out := c.ListBuiltInIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBuiltInIntentsPages iterates over the pages of a ListBuiltInIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBuiltInIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBuiltInIntents operation.
//	pageNum := 0
//	err := client.ListBuiltInIntentsPages(params,
//	    func(page *lexmodelsv2.ListBuiltInIntentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBuiltInIntentsPages(input *ListBuiltInIntentsInput, fn func(*ListBuiltInIntentsOutput, bool) bool) error {
	return c.ListBuiltInIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBuiltInIntentsPagesWithContext same as ListBuiltInIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInIntentsPagesWithContext(ctx aws.Context, input *ListBuiltInIntentsInput, fn func(*ListBuiltInIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBuiltInIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBuiltInIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBuiltInIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBuiltInSlotTypes = "ListBuiltInSlotTypes"

// ListBuiltInSlotTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListBuiltInSlotTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuiltInSlotTypes for more information on using the ListBuiltInSlotTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBuiltInSlotTypesRequest method.
//	req, resp := client.ListBuiltInSlotTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes
func (c *LexModelsV2) ListBuiltInSlotTypesRequest(input *ListBuiltInSlotTypesInput) (req *request.Request, output *ListBuiltInSlotTypesOutput) {
	op := &request.Operation{
		Name:       opListBuiltInSlotTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/builtins/locales/{localeId}/slottypes/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBuiltInSlotTypesInput{}
	}

	output = &ListBuiltInSlotTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuiltInSlotTypes API operation for Amazon Lex Model Building V2.
//
// Gets a list of built-in slot types that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBuiltInSlotTypes for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes
func (c *LexModelsV2) ListBuiltInSlotTypes(input *ListBuiltInSlotTypesInput) (*ListBuiltInSlotTypesOutput, error) {
	req, out := c.ListBuiltInSlotTypesRequest(input)
	return out, req.Send()
}

// ListBuiltInSlotTypesWithContext is the same as ListBuiltInSlotTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuiltInSlotTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInSlotTypesWithContext(ctx aws.Context, input *ListBuiltInSlotTypesInput, opts ...request.Option) (*ListBuiltInSlotTypesOutput, error) {
	req, out := c.ListBuiltInSlotTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBuiltInSlotTypesPages iterates over the pages of a ListBuiltInSlotTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBuiltInSlotTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBuiltInSlotTypes operation.
//	pageNum := 0
//	err := client.ListBuiltInSlotTypesPages(params,
//	    func(page *lexmodelsv2.ListBuiltInSlotTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBuiltInSlotTypesPages(input *ListBuiltInSlotTypesInput, fn func(*ListBuiltInSlotTypesOutput, bool) bool) error {
	return c.ListBuiltInSlotTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBuiltInSlotTypesPagesWithContext same as ListBuiltInSlotTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInSlotTypesPagesWithContext(ctx aws.Context, input *ListBuiltInSlotTypesInput, fn func(*ListBuiltInSlotTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBuiltInSlotTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBuiltInSlotTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBuiltInSlotTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomVocabularyItems = "ListCustomVocabularyItems"

// ListCustomVocabularyItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomVocabularyItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomVocabularyItems for more information on using the ListCustomVocabularyItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomVocabularyItemsRequest method.
//	req, resp := client.ListCustomVocabularyItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems
func (c *LexModelsV2) ListCustomVocabularyItemsRequest(input *ListCustomVocabularyItemsInput) (req *request.Request, output *ListCustomVocabularyItemsOutput) {
	op := &request.Operation{
		Name:       opListCustomVocabularyItems,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomVocabularyItemsInput{}
	}

	output = &ListCustomVocabularyItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomVocabularyItems API operation for Amazon Lex Model Building V2.
//
// Paginated list of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListCustomVocabularyItems for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems
func (c *LexModelsV2) ListCustomVocabularyItems(input *ListCustomVocabularyItemsInput) (*ListCustomVocabularyItemsOutput, error) {
	req, out := c.ListCustomVocabularyItemsRequest(input)
	return out, req.Send()
}

// ListCustomVocabularyItemsWithContext is the same as ListCustomVocabularyItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomVocabularyItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListCustomVocabularyItemsWithContext(ctx aws.Context, input *ListCustomVocabularyItemsInput, opts ...request.Option) (*ListCustomVocabularyItemsOutput, error) {
	req, out := c.ListCustomVocabularyItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomVocabularyItemsPages iterates over the pages of a ListCustomVocabularyItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomVocabularyItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomVocabularyItems operation.
//	pageNum := 0
//	err := client.ListCustomVocabularyItemsPages(params,
//	    func(page *lexmodelsv2.ListCustomVocabularyItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListCustomVocabularyItemsPages(input *ListCustomVocabularyItemsInput, fn func(*ListCustomVocabularyItemsOutput, bool) bool) error {
	return c.ListCustomVocabularyItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomVocabularyItemsPagesWithContext same as ListCustomVocabularyItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListCustomVocabularyItemsPagesWithContext(ctx aws.Context, input *ListCustomVocabularyItemsInput, fn func(*ListCustomVocabularyItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomVocabularyItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomVocabularyItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomVocabularyItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExports = "ListExports"

// ListExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListExports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExports for more information on using the ListExports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExportsRequest method.
//	req, resp := client.ListExportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports
func (c *LexModelsV2) ListExportsRequest(input *ListExportsInput) (req *request.Request, output *ListExportsOutput) {
	op := &request.Operation{
		Name:       opListExports,
		HTTPMethod: "POST",
		HTTPPath:   "/exports/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExportsInput{}
	}

	output = &ListExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExports API operation for Amazon Lex Model Building V2.
//
// Lists the exports for a bot, bot locale, or custom vocabulary. Exports are
// kept in the list for 7 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListExports for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports
func (c *LexModelsV2) ListExports(input *ListExportsInput) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	return out, req.Send()
}

// ListExportsWithContext is the same as ListExports with the addition of
// the ability to pass a context and additional request options.
//
// See ListExports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListExportsWithContext(ctx aws.Context, input *ListExportsInput, opts ...request.Option) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExportsPages iterates over the pages of a ListExports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExports operation.
//	pageNum := 0
//	err := client.ListExportsPages(params,
//	    func(page *lexmodelsv2.ListExportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListExportsPages(input *ListExportsInput, fn func(*ListExportsOutput, bool) bool) error {
	return c.ListExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExportsPagesWithContext same as ListExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListExportsPagesWithContext(ctx aws.Context, input *ListExportsInput, fn func(*ListExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImports = "ListImports"

// ListImportsRequest generates a "aws/request.Request" representing the
// client's request for the ListImports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImports for more information on using the ListImports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImportsRequest method.
//	req, resp := client.ListImportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports
func (c *LexModelsV2) ListImportsRequest(input *ListImportsInput) (req *request.Request, output *ListImportsOutput) {
	op := &request.Operation{
		Name:       opListImports,
		HTTPMethod: "POST",
		HTTPPath:   "/imports/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImportsInput{}
	}

	output = &ListImportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImports API operation for Amazon Lex Model Building V2.
//
// Lists the imports for a bot, bot locale, or custom vocabulary. Imports are
// kept in the list for 7 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListImports for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports
func (c *LexModelsV2) ListImports(input *ListImportsInput) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	return out, req.Send()
}

// ListImportsWithContext is the same as ListImports with the addition of
// the ability to pass a context and additional request options.
//
// See ListImports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListImportsWithContext(ctx aws.Context, input *ListImportsInput, opts ...request.Option) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImportsPages iterates over the pages of a ListImports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImports operation.
//	pageNum := 0
//	err := client.ListImportsPages(params,
//	    func(page *lexmodelsv2.ListImportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListImportsPages(input *ListImportsInput, fn func(*ListImportsOutput, bool) bool) error {
	return c.ListImportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImportsPagesWithContext same as ListImportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListImportsPagesWithContext(ctx aws.Context, input *ListImportsInput, fn func(*ListImportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIntentMetrics = "ListIntentMetrics"

// ListIntentMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntentMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntentMetrics for more information on using the ListIntentMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIntentMetricsRequest method.
//	req, resp := client.ListIntentMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics
func (c *LexModelsV2) ListIntentMetricsRequest(input *ListIntentMetricsInput) (req *request.Request, output *ListIntentMetricsOutput) {
	op := &request.Operation{
		Name:       opListIntentMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/analytics/intentmetrics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIntentMetricsInput{}
	}

	output = &ListIntentMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntentMetrics API operation for Amazon Lex Model Building V2.
//
// Retrieves summary metrics for the intents in your bot. The following fields
// are required:
//
//   - metrics – A list of AnalyticsIntentMetric (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html)
//     objects. In each object, use the name field to specify the metric to calculate,
//     the statistic field to specify whether to calculate the Sum, Average,
//     or Max number, and the order field to specify whether to sort the results
//     in Ascending or Descending order.
//
//   - startDateTime and endDateTime – Define a time range for which you
//     want to retrieve results.
//
// Of the optional fields, you can organize the results in the following ways:
//
//   - Use the filters field to filter the results, the groupBy field to specify
//     categories by which to group the results, and the binBy field to specify
//     time intervals by which to group the results.
//
//   - Use the maxResults field to limit the number of results to return in
//     a single response and the nextToken field to return the next batch of
//     results if the response does not return the full set of results.
//
// Note that an order field exists in both binBy and metrics. You can specify
// only one order in a given request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListIntentMetrics for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics
func (c *LexModelsV2) ListIntentMetrics(input *ListIntentMetricsInput) (*ListIntentMetricsOutput, error) {
	req, out := c.ListIntentMetricsRequest(input)
	return out, req.Send()
}

// ListIntentMetricsWithContext is the same as ListIntentMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntentMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentMetricsWithContext(ctx aws.Context, input *ListIntentMetricsInput, opts ...request.Option) (*ListIntentMetricsOutput, error) {
	req, out := c.ListIntentMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIntentMetricsPages iterates over the pages of a ListIntentMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIntentMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIntentMetrics operation.
//	pageNum := 0
//	err := client.ListIntentMetricsPages(params,
//	    func(page *lexmodelsv2.ListIntentMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListIntentMetricsPages(input *ListIntentMetricsInput, fn func(*ListIntentMetricsOutput, bool) bool) error {
	return c.ListIntentMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIntentMetricsPagesWithContext same as ListIntentMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentMetricsPagesWithContext(ctx aws.Context, input *ListIntentMetricsInput, fn func(*ListIntentMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIntentMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIntentMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIntentMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIntentPaths = "ListIntentPaths"

// ListIntentPathsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntentPaths operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntentPaths for more information on using the ListIntentPaths
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIntentPathsRequest method.
//	req, resp := client.ListIntentPathsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentPaths
func (c *LexModelsV2) ListIntentPathsRequest(input *ListIntentPathsInput) (req *request.Request, output *ListIntentPathsOutput) {
	op := &request.Operation{
		Name:       opListIntentPaths,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/analytics/intentpaths",
	}

	if input == nil {
		input = &ListIntentPathsInput{}
	}

	output = &ListIntentPathsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntentPaths API operation for Amazon Lex Model Building V2.
//
// Retrieves summary statistics for a path of intents that users take over sessions
// with your bot. The following fields are required:
//
//   - startDateTime and endDateTime – Define a time range for which you
//     want to retrieve results.
//
//   - intentPath – Define an order of intents for which you want to retrieve
//     metrics. Separate intents in the path with a forward slash. For example,
//     populate the intentPath field with /BookCar/BookHotel to see details about
//     how many times users invoked the BookCar and BookHotel intents in that
//     order.
//
// Use the optional filters field to filter the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListIntentPaths for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentPaths
func (c *LexModelsV2) ListIntentPaths(input *ListIntentPathsInput) (*ListIntentPathsOutput, error) {
	req, out := c.ListIntentPathsRequest(input)
	return out, req.Send()
}

// ListIntentPathsWithContext is the same as ListIntentPaths with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntentPaths for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentPathsWithContext(ctx aws.Context, input *ListIntentPathsInput, opts ...request.Option) (*ListIntentPathsOutput, error) {
	req, out := c.ListIntentPathsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIntentStageMetrics = "ListIntentStageMetrics"

// ListIntentStageMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntentStageMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntentStageMetrics for more information on using the ListIntentStageMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIntentStageMetricsRequest method.
//	req, resp := client.ListIntentStageMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics
func (c *LexModelsV2) ListIntentStageMetricsRequest(input *ListIntentStageMetricsInput) (req *request.Request, output *ListIntentStageMetricsOutput) {
	op := &request.Operation{
		Name:       opListIntentStageMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/analytics/intentstagemetrics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIntentStageMetricsInput{}
	}

	output = &ListIntentStageMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntentStageMetrics API operation for Amazon Lex Model Building V2.
//
// Retrieves summary metrics for the stages within intents in your bot. The
// following fields are required:
//
//   - metrics – A list of AnalyticsIntentStageMetric (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html)
//     objects. In each object, use the name field to specify the metric to calculate,
//     the statistic field to specify whether to calculate the Sum, Average,
//     or Max number, and the order field to specify whether to sort the results
//     in Ascending or Descending order.
//
//   - startDateTime and endDateTime – Define a time range for which you
//     want to retrieve results.
//
// Of the optional fields, you can organize the results in the following ways:
//
//   - Use the filters field to filter the results, the groupBy field to specify
//     categories by which to group the results, and the binBy field to specify
//     time intervals by which to group the results.
//
//   - Use the maxResults field to limit the number of results to return in
//     a single response and the nextToken field to return the next batch of
//     results if the response does not return the full set of results.
//
// Note that an order field exists in both binBy and metrics. You can only specify
// one order in a given request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListIntentStageMetrics for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics
func (c *LexModelsV2) ListIntentStageMetrics(input *ListIntentStageMetricsInput) (*ListIntentStageMetricsOutput, error) {
	req, out := c.ListIntentStageMetricsRequest(input)
	return out, req.Send()
}

// ListIntentStageMetricsWithContext is the same as ListIntentStageMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntentStageMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentStageMetricsWithContext(ctx aws.Context, input *ListIntentStageMetricsInput, opts ...request.Option) (*ListIntentStageMetricsOutput, error) {
	req, out := c.ListIntentStageMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIntentStageMetricsPages iterates over the pages of a ListIntentStageMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIntentStageMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIntentStageMetrics operation.
//	pageNum := 0
//	err := client.ListIntentStageMetricsPages(params,
//	    func(page *lexmodelsv2.ListIntentStageMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListIntentStageMetricsPages(input *ListIntentStageMetricsInput, fn func(*ListIntentStageMetricsOutput, bool) bool) error {
	return c.ListIntentStageMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIntentStageMetricsPagesWithContext same as ListIntentStageMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentStageMetricsPagesWithContext(ctx aws.Context, input *ListIntentStageMetricsInput, fn func(*ListIntentStageMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIntentStageMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIntentStageMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIntentStageMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIntents = "ListIntents"

// ListIntentsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntents for more information on using the ListIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIntentsRequest method.
//	req, resp := client.ListIntentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents
func (c *LexModelsV2) ListIntentsRequest(input *ListIntentsInput) (req *request.Request, output *ListIntentsOutput) {
	op := &request.Operation{
		Name:       opListIntents,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIntentsInput{}
	}

	output = &ListIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntents API operation for Amazon Lex Model Building V2.
//
// Get a list of intents that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListIntents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents
func (c *LexModelsV2) ListIntents(input *ListIntentsInput) (*ListIntentsOutput, error) {
	req, out := c.ListIntentsRequest(input)
	return out, req.Send()
}

// ListIntentsWithContext is the same as ListIntents with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentsWithContext(ctx aws.Context, input *ListIntentsInput, opts ...request.Option) (*ListIntentsOutput, error) {
	req, out := c.ListIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIntentsPages iterates over the pages of a ListIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIntents operation.
//	pageNum := 0
//	err := client.ListIntentsPages(params,
//	    func(page *lexmodelsv2.ListIntentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListIntentsPages(input *ListIntentsInput, fn func(*ListIntentsOutput, bool) bool) error {
	return c.ListIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIntentsPagesWithContext same as ListIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentsPagesWithContext(ctx aws.Context, input *ListIntentsInput, fn func(*ListIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendedIntents = "ListRecommendedIntents"

// ListRecommendedIntentsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendedIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendedIntents for more information on using the ListRecommendedIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendedIntentsRequest method.
//	req, resp := client.ListRecommendedIntentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents
func (c *LexModelsV2) ListRecommendedIntentsRequest(input *ListRecommendedIntentsInput) (req *request.Request, output *ListRecommendedIntentsOutput) {
	op := &request.Operation{
		Name:       opListRecommendedIntents,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/intents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendedIntentsInput{}
	}

	output = &ListRecommendedIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendedIntents API operation for Amazon Lex Model Building V2.
//
// Gets a list of recommended intents provided by the bot recommendation that
// you can use in your bot. Intents in the response are ordered by relevance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListRecommendedIntents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents
func (c *LexModelsV2) ListRecommendedIntents(input *ListRecommendedIntentsInput) (*ListRecommendedIntentsOutput, error) {
	req, out := c.ListRecommendedIntentsRequest(input)
	return out, req.Send()
}

// ListRecommendedIntentsWithContext is the same as ListRecommendedIntents with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendedIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListRecommendedIntentsWithContext(ctx aws.Context, input *ListRecommendedIntentsInput, opts ...request.Option) (*ListRecommendedIntentsOutput, error) {
	req, out := c.ListRecommendedIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendedIntentsPages iterates over the pages of a ListRecommendedIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendedIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendedIntents operation.
//	pageNum := 0
//	err := client.ListRecommendedIntentsPages(params,
//	    func(page *lexmodelsv2.ListRecommendedIntentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListRecommendedIntentsPages(input *ListRecommendedIntentsInput, fn func(*ListRecommendedIntentsOutput, bool) bool) error {
	return c.ListRecommendedIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendedIntentsPagesWithContext same as ListRecommendedIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListRecommendedIntentsPagesWithContext(ctx aws.Context, input *ListRecommendedIntentsInput, fn func(*ListRecommendedIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendedIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendedIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendedIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSessionAnalyticsData = "ListSessionAnalyticsData"

// ListSessionAnalyticsDataRequest generates a "aws/request.Request" representing the
// client's request for the ListSessionAnalyticsData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSessionAnalyticsData for more information on using the ListSessionAnalyticsData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSessionAnalyticsDataRequest method.
//	req, resp := client.ListSessionAnalyticsDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData
func (c *LexModelsV2) ListSessionAnalyticsDataRequest(input *ListSessionAnalyticsDataInput) (req *request.Request, output *ListSessionAnalyticsDataOutput) {
	op := &request.Operation{
		Name:       opListSessionAnalyticsData,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/analytics/sessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSessionAnalyticsDataInput{}
	}

	output = &ListSessionAnalyticsDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSessionAnalyticsData API operation for Amazon Lex Model Building V2.
//
// Retrieves a list of metadata for individual user sessions with your bot.
// The startDateTime and endDateTime fields are required. These fields define
// a time range for which you want to retrieve results. Of the optional fields,
// you can organize the results in the following ways:
//
//   - Use the filters field to filter the results and the sortBy field to
//     specify the values by which to sort the results.
//
//   - Use the maxResults field to limit the number of results to return in
//     a single response and the nextToken field to return the next batch of
//     results if the response does not return the full set of results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListSessionAnalyticsData for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData
func (c *LexModelsV2) ListSessionAnalyticsData(input *ListSessionAnalyticsDataInput) (*ListSessionAnalyticsDataOutput, error) {
	req, out := c.ListSessionAnalyticsDataRequest(input)
	return out, req.Send()
}

// ListSessionAnalyticsDataWithContext is the same as ListSessionAnalyticsData with the addition of
// the ability to pass a context and additional request options.
//
// See ListSessionAnalyticsData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSessionAnalyticsDataWithContext(ctx aws.Context, input *ListSessionAnalyticsDataInput, opts ...request.Option) (*ListSessionAnalyticsDataOutput, error) {
	req, out := c.ListSessionAnalyticsDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSessionAnalyticsDataPages iterates over the pages of a ListSessionAnalyticsData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSessionAnalyticsData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSessionAnalyticsData operation.
//	pageNum := 0
//	err := client.ListSessionAnalyticsDataPages(params,
//	    func(page *lexmodelsv2.ListSessionAnalyticsDataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListSessionAnalyticsDataPages(input *ListSessionAnalyticsDataInput, fn func(*ListSessionAnalyticsDataOutput, bool) bool) error {
	return c.ListSessionAnalyticsDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSessionAnalyticsDataPagesWithContext same as ListSessionAnalyticsDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSessionAnalyticsDataPagesWithContext(ctx aws.Context, input *ListSessionAnalyticsDataInput, fn func(*ListSessionAnalyticsDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSessionAnalyticsDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSessionAnalyticsDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSessionAnalyticsDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSessionMetrics = "ListSessionMetrics"

// ListSessionMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListSessionMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSessionMetrics for more information on using the ListSessionMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSessionMetricsRequest method.
//	req, resp := client.ListSessionMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics
func (c *LexModelsV2) ListSessionMetricsRequest(input *ListSessionMetricsInput) (req *request.Request, output *ListSessionMetricsOutput) {
	op := &request.Operation{
		Name:       opListSessionMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/analytics/sessionmetrics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSessionMetricsInput{}
	}

	output = &ListSessionMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSessionMetrics API operation for Amazon Lex Model Building V2.
//
// Retrieves summary metrics for the user sessions with your bot. The following
// fields are required:
//
//   - metrics – A list of AnalyticsSessionMetric (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html)
//     objects. In each object, use the name field to specify the metric to calculate,
//     the statistic field to specify whether to calculate the Sum, Average,
//     or Max number, and the order field to specify whether to sort the results
//     in Ascending or Descending order.
//
//   - startDateTime and endDateTime – Define a time range for which you
//     want to retrieve results.
//
// Of the optional fields, you can organize the results in the following ways:
//
//   - Use the filters field to filter the results, the groupBy field to specify
//     categories by which to group the results, and the binBy field to specify
//     time intervals by which to group the results.
//
//   - Use the maxResults field to limit the number of results to return in
//     a single response and the nextToken field to return the next batch of
//     results if the response does not return the full set of results.
//
// Note that an order field exists in both binBy and metrics. Currently, you
// can specify it in either field, but not in both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListSessionMetrics for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics
func (c *LexModelsV2) ListSessionMetrics(input *ListSessionMetricsInput) (*ListSessionMetricsOutput, error) {
	req, out := c.ListSessionMetricsRequest(input)
	return out, req.Send()
}

// ListSessionMetricsWithContext is the same as ListSessionMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListSessionMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSessionMetricsWithContext(ctx aws.Context, input *ListSessionMetricsInput, opts ...request.Option) (*ListSessionMetricsOutput, error) {
	req, out := c.ListSessionMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSessionMetricsPages iterates over the pages of a ListSessionMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSessionMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSessionMetrics operation.
//	pageNum := 0
//	err := client.ListSessionMetricsPages(params,
//	    func(page *lexmodelsv2.ListSessionMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListSessionMetricsPages(input *ListSessionMetricsInput, fn func(*ListSessionMetricsOutput, bool) bool) error {
	return c.ListSessionMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSessionMetricsPagesWithContext same as ListSessionMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSessionMetricsPagesWithContext(ctx aws.Context, input *ListSessionMetricsInput, fn func(*ListSessionMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSessionMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSessionMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSessionMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSlotTypes = "ListSlotTypes"

// ListSlotTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListSlotTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSlotTypes for more information on using the ListSlotTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSlotTypesRequest method.
//	req, resp := client.ListSlotTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes
func (c *LexModelsV2) ListSlotTypesRequest(input *ListSlotTypesInput) (req *request.Request, output *ListSlotTypesOutput) {
	op := &request.Operation{
		Name:       opListSlotTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSlotTypesInput{}
	}

	output = &ListSlotTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSlotTypes API operation for Amazon Lex Model Building V2.
//
// Gets a list of slot types that match the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListSlotTypes for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes
func (c *LexModelsV2) ListSlotTypes(input *ListSlotTypesInput) (*ListSlotTypesOutput, error) {
	req, out := c.ListSlotTypesRequest(input)
	return out, req.Send()
}

// ListSlotTypesWithContext is the same as ListSlotTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListSlotTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotTypesWithContext(ctx aws.Context, input *ListSlotTypesInput, opts ...request.Option) (*ListSlotTypesOutput, error) {
	req, out := c.ListSlotTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSlotTypesPages iterates over the pages of a ListSlotTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSlotTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSlotTypes operation.
//	pageNum := 0
//	err := client.ListSlotTypesPages(params,
//	    func(page *lexmodelsv2.ListSlotTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListSlotTypesPages(input *ListSlotTypesInput, fn func(*ListSlotTypesOutput, bool) bool) error {
	return c.ListSlotTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSlotTypesPagesWithContext same as ListSlotTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotTypesPagesWithContext(ctx aws.Context, input *ListSlotTypesInput, fn func(*ListSlotTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSlotTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSlotTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSlotTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSlots = "ListSlots"

// ListSlotsRequest generates a "aws/request.Request" representing the
// client's request for the ListSlots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSlots for more information on using the ListSlots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSlotsRequest method.
//	req, resp := client.ListSlotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots
func (c *LexModelsV2) ListSlotsRequest(input *ListSlotsInput) (req *request.Request, output *ListSlotsOutput) {
	op := &request.Operation{
		Name:       opListSlots,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSlotsInput{}
	}

	output = &ListSlotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSlots API operation for Amazon Lex Model Building V2.
//
// Gets a list of slots that match the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListSlots for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots
func (c *LexModelsV2) ListSlots(input *ListSlotsInput) (*ListSlotsOutput, error) {
	req, out := c.ListSlotsRequest(input)
	return out, req.Send()
}

// ListSlotsWithContext is the same as ListSlots with the addition of
// the ability to pass a context and additional request options.
//
// See ListSlots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotsWithContext(ctx aws.Context, input *ListSlotsInput, opts ...request.Option) (*ListSlotsOutput, error) {
	req, out := c.ListSlotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSlotsPages iterates over the pages of a ListSlots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSlots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSlots operation.
//	pageNum := 0
//	err := client.ListSlotsPages(params,
//	    func(page *lexmodelsv2.ListSlotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListSlotsPages(input *ListSlotsInput, fn func(*ListSlotsOutput, bool) bool) error {
	return c.ListSlotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSlotsPagesWithContext same as ListSlotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotsPagesWithContext(ctx aws.Context, input *ListSlotsInput, fn func(*ListSlotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSlotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSlotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSlotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource
func (c *LexModelsV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Lex Model Building V2.
//
// Gets a list of tags associated with a resource. Only bots, bot aliases, and
// bot channels can have tags associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource
func (c *LexModelsV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTestExecutionResultItems = "ListTestExecutionResultItems"

// ListTestExecutionResultItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestExecutionResultItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestExecutionResultItems for more information on using the ListTestExecutionResultItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestExecutionResultItemsRequest method.
//	req, resp := client.ListTestExecutionResultItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems
func (c *LexModelsV2) ListTestExecutionResultItemsRequest(input *ListTestExecutionResultItemsInput) (req *request.Request, output *ListTestExecutionResultItemsOutput) {
	op := &request.Operation{
		Name:       opListTestExecutionResultItems,
		HTTPMethod: "POST",
		HTTPPath:   "/testexecutions/{testExecutionId}/results",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestExecutionResultItemsInput{}
	}

	output = &ListTestExecutionResultItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestExecutionResultItems API operation for Amazon Lex Model Building V2.
//
// Gets a list of test execution result items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestExecutionResultItems for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems
func (c *LexModelsV2) ListTestExecutionResultItems(input *ListTestExecutionResultItemsInput) (*ListTestExecutionResultItemsOutput, error) {
	req, out := c.ListTestExecutionResultItemsRequest(input)
	return out, req.Send()
}

// ListTestExecutionResultItemsWithContext is the same as ListTestExecutionResultItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestExecutionResultItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionResultItemsWithContext(ctx aws.Context, input *ListTestExecutionResultItemsInput, opts ...request.Option) (*ListTestExecutionResultItemsOutput, error) {
	req, out := c.ListTestExecutionResultItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestExecutionResultItemsPages iterates over the pages of a ListTestExecutionResultItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestExecutionResultItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestExecutionResultItems operation.
//	pageNum := 0
//	err := client.ListTestExecutionResultItemsPages(params,
//	    func(page *lexmodelsv2.ListTestExecutionResultItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestExecutionResultItemsPages(input *ListTestExecutionResultItemsInput, fn func(*ListTestExecutionResultItemsOutput, bool) bool) error {
	return c.ListTestExecutionResultItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestExecutionResultItemsPagesWithContext same as ListTestExecutionResultItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionResultItemsPagesWithContext(ctx aws.Context, input *ListTestExecutionResultItemsInput, fn func(*ListTestExecutionResultItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestExecutionResultItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestExecutionResultItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestExecutionResultItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestExecutions = "ListTestExecutions"

// ListTestExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestExecutions for more information on using the ListTestExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestExecutionsRequest method.
//	req, resp := client.ListTestExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions
func (c *LexModelsV2) ListTestExecutionsRequest(input *ListTestExecutionsInput) (req *request.Request, output *ListTestExecutionsOutput) {
	op := &request.Operation{
		Name:       opListTestExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/testexecutions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestExecutionsInput{}
	}

	output = &ListTestExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestExecutions API operation for Amazon Lex Model Building V2.
//
// The list of test set executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestExecutions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions
func (c *LexModelsV2) ListTestExecutions(input *ListTestExecutionsInput) (*ListTestExecutionsOutput, error) {
	req, out := c.ListTestExecutionsRequest(input)
	return out, req.Send()
}

// ListTestExecutionsWithContext is the same as ListTestExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionsWithContext(ctx aws.Context, input *ListTestExecutionsInput, opts ...request.Option) (*ListTestExecutionsOutput, error) {
	req, out := c.ListTestExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestExecutionsPages iterates over the pages of a ListTestExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestExecutions operation.
//	pageNum := 0
//	err := client.ListTestExecutionsPages(params,
//	    func(page *lexmodelsv2.ListTestExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestExecutionsPages(input *ListTestExecutionsInput, fn func(*ListTestExecutionsOutput, bool) bool) error {
	return c.ListTestExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestExecutionsPagesWithContext same as ListTestExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionsPagesWithContext(ctx aws.Context, input *ListTestExecutionsInput, fn func(*ListTestExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestSetRecords = "ListTestSetRecords"

// ListTestSetRecordsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestSetRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestSetRecords for more information on using the ListTestSetRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestSetRecordsRequest method.
//	req, resp := client.ListTestSetRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords
func (c *LexModelsV2) ListTestSetRecordsRequest(input *ListTestSetRecordsInput) (req *request.Request, output *ListTestSetRecordsOutput) {
	op := &request.Operation{
		Name:       opListTestSetRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets/{testSetId}/records",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestSetRecordsInput{}
	}

	output = &ListTestSetRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestSetRecords API operation for Amazon Lex Model Building V2.
//
// The list of test set records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestSetRecords for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords
func (c *LexModelsV2) ListTestSetRecords(input *ListTestSetRecordsInput) (*ListTestSetRecordsOutput, error) {
	req, out := c.ListTestSetRecordsRequest(input)
	return out, req.Send()
}

// ListTestSetRecordsWithContext is the same as ListTestSetRecords with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestSetRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetRecordsWithContext(ctx aws.Context, input *ListTestSetRecordsInput, opts ...request.Option) (*ListTestSetRecordsOutput, error) {
	req, out := c.ListTestSetRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestSetRecordsPages iterates over the pages of a ListTestSetRecords operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestSetRecords method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestSetRecords operation.
//	pageNum := 0
//	err := client.ListTestSetRecordsPages(params,
//	    func(page *lexmodelsv2.ListTestSetRecordsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestSetRecordsPages(input *ListTestSetRecordsInput, fn func(*ListTestSetRecordsOutput, bool) bool) error {
	return c.ListTestSetRecordsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestSetRecordsPagesWithContext same as ListTestSetRecordsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetRecordsPagesWithContext(ctx aws.Context, input *ListTestSetRecordsInput, fn func(*ListTestSetRecordsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestSetRecordsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestSetRecordsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestSetRecordsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestSets = "ListTestSets"

// ListTestSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestSets for more information on using the ListTestSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestSetsRequest method.
//	req, resp := client.ListTestSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets
func (c *LexModelsV2) ListTestSetsRequest(input *ListTestSetsInput) (req *request.Request, output *ListTestSetsOutput) {
	op := &request.Operation{
		Name:       opListTestSets,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestSetsInput{}
	}

	output = &ListTestSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestSets API operation for Amazon Lex Model Building V2.
//
// # The list of the test sets
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestSets for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets
func (c *LexModelsV2) ListTestSets(input *ListTestSetsInput) (*ListTestSetsOutput, error) {
	req, out := c.ListTestSetsRequest(input)
	return out, req.Send()
}

// ListTestSetsWithContext is the same as ListTestSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetsWithContext(ctx aws.Context, input *ListTestSetsInput, opts ...request.Option) (*ListTestSetsOutput, error) {
	req, out := c.ListTestSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestSetsPages iterates over the pages of a ListTestSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestSets operation.
//	pageNum := 0
//	err := client.ListTestSetsPages(params,
//	    func(page *lexmodelsv2.ListTestSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestSetsPages(input *ListTestSetsInput, fn func(*ListTestSetsOutput, bool) bool) error {
	return c.ListTestSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestSetsPagesWithContext same as ListTestSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetsPagesWithContext(ctx aws.Context, input *ListTestSetsInput, fn func(*ListTestSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUtteranceAnalyticsData = "ListUtteranceAnalyticsData"

// ListUtteranceAnalyticsDataRequest generates a "aws/request.Request" representing the
// client's request for the ListUtteranceAnalyticsData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUtteranceAnalyticsData for more information on using the ListUtteranceAnalyticsData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUtteranceAnalyticsDataRequest method.
//	req, resp := client.ListUtteranceAnalyticsDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData
func (c *LexModelsV2) ListUtteranceAnalyticsDataRequest(input *ListUtteranceAnalyticsDataInput) (req *request.Request, output *ListUtteranceAnalyticsDataOutput) {
	op := &request.Operation{
		Name:       opListUtteranceAnalyticsData,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/analytics/utterances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUtteranceAnalyticsDataInput{}
	}

	output = &ListUtteranceAnalyticsDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUtteranceAnalyticsData API operation for Amazon Lex Model Building V2.
//
// To use this API operation, your IAM role must have permissions to perform
// the ListAggregatedUtterances (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html)
// operation, which provides access to utterance-related analytics. See Viewing
// utterance statistics (https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html)
// for the IAM policy to apply to the IAM role.
//
// Retrieves a list of metadata for individual user utterances to your bot.
// The following fields are required:
//
//   - startDateTime and endDateTime – Define a time range for which you
//     want to retrieve results.
//
// Of the optional fields, you can organize the results in the following ways:
//
//   - Use the filters field to filter the results and the sortBy field to
//     specify the values by which to sort the results.
//
//   - Use the maxResults field to limit the number of results to return in
//     a single response and the nextToken field to return the next batch of
//     results if the response does not return the full set of results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListUtteranceAnalyticsData for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData
func (c *LexModelsV2) ListUtteranceAnalyticsData(input *ListUtteranceAnalyticsDataInput) (*ListUtteranceAnalyticsDataOutput, error) {
	req, out := c.ListUtteranceAnalyticsDataRequest(input)
	return out, req.Send()
}

// ListUtteranceAnalyticsDataWithContext is the same as ListUtteranceAnalyticsData with the addition of
// the ability to pass a context and additional request options.
//
// See ListUtteranceAnalyticsData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListUtteranceAnalyticsDataWithContext(ctx aws.Context, input *ListUtteranceAnalyticsDataInput, opts ...request.Option) (*ListUtteranceAnalyticsDataOutput, error) {
	req, out := c.ListUtteranceAnalyticsDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUtteranceAnalyticsDataPages iterates over the pages of a ListUtteranceAnalyticsData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUtteranceAnalyticsData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUtteranceAnalyticsData operation.
//	pageNum := 0
//	err := client.ListUtteranceAnalyticsDataPages(params,
//	    func(page *lexmodelsv2.ListUtteranceAnalyticsDataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListUtteranceAnalyticsDataPages(input *ListUtteranceAnalyticsDataInput, fn func(*ListUtteranceAnalyticsDataOutput, bool) bool) error {
	return c.ListUtteranceAnalyticsDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUtteranceAnalyticsDataPagesWithContext same as ListUtteranceAnalyticsDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListUtteranceAnalyticsDataPagesWithContext(ctx aws.Context, input *ListUtteranceAnalyticsDataInput, fn func(*ListUtteranceAnalyticsDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUtteranceAnalyticsDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUtteranceAnalyticsDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUtteranceAnalyticsDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUtteranceMetrics = "ListUtteranceMetrics"

// ListUtteranceMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListUtteranceMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUtteranceMetrics for more information on using the ListUtteranceMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUtteranceMetricsRequest method.
//	req, resp := client.ListUtteranceMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics
func (c *LexModelsV2) ListUtteranceMetricsRequest(input *ListUtteranceMetricsInput) (req *request.Request, output *ListUtteranceMetricsOutput) {
	op := &request.Operation{
		Name:       opListUtteranceMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/analytics/utterancemetrics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUtteranceMetricsInput{}
	}

	output = &ListUtteranceMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUtteranceMetrics API operation for Amazon Lex Model Building V2.
//
// To use this API operation, your IAM role must have permissions to perform
// the ListAggregatedUtterances (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html)
// operation, which provides access to utterance-related analytics. See Viewing
// utterance statistics (https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html)
// for the IAM policy to apply to the IAM role.
//
// Retrieves summary metrics for the utterances in your bot. The following fields
// are required:
//
//   - metrics – A list of AnalyticsUtteranceMetric (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html)
//     objects. In each object, use the name field to specify the metric to calculate,
//     the statistic field to specify whether to calculate the Sum, Average,
//     or Max number, and the order field to specify whether to sort the results
//     in Ascending or Descending order.
//
//   - startDateTime and endDateTime – Define a time range for which you
//     want to retrieve results.
//
// Of the optional fields, you can organize the results in the following ways:
//
//   - Use the filters field to filter the results, the groupBy field to specify
//     categories by which to group the results, and the binBy field to specify
//     time intervals by which to group the results.
//
//   - Use the maxResults field to limit the number of results to return in
//     a single response and the nextToken field to return the next batch of
//     results if the response does not return the full set of results.
//
// Note that an order field exists in both binBy and metrics. Currently, you
// can specify it in either field, but not in both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListUtteranceMetrics for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics
func (c *LexModelsV2) ListUtteranceMetrics(input *ListUtteranceMetricsInput) (*ListUtteranceMetricsOutput, error) {
	req, out := c.ListUtteranceMetricsRequest(input)
	return out, req.Send()
}

// ListUtteranceMetricsWithContext is the same as ListUtteranceMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListUtteranceMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListUtteranceMetricsWithContext(ctx aws.Context, input *ListUtteranceMetricsInput, opts ...request.Option) (*ListUtteranceMetricsOutput, error) {
	req, out := c.ListUtteranceMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUtteranceMetricsPages iterates over the pages of a ListUtteranceMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUtteranceMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUtteranceMetrics operation.
//	pageNum := 0
//	err := client.ListUtteranceMetricsPages(params,
//	    func(page *lexmodelsv2.ListUtteranceMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListUtteranceMetricsPages(input *ListUtteranceMetricsInput, fn func(*ListUtteranceMetricsOutput, bool) bool) error {
	return c.ListUtteranceMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUtteranceMetricsPagesWithContext same as ListUtteranceMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListUtteranceMetricsPagesWithContext(ctx aws.Context, input *ListUtteranceMetricsInput, fn func(*ListUtteranceMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUtteranceMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUtteranceMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUtteranceMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchAssociatedTranscripts = "SearchAssociatedTranscripts"

// SearchAssociatedTranscriptsRequest generates a "aws/request.Request" representing the
// client's request for the SearchAssociatedTranscripts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAssociatedTranscripts for more information on using the SearchAssociatedTranscripts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAssociatedTranscriptsRequest method.
//	req, resp := client.SearchAssociatedTranscriptsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts
func (c *LexModelsV2) SearchAssociatedTranscriptsRequest(input *SearchAssociatedTranscriptsInput) (req *request.Request, output *SearchAssociatedTranscriptsOutput) {
	op := &request.Operation{
		Name:       opSearchAssociatedTranscripts,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/associatedtranscripts",
	}

	if input == nil {
		input = &SearchAssociatedTranscriptsInput{}
	}

	output = &SearchAssociatedTranscriptsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAssociatedTranscripts API operation for Amazon Lex Model Building V2.
//
// Search for associated transcripts that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation SearchAssociatedTranscripts for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts
func (c *LexModelsV2) SearchAssociatedTranscripts(input *SearchAssociatedTranscriptsInput) (*SearchAssociatedTranscriptsOutput, error) {
	req, out := c.SearchAssociatedTranscriptsRequest(input)
	return out, req.Send()
}

// SearchAssociatedTranscriptsWithContext is the same as SearchAssociatedTranscripts with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAssociatedTranscripts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) SearchAssociatedTranscriptsWithContext(ctx aws.Context, input *SearchAssociatedTranscriptsInput, opts ...request.Option) (*SearchAssociatedTranscriptsOutput, error) {
	req, out := c.SearchAssociatedTranscriptsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBotRecommendation = "StartBotRecommendation"

// StartBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the StartBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBotRecommendation for more information on using the StartBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartBotRecommendationRequest method.
//	req, resp := client.StartBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation
func (c *LexModelsV2) StartBotRecommendationRequest(input *StartBotRecommendationInput) (req *request.Request, output *StartBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opStartBotRecommendation,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
	}

	if input == nil {
		input = &StartBotRecommendationInput{}
	}

	output = &StartBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Use this to provide your transcript data, and to start the bot recommendation
// process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation
func (c *LexModelsV2) StartBotRecommendation(input *StartBotRecommendationInput) (*StartBotRecommendationOutput, error) {
	req, out := c.StartBotRecommendationRequest(input)
	return out, req.Send()
}

// StartBotRecommendationWithContext is the same as StartBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See StartBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartBotRecommendationWithContext(ctx aws.Context, input *StartBotRecommendationInput, opts ...request.Option) (*StartBotRecommendationOutput, error) {
	req, out := c.StartBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBotResourceGeneration = "StartBotResourceGeneration"

// StartBotResourceGenerationRequest generates a "aws/request.Request" representing the
// client's request for the StartBotResourceGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBotResourceGeneration for more information on using the StartBotResourceGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartBotResourceGenerationRequest method.
//	req, resp := client.StartBotResourceGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotResourceGeneration
func (c *LexModelsV2) StartBotResourceGenerationRequest(input *StartBotResourceGenerationInput) (req *request.Request, output *StartBotResourceGenerationOutput) {
	op := &request.Operation{
		Name:       opStartBotResourceGeneration,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/startgeneration",
	}

	if input == nil {
		input = &StartBotResourceGenerationInput{}
	}

	output = &StartBotResourceGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBotResourceGeneration API operation for Amazon Lex Model Building V2.
//
// Starts a request for the descriptive bot builder to generate a bot locale
// configuration based on the prompt you provide it. After you make this call,
// use the DescribeBotResourceGeneration operation to check on the status of
// the generation and for the generatedBotLocaleUrl when the generation is complete.
// Use that value to retrieve the Amazon S3 object containing the bot locale
// configuration. You can then modify and import this configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartBotResourceGeneration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotResourceGeneration
func (c *LexModelsV2) StartBotResourceGeneration(input *StartBotResourceGenerationInput) (*StartBotResourceGenerationOutput, error) {
	req, out := c.StartBotResourceGenerationRequest(input)
	return out, req.Send()
}

// StartBotResourceGenerationWithContext is the same as StartBotResourceGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See StartBotResourceGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartBotResourceGenerationWithContext(ctx aws.Context, input *StartBotResourceGenerationInput, opts ...request.Option) (*StartBotResourceGenerationOutput, error) {
	req, out := c.StartBotResourceGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImport = "StartImport"

// StartImportRequest generates a "aws/request.Request" representing the
// client's request for the StartImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImport for more information on using the StartImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartImportRequest method.
//	req, resp := client.StartImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport
func (c *LexModelsV2) StartImportRequest(input *StartImportInput) (req *request.Request, output *StartImportOutput) {
	op := &request.Operation{
		Name:       opStartImport,
		HTTPMethod: "PUT",
		HTTPPath:   "/imports/",
	}

	if input == nil {
		input = &StartImportInput{}
	}

	output = &StartImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImport API operation for Amazon Lex Model Building V2.
//
// Starts importing a bot, bot locale, or custom vocabulary from a zip archive
// that you uploaded to an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartImport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport
func (c *LexModelsV2) StartImport(input *StartImportInput) (*StartImportOutput, error) {
	req, out := c.StartImportRequest(input)
	return out, req.Send()
}

// StartImportWithContext is the same as StartImport with the addition of
// the ability to pass a context and additional request options.
//
// See StartImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartImportWithContext(ctx aws.Context, input *StartImportInput, opts ...request.Option) (*StartImportOutput, error) {
	req, out := c.StartImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTestExecution = "StartTestExecution"

// StartTestExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartTestExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTestExecution for more information on using the StartTestExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTestExecutionRequest method.
//	req, resp := client.StartTestExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution
func (c *LexModelsV2) StartTestExecutionRequest(input *StartTestExecutionInput) (req *request.Request, output *StartTestExecutionOutput) {
	op := &request.Operation{
		Name:       opStartTestExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets/{testSetId}/testexecutions",
	}

	if input == nil {
		input = &StartTestExecutionInput{}
	}

	output = &StartTestExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTestExecution API operation for Amazon Lex Model Building V2.
//
// The action to start test set execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartTestExecution for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution
func (c *LexModelsV2) StartTestExecution(input *StartTestExecutionInput) (*StartTestExecutionOutput, error) {
	req, out := c.StartTestExecutionRequest(input)
	return out, req.Send()
}

// StartTestExecutionWithContext is the same as StartTestExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartTestExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartTestExecutionWithContext(ctx aws.Context, input *StartTestExecutionInput, opts ...request.Option) (*StartTestExecutionOutput, error) {
	req, out := c.StartTestExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTestSetGeneration = "StartTestSetGeneration"

// StartTestSetGenerationRequest generates a "aws/request.Request" representing the
// client's request for the StartTestSetGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTestSetGeneration for more information on using the StartTestSetGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTestSetGenerationRequest method.
//	req, resp := client.StartTestSetGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration
func (c *LexModelsV2) StartTestSetGenerationRequest(input *StartTestSetGenerationInput) (req *request.Request, output *StartTestSetGenerationOutput) {
	op := &request.Operation{
		Name:       opStartTestSetGeneration,
		HTTPMethod: "PUT",
		HTTPPath:   "/testsetgenerations",
	}

	if input == nil {
		input = &StartTestSetGenerationInput{}
	}

	output = &StartTestSetGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTestSetGeneration API operation for Amazon Lex Model Building V2.
//
// The action to start the generation of test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartTestSetGeneration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration
func (c *LexModelsV2) StartTestSetGeneration(input *StartTestSetGenerationInput) (*StartTestSetGenerationOutput, error) {
	req, out := c.StartTestSetGenerationRequest(input)
	return out, req.Send()
}

// StartTestSetGenerationWithContext is the same as StartTestSetGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See StartTestSetGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartTestSetGenerationWithContext(ctx aws.Context, input *StartTestSetGenerationInput, opts ...request.Option) (*StartTestSetGenerationOutput, error) {
	req, out := c.StartTestSetGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopBotRecommendation = "StopBotRecommendation"

// StopBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the StopBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopBotRecommendation for more information on using the StopBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopBotRecommendationRequest method.
//	req, resp := client.StopBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation
func (c *LexModelsV2) StopBotRecommendationRequest(input *StopBotRecommendationInput) (req *request.Request, output *StopBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opStopBotRecommendation,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/stopbotrecommendation",
	}

	if input == nil {
		input = &StopBotRecommendationInput{}
	}

	output = &StopBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Stop an already running Bot Recommendation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StopBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation
func (c *LexModelsV2) StopBotRecommendation(input *StopBotRecommendationInput) (*StopBotRecommendationOutput, error) {
	req, out := c.StopBotRecommendationRequest(input)
	return out, req.Send()
}

// StopBotRecommendationWithContext is the same as StopBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See StopBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StopBotRecommendationWithContext(ctx aws.Context, input *StopBotRecommendationInput, opts ...request.Option) (*StopBotRecommendationOutput, error) {
	req, out := c.StopBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource
func (c *LexModelsV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Lex Model Building V2.
//
// Adds the specified tags to the specified resource. If a tag key already exists,
// the existing value is replaced with the new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource
func (c *LexModelsV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource
func (c *LexModelsV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Lex Model Building V2.
//
// Removes tags from a bot, bot alias, or bot channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource
func (c *LexModelsV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBot = "UpdateBot"

// UpdateBotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBot for more information on using the UpdateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotRequest method.
//	req, resp := client.UpdateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot
func (c *LexModelsV2) UpdateBotRequest(input *UpdateBotInput) (req *request.Request, output *UpdateBotOutput) {
	op := &request.Operation{
		Name:       opUpdateBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/",
	}

	if input == nil {
		input = &UpdateBotInput{}
	}

	output = &UpdateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBot API operation for Amazon Lex Model Building V2.
//
// Updates the configuration of an existing bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot
func (c *LexModelsV2) UpdateBot(input *UpdateBotInput) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	return out, req.Send()
}

// UpdateBotWithContext is the same as UpdateBot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotWithContext(ctx aws.Context, input *UpdateBotInput, opts ...request.Option) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBotAlias = "UpdateBotAlias"

// UpdateBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBotAlias for more information on using the UpdateBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotAliasRequest method.
//	req, resp := client.UpdateBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias
func (c *LexModelsV2) UpdateBotAliasRequest(input *UpdateBotAliasInput) (req *request.Request, output *UpdateBotAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateBotAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botaliases/{botAliasId}/",
	}

	if input == nil {
		input = &UpdateBotAliasInput{}
	}

	output = &UpdateBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBotAlias API operation for Amazon Lex Model Building V2.
//
// Updates the configuration of an existing bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias
func (c *LexModelsV2) UpdateBotAlias(input *UpdateBotAliasInput) (*UpdateBotAliasOutput, error) {
	req, out := c.UpdateBotAliasRequest(input)
	return out, req.Send()
}

// UpdateBotAliasWithContext is the same as UpdateBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotAliasWithContext(ctx aws.Context, input *UpdateBotAliasInput, opts ...request.Option) (*UpdateBotAliasOutput, error) {
	req, out := c.UpdateBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBotLocale = "UpdateBotLocale"

// UpdateBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBotLocale for more information on using the UpdateBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotLocaleRequest method.
//	req, resp := client.UpdateBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale
func (c *LexModelsV2) UpdateBotLocaleRequest(input *UpdateBotLocaleInput) (req *request.Request, output *UpdateBotLocaleOutput) {
	op := &request.Operation{
		Name:       opUpdateBotLocale,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &UpdateBotLocaleInput{}
	}

	output = &UpdateBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBotLocale API operation for Amazon Lex Model Building V2.
//
// Updates the settings that a bot has for a specific locale.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale
func (c *LexModelsV2) UpdateBotLocale(input *UpdateBotLocaleInput) (*UpdateBotLocaleOutput, error) {
	req, out := c.UpdateBotLocaleRequest(input)
	return out, req.Send()
}

// UpdateBotLocaleWithContext is the same as UpdateBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotLocaleWithContext(ctx aws.Context, input *UpdateBotLocaleInput, opts ...request.Option) (*UpdateBotLocaleOutput, error) {
	req, out := c.UpdateBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBotRecommendation = "UpdateBotRecommendation"

// UpdateBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBotRecommendation for more information on using the UpdateBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotRecommendationRequest method.
//	req, resp := client.UpdateBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation
func (c *LexModelsV2) UpdateBotRecommendationRequest(input *UpdateBotRecommendationInput) (req *request.Request, output *UpdateBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opUpdateBotRecommendation,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
	}

	if input == nil {
		input = &UpdateBotRecommendationInput{}
	}

	output = &UpdateBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Updates an existing bot recommendation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation
func (c *LexModelsV2) UpdateBotRecommendation(input *UpdateBotRecommendationInput) (*UpdateBotRecommendationOutput, error) {
	req, out := c.UpdateBotRecommendationRequest(input)
	return out, req.Send()
}

// UpdateBotRecommendationWithContext is the same as UpdateBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotRecommendationWithContext(ctx aws.Context, input *UpdateBotRecommendationInput, opts ...request.Option) (*UpdateBotRecommendationOutput, error) {
	req, out := c.UpdateBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExport = "UpdateExport"

// UpdateExportRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExport for more information on using the UpdateExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateExportRequest method.
//	req, resp := client.UpdateExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport
func (c *LexModelsV2) UpdateExportRequest(input *UpdateExportInput) (req *request.Request, output *UpdateExportOutput) {
	op := &request.Operation{
		Name:       opUpdateExport,
		HTTPMethod: "PUT",
		HTTPPath:   "/exports/{exportId}/",
	}

	if input == nil {
		input = &UpdateExportInput{}
	}

	output = &UpdateExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExport API operation for Amazon Lex Model Building V2.
//
// Updates the password used to protect an export zip archive.
//
// The password is not required. If you don't supply a password, Amazon Lex
// generates a zip file that is not protected by a password. This is the archive
// that is available at the pre-signed S3 URL provided by the DescribeExport
// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport
func (c *LexModelsV2) UpdateExport(input *UpdateExportInput) (*UpdateExportOutput, error) {
	req, out := c.UpdateExportRequest(input)
	return out, req.Send()
}

// UpdateExportWithContext is the same as UpdateExport with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateExportWithContext(ctx aws.Context, input *UpdateExportInput, opts ...request.Option) (*UpdateExportOutput, error) {
	req, out := c.UpdateExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIntent = "UpdateIntent"

// UpdateIntentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIntent for more information on using the UpdateIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIntentRequest method.
//	req, resp := client.UpdateIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent
func (c *LexModelsV2) UpdateIntentRequest(input *UpdateIntentInput) (req *request.Request, output *UpdateIntentOutput) {
	op := &request.Operation{
		Name:       opUpdateIntent,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
	}

	if input == nil {
		input = &UpdateIntentInput{}
	}

	output = &UpdateIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIntent API operation for Amazon Lex Model Building V2.
//
// Updates the settings for an intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent
func (c *LexModelsV2) UpdateIntent(input *UpdateIntentInput) (*UpdateIntentOutput, error) {
	req, out := c.UpdateIntentRequest(input)
	return out, req.Send()
}

// UpdateIntentWithContext is the same as UpdateIntent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateIntentWithContext(ctx aws.Context, input *UpdateIntentInput, opts ...request.Option) (*UpdateIntentOutput, error) {
	req, out := c.UpdateIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourcePolicy = "UpdateResourcePolicy"

// UpdateResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourcePolicy for more information on using the UpdateResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResourcePolicyRequest method.
//	req, resp := client.UpdateResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy
func (c *LexModelsV2) UpdateResourcePolicyRequest(input *UpdateResourcePolicyInput) (req *request.Request, output *UpdateResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateResourcePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &UpdateResourcePolicyInput{}
	}

	output = &UpdateResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Replaces the existing resource policy for a bot or bot alias with a new one.
// If the policy doesn't exist, Amazon Lex returns an exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy
func (c *LexModelsV2) UpdateResourcePolicy(input *UpdateResourcePolicyInput) (*UpdateResourcePolicyOutput, error) {
	req, out := c.UpdateResourcePolicyRequest(input)
	return out, req.Send()
}

// UpdateResourcePolicyWithContext is the same as UpdateResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateResourcePolicyWithContext(ctx aws.Context, input *UpdateResourcePolicyInput, opts ...request.Option) (*UpdateResourcePolicyOutput, error) {
	req, out := c.UpdateResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSlot = "UpdateSlot"

// UpdateSlotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSlot for more information on using the UpdateSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSlotRequest method.
//	req, resp := client.UpdateSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot
func (c *LexModelsV2) UpdateSlotRequest(input *UpdateSlotInput) (req *request.Request, output *UpdateSlotOutput) {
	op := &request.Operation{
		Name:       opUpdateSlot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
	}

	if input == nil {
		input = &UpdateSlotInput{}
	}

	output = &UpdateSlotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSlot API operation for Amazon Lex Model Building V2.
//
// Updates the settings for a slot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot
func (c *LexModelsV2) UpdateSlot(input *UpdateSlotInput) (*UpdateSlotOutput, error) {
	req, out := c.UpdateSlotRequest(input)
	return out, req.Send()
}

// UpdateSlotWithContext is the same as UpdateSlot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateSlotWithContext(ctx aws.Context, input *UpdateSlotInput, opts ...request.Option) (*UpdateSlotOutput, error) {
	req, out := c.UpdateSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSlotType = "UpdateSlotType"

// UpdateSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSlotType for more information on using the UpdateSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSlotTypeRequest method.
//	req, resp := client.UpdateSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType
func (c *LexModelsV2) UpdateSlotTypeRequest(input *UpdateSlotTypeInput) (req *request.Request, output *UpdateSlotTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateSlotType,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
	}

	if input == nil {
		input = &UpdateSlotTypeInput{}
	}

	output = &UpdateSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSlotType API operation for Amazon Lex Model Building V2.
//
// Updates the configuration of an existing slot type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType
func (c *LexModelsV2) UpdateSlotType(input *UpdateSlotTypeInput) (*UpdateSlotTypeOutput, error) {
	req, out := c.UpdateSlotTypeRequest(input)
	return out, req.Send()
}

// UpdateSlotTypeWithContext is the same as UpdateSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateSlotTypeWithContext(ctx aws.Context, input *UpdateSlotTypeInput, opts ...request.Option) (*UpdateSlotTypeOutput, error) {
	req, out := c.UpdateSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTestSet = "UpdateTestSet"

// UpdateTestSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTestSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTestSet for more information on using the UpdateTestSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTestSetRequest method.
//	req, resp := client.UpdateTestSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet
func (c *LexModelsV2) UpdateTestSetRequest(input *UpdateTestSetInput) (req *request.Request, output *UpdateTestSetOutput) {
	op := &request.Operation{
		Name:       opUpdateTestSet,
		HTTPMethod: "PUT",
		HTTPPath:   "/testsets/{testSetId}",
	}

	if input == nil {
		input = &UpdateTestSetInput{}
	}

	output = &UpdateTestSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTestSet API operation for Amazon Lex Model Building V2.
//
// The action to update the test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateTestSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet
func (c *LexModelsV2) UpdateTestSet(input *UpdateTestSetInput) (*UpdateTestSetOutput, error) {
	req, out := c.UpdateTestSetRequest(input)
	return out, req.Send()
}

// UpdateTestSetWithContext is the same as UpdateTestSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTestSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateTestSetWithContext(ctx aws.Context, input *UpdateTestSetInput, opts ...request.Option) (*UpdateTestSetOutput, error) {
	req, out := c.UpdateTestSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The active context used in the test execution.
type ActiveContext struct {
	_ struct{} `type:"structure"`

	// The name of active context.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContext) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ActiveContext) SetName(v string) *ActiveContext {
	s.Name = &v
	return s
}

// Provides settings that enable advanced recognition settings for slot values.
type AdvancedRecognitionSetting struct {
	_ struct{} `type:"structure"`

	// Enables using the slot values as a custom vocabulary for recognizing user
	// utterances.
	AudioRecognitionStrategy *string `locationName:"audioRecognitionStrategy" type:"string" enum:"AudioRecognitionStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedRecognitionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedRecognitionSetting) GoString() string {
	return s.String()
}

// SetAudioRecognitionStrategy sets the AudioRecognitionStrategy field's value.
func (s *AdvancedRecognitionSetting) SetAudioRecognitionStrategy(v string) *AdvancedRecognitionSetting {
	s.AudioRecognitionStrategy = &v
	return s
}

// The information about the agent turn in a test set execution.
type AgentTurnResult struct {
	_ struct{} `type:"structure"`

	// The actual agent prompt for the agent turn in a test set execution.
	ActualAgentPrompt *string `locationName:"actualAgentPrompt" min:"1" type:"string"`

	// The actual elicited slot for the agent turn in a test set execution.
	ActualElicitedSlot *string `locationName:"actualElicitedSlot" min:"1" type:"string"`

	// The actual intent for the agent turn in a test set execution.
	ActualIntent *string `locationName:"actualIntent" min:"1" type:"string"`

	// Details about an error in an execution of a test set.
	ErrorDetails *ExecutionErrorDetails `locationName:"errorDetails" type:"structure"`

	// The expected agent prompt for the agent turn in a test set execution.
	//
	// ExpectedAgentPrompt is a required field
	ExpectedAgentPrompt *string `locationName:"expectedAgentPrompt" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnResult) GoString() string {
	return s.String()
}

// SetActualAgentPrompt sets the ActualAgentPrompt field's value.
func (s *AgentTurnResult) SetActualAgentPrompt(v string) *AgentTurnResult {
	s.ActualAgentPrompt = &v
	return s
}

// SetActualElicitedSlot sets the ActualElicitedSlot field's value.
func (s *AgentTurnResult) SetActualElicitedSlot(v string) *AgentTurnResult {
	s.ActualElicitedSlot = &v
	return s
}

// SetActualIntent sets the ActualIntent field's value.
func (s *AgentTurnResult) SetActualIntent(v string) *AgentTurnResult {
	s.ActualIntent = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *AgentTurnResult) SetErrorDetails(v *ExecutionErrorDetails) *AgentTurnResult {
	s.ErrorDetails = v
	return s
}

// SetExpectedAgentPrompt sets the ExpectedAgentPrompt field's value.
func (s *AgentTurnResult) SetExpectedAgentPrompt(v string) *AgentTurnResult {
	s.ExpectedAgentPrompt = &v
	return s
}

// The specification of an agent turn.
type AgentTurnSpecification struct {
	_ struct{} `type:"structure"`

	// The agent prompt for the agent turn in a test set.
	//
	// AgentPrompt is a required field
	AgentPrompt *string `locationName:"agentPrompt" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnSpecification) GoString() string {
	return s.String()
}

// SetAgentPrompt sets the AgentPrompt field's value.
func (s *AgentTurnSpecification) SetAgentPrompt(v string) *AgentTurnSpecification {
	s.AgentPrompt = &v
	return s
}

// Filters responses returned by the ListAggregatedUtterances operation.
type AggregatedUtterancesFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to filter the utterance list.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AggregatedUtterancesFilterName"`

	// The operator to use for the filter. Specify EQ when the ListAggregatedUtterances
	// operation should return only utterances that equal the specified value. Specify
	// CO when the ListAggregatedUtterances operation should return utterances that
	// contain the specified value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"AggregatedUtterancesFilterOperator"`

	// The value to use for filtering the list of bots.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregatedUtterancesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregatedUtterancesFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AggregatedUtterancesFilter) SetName(v string) *AggregatedUtterancesFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AggregatedUtterancesFilter) SetOperator(v string) *AggregatedUtterancesFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AggregatedUtterancesFilter) SetValues(v []*string) *AggregatedUtterancesFilter {
	s.Values = v
	return s
}

// Specifies attributes for sorting a list of utterances.
type AggregatedUtterancesSortBy struct {
	_ struct{} `type:"structure"`

	// The utterance attribute to sort by.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"AggregatedUtterancesSortAttribute"`

	// Specifies whether to sort the aggregated utterances in ascending or descending
	// order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregatedUtterancesSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregatedUtterancesSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *AggregatedUtterancesSortBy) SetAttribute(v string) *AggregatedUtterancesSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *AggregatedUtterancesSortBy) SetOrder(v string) *AggregatedUtterancesSortBy {
	s.Order = &v
	return s
}

// Provides summary information for aggregated utterances. The ListAggregatedUtterances
// operations combines all instances of the same utterance into a single aggregated
// summary.
type AggregatedUtterancesSummary struct {
	_ struct{} `type:"structure"`

	// Aggregated utterance data may contain utterances from versions of your bot
	// that have since been deleted. When the aggregated contains this kind of data,
	// this field is set to true.
	ContainsDataFromDeletedResources *bool `locationName:"containsDataFromDeletedResources" type:"boolean"`

	// The number of times that the utterance was detected by Amazon Lex during
	// the time period. When an utterance is detected, it activates an intent or
	// a slot.
	HitCount *int64 `locationName:"hitCount" type:"integer"`

	// The number of times that the utterance was missed by Amazon Lex An utterance
	// is missed when it doesn't activate an intent or slot.
	MissedCount *int64 `locationName:"missedCount" type:"integer"`

	// The text of the utterance. If the utterance was used with the RecognizeUtterance
	// operation, the text is the transcription of the audio utterance.
	Utterance *string `locationName:"utterance" type:"string"`

	// The date and time that the utterance was first recorded in the time window
	// for aggregation. An utterance may have been sent to Amazon Lex before that
	// time, but only utterances within the time window are counted.
	UtteranceFirstRecordedInAggregationDuration *time.Time `locationName:"utteranceFirstRecordedInAggregationDuration" type:"timestamp"`

	// The last date and time that an utterance was recorded in the time window
	// for aggregation. An utterance may be sent to Amazon Lex after that time,
	// but only utterances within the time window are counted.
	UtteranceLastRecordedInAggregationDuration *time.Time `locationName:"utteranceLastRecordedInAggregationDuration" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSummary) GoString() string {
	return s.String()
}

// SetContainsDataFromDeletedResources sets the ContainsDataFromDeletedResources field's value.
func (s *AggregatedUtterancesSummary) SetContainsDataFromDeletedResources(v bool) *AggregatedUtterancesSummary {
	s.ContainsDataFromDeletedResources = &v
	return s
}

// SetHitCount sets the HitCount field's value.
func (s *AggregatedUtterancesSummary) SetHitCount(v int64) *AggregatedUtterancesSummary {
	s.HitCount = &v
	return s
}

// SetMissedCount sets the MissedCount field's value.
func (s *AggregatedUtterancesSummary) SetMissedCount(v int64) *AggregatedUtterancesSummary {
	s.MissedCount = &v
	return s
}

// SetUtterance sets the Utterance field's value.
func (s *AggregatedUtterancesSummary) SetUtterance(v string) *AggregatedUtterancesSummary {
	s.Utterance = &v
	return s
}

// SetUtteranceFirstRecordedInAggregationDuration sets the UtteranceFirstRecordedInAggregationDuration field's value.
func (s *AggregatedUtterancesSummary) SetUtteranceFirstRecordedInAggregationDuration(v time.Time) *AggregatedUtterancesSummary {
	s.UtteranceFirstRecordedInAggregationDuration = &v
	return s
}

// SetUtteranceLastRecordedInAggregationDuration sets the UtteranceLastRecordedInAggregationDuration field's value.
func (s *AggregatedUtterancesSummary) SetUtteranceLastRecordedInAggregationDuration(v time.Time) *AggregatedUtterancesSummary {
	s.UtteranceLastRecordedInAggregationDuration = &v
	return s
}

// Specifies the allowed input types.
type AllowedInputTypes struct {
	_ struct{} `type:"structure"`

	// Indicates whether audio input is allowed.
	//
	// AllowAudioInput is a required field
	AllowAudioInput *bool `locationName:"allowAudioInput" type:"boolean" required:"true"`

	// Indicates whether DTMF input is allowed.
	//
	// AllowDTMFInput is a required field
	AllowDTMFInput *bool `locationName:"allowDTMFInput" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowedInputTypes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowedInputTypes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowedInputTypes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllowedInputTypes"}
	if s.AllowAudioInput == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowAudioInput"))
	}
	if s.AllowDTMFInput == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowDTMFInput"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAudioInput sets the AllowAudioInput field's value.
func (s *AllowedInputTypes) SetAllowAudioInput(v bool) *AllowedInputTypes {
	s.AllowAudioInput = &v
	return s
}

// SetAllowDTMFInput sets the AllowDTMFInput field's value.
func (s *AllowedInputTypes) SetAllowDTMFInput(v bool) *AllowedInputTypes {
	s.AllowDTMFInput = &v
	return s
}

// Contains the time metric, interval, and method by which to bin the analytics
// data.
type AnalyticsBinBySpecification struct {
	_ struct{} `type:"structure"`

	// Specifies the interval of time by which to bin the analytics data.
	//
	// Interval is a required field
	Interval *string `locationName:"interval" type:"string" required:"true" enum:"AnalyticsInterval"`

	// Specifies the time metric by which to bin the analytics data.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsBinByName"`

	// Specifies whether to bin the analytics data in ascending or descending order.
	// If this field is left blank, the default order is by the key of the bin in
	// descending order.
	Order *string `locationName:"order" type:"string" enum:"AnalyticsSortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsBinBySpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsBinBySpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsBinBySpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsBinBySpecification"}
	if s.Interval == nil {
		invalidParams.Add(request.NewErrParamRequired("Interval"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *AnalyticsBinBySpecification) SetInterval(v string) *AnalyticsBinBySpecification {
	s.Interval = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalyticsBinBySpecification) SetName(v string) *AnalyticsBinBySpecification {
	s.Name = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *AnalyticsBinBySpecification) SetOrder(v string) *AnalyticsBinBySpecification {
	s.Order = &v
	return s
}

// An object containing the criterion by which to bin the results and the value
// that defines that bin.
type AnalyticsBinKey struct {
	_ struct{} `type:"structure"`

	// The criterion by which to bin the results.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsBinByName"`

	// The value of the criterion that defines the bin.
	Value *int64 `locationName:"value" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsBinKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsBinKey) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsBinKey) SetName(v string) *AnalyticsBinKey {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsBinKey) SetValue(v int64) *AnalyticsBinKey {
	s.Value = &v
	return s
}

// Contains fields describing a condition by which to filter the intents. The
// expression may be understood as name operator values. For example:
//
//   - IntentName CO Book – The intent name contains the string "Book."
//
//   - BotVersion EQ 2 – The bot version is equal to two.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ.
//
//   - BotVersion – EQ.
//
//   - LocaleId – EQ.
//
//   - Modality – EQ.
//
//   - Channel – EQ.
//
//   - SessionId – EQ.
//
//   - OriginatingRequestId – EQ.
//
//   - IntentName – EQ, CO.
//
//   - IntentEndState – EQ, CO.
type AnalyticsIntentFilter struct {
	_ struct{} `type:"structure"`

	// The category by which to filter the intents. The descriptions for each option
	// are as follows:
	//
	//    * BotAlias – The name of the bot alias.
	//
	//    * BotVersion – The version of the bot.
	//
	//    * LocaleId – The locale of the bot.
	//
	//    * Modality – The modality of the session with the bot (audio, DTMF,
	//    or text).
	//
	//    * Channel – The channel that the bot is integrated with.
	//
	//    * SessionId – The identifier of the session with the bot.
	//
	//    * OriginatingRequestId – The identifier of the first request in a session.
	//
	//    * IntentName – The name of the intent.
	//
	//    * IntentEndState – The final state of the intent.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsIntentFilterName"`

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//    * CO – Contains
	//
	//    * EQ – Equals
	//
	//    * GT – Greater than
	//
	//    * LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//    * BotAlias – EQ.
	//
	//    * BotVersion – EQ.
	//
	//    * LocaleId – EQ.
	//
	//    * Modality – EQ.
	//
	//    * Channel – EQ.
	//
	//    * SessionId – EQ.
	//
	//    * OriginatingRequestId – EQ.
	//
	//    * IntentName – EQ, CO.
	//
	//    * IntentEndState – EQ, CO.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"AnalyticsFilterOperator"`

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is
	// EQ or CO. If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name, operator, and values fields
	// are Modality, EQ, and [Speech, Text], the operation filters for results where
	// the modality was either Speech or Text.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsIntentFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsIntentFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentFilter) SetName(v string) *AnalyticsIntentFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalyticsIntentFilter) SetOperator(v string) *AnalyticsIntentFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AnalyticsIntentFilter) SetValues(v []*string) *AnalyticsIntentFilter {
	s.Values = v
	return s
}

// Contains the category by which the intent analytics were grouped and a member
// of that category.
type AnalyticsIntentGroupByKey struct {
	_ struct{} `type:"structure"`

	// A category by which the intent analytics were grouped.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsIntentField"`

	// A member of the category by which the intent analytics were grouped.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentGroupByKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentGroupByKey) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentGroupByKey) SetName(v string) *AnalyticsIntentGroupByKey {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsIntentGroupByKey) SetValue(v string) *AnalyticsIntentGroupByKey {
	s.Value = &v
	return s
}

// Contains the category by which to group the intents.
type AnalyticsIntentGroupBySpecification struct {
	_ struct{} `type:"structure"`

	// Specifies whether to group the intent stages by their name or their end state.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsIntentField"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentGroupBySpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentGroupBySpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsIntentGroupBySpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsIntentGroupBySpecification"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentGroupBySpecification) SetName(v string) *AnalyticsIntentGroupBySpecification {
	s.Name = &v
	return s
}

// Contains the metric and the summary statistic you want to calculate, and
// the order in which to sort the results, for the intents in the bot.
type AnalyticsIntentMetric struct {
	_ struct{} `type:"structure"`

	// The metric for which you want to get intent summary statistics.
	//
	//    * Count – The number of times the intent was invoked.
	//
	//    * Success – The number of times the intent succeeded.
	//
	//    * Failure – The number of times the intent failed.
	//
	//    * Switched – The number of times there was a switch to a different intent.
	//
	//    * Dropped – The number of times the user dropped the intent.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsIntentMetricName"`

	// Specifies whether to sort the results in ascending or descending order.
	Order *string `locationName:"order" type:"string" enum:"AnalyticsSortOrder"`

	// The summary statistic to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of intents in the
	//    category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	//
	// Statistic is a required field
	Statistic *string `locationName:"statistic" type:"string" required:"true" enum:"AnalyticsMetricStatistic"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsIntentMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsIntentMetric"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentMetric) SetName(v string) *AnalyticsIntentMetric {
	s.Name = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *AnalyticsIntentMetric) SetOrder(v string) *AnalyticsIntentMetric {
	s.Order = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsIntentMetric) SetStatistic(v string) *AnalyticsIntentMetric {
	s.Statistic = &v
	return s
}

// An object containing the results for the intent metric you requested.
type AnalyticsIntentMetricResult struct {
	_ struct{} `type:"structure"`

	// The metric that you requested. See Key definitions (https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html)
	// for more details about these metrics.
	//
	//    * Count – The number of times the intent was invoked.
	//
	//    * Success – The number of times the intent succeeded.
	//
	//    * Failure – The number of times the intent failed.
	//
	//    * Switched – The number of times there was a switch to a different intent.
	//
	//    * Dropped – The number of times the user dropped the intent.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsIntentMetricName"`

	// The statistic that you requested to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of intents in the
	//    category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	Statistic *string `locationName:"statistic" type:"string" enum:"AnalyticsMetricStatistic"`

	// The value of the summary statistic for the metric that you requested.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentMetricResult) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentMetricResult) SetName(v string) *AnalyticsIntentMetricResult {
	s.Name = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsIntentMetricResult) SetStatistic(v string) *AnalyticsIntentMetricResult {
	s.Statistic = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsIntentMetricResult) SetValue(v float64) *AnalyticsIntentMetricResult {
	s.Value = &v
	return s
}

// An object containing information about the requested path.
type AnalyticsIntentNodeSummary struct {
	_ struct{} `type:"structure"`

	// The total number of sessions that follow the given path to the given intent.
	IntentCount *int64 `locationName:"intentCount" type:"integer"`

	// The number of intents up to and including the requested path.
	IntentLevel *int64 `locationName:"intentLevel" type:"integer"`

	// The name of the intent at the end of the requested path.
	IntentName *string `locationName:"intentName" min:"1" type:"string"`

	// The path.
	IntentPath *string `locationName:"intentPath" min:"1" type:"string"`

	// Specifies whether the node is the end of a path (Exit) or not (Inner).
	NodeType *string `locationName:"nodeType" type:"string" enum:"AnalyticsNodeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentNodeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentNodeSummary) GoString() string {
	return s.String()
}

// SetIntentCount sets the IntentCount field's value.
func (s *AnalyticsIntentNodeSummary) SetIntentCount(v int64) *AnalyticsIntentNodeSummary {
	s.IntentCount = &v
	return s
}

// SetIntentLevel sets the IntentLevel field's value.
func (s *AnalyticsIntentNodeSummary) SetIntentLevel(v int64) *AnalyticsIntentNodeSummary {
	s.IntentLevel = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *AnalyticsIntentNodeSummary) SetIntentName(v string) *AnalyticsIntentNodeSummary {
	s.IntentName = &v
	return s
}

// SetIntentPath sets the IntentPath field's value.
func (s *AnalyticsIntentNodeSummary) SetIntentPath(v string) *AnalyticsIntentNodeSummary {
	s.IntentPath = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *AnalyticsIntentNodeSummary) SetNodeType(v string) *AnalyticsIntentNodeSummary {
	s.NodeType = &v
	return s
}

// An object containing the results for the intent metrics you requested and
// the bin and/or group(s) they refer to, if applicable.
type AnalyticsIntentResult struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the criteria you requested for binning results
	// and the values of the bins.
	BinKeys []*AnalyticsBinKey `locationName:"binKeys" min:"1" type:"list"`

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the groups.
	GroupByKeys []*AnalyticsIntentGroupByKey `locationName:"groupByKeys" type:"list"`

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []*AnalyticsIntentMetricResult `locationName:"metricsResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentResult) GoString() string {
	return s.String()
}

// SetBinKeys sets the BinKeys field's value.
func (s *AnalyticsIntentResult) SetBinKeys(v []*AnalyticsBinKey) *AnalyticsIntentResult {
	s.BinKeys = v
	return s
}

// SetGroupByKeys sets the GroupByKeys field's value.
func (s *AnalyticsIntentResult) SetGroupByKeys(v []*AnalyticsIntentGroupByKey) *AnalyticsIntentResult {
	s.GroupByKeys = v
	return s
}

// SetMetricsResults sets the MetricsResults field's value.
func (s *AnalyticsIntentResult) SetMetricsResults(v []*AnalyticsIntentMetricResult) *AnalyticsIntentResult {
	s.MetricsResults = v
	return s
}

// Contains fields describing a condition by which to filter the intent stages.
// The expression may be understood as name operator values. For example:
//
//   - IntentName CO Book – The intent name contains the string "Book."
//
//   - BotVersion EQ 2 – The bot version is equal to two.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ.
//
//   - BotVersion – EQ.
//
//   - LocaleId – EQ.
//
//   - Modality – EQ.
//
//   - Channel – EQ.
//
//   - SessionId – EQ.
//
//   - OriginatingRequestId – EQ.
//
//   - IntentName – EQ, CO.
//
//   - IntentStageName – EQ, CO.
type AnalyticsIntentStageFilter struct {
	_ struct{} `type:"structure"`

	// The category by which to filter the intent stages. The descriptions for each
	// option are as follows:
	//
	//    * BotAlias – The name of the bot alias.
	//
	//    * BotVersion – The version of the bot.
	//
	//    * LocaleId – The locale of the bot.
	//
	//    * Modality – The modality of the session with the bot (audio, DTMF,
	//    or text).
	//
	//    * Channel – The channel that the bot is integrated with.
	//
	//    * SessionId – The identifier of the session with the bot.
	//
	//    * OriginatingRequestId – The identifier of the first request in a session.
	//
	//    * IntentName – The name of the intent.
	//
	//    * IntentStageName – The stage in the intent.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsIntentStageFilterName"`

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//    * CO – Contains
	//
	//    * EQ – Equals
	//
	//    * GT – Greater than
	//
	//    * LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//    * BotAlias – EQ.
	//
	//    * BotVersion – EQ.
	//
	//    * LocaleId – EQ.
	//
	//    * Modality – EQ.
	//
	//    * Channel – EQ.
	//
	//    * SessionId – EQ.
	//
	//    * OriginatingRequestId – EQ.
	//
	//    * IntentName – EQ, CO.
	//
	//    * IntentStageName – EQ, CO.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"AnalyticsFilterOperator"`

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is
	// EQ or CO. If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name, operator, and values fields
	// are Modality, EQ, and [Speech, Text], the operation filters for results where
	// the modality was either Speech or Text.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsIntentStageFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsIntentStageFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentStageFilter) SetName(v string) *AnalyticsIntentStageFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalyticsIntentStageFilter) SetOperator(v string) *AnalyticsIntentStageFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AnalyticsIntentStageFilter) SetValues(v []*string) *AnalyticsIntentStageFilter {
	s.Values = v
	return s
}

// Contains the category by which the intent stage analytics and the values
// for that category were grouped.
type AnalyticsIntentStageGroupByKey struct {
	_ struct{} `type:"structure"`

	// A category by which the intent stage analytics were grouped.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsIntentStageField"`

	// A member of the category by which the intent stage analytics were grouped.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageGroupByKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageGroupByKey) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentStageGroupByKey) SetName(v string) *AnalyticsIntentStageGroupByKey {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsIntentStageGroupByKey) SetValue(v string) *AnalyticsIntentStageGroupByKey {
	s.Value = &v
	return s
}

// Contains the category by which to group the intent stages.
type AnalyticsIntentStageGroupBySpecification struct {
	_ struct{} `type:"structure"`

	// Specifies whether to group the intent stages by their name or the intent
	// to which the session was switched.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsIntentStageField"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageGroupBySpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageGroupBySpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsIntentStageGroupBySpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsIntentStageGroupBySpecification"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentStageGroupBySpecification) SetName(v string) *AnalyticsIntentStageGroupBySpecification {
	s.Name = &v
	return s
}

// Contains the metric and the summary statistic you want to calculate, and
// the order in which to sort the results, for the intent stages across the
// user sessions with the bot.
type AnalyticsIntentStageMetric struct {
	_ struct{} `type:"structure"`

	// The metric for which you want to get intent stage summary statistics. See
	// Key definitions (https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html)
	// for more details about these metrics.
	//
	//    * Count – The number of times the intent stage occurred.
	//
	//    * Success – The number of times the intent stage succeeded.
	//
	//    * Failure – The number of times the intent stage failed.
	//
	//    * Dropped – The number of times the user dropped the intent stage.
	//
	//    * Retry – The number of times the bot tried to elicit a response from
	//    the user at this stage.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsIntentStageMetricName"`

	// Specifies whether to sort the results in ascending or descending order of
	// the summary statistic (value in the response).
	Order *string `locationName:"order" type:"string" enum:"AnalyticsSortOrder"`

	// The summary statistic to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of intent stages in
	//    the category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	//
	// Statistic is a required field
	Statistic *string `locationName:"statistic" type:"string" required:"true" enum:"AnalyticsMetricStatistic"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsIntentStageMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsIntentStageMetric"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentStageMetric) SetName(v string) *AnalyticsIntentStageMetric {
	s.Name = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *AnalyticsIntentStageMetric) SetOrder(v string) *AnalyticsIntentStageMetric {
	s.Order = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsIntentStageMetric) SetStatistic(v string) *AnalyticsIntentStageMetric {
	s.Statistic = &v
	return s
}

// An object containing the results for an intent stage metric you requested.
type AnalyticsIntentStageMetricResult struct {
	_ struct{} `type:"structure"`

	// The metric that you requested.
	//
	//    * Count – The number of times the intent stage occurred.
	//
	//    * Success – The number of times the intent stage succeeded.
	//
	//    * Failure – The number of times the intent stage failed.
	//
	//    * Dropped – The number of times the user dropped the intent stage.
	//
	//    * Retry – The number of times the bot tried to elicit a response from
	//    the user at this stage.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsIntentStageMetricName"`

	// The summary statistic that you requested to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of intent stages in
	//    the category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	Statistic *string `locationName:"statistic" type:"string" enum:"AnalyticsMetricStatistic"`

	// The value of the summary statistic for the metric that you requested.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageMetricResult) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsIntentStageMetricResult) SetName(v string) *AnalyticsIntentStageMetricResult {
	s.Name = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsIntentStageMetricResult) SetStatistic(v string) *AnalyticsIntentStageMetricResult {
	s.Statistic = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsIntentStageMetricResult) SetValue(v float64) *AnalyticsIntentStageMetricResult {
	s.Value = &v
	return s
}

// An object containing the results for the intent stage metrics you requested
// and the bin and/or group they refer to, if applicable.
type AnalyticsIntentStageResult struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the criteria you requested for binning results
	// and the values of the bins.
	BinKeys []*AnalyticsBinKey `locationName:"binKeys" min:"1" type:"list"`

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the bins.
	GroupByKeys []*AnalyticsIntentStageGroupByKey `locationName:"groupByKeys" type:"list"`

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []*AnalyticsIntentStageMetricResult `locationName:"metricsResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsIntentStageResult) GoString() string {
	return s.String()
}

// SetBinKeys sets the BinKeys field's value.
func (s *AnalyticsIntentStageResult) SetBinKeys(v []*AnalyticsBinKey) *AnalyticsIntentStageResult {
	s.BinKeys = v
	return s
}

// SetGroupByKeys sets the GroupByKeys field's value.
func (s *AnalyticsIntentStageResult) SetGroupByKeys(v []*AnalyticsIntentStageGroupByKey) *AnalyticsIntentStageResult {
	s.GroupByKeys = v
	return s
}

// SetMetricsResults sets the MetricsResults field's value.
func (s *AnalyticsIntentStageResult) SetMetricsResults(v []*AnalyticsIntentStageMetricResult) *AnalyticsIntentStageResult {
	s.MetricsResults = v
	return s
}

// Contains fields describing a condition by which to filter the paths. The
// expression may be understood as name operator values. For example:
//
//   - LocaleId EQ en – The locale is "en".
//
//   - BotVersion EQ 2 – The bot version is equal to two.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ.
//
//   - BotVersion – EQ.
//
//   - LocaleId – EQ.
//
//   - Modality – EQ.
//
//   - Channel – EQ.
type AnalyticsPathFilter struct {
	_ struct{} `type:"structure"`

	// The category by which to filter the intent paths. The descriptions for each
	// option are as follows:
	//
	//    * BotAlias – The name of the bot alias.
	//
	//    * BotVersion – The version of the bot.
	//
	//    * LocaleId – The locale of the bot.
	//
	//    * Modality – The modality of the session with the bot (audio, DTMF,
	//    or text).
	//
	//    * Channel – The channel that the bot is integrated with.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsCommonFilterName"`

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//    * CO – Contains
	//
	//    * EQ – Equals
	//
	//    * GT – Greater than
	//
	//    * LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//    * BotAlias – EQ.
	//
	//    * BotVersion – EQ.
	//
	//    * LocaleId – EQ.
	//
	//    * Modality – EQ.
	//
	//    * Channel – EQ.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"AnalyticsFilterOperator"`

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is
	// EQ or CO. If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name, operator, and values fields
	// are Modality, EQ, and [Speech, Text], the operation filters for results where
	// the modality was either Speech or Text.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsPathFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsPathFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsPathFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsPathFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsPathFilter) SetName(v string) *AnalyticsPathFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalyticsPathFilter) SetOperator(v string) *AnalyticsPathFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AnalyticsPathFilter) SetValues(v []*string) *AnalyticsPathFilter {
	s.Values = v
	return s
}

// Contains fields describing a condition by which to filter the sessions. The
// expression may be understood as name operator values. For example:
//
//   - LocaleId EQ en – The locale is "en".
//
//   - Duration GT 200 – The duration is greater than 200 seconds.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ.
//
//   - BotVersion – EQ.
//
//   - LocaleId – EQ.
//
//   - Modality – EQ.
//
//   - Channel – EQ.
//
//   - Duration – EQ, GT, LT.
//
//   - conversationEndState – EQ, CO.
//
//   - SessionId – EQ.
//
//   - OriginatingRequestId – EQ.
//
//   - IntentPath – EQ.
type AnalyticsSessionFilter struct {
	_ struct{} `type:"structure"`

	// The category by which to filter the sessions. The descriptions for each option
	// are as follows:
	//
	//    * BotAlias – The name of the bot alias.
	//
	//    * BotVersion – The version of the bot.
	//
	//    * LocaleId – The locale of the bot.
	//
	//    * Modality – The modality of the session with the bot (audio, DTMF,
	//    or text).
	//
	//    * Channel – The channel that the bot is integrated with.
	//
	//    * Duration – The duration of the session.
	//
	//    * conversationEndState – The final state of the session.
	//
	//    * SessionId – The identifier of the session with the bot.
	//
	//    * OriginatingRequestId – The identifier of the first request in a session.
	//
	//    * IntentPath – The order of intents taken in a session.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsSessionFilterName"`

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//    * CO – Contains
	//
	//    * EQ – Equals
	//
	//    * GT – Greater than
	//
	//    * LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//    * BotAlias – EQ.
	//
	//    * BotVersion – EQ.
	//
	//    * LocaleId – EQ.
	//
	//    * Modality – EQ.
	//
	//    * Channel – EQ.
	//
	//    * Duration – EQ, GT, LT.
	//
	//    * conversationEndState – EQ, CO.
	//
	//    * SessionId – EQ.
	//
	//    * OriginatingRequestId – EQ.
	//
	//    * IntentPath – EQ.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"AnalyticsFilterOperator"`

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is
	// EQ or CO. If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name, operator, and values fields
	// are Modality, EQ, and [Speech, Text], the operation filters for results where
	// the modality was either Speech or Text.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsSessionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsSessionFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsSessionFilter) SetName(v string) *AnalyticsSessionFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalyticsSessionFilter) SetOperator(v string) *AnalyticsSessionFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AnalyticsSessionFilter) SetValues(v []*string) *AnalyticsSessionFilter {
	s.Values = v
	return s
}

// Contains the category by which the session analytics were grouped and a member
// of that category.
type AnalyticsSessionGroupByKey struct {
	_ struct{} `type:"structure"`

	// The category by which the session analytics were grouped.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsSessionField"`

	// A member of the category by which the session analytics were grouped.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionGroupByKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionGroupByKey) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsSessionGroupByKey) SetName(v string) *AnalyticsSessionGroupByKey {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsSessionGroupByKey) SetValue(v string) *AnalyticsSessionGroupByKey {
	s.Value = &v
	return s
}

// Contains the category by which to group the sessions.
type AnalyticsSessionGroupBySpecification struct {
	_ struct{} `type:"structure"`

	// Specifies whether to group the session by their end state or their locale.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsSessionField"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionGroupBySpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionGroupBySpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsSessionGroupBySpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsSessionGroupBySpecification"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsSessionGroupBySpecification) SetName(v string) *AnalyticsSessionGroupBySpecification {
	s.Name = &v
	return s
}

// Contains the metric and the summary statistic you want to calculate, and
// the order in which to sort the results, for the user sessions with the bot.
type AnalyticsSessionMetric struct {
	_ struct{} `type:"structure"`

	// The metric for which you want to get session summary statistics.
	//
	//    * Count – The number of sessions.
	//
	//    * Success – The number of sessions that succeeded.
	//
	//    * Failure – The number of sessions that failed.
	//
	//    * Dropped – The number of sessions that the user dropped.
	//
	//    * Duration – The duration of sessions.
	//
	//    * TurnsPerSession – The number of turns in the sessions.
	//
	//    * Concurrency – The number of sessions occurring in the same period
	//    of time.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsSessionMetricName"`

	// Specifies whether to sort the results in ascending or descending order.
	Order *string `locationName:"order" type:"string" enum:"AnalyticsSortOrder"`

	// The summary statistic to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of sessions in the
	//    category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	//
	// Statistic is a required field
	Statistic *string `locationName:"statistic" type:"string" required:"true" enum:"AnalyticsMetricStatistic"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsSessionMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsSessionMetric"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsSessionMetric) SetName(v string) *AnalyticsSessionMetric {
	s.Name = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *AnalyticsSessionMetric) SetOrder(v string) *AnalyticsSessionMetric {
	s.Order = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsSessionMetric) SetStatistic(v string) *AnalyticsSessionMetric {
	s.Statistic = &v
	return s
}

// An object containing the results for a session metric you requested.
type AnalyticsSessionMetricResult struct {
	_ struct{} `type:"structure"`

	// The metric that you requested.
	//
	//    * Count – The number of sessions.
	//
	//    * Success – The number of sessions that succeeded.
	//
	//    * Failure – The number of sessions that failed.
	//
	//    * Dropped – The number of sessions that the user dropped.
	//
	//    * Duration – The duration of sessions.
	//
	//    * TurnPersession – The number of turns in the sessions.
	//
	//    * Concurrency – The number of sessions occurring in the same period
	//    of time.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsSessionMetricName"`

	// The summary statistic that you requested to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of sessions in the
	//    category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	Statistic *string `locationName:"statistic" type:"string" enum:"AnalyticsMetricStatistic"`

	// The value of the summary statistic for the metric that you requested.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionMetricResult) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsSessionMetricResult) SetName(v string) *AnalyticsSessionMetricResult {
	s.Name = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsSessionMetricResult) SetStatistic(v string) *AnalyticsSessionMetricResult {
	s.Statistic = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsSessionMetricResult) SetValue(v float64) *AnalyticsSessionMetricResult {
	s.Value = &v
	return s
}

// An object containing the results for the session metrics you requested and
// the bin and/or group(s) they refer to, if applicable.
type AnalyticsSessionResult struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the criteria you requested for binning results
	// and the values of the bins.
	BinKeys []*AnalyticsBinKey `locationName:"binKeys" min:"1" type:"list"`

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the bins.
	GroupByKeys []*AnalyticsSessionGroupByKey `locationName:"groupByKeys" type:"list"`

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []*AnalyticsSessionMetricResult `locationName:"metricsResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsSessionResult) GoString() string {
	return s.String()
}

// SetBinKeys sets the BinKeys field's value.
func (s *AnalyticsSessionResult) SetBinKeys(v []*AnalyticsBinKey) *AnalyticsSessionResult {
	s.BinKeys = v
	return s
}

// SetGroupByKeys sets the GroupByKeys field's value.
func (s *AnalyticsSessionResult) SetGroupByKeys(v []*AnalyticsSessionGroupByKey) *AnalyticsSessionResult {
	s.GroupByKeys = v
	return s
}

// SetMetricsResults sets the MetricsResults field's value.
func (s *AnalyticsSessionResult) SetMetricsResults(v []*AnalyticsSessionMetricResult) *AnalyticsSessionResult {
	s.MetricsResults = v
	return s
}

// An object that specifies the last used intent at the time of the utterance
// as an attribute to return.
type AnalyticsUtteranceAttribute struct {
	_ struct{} `type:"structure"`

	// An attribute to return. The only available attribute is the intent that the
	// bot mapped the utterance to.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsUtteranceAttributeName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsUtteranceAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsUtteranceAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsUtteranceAttribute) SetName(v string) *AnalyticsUtteranceAttribute {
	s.Name = &v
	return s
}

// An object containing the intent that the bot mapped the utterance to.
type AnalyticsUtteranceAttributeResult struct {
	_ struct{} `type:"structure"`

	// The intent that the bot mapped the utterance to.
	LastUsedIntent *string `locationName:"lastUsedIntent" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceAttributeResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceAttributeResult) GoString() string {
	return s.String()
}

// SetLastUsedIntent sets the LastUsedIntent field's value.
func (s *AnalyticsUtteranceAttributeResult) SetLastUsedIntent(v string) *AnalyticsUtteranceAttributeResult {
	s.LastUsedIntent = &v
	return s
}

// Contains fields describing a condition by which to filter the utterances.
// The expression may be understood as name operator values. For example:
//
//   - LocaleId EQ Book – The locale is the string "en".
//
//   - UtteranceText CO help – The text of the utterance contains the string
//     "help".
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ.
//
//   - BotVersion – EQ.
//
//   - LocaleId – EQ.
//
//   - Modality – EQ.
//
//   - Channel – EQ.
//
//   - SessionId – EQ.
//
//   - OriginatingRequestId – EQ.
//
//   - UtteranceState – EQ.
//
//   - UtteranceText – EQ, CO.
type AnalyticsUtteranceFilter struct {
	_ struct{} `type:"structure"`

	// The category by which to filter the utterances. The descriptions for each
	// option are as follows:
	//
	//    * BotAlias – The name of the bot alias.
	//
	//    * BotVersion – The version of the bot.
	//
	//    * LocaleId – The locale of the bot.
	//
	//    * Modality – The modality of the session with the bot (audio, DTMF,
	//    or text).
	//
	//    * Channel – The channel that the bot is integrated with.
	//
	//    * SessionId – The identifier of the session with the bot.
	//
	//    * OriginatingRequestId – The identifier of the first request in a session.
	//
	//    * UtteranceState – The state of the utterance.
	//
	//    * UtteranceText – The text in the utterance.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsUtteranceFilterName"`

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//    * CO – Contains
	//
	//    * EQ – Equals
	//
	//    * GT – Greater than
	//
	//    * LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//    * BotAlias – EQ.
	//
	//    * BotVersion – EQ.
	//
	//    * LocaleId – EQ.
	//
	//    * Modality – EQ.
	//
	//    * Channel – EQ.
	//
	//    * SessionId – EQ.
	//
	//    * OriginatingRequestId – EQ.
	//
	//    * UtteranceState – EQ.
	//
	//    * UtteranceText – EQ, CO.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"AnalyticsFilterOperator"`

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is
	// EQ or CO. If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name, operator, and values fields
	// are Modality, EQ, and [Speech, Text], the operation filters for results where
	// the modality was either Speech or Text.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsUtteranceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsUtteranceFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsUtteranceFilter) SetName(v string) *AnalyticsUtteranceFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalyticsUtteranceFilter) SetOperator(v string) *AnalyticsUtteranceFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AnalyticsUtteranceFilter) SetValues(v []*string) *AnalyticsUtteranceFilter {
	s.Values = v
	return s
}

// Contains the category by which the utterance analytics were grouped and the
// values for that category.
type AnalyticsUtteranceGroupByKey struct {
	_ struct{} `type:"structure"`

	// The category by which the utterance analytics were grouped.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsUtteranceField"`

	// A member of the category by which the utterance analytics were grouped.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceGroupByKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceGroupByKey) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsUtteranceGroupByKey) SetName(v string) *AnalyticsUtteranceGroupByKey {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsUtteranceGroupByKey) SetValue(v string) *AnalyticsUtteranceGroupByKey {
	s.Value = &v
	return s
}

// Contains the category by which to group the utterances.
type AnalyticsUtteranceGroupBySpecification struct {
	_ struct{} `type:"structure"`

	// Specifies whether to group the utterances by their text or their state.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsUtteranceField"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceGroupBySpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceGroupBySpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsUtteranceGroupBySpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsUtteranceGroupBySpecification"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsUtteranceGroupBySpecification) SetName(v string) *AnalyticsUtteranceGroupBySpecification {
	s.Name = &v
	return s
}

// Contains the metric and the summary statistic you want to calculate, and
// the order in which to sort the results, for the utterances across the user
// sessions with the bot.
type AnalyticsUtteranceMetric struct {
	_ struct{} `type:"structure"`

	// The metric for which you want to get utterance summary statistics.
	//
	//    * Count – The number of utterances.
	//
	//    * Missed – The number of utterances that Amazon Lex failed to recognize.
	//
	//    * Detected – The number of utterances that Amazon Lex managed to detect.
	//
	//    * UtteranceTimestamp – The date and time of the utterance.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AnalyticsUtteranceMetricName"`

	// Specifies whether to sort the results in ascending or descending order.
	Order *string `locationName:"order" type:"string" enum:"AnalyticsSortOrder"`

	// The summary statistic to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of utterances in the
	//    category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	//
	// Statistic is a required field
	Statistic *string `locationName:"statistic" type:"string" required:"true" enum:"AnalyticsMetricStatistic"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsUtteranceMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsUtteranceMetric"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AnalyticsUtteranceMetric) SetName(v string) *AnalyticsUtteranceMetric {
	s.Name = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *AnalyticsUtteranceMetric) SetOrder(v string) *AnalyticsUtteranceMetric {
	s.Order = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsUtteranceMetric) SetStatistic(v string) *AnalyticsUtteranceMetric {
	s.Statistic = &v
	return s
}

// An object containing the results for the utterance metric you requested.
type AnalyticsUtteranceMetricResult struct {
	_ struct{} `type:"structure"`

	// The metric that you requested.
	//
	//    * Count – The number of utterances.
	//
	//    * Missed – The number of utterances that Amazon Lex failed to recognize.
	//
	//    * Detected – The number of utterances that Amazon Lex managed to detect.
	//
	//    * UtteranceTimestamp – The date and time of the utterance.
	Name *string `locationName:"name" type:"string" enum:"AnalyticsUtteranceMetricName"`

	// The summary statistic that you requested to calculate.
	//
	//    * Sum – The total count for the category you provide in name.
	//
	//    * Average – The total count divided by the number of utterances in the
	//    category you provide in name.
	//
	//    * Max – The highest count in the category you provide in name.
	Statistic *string `locationName:"statistic" type:"string" enum:"AnalyticsMetricStatistic"`

	// The value of the summary statistic for the metric that you requested.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceMetricResult) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalyticsUtteranceMetricResult) SetName(v string) *AnalyticsUtteranceMetricResult {
	s.Name = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *AnalyticsUtteranceMetricResult) SetStatistic(v string) *AnalyticsUtteranceMetricResult {
	s.Statistic = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalyticsUtteranceMetricResult) SetValue(v float64) *AnalyticsUtteranceMetricResult {
	s.Value = &v
	return s
}

// An object containing the results for the utterance metrics you requested
// and the bin and/or group(s) they refer to, if applicable.
type AnalyticsUtteranceResult struct {
	_ struct{} `type:"structure"`

	// A list of objects containing information about the last used intent at the
	// time of an utterance.
	AttributeResults []*AnalyticsUtteranceAttributeResult `locationName:"attributeResults" type:"list"`

	// A list of objects containing the criteria you requested for binning results
	// and the values of the bins.
	BinKeys []*AnalyticsBinKey `locationName:"binKeys" min:"1" type:"list"`

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the bins.
	GroupByKeys []*AnalyticsUtteranceGroupByKey `locationName:"groupByKeys" type:"list"`

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []*AnalyticsUtteranceMetricResult `locationName:"metricsResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsUtteranceResult) GoString() string {
	return s.String()
}

// SetAttributeResults sets the AttributeResults field's value.
func (s *AnalyticsUtteranceResult) SetAttributeResults(v []*AnalyticsUtteranceAttributeResult) *AnalyticsUtteranceResult {
	s.AttributeResults = v
	return s
}

// SetBinKeys sets the BinKeys field's value.
func (s *AnalyticsUtteranceResult) SetBinKeys(v []*AnalyticsBinKey) *AnalyticsUtteranceResult {
	s.BinKeys = v
	return s
}

// SetGroupByKeys sets the GroupByKeys field's value.
func (s *AnalyticsUtteranceResult) SetGroupByKeys(v []*AnalyticsUtteranceGroupByKey) *AnalyticsUtteranceResult {
	s.GroupByKeys = v
	return s
}

// SetMetricsResults sets the MetricsResults field's value.
func (s *AnalyticsUtteranceResult) SetMetricsResults(v []*AnalyticsUtteranceMetricResult) *AnalyticsUtteranceResult {
	s.MetricsResults = v
	return s
}

// The object containing information that associates the recommended intent/slot
// type with a conversation.
type AssociatedTranscript struct {
	_ struct{} `type:"structure"`

	// The content of the transcript that meets the search filter criteria. For
	// the JSON format of the transcript, see Output transcript format (https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html).
	Transcript *string `locationName:"transcript" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscript) GoString() string {
	return s.String()
}

// SetTranscript sets the Transcript field's value.
func (s *AssociatedTranscript) SetTranscript(v string) *AssociatedTranscript {
	s.Transcript = &v
	return s
}

// Filters to search for the associated transcript.
type AssociatedTranscriptFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to use for filtering. The allowed names are IntentId
	// and SlotTypeId.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AssociatedTranscriptFilterName"`

	// The values to use to filter the transcript.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscriptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscriptFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatedTranscriptFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatedTranscriptFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssociatedTranscriptFilter) SetName(v string) *AssociatedTranscriptFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AssociatedTranscriptFilter) SetValues(v []*string) *AssociatedTranscriptFilter {
	s.Values = v
	return s
}

// Specifies the audio and DTMF input specification.
type AudioAndDTMFInputSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies the settings on audio input.
	AudioSpecification *AudioSpecification `locationName:"audioSpecification" type:"structure"`

	// Specifies the settings on DTMF input.
	DtmfSpecification *DTMFSpecification `locationName:"dtmfSpecification" type:"structure"`

	// Time for which a bot waits before assuming that the customer isn't going
	// to speak or press a key. This timeout is shared between Audio and DTMF inputs.
	//
	// StartTimeoutMs is a required field
	StartTimeoutMs *int64 `locationName:"startTimeoutMs" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioAndDTMFInputSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioAndDTMFInputSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioAndDTMFInputSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioAndDTMFInputSpecification"}
	if s.StartTimeoutMs == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeoutMs"))
	}
	if s.StartTimeoutMs != nil && *s.StartTimeoutMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("StartTimeoutMs", 1))
	}
	if s.AudioSpecification != nil {
		if err := s.AudioSpecification.Validate(); err != nil {
			invalidParams.AddNested("AudioSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.DtmfSpecification != nil {
		if err := s.DtmfSpecification.Validate(); err != nil {
			invalidParams.AddNested("DtmfSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioSpecification sets the AudioSpecification field's value.
func (s *AudioAndDTMFInputSpecification) SetAudioSpecification(v *AudioSpecification) *AudioAndDTMFInputSpecification {
	s.AudioSpecification = v
	return s
}

// SetDtmfSpecification sets the DtmfSpecification field's value.
func (s *AudioAndDTMFInputSpecification) SetDtmfSpecification(v *DTMFSpecification) *AudioAndDTMFInputSpecification {
	s.DtmfSpecification = v
	return s
}

// SetStartTimeoutMs sets the StartTimeoutMs field's value.
func (s *AudioAndDTMFInputSpecification) SetStartTimeoutMs(v int64) *AudioAndDTMFInputSpecification {
	s.StartTimeoutMs = &v
	return s
}

// The location of audio log files collected when conversation logging is enabled
// for a bot.
type AudioLogDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the audio log files are stored. The IAM role specified
	// in the roleArn parameter of the CreateBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html)
	// operation must have permission to write to this bucket.
	//
	// S3Bucket is a required field
	S3Bucket *S3BucketLogDestination `locationName:"s3Bucket" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLogDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioLogDestination"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil {
		if err := s.S3Bucket.Validate(); err != nil {
			invalidParams.AddNested("S3Bucket", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *AudioLogDestination) SetS3Bucket(v *S3BucketLogDestination) *AudioLogDestination {
	s.S3Bucket = v
	return s
}

// Settings for logging audio of conversations between Amazon Lex and a user.
// You specify whether to log audio and the Amazon S3 bucket where the audio
// file is stored.
type AudioLogSetting struct {
	_ struct{} `type:"structure"`

	// The location of audio log files collected when conversation logging is enabled
	// for a bot.
	//
	// Destination is a required field
	Destination *AudioLogDestination `locationName:"destination" type:"structure" required:"true"`

	// Determines whether audio logging in enabled for the bot.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The option to enable selective conversation log capture for audio.
	SelectiveLoggingEnabled *bool `locationName:"selectiveLoggingEnabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLogSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioLogSetting"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *AudioLogSetting) SetDestination(v *AudioLogDestination) *AudioLogSetting {
	s.Destination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AudioLogSetting) SetEnabled(v bool) *AudioLogSetting {
	s.Enabled = &v
	return s
}

// SetSelectiveLoggingEnabled sets the SelectiveLoggingEnabled field's value.
func (s *AudioLogSetting) SetSelectiveLoggingEnabled(v bool) *AudioLogSetting {
	s.SelectiveLoggingEnabled = &v
	return s
}

// Specifies the audio input specifications.
type AudioSpecification struct {
	_ struct{} `type:"structure"`

	// Time for which a bot waits after the customer stops speaking to assume the
	// utterance is finished.
	//
	// EndTimeoutMs is a required field
	EndTimeoutMs *int64 `locationName:"endTimeoutMs" min:"1" type:"integer" required:"true"`

	// Time for how long Amazon Lex waits before speech input is truncated and the
	// speech is returned to application.
	//
	// MaxLengthMs is a required field
	MaxLengthMs *int64 `locationName:"maxLengthMs" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSpecification"}
	if s.EndTimeoutMs == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeoutMs"))
	}
	if s.EndTimeoutMs != nil && *s.EndTimeoutMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EndTimeoutMs", 1))
	}
	if s.MaxLengthMs == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxLengthMs"))
	}
	if s.MaxLengthMs != nil && *s.MaxLengthMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxLengthMs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTimeoutMs sets the EndTimeoutMs field's value.
func (s *AudioSpecification) SetEndTimeoutMs(v int64) *AudioSpecification {
	s.EndTimeoutMs = &v
	return s
}

// SetMaxLengthMs sets the MaxLengthMs field's value.
func (s *AudioSpecification) SetMaxLengthMs(v int64) *AudioSpecification {
	s.MaxLengthMs = &v
	return s
}

type BatchCreateCustomVocabularyItemInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// A list of new custom vocabulary items. Each entry must contain a phrase and
	// can optionally contain a displayAs and/or a weight.
	//
	// CustomVocabularyItemList is a required field
	CustomVocabularyItemList []*NewCustomVocabularyItem `locationName:"customVocabularyItemList" min:"1" type:"list" required:"true"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateCustomVocabularyItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateCustomVocabularyItemInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.CustomVocabularyItemList == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomVocabularyItemList"))
	}
	if s.CustomVocabularyItemList != nil && len(s.CustomVocabularyItemList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomVocabularyItemList", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.CustomVocabularyItemList != nil {
		for i, v := range s.CustomVocabularyItemList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomVocabularyItemList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetBotId(v string) *BatchCreateCustomVocabularyItemInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetBotVersion(v string) *BatchCreateCustomVocabularyItemInput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyItemList sets the CustomVocabularyItemList field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetCustomVocabularyItemList(v []*NewCustomVocabularyItem) *BatchCreateCustomVocabularyItemInput {
	s.CustomVocabularyItemList = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetLocaleId(v string) *BatchCreateCustomVocabularyItemInput {
	s.LocaleId = &v
	return s
}

type BatchCreateCustomVocabularyItemOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A list of custom vocabulary items that failed to create during the operation.
	// The reason for the error is contained within each error object.
	Errors []*FailedCustomVocabularyItem `locationName:"errors" type:"list"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of custom vocabulary items that were successfully created during the
	// operation.
	Resources []*CustomVocabularyItem `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetBotId(v string) *BatchCreateCustomVocabularyItemOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetBotVersion(v string) *BatchCreateCustomVocabularyItemOutput {
	s.BotVersion = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetErrors(v []*FailedCustomVocabularyItem) *BatchCreateCustomVocabularyItemOutput {
	s.Errors = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetLocaleId(v string) *BatchCreateCustomVocabularyItemOutput {
	s.LocaleId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetResources(v []*CustomVocabularyItem) *BatchCreateCustomVocabularyItemOutput {
	s.Resources = v
	return s
}

type BatchDeleteCustomVocabularyItemInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// A list of custom vocabulary items requested to be deleted. Each entry must
	// contain the unique custom vocabulary entry identifier.
	//
	// CustomVocabularyItemList is a required field
	CustomVocabularyItemList []*CustomVocabularyEntryId `locationName:"customVocabularyItemList" min:"1" type:"list" required:"true"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteCustomVocabularyItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteCustomVocabularyItemInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.CustomVocabularyItemList == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomVocabularyItemList"))
	}
	if s.CustomVocabularyItemList != nil && len(s.CustomVocabularyItemList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomVocabularyItemList", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.CustomVocabularyItemList != nil {
		for i, v := range s.CustomVocabularyItemList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomVocabularyItemList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetBotId(v string) *BatchDeleteCustomVocabularyItemInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetBotVersion(v string) *BatchDeleteCustomVocabularyItemInput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyItemList sets the CustomVocabularyItemList field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetCustomVocabularyItemList(v []*CustomVocabularyEntryId) *BatchDeleteCustomVocabularyItemInput {
	s.CustomVocabularyItemList = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetLocaleId(v string) *BatchDeleteCustomVocabularyItemInput {
	s.LocaleId = &v
	return s
}

type BatchDeleteCustomVocabularyItemOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A list of custom vocabulary items that failed to delete during the operation.
	// The reason for the error is contained within each error object.
	Errors []*FailedCustomVocabularyItem `locationName:"errors" type:"list"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of custom vocabulary items that were successfully deleted during the
	// operation.
	Resources []*CustomVocabularyItem `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetBotId(v string) *BatchDeleteCustomVocabularyItemOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetBotVersion(v string) *BatchDeleteCustomVocabularyItemOutput {
	s.BotVersion = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetErrors(v []*FailedCustomVocabularyItem) *BatchDeleteCustomVocabularyItemOutput {
	s.Errors = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetLocaleId(v string) *BatchDeleteCustomVocabularyItemOutput {
	s.LocaleId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetResources(v []*CustomVocabularyItem) *BatchDeleteCustomVocabularyItemOutput {
	s.Resources = v
	return s
}

type BatchUpdateCustomVocabularyItemInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// A list of custom vocabulary items with updated fields. Each entry must contain
	// a phrase and can optionally contain a displayAs and/or a weight.
	//
	// CustomVocabularyItemList is a required field
	CustomVocabularyItemList []*CustomVocabularyItem `locationName:"customVocabularyItemList" min:"1" type:"list" required:"true"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateCustomVocabularyItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateCustomVocabularyItemInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.CustomVocabularyItemList == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomVocabularyItemList"))
	}
	if s.CustomVocabularyItemList != nil && len(s.CustomVocabularyItemList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomVocabularyItemList", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.CustomVocabularyItemList != nil {
		for i, v := range s.CustomVocabularyItemList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomVocabularyItemList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetBotId(v string) *BatchUpdateCustomVocabularyItemInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetBotVersion(v string) *BatchUpdateCustomVocabularyItemInput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyItemList sets the CustomVocabularyItemList field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetCustomVocabularyItemList(v []*CustomVocabularyItem) *BatchUpdateCustomVocabularyItemInput {
	s.CustomVocabularyItemList = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetLocaleId(v string) *BatchUpdateCustomVocabularyItemInput {
	s.LocaleId = &v
	return s
}

type BatchUpdateCustomVocabularyItemOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A list of custom vocabulary items that failed to update during the operation.
	// The reason for the error is contained within each error object.
	Errors []*FailedCustomVocabularyItem `locationName:"errors" type:"list"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of custom vocabulary items that were successfully updated during the
	// operation.
	Resources []*CustomVocabularyItem `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetBotId(v string) *BatchUpdateCustomVocabularyItemOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetBotVersion(v string) *BatchUpdateCustomVocabularyItemOutput {
	s.BotVersion = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetErrors(v []*FailedCustomVocabularyItem) *BatchUpdateCustomVocabularyItemOutput {
	s.Errors = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetLocaleId(v string) *BatchUpdateCustomVocabularyItemOutput {
	s.LocaleId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetResources(v []*CustomVocabularyItem) *BatchUpdateCustomVocabularyItemOutput {
	s.Resources = v
	return s
}

// The details on the Bedrock guardrail configuration.
type BedrockGuardrailConfiguration struct {
	_ struct{} `type:"structure"`

	// The unique guardrail id for the Bedrock guardrail configuration.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true"`

	// The guardrail version for the Bedrock guardrail configuration.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockGuardrailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockGuardrailConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BedrockGuardrailConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BedrockGuardrailConfiguration"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *BedrockGuardrailConfiguration) SetIdentifier(v string) *BedrockGuardrailConfiguration {
	s.Identifier = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *BedrockGuardrailConfiguration) SetVersion(v string) *BedrockGuardrailConfiguration {
	s.Version = &v
	return s
}

// Contains details about the configuration of a Amazon Bedrock knowledge base.
type BedrockKnowledgeStoreConfiguration struct {
	_ struct{} `type:"structure"`

	// The base ARN of the knowledge base used.
	//
	// BedrockKnowledgeBaseArn is a required field
	BedrockKnowledgeBaseArn *string `locationName:"bedrockKnowledgeBaseArn" min:"1" type:"string" required:"true"`

	// Specifies whether to return an exact response, or to return an answer generated
	// by the model, using the fields you specify from the database.
	ExactResponse *bool `locationName:"exactResponse" type:"boolean"`

	// Contains the names of the fields used for an exact response to the user.
	ExactResponseFields *BedrockKnowledgeStoreExactResponseFields `locationName:"exactResponseFields" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockKnowledgeStoreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockKnowledgeStoreConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BedrockKnowledgeStoreConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BedrockKnowledgeStoreConfiguration"}
	if s.BedrockKnowledgeBaseArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BedrockKnowledgeBaseArn"))
	}
	if s.BedrockKnowledgeBaseArn != nil && len(*s.BedrockKnowledgeBaseArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BedrockKnowledgeBaseArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBedrockKnowledgeBaseArn sets the BedrockKnowledgeBaseArn field's value.
func (s *BedrockKnowledgeStoreConfiguration) SetBedrockKnowledgeBaseArn(v string) *BedrockKnowledgeStoreConfiguration {
	s.BedrockKnowledgeBaseArn = &v
	return s
}

// SetExactResponse sets the ExactResponse field's value.
func (s *BedrockKnowledgeStoreConfiguration) SetExactResponse(v bool) *BedrockKnowledgeStoreConfiguration {
	s.ExactResponse = &v
	return s
}

// SetExactResponseFields sets the ExactResponseFields field's value.
func (s *BedrockKnowledgeStoreConfiguration) SetExactResponseFields(v *BedrockKnowledgeStoreExactResponseFields) *BedrockKnowledgeStoreConfiguration {
	s.ExactResponseFields = v
	return s
}

// The exact response fields given by the Bedrock knowledge store.
type BedrockKnowledgeStoreExactResponseFields struct {
	_ struct{} `type:"structure"`

	// The answer field used for an exact response from Bedrock Knowledge Store.
	AnswerField *string `locationName:"answerField" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockKnowledgeStoreExactResponseFields) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockKnowledgeStoreExactResponseFields) GoString() string {
	return s.String()
}

// SetAnswerField sets the AnswerField field's value.
func (s *BedrockKnowledgeStoreExactResponseFields) SetAnswerField(v string) *BedrockKnowledgeStoreExactResponseFields {
	s.AnswerField = &v
	return s
}

// Contains information about the Amazon Bedrock model used to interpret the
// prompt used in descriptive bot building.
type BedrockModelSpecification struct {
	_ struct{} `type:"structure"`

	// The custom prompt used in the Bedrock model specification details.
	CustomPrompt *string `locationName:"customPrompt" min:"1" type:"string"`

	// The guardrail configuration in the Bedrock model specification details.
	Guardrail *BedrockGuardrailConfiguration `locationName:"guardrail" type:"structure"`

	// The ARN of the foundation model used in descriptive bot building.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" type:"string" required:"true"`

	// The Bedrock trace status in the Bedrock model specification details.
	TraceStatus *string `locationName:"traceStatus" type:"string" enum:"BedrockTraceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockModelSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockModelSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BedrockModelSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BedrockModelSpecification"}
	if s.CustomPrompt != nil && len(*s.CustomPrompt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomPrompt", 1))
	}
	if s.ModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelArn"))
	}
	if s.Guardrail != nil {
		if err := s.Guardrail.Validate(); err != nil {
			invalidParams.AddNested("Guardrail", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomPrompt sets the CustomPrompt field's value.
func (s *BedrockModelSpecification) SetCustomPrompt(v string) *BedrockModelSpecification {
	s.CustomPrompt = &v
	return s
}

// SetGuardrail sets the Guardrail field's value.
func (s *BedrockModelSpecification) SetGuardrail(v *BedrockGuardrailConfiguration) *BedrockModelSpecification {
	s.Guardrail = v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *BedrockModelSpecification) SetModelArn(v string) *BedrockModelSpecification {
	s.ModelArn = &v
	return s
}

// SetTraceStatus sets the TraceStatus field's value.
func (s *BedrockModelSpecification) SetTraceStatus(v string) *BedrockModelSpecification {
	s.TraceStatus = &v
	return s
}

// Provides a record of an event that affects a bot alias. For example, when
// the version of a bot that the alias points to changes.
type BotAliasHistoryEvent struct {
	_ struct{} `type:"structure"`

	// The version of the bot that was used in the event.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The date and time that the event ended.
	EndDate *time.Time `locationName:"endDate" type:"timestamp"`

	// The date and time that the event started.
	StartDate *time.Time `locationName:"startDate" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasHistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasHistoryEvent) GoString() string {
	return s.String()
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotAliasHistoryEvent) SetBotVersion(v string) *BotAliasHistoryEvent {
	s.BotVersion = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *BotAliasHistoryEvent) SetEndDate(v time.Time) *BotAliasHistoryEvent {
	s.EndDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *BotAliasHistoryEvent) SetStartDate(v time.Time) *BotAliasHistoryEvent {
	s.StartDate = &v
	return s
}

// Specifies settings that are unique to a locale. For example, you can use
// different Lambda function depending on the bot's locale.
type BotAliasLocaleSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the Lambda function that should be used in the locale.
	CodeHookSpecification *CodeHookSpecification `locationName:"codeHookSpecification" type:"structure"`

	// Determines whether the locale is enabled for the bot. If the value is false,
	// the locale isn't available for use.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasLocaleSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasLocaleSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotAliasLocaleSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotAliasLocaleSettings"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.CodeHookSpecification != nil {
		if err := s.CodeHookSpecification.Validate(); err != nil {
			invalidParams.AddNested("CodeHookSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeHookSpecification sets the CodeHookSpecification field's value.
func (s *BotAliasLocaleSettings) SetCodeHookSpecification(v *CodeHookSpecification) *BotAliasLocaleSettings {
	s.CodeHookSpecification = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BotAliasLocaleSettings) SetEnabled(v bool) *BotAliasLocaleSettings {
	s.Enabled = &v
	return s
}

// Contains information about all the aliases replication statuses applicable
// for global resiliency.
type BotAliasReplicaSummary struct {
	_ struct{} `type:"structure"`

	// The bot alias ID for all the alias bot replications.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The replication statuses for all the alias bot replications.
	BotAliasReplicationStatus *string `locationName:"botAliasReplicationStatus" type:"string" enum:"BotAliasReplicationStatus"`

	// The bot version for all the alias bot replications.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The creation time and date for all the alias bot replications.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The reasons for failure for the aliases bot replications.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The last time and date updated for all the alias bot replications.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasReplicaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasReplicaSummary) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *BotAliasReplicaSummary) SetBotAliasId(v string) *BotAliasReplicaSummary {
	s.BotAliasId = &v
	return s
}

// SetBotAliasReplicationStatus sets the BotAliasReplicationStatus field's value.
func (s *BotAliasReplicaSummary) SetBotAliasReplicationStatus(v string) *BotAliasReplicaSummary {
	s.BotAliasReplicationStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotAliasReplicaSummary) SetBotVersion(v string) *BotAliasReplicaSummary {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotAliasReplicaSummary) SetCreationDateTime(v time.Time) *BotAliasReplicaSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *BotAliasReplicaSummary) SetFailureReasons(v []*string) *BotAliasReplicaSummary {
	s.FailureReasons = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotAliasReplicaSummary) SetLastUpdatedDateTime(v time.Time) *BotAliasReplicaSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// Summary information about bot aliases returned from the ListBotAliases (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotAliases.html)
// operation.
type BotAliasSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier assigned to the bot alias. You can use this ID to get
	// detailed information about the alias using the DescribeBotAlias (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotAlias.html)
	// operation.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The name of the bot alias.
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string"`

	// The current state of the bot alias. If the status is Available, the alias
	// is ready for use.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The version of the bot that the bot alias references.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the bot alias was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the bot alias.
	Description *string `locationName:"description" type:"string"`

	// A timestamp of the date and time that the bot alias was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasSummary) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *BotAliasSummary) SetBotAliasId(v string) *BotAliasSummary {
	s.BotAliasId = &v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *BotAliasSummary) SetBotAliasName(v string) *BotAliasSummary {
	s.BotAliasName = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *BotAliasSummary) SetBotAliasStatus(v string) *BotAliasSummary {
	s.BotAliasStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotAliasSummary) SetBotVersion(v string) *BotAliasSummary {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotAliasSummary) SetCreationDateTime(v time.Time) *BotAliasSummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotAliasSummary) SetDescription(v string) *BotAliasSummary {
	s.Description = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotAliasSummary) SetLastUpdatedDateTime(v time.Time) *BotAliasSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// The target Amazon S3 location for the test set execution using a bot alias.
type BotAliasTestExecutionTarget struct {
	_ struct{} `type:"structure"`

	// The bot alias Id of the bot alias used in the test set execution.
	//
	// BotAliasId is a required field
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The bot Id of the bot alias used in the test set execution.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The locale Id of the bot alias used in the test set execution.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasTestExecutionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasTestExecutionTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotAliasTestExecutionTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotAliasTestExecutionTarget"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *BotAliasTestExecutionTarget) SetBotAliasId(v string) *BotAliasTestExecutionTarget {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *BotAliasTestExecutionTarget) SetBotId(v string) *BotAliasTestExecutionTarget {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotAliasTestExecutionTarget) SetLocaleId(v string) *BotAliasTestExecutionTarget {
	s.LocaleId = &v
	return s
}

// Provides the identity of a the bot that was exported.
type BotExportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot assigned by Amazon Lex.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that was exported. This will be either DRAFT or the
	// version number.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotExportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotExportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotExportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotExportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BotExportSpecification) SetBotId(v string) *BotExportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotExportSpecification) SetBotVersion(v string) *BotExportSpecification {
	s.BotVersion = &v
	return s
}

// Filters the responses returned by the ListBots operation.
type BotFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to filter the list of bots.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"BotFilterName"`

	// The operator to use for the filter. Specify EQ when the ListBots operation
	// should return only aliases that equal the specified value. Specify CO when
	// the ListBots operation should return aliases that contain the specified value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"BotFilterOperator"`

	// The value to use for filtering the list of bots.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BotFilter) SetName(v string) *BotFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *BotFilter) SetOperator(v string) *BotFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *BotFilter) SetValues(v []*string) *BotFilter {
	s.Values = v
	return s
}

// Provides the bot parameters required for importing a bot.
type BotImportSpecification struct {
	_ struct{} `type:"structure"`

	// The name that Amazon Lex should use for the bot.
	//
	// BotName is a required field
	BotName *string `locationName:"botName" min:"1" type:"string" required:"true"`

	// A list of tags to add to the bot. You can only add tags when you import a
	// bot. You can't use the UpdateBot operation to update tags. To update tags,
	// use the TagResource operation.
	BotTags map[string]*string `locationName:"botTags" type:"map"`

	// By default, data stored by Amazon Lex is encrypted. The DataPrivacy structure
	// provides settings that determine how Amazon Lex handles special cases of
	// securing the data for your bot.
	//
	// DataPrivacy is a required field
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure" required:"true"`

	// The time, in seconds, that Amazon Lex should keep information about a user's
	// conversation with the bot.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Lex
	// deletes any data provided before the timeout.
	//
	// You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role used to build and run the
	// bot.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// A list of tags to add to the test alias for a bot. You can only add tags
	// when you import a bot. You can't use the UpdateAlias operation to update
	// tags. To update tags on the test alias, use the TagResource operation.
	TestBotAliasTags map[string]*string `locationName:"testBotAliasTags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotImportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotImportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotImportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotImportSpecification"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 1))
	}
	if s.DataPrivacy == nil {
		invalidParams.Add(request.NewErrParamRequired("DataPrivacy"))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.DataPrivacy != nil {
		if err := s.DataPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DataPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *BotImportSpecification) SetBotName(v string) *BotImportSpecification {
	s.BotName = &v
	return s
}

// SetBotTags sets the BotTags field's value.
func (s *BotImportSpecification) SetBotTags(v map[string]*string) *BotImportSpecification {
	s.BotTags = v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *BotImportSpecification) SetDataPrivacy(v *DataPrivacy) *BotImportSpecification {
	s.DataPrivacy = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *BotImportSpecification) SetIdleSessionTTLInSeconds(v int64) *BotImportSpecification {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BotImportSpecification) SetRoleArn(v string) *BotImportSpecification {
	s.RoleArn = &v
	return s
}

// SetTestBotAliasTags sets the TestBotAliasTags field's value.
func (s *BotImportSpecification) SetTestBotAliasTags(v map[string]*string) *BotImportSpecification {
	s.TestBotAliasTags = v
	return s
}

// Provides the bot locale parameters required for exporting a bot locale.
type BotLocaleExportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to create the locale for.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to export.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the language and locale to export. The string must match
	// one of the locales in the bot.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleExportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleExportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleExportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleExportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BotLocaleExportSpecification) SetBotId(v string) *BotLocaleExportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotLocaleExportSpecification) SetBotVersion(v string) *BotLocaleExportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotLocaleExportSpecification) SetLocaleId(v string) *BotLocaleExportSpecification {
	s.LocaleId = &v
	return s
}

// Filters responses returned by the ListBotLocales operation.
type BotLocaleFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to filter the list of bots.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"BotLocaleFilterName"`

	// The operator to use for the filter. Specify EQ when the ListBotLocales operation
	// should return only aliases that equal the specified value. Specify CO when
	// the ListBotLocales operation should return aliases that contain the specified
	// value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"BotLocaleFilterOperator"`

	// The value to use for filtering the list of bots.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BotLocaleFilter) SetName(v string) *BotLocaleFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *BotLocaleFilter) SetOperator(v string) *BotLocaleFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *BotLocaleFilter) SetValues(v []*string) *BotLocaleFilter {
	s.Values = v
	return s
}

// Provides information about an event that occurred affecting the bot locale.
type BotLocaleHistoryEvent struct {
	_ struct{} `type:"structure"`

	// A description of the event that occurred.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true"`

	// A timestamp of the date and time that the event occurred.
	//
	// EventDate is a required field
	EventDate *time.Time `locationName:"eventDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleHistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleHistoryEvent) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *BotLocaleHistoryEvent) SetEvent(v string) *BotLocaleHistoryEvent {
	s.Event = &v
	return s
}

// SetEventDate sets the EventDate field's value.
func (s *BotLocaleHistoryEvent) SetEventDate(v time.Time) *BotLocaleHistoryEvent {
	s.EventDate = &v
	return s
}

// Provides the bot locale parameters required for importing a bot locale.
type BotLocaleImportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to import the locale to.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to import the locale to. This can only be the DRAFT
	// version of the bot.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot
	// types, and slots used in the bot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`

	// Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent,
	// AMAZON.KendraSearchIntent, or both when returning alternative intents. AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent are only inserted if they are configured for
	// the bot.
	//
	// For example, suppose a bot is configured with the confidence threshold of
	// 0.80 and the AMAZON.FallbackIntent. Amazon Lex returns three alternative
	// intents with the following confidence scores: IntentA (0.70), IntentB (0.60),
	// IntentC (0.50). The response from the PostText operation would be:
	//
	//    * AMAZON.FallbackIntent
	//
	//    * IntentA
	//
	//    * IntentB
	//
	//    * IntentC
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double"`

	// Defines settings for using an Amazon Polly voice to communicate with a user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleImportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleImportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleImportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleImportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.VoiceSettings != nil {
		if err := s.VoiceSettings.Validate(); err != nil {
			invalidParams.AddNested("VoiceSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BotLocaleImportSpecification) SetBotId(v string) *BotLocaleImportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotLocaleImportSpecification) SetBotVersion(v string) *BotLocaleImportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotLocaleImportSpecification) SetLocaleId(v string) *BotLocaleImportSpecification {
	s.LocaleId = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *BotLocaleImportSpecification) SetNluIntentConfidenceThreshold(v float64) *BotLocaleImportSpecification {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *BotLocaleImportSpecification) SetVoiceSettings(v *VoiceSettings) *BotLocaleImportSpecification {
	s.VoiceSettings = v
	return s
}

// Specifies attributes for sorting a list of bot locales.
type BotLocaleSortBy struct {
	_ struct{} `type:"structure"`

	// The bot locale attribute to sort by.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BotLocaleSortAttribute"`

	// Specifies whether to sort the bot locales in ascending or descending order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BotLocaleSortBy) SetAttribute(v string) *BotLocaleSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BotLocaleSortBy) SetOrder(v string) *BotLocaleSortBy {
	s.Order = &v
	return s
}

// Summary information about bot locales returned by the ListBotLocales (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotLocales.html)
// operation.
type BotLocaleSummary struct {
	_ struct{} `type:"structure"`

	// The current status of the bot locale. When the status is Built the locale
	// is ready for use.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The description of the bot locale.
	Description *string `locationName:"description" type:"string"`

	// A timestamp of the date and time that the bot locale was last built.
	LastBuildSubmittedDateTime *time.Time `locationName:"lastBuildSubmittedDateTime" type:"timestamp"`

	// A timestamp of the date and time that the bot locale was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The language and locale of the bot locale.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The name of the bot locale.
	LocaleName *string `locationName:"localeName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSummary) GoString() string {
	return s.String()
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *BotLocaleSummary) SetBotLocaleStatus(v string) *BotLocaleSummary {
	s.BotLocaleStatus = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotLocaleSummary) SetDescription(v string) *BotLocaleSummary {
	s.Description = &v
	return s
}

// SetLastBuildSubmittedDateTime sets the LastBuildSubmittedDateTime field's value.
func (s *BotLocaleSummary) SetLastBuildSubmittedDateTime(v time.Time) *BotLocaleSummary {
	s.LastBuildSubmittedDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotLocaleSummary) SetLastUpdatedDateTime(v time.Time) *BotLocaleSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotLocaleSummary) SetLocaleId(v string) *BotLocaleSummary {
	s.LocaleId = &v
	return s
}

// SetLocaleName sets the LocaleName field's value.
func (s *BotLocaleSummary) SetLocaleName(v string) *BotLocaleSummary {
	s.LocaleName = &v
	return s
}

// A bot that is a member of a network of bots.
type BotMember struct {
	_ struct{} `type:"structure"`

	// The alias ID of a bot that is a member of this network of bots.
	//
	// BotMemberAliasId is a required field
	BotMemberAliasId *string `locationName:"botMemberAliasId" min:"10" type:"string" required:"true"`

	// The alias name of a bot that is a member of this network of bots.
	//
	// BotMemberAliasName is a required field
	BotMemberAliasName *string `locationName:"botMemberAliasName" min:"1" type:"string" required:"true"`

	// The unique ID of a bot that is a member of this network of bots.
	//
	// BotMemberId is a required field
	BotMemberId *string `locationName:"botMemberId" min:"10" type:"string" required:"true"`

	// The unique name of a bot that is a member of this network of bots.
	//
	// BotMemberName is a required field
	BotMemberName *string `locationName:"botMemberName" min:"1" type:"string" required:"true"`

	// The version of a bot that is a member of this network of bots.
	//
	// BotMemberVersion is a required field
	BotMemberVersion *string `locationName:"botMemberVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotMember) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotMember) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotMember"}
	if s.BotMemberAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberAliasId"))
	}
	if s.BotMemberAliasId != nil && len(*s.BotMemberAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberAliasId", 10))
	}
	if s.BotMemberAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberAliasName"))
	}
	if s.BotMemberAliasName != nil && len(*s.BotMemberAliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberAliasName", 1))
	}
	if s.BotMemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberId"))
	}
	if s.BotMemberId != nil && len(*s.BotMemberId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberId", 10))
	}
	if s.BotMemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberName"))
	}
	if s.BotMemberName != nil && len(*s.BotMemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberName", 1))
	}
	if s.BotMemberVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberVersion"))
	}
	if s.BotMemberVersion != nil && len(*s.BotMemberVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotMemberAliasId sets the BotMemberAliasId field's value.
func (s *BotMember) SetBotMemberAliasId(v string) *BotMember {
	s.BotMemberAliasId = &v
	return s
}

// SetBotMemberAliasName sets the BotMemberAliasName field's value.
func (s *BotMember) SetBotMemberAliasName(v string) *BotMember {
	s.BotMemberAliasName = &v
	return s
}

// SetBotMemberId sets the BotMemberId field's value.
func (s *BotMember) SetBotMemberId(v string) *BotMember {
	s.BotMemberId = &v
	return s
}

// SetBotMemberName sets the BotMemberName field's value.
func (s *BotMember) SetBotMemberName(v string) *BotMember {
	s.BotMemberName = &v
	return s
}

// SetBotMemberVersion sets the BotMemberVersion field's value.
func (s *BotMember) SetBotMemberVersion(v string) *BotMember {
	s.BotMemberVersion = &v
	return s
}

// A statistical summary of the bot recommendation results.
type BotRecommendationResultStatistics struct {
	_ struct{} `type:"structure"`

	// Statistical information about about the intents associated with the bot recommendation
	// results.
	Intents *IntentStatistics `locationName:"intents" type:"structure"`

	// Statistical information about the slot types associated with the bot recommendation
	// results.
	SlotTypes *SlotTypeStatistics `locationName:"slotTypes" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResultStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResultStatistics) GoString() string {
	return s.String()
}

// SetIntents sets the Intents field's value.
func (s *BotRecommendationResultStatistics) SetIntents(v *IntentStatistics) *BotRecommendationResultStatistics {
	s.Intents = v
	return s
}

// SetSlotTypes sets the SlotTypes field's value.
func (s *BotRecommendationResultStatistics) SetSlotTypes(v *SlotTypeStatistics) *BotRecommendationResultStatistics {
	s.SlotTypes = v
	return s
}

// The object representing the URL of the bot definition, the URL of the associated
// transcript, and a statistical summary of the bot recommendation results.
type BotRecommendationResults struct {
	_ struct{} `type:"structure"`

	// The presigned url link of the associated transcript.
	AssociatedTranscriptsUrl *string `locationName:"associatedTranscriptsUrl" min:"1" type:"string"`

	// The presigned URL link of the recommended bot definition.
	BotLocaleExportUrl *string `locationName:"botLocaleExportUrl" min:"1" type:"string"`

	// The statistical summary of the bot recommendation results.
	Statistics *BotRecommendationResultStatistics `locationName:"statistics" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResults) GoString() string {
	return s.String()
}

// SetAssociatedTranscriptsUrl sets the AssociatedTranscriptsUrl field's value.
func (s *BotRecommendationResults) SetAssociatedTranscriptsUrl(v string) *BotRecommendationResults {
	s.AssociatedTranscriptsUrl = &v
	return s
}

// SetBotLocaleExportUrl sets the BotLocaleExportUrl field's value.
func (s *BotRecommendationResults) SetBotLocaleExportUrl(v string) *BotRecommendationResults {
	s.BotLocaleExportUrl = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *BotRecommendationResults) SetStatistics(v *BotRecommendationResultStatistics) *BotRecommendationResults {
	s.Statistics = v
	return s
}

// A summary of the bot recommendation.
type BotRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot recommendation to be updated.
	//
	// BotRecommendationId is a required field
	BotRecommendationId *string `locationName:"botRecommendationId" min:"10" type:"string" required:"true"`

	// The status of the bot recommendation.
	//
	// If the status is Failed, then the reasons for the failure are listed in the
	// failureReasons field.
	//
	// BotRecommendationStatus is a required field
	BotRecommendationStatus *string `locationName:"botRecommendationStatus" type:"string" required:"true" enum:"BotRecommendationStatus"`

	// A timestamp of the date and time that the bot recommendation was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// A timestamp of the date and time that the bot recommendation was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationSummary) GoString() string {
	return s.String()
}

// SetBotRecommendationId sets the BotRecommendationId field's value.
func (s *BotRecommendationSummary) SetBotRecommendationId(v string) *BotRecommendationSummary {
	s.BotRecommendationId = &v
	return s
}

// SetBotRecommendationStatus sets the BotRecommendationStatus field's value.
func (s *BotRecommendationSummary) SetBotRecommendationStatus(v string) *BotRecommendationSummary {
	s.BotRecommendationStatus = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotRecommendationSummary) SetCreationDateTime(v time.Time) *BotRecommendationSummary {
	s.CreationDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotRecommendationSummary) SetLastUpdatedDateTime(v time.Time) *BotRecommendationSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// Contains summary information about all the replication statuses applicable
// for global resiliency.
type BotReplicaSummary struct {
	_ struct{} `type:"structure"`

	// The operation status for the replicated bot applicable.
	BotReplicaStatus *string `locationName:"botReplicaStatus" type:"string" enum:"BotReplicaStatus"`

	// The creation time and date for the replicated bots.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The reasons for the failure for the replicated bot.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The replica region used in the replication statuses summary.
	ReplicaRegion *string `locationName:"replicaRegion" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotReplicaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotReplicaSummary) GoString() string {
	return s.String()
}

// SetBotReplicaStatus sets the BotReplicaStatus field's value.
func (s *BotReplicaSummary) SetBotReplicaStatus(v string) *BotReplicaSummary {
	s.BotReplicaStatus = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotReplicaSummary) SetCreationDateTime(v time.Time) *BotReplicaSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *BotReplicaSummary) SetFailureReasons(v []*string) *BotReplicaSummary {
	s.FailureReasons = v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *BotReplicaSummary) SetReplicaRegion(v string) *BotReplicaSummary {
	s.ReplicaRegion = &v
	return s
}

// Specifies attributes for sorting a list of bots.
type BotSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of bots.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BotSortAttribute"`

	// The order to sort the list. You can choose ascending or descending.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BotSortBy) SetAttribute(v string) *BotSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BotSortBy) SetOrder(v string) *BotSortBy {
	s.Order = &v
	return s
}

// Summary information about a bot returned by the ListBots (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBots.html)
// operation.
type BotSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier assigned to the bot. Use this ID to get detailed information
	// about the bot with the DescribeBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBot.html)
	// operation.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The name of the bot.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The current status of the bot. When the status is Available the bot is ready
	// for use.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The type of the bot.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// The description of the bot.
	Description *string `locationName:"description" type:"string"`

	// The date and time that the bot was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The latest numerical version in use for the bot.
	LatestBotVersion *string `locationName:"latestBotVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSummary) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BotSummary) SetBotId(v string) *BotSummary {
	s.BotId = &v
	return s
}

// SetBotName sets the BotName field's value.
func (s *BotSummary) SetBotName(v string) *BotSummary {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *BotSummary) SetBotStatus(v string) *BotSummary {
	s.BotStatus = &v
	return s
}

// SetBotType sets the BotType field's value.
func (s *BotSummary) SetBotType(v string) *BotSummary {
	s.BotType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotSummary) SetDescription(v string) *BotSummary {
	s.Description = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotSummary) SetLastUpdatedDateTime(v time.Time) *BotSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestBotVersion sets the LatestBotVersion field's value.
func (s *BotSummary) SetLatestBotVersion(v string) *BotSummary {
	s.LatestBotVersion = &v
	return s
}

// The version of a bot used for a bot locale.
type BotVersionLocaleDetails struct {
	_ struct{} `type:"structure"`

	// The version of a bot used for a bot locale.
	//
	// SourceBotVersion is a required field
	SourceBotVersion *string `locationName:"sourceBotVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionLocaleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionLocaleDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotVersionLocaleDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotVersionLocaleDetails"}
	if s.SourceBotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceBotVersion"))
	}
	if s.SourceBotVersion != nil && len(*s.SourceBotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceBotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceBotVersion sets the SourceBotVersion field's value.
func (s *BotVersionLocaleDetails) SetSourceBotVersion(v string) *BotVersionLocaleDetails {
	s.SourceBotVersion = &v
	return s
}

// The sort category for the version replicated bots.
type BotVersionReplicaSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute of the sort category for the version replicated bots.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BotVersionReplicaSortAttribute"`

	// The order of the sort category for the version replicated bots.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionReplicaSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionReplicaSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotVersionReplicaSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotVersionReplicaSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BotVersionReplicaSortBy) SetAttribute(v string) *BotVersionReplicaSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BotVersionReplicaSortBy) SetOrder(v string) *BotVersionReplicaSortBy {
	s.Order = &v
	return s
}

// Contains summary information for all the version replication statuses applicable
// for Global resiliency.
type BotVersionReplicaSummary struct {
	_ struct{} `type:"structure"`

	// The bot version for the summary information for all the version replication
	// statuses.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The version replication status for all the replicated bots.
	BotVersionReplicationStatus *string `locationName:"botVersionReplicationStatus" type:"string" enum:"BotVersionReplicationStatus"`

	// The creation date and time of the replication status for all the replicated
	// bots.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The reasons for replication failure for all the replicated bots.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionReplicaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionReplicaSummary) GoString() string {
	return s.String()
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotVersionReplicaSummary) SetBotVersion(v string) *BotVersionReplicaSummary {
	s.BotVersion = &v
	return s
}

// SetBotVersionReplicationStatus sets the BotVersionReplicationStatus field's value.
func (s *BotVersionReplicaSummary) SetBotVersionReplicationStatus(v string) *BotVersionReplicaSummary {
	s.BotVersionReplicationStatus = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotVersionReplicaSummary) SetCreationDateTime(v time.Time) *BotVersionReplicaSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *BotVersionReplicaSummary) SetFailureReasons(v []*string) *BotVersionReplicaSummary {
	s.FailureReasons = v
	return s
}

// Specifies attributes for sorting a list of bot versions.
type BotVersionSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of versions.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BotVersionSortAttribute"`

	// The order to sort the list. You can specify ascending or descending order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotVersionSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotVersionSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BotVersionSortBy) SetAttribute(v string) *BotVersionSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BotVersionSortBy) SetOrder(v string) *BotVersionSortBy {
	s.Order = &v
	return s
}

// Summary information about a bot version returned by the ListBotVersions (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotVersions.html)
// operation.
type BotVersionSummary struct {
	_ struct{} `type:"structure"`

	// The name of the bot associated with the version.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The status of the bot. When the status is available, the version of the bot
	// is ready for use.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The numeric version of the bot, or DRAFT to indicate that this is the version
	// of the bot that can be updated..
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the version was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the version.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSummary) GoString() string {
	return s.String()
}

// SetBotName sets the BotName field's value.
func (s *BotVersionSummary) SetBotName(v string) *BotVersionSummary {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *BotVersionSummary) SetBotStatus(v string) *BotVersionSummary {
	s.BotStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotVersionSummary) SetBotVersion(v string) *BotVersionSummary {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotVersionSummary) SetCreationDateTime(v time.Time) *BotVersionSummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotVersionSummary) SetDescription(v string) *BotVersionSummary {
	s.Description = &v
	return s
}

type BuildBotLocaleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot to build. The identifier is returned in the response
	// from the CreateBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html)
	// operation.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to build. This can only be the draft version of the
	// bot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot
	// types, and slots used in the bot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuildBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuildBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BuildBotLocaleInput) SetBotId(v string) *BuildBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BuildBotLocaleInput) SetBotVersion(v string) *BuildBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BuildBotLocaleInput) SetLocaleId(v string) *BuildBotLocaleInput {
	s.LocaleId = &v
	return s
}

type BuildBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the specified bot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The bot's build status. When the status is ReadyExpressTesting you can test
	// the bot using the utterances defined for the intents and slot types. When
	// the status is Built, the bot is ready for use and can be tested using any
	// utterance.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The version of the bot that was built. This is only the draft version of
	// the bot.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp indicating the date and time that the bot was last built for
	// this locale.
	LastBuildSubmittedDateTime *time.Time `locationName:"lastBuildSubmittedDateTime" type:"timestamp"`

	// The language and locale specified of where the bot can be used.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BuildBotLocaleOutput) SetBotId(v string) *BuildBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *BuildBotLocaleOutput) SetBotLocaleStatus(v string) *BuildBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BuildBotLocaleOutput) SetBotVersion(v string) *BuildBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetLastBuildSubmittedDateTime sets the LastBuildSubmittedDateTime field's value.
func (s *BuildBotLocaleOutput) SetLastBuildSubmittedDateTime(v time.Time) *BuildBotLocaleOutput {
	s.LastBuildSubmittedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BuildBotLocaleOutput) SetLocaleId(v string) *BuildBotLocaleOutput {
	s.LocaleId = &v
	return s
}

// Contains specifications about the Amazon Lex build time generative AI capabilities
// from Amazon Bedrock that you can turn on for your bot.
type BuildtimeSettings struct {
	_ struct{} `type:"structure"`

	// An object containing specifications for the descriptive bot building feature.
	DescriptiveBotBuilder *DescriptiveBotBuilderSpecification `locationName:"descriptiveBotBuilder" type:"structure"`

	// Contains specifications for the sample utterance generation feature.
	SampleUtteranceGeneration *SampleUtteranceGenerationSpecification `locationName:"sampleUtteranceGeneration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildtimeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildtimeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuildtimeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuildtimeSettings"}
	if s.DescriptiveBotBuilder != nil {
		if err := s.DescriptiveBotBuilder.Validate(); err != nil {
			invalidParams.AddNested("DescriptiveBotBuilder", err.(request.ErrInvalidParams))
		}
	}
	if s.SampleUtteranceGeneration != nil {
		if err := s.SampleUtteranceGeneration.Validate(); err != nil {
			invalidParams.AddNested("SampleUtteranceGeneration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescriptiveBotBuilder sets the DescriptiveBotBuilder field's value.
func (s *BuildtimeSettings) SetDescriptiveBotBuilder(v *DescriptiveBotBuilderSpecification) *BuildtimeSettings {
	s.DescriptiveBotBuilder = v
	return s
}

// SetSampleUtteranceGeneration sets the SampleUtteranceGeneration field's value.
func (s *BuildtimeSettings) SetSampleUtteranceGeneration(v *SampleUtteranceGenerationSpecification) *BuildtimeSettings {
	s.SampleUtteranceGeneration = v
	return s
}

// Specifies attributes for sorting a list of built-in intents.
type BuiltInIntentSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of built-in intents.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BuiltInIntentSortAttribute"`

	// The order to sort the list. You can specify ascending or descending order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuiltInIntentSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuiltInIntentSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BuiltInIntentSortBy) SetAttribute(v string) *BuiltInIntentSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BuiltInIntentSortBy) SetOrder(v string) *BuiltInIntentSortBy {
	s.Order = &v
	return s
}

// Provides summary information about a built-in intent for the ListBuiltInIntents
// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInIntents.html)
// operation.
type BuiltInIntentSummary struct {
	_ struct{} `type:"structure"`

	// The description of the intent.
	Description *string `locationName:"description" type:"string"`

	// The signature of the built-in intent. Use this to specify the parent intent
	// of a derived intent.
	IntentSignature *string `locationName:"intentSignature" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *BuiltInIntentSummary) SetDescription(v string) *BuiltInIntentSummary {
	s.Description = &v
	return s
}

// SetIntentSignature sets the IntentSignature field's value.
func (s *BuiltInIntentSummary) SetIntentSignature(v string) *BuiltInIntentSummary {
	s.IntentSignature = &v
	return s
}

// Specifies attributes for sorting a list of built-in slot types.
type BuiltInSlotTypeSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of built-in intents.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BuiltInSlotTypeSortAttribute"`

	// The order to sort the list. You can choose ascending or descending.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuiltInSlotTypeSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuiltInSlotTypeSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BuiltInSlotTypeSortBy) SetAttribute(v string) *BuiltInSlotTypeSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BuiltInSlotTypeSortBy) SetOrder(v string) *BuiltInSlotTypeSortBy {
	s.Order = &v
	return s
}

// Provides summary information about a built-in slot type for the ListBuiltInSlotTypes
// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInSlotTypes.html)
// operation.
type BuiltInSlotTypeSummary struct {
	_ struct{} `type:"structure"`

	// The description of the built-in slot type.
	Description *string `locationName:"description" type:"string"`

	// The signature of the built-in slot type. Use this to specify the parent slot
	// type of a derived slot type.
	SlotTypeSignature *string `locationName:"slotTypeSignature" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *BuiltInSlotTypeSummary) SetDescription(v string) *BuiltInSlotTypeSummary {
	s.Description = &v
	return s
}

// SetSlotTypeSignature sets the SlotTypeSignature field's value.
func (s *BuiltInSlotTypeSummary) SetSlotTypeSignature(v string) *BuiltInSlotTypeSummary {
	s.SlotTypeSignature = &v
	return s
}

// Describes a button to use on a response card used to gather slot values from
// a user.
type Button struct {
	_ struct{} `type:"structure"`

	// The text that appears on the button. Use this to tell the user what value
	// is returned when they choose this button.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true"`

	// The value returned to Amazon Lex when the user chooses this button. This
	// must be one of the slot values configured for the slot.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Button) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Button) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Button) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Button"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *Button) SetText(v string) *Button {
	s.Text = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Button) SetValue(v string) *Button {
	s.Value = &v
	return s
}

// The Amazon CloudWatch Logs log group where the text and metadata logs are
// delivered. The log group must exist before you enable logging.
type CloudWatchLogGroupLogDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the log group where text and metadata logs
	// are delivered.
	//
	// CloudWatchLogGroupArn is a required field
	CloudWatchLogGroupArn *string `locationName:"cloudWatchLogGroupArn" min:"1" type:"string" required:"true"`

	// The prefix of the log stream name within the log group that you specified
	//
	// LogPrefix is a required field
	LogPrefix *string `locationName:"logPrefix" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogGroupLogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogGroupLogDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogGroupLogDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogGroupLogDestination"}
	if s.CloudWatchLogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogGroupArn"))
	}
	if s.CloudWatchLogGroupArn != nil && len(*s.CloudWatchLogGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogGroupArn", 1))
	}
	if s.LogPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("LogPrefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *CloudWatchLogGroupLogDestination) SetCloudWatchLogGroupArn(v string) *CloudWatchLogGroupLogDestination {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetLogPrefix sets the LogPrefix field's value.
func (s *CloudWatchLogGroupLogDestination) SetLogPrefix(v string) *CloudWatchLogGroupLogDestination {
	s.LogPrefix = &v
	return s
}

// Contains information about code hooks that Amazon Lex calls during a conversation.
type CodeHookSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies a Lambda function that verifies requests to a bot or fulfills the
	// user's request to a bot.
	//
	// LambdaCodeHook is a required field
	LambdaCodeHook *LambdaCodeHook `locationName:"lambdaCodeHook" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeHookSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeHookSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeHookSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeHookSpecification"}
	if s.LambdaCodeHook == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaCodeHook"))
	}
	if s.LambdaCodeHook != nil {
		if err := s.LambdaCodeHook.Validate(); err != nil {
			invalidParams.AddNested("LambdaCodeHook", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaCodeHook sets the LambdaCodeHook field's value.
func (s *CodeHookSpecification) SetLambdaCodeHook(v *LambdaCodeHook) *CodeHookSpecification {
	s.LambdaCodeHook = v
	return s
}

// A composite slot is a combination of two or more slots that capture multiple
// pieces of information in a single user input.
type CompositeSlotTypeSetting struct {
	_ struct{} `type:"structure"`

	// Subslots in the composite slot.
	SubSlots []*SubSlotTypeComposition `locationName:"subSlots" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeSlotTypeSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeSlotTypeSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompositeSlotTypeSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompositeSlotTypeSetting"}
	if s.SubSlots != nil {
		for i, v := range s.SubSlots {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubSlots", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubSlots sets the SubSlots field's value.
func (s *CompositeSlotTypeSetting) SetSubSlots(v []*SubSlotTypeComposition) *CompositeSlotTypeSetting {
	s.SubSlots = v
	return s
}

// Provides an expression that evaluates to true or false.
type Condition struct {
	_ struct{} `type:"structure"`

	// The expression string that is evaluated.
	//
	// ExpressionString is a required field
	ExpressionString *string `locationName:"expressionString" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.ExpressionString == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpressionString"))
	}
	if s.ExpressionString != nil && len(*s.ExpressionString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpressionString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpressionString sets the ExpressionString field's value.
func (s *Condition) SetExpressionString(v string) *Condition {
	s.ExpressionString = &v
	return s
}

// A set of actions that Amazon Lex should run if the condition is matched.
type ConditionalBranch struct {
	_ struct{} `type:"structure"`

	// Contains the expression to evaluate. If the condition is true, the branch's
	// actions are taken.
	//
	// Condition is a required field
	Condition *Condition `locationName:"condition" type:"structure" required:"true"`

	// The name of the branch.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next step in the conversation.
	//
	// NextStep is a required field
	NextStep *DialogState `locationName:"nextStep" type:"structure" required:"true"`

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	Response *ResponseSpecification `locationName:"response" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalBranch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalBranch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalBranch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalBranch"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextStep == nil {
		invalidParams.Add(request.NewErrParamRequired("NextStep"))
	}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}
	if s.NextStep != nil {
		if err := s.NextStep.Validate(); err != nil {
			invalidParams.AddNested("NextStep", err.(request.ErrInvalidParams))
		}
	}
	if s.Response != nil {
		if err := s.Response.Validate(); err != nil {
			invalidParams.AddNested("Response", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ConditionalBranch) SetCondition(v *Condition) *ConditionalBranch {
	s.Condition = v
	return s
}

// SetName sets the Name field's value.
func (s *ConditionalBranch) SetName(v string) *ConditionalBranch {
	s.Name = &v
	return s
}

// SetNextStep sets the NextStep field's value.
func (s *ConditionalBranch) SetNextStep(v *DialogState) *ConditionalBranch {
	s.NextStep = v
	return s
}

// SetResponse sets the Response field's value.
func (s *ConditionalBranch) SetResponse(v *ResponseSpecification) *ConditionalBranch {
	s.Response = v
	return s
}

// Provides a list of conditional branches. Branches are evaluated in the order
// that they are entered in the list. The first branch with a condition that
// evaluates to true is executed. The last branch in the list is the default
// branch. The default branch should not have any condition expression. The
// default branch is executed if no other branch has a matching condition.
type ConditionalSpecification struct {
	_ struct{} `type:"structure"`

	// Determines whether a conditional branch is active. When active is false,
	// the conditions are not evaluated.
	//
	// Active is a required field
	Active *bool `locationName:"active" type:"boolean" required:"true"`

	// A list of conditional branches. A conditional branch is made up of a condition,
	// a response and a next step. The response and next step are executed when
	// the condition is true.
	//
	// ConditionalBranches is a required field
	ConditionalBranches []*ConditionalBranch `locationName:"conditionalBranches" min:"1" type:"list" required:"true"`

	// The conditional branch that should be followed when the conditions for other
	// branches are not satisfied. A conditional branch is made up of a condition,
	// a response and a next step.
	//
	// DefaultBranch is a required field
	DefaultBranch *DefaultConditionalBranch `locationName:"defaultBranch" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalSpecification"}
	if s.Active == nil {
		invalidParams.Add(request.NewErrParamRequired("Active"))
	}
	if s.ConditionalBranches == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionalBranches"))
	}
	if s.ConditionalBranches != nil && len(s.ConditionalBranches) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionalBranches", 1))
	}
	if s.DefaultBranch == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultBranch"))
	}
	if s.ConditionalBranches != nil {
		for i, v := range s.ConditionalBranches {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConditionalBranches", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DefaultBranch != nil {
		if err := s.DefaultBranch.Validate(); err != nil {
			invalidParams.AddNested("DefaultBranch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *ConditionalSpecification) SetActive(v bool) *ConditionalSpecification {
	s.Active = &v
	return s
}

// SetConditionalBranches sets the ConditionalBranches field's value.
func (s *ConditionalSpecification) SetConditionalBranches(v []*ConditionalBranch) *ConditionalSpecification {
	s.ConditionalBranches = v
	return s
}

// SetDefaultBranch sets the DefaultBranch field's value.
func (s *ConditionalSpecification) SetDefaultBranch(v *DefaultConditionalBranch) *ConditionalSpecification {
	s.DefaultBranch = v
	return s
}

// The action that you tried to perform couldn't be completed because the resource
// is in a conflicting state. For example, deleting a bot that is in the CREATING
// state. Try your request again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The item listing the evaluation of intent level success or failure.
type ConversationLevelIntentClassificationResultItem struct {
	_ struct{} `type:"structure"`

	// The intent name used in the evaluation of intent level success or failure.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// The number of times the specific intent is used in the evaluation of intent
	// level success or failure.
	//
	// MatchResult is a required field
	MatchResult *string `locationName:"matchResult" type:"string" required:"true" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelIntentClassificationResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelIntentClassificationResultItem) GoString() string {
	return s.String()
}

// SetIntentName sets the IntentName field's value.
func (s *ConversationLevelIntentClassificationResultItem) SetIntentName(v string) *ConversationLevelIntentClassificationResultItem {
	s.IntentName = &v
	return s
}

// SetMatchResult sets the MatchResult field's value.
func (s *ConversationLevelIntentClassificationResultItem) SetMatchResult(v string) *ConversationLevelIntentClassificationResultItem {
	s.MatchResult = &v
	return s
}

// The conversation level details of the conversation used in the test set.
type ConversationLevelResultDetail struct {
	_ struct{} `type:"structure"`

	// The success or failure of the streaming of the conversation.
	//
	// EndToEndResult is a required field
	EndToEndResult *string `locationName:"endToEndResult" type:"string" required:"true" enum:"TestResultMatchStatus"`

	// The speech transcription success or failure details of the conversation.
	SpeechTranscriptionResult *string `locationName:"speechTranscriptionResult" type:"string" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelResultDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelResultDetail) GoString() string {
	return s.String()
}

// SetEndToEndResult sets the EndToEndResult field's value.
func (s *ConversationLevelResultDetail) SetEndToEndResult(v string) *ConversationLevelResultDetail {
	s.EndToEndResult = &v
	return s
}

// SetSpeechTranscriptionResult sets the SpeechTranscriptionResult field's value.
func (s *ConversationLevelResultDetail) SetSpeechTranscriptionResult(v string) *ConversationLevelResultDetail {
	s.SpeechTranscriptionResult = &v
	return s
}

// The slots used for the slot resolution in the conversation.
type ConversationLevelSlotResolutionResultItem struct {
	_ struct{} `type:"structure"`

	// The intents used in the slots list for the slot resolution details.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// The number of matching slots used in the slots listings for the slot resolution
	// evaluation.
	//
	// MatchResult is a required field
	MatchResult *string `locationName:"matchResult" type:"string" required:"true" enum:"TestResultMatchStatus"`

	// The slot name in the slots list for the slot resolution details.
	//
	// SlotName is a required field
	SlotName *string `locationName:"slotName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelSlotResolutionResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelSlotResolutionResultItem) GoString() string {
	return s.String()
}

// SetIntentName sets the IntentName field's value.
func (s *ConversationLevelSlotResolutionResultItem) SetIntentName(v string) *ConversationLevelSlotResolutionResultItem {
	s.IntentName = &v
	return s
}

// SetMatchResult sets the MatchResult field's value.
func (s *ConversationLevelSlotResolutionResultItem) SetMatchResult(v string) *ConversationLevelSlotResolutionResultItem {
	s.MatchResult = &v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *ConversationLevelSlotResolutionResultItem) SetSlotName(v string) *ConversationLevelSlotResolutionResultItem {
	s.SlotName = &v
	return s
}

// The test result evaluation item at the conversation level.
type ConversationLevelTestResultItem struct {
	_ struct{} `type:"structure"`

	// The conversation Id of the test result evaluation item.
	//
	// ConversationId is a required field
	ConversationId *string `locationName:"conversationId" min:"1" type:"string" required:"true"`

	// The end-to-end success or failure of the test result evaluation item.
	//
	// EndToEndResult is a required field
	EndToEndResult *string `locationName:"endToEndResult" type:"string" required:"true" enum:"TestResultMatchStatus"`

	// The intent classification of the test result evaluation item.
	//
	// IntentClassificationResults is a required field
	IntentClassificationResults []*ConversationLevelIntentClassificationResultItem `locationName:"intentClassificationResults" type:"list" required:"true"`

	// The slot success or failure of the test result evaluation item.
	//
	// SlotResolutionResults is a required field
	SlotResolutionResults []*ConversationLevelSlotResolutionResultItem `locationName:"slotResolutionResults" type:"list" required:"true"`

	// The speech transcription success or failure of the test result evaluation
	// item.
	SpeechTranscriptionResult *string `locationName:"speechTranscriptionResult" type:"string" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultItem) GoString() string {
	return s.String()
}

// SetConversationId sets the ConversationId field's value.
func (s *ConversationLevelTestResultItem) SetConversationId(v string) *ConversationLevelTestResultItem {
	s.ConversationId = &v
	return s
}

// SetEndToEndResult sets the EndToEndResult field's value.
func (s *ConversationLevelTestResultItem) SetEndToEndResult(v string) *ConversationLevelTestResultItem {
	s.EndToEndResult = &v
	return s
}

// SetIntentClassificationResults sets the IntentClassificationResults field's value.
func (s *ConversationLevelTestResultItem) SetIntentClassificationResults(v []*ConversationLevelIntentClassificationResultItem) *ConversationLevelTestResultItem {
	s.IntentClassificationResults = v
	return s
}

// SetSlotResolutionResults sets the SlotResolutionResults field's value.
func (s *ConversationLevelTestResultItem) SetSlotResolutionResults(v []*ConversationLevelSlotResolutionResultItem) *ConversationLevelTestResultItem {
	s.SlotResolutionResults = v
	return s
}

// SetSpeechTranscriptionResult sets the SpeechTranscriptionResult field's value.
func (s *ConversationLevelTestResultItem) SetSpeechTranscriptionResult(v string) *ConversationLevelTestResultItem {
	s.SpeechTranscriptionResult = &v
	return s
}

// The test set results data at the conversation level.
type ConversationLevelTestResults struct {
	_ struct{} `type:"structure"`

	// The item list in the test set results data at the conversation level.
	//
	// Items is a required field
	Items []*ConversationLevelTestResultItem `locationName:"items" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResults) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ConversationLevelTestResults) SetItems(v []*ConversationLevelTestResultItem) *ConversationLevelTestResults {
	s.Items = v
	return s
}

// The selection to filter the test set results data at the conversation level.
type ConversationLevelTestResultsFilterBy struct {
	_ struct{} `type:"structure"`

	// The selection of matched or mismatched end-to-end status to filter test set
	// results data at the conversation level.
	EndToEndResult *string `locationName:"endToEndResult" type:"string" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultsFilterBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultsFilterBy) GoString() string {
	return s.String()
}

// SetEndToEndResult sets the EndToEndResult field's value.
func (s *ConversationLevelTestResultsFilterBy) SetEndToEndResult(v string) *ConversationLevelTestResultsFilterBy {
	s.EndToEndResult = &v
	return s
}

// Configures conversation logging that saves audio, text, and metadata for
// the conversations with your users.
type ConversationLogSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 settings for logging audio to an S3 bucket.
	AudioLogSettings []*AudioLogSetting `locationName:"audioLogSettings" min:"1" type:"list"`

	// The Amazon CloudWatch Logs settings for logging text and metadata.
	TextLogSettings []*TextLogSetting `locationName:"textLogSettings" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationLogSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationLogSettings"}
	if s.AudioLogSettings != nil && len(s.AudioLogSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AudioLogSettings", 1))
	}
	if s.TextLogSettings != nil && len(s.TextLogSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextLogSettings", 1))
	}
	if s.AudioLogSettings != nil {
		for i, v := range s.AudioLogSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioLogSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TextLogSettings != nil {
		for i, v := range s.TextLogSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextLogSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioLogSettings sets the AudioLogSettings field's value.
func (s *ConversationLogSettings) SetAudioLogSettings(v []*AudioLogSetting) *ConversationLogSettings {
	s.AudioLogSettings = v
	return s
}

// SetTextLogSettings sets the TextLogSettings field's value.
func (s *ConversationLogSettings) SetTextLogSettings(v []*TextLogSetting) *ConversationLogSettings {
	s.TextLogSettings = v
	return s
}

// The data source that uses conversation logs.
type ConversationLogsDataSource struct {
	_ struct{} `type:"structure"`

	// The bot alias Id from the conversation logs.
	//
	// BotAliasId is a required field
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The bot Id from the conversation logs.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The filter for the data source of the conversation log.
	//
	// Filter is a required field
	Filter *ConversationLogsDataSourceFilterBy `locationName:"filter" type:"structure" required:"true"`

	// The locale Id of the conversation log.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationLogsDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationLogsDataSource"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *ConversationLogsDataSource) SetBotAliasId(v string) *ConversationLogsDataSource {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *ConversationLogsDataSource) SetBotId(v string) *ConversationLogsDataSource {
	s.BotId = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ConversationLogsDataSource) SetFilter(v *ConversationLogsDataSourceFilterBy) *ConversationLogsDataSource {
	s.Filter = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ConversationLogsDataSource) SetLocaleId(v string) *ConversationLogsDataSource {
	s.LocaleId = &v
	return s
}

// The selected data source to filter the conversation log.
type ConversationLogsDataSourceFilterBy struct {
	_ struct{} `type:"structure"`

	// The end time for the conversation log.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The selection to filter by input mode for the conversation logs.
	//
	// InputMode is a required field
	InputMode *string `locationName:"inputMode" type:"string" required:"true" enum:"ConversationLogsInputModeFilter"`

	// The start time for the conversation log.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSourceFilterBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSourceFilterBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationLogsDataSourceFilterBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationLogsDataSourceFilterBy"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.InputMode == nil {
		invalidParams.Add(request.NewErrParamRequired("InputMode"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ConversationLogsDataSourceFilterBy) SetEndTime(v time.Time) *ConversationLogsDataSourceFilterBy {
	s.EndTime = &v
	return s
}

// SetInputMode sets the InputMode field's value.
func (s *ConversationLogsDataSourceFilterBy) SetInputMode(v string) *ConversationLogsDataSourceFilterBy {
	s.InputMode = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ConversationLogsDataSourceFilterBy) SetStartTime(v time.Time) *ConversationLogsDataSourceFilterBy {
	s.StartTime = &v
	return s
}

type CreateBotAliasInput struct {
	_ struct{} `type:"structure"`

	// Maps configuration information to a specific locale. You can use this parameter
	// to specify a specific Lambda function to run different functions in different
	// locales.
	BotAliasLocaleSettings map[string]*BotAliasLocaleSettings `locationName:"botAliasLocaleSettings" min:"1" type:"map"`

	// The alias to create. The name must be unique for the bot.
	//
	// BotAliasName is a required field
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string" required:"true"`

	// The unique identifier of the bot that the alias applies to.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that this alias points to. You can use the UpdateBotAlias
	// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html)
	// operation to change the bot version associated with the alias.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Specifies whether Amazon Lex logs text and audio for a conversation with
	// the bot. When you enable conversation logs, text logs store text input, transcripts
	// of audio input, and associated metadata in Amazon CloudWatch Logs. Audio
	// logs store audio input in Amazon S3.
	ConversationLogSettings *ConversationLogSettings `locationName:"conversationLogSettings" type:"structure"`

	// A description of the alias. Use this description to help identify the alias.
	Description *string `locationName:"description" type:"string"`

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment
	// of user utterances.
	SentimentAnalysisSettings *SentimentAnalysisSettings `locationName:"sentimentAnalysisSettings" type:"structure"`

	// A list of tags to add to the bot alias. You can only add tags when you create
	// an alias, you can't use the UpdateBotAlias operation to update the tags on
	// a bot alias. To update tags, use the TagResource operation.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotAliasInput"}
	if s.BotAliasLocaleSettings != nil && len(s.BotAliasLocaleSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasLocaleSettings", 1))
	}
	if s.BotAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasName"))
	}
	if s.BotAliasName != nil && len(*s.BotAliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasName", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.BotAliasLocaleSettings != nil {
		for i, v := range s.BotAliasLocaleSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BotAliasLocaleSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ConversationLogSettings != nil {
		if err := s.ConversationLogSettings.Validate(); err != nil {
			invalidParams.AddNested("ConversationLogSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.SentimentAnalysisSettings != nil {
		if err := s.SentimentAnalysisSettings.Validate(); err != nil {
			invalidParams.AddNested("SentimentAnalysisSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasLocaleSettings sets the BotAliasLocaleSettings field's value.
func (s *CreateBotAliasInput) SetBotAliasLocaleSettings(v map[string]*BotAliasLocaleSettings) *CreateBotAliasInput {
	s.BotAliasLocaleSettings = v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *CreateBotAliasInput) SetBotAliasName(v string) *CreateBotAliasInput {
	s.BotAliasName = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *CreateBotAliasInput) SetBotId(v string) *CreateBotAliasInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotAliasInput) SetBotVersion(v string) *CreateBotAliasInput {
	s.BotVersion = &v
	return s
}

// SetConversationLogSettings sets the ConversationLogSettings field's value.
func (s *CreateBotAliasInput) SetConversationLogSettings(v *ConversationLogSettings) *CreateBotAliasInput {
	s.ConversationLogSettings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotAliasInput) SetDescription(v string) *CreateBotAliasInput {
	s.Description = &v
	return s
}

// SetSentimentAnalysisSettings sets the SentimentAnalysisSettings field's value.
func (s *CreateBotAliasInput) SetSentimentAnalysisSettings(v *SentimentAnalysisSettings) *CreateBotAliasInput {
	s.SentimentAnalysisSettings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBotAliasInput) SetTags(v map[string]*string) *CreateBotAliasInput {
	s.Tags = v
	return s
}

type CreateBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot alias.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// Configuration information for a specific locale.
	BotAliasLocaleSettings map[string]*BotAliasLocaleSettings `locationName:"botAliasLocaleSettings" min:"1" type:"map"`

	// The name specified for the bot alias.
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string"`

	// The current status of the alias. The alias is first put into the Creating
	// state. When the alias is ready to be used, it is put into the Available state.
	// You can use the DescribeBotAlias operation to get the current state of an
	// alias.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The unique identifier of the bot that this alias applies to.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with this alias.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The conversation log settings specified for the alias.
	ConversationLogSettings *ConversationLogSettings `locationName:"conversationLogSettings" type:"structure"`

	// A Unix timestamp indicating the date and time that the bot alias was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the bot alias.
	Description *string `locationName:"description" type:"string"`

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment
	// of user utterances.
	SentimentAnalysisSettings *SentimentAnalysisSettings `locationName:"sentimentAnalysisSettings" type:"structure"`

	// A list of tags associated with the bot alias.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *CreateBotAliasOutput) SetBotAliasId(v string) *CreateBotAliasOutput {
	s.BotAliasId = &v
	return s
}

// SetBotAliasLocaleSettings sets the BotAliasLocaleSettings field's value.
func (s *CreateBotAliasOutput) SetBotAliasLocaleSettings(v map[string]*BotAliasLocaleSettings) *CreateBotAliasOutput {
	s.BotAliasLocaleSettings = v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *CreateBotAliasOutput) SetBotAliasName(v string) *CreateBotAliasOutput {
	s.BotAliasName = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *CreateBotAliasOutput) SetBotAliasStatus(v string) *CreateBotAliasOutput {
	s.BotAliasStatus = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *CreateBotAliasOutput) SetBotId(v string) *CreateBotAliasOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotAliasOutput) SetBotVersion(v string) *CreateBotAliasOutput {
	s.BotVersion = &v
	return s
}

// SetConversationLogSettings sets the ConversationLogSettings field's value.
func (s *CreateBotAliasOutput) SetConversationLogSettings(v *ConversationLogSettings) *CreateBotAliasOutput {
	s.ConversationLogSettings = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotAliasOutput) SetCreationDateTime(v time.Time) *CreateBotAliasOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotAliasOutput) SetDescription(v string) *CreateBotAliasOutput {
	s.Description = &v
	return s
}

// SetSentimentAnalysisSettings sets the SentimentAnalysisSettings field's value.
func (s *CreateBotAliasOutput) SetSentimentAnalysisSettings(v *SentimentAnalysisSettings) *CreateBotAliasOutput {
	s.SentimentAnalysisSettings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBotAliasOutput) SetTags(v map[string]*string) *CreateBotAliasOutput {
	s.Tags = v
	return s
}

type CreateBotInput struct {
	_ struct{} `type:"structure"`

	// The list of bot members in a network to be created.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name of the bot. The bot name must be unique in the account that creates
	// the bot.
	//
	// BotName is a required field
	BotName *string `locationName:"botName" min:"1" type:"string" required:"true"`

	// A list of tags to add to the bot. You can only add tags when you create a
	// bot. You can't use the UpdateBot operation to update tags. To update tags,
	// use the TagResource operation.
	BotTags map[string]*string `locationName:"botTags" type:"map"`

	// The type of a bot to create.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// Provides information on additional privacy protections Amazon Lex should
	// use with the bot's data.
	//
	// DataPrivacy is a required field
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure" required:"true"`

	// A description of the bot. It appears in lists to help you identify a particular
	// bot.
	Description *string `locationName:"description" type:"string"`

	// The time, in seconds, that Amazon Lex should keep information about a user's
	// conversation with the bot.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Lex
	// deletes any data provided before the timeout.
	//
	// You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
	//
	// IdleSessionTTLInSeconds is a required field
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access
	// the bot.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// A list of tags to add to the test alias for a bot. You can only add tags
	// when you create a bot. You can't use the UpdateAlias operation to update
	// tags. To update tags on the test alias, use the TagResource operation.
	TestBotAliasTags map[string]*string `locationName:"testBotAliasTags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 1))
	}
	if s.DataPrivacy == nil {
		invalidParams.Add(request.NewErrParamRequired("DataPrivacy"))
	}
	if s.IdleSessionTTLInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("IdleSessionTTLInSeconds"))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.BotMembers != nil {
		for i, v := range s.BotMembers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BotMembers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataPrivacy != nil {
		if err := s.DataPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DataPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotMembers sets the BotMembers field's value.
func (s *CreateBotInput) SetBotMembers(v []*BotMember) *CreateBotInput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *CreateBotInput) SetBotName(v string) *CreateBotInput {
	s.BotName = &v
	return s
}

// SetBotTags sets the BotTags field's value.
func (s *CreateBotInput) SetBotTags(v map[string]*string) *CreateBotInput {
	s.BotTags = v
	return s
}

// SetBotType sets the BotType field's value.
func (s *CreateBotInput) SetBotType(v string) *CreateBotInput {
	s.BotType = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *CreateBotInput) SetDataPrivacy(v *DataPrivacy) *CreateBotInput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotInput) SetDescription(v string) *CreateBotInput {
	s.Description = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *CreateBotInput) SetIdleSessionTTLInSeconds(v int64) *CreateBotInput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateBotInput) SetRoleArn(v string) *CreateBotInput {
	s.RoleArn = &v
	return s
}

// SetTestBotAliasTags sets the TestBotAliasTags field's value.
func (s *CreateBotInput) SetTestBotAliasTags(v map[string]*string) *CreateBotInput {
	s.TestBotAliasTags = v
	return s
}

type CreateBotLocaleInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to create the locale for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to create the locale for. This can only be the draft
	// version of the bot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// A description of the bot locale. Use this to help identify the bot locale
	// in lists.
	Description *string `locationName:"description" type:"string"`

	// Contains specifications about the generative AI capabilities from Amazon
	// Bedrock that you can turn on for your bot.
	GenerativeAISettings *GenerativeAISettings `locationName:"generativeAISettings" type:"structure"`

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot
	// types, and slots used in the bot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`

	// Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent,
	// AMAZON.KendraSearchIntent, or both when returning alternative intents. AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent are only inserted if they are configured for
	// the bot.
	//
	// For example, suppose a bot is configured with the confidence threshold of
	// 0.80 and the AMAZON.FallbackIntent. Amazon Lex returns three alternative
	// intents with the following confidence scores: IntentA (0.70), IntentB (0.60),
	// IntentC (0.50). The response from the RecognizeText operation would be:
	//
	//    * AMAZON.FallbackIntent
	//
	//    * IntentA
	//
	//    * IntentB
	//
	//    * IntentC
	//
	// NluIntentConfidenceThreshold is a required field
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double" required:"true"`

	// The Amazon Polly voice ID that Amazon Lex uses for voice interaction with
	// the user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.NluIntentConfidenceThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("NluIntentConfidenceThreshold"))
	}
	if s.GenerativeAISettings != nil {
		if err := s.GenerativeAISettings.Validate(); err != nil {
			invalidParams.AddNested("GenerativeAISettings", err.(request.ErrInvalidParams))
		}
	}
	if s.VoiceSettings != nil {
		if err := s.VoiceSettings.Validate(); err != nil {
			invalidParams.AddNested("VoiceSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateBotLocaleInput) SetBotId(v string) *CreateBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotLocaleInput) SetBotVersion(v string) *CreateBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotLocaleInput) SetDescription(v string) *CreateBotLocaleInput {
	s.Description = &v
	return s
}

// SetGenerativeAISettings sets the GenerativeAISettings field's value.
func (s *CreateBotLocaleInput) SetGenerativeAISettings(v *GenerativeAISettings) *CreateBotLocaleInput {
	s.GenerativeAISettings = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateBotLocaleInput) SetLocaleId(v string) *CreateBotLocaleInput {
	s.LocaleId = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *CreateBotLocaleInput) SetNluIntentConfidenceThreshold(v float64) *CreateBotLocaleInput {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *CreateBotLocaleInput) SetVoiceSettings(v *VoiceSettings) *CreateBotLocaleInput {
	s.VoiceSettings = v
	return s
}

type CreateBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The specified bot identifier.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The status of the bot.
	//
	// When the status is Creating the bot locale is being configured. When the
	// status is Building Amazon Lex is building the bot for testing and use.
	//
	// If the status of the bot is ReadyExpressTesting, you can test the bot using
	// the exact utterances specified in the bots' intents. When the bot is ready
	// for full testing or to run, the status is Built.
	//
	// If there was a problem with building the bot, the status is Failed. If the
	// bot was saved but not built, the status is NotBuilt.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The specified bot version.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp specifying the date and time that the bot locale was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The specified description of the bot locale.
	Description *string `locationName:"description" type:"string"`

	// Contains specifications about the generative AI capabilities from Amazon
	// Bedrock that you can turn on for your bot.
	GenerativeAISettings *GenerativeAISettings `locationName:"generativeAISettings" type:"structure"`

	// The specified locale identifier.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The specified locale name.
	LocaleName *string `locationName:"localeName" type:"string"`

	// The specified confidence threshold for inserting the AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent intents.
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double"`

	// The Amazon Polly voice ID that Amazon Lex uses for voice interaction with
	// the user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateBotLocaleOutput) SetBotId(v string) *CreateBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *CreateBotLocaleOutput) SetBotLocaleStatus(v string) *CreateBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotLocaleOutput) SetBotVersion(v string) *CreateBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotLocaleOutput) SetCreationDateTime(v time.Time) *CreateBotLocaleOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotLocaleOutput) SetDescription(v string) *CreateBotLocaleOutput {
	s.Description = &v
	return s
}

// SetGenerativeAISettings sets the GenerativeAISettings field's value.
func (s *CreateBotLocaleOutput) SetGenerativeAISettings(v *GenerativeAISettings) *CreateBotLocaleOutput {
	s.GenerativeAISettings = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateBotLocaleOutput) SetLocaleId(v string) *CreateBotLocaleOutput {
	s.LocaleId = &v
	return s
}

// SetLocaleName sets the LocaleName field's value.
func (s *CreateBotLocaleOutput) SetLocaleName(v string) *CreateBotLocaleOutput {
	s.LocaleName = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *CreateBotLocaleOutput) SetNluIntentConfidenceThreshold(v float64) *CreateBotLocaleOutput {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *CreateBotLocaleOutput) SetVoiceSettings(v *VoiceSettings) *CreateBotLocaleOutput {
	s.VoiceSettings = v
	return s
}

type CreateBotOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a particular bot. You use this to identify the bot
	// when you call other Amazon Lex API operations.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The list of bots in a network that was created.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name specified for the bot.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// Shows the current status of the bot. The bot is first in the Creating status.
	// Once the bot is read for use, it changes to the Available status. After the
	// bot is created, you can use the DRAFT version of the bot.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// A list of tags associated with the bot.
	BotTags map[string]*string `locationName:"botTags" type:"map"`

	// The type of a bot that was created.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// A timestamp indicating the date and time that the bot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The data privacy settings specified for the bot.
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure"`

	// The description specified for the bot.
	Description *string `locationName:"description" type:"string"`

	// The session idle time specified for the bot.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// The IAM role specified for the bot.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// A list of tags associated with the test alias for the bot.
	TestBotAliasTags map[string]*string `locationName:"testBotAliasTags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateBotOutput) SetBotId(v string) *CreateBotOutput {
	s.BotId = &v
	return s
}

// SetBotMembers sets the BotMembers field's value.
func (s *CreateBotOutput) SetBotMembers(v []*BotMember) *CreateBotOutput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *CreateBotOutput) SetBotName(v string) *CreateBotOutput {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *CreateBotOutput) SetBotStatus(v string) *CreateBotOutput {
	s.BotStatus = &v
	return s
}

// SetBotTags sets the BotTags field's value.
func (s *CreateBotOutput) SetBotTags(v map[string]*string) *CreateBotOutput {
	s.BotTags = v
	return s
}

// SetBotType sets the BotType field's value.
func (s *CreateBotOutput) SetBotType(v string) *CreateBotOutput {
	s.BotType = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotOutput) SetCreationDateTime(v time.Time) *CreateBotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *CreateBotOutput) SetDataPrivacy(v *DataPrivacy) *CreateBotOutput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotOutput) SetDescription(v string) *CreateBotOutput {
	s.Description = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *CreateBotOutput) SetIdleSessionTTLInSeconds(v int64) *CreateBotOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateBotOutput) SetRoleArn(v string) *CreateBotOutput {
	s.RoleArn = &v
	return s
}

// SetTestBotAliasTags sets the TestBotAliasTags field's value.
func (s *CreateBotOutput) SetTestBotAliasTags(v map[string]*string) *CreateBotOutput {
	s.TestBotAliasTags = v
	return s
}

type CreateBotReplicaInput struct {
	_ struct{} `type:"structure"`

	// The request for the unique bot ID of the source bot to be replicated in the
	// secondary region.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The request for the secondary region that will be used in the replication
	// of the source bot.
	//
	// ReplicaRegion is a required field
	ReplicaRegion *string `locationName:"replicaRegion" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotReplicaInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.ReplicaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicaRegion"))
	}
	if s.ReplicaRegion != nil && len(*s.ReplicaRegion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaRegion", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateBotReplicaInput) SetBotId(v string) *CreateBotReplicaInput {
	s.BotId = &v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *CreateBotReplicaInput) SetReplicaRegion(v string) *CreateBotReplicaInput {
	s.ReplicaRegion = &v
	return s
}

type CreateBotReplicaOutput struct {
	_ struct{} `type:"structure"`

	// The unique bot ID of the replicated bot generated.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The operational status of the replicated bot generated.
	BotReplicaStatus *string `locationName:"botReplicaStatus" type:"string" enum:"BotReplicaStatus"`

	// The creation date and time of the replicated bot generated.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The region of the replicated bot generated.
	ReplicaRegion *string `locationName:"replicaRegion" min:"2" type:"string"`

	// The source region for the source bot used for the replicated bot generated.
	SourceRegion *string `locationName:"sourceRegion" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotReplicaOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateBotReplicaOutput) SetBotId(v string) *CreateBotReplicaOutput {
	s.BotId = &v
	return s
}

// SetBotReplicaStatus sets the BotReplicaStatus field's value.
func (s *CreateBotReplicaOutput) SetBotReplicaStatus(v string) *CreateBotReplicaOutput {
	s.BotReplicaStatus = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotReplicaOutput) SetCreationDateTime(v time.Time) *CreateBotReplicaOutput {
	s.CreationDateTime = &v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *CreateBotReplicaOutput) SetReplicaRegion(v string) *CreateBotReplicaOutput {
	s.ReplicaRegion = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CreateBotReplicaOutput) SetSourceRegion(v string) *CreateBotReplicaOutput {
	s.SourceRegion = &v
	return s
}

type CreateBotVersionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to create the version for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// Specifies the locales that Amazon Lex adds to this version. You can choose
	// the Draft version or any other previously published version for each locale.
	// When you specify a source version, the locale data is copied from the source
	// version to the new version.
	//
	// BotVersionLocaleSpecification is a required field
	BotVersionLocaleSpecification map[string]*BotVersionLocaleDetails `locationName:"botVersionLocaleSpecification" min:"1" type:"map" required:"true"`

	// A description of the version. Use the description to help identify the version
	// in lists.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotVersionInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersionLocaleSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersionLocaleSpecification"))
	}
	if s.BotVersionLocaleSpecification != nil && len(s.BotVersionLocaleSpecification) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersionLocaleSpecification", 1))
	}
	if s.BotVersionLocaleSpecification != nil {
		for i, v := range s.BotVersionLocaleSpecification {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BotVersionLocaleSpecification", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateBotVersionInput) SetBotId(v string) *CreateBotVersionInput {
	s.BotId = &v
	return s
}

// SetBotVersionLocaleSpecification sets the BotVersionLocaleSpecification field's value.
func (s *CreateBotVersionInput) SetBotVersionLocaleSpecification(v map[string]*BotVersionLocaleDetails) *CreateBotVersionInput {
	s.BotVersionLocaleSpecification = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotVersionInput) SetDescription(v string) *CreateBotVersionInput {
	s.Description = &v
	return s
}

type CreateBotVersionOutput struct {
	_ struct{} `type:"structure"`

	// The bot identifier specified in the request.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// When you send a request to create or update a bot, Amazon Lex sets the status
	// response element to Creating. After Amazon Lex builds the bot, it sets status
	// to Available. If Amazon Lex can't build the bot, it sets status to Failed.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The version number assigned to the version.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The source versions used for each locale in the new version.
	BotVersionLocaleSpecification map[string]*BotVersionLocaleDetails `locationName:"botVersionLocaleSpecification" min:"1" type:"map"`

	// A timestamp of the date and time that the version was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the version specified in the request.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateBotVersionOutput) SetBotId(v string) *CreateBotVersionOutput {
	s.BotId = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *CreateBotVersionOutput) SetBotStatus(v string) *CreateBotVersionOutput {
	s.BotStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotVersionOutput) SetBotVersion(v string) *CreateBotVersionOutput {
	s.BotVersion = &v
	return s
}

// SetBotVersionLocaleSpecification sets the BotVersionLocaleSpecification field's value.
func (s *CreateBotVersionOutput) SetBotVersionLocaleSpecification(v map[string]*BotVersionLocaleDetails) *CreateBotVersionOutput {
	s.BotVersionLocaleSpecification = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotVersionOutput) SetCreationDateTime(v time.Time) *CreateBotVersionOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotVersionOutput) SetDescription(v string) *CreateBotVersionOutput {
	s.Description = &v
	return s
}

type CreateExportInput struct {
	_ struct{} `type:"structure"`

	// The file format of the bot or bot locale definition files.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"ImportExportFileFormat"`

	// An password to use to encrypt the exported archive. Using a password is optional,
	// but you should encrypt the archive to protect the data in transit between
	// Amazon Lex and your local computer.
	//
	// FilePassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateExportInput's
	// String and GoString methods.
	FilePassword *string `locationName:"filePassword" min:"1" type:"string" sensitive:"true"`

	// Specifies the type of resource to export, either a bot or a bot locale. You
	// can only specify one type of resource to export.
	//
	// ResourceSpecification is a required field
	ResourceSpecification *ExportResourceSpecification `locationName:"resourceSpecification" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExportInput"}
	if s.FileFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("FileFormat"))
	}
	if s.FilePassword != nil && len(*s.FilePassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilePassword", 1))
	}
	if s.ResourceSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSpecification"))
	}
	if s.ResourceSpecification != nil {
		if err := s.ResourceSpecification.Validate(); err != nil {
			invalidParams.AddNested("ResourceSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileFormat sets the FileFormat field's value.
func (s *CreateExportInput) SetFileFormat(v string) *CreateExportInput {
	s.FileFormat = &v
	return s
}

// SetFilePassword sets the FilePassword field's value.
func (s *CreateExportInput) SetFilePassword(v string) *CreateExportInput {
	s.FilePassword = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *CreateExportInput) SetResourceSpecification(v *ExportResourceSpecification) *CreateExportInput {
	s.ResourceSpecification = v
	return s
}

type CreateExportOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the request to export a bot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// An identifier for a specific request to create an export.
	ExportId *string `locationName:"exportId" min:"10" type:"string"`

	// The status of the export. When the status is Completed, you can use the DescribeExport
	// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html)
	// operation to get the pre-signed S3 URL link to your exported bot or bot locale.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`

	// The file format used for the bot or bot locale definition files.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"ImportExportFileFormat"`

	// A description of the type of resource that was exported, either a bot or
	// a bot locale.
	ResourceSpecification *ExportResourceSpecification `locationName:"resourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateExportOutput) SetCreationDateTime(v time.Time) *CreateExportOutput {
	s.CreationDateTime = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *CreateExportOutput) SetExportId(v string) *CreateExportOutput {
	s.ExportId = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *CreateExportOutput) SetExportStatus(v string) *CreateExportOutput {
	s.ExportStatus = &v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *CreateExportOutput) SetFileFormat(v string) *CreateExportOutput {
	s.FileFormat = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *CreateExportOutput) SetResourceSpecification(v *ExportResourceSpecification) *CreateExportOutput {
	s.ResourceSpecification = v
	return s
}

type CreateIntentInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this intent.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with this intent.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// A description of the intent. Use the description to help identify the intent
	// in lists.
	Description *string `locationName:"description" type:"string"`

	// Specifies that Amazon Lex invokes the alias Lambda function for each user
	// input. You can invoke this Lambda function to personalize user interaction.
	//
	// For example, suppose that your bot determines that the user's name is John.
	// You Lambda function might retrieve John's information from a backend database
	// and prepopulate some of the values. For example, if you find that John is
	// gluten intolerant, you might set the corresponding intent slot, glutenIntolerant
	// to true. You might find John's phone number and set the corresponding session
	// attribute.
	DialogCodeHook *DialogCodeHookSettings `locationName:"dialogCodeHook" type:"structure"`

	// Specifies that Amazon Lex invokes the alias Lambda function when the intent
	// is ready for fulfillment. You can invoke this function to complete the bot's
	// transaction with the user.
	//
	// For example, in a pizza ordering bot, the Lambda function can look up the
	// closest pizza restaurant to the customer's location and then place an order
	// on the customer's behalf.
	FulfillmentCodeHook *FulfillmentCodeHookSettings `locationName:"fulfillmentCodeHook" type:"structure"`

	// Configuration settings for the response that is sent to the user at the beginning
	// of a conversation, before eliciting slot values.
	InitialResponseSetting *InitialResponseSetting `locationName:"initialResponseSetting" type:"structure"`

	// A list of contexts that must be active for this intent to be considered by
	// Amazon Lex.
	//
	// When an intent has an input context list, Amazon Lex only considers using
	// the intent in an interaction with the user when the specified contexts are
	// included in the active context list for the session. If the contexts are
	// not active, then Amazon Lex will not use the intent.
	//
	// A context can be automatically activated using the outputContexts property
	// or it can be set at runtime.
	//
	// For example, if there are two intents with different input contexts that
	// respond to the same utterances, only the intent with the active context will
	// respond.
	//
	// An intent may have up to 5 input contexts. If an intent has multiple input
	// contexts, all of the contexts must be active to consider the intent.
	InputContexts []*InputContext `locationName:"inputContexts" type:"list"`

	// Sets the response that Amazon Lex sends to the user when the intent is closed.
	IntentClosingSetting *IntentClosingSetting `locationName:"intentClosingSetting" type:"structure"`

	// Provides prompts that Amazon Lex sends to the user to confirm the completion
	// of an intent. If the user answers "no," the settings contain a statement
	// that is sent to the user to end the intent.
	IntentConfirmationSetting *IntentConfirmationSetting `locationName:"intentConfirmationSetting" type:"structure"`

	// The name of the intent. Intent names must be unique in the locale that contains
	// the intent and cannot match the name of any built-in intent.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// Configuration information required to use the AMAZON.KendraSearchIntent intent
	// to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent
	// is called when Amazon Lex can't determine another intent to invoke.
	KendraConfiguration *KendraConfiguration `locationName:"kendraConfiguration" type:"structure"`

	// The identifier of the language and locale where this intent is used. All
	// of the bots, slot types, and slots used by the intent must have the same
	// locale. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// A lists of contexts that the intent activates when it is fulfilled.
	//
	// You can use an output context to indicate the intents that Amazon Lex should
	// consider for the next turn of the conversation with a customer.
	//
	// When you use the outputContextsList property, all of the contexts specified
	// in the list are activated when the intent is fulfilled. You can set up to
	// 10 output contexts. You can also set the number of conversation turns that
	// the context should be active, or the length of time that the context should
	// be active.
	OutputContexts []*OutputContext `locationName:"outputContexts" type:"list"`

	// A unique identifier for the built-in intent to base this intent on.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// Specifies the configuration of the built-in Amazon.QnAIntent. The AMAZON.QnAIntent
	// intent is called when Amazon Lex can't determine another intent to invoke.
	// If you specify this field, you can't specify the kendraConfiguration field.
	QnAIntentConfiguration *QnAIntentConfiguration `locationName:"qnAIntentConfiguration" type:"structure"`

	// An array of strings that a user might say to signal the intent. For example,
	// "I want a pizza", or "I want a {PizzaSize} pizza".
	//
	// In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate
	// where they should be displayed in the utterance shown to the user..
	SampleUtterances []*SampleUtterance `locationName:"sampleUtterances" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIntentInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentName == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentName"))
	}
	if s.IntentName != nil && len(*s.IntentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntentName", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.DialogCodeHook != nil {
		if err := s.DialogCodeHook.Validate(); err != nil {
			invalidParams.AddNested("DialogCodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.FulfillmentCodeHook != nil {
		if err := s.FulfillmentCodeHook.Validate(); err != nil {
			invalidParams.AddNested("FulfillmentCodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.InitialResponseSetting != nil {
		if err := s.InitialResponseSetting.Validate(); err != nil {
			invalidParams.AddNested("InitialResponseSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.InputContexts != nil {
		for i, v := range s.InputContexts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputContexts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IntentClosingSetting != nil {
		if err := s.IntentClosingSetting.Validate(); err != nil {
			invalidParams.AddNested("IntentClosingSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.IntentConfirmationSetting != nil {
		if err := s.IntentConfirmationSetting.Validate(); err != nil {
			invalidParams.AddNested("IntentConfirmationSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.KendraConfiguration != nil {
		if err := s.KendraConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KendraConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputContexts != nil {
		for i, v := range s.OutputContexts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputContexts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.QnAIntentConfiguration != nil {
		if err := s.QnAIntentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("QnAIntentConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SampleUtterances != nil {
		for i, v := range s.SampleUtterances {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SampleUtterances", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateIntentInput) SetBotId(v string) *CreateIntentInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateIntentInput) SetBotVersion(v string) *CreateIntentInput {
	s.BotVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIntentInput) SetDescription(v string) *CreateIntentInput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *CreateIntentInput) SetDialogCodeHook(v *DialogCodeHookSettings) *CreateIntentInput {
	s.DialogCodeHook = v
	return s
}

// SetFulfillmentCodeHook sets the FulfillmentCodeHook field's value.
func (s *CreateIntentInput) SetFulfillmentCodeHook(v *FulfillmentCodeHookSettings) *CreateIntentInput {
	s.FulfillmentCodeHook = v
	return s
}

// SetInitialResponseSetting sets the InitialResponseSetting field's value.
func (s *CreateIntentInput) SetInitialResponseSetting(v *InitialResponseSetting) *CreateIntentInput {
	s.InitialResponseSetting = v
	return s
}

// SetInputContexts sets the InputContexts field's value.
func (s *CreateIntentInput) SetInputContexts(v []*InputContext) *CreateIntentInput {
	s.InputContexts = v
	return s
}

// SetIntentClosingSetting sets the IntentClosingSetting field's value.
func (s *CreateIntentInput) SetIntentClosingSetting(v *IntentClosingSetting) *CreateIntentInput {
	s.IntentClosingSetting = v
	return s
}

// SetIntentConfirmationSetting sets the IntentConfirmationSetting field's value.
func (s *CreateIntentInput) SetIntentConfirmationSetting(v *IntentConfirmationSetting) *CreateIntentInput {
	s.IntentConfirmationSetting = v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *CreateIntentInput) SetIntentName(v string) *CreateIntentInput {
	s.IntentName = &v
	return s
}

// SetKendraConfiguration sets the KendraConfiguration field's value.
func (s *CreateIntentInput) SetKendraConfiguration(v *KendraConfiguration) *CreateIntentInput {
	s.KendraConfiguration = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateIntentInput) SetLocaleId(v string) *CreateIntentInput {
	s.LocaleId = &v
	return s
}

// SetOutputContexts sets the OutputContexts field's value.
func (s *CreateIntentInput) SetOutputContexts(v []*OutputContext) *CreateIntentInput {
	s.OutputContexts = v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *CreateIntentInput) SetParentIntentSignature(v string) *CreateIntentInput {
	s.ParentIntentSignature = &v
	return s
}

// SetQnAIntentConfiguration sets the QnAIntentConfiguration field's value.
func (s *CreateIntentInput) SetQnAIntentConfiguration(v *QnAIntentConfiguration) *CreateIntentInput {
	s.QnAIntentConfiguration = v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *CreateIntentInput) SetSampleUtterances(v []*SampleUtterance) *CreateIntentInput {
	s.SampleUtterances = v
	return s
}

type CreateIntentOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the intent.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the intent.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp of the date and time that the intent was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the intent.
	Description *string `locationName:"description" type:"string"`

	// The dialog Lambda function specified for the intent.
	DialogCodeHook *DialogCodeHookSettings `locationName:"dialogCodeHook" type:"structure"`

	// The fulfillment Lambda function specified for the intent.
	FulfillmentCodeHook *FulfillmentCodeHookSettings `locationName:"fulfillmentCodeHook" type:"structure"`

	// Configuration settings for the response that is sent to the user at the beginning
	// of a conversation, before eliciting slot values.
	InitialResponseSetting *InitialResponseSetting `locationName:"initialResponseSetting" type:"structure"`

	// The list of input contexts specified for the intent.
	InputContexts []*InputContext `locationName:"inputContexts" type:"list"`

	// The closing setting specified for the intent.
	IntentClosingSetting *IntentClosingSetting `locationName:"intentClosingSetting" type:"structure"`

	// The confirmation setting specified for the intent.
	IntentConfirmationSetting *IntentConfirmationSetting `locationName:"intentConfirmationSetting" type:"structure"`

	// A unique identifier for the intent.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// The name specified for the intent.
	IntentName *string `locationName:"intentName" min:"1" type:"string"`

	// Configuration for searching a Amazon Kendra index specified for the intent.
	KendraConfiguration *KendraConfiguration `locationName:"kendraConfiguration" type:"structure"`

	// The locale that the intent is specified to use.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The list of output contexts specified for the intent.
	OutputContexts []*OutputContext `locationName:"outputContexts" type:"list"`

	// The signature of the parent intent specified for the intent.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// Details about the the configuration of the built-in Amazon.QnAIntent.
	QnAIntentConfiguration *QnAIntentConfiguration `locationName:"qnAIntentConfiguration" type:"structure"`

	// The sample utterances specified for the intent.
	SampleUtterances []*SampleUtterance `locationName:"sampleUtterances" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateIntentOutput) SetBotId(v string) *CreateIntentOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateIntentOutput) SetBotVersion(v string) *CreateIntentOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateIntentOutput) SetCreationDateTime(v time.Time) *CreateIntentOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIntentOutput) SetDescription(v string) *CreateIntentOutput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *CreateIntentOutput) SetDialogCodeHook(v *DialogCodeHookSettings) *CreateIntentOutput {
	s.DialogCodeHook = v
	return s
}

// SetFulfillmentCodeHook sets the FulfillmentCodeHook field's value.
func (s *CreateIntentOutput) SetFulfillmentCodeHook(v *FulfillmentCodeHookSettings) *CreateIntentOutput {
	s.FulfillmentCodeHook = v
	return s
}

// SetInitialResponseSetting sets the InitialResponseSetting field's value.
func (s *CreateIntentOutput) SetInitialResponseSetting(v *InitialResponseSetting) *CreateIntentOutput {
	s.InitialResponseSetting = v
	return s
}

// SetInputContexts sets the InputContexts field's value.
func (s *CreateIntentOutput) SetInputContexts(v []*InputContext) *CreateIntentOutput {
	s.InputContexts = v
	return s
}

// SetIntentClosingSetting sets the IntentClosingSetting field's value.
func (s *CreateIntentOutput) SetIntentClosingSetting(v *IntentClosingSetting) *CreateIntentOutput {
	s.IntentClosingSetting = v
	return s
}

// SetIntentConfirmationSetting sets the IntentConfirmationSetting field's value.
func (s *CreateIntentOutput) SetIntentConfirmationSetting(v *IntentConfirmationSetting) *CreateIntentOutput {
	s.IntentConfirmationSetting = v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *CreateIntentOutput) SetIntentId(v string) *CreateIntentOutput {
	s.IntentId = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *CreateIntentOutput) SetIntentName(v string) *CreateIntentOutput {
	s.IntentName = &v
	return s
}

// SetKendraConfiguration sets the KendraConfiguration field's value.
func (s *CreateIntentOutput) SetKendraConfiguration(v *KendraConfiguration) *CreateIntentOutput {
	s.KendraConfiguration = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateIntentOutput) SetLocaleId(v string) *CreateIntentOutput {
	s.LocaleId = &v
	return s
}

// SetOutputContexts sets the OutputContexts field's value.
func (s *CreateIntentOutput) SetOutputContexts(v []*OutputContext) *CreateIntentOutput {
	s.OutputContexts = v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *CreateIntentOutput) SetParentIntentSignature(v string) *CreateIntentOutput {
	s.ParentIntentSignature = &v
	return s
}

// SetQnAIntentConfiguration sets the QnAIntentConfiguration field's value.
func (s *CreateIntentOutput) SetQnAIntentConfiguration(v *QnAIntentConfiguration) *CreateIntentOutput {
	s.QnAIntentConfiguration = v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *CreateIntentOutput) SetSampleUtterances(v []*SampleUtterance) *CreateIntentOutput {
	s.SampleUtterances = v
	return s
}

type CreateResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// A resource policy to add to the resource. The policy is a JSON structure
	// that contains one or more statements that define the policy. The policy must
	// follow the IAM syntax. For more information about the contents of a JSON
	// policy document, see IAM JSON policy reference (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
	//
	// If the policy isn't valid, Amazon Lex returns a validation exception.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 2))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *CreateResourcePolicyInput) SetPolicy(v string) *CreateResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyInput) SetResourceArn(v string) *CreateResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type CreateResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy was attached to.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyOutput) SetResourceArn(v string) *CreateResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateResourcePolicyOutput) SetRevisionId(v string) *CreateResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type CreateResourcePolicyStatementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Lex action that this policy either allows or denies. The action
	// must apply to the resource type of the specified ARN. For more information,
	// see Actions, resources, and condition keys for Amazon Lex V2 (https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
	//
	// Action is a required field
	Action []*string `locationName:"action" type:"list" required:"true"`

	// Specifies a condition when the policy is in effect. If the principal of the
	// policy is a service principal, you must provide two condition blocks, one
	// with a SourceAccount global condition key and one with a SourceArn global
	// condition key.
	//
	// For more information, see IAM JSON policy elements: Condition (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
	Condition map[string]map[string]*string `locationName:"condition" type:"map"`

	// Determines whether the statement allows or denies access to the resource.
	//
	// Effect is a required field
	Effect *string `locationName:"effect" type:"string" required:"true" enum:"Effect"`

	// The identifier of the revision of the policy to edit. If this revision ID
	// doesn't match the current revision ID, Amazon Lex throws an exception.
	//
	// If you don't specify a revision, Amazon Lex overwrites the contents of the
	// policy with the new values.
	ExpectedRevisionId *string `location:"querystring" locationName:"expectedRevisionId" min:"1" type:"string"`

	// An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services
	// that is allowed or denied access to a resource. For more information, see
	// Amazon Web Services JSON policy elements: Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
	//
	// Principal is a required field
	Principal []*Principal `locationName:"principal" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The name of the statement. The ID is the same as the Sid IAM property. The
	// statement name must be unique within the policy. For more information, see
	// IAM JSON policy elements: Sid (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html).
	//
	// StatementId is a required field
	StatementId *string `locationName:"statementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourcePolicyStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourcePolicyStatementInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Effect == nil {
		invalidParams.Add(request.NewErrParamRequired("Effect"))
	}
	if s.ExpectedRevisionId != nil && len(*s.ExpectedRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpectedRevisionId", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.Principal != nil {
		for i, v := range s.Principal {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Principal", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateResourcePolicyStatementInput) SetAction(v []*string) *CreateResourcePolicyStatementInput {
	s.Action = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CreateResourcePolicyStatementInput) SetCondition(v map[string]map[string]*string) *CreateResourcePolicyStatementInput {
	s.Condition = v
	return s
}

// SetEffect sets the Effect field's value.
func (s *CreateResourcePolicyStatementInput) SetEffect(v string) *CreateResourcePolicyStatementInput {
	s.Effect = &v
	return s
}

// SetExpectedRevisionId sets the ExpectedRevisionId field's value.
func (s *CreateResourcePolicyStatementInput) SetExpectedRevisionId(v string) *CreateResourcePolicyStatementInput {
	s.ExpectedRevisionId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *CreateResourcePolicyStatementInput) SetPrincipal(v []*Principal) *CreateResourcePolicyStatementInput {
	s.Principal = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyStatementInput) SetResourceArn(v string) *CreateResourcePolicyStatementInput {
	s.ResourceArn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *CreateResourcePolicyStatementInput) SetStatementId(v string) *CreateResourcePolicyStatementInput {
	s.StatementId = &v
	return s
}

type CreateResourcePolicyStatementOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyStatementOutput) SetResourceArn(v string) *CreateResourcePolicyStatementOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateResourcePolicyStatementOutput) SetRevisionId(v string) *CreateResourcePolicyStatementOutput {
	s.RevisionId = &v
	return s
}

type CreateSlotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the slot.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// A description of the slot. Use this to help identify the slot in lists.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the intent that contains the slot.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale that the slot will be used in.
	// The string must match one of the supported locales. All of the bots, intents,
	// slot types used by the slot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// Indicates whether the slot returns multiple values in one response. Multi-value
	// slots are only available in the en-US locale. If you set this value to true
	// in any other locale, Amazon Lex throws a ValidationException.
	//
	// If the multipleValuesSetting is not set, the default value is false.
	MultipleValuesSetting *MultipleValuesSetting `locationName:"multipleValuesSetting" type:"structure"`

	// Determines how slot values are used in Amazon CloudWatch logs. If the value
	// of the obfuscationSetting parameter is DefaultObfuscation, slot values are
	// obfuscated in the log output. If the value is None, the actual value is present
	// in the log output.
	//
	// The default is to obfuscate values in the CloudWatch logs.
	ObfuscationSetting *ObfuscationSetting `locationName:"obfuscationSetting" type:"structure"`

	// The name of the slot. Slot names must be unique within the bot that contains
	// the slot.
	//
	// SlotName is a required field
	SlotName *string `locationName:"slotName" min:"1" type:"string" required:"true"`

	// The unique identifier for the slot type associated with this slot. The slot
	// type determines the values that can be entered into the slot.
	SlotTypeId *string `locationName:"slotTypeId" min:"1" type:"string"`

	// Specifications for the constituent sub slots and the expression for the composite
	// slot.
	SubSlotSetting *SubSlotSetting `locationName:"subSlotSetting" type:"structure"`

	// Specifies prompts that Amazon Lex sends to the user to elicit a response
	// that provides the value for the slot.
	//
	// ValueElicitationSetting is a required field
	ValueElicitationSetting *SlotValueElicitationSetting `locationName:"valueElicitationSetting" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSlotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSlotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotName"))
	}
	if s.SlotName != nil && len(*s.SlotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotName", 1))
	}
	if s.SlotTypeId != nil && len(*s.SlotTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeId", 1))
	}
	if s.ValueElicitationSetting == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueElicitationSetting"))
	}
	if s.ObfuscationSetting != nil {
		if err := s.ObfuscationSetting.Validate(); err != nil {
			invalidParams.AddNested("ObfuscationSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.SubSlotSetting != nil {
		if err := s.SubSlotSetting.Validate(); err != nil {
			invalidParams.AddNested("SubSlotSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.ValueElicitationSetting != nil {
		if err := s.ValueElicitationSetting.Validate(); err != nil {
			invalidParams.AddNested("ValueElicitationSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotInput) SetBotId(v string) *CreateSlotInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotInput) SetBotVersion(v string) *CreateSlotInput {
	s.BotVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotInput) SetDescription(v string) *CreateSlotInput {
	s.Description = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *CreateSlotInput) SetIntentId(v string) *CreateSlotInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotInput) SetLocaleId(v string) *CreateSlotInput {
	s.LocaleId = &v
	return s
}

// SetMultipleValuesSetting sets the MultipleValuesSetting field's value.
func (s *CreateSlotInput) SetMultipleValuesSetting(v *MultipleValuesSetting) *CreateSlotInput {
	s.MultipleValuesSetting = v
	return s
}

// SetObfuscationSetting sets the ObfuscationSetting field's value.
func (s *CreateSlotInput) SetObfuscationSetting(v *ObfuscationSetting) *CreateSlotInput {
	s.ObfuscationSetting = v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *CreateSlotInput) SetSlotName(v string) *CreateSlotInput {
	s.SlotName = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *CreateSlotInput) SetSlotTypeId(v string) *CreateSlotInput {
	s.SlotTypeId = &v
	return s
}

// SetSubSlotSetting sets the SubSlotSetting field's value.
func (s *CreateSlotInput) SetSubSlotSetting(v *SubSlotSetting) *CreateSlotInput {
	s.SubSlotSetting = v
	return s
}

// SetValueElicitationSetting sets the ValueElicitationSetting field's value.
func (s *CreateSlotInput) SetValueElicitationSetting(v *SlotValueElicitationSetting) *CreateSlotInput {
	s.ValueElicitationSetting = v
	return s
}

type CreateSlotOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot associated with the slot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the slot.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The timestamp of the date and time that the slot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description associated with the slot.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the intent associated with the slot.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// The language and local specified for the slot.
	LocaleId *string `locationName:"localeId" type:"string"`

	// Indicates whether the slot returns multiple values in one response.
	MultipleValuesSetting *MultipleValuesSetting `locationName:"multipleValuesSetting" type:"structure"`

	// Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch
	// logs.
	ObfuscationSetting *ObfuscationSetting `locationName:"obfuscationSetting" type:"structure"`

	// The unique identifier associated with the slot. Use this to identify the
	// slot when you update or delete it.
	SlotId *string `locationName:"slotId" min:"10" type:"string"`

	// The name specified for the slot.
	SlotName *string `locationName:"slotName" min:"1" type:"string"`

	// The unique identifier of the slot type associated with this slot.
	SlotTypeId *string `locationName:"slotTypeId" min:"1" type:"string"`

	// Specifications for the constituent sub slots and the expression for the composite
	// slot.
	SubSlotSetting *SubSlotSetting `locationName:"subSlotSetting" type:"structure"`

	// The value elicitation settings specified for the slot.
	ValueElicitationSetting *SlotValueElicitationSetting `locationName:"valueElicitationSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotOutput) SetBotId(v string) *CreateSlotOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotOutput) SetBotVersion(v string) *CreateSlotOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateSlotOutput) SetCreationDateTime(v time.Time) *CreateSlotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotOutput) SetDescription(v string) *CreateSlotOutput {
	s.Description = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *CreateSlotOutput) SetIntentId(v string) *CreateSlotOutput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotOutput) SetLocaleId(v string) *CreateSlotOutput {
	s.LocaleId = &v
	return s
}

// SetMultipleValuesSetting sets the MultipleValuesSetting field's value.
func (s *CreateSlotOutput) SetMultipleValuesSetting(v *MultipleValuesSetting) *CreateSlotOutput {
	s.MultipleValuesSetting = v
	return s
}

// SetObfuscationSetting sets the ObfuscationSetting field's value.
func (s *CreateSlotOutput) SetObfuscationSetting(v *ObfuscationSetting) *CreateSlotOutput {
	s.ObfuscationSetting = v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *CreateSlotOutput) SetSlotId(v string) *CreateSlotOutput {
	s.SlotId = &v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *CreateSlotOutput) SetSlotName(v string) *CreateSlotOutput {
	s.SlotName = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *CreateSlotOutput) SetSlotTypeId(v string) *CreateSlotOutput {
	s.SlotTypeId = &v
	return s
}

// SetSubSlotSetting sets the SubSlotSetting field's value.
func (s *CreateSlotOutput) SetSubSlotSetting(v *SubSlotSetting) *CreateSlotOutput {
	s.SubSlotSetting = v
	return s
}

// SetValueElicitationSetting sets the ValueElicitationSetting field's value.
func (s *CreateSlotOutput) SetValueElicitationSetting(v *SlotValueElicitationSetting) *CreateSlotOutput {
	s.ValueElicitationSetting = v
	return s
}

type CreateSlotTypeInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this slot type.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the bot version associated with this slot type.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *CompositeSlotTypeSetting `locationName:"compositeSlotTypeSetting" type:"structure"`

	// A description of the slot type. Use the description to help identify the
	// slot type in lists.
	Description *string `locationName:"description" type:"string"`

	// Sets the type of external information used to create the slot type.
	ExternalSourceSetting *ExternalSourceSetting `locationName:"externalSourceSetting" type:"structure"`

	// The identifier of the language and locale that the slot type will be used
	// in. The string must match one of the supported locales. All of the bots,
	// intents, and slots used by the slot type must have the same locale. For more
	// information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The built-in slot type used as a parent of this slot type. When you define
	// a parent slot type, the new slot type has the configuration of the parent
	// slot type.
	//
	// Only AMAZON.AlphaNumeric is supported.
	ParentSlotTypeSignature *string `locationName:"parentSlotTypeSignature" type:"string"`

	// The name for the slot. A slot type name must be unique within the intent.
	//
	// SlotTypeName is a required field
	SlotTypeName *string `locationName:"slotTypeName" min:"1" type:"string" required:"true"`

	// A list of SlotTypeValue objects that defines the values that the slot type
	// can take. Each value can have a list of synonyms, additional values that
	// help train the machine learning model about the values that it resolves for
	// a slot.
	SlotTypeValues []*SlotTypeValue `locationName:"slotTypeValues" min:"1" type:"list"`

	// Determines the strategy that Amazon Lex uses to select a value from the list
	// of possible values. The field can be set to one of the following values:
	//
	//    * ORIGINAL_VALUE - Returns the value entered by the user, if the user
	//    value is similar to the slot value.
	//
	//    * TOP_RESOLUTION - If there is a resolution list for the slot, return
	//    the first value in the resolution list. If there is no resolution list,
	//    return null.
	//
	// If you don't specify the valueSelectionSetting parameter, the default is
	// ORIGINAL_VALUE.
	ValueSelectionSetting *SlotValueSelectionSetting `locationName:"valueSelectionSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSlotTypeInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotTypeName"))
	}
	if s.SlotTypeName != nil && len(*s.SlotTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeName", 1))
	}
	if s.SlotTypeValues != nil && len(s.SlotTypeValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeValues", 1))
	}
	if s.CompositeSlotTypeSetting != nil {
		if err := s.CompositeSlotTypeSetting.Validate(); err != nil {
			invalidParams.AddNested("CompositeSlotTypeSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.ExternalSourceSetting != nil {
		if err := s.ExternalSourceSetting.Validate(); err != nil {
			invalidParams.AddNested("ExternalSourceSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.SlotTypeValues != nil {
		for i, v := range s.SlotTypeValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SlotTypeValues", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ValueSelectionSetting != nil {
		if err := s.ValueSelectionSetting.Validate(); err != nil {
			invalidParams.AddNested("ValueSelectionSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotTypeInput) SetBotId(v string) *CreateSlotTypeInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotTypeInput) SetBotVersion(v string) *CreateSlotTypeInput {
	s.BotVersion = &v
	return s
}

// SetCompositeSlotTypeSetting sets the CompositeSlotTypeSetting field's value.
func (s *CreateSlotTypeInput) SetCompositeSlotTypeSetting(v *CompositeSlotTypeSetting) *CreateSlotTypeInput {
	s.CompositeSlotTypeSetting = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotTypeInput) SetDescription(v string) *CreateSlotTypeInput {
	s.Description = &v
	return s
}

// SetExternalSourceSetting sets the ExternalSourceSetting field's value.
func (s *CreateSlotTypeInput) SetExternalSourceSetting(v *ExternalSourceSetting) *CreateSlotTypeInput {
	s.ExternalSourceSetting = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotTypeInput) SetLocaleId(v string) *CreateSlotTypeInput {
	s.LocaleId = &v
	return s
}

// SetParentSlotTypeSignature sets the ParentSlotTypeSignature field's value.
func (s *CreateSlotTypeInput) SetParentSlotTypeSignature(v string) *CreateSlotTypeInput {
	s.ParentSlotTypeSignature = &v
	return s
}

// SetSlotTypeName sets the SlotTypeName field's value.
func (s *CreateSlotTypeInput) SetSlotTypeName(v string) *CreateSlotTypeInput {
	s.SlotTypeName = &v
	return s
}

// SetSlotTypeValues sets the SlotTypeValues field's value.
func (s *CreateSlotTypeInput) SetSlotTypeValues(v []*SlotTypeValue) *CreateSlotTypeInput {
	s.SlotTypeValues = v
	return s
}

// SetValueSelectionSetting sets the ValueSelectionSetting field's value.
func (s *CreateSlotTypeInput) SetValueSelectionSetting(v *SlotValueSelectionSetting) *CreateSlotTypeInput {
	s.ValueSelectionSetting = v
	return s
}

type CreateSlotTypeOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the bot associated with the slot type.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the slot type.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *CompositeSlotTypeSetting `locationName:"compositeSlotTypeSetting" type:"structure"`

	// A timestamp of the date and time that the slot type was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the slot type.
	Description *string `locationName:"description" type:"string"`

	// The type of external information used to create the slot type.
	ExternalSourceSetting *ExternalSourceSetting `locationName:"externalSourceSetting" type:"structure"`

	// The specified language and local specified for the slot type.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The signature of the base slot type specified for the slot type.
	ParentSlotTypeSignature *string `locationName:"parentSlotTypeSignature" type:"string"`

	// The unique identifier assigned to the slot type. Use this to identify the
	// slot type in the UpdateSlotType and DeleteSlotType operations.
	SlotTypeId *string `locationName:"slotTypeId" min:"10" type:"string"`

	// The name specified for the slot type.
	SlotTypeName *string `locationName:"slotTypeName" min:"1" type:"string"`

	// The list of values that the slot type can assume.
	SlotTypeValues []*SlotTypeValue `locationName:"slotTypeValues" min:"1" type:"list"`

	// The strategy that Amazon Lex uses to select a value from the list of possible
	// values.
	ValueSelectionSetting *SlotValueSelectionSetting `locationName:"valueSelectionSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotTypeOutput) SetBotId(v string) *CreateSlotTypeOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotTypeOutput) SetBotVersion(v string) *CreateSlotTypeOutput {
	s.BotVersion = &v
	return s
}

// SetCompositeSlotTypeSetting sets the CompositeSlotTypeSetting field's value.
func (s *CreateSlotTypeOutput) SetCompositeSlotTypeSetting(v *CompositeSlotTypeSetting) *CreateSlotTypeOutput {
	s.CompositeSlotTypeSetting = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateSlotTypeOutput) SetCreationDateTime(v time.Time) *CreateSlotTypeOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotTypeOutput) SetDescription(v string) *CreateSlotTypeOutput {
	s.Description = &v
	return s
}

// SetExternalSourceSetting sets the ExternalSourceSetting field's value.
func (s *CreateSlotTypeOutput) SetExternalSourceSetting(v *ExternalSourceSetting) *CreateSlotTypeOutput {
	s.ExternalSourceSetting = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotTypeOutput) SetLocaleId(v string) *CreateSlotTypeOutput {
	s.LocaleId = &v
	return s
}

// SetParentSlotTypeSignature sets the ParentSlotTypeSignature field's value.
func (s *CreateSlotTypeOutput) SetParentSlotTypeSignature(v string) *CreateSlotTypeOutput {
	s.ParentSlotTypeSignature = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *CreateSlotTypeOutput) SetSlotTypeId(v string) *CreateSlotTypeOutput {
	s.SlotTypeId = &v
	return s
}

// SetSlotTypeName sets the SlotTypeName field's value.
func (s *CreateSlotTypeOutput) SetSlotTypeName(v string) *CreateSlotTypeOutput {
	s.SlotTypeName = &v
	return s
}

// SetSlotTypeValues sets the SlotTypeValues field's value.
func (s *CreateSlotTypeOutput) SetSlotTypeValues(v []*SlotTypeValue) *CreateSlotTypeOutput {
	s.SlotTypeValues = v
	return s
}

// SetValueSelectionSetting sets the ValueSelectionSetting field's value.
func (s *CreateSlotTypeOutput) SetValueSelectionSetting(v *SlotValueSelectionSetting) *CreateSlotTypeOutput {
	s.ValueSelectionSetting = v
	return s
}

type CreateTestSetDiscrepancyReportInput struct {
	_ struct{} `type:"structure"`

	// The target bot for the test set discrepancy report.
	//
	// Target is a required field
	Target *TestSetDiscrepancyReportResourceTarget `locationName:"target" type:"structure" required:"true"`

	// The test set Id for the test set discrepancy report.
	//
	// TestSetId is a required field
	TestSetId *string `location:"uri" locationName:"testSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestSetDiscrepancyReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTestSetDiscrepancyReportInput"}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.TestSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSetId"))
	}
	if s.TestSetId != nil && len(*s.TestSetId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestSetId", 10))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTarget sets the Target field's value.
func (s *CreateTestSetDiscrepancyReportInput) SetTarget(v *TestSetDiscrepancyReportResourceTarget) *CreateTestSetDiscrepancyReportInput {
	s.Target = v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *CreateTestSetDiscrepancyReportInput) SetTestSetId(v string) *CreateTestSetDiscrepancyReportInput {
	s.TestSetId = &v
	return s
}

type CreateTestSetDiscrepancyReportOutput struct {
	_ struct{} `type:"structure"`

	// The creation date and time for the test set discrepancy report.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The target bot for the test set discrepancy report.
	Target *TestSetDiscrepancyReportResourceTarget `locationName:"target" type:"structure"`

	// The unique identifier of the test set discrepancy report to describe.
	TestSetDiscrepancyReportId *string `locationName:"testSetDiscrepancyReportId" min:"10" type:"string"`

	// The test set Id for the test set discrepancy report.
	TestSetId *string `locationName:"testSetId" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetCreationDateTime(v time.Time) *CreateTestSetDiscrepancyReportOutput {
	s.CreationDateTime = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetTarget(v *TestSetDiscrepancyReportResourceTarget) *CreateTestSetDiscrepancyReportOutput {
	s.Target = v
	return s
}

// SetTestSetDiscrepancyReportId sets the TestSetDiscrepancyReportId field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetTestSetDiscrepancyReportId(v string) *CreateTestSetDiscrepancyReportOutput {
	s.TestSetDiscrepancyReportId = &v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetTestSetId(v string) *CreateTestSetDiscrepancyReportOutput {
	s.TestSetId = &v
	return s
}

type CreateUploadUrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlInput) GoString() string {
	return s.String()
}

type CreateUploadUrlOutput struct {
	_ struct{} `type:"structure"`

	// An identifier for a unique import job. Use it when you call the StartImport
	// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartImport.html)
	// operation.
	ImportId *string `locationName:"importId" min:"10" type:"string"`

	// A pre-signed S3 write URL. Upload the zip archive file that contains the
	// definition of your bot or bot locale.
	UploadUrl *string `locationName:"uploadUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlOutput) GoString() string {
	return s.String()
}

// SetImportId sets the ImportId field's value.
func (s *CreateUploadUrlOutput) SetImportId(v string) *CreateUploadUrlOutput {
	s.ImportId = &v
	return s
}

// SetUploadUrl sets the UploadUrl field's value.
func (s *CreateUploadUrlOutput) SetUploadUrl(v string) *CreateUploadUrlOutput {
	s.UploadUrl = &v
	return s
}

// A custom response string that Amazon Lex sends to your application. You define
// the content and structure the string.
type CustomPayload struct {
	_ struct{} `type:"structure"`

	// The string that is sent to your application.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomPayload"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *CustomPayload) SetValue(v string) *CustomPayload {
	s.Value = &v
	return s
}

// The unique entry identifier for the custom vocabulary items.
type CustomVocabularyEntryId struct {
	_ struct{} `type:"structure"`

	// The unique item identifier for the custom vocabulary items.
	//
	// ItemId is a required field
	ItemId *string `locationName:"itemId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyEntryId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyEntryId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyEntryId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyEntryId"}
	if s.ItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemId"))
	}
	if s.ItemId != nil && len(*s.ItemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ItemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItemId sets the ItemId field's value.
func (s *CustomVocabularyEntryId) SetItemId(v string) *CustomVocabularyEntryId {
	s.ItemId = &v
	return s
}

// Provides the parameters required for exporting a custom vocabulary.
type CustomVocabularyExportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contains the custom vocabulary to export.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that contains the custom vocabulary to export.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The locale of the bot that contains the custom vocabulary to export.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyExportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyExportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyExportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyExportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CustomVocabularyExportSpecification) SetBotId(v string) *CustomVocabularyExportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CustomVocabularyExportSpecification) SetBotVersion(v string) *CustomVocabularyExportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CustomVocabularyExportSpecification) SetLocaleId(v string) *CustomVocabularyExportSpecification {
	s.LocaleId = &v
	return s
}

// Provides the parameters required for importing a custom vocabulary.
type CustomVocabularyImportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to import the custom vocabulary to.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to import the custom vocabulary to.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the local to import the custom vocabulary to. The value
	// must be en_GB.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyImportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyImportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyImportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyImportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CustomVocabularyImportSpecification) SetBotId(v string) *CustomVocabularyImportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CustomVocabularyImportSpecification) SetBotVersion(v string) *CustomVocabularyImportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CustomVocabularyImportSpecification) SetLocaleId(v string) *CustomVocabularyImportSpecification {
	s.LocaleId = &v
	return s
}

// The unique custom vocabulary item from the custom vocabulary list.
type CustomVocabularyItem struct {
	_ struct{} `type:"structure"`

	// The DisplayAs value for the custom vocabulary item from the custom vocabulary
	// list.
	DisplayAs *string `locationName:"displayAs" min:"1" type:"string"`

	// The unique item identifer for the custom vocabulary item from the custom
	// vocabulary list.
	//
	// ItemId is a required field
	ItemId *string `locationName:"itemId" min:"1" type:"string" required:"true"`

	// The unique phrase for the custom vocabulary item from the custom vocabulary
	// list.
	//
	// Phrase is a required field
	Phrase *string `locationName:"phrase" min:"1" type:"string" required:"true"`

	// The weight assigned for the custom vocabulary item from the custom vocabulary
	// list.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyItem"}
	if s.DisplayAs != nil && len(*s.DisplayAs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayAs", 1))
	}
	if s.ItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemId"))
	}
	if s.ItemId != nil && len(*s.ItemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ItemId", 1))
	}
	if s.Phrase == nil {
		invalidParams.Add(request.NewErrParamRequired("Phrase"))
	}
	if s.Phrase != nil && len(*s.Phrase) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Phrase", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayAs sets the DisplayAs field's value.
func (s *CustomVocabularyItem) SetDisplayAs(v string) *CustomVocabularyItem {
	s.DisplayAs = &v
	return s
}

// SetItemId sets the ItemId field's value.
func (s *CustomVocabularyItem) SetItemId(v string) *CustomVocabularyItem {
	s.ItemId = &v
	return s
}

// SetPhrase sets the Phrase field's value.
func (s *CustomVocabularyItem) SetPhrase(v string) *CustomVocabularyItem {
	s.Phrase = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *CustomVocabularyItem) SetWeight(v int64) *CustomVocabularyItem {
	s.Weight = &v
	return s
}

// Specifies the DTMF input specifications.
type DTMFSpecification struct {
	_ struct{} `type:"structure"`

	// The DTMF character that clears the accumulated DTMF digits and immediately
	// ends the input.
	//
	// DeletionCharacter is a required field
	DeletionCharacter *string `locationName:"deletionCharacter" type:"string" required:"true"`

	// The DTMF character that immediately ends input. If the user does not press
	// this character, the input ends after the end timeout.
	//
	// EndCharacter is a required field
	EndCharacter *string `locationName:"endCharacter" type:"string" required:"true"`

	// How long the bot should wait after the last DTMF character input before assuming
	// that the input has concluded.
	//
	// EndTimeoutMs is a required field
	EndTimeoutMs *int64 `locationName:"endTimeoutMs" min:"1" type:"integer" required:"true"`

	// The maximum number of DTMF digits allowed in an utterance.
	//
	// MaxLength is a required field
	MaxLength *int64 `locationName:"maxLength" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DTMFSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DTMFSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DTMFSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DTMFSpecification"}
	if s.DeletionCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("DeletionCharacter"))
	}
	if s.EndCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("EndCharacter"))
	}
	if s.EndTimeoutMs == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeoutMs"))
	}
	if s.EndTimeoutMs != nil && *s.EndTimeoutMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EndTimeoutMs", 1))
	}
	if s.MaxLength == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxLength"))
	}
	if s.MaxLength != nil && *s.MaxLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionCharacter sets the DeletionCharacter field's value.
func (s *DTMFSpecification) SetDeletionCharacter(v string) *DTMFSpecification {
	s.DeletionCharacter = &v
	return s
}

// SetEndCharacter sets the EndCharacter field's value.
func (s *DTMFSpecification) SetEndCharacter(v string) *DTMFSpecification {
	s.EndCharacter = &v
	return s
}

// SetEndTimeoutMs sets the EndTimeoutMs field's value.
func (s *DTMFSpecification) SetEndTimeoutMs(v int64) *DTMFSpecification {
	s.EndTimeoutMs = &v
	return s
}

// SetMaxLength sets the MaxLength field's value.
func (s *DTMFSpecification) SetMaxLength(v int64) *DTMFSpecification {
	s.MaxLength = &v
	return s
}

// By default, data stored by Amazon Lex is encrypted. The DataPrivacy structure
// provides settings that determine how Amazon Lex handles special cases of
// securing the data for your bot.
type DataPrivacy struct {
	_ struct{} `type:"structure"`

	// For each Amazon Lex bot created with the Amazon Lex Model Building Service,
	// you must specify whether your use of Amazon Lex is related to a website,
	// program, or other application that is directed or targeted, in whole or in
	// part, to children under age 13 and subject to the Children's Online Privacy
	// Protection Act (COPPA) by specifying true or false in the childDirected field.
	// By specifying true in the childDirected field, you confirm that your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. By specifying false in the childDirected field, you confirm
	// that your use of Amazon Lex is not related to a website, program, or other
	// application that is directed or targeted, in whole or in part, to children
	// under age 13 and subject to COPPA. You may not specify a default value for
	// the childDirected field that does not accurately reflect whether your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. If your use of Amazon Lex relates to a website, program,
	// or other application that is directed in whole or in part, to children under
	// age 13, you must obtain any required verifiable parental consent under COPPA.
	// For information regarding the use of Amazon Lex in connection with websites,
	// programs, or other applications that are directed or targeted, in whole or
	// in part, to children under age 13, see the Amazon Lex FAQ (http://aws.amazon.com/lex/faqs#data-security).
	//
	// ChildDirected is a required field
	ChildDirected *bool `locationName:"childDirected" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPrivacy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPrivacy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataPrivacy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataPrivacy"}
	if s.ChildDirected == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildDirected"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildDirected sets the ChildDirected field's value.
func (s *DataPrivacy) SetChildDirected(v bool) *DataPrivacy {
	s.ChildDirected = &v
	return s
}

// Contains details about the configuration of the knowledge store used for
// the AMAZON.QnAIntent. You must have already created the knowledge store and
// indexed the documents within it.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains details about the configuration of the Amazon Bedrock knowledge
	// base used for the AMAZON.QnAIntent. To set up a knowledge base, follow the
	// steps at Building a knowledge base (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html).
	BedrockKnowledgeStoreConfiguration *BedrockKnowledgeStoreConfiguration `locationName:"bedrockKnowledgeStoreConfiguration" type:"structure"`

	// Contains details about the configuration of the Amazon Kendra index used
	// for the AMAZON.QnAIntent. To create a Amazon Kendra index, follow the steps
	// at Creating an index (https://docs.aws.amazon.com/kendra/latest/dg/create-index.html).
	KendraConfiguration *QnAKendraConfiguration `locationName:"kendraConfiguration" type:"structure"`

	// Contains details about the configuration of the Amazon OpenSearch Service
	// database used for the AMAZON.QnAIntent. To create a domain, follow the steps
	// at Creating and managing Amazon OpenSearch Service domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
	OpensearchConfiguration *OpensearchConfiguration `locationName:"opensearchConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.BedrockKnowledgeStoreConfiguration != nil {
		if err := s.BedrockKnowledgeStoreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BedrockKnowledgeStoreConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.KendraConfiguration != nil {
		if err := s.KendraConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KendraConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OpensearchConfiguration != nil {
		if err := s.OpensearchConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OpensearchConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBedrockKnowledgeStoreConfiguration sets the BedrockKnowledgeStoreConfiguration field's value.
func (s *DataSourceConfiguration) SetBedrockKnowledgeStoreConfiguration(v *BedrockKnowledgeStoreConfiguration) *DataSourceConfiguration {
	s.BedrockKnowledgeStoreConfiguration = v
	return s
}

// SetKendraConfiguration sets the KendraConfiguration field's value.
func (s *DataSourceConfiguration) SetKendraConfiguration(v *QnAKendraConfiguration) *DataSourceConfiguration {
	s.KendraConfiguration = v
	return s
}

// SetOpensearchConfiguration sets the OpensearchConfiguration field's value.
func (s *DataSourceConfiguration) SetOpensearchConfiguration(v *OpensearchConfiguration) *DataSourceConfiguration {
	s.OpensearchConfiguration = v
	return s
}

// The object used for specifying the data range that the customer wants Amazon
// Lex to read through in the input transcripts.
type DateRangeFilter struct {
	_ struct{} `type:"structure"`

	// A timestamp indicating the end date for the date range filter.
	//
	// EndDateTime is a required field
	EndDateTime *time.Time `locationName:"endDateTime" type:"timestamp" required:"true"`

	// A timestamp indicating the start date for the date range filter.
	//
	// StartDateTime is a required field
	StartDateTime *time.Time `locationName:"startDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateRangeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateRangeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateRangeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateRangeFilter"}
	if s.EndDateTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDateTime"))
	}
	if s.StartDateTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDateTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *DateRangeFilter) SetEndDateTime(v time.Time) *DateRangeFilter {
	s.EndDateTime = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *DateRangeFilter) SetStartDateTime(v time.Time) *DateRangeFilter {
	s.StartDateTime = &v
	return s
}

// A set of actions that Amazon Lex should run if none of the other conditions
// are met.
type DefaultConditionalBranch struct {
	_ struct{} `type:"structure"`

	// The next step in the conversation.
	NextStep *DialogState `locationName:"nextStep" type:"structure"`

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	Response *ResponseSpecification `locationName:"response" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultConditionalBranch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultConditionalBranch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefaultConditionalBranch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefaultConditionalBranch"}
	if s.NextStep != nil {
		if err := s.NextStep.Validate(); err != nil {
			invalidParams.AddNested("NextStep", err.(request.ErrInvalidParams))
		}
	}
	if s.Response != nil {
		if err := s.Response.Validate(); err != nil {
			invalidParams.AddNested("Response", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextStep sets the NextStep field's value.
func (s *DefaultConditionalBranch) SetNextStep(v *DialogState) *DefaultConditionalBranch {
	s.NextStep = v
	return s
}

// SetResponse sets the Response field's value.
func (s *DefaultConditionalBranch) SetResponse(v *ResponseSpecification) *DefaultConditionalBranch {
	s.Response = v
	return s
}

type DeleteBotAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot alias to delete.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The unique identifier of the bot associated with the alias to delete.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// By default, Amazon Lex checks if any other resource, such as a bot network,
	// is using the bot alias before it is deleted and throws a ResourceInUseException
	// exception if the alias is being used by another resource. Set this parameter
	// to true to skip this check and remove the alias even if it is being used
	// by another resource.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotAliasInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DeleteBotAliasInput) SetBotAliasId(v string) *DeleteBotAliasInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotAliasInput) SetBotId(v string) *DeleteBotAliasInput {
	s.BotId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteBotAliasInput) SetSkipResourceInUseCheck(v bool) *DeleteBotAliasInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot alias to delete.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The current status of the alias. The status is Deleting while the alias is
	// in the process of being deleted. Once the alias is deleted, it will no longer
	// appear in the list of aliases returned by the ListBotAliases operation.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The unique identifier of the bot that contains the alias to delete.
	BotId *string `locationName:"botId" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DeleteBotAliasOutput) SetBotAliasId(v string) *DeleteBotAliasOutput {
	s.BotAliasId = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *DeleteBotAliasOutput) SetBotAliasStatus(v string) *DeleteBotAliasOutput {
	s.BotAliasStatus = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotAliasOutput) SetBotId(v string) *DeleteBotAliasOutput {
	s.BotId = &v
	return s
}

type DeleteBotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot to delete.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// By default, Amazon Lex checks if any other resource, such as an alias or
	// bot network, is using the bot version before it is deleted and throws a ResourceInUseException
	// exception if the bot is being used by another resource. Set this parameter
	// to true to skip this check and remove the bot even if it is being used by
	// another resource.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotInput) SetBotId(v string) *DeleteBotInput {
	s.BotId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteBotInput) SetSkipResourceInUseCheck(v bool) *DeleteBotInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteBotLocaleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot that contains the locale.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that contains the locale.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that will be deleted. The string
	// must match one of the supported locales. For more information, see Supported
	// languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotLocaleInput) SetBotId(v string) *DeleteBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotLocaleInput) SetBotVersion(v string) *DeleteBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteBotLocaleInput) SetLocaleId(v string) *DeleteBotLocaleInput {
	s.LocaleId = &v
	return s
}

type DeleteBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contained the deleted locale.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The status of deleting the bot locale. The locale first enters the Deleting
	// status. Once the locale is deleted it no longer appears in the list of locales
	// for the bot.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The version of the bot that contained the deleted locale.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The language and locale of the deleted locale.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotLocaleOutput) SetBotId(v string) *DeleteBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *DeleteBotLocaleOutput) SetBotLocaleStatus(v string) *DeleteBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotLocaleOutput) SetBotVersion(v string) *DeleteBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteBotLocaleOutput) SetLocaleId(v string) *DeleteBotLocaleOutput {
	s.LocaleId = &v
	return s
}

type DeleteBotOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot that Amazon Lex is deleting.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The current status of the bot. The status is Deleting while the bot and its
	// associated resources are being deleted.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotOutput) SetBotId(v string) *DeleteBotOutput {
	s.BotId = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DeleteBotOutput) SetBotStatus(v string) *DeleteBotOutput {
	s.BotStatus = &v
	return s
}

type DeleteBotReplicaInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the replicated bot to be deleted from the secondary region
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The secondary region of the replicated bot that will be deleted.
	//
	// ReplicaRegion is a required field
	ReplicaRegion *string `location:"uri" locationName:"replicaRegion" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotReplicaInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.ReplicaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicaRegion"))
	}
	if s.ReplicaRegion != nil && len(*s.ReplicaRegion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaRegion", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotReplicaInput) SetBotId(v string) *DeleteBotReplicaInput {
	s.BotId = &v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *DeleteBotReplicaInput) SetReplicaRegion(v string) *DeleteBotReplicaInput {
	s.ReplicaRegion = &v
	return s
}

type DeleteBotReplicaOutput struct {
	_ struct{} `type:"structure"`

	// The unique bot ID of the replicated bot generated.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The operational status of the replicated bot generated.
	BotReplicaStatus *string `locationName:"botReplicaStatus" type:"string" enum:"BotReplicaStatus"`

	// The region of the replicated bot generated.
	ReplicaRegion *string `locationName:"replicaRegion" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotReplicaOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotReplicaOutput) SetBotId(v string) *DeleteBotReplicaOutput {
	s.BotId = &v
	return s
}

// SetBotReplicaStatus sets the BotReplicaStatus field's value.
func (s *DeleteBotReplicaOutput) SetBotReplicaStatus(v string) *DeleteBotReplicaOutput {
	s.BotReplicaStatus = &v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *DeleteBotReplicaOutput) SetReplicaRegion(v string) *DeleteBotReplicaOutput {
	s.ReplicaRegion = &v
	return s
}

type DeleteBotVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot that contains the version.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to delete.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// By default, Amazon Lex checks if any other resource, such as an alias or
	// bot network, is using the bot version before it is deleted and throws a ResourceInUseException
	// exception if the version is being used by another resource. Set this parameter
	// to true to skip this check and remove the version even if it is being used
	// by another resource.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotVersionInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotVersionInput) SetBotId(v string) *DeleteBotVersionInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotVersionInput) SetBotVersion(v string) *DeleteBotVersionInput {
	s.BotVersion = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteBotVersionInput) SetSkipResourceInUseCheck(v bool) *DeleteBotVersionInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteBotVersionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that is being deleted.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The current status of the bot.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The version of the bot that is being deleted.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotVersionOutput) SetBotId(v string) *DeleteBotVersionOutput {
	s.BotId = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DeleteBotVersionOutput) SetBotStatus(v string) *DeleteBotVersionOutput {
	s.BotStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotVersionOutput) SetBotVersion(v string) *DeleteBotVersionOutput {
	s.BotVersion = &v
	return s
}

type DeleteCustomVocabularyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot to remove the custom vocabulary from.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to remove the custom vocabulary from.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The locale identifier for the locale that contains the custom vocabulary
	// to remove.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomVocabularyInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteCustomVocabularyInput) SetBotId(v string) *DeleteCustomVocabularyInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteCustomVocabularyInput) SetBotVersion(v string) *DeleteCustomVocabularyInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteCustomVocabularyInput) SetLocaleId(v string) *DeleteCustomVocabularyInput {
	s.LocaleId = &v
	return s
}

type DeleteCustomVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that the custom vocabulary was removed from.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot that the custom vocabulary was removed from.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The status of removing the custom vocabulary.
	CustomVocabularyStatus *string `locationName:"customVocabularyStatus" type:"string" enum:"CustomVocabularyStatus"`

	// The locale identifier for the locale that the custom vocabulary was removed
	// from.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteCustomVocabularyOutput) SetBotId(v string) *DeleteCustomVocabularyOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteCustomVocabularyOutput) SetBotVersion(v string) *DeleteCustomVocabularyOutput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyStatus sets the CustomVocabularyStatus field's value.
func (s *DeleteCustomVocabularyOutput) SetCustomVocabularyStatus(v string) *DeleteCustomVocabularyOutput {
	s.CustomVocabularyStatus = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteCustomVocabularyOutput) SetLocaleId(v string) *DeleteCustomVocabularyOutput {
	s.LocaleId = &v
	return s
}

type DeleteExportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the export to delete.
	//
	// ExportId is a required field
	ExportId *string `location:"uri" locationName:"exportId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}
	if s.ExportId != nil && len(*s.ExportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ExportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *DeleteExportInput) SetExportId(v string) *DeleteExportInput {
	s.ExportId = &v
	return s
}

type DeleteExportOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the deleted export.
	ExportId *string `locationName:"exportId" min:"10" type:"string"`

	// The current status of the deletion. When the deletion is complete, the export
	// will no longer be returned by the ListExports (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html)
	// operation and calls to the DescribeExport (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html)
	// operation with the export identifier will fail.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportOutput) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *DeleteExportOutput) SetExportId(v string) *DeleteExportOutput {
	s.ExportId = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *DeleteExportOutput) SetExportStatus(v string) *DeleteExportOutput {
	s.ExportStatus = &v
	return s
}

type DeleteImportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the import to delete.
	//
	// ImportId is a required field
	ImportId *string `location:"uri" locationName:"importId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImportInput"}
	if s.ImportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportId"))
	}
	if s.ImportId != nil && len(*s.ImportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ImportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImportId sets the ImportId field's value.
func (s *DeleteImportInput) SetImportId(v string) *DeleteImportInput {
	s.ImportId = &v
	return s
}

type DeleteImportOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the deleted import.
	ImportId *string `locationName:"importId" min:"10" type:"string"`

	// The current status of the deletion. When the deletion is complete, the import
	// will no longer be returned by the ListImports (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListImports.html)
	// operation and calls to the DescribeImport (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeImport.html)
	// operation with the import identifier will fail.
	ImportStatus *string `locationName:"importStatus" type:"string" enum:"ImportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportOutput) GoString() string {
	return s.String()
}

// SetImportId sets the ImportId field's value.
func (s *DeleteImportOutput) SetImportId(v string) *DeleteImportOutput {
	s.ImportId = &v
	return s
}

// SetImportStatus sets the ImportStatus field's value.
func (s *DeleteImportOutput) SetImportStatus(v string) *DeleteImportOutput {
	s.ImportStatus = &v
	return s
}

type DeleteIntentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the intent.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the intent.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The unique identifier of the intent to delete.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale where the bot will be deleted.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntentInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteIntentInput) SetBotId(v string) *DeleteIntentInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteIntentInput) SetBotVersion(v string) *DeleteIntentInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DeleteIntentInput) SetIntentId(v string) *DeleteIntentInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteIntentInput) SetLocaleId(v string) *DeleteIntentInput {
	s.LocaleId = &v
	return s
}

type DeleteIntentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentOutput) GoString() string {
	return s.String()
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the revision to edit. If this ID doesn't match the current
	// revision number, Amazon Lex returns an exception
	//
	// If you don't specify a revision ID, Amazon Lex will delete the current policy.
	ExpectedRevisionId *string `location:"querystring" locationName:"expectedRevisionId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that has the resource
	// policy attached.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ExpectedRevisionId != nil && len(*s.ExpectedRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpectedRevisionId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedRevisionId sets the ExpectedRevisionId field's value.
func (s *DeleteResourcePolicyInput) SetExpectedRevisionId(v string) *DeleteResourcePolicyInput {
	s.ExpectedRevisionId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy was deleted from.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyOutput) SetResourceArn(v string) *DeleteResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DeleteResourcePolicyOutput) SetRevisionId(v string) *DeleteResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type DeleteResourcePolicyStatementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the revision of the policy to delete the statement from.
	// If this revision ID doesn't match the current revision ID, Amazon Lex throws
	// an exception.
	//
	// If you don't specify a revision, Amazon Lex removes the current contents
	// of the statement.
	ExpectedRevisionId *string `location:"querystring" locationName:"expectedRevisionId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The name of the statement (SID) to delete from the policy.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"statementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyStatementInput"}
	if s.ExpectedRevisionId != nil && len(*s.ExpectedRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpectedRevisionId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedRevisionId sets the ExpectedRevisionId field's value.
func (s *DeleteResourcePolicyStatementInput) SetExpectedRevisionId(v string) *DeleteResourcePolicyStatementInput {
	s.ExpectedRevisionId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyStatementInput) SetResourceArn(v string) *DeleteResourcePolicyStatementInput {
	s.ResourceArn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *DeleteResourcePolicyStatementInput) SetStatementId(v string) *DeleteResourcePolicyStatementInput {
	s.StatementId = &v
	return s
}

type DeleteResourcePolicyStatementOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy statement was removed from.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyStatementOutput) SetResourceArn(v string) *DeleteResourcePolicyStatementOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DeleteResourcePolicyStatementOutput) SetRevisionId(v string) *DeleteResourcePolicyStatementOutput {
	s.RevisionId = &v
	return s
}

type DeleteSlotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot to delete.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot to delete.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the intent associated with the slot.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale that the slot will be deleted from.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The identifier of the slot to delete.
	//
	// SlotId is a required field
	SlotId *string `location:"uri" locationName:"slotId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotId"))
	}
	if s.SlotId != nil && len(*s.SlotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SlotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteSlotInput) SetBotId(v string) *DeleteSlotInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteSlotInput) SetBotVersion(v string) *DeleteSlotInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DeleteSlotInput) SetIntentId(v string) *DeleteSlotInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteSlotInput) SetLocaleId(v string) *DeleteSlotInput {
	s.LocaleId = &v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *DeleteSlotInput) SetSlotId(v string) *DeleteSlotInput {
	s.SlotId = &v
	return s
}

type DeleteSlotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotOutput) GoString() string {
	return s.String()
}

type DeleteSlotTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot type.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot type.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that the slot type will be deleted
	// from. The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// By default, the DeleteSlotType operations throws a ResourceInUseException
	// exception if you try to delete a slot type used by a slot. Set the skipResourceInUseCheck
	// parameter to true to skip this check and remove the slot type even if a slot
	// uses it.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`

	// The identifier of the slot type to delete.
	//
	// SlotTypeId is a required field
	SlotTypeId *string `location:"uri" locationName:"slotTypeId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlotTypeInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotTypeId"))
	}
	if s.SlotTypeId != nil && len(*s.SlotTypeId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteSlotTypeInput) SetBotId(v string) *DeleteSlotTypeInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteSlotTypeInput) SetBotVersion(v string) *DeleteSlotTypeInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteSlotTypeInput) SetLocaleId(v string) *DeleteSlotTypeInput {
	s.LocaleId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteSlotTypeInput) SetSkipResourceInUseCheck(v bool) *DeleteSlotTypeInput {
	s.SkipResourceInUseCheck = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *DeleteSlotTypeInput) SetSlotTypeId(v string) *DeleteSlotTypeInput {
	s.SlotTypeId = &v
	return s
}

type DeleteSlotTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeOutput) GoString() string {
	return s.String()
}

type DeleteTestSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The test set Id of the test set to be deleted.
	//
	// TestSetId is a required field
	TestSetId *string `location:"uri" locationName:"testSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTestSetInput"}
	if s.TestSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSetId"))
	}
	if s.TestSetId != nil && len(*s.TestSetId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestSetId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestSetId sets the TestSetId field's value.
func (s *DeleteTestSetInput) SetTestSetId(v string) *DeleteTestSetInput {
	s.TestSetId = &v
	return s
}

type DeleteTestSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetOutput) GoString() string {
	return s.String()
}

type DeleteUtterancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot that contains the utterances.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale where the utterances were collected.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `location:"querystring" locationName:"localeId" type:"string"`

	// The unique identifier of the session with the user. The ID is returned in
	// the response from the RecognizeText (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeText.html)
	// and RecognizeUtterance (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeUtterance.html)
	// operations.
	SessionId *string `location:"querystring" locationName:"sessionId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUtterancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUtterancesInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteUtterancesInput) SetBotId(v string) *DeleteUtterancesInput {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteUtterancesInput) SetLocaleId(v string) *DeleteUtterancesInput {
	s.LocaleId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *DeleteUtterancesInput) SetSessionId(v string) *DeleteUtterancesInput {
	s.SessionId = &v
	return s
}

type DeleteUtterancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesOutput) GoString() string {
	return s.String()
}

type DescribeBotAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot alias to describe.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The identifier of the bot associated with the bot alias to describe.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotAliasInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DescribeBotAliasInput) SetBotAliasId(v string) *DescribeBotAliasInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotAliasInput) SetBotId(v string) *DescribeBotAliasInput {
	s.BotId = &v
	return s
}

type DescribeBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// A list of events that affect a bot alias. For example, an event is recorded
	// when the version that the alias points to changes.
	BotAliasHistoryEvents []*BotAliasHistoryEvent `locationName:"botAliasHistoryEvents" type:"list"`

	// The identifier of the bot alias.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The locale settings that are unique to the alias.
	BotAliasLocaleSettings map[string]*BotAliasLocaleSettings `locationName:"botAliasLocaleSettings" min:"1" type:"map"`

	// The name of the bot alias.
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string"`

	// The current status of the alias. When the alias is Available, the alias is
	// ready for use with your bot.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The identifier of the bot associated with the bot alias.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the bot alias.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Specifics of how Amazon Lex logs text and audio conversations with the bot
	// associated with the alias.
	ConversationLogSettings *ConversationLogSettings `locationName:"conversationLogSettings" type:"structure"`

	// A timestamp of the date and time that the alias was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the bot alias.
	Description *string `locationName:"description" type:"string"`

	// A timestamp of the date and time that the alias was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// A list of the networks to which the bot alias you described belongs.
	ParentBotNetworks []*ParentBotNetwork `locationName:"parentBotNetworks" type:"list"`

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment
	// of user utterances.
	SentimentAnalysisSettings *SentimentAnalysisSettings `locationName:"sentimentAnalysisSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotAliasHistoryEvents sets the BotAliasHistoryEvents field's value.
func (s *DescribeBotAliasOutput) SetBotAliasHistoryEvents(v []*BotAliasHistoryEvent) *DescribeBotAliasOutput {
	s.BotAliasHistoryEvents = v
	return s
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DescribeBotAliasOutput) SetBotAliasId(v string) *DescribeBotAliasOutput {
	s.BotAliasId = &v
	return s
}

// SetBotAliasLocaleSettings sets the BotAliasLocaleSettings field's value.
func (s *DescribeBotAliasOutput) SetBotAliasLocaleSettings(v map[string]*BotAliasLocaleSettings) *DescribeBotAliasOutput {
	s.BotAliasLocaleSettings = v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *DescribeBotAliasOutput) SetBotAliasName(v string) *DescribeBotAliasOutput {
	s.BotAliasName = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *DescribeBotAliasOutput) SetBotAliasStatus(v string) *DescribeBotAliasOutput {
	s.BotAliasStatus = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotAliasOutput) SetBotId(v string) *DescribeBotAliasOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotAliasOutput) SetBotVersion(v string) *DescribeBotAliasOutput {
	s.BotVersion = &v
	return s
}

// SetConversationLogSettings sets the ConversationLogSettings field's value.
func (s *DescribeBotAliasOutput) SetConversationLogSettings(v *ConversationLogSettings) *DescribeBotAliasOutput {
	s.ConversationLogSettings = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotAliasOutput) SetCreationDateTime(v time.Time) *DescribeBotAliasOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotAliasOutput) SetDescription(v string) *DescribeBotAliasOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotAliasOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotAliasOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetParentBotNetworks sets the ParentBotNetworks field's value.
func (s *DescribeBotAliasOutput) SetParentBotNetworks(v []*ParentBotNetwork) *DescribeBotAliasOutput {
	s.ParentBotNetworks = v
	return s
}

// SetSentimentAnalysisSettings sets the SentimentAnalysisSettings field's value.
func (s *DescribeBotAliasOutput) SetSentimentAnalysisSettings(v *SentimentAnalysisSettings) *DescribeBotAliasOutput {
	s.SentimentAnalysisSettings = v
	return s
}

type DescribeBotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot to describe.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotInput) SetBotId(v string) *DescribeBotInput {
	s.BotId = &v
	return s
}

type DescribeBotLocaleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the locale.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the locale.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The unique identifier of the locale to describe. The string must match one
	// of the supported locales. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotLocaleInput) SetBotId(v string) *DescribeBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotLocaleInput) SetBotVersion(v string) *DescribeBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotLocaleInput) SetLocaleId(v string) *DescribeBotLocaleInput {
	s.LocaleId = &v
	return s
}

type DescribeBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the locale.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// History of changes, such as when a locale is used in an alias, that have
	// taken place for the locale.
	BotLocaleHistoryEvents []*BotLocaleHistoryEvent `locationName:"botLocaleHistoryEvents" type:"list"`

	// The status of the bot. If the status is Failed, the reasons for the failure
	// are listed in the failureReasons field.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The version of the bot associated with the locale.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The date and time that the locale was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the locale.
	Description *string `locationName:"description" type:"string"`

	// if botLocaleStatus is Failed, Amazon Lex explains why it failed to build
	// the bot.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// Contains settings for Amazon Bedrock's generative AI features for your bot
	// locale.
	GenerativeAISettings *GenerativeAISettings `locationName:"generativeAISettings" type:"structure"`

	// The number of intents defined for the locale.
	IntentsCount *int64 `locationName:"intentsCount" type:"integer"`

	// The date and time that the locale was last submitted for building.
	LastBuildSubmittedDateTime *time.Time `locationName:"lastBuildSubmittedDateTime" type:"timestamp"`

	// The date and time that the locale was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The unique identifier of the described locale.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The name of the locale.
	LocaleName *string `locationName:"localeName" type:"string"`

	// The confidence threshold where Amazon Lex inserts the AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent intents in the list of possible intents for
	// an utterance.
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double"`

	// Recommended actions to take to resolve an error in the failureReasons field.
	RecommendedActions []*string `locationName:"recommendedActions" type:"list"`

	// The number of slot types defined for the locale.
	SlotTypesCount *int64 `locationName:"slotTypesCount" type:"integer"`

	// The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotLocaleOutput) SetBotId(v string) *DescribeBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleHistoryEvents sets the BotLocaleHistoryEvents field's value.
func (s *DescribeBotLocaleOutput) SetBotLocaleHistoryEvents(v []*BotLocaleHistoryEvent) *DescribeBotLocaleOutput {
	s.BotLocaleHistoryEvents = v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *DescribeBotLocaleOutput) SetBotLocaleStatus(v string) *DescribeBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotLocaleOutput) SetBotVersion(v string) *DescribeBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotLocaleOutput) SetCreationDateTime(v time.Time) *DescribeBotLocaleOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotLocaleOutput) SetDescription(v string) *DescribeBotLocaleOutput {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotLocaleOutput) SetFailureReasons(v []*string) *DescribeBotLocaleOutput {
	s.FailureReasons = v
	return s
}

// SetGenerativeAISettings sets the GenerativeAISettings field's value.
func (s *DescribeBotLocaleOutput) SetGenerativeAISettings(v *GenerativeAISettings) *DescribeBotLocaleOutput {
	s.GenerativeAISettings = v
	return s
}

// SetIntentsCount sets the IntentsCount field's value.
func (s *DescribeBotLocaleOutput) SetIntentsCount(v int64) *DescribeBotLocaleOutput {
	s.IntentsCount = &v
	return s
}

// SetLastBuildSubmittedDateTime sets the LastBuildSubmittedDateTime field's value.
func (s *DescribeBotLocaleOutput) SetLastBuildSubmittedDateTime(v time.Time) *DescribeBotLocaleOutput {
	s.LastBuildSubmittedDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotLocaleOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotLocaleOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotLocaleOutput) SetLocaleId(v string) *DescribeBotLocaleOutput {
	s.LocaleId = &v
	return s
}

// SetLocaleName sets the LocaleName field's value.
func (s *DescribeBotLocaleOutput) SetLocaleName(v string) *DescribeBotLocaleOutput {
	s.LocaleName = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *DescribeBotLocaleOutput) SetNluIntentConfidenceThreshold(v float64) *DescribeBotLocaleOutput {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetRecommendedActions sets the RecommendedActions field's value.
func (s *DescribeBotLocaleOutput) SetRecommendedActions(v []*string) *DescribeBotLocaleOutput {
	s.RecommendedActions = v
	return s
}

// SetSlotTypesCount sets the SlotTypesCount field's value.
func (s *DescribeBotLocaleOutput) SetSlotTypesCount(v int64) *DescribeBotLocaleOutput {
	s.SlotTypesCount = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *DescribeBotLocaleOutput) SetVoiceSettings(v *VoiceSettings) *DescribeBotLocaleOutput {
	s.VoiceSettings = v
	return s
}

type DescribeBotOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The list of bots in the network that was described.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name of the bot.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The current status of the bot. When the status is Available the bot is ready
	// to be used in conversations with users.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The type of the bot that was described.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// A timestamp of the date and time that the bot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Settings for managing data privacy of the bot and its conversations with
	// users.
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure"`

	// The description of the bot.
	Description *string `locationName:"description" type:"string"`

	// If the botStatus is Failed, this contains a list of reasons that the bot
	// couldn't be built.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The maximum time in seconds that Amazon Lex retains the data gathered in
	// a conversation.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// A timestamp of the date and time that the bot was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access
	// the bot.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotOutput) SetBotId(v string) *DescribeBotOutput {
	s.BotId = &v
	return s
}

// SetBotMembers sets the BotMembers field's value.
func (s *DescribeBotOutput) SetBotMembers(v []*BotMember) *DescribeBotOutput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *DescribeBotOutput) SetBotName(v string) *DescribeBotOutput {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DescribeBotOutput) SetBotStatus(v string) *DescribeBotOutput {
	s.BotStatus = &v
	return s
}

// SetBotType sets the BotType field's value.
func (s *DescribeBotOutput) SetBotType(v string) *DescribeBotOutput {
	s.BotType = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotOutput) SetCreationDateTime(v time.Time) *DescribeBotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *DescribeBotOutput) SetDataPrivacy(v *DataPrivacy) *DescribeBotOutput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotOutput) SetDescription(v string) *DescribeBotOutput {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotOutput) SetFailureReasons(v []*string) *DescribeBotOutput {
	s.FailureReasons = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *DescribeBotOutput) SetIdleSessionTTLInSeconds(v int64) *DescribeBotOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeBotOutput) SetRoleArn(v string) *DescribeBotOutput {
	s.RoleArn = &v
	return s
}

type DescribeBotRecommendationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot associated with the bot recommendation.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the bot recommendation to describe.
	//
	// BotRecommendationId is a required field
	BotRecommendationId *string `location:"uri" locationName:"botRecommendationId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the bot recommendation.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale of the bot recommendation to describe.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotRecommendationInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotRecommendationId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotRecommendationId"))
	}
	if s.BotRecommendationId != nil && len(*s.BotRecommendationId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotRecommendationId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotRecommendationInput) SetBotId(v string) *DescribeBotRecommendationInput {
	s.BotId = &v
	return s
}

// SetBotRecommendationId sets the BotRecommendationId field's value.
func (s *DescribeBotRecommendationInput) SetBotRecommendationId(v string) *DescribeBotRecommendationInput {
	s.BotRecommendationId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotRecommendationInput) SetBotVersion(v string) *DescribeBotRecommendationInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotRecommendationInput) SetLocaleId(v string) *DescribeBotRecommendationInput {
	s.LocaleId = &v
	return s
}

type DescribeBotRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the bot recommendation.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the bot recommendation being described.
	BotRecommendationId *string `locationName:"botRecommendationId" min:"10" type:"string"`

	// The object representing the URL of the bot definition, the URL of the associated
	// transcript and a statistical summary of the bot recommendation results.
	BotRecommendationResults *BotRecommendationResults `locationName:"botRecommendationResults" type:"structure"`

	// The status of the bot recommendation. If the status is Failed, then the reasons
	// for the failure are listed in the failureReasons field.
	BotRecommendationStatus *string `locationName:"botRecommendationStatus" type:"string" enum:"BotRecommendationStatus"`

	// The version of the bot associated with the bot recommendation.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The date and time that the bot recommendation was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The object representing the passwords that were used to encrypt the data
	// related to the bot recommendation results, as well as the KMS key ARN used
	// to encrypt the associated metadata.
	EncryptionSetting *EncryptionSetting `locationName:"encryptionSetting" type:"structure"`

	// If botRecommendationStatus is Failed, Amazon Lex explains why.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The date and time that the bot recommendation was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The identifier of the language and locale of the bot recommendation to describe.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The object representing the Amazon S3 bucket containing the transcript, as
	// well as the associated metadata.
	TranscriptSourceSetting *TranscriptSourceSetting `locationName:"transcriptSourceSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotRecommendationOutput) SetBotId(v string) *DescribeBotRecommendationOutput {
	s.BotId = &v
	return s
}

// SetBotRecommendationId sets the BotRecommendationId field's value.
func (s *DescribeBotRecommendationOutput) SetBotRecommendationId(v string) *DescribeBotRecommendationOutput {
	s.BotRecommendationId = &v
	return s
}

// SetBotRecommendationResults sets the BotRecommendationResults field's value.
func (s *DescribeBotRecommendationOutput) SetBotRecommendationResults(v *BotRecommendationResults) *DescribeBotRecommendationOutput {
	s.BotRecommendationResults = v
	return s
}

// SetBotRecommendationStatus sets the BotRecommendationStatus field's value.
func (s *DescribeBotRecommendationOutput) SetBotRecommendationStatus(v string) *DescribeBotRecommendationOutput {
	s.BotRecommendationStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotRecommendationOutput) SetBotVersion(v string) *DescribeBotRecommendationOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotRecommendationOutput) SetCreationDateTime(v time.Time) *DescribeBotRecommendationOutput {
	s.CreationDateTime = &v
	return s
}

// SetEncryptionSetting sets the EncryptionSetting field's value.
func (s *DescribeBotRecommendationOutput) SetEncryptionSetting(v *EncryptionSetting) *DescribeBotRecommendationOutput {
	s.EncryptionSetting = v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotRecommendationOutput) SetFailureReasons(v []*string) *DescribeBotRecommendationOutput {
	s.FailureReasons = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotRecommendationOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotRecommendationOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotRecommendationOutput) SetLocaleId(v string) *DescribeBotRecommendationOutput {
	s.LocaleId = &v
	return s
}

// SetTranscriptSourceSetting sets the TranscriptSourceSetting field's value.
func (s *DescribeBotRecommendationOutput) SetTranscriptSourceSetting(v *TranscriptSourceSetting) *DescribeBotRecommendationOutput {
	s.TranscriptSourceSetting = v
	return s
}

type DescribeBotReplicaInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The request for the unique bot ID of the replicated bot being monitored.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The request for the region of the replicated bot being monitored.
	//
	// ReplicaRegion is a required field
	ReplicaRegion *string `location:"uri" locationName:"replicaRegion" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotReplicaInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.ReplicaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicaRegion"))
	}
	if s.ReplicaRegion != nil && len(*s.ReplicaRegion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaRegion", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotReplicaInput) SetBotId(v string) *DescribeBotReplicaInput {
	s.BotId = &v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *DescribeBotReplicaInput) SetReplicaRegion(v string) *DescribeBotReplicaInput {
	s.ReplicaRegion = &v
	return s
}

type DescribeBotReplicaOutput struct {
	_ struct{} `type:"structure"`

	// The unique bot ID of the replicated bot being monitored.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The operational status of the replicated bot being monitored.
	BotReplicaStatus *string `locationName:"botReplicaStatus" type:"string" enum:"BotReplicaStatus"`

	// The creation date and time of the replicated bot being monitored.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The failure reasons the bot being monitored failed to replicate.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The region of the replicated bot being monitored.
	ReplicaRegion *string `locationName:"replicaRegion" min:"2" type:"string"`

	// The source region of the replicated bot being monitored.
	SourceRegion *string `locationName:"sourceRegion" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotReplicaOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotReplicaOutput) SetBotId(v string) *DescribeBotReplicaOutput {
	s.BotId = &v
	return s
}

// SetBotReplicaStatus sets the BotReplicaStatus field's value.
func (s *DescribeBotReplicaOutput) SetBotReplicaStatus(v string) *DescribeBotReplicaOutput {
	s.BotReplicaStatus = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotReplicaOutput) SetCreationDateTime(v time.Time) *DescribeBotReplicaOutput {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotReplicaOutput) SetFailureReasons(v []*string) *DescribeBotReplicaOutput {
	s.FailureReasons = v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *DescribeBotReplicaOutput) SetReplicaRegion(v string) *DescribeBotReplicaOutput {
	s.ReplicaRegion = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *DescribeBotReplicaOutput) SetSourceRegion(v string) *DescribeBotReplicaOutput {
	s.SourceRegion = &v
	return s
}

type DescribeBotResourceGenerationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot for which to return the generation details.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot for which to return the generation details.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The unique identifier of the generation request for which to return the generation
	// details.
	//
	// GenerationId is a required field
	GenerationId *string `location:"uri" locationName:"generationId" min:"10" type:"string" required:"true"`

	// The locale of the bot for which to return the generation details.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotResourceGenerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotResourceGenerationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotResourceGenerationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotResourceGenerationInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.GenerationId == nil {
		invalidParams.Add(request.NewErrParamRequired("GenerationId"))
	}
	if s.GenerationId != nil && len(*s.GenerationId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("GenerationId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotResourceGenerationInput) SetBotId(v string) *DescribeBotResourceGenerationInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotResourceGenerationInput) SetBotVersion(v string) *DescribeBotResourceGenerationInput {
	s.BotVersion = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *DescribeBotResourceGenerationInput) SetGenerationId(v string) *DescribeBotResourceGenerationInput {
	s.GenerationId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotResourceGenerationInput) SetLocaleId(v string) *DescribeBotResourceGenerationInput {
	s.LocaleId = &v
	return s
}

type DescribeBotResourceGenerationOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot for which the generation request was made.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot for which the generation request was made.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The date and time at which the item was generated.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// A list of reasons why the generation of bot resources through natural language
	// description failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The Amazon S3 location of the generated bot locale configuration.
	GeneratedBotLocaleUrl *string `locationName:"generatedBotLocaleUrl" min:"1" type:"string"`

	// The generation ID for which to return the generation details.
	GenerationId *string `locationName:"generationId" min:"10" type:"string"`

	// The prompt used in the generation request.
	GenerationInputPrompt *string `locationName:"generationInputPrompt" min:"100" type:"string"`

	// The status of the generation request.
	GenerationStatus *string `locationName:"generationStatus" type:"string" enum:"GenerationStatus"`

	// The date and time at which the generated item was updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The locale of the bot for which the generation request was made.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The ARN of the model used to generate the bot resources.
	ModelArn *string `locationName:"modelArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotResourceGenerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotResourceGenerationOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotResourceGenerationOutput) SetBotId(v string) *DescribeBotResourceGenerationOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotResourceGenerationOutput) SetBotVersion(v string) *DescribeBotResourceGenerationOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotResourceGenerationOutput) SetCreationDateTime(v time.Time) *DescribeBotResourceGenerationOutput {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotResourceGenerationOutput) SetFailureReasons(v []*string) *DescribeBotResourceGenerationOutput {
	s.FailureReasons = v
	return s
}

// SetGeneratedBotLocaleUrl sets the GeneratedBotLocaleUrl field's value.
func (s *DescribeBotResourceGenerationOutput) SetGeneratedBotLocaleUrl(v string) *DescribeBotResourceGenerationOutput {
	s.GeneratedBotLocaleUrl = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *DescribeBotResourceGenerationOutput) SetGenerationId(v string) *DescribeBotResourceGenerationOutput {
	s.GenerationId = &v
	return s
}

// SetGenerationInputPrompt sets the GenerationInputPrompt field's value.
func (s *DescribeBotResourceGenerationOutput) SetGenerationInputPrompt(v string) *DescribeBotResourceGenerationOutput {
	s.GenerationInputPrompt = &v
	return s
}

// SetGenerationStatus sets the GenerationStatus field's value.
func (s *DescribeBotResourceGenerationOutput) SetGenerationStatus(v string) *DescribeBotResourceGenerationOutput {
	s.GenerationStatus = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotResourceGenerationOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotResourceGenerationOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotResourceGenerationOutput) SetLocaleId(v string) *DescribeBotResourceGenerationOutput {
	s.LocaleId = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *DescribeBotResourceGenerationOutput) SetModelArn(v string) *DescribeBotResourceGenerationOutput {
	s.ModelArn = &v
	return s
}

type DescribeBotVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot containing the version to return metadata for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to return metadata for.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotVersionInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotVersionInput) SetBotId(v string) *DescribeBotVersionInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotVersionInput) SetBotVersion(v string) *DescribeBotVersionInput {
	s.BotVersion = &v
	return s
}

type DescribeBotVersionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contains the version.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The members of bot network in the version that was described.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name of the bot that contains the version.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The current status of the bot. When the status is Available, the bot version
	// is ready for use.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The type of the bot in the version that was described.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// The version of the bot that was described.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the bot version was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Data privacy settings for the bot version.
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure"`

	// The description specified for the bot.
	Description *string `locationName:"description" type:"string"`

	// If the botStatus is Failed, this contains a list of reasons that the version
	// couldn't be built.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The number of seconds that a session with the bot remains active before it
	// is discarded by Amazon Lex.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// A list of the networks to which the bot version you described belongs.
	ParentBotNetworks []*ParentBotNetwork `locationName:"parentBotNetworks" type:"list"`

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access
	// the bot version.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotVersionOutput) SetBotId(v string) *DescribeBotVersionOutput {
	s.BotId = &v
	return s
}

// SetBotMembers sets the BotMembers field's value.
func (s *DescribeBotVersionOutput) SetBotMembers(v []*BotMember) *DescribeBotVersionOutput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *DescribeBotVersionOutput) SetBotName(v string) *DescribeBotVersionOutput {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DescribeBotVersionOutput) SetBotStatus(v string) *DescribeBotVersionOutput {
	s.BotStatus = &v
	return s
}

// SetBotType sets the BotType field's value.
func (s *DescribeBotVersionOutput) SetBotType(v string) *DescribeBotVersionOutput {
	s.BotType = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotVersionOutput) SetBotVersion(v string) *DescribeBotVersionOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotVersionOutput) SetCreationDateTime(v time.Time) *DescribeBotVersionOutput {
	s.CreationDateTime = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *DescribeBotVersionOutput) SetDataPrivacy(v *DataPrivacy) *DescribeBotVersionOutput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotVersionOutput) SetDescription(v string) *DescribeBotVersionOutput {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotVersionOutput) SetFailureReasons(v []*string) *DescribeBotVersionOutput {
	s.FailureReasons = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *DescribeBotVersionOutput) SetIdleSessionTTLInSeconds(v int64) *DescribeBotVersionOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetParentBotNetworks sets the ParentBotNetworks field's value.
func (s *DescribeBotVersionOutput) SetParentBotNetworks(v []*ParentBotNetwork) *DescribeBotVersionOutput {
	s.ParentBotNetworks = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeBotVersionOutput) SetRoleArn(v string) *DescribeBotVersionOutput {
	s.RoleArn = &v
	return s
}

type DescribeCustomVocabularyMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot that contains the custom vocabulary.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The bot version of the bot to return metadata for.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The locale to return the custom vocabulary information for. The locale must
	// be en_GB.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomVocabularyMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomVocabularyMetadataInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeCustomVocabularyMetadataInput) SetBotId(v string) *DescribeCustomVocabularyMetadataInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeCustomVocabularyMetadataInput) SetBotVersion(v string) *DescribeCustomVocabularyMetadataInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeCustomVocabularyMetadataInput) SetLocaleId(v string) *DescribeCustomVocabularyMetadataInput {
	s.LocaleId = &v
	return s
}

type DescribeCustomVocabularyMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contains the custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot that contains the custom vocabulary to describe.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The date and time that the custom vocabulary was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The status of the custom vocabulary. If the status is Ready the custom vocabulary
	// is ready to use.
	CustomVocabularyStatus *string `locationName:"customVocabularyStatus" type:"string" enum:"CustomVocabularyStatus"`

	// The date and time that the custom vocabulary was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The locale that contains the custom vocabulary to describe.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetBotId(v string) *DescribeCustomVocabularyMetadataOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetBotVersion(v string) *DescribeCustomVocabularyMetadataOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetCreationDateTime(v time.Time) *DescribeCustomVocabularyMetadataOutput {
	s.CreationDateTime = &v
	return s
}

// SetCustomVocabularyStatus sets the CustomVocabularyStatus field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetCustomVocabularyStatus(v string) *DescribeCustomVocabularyMetadataOutput {
	s.CustomVocabularyStatus = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetLastUpdatedDateTime(v time.Time) *DescribeCustomVocabularyMetadataOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetLocaleId(v string) *DescribeCustomVocabularyMetadataOutput {
	s.LocaleId = &v
	return s
}

type DescribeExportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the export to describe.
	//
	// ExportId is a required field
	ExportId *string `location:"uri" locationName:"exportId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}
	if s.ExportId != nil && len(*s.ExportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ExportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *DescribeExportInput) SetExportId(v string) *DescribeExportInput {
	s.ExportId = &v
	return s
}

type DescribeExportOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the export was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// A pre-signed S3 URL that points to the bot or bot locale archive. The URL
	// is only available for 5 minutes after calling the DescribeExport operation.
	DownloadUrl *string `locationName:"downloadUrl" min:"1" type:"string"`

	// The unique identifier of the described export.
	ExportId *string `locationName:"exportId" min:"10" type:"string"`

	// The status of the export. When the status is Complete the export archive
	// file is available for download.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`

	// If the exportStatus is failed, contains one or more reasons why the export
	// could not be completed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The file format used in the files that describe the resource.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"ImportExportFileFormat"`

	// The last date and time that the export was updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The bot, bot ID, and optional locale ID of the exported bot or bot locale.
	ResourceSpecification *ExportResourceSpecification `locationName:"resourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeExportOutput) SetCreationDateTime(v time.Time) *DescribeExportOutput {
	s.CreationDateTime = &v
	return s
}

// SetDownloadUrl sets the DownloadUrl field's value.
func (s *DescribeExportOutput) SetDownloadUrl(v string) *DescribeExportOutput {
	s.DownloadUrl = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *DescribeExportOutput) SetExportId(v string) *DescribeExportOutput {
	s.ExportId = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *DescribeExportOutput) SetExportStatus(v string) *DescribeExportOutput {
	s.ExportStatus = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeExportOutput) SetFailureReasons(v []*string) *DescribeExportOutput {
	s.FailureReasons = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *DescribeExportOutput) SetFileFormat(v string) *DescribeExportOutput {
	s.FileFormat = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeExportOutput) SetLastUpdatedDateTime(v time.Time) *DescribeExportOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeExportOutput) SetResourceSpecification(v *ExportResourceSpecification) *DescribeExportOutput {
	s.ResourceSpecification = v
	return s
}

type DescribeImportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the import to describe.
	//
	// ImportId is a required field
	ImportId *string `location:"uri" locationName:"importId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImportInput"}
	if s.ImportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportId"))
	}
	if s.ImportId != nil && len(*s.ImportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ImportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImportId sets the ImportId field's value.
func (s *DescribeImportInput) SetImportId(v string) *DescribeImportInput {
	s.ImportId = &v
	return s
}

type DescribeImportOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the import was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the importStatus field is Failed, this provides one or more reasons for
	// the failure.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The unique identifier of the described import.
	ImportId *string `locationName:"importId" min:"10" type:"string"`

	// The status of the import process. When the status is Completed the resource
	// is imported and ready for use.
	ImportStatus *string `locationName:"importStatus" type:"string" enum:"ImportStatus"`

	// The unique identifier that Amazon Lex assigned to the resource created by
	// the import.
	ImportedResourceId *string `locationName:"importedResourceId" min:"5" type:"string"`

	// The name of the imported resource.
	ImportedResourceName *string `locationName:"importedResourceName" min:"1" type:"string"`

	// The date and time that the import was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The strategy used when there was a name conflict between the imported resource
	// and an existing resource. When the merge strategy is FailOnConflict existing
	// resources are not overwritten and the import fails.
	MergeStrategy *string `locationName:"mergeStrategy" type:"string" enum:"MergeStrategy"`

	// The specifications of the imported bot, bot locale, or custom vocabulary.
	ResourceSpecification *ImportResourceSpecification `locationName:"resourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeImportOutput) SetCreationDateTime(v time.Time) *DescribeImportOutput {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeImportOutput) SetFailureReasons(v []*string) *DescribeImportOutput {
	s.FailureReasons = v
	return s
}

// SetImportId sets the ImportId field's value.
func (s *DescribeImportOutput) SetImportId(v string) *DescribeImportOutput {
	s.ImportId = &v
	return s
}

// SetImportStatus sets the ImportStatus field's value.
func (s *DescribeImportOutput) SetImportStatus(v string) *DescribeImportOutput {
	s.ImportStatus = &v
	return s
}

// SetImportedResourceId sets the ImportedResourceId field's value.
func (s *DescribeImportOutput) SetImportedResourceId(v string) *DescribeImportOutput {
	s.ImportedResourceId = &v
	return s
}

// SetImportedResourceName sets the ImportedResourceName field's value.
func (s *DescribeImportOutput) SetImportedResourceName(v string) *DescribeImportOutput {
	s.ImportedResourceName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeImportOutput) SetLastUpdatedDateTime(v time.Time) *DescribeImportOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *DescribeImportOutput) SetMergeStrategy(v string) *DescribeImportOutput {
	s.MergeStrategy = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeImportOutput) SetResourceSpecification(v *ImportResourceSpecification) *DescribeImportOutput {
	s.ResourceSpecification = v
	return s
}

type DescribeIntentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the intent.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the intent.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the intent to describe.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale of the intent to describe. The
	// string must match one of the supported locales. For more information, see
	// Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIntentInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeIntentInput) SetBotId(v string) *DescribeIntentInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeIntentInput) SetBotVersion(v string) *DescribeIntentInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeIntentInput) SetIntentId(v string) *DescribeIntentInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeIntentInput) SetLocaleId(v string) *DescribeIntentInput {
	s.LocaleId = &v
	return s
}

type DescribeIntentOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the intent.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the intent.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp of the date and time that the intent was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the intent.
	Description *string `locationName:"description" type:"string"`

	// The Lambda function called during each turn of a conversation with the intent.
	DialogCodeHook *DialogCodeHookSettings `locationName:"dialogCodeHook" type:"structure"`

	// The Lambda function called when the intent is complete and ready for fulfillment.
	FulfillmentCodeHook *FulfillmentCodeHookSettings `locationName:"fulfillmentCodeHook" type:"structure"`

	// Configuration setting for a response sent to the user before Amazon Lex starts
	// eliciting slots.
	InitialResponseSetting *InitialResponseSetting `locationName:"initialResponseSetting" type:"structure"`

	// A list of contexts that must be active for the intent to be considered for
	// sending to the user.
	InputContexts []*InputContext `locationName:"inputContexts" type:"list"`

	// The response that Amazon Lex sends to when the intent is closed.
	IntentClosingSetting *IntentClosingSetting `locationName:"intentClosingSetting" type:"structure"`

	// Prompts that Amazon Lex sends to the user to confirm completion of an intent.
	IntentConfirmationSetting *IntentConfirmationSetting `locationName:"intentConfirmationSetting" type:"structure"`

	// The unique identifier assigned to the intent when it was created.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// The name specified for the intent.
	IntentName *string `locationName:"intentName" min:"1" type:"string"`

	// Configuration information required to use the AMAZON.KendraSearchIntent intent.
	KendraConfiguration *KendraConfiguration `locationName:"kendraConfiguration" type:"structure"`

	// A timestamp of the date and time that the intent was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The language and locale specified for the intent.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of contexts that are activated when the intent is fulfilled.
	OutputContexts []*OutputContext `locationName:"outputContexts" type:"list"`

	// The identifier of the built-in intent that this intent is derived from, if
	// any.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// Details about the configuration of the built-in Amazon.QnAIntent.
	QnAIntentConfiguration *QnAIntentConfiguration `locationName:"qnAIntentConfiguration" type:"structure"`

	// User utterances that trigger this intent.
	SampleUtterances []*SampleUtterance `locationName:"sampleUtterances" type:"list"`

	// The list that determines the priority that slots should be elicited from
	// the user.
	SlotPriorities []*SlotPriority `locationName:"slotPriorities" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeIntentOutput) SetBotId(v string) *DescribeIntentOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeIntentOutput) SetBotVersion(v string) *DescribeIntentOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeIntentOutput) SetCreationDateTime(v time.Time) *DescribeIntentOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeIntentOutput) SetDescription(v string) *DescribeIntentOutput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *DescribeIntentOutput) SetDialogCodeHook(v *DialogCodeHookSettings) *DescribeIntentOutput {
	s.DialogCodeHook = v
	return s
}

// SetFulfillmentCodeHook sets the FulfillmentCodeHook field's value.
func (s *DescribeIntentOutput) SetFulfillmentCodeHook(v *FulfillmentCodeHookSettings) *DescribeIntentOutput {
	s.FulfillmentCodeHook = v
	return s
}

// SetInitialResponseSetting sets the InitialResponseSetting field's value.
func (s *DescribeIntentOutput) SetInitialResponseSetting(v *InitialResponseSetting) *DescribeIntentOutput {
	s.InitialResponseSetting = v
	return s
}

// SetInputContexts sets the InputContexts field's value.
func (s *DescribeIntentOutput) SetInputContexts(v []*InputContext) *DescribeIntentOutput {
	s.InputContexts = v
	return s
}

// SetIntentClosingSetting sets the IntentClosingSetting field's value.
func (s *DescribeIntentOutput) SetIntentClosingSetting(v *IntentClosingSetting) *DescribeIntentOutput {
	s.IntentClosingSetting = v
	return s
}

// SetIntentConfirmationSetting sets the IntentConfirmationSetting field's value.
func (s *DescribeIntentOutput) SetIntentConfirmationSetting(v *IntentConfirmationSetting) *DescribeIntentOutput {
	s.IntentConfirmationSetting = v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeIntentOutput) SetIntentId(v string) *DescribeIntentOutput {
	s.IntentId = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *DescribeIntentOutput) SetIntentName(v string) *DescribeIntentOutput {
	s.IntentName = &v
	return s
}

// SetKendraConfiguration sets the KendraConfiguration field's value.
func (s *DescribeIntentOutput) SetKendraConfiguration(v *KendraConfiguration) *DescribeIntentOutput {
	s.KendraConfiguration = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeIntentOutput) SetLastUpdatedDateTime(v time.Time) *DescribeIntentOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeIntentOutput) SetLocaleId(v string) *DescribeIntentOutput {
	s.LocaleId = &v
	return s
}

// SetOutputContexts sets the OutputContexts field's value.
func (s *DescribeIntentOutput) SetOutputContexts(v []*OutputContext) *DescribeIntentOutput {
	s.OutputContexts = v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *DescribeIntentOutput) SetParentIntentSignature(v string) *DescribeIntentOutput {
	s.ParentIntentSignature = &v
	return s
}

// SetQnAIntentConfiguration sets the QnAIntentConfiguration field's value.
func (s *DescribeIntentOutput) SetQnAIntentConfiguration(v *QnAIntentConfiguration) *DescribeIntentOutput {
	s.QnAIntentConfiguration = v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *DescribeIntentOutput) SetSampleUtterances(v []*SampleUtterance) *DescribeIntentOutput {
	s.SampleUtterances = v
	return s
}

// SetSlotPriorities sets the SlotPriorities field's value.
func (s *DescribeIntentOutput) SetSlotPriorities(v []*SlotPriority) *DescribeIntentOutput {
	s.SlotPriorities = v
	return s
}

type DescribeResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourcePolicyInput) SetResourceArn(v string) *DescribeResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DescribeResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON structure that contains the resource policy. For more information
	// about the contents of a JSON policy document, see IAM JSON policy reference
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
	Policy *string `locationName:"policy" min:"2" type:"string"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DescribeResourcePolicyOutput) SetPolicy(v string) *DescribeResourcePolicyOutput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourcePolicyOutput) SetResourceArn(v string) *DescribeResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DescribeResourcePolicyOutput) SetRevisionId(v string) *DescribeResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type DescribeSlotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the intent that contains the slot.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale of the slot to describe. The string
	// must match one of the supported locales. For more information, see Supported
	// languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The unique identifier for the slot.
	//
	// SlotId is a required field
	SlotId *string `location:"uri" locationName:"slotId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotId"))
	}
	if s.SlotId != nil && len(*s.SlotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SlotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeSlotInput) SetBotId(v string) *DescribeSlotInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeSlotInput) SetBotVersion(v string) *DescribeSlotInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeSlotInput) SetIntentId(v string) *DescribeSlotInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeSlotInput) SetLocaleId(v string) *DescribeSlotInput {
	s.LocaleId = &v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *DescribeSlotInput) SetSlotId(v string) *DescribeSlotInput {
	s.SlotId = &v
	return s
}

type DescribeSlotOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the slot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the slot.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the slot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the slot.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the intent associated with the slot.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// A timestamp of the date and time that the slot was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The language and locale specified for the slot.
	LocaleId *string `locationName:"localeId" type:"string"`

	// Indicates whether the slot accepts multiple values in a single utterance.
	//
	// If the multipleValuesSetting is not set, the default value is false.
	MultipleValuesSetting *MultipleValuesSetting `locationName:"multipleValuesSetting" type:"structure"`

	// Whether slot values are shown in Amazon CloudWatch logs. If the value is
	// None, the actual value of the slot is shown in logs.
	ObfuscationSetting *ObfuscationSetting `locationName:"obfuscationSetting" type:"structure"`

	// The unique identifier generated for the slot.
	SlotId *string `locationName:"slotId" min:"10" type:"string"`

	// The name specified for the slot.
	SlotName *string `locationName:"slotName" min:"1" type:"string"`

	// The identifier of the slot type that determines the values entered into the
	// slot.
	SlotTypeId *string `locationName:"slotTypeId" min:"1" type:"string"`

	// Specifications for the constituent sub slots and the expression for the composite
	// slot.
	SubSlotSetting *SubSlotSetting `locationName:"subSlotSetting" type:"structure"`

	// Prompts that Amazon Lex uses to elicit a value for the slot.
	ValueElicitationSetting *SlotValueElicitationSetting `locationName:"valueElicitationSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeSlotOutput) SetBotId(v string) *DescribeSlotOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeSlotOutput) SetBotVersion(v string) *DescribeSlotOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeSlotOutput) SetCreationDateTime(v time.Time) *DescribeSlotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeSlotOutput) SetDescription(v string) *DescribeSlotOutput {
	s.Description = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeSlotOutput) SetIntentId(v string) *DescribeSlotOutput {
	s.IntentId = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeSlotOutput) SetLastUpdatedDateTime(v time.Time) *DescribeSlotOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeSlotOutput) SetLocaleId(v string) *DescribeSlotOutput {
	s.LocaleId = &v
	return s
}

// SetMultipleValuesSetting sets the MultipleValuesSetting field's value.
func (s *DescribeSlotOutput) SetMultipleValuesSetting(v *MultipleValuesSetting) *DescribeSlotOutput {
	s.MultipleValuesSetting = v
	return s
}

// SetObfuscationSetting sets the ObfuscationSetting field's value.
func (s *DescribeSlotOutput) SetObfuscationSetting(v *ObfuscationSetting) *DescribeSlotOutput {
	s.ObfuscationSetting = v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *DescribeSlotOutput) SetSlotId(v string) *DescribeSlotOutput {
	s.SlotId = &v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *DescribeSlotOutput) SetSlotName(v string) *DescribeSlotOutput {
	s.SlotName = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *DescribeSlotOutput) SetSlotTypeId(v string) *DescribeSlotOutput {
	s.SlotTypeId = &v
	return s
}

// SetSubSlotSetting sets the SubSlotSetting field's value.
func (s *DescribeSlotOutput) SetSubSlotSetting(v *SubSlotSetting) *DescribeSlotOutput {
	s.SubSlotSetting = v
	return s
}

// SetValueElicitationSetting sets the ValueElicitationSetting field's value.
func (s *DescribeSlotOutput) SetValueElicitationSetting(v *SlotValueElicitationSetting) *DescribeSlotOutput {
	s.ValueElicitationSetting = v
	return s
}

type DescribeSlotTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot type.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot type.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the language and locale of the slot type to describe. The
	// string must match one of the supported locales. For more information, see
	// Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The identifier of the slot type.
	//
	// SlotTypeId is a required field
	SlotTypeId *string `location:"uri" locationName:"slotTypeId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlotTypeInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrPar