//
// jja: swiss army knife for chess file formats
// src/lieval.rs: Lichess evaluations export file constants and utilities
//
// Copyright (c) 2023 Ali Polatel <alip@chesswob.org>
//
// SPDX-License-Identifier: GPL-3.0-or-later

use serde::{Deserialize, Serialize};

/// Lichess Evaluations
#[derive(Serialize, Deserialize, Debug)]
pub struct LichessEval {
    /// FEN
    pub fen: String,
    /// List of evaluations
    pub evals: Vec<Eval>,
}

/// Lichess Evaluation
#[derive(Serialize, Deserialize, Debug)]
pub struct Eval {
    /// List of principled variations
    pub pvs: Vec<Pv>,
    /// Depth in kilo nodes
    pub knodes: u64,
    /// Depth in ply
    pub depth: i32,
}

/// Lichess Principled Variation
#[derive(Serialize, Deserialize, Debug)]
pub struct Pv {
    /// Score in centipawns
    pub cp: Option<i32>,
    /// Mate in number of plies
    pub mate: Option<i32>,
    /// Moves as space separated UCI
    pub line: String,
}
