// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bedrockagent

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAgentKnowledgeBase = "AssociateAgentKnowledgeBase"

// AssociateAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAgentKnowledgeBase for more information on using the AssociateAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateAgentKnowledgeBaseRequest method.
//	req, resp := client.AssociateAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AssociateAgentKnowledgeBase
func (c *BedrockAgent) AssociateAgentKnowledgeBaseRequest(input *AssociateAgentKnowledgeBaseInput) (req *request.Request, output *AssociateAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opAssociateAgentKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/",
	}

	if input == nil {
		input = &AssociateAgentKnowledgeBaseInput{}
	}

	output = &AssociateAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Associates a knowledge base with an agent. If a knowledge base is associated
// and its indexState is set to Enabled, the agent queries the knowledge base
// for information to augment its response to the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation AssociateAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AssociateAgentKnowledgeBase
func (c *BedrockAgent) AssociateAgentKnowledgeBase(input *AssociateAgentKnowledgeBaseInput) (*AssociateAgentKnowledgeBaseOutput, error) {
	req, out := c.AssociateAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// AssociateAgentKnowledgeBaseWithContext is the same as AssociateAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) AssociateAgentKnowledgeBaseWithContext(ctx aws.Context, input *AssociateAgentKnowledgeBaseInput, opts ...request.Option) (*AssociateAgentKnowledgeBaseOutput, error) {
	req, out := c.AssociateAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgent = "CreateAgent"

// CreateAgentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgent for more information on using the CreateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentRequest method.
//	req, resp := client.CreateAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgent
func (c *BedrockAgent) CreateAgentRequest(input *CreateAgentInput) (req *request.Request, output *CreateAgentOutput) {
	op := &request.Operation{
		Name:       opCreateAgent,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/",
	}

	if input == nil {
		input = &CreateAgentInput{}
	}

	output = &CreateAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgent API operation for Agents for Amazon Bedrock.
//
// Creates an agent that orchestrates interactions between foundation models,
// data sources, software applications, user conversations, and APIs to carry
// out tasks to help customers.
//
//   - Specify the following fields for security purposes. agentResourceRoleArn
//     – The Amazon Resource Name (ARN) of the role with permissions to invoke
//     API operations on an agent. (Optional) customerEncryptionKeyArn – The
//     Amazon Resource Name (ARN) of a KMS key to encrypt the creation of the
//     agent. (Optional) idleSessionTTLinSeconds – Specify the number of seconds
//     for which the agent should maintain session information. After this time
//     expires, the subsequent InvokeAgent request begins a new session.
//
//   - To override the default prompt behavior for agent orchestration and
//     to use advanced prompts, include a promptOverrideConfiguration object.
//     For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
//
//   - If you agent fails to be created, the response returns a list of failureReasons
//     alongside a list of recommendedActions for you to troubleshoot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgent
func (c *BedrockAgent) CreateAgent(input *CreateAgentInput) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	return out, req.Send()
}

// CreateAgentWithContext is the same as CreateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateAgentWithContext(ctx aws.Context, input *CreateAgentInput, opts ...request.Option) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgentActionGroup = "CreateAgentActionGroup"

// CreateAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgentActionGroup for more information on using the CreateAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentActionGroupRequest method.
//	req, resp := client.CreateAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentActionGroup
func (c *BedrockAgent) CreateAgentActionGroupRequest(input *CreateAgentActionGroupInput) (req *request.Request, output *CreateAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opCreateAgentActionGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/",
	}

	if input == nil {
		input = &CreateAgentActionGroupInput{}
	}

	output = &CreateAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Creates an action group for an agent. An action group represents the actions
// that an agent can carry out for the customer by defining the APIs that an
// agent can call and the logic for calling them.
//
// To allow your agent to request the user for additional information when trying
// to complete a task, add an action group with the parentActionGroupSignature
// field set to AMAZON.UserInput. You must leave the description, apiSchema,
// and actionGroupExecutor fields blank for this action group. During orchestration,
// if your agent determines that it needs to invoke an API in an action group,
// but doesn't have enough information to complete the API request, it will
// invoke this action group instead and return an Observation (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
// reprompting the user for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentActionGroup
func (c *BedrockAgent) CreateAgentActionGroup(input *CreateAgentActionGroupInput) (*CreateAgentActionGroupOutput, error) {
	req, out := c.CreateAgentActionGroupRequest(input)
	return out, req.Send()
}

// CreateAgentActionGroupWithContext is the same as CreateAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateAgentActionGroupWithContext(ctx aws.Context, input *CreateAgentActionGroupInput, opts ...request.Option) (*CreateAgentActionGroupOutput, error) {
	req, out := c.CreateAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgentAlias = "CreateAgentAlias"

// CreateAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgentAlias for more information on using the CreateAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentAliasRequest method.
//	req, resp := client.CreateAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentAlias
func (c *BedrockAgent) CreateAgentAliasRequest(input *CreateAgentAliasInput) (req *request.Request, output *CreateAgentAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAgentAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentaliases/",
	}

	if input == nil {
		input = &CreateAgentAliasInput{}
	}

	output = &CreateAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgentAlias API operation for Agents for Amazon Bedrock.
//
// Creates an alias of an agent that can be used to deploy the agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentAlias
func (c *BedrockAgent) CreateAgentAlias(input *CreateAgentAliasInput) (*CreateAgentAliasOutput, error) {
	req, out := c.CreateAgentAliasRequest(input)
	return out, req.Send()
}

// CreateAgentAliasWithContext is the same as CreateAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateAgentAliasWithContext(ctx aws.Context, input *CreateAgentAliasInput, opts ...request.Option) (*CreateAgentAliasOutput, error) {
	req, out := c.CreateAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSourceRequest method.
//	req, resp := client.CreateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateDataSource
func (c *BedrockAgent) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for Agents for Amazon Bedrock.
//
// Sets up a data source to be added to a knowledge base.
//
// You can't change the chunkingConfiguration after you create the data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateDataSource
func (c *BedrockAgent) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKnowledgeBase = "CreateKnowledgeBase"

// CreateKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKnowledgeBase for more information on using the CreateKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKnowledgeBaseRequest method.
//	req, resp := client.CreateKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateKnowledgeBase
func (c *BedrockAgent) CreateKnowledgeBaseRequest(input *CreateKnowledgeBaseInput) (req *request.Request, output *CreateKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opCreateKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/",
	}

	if input == nil {
		input = &CreateKnowledgeBaseInput{}
	}

	output = &CreateKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Creates a knowledge base that contains data sources from which information
// can be queried and used by LLMs. To create a knowledge base, you must first
// set up your data sources and configure a supported vector store. For more
// information, see Set up your data for ingestion (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup.html).
//
// If you prefer to let Amazon Bedrock create and manage a vector store for
// you in Amazon OpenSearch Service, use the console. For more information,
// see Create a knowledge base (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-create).
//
//   - Provide the name and an optional description.
//
//   - Provide the Amazon Resource Name (ARN) with permissions to create a
//     knowledge base in the roleArn field.
//
//   - Provide the embedding model to use in the embeddingModelArn field in
//     the knowledgeBaseConfiguration object.
//
//   - Provide the configuration for your vector store in the storageConfiguration
//     object. For an Amazon OpenSearch Service database, use the opensearchServerlessConfiguration
//     object. For more information, see Create a vector store in Amazon OpenSearch
//     Service (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html).
//     For an Amazon Aurora database, use the RdsConfiguration object. For more
//     information, see Create a vector store in Amazon Aurora (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html).
//     For a Pinecone database, use the pineconeConfiguration object. For more
//     information, see Create a vector store in Pinecone (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html).
//     For a Redis Enterprise Cloud database, use the redisEnterpriseCloudConfiguration
//     object. For more information, see Create a vector store in Redis Enterprise
//     Cloud (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-redis.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateKnowledgeBase
func (c *BedrockAgent) CreateKnowledgeBase(input *CreateKnowledgeBaseInput) (*CreateKnowledgeBaseOutput, error) {
	req, out := c.CreateKnowledgeBaseRequest(input)
	return out, req.Send()
}

// CreateKnowledgeBaseWithContext is the same as CreateKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateKnowledgeBaseWithContext(ctx aws.Context, input *CreateKnowledgeBaseInput, opts ...request.Option) (*CreateKnowledgeBaseOutput, error) {
	req, out := c.CreateKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgent = "DeleteAgent"

// DeleteAgentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgent for more information on using the DeleteAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentRequest method.
//	req, resp := client.DeleteAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgent
func (c *BedrockAgent) DeleteAgentRequest(input *DeleteAgentInput) (req *request.Request, output *DeleteAgentOutput) {
	op := &request.Operation{
		Name:       opDeleteAgent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &DeleteAgentInput{}
	}

	output = &DeleteAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAgent API operation for Agents for Amazon Bedrock.
//
// Deletes an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgent
func (c *BedrockAgent) DeleteAgent(input *DeleteAgentInput) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	return out, req.Send()
}

// DeleteAgentWithContext is the same as DeleteAgent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentWithContext(ctx aws.Context, input *DeleteAgentInput, opts ...request.Option) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgentActionGroup = "DeleteAgentActionGroup"

// DeleteAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgentActionGroup for more information on using the DeleteAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentActionGroupRequest method.
//	req, resp := client.DeleteAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentActionGroup
func (c *BedrockAgent) DeleteAgentActionGroupRequest(input *DeleteAgentActionGroupInput) (req *request.Request, output *DeleteAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteAgentActionGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
	}

	if input == nil {
		input = &DeleteAgentActionGroupInput{}
	}

	output = &DeleteAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Deletes an action group in an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentActionGroup
func (c *BedrockAgent) DeleteAgentActionGroup(input *DeleteAgentActionGroupInput) (*DeleteAgentActionGroupOutput, error) {
	req, out := c.DeleteAgentActionGroupRequest(input)
	return out, req.Send()
}

// DeleteAgentActionGroupWithContext is the same as DeleteAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentActionGroupWithContext(ctx aws.Context, input *DeleteAgentActionGroupInput, opts ...request.Option) (*DeleteAgentActionGroupOutput, error) {
	req, out := c.DeleteAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgentAlias = "DeleteAgentAlias"

// DeleteAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgentAlias for more information on using the DeleteAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentAliasRequest method.
//	req, resp := client.DeleteAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentAlias
func (c *BedrockAgent) DeleteAgentAliasRequest(input *DeleteAgentAliasInput) (req *request.Request, output *DeleteAgentAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAgentAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentaliases/{agentAliasId}/",
	}

	if input == nil {
		input = &DeleteAgentAliasInput{}
	}

	output = &DeleteAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAgentAlias API operation for Agents for Amazon Bedrock.
//
// Deletes an alias of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentAlias
func (c *BedrockAgent) DeleteAgentAlias(input *DeleteAgentAliasInput) (*DeleteAgentAliasOutput, error) {
	req, out := c.DeleteAgentAliasRequest(input)
	return out, req.Send()
}

// DeleteAgentAliasWithContext is the same as DeleteAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentAliasWithContext(ctx aws.Context, input *DeleteAgentAliasInput, opts ...request.Option) (*DeleteAgentAliasOutput, error) {
	req, out := c.DeleteAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgentVersion = "DeleteAgentVersion"

// DeleteAgentVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgentVersion for more information on using the DeleteAgentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentVersionRequest method.
//	req, resp := client.DeleteAgentVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentVersion
func (c *BedrockAgent) DeleteAgentVersionRequest(input *DeleteAgentVersionInput) (req *request.Request, output *DeleteAgentVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteAgentVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/",
	}

	if input == nil {
		input = &DeleteAgentVersionInput{}
	}

	output = &DeleteAgentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAgentVersion API operation for Agents for Amazon Bedrock.
//
// Deletes a version of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgentVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentVersion
func (c *BedrockAgent) DeleteAgentVersion(input *DeleteAgentVersionInput) (*DeleteAgentVersionOutput, error) {
	req, out := c.DeleteAgentVersionRequest(input)
	return out, req.Send()
}

// DeleteAgentVersionWithContext is the same as DeleteAgentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentVersionWithContext(ctx aws.Context, input *DeleteAgentVersionInput, opts ...request.Option) (*DeleteAgentVersionOutput, error) {
	req, out := c.DeleteAgentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSourceRequest method.
//	req, resp := client.DeleteDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteDataSource
func (c *BedrockAgent) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Agents for Amazon Bedrock.
//
// Deletes a data source from a knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteDataSource
func (c *BedrockAgent) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKnowledgeBase = "DeleteKnowledgeBase"

// DeleteKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKnowledgeBase for more information on using the DeleteKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKnowledgeBaseRequest method.
//	req, resp := client.DeleteKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteKnowledgeBase
func (c *BedrockAgent) DeleteKnowledgeBaseRequest(input *DeleteKnowledgeBaseInput) (req *request.Request, output *DeleteKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opDeleteKnowledgeBase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &DeleteKnowledgeBaseInput{}
	}

	output = &DeleteKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Deletes a knowledge base. Before deleting a knowledge base, you should disassociate
// the knowledge base from any agents that it is associated with by making a
// DisassociateAgentKnowledgeBase (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DisassociateAgentKnowledgeBase.html)
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteKnowledgeBase
func (c *BedrockAgent) DeleteKnowledgeBase(input *DeleteKnowledgeBaseInput) (*DeleteKnowledgeBaseOutput, error) {
	req, out := c.DeleteKnowledgeBaseRequest(input)
	return out, req.Send()
}

// DeleteKnowledgeBaseWithContext is the same as DeleteKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteKnowledgeBaseWithContext(ctx aws.Context, input *DeleteKnowledgeBaseInput, opts ...request.Option) (*DeleteKnowledgeBaseOutput, error) {
	req, out := c.DeleteKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAgentKnowledgeBase = "DisassociateAgentKnowledgeBase"

// DisassociateAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAgentKnowledgeBase for more information on using the DisassociateAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateAgentKnowledgeBaseRequest method.
//	req, resp := client.DisassociateAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DisassociateAgentKnowledgeBase
func (c *BedrockAgent) DisassociateAgentKnowledgeBaseRequest(input *DisassociateAgentKnowledgeBaseInput) (req *request.Request, output *DisassociateAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opDisassociateAgentKnowledgeBase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
	}

	if input == nil {
		input = &DisassociateAgentKnowledgeBaseInput{}
	}

	output = &DisassociateAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Disassociates a knowledge base from an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DisassociateAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DisassociateAgentKnowledgeBase
func (c *BedrockAgent) DisassociateAgentKnowledgeBase(input *DisassociateAgentKnowledgeBaseInput) (*DisassociateAgentKnowledgeBaseOutput, error) {
	req, out := c.DisassociateAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// DisassociateAgentKnowledgeBaseWithContext is the same as DisassociateAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DisassociateAgentKnowledgeBaseWithContext(ctx aws.Context, input *DisassociateAgentKnowledgeBaseInput, opts ...request.Option) (*DisassociateAgentKnowledgeBaseOutput, error) {
	req, out := c.DisassociateAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgent = "GetAgent"

// GetAgentRequest generates a "aws/request.Request" representing the
// client's request for the GetAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgent for more information on using the GetAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentRequest method.
//	req, resp := client.GetAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgent
func (c *BedrockAgent) GetAgentRequest(input *GetAgentInput) (req *request.Request, output *GetAgentOutput) {
	op := &request.Operation{
		Name:       opGetAgent,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &GetAgentInput{}
	}

	output = &GetAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgent API operation for Agents for Amazon Bedrock.
//
// Gets information about an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgent
func (c *BedrockAgent) GetAgent(input *GetAgentInput) (*GetAgentOutput, error) {
	req, out := c.GetAgentRequest(input)
	return out, req.Send()
}

// GetAgentWithContext is the same as GetAgent with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentWithContext(ctx aws.Context, input *GetAgentInput, opts ...request.Option) (*GetAgentOutput, error) {
	req, out := c.GetAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentActionGroup = "GetAgentActionGroup"

// GetAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentActionGroup for more information on using the GetAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentActionGroupRequest method.
//	req, resp := client.GetAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentActionGroup
func (c *BedrockAgent) GetAgentActionGroupRequest(input *GetAgentActionGroupInput) (req *request.Request, output *GetAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opGetAgentActionGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
	}

	if input == nil {
		input = &GetAgentActionGroupInput{}
	}

	output = &GetAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Gets information about an action group for an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentActionGroup
func (c *BedrockAgent) GetAgentActionGroup(input *GetAgentActionGroupInput) (*GetAgentActionGroupOutput, error) {
	req, out := c.GetAgentActionGroupRequest(input)
	return out, req.Send()
}

// GetAgentActionGroupWithContext is the same as GetAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentActionGroupWithContext(ctx aws.Context, input *GetAgentActionGroupInput, opts ...request.Option) (*GetAgentActionGroupOutput, error) {
	req, out := c.GetAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentAlias = "GetAgentAlias"

// GetAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentAlias for more information on using the GetAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentAliasRequest method.
//	req, resp := client.GetAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentAlias
func (c *BedrockAgent) GetAgentAliasRequest(input *GetAgentAliasInput) (req *request.Request, output *GetAgentAliasOutput) {
	op := &request.Operation{
		Name:       opGetAgentAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentaliases/{agentAliasId}/",
	}

	if input == nil {
		input = &GetAgentAliasInput{}
	}

	output = &GetAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentAlias API operation for Agents for Amazon Bedrock.
//
// Gets information about an alias of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentAlias
func (c *BedrockAgent) GetAgentAlias(input *GetAgentAliasInput) (*GetAgentAliasOutput, error) {
	req, out := c.GetAgentAliasRequest(input)
	return out, req.Send()
}

// GetAgentAliasWithContext is the same as GetAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentAliasWithContext(ctx aws.Context, input *GetAgentAliasInput, opts ...request.Option) (*GetAgentAliasOutput, error) {
	req, out := c.GetAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentKnowledgeBase = "GetAgentKnowledgeBase"

// GetAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentKnowledgeBase for more information on using the GetAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentKnowledgeBaseRequest method.
//	req, resp := client.GetAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentKnowledgeBase
func (c *BedrockAgent) GetAgentKnowledgeBaseRequest(input *GetAgentKnowledgeBaseInput) (req *request.Request, output *GetAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opGetAgentKnowledgeBase,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
	}

	if input == nil {
		input = &GetAgentKnowledgeBaseInput{}
	}

	output = &GetAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Gets information about a knowledge base associated with an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentKnowledgeBase
func (c *BedrockAgent) GetAgentKnowledgeBase(input *GetAgentKnowledgeBaseInput) (*GetAgentKnowledgeBaseOutput, error) {
	req, out := c.GetAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// GetAgentKnowledgeBaseWithContext is the same as GetAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentKnowledgeBaseWithContext(ctx aws.Context, input *GetAgentKnowledgeBaseInput, opts ...request.Option) (*GetAgentKnowledgeBaseOutput, error) {
	req, out := c.GetAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentVersion = "GetAgentVersion"

// GetAgentVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentVersion for more information on using the GetAgentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentVersionRequest method.
//	req, resp := client.GetAgentVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentVersion
func (c *BedrockAgent) GetAgentVersionRequest(input *GetAgentVersionInput) (req *request.Request, output *GetAgentVersionOutput) {
	op := &request.Operation{
		Name:       opGetAgentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/",
	}

	if input == nil {
		input = &GetAgentVersionInput{}
	}

	output = &GetAgentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentVersion API operation for Agents for Amazon Bedrock.
//
// Gets details about a version of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentVersion
func (c *BedrockAgent) GetAgentVersion(input *GetAgentVersionInput) (*GetAgentVersionOutput, error) {
	req, out := c.GetAgentVersionRequest(input)
	return out, req.Send()
}

// GetAgentVersionWithContext is the same as GetAgentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentVersionWithContext(ctx aws.Context, input *GetAgentVersionInput, opts ...request.Option) (*GetAgentVersionOutput, error) {
	req, out := c.GetAgentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSource for more information on using the GetDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSourceRequest method.
//	req, resp := client.GetDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetDataSource
func (c *BedrockAgent) GetDataSourceRequest(input *GetDataSourceInput) (req *request.Request, output *GetDataSourceOutput) {
	op := &request.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	output = &GetDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSource API operation for Agents for Amazon Bedrock.
//
// Gets information about a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetDataSource
func (c *BedrockAgent) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	return out, req.Send()
}

// GetDataSourceWithContext is the same as GetDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetDataSourceWithContext(ctx aws.Context, input *GetDataSourceInput, opts ...request.Option) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIngestionJob = "GetIngestionJob"

// GetIngestionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetIngestionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIngestionJob for more information on using the GetIngestionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIngestionJobRequest method.
//	req, resp := client.GetIngestionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetIngestionJob
func (c *BedrockAgent) GetIngestionJobRequest(input *GetIngestionJobInput) (req *request.Request, output *GetIngestionJobOutput) {
	op := &request.Operation{
		Name:       opGetIngestionJob,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/{ingestionJobId}",
	}

	if input == nil {
		input = &GetIngestionJobInput{}
	}

	output = &GetIngestionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIngestionJob API operation for Agents for Amazon Bedrock.
//
// Gets information about a ingestion job, in which a data source is added to
// a knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetIngestionJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetIngestionJob
func (c *BedrockAgent) GetIngestionJob(input *GetIngestionJobInput) (*GetIngestionJobOutput, error) {
	req, out := c.GetIngestionJobRequest(input)
	return out, req.Send()
}

// GetIngestionJobWithContext is the same as GetIngestionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetIngestionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetIngestionJobWithContext(ctx aws.Context, input *GetIngestionJobInput, opts ...request.Option) (*GetIngestionJobOutput, error) {
	req, out := c.GetIngestionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKnowledgeBase = "GetKnowledgeBase"

// GetKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the GetKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKnowledgeBase for more information on using the GetKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKnowledgeBaseRequest method.
//	req, resp := client.GetKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetKnowledgeBase
func (c *BedrockAgent) GetKnowledgeBaseRequest(input *GetKnowledgeBaseInput) (req *request.Request, output *GetKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opGetKnowledgeBase,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &GetKnowledgeBaseInput{}
	}

	output = &GetKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Gets information about a knoweldge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetKnowledgeBase
func (c *BedrockAgent) GetKnowledgeBase(input *GetKnowledgeBaseInput) (*GetKnowledgeBaseOutput, error) {
	req, out := c.GetKnowledgeBaseRequest(input)
	return out, req.Send()
}

// GetKnowledgeBaseWithContext is the same as GetKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See GetKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetKnowledgeBaseWithContext(ctx aws.Context, input *GetKnowledgeBaseInput, opts ...request.Option) (*GetKnowledgeBaseOutput, error) {
	req, out := c.GetKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAgentActionGroups = "ListAgentActionGroups"

// ListAgentActionGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentActionGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentActionGroups for more information on using the ListAgentActionGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentActionGroupsRequest method.
//	req, resp := client.ListAgentActionGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups
func (c *BedrockAgent) ListAgentActionGroupsRequest(input *ListAgentActionGroupsInput) (req *request.Request, output *ListAgentActionGroupsOutput) {
	op := &request.Operation{
		Name:       opListAgentActionGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentActionGroupsInput{}
	}

	output = &ListAgentActionGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentActionGroups API operation for Agents for Amazon Bedrock.
//
// Lists the action groups for an agent and information about each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentActionGroups for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups
func (c *BedrockAgent) ListAgentActionGroups(input *ListAgentActionGroupsInput) (*ListAgentActionGroupsOutput, error) {
	req, out := c.ListAgentActionGroupsRequest(input)
	return out, req.Send()
}

// ListAgentActionGroupsWithContext is the same as ListAgentActionGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentActionGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentActionGroupsWithContext(ctx aws.Context, input *ListAgentActionGroupsInput, opts ...request.Option) (*ListAgentActionGroupsOutput, error) {
	req, out := c.ListAgentActionGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentActionGroupsPages iterates over the pages of a ListAgentActionGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentActionGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentActionGroups operation.
//	pageNum := 0
//	err := client.ListAgentActionGroupsPages(params,
//	    func(page *bedrockagent.ListAgentActionGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentActionGroupsPages(input *ListAgentActionGroupsInput, fn func(*ListAgentActionGroupsOutput, bool) bool) error {
	return c.ListAgentActionGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentActionGroupsPagesWithContext same as ListAgentActionGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentActionGroupsPagesWithContext(ctx aws.Context, input *ListAgentActionGroupsInput, fn func(*ListAgentActionGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentActionGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentActionGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentActionGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgentAliases = "ListAgentAliases"

// ListAgentAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentAliases for more information on using the ListAgentAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentAliasesRequest method.
//	req, resp := client.ListAgentAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases
func (c *BedrockAgent) ListAgentAliasesRequest(input *ListAgentAliasesInput) (req *request.Request, output *ListAgentAliasesOutput) {
	op := &request.Operation{
		Name:       opListAgentAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentaliases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentAliasesInput{}
	}

	output = &ListAgentAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentAliases API operation for Agents for Amazon Bedrock.
//
// Lists the aliases of an agent and information about each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentAliases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases
func (c *BedrockAgent) ListAgentAliases(input *ListAgentAliasesInput) (*ListAgentAliasesOutput, error) {
	req, out := c.ListAgentAliasesRequest(input)
	return out, req.Send()
}

// ListAgentAliasesWithContext is the same as ListAgentAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentAliasesWithContext(ctx aws.Context, input *ListAgentAliasesInput, opts ...request.Option) (*ListAgentAliasesOutput, error) {
	req, out := c.ListAgentAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentAliasesPages iterates over the pages of a ListAgentAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentAliases operation.
//	pageNum := 0
//	err := client.ListAgentAliasesPages(params,
//	    func(page *bedrockagent.ListAgentAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentAliasesPages(input *ListAgentAliasesInput, fn func(*ListAgentAliasesOutput, bool) bool) error {
	return c.ListAgentAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentAliasesPagesWithContext same as ListAgentAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentAliasesPagesWithContext(ctx aws.Context, input *ListAgentAliasesInput, fn func(*ListAgentAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgentKnowledgeBases = "ListAgentKnowledgeBases"

// ListAgentKnowledgeBasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentKnowledgeBases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentKnowledgeBases for more information on using the ListAgentKnowledgeBases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentKnowledgeBasesRequest method.
//	req, resp := client.ListAgentKnowledgeBasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases
func (c *BedrockAgent) ListAgentKnowledgeBasesRequest(input *ListAgentKnowledgeBasesInput) (req *request.Request, output *ListAgentKnowledgeBasesOutput) {
	op := &request.Operation{
		Name:       opListAgentKnowledgeBases,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentKnowledgeBasesInput{}
	}

	output = &ListAgentKnowledgeBasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentKnowledgeBases API operation for Agents for Amazon Bedrock.
//
// Lists knowledge bases associated with an agent and information about each
// one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentKnowledgeBases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases
func (c *BedrockAgent) ListAgentKnowledgeBases(input *ListAgentKnowledgeBasesInput) (*ListAgentKnowledgeBasesOutput, error) {
	req, out := c.ListAgentKnowledgeBasesRequest(input)
	return out, req.Send()
}

// ListAgentKnowledgeBasesWithContext is the same as ListAgentKnowledgeBases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentKnowledgeBases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentKnowledgeBasesWithContext(ctx aws.Context, input *ListAgentKnowledgeBasesInput, opts ...request.Option) (*ListAgentKnowledgeBasesOutput, error) {
	req, out := c.ListAgentKnowledgeBasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentKnowledgeBasesPages iterates over the pages of a ListAgentKnowledgeBases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentKnowledgeBases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentKnowledgeBases operation.
//	pageNum := 0
//	err := client.ListAgentKnowledgeBasesPages(params,
//	    func(page *bedrockagent.ListAgentKnowledgeBasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentKnowledgeBasesPages(input *ListAgentKnowledgeBasesInput, fn func(*ListAgentKnowledgeBasesOutput, bool) bool) error {
	return c.ListAgentKnowledgeBasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentKnowledgeBasesPagesWithContext same as ListAgentKnowledgeBasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentKnowledgeBasesPagesWithContext(ctx aws.Context, input *ListAgentKnowledgeBasesInput, fn func(*ListAgentKnowledgeBasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentKnowledgeBasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentKnowledgeBasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentKnowledgeBasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgentVersions = "ListAgentVersions"

// ListAgentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentVersions for more information on using the ListAgentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentVersionsRequest method.
//	req, resp := client.ListAgentVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions
func (c *BedrockAgent) ListAgentVersionsRequest(input *ListAgentVersionsInput) (req *request.Request, output *ListAgentVersionsOutput) {
	op := &request.Operation{
		Name:       opListAgentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentversions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentVersionsInput{}
	}

	output = &ListAgentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentVersions API operation for Agents for Amazon Bedrock.
//
// Lists the versions of an agent and information about each version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions
func (c *BedrockAgent) ListAgentVersions(input *ListAgentVersionsInput) (*ListAgentVersionsOutput, error) {
	req, out := c.ListAgentVersionsRequest(input)
	return out, req.Send()
}

// ListAgentVersionsWithContext is the same as ListAgentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentVersionsWithContext(ctx aws.Context, input *ListAgentVersionsInput, opts ...request.Option) (*ListAgentVersionsOutput, error) {
	req, out := c.ListAgentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentVersionsPages iterates over the pages of a ListAgentVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentVersions operation.
//	pageNum := 0
//	err := client.ListAgentVersionsPages(params,
//	    func(page *bedrockagent.ListAgentVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentVersionsPages(input *ListAgentVersionsInput, fn func(*ListAgentVersionsOutput, bool) bool) error {
	return c.ListAgentVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentVersionsPagesWithContext same as ListAgentVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentVersionsPagesWithContext(ctx aws.Context, input *ListAgentVersionsInput, fn func(*ListAgentVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgents = "ListAgents"

// ListAgentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgents for more information on using the ListAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentsRequest method.
//	req, resp := client.ListAgentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents
func (c *BedrockAgent) ListAgentsRequest(input *ListAgentsInput) (req *request.Request, output *ListAgentsOutput) {
	op := &request.Operation{
		Name:       opListAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentsInput{}
	}

	output = &ListAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgents API operation for Agents for Amazon Bedrock.
//
// Lists the agents belonging to an account and information about each agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents
func (c *BedrockAgent) ListAgents(input *ListAgentsInput) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	return out, req.Send()
}

// ListAgentsWithContext is the same as ListAgents with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentsWithContext(ctx aws.Context, input *ListAgentsInput, opts ...request.Option) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentsPages iterates over the pages of a ListAgents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgents operation.
//	pageNum := 0
//	err := client.ListAgentsPages(params,
//	    func(page *bedrockagent.ListAgentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentsPages(input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool) error {
	return c.ListAgentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentsPagesWithContext same as ListAgentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentsPagesWithContext(ctx aws.Context, input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourcesRequest method.
//	req, resp := client.ListDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources
func (c *BedrockAgent) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Agents for Amazon Bedrock.
//
// Lists the data sources in a knowledge base and information about each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources
func (c *BedrockAgent) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSources operation.
//	pageNum := 0
//	err := client.ListDataSourcesPages(params,
//	    func(page *bedrockagent.ListDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIngestionJobs = "ListIngestionJobs"

// ListIngestionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestionJobs for more information on using the ListIngestionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIngestionJobsRequest method.
//	req, resp := client.ListIngestionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs
func (c *BedrockAgent) ListIngestionJobsRequest(input *ListIngestionJobsInput) (req *request.Request, output *ListIngestionJobsOutput) {
	op := &request.Operation{
		Name:       opListIngestionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionJobsInput{}
	}

	output = &ListIngestionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestionJobs API operation for Agents for Amazon Bedrock.
//
// Lists the ingestion jobs for a data source and information about each of
// them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListIngestionJobs for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs
func (c *BedrockAgent) ListIngestionJobs(input *ListIngestionJobsInput) (*ListIngestionJobsOutput, error) {
	req, out := c.ListIngestionJobsRequest(input)
	return out, req.Send()
}

// ListIngestionJobsWithContext is the same as ListIngestionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListIngestionJobsWithContext(ctx aws.Context, input *ListIngestionJobsInput, opts ...request.Option) (*ListIngestionJobsOutput, error) {
	req, out := c.ListIngestionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionJobsPages iterates over the pages of a ListIngestionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIngestionJobs operation.
//	pageNum := 0
//	err := client.ListIngestionJobsPages(params,
//	    func(page *bedrockagent.ListIngestionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListIngestionJobsPages(input *ListIngestionJobsInput, fn func(*ListIngestionJobsOutput, bool) bool) error {
	return c.ListIngestionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionJobsPagesWithContext same as ListIngestionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListIngestionJobsPagesWithContext(ctx aws.Context, input *ListIngestionJobsInput, fn func(*ListIngestionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKnowledgeBases = "ListKnowledgeBases"

// ListKnowledgeBasesRequest generates a "aws/request.Request" representing the
// client's request for the ListKnowledgeBases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKnowledgeBases for more information on using the ListKnowledgeBases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKnowledgeBasesRequest method.
//	req, resp := client.ListKnowledgeBasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases
func (c *BedrockAgent) ListKnowledgeBasesRequest(input *ListKnowledgeBasesInput) (req *request.Request, output *ListKnowledgeBasesOutput) {
	op := &request.Operation{
		Name:       opListKnowledgeBases,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKnowledgeBasesInput{}
	}

	output = &ListKnowledgeBasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKnowledgeBases API operation for Agents for Amazon Bedrock.
//
// Lists the knowledge bases in an account and information about each of them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListKnowledgeBases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases
func (c *BedrockAgent) ListKnowledgeBases(input *ListKnowledgeBasesInput) (*ListKnowledgeBasesOutput, error) {
	req, out := c.ListKnowledgeBasesRequest(input)
	return out, req.Send()
}

// ListKnowledgeBasesWithContext is the same as ListKnowledgeBases with the addition of
// the ability to pass a context and additional request options.
//
// See ListKnowledgeBases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListKnowledgeBasesWithContext(ctx aws.Context, input *ListKnowledgeBasesInput, opts ...request.Option) (*ListKnowledgeBasesOutput, error) {
	req, out := c.ListKnowledgeBasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKnowledgeBasesPages iterates over the pages of a ListKnowledgeBases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKnowledgeBases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKnowledgeBases operation.
//	pageNum := 0
//	err := client.ListKnowledgeBasesPages(params,
//	    func(page *bedrockagent.ListKnowledgeBasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListKnowledgeBasesPages(input *ListKnowledgeBasesInput, fn func(*ListKnowledgeBasesOutput, bool) bool) error {
	return c.ListKnowledgeBasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKnowledgeBasesPagesWithContext same as ListKnowledgeBasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListKnowledgeBasesPagesWithContext(ctx aws.Context, input *ListKnowledgeBasesInput, fn func(*ListKnowledgeBasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKnowledgeBasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKnowledgeBasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKnowledgeBasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListTagsForResource
func (c *BedrockAgent) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Agents for Amazon Bedrock.
//
// List all the tags for the resource you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListTagsForResource
func (c *BedrockAgent) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPrepareAgent = "PrepareAgent"

// PrepareAgentRequest generates a "aws/request.Request" representing the
// client's request for the PrepareAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PrepareAgent for more information on using the PrepareAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PrepareAgentRequest method.
//	req, resp := client.PrepareAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareAgent
func (c *BedrockAgent) PrepareAgentRequest(input *PrepareAgentInput) (req *request.Request, output *PrepareAgentOutput) {
	op := &request.Operation{
		Name:       opPrepareAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &PrepareAgentInput{}
	}

	output = &PrepareAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PrepareAgent API operation for Agents for Amazon Bedrock.
//
// Creates a DRAFT version of the agent that can be used for internal testing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation PrepareAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareAgent
func (c *BedrockAgent) PrepareAgent(input *PrepareAgentInput) (*PrepareAgentOutput, error) {
	req, out := c.PrepareAgentRequest(input)
	return out, req.Send()
}

// PrepareAgentWithContext is the same as PrepareAgent with the addition of
// the ability to pass a context and additional request options.
//
// See PrepareAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) PrepareAgentWithContext(ctx aws.Context, input *PrepareAgentInput, opts ...request.Option) (*PrepareAgentOutput, error) {
	req, out := c.PrepareAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartIngestionJob = "StartIngestionJob"

// StartIngestionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartIngestionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartIngestionJob for more information on using the StartIngestionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartIngestionJobRequest method.
//	req, resp := client.StartIngestionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/StartIngestionJob
func (c *BedrockAgent) StartIngestionJobRequest(input *StartIngestionJobInput) (req *request.Request, output *StartIngestionJobOutput) {
	op := &request.Operation{
		Name:       opStartIngestionJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/",
	}

	if input == nil {
		input = &StartIngestionJobInput{}
	}

	output = &StartIngestionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartIngestionJob API operation for Agents for Amazon Bedrock.
//
// Begins an ingestion job, in which a data source is added to a knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation StartIngestionJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/StartIngestionJob
func (c *BedrockAgent) StartIngestionJob(input *StartIngestionJobInput) (*StartIngestionJobOutput, error) {
	req, out := c.StartIngestionJobRequest(input)
	return out, req.Send()
}

// StartIngestionJobWithContext is the same as StartIngestionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartIngestionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) StartIngestionJobWithContext(ctx aws.Context, input *StartIngestionJobInput, opts ...request.Option) (*StartIngestionJobOutput, error) {
	req, out := c.StartIngestionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/TagResource
func (c *BedrockAgent) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Agents for Amazon Bedrock.
//
// Associate tags with a resource. For more information, see Tagging resources
// (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/TagResource
func (c *BedrockAgent) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UntagResource
func (c *BedrockAgent) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Agents for Amazon Bedrock.
//
// Remove tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UntagResource
func (c *BedrockAgent) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgent = "UpdateAgent"

// UpdateAgentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgent for more information on using the UpdateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentRequest method.
//	req, resp := client.UpdateAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgent
func (c *BedrockAgent) UpdateAgentRequest(input *UpdateAgentInput) (req *request.Request, output *UpdateAgentOutput) {
	op := &request.Operation{
		Name:       opUpdateAgent,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &UpdateAgentInput{}
	}

	output = &UpdateAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgent API operation for Agents for Amazon Bedrock.
//
// Updates the configuration of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgent
func (c *BedrockAgent) UpdateAgent(input *UpdateAgentInput) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	return out, req.Send()
}

// UpdateAgentWithContext is the same as UpdateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentWithContext(ctx aws.Context, input *UpdateAgentInput, opts ...request.Option) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgentActionGroup = "UpdateAgentActionGroup"

// UpdateAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgentActionGroup for more information on using the UpdateAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentActionGroupRequest method.
//	req, resp := client.UpdateAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentActionGroup
func (c *BedrockAgent) UpdateAgentActionGroupRequest(input *UpdateAgentActionGroupInput) (req *request.Request, output *UpdateAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateAgentActionGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
	}

	if input == nil {
		input = &UpdateAgentActionGroupInput{}
	}

	output = &UpdateAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Updates the configuration for an action group for an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentActionGroup
func (c *BedrockAgent) UpdateAgentActionGroup(input *UpdateAgentActionGroupInput) (*UpdateAgentActionGroupOutput, error) {
	req, out := c.UpdateAgentActionGroupRequest(input)
	return out, req.Send()
}

// UpdateAgentActionGroupWithContext is the same as UpdateAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentActionGroupWithContext(ctx aws.Context, input *UpdateAgentActionGroupInput, opts ...request.Option) (*UpdateAgentActionGroupOutput, error) {
	req, out := c.UpdateAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgentAlias = "UpdateAgentAlias"

// UpdateAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgentAlias for more information on using the UpdateAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentAliasRequest method.
//	req, resp := client.UpdateAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentAlias
func (c *BedrockAgent) UpdateAgentAliasRequest(input *UpdateAgentAliasInput) (req *request.Request, output *UpdateAgentAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAgentAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentaliases/{agentAliasId}/",
	}

	if input == nil {
		input = &UpdateAgentAliasInput{}
	}

	output = &UpdateAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgentAlias API operation for Agents for Amazon Bedrock.
//
// Updates configurations for an alias of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentAlias
func (c *BedrockAgent) UpdateAgentAlias(input *UpdateAgentAliasInput) (*UpdateAgentAliasOutput, error) {
	req, out := c.UpdateAgentAliasRequest(input)
	return out, req.Send()
}

// UpdateAgentAliasWithContext is the same as UpdateAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentAliasWithContext(ctx aws.Context, input *UpdateAgentAliasInput, opts ...request.Option) (*UpdateAgentAliasOutput, error) {
	req, out := c.UpdateAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgentKnowledgeBase = "UpdateAgentKnowledgeBase"

// UpdateAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgentKnowledgeBase for more information on using the UpdateAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentKnowledgeBaseRequest method.
//	req, resp := client.UpdateAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentKnowledgeBase
func (c *BedrockAgent) UpdateAgentKnowledgeBaseRequest(input *UpdateAgentKnowledgeBaseInput) (req *request.Request, output *UpdateAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opUpdateAgentKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
	}

	if input == nil {
		input = &UpdateAgentKnowledgeBaseInput{}
	}

	output = &UpdateAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Updates the configuration for a knowledge base that has been associated with
// an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentKnowledgeBase
func (c *BedrockAgent) UpdateAgentKnowledgeBase(input *UpdateAgentKnowledgeBaseInput) (*UpdateAgentKnowledgeBaseOutput, error) {
	req, out := c.UpdateAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// UpdateAgentKnowledgeBaseWithContext is the same as UpdateAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentKnowledgeBaseWithContext(ctx aws.Context, input *UpdateAgentKnowledgeBaseInput, opts ...request.Option) (*UpdateAgentKnowledgeBaseOutput, error) {
	req, out := c.UpdateAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourceRequest method.
//	req, resp := client.UpdateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateDataSource
func (c *BedrockAgent) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Agents for Amazon Bedrock.
//
// Updates configurations for a data source.
//
// You can't change the chunkingConfiguration after you create the data source.
// Specify the existing chunkingConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateDataSource
func (c *BedrockAgent) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKnowledgeBase = "UpdateKnowledgeBase"

// UpdateKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKnowledgeBase for more information on using the UpdateKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKnowledgeBaseRequest method.
//	req, resp := client.UpdateKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateKnowledgeBase
func (c *BedrockAgent) UpdateKnowledgeBaseRequest(input *UpdateKnowledgeBaseInput) (req *request.Request, output *UpdateKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opUpdateKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &UpdateKnowledgeBaseInput{}
	}

	output = &UpdateKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Updates the configuration of a knowledge base with the fields that you specify.
// Because all fields will be overwritten, you must include the same values
// for fields that you want to keep the same.
//
// You can change the following fields:
//
//   - name
//
//   - description
//
//   - roleArn
//
// You can't change the knowledgeBaseConfiguration or storageConfiguration fields,
// so you must specify the same configurations as when you created the knowledge
// base. You can send a GetKnowledgeBase (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetKnowledgeBase.html)
// request and copy the same configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateKnowledgeBase
func (c *BedrockAgent) UpdateKnowledgeBase(input *UpdateKnowledgeBaseInput) (*UpdateKnowledgeBaseOutput, error) {
	req, out := c.UpdateKnowledgeBaseRequest(input)
	return out, req.Send()
}

// UpdateKnowledgeBaseWithContext is the same as UpdateKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateKnowledgeBaseWithContext(ctx aws.Context, input *UpdateKnowledgeBaseInput, opts ...request.Option) (*UpdateKnowledgeBaseOutput, error) {
	req, out := c.UpdateKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains details about the OpenAPI schema for the action group. For more
// information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
// You can either include the schema directly in the payload field or you can
// upload it to an S3 bucket and specify the S3 bucket location in the s3 field.
type APISchema struct {
	_ struct{} `type:"structure"`

	// The JSON or YAML-formatted payload defining the OpenAPI schema for the action
	// group. For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	//
	// Payload is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by APISchema's
	// String and GoString methods.
	Payload *string `locationName:"payload" type:"string" sensitive:"true"`

	// Contains details about the S3 object containing the OpenAPI schema for the
	// action group. For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	S3 *S3Identifier `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APISchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APISchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *APISchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "APISchema"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayload sets the Payload field's value.
func (s *APISchema) SetPayload(v string) *APISchema {
	s.Payload = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *APISchema) SetS3(v *S3Identifier) *APISchema {
	s.S3 = v
	return s
}

// The request is denied because of missing access permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about the Lambda function containing the business logic
// that is carried out upon invoking the action.
type ActionGroupExecutor struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action.
	Lambda *string `locationName:"lambda" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupExecutor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupExecutor) GoString() string {
	return s.String()
}

// SetLambda sets the Lambda field's value.
func (s *ActionGroupExecutor) SetLambda(v string) *ActionGroupExecutor {
	s.Lambda = &v
	return s
}

// Contains details about an action group.
type ActionGroupSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the action group.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `locationName:"actionGroupId" type:"string" required:"true"`

	// The name of the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// ActionGroupState is a required field
	ActionGroupState *string `locationName:"actionGroupState" type:"string" required:"true" enum:"ActionGroupState"`

	// The description of the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The time at which the action group was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupSummary) GoString() string {
	return s.String()
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *ActionGroupSummary) SetActionGroupId(v string) *ActionGroupSummary {
	s.ActionGroupId = &v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *ActionGroupSummary) SetActionGroupName(v string) *ActionGroupSummary {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *ActionGroupSummary) SetActionGroupState(v string) *ActionGroupSummary {
	s.ActionGroupState = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActionGroupSummary) SetDescription(v string) *ActionGroupSummary {
	s.Description = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ActionGroupSummary) SetUpdatedAt(v time.Time) *ActionGroupSummary {
	s.UpdatedAt = &v
	return s
}

// Contains details about an agent.
type Agent struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent.
	//
	// AgentArn is a required field
	AgentArn *string `locationName:"agentArn" type:"string" required:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The name of the agent.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	//
	// AgentResourceRoleArn is a required field
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string" required:"true"`

	// The status of the agent and whether it is ready for use. The following statuses
	// are possible:
	//
	//    * CREATING – The agent is being created.
	//
	//    * PREPARING – The agent is being prepared.
	//
	//    * PREPARED – The agent is prepared and ready to be invoked.
	//
	//    * NOT_PREPARED – The agent has been created but not yet prepared.
	//
	//    * FAILED – The agent API operation failed.
	//
	//    * UPDATING – The agent is being updated.
	//
	//    * DELETING – The agent is being deleted.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string"`

	// The time at which the agent was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains reasons that the agent-related API that you invoked failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The foundation model used for orchestration by the agent.
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	//
	// IdleSessionTTLInSeconds is a required field
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer" required:"true"`

	// Instructions that tell the agent what it should do and how it should interact
	// with users.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Agent's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// The time at which the agent was last prepared.
	PreparedAt *time.Time `locationName:"preparedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Contains configurations to override prompt templates in different parts of
	// an agent sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Agent's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`

	// Contains recommended actions to take for the agent-related API that you invoked
	// to succeed.
	RecommendedActions []*string `locationName:"recommendedActions" type:"list"`

	// The time at which the agent was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Agent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Agent) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *Agent) SetAgentArn(v string) *Agent {
	s.AgentArn = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *Agent) SetAgentId(v string) *Agent {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *Agent) SetAgentName(v string) *Agent {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *Agent) SetAgentResourceRoleArn(v string) *Agent {
	s.AgentResourceRoleArn = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *Agent) SetAgentStatus(v string) *Agent {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *Agent) SetAgentVersion(v string) *Agent {
	s.AgentVersion = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *Agent) SetClientToken(v string) *Agent {
	s.ClientToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Agent) SetCreatedAt(v time.Time) *Agent {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *Agent) SetCustomerEncryptionKeyArn(v string) *Agent {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Agent) SetDescription(v string) *Agent {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *Agent) SetFailureReasons(v []*string) *Agent {
	s.FailureReasons = v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *Agent) SetFoundationModel(v string) *Agent {
	s.FoundationModel = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *Agent) SetIdleSessionTTLInSeconds(v int64) *Agent {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *Agent) SetInstruction(v string) *Agent {
	s.Instruction = &v
	return s
}

// SetPreparedAt sets the PreparedAt field's value.
func (s *Agent) SetPreparedAt(v time.Time) *Agent {
	s.PreparedAt = &v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *Agent) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *Agent {
	s.PromptOverrideConfiguration = v
	return s
}

// SetRecommendedActions sets the RecommendedActions field's value.
func (s *Agent) SetRecommendedActions(v []*string) *Agent {
	s.RecommendedActions = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Agent) SetUpdatedAt(v time.Time) *Agent {
	s.UpdatedAt = &v
	return s
}

// Contains details about an action group.
type AgentActionGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action.
	ActionGroupExecutor *ActionGroupExecutor `locationName:"actionGroupExecutor" type:"structure"`

	// The unique identifier of the action group.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `locationName:"actionGroupId" type:"string" required:"true"`

	// The name of the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// ActionGroupState is a required field
	ActionGroupState *string `locationName:"actionGroupState" type:"string" required:"true" enum:"ActionGroupState"`

	// The unique identifier of the agent to which the action group belongs.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The version of the agent to which the action group belongs.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// Contains either details about the S3 object containing the OpenAPI schema
	// for the action group or the JSON or YAML-formatted payload defining the schema.
	// For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	ApiSchema *APISchema `locationName:"apiSchema" type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string"`

	// The time at which the action group was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// If this field is set as AMAZON.UserInput, the agent can request the user
	// for additional information when trying to complete a task. The description,
	// apiSchema, and actionGroupExecutor fields must be blank for this action group.
	//
	// During orchestration, if the agent determines that it needs to invoke an
	// API in an action group, but doesn't have enough information to complete the
	// API request, it will invoke this action group instead and return an Observation
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
	// reprompting the user for more information.
	ParentActionSignature *string `locationName:"parentActionSignature" type:"string" enum:"ActionGroupSignature"`

	// The time at which the action group was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentActionGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentActionGroup) GoString() string {
	return s.String()
}

// SetActionGroupExecutor sets the ActionGroupExecutor field's value.
func (s *AgentActionGroup) SetActionGroupExecutor(v *ActionGroupExecutor) *AgentActionGroup {
	s.ActionGroupExecutor = v
	return s
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *AgentActionGroup) SetActionGroupId(v string) *AgentActionGroup {
	s.ActionGroupId = &v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *AgentActionGroup) SetActionGroupName(v string) *AgentActionGroup {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *AgentActionGroup) SetActionGroupState(v string) *AgentActionGroup {
	s.ActionGroupState = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AgentActionGroup) SetAgentId(v string) *AgentActionGroup {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentActionGroup) SetAgentVersion(v string) *AgentActionGroup {
	s.AgentVersion = &v
	return s
}

// SetApiSchema sets the ApiSchema field's value.
func (s *AgentActionGroup) SetApiSchema(v *APISchema) *AgentActionGroup {
	s.ApiSchema = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AgentActionGroup) SetClientToken(v string) *AgentActionGroup {
	s.ClientToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentActionGroup) SetCreatedAt(v time.Time) *AgentActionGroup {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentActionGroup) SetDescription(v string) *AgentActionGroup {
	s.Description = &v
	return s
}

// SetParentActionSignature sets the ParentActionSignature field's value.
func (s *AgentActionGroup) SetParentActionSignature(v string) *AgentActionGroup {
	s.ParentActionSignature = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentActionGroup) SetUpdatedAt(v time.Time) *AgentActionGroup {
	s.UpdatedAt = &v
	return s
}

// Contains details about an alias of an agent.
type AgentAlias struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alias of the agent.
	//
	// AgentAliasArn is a required field
	AgentAliasArn *string `locationName:"agentAliasArn" type:"string" required:"true"`

	// Contains details about the history of the alias.
	AgentAliasHistoryEvents []*AgentAliasHistoryEvent `locationName:"agentAliasHistoryEvents" type:"list"`

	// The unique identifier of the alias of the agent.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The name of the alias of the agent.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The status of the alias of the agent and whether it is ready for use. The
	// following statuses are possible:
	//
	//    * CREATING – The agent alias is being created.
	//
	//    * PREPARED – The agent alias is finished being created or updated and
	//    is ready to be invoked.
	//
	//    * FAILED – The agent alias API operation failed.
	//
	//    * UPDATING – The agent alias is being updated.
	//
	//    * DELETING – The agent alias is being deleted.
	//
	// AgentAliasStatus is a required field
	AgentAliasStatus *string `locationName:"agentAliasStatus" type:"string" required:"true" enum:"AgentAliasStatus"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string"`

	// The time at which the alias of the agent was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the alias of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the routing configuration of the alias.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list" required:"true"`

	// The time at which the alias was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAlias) GoString() string {
	return s.String()
}

// SetAgentAliasArn sets the AgentAliasArn field's value.
func (s *AgentAlias) SetAgentAliasArn(v string) *AgentAlias {
	s.AgentAliasArn = &v
	return s
}

// SetAgentAliasHistoryEvents sets the AgentAliasHistoryEvents field's value.
func (s *AgentAlias) SetAgentAliasHistoryEvents(v []*AgentAliasHistoryEvent) *AgentAlias {
	s.AgentAliasHistoryEvents = v
	return s
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *AgentAlias) SetAgentAliasId(v string) *AgentAlias {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *AgentAlias) SetAgentAliasName(v string) *AgentAlias {
	s.AgentAliasName = &v
	return s
}

// SetAgentAliasStatus sets the AgentAliasStatus field's value.
func (s *AgentAlias) SetAgentAliasStatus(v string) *AgentAlias {
	s.AgentAliasStatus = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AgentAlias) SetAgentId(v string) *AgentAlias {
	s.AgentId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AgentAlias) SetClientToken(v string) *AgentAlias {
	s.ClientToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentAlias) SetCreatedAt(v time.Time) *AgentAlias {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentAlias) SetDescription(v string) *AgentAlias {
	s.Description = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *AgentAlias) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *AgentAlias {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentAlias) SetUpdatedAt(v time.Time) *AgentAlias {
	s.UpdatedAt = &v
	return s
}

// Contains details about the history of the alias.
type AgentAliasHistoryEvent struct {
	_ struct{} `type:"structure"`

	// The date that the alias stopped being associated to the version in the routingConfiguration
	// object
	EndDate *time.Time `locationName:"endDate" type:"timestamp" timestampFormat:"iso8601"`

	// Contains details about the version of the agent with which the alias is associated.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`

	// The date that the alias began being associated to the version in the routingConfiguration
	// object.
	StartDate *time.Time `locationName:"startDate" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasHistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasHistoryEvent) GoString() string {
	return s.String()
}

// SetEndDate sets the EndDate field's value.
func (s *AgentAliasHistoryEvent) SetEndDate(v time.Time) *AgentAliasHistoryEvent {
	s.EndDate = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *AgentAliasHistoryEvent) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *AgentAliasHistoryEvent {
	s.RoutingConfiguration = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *AgentAliasHistoryEvent) SetStartDate(v time.Time) *AgentAliasHistoryEvent {
	s.StartDate = &v
	return s
}

// Contains details about the routing configuration of the alias.
type AgentAliasRoutingConfigurationListItem struct {
	_ struct{} `type:"structure"`

	// The version of the agent with which the alias is associated.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasRoutingConfigurationListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasRoutingConfigurationListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentAliasRoutingConfigurationListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AgentAliasRoutingConfigurationListItem"}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentAliasRoutingConfigurationListItem) SetAgentVersion(v string) *AgentAliasRoutingConfigurationListItem {
	s.AgentVersion = &v
	return s
}

// Contains details about an alias of an agent.
type AgentAliasSummary struct {
	_ struct{} `type:"structure"`

	// Contains details about
	//
	// AgentAliasId is a required field
	AgentAliasId *string `locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The name of the alias.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The status of the alias.
	//
	// AgentAliasStatus is a required field
	AgentAliasStatus *string `locationName:"agentAliasStatus" type:"string" required:"true" enum:"AgentAliasStatus"`

	// The time at which the alias of the agent was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the version of the agent with which the alias is associated.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`

	// The time at which the alias was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasSummary) GoString() string {
	return s.String()
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *AgentAliasSummary) SetAgentAliasId(v string) *AgentAliasSummary {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *AgentAliasSummary) SetAgentAliasName(v string) *AgentAliasSummary {
	s.AgentAliasName = &v
	return s
}

// SetAgentAliasStatus sets the AgentAliasStatus field's value.
func (s *AgentAliasSummary) SetAgentAliasStatus(v string) *AgentAliasSummary {
	s.AgentAliasStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentAliasSummary) SetCreatedAt(v time.Time) *AgentAliasSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentAliasSummary) SetDescription(v string) *AgentAliasSummary {
	s.Description = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *AgentAliasSummary) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *AgentAliasSummary {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentAliasSummary) SetUpdatedAt(v time.Time) *AgentAliasSummary {
	s.UpdatedAt = &v
	return s
}

// Contains details about a knowledge base that is associated with an agent.
type AgentKnowledgeBase struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent with which the knowledge base is associated.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The version of the agent with which the knowledge base is associated.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The time at which the association between the agent and the knowledge base
	// was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the association between the agent and the knowledge base.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The unique identifier of the association between the agent and the knowledge
	// base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether to use the knowledge base or not when sending an InvokeAgent
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// KnowledgeBaseState is a required field
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" required:"true" enum:"KnowledgeBaseState"`

	// The time at which the association between the agent and the knowledge base
	// was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBase) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentKnowledgeBase) SetAgentId(v string) *AgentKnowledgeBase {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentKnowledgeBase) SetAgentVersion(v string) *AgentKnowledgeBase {
	s.AgentVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentKnowledgeBase) SetCreatedAt(v time.Time) *AgentKnowledgeBase {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentKnowledgeBase) SetDescription(v string) *AgentKnowledgeBase {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *AgentKnowledgeBase) SetKnowledgeBaseId(v string) *AgentKnowledgeBase {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *AgentKnowledgeBase) SetKnowledgeBaseState(v string) *AgentKnowledgeBase {
	s.KnowledgeBaseState = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentKnowledgeBase) SetUpdatedAt(v time.Time) *AgentKnowledgeBase {
	s.UpdatedAt = &v
	return s
}

// Contains details about a knowledge base associated with an agent.
type AgentKnowledgeBaseSummary struct {
	_ struct{} `type:"structure"`

	// The description of the knowledge base associated with an agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base associated with an agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether the agent uses the knowledge base or not when sending an
	// InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// KnowledgeBaseState is a required field
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" required:"true" enum:"KnowledgeBaseState"`

	// The time at which the knowledge base associated with an agent was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBaseSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AgentKnowledgeBaseSummary) SetDescription(v string) *AgentKnowledgeBaseSummary {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *AgentKnowledgeBaseSummary) SetKnowledgeBaseId(v string) *AgentKnowledgeBaseSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *AgentKnowledgeBaseSummary) SetKnowledgeBaseState(v string) *AgentKnowledgeBaseSummary {
	s.KnowledgeBaseState = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentKnowledgeBaseSummary) SetUpdatedAt(v time.Time) *AgentKnowledgeBaseSummary {
	s.UpdatedAt = &v
	return s
}

// Contains details about an agent.
type AgentSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The name of the agent.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The status of the agent.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The latest version of the agent.
	LatestAgentVersion *string `locationName:"latestAgentVersion" min:"1" type:"string"`

	// The time at which the agent was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentSummary) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentSummary) SetAgentId(v string) *AgentSummary {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *AgentSummary) SetAgentName(v string) *AgentSummary {
	s.AgentName = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *AgentSummary) SetAgentStatus(v string) *AgentSummary {
	s.AgentStatus = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentSummary) SetDescription(v string) *AgentSummary {
	s.Description = &v
	return s
}

// SetLatestAgentVersion sets the LatestAgentVersion field's value.
func (s *AgentSummary) SetLatestAgentVersion(v string) *AgentSummary {
	s.LatestAgentVersion = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentSummary) SetUpdatedAt(v time.Time) *AgentSummary {
	s.UpdatedAt = &v
	return s
}

// Contains details about a version of an agent.
type AgentVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent that the version belongs to.
	//
	// AgentArn is a required field
	AgentArn *string `locationName:"agentArn" type:"string" required:"true"`

	// The unique identifier of the agent that the version belongs to.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The name of the agent that the version belongs to.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	//
	// AgentResourceRoleArn is a required field
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string" required:"true"`

	// The status of the agent that the version belongs to.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The time at which the version was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The description of the version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A list of reasons that the API operation on the version failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The foundation model that the version invokes.
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	//
	// IdleSessionTTLInSeconds is a required field
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer" required:"true"`

	// The instructions provided to the agent.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AgentVersion's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// Contains configurations to override prompt templates in different parts of
	// an agent sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AgentVersion's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`

	// A list of recommended actions to take for the failed API operation on the
	// version to succeed.
	RecommendedActions []*string `locationName:"recommendedActions" type:"list"`

	// The time at which the version was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version number.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersion) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *AgentVersion) SetAgentArn(v string) *AgentVersion {
	s.AgentArn = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AgentVersion) SetAgentId(v string) *AgentVersion {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *AgentVersion) SetAgentName(v string) *AgentVersion {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *AgentVersion) SetAgentResourceRoleArn(v string) *AgentVersion {
	s.AgentResourceRoleArn = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *AgentVersion) SetAgentStatus(v string) *AgentVersion {
	s.AgentStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentVersion) SetCreatedAt(v time.Time) *AgentVersion {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *AgentVersion) SetCustomerEncryptionKeyArn(v string) *AgentVersion {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentVersion) SetDescription(v string) *AgentVersion {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *AgentVersion) SetFailureReasons(v []*string) *AgentVersion {
	s.FailureReasons = v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *AgentVersion) SetFoundationModel(v string) *AgentVersion {
	s.FoundationModel = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *AgentVersion) SetIdleSessionTTLInSeconds(v int64) *AgentVersion {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *AgentVersion) SetInstruction(v string) *AgentVersion {
	s.Instruction = &v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *AgentVersion) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *AgentVersion {
	s.PromptOverrideConfiguration = v
	return s
}

// SetRecommendedActions sets the RecommendedActions field's value.
func (s *AgentVersion) SetRecommendedActions(v []*string) *AgentVersion {
	s.RecommendedActions = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentVersion) SetUpdatedAt(v time.Time) *AgentVersion {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AgentVersion) SetVersion(v string) *AgentVersion {
	s.Version = &v
	return s
}

// Contains details about a version of an agent.
type AgentVersionSummary struct {
	_ struct{} `type:"structure"`

	// The name of the agent to which the version belongs.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The status of the agent to which the version belongs.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The time at which the version was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the version of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The time at which the version was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersionSummary) GoString() string {
	return s.String()
}

// SetAgentName sets the AgentName field's value.
func (s *AgentVersionSummary) SetAgentName(v string) *AgentVersionSummary {
	s.AgentName = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *AgentVersionSummary) SetAgentStatus(v string) *AgentVersionSummary {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentVersionSummary) SetAgentVersion(v string) *AgentVersionSummary {
	s.AgentVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentVersionSummary) SetCreatedAt(v time.Time) *AgentVersionSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentVersionSummary) SetDescription(v string) *AgentVersionSummary {
	s.Description = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentVersionSummary) SetUpdatedAt(v time.Time) *AgentVersionSummary {
	s.UpdatedAt = &v
	return s
}

type AssociateAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent with which you want to associate the knowledge
	// base.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent with which you want to associate the knowledge base.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// A description of what the agent should use the knowledge base for.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The unique identifier of the knowledge base to associate with the agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether to use the knowledge base or not when sending an InvokeAgent
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" enum:"KnowledgeBaseState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetAgentId(v string) *AssociateAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetAgentVersion(v string) *AssociateAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetDescription(v string) *AssociateAgentKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *AssociateAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetKnowledgeBaseState(v string) *AssociateAgentKnowledgeBaseInput {
	s.KnowledgeBaseState = &v
	return s
}

type AssociateAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base that has been associated with the
	// agent.
	//
	// AgentKnowledgeBase is a required field
	AgentKnowledgeBase *AgentKnowledgeBase `locationName:"agentKnowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBase sets the AgentKnowledgeBase field's value.
func (s *AssociateAgentKnowledgeBaseOutput) SetAgentKnowledgeBase(v *AgentKnowledgeBase) *AssociateAgentKnowledgeBaseOutput {
	s.AgentKnowledgeBase = v
	return s
}

// Details about how to chunk the documents in the data source. A chunk refers
// to an excerpt from a data source that is returned when the knowledge base
// that it belongs to is queried.
type ChunkingConfiguration struct {
	_ struct{} `type:"structure"`

	// Knowledge base can split your source data into chunks. A chunk refers to
	// an excerpt from a data source that is returned when the knowledge base that
	// it belongs to is queried. You have the following options for chunking your
	// data. If you opt for NONE, then you may want to pre-process your files by
	// splitting them up such that each file corresponds to a chunk.
	//
	//    * FIXED_SIZE – Amazon Bedrock splits your source data into chunks of
	//    the approximate size that you set in the fixedSizeChunkingConfiguration.
	//
	//    * NONE – Amazon Bedrock treats each file as one chunk. If you choose
	//    this option, you may want to pre-process your documents by splitting them
	//    into separate files.
	//
	// ChunkingStrategy is a required field
	ChunkingStrategy *string `locationName:"chunkingStrategy" type:"string" required:"true" enum:"ChunkingStrategy"`

	// Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy
	// as NONE, exclude this field.
	FixedSizeChunkingConfiguration *FixedSizeChunkingConfiguration `locationName:"fixedSizeChunkingConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChunkingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChunkingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChunkingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChunkingConfiguration"}
	if s.ChunkingStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("ChunkingStrategy"))
	}
	if s.FixedSizeChunkingConfiguration != nil {
		if err := s.FixedSizeChunkingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FixedSizeChunkingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChunkingStrategy sets the ChunkingStrategy field's value.
func (s *ChunkingConfiguration) SetChunkingStrategy(v string) *ChunkingConfiguration {
	s.ChunkingStrategy = &v
	return s
}

// SetFixedSizeChunkingConfiguration sets the FixedSizeChunkingConfiguration field's value.
func (s *ChunkingConfiguration) SetFixedSizeChunkingConfiguration(v *FixedSizeChunkingConfiguration) *ChunkingConfiguration {
	s.FixedSizeChunkingConfiguration = v
	return s
}

// There was a conflict performing an operation.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAgentActionGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action.
	ActionGroupExecutor *ActionGroupExecutor `locationName:"actionGroupExecutor" type:"structure"`

	// The name to give the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	ActionGroupState *string `locationName:"actionGroupState" type:"string" enum:"ActionGroupState"`

	// The unique identifier of the agent for which to create the action group.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent for which to create the action group.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// Contains either details about the S3 object containing the OpenAPI schema
	// for the action group or the JSON or YAML-formatted payload defining the schema.
	// For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	ApiSchema *APISchema `locationName:"apiSchema" type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description of the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// To allow your agent to request the user for additional information when trying
	// to complete a task, set this field to AMAZON.UserInput. You must leave the
	// description, apiSchema, and actionGroupExecutor fields blank for this action
	// group.
	//
	// During orchestration, if your agent determines that it needs to invoke an
	// API in an action group, but doesn't have enough information to complete the
	// API request, it will invoke this action group instead and return an Observation
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
	// reprompting the user for more information.
	ParentActionGroupSignature *string `locationName:"parentActionGroupSignature" type:"string" enum:"ActionGroupSignature"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentActionGroupInput"}
	if s.ActionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ApiSchema != nil {
		if err := s.ApiSchema.Validate(); err != nil {
			invalidParams.AddNested("ApiSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupExecutor sets the ActionGroupExecutor field's value.
func (s *CreateAgentActionGroupInput) SetActionGroupExecutor(v *ActionGroupExecutor) *CreateAgentActionGroupInput {
	s.ActionGroupExecutor = v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *CreateAgentActionGroupInput) SetActionGroupName(v string) *CreateAgentActionGroupInput {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *CreateAgentActionGroupInput) SetActionGroupState(v string) *CreateAgentActionGroupInput {
	s.ActionGroupState = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *CreateAgentActionGroupInput) SetAgentId(v string) *CreateAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *CreateAgentActionGroupInput) SetAgentVersion(v string) *CreateAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

// SetApiSchema sets the ApiSchema field's value.
func (s *CreateAgentActionGroupInput) SetApiSchema(v *APISchema) *CreateAgentActionGroupInput {
	s.ApiSchema = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAgentActionGroupInput) SetClientToken(v string) *CreateAgentActionGroupInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAgentActionGroupInput) SetDescription(v string) *CreateAgentActionGroupInput {
	s.Description = &v
	return s
}

// SetParentActionGroupSignature sets the ParentActionGroupSignature field's value.
func (s *CreateAgentActionGroupInput) SetParentActionGroupSignature(v string) *CreateAgentActionGroupInput {
	s.ParentActionGroupSignature = &v
	return s
}

type CreateAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the action group that was created.
	//
	// AgentActionGroup is a required field
	AgentActionGroup *AgentActionGroup `locationName:"agentActionGroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupOutput) GoString() string {
	return s.String()
}

// SetAgentActionGroup sets the AgentActionGroup field's value.
func (s *CreateAgentActionGroupOutput) SetAgentActionGroup(v *AgentActionGroup) *CreateAgentActionGroupOutput {
	s.AgentActionGroup = v
	return s
}

type CreateAgentAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the alias.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description of the alias of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the routing configuration of the alias.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`

	// Any tags that you want to attach to the alias of the agent.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentAliasInput"}
	if s.AgentAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoutingConfiguration != nil {
		for i, v := range s.RoutingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *CreateAgentAliasInput) SetAgentAliasName(v string) *CreateAgentAliasInput {
	s.AgentAliasName = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *CreateAgentAliasInput) SetAgentId(v string) *CreateAgentAliasInput {
	s.AgentId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAgentAliasInput) SetClientToken(v string) *CreateAgentAliasInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAgentAliasInput) SetDescription(v string) *CreateAgentAliasInput {
	s.Description = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *CreateAgentAliasInput) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *CreateAgentAliasInput {
	s.RoutingConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAgentAliasInput) SetTags(v map[string]*string) *CreateAgentAliasInput {
	s.Tags = v
	return s
}

type CreateAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the alias that was created.
	//
	// AgentAlias is a required field
	AgentAlias *AgentAlias `locationName:"agentAlias" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAlias sets the AgentAlias field's value.
func (s *CreateAgentAliasOutput) SetAgentAlias(v *AgentAlias) *CreateAgentAliasOutput {
	s.AgentAlias = v
	return s
}

type CreateAgentInput struct {
	_ struct{} `type:"structure"`

	// A name for the agent that you create.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// A description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The foundation model to be used for orchestration by the agent you create.
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// Instructions that tell the agent what it should do and how it should interact
	// with users.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAgentInput's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// Contains configurations to override prompts in different parts of an agent
	// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAgentInput's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`

	// Any tags that you want to attach to the agent.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentInput"}
	if s.AgentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentName"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FoundationModel != nil && len(*s.FoundationModel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FoundationModel", 1))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.Instruction != nil && len(*s.Instruction) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("Instruction", 40))
	}
	if s.PromptOverrideConfiguration != nil {
		if err := s.PromptOverrideConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PromptOverrideConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentName sets the AgentName field's value.
func (s *CreateAgentInput) SetAgentName(v string) *CreateAgentInput {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *CreateAgentInput) SetAgentResourceRoleArn(v string) *CreateAgentInput {
	s.AgentResourceRoleArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAgentInput) SetClientToken(v string) *CreateAgentInput {
	s.ClientToken = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreateAgentInput) SetCustomerEncryptionKeyArn(v string) *CreateAgentInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAgentInput) SetDescription(v string) *CreateAgentInput {
	s.Description = &v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *CreateAgentInput) SetFoundationModel(v string) *CreateAgentInput {
	s.FoundationModel = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *CreateAgentInput) SetIdleSessionTTLInSeconds(v int64) *CreateAgentInput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *CreateAgentInput) SetInstruction(v string) *CreateAgentInput {
	s.Instruction = &v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *CreateAgentInput) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *CreateAgentInput {
	s.PromptOverrideConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAgentInput) SetTags(v map[string]*string) *CreateAgentInput {
	s.Tags = v
	return s
}

type CreateAgentOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the agent created.
	//
	// Agent is a required field
	Agent *Agent `locationName:"agent" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentOutput) GoString() string {
	return s.String()
}

// SetAgent sets the Agent field's value.
func (s *CreateAgentOutput) SetAgent(v *Agent) *CreateAgentOutput {
	s.Agent = v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// Contains metadata about where the data source is stored.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `locationName:"dataSourceConfiguration" type:"structure" required:"true"`

	// A description of the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which to add the data source.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains details about the server-side encryption for the data source.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration `locationName:"vectorIngestionConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.DataSourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceConfiguration"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DataSourceConfiguration != nil {
		if err := s.DataSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VectorIngestionConfiguration != nil {
		if err := s.VectorIngestionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorIngestionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataSourceInput) SetClientToken(v string) *CreateDataSourceInput {
	s.ClientToken = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *CreateDataSourceInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *CreateDataSourceInput {
	s.DataSourceConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSourceInput) SetDescription(v string) *CreateDataSourceInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *CreateDataSourceInput) SetKnowledgeBaseId(v string) *CreateDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *CreateDataSourceInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *CreateDataSourceInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetVectorIngestionConfiguration sets the VectorIngestionConfiguration field's value.
func (s *CreateDataSourceInput) SetVectorIngestionConfiguration(v *VectorIngestionConfiguration) *CreateDataSourceInput {
	s.VectorIngestionConfiguration = v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the data source.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *CreateDataSourceOutput) SetDataSource(v *DataSource) *CreateDataSourceOutput {
	s.DataSource = v
	return s
}

type CreateKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description of the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the embeddings model used for the knowledge base.
	//
	// KnowledgeBaseConfiguration is a required field
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure" required:"true"`

	// A name for the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the knowledge base.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Contains details about the configuration of the vector database used for
	// the knowledge base.
	//
	// StorageConfiguration is a required field
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure" required:"true"`

	// Specify the key-value pairs for the tags that you want to attach to your
	// knowledge base in this object.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKnowledgeBaseInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseConfiguration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StorageConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageConfiguration"))
	}
	if s.KnowledgeBaseConfiguration != nil {
		if err := s.KnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageConfiguration != nil {
		if err := s.StorageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StorageConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKnowledgeBaseInput) SetClientToken(v string) *CreateKnowledgeBaseInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKnowledgeBaseInput) SetDescription(v string) *CreateKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *CreateKnowledgeBaseInput) SetKnowledgeBaseConfiguration(v *KnowledgeBaseConfiguration) *CreateKnowledgeBaseInput {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateKnowledgeBaseInput) SetName(v string) *CreateKnowledgeBaseInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateKnowledgeBaseInput) SetRoleArn(v string) *CreateKnowledgeBaseInput {
	s.RoleArn = &v
	return s
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *CreateKnowledgeBaseInput) SetStorageConfiguration(v *StorageConfiguration) *CreateKnowledgeBaseInput {
	s.StorageConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKnowledgeBaseInput) SetTags(v map[string]*string) *CreateKnowledgeBaseInput {
	s.Tags = v
	return s
}

type CreateKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base.
	//
	// KnowledgeBase is a required field
	KnowledgeBase *KnowledgeBase `locationName:"knowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *CreateKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBase) *CreateKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

// Contains details about a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The time at which the data source was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Contains details about how the data source is stored.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `locationName:"dataSourceConfiguration" type:"structure" required:"true"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains details about the configuration of the server-side encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// The status of the data source. The following statuses are possible:
	//
	//    * Available – The data source has been created and is ready for ingestion
	//    into the knowledge base.
	//
	//    * Deleting – The data source is being deleted.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceStatus"`

	// The time at which the data source was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration `locationName:"vectorIngestionConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSource) SetCreatedAt(v time.Time) *DataSource {
	s.CreatedAt = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *DataSource) SetDataSourceConfiguration(v *DataSourceConfiguration) *DataSource {
	s.DataSourceConfiguration = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSource) SetDataSourceId(v string) *DataSource {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataSource) SetDescription(v string) *DataSource {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DataSource) SetKnowledgeBaseId(v string) *DataSource {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSource) SetName(v string) *DataSource {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *DataSource) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *DataSource {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSource) SetStatus(v string) *DataSource {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSource) SetUpdatedAt(v time.Time) *DataSource {
	s.UpdatedAt = &v
	return s
}

// SetVectorIngestionConfiguration sets the VectorIngestionConfiguration field's value.
func (s *DataSource) SetVectorIngestionConfiguration(v *VectorIngestionConfiguration) *DataSource {
	s.VectorIngestionConfiguration = v
	return s
}

// Contains details about how a data source is stored.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains details about the configuration of the S3 object containing the
	// data source.
	S3Configuration *S3DataSourceConfiguration `locationName:"s3Configuration" type:"structure"`

	// The type of storage for the data source.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DataSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *DataSourceConfiguration) SetS3Configuration(v *S3DataSourceConfiguration) *DataSourceConfiguration {
	s.S3Configuration = v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceConfiguration) SetType(v string) *DataSourceConfiguration {
	s.Type = &v
	return s
}

// Contains details about a data source.
type DataSourceSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the data source.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceStatus"`

	// The time at which the data source was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSourceSummary) SetDataSourceId(v string) *DataSourceSummary {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataSourceSummary) SetDescription(v string) *DataSourceSummary {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DataSourceSummary) SetKnowledgeBaseId(v string) *DataSourceSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSourceSummary) SetName(v string) *DataSourceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSummary) SetStatus(v string) *DataSourceSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSourceSummary) SetUpdatedAt(v time.Time) *DataSourceSummary {
	s.UpdatedAt = &v
	return s
}

type DeleteAgentActionGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the action group to delete.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `location:"uri" locationName:"actionGroupId" type:"string" required:"true"`

	// The unique identifier of the agent that the action group belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent that the action group belongs to.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentActionGroupInput"}
	if s.ActionGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupId"))
	}
	if s.ActionGroupId != nil && len(*s.ActionGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionGroupId", 1))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *DeleteAgentActionGroupInput) SetActionGroupId(v string) *DeleteAgentActionGroupInput {
	s.ActionGroupId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentActionGroupInput) SetAgentId(v string) *DeleteAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DeleteAgentActionGroupInput) SetAgentVersion(v string) *DeleteAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteAgentActionGroupInput) SetSkipResourceInUseCheck(v bool) *DeleteAgentActionGroupInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupOutput) GoString() string {
	return s.String()
}

type DeleteAgentAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the alias to delete.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The unique identifier of the agent that the alias belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentAliasInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 10))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *DeleteAgentAliasInput) SetAgentAliasId(v string) *DeleteAgentAliasInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentAliasInput) SetAgentId(v string) *DeleteAgentAliasInput {
	s.AgentId = &v
	return s
}

type DeleteAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the alias that was deleted.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The status of the alias.
	//
	// AgentAliasStatus is a required field
	AgentAliasStatus *string `locationName:"agentAliasStatus" type:"string" required:"true" enum:"AgentAliasStatus"`

	// The unique identifier of the agent that the alias belongs to.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *DeleteAgentAliasOutput) SetAgentAliasId(v string) *DeleteAgentAliasOutput {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasStatus sets the AgentAliasStatus field's value.
func (s *DeleteAgentAliasOutput) SetAgentAliasStatus(v string) *DeleteAgentAliasOutput {
	s.AgentAliasStatus = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentAliasOutput) SetAgentId(v string) *DeleteAgentAliasOutput {
	s.AgentId = &v
	return s
}

type DeleteAgentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent to delete.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentInput) SetAgentId(v string) *DeleteAgentInput {
	s.AgentId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteAgentInput) SetSkipResourceInUseCheck(v bool) *DeleteAgentInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteAgentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent that was deleted.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The status of the agent.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentOutput) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentOutput) SetAgentId(v string) *DeleteAgentOutput {
	s.AgentId = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *DeleteAgentOutput) SetAgentStatus(v string) *DeleteAgentOutput {
	s.AgentStatus = &v
	return s
}

type DeleteAgentVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent that the version belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent to delete.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentVersionInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentVersionInput) SetAgentId(v string) *DeleteAgentVersionInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DeleteAgentVersionInput) SetAgentVersion(v string) *DeleteAgentVersionInput {
	s.AgentVersion = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteAgentVersionInput) SetSkipResourceInUseCheck(v bool) *DeleteAgentVersionInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteAgentVersionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent that the version belongs to.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The status of the agent version.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version that was deleted.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionOutput) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentVersionOutput) SetAgentId(v string) *DeleteAgentVersionOutput {
	s.AgentId = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *DeleteAgentVersionOutput) SetAgentStatus(v string) *DeleteAgentVersionOutput {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DeleteAgentVersionOutput) SetAgentVersion(v string) *DeleteAgentVersionOutput {
	s.AgentVersion = &v
	return s
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the data source to delete.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the knowledge base from which to delete the data
	// source.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceInput) SetDataSourceId(v string) *DeleteDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteDataSourceInput) SetKnowledgeBaseId(v string) *DeleteDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source that was deleted.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the knowledge base to which the data source that
	// was deleted belonged.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The status of the data source.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceOutput) SetDataSourceId(v string) *DeleteDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteDataSourceOutput) SetKnowledgeBaseId(v string) *DeleteDataSourceOutput {
	s.KnowledgeBaseId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDataSourceOutput) SetStatus(v string) *DeleteDataSourceOutput {
	s.Status = &v
	return s
}

type DeleteKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the knowledge base to delete.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKnowledgeBaseInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteKnowledgeBaseInput) SetKnowledgeBaseId(v string) *DeleteKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type DeleteKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the knowledge base that was deleted.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The status of the knowledge base and whether it has been successfully deleted.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteKnowledgeBaseOutput) SetKnowledgeBaseId(v string) *DeleteKnowledgeBaseOutput {
	s.KnowledgeBaseId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteKnowledgeBaseOutput) SetStatus(v string) *DeleteKnowledgeBaseOutput {
	s.Status = &v
	return s
}

type DisassociateAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent from which to disassociate the knowledge
	// base.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent from which to disassociate the knowledge base.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// The unique identifier of the knowledge base to disassociate.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *DisassociateAgentKnowledgeBaseInput) SetAgentId(v string) *DisassociateAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DisassociateAgentKnowledgeBaseInput) SetAgentVersion(v string) *DisassociateAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DisassociateAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *DisassociateAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type DisassociateAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy
// as NONE, exclude this field.
type FixedSizeChunkingConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens to include in a chunk.
	//
	// MaxTokens is a required field
	MaxTokens *int64 `locationName:"maxTokens" min:"1" type:"integer" required:"true"`

	// The percentage of overlap between adjacent chunks of a data source.
	//
	// OverlapPercentage is a required field
	OverlapPercentage *int64 `locationName:"overlapPercentage" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedSizeChunkingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedSizeChunkingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedSizeChunkingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FixedSizeChunkingConfiguration"}
	if s.MaxTokens == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxTokens"))
	}
	if s.MaxTokens != nil && *s.MaxTokens < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxTokens", 1))
	}
	if s.OverlapPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("OverlapPercentage"))
	}
	if s.OverlapPercentage != nil && *s.OverlapPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("OverlapPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxTokens sets the MaxTokens field's value.
func (s *FixedSizeChunkingConfiguration) SetMaxTokens(v int64) *FixedSizeChunkingConfiguration {
	s.MaxTokens = &v
	return s
}

// SetOverlapPercentage sets the OverlapPercentage field's value.
func (s *FixedSizeChunkingConfiguration) SetOverlapPercentage(v int64) *FixedSizeChunkingConfiguration {
	s.OverlapPercentage = &v
	return s
}

type GetAgentActionGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the action group for which to get information.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `location:"uri" locationName:"actionGroupId" type:"string" required:"true"`

	// The unique identifier of the agent that the action group belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent that the action group belongs to.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentActionGroupInput"}
	if s.ActionGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupId"))
	}
	if s.ActionGroupId != nil && len(*s.ActionGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionGroupId", 1))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *GetAgentActionGroupInput) SetActionGroupId(v string) *GetAgentActionGroupInput {
	s.ActionGroupId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentActionGroupInput) SetAgentId(v string) *GetAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentActionGroupInput) SetAgentVersion(v string) *GetAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

type GetAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the action group.
	//
	// AgentActionGroup is a required field
	AgentActionGroup *AgentActionGroup `locationName:"agentActionGroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupOutput) GoString() string {
	return s.String()
}

// SetAgentActionGroup sets the AgentActionGroup field's value.
func (s *GetAgentActionGroupOutput) SetAgentActionGroup(v *AgentActionGroup) *GetAgentActionGroupOutput {
	s.AgentActionGroup = v
	return s
}

type GetAgentAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the alias for which to get information.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The unique identifier of the agent to which the alias to get information
	// belongs.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentAliasInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 10))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *GetAgentAliasInput) SetAgentAliasId(v string) *GetAgentAliasInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentAliasInput) SetAgentId(v string) *GetAgentAliasInput {
	s.AgentId = &v
	return s
}

type GetAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the alias.
	//
	// AgentAlias is a required field
	AgentAlias *AgentAlias `locationName:"agentAlias" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAlias sets the AgentAlias field's value.
func (s *GetAgentAliasOutput) SetAgentAlias(v *AgentAlias) *GetAgentAliasOutput {
	s.AgentAlias = v
	return s
}

type GetAgentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentInput) SetAgentId(v string) *GetAgentInput {
	s.AgentId = &v
	return s
}

type GetAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent with which the knowledge base is associated.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent with which the knowledge base is associated.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The unique identifier of the knowledge base associated with the agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentKnowledgeBaseInput) SetAgentId(v string) *GetAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentKnowledgeBaseInput) SetAgentVersion(v string) *GetAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *GetAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about a knowledge base attached to an agent.
	//
	// AgentKnowledgeBase is a required field
	AgentKnowledgeBase *AgentKnowledgeBase `locationName:"agentKnowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBase sets the AgentKnowledgeBase field's value.
func (s *GetAgentKnowledgeBaseOutput) SetAgentKnowledgeBase(v *AgentKnowledgeBase) *GetAgentKnowledgeBaseOutput {
	s.AgentKnowledgeBase = v
	return s
}

type GetAgentOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the agent.
	//
	// Agent is a required field
	Agent *Agent `locationName:"agent" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentOutput) GoString() string {
	return s.String()
}

// SetAgent sets the Agent field's value.
func (s *GetAgentOutput) SetAgent(v *Agent) *GetAgentOutput {
	s.Agent = v
	return s
}

type GetAgentVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentVersionInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentVersionInput) SetAgentId(v string) *GetAgentVersionInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentVersionInput) SetAgentVersion(v string) *GetAgentVersionInput {
	s.AgentVersion = &v
	return s
}

type GetAgentVersionOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *AgentVersion `locationName:"agentVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionOutput) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentVersionOutput) SetAgentVersion(v *AgentVersion) *GetAgentVersionOutput {
	s.AgentVersion = v
	return s
}

type GetDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the knowledge base that the data source was added
	// to.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetDataSourceInput) SetDataSourceId(v string) *GetDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetDataSourceInput) SetKnowledgeBaseId(v string) *GetDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the data source.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *GetDataSourceOutput) SetDataSource(v *DataSource) *GetDataSourceOutput {
	s.DataSource = v
	return s
}

type GetIngestionJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the data source in the ingestion job.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the ingestion job.
	//
	// IngestionJobId is a required field
	IngestionJobId *string `location:"uri" locationName:"ingestionJobId" type:"string" required:"true"`

	// The unique identifier of the knowledge base for which the ingestion job applies.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIngestionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIngestionJobInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.IngestionJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionJobId"))
	}
	if s.IngestionJobId != nil && len(*s.IngestionJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionJobId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetIngestionJobInput) SetDataSourceId(v string) *GetIngestionJobInput {
	s.DataSourceId = &v
	return s
}

// SetIngestionJobId sets the IngestionJobId field's value.
func (s *GetIngestionJobInput) SetIngestionJobId(v string) *GetIngestionJobInput {
	s.IngestionJobId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetIngestionJobInput) SetKnowledgeBaseId(v string) *GetIngestionJobInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetIngestionJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the ingestion job.
	//
	// IngestionJob is a required field
	IngestionJob *IngestionJob `locationName:"ingestionJob" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobOutput) GoString() string {
	return s.String()
}

// SetIngestionJob sets the IngestionJob field's value.
func (s *GetIngestionJobOutput) SetIngestionJob(v *IngestionJob) *GetIngestionJobOutput {
	s.IngestionJob = v
	return s
}

type GetKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the knowledge base for which to get information.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKnowledgeBaseInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetKnowledgeBaseInput) SetKnowledgeBaseId(v string) *GetKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base.
	//
	// KnowledgeBase is a required field
	KnowledgeBase *KnowledgeBase `locationName:"knowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *GetKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBase) *GetKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

// Contains inference parameters to use when the agent invokes a foundation
// model in the part of the agent sequence defined by the promptType. For more
// information, see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
type InferenceConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens to allow in the generated response.
	MaximumLength *int64 `locationName:"maximumLength" type:"integer"`

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []*string `locationName:"stopSequences" type:"list"`

	// The likelihood of the model selecting higher-probability options while generating
	// a response. A lower value makes the model more likely to choose higher-probability
	// options, while a higher value makes the model more likely to choose lower-probability
	// options.
	Temperature *float64 `locationName:"temperature" type:"float"`

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for topK
	// is the number of most-likely candidates from which the model chooses the
	// next token in the sequence. For example, if you set topK to 50, the model
	// selects the next token from among the top 50 most likely choices.
	TopK *int64 `locationName:"topK" type:"integer"`

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for Top
	// P determines the number of most-likely candidates from which the model chooses
	// the next token in the sequence. For example, if you set topP to 80, the model
	// only selects the next token from the top 80% of the probability distribution
	// of next tokens.
	TopP *float64 `locationName:"topP" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) GoString() string {
	return s.String()
}

// SetMaximumLength sets the MaximumLength field's value.
func (s *InferenceConfiguration) SetMaximumLength(v int64) *InferenceConfiguration {
	s.MaximumLength = &v
	return s
}

// SetStopSequences sets the StopSequences field's value.
func (s *InferenceConfiguration) SetStopSequences(v []*string) *InferenceConfiguration {
	s.StopSequences = v
	return s
}

// SetTemperature sets the Temperature field's value.
func (s *InferenceConfiguration) SetTemperature(v float64) *InferenceConfiguration {
	s.Temperature = &v
	return s
}

// SetTopK sets the TopK field's value.
func (s *InferenceConfiguration) SetTopK(v int64) *InferenceConfiguration {
	s.TopK = &v
	return s
}

// SetTopP sets the TopP field's value.
func (s *InferenceConfiguration) SetTopP(v float64) *InferenceConfiguration {
	s.TopP = &v
	return s
}

// Contains details about an ingestion job, which converts a data source to
// embeddings for a vector store in knowledge base.
//
// This data type is used in the following API operations:
//
//   - StartIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StartIngestionJob.html#API_agent_StartIngestionJob_ResponseSyntax)
//
//   - GetIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetIngestionJob.html#API_agent_GetIngestionJob_ResponseSyntax)
//
//   - ListIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListIngestionJob.html#API_agent_ListIngestionJob_ResponseSyntax)
type IngestionJob struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the ingested data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the ingestion job.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A list of reasons that the ingestion job failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The unique identifier of the ingestion job.
	//
	// IngestionJobId is a required field
	IngestionJobId *string `locationName:"ingestionJobId" type:"string" required:"true"`

	// The unique identifier of the knowledge base to which the data source is being
	// added.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The time at which the ingestion job started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Contains statistics about the ingestion job.
	Statistics *IngestionJobStatistics `locationName:"statistics" type:"structure"`

	// The status of the ingestion job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"IngestionJobStatus"`

	// The time at which the ingestion job was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJob) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *IngestionJob) SetDataSourceId(v string) *IngestionJob {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IngestionJob) SetDescription(v string) *IngestionJob {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *IngestionJob) SetFailureReasons(v []*string) *IngestionJob {
	s.FailureReasons = v
	return s
}

// SetIngestionJobId sets the IngestionJobId field's value.
func (s *IngestionJob) SetIngestionJobId(v string) *IngestionJob {
	s.IngestionJobId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *IngestionJob) SetKnowledgeBaseId(v string) *IngestionJob {
	s.KnowledgeBaseId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *IngestionJob) SetStartedAt(v time.Time) *IngestionJob {
	s.StartedAt = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *IngestionJob) SetStatistics(v *IngestionJobStatistics) *IngestionJob {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *IngestionJob) SetStatus(v string) *IngestionJob {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IngestionJob) SetUpdatedAt(v time.Time) *IngestionJob {
	s.UpdatedAt = &v
	return s
}

// Defines a filter by which to filter the results.
type IngestionJobFilter struct {
	_ struct{} `type:"structure"`

	// The attribute by which to filter the results.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"IngestionJobFilterAttribute"`

	// The operation to carry out between the attribute and the values.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"IngestionJobFilterOperator"`

	// A list of values for the attribute.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestionJobFilter"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *IngestionJobFilter) SetAttribute(v string) *IngestionJobFilter {
	s.Attribute = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *IngestionJobFilter) SetOperator(v string) *IngestionJobFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *IngestionJobFilter) SetValues(v []*string) *IngestionJobFilter {
	s.Values = v
	return s
}

// Parameters by which to sort the results.
type IngestionJobSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute by which to sort the results.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"IngestionJobSortByAttribute"`

	// The order by which to sort the results.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestionJobSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestionJobSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *IngestionJobSortBy) SetAttribute(v string) *IngestionJobSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *IngestionJobSortBy) SetOrder(v string) *IngestionJobSortBy {
	s.Order = &v
	return s
}

// Contains the statistics for the ingestion job.
type IngestionJobStatistics struct {
	_ struct{} `type:"structure"`

	// The number of source documents that was deleted.
	NumberOfDocumentsDeleted *int64 `locationName:"numberOfDocumentsDeleted" type:"long"`

	// The number of source documents that failed to be ingested.
	NumberOfDocumentsFailed *int64 `locationName:"numberOfDocumentsFailed" type:"long"`

	// The total number of source documents that were scanned. Includes new, updated,
	// and unchanged documents.
	NumberOfDocumentsScanned *int64 `locationName:"numberOfDocumentsScanned" type:"long"`

	// The number of metadata files that were updated or deleted.
	NumberOfMetadataDocumentsModified *int64 `locationName:"numberOfMetadataDocumentsModified" type:"long"`

	// The total number of metadata files that were scanned. Includes new, updated,
	// and unchanged files.
	NumberOfMetadataDocumentsScanned *int64 `locationName:"numberOfMetadataDocumentsScanned" type:"long"`

	// The number of modified source documents in the data source that were successfully
	// indexed.
	NumberOfModifiedDocumentsIndexed *int64 `locationName:"numberOfModifiedDocumentsIndexed" type:"long"`

	// The number of new source documents in the data source that were successfully
	// indexed.
	NumberOfNewDocumentsIndexed *int64 `locationName:"numberOfNewDocumentsIndexed" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobStatistics) GoString() string {
	return s.String()
}

// SetNumberOfDocumentsDeleted sets the NumberOfDocumentsDeleted field's value.
func (s *IngestionJobStatistics) SetNumberOfDocumentsDeleted(v int64) *IngestionJobStatistics {
	s.NumberOfDocumentsDeleted = &v
	return s
}

// SetNumberOfDocumentsFailed sets the NumberOfDocumentsFailed field's value.
func (s *IngestionJobStatistics) SetNumberOfDocumentsFailed(v int64) *IngestionJobStatistics {
	s.NumberOfDocumentsFailed = &v
	return s
}

// SetNumberOfDocumentsScanned sets the NumberOfDocumentsScanned field's value.
func (s *IngestionJobStatistics) SetNumberOfDocumentsScanned(v int64) *IngestionJobStatistics {
	s.NumberOfDocumentsScanned = &v
	return s
}

// SetNumberOfMetadataDocumentsModified sets the NumberOfMetadataDocumentsModified field's value.
func (s *IngestionJobStatistics) SetNumberOfMetadataDocumentsModified(v int64) *IngestionJobStatistics {
	s.NumberOfMetadataDocumentsModified = &v
	return s
}

// SetNumberOfMetadataDocumentsScanned sets the NumberOfMetadataDocumentsScanned field's value.
func (s *IngestionJobStatistics) SetNumberOfMetadataDocumentsScanned(v int64) *IngestionJobStatistics {
	s.NumberOfMetadataDocumentsScanned = &v
	return s
}

// SetNumberOfModifiedDocumentsIndexed sets the NumberOfModifiedDocumentsIndexed field's value.
func (s *IngestionJobStatistics) SetNumberOfModifiedDocumentsIndexed(v int64) *IngestionJobStatistics {
	s.NumberOfModifiedDocumentsIndexed = &v
	return s
}

// SetNumberOfNewDocumentsIndexed sets the NumberOfNewDocumentsIndexed field's value.
func (s *IngestionJobStatistics) SetNumberOfNewDocumentsIndexed(v int64) *IngestionJobStatistics {
	s.NumberOfNewDocumentsIndexed = &v
	return s
}

// Contains details about an ingestion job.
type IngestionJobSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source in the ingestion job.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the ingestion job.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the ingestion job.
	//
	// IngestionJobId is a required field
	IngestionJobId *string `locationName:"ingestionJobId" type:"string" required:"true"`

	// The unique identifier of the knowledge base to which the data source is added.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The time at which the ingestion job was started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Contains statistics for the ingestion job.
	Statistics *IngestionJobStatistics `locationName:"statistics" type:"structure"`

	// The status of the ingestion job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"IngestionJobStatus"`

	// The time at which the ingestion job was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSummary) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *IngestionJobSummary) SetDataSourceId(v string) *IngestionJobSummary {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IngestionJobSummary) SetDescription(v string) *IngestionJobSummary {
	s.Description = &v
	return s
}

// SetIngestionJobId sets the IngestionJobId field's value.
func (s *IngestionJobSummary) SetIngestionJobId(v string) *IngestionJobSummary {
	s.IngestionJobId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *IngestionJobSummary) SetKnowledgeBaseId(v string) *IngestionJobSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *IngestionJobSummary) SetStartedAt(v time.Time) *IngestionJobSummary {
	s.StartedAt = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *IngestionJobSummary) SetStatistics(v *IngestionJobStatistics) *IngestionJobSummary {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *IngestionJobSummary) SetStatus(v string) *IngestionJobSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IngestionJobSummary) SetUpdatedAt(v time.Time) *IngestionJobSummary {
	s.UpdatedAt = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a knowledge base.
type KnowledgeBase struct {
	_ struct{} `type:"structure"`

	// The time at which the knowledge base was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A list of reasons that the API operation on the knowledge base failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	//
	// KnowledgeBaseArn is a required field
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string" required:"true"`

	// Contains details about the embeddings configuration of the knowledge base.
	//
	// KnowledgeBaseConfiguration is a required field
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure" required:"true"`

	// The unique identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the knowledge base.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The status of the knowledge base. The following statuses are possible:
	//
	//    * CREATING – The knowledge base is being created.
	//
	//    * ACTIVE – The knowledge base is ready to be queried.
	//
	//    * DELETING – The knowledge base is being deleted.
	//
	//    * UPDATING – The knowledge base is being updated.
	//
	//    * FAILED – The knowledge base API operation failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`

	// Contains details about the storage configuration of the knowledge base.
	//
	// StorageConfiguration is a required field
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure" required:"true"`

	// The time at which the knowledge base was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBase) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *KnowledgeBase) SetCreatedAt(v time.Time) *KnowledgeBase {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KnowledgeBase) SetDescription(v string) *KnowledgeBase {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *KnowledgeBase) SetFailureReasons(v []*string) *KnowledgeBase {
	s.FailureReasons = v
	return s
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *KnowledgeBase) SetKnowledgeBaseArn(v string) *KnowledgeBase {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *KnowledgeBase) SetKnowledgeBaseConfiguration(v *KnowledgeBaseConfiguration) *KnowledgeBase {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBase) SetKnowledgeBaseId(v string) *KnowledgeBase {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *KnowledgeBase) SetName(v string) *KnowledgeBase {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *KnowledgeBase) SetRoleArn(v string) *KnowledgeBase {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KnowledgeBase) SetStatus(v string) *KnowledgeBase {
	s.Status = &v
	return s
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *KnowledgeBase) SetStorageConfiguration(v *StorageConfiguration) *KnowledgeBase {
	s.StorageConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *KnowledgeBase) SetUpdatedAt(v time.Time) *KnowledgeBase {
	s.UpdatedAt = &v
	return s
}

// Contains details about the embeddings configuration of the knowledge base.
type KnowledgeBaseConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of data that the data source is converted into for the knowledge
	// base.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"KnowledgeBaseType"`

	// Contains details about the embeddings model that'sused to convert the data
	// source.
	VectorKnowledgeBaseConfiguration *VectorKnowledgeBaseConfiguration `locationName:"vectorKnowledgeBaseConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.VectorKnowledgeBaseConfiguration != nil {
		if err := s.VectorKnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorKnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *KnowledgeBaseConfiguration) SetType(v string) *KnowledgeBaseConfiguration {
	s.Type = &v
	return s
}

// SetVectorKnowledgeBaseConfiguration sets the VectorKnowledgeBaseConfiguration field's value.
func (s *KnowledgeBaseConfiguration) SetVectorKnowledgeBaseConfiguration(v *VectorKnowledgeBaseConfiguration) *KnowledgeBaseConfiguration {
	s.VectorKnowledgeBaseConfiguration = v
	return s
}

// Contains details about a knowledge base.
type KnowledgeBaseSummary struct {
	_ struct{} `type:"structure"`

	// The description of the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the knowledge base.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`

	// The time at which the knowledge base was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *KnowledgeBaseSummary) SetDescription(v string) *KnowledgeBaseSummary {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseSummary) SetKnowledgeBaseId(v string) *KnowledgeBaseSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *KnowledgeBaseSummary) SetName(v string) *KnowledgeBaseSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KnowledgeBaseSummary) SetStatus(v string) *KnowledgeBaseSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *KnowledgeBaseSummary) SetUpdatedAt(v time.Time) *KnowledgeBaseSummary {
	s.UpdatedAt = &v
	return s
}

type ListAgentActionGroupsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentActionGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentActionGroupsInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentActionGroupsInput) SetAgentId(v string) *ListAgentActionGroupsInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *ListAgentActionGroupsInput) SetAgentVersion(v string) *ListAgentActionGroupsInput {
	s.AgentVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentActionGroupsInput) SetMaxResults(v int64) *ListAgentActionGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentActionGroupsInput) SetNextToken(v string) *ListAgentActionGroupsInput {
	s.NextToken = &v
	return s
}

type ListAgentActionGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an action group.
	//
	// ActionGroupSummaries is a required field
	ActionGroupSummaries []*ActionGroupSummary `locationName:"actionGroupSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsOutput) GoString() string {
	return s.String()
}

// SetActionGroupSummaries sets the ActionGroupSummaries field's value.
func (s *ListAgentActionGroupsOutput) SetActionGroupSummaries(v []*ActionGroupSummary) *ListAgentActionGroupsOutput {
	s.ActionGroupSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentActionGroupsOutput) SetNextToken(v string) *ListAgentActionGroupsOutput {
	s.NextToken = &v
	return s
}

type ListAgentAliasesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentAliasesInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentAliasesInput) SetAgentId(v string) *ListAgentAliasesInput {
	s.AgentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentAliasesInput) SetMaxResults(v int64) *ListAgentAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentAliasesInput) SetNextToken(v string) *ListAgentAliasesInput {
	s.NextToken = &v
	return s
}

type ListAgentAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an alias of the
	// agent.
	//
	// AgentAliasSummaries is a required field
	AgentAliasSummaries []*AgentAliasSummary `locationName:"agentAliasSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesOutput) GoString() string {
	return s.String()
}

// SetAgentAliasSummaries sets the AgentAliasSummaries field's value.
func (s *ListAgentAliasesOutput) SetAgentAliasSummaries(v []*AgentAliasSummary) *ListAgentAliasesOutput {
	s.AgentAliasSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentAliasesOutput) SetNextToken(v string) *ListAgentAliasesOutput {
	s.NextToken = &v
	return s
}

type ListAgentKnowledgeBasesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent for which to return information about
	// knowledge bases associated with it.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent for which to return information about knowledge
	// bases associated with it.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentKnowledgeBasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentKnowledgeBasesInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentKnowledgeBasesInput) SetAgentId(v string) *ListAgentKnowledgeBasesInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *ListAgentKnowledgeBasesInput) SetAgentVersion(v string) *ListAgentKnowledgeBasesInput {
	s.AgentVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentKnowledgeBasesInput) SetMaxResults(v int64) *ListAgentKnowledgeBasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentKnowledgeBasesInput) SetNextToken(v string) *ListAgentKnowledgeBasesInput {
	s.NextToken = &v
	return s
}

type ListAgentKnowledgeBasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a knowledge base
	// associated with the agent.
	//
	// AgentKnowledgeBaseSummaries is a required field
	AgentKnowledgeBaseSummaries []*AgentKnowledgeBaseSummary `locationName:"agentKnowledgeBaseSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBaseSummaries sets the AgentKnowledgeBaseSummaries field's value.
func (s *ListAgentKnowledgeBasesOutput) SetAgentKnowledgeBaseSummaries(v []*AgentKnowledgeBaseSummary) *ListAgentKnowledgeBasesOutput {
	s.AgentKnowledgeBaseSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentKnowledgeBasesOutput) SetNextToken(v string) *ListAgentKnowledgeBasesOutput {
	s.NextToken = &v
	return s
}

type ListAgentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentVersionsInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentVersionsInput) SetAgentId(v string) *ListAgentVersionsInput {
	s.AgentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentVersionsInput) SetMaxResults(v int64) *ListAgentVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentVersionsInput) SetNextToken(v string) *ListAgentVersionsInput {
	s.NextToken = &v
	return s
}

type ListAgentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a version of
	// the agent.
	//
	// AgentVersionSummaries is a required field
	AgentVersionSummaries []*AgentVersionSummary `locationName:"agentVersionSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsOutput) GoString() string {
	return s.String()
}

// SetAgentVersionSummaries sets the AgentVersionSummaries field's value.
func (s *ListAgentVersionsOutput) SetAgentVersionSummaries(v []*AgentVersionSummary) *ListAgentVersionsOutput {
	s.AgentVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentVersionsOutput) SetNextToken(v string) *ListAgentVersionsOutput {
	s.NextToken = &v
	return s
}

type ListAgentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentsInput) SetMaxResults(v int64) *ListAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsInput) SetNextToken(v string) *ListAgentsInput {
	s.NextToken = &v
	return s
}

type ListAgentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an agent.
	//
	// AgentSummaries is a required field
	AgentSummaries []*AgentSummary `locationName:"agentSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsOutput) GoString() string {
	return s.String()
}

// SetAgentSummaries sets the AgentSummaries field's value.
func (s *ListAgentsOutput) SetAgentSummaries(v []*AgentSummary) *ListAgentsOutput {
	s.AgentSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsOutput) SetNextToken(v string) *ListAgentsOutput {
	s.NextToken = &v
	return s
}

type ListDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the knowledge base for which to return a list of
	// information.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ListDataSourcesInput) SetKnowledgeBaseId(v string) *ListDataSourcesInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourcesInput) SetMaxResults(v int64) *ListDataSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesInput) SetNextToken(v string) *ListDataSourcesInput {
	s.NextToken = &v
	return s
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a data source.
	//
	// DataSourceSummaries is a required field
	DataSourceSummaries []*DataSourceSummary `locationName:"dataSourceSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetDataSourceSummaries sets the DataSourceSummaries field's value.
func (s *ListDataSourcesOutput) SetDataSourceSummaries(v []*DataSourceSummary) *ListDataSourcesOutput {
	s.DataSourceSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesOutput) SetNextToken(v string) *ListDataSourcesOutput {
	s.NextToken = &v
	return s
}

type ListIngestionJobsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source for which to return ingestion jobs.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// Contains a definition of a filter for which to filter the results.
	Filters []*IngestionJobFilter `locationName:"filters" min:"1" type:"list"`

	// The unique identifier of the knowledge base for which to return ingestion
	// jobs.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Contains details about how to sort the results.
	SortBy *IngestionJobSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIngestionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIngestionJobsInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *ListIngestionJobsInput) SetDataSourceId(v string) *ListIngestionJobsInput {
	s.DataSourceId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListIngestionJobsInput) SetFilters(v []*IngestionJobFilter) *ListIngestionJobsInput {
	s.Filters = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ListIngestionJobsInput) SetKnowledgeBaseId(v string) *ListIngestionJobsInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIngestionJobsInput) SetMaxResults(v int64) *ListIngestionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionJobsInput) SetNextToken(v string) *ListIngestionJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListIngestionJobsInput) SetSortBy(v *IngestionJobSortBy) *ListIngestionJobsInput {
	s.SortBy = v
	return s
}

type ListIngestionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an ingestion
	// job.
	//
	// IngestionJobSummaries is a required field
	IngestionJobSummaries []*IngestionJobSummary `locationName:"ingestionJobSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsOutput) GoString() string {
	return s.String()
}

// SetIngestionJobSummaries sets the IngestionJobSummaries field's value.
func (s *ListIngestionJobsOutput) SetIngestionJobSummaries(v []*IngestionJobSummary) *ListIngestionJobsOutput {
	s.IngestionJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionJobsOutput) SetNextToken(v string) *ListIngestionJobsOutput {
	s.NextToken = &v
	return s
}

type ListKnowledgeBasesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKnowledgeBasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKnowledgeBasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKnowledgeBasesInput) SetMaxResults(v int64) *ListKnowledgeBasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKnowledgeBasesInput) SetNextToken(v string) *ListKnowledgeBasesInput {
	s.NextToken = &v
	return s
}

type ListKnowledgeBasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a knowledge base.
	//
	// KnowledgeBaseSummaries is a required field
	KnowledgeBaseSummaries []*KnowledgeBaseSummary `locationName:"knowledgeBaseSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBaseSummaries sets the KnowledgeBaseSummaries field's value.
func (s *ListKnowledgeBasesOutput) SetKnowledgeBaseSummaries(v []*KnowledgeBaseSummary) *ListKnowledgeBasesOutput {
	s.KnowledgeBaseSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKnowledgeBasesOutput) SetNextToken(v string) *ListKnowledgeBasesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource for which to list tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pairs for the tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Amazon OpenSearch Service. For more information, see Create a vector index
// in Amazon OpenSearch Service (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html).
type OpenSearchServerlessConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
	//
	// CollectionArn is a required field
	CollectionArn *string `locationName:"collectionArn" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *OpenSearchServerlessFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The name of the vector store.
	//
	// VectorIndexName is a required field
	VectorIndexName *string `locationName:"vectorIndexName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenSearchServerlessConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenSearchServerlessConfiguration"}
	if s.CollectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionArn"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.VectorIndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorIndexName"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *OpenSearchServerlessConfiguration) SetCollectionArn(v string) *OpenSearchServerlessConfiguration {
	s.CollectionArn = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *OpenSearchServerlessConfiguration) SetFieldMapping(v *OpenSearchServerlessFieldMapping) *OpenSearchServerlessConfiguration {
	s.FieldMapping = v
	return s
}

// SetVectorIndexName sets the VectorIndexName field's value.
func (s *OpenSearchServerlessConfiguration) SetVectorIndexName(v string) *OpenSearchServerlessConfiguration {
	s.VectorIndexName = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type OpenSearchServerlessFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the vector embeddings
	// for your data sources.
	//
	// VectorField is a required field
	VectorField *string `locationName:"vectorField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenSearchServerlessFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenSearchServerlessFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}
	if s.VectorField == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *OpenSearchServerlessFieldMapping) SetMetadataField(v string) *OpenSearchServerlessFieldMapping {
	s.MetadataField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *OpenSearchServerlessFieldMapping) SetTextField(v string) *OpenSearchServerlessFieldMapping {
	s.TextField = &v
	return s
}

// SetVectorField sets the VectorField field's value.
func (s *OpenSearchServerlessFieldMapping) SetVectorField(v string) *OpenSearchServerlessFieldMapping {
	s.VectorField = &v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Pinecone. For more information, see Create a vector index in Pinecone (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html).
type PineconeConfiguration struct {
	_ struct{} `type:"structure"`

	// The endpoint URL for your index management page.
	//
	// ConnectionString is a required field
	ConnectionString *string `locationName:"connectionString" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Pinecone API key.
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *PineconeFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The namespace to be used to write new data to your database.
	Namespace *string `locationName:"namespace" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PineconeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PineconeConfiguration"}
	if s.ConnectionString == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionString"))
	}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionString sets the ConnectionString field's value.
func (s *PineconeConfiguration) SetConnectionString(v string) *PineconeConfiguration {
	s.ConnectionString = &v
	return s
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *PineconeConfiguration) SetCredentialsSecretArn(v string) *PineconeConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *PineconeConfiguration) SetFieldMapping(v *PineconeFieldMapping) *PineconeConfiguration {
	s.FieldMapping = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PineconeConfiguration) SetNamespace(v string) *PineconeConfiguration {
	s.Namespace = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type PineconeFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PineconeFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PineconeFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *PineconeFieldMapping) SetMetadataField(v string) *PineconeFieldMapping {
	s.MetadataField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *PineconeFieldMapping) SetTextField(v string) *PineconeFieldMapping {
	s.TextField = &v
	return s
}

type PrepareAgentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent for which to create a DRAFT version.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrepareAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrepareAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *PrepareAgentInput) SetAgentId(v string) *PrepareAgentInput {
	s.AgentId = &v
	return s
}

type PrepareAgentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent for which the DRAFT version was created.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The status of the DRAFT version and whether it is ready for use.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The time at which the DRAFT version of the agent was last prepared.
	//
	// PreparedAt is a required field
	PreparedAt *time.Time `locationName:"preparedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentOutput) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *PrepareAgentOutput) SetAgentId(v string) *PrepareAgentOutput {
	s.AgentId = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *PrepareAgentOutput) SetAgentStatus(v string) *PrepareAgentOutput {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *PrepareAgentOutput) SetAgentVersion(v string) *PrepareAgentOutput {
	s.AgentVersion = &v
	return s
}

// SetPreparedAt sets the PreparedAt field's value.
func (s *PrepareAgentOutput) SetPreparedAt(v time.Time) *PrepareAgentOutput {
	s.PreparedAt = &v
	return s
}

// Contains configurations to override a prompt template in one part of an agent
// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
type PromptConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the prompt template with which to replace the default prompt template.
	// You can use placeholder variables in the base prompt template to customize
	// the prompt. For more information, see Prompt template placeholder variables
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html).
	BasePromptTemplate *string `locationName:"basePromptTemplate" min:"1" type:"string"`

	// Contains inference parameters to use when the agent invokes a foundation
	// model in the part of the agent sequence defined by the promptType. For more
	// information, see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
	InferenceConfiguration *InferenceConfiguration `locationName:"inferenceConfiguration" type:"structure"`

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined
	// by the promptType. If you set the field as OVERRIDEN, the overrideLambda
	// field in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	// must be specified with the ARN of a Lambda function.
	ParserMode *string `locationName:"parserMode" type:"string" enum:"CreationMode"`

	// Specifies whether to override the default prompt template for this promptType.
	// Set this value to OVERRIDDEN to use the prompt that you provide in the basePromptTemplate.
	// If you leave it as DEFAULT, the agent uses a default prompt template.
	PromptCreationMode *string `locationName:"promptCreationMode" type:"string" enum:"CreationMode"`

	// Specifies whether to allow the agent to carry out the step specified in the
	// promptType. If you set this value to DISABLED, the agent skips that step.
	// The default state for each promptType is as follows.
	//
	//    * PRE_PROCESSING – ENABLED
	//
	//    * ORCHESTRATION – ENABLED
	//
	//    * KNOWLEDGE_BASE_RESPONSE_GENERATION – ENABLED
	//
	//    * POST_PROCESSING – DISABLED
	PromptState *string `locationName:"promptState" type:"string" enum:"PromptState"`

	// The step in the agent sequence that this prompt configuration applies to.
	PromptType *string `locationName:"promptType" type:"string" enum:"PromptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptConfiguration"}
	if s.BasePromptTemplate != nil && len(*s.BasePromptTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasePromptTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePromptTemplate sets the BasePromptTemplate field's value.
func (s *PromptConfiguration) SetBasePromptTemplate(v string) *PromptConfiguration {
	s.BasePromptTemplate = &v
	return s
}

// SetInferenceConfiguration sets the InferenceConfiguration field's value.
func (s *PromptConfiguration) SetInferenceConfiguration(v *InferenceConfiguration) *PromptConfiguration {
	s.InferenceConfiguration = v
	return s
}

// SetParserMode sets the ParserMode field's value.
func (s *PromptConfiguration) SetParserMode(v string) *PromptConfiguration {
	s.ParserMode = &v
	return s
}

// SetPromptCreationMode sets the PromptCreationMode field's value.
func (s *PromptConfiguration) SetPromptCreationMode(v string) *PromptConfiguration {
	s.PromptCreationMode = &v
	return s
}

// SetPromptState sets the PromptState field's value.
func (s *PromptConfiguration) SetPromptState(v string) *PromptConfiguration {
	s.PromptState = &v
	return s
}

// SetPromptType sets the PromptType field's value.
func (s *PromptConfiguration) SetPromptType(v string) *PromptConfiguration {
	s.PromptType = &v
	return s
}

// Contains configurations to override prompts in different parts of an agent
// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
type PromptOverrideConfiguration struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence. If you specify this field, at least
	// one of the promptConfigurations must contain a parserMode value that is set
	// to OVERRIDDEN.
	OverrideLambda *string `locationName:"overrideLambda" type:"string"`

	// Contains configurations to override a prompt template in one part of an agent
	// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptConfigurations is a required field
	PromptConfigurations []*PromptConfiguration `locationName:"promptConfigurations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptOverrideConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptOverrideConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptOverrideConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptOverrideConfiguration"}
	if s.PromptConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptConfigurations"))
	}
	if s.PromptConfigurations != nil {
		for i, v := range s.PromptConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PromptConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverrideLambda sets the OverrideLambda field's value.
func (s *PromptOverrideConfiguration) SetOverrideLambda(v string) *PromptOverrideConfiguration {
	s.OverrideLambda = &v
	return s
}

// SetPromptConfigurations sets the PromptConfigurations field's value.
func (s *PromptOverrideConfiguration) SetPromptConfigurations(v []*PromptConfiguration) *PromptOverrideConfiguration {
	s.PromptConfigurations = v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Amazon RDS. For more information, see Create a vector index in Amazon RDS
// (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html).
type RdsConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Amazon RDS database.
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The name of your Amazon RDS database.
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *RdsFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the vector store.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The name of the table in the database.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RdsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RdsConfiguration"}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *RdsConfiguration) SetCredentialsSecretArn(v string) *RdsConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RdsConfiguration) SetDatabaseName(v string) *RdsConfiguration {
	s.DatabaseName = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *RdsConfiguration) SetFieldMapping(v *RdsFieldMapping) *RdsConfiguration {
	s.FieldMapping = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RdsConfiguration) SetResourceArn(v string) *RdsConfiguration {
	s.ResourceArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *RdsConfiguration) SetTableName(v string) *RdsConfiguration {
	s.TableName = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type RdsFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the ID for each entry.
	//
	// PrimaryKeyField is a required field
	PrimaryKeyField *string `locationName:"primaryKeyField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the vector embeddings
	// for your data sources.
	//
	// VectorField is a required field
	VectorField *string `locationName:"vectorField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RdsFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RdsFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.PrimaryKeyField == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryKeyField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}
	if s.VectorField == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *RdsFieldMapping) SetMetadataField(v string) *RdsFieldMapping {
	s.MetadataField = &v
	return s
}

// SetPrimaryKeyField sets the PrimaryKeyField field's value.
func (s *RdsFieldMapping) SetPrimaryKeyField(v string) *RdsFieldMapping {
	s.PrimaryKeyField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *RdsFieldMapping) SetTextField(v string) *RdsFieldMapping {
	s.TextField = &v
	return s
}

// SetVectorField sets the VectorField field's value.
func (s *RdsFieldMapping) SetVectorField(v string) *RdsFieldMapping {
	s.VectorField = &v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Redis Enterprise Cloud. For more information, see Create a vector index in
// Redis Enterprise Cloud (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html).
type RedisEnterpriseCloudConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Redis Enterprise Cloud database.
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The endpoint URL of the Redis Enterprise Cloud database.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *RedisEnterpriseCloudFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The name of the vector index.
	//
	// VectorIndexName is a required field
	VectorIndexName *string `locationName:"vectorIndexName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedisEnterpriseCloudConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedisEnterpriseCloudConfiguration"}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.VectorIndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorIndexName"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *RedisEnterpriseCloudConfiguration) SetCredentialsSecretArn(v string) *RedisEnterpriseCloudConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *RedisEnterpriseCloudConfiguration) SetEndpoint(v string) *RedisEnterpriseCloudConfiguration {
	s.Endpoint = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *RedisEnterpriseCloudConfiguration) SetFieldMapping(v *RedisEnterpriseCloudFieldMapping) *RedisEnterpriseCloudConfiguration {
	s.FieldMapping = v
	return s
}

// SetVectorIndexName sets the VectorIndexName field's value.
func (s *RedisEnterpriseCloudConfiguration) SetVectorIndexName(v string) *RedisEnterpriseCloudConfiguration {
	s.VectorIndexName = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type RedisEnterpriseCloudFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the vector embeddings
	// for your data sources.
	//
	// VectorField is a required field
	VectorField *string `locationName:"vectorField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedisEnterpriseCloudFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedisEnterpriseCloudFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}
	if s.VectorField == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *RedisEnterpriseCloudFieldMapping) SetMetadataField(v string) *RedisEnterpriseCloudFieldMapping {
	s.MetadataField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *RedisEnterpriseCloudFieldMapping) SetTextField(v string) *RedisEnterpriseCloudFieldMapping {
	s.TextField = &v
	return s
}

// SetVectorField sets the VectorField field's value.
func (s *RedisEnterpriseCloudFieldMapping) SetVectorField(v string) *RedisEnterpriseCloudFieldMapping {
	s.VectorField = &v
	return s
}

// The specified resource Amazon Resource Name (ARN) was not found. Check the
// Amazon Resource Name (ARN) and try your request again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the S3 configuration of the data source.
type S3DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bucket that contains the data source.
	//
	// BucketArn is a required field
	BucketArn *string `locationName:"bucketArn" min:"1" type:"string" required:"true"`

	// A list of S3 prefixes that define the object containing the data sources.
	// For more information, see Organizing objects using prefixes (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
	InclusionPrefixes []*string `locationName:"inclusionPrefixes" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DataSourceConfiguration"}
	if s.BucketArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketArn"))
	}
	if s.BucketArn != nil && len(*s.BucketArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketArn", 1))
	}
	if s.InclusionPrefixes != nil && len(s.InclusionPrefixes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InclusionPrefixes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3DataSourceConfiguration) SetBucketArn(v string) *S3DataSourceConfiguration {
	s.BucketArn = &v
	return s
}

// SetInclusionPrefixes sets the InclusionPrefixes field's value.
func (s *S3DataSourceConfiguration) SetInclusionPrefixes(v []*string) *S3DataSourceConfiguration {
	s.InclusionPrefixes = v
	return s
}

// Contains information about the S3 object containing the resource.
type S3Identifier struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	S3BucketName *string `locationName:"s3BucketName" min:"3" type:"string"`

	// The S3 object key containing the resource.
	S3ObjectKey *string `locationName:"s3ObjectKey" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Identifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Identifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Identifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Identifier"}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}
	if s.S3ObjectKey != nil && len(*s.S3ObjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *S3Identifier) SetS3BucketName(v string) *S3Identifier {
	s.S3BucketName = &v
	return s
}

// SetS3ObjectKey sets the S3ObjectKey field's value.
func (s *S3Identifier) SetS3ObjectKey(v string) *S3Identifier {
	s.S3ObjectKey = &v
	return s
}

// Contains the configuration for server-side encryption.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the resource.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *ServerSideEncryptionConfiguration) SetKmsKeyArn(v string) *ServerSideEncryptionConfiguration {
	s.KmsKeyArn = &v
	return s
}

// The number of requests exceeds the service quota. Resubmit your request later.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartIngestionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The unique identifier of the data source to ingest.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// A description of the ingestion job.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which to add the data source.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartIngestionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartIngestionJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartIngestionJobInput) SetClientToken(v string) *StartIngestionJobInput {
	s.ClientToken = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *StartIngestionJobInput) SetDataSourceId(v string) *StartIngestionJobInput {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartIngestionJobInput) SetDescription(v string) *StartIngestionJobInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *StartIngestionJobInput) SetKnowledgeBaseId(v string) *StartIngestionJobInput {
	s.KnowledgeBaseId = &v
	return s
}

type StartIngestionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the ingestion job.
	//
	// IngestionJob is a required field
	IngestionJob *IngestionJob `locationName:"ingestionJob" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobOutput) GoString() string {
	return s.String()
}

// SetIngestionJob sets the IngestionJob field's value.
func (s *StartIngestionJobOutput) SetIngestionJob(v *IngestionJob) *StartIngestionJobOutput {
	s.IngestionJob = v
	return s
}

// Contains the storage configuration of the knowledge base.
type StorageConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains the storage configuration of the knowledge base in Amazon OpenSearch
	// Service.
	OpensearchServerlessConfiguration *OpenSearchServerlessConfiguration `locationName:"opensearchServerlessConfiguration" type:"structure"`

	// Contains the storage configuration of the knowledge base in Pinecone.
	PineconeConfiguration *PineconeConfiguration `locationName:"pineconeConfiguration" type:"structure"`

	// Contains details about the storage configuration of the knowledge base in
	// Amazon RDS. For more information, see Create a vector index in Amazon RDS
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html).
	RdsConfiguration *RdsConfiguration `locationName:"rdsConfiguration" type:"structure"`

	// Contains the storage configuration of the knowledge base in Redis Enterprise
	// Cloud.
	RedisEnterpriseCloudConfiguration *RedisEnterpriseCloudConfiguration `locationName:"redisEnterpriseCloudConfiguration" type:"structure"`

	// The vector store service in which the knowledge base is stored.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"KnowledgeBaseStorageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.OpensearchServerlessConfiguration != nil {
		if err := s.OpensearchServerlessConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OpensearchServerlessConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PineconeConfiguration != nil {
		if err := s.PineconeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PineconeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RdsConfiguration != nil {
		if err := s.RdsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RdsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RedisEnterpriseCloudConfiguration != nil {
		if err := s.RedisEnterpriseCloudConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RedisEnterpriseCloudConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOpensearchServerlessConfiguration sets the OpensearchServerlessConfiguration field's value.
func (s *StorageConfiguration) SetOpensearchServerlessConfiguration(v *OpenSearchServerlessConfiguration) *StorageConfiguration {
	s.OpensearchServerlessConfiguration = v
	return s
}

// SetPineconeConfiguration sets the PineconeConfiguration field's value.
func (s *StorageConfiguration) SetPineconeConfiguration(v *PineconeConfiguration) *StorageConfiguration {
	s.PineconeConfiguration = v
	return s
}

// SetRdsConfiguration sets the RdsConfiguration field's value.
func (s *StorageConfiguration) SetRdsConfiguration(v *RdsConfiguration) *StorageConfiguration {
	s.RdsConfiguration = v
	return s
}

// SetRedisEnterpriseCloudConfiguration sets the RedisEnterpriseCloudConfiguration field's value.
func (s *StorageConfiguration) SetRedisEnterpriseCloudConfiguration(v *RedisEnterpriseCloudConfiguration) *StorageConfiguration {
	s.RedisEnterpriseCloudConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *StorageConfiguration) SetType(v string) *StorageConfiguration {
	s.Type = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// An object containing key-value pairs that define the tags to attach to the
	// resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The number of requests exceeds the limit. Resubmit your request later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource from which to remove tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// A list of keys of the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAgentActionGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action.
	ActionGroupExecutor *ActionGroupExecutor `locationName:"actionGroupExecutor" type:"structure"`

	// The unique identifier of the action group.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `location:"uri" locationName:"actionGroupId" type:"string" required:"true"`

	// Specifies a new name for the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	ActionGroupState *string `locationName:"actionGroupState" type:"string" enum:"ActionGroupState"`

	// The unique identifier of the agent for which to update the action group.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The unique identifier of the agent version for which to update the action
	// group.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// Contains either details about the S3 object containing the OpenAPI schema
	// for the action group or the JSON or YAML-formatted payload defining the schema.
	// For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	ApiSchema *APISchema `locationName:"apiSchema" type:"structure"`

	// Specifies a new name for the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// To allow your agent to request the user for additional information when trying
	// to complete a task, set this field to AMAZON.UserInput. You must leave the
	// description, apiSchema, and actionGroupExecutor fields blank for this action
	// group.
	//
	// During orchestration, if your agent determines that it needs to invoke an
	// API in an action group, but doesn't have enough information to complete the
	// API request, it will invoke this action group instead and return an Observation
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
	// reprompting the user for more information.
	ParentActionGroupSignature *string `locationName:"parentActionGroupSignature" type:"string" enum:"ActionGroupSignature"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentActionGroupInput"}
	if s.ActionGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupId"))
	}
	if s.ActionGroupId != nil && len(*s.ActionGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionGroupId", 1))
	}
	if s.ActionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ApiSchema != nil {
		if err := s.ApiSchema.Validate(); err != nil {
			invalidParams.AddNested("ApiSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupExecutor sets the ActionGroupExecutor field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupExecutor(v *ActionGroupExecutor) *UpdateAgentActionGroupInput {
	s.ActionGroupExecutor = v
	return s
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupId(v string) *UpdateAgentActionGroupInput {
	s.ActionGroupId = &v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupName(v string) *UpdateAgentActionGroupInput {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupState(v string) *UpdateAgentActionGroupInput {
	s.ActionGroupState = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentActionGroupInput) SetAgentId(v string) *UpdateAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *UpdateAgentActionGroupInput) SetAgentVersion(v string) *UpdateAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

// SetApiSchema sets the ApiSchema field's value.
func (s *UpdateAgentActionGroupInput) SetApiSchema(v *APISchema) *UpdateAgentActionGroupInput {
	s.ApiSchema = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentActionGroupInput) SetDescription(v string) *UpdateAgentActionGroupInput {
	s.Description = &v
	return s
}

// SetParentActionGroupSignature sets the ParentActionGroupSignature field's value.
func (s *UpdateAgentActionGroupInput) SetParentActionGroupSignature(v string) *UpdateAgentActionGroupInput {
	s.ParentActionGroupSignature = &v
	return s
}

type UpdateAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the action group that was updated.
	//
	// AgentActionGroup is a required field
	AgentActionGroup *AgentActionGroup `locationName:"agentActionGroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupOutput) GoString() string {
	return s.String()
}

// SetAgentActionGroup sets the AgentActionGroup field's value.
func (s *UpdateAgentActionGroupOutput) SetAgentActionGroup(v *AgentActionGroup) *UpdateAgentActionGroupOutput {
	s.AgentActionGroup = v
	return s
}

type UpdateAgentAliasInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the alias.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// Specifies a new name for the alias.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// Specifies a new description for the alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the routing configuration of the alias.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentAliasInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 10))
	}
	if s.AgentAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoutingConfiguration != nil {
		for i, v := range s.RoutingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *UpdateAgentAliasInput) SetAgentAliasId(v string) *UpdateAgentAliasInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *UpdateAgentAliasInput) SetAgentAliasName(v string) *UpdateAgentAliasInput {
	s.AgentAliasName = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentAliasInput) SetAgentId(v string) *UpdateAgentAliasInput {
	s.AgentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentAliasInput) SetDescription(v string) *UpdateAgentAliasInput {
	s.Description = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *UpdateAgentAliasInput) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *UpdateAgentAliasInput {
	s.RoutingConfiguration = v
	return s
}

type UpdateAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the alias that was updated.
	//
	// AgentAlias is a required field
	AgentAlias *AgentAlias `locationName:"agentAlias" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAlias sets the AgentAlias field's value.
func (s *UpdateAgentAliasOutput) SetAgentAlias(v *AgentAlias) *UpdateAgentAliasOutput {
	s.AgentAlias = v
	return s
}

type UpdateAgentInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// Specifies a new name for the agent.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	//
	// AgentResourceRoleArn is a required field
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// Specifies a new description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Specifies a new foundation model to be used for orchestration by the agent.
	//
	// FoundationModel is a required field
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string" required:"true"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// Specifies new instructions that tell the agent what it should do and how
	// it should interact with users.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAgentInput's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// Contains configurations to override prompts in different parts of an agent
	// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAgentInput's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentName"))
	}
	if s.AgentResourceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentResourceRoleArn"))
	}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FoundationModel == nil {
		invalidParams.Add(request.NewErrParamRequired("FoundationModel"))
	}
	if s.FoundationModel != nil && len(*s.FoundationModel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FoundationModel", 1))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.Instruction != nil && len(*s.Instruction) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("Instruction", 40))
	}
	if s.PromptOverrideConfiguration != nil {
		if err := s.PromptOverrideConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PromptOverrideConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentInput) SetAgentId(v string) *UpdateAgentInput {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *UpdateAgentInput) SetAgentName(v string) *UpdateAgentInput {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *UpdateAgentInput) SetAgentResourceRoleArn(v string) *UpdateAgentInput {
	s.AgentResourceRoleArn = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *UpdateAgentInput) SetCustomerEncryptionKeyArn(v string) *UpdateAgentInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentInput) SetDescription(v string) *UpdateAgentInput {
	s.Description = &v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *UpdateAgentInput) SetFoundationModel(v string) *UpdateAgentInput {
	s.FoundationModel = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *UpdateAgentInput) SetIdleSessionTTLInSeconds(v int64) *UpdateAgentInput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *UpdateAgentInput) SetInstruction(v string) *UpdateAgentInput {
	s.Instruction = &v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *UpdateAgentInput) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *UpdateAgentInput {
	s.PromptOverrideConfiguration = v
	return s
}

type UpdateAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent associated with the knowledge base that
	// you want to update.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent associated with the knowledge base that you want
	// to update.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// Specifies a new description for the knowledge base associated with an agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base that has been associated with
	// an agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether the agent uses the knowledge base or not when sending an
	// InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" enum:"KnowledgeBaseState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetAgentId(v string) *UpdateAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetAgentVersion(v string) *UpdateAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetDescription(v string) *UpdateAgentKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *UpdateAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetKnowledgeBaseState(v string) *UpdateAgentKnowledgeBaseInput {
	s.KnowledgeBaseState = &v
	return s
}

type UpdateAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base that has been associated with an
	// agent.
	//
	// AgentKnowledgeBase is a required field
	AgentKnowledgeBase *AgentKnowledgeBase `locationName:"agentKnowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBase sets the AgentKnowledgeBase field's value.
func (s *UpdateAgentKnowledgeBaseOutput) SetAgentKnowledgeBase(v *AgentKnowledgeBase) *UpdateAgentKnowledgeBaseOutput {
	s.AgentKnowledgeBase = v
	return s
}

type UpdateAgentOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the agent that was updated.
	//
	// Agent is a required field
	Agent *Agent `locationName:"agent" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentOutput) GoString() string {
	return s.String()
}

// SetAgent sets the Agent field's value.
func (s *UpdateAgentOutput) SetAgent(v *Agent) *UpdateAgentOutput {
	s.Agent = v
	return s
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// Contains details about the storage configuration of the data source.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `locationName:"dataSourceConfiguration" type:"structure" required:"true"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// Specifies a new description for the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies a new name for the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains details about server-side encryption of the data source.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration `locationName:"vectorIngestionConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.DataSourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceConfiguration"))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DataSourceConfiguration != nil {
		if err := s.DataSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VectorIngestionConfiguration != nil {
		if err := s.VectorIngestionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorIngestionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *UpdateDataSourceInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *UpdateDataSourceInput {
	s.DataSourceConfiguration = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourceInput) SetDataSourceId(v string) *UpdateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSourceInput) SetDescription(v string) *UpdateDataSourceInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateDataSourceInput) SetKnowledgeBaseId(v string) *UpdateDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSourceInput) SetName(v string) *UpdateDataSourceInput {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *UpdateDataSourceInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *UpdateDataSourceInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetVectorIngestionConfiguration sets the VectorIngestionConfiguration field's value.
func (s *UpdateDataSourceInput) SetVectorIngestionConfiguration(v *VectorIngestionConfiguration) *UpdateDataSourceInput {
	s.VectorIngestionConfiguration = v
	return s
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the data source.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *UpdateDataSourceOutput) SetDataSource(v *DataSource) *UpdateDataSourceOutput {
	s.DataSource = v
	return s
}

type UpdateKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// Specifies a new description for the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Specifies the configuration for the embeddings model used for the knowledge
	// base. You must use the same configuration as when the knowledge base was
	// created.
	//
	// KnowledgeBaseConfiguration is a required field
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure" required:"true"`

	// The unique identifier of the knowledge base to update.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies a new name for the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Specifies a different Amazon Resource Name (ARN) of the IAM role with permissions
	// to invoke API operations on the knowledge base.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Specifies the configuration for the vector store used for the knowledge base.
	// You must use the same configuration as when the knowledge base was created.
	//
	// StorageConfiguration is a required field
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKnowledgeBaseInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseConfiguration"))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StorageConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageConfiguration"))
	}
	if s.KnowledgeBaseConfiguration != nil {
		if err := s.KnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageConfiguration != nil {
		if err := s.StorageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StorageConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateKnowledgeBaseInput) SetDescription(v string) *UpdateKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *UpdateKnowledgeBaseInput) SetKnowledgeBaseConfiguration(v *KnowledgeBaseConfiguration) *UpdateKnowledgeBaseInput {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateKnowledgeBaseInput) SetKnowledgeBaseId(v string) *UpdateKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateKnowledgeBaseInput) SetName(v string) *UpdateKnowledgeBaseInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateKnowledgeBaseInput) SetRoleArn(v string) *UpdateKnowledgeBaseInput {
	s.RoleArn = &v
	return s
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *UpdateKnowledgeBaseInput) SetStorageConfiguration(v *StorageConfiguration) *UpdateKnowledgeBaseInput {
	s.StorageConfiguration = v
	return s
}

type UpdateKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base.
	//
	// KnowledgeBase is a required field
	KnowledgeBase *KnowledgeBase `locationName:"knowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *UpdateKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBase) *UpdateKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

// Input validation failed. Check your request parameters and retry the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of objects containing fields that caused validation errors and their
	// corresponding validation error messages.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores information about a field passed inside a request that resulted in
// an validation error.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message describing why this field failed validation.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Contains details about how to ingest the documents in a data source.
type VectorIngestionConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about how to chunk the documents in the data source. A chunk refers
	// to an excerpt from a data source that is returned when the knowledge base
	// that it belongs to is queried.
	ChunkingConfiguration *ChunkingConfiguration `locationName:"chunkingConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorIngestionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorIngestionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorIngestionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorIngestionConfiguration"}
	if s.ChunkingConfiguration != nil {
		if err := s.ChunkingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChunkingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChunkingConfiguration sets the ChunkingConfiguration field's value.
func (s *VectorIngestionConfiguration) SetChunkingConfiguration(v *ChunkingConfiguration) *VectorIngestionConfiguration {
	s.ChunkingConfiguration = v
	return s
}

// Contains details about the model used to create vector embeddings for the
// knowledge base.
type VectorKnowledgeBaseConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model used to create vector embeddings
	// for the knowledge base.
	//
	// EmbeddingModelArn is a required field
	EmbeddingModelArn *string `locationName:"embeddingModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorKnowledgeBaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorKnowledgeBaseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorKnowledgeBaseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorKnowledgeBaseConfiguration"}
	if s.EmbeddingModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EmbeddingModelArn"))
	}
	if s.EmbeddingModelArn != nil && len(*s.EmbeddingModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EmbeddingModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmbeddingModelArn sets the EmbeddingModelArn field's value.
func (s *VectorKnowledgeBaseConfiguration) SetEmbeddingModelArn(v string) *VectorKnowledgeBaseConfiguration {
	s.EmbeddingModelArn = &v
	return s
}

const (
	// ActionGroupSignatureAmazonUserInput is a ActionGroupSignature enum value
	ActionGroupSignatureAmazonUserInput = "AMAZON.UserInput"
)

// ActionGroupSignature_Values returns all elements of the ActionGroupSignature enum
func ActionGroupSignature_Values() []string {
	return []string{
		ActionGroupSignatureAmazonUserInput,
	}
}

const (
	// ActionGroupStateEnabled is a ActionGroupState enum value
	ActionGroupStateEnabled = "ENABLED"

	// ActionGroupStateDisabled is a ActionGroupState enum value
	ActionGroupStateDisabled = "DISABLED"
)

// ActionGroupState_Values returns all elements of the ActionGroupState enum
func ActionGroupState_Values() []string {
	return []string{
		ActionGroupStateEnabled,
		ActionGroupStateDisabled,
	}
}

const (
	// AgentAliasStatusCreating is a AgentAliasStatus enum value
	AgentAliasStatusCreating = "CREATING"

	// AgentAliasStatusPrepared is a AgentAliasStatus enum value
	AgentAliasStatusPrepared = "PREPARED"

	// AgentAliasStatusFailed is a AgentAliasStatus enum value
	AgentAliasStatusFailed = "FAILED"

	// AgentAliasStatusUpdating is a AgentAliasStatus enum value
	AgentAliasStatusUpdating = "UPDATING"

	// AgentAliasStatusDeleting is a AgentAliasStatus enum value
	AgentAliasStatusDeleting = "DELETING"
)

// AgentAliasStatus_Values returns all elements of the AgentAliasStatus enum
func AgentAliasStatus_Values() []string {
	return []string{
		AgentAliasStatusCreating,
		AgentAliasStatusPrepared,
		AgentAliasStatusFailed,
		AgentAliasStatusUpdating,
		AgentAliasStatusDeleting,
	}
}

const (
	// AgentStatusCreating is a AgentStatus enum value
	AgentStatusCreating = "CREATING"

	// AgentStatusPreparing is a AgentStatus enum value
	AgentStatusPreparing = "PREPARING"

	// AgentStatusPrepared is a AgentStatus enum value
	AgentStatusPrepared = "PREPARED"

	// AgentStatusNotPrepared is a AgentStatus enum value
	AgentStatusNotPrepared = "NOT_PREPARED"

	// AgentStatusDeleting is a AgentStatus enum value
	AgentStatusDeleting = "DELETING"

	// AgentStatusFailed is a AgentStatus enum value
	AgentStatusFailed = "FAILED"

	// AgentStatusVersioning is a AgentStatus enum value
	AgentStatusVersioning = "VERSIONING"

	// AgentStatusUpdating is a AgentStatus enum value
	AgentStatusUpdating = "UPDATING"
)

// AgentStatus_Values returns all elements of the AgentStatus enum
func AgentStatus_Values() []string {
	return []string{
		AgentStatusCreating,
		AgentStatusPreparing,
		AgentStatusPrepared,
		AgentStatusNotPrepared,
		AgentStatusDeleting,
		AgentStatusFailed,
		AgentStatusVersioning,
		AgentStatusUpdating,
	}
}

const (
	// ChunkingStrategyFixedSize is a ChunkingStrategy enum value
	ChunkingStrategyFixedSize = "FIXED_SIZE"

	// ChunkingStrategyNone is a ChunkingStrategy enum value
	ChunkingStrategyNone = "NONE"
)

// ChunkingStrategy_Values returns all elements of the ChunkingStrategy enum
func ChunkingStrategy_Values() []string {
	return []string{
		ChunkingStrategyFixedSize,
		ChunkingStrategyNone,
	}
}

const (
	// CreationModeDefault is a CreationMode enum value
	CreationModeDefault = "DEFAULT"

	// CreationModeOverridden is a CreationMode enum value
	CreationModeOverridden = "OVERRIDDEN"
)

// CreationMode_Values returns all elements of the CreationMode enum
func CreationMode_Values() []string {
	return []string{
		CreationModeDefault,
		CreationModeOverridden,
	}
}

const (
	// DataSourceStatusAvailable is a DataSourceStatus enum value
	DataSourceStatusAvailable = "AVAILABLE"

	// DataSourceStatusDeleting is a DataSourceStatus enum value
	DataSourceStatusDeleting = "DELETING"
)

// DataSourceStatus_Values returns all elements of the DataSourceStatus enum
func DataSourceStatus_Values() []string {
	return []string{
		DataSourceStatusAvailable,
		DataSourceStatusDeleting,
	}
}

const (
	// DataSourceTypeS3 is a DataSourceType enum value
	DataSourceTypeS3 = "S3"
)

// DataSourceType_Values returns all elements of the DataSourceType enum
func DataSourceType_Values() []string {
	return []string{
		DataSourceTypeS3,
	}
}

const (
	// IngestionJobFilterAttributeStatus is a IngestionJobFilterAttribute enum value
	IngestionJobFilterAttributeStatus = "STATUS"
)

// IngestionJobFilterAttribute_Values returns all elements of the IngestionJobFilterAttribute enum
func IngestionJobFilterAttribute_Values() []string {
	return []string{
		IngestionJobFilterAttributeStatus,
	}
}

const (
	// IngestionJobFilterOperatorEq is a IngestionJobFilterOperator enum value
	IngestionJobFilterOperatorEq = "EQ"
)

// IngestionJobFilterOperator_Values returns all elements of the IngestionJobFilterOperator enum
func IngestionJobFilterOperator_Values() []string {
	return []string{
		IngestionJobFilterOperatorEq,
	}
}

const (
	// IngestionJobSortByAttributeStatus is a IngestionJobSortByAttribute enum value
	IngestionJobSortByAttributeStatus = "STATUS"

	// IngestionJobSortByAttributeStartedAt is a IngestionJobSortByAttribute enum value
	IngestionJobSortByAttributeStartedAt = "STARTED_AT"
)

// IngestionJobSortByAttribute_Values returns all elements of the IngestionJobSortByAttribute enum
func IngestionJobSortByAttribute_Values() []string {
	return []string{
		IngestionJobSortByAttributeStatus,
		IngestionJobSortByAttributeStartedAt,
	}
}

const (
	// IngestionJobStatusStarting is a IngestionJobStatus enum value
	IngestionJobStatusStarting = "STARTING"

	// IngestionJobStatusInProgress is a IngestionJobStatus enum value
	IngestionJobStatusInProgress = "IN_PROGRESS"

	// IngestionJobStatusComplete is a IngestionJobStatus enum value
	IngestionJobStatusComplete = "COMPLETE"

	// IngestionJobStatusFailed is a IngestionJobStatus enum value
	IngestionJobStatusFailed = "FAILED"
)

// IngestionJobStatus_Values returns all elements of the IngestionJobStatus enum
func IngestionJobStatus_Values() []string {
	return []string{
		IngestionJobStatusStarting,
		IngestionJobStatusInProgress,
		IngestionJobStatusComplete,
		IngestionJobStatusFailed,
	}
}

const (
	// KnowledgeBaseStateEnabled is a KnowledgeBaseState enum value
	KnowledgeBaseStateEnabled = "ENABLED"

	// KnowledgeBaseStateDisabled is a KnowledgeBaseState enum value
	KnowledgeBaseStateDisabled = "DISABLED"
)

// KnowledgeBaseState_Values returns all elements of the KnowledgeBaseState enum
func KnowledgeBaseState_Values() []string {
	return []string{
		KnowledgeBaseStateEnabled,
		KnowledgeBaseStateDisabled,
	}
}

const (
	// KnowledgeBaseStatusCreating is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusCreating = "CREATING"

	// KnowledgeBaseStatusActive is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusActive = "ACTIVE"

	// KnowledgeBaseStatusDeleting is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusDeleting = "DELETING"

	// KnowledgeBaseStatusUpdating is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusUpdating = "UPDATING"

	// KnowledgeBaseStatusFailed is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusFailed = "FAILED"
)

// KnowledgeBaseStatus_Values returns all elements of the KnowledgeBaseStatus enum
func KnowledgeBaseStatus_Values() []string {
	return []string{
		KnowledgeBaseStatusCreating,
		KnowledgeBaseStatusActive,
		KnowledgeBaseStatusDeleting,
		KnowledgeBaseStatusUpdating,
		KnowledgeBaseStatusFailed,
	}
}

const (
	// KnowledgeBaseStorageTypeOpensearchServerless is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypeOpensearchServerless = "OPENSEARCH_SERVERLESS"

	// KnowledgeBaseStorageTypePinecone is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypePinecone = "PINECONE"

	// KnowledgeBaseStorageTypeRedisEnterpriseCloud is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypeRedisEnterpriseCloud = "REDIS_ENTERPRISE_CLOUD"

	// KnowledgeBaseStorageTypeRds is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypeRds = "RDS"
)

// KnowledgeBaseStorageType_Values returns all elements of the KnowledgeBaseStorageType enum
func KnowledgeBaseStorageType_Values() []string {
	return []string{
		KnowledgeBaseStorageTypeOpensearchServerless,
		KnowledgeBaseStorageTypePinecone,
		KnowledgeBaseStorageTypeRedisEnterpriseCloud,
		KnowledgeBaseStorageTypeRds,
	}
}

const (
	// KnowledgeBaseTypeVector is a KnowledgeBaseType enum value
	KnowledgeBaseTypeVector = "VECTOR"
)

// KnowledgeBaseType_Values returns all elements of the KnowledgeBaseType enum
func KnowledgeBaseType_Values() []string {
	return []string{
		KnowledgeBaseTypeVector,
	}
}

const (
	// PromptStateEnabled is a PromptState enum value
	PromptStateEnabled = "ENABLED"

	// PromptStateDisabled is a PromptState enum value
	PromptStateDisabled = "DISABLED"
)

// PromptState_Values returns all elements of the PromptState enum
func PromptState_Values() []string {
	return []string{
		PromptStateEnabled,
		PromptStateDisabled,
	}
}

const (
	// PromptTypePreProcessing is a PromptType enum value
	PromptTypePreProcessing = "PRE_PROCESSING"

	// PromptTypeOrchestration is a PromptType enum value
	PromptTypeOrchestration = "ORCHESTRATION"

	// PromptTypePostProcessing is a PromptType enum value
	PromptTypePostProcessing = "POST_PROCESSING"

	// PromptTypeKnowledgeBaseResponseGeneration is a PromptType enum value
	PromptTypeKnowledgeBaseResponseGeneration = "KNOWLEDGE_BASE_RESPONSE_GENERATION"
)

// PromptType_Values returns all elements of the PromptType enum
func PromptType_Values() []string {
	return []string{
		PromptTypePreProcessing,
		PromptTypeOrchestration,
		PromptTypePostProcessing,
		PromptTypeKnowledgeBaseResponseGeneration,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
