// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAnomalyMonitor = "CreateAnomalyMonitor"

// CreateAnomalyMonitorRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnomalyMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnomalyMonitor for more information on using the CreateAnomalyMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAnomalyMonitorRequest method.
//	req, resp := client.CreateAnomalyMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor
func (c *CostExplorer) CreateAnomalyMonitorRequest(input *CreateAnomalyMonitorInput) (req *request.Request, output *CreateAnomalyMonitorOutput) {
	op := &request.Operation{
		Name:       opCreateAnomalyMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAnomalyMonitorInput{}
	}

	output = &CreateAnomalyMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnomalyMonitor API operation for AWS Cost Explorer Service.
//
// Creates a new cost anomaly detection monitor with the requested type and
// monitor specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation CreateAnomalyMonitor for usage and error information.
//
// Returned Error Types:
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor
func (c *CostExplorer) CreateAnomalyMonitor(input *CreateAnomalyMonitorInput) (*CreateAnomalyMonitorOutput, error) {
	req, out := c.CreateAnomalyMonitorRequest(input)
	return out, req.Send()
}

// CreateAnomalyMonitorWithContext is the same as CreateAnomalyMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnomalyMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) CreateAnomalyMonitorWithContext(ctx aws.Context, input *CreateAnomalyMonitorInput, opts ...request.Option) (*CreateAnomalyMonitorOutput, error) {
	req, out := c.CreateAnomalyMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnomalySubscription = "CreateAnomalySubscription"

// CreateAnomalySubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnomalySubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnomalySubscription for more information on using the CreateAnomalySubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAnomalySubscriptionRequest method.
//	req, resp := client.CreateAnomalySubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription
func (c *CostExplorer) CreateAnomalySubscriptionRequest(input *CreateAnomalySubscriptionInput) (req *request.Request, output *CreateAnomalySubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateAnomalySubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAnomalySubscriptionInput{}
	}

	output = &CreateAnomalySubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnomalySubscription API operation for AWS Cost Explorer Service.
//
// Adds an alert subscription to a cost anomaly detection monitor. You can use
// each subscription to define subscribers with email or SNS notifications.
// Email subscribers can set an absolute or percentage threshold and a time
// frequency for receiving notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation CreateAnomalySubscription for usage and error information.
//
// Returned Error Types:
//
//   - UnknownMonitorException
//     The cost anomaly monitor does not exist for the account.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription
func (c *CostExplorer) CreateAnomalySubscription(input *CreateAnomalySubscriptionInput) (*CreateAnomalySubscriptionOutput, error) {
	req, out := c.CreateAnomalySubscriptionRequest(input)
	return out, req.Send()
}

// CreateAnomalySubscriptionWithContext is the same as CreateAnomalySubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnomalySubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) CreateAnomalySubscriptionWithContext(ctx aws.Context, input *CreateAnomalySubscriptionInput, opts ...request.Option) (*CreateAnomalySubscriptionOutput, error) {
	req, out := c.CreateAnomalySubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCostCategoryDefinition = "CreateCostCategoryDefinition"

// CreateCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCostCategoryDefinition for more information on using the CreateCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCostCategoryDefinitionRequest method.
//	req, resp := client.CreateCostCategoryDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition
func (c *CostExplorer) CreateCostCategoryDefinitionRequest(input *CreateCostCategoryDefinitionInput) (req *request.Request, output *CreateCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCostCategoryDefinitionInput{}
	}

	output = &CreateCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Creates a new Cost Category with the requested name and rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation CreateCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You've reached the limit on the number of resources you can create, or exceeded
//     the size of an individual resource.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition
func (c *CostExplorer) CreateCostCategoryDefinition(input *CreateCostCategoryDefinitionInput) (*CreateCostCategoryDefinitionOutput, error) {
	req, out := c.CreateCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// CreateCostCategoryDefinitionWithContext is the same as CreateCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) CreateCostCategoryDefinitionWithContext(ctx aws.Context, input *CreateCostCategoryDefinitionInput, opts ...request.Option) (*CreateCostCategoryDefinitionOutput, error) {
	req, out := c.CreateCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnomalyMonitor = "DeleteAnomalyMonitor"

// DeleteAnomalyMonitorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnomalyMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnomalyMonitor for more information on using the DeleteAnomalyMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnomalyMonitorRequest method.
//	req, resp := client.DeleteAnomalyMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor
func (c *CostExplorer) DeleteAnomalyMonitorRequest(input *DeleteAnomalyMonitorInput) (req *request.Request, output *DeleteAnomalyMonitorOutput) {
	op := &request.Operation{
		Name:       opDeleteAnomalyMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnomalyMonitorInput{}
	}

	output = &DeleteAnomalyMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnomalyMonitor API operation for AWS Cost Explorer Service.
//
// Deletes a cost anomaly monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DeleteAnomalyMonitor for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - UnknownMonitorException
//     The cost anomaly monitor does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor
func (c *CostExplorer) DeleteAnomalyMonitor(input *DeleteAnomalyMonitorInput) (*DeleteAnomalyMonitorOutput, error) {
	req, out := c.DeleteAnomalyMonitorRequest(input)
	return out, req.Send()
}

// DeleteAnomalyMonitorWithContext is the same as DeleteAnomalyMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnomalyMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DeleteAnomalyMonitorWithContext(ctx aws.Context, input *DeleteAnomalyMonitorInput, opts ...request.Option) (*DeleteAnomalyMonitorOutput, error) {
	req, out := c.DeleteAnomalyMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnomalySubscription = "DeleteAnomalySubscription"

// DeleteAnomalySubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnomalySubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnomalySubscription for more information on using the DeleteAnomalySubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnomalySubscriptionRequest method.
//	req, resp := client.DeleteAnomalySubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription
func (c *CostExplorer) DeleteAnomalySubscriptionRequest(input *DeleteAnomalySubscriptionInput) (req *request.Request, output *DeleteAnomalySubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteAnomalySubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnomalySubscriptionInput{}
	}

	output = &DeleteAnomalySubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnomalySubscription API operation for AWS Cost Explorer Service.
//
// Deletes a cost anomaly subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DeleteAnomalySubscription for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - UnknownSubscriptionException
//     The cost anomaly subscription does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription
func (c *CostExplorer) DeleteAnomalySubscription(input *DeleteAnomalySubscriptionInput) (*DeleteAnomalySubscriptionOutput, error) {
	req, out := c.DeleteAnomalySubscriptionRequest(input)
	return out, req.Send()
}

// DeleteAnomalySubscriptionWithContext is the same as DeleteAnomalySubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnomalySubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DeleteAnomalySubscriptionWithContext(ctx aws.Context, input *DeleteAnomalySubscriptionInput, opts ...request.Option) (*DeleteAnomalySubscriptionOutput, error) {
	req, out := c.DeleteAnomalySubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCostCategoryDefinition = "DeleteCostCategoryDefinition"

// DeleteCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCostCategoryDefinition for more information on using the DeleteCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCostCategoryDefinitionRequest method.
//	req, resp := client.DeleteCostCategoryDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition
func (c *CostExplorer) DeleteCostCategoryDefinitionRequest(input *DeleteCostCategoryDefinitionInput) (req *request.Request, output *DeleteCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCostCategoryDefinitionInput{}
	}

	output = &DeleteCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Deletes a Cost Category. Expenses from this month going forward will no longer
// be categorized with this Cost Category.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DeleteCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ARN in the request doesn't exist.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition
func (c *CostExplorer) DeleteCostCategoryDefinition(input *DeleteCostCategoryDefinitionInput) (*DeleteCostCategoryDefinitionOutput, error) {
	req, out := c.DeleteCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// DeleteCostCategoryDefinitionWithContext is the same as DeleteCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DeleteCostCategoryDefinitionWithContext(ctx aws.Context, input *DeleteCostCategoryDefinitionInput, opts ...request.Option) (*DeleteCostCategoryDefinitionOutput, error) {
	req, out := c.DeleteCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCostCategoryDefinition = "DescribeCostCategoryDefinition"

// DescribeCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCostCategoryDefinition for more information on using the DescribeCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCostCategoryDefinitionRequest method.
//	req, resp := client.DescribeCostCategoryDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition
func (c *CostExplorer) DescribeCostCategoryDefinitionRequest(input *DescribeCostCategoryDefinitionInput) (req *request.Request, output *DescribeCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCostCategoryDefinitionInput{}
	}

	output = &DescribeCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Returns the name, Amazon Resource Name (ARN), rules, definition, and effective
// dates of a Cost Category that's defined in the account.
//
// You have the option to use EffectiveOn to return a Cost Category that's active
// on a specific date. If there's no EffectiveOn specified, you see a Cost Category
// that's effective on the current date. If Cost Category is still effective,
// EffectiveEnd is omitted in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DescribeCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ARN in the request doesn't exist.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition
func (c *CostExplorer) DescribeCostCategoryDefinition(input *DescribeCostCategoryDefinitionInput) (*DescribeCostCategoryDefinitionOutput, error) {
	req, out := c.DescribeCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// DescribeCostCategoryDefinitionWithContext is the same as DescribeCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DescribeCostCategoryDefinitionWithContext(ctx aws.Context, input *DescribeCostCategoryDefinitionInput, opts ...request.Option) (*DescribeCostCategoryDefinitionOutput, error) {
	req, out := c.DescribeCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnomalies = "GetAnomalies"

// GetAnomaliesRequest generates a "aws/request.Request" representing the
// client's request for the GetAnomalies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnomalies for more information on using the GetAnomalies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnomaliesRequest method.
//	req, resp := client.GetAnomaliesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies
func (c *CostExplorer) GetAnomaliesRequest(input *GetAnomaliesInput) (req *request.Request, output *GetAnomaliesOutput) {
	op := &request.Operation{
		Name:       opGetAnomalies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAnomaliesInput{}
	}

	output = &GetAnomaliesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnomalies API operation for AWS Cost Explorer Service.
//
// Retrieves all of the cost anomalies detected on your account during the time
// period that's specified by the DateInterval object. Anomalies are available
// for up to 90 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetAnomalies for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies
func (c *CostExplorer) GetAnomalies(input *GetAnomaliesInput) (*GetAnomaliesOutput, error) {
	req, out := c.GetAnomaliesRequest(input)
	return out, req.Send()
}

// GetAnomaliesWithContext is the same as GetAnomalies with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnomalies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetAnomaliesWithContext(ctx aws.Context, input *GetAnomaliesInput, opts ...request.Option) (*GetAnomaliesOutput, error) {
	req, out := c.GetAnomaliesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnomalyMonitors = "GetAnomalyMonitors"

// GetAnomalyMonitorsRequest generates a "aws/request.Request" representing the
// client's request for the GetAnomalyMonitors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnomalyMonitors for more information on using the GetAnomalyMonitors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnomalyMonitorsRequest method.
//	req, resp := client.GetAnomalyMonitorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors
func (c *CostExplorer) GetAnomalyMonitorsRequest(input *GetAnomalyMonitorsInput) (req *request.Request, output *GetAnomalyMonitorsOutput) {
	op := &request.Operation{
		Name:       opGetAnomalyMonitors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAnomalyMonitorsInput{}
	}

	output = &GetAnomalyMonitorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnomalyMonitors API operation for AWS Cost Explorer Service.
//
// Retrieves the cost anomaly monitor definitions for your account. You can
// filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetAnomalyMonitors for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - UnknownMonitorException
//     The cost anomaly monitor does not exist for the account.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors
func (c *CostExplorer) GetAnomalyMonitors(input *GetAnomalyMonitorsInput) (*GetAnomalyMonitorsOutput, error) {
	req, out := c.GetAnomalyMonitorsRequest(input)
	return out, req.Send()
}

// GetAnomalyMonitorsWithContext is the same as GetAnomalyMonitors with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnomalyMonitors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetAnomalyMonitorsWithContext(ctx aws.Context, input *GetAnomalyMonitorsInput, opts ...request.Option) (*GetAnomalyMonitorsOutput, error) {
	req, out := c.GetAnomalyMonitorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnomalySubscriptions = "GetAnomalySubscriptions"

// GetAnomalySubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetAnomalySubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnomalySubscriptions for more information on using the GetAnomalySubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnomalySubscriptionsRequest method.
//	req, resp := client.GetAnomalySubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions
func (c *CostExplorer) GetAnomalySubscriptionsRequest(input *GetAnomalySubscriptionsInput) (req *request.Request, output *GetAnomalySubscriptionsOutput) {
	op := &request.Operation{
		Name:       opGetAnomalySubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAnomalySubscriptionsInput{}
	}

	output = &GetAnomalySubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnomalySubscriptions API operation for AWS Cost Explorer Service.
//
// Retrieves the cost anomaly subscription objects for your account. You can
// filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetAnomalySubscriptions for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - UnknownSubscriptionException
//     The cost anomaly subscription does not exist for the account.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions
func (c *CostExplorer) GetAnomalySubscriptions(input *GetAnomalySubscriptionsInput) (*GetAnomalySubscriptionsOutput, error) {
	req, out := c.GetAnomalySubscriptionsRequest(input)
	return out, req.Send()
}

// GetAnomalySubscriptionsWithContext is the same as GetAnomalySubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnomalySubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetAnomalySubscriptionsWithContext(ctx aws.Context, input *GetAnomalySubscriptionsInput, opts ...request.Option) (*GetAnomalySubscriptionsOutput, error) {
	req, out := c.GetAnomalySubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApproximateUsageRecords = "GetApproximateUsageRecords"

// GetApproximateUsageRecordsRequest generates a "aws/request.Request" representing the
// client's request for the GetApproximateUsageRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApproximateUsageRecords for more information on using the GetApproximateUsageRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApproximateUsageRecordsRequest method.
//	req, resp := client.GetApproximateUsageRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetApproximateUsageRecords
func (c *CostExplorer) GetApproximateUsageRecordsRequest(input *GetApproximateUsageRecordsInput) (req *request.Request, output *GetApproximateUsageRecordsOutput) {
	op := &request.Operation{
		Name:       opGetApproximateUsageRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApproximateUsageRecordsInput{}
	}

	output = &GetApproximateUsageRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApproximateUsageRecords API operation for AWS Cost Explorer Service.
//
// Retrieves estimated usage records for hourly granularity or resource-level
// data at daily granularity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetApproximateUsageRecords for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetApproximateUsageRecords
func (c *CostExplorer) GetApproximateUsageRecords(input *GetApproximateUsageRecordsInput) (*GetApproximateUsageRecordsOutput, error) {
	req, out := c.GetApproximateUsageRecordsRequest(input)
	return out, req.Send()
}

// GetApproximateUsageRecordsWithContext is the same as GetApproximateUsageRecords with the addition of
// the ability to pass a context and additional request options.
//
// See GetApproximateUsageRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetApproximateUsageRecordsWithContext(ctx aws.Context, input *GetApproximateUsageRecordsInput, opts ...request.Option) (*GetApproximateUsageRecordsOutput, error) {
	req, out := c.GetApproximateUsageRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostAndUsage = "GetCostAndUsage"

// GetCostAndUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetCostAndUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostAndUsage for more information on using the GetCostAndUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCostAndUsageRequest method.
//	req, resp := client.GetCostAndUsageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsageRequest(input *GetCostAndUsageInput) (req *request.Request, output *GetCostAndUsageOutput) {
	op := &request.Operation{
		Name:       opGetCostAndUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageInput{}
	}

	output = &GetCostAndUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostAndUsage API operation for AWS Cost Explorer Service.
//
// Retrieves cost and usage metrics for your account. You can specify which
// cost and usage-related metric that you want the request to return. For example,
// you can specify BlendedCosts or UsageQuantity. You can also filter and group
// your data by various dimensions, such as SERVICE or AZ, in a specific time
// range. For a complete list of valid dimensions, see the GetDimensionValues
// (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html)
// operation. Management account in an organization in Organizations have access
// to all member accounts.
//
// For information about filter limitations, see Quotas and restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html)
// in the Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostAndUsage for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - BillExpirationException
//     The requested report expired. Update the date interval and try again.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
//   - RequestChangedException
//     Your request parameters changed between pages. Try again with the old parameters
//     or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsage(input *GetCostAndUsageInput) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	return out, req.Send()
}

// GetCostAndUsageWithContext is the same as GetCostAndUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostAndUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostAndUsageWithContext(ctx aws.Context, input *GetCostAndUsageInput, opts ...request.Option) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostAndUsageWithResources = "GetCostAndUsageWithResources"

// GetCostAndUsageWithResourcesRequest generates a "aws/request.Request" representing the
// client's request for the GetCostAndUsageWithResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostAndUsageWithResources for more information on using the GetCostAndUsageWithResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCostAndUsageWithResourcesRequest method.
//	req, resp := client.GetCostAndUsageWithResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources
func (c *CostExplorer) GetCostAndUsageWithResourcesRequest(input *GetCostAndUsageWithResourcesInput) (req *request.Request, output *GetCostAndUsageWithResourcesOutput) {
	op := &request.Operation{
		Name:       opGetCostAndUsageWithResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageWithResourcesInput{}
	}

	output = &GetCostAndUsageWithResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostAndUsageWithResources API operation for AWS Cost Explorer Service.
//
// Retrieves cost and usage metrics with resources for your account. You can
// specify which cost and usage-related metric, such as BlendedCosts or UsageQuantity,
// that you want the request to return. You can also filter and group your data
// by various dimensions, such as SERVICE or AZ, in a specific time range. For
// a complete list of valid dimensions, see the GetDimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html)
// operation. Management account in an organization in Organizations have access
// to all member accounts. This API is currently available for the Amazon Elastic
// Compute Cloud – Compute service only.
//
// This is an opt-in only feature. You can enable this feature from the Cost
// Explorer Settings page. For information about how to access the Settings
// page, see Controlling Access for Cost Explorer (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html)
// in the Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostAndUsageWithResources for usage and error information.
//
// Returned Error Types:
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - BillExpirationException
//     The requested report expired. Update the date interval and try again.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
//   - RequestChangedException
//     Your request parameters changed between pages. Try again with the old parameters
//     or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources
func (c *CostExplorer) GetCostAndUsageWithResources(input *GetCostAndUsageWithResourcesInput) (*GetCostAndUsageWithResourcesOutput, error) {
	req, out := c.GetCostAndUsageWithResourcesRequest(input)
	return out, req.Send()
}

// GetCostAndUsageWithResourcesWithContext is the same as GetCostAndUsageWithResources with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostAndUsageWithResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostAndUsageWithResourcesWithContext(ctx aws.Context, input *GetCostAndUsageWithResourcesInput, opts ...request.Option) (*GetCostAndUsageWithResourcesOutput, error) {
	req, out := c.GetCostAndUsageWithResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostCategories = "GetCostCategories"

// GetCostCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the GetCostCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostCategories for more information on using the GetCostCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCostCategoriesRequest method.
//	req, resp := client.GetCostCategoriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostCategories
func (c *CostExplorer) GetCostCategoriesRequest(input *GetCostCategoriesInput) (req *request.Request, output *GetCostCategoriesOutput) {
	op := &request.Operation{
		Name:       opGetCostCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostCategoriesInput{}
	}

	output = &GetCostCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostCategories API operation for AWS Cost Explorer Service.
//
// Retrieves an array of Cost Category names and values incurred cost.
//
// If some Cost Category names and values are not associated with any cost,
// they will not be returned by this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostCategories for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - BillExpirationException
//     The requested report expired. Update the date interval and try again.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
//   - RequestChangedException
//     Your request parameters changed between pages. Try again with the old parameters
//     or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostCategories
func (c *CostExplorer) GetCostCategories(input *GetCostCategoriesInput) (*GetCostCategoriesOutput, error) {
	req, out := c.GetCostCategoriesRequest(input)
	return out, req.Send()
}

// GetCostCategoriesWithContext is the same as GetCostCategories with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostCategoriesWithContext(ctx aws.Context, input *GetCostCategoriesInput, opts ...request.Option) (*GetCostCategoriesOutput, error) {
	req, out := c.GetCostCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostForecast = "GetCostForecast"

// GetCostForecastRequest generates a "aws/request.Request" representing the
// client's request for the GetCostForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostForecast for more information on using the GetCostForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCostForecastRequest method.
//	req, resp := client.GetCostForecastRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast
func (c *CostExplorer) GetCostForecastRequest(input *GetCostForecastInput) (req *request.Request, output *GetCostForecastOutput) {
	op := &request.Operation{
		Name:       opGetCostForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostForecastInput{}
	}

	output = &GetCostForecastOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostForecast API operation for AWS Cost Explorer Service.
//
// Retrieves a forecast for how much Amazon Web Services predicts that you will
// spend over the forecast time period that you select, based on your past costs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostForecast for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast
func (c *CostExplorer) GetCostForecast(input *GetCostForecastInput) (*GetCostForecastOutput, error) {
	req, out := c.GetCostForecastRequest(input)
	return out, req.Send()
}

// GetCostForecastWithContext is the same as GetCostForecast with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostForecastWithContext(ctx aws.Context, input *GetCostForecastInput, opts ...request.Option) (*GetCostForecastOutput, error) {
	req, out := c.GetCostForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDimensionValues = "GetDimensionValues"

// GetDimensionValuesRequest generates a "aws/request.Request" representing the
// client's request for the GetDimensionValues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDimensionValues for more information on using the GetDimensionValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDimensionValuesRequest method.
//	req, resp := client.GetDimensionValuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValuesRequest(input *GetDimensionValuesInput) (req *request.Request, output *GetDimensionValuesOutput) {
	op := &request.Operation{
		Name:       opGetDimensionValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDimensionValuesInput{}
	}

	output = &GetDimensionValuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDimensionValues API operation for AWS Cost Explorer Service.
//
// Retrieves all available filter values for a specified filter over a period
// of time. You can search the dimension values for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetDimensionValues for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - BillExpirationException
//     The requested report expired. Update the date interval and try again.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
//   - RequestChangedException
//     Your request parameters changed between pages. Try again with the old parameters
//     or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValues(input *GetDimensionValuesInput) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	return out, req.Send()
}

// GetDimensionValuesWithContext is the same as GetDimensionValues with the addition of
// the ability to pass a context and additional request options.
//
// See GetDimensionValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetDimensionValuesWithContext(ctx aws.Context, input *GetDimensionValuesInput, opts ...request.Option) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationCoverage = "GetReservationCoverage"

// GetReservationCoverageRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationCoverage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationCoverage for more information on using the GetReservationCoverage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReservationCoverageRequest method.
//	req, resp := client.GetReservationCoverageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage
func (c *CostExplorer) GetReservationCoverageRequest(input *GetReservationCoverageInput) (req *request.Request, output *GetReservationCoverageOutput) {
	op := &request.Operation{
		Name:       opGetReservationCoverage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationCoverageInput{}
	}

	output = &GetReservationCoverageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationCoverage API operation for AWS Cost Explorer Service.
//
// Retrieves the reservation coverage for your account, which you can use to
// see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon
// Relational Database Service, or Amazon Redshift usage is covered by a reservation.
// An organization's management account can see the coverage of the associated
// member accounts. This supports dimensions, Cost Categories, and nested expressions.
// For any time period, you can filter data about reservation usage by the following
// dimensions:
//
//   - AZ
//
//   - CACHE_ENGINE
//
//   - DATABASE_ENGINE
//
//   - DEPLOYMENT_OPTION
//
//   - INSTANCE_TYPE
//
//   - LINKED_ACCOUNT
//
//   - OPERATING_SYSTEM
//
//   - PLATFORM
//
//   - REGION
//
//   - SERVICE
//
//   - TAG
//
//   - TENANCY
//
// To determine valid values for a dimension, use the GetDimensionValues operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationCoverage for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage
func (c *CostExplorer) GetReservationCoverage(input *GetReservationCoverageInput) (*GetReservationCoverageOutput, error) {
	req, out := c.GetReservationCoverageRequest(input)
	return out, req.Send()
}

// GetReservationCoverageWithContext is the same as GetReservationCoverage with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationCoverage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationCoverageWithContext(ctx aws.Context, input *GetReservationCoverageInput, opts ...request.Option) (*GetReservationCoverageOutput, error) {
	req, out := c.GetReservationCoverageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationPurchaseRecommendation = "GetReservationPurchaseRecommendation"

// GetReservationPurchaseRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationPurchaseRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationPurchaseRecommendation for more information on using the GetReservationPurchaseRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReservationPurchaseRecommendationRequest method.
//	req, resp := client.GetReservationPurchaseRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation
func (c *CostExplorer) GetReservationPurchaseRecommendationRequest(input *GetReservationPurchaseRecommendationInput) (req *request.Request, output *GetReservationPurchaseRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetReservationPurchaseRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationPurchaseRecommendationInput{}
	}

	output = &GetReservationPurchaseRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationPurchaseRecommendation API operation for AWS Cost Explorer Service.
//
// Gets recommendations for reservation purchases. These recommendations might
// help you to reduce your costs. Reservations provide a discounted hourly rate
// (up to 75%) compared to On-Demand pricing.
//
// Amazon Web Services generates your recommendations by identifying your On-Demand
// usage during a specific time period and collecting your usage into categories
// that are eligible for a reservation. After Amazon Web Services has these
// categories, it simulates every combination of reservations in each category
// of usage to identify the best number of each type of Reserved Instance (RI)
// to purchase to maximize your estimated savings.
//
// For example, Amazon Web Services automatically aggregates your Amazon EC2
// Linux, shared tenancy, and c4 family usage in the US West (Oregon) Region
// and recommends that you buy size-flexible regional reservations to apply
// to the c4 family usage. Amazon Web Services recommends the smallest size
// instance in an instance family. This makes it easier to purchase a size-flexible
// Reserved Instance (RI). Amazon Web Services also shows the equal number of
// normalized units. This way, you can purchase any instance size that you want.
// For this example, your RI recommendation is for c4.large because that is
// the smallest size instance in the c4 instance family.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationPurchaseRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation
func (c *CostExplorer) GetReservationPurchaseRecommendation(input *GetReservationPurchaseRecommendationInput) (*GetReservationPurchaseRecommendationOutput, error) {
	req, out := c.GetReservationPurchaseRecommendationRequest(input)
	return out, req.Send()
}

// GetReservationPurchaseRecommendationWithContext is the same as GetReservationPurchaseRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationPurchaseRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationPurchaseRecommendationWithContext(ctx aws.Context, input *GetReservationPurchaseRecommendationInput, opts ...request.Option) (*GetReservationPurchaseRecommendationOutput, error) {
	req, out := c.GetReservationPurchaseRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationUtilization = "GetReservationUtilization"

// GetReservationUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationUtilization for more information on using the GetReservationUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReservationUtilizationRequest method.
//	req, resp := client.GetReservationUtilizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilizationRequest(input *GetReservationUtilizationInput) (req *request.Request, output *GetReservationUtilizationOutput) {
	op := &request.Operation{
		Name:       opGetReservationUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationUtilizationInput{}
	}

	output = &GetReservationUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationUtilization API operation for AWS Cost Explorer Service.
//
// Retrieves the reservation utilization for your account. Management account
// in an organization have access to member accounts. You can filter data by
// dimensions in a time period. You can use GetDimensionValues to determine
// the possible dimension values. Currently, you can group only by SUBSCRIPTION_ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationUtilization for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilization(input *GetReservationUtilizationInput) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	return out, req.Send()
}

// GetReservationUtilizationWithContext is the same as GetReservationUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationUtilizationWithContext(ctx aws.Context, input *GetReservationUtilizationInput, opts ...request.Option) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRightsizingRecommendation = "GetRightsizingRecommendation"

// GetRightsizingRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetRightsizingRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRightsizingRecommendation for more information on using the GetRightsizingRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRightsizingRecommendationRequest method.
//	req, resp := client.GetRightsizingRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation
func (c *CostExplorer) GetRightsizingRecommendationRequest(input *GetRightsizingRecommendationInput) (req *request.Request, output *GetRightsizingRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetRightsizingRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRightsizingRecommendationInput{}
	}

	output = &GetRightsizingRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRightsizingRecommendation API operation for AWS Cost Explorer Service.
//
// Creates recommendations that help you save cost by identifying idle and underutilized
// Amazon EC2 instances.
//
// Recommendations are generated to either downsize or terminate instances,
// along with providing savings detail and metrics. For more information about
// calculation and function, see Optimizing Your Cost with Rightsizing Recommendations
// (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html)
// in the Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetRightsizingRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation
func (c *CostExplorer) GetRightsizingRecommendation(input *GetRightsizingRecommendationInput) (*GetRightsizingRecommendationOutput, error) {
	req, out := c.GetRightsizingRecommendationRequest(input)
	return out, req.Send()
}

// GetRightsizingRecommendationWithContext is the same as GetRightsizingRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetRightsizingRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetRightsizingRecommendationWithContext(ctx aws.Context, input *GetRightsizingRecommendationInput, opts ...request.Option) (*GetRightsizingRecommendationOutput, error) {
	req, out := c.GetRightsizingRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSavingsPlanPurchaseRecommendationDetails = "GetSavingsPlanPurchaseRecommendationDetails"

// GetSavingsPlanPurchaseRecommendationDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlanPurchaseRecommendationDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlanPurchaseRecommendationDetails for more information on using the GetSavingsPlanPurchaseRecommendationDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSavingsPlanPurchaseRecommendationDetailsRequest method.
//	req, resp := client.GetSavingsPlanPurchaseRecommendationDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlanPurchaseRecommendationDetails
func (c *CostExplorer) GetSavingsPlanPurchaseRecommendationDetailsRequest(input *GetSavingsPlanPurchaseRecommendationDetailsInput) (req *request.Request, output *GetSavingsPlanPurchaseRecommendationDetailsOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlanPurchaseRecommendationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSavingsPlanPurchaseRecommendationDetailsInput{}
	}

	output = &GetSavingsPlanPurchaseRecommendationDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlanPurchaseRecommendationDetails API operation for AWS Cost Explorer Service.
//
// Retrieves the details for a Savings Plan recommendation. These details include
// the hourly data-points that construct the cost, coverage, and utilization
// charts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlanPurchaseRecommendationDetails for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlanPurchaseRecommendationDetails
func (c *CostExplorer) GetSavingsPlanPurchaseRecommendationDetails(input *GetSavingsPlanPurchaseRecommendationDetailsInput) (*GetSavingsPlanPurchaseRecommendationDetailsOutput, error) {
	req, out := c.GetSavingsPlanPurchaseRecommendationDetailsRequest(input)
	return out, req.Send()
}

// GetSavingsPlanPurchaseRecommendationDetailsWithContext is the same as GetSavingsPlanPurchaseRecommendationDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlanPurchaseRecommendationDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlanPurchaseRecommendationDetailsWithContext(ctx aws.Context, input *GetSavingsPlanPurchaseRecommendationDetailsInput, opts ...request.Option) (*GetSavingsPlanPurchaseRecommendationDetailsOutput, error) {
	req, out := c.GetSavingsPlanPurchaseRecommendationDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSavingsPlansCoverage = "GetSavingsPlansCoverage"

// GetSavingsPlansCoverageRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansCoverage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansCoverage for more information on using the GetSavingsPlansCoverage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSavingsPlansCoverageRequest method.
//	req, resp := client.GetSavingsPlansCoverageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage
func (c *CostExplorer) GetSavingsPlansCoverageRequest(input *GetSavingsPlansCoverageInput) (req *request.Request, output *GetSavingsPlansCoverageOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansCoverage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSavingsPlansCoverageInput{}
	}

	output = &GetSavingsPlansCoverageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansCoverage API operation for AWS Cost Explorer Service.
//
// Retrieves the Savings Plans covered for your account. This enables you to
// see how much of your cost is covered by a Savings Plan. An organization’s
// management account can see the coverage of the associated member accounts.
// This supports dimensions, Cost Categories, and nested expressions. For any
// time period, you can filter data for Savings Plans usage with the following
// dimensions:
//
//   - LINKED_ACCOUNT
//
//   - REGION
//
//   - SERVICE
//
//   - INSTANCE_FAMILY
//
// To determine valid values for a dimension, use the GetDimensionValues operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansCoverage for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage
func (c *CostExplorer) GetSavingsPlansCoverage(input *GetSavingsPlansCoverageInput) (*GetSavingsPlansCoverageOutput, error) {
	req, out := c.GetSavingsPlansCoverageRequest(input)
	return out, req.Send()
}

// GetSavingsPlansCoverageWithContext is the same as GetSavingsPlansCoverage with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansCoverage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansCoverageWithContext(ctx aws.Context, input *GetSavingsPlansCoverageInput, opts ...request.Option) (*GetSavingsPlansCoverageOutput, error) {
	req, out := c.GetSavingsPlansCoverageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSavingsPlansCoveragePages iterates over the pages of a GetSavingsPlansCoverage operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSavingsPlansCoverage method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetSavingsPlansCoverage operation.
//	pageNum := 0
//	err := client.GetSavingsPlansCoveragePages(params,
//	    func(page *costexplorer.GetSavingsPlansCoverageOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostExplorer) GetSavingsPlansCoveragePages(input *GetSavingsPlansCoverageInput, fn func(*GetSavingsPlansCoverageOutput, bool) bool) error {
	return c.GetSavingsPlansCoveragePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSavingsPlansCoveragePagesWithContext same as GetSavingsPlansCoveragePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansCoveragePagesWithContext(ctx aws.Context, input *GetSavingsPlansCoverageInput, fn func(*GetSavingsPlansCoverageOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSavingsPlansCoverageInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSavingsPlansCoverageRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSavingsPlansCoverageOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSavingsPlansPurchaseRecommendation = "GetSavingsPlansPurchaseRecommendation"

// GetSavingsPlansPurchaseRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansPurchaseRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansPurchaseRecommendation for more information on using the GetSavingsPlansPurchaseRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSavingsPlansPurchaseRecommendationRequest method.
//	req, resp := client.GetSavingsPlansPurchaseRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation
func (c *CostExplorer) GetSavingsPlansPurchaseRecommendationRequest(input *GetSavingsPlansPurchaseRecommendationInput) (req *request.Request, output *GetSavingsPlansPurchaseRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansPurchaseRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSavingsPlansPurchaseRecommendationInput{}
	}

	output = &GetSavingsPlansPurchaseRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansPurchaseRecommendation API operation for AWS Cost Explorer Service.
//
// Retrieves the Savings Plans recommendations for your account. First use StartSavingsPlansPurchaseRecommendationGeneration
// to generate a new set of recommendations, and then use GetSavingsPlansPurchaseRecommendation
// to retrieve them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansPurchaseRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation
func (c *CostExplorer) GetSavingsPlansPurchaseRecommendation(input *GetSavingsPlansPurchaseRecommendationInput) (*GetSavingsPlansPurchaseRecommendationOutput, error) {
	req, out := c.GetSavingsPlansPurchaseRecommendationRequest(input)
	return out, req.Send()
}

// GetSavingsPlansPurchaseRecommendationWithContext is the same as GetSavingsPlansPurchaseRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansPurchaseRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansPurchaseRecommendationWithContext(ctx aws.Context, input *GetSavingsPlansPurchaseRecommendationInput, opts ...request.Option) (*GetSavingsPlansPurchaseRecommendationOutput, error) {
	req, out := c.GetSavingsPlansPurchaseRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSavingsPlansUtilization = "GetSavingsPlansUtilization"

// GetSavingsPlansUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansUtilization for more information on using the GetSavingsPlansUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSavingsPlansUtilizationRequest method.
//	req, resp := client.GetSavingsPlansUtilizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization
func (c *CostExplorer) GetSavingsPlansUtilizationRequest(input *GetSavingsPlansUtilizationInput) (req *request.Request, output *GetSavingsPlansUtilizationOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSavingsPlansUtilizationInput{}
	}

	output = &GetSavingsPlansUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansUtilization API operation for AWS Cost Explorer Service.
//
// Retrieves the Savings Plans utilization for your account across date ranges
// with daily or monthly granularity. Management account in an organization
// have access to member accounts. You can use GetDimensionValues in SAVINGS_PLANS
// to determine the possible dimension values.
//
// You can't group by any dimension values for GetSavingsPlansUtilization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansUtilization for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization
func (c *CostExplorer) GetSavingsPlansUtilization(input *GetSavingsPlansUtilizationInput) (*GetSavingsPlansUtilizationOutput, error) {
	req, out := c.GetSavingsPlansUtilizationRequest(input)
	return out, req.Send()
}

// GetSavingsPlansUtilizationWithContext is the same as GetSavingsPlansUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansUtilizationWithContext(ctx aws.Context, input *GetSavingsPlansUtilizationInput, opts ...request.Option) (*GetSavingsPlansUtilizationOutput, error) {
	req, out := c.GetSavingsPlansUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSavingsPlansUtilizationDetails = "GetSavingsPlansUtilizationDetails"

// GetSavingsPlansUtilizationDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansUtilizationDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansUtilizationDetails for more information on using the GetSavingsPlansUtilizationDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSavingsPlansUtilizationDetailsRequest method.
//	req, resp := client.GetSavingsPlansUtilizationDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsRequest(input *GetSavingsPlansUtilizationDetailsInput) (req *request.Request, output *GetSavingsPlansUtilizationDetailsOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansUtilizationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSavingsPlansUtilizationDetailsInput{}
	}

	output = &GetSavingsPlansUtilizationDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansUtilizationDetails API operation for AWS Cost Explorer Service.
//
// Retrieves attribute data along with aggregate utilization and savings data
// for a given time period. This doesn't support granular or grouped data (daily/monthly)
// in response. You can't retrieve data by dates in a single response similar
// to GetSavingsPlanUtilization, but you have the option to make multiple calls
// to GetSavingsPlanUtilizationDetails by providing individual dates. You can
// use GetDimensionValues in SAVINGS_PLANS to determine the possible dimension
// values.
//
// GetSavingsPlanUtilizationDetails internally groups data by SavingsPlansArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansUtilizationDetails for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails
func (c *CostExplorer) GetSavingsPlansUtilizationDetails(input *GetSavingsPlansUtilizationDetailsInput) (*GetSavingsPlansUtilizationDetailsOutput, error) {
	req, out := c.GetSavingsPlansUtilizationDetailsRequest(input)
	return out, req.Send()
}

// GetSavingsPlansUtilizationDetailsWithContext is the same as GetSavingsPlansUtilizationDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansUtilizationDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsWithContext(ctx aws.Context, input *GetSavingsPlansUtilizationDetailsInput, opts ...request.Option) (*GetSavingsPlansUtilizationDetailsOutput, error) {
	req, out := c.GetSavingsPlansUtilizationDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSavingsPlansUtilizationDetailsPages iterates over the pages of a GetSavingsPlansUtilizationDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSavingsPlansUtilizationDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetSavingsPlansUtilizationDetails operation.
//	pageNum := 0
//	err := client.GetSavingsPlansUtilizationDetailsPages(params,
//	    func(page *costexplorer.GetSavingsPlansUtilizationDetailsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsPages(input *GetSavingsPlansUtilizationDetailsInput, fn func(*GetSavingsPlansUtilizationDetailsOutput, bool) bool) error {
	return c.GetSavingsPlansUtilizationDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSavingsPlansUtilizationDetailsPagesWithContext same as GetSavingsPlansUtilizationDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsPagesWithContext(ctx aws.Context, input *GetSavingsPlansUtilizationDetailsInput, fn func(*GetSavingsPlansUtilizationDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSavingsPlansUtilizationDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSavingsPlansUtilizationDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSavingsPlansUtilizationDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTagsRequest method.
//	req, resp := client.GetTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AWS Cost Explorer Service.
//
// Queries for available tag keys and tag values for a specified period. You
// can search the tag values for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetTags for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - BillExpirationException
//     The requested report expired. Update the date interval and try again.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
//   - RequestChangedException
//     Your request parameters changed between pages. Try again with the old parameters
//     or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsageForecast = "GetUsageForecast"

// GetUsageForecastRequest generates a "aws/request.Request" representing the
// client's request for the GetUsageForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsageForecast for more information on using the GetUsageForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUsageForecastRequest method.
//	req, resp := client.GetUsageForecastRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast
func (c *CostExplorer) GetUsageForecastRequest(input *GetUsageForecastInput) (req *request.Request, output *GetUsageForecastOutput) {
	op := &request.Operation{
		Name:       opGetUsageForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUsageForecastInput{}
	}

	output = &GetUsageForecastOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsageForecast API operation for AWS Cost Explorer Service.
//
// Retrieves a forecast for how much Amazon Web Services predicts that you will
// use over the forecast time period that you select, based on your past usage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetUsageForecast for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
//   - UnresolvableUsageUnitException
//     Cost Explorer was unable to identify the usage unit. Provide UsageType/UsageTypeGroup
//     filter selections that contain matching units, for example: hours.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast
func (c *CostExplorer) GetUsageForecast(input *GetUsageForecastInput) (*GetUsageForecastOutput, error) {
	req, out := c.GetUsageForecastRequest(input)
	return out, req.Send()
}

// GetUsageForecastWithContext is the same as GetUsageForecast with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsageForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetUsageForecastWithContext(ctx aws.Context, input *GetUsageForecastInput, opts ...request.Option) (*GetUsageForecastOutput, error) {
	req, out := c.GetUsageForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCostAllocationTags = "ListCostAllocationTags"

// ListCostAllocationTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListCostAllocationTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCostAllocationTags for more information on using the ListCostAllocationTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCostAllocationTagsRequest method.
//	req, resp := client.ListCostAllocationTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostAllocationTags
func (c *CostExplorer) ListCostAllocationTagsRequest(input *ListCostAllocationTagsInput) (req *request.Request, output *ListCostAllocationTagsOutput) {
	op := &request.Operation{
		Name:       opListCostAllocationTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCostAllocationTagsInput{}
	}

	output = &ListCostAllocationTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCostAllocationTags API operation for AWS Cost Explorer Service.
//
// Get a list of cost allocation tags. All inputs in the API are optional and
// serve as filters. By default, all cost allocation tags are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation ListCostAllocationTags for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostAllocationTags
func (c *CostExplorer) ListCostAllocationTags(input *ListCostAllocationTagsInput) (*ListCostAllocationTagsOutput, error) {
	req, out := c.ListCostAllocationTagsRequest(input)
	return out, req.Send()
}

// ListCostAllocationTagsWithContext is the same as ListCostAllocationTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListCostAllocationTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListCostAllocationTagsWithContext(ctx aws.Context, input *ListCostAllocationTagsInput, opts ...request.Option) (*ListCostAllocationTagsOutput, error) {
	req, out := c.ListCostAllocationTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCostAllocationTagsPages iterates over the pages of a ListCostAllocationTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCostAllocationTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCostAllocationTags operation.
//	pageNum := 0
//	err := client.ListCostAllocationTagsPages(params,
//	    func(page *costexplorer.ListCostAllocationTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostExplorer) ListCostAllocationTagsPages(input *ListCostAllocationTagsInput, fn func(*ListCostAllocationTagsOutput, bool) bool) error {
	return c.ListCostAllocationTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCostAllocationTagsPagesWithContext same as ListCostAllocationTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListCostAllocationTagsPagesWithContext(ctx aws.Context, input *ListCostAllocationTagsInput, fn func(*ListCostAllocationTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCostAllocationTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCostAllocationTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCostAllocationTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCostCategoryDefinitions = "ListCostCategoryDefinitions"

// ListCostCategoryDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCostCategoryDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCostCategoryDefinitions for more information on using the ListCostCategoryDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCostCategoryDefinitionsRequest method.
//	req, resp := client.ListCostCategoryDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions
func (c *CostExplorer) ListCostCategoryDefinitionsRequest(input *ListCostCategoryDefinitionsInput) (req *request.Request, output *ListCostCategoryDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListCostCategoryDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCostCategoryDefinitionsInput{}
	}

	output = &ListCostCategoryDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCostCategoryDefinitions API operation for AWS Cost Explorer Service.
//
// Returns the name, Amazon Resource Name (ARN), NumberOfRules and effective
// dates of all Cost Categories defined in the account. You have the option
// to use EffectiveOn to return a list of Cost Categories that were active on
// a specific date. If there is no EffectiveOn specified, you’ll see Cost
// Categories that are effective on the current date. If Cost Category is still
// effective, EffectiveEnd is omitted in the response. ListCostCategoryDefinitions
// supports pagination. The request can have a MaxResults range up to 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation ListCostCategoryDefinitions for usage and error information.
//
// Returned Error Types:
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions
func (c *CostExplorer) ListCostCategoryDefinitions(input *ListCostCategoryDefinitionsInput) (*ListCostCategoryDefinitionsOutput, error) {
	req, out := c.ListCostCategoryDefinitionsRequest(input)
	return out, req.Send()
}

// ListCostCategoryDefinitionsWithContext is the same as ListCostCategoryDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCostCategoryDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListCostCategoryDefinitionsWithContext(ctx aws.Context, input *ListCostCategoryDefinitionsInput, opts ...request.Option) (*ListCostCategoryDefinitionsOutput, error) {
	req, out := c.ListCostCategoryDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCostCategoryDefinitionsPages iterates over the pages of a ListCostCategoryDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCostCategoryDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCostCategoryDefinitions operation.
//	pageNum := 0
//	err := client.ListCostCategoryDefinitionsPages(params,
//	    func(page *costexplorer.ListCostCategoryDefinitionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CostExplorer) ListCostCategoryDefinitionsPages(input *ListCostCategoryDefinitionsInput, fn func(*ListCostCategoryDefinitionsOutput, bool) bool) error {
	return c.ListCostCategoryDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCostCategoryDefinitionsPagesWithContext same as ListCostCategoryDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListCostCategoryDefinitionsPagesWithContext(ctx aws.Context, input *ListCostCategoryDefinitionsInput, fn func(*ListCostCategoryDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCostCategoryDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCostCategoryDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCostCategoryDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSavingsPlansPurchaseRecommendationGeneration = "ListSavingsPlansPurchaseRecommendationGeneration"

// ListSavingsPlansPurchaseRecommendationGenerationRequest generates a "aws/request.Request" representing the
// client's request for the ListSavingsPlansPurchaseRecommendationGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSavingsPlansPurchaseRecommendationGeneration for more information on using the ListSavingsPlansPurchaseRecommendationGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSavingsPlansPurchaseRecommendationGenerationRequest method.
//	req, resp := client.ListSavingsPlansPurchaseRecommendationGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListSavingsPlansPurchaseRecommendationGeneration
func (c *CostExplorer) ListSavingsPlansPurchaseRecommendationGenerationRequest(input *ListSavingsPlansPurchaseRecommendationGenerationInput) (req *request.Request, output *ListSavingsPlansPurchaseRecommendationGenerationOutput) {
	op := &request.Operation{
		Name:       opListSavingsPlansPurchaseRecommendationGeneration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSavingsPlansPurchaseRecommendationGenerationInput{}
	}

	output = &ListSavingsPlansPurchaseRecommendationGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSavingsPlansPurchaseRecommendationGeneration API operation for AWS Cost Explorer Service.
//
// Retrieves a list of your historical recommendation generations within the
// past 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation ListSavingsPlansPurchaseRecommendationGeneration for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - InvalidNextTokenException
//     The pagination token is invalid. Try again without a pagination token.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListSavingsPlansPurchaseRecommendationGeneration
func (c *CostExplorer) ListSavingsPlansPurchaseRecommendationGeneration(input *ListSavingsPlansPurchaseRecommendationGenerationInput) (*ListSavingsPlansPurchaseRecommendationGenerationOutput, error) {
	req, out := c.ListSavingsPlansPurchaseRecommendationGenerationRequest(input)
	return out, req.Send()
}

// ListSavingsPlansPurchaseRecommendationGenerationWithContext is the same as ListSavingsPlansPurchaseRecommendationGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See ListSavingsPlansPurchaseRecommendationGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListSavingsPlansPurchaseRecommendationGenerationWithContext(ctx aws.Context, input *ListSavingsPlansPurchaseRecommendationGenerationInput, opts ...request.Option) (*ListSavingsPlansPurchaseRecommendationGenerationOutput, error) {
	req, out := c.ListSavingsPlansPurchaseRecommendationGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListTagsForResource
func (c *CostExplorer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Cost Explorer Service.
//
// Returns a list of resource tags associated with the resource specified by
// the Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ARN in the request doesn't exist.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListTagsForResource
func (c *CostExplorer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opProvideAnomalyFeedback = "ProvideAnomalyFeedback"

// ProvideAnomalyFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the ProvideAnomalyFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ProvideAnomalyFeedback for more information on using the ProvideAnomalyFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ProvideAnomalyFeedbackRequest method.
//	req, resp := client.ProvideAnomalyFeedbackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback
func (c *CostExplorer) ProvideAnomalyFeedbackRequest(input *ProvideAnomalyFeedbackInput) (req *request.Request, output *ProvideAnomalyFeedbackOutput) {
	op := &request.Operation{
		Name:       opProvideAnomalyFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvideAnomalyFeedbackInput{}
	}

	output = &ProvideAnomalyFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ProvideAnomalyFeedback API operation for AWS Cost Explorer Service.
//
// Modifies the feedback property of a given cost anomaly.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation ProvideAnomalyFeedback for usage and error information.
//
// Returned Error Types:
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback
func (c *CostExplorer) ProvideAnomalyFeedback(input *ProvideAnomalyFeedbackInput) (*ProvideAnomalyFeedbackOutput, error) {
	req, out := c.ProvideAnomalyFeedbackRequest(input)
	return out, req.Send()
}

// ProvideAnomalyFeedbackWithContext is the same as ProvideAnomalyFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See ProvideAnomalyFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ProvideAnomalyFeedbackWithContext(ctx aws.Context, input *ProvideAnomalyFeedbackInput, opts ...request.Option) (*ProvideAnomalyFeedbackOutput, error) {
	req, out := c.ProvideAnomalyFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSavingsPlansPurchaseRecommendationGeneration = "StartSavingsPlansPurchaseRecommendationGeneration"

// StartSavingsPlansPurchaseRecommendationGenerationRequest generates a "aws/request.Request" representing the
// client's request for the StartSavingsPlansPurchaseRecommendationGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSavingsPlansPurchaseRecommendationGeneration for more information on using the StartSavingsPlansPurchaseRecommendationGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSavingsPlansPurchaseRecommendationGenerationRequest method.
//	req, resp := client.StartSavingsPlansPurchaseRecommendationGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/StartSavingsPlansPurchaseRecommendationGeneration
func (c *CostExplorer) StartSavingsPlansPurchaseRecommendationGenerationRequest(input *StartSavingsPlansPurchaseRecommendationGenerationInput) (req *request.Request, output *StartSavingsPlansPurchaseRecommendationGenerationOutput) {
	op := &request.Operation{
		Name:       opStartSavingsPlansPurchaseRecommendationGeneration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSavingsPlansPurchaseRecommendationGenerationInput{}
	}

	output = &StartSavingsPlansPurchaseRecommendationGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSavingsPlansPurchaseRecommendationGeneration API operation for AWS Cost Explorer Service.
//
// Requests a Savings Plans recommendation generation. This enables you to calculate
// a fresh set of Savings Plans recommendations that takes your latest usage
// data and current Savings Plans inventory into account. You can refresh Savings
// Plans recommendations up to three times daily for a consolidated billing
// family.
//
// StartSavingsPlansPurchaseRecommendationGeneration has no request syntax because
// no input parameters are needed to support this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation StartSavingsPlansPurchaseRecommendationGeneration for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - ServiceQuotaExceededException
//     You've reached the limit on the number of resources you can create, or exceeded
//     the size of an individual resource.
//
//   - GenerationExistsException
//     A request to generate a recommendation is already in progress.
//
//   - DataUnavailableException
//     The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/StartSavingsPlansPurchaseRecommendationGeneration
func (c *CostExplorer) StartSavingsPlansPurchaseRecommendationGeneration(input *StartSavingsPlansPurchaseRecommendationGenerationInput) (*StartSavingsPlansPurchaseRecommendationGenerationOutput, error) {
	req, out := c.StartSavingsPlansPurchaseRecommendationGenerationRequest(input)
	return out, req.Send()
}

// StartSavingsPlansPurchaseRecommendationGenerationWithContext is the same as StartSavingsPlansPurchaseRecommendationGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See StartSavingsPlansPurchaseRecommendationGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) StartSavingsPlansPurchaseRecommendationGenerationWithContext(ctx aws.Context, input *StartSavingsPlansPurchaseRecommendationGenerationInput, opts ...request.Option) (*StartSavingsPlansPurchaseRecommendationGenerationOutput, error) {
	req, out := c.StartSavingsPlansPurchaseRecommendationGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/TagResource
func (c *CostExplorer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Cost Explorer Service.
//
// An API operation for adding one or more tags (key-value pairs) to a resource.
//
// You can use the TagResource operation with a resource that already has tags.
// If you specify a new tag key for the resource, this tag is appended to the
// list of tags associated with the resource. If you specify a tag key that
// is already associated with the resource, the new tag value you specify replaces
// the previous value for that tag.
//
// Although the maximum number of array members is 200, user-tag maximum is
// 50. The remaining are reserved for Amazon Web Services use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ARN in the request doesn't exist.
//
//   - TooManyTagsException
//     Can occur if you specify a number of tags for a resource greater than the
//     maximum 50 user tags per resource.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/TagResource
func (c *CostExplorer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UntagResource
func (c *CostExplorer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Cost Explorer Service.
//
// Removes one or more tags from a resource. Specify only tag keys in your request.
// Don't specify the value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ARN in the request doesn't exist.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UntagResource
func (c *CostExplorer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnomalyMonitor = "UpdateAnomalyMonitor"

// UpdateAnomalyMonitorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnomalyMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnomalyMonitor for more information on using the UpdateAnomalyMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnomalyMonitorRequest method.
//	req, resp := client.UpdateAnomalyMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor
func (c *CostExplorer) UpdateAnomalyMonitorRequest(input *UpdateAnomalyMonitorInput) (req *request.Request, output *UpdateAnomalyMonitorOutput) {
	op := &request.Operation{
		Name:       opUpdateAnomalyMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAnomalyMonitorInput{}
	}

	output = &UpdateAnomalyMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnomalyMonitor API operation for AWS Cost Explorer Service.
//
// Updates an existing cost anomaly monitor. The changes made are applied going
// forward, and doesn't change anomalies detected in the past.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UpdateAnomalyMonitor for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - UnknownMonitorException
//     The cost anomaly monitor does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor
func (c *CostExplorer) UpdateAnomalyMonitor(input *UpdateAnomalyMonitorInput) (*UpdateAnomalyMonitorOutput, error) {
	req, out := c.UpdateAnomalyMonitorRequest(input)
	return out, req.Send()
}

// UpdateAnomalyMonitorWithContext is the same as UpdateAnomalyMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnomalyMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UpdateAnomalyMonitorWithContext(ctx aws.Context, input *UpdateAnomalyMonitorInput, opts ...request.Option) (*UpdateAnomalyMonitorOutput, error) {
	req, out := c.UpdateAnomalyMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnomalySubscription = "UpdateAnomalySubscription"

// UpdateAnomalySubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnomalySubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnomalySubscription for more information on using the UpdateAnomalySubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnomalySubscriptionRequest method.
//	req, resp := client.UpdateAnomalySubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription
func (c *CostExplorer) UpdateAnomalySubscriptionRequest(input *UpdateAnomalySubscriptionInput) (req *request.Request, output *UpdateAnomalySubscriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateAnomalySubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAnomalySubscriptionInput{}
	}

	output = &UpdateAnomalySubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnomalySubscription API operation for AWS Cost Explorer Service.
//
// Updates an existing cost anomaly subscription. Specify the fields that you
// want to update. Omitted fields are unchanged.
//
// The JSON below describes the generic construct for each type. See Request
// Parameters (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateAnomalySubscription.html#API_UpdateAnomalySubscription_RequestParameters)
// for possible values as they apply to AnomalySubscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UpdateAnomalySubscription for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
//   - UnknownMonitorException
//     The cost anomaly monitor does not exist for the account.
//
//   - UnknownSubscriptionException
//     The cost anomaly subscription does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription
func (c *CostExplorer) UpdateAnomalySubscription(input *UpdateAnomalySubscriptionInput) (*UpdateAnomalySubscriptionOutput, error) {
	req, out := c.UpdateAnomalySubscriptionRequest(input)
	return out, req.Send()
}

// UpdateAnomalySubscriptionWithContext is the same as UpdateAnomalySubscription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnomalySubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UpdateAnomalySubscriptionWithContext(ctx aws.Context, input *UpdateAnomalySubscriptionInput, opts ...request.Option) (*UpdateAnomalySubscriptionOutput, error) {
	req, out := c.UpdateAnomalySubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCostAllocationTagsStatus = "UpdateCostAllocationTagsStatus"

// UpdateCostAllocationTagsStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCostAllocationTagsStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCostAllocationTagsStatus for more information on using the UpdateCostAllocationTagsStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCostAllocationTagsStatusRequest method.
//	req, resp := client.UpdateCostAllocationTagsStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostAllocationTagsStatus
func (c *CostExplorer) UpdateCostAllocationTagsStatusRequest(input *UpdateCostAllocationTagsStatusInput) (req *request.Request, output *UpdateCostAllocationTagsStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateCostAllocationTagsStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCostAllocationTagsStatusInput{}
	}

	output = &UpdateCostAllocationTagsStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCostAllocationTagsStatus API operation for AWS Cost Explorer Service.
//
// Updates status for cost allocation tags in bulk, with maximum batch size
// of 20. If the tag status that's updated is the same as the existing tag status,
// the request doesn't fail. Instead, it doesn't have any effect on the tag
// status (for example, activating the active tag).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UpdateCostAllocationTagsStatus for usage and error information.
//
// Returned Error Types:
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostAllocationTagsStatus
func (c *CostExplorer) UpdateCostAllocationTagsStatus(input *UpdateCostAllocationTagsStatusInput) (*UpdateCostAllocationTagsStatusOutput, error) {
	req, out := c.UpdateCostAllocationTagsStatusRequest(input)
	return out, req.Send()
}

// UpdateCostAllocationTagsStatusWithContext is the same as UpdateCostAllocationTagsStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCostAllocationTagsStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UpdateCostAllocationTagsStatusWithContext(ctx aws.Context, input *UpdateCostAllocationTagsStatusInput, opts ...request.Option) (*UpdateCostAllocationTagsStatusOutput, error) {
	req, out := c.UpdateCostAllocationTagsStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCostCategoryDefinition = "UpdateCostCategoryDefinition"

// UpdateCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCostCategoryDefinition for more information on using the UpdateCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCostCategoryDefinitionRequest method.
//	req, resp := client.UpdateCostCategoryDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition
func (c *CostExplorer) UpdateCostCategoryDefinitionRequest(input *UpdateCostCategoryDefinitionInput) (req *request.Request, output *UpdateCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCostCategoryDefinitionInput{}
	}

	output = &UpdateCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Updates an existing Cost Category. Changes made to the Cost Category rules
// will be used to categorize the current month’s expenses and future expenses.
// This won’t change categorization for the previous months.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UpdateCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ARN in the request doesn't exist.
//
//   - ServiceQuotaExceededException
//     You've reached the limit on the number of resources you can create, or exceeded
//     the size of an individual resource.
//
//   - LimitExceededException
//     You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition
func (c *CostExplorer) UpdateCostCategoryDefinition(input *UpdateCostCategoryDefinitionInput) (*UpdateCostCategoryDefinitionOutput, error) {
	req, out := c.UpdateCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// UpdateCostCategoryDefinitionWithContext is the same as UpdateCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UpdateCostCategoryDefinitionWithContext(ctx aws.Context, input *UpdateCostCategoryDefinitionInput, opts ...request.Option) (*UpdateCostCategoryDefinitionOutput, error) {
	req, out := c.UpdateCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An unusual cost pattern. This consists of the detailed metadata and the current
// status of the anomaly object.
type Anomaly struct {
	_ struct{} `type:"structure"`

	// The last day the anomaly is detected.
	AnomalyEndDate *string `type:"string"`

	// The unique identifier for the anomaly.
	//
	// AnomalyId is a required field
	AnomalyId *string `type:"string" required:"true"`

	// The latest and maximum score for the anomaly.
	//
	// AnomalyScore is a required field
	AnomalyScore *AnomalyScore `type:"structure" required:"true"`

	// The first day the anomaly is detected.
	AnomalyStartDate *string `type:"string"`

	// The dimension for the anomaly (for example, an Amazon Web Service in a service
	// monitor).
	DimensionValue *string `type:"string"`

	// The feedback value.
	Feedback *string `type:"string" enum:"AnomalyFeedbackType"`

	// The dollar impact for the anomaly.
	//
	// Impact is a required field
	Impact *Impact `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the cost monitor that generated this anomaly.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`

	// The list of identified root causes for the anomaly.
	RootCauses []*RootCause `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Anomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Anomaly) GoString() string {
	return s.String()
}

// SetAnomalyEndDate sets the AnomalyEndDate field's value.
func (s *Anomaly) SetAnomalyEndDate(v string) *Anomaly {
	s.AnomalyEndDate = &v
	return s
}

// SetAnomalyId sets the AnomalyId field's value.
func (s *Anomaly) SetAnomalyId(v string) *Anomaly {
	s.AnomalyId = &v
	return s
}

// SetAnomalyScore sets the AnomalyScore field's value.
func (s *Anomaly) SetAnomalyScore(v *AnomalyScore) *Anomaly {
	s.AnomalyScore = v
	return s
}

// SetAnomalyStartDate sets the AnomalyStartDate field's value.
func (s *Anomaly) SetAnomalyStartDate(v string) *Anomaly {
	s.AnomalyStartDate = &v
	return s
}

// SetDimensionValue sets the DimensionValue field's value.
func (s *Anomaly) SetDimensionValue(v string) *Anomaly {
	s.DimensionValue = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *Anomaly) SetFeedback(v string) *Anomaly {
	s.Feedback = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *Anomaly) SetImpact(v *Impact) *Anomaly {
	s.Impact = v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *Anomaly) SetMonitorArn(v string) *Anomaly {
	s.MonitorArn = &v
	return s
}

// SetRootCauses sets the RootCauses field's value.
func (s *Anomaly) SetRootCauses(v []*RootCause) *Anomaly {
	s.RootCauses = v
	return s
}

// The time period for an anomaly.
type AnomalyDateInterval struct {
	_ struct{} `type:"structure"`

	// The last date an anomaly was observed.
	EndDate *string `type:"string"`

	// The first date an anomaly was observed.
	//
	// StartDate is a required field
	StartDate *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDateInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDateInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalyDateInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalyDateInterval"}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDate sets the EndDate field's value.
func (s *AnomalyDateInterval) SetEndDate(v string) *AnomalyDateInterval {
	s.EndDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *AnomalyDateInterval) SetStartDate(v string) *AnomalyDateInterval {
	s.StartDate = &v
	return s
}

// This object continuously inspects your account's cost data for anomalies.
// It's based on MonitorType and MonitorSpecification. The content consists
// of detailed metadata and the current status of the monitor object.
type AnomalyMonitor struct {
	_ struct{} `type:"structure"`

	// The date when the monitor was created.
	CreationDate *string `type:"string"`

	// The value for evaluated dimensions.
	DimensionalValueCount *int64 `type:"integer"`

	// The date when the monitor last evaluated for anomalies.
	LastEvaluatedDate *string `type:"string"`

	// The date when the monitor was last updated.
	LastUpdatedDate *string `type:"string"`

	// The Amazon Resource Name (ARN) value.
	MonitorArn *string `type:"string"`

	// The dimensions to evaluate.
	MonitorDimension *string `type:"string" enum:"MonitorDimension"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `type:"string" required:"true"`

	// Use Expression to filter in various Cost Explorer APIs.
	//
	// Not all Expression types are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// There are two patterns:
	//
	//    * Simple dimension values. There are three types of simple dimension values:
	//    CostCategories, Tags, and Dimensions. Specify the CostCategories field
	//    to define a filter that acts on Cost Categories. Specify the Tags field
	//    to define a filter that acts on Cost Allocation Tags. Specify the Dimensions
	//    field to define a filter that acts on the DimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html).
	//    For each filter type, you can set the dimension name and values for the
	//    filters that you plan to use. For example, you can filter for REGION==us-east-1
	//    OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is
	//    a full name (for example, REGION==US East (N. Virginia). The corresponding
	//    Expression for this example is as follows: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", "us-west-1" ] } } As shown in the previous example,
	//    lists of dimension values are combined with OR when applying the filter.
	//    You can also set different match options to further control how the filter
	//    behaves. Not all APIs support match options. Refer to the documentation
	//    for each specific API to see what is supported. For example, you can filter
	//    for linked account names that start with "a". The corresponding Expression
	//    for this example is as follows: { "Dimensions": { "Key": "LINKED_ACCOUNT_NAME",
	//    "MatchOptions": [ "STARTS_WITH" ], "Values": [ "a" ] } }
	//
	//    * Compound Expression types with logical operations. You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. By doing this, you can filter by more
	//    advanced options. For example, you can filter by ((REGION == us-east-1
	//    OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The corresponding Expression for this example is as follows: { "And":
	//    [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
	//    "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] }
	//    } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
	//    }}} ] } Because each Expression can have only one operator, the service
	//    returns an error if more than one is specified. The following example
	//    shows an Expression object that creates an error: { "And": [ ... ], "Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } The following
	//    is an example of the corresponding error message: "Expression has more
	//    than one roots. Only one root operator is allowed for each expression:
	//    And, Or, Not, Dimensions, Tags, CostCategories"
	//
	// For the GetRightsizingRecommendation action, a combination of OR and NOT
	// isn't supported. OR isn't supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	//
	// For the GetReservationPurchaseRecommendation action, only NOT is supported.
	// AND and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT.
	MonitorSpecification *Expression `type:"structure"`

	// The possible type values.
	//
	// MonitorType is a required field
	MonitorType *string `type:"string" required:"true" enum:"MonitorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyMonitor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyMonitor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalyMonitor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalyMonitor"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorType == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorType"))
	}
	if s.MonitorSpecification != nil {
		if err := s.MonitorSpecification.Validate(); err != nil {
			invalidParams.AddNested("MonitorSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationDate sets the CreationDate field's value.
func (s *AnomalyMonitor) SetCreationDate(v string) *AnomalyMonitor {
	s.CreationDate = &v
	return s
}

// SetDimensionalValueCount sets the DimensionalValueCount field's value.
func (s *AnomalyMonitor) SetDimensionalValueCount(v int64) *AnomalyMonitor {
	s.DimensionalValueCount = &v
	return s
}

// SetLastEvaluatedDate sets the LastEvaluatedDate field's value.
func (s *AnomalyMonitor) SetLastEvaluatedDate(v string) *AnomalyMonitor {
	s.LastEvaluatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AnomalyMonitor) SetLastUpdatedDate(v string) *AnomalyMonitor {
	s.LastUpdatedDate = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *AnomalyMonitor) SetMonitorArn(v string) *AnomalyMonitor {
	s.MonitorArn = &v
	return s
}

// SetMonitorDimension sets the MonitorDimension field's value.
func (s *AnomalyMonitor) SetMonitorDimension(v string) *AnomalyMonitor {
	s.MonitorDimension = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *AnomalyMonitor) SetMonitorName(v string) *AnomalyMonitor {
	s.MonitorName = &v
	return s
}

// SetMonitorSpecification sets the MonitorSpecification field's value.
func (s *AnomalyMonitor) SetMonitorSpecification(v *Expression) *AnomalyMonitor {
	s.MonitorSpecification = v
	return s
}

// SetMonitorType sets the MonitorType field's value.
func (s *AnomalyMonitor) SetMonitorType(v string) *AnomalyMonitor {
	s.MonitorType = &v
	return s
}

// Quantifies the anomaly. The higher score means that it's more anomalous.
type AnomalyScore struct {
	_ struct{} `type:"structure"`

	// The last observed score.
	//
	// CurrentScore is a required field
	CurrentScore *float64 `type:"double" required:"true"`

	// The maximum score that's observed during the AnomalyDateInterval.
	//
	// MaxScore is a required field
	MaxScore *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyScore) GoString() string {
	return s.String()
}

// SetCurrentScore sets the CurrentScore field's value.
func (s *AnomalyScore) SetCurrentScore(v float64) *AnomalyScore {
	s.CurrentScore = &v
	return s
}

// SetMaxScore sets the MaxScore field's value.
func (s *AnomalyScore) SetMaxScore(v float64) *AnomalyScore {
	s.MaxScore = &v
	return s
}

// An AnomalySubscription resource (also referred to as an alert subscription)
// sends notifications about specific anomalies that meet an alerting criteria
// defined by you.
//
// You can specify the frequency of the alerts and the subscribers to notify.
//
// Anomaly subscriptions can be associated with one or more AnomalyMonitor (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalyMonitor.html)
// resources, and they only send notifications about anomalies detected by those
// associated monitors. You can also configure a threshold to further control
// which anomalies are included in the notifications.
//
// Anomalies that don’t exceed the chosen threshold and therefore don’t
// trigger notifications from an anomaly subscription will still be available
// on the console and from the GetAnomalies (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetAnomalies.html)
// API.
type AnomalySubscription struct {
	_ struct{} `type:"structure"`

	// Your unique account identifier.
	AccountId *string `type:"string"`

	// The frequency that anomaly notifications are sent. Notifications are sent
	// either over email (for DAILY and WEEKLY frequencies) or SNS (for IMMEDIATE
	// frequency). For more information, see Creating an Amazon SNS topic for anomaly
	// notifications (https://docs.aws.amazon.com/cost-management/latest/userguide/ad-SNS.html).
	//
	// Frequency is a required field
	Frequency *string `type:"string" required:"true" enum:"AnomalySubscriptionFrequency"`

	// A list of cost anomaly monitors.
	//
	// MonitorArnList is a required field
	MonitorArnList []*string `type:"list" required:"true"`

	// A list of subscribers to notify.
	//
	// Subscribers is a required field
	Subscribers []*Subscriber `type:"list" required:"true"`

	// The AnomalySubscription Amazon Resource Name (ARN).
	SubscriptionArn *string `type:"string"`

	// The name for the subscription.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// (deprecated)
	//
	// An absolute dollar value that must be exceeded by the anomaly's total impact
	// (see Impact (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html)
	// for more details) for an anomaly notification to be generated.
	//
	// This field has been deprecated. To specify a threshold, use ThresholdExpression.
	// Continued use of Threshold will be treated as shorthand syntax for a ThresholdExpression.
	//
	// One of Threshold or ThresholdExpression is required for this resource. You
	// cannot specify both.
	//
	// Deprecated: Threshold has been deprecated in favor of ThresholdExpression
	Threshold *float64 `deprecated:"true" type:"double"`

	// An Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object used to specify the anomalies that you want to generate alerts for.
	// This supports dimensions and nested expressions. The supported dimensions
	// are ANOMALY_TOTAL_IMPACT_ABSOLUTE and ANOMALY_TOTAL_IMPACT_PERCENTAGE, corresponding
	// to an anomaly’s TotalImpact and TotalImpactPercentage, respectively (see
	// Impact (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html)
	// for more details). The supported nested expression types are AND and OR.
	// The match option GREATER_THAN_OR_EQUAL is required. Values must be numbers
	// between 0 and 10,000,000,000 in string format.
	//
	// One of Threshold or ThresholdExpression is required for this resource. You
	// cannot specify both.
	//
	// The following are examples of valid ThresholdExpressions:
	//
	//    * Absolute threshold: { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }
	//
	//    * Percentage threshold: { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }
	//
	//    * AND two thresholds together: { "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } },
	//    { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions":
	//    [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }
	//
	//    * OR two thresholds together: { "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } },
	//    { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions":
	//    [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }
	ThresholdExpression *Expression `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalySubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalySubscription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalySubscription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalySubscription"}
	if s.Frequency == nil {
		invalidParams.Add(request.NewErrParamRequired("Frequency"))
	}
	if s.MonitorArnList == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorArnList"))
	}
	if s.Subscribers == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscribers"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}
	if s.Subscribers != nil {
		for i, v := range s.Subscribers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscribers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ThresholdExpression != nil {
		if err := s.ThresholdExpression.Validate(); err != nil {
			invalidParams.AddNested("ThresholdExpression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AnomalySubscription) SetAccountId(v string) *AnomalySubscription {
	s.AccountId = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *AnomalySubscription) SetFrequency(v string) *AnomalySubscription {
	s.Frequency = &v
	return s
}

// SetMonitorArnList sets the MonitorArnList field's value.
func (s *AnomalySubscription) SetMonitorArnList(v []*string) *AnomalySubscription {
	s.MonitorArnList = v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *AnomalySubscription) SetSubscribers(v []*Subscriber) *AnomalySubscription {
	s.Subscribers = v
	return s
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *AnomalySubscription) SetSubscriptionArn(v string) *AnomalySubscription {
	s.SubscriptionArn = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *AnomalySubscription) SetSubscriptionName(v string) *AnomalySubscription {
	s.SubscriptionName = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *AnomalySubscription) SetThreshold(v float64) *AnomalySubscription {
	s.Threshold = &v
	return s
}

// SetThresholdExpression sets the ThresholdExpression field's value.
func (s *AnomalySubscription) SetThresholdExpression(v *Expression) *AnomalySubscription {
	s.ThresholdExpression = v
	return s
}

// The requested report expired. Update the date interval and try again.
type BillExpirationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillExpirationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillExpirationException) GoString() string {
	return s.String()
}

func newErrorBillExpirationException(v protocol.ResponseMetadata) error {
	return &BillExpirationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BillExpirationException) Code() string {
	return "BillExpirationException"
}

// Message returns the exception's message.
func (s *BillExpirationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BillExpirationException) OrigErr() error {
	return nil
}

func (s *BillExpirationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BillExpirationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BillExpirationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The cost allocation tag structure. This includes detailed metadata for the
// CostAllocationTag object.
type CostAllocationTag struct {
	_ struct{} `type:"structure"`

	// The last date that the tag was either activated or deactivated.
	LastUpdatedDate *string `min:"20" type:"string"`

	// The last month that the tag was used on an Amazon Web Services resource.
	LastUsedDate *string `min:"20" type:"string"`

	// The status of a cost allocation tag.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"CostAllocationTagStatus"`

	// The key for the cost allocation tag.
	//
	// TagKey is a required field
	TagKey *string `type:"string" required:"true"`

	// The type of cost allocation tag. You can use AWSGenerated or UserDefined
	// type tags. AWSGenerated type tags are tags that Amazon Web Services defines
	// and applies to support Amazon Web Services resources for cost allocation
	// purposes. UserDefined type tags are tags that you define, create, and apply
	// to resources.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"CostAllocationTagType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostAllocationTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostAllocationTag) GoString() string {
	return s.String()
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CostAllocationTag) SetLastUpdatedDate(v string) *CostAllocationTag {
	s.LastUpdatedDate = &v
	return s
}

// SetLastUsedDate sets the LastUsedDate field's value.
func (s *CostAllocationTag) SetLastUsedDate(v string) *CostAllocationTag {
	s.LastUsedDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CostAllocationTag) SetStatus(v string) *CostAllocationTag {
	s.Status = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *CostAllocationTag) SetTagKey(v string) *CostAllocationTag {
	s.TagKey = &v
	return s
}

// SetType sets the Type field's value.
func (s *CostAllocationTag) SetType(v string) *CostAllocationTag {
	s.Type = &v
	return s
}

// The cost allocation tag status. The status of a key can either be active
// or inactive.
type CostAllocationTagStatusEntry struct {
	_ struct{} `type:"structure"`

	// The status of a cost allocation tag.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"CostAllocationTagStatus"`

	// The key for the cost allocation tag.
	//
	// TagKey is a required field
	TagKey *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostAllocationTagStatusEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostAllocationTagStatusEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostAllocationTagStatusEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostAllocationTagStatusEntry"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *CostAllocationTagStatusEntry) SetStatus(v string) *CostAllocationTagStatusEntry {
	s.Status = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *CostAllocationTagStatusEntry) SetTagKey(v string) *CostAllocationTagStatusEntry {
	s.TagKey = &v
	return s
}

// The structure of Cost Categories. This includes detailed metadata and the
// set of rules for the CostCategory object.
type CostCategory struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The default value for the cost category.
	DefaultValue *string `min:"1" type:"string"`

	// The effective end date of your Cost Category.
	EffectiveEnd *string `min:"20" type:"string"`

	// The effective start date of your Cost Category.
	//
	// EffectiveStart is a required field
	EffectiveStart *string `min:"20" type:"string" required:"true"`

	// The unique name of the Cost Category.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The list of processing statuses for Cost Management products for a specific
	// cost category.
	ProcessingStatus []*CostCategoryProcessingStatus `type:"list"`

	// The rule schema version in this particular Cost Category.
	//
	// RuleVersion is a required field
	RuleVersion *string `type:"string" required:"true" enum:"CostCategoryRuleVersion"`

	// The rules are processed in order. If there are multiple rules that match
	// the line item, then the first rule to match is used to determine that Cost
	// Category value.
	//
	// Rules is a required field
	Rules []*CostCategoryRule `min:"1" type:"list" required:"true"`

	// The split charge rules that are used to allocate your charges between your
	// Cost Category values.
	SplitChargeRules []*CostCategorySplitChargeRule `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategory) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *CostCategory) SetCostCategoryArn(v string) *CostCategory {
	s.CostCategoryArn = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *CostCategory) SetDefaultValue(v string) *CostCategory {
	s.DefaultValue = &v
	return s
}

// SetEffectiveEnd sets the EffectiveEnd field's value.
func (s *CostCategory) SetEffectiveEnd(v string) *CostCategory {
	s.EffectiveEnd = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *CostCategory) SetEffectiveStart(v string) *CostCategory {
	s.EffectiveStart = &v
	return s
}

// SetName sets the Name field's value.
func (s *CostCategory) SetName(v string) *CostCategory {
	s.Name = &v
	return s
}

// SetProcessingStatus sets the ProcessingStatus field's value.
func (s *CostCategory) SetProcessingStatus(v []*CostCategoryProcessingStatus) *CostCategory {
	s.ProcessingStatus = v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *CostCategory) SetRuleVersion(v string) *CostCategory {
	s.RuleVersion = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CostCategory) SetRules(v []*CostCategoryRule) *CostCategory {
	s.Rules = v
	return s
}

// SetSplitChargeRules sets the SplitChargeRules field's value.
func (s *CostCategory) SetSplitChargeRules(v []*CostCategorySplitChargeRule) *CostCategory {
	s.SplitChargeRules = v
	return s
}

// When you create or update a cost category, you can define the CostCategoryRule
// rule type as INHERITED_VALUE. This rule type adds the flexibility to define
// a rule that dynamically inherits the cost category value from the dimension
// value that's defined by CostCategoryInheritedValueDimension. For example,
// suppose that you want to dynamically group costs that are based on the value
// of a specific tag key. First, choose an inherited value rule type, and then
// choose the tag dimension and specify the tag key to use.
type CostCategoryInheritedValueDimension struct {
	_ struct{} `type:"structure"`

	// The key to extract cost category values.
	DimensionKey *string `type:"string"`

	// The name of the dimension that's used to group costs.
	//
	// If you specify LINKED_ACCOUNT_NAME, the cost category value is based on account
	// name. If you specify TAG, the cost category value is based on the value of
	// the specified tag key.
	DimensionName *string `type:"string" enum:"CostCategoryInheritedValueDimensionName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryInheritedValueDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryInheritedValueDimension) GoString() string {
	return s.String()
}

// SetDimensionKey sets the DimensionKey field's value.
func (s *CostCategoryInheritedValueDimension) SetDimensionKey(v string) *CostCategoryInheritedValueDimension {
	s.DimensionKey = &v
	return s
}

// SetDimensionName sets the DimensionName field's value.
func (s *CostCategoryInheritedValueDimension) SetDimensionName(v string) *CostCategoryInheritedValueDimension {
	s.DimensionName = &v
	return s
}

// The list of processing statuses for Cost Management products for a specific
// cost category.
type CostCategoryProcessingStatus struct {
	_ struct{} `type:"structure"`

	// The Cost Management product name of the applied status.
	Component *string `type:"string" enum:"CostCategoryStatusComponent"`

	// The process status for a specific cost category.
	Status *string `type:"string" enum:"CostCategoryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryProcessingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryProcessingStatus) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *CostCategoryProcessingStatus) SetComponent(v string) *CostCategoryProcessingStatus {
	s.Component = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CostCategoryProcessingStatus) SetStatus(v string) *CostCategoryProcessingStatus {
	s.Status = &v
	return s
}

// A reference to a Cost Category containing only enough information to identify
// the Cost Category.
//
// You can use this information to retrieve the full Cost Category information
// using DescribeCostCategory.
type CostCategoryReference struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The default value for the cost category.
	DefaultValue *string `min:"1" type:"string"`

	// The Cost Category's effective end date.
	EffectiveEnd *string `min:"20" type:"string"`

	// The Cost Category's effective start date.
	EffectiveStart *string `min:"20" type:"string"`

	// The unique name of the Cost Category.
	Name *string `min:"1" type:"string"`

	// The number of rules that are associated with a specific Cost Category.
	NumberOfRules *int64 `type:"integer"`

	// The list of processing statuses for Cost Management products for a specific
	// cost category.
	ProcessingStatus []*CostCategoryProcessingStatus `type:"list"`

	// A list of unique cost category values in a specific cost category.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryReference) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *CostCategoryReference) SetCostCategoryArn(v string) *CostCategoryReference {
	s.CostCategoryArn = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *CostCategoryReference) SetDefaultValue(v string) *CostCategoryReference {
	s.DefaultValue = &v
	return s
}

// SetEffectiveEnd sets the EffectiveEnd field's value.
func (s *CostCategoryReference) SetEffectiveEnd(v string) *CostCategoryReference {
	s.EffectiveEnd = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *CostCategoryReference) SetEffectiveStart(v string) *CostCategoryReference {
	s.EffectiveStart = &v
	return s
}

// SetName sets the Name field's value.
func (s *CostCategoryReference) SetName(v string) *CostCategoryReference {
	s.Name = &v
	return s
}

// SetNumberOfRules sets the NumberOfRules field's value.
func (s *CostCategoryReference) SetNumberOfRules(v int64) *CostCategoryReference {
	s.NumberOfRules = &v
	return s
}

// SetProcessingStatus sets the ProcessingStatus field's value.
func (s *CostCategoryReference) SetProcessingStatus(v []*CostCategoryProcessingStatus) *CostCategoryReference {
	s.ProcessingStatus = v
	return s
}

// SetValues sets the Values field's value.
func (s *CostCategoryReference) SetValues(v []*string) *CostCategoryReference {
	s.Values = v
	return s
}

// Rules are processed in order. If there are multiple rules that match the
// line item, then the first rule to match is used to determine that Cost Category
// value.
type CostCategoryRule struct {
	_ struct{} `type:"structure"`

	// The value the line item is categorized as if the line item contains the matched
	// dimension.
	InheritedValue *CostCategoryInheritedValueDimension `type:"structure"`

	// An Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object used to categorize costs. This supports dimensions, tags, and nested
	// expressions. Currently the only dimensions supported are LINKED_ACCOUNT,
	// SERVICE_CODE, RECORD_TYPE, LINKED_ACCOUNT_NAME, REGION, and USAGE_TYPE.
	//
	// RECORD_TYPE is a dimension used for Cost Explorer APIs, and is also supported
	// for Cost Category expressions. This dimension uses different terms, depending
	// on whether you're using the console or API/JSON editor. For a detailed comparison,
	// see Term Comparisons (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms)
	// in the Billing and Cost Management User Guide.
	Rule *Expression `type:"structure"`

	// You can define the CostCategoryRule rule type as either REGULAR or INHERITED_VALUE.
	// The INHERITED_VALUE rule type adds the flexibility to define a rule that
	// dynamically inherits the cost category value. This value is from the dimension
	// value that's defined by CostCategoryInheritedValueDimension. For example,
	// suppose that you want to costs to be dynamically grouped based on the value
	// of a specific tag key. First, choose an inherited value rule type, and then
	// choose the tag dimension and specify the tag key to use.
	Type *string `type:"string" enum:"CostCategoryRuleType"`

	// The default value for the cost category.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategoryRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostCategoryRule"}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInheritedValue sets the InheritedValue field's value.
func (s *CostCategoryRule) SetInheritedValue(v *CostCategoryInheritedValueDimension) *CostCategoryRule {
	s.InheritedValue = v
	return s
}

// SetRule sets the Rule field's value.
func (s *CostCategoryRule) SetRule(v *Expression) *CostCategoryRule {
	s.Rule = v
	return s
}

// SetType sets the Type field's value.
func (s *CostCategoryRule) SetType(v string) *CostCategoryRule {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CostCategoryRule) SetValue(v string) *CostCategoryRule {
	s.Value = &v
	return s
}

// Use the split charge rule to split the cost of one Cost Category value across
// several other target values.
type CostCategorySplitChargeRule struct {
	_ struct{} `type:"structure"`

	// The method that's used to define how to split your source costs across your
	// targets.
	//
	// Proportional - Allocates charges across your targets based on the proportional
	// weighted cost of each target.
	//
	// Fixed - Allocates charges across your targets based on your defined allocation
	// percentage.
	//
	// >Even - Allocates costs evenly across all targets.
	//
	// Method is a required field
	Method *string `type:"string" required:"true" enum:"CostCategorySplitChargeMethod"`

	// The parameters for a split charge method. This is only required for the FIXED
	// method.
	Parameters []*CostCategorySplitChargeRuleParameter `min:"1" type:"list"`

	// The Cost Category value that you want to split. That value can't be used
	// as a source or a target in other split charge rules. To indicate uncategorized
	// costs, you can use an empty string as the source.
	//
	// Source is a required field
	Source *string `type:"string" required:"true"`

	// The Cost Category values that you want to split costs across. These values
	// can't be used as a source in other split charge rules.
	//
	// Targets is a required field
	Targets []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategorySplitChargeRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategorySplitChargeRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategorySplitChargeRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostCategorySplitChargeRule"}
	if s.Method == nil {
		invalidParams.Add(request.NewErrParamRequired("Method"))
	}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMethod sets the Method field's value.
func (s *CostCategorySplitChargeRule) SetMethod(v string) *CostCategorySplitChargeRule {
	s.Method = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CostCategorySplitChargeRule) SetParameters(v []*CostCategorySplitChargeRuleParameter) *CostCategorySplitChargeRule {
	s.Parameters = v
	return s
}

// SetSource sets the Source field's value.
func (s *CostCategorySplitChargeRule) SetSource(v string) *CostCategorySplitChargeRule {
	s.Source = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CostCategorySplitChargeRule) SetTargets(v []*string) *CostCategorySplitChargeRule {
	s.Targets = v
	return s
}

// The parameters for a split charge method.
type CostCategorySplitChargeRuleParameter struct {
	_ struct{} `type:"structure"`

	// The parameter type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"CostCategorySplitChargeRuleParameterType"`

	// The parameter values.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategorySplitChargeRuleParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategorySplitChargeRuleParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategorySplitChargeRuleParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostCategorySplitChargeRuleParameter"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *CostCategorySplitChargeRuleParameter) SetType(v string) *CostCategorySplitChargeRuleParameter {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *CostCategorySplitChargeRuleParameter) SetValues(v []*string) *CostCategorySplitChargeRuleParameter {
	s.Values = v
	return s
}

// The Cost Categories values used for filtering the costs.
//
// If Values and Key are not specified, the ABSENT MatchOption is applied to
// all Cost Categories. That is, it filters on resources that aren't mapped
// to any Cost Categories.
//
// If Values is provided and Key isn't specified, the ABSENT MatchOption is
// applied to the Cost Categories Key only. That is, it filters on resources
// without the given Cost Categories key.
type CostCategoryValues struct {
	_ struct{} `type:"structure"`

	// The unique name of the Cost Category.
	Key *string `min:"1" type:"string"`

	// The match options that you can use to filter your results. MatchOptions is
	// only applicable for actions related to cost category. The default values
	// for MatchOptions is EQUALS and CASE_SENSITIVE.
	MatchOptions []*string `type:"list" enum:"MatchOption"`

	// The specific value of the Cost Category.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CostCategoryValues) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategoryValues) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostCategoryValues"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *CostCategoryValues) SetKey(v string) *CostCategoryValues {
	s.Key = &v
	return s
}

// SetMatchOptions sets the MatchOptions field's value.
func (s *CostCategoryValues) SetMatchOptions(v []*string) *CostCategoryValues {
	s.MatchOptions = v
	return s
}

// SetValues sets the Values field's value.
func (s *CostCategoryValues) SetValues(v []*string) *CostCategoryValues {
	s.Values = v
	return s
}

// The amount of instance usage that a reservation covered.
type Coverage struct {
	_ struct{} `type:"structure"`

	// The amount of cost that the reservation covered.
	CoverageCost *CoverageCost `type:"structure"`

	// The amount of instance usage that the reservation covered, in hours.
	CoverageHours *CoverageHours `type:"structure"`

	// The amount of instance usage that the reservation covered, in normalized
	// units.
	CoverageNormalizedUnits *CoverageNormalizedUnits `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Coverage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Coverage) GoString() string {
	return s.String()
}

// SetCoverageCost sets the CoverageCost field's value.
func (s *Coverage) SetCoverageCost(v *CoverageCost) *Coverage {
	s.CoverageCost = v
	return s
}

// SetCoverageHours sets the CoverageHours field's value.
func (s *Coverage) SetCoverageHours(v *CoverageHours) *Coverage {
	s.CoverageHours = v
	return s
}

// SetCoverageNormalizedUnits sets the CoverageNormalizedUnits field's value.
func (s *Coverage) SetCoverageNormalizedUnits(v *CoverageNormalizedUnits) *Coverage {
	s.CoverageNormalizedUnits = v
	return s
}

// Reservation coverage for a specified period, in hours.
type CoverageByTime struct {
	_ struct{} `type:"structure"`

	// The groups of instances that the reservation covered.
	Groups []*ReservationCoverageGroup `type:"list"`

	// The period that this coverage was used over.
	TimePeriod *DateInterval `type:"structure"`

	// The total reservation coverage, in hours.
	Total *Coverage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageByTime) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *CoverageByTime) SetGroups(v []*ReservationCoverageGroup) *CoverageByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *CoverageByTime) SetTimePeriod(v *DateInterval) *CoverageByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *CoverageByTime) SetTotal(v *Coverage) *CoverageByTime {
	s.Total = v
	return s
}

// How much it costs to run an instance.
type CoverageCost struct {
	_ struct{} `type:"structure"`

	// How much an On-Demand Instance costs.
	OnDemandCost *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageCost) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageCost) GoString() string {
	return s.String()
}

// SetOnDemandCost sets the OnDemandCost field's value.
func (s *CoverageCost) SetOnDemandCost(v string) *CoverageCost {
	s.OnDemandCost = &v
	return s
}

// How long a running instance either used a reservation or was On-Demand.
type CoverageHours struct {
	_ struct{} `type:"structure"`

	// The percentage of instance hours that a reservation covered.
	CoverageHoursPercentage *string `type:"string"`

	// The number of instance running hours that On-Demand Instances covered.
	OnDemandHours *string `type:"string"`

	// The number of instance running hours that reservations covered.
	ReservedHours *string `type:"string"`

	// The total instance usage, in hours.
	TotalRunningHours *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageHours) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageHours) GoString() string {
	return s.String()
}

// SetCoverageHoursPercentage sets the CoverageHoursPercentage field's value.
func (s *CoverageHours) SetCoverageHoursPercentage(v string) *CoverageHours {
	s.CoverageHoursPercentage = &v
	return s
}

// SetOnDemandHours sets the OnDemandHours field's value.
func (s *CoverageHours) SetOnDemandHours(v string) *CoverageHours {
	s.OnDemandHours = &v
	return s
}

// SetReservedHours sets the ReservedHours field's value.
func (s *CoverageHours) SetReservedHours(v string) *CoverageHours {
	s.ReservedHours = &v
	return s
}

// SetTotalRunningHours sets the TotalRunningHours field's value.
func (s *CoverageHours) SetTotalRunningHours(v string) *CoverageHours {
	s.TotalRunningHours = &v
	return s
}

// The amount of instance usage, in normalized units. You can use normalized
// units to see your EC2 usage for multiple sizes of instances in a uniform
// way. For example, suppose that you run an xlarge instance and a 2xlarge instance.
// If you run both instances for the same amount of time, the 2xlarge instance
// uses twice as much of your reservation as the xlarge instance, even though
// both instances show only one instance-hour. When you use normalized units
// instead of instance-hours, the xlarge instance used 8 normalized units, and
// the 2xlarge instance used 16 normalized units.
//
// For more information, see Modifying Reserved Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
type CoverageNormalizedUnits struct {
	_ struct{} `type:"structure"`

	// The percentage of your used instance normalized units that a reservation
	// covers.
	CoverageNormalizedUnitsPercentage *string `type:"string"`

	// The number of normalized units that are covered by On-Demand Instances instead
	// of a reservation.
	OnDemandNormalizedUnits *string `type:"string"`

	// The number of normalized units that a reservation covers.
	ReservedNormalizedUnits *string `type:"string"`

	// The total number of normalized units that you used.
	TotalRunningNormalizedUnits *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageNormalizedUnits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageNormalizedUnits) GoString() string {
	return s.String()
}

// SetCoverageNormalizedUnitsPercentage sets the CoverageNormalizedUnitsPercentage field's value.
func (s *CoverageNormalizedUnits) SetCoverageNormalizedUnitsPercentage(v string) *CoverageNormalizedUnits {
	s.CoverageNormalizedUnitsPercentage = &v
	return s
}

// SetOnDemandNormalizedUnits sets the OnDemandNormalizedUnits field's value.
func (s *CoverageNormalizedUnits) SetOnDemandNormalizedUnits(v string) *CoverageNormalizedUnits {
	s.OnDemandNormalizedUnits = &v
	return s
}

// SetReservedNormalizedUnits sets the ReservedNormalizedUnits field's value.
func (s *CoverageNormalizedUnits) SetReservedNormalizedUnits(v string) *CoverageNormalizedUnits {
	s.ReservedNormalizedUnits = &v
	return s
}

// SetTotalRunningNormalizedUnits sets the TotalRunningNormalizedUnits field's value.
func (s *CoverageNormalizedUnits) SetTotalRunningNormalizedUnits(v string) *CoverageNormalizedUnits {
	s.TotalRunningNormalizedUnits = &v
	return s
}

type CreateAnomalyMonitorInput struct {
	_ struct{} `type:"structure"`

	// The cost anomaly detection monitor object that you want to create.
	//
	// AnomalyMonitor is a required field
	AnomalyMonitor *AnomalyMonitor `type:"structure" required:"true"`

	// An optional list of tags to associate with the specified AnomalyMonitor (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalyMonitor.html).
	// You can use resource tags to control access to your monitor using IAM policies.
	//
	// Each tag consists of a key and a value, and each key must be unique for the
	// resource. The following restrictions apply to resource tags:
	//
	//    * Although the maximum number of array members is 200, you can assign
	//    a maximum of 50 user-tags to one resource. The remaining are reserved
	//    for Amazon Web Services use
	//
	//    * The maximum length of a key is 128 characters
	//
	//    * The maximum length of a value is 256 characters
	//
	//    * Keys and values can only contain alphanumeric characters, spaces, and
	//    any of the following: _.:/=+@-
	//
	//    * Keys and values are case sensitive
	//
	//    * Keys and values are trimmed for any leading or trailing whitespaces
	//
	//    * Don’t use aws: as a prefix for your keys. This prefix is reserved
	//    for Amazon Web Services use
	ResourceTags []*ResourceTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnomalyMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnomalyMonitorInput"}
	if s.AnomalyMonitor == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyMonitor"))
	}
	if s.AnomalyMonitor != nil {
		if err := s.AnomalyMonitor.Validate(); err != nil {
			invalidParams.AddNested("AnomalyMonitor", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyMonitor sets the AnomalyMonitor field's value.
func (s *CreateAnomalyMonitorInput) SetAnomalyMonitor(v *AnomalyMonitor) *CreateAnomalyMonitorInput {
	s.AnomalyMonitor = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateAnomalyMonitorInput) SetResourceTags(v []*ResourceTag) *CreateAnomalyMonitorInput {
	s.ResourceTags = v
	return s
}

type CreateAnomalyMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of your newly created cost anomaly detection monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalyMonitorOutput) GoString() string {
	return s.String()
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *CreateAnomalyMonitorOutput) SetMonitorArn(v string) *CreateAnomalyMonitorOutput {
	s.MonitorArn = &v
	return s
}

type CreateAnomalySubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The cost anomaly subscription object that you want to create.
	//
	// AnomalySubscription is a required field
	AnomalySubscription *AnomalySubscription `type:"structure" required:"true"`

	// An optional list of tags to associate with the specified AnomalySubscription
	// (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html).
	// You can use resource tags to control access to your subscription using IAM
	// policies.
	//
	// Each tag consists of a key and a value, and each key must be unique for the
	// resource. The following restrictions apply to resource tags:
	//
	//    * Although the maximum number of array members is 200, you can assign
	//    a maximum of 50 user-tags to one resource. The remaining are reserved
	//    for Amazon Web Services use
	//
	//    * The maximum length of a key is 128 characters
	//
	//    * The maximum length of a value is 256 characters
	//
	//    * Keys and values can only contain alphanumeric characters, spaces, and
	//    any of the following: _.:/=+@-
	//
	//    * Keys and values are case sensitive
	//
	//    * Keys and values are trimmed for any leading or trailing whitespaces
	//
	//    * Don’t use aws: as a prefix for your keys. This prefix is reserved
	//    for Amazon Web Services use
	ResourceTags []*ResourceTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalySubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalySubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnomalySubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnomalySubscriptionInput"}
	if s.AnomalySubscription == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalySubscription"))
	}
	if s.AnomalySubscription != nil {
		if err := s.AnomalySubscription.Validate(); err != nil {
			invalidParams.AddNested("AnomalySubscription", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalySubscription sets the AnomalySubscription field's value.
func (s *CreateAnomalySubscriptionInput) SetAnomalySubscription(v *AnomalySubscription) *CreateAnomalySubscriptionInput {
	s.AnomalySubscription = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateAnomalySubscriptionInput) SetResourceTags(v []*ResourceTag) *CreateAnomalySubscriptionInput {
	s.ResourceTags = v
	return s
}

type CreateAnomalySubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of your newly created cost anomaly subscription.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalySubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnomalySubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *CreateAnomalySubscriptionOutput) SetSubscriptionArn(v string) *CreateAnomalySubscriptionOutput {
	s.SubscriptionArn = &v
	return s
}

type CreateCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The default value for the cost category.
	DefaultValue *string `min:"1" type:"string"`

	// The Cost Category's effective start date. It can only be a billing start
	// date (first day of the month). If the date isn't provided, it's the first
	// day of the current month. Dates can't be before the previous twelve months,
	// or in the future.
	EffectiveStart *string `min:"20" type:"string"`

	// The unique name of the Cost Category.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An optional list of tags to associate with the specified CostCategory (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html).
	// You can use resource tags to control access to your cost category using IAM
	// policies.
	//
	// Each tag consists of a key and a value, and each key must be unique for the
	// resource. The following restrictions apply to resource tags:
	//
	//    * Although the maximum number of array members is 200, you can assign
	//    a maximum of 50 user-tags to one resource. The remaining are reserved
	//    for Amazon Web Services use
	//
	//    * The maximum length of a key is 128 characters
	//
	//    * The maximum length of a value is 256 characters
	//
	//    * Keys and values can only contain alphanumeric characters, spaces, and
	//    any of the following: _.:/=+@-
	//
	//    * Keys and values are case sensitive
	//
	//    * Keys and values are trimmed for any leading or trailing whitespaces
	//
	//    * Don’t use aws: as a prefix for your keys. This prefix is reserved
	//    for Amazon Web Services use
	ResourceTags []*ResourceTag `type:"list"`

	// The rule schema version in this particular Cost Category.
	//
	// RuleVersion is a required field
	RuleVersion *string `type:"string" required:"true" enum:"CostCategoryRuleVersion"`

	// The Cost Category rules used to categorize costs. For more information, see
	// CostCategoryRule (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html).
	//
	// Rules is a required field
	Rules []*CostCategoryRule `min:"1" type:"list" required:"true"`

	// The split charge rules used to allocate your charges between your Cost Category
	// values.
	SplitChargeRules []*CostCategorySplitChargeRule `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCostCategoryDefinitionInput"}
	if s.DefaultValue != nil && len(*s.DefaultValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultValue", 1))
	}
	if s.EffectiveStart != nil && len(*s.EffectiveStart) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EffectiveStart", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuleVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleVersion"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.SplitChargeRules != nil && len(s.SplitChargeRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SplitChargeRules", 1))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SplitChargeRules != nil {
		for i, v := range s.SplitChargeRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SplitChargeRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *CreateCostCategoryDefinitionInput) SetDefaultValue(v string) *CreateCostCategoryDefinitionInput {
	s.DefaultValue = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *CreateCostCategoryDefinitionInput) SetEffectiveStart(v string) *CreateCostCategoryDefinitionInput {
	s.EffectiveStart = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCostCategoryDefinitionInput) SetName(v string) *CreateCostCategoryDefinitionInput {
	s.Name = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateCostCategoryDefinitionInput) SetResourceTags(v []*ResourceTag) *CreateCostCategoryDefinitionInput {
	s.ResourceTags = v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *CreateCostCategoryDefinitionInput) SetRuleVersion(v string) *CreateCostCategoryDefinitionInput {
	s.RuleVersion = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateCostCategoryDefinitionInput) SetRules(v []*CostCategoryRule) *CreateCostCategoryDefinitionInput {
	s.Rules = v
	return s
}

// SetSplitChargeRules sets the SplitChargeRules field's value.
func (s *CreateCostCategoryDefinitionInput) SetSplitChargeRules(v []*CostCategorySplitChargeRule) *CreateCostCategoryDefinitionInput {
	s.SplitChargeRules = v
	return s
}

type CreateCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your newly created Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The Cost Category's effective start date. It can only be a billing start
	// date (first day of the month).
	EffectiveStart *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *CreateCostCategoryDefinitionOutput) SetCostCategoryArn(v string) *CreateCostCategoryDefinitionOutput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *CreateCostCategoryDefinitionOutput) SetEffectiveStart(v string) *CreateCostCategoryDefinitionOutput {
	s.EffectiveStart = &v
	return s
}

// Context about the current instance.
type CurrentInstance struct {
	_ struct{} `type:"structure"`

	// The currency code that Amazon Web Services used to calculate the costs for
	// this instance.
	CurrencyCode *string `type:"string"`

	// The name that you given an instance. This field shows as blank if you haven't
	// given the instance a name.
	InstanceName *string `type:"string"`

	// The current On-Demand cost of operating this instance on a monthly basis.
	MonthlyCost *string `type:"string"`

	// The number of hours during the lookback period that's billed at On-Demand
	// rates.
	OnDemandHoursInLookbackPeriod *string `type:"string"`

	// The number of hours during the lookback period that's covered by reservations.
	ReservationCoveredHoursInLookbackPeriod *string `type:"string"`

	// Details about the resource and utilization.
	ResourceDetails *ResourceDetails `type:"structure"`

	// Resource ID of the current instance.
	ResourceId *string `type:"string"`

	// Utilization information of the current instance during the lookback period.
	ResourceUtilization *ResourceUtilization `type:"structure"`

	// The number of hours during the lookback period that's covered by Savings
	// Plans.
	SavingsPlansCoveredHoursInLookbackPeriod *string `type:"string"`

	// Cost allocation resource tags that are applied to the instance.
	Tags []*TagValues `type:"list"`

	// The total number of hours that the instance ran during the lookback period.
	TotalRunningHoursInLookbackPeriod *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CurrentInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CurrentInstance) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *CurrentInstance) SetCurrencyCode(v string) *CurrentInstance {
	s.CurrencyCode = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CurrentInstance) SetInstanceName(v string) *CurrentInstance {
	s.InstanceName = &v
	return s
}

// SetMonthlyCost sets the MonthlyCost field's value.
func (s *CurrentInstance) SetMonthlyCost(v string) *CurrentInstance {
	s.MonthlyCost = &v
	return s
}

// SetOnDemandHoursInLookbackPeriod sets the OnDemandHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetOnDemandHoursInLookbackPeriod(v string) *CurrentInstance {
	s.OnDemandHoursInLookbackPeriod = &v
	return s
}

// SetReservationCoveredHoursInLookbackPeriod sets the ReservationCoveredHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetReservationCoveredHoursInLookbackPeriod(v string) *CurrentInstance {
	s.ReservationCoveredHoursInLookbackPeriod = &v
	return s
}

// SetResourceDetails sets the ResourceDetails field's value.
func (s *CurrentInstance) SetResourceDetails(v *ResourceDetails) *CurrentInstance {
	s.ResourceDetails = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CurrentInstance) SetResourceId(v string) *CurrentInstance {
	s.ResourceId = &v
	return s
}

// SetResourceUtilization sets the ResourceUtilization field's value.
func (s *CurrentInstance) SetResourceUtilization(v *ResourceUtilization) *CurrentInstance {
	s.ResourceUtilization = v
	return s
}

// SetSavingsPlansCoveredHoursInLookbackPeriod sets the SavingsPlansCoveredHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetSavingsPlansCoveredHoursInLookbackPeriod(v string) *CurrentInstance {
	s.SavingsPlansCoveredHoursInLookbackPeriod = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CurrentInstance) SetTags(v []*TagValues) *CurrentInstance {
	s.Tags = v
	return s
}

// SetTotalRunningHoursInLookbackPeriod sets the TotalRunningHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetTotalRunningHoursInLookbackPeriod(v string) *CurrentInstance {
	s.TotalRunningHoursInLookbackPeriod = &v
	return s
}

// The requested data is unavailable.
type DataUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataUnavailableException) GoString() string {
	return s.String()
}

func newErrorDataUnavailableException(v protocol.ResponseMetadata) error {
	return &DataUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataUnavailableException) Code() string {
	return "DataUnavailableException"
}

// Message returns the exception's message.
func (s *DataUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataUnavailableException) OrigErr() error {
	return nil
}

func (s *DataUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The time period of the request.
type DateInterval struct {
	_ struct{} `type:"structure"`

	// The end of the time period. The end date is exclusive. For example, if end
	// is 2017-05-01, Amazon Web Services retrieves cost and usage data from the
	// start date up to, but not including, 2017-05-01.
	//
	// End is a required field
	End *string `type:"string" required:"true"`

	// The beginning of the time period. The start date is inclusive. For example,
	// if start is 2017-01-01, Amazon Web Services retrieves cost and usage data
	// starting at 2017-01-01 up to the end date. The start date must be equal to
	// or no later than the current date to avoid a validation error.
	//
	// Start is a required field
	Start *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateInterval"}
	if s.End == nil {
		invalidParams.Add(request.NewErrParamRequired("End"))
	}
	if s.Start == nil {
		invalidParams.Add(request.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnd sets the End field's value.
func (s *DateInterval) SetEnd(v string) *DateInterval {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *DateInterval) SetStart(v string) *DateInterval {
	s.Start = &v
	return s
}

type DeleteAnomalyMonitorInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cost anomaly monitor that you want to delete.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnomalyMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnomalyMonitorInput"}
	if s.MonitorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *DeleteAnomalyMonitorInput) SetMonitorArn(v string) *DeleteAnomalyMonitorInput {
	s.MonitorArn = &v
	return s
}

type DeleteAnomalyMonitorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyMonitorOutput) GoString() string {
	return s.String()
}

type DeleteAnomalySubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cost anomaly subscription that you want to delete.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalySubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalySubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnomalySubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnomalySubscriptionInput"}
	if s.SubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *DeleteAnomalySubscriptionInput) SetSubscriptionArn(v string) *DeleteAnomalySubscriptionInput {
	s.SubscriptionArn = &v
	return s
}

type DeleteAnomalySubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalySubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalySubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCostCategoryDefinitionInput"}
	if s.CostCategoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CostCategoryArn"))
	}
	if s.CostCategoryArn != nil && len(*s.CostCategoryArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CostCategoryArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *DeleteCostCategoryDefinitionInput) SetCostCategoryArn(v string) *DeleteCostCategoryDefinitionInput {
	s.CostCategoryArn = &v
	return s
}

type DeleteCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The effective end date of the Cost Category as a result of deleting it. No
	// costs after this date is categorized by the deleted Cost Category.
	EffectiveEnd *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *DeleteCostCategoryDefinitionOutput) SetCostCategoryArn(v string) *DeleteCostCategoryDefinitionOutput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveEnd sets the EffectiveEnd field's value.
func (s *DeleteCostCategoryDefinitionOutput) SetEffectiveEnd(v string) *DeleteCostCategoryDefinitionOutput {
	s.EffectiveEnd = &v
	return s
}

type DescribeCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The date when the Cost Category was effective.
	EffectiveOn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCostCategoryDefinitionInput"}
	if s.CostCategoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CostCategoryArn"))
	}
	if s.CostCategoryArn != nil && len(*s.CostCategoryArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CostCategoryArn", 20))
	}
	if s.EffectiveOn != nil && len(*s.EffectiveOn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EffectiveOn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *DescribeCostCategoryDefinitionInput) SetCostCategoryArn(v string) *DescribeCostCategoryDefinitionInput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveOn sets the EffectiveOn field's value.
func (s *DescribeCostCategoryDefinitionInput) SetEffectiveOn(v string) *DescribeCostCategoryDefinitionInput {
	s.EffectiveOn = &v
	return s
}

type DescribeCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The structure of Cost Categories. This includes detailed metadata and the
	// set of rules for the CostCategory object.
	CostCategory *CostCategory `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategory sets the CostCategory field's value.
func (s *DescribeCostCategoryDefinitionOutput) SetCostCategory(v *CostCategory) *DescribeCostCategoryDefinitionOutput {
	s.CostCategory = v
	return s
}

// The metadata that you can use to filter and group your results. You can use
// GetDimensionValues to find specific values.
type DimensionValues struct {
	_ struct{} `type:"structure"`

	// The names of the metadata types that you can use to filter and group your
	// results. For example, AZ returns a list of Availability Zones.
	//
	// Not all dimensions are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// LINK_ACCOUNT_NAME and SERVICE_CODE can only be used in CostCategoryRule (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html).
	//
	// ANOMALY_TOTAL_IMPACT_ABSOLUTE and ANOMALY_TOTAL_IMPACT_PERCENTAGE can only
	// be used in AnomalySubscriptions (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html).
	Key *string `type:"string" enum:"Dimension"`

	// The match options that you can use to filter your results.
	//
	// MatchOptions is only applicable for actions related to Cost Category and
	// Anomaly Subscriptions. Refer to the documentation for each specific API to
	// see what is supported.
	//
	// The default values for MatchOptions are EQUALS and CASE_SENSITIVE.
	MatchOptions []*string `type:"list" enum:"MatchOption"`

	// The metadata values that you can use to filter and group your results. You
	// can use GetDimensionValues to find specific values.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *DimensionValues) SetKey(v string) *DimensionValues {
	s.Key = &v
	return s
}

// SetMatchOptions sets the MatchOptions field's value.
func (s *DimensionValues) SetMatchOptions(v []*string) *DimensionValues {
	s.MatchOptions = v
	return s
}

// SetValues sets the Values field's value.
func (s *DimensionValues) SetValues(v []*string) *DimensionValues {
	s.Values = v
	return s
}

// The metadata of a specific type that you can use to filter and group your
// results. You can use GetDimensionValues to find specific values.
type DimensionValuesWithAttributes struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The value of a dimension with a specific attribute.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionValuesWithAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionValuesWithAttributes) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DimensionValuesWithAttributes) SetAttributes(v map[string]*string) *DimensionValuesWithAttributes {
	s.Attributes = v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionValuesWithAttributes) SetValue(v string) *DimensionValuesWithAttributes {
	s.Value = &v
	return s
}

// The field that contains a list of disk (local storage) metrics that are associated
// with the current instance.
type DiskResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The maximum read throughput operations per second.
	DiskReadBytesPerSecond *string `type:"string"`

	// The maximum number of read operations per second.
	DiskReadOpsPerSecond *string `type:"string"`

	// The maximum write throughput operations per second.
	DiskWriteBytesPerSecond *string `type:"string"`

	// The maximum number of write operations per second.
	DiskWriteOpsPerSecond *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiskResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiskResourceUtilization) GoString() string {
	return s.String()
}

// SetDiskReadBytesPerSecond sets the DiskReadBytesPerSecond field's value.
func (s *DiskResourceUtilization) SetDiskReadBytesPerSecond(v string) *DiskResourceUtilization {
	s.DiskReadBytesPerSecond = &v
	return s
}

// SetDiskReadOpsPerSecond sets the DiskReadOpsPerSecond field's value.
func (s *DiskResourceUtilization) SetDiskReadOpsPerSecond(v string) *DiskResourceUtilization {
	s.DiskReadOpsPerSecond = &v
	return s
}

// SetDiskWriteBytesPerSecond sets the DiskWriteBytesPerSecond field's value.
func (s *DiskResourceUtilization) SetDiskWriteBytesPerSecond(v string) *DiskResourceUtilization {
	s.DiskWriteBytesPerSecond = &v
	return s
}

// SetDiskWriteOpsPerSecond sets the DiskWriteOpsPerSecond field's value.
func (s *DiskResourceUtilization) SetDiskWriteOpsPerSecond(v string) *DiskResourceUtilization {
	s.DiskWriteOpsPerSecond = &v
	return s
}

// The EBS field that contains a list of EBS metrics that are associated with
// the current instance.
type EBSResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The maximum size of read operations per second
	EbsReadBytesPerSecond *string `type:"string"`

	// The maximum number of read operations per second.
	EbsReadOpsPerSecond *string `type:"string"`

	// The maximum size of write operations per second.
	EbsWriteBytesPerSecond *string `type:"string"`

	// The maximum number of write operations per second.
	EbsWriteOpsPerSecond *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSResourceUtilization) GoString() string {
	return s.String()
}

// SetEbsReadBytesPerSecond sets the EbsReadBytesPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsReadBytesPerSecond(v string) *EBSResourceUtilization {
	s.EbsReadBytesPerSecond = &v
	return s
}

// SetEbsReadOpsPerSecond sets the EbsReadOpsPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsReadOpsPerSecond(v string) *EBSResourceUtilization {
	s.EbsReadOpsPerSecond = &v
	return s
}

// SetEbsWriteBytesPerSecond sets the EbsWriteBytesPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsWriteBytesPerSecond(v string) *EBSResourceUtilization {
	s.EbsWriteBytesPerSecond = &v
	return s
}

// SetEbsWriteOpsPerSecond sets the EbsWriteOpsPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsWriteOpsPerSecond(v string) *EBSResourceUtilization {
	s.EbsWriteOpsPerSecond = &v
	return s
}

// Details about the Amazon EC2 reservations that Amazon Web Services recommends
// that you purchase.
type EC2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the recommended reservation.
	AvailabilityZone *string `type:"string"`

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string `type:"string"`

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The Amazon Web Services Region of the recommended reservation.
	Region *string `type:"string"`

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`

	// Determines whether the recommended reservation is dedicated or shared.
	Tenancy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2InstanceDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *EC2InstanceDetails) SetAvailabilityZone(v string) *EC2InstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *EC2InstanceDetails) SetCurrentGeneration(v bool) *EC2InstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *EC2InstanceDetails) SetFamily(v string) *EC2InstanceDetails {
	s.Family = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *EC2InstanceDetails) SetInstanceType(v string) *EC2InstanceDetails {
	s.InstanceType = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EC2InstanceDetails) SetPlatform(v string) *EC2InstanceDetails {
	s.Platform = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EC2InstanceDetails) SetRegion(v string) *EC2InstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *EC2InstanceDetails) SetSizeFlexEligible(v bool) *EC2InstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *EC2InstanceDetails) SetTenancy(v string) *EC2InstanceDetails {
	s.Tenancy = &v
	return s
}

// Details on the Amazon EC2 Resource.
type EC2ResourceDetails struct {
	_ struct{} `type:"structure"`

	// The hourly public On-Demand rate for the instance type.
	HourlyOnDemandRate *string `type:"string"`

	// The type of Amazon Web Services instance.
	InstanceType *string `type:"string"`

	// The memory capacity of the Amazon Web Services instance.
	Memory *string `type:"string"`

	// The network performance capacity of the Amazon Web Services instance.
	NetworkPerformance *string `type:"string"`

	// The platform of the Amazon Web Services instance. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The Amazon Web Services Region of the instance.
	Region *string `type:"string"`

	// The SKU of the product.
	Sku *string `type:"string"`

	// The disk storage of the Amazon Web Services instance. This doesn't include
	// EBS storage.
	Storage *string `type:"string"`

	// The number of VCPU cores in the Amazon Web Services instance type.
	Vcpu *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ResourceDetails) GoString() string {
	return s.String()
}

// SetHourlyOnDemandRate sets the HourlyOnDemandRate field's value.
func (s *EC2ResourceDetails) SetHourlyOnDemandRate(v string) *EC2ResourceDetails {
	s.HourlyOnDemandRate = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *EC2ResourceDetails) SetInstanceType(v string) *EC2ResourceDetails {
	s.InstanceType = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *EC2ResourceDetails) SetMemory(v string) *EC2ResourceDetails {
	s.Memory = &v
	return s
}

// SetNetworkPerformance sets the NetworkPerformance field's value.
func (s *EC2ResourceDetails) SetNetworkPerformance(v string) *EC2ResourceDetails {
	s.NetworkPerformance = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EC2ResourceDetails) SetPlatform(v string) *EC2ResourceDetails {
	s.Platform = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EC2ResourceDetails) SetRegion(v string) *EC2ResourceDetails {
	s.Region = &v
	return s
}

// SetSku sets the Sku field's value.
func (s *EC2ResourceDetails) SetSku(v string) *EC2ResourceDetails {
	s.Sku = &v
	return s
}

// SetStorage sets the Storage field's value.
func (s *EC2ResourceDetails) SetStorage(v string) *EC2ResourceDetails {
	s.Storage = &v
	return s
}

// SetVcpu sets the Vcpu field's value.
func (s *EC2ResourceDetails) SetVcpu(v string) *EC2ResourceDetails {
	s.Vcpu = &v
	return s
}

// Utilization metrics for the instance.
type EC2ResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The field that contains a list of disk (local storage) metrics that are associated
	// with the current instance.
	DiskResourceUtilization *DiskResourceUtilization `type:"structure"`

	// The EBS field that contains a list of EBS metrics that are associated with
	// the current instance.
	EBSResourceUtilization *EBSResourceUtilization `type:"structure"`

	// The maximum observed or expected CPU utilization of the instance.
	MaxCpuUtilizationPercentage *string `type:"string"`

	// The maximum observed or expected memory utilization of the instance.
	MaxMemoryUtilizationPercentage *string `type:"string"`

	// The maximum observed or expected storage utilization of the instance. This
	// doesn't include EBS storage.
	MaxStorageUtilizationPercentage *string `type:"string"`

	// The network field that contains a list of network metrics that are associated
	// with the current instance.
	NetworkResourceUtilization *NetworkResourceUtilization `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ResourceUtilization) GoString() string {
	return s.String()
}

// SetDiskResourceUtilization sets the DiskResourceUtilization field's value.
func (s *EC2ResourceUtilization) SetDiskResourceUtilization(v *DiskResourceUtilization) *EC2ResourceUtilization {
	s.DiskResourceUtilization = v
	return s
}

// SetEBSResourceUtilization sets the EBSResourceUtilization field's value.
func (s *EC2ResourceUtilization) SetEBSResourceUtilization(v *EBSResourceUtilization) *EC2ResourceUtilization {
	s.EBSResourceUtilization = v
	return s
}

// SetMaxCpuUtilizationPercentage sets the MaxCpuUtilizationPercentage field's value.
func (s *EC2ResourceUtilization) SetMaxCpuUtilizationPercentage(v string) *EC2ResourceUtilization {
	s.MaxCpuUtilizationPercentage = &v
	return s
}

// SetMaxMemoryUtilizationPercentage sets the MaxMemoryUtilizationPercentage field's value.
func (s *EC2ResourceUtilization) SetMaxMemoryUtilizationPercentage(v string) *EC2ResourceUtilization {
	s.MaxMemoryUtilizationPercentage = &v
	return s
}

// SetMaxStorageUtilizationPercentage sets the MaxStorageUtilizationPercentage field's value.
func (s *EC2ResourceUtilization) SetMaxStorageUtilizationPercentage(v string) *EC2ResourceUtilization {
	s.MaxStorageUtilizationPercentage = &v
	return s
}

// SetNetworkResourceUtilization sets the NetworkResourceUtilization field's value.
func (s *EC2ResourceUtilization) SetNetworkResourceUtilization(v *NetworkResourceUtilization) *EC2ResourceUtilization {
	s.NetworkResourceUtilization = v
	return s
}

// The Amazon EC2 hardware specifications that you want Amazon Web Services
// to provide recommendations for.
type EC2Specification struct {
	_ struct{} `type:"structure"`

	// Indicates whether you want a recommendation for standard or convertible reservations.
	OfferingClass *string `type:"string" enum:"OfferingClass"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2Specification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2Specification) GoString() string {
	return s.String()
}

// SetOfferingClass sets the OfferingClass field's value.
func (s *EC2Specification) SetOfferingClass(v string) *EC2Specification {
	s.OfferingClass = &v
	return s
}

// Details about the Amazon OpenSearch Service reservations that Amazon Web
// Services recommends that you purchase.
type ESInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The class of instance that Amazon Web Services recommends.
	InstanceClass *string `type:"string"`

	// The size of instance that Amazon Web Services recommends.
	InstanceSize *string `type:"string"`

	// The Amazon Web Services Region of the recommended reservation.
	Region *string `type:"string"`

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ESInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ESInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *ESInstanceDetails) SetCurrentGeneration(v bool) *ESInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetInstanceClass sets the InstanceClass field's value.
func (s *ESInstanceDetails) SetInstanceClass(v string) *ESInstanceDetails {
	s.InstanceClass = &v
	return s
}

// SetInstanceSize sets the InstanceSize field's value.
func (s *ESInstanceDetails) SetInstanceSize(v string) *ESInstanceDetails {
	s.InstanceSize = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ESInstanceDetails) SetRegion(v string) *ESInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *ESInstanceDetails) SetSizeFlexEligible(v bool) *ESInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// Details about the Amazon ElastiCache reservations that Amazon Web Services
// recommends that you purchase.
type ElastiCacheInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that Amazon Web Services recommends.
	NodeType *string `type:"string"`

	// The description of the recommended reservation.
	ProductDescription *string `type:"string"`

	// The Amazon Web Services Region of the recommended reservation.
	Region *string `type:"string"`

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElastiCacheInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElastiCacheInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *ElastiCacheInstanceDetails) SetCurrentGeneration(v bool) *ElastiCacheInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *ElastiCacheInstanceDetails) SetFamily(v string) *ElastiCacheInstanceDetails {
	s.Family = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ElastiCacheInstanceDetails) SetNodeType(v string) *ElastiCacheInstanceDetails {
	s.NodeType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *ElastiCacheInstanceDetails) SetProductDescription(v string) *ElastiCacheInstanceDetails {
	s.ProductDescription = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ElastiCacheInstanceDetails) SetRegion(v string) *ElastiCacheInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *ElastiCacheInstanceDetails) SetSizeFlexEligible(v bool) *ElastiCacheInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// Use Expression to filter in various Cost Explorer APIs.
//
// Not all Expression types are supported in each API. Refer to the documentation
// for each specific API to see what is supported.
//
// There are two patterns:
//
//   - Simple dimension values. There are three types of simple dimension values:
//     CostCategories, Tags, and Dimensions. Specify the CostCategories field
//     to define a filter that acts on Cost Categories. Specify the Tags field
//     to define a filter that acts on Cost Allocation Tags. Specify the Dimensions
//     field to define a filter that acts on the DimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html).
//     For each filter type, you can set the dimension name and values for the
//     filters that you plan to use. For example, you can filter for REGION==us-east-1
//     OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is
//     a full name (for example, REGION==US East (N. Virginia). The corresponding
//     Expression for this example is as follows: { "Dimensions": { "Key": "REGION",
//     "Values": [ "us-east-1", "us-west-1" ] } } As shown in the previous example,
//     lists of dimension values are combined with OR when applying the filter.
//     You can also set different match options to further control how the filter
//     behaves. Not all APIs support match options. Refer to the documentation
//     for each specific API to see what is supported. For example, you can filter
//     for linked account names that start with "a". The corresponding Expression
//     for this example is as follows: { "Dimensions": { "Key": "LINKED_ACCOUNT_NAME",
//     "MatchOptions": [ "STARTS_WITH" ], "Values": [ "a" ] } }
//
//   - Compound Expression types with logical operations. You can use multiple
//     Expression types and the logical operators AND/OR/NOT to create a list
//     of one or more Expression objects. By doing this, you can filter by more
//     advanced options. For example, you can filter by ((REGION == us-east-1
//     OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
//     The corresponding Expression for this example is as follows: { "And":
//     [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
//     "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] }
//     } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
//     }}} ] } Because each Expression can have only one operator, the service
//     returns an error if more than one is specified. The following example
//     shows an Expression object that creates an error: { "And": [ ... ], "Dimensions":
//     { "Key": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } The following
//     is an example of the corresponding error message: "Expression has more
//     than one roots. Only one root operator is allowed for each expression:
//     And, Or, Not, Dimensions, Tags, CostCategories"
//
// For the GetRightsizingRecommendation action, a combination of OR and NOT
// isn't supported. OR isn't supported between different dimensions, or dimensions
// and tags. NOT operators aren't supported. Dimensions are also limited to
// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
//
// For the GetReservationPurchaseRecommendation action, only NOT is supported.
// AND and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT.
type Expression struct {
	_ struct{} `type:"structure"`

	// Return results that match both Dimension objects.
	And []*Expression `type:"list"`

	// The filter that's based on CostCategory values.
	CostCategories *CostCategoryValues `type:"structure"`

	// The specific Dimension to use for Expression.
	Dimensions *DimensionValues `type:"structure"`

	// Return results that don't match a Dimension object.
	Not *Expression `type:"structure"`

	// Return results that match either Dimension object.
	Or []*Expression `type:"list"`

	// The specific Tag to use for Expression.
	Tags *TagValues `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Expression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Expression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Expression"}
	if s.CostCategories != nil {
		if err := s.CostCategories.Validate(); err != nil {
			invalidParams.AddNested("CostCategories", err.(request.ErrInvalidParams))
		}
	}
	if s.Not != nil {
		if err := s.Not.Validate(); err != nil {
			invalidParams.AddNested("Not", err.(request.ErrInvalidParams))
		}
	}
	if s.Or != nil {
		for i, v := range s.Or {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Or", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *Expression) SetAnd(v []*Expression) *Expression {
	s.And = v
	return s
}

// SetCostCategories sets the CostCategories field's value.
func (s *Expression) SetCostCategories(v *CostCategoryValues) *Expression {
	s.CostCategories = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *Expression) SetDimensions(v *DimensionValues) *Expression {
	s.Dimensions = v
	return s
}

// SetNot sets the Not field's value.
func (s *Expression) SetNot(v *Expression) *Expression {
	s.Not = v
	return s
}

// SetOr sets the Or field's value.
func (s *Expression) SetOr(v []*Expression) *Expression {
	s.Or = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Expression) SetTags(v *TagValues) *Expression {
	s.Tags = v
	return s
}

// The forecast that's created for your query.
type ForecastResult struct {
	_ struct{} `type:"structure"`

	// The mean value of the forecast.
	MeanValue *string `type:"string"`

	// The lower limit for the prediction interval.
	PredictionIntervalLowerBound *string `type:"string"`

	// The upper limit for the prediction interval.
	PredictionIntervalUpperBound *string `type:"string"`

	// The period of time that the forecast covers.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForecastResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForecastResult) GoString() string {
	return s.String()
}

// SetMeanValue sets the MeanValue field's value.
func (s *ForecastResult) SetMeanValue(v string) *ForecastResult {
	s.MeanValue = &v
	return s
}

// SetPredictionIntervalLowerBound sets the PredictionIntervalLowerBound field's value.
func (s *ForecastResult) SetPredictionIntervalLowerBound(v string) *ForecastResult {
	s.PredictionIntervalLowerBound = &v
	return s
}

// SetPredictionIntervalUpperBound sets the PredictionIntervalUpperBound field's value.
func (s *ForecastResult) SetPredictionIntervalUpperBound(v string) *ForecastResult {
	s.PredictionIntervalUpperBound = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *ForecastResult) SetTimePeriod(v *DateInterval) *ForecastResult {
	s.TimePeriod = v
	return s
}

// A request to generate a recommendation is already in progress.
type GenerationExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerationExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerationExistsException) GoString() string {
	return s.String()
}

func newErrorGenerationExistsException(v protocol.ResponseMetadata) error {
	return &GenerationExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GenerationExistsException) Code() string {
	return "GenerationExistsException"
}

// Message returns the exception's message.
func (s *GenerationExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GenerationExistsException) OrigErr() error {
	return nil
}

func (s *GenerationExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GenerationExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GenerationExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The summary of the Savings Plans recommendation generation.
type GenerationSummary struct {
	_ struct{} `type:"structure"`

	// Indicates the estimated time for when the recommendation generation will
	// complete.
	EstimatedCompletionTime *string `min:"20" type:"string"`

	// Indicates the completion time of the recommendation generation.
	GenerationCompletionTime *string `min:"20" type:"string"`

	// Indicates the start time of the recommendation generation.
	GenerationStartedTime *string `min:"20" type:"string"`

	// Indicates whether the recommendation generation succeeded, is processing,
	// or failed.
	GenerationStatus *string `type:"string" enum:"GenerationStatus"`

	// Indicates the ID for this specific recommendation.
	RecommendationId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerationSummary) GoString() string {
	return s.String()
}

// SetEstimatedCompletionTime sets the EstimatedCompletionTime field's value.
func (s *GenerationSummary) SetEstimatedCompletionTime(v string) *GenerationSummary {
	s.EstimatedCompletionTime = &v
	return s
}

// SetGenerationCompletionTime sets the GenerationCompletionTime field's value.
func (s *GenerationSummary) SetGenerationCompletionTime(v string) *GenerationSummary {
	s.GenerationCompletionTime = &v
	return s
}

// SetGenerationStartedTime sets the GenerationStartedTime field's value.
func (s *GenerationSummary) SetGenerationStartedTime(v string) *GenerationSummary {
	s.GenerationStartedTime = &v
	return s
}

// SetGenerationStatus sets the GenerationStatus field's value.
func (s *GenerationSummary) SetGenerationStatus(v string) *GenerationSummary {
	s.GenerationStatus = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *GenerationSummary) SetRecommendationId(v string) *GenerationSummary {
	s.RecommendationId = &v
	return s
}

type GetAnomaliesInput struct {
	_ struct{} `type:"structure"`

	// Assigns the start and end dates for retrieving cost anomalies. The returned
	// anomaly object will have an AnomalyEndDate in the specified time range.
	//
	// DateInterval is a required field
	DateInterval *AnomalyDateInterval `type:"structure" required:"true"`

	// Filters anomaly results by the feedback field on the anomaly object.
	Feedback *string `type:"string" enum:"AnomalyFeedbackType"`

	// The number of entries a paginated response contains.
	MaxResults *int64 `type:"integer"`

	// Retrieves all of the cost anomalies detected for a specific cost anomaly
	// monitor Amazon Resource Name (ARN).
	MonitorArn *string `type:"string"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// Filters anomaly results by the total impact field on the anomaly object.
	// For example, you can filter anomalies GREATER_THAN 200.00 to retrieve anomalies,
	// with an estimated dollar impact greater than 200.
	TotalImpact *TotalImpactFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomaliesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomaliesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnomaliesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnomaliesInput"}
	if s.DateInterval == nil {
		invalidParams.Add(request.NewErrParamRequired("DateInterval"))
	}
	if s.DateInterval != nil {
		if err := s.DateInterval.Validate(); err != nil {
			invalidParams.AddNested("DateInterval", err.(request.ErrInvalidParams))
		}
	}
	if s.TotalImpact != nil {
		if err := s.TotalImpact.Validate(); err != nil {
			invalidParams.AddNested("TotalImpact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateInterval sets the DateInterval field's value.
func (s *GetAnomaliesInput) SetDateInterval(v *AnomalyDateInterval) *GetAnomaliesInput {
	s.DateInterval = v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *GetAnomaliesInput) SetFeedback(v string) *GetAnomaliesInput {
	s.Feedback = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAnomaliesInput) SetMaxResults(v int64) *GetAnomaliesInput {
	s.MaxResults = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *GetAnomaliesInput) SetMonitorArn(v string) *GetAnomaliesInput {
	s.MonitorArn = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomaliesInput) SetNextPageToken(v string) *GetAnomaliesInput {
	s.NextPageToken = &v
	return s
}

// SetTotalImpact sets the TotalImpact field's value.
func (s *GetAnomaliesInput) SetTotalImpact(v *TotalImpactFilter) *GetAnomaliesInput {
	s.TotalImpact = v
	return s
}

type GetAnomaliesOutput struct {
	_ struct{} `type:"structure"`

	// A list of cost anomalies.
	//
	// Anomalies is a required field
	Anomalies []*Anomaly `type:"list" required:"true"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomaliesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomaliesOutput) GoString() string {
	return s.String()
}

// SetAnomalies sets the Anomalies field's value.
func (s *GetAnomaliesOutput) SetAnomalies(v []*Anomaly) *GetAnomaliesOutput {
	s.Anomalies = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomaliesOutput) SetNextPageToken(v string) *GetAnomaliesOutput {
	s.NextPageToken = &v
	return s
}

type GetAnomalyMonitorsInput struct {
	_ struct{} `type:"structure"`

	// The number of entries that a paginated response contains.
	MaxResults *int64 `type:"integer"`

	// A list of cost anomaly monitor ARNs.
	MonitorArnList []*string `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyMonitorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyMonitorsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAnomalyMonitorsInput) SetMaxResults(v int64) *GetAnomalyMonitorsInput {
	s.MaxResults = &v
	return s
}

// SetMonitorArnList sets the MonitorArnList field's value.
func (s *GetAnomalyMonitorsInput) SetMonitorArnList(v []*string) *GetAnomalyMonitorsInput {
	s.MonitorArnList = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalyMonitorsInput) SetNextPageToken(v string) *GetAnomalyMonitorsInput {
	s.NextPageToken = &v
	return s
}

type GetAnomalyMonitorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cost anomaly monitors that includes the detailed metadata for each
	// monitor.
	//
	// AnomalyMonitors is a required field
	AnomalyMonitors []*AnomalyMonitor `type:"list" required:"true"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyMonitorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalyMonitorsOutput) GoString() string {
	return s.String()
}

// SetAnomalyMonitors sets the AnomalyMonitors field's value.
func (s *GetAnomalyMonitorsOutput) SetAnomalyMonitors(v []*AnomalyMonitor) *GetAnomalyMonitorsOutput {
	s.AnomalyMonitors = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalyMonitorsOutput) SetNextPageToken(v string) *GetAnomalyMonitorsOutput {
	s.NextPageToken = &v
	return s
}

type GetAnomalySubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// The number of entries a paginated response contains.
	MaxResults *int64 `type:"integer"`

	// Cost anomaly monitor ARNs.
	MonitorArn *string `type:"string"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// A list of cost anomaly subscription ARNs.
	SubscriptionArnList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalySubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalySubscriptionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAnomalySubscriptionsInput) SetMaxResults(v int64) *GetAnomalySubscriptionsInput {
	s.MaxResults = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *GetAnomalySubscriptionsInput) SetMonitorArn(v string) *GetAnomalySubscriptionsInput {
	s.MonitorArn = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalySubscriptionsInput) SetNextPageToken(v string) *GetAnomalySubscriptionsInput {
	s.NextPageToken = &v
	return s
}

// SetSubscriptionArnList sets the SubscriptionArnList field's value.
func (s *GetAnomalySubscriptionsInput) SetSubscriptionArnList(v []*string) *GetAnomalySubscriptionsInput {
	s.SubscriptionArnList = v
	return s
}

type GetAnomalySubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cost anomaly subscriptions that includes the detailed metadata
	// for each one.
	//
	// AnomalySubscriptions is a required field
	AnomalySubscriptions []*AnomalySubscription `type:"list" required:"true"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalySubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnomalySubscriptionsOutput) GoString() string {
	return s.String()
}

// SetAnomalySubscriptions sets the AnomalySubscriptions field's value.
func (s *GetAnomalySubscriptionsOutput) SetAnomalySubscriptions(v []*AnomalySubscription) *GetAnomalySubscriptionsOutput {
	s.AnomalySubscriptions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalySubscriptionsOutput) SetNextPageToken(v string) *GetAnomalySubscriptionsOutput {
	s.NextPageToken = &v
	return s
}

type GetApproximateUsageRecordsInput struct {
	_ struct{} `type:"structure"`

	// The service to evaluate for the usage records. You can choose resource-level
	// data at daily granularity, or hourly granularity with or without resource-level
	// data.
	//
	// ApproximationDimension is a required field
	ApproximationDimension *string `type:"string" required:"true" enum:"ApproximationDimension"`

	// How granular you want the data to be. You can enable data at hourly or daily
	// granularity.
	//
	// Granularity is a required field
	Granularity *string `type:"string" required:"true" enum:"Granularity"`

	// The service metadata for the service or services you want to query. If not
	// specified, all elements are returned.
	Services []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApproximateUsageRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApproximateUsageRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApproximateUsageRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApproximateUsageRecordsInput"}
	if s.ApproximationDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ApproximationDimension"))
	}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApproximationDimension sets the ApproximationDimension field's value.
func (s *GetApproximateUsageRecordsInput) SetApproximationDimension(v string) *GetApproximateUsageRecordsInput {
	s.ApproximationDimension = &v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetApproximateUsageRecordsInput) SetGranularity(v string) *GetApproximateUsageRecordsInput {
	s.Granularity = &v
	return s
}

// SetServices sets the Services field's value.
func (s *GetApproximateUsageRecordsInput) SetServices(v []*string) *GetApproximateUsageRecordsInput {
	s.Services = v
	return s
}

type GetApproximateUsageRecordsOutput struct {
	_ struct{} `type:"structure"`

	// The lookback period that's used for the estimation.
	LookbackPeriod *DateInterval `type:"structure"`

	// The service metadata for the service or services in the response.
	Services map[string]*int64 `type:"map"`

	// The total number of usage records for all services in the services list.
	TotalRecords *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApproximateUsageRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApproximateUsageRecordsOutput) GoString() string {
	return s.String()
}

// SetLookbackPeriod sets the LookbackPeriod field's value.
func (s *GetApproximateUsageRecordsOutput) SetLookbackPeriod(v *DateInterval) *GetApproximateUsageRecordsOutput {
	s.LookbackPeriod = v
	return s
}

// SetServices sets the Services field's value.
func (s *GetApproximateUsageRecordsOutput) SetServices(v map[string]*int64) *GetApproximateUsageRecordsOutput {
	s.Services = v
	return s
}

// SetTotalRecords sets the TotalRecords field's value.
func (s *GetApproximateUsageRecordsOutput) SetTotalRecords(v int64) *GetApproximateUsageRecordsOutput {
	s.TotalRecords = &v
	return s
}

type GetCostAndUsageInput struct {
	_ struct{} `type:"structure"`

	// Filters Amazon Web Services costs by different dimensions. For example, you
	// can specify SERVICE and LINKED_ACCOUNT and get the costs that are associated
	// with that account's usage of that service. You can nest Expression objects
	// to define any combination of dimension filters. For more information, see
	// Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
	//
	// Valid values for MatchOptions for Dimensions are EQUALS and CASE_SENSITIVE.
	//
	// Valid values for MatchOptions for CostCategories and Tags are EQUALS, ABSENT,
	// and CASE_SENSITIVE. Default values are EQUALS and CASE_SENSITIVE.
	Filter *Expression `type:"structure"`

	// Sets the Amazon Web Services cost granularity to MONTHLY or DAILY, or HOURLY.
	// If Granularity isn't set, the response object doesn't include the Granularity,
	// either MONTHLY or DAILY, or HOURLY.
	//
	// Granularity is a required field
	Granularity *string `type:"string" required:"true" enum:"Granularity"`

	// You can group Amazon Web Services costs using up to two different groups,
	// either dimensions, tag keys, cost categories, or any two group by types.
	//
	// Valid values for the DIMENSION type are AZ, INSTANCE_TYPE, LEGAL_ENTITY_NAME,
	// INVOICING_ENTITY, LINKED_ACCOUNT, OPERATION, PLATFORM, PURCHASE_TYPE, SERVICE,
	// TENANCY, RECORD_TYPE, and USAGE_TYPE.
	//
	// When you group by the TAG type and include a valid tag key, you get all tag
	// values, including empty strings.
	GroupBy []*GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see Why does the "blended" annotation appear on some
	// line items in my bill? (http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values are AmortizedCost, BlendedCost, NetAmortizedCost, NetUnblendedCost,
	// NormalizedUsageAmount, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking into account the units. For example, if you aggregate
	// usageQuantity across all of Amazon EC2, the results aren't meaningful because
	// Amazon EC2 compute hours and data transfer are measured in different units
	// (for example, hours and GB). To get more meaningful UsageQuantity metrics,
	// filter by UsageType or UsageTypeGroups.
	//
	// Metrics is required for GetCostAndUsage requests.
	//
	// Metrics is a required field
	Metrics []*string `type:"list" required:"true"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// Sets the start date and end date for retrieving Amazon Web Services costs.
	// The start date is inclusive, but the end date is exclusive. For example,
	// if start is 2017-01-01 and end is 2017-05-01, then the cost and usage data
	// is retrieved from 2017-01-01 up to and including 2017-04-30 but not including
	// 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostAndUsageInput"}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.Metrics == nil {
		invalidParams.Add(request.NewErrParamRequired("Metrics"))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostAndUsageInput) SetFilter(v *Expression) *GetCostAndUsageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostAndUsageInput) SetGranularity(v string) *GetCostAndUsageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetCostAndUsageInput) SetGroupBy(v []*GroupDefinition) *GetCostAndUsageInput {
	s.GroupBy = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetCostAndUsageInput) SetMetrics(v []*string) *GetCostAndUsageInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageInput) SetNextPageToken(v string) *GetCostAndUsageInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostAndUsageInput) SetTimePeriod(v *DateInterval) *GetCostAndUsageInput {
	s.TimePeriod = v
	return s
}

type GetCostAndUsageOutput struct {
	_ struct{} `type:"structure"`

	// The attributes that apply to a specific dimension value. For example, if
	// the value is a linked account, the attribute is that account name.
	DimensionValueAttributes []*DimensionValuesWithAttributes `type:"list"`

	// The groups that are specified by the Filter or GroupBy parameters in the
	// request.
	GroupDefinitions []*GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The time period that's covered by the results in the response.
	ResultsByTime []*ResultByTime `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageOutput) GoString() string {
	return s.String()
}

// SetDimensionValueAttributes sets the DimensionValueAttributes field's value.
func (s *GetCostAndUsageOutput) SetDimensionValueAttributes(v []*DimensionValuesWithAttributes) *GetCostAndUsageOutput {
	s.DimensionValueAttributes = v
	return s
}

// SetGroupDefinitions sets the GroupDefinitions field's value.
func (s *GetCostAndUsageOutput) SetGroupDefinitions(v []*GroupDefinition) *GetCostAndUsageOutput {
	s.GroupDefinitions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageOutput) SetNextPageToken(v string) *GetCostAndUsageOutput {
	s.NextPageToken = &v
	return s
}

// SetResultsByTime sets the ResultsByTime field's value.
func (s *GetCostAndUsageOutput) SetResultsByTime(v []*ResultByTime) *GetCostAndUsageOutput {
	s.ResultsByTime = v
	return s
}

type GetCostAndUsageWithResourcesInput struct {
	_ struct{} `type:"structure"`

	// Filters Amazon Web Services costs by different dimensions. For example, you
	// can specify SERVICE and LINKED_ACCOUNT and get the costs that are associated
	// with that account's usage of that service. You can nest Expression objects
	// to define any combination of dimension filters. For more information, see
	// Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
	//
	// The GetCostAndUsageWithResources operation requires that you either group
	// by or filter by a ResourceId. It requires the Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// "SERVICE = Amazon Elastic Compute Cloud - Compute" in the filter.
	//
	// Valid values for MatchOptions for Dimensions are EQUALS and CASE_SENSITIVE.
	//
	// Valid values for MatchOptions for CostCategories and Tags are EQUALS, ABSENT,
	// and CASE_SENSITIVE. Default values are EQUALS and CASE_SENSITIVE.
	//
	// Filter is a required field
	Filter *Expression `type:"structure" required:"true"`

	// Sets the Amazon Web Services cost granularity to MONTHLY, DAILY, or HOURLY.
	// If Granularity isn't set, the response object doesn't include the Granularity,
	// MONTHLY, DAILY, or HOURLY.
	//
	// Granularity is a required field
	Granularity *string `type:"string" required:"true" enum:"Granularity"`

	// You can group Amazon Web Services costs using up to two different groups:
	// DIMENSION, TAG, COST_CATEGORY.
	GroupBy []*GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see Why does the "blended" annotation appear on some
	// line items in my bill? (http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values are AmortizedCost, BlendedCost, NetAmortizedCost, NetUnblendedCost,
	// NormalizedUsageAmount, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking the units into account. For example, if you aggregate
	// usageQuantity across all of Amazon EC2, the results aren't meaningful because
	// Amazon EC2 compute hours and data transfer are measured in different units
	// (for example, hour or GB). To get more meaningful UsageQuantity metrics,
	// filter by UsageType or UsageTypeGroups.
	//
	// Metrics is required for GetCostAndUsageWithResources requests.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving Amazon Web Services costs. The
	// range must be within the last 14 days (the start date cannot be earlier than
	// 14 days ago). The start date is inclusive, but the end date is exclusive.
	// For example, if start is 2017-01-01 and end is 2017-05-01, then the cost
	// and usage data is retrieved from 2017-01-01 up to and including 2017-04-30
	// but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageWithResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageWithResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageWithResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostAndUsageWithResourcesInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostAndUsageWithResourcesInput) SetFilter(v *Expression) *GetCostAndUsageWithResourcesInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostAndUsageWithResourcesInput) SetGranularity(v string) *GetCostAndUsageWithResourcesInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetCostAndUsageWithResourcesInput) SetGroupBy(v []*GroupDefinition) *GetCostAndUsageWithResourcesInput {
	s.GroupBy = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetCostAndUsageWithResourcesInput) SetMetrics(v []*string) *GetCostAndUsageWithResourcesInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageWithResourcesInput) SetNextPageToken(v string) *GetCostAndUsageWithResourcesInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostAndUsageWithResourcesInput) SetTimePeriod(v *DateInterval) *GetCostAndUsageWithResourcesInput {
	s.TimePeriod = v
	return s
}

type GetCostAndUsageWithResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes that apply to a specific dimension value. For example, if
	// the value is a linked account, the attribute is that account name.
	DimensionValueAttributes []*DimensionValuesWithAttributes `type:"list"`

	// The groups that are specified by the Filter or GroupBy parameters in the
	// request.
	GroupDefinitions []*GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The time period that's covered by the results in the response.
	ResultsByTime []*ResultByTime `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageWithResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostAndUsageWithResourcesOutput) GoString() string {
	return s.String()
}

// SetDimensionValueAttributes sets the DimensionValueAttributes field's value.
func (s *GetCostAndUsageWithResourcesOutput) SetDimensionValueAttributes(v []*DimensionValuesWithAttributes) *GetCostAndUsageWithResourcesOutput {
	s.DimensionValueAttributes = v
	return s
}

// SetGroupDefinitions sets the GroupDefinitions field's value.
func (s *GetCostAndUsageWithResourcesOutput) SetGroupDefinitions(v []*GroupDefinition) *GetCostAndUsageWithResourcesOutput {
	s.GroupDefinitions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageWithResourcesOutput) SetNextPageToken(v string) *GetCostAndUsageWithResourcesOutput {
	s.NextPageToken = &v
	return s
}

// SetResultsByTime sets the ResultsByTime field's value.
func (s *GetCostAndUsageWithResourcesOutput) SetResultsByTime(v []*ResultByTime) *GetCostAndUsageWithResourcesOutput {
	s.ResultsByTime = v
	return s
}

type GetCostCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the Cost Category.
	CostCategoryName *string `min:"1" type:"string"`

	// Use Expression to filter in various Cost Explorer APIs.
	//
	// Not all Expression types are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// There are two patterns:
	//
	//    * Simple dimension values. There are three types of simple dimension values:
	//    CostCategories, Tags, and Dimensions. Specify the CostCategories field
	//    to define a filter that acts on Cost Categories. Specify the Tags field
	//    to define a filter that acts on Cost Allocation Tags. Specify the Dimensions
	//    field to define a filter that acts on the DimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html).
	//    For each filter type, you can set the dimension name and values for the
	//    filters that you plan to use. For example, you can filter for REGION==us-east-1
	//    OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is
	//    a full name (for example, REGION==US East (N. Virginia). The corresponding
	//    Expression for this example is as follows: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", "us-west-1" ] } } As shown in the previous example,
	//    lists of dimension values are combined with OR when applying the filter.
	//    You can also set different match options to further control how the filter
	//    behaves. Not all APIs support match options. Refer to the documentation
	//    for each specific API to see what is supported. For example, you can filter
	//    for linked account names that start with "a". The corresponding Expression
	//    for this example is as follows: { "Dimensions": { "Key": "LINKED_ACCOUNT_NAME",
	//    "MatchOptions": [ "STARTS_WITH" ], "Values": [ "a" ] } }
	//
	//    * Compound Expression types with logical operations. You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. By doing this, you can filter by more
	//    advanced options. For example, you can filter by ((REGION == us-east-1
	//    OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The corresponding Expression for this example is as follows: { "And":
	//    [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
	//    "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] }
	//    } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
	//    }}} ] } Because each Expression can have only one operator, the service
	//    returns an error if more than one is specified. The following example
	//    shows an Expression object that creates an error: { "And": [ ... ], "Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } The following
	//    is an example of the corresponding error message: "Expression has more
	//    than one roots. Only one root operator is allowed for each expression:
	//    And, Or, Not, Dimensions, Tags, CostCategories"
	//
	// For the GetRightsizingRecommendation action, a combination of OR and NOT
	// isn't supported. OR isn't supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	//
	// For the GetReservationPurchaseRecommendation action, only NOT is supported.
	// AND and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT.
	Filter *Expression `type:"structure"`

	// This field is only used when the SortBy value is provided in the request.
	//
	// The maximum number of objects that are returned for this request. If MaxResults
	// isn't specified with the SortBy value, the request returns 1000 results as
	// the default value for this parameter.
	//
	// For GetCostCategories, MaxResults has an upper quota of 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the number of objects that are still available for retrieval exceeds the
	// quota, Amazon Web Services returns a NextPageToken value in the response.
	// To retrieve the next batch of objects, provide the NextPageToken from the
	// previous call in your next request.
	NextPageToken *string `type:"string"`

	// The value that you want to search the filter values for.
	//
	// If you don't specify a CostCategoryName, SearchString is used to filter Cost
	// Category names that match the SearchString pattern. If you specify a CostCategoryName,
	// SearchString is used to filter Cost Category values that match the SearchString
	// pattern.
	SearchString *string `type:"string"`

	// The value that you sort the data by.
	//
	// The key represents the cost and usage metrics. The following values are supported:
	//
	//    * BlendedCost
	//
	//    * UnblendedCost
	//
	//    * AmortizedCost
	//
	//    * NetAmortizedCost
	//
	//    * NetUnblendedCost
	//
	//    * UsageQuantity
	//
	//    * NormalizedUsageAmount
	//
	// The supported key values for the SortOrder value are ASCENDING and DESCENDING.
	//
	// When you use the SortBy value, the NextPageToken and SearchString key values
	// aren't supported.
	SortBy []*SortDefinition `type:"list"`

	// The time period of the request.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostCategoriesInput"}
	if s.CostCategoryName != nil && len(*s.CostCategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CostCategoryName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		for i, v := range s.SortBy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortBy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostCategoryName sets the CostCategoryName field's value.
func (s *GetCostCategoriesInput) SetCostCategoryName(v string) *GetCostCategoriesInput {
	s.CostCategoryName = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetCostCategoriesInput) SetFilter(v *Expression) *GetCostCategoriesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCostCategoriesInput) SetMaxResults(v int64) *GetCostCategoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostCategoriesInput) SetNextPageToken(v string) *GetCostCategoriesInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetCostCategoriesInput) SetSearchString(v string) *GetCostCategoriesInput {
	s.SearchString = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetCostCategoriesInput) SetSortBy(v []*SortDefinition) *GetCostCategoriesInput {
	s.SortBy = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostCategoriesInput) SetTimePeriod(v *DateInterval) *GetCostCategoriesInput {
	s.TimePeriod = v
	return s
}

type GetCostCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// The names of the Cost Categories.
	CostCategoryNames []*string `type:"list"`

	// The Cost Category values.
	//
	// If the CostCategoryName key isn't specified in the request, the CostCategoryValues
	// fields aren't returned.
	CostCategoryValues []*string `type:"list"`

	// If the number of objects that are still available for retrieval exceeds the
	// quota, Amazon Web Services returns a NextPageToken value in the response.
	// To retrieve the next batch of objects, provide the marker from the prior
	// call in your next request.
	NextPageToken *string `type:"string"`

	// The number of objects that are returned.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The total number of objects.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostCategoriesOutput) GoString() string {
	return s.String()
}

// SetCostCategoryNames sets the CostCategoryNames field's value.
func (s *GetCostCategoriesOutput) SetCostCategoryNames(v []*string) *GetCostCategoriesOutput {
	s.CostCategoryNames = v
	return s
}

// SetCostCategoryValues sets the CostCategoryValues field's value.
func (s *GetCostCategoriesOutput) SetCostCategoryValues(v []*string) *GetCostCategoriesOutput {
	s.CostCategoryValues = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostCategoriesOutput) SetNextPageToken(v string) *GetCostCategoriesOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetCostCategoriesOutput) SetReturnSize(v int64) *GetCostCategoriesOutput {
	s.ReturnSize = &v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetCostCategoriesOutput) SetTotalSize(v int64) *GetCostCategoriesOutput {
	s.TotalSize = &v
	return s
}

type GetCostForecastInput struct {
	_ struct{} `type:"structure"`

	// The filters that you want to use to filter your forecast. The GetCostForecast
	// API supports filtering by the following dimensions:
	//
	//    * AZ
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * LINKED_ACCOUNT_NAME
	//
	//    * OPERATION
	//
	//    * PURCHASE_TYPE
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * USAGE_TYPE
	//
	//    * USAGE_TYPE_GROUP
	//
	//    * RECORD_TYPE
	//
	//    * OPERATING_SYSTEM
	//
	//    * TENANCY
	//
	//    * SCOPE
	//
	//    * PLATFORM
	//
	//    * SUBSCRIPTION_ID
	//
	//    * LEGAL_ENTITY_NAME
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * DATABASE_ENGINE
	//
	//    * INSTANCE_TYPE_FAMILY
	//
	//    * BILLING_ENTITY
	//
	//    * RESERVATION_ID
	//
	//    * SAVINGS_PLAN_ARN
	Filter *Expression `type:"structure"`

	// How granular you want the forecast to be. You can get 3 months of DAILY forecasts
	// or 12 months of MONTHLY forecasts.
	//
	// The GetCostForecast operation supports only DAILY and MONTHLY granularities.
	//
	// Granularity is a required field
	Granularity *string `type:"string" required:"true" enum:"Granularity"`

	// Which metric Cost Explorer uses to create your forecast. For more information
	// about blended and unblended rates, see Why does the "blended" annotation
	// appear on some line items in my bill? (http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values for a GetCostForecast call are the following:
	//
	//    * AMORTIZED_COST
	//
	//    * BLENDED_COST
	//
	//    * NET_AMORTIZED_COST
	//
	//    * NET_UNBLENDED_COST
	//
	//    * UNBLENDED_COST
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true" enum:"Metric"`

	// Cost Explorer always returns the mean forecast as a single point. You can
	// request a prediction interval around the mean by specifying a confidence
	// level. The higher the confidence level, the more confident Cost Explorer
	// is about the actual value falling in the prediction interval. Higher confidence
	// levels result in wider prediction intervals.
	PredictionIntervalLevel *int64 `min:"51" type:"integer"`

	// The period of time that you want the forecast to cover. The start date must
	// be equal to or no later than the current date to avoid a validation error.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostForecastInput"}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.PredictionIntervalLevel != nil && *s.PredictionIntervalLevel < 51 {
		invalidParams.Add(request.NewErrParamMinValue("PredictionIntervalLevel", 51))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostForecastInput) SetFilter(v *Expression) *GetCostForecastInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostForecastInput) SetGranularity(v string) *GetCostForecastInput {
	s.Granularity = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *GetCostForecastInput) SetMetric(v string) *GetCostForecastInput {
	s.Metric = &v
	return s
}

// SetPredictionIntervalLevel sets the PredictionIntervalLevel field's value.
func (s *GetCostForecastInput) SetPredictionIntervalLevel(v int64) *GetCostForecastInput {
	s.PredictionIntervalLevel = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostForecastInput) SetTimePeriod(v *DateInterval) *GetCostForecastInput {
	s.TimePeriod = v
	return s
}

type GetCostForecastOutput struct {
	_ struct{} `type:"structure"`

	// The forecasts for your query, in order. For DAILY forecasts, this is a list
	// of days. For MONTHLY forecasts, this is a list of months.
	ForecastResultsByTime []*ForecastResult `type:"list"`

	// How much you are forecasted to spend over the forecast period, in USD.
	Total *MetricValue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCostForecastOutput) GoString() string {
	return s.String()
}

// SetForecastResultsByTime sets the ForecastResultsByTime field's value.
func (s *GetCostForecastOutput) SetForecastResultsByTime(v []*ForecastResult) *GetCostForecastOutput {
	s.ForecastResultsByTime = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetCostForecastOutput) SetTotal(v *MetricValue) *GetCostForecastOutput {
	s.Total = v
	return s
}

type GetDimensionValuesInput struct {
	_ struct{} `type:"structure"`

	// The context for the call to GetDimensionValues. This can be RESERVATIONS
	// or COST_AND_USAGE. The default value is COST_AND_USAGE. If the context is
	// set to RESERVATIONS, the resulting dimension values can be used in the GetReservationUtilization
	// operation. If the context is set to COST_AND_USAGE, the resulting dimension
	// values can be used in the GetCostAndUsage operation.
	//
	// If you set the context to COST_AND_USAGE, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * BILLING_ENTITY - The Amazon Web Services seller that your account is
	//    with. Possible values are the following: - Amazon Web Services(Amazon
	//    Web Services): The entity that sells Amazon Web Services. - AISPL (Amazon
	//    Internet Services Pvt. Ltd.): The local Indian entity that's an acting
	//    reseller for Amazon Web Services in India. - Amazon Web Services Marketplace:
	//    The entity that supports the sale of solutions that are built on Amazon
	//    Web Services by third-party software providers.
	//
	//    * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are
	//    Windows or Linux.
	//
	//    * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
	//    deployments. Valid values are SingleAZ and MultiAZ.
	//
	//    * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples
	//    are Aurora or MySQL.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different
	//    use cases. Examples are Compute Optimized (for example, C4, C5, C6g, and
	//    C7g), Memory Optimization (for example, R4, R5n, R5b, and R6g).
	//
	//    * INVOICING_ENTITY - The name of the entity that issues the Amazon Web
	//    Services invoice.
	//
	//    * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon
	//    Web Services services, such as Amazon Web Services.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the Amazon
	//    Web Services ID of the member account.
	//
	//    * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
	//
	//    * OPERATION - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * PURCHASE_TYPE - The reservation type of the purchase that this usage
	//    is related to. Examples include On-Demand Instances and Standard Reserved
	//    Instances.
	//
	//    * RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation
	//    Instance.
	//
	//    * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
	//
	//    * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
	//
	//    * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
	//
	//    * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
	//
	//    * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes.
	//    The response for the GetDimensionValues operation includes a unit attribute.
	//    Examples include GB and Hrs.
	//
	//    * USAGE_TYPE_GROUP - The grouping of common usage types. An example is
	//    Amazon EC2: CloudWatch – Alarms. The response for this operation includes
	//    a unit attribute.
	//
	//    * REGION - The Amazon Web Services Region.
	//
	//    * RECORD_TYPE - The different types of charges such as Reserved Instance
	//    (RI) fees, usage costs, tax refunds, and credits.
	//
	//    * RESOURCE_ID - The unique identifier of the resource. ResourceId is an
	//    opt-in feature only available for last 14 days for EC2-Compute Service.
	//
	// If you set the context to RESERVATIONS, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are
	//    Windows or Linux.
	//
	//    * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
	//    deployments. Valid values are SingleAZ and MultiAZ.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the Amazon
	//    Web Services ID of the member account.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * REGION - The Amazon Web Services Region.
	//
	//    * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values
	//    are regional or a single Availability Zone.
	//
	//    * TAG (Coverage only) - The tags that are associated with a Reserved Instance
	//    (RI).
	//
	//    * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
	//
	// If you set the context to SAVINGS_PLANS, you can use the following dimensions
	// for searching:
	//
	//    * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
	//
	//    * PAYMENT_OPTION - The payment option for the given Savings Plans (for
	//    example, All Upfront)
	//
	//    * REGION - The Amazon Web Services Region.
	//
	//    * INSTANCE_TYPE_FAMILY - The family of instances (For example, m5)
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the Amazon
	//    Web Services ID of the member account.
	//
	//    * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
	Context *string `type:"string" enum:"Context"`

	// The name of the dimension. Each Dimension is available for a different Context.
	// For more information, see Context. LINK_ACCOUNT_NAME and SERVICE_CODE can
	// only be used in CostCategoryRule (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/AAPI_CostCategoryRule.html).
	//
	// Dimension is a required field
	Dimension *string `type:"string" required:"true" enum:"Dimension"`

	// Use Expression to filter in various Cost Explorer APIs.
	//
	// Not all Expression types are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// There are two patterns:
	//
	//    * Simple dimension values. There are three types of simple dimension values:
	//    CostCategories, Tags, and Dimensions. Specify the CostCategories field
	//    to define a filter that acts on Cost Categories. Specify the Tags field
	//    to define a filter that acts on Cost Allocation Tags. Specify the Dimensions
	//    field to define a filter that acts on the DimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html).
	//    For each filter type, you can set the dimension name and values for the
	//    filters that you plan to use. For example, you can filter for REGION==us-east-1
	//    OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is
	//    a full name (for example, REGION==US East (N. Virginia). The corresponding
	//    Expression for this example is as follows: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", "us-west-1" ] } } As shown in the previous example,
	//    lists of dimension values are combined with OR when applying the filter.
	//    You can also set different match options to further control how the filter
	//    behaves. Not all APIs support match options. Refer to the documentation
	//    for each specific API to see what is supported. For example, you can filter
	//    for linked account names that start with "a". The corresponding Expression
	//    for this example is as follows: { "Dimensions": { "Key": "LINKED_ACCOUNT_NAME",
	//    "MatchOptions": [ "STARTS_WITH" ], "Values": [ "a" ] } }
	//
	//    * Compound Expression types with logical operations. You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. By doing this, you can filter by more
	//    advanced options. For example, you can filter by ((REGION == us-east-1
	//    OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The corresponding Expression for this example is as follows: { "And":
	//    [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
	//    "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] }
	//    } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
	//    }}} ] } Because each Expression can have only one operator, the service
	//    returns an error if more than one is specified. The following example
	//    shows an Expression object that creates an error: { "And": [ ... ], "Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } The following
	//    is an example of the corresponding error message: "Expression has more
	//    than one roots. Only one root operator is allowed for each expression:
	//    And, Or, Not, Dimensions, Tags, CostCategories"
	//
	// For the GetRightsizingRecommendation action, a combination of OR and NOT
	// isn't supported. OR isn't supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	//
	// For the GetReservationPurchaseRecommendation action, only NOT is supported.
	// AND and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT.
	Filter *Expression `type:"structure"`

	// This field is only used when SortBy is provided in the request. The maximum
	// number of objects that are returned for this request. If MaxResults isn't
	// specified with SortBy, the request returns 1000 results as the default value
	// for this parameter.
	//
	// For GetDimensionValues, MaxResults has an upper limit of 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The value that you want to search the filter values for.
	SearchString *string `type:"string"`

	// The value that you want to sort the data by.
	//
	// The key represents cost and usage metrics. The following values are supported:
	//
	//    * BlendedCost
	//
	//    * UnblendedCost
	//
	//    * AmortizedCost
	//
	//    * NetAmortizedCost
	//
	//    * NetUnblendedCost
	//
	//    * UsageQuantity
	//
	//    * NormalizedUsageAmount
	//
	// The supported values for the SortOrder key are ASCENDING or DESCENDING.
	//
	// When you specify a SortBy paramater, the context must be COST_AND_USAGE.
	// Further, when using SortBy, NextPageToken and SearchString aren't supported.
	SortBy []*SortDefinition `type:"list"`

	// The start date and end date for retrieving the dimension values. The start
	// date is inclusive, but the end date is exclusive. For example, if start is
	// 2017-01-01 and end is 2017-05-01, then the cost and usage data is retrieved
	// from 2017-01-01 up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDimensionValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDimensionValuesInput"}
	if s.Dimension == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimension"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		for i, v := range s.SortBy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortBy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContext sets the Context field's value.
func (s *GetDimensionValuesInput) SetContext(v string) *GetDimensionValuesInput {
	s.Context = &v
	return s
}

// SetDimension sets the Dimension field's value.
func (s *GetDimensionValuesInput) SetDimension(v string) *GetDimensionValuesInput {
	s.Dimension = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetDimensionValuesInput) SetFilter(v *Expression) *GetDimensionValuesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDimensionValuesInput) SetMaxResults(v int64) *GetDimensionValuesInput {
	s.MaxResults = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesInput) SetNextPageToken(v string) *GetDimensionValuesInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetDimensionValuesInput) SetSearchString(v string) *GetDimensionValuesInput {
	s.SearchString = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetDimensionValuesInput) SetSortBy(v []*SortDefinition) *GetDimensionValuesInput {
	s.SortBy = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetDimensionValuesInput) SetTimePeriod(v *DateInterval) *GetDimensionValuesInput {
	s.TimePeriod = v
	return s
}

type GetDimensionValuesOutput struct {
	_ struct{} `type:"structure"`

	// The filters that you used to filter your request. Some dimensions are available
	// only for a specific context.
	//
	// If you set the context to COST_AND_USAGE, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples
	//    are Aurora or MySQL.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon
	//    Web Services services, such as Amazon Web Services.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the Amazon
	//    Web Services ID of the member account.
	//
	//    * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
	//
	//    * OPERATION - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * PURCHASE_TYPE - The reservation type of the purchase to which this usage
	//    is related. Examples include On-Demand Instances and Standard Reserved
	//    Instances.
	//
	//    * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
	//
	//    * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes.
	//    The response for the GetDimensionValues operation includes a unit attribute.
	//    Examples include GB and Hrs.
	//
	//    * USAGE_TYPE_GROUP - The grouping of common usage types. An example is
	//    Amazon EC2: CloudWatch – Alarms. The response for this operation includes
	//    a unit attribute.
	//
	//    * RECORD_TYPE - The different types of charges such as RI fees, usage
	//    costs, tax refunds, and credits.
	//
	//    * RESOURCE_ID - The unique identifier of the resource. ResourceId is an
	//    opt-in feature only available for last 14 days for EC2-Compute Service.
	//    You can opt-in by enabling Hourly and Resource Level Data in Cost Management
	//    Console preferences.
	//
	// If you set the context to RESERVATIONS, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are
	//    Windows or Linux.
	//
	//    * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
	//    deployments. Valid values are SingleAZ and MultiAZ.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the Amazon
	//    Web Services ID of the member account.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * REGION - The Amazon Web Services Region.
	//
	//    * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values
	//    are regional or a single Availability Zone.
	//
	//    * TAG (Coverage only) - The tags that are associated with a Reserved Instance
	//    (RI).
	//
	//    * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
	//
	// If you set the context to SAVINGS_PLANS, you can use the following dimensions
	// for searching:
	//
	//    * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
	//
	//    * PAYMENT_OPTION - Payment option for the given Savings Plans (for example,
	//    All Upfront)
	//
	//    * REGION - The Amazon Web Services Region.
	//
	//    * INSTANCE_TYPE_FAMILY - The family of instances (For example, m5)
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the Amazon
	//    Web Services ID of the member account.
	//
	//    * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
	//
	// DimensionValues is a required field
	DimensionValues []*DimensionValuesWithAttributes `type:"list" required:"true"`

	// The token for the next set of retrievable results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The number of results that Amazon Web Services returned at one time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The total number of search results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionValuesOutput) GoString() string {
	return s.String()
}

// SetDimensionValues sets the DimensionValues field's value.
func (s *GetDimensionValuesOutput) SetDimensionValues(v []*DimensionValuesWithAttributes) *GetDimensionValuesOutput {
	s.DimensionValues = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesOutput) SetNextPageToken(v string) *GetDimensionValuesOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetDimensionValuesOutput) SetReturnSize(v int64) *GetDimensionValuesOutput {
	s.ReturnSize = &v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetDimensionValuesOutput) SetTotalSize(v int64) *GetDimensionValuesOutput {
	s.TotalSize = &v
	return s
}

// You can use the following request parameters to query for how much of your
// instance usage a reservation covered.
type GetReservationCoverageInput struct {
	_ struct{} `type:"structure"`

	// Filters utilization data by dimensions. You can filter by the following dimensions:
	//
	//    * AZ
	//
	//    * CACHE_ENGINE
	//
	//    * DATABASE_ENGINE
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * OPERATING_SYSTEM
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * TAG
	//
	//    * TENANCY
	//
	// GetReservationCoverage uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	// You can nest only one level deep. If there are multiple values for a dimension,
	// they are OR'd together.
	//
	// If you don't provide a SERVICE filter, Cost Explorer defaults to EC2.
	//
	// Cost category is also supported.
	Filter *Expression `type:"structure"`

	// The granularity of the Amazon Web Services cost data for the reservation.
	// Valid values are MONTHLY and DAILY.
	//
	// If GroupBy is set, Granularity can't be set. If Granularity isn't set, the
	// response object doesn't include Granularity, either MONTHLY or DAILY.
	//
	// The GetReservationCoverage operation supports only DAILY and MONTHLY granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group the data by the following attributes:
	//
	//    * AZ
	//
	//    * CACHE_ENGINE
	//
	//    * DATABASE_ENGINE
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * INSTANCE_TYPE
	//
	//    * INVOICING_ENTITY
	//
	//    * LINKED_ACCOUNT
	//
	//    * OPERATING_SYSTEM
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * TENANCY
	GroupBy []*GroupDefinition `type:"list"`

	// The maximum number of objects that you returned for this request. If more
	// objects are available, in the response, Amazon Web Services provides a NextPageToken
	// value that you can use in a subsequent call to get the next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// The measurement that you want your reservation coverage reported in.
	//
	// Valid values are Hour, Unit, and Cost. You can use multiple values in a request.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The value by which you want to sort the data.
	//
	// The following values are supported for Key:
	//
	//    * OnDemandCost
	//
	//    * CoverageHoursPercentage
	//
	//    * OnDemandHours
	//
	//    * ReservedHours
	//
	//    * TotalRunningHours
	//
	//    * CoverageNormalizedUnitsPercentage
	//
	//    * OnDemandNormalizedUnits
	//
	//    * ReservedNormalizedUnits
	//
	//    * TotalRunningNormalizedUnits
	//
	//    * Time
	//
	// Supported values for SortOrder are ASCENDING or DESCENDING.
	SortBy *SortDefinition `type:"structure"`

	// The start and end dates of the period that you want to retrieve data about
	// reservation coverage for. You can retrieve data for a maximum of 13 months:
	// the last 12 months and the current month. The start date is inclusive, but
	// the end date is exclusive. For example, if start is 2017-01-01 and end is
	// 2017-05-01, then the cost and usage data is retrieved from 2017-01-01 up
	// to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationCoverageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationCoverageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationCoverageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationCoverageInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetReservationCoverageInput) SetFilter(v *Expression) *GetReservationCoverageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetReservationCoverageInput) SetGranularity(v string) *GetReservationCoverageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetReservationCoverageInput) SetGroupBy(v []*GroupDefinition) *GetReservationCoverageInput {
	s.GroupBy = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReservationCoverageInput) SetMaxResults(v int64) *GetReservationCoverageInput {
	s.MaxResults = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetReservationCoverageInput) SetMetrics(v []*string) *GetReservationCoverageInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationCoverageInput) SetNextPageToken(v string) *GetReservationCoverageInput {
	s.NextPageToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetReservationCoverageInput) SetSortBy(v *SortDefinition) *GetReservationCoverageInput {
	s.SortBy = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetReservationCoverageInput) SetTimePeriod(v *DateInterval) *GetReservationCoverageInput {
	s.TimePeriod = v
	return s
}

type GetReservationCoverageOutput struct {
	_ struct{} `type:"structure"`

	// The amount of time that your reservations covered.
	//
	// CoveragesByTime is a required field
	CoveragesByTime []*CoverageByTime `type:"list" required:"true"`

	// The token for the next set of retrievable results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The total amount of instance usage that a reservation covered.
	Total *Coverage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationCoverageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationCoverageOutput) GoString() string {
	return s.String()
}

// SetCoveragesByTime sets the CoveragesByTime field's value.
func (s *GetReservationCoverageOutput) SetCoveragesByTime(v []*CoverageByTime) *GetReservationCoverageOutput {
	s.CoveragesByTime = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationCoverageOutput) SetNextPageToken(v string) *GetReservationCoverageOutput {
	s.NextPageToken = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetReservationCoverageOutput) SetTotal(v *Coverage) *GetReservationCoverageOutput {
	s.Total = v
	return s
}

type GetReservationPurchaseRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The account ID that's associated with the recommendation.
	AccountId *string `type:"string"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER. If the value is LINKED, recommendations are
	// calculated for individual member accounts only.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// Use Expression to filter in various Cost Explorer APIs.
	//
	// Not all Expression types are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// There are two patterns:
	//
	//    * Simple dimension values. There are three types of simple dimension values:
	//    CostCategories, Tags, and Dimensions. Specify the CostCategories field
	//    to define a filter that acts on Cost Categories. Specify the Tags field
	//    to define a filter that acts on Cost Allocation Tags. Specify the Dimensions
	//    field to define a filter that acts on the DimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html).
	//    For each filter type, you can set the dimension name and values for the
	//    filters that you plan to use. For example, you can filter for REGION==us-east-1
	//    OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is
	//    a full name (for example, REGION==US East (N. Virginia). The corresponding
	//    Expression for this example is as follows: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", "us-west-1" ] } } As shown in the previous example,
	//    lists of dimension values are combined with OR when applying the filter.
	//    You can also set different match options to further control how the filter
	//    behaves. Not all APIs support match options. Refer to the documentation
	//    for each specific API to see what is supported. For example, you can filter
	//    for linked account names that start with "a". The corresponding Expression
	//    for this example is as follows: { "Dimensions": { "Key": "LINKED_ACCOUNT_NAME",
	//    "MatchOptions": [ "STARTS_WITH" ], "Values": [ "a" ] } }
	//
	//    * Compound Expression types with logical operations. You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. By doing this, you can filter by more
	//    advanced options. For example, you can filter by ((REGION == us-east-1
	//    OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The corresponding Expression for this example is as follows: { "And":
	//    [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
	//    "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] }
	//    } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
	//    }}} ] } Because each Expression can have only one operator, the service
	//    returns an error if more than one is specified. The following example
	//    shows an Expression object that creates an error: { "And": [ ... ], "Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } The following
	//    is an example of the corresponding error message: "Expression has more
	//    than one roots. Only one root operator is allowed for each expression:
	//    And, Or, Not, Dimensions, Tags, CostCategories"
	//
	// For the GetRightsizingRecommendation action, a combination of OR and NOT
	// isn't supported. OR isn't supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	//
	// For the GetReservationPurchaseRecommendation action, only NOT is supported.
	// AND and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT.
	Filter *Expression `type:"structure"`

	// The number of previous days that you want Amazon Web Services to consider
	// when it calculates your recommendations.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The pagination token that indicates the next set of results that you want
	// to retrieve.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The reservation purchase option that you want recommendations for.
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// The specific service that you want recommendations for.
	//
	// Service is a required field
	Service *string `type:"string" required:"true"`

	// The hardware specifications for the service instances that you want recommendations
	// for, such as standard or convertible Amazon EC2 instances.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The reservation term that you want recommendations for.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationPurchaseRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationPurchaseRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationPurchaseRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationPurchaseRecommendationInput"}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetReservationPurchaseRecommendationInput) SetAccountId(v string) *GetReservationPurchaseRecommendationInput {
	s.AccountId = &v
	return s
}

// SetAccountScope sets the AccountScope field's value.
func (s *GetReservationPurchaseRecommendationInput) SetAccountScope(v string) *GetReservationPurchaseRecommendationInput {
	s.AccountScope = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetReservationPurchaseRecommendationInput) SetFilter(v *Expression) *GetReservationPurchaseRecommendationInput {
	s.Filter = v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *GetReservationPurchaseRecommendationInput) SetLookbackPeriodInDays(v string) *GetReservationPurchaseRecommendationInput {
	s.LookbackPeriodInDays = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationPurchaseRecommendationInput) SetNextPageToken(v string) *GetReservationPurchaseRecommendationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetReservationPurchaseRecommendationInput) SetPageSize(v int64) *GetReservationPurchaseRecommendationInput {
	s.PageSize = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *GetReservationPurchaseRecommendationInput) SetPaymentOption(v string) *GetReservationPurchaseRecommendationInput {
	s.PaymentOption = &v
	return s
}

// SetService sets the Service field's value.
func (s *GetReservationPurchaseRecommendationInput) SetService(v string) *GetReservationPurchaseRecommendationInput {
	s.Service = &v
	return s
}

// SetServiceSpecification sets the ServiceSpecification field's value.
func (s *GetReservationPurchaseRecommendationInput) SetServiceSpecification(v *ServiceSpecification) *GetReservationPurchaseRecommendationInput {
	s.ServiceSpecification = v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *GetReservationPurchaseRecommendationInput) SetTermInYears(v string) *GetReservationPurchaseRecommendationInput {
	s.TermInYears = &v
	return s
}

type GetReservationPurchaseRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// Information about this specific recommendation call, such as the time stamp
	// for when Cost Explorer generated this recommendation.
	Metadata *ReservationPurchaseRecommendationMetadata `type:"structure"`

	// The pagination token for the next set of retrievable results.
	NextPageToken *string `type:"string"`

	// Recommendations for reservations to purchase.
	Recommendations []*ReservationPurchaseRecommendation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationPurchaseRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationPurchaseRecommendationOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetMetadata(v *ReservationPurchaseRecommendationMetadata) *GetReservationPurchaseRecommendationOutput {
	s.Metadata = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetNextPageToken(v string) *GetReservationPurchaseRecommendationOutput {
	s.NextPageToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetRecommendations(v []*ReservationPurchaseRecommendation) *GetReservationPurchaseRecommendationOutput {
	s.Recommendations = v
	return s
}

type GetReservationUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Filters utilization data by dimensions. You can filter by the following dimensions:
	//
	//    * AZ
	//
	//    * CACHE_ENGINE
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * OPERATING_SYSTEM
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * SCOPE
	//
	//    * TENANCY
	//
	// GetReservationUtilization uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension,
	// and nesting is supported up to only one level deep. If there are multiple
	// values for a dimension, they are OR'd together.
	Filter *Expression `type:"structure"`

	// If GroupBy is set, Granularity can't be set. If Granularity isn't set, the
	// response object doesn't include Granularity, either MONTHLY or DAILY. If
	// both GroupBy and Granularity aren't set, GetReservationUtilization defaults
	// to DAILY.
	//
	// The GetReservationUtilization operation supports only DAILY and MONTHLY granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// Groups only by SUBSCRIPTION_ID. Metadata is included.
	GroupBy []*GroupDefinition `type:"list"`

	// The maximum number of objects that you returned for this request. If more
	// objects are available, in the response, Amazon Web Services provides a NextPageToken
	// value that you can use in a subsequent call to get the next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The value that you want to sort the data by.
	//
	// The following values are supported for Key:
	//
	//    * UtilizationPercentage
	//
	//    * UtilizationPercentageInUnits
	//
	//    * PurchasedHours
	//
	//    * PurchasedUnits
	//
	//    * TotalActualHours
	//
	//    * TotalActualUnits
	//
	//    * UnusedHours
	//
	//    * UnusedUnits
	//
	//    * OnDemandCostOfRIHoursUsed
	//
	//    * NetRISavings
	//
	//    * TotalPotentialRISavings
	//
	//    * AmortizedUpfrontFee
	//
	//    * AmortizedRecurringFee
	//
	//    * TotalAmortizedFee
	//
	//    * RICostForUnusedHours
	//
	//    * RealizedSavings
	//
	//    * UnrealizedSavings
	//
	// The supported values for SortOrder are ASCENDING and DESCENDING.
	SortBy *SortDefinition `type:"structure"`

	// Sets the start and end dates for retrieving Reserved Instance (RI) utilization.
	// The start date is inclusive, but the end date is exclusive. For example,
	// if start is 2017-01-01 and end is 2017-05-01, then the cost and usage data
	// is retrieved from 2017-01-01 up to and including 2017-04-30 but not including
	// 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationUtilizationInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetReservationUtilizationInput) SetFilter(v *Expression) *GetReservationUtilizationInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetReservationUtilizationInput) SetGranularity(v string) *GetReservationUtilizationInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetReservationUtilizationInput) SetGroupBy(v []*GroupDefinition) *GetReservationUtilizationInput {
	s.GroupBy = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReservationUtilizationInput) SetMaxResults(v int64) *GetReservationUtilizationInput {
	s.MaxResults = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationInput) SetNextPageToken(v string) *GetReservationUtilizationInput {
	s.NextPageToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetReservationUtilizationInput) SetSortBy(v *SortDefinition) *GetReservationUtilizationInput {
	s.SortBy = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetReservationUtilizationInput) SetTimePeriod(v *DateInterval) *GetReservationUtilizationInput {
	s.TimePeriod = v
	return s
}

type GetReservationUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The total amount of time that you used your Reserved Instances (RIs).
	Total *ReservationAggregates `type:"structure"`

	// The amount of time that you used your Reserved Instances (RIs).
	//
	// UtilizationsByTime is a required field
	UtilizationsByTime []*UtilizationByTime `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReservationUtilizationOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationOutput) SetNextPageToken(v string) *GetReservationUtilizationOutput {
	s.NextPageToken = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetReservationUtilizationOutput) SetTotal(v *ReservationAggregates) *GetReservationUtilizationOutput {
	s.Total = v
	return s
}

// SetUtilizationsByTime sets the UtilizationsByTime field's value.
func (s *GetReservationUtilizationOutput) SetUtilizationsByTime(v []*UtilizationByTime) *GetReservationUtilizationOutput {
	s.UtilizationsByTime = v
	return s
}

type GetRightsizingRecommendationInput struct {
	_ struct{} `type:"structure"`

	// You can use Configuration to customize recommendations across two attributes.
	// You can choose to view recommendations for instances within the same instance
	// families or across different instance families. You can also choose to view
	// your estimated savings that are associated with recommendations with consideration
	// of existing Savings Plans or RI benefits, or neither.
	Configuration *RightsizingRecommendationConfiguration `type:"structure"`

	// Use Expression to filter in various Cost Explorer APIs.
	//
	// Not all Expression types are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// There are two patterns:
	//
	//    * Simple dimension values. There are three types of simple dimension values:
	//    CostCategories, Tags, and Dimensions. Specify the CostCategories field
	//    to define a filter that acts on Cost Categories. Specify the Tags field
	//    to define a filter that acts on Cost Allocation Tags. Specify the Dimensions
	//    field to define a filter that acts on the DimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html).
	//    For each filter type, you can set the dimension name and values for the
	//    filters that you plan to use. For example, you can filter for REGION==us-east-1
	//    OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is
	//    a full name (for example, REGION==US East (N. Virginia). The corresponding
	//    Expression for this example is as follows: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", "us-west-1" ] } } As shown in the previous example,
	//    lists of dimension values are combined with OR when applying the filter.
	//    You can also set different match options to further control how the filter
	//    behaves. Not all APIs support match options. Refer to the documentation
	//    for each specific API to see what is supported. For example, you can filter
	//    for linked account names that start with "a". The corresponding Expression
	//    for this example is as follows: { "Dimensions": { "Key": "LINKED_ACCOUNT_NAME",
	//    "MatchOptions": [ "STARTS_WITH" ], "Values": [ "a" ] } }
	//
	//    * Compound Expression types with logical operations. You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. By doing this, you can filter by more
	//    advanced options. For example, you can filter by ((REGION == us-east-1
	//    OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The corresponding Expression for this example is as follows: { "And":
	//    [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
	//    "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] }
	//    } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
	//    }}} ] } Because each Expression can have only one operator, the service
	//    returns an error if more than one is specified. The following example
	//    shows an Expression object that creates an error: { "And": [ ... ], "Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } The following
	//    is an example of the corresponding error message: "Expression has more
	//    than one roots. Only one root operator is allowed for each expression:
	//    And, Or, Not, Dimensions, Tags, CostCategories"
	//
	// For the GetRightsizingRecommendation action, a combination of OR and NOT
	// isn't supported. OR isn't supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	//
	// For the GetReservationPurchaseRecommendation action, only NOT is supported.
	// AND and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT.
	Filter *Expression `type:"structure"`

	// The pagination token that indicates the next set of results that you want
	// to retrieve.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The specific service that you want recommendations for. The only valid value
	// for GetRightsizingRecommendation is "AmazonEC2".
	//
	// Service is a required field
	Service *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRightsizingRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRightsizingRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRightsizingRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRightsizingRecommendationInput"}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *GetRightsizingRecommendationInput) SetConfiguration(v *RightsizingRecommendationConfiguration) *GetRightsizingRecommendationInput {
	s.Configuration = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetRightsizingRecommendationInput) SetFilter(v *Expression) *GetRightsizingRecommendationInput {
	s.Filter = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRightsizingRecommendationInput) SetNextPageToken(v string) *GetRightsizingRecommendationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetRightsizingRecommendationInput) SetPageSize(v int64) *GetRightsizingRecommendationInput {
	s.PageSize = &v
	return s
}

// SetService sets the Service field's value.
func (s *GetRightsizingRecommendationInput) SetService(v string) *GetRightsizingRecommendationInput {
	s.Service = &v
	return s
}

type GetRightsizingRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// You can use Configuration to customize recommendations across two attributes.
	// You can choose to view recommendations for instances within the same instance
	// families or across different instance families. You can also choose to view
	// your estimated savings that are associated with recommendations with consideration
	// of existing Savings Plans or RI benefits, or neither.
	Configuration *RightsizingRecommendationConfiguration `type:"structure"`

	// Information regarding this specific recommendation set.
	Metadata *RightsizingRecommendationMetadata `type:"structure"`

	// The token to retrieve the next set of results.
	NextPageToken *string `type:"string"`

	// Recommendations to rightsize resources.
	RightsizingRecommendations []*RightsizingRecommendation `type:"list"`

	// Summary of this recommendation set.
	Summary *RightsizingRecommendationSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRightsizingRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRightsizingRecommendationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *GetRightsizingRecommendationOutput) SetConfiguration(v *RightsizingRecommendationConfiguration) *GetRightsizingRecommendationOutput {
	s.Configuration = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetRightsizingRecommendationOutput) SetMetadata(v *RightsizingRecommendationMetadata) *GetRightsizingRecommendationOutput {
	s.Metadata = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRightsizingRecommendationOutput) SetNextPageToken(v string) *GetRightsizingRecommendationOutput {
	s.NextPageToken = &v
	return s
}

// SetRightsizingRecommendations sets the RightsizingRecommendations field's value.
func (s *GetRightsizingRecommendationOutput) SetRightsizingRecommendations(v []*RightsizingRecommendation) *GetRightsizingRecommendationOutput {
	s.RightsizingRecommendations = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *GetRightsizingRecommendationOutput) SetSummary(v *RightsizingRecommendationSummary) *GetRightsizingRecommendationOutput {
	s.Summary = v
	return s
}

type GetSavingsPlanPurchaseRecommendationDetailsInput struct {
	_ struct{} `type:"structure"`

	// The ID that is associated with the Savings Plan recommendation.
	//
	// RecommendationDetailId is a required field
	RecommendationDetailId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlanPurchaseRecommendationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlanPurchaseRecommendationDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlanPurchaseRecommendationDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlanPurchaseRecommendationDetailsInput"}
	if s.RecommendationDetailId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationDetailId"))
	}
	if s.RecommendationDetailId != nil && len(*s.RecommendationDetailId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationDetailId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommendationDetailId sets the RecommendationDetailId field's value.
func (s *GetSavingsPlanPurchaseRecommendationDetailsInput) SetRecommendationDetailId(v string) *GetSavingsPlanPurchaseRecommendationDetailsInput {
	s.RecommendationDetailId = &v
	return s
}

type GetSavingsPlanPurchaseRecommendationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Contains detailed information about a specific Savings Plan recommendation.
	RecommendationDetailData *RecommendationDetailData `type:"structure"`

	// The ID that is associated with the Savings Plan recommendation.
	RecommendationDetailId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlanPurchaseRecommendationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlanPurchaseRecommendationDetailsOutput) GoString() string {
	return s.String()
}

// SetRecommendationDetailData sets the RecommendationDetailData field's value.
func (s *GetSavingsPlanPurchaseRecommendationDetailsOutput) SetRecommendationDetailData(v *RecommendationDetailData) *GetSavingsPlanPurchaseRecommendationDetailsOutput {
	s.RecommendationDetailData = v
	return s
}

// SetRecommendationDetailId sets the RecommendationDetailId field's value.
func (s *GetSavingsPlanPurchaseRecommendationDetailsOutput) SetRecommendationDetailId(v string) *GetSavingsPlanPurchaseRecommendationDetailsOutput {
	s.RecommendationDetailId = &v
	return s
}

type GetSavingsPlansCoverageInput struct {
	_ struct{} `type:"structure"`

	// Filters Savings Plans coverage data by dimensions. You can filter data for
	// Savings Plans usage with the following dimensions:
	//
	//    * LINKED_ACCOUNT
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * INSTANCE_FAMILY
	//
	// GetSavingsPlansCoverage uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	// If there are multiple values for a dimension, they are OR'd together.
	//
	// Cost category is also supported.
	Filter *Expression `type:"structure"`

	// The granularity of the Amazon Web Services cost data for your Savings Plans.
	// Granularity can't be set if GroupBy is set.
	//
	// The GetSavingsPlansCoverage operation supports only DAILY and MONTHLY granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group the data using the attributes INSTANCE_FAMILY, REGION, or SERVICE.
	GroupBy []*GroupDefinition `type:"list"`

	// The number of items to be returned in a response. The default is 20, with
	// a minimum value of 1.
	MaxResults *int64 `min:"1" type:"integer"`

	// The measurement that you want your Savings Plans coverage reported in. The
	// only valid value is SpendCoveredBySavingsPlans.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The value that you want to sort the data by.
	//
	// The following values are supported for Key:
	//
	//    * SpendCoveredBySavingsPlan
	//
	//    * OnDemandCost
	//
	//    * CoveragePercentage
	//
	//    * TotalCost
	//
	//    * InstanceFamily
	//
	//    * Region
	//
	//    * Service
	//
	// The supported values for SortOrder are ASCENDING and DESCENDING.
	SortBy *SortDefinition `type:"structure"`

	// The time period that you want the usage and costs for. The Start date must
	// be within 13 months. The End date must be after the Start date, and before
	// the current date. Future dates can't be used as an End date.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansCoverageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansCoverageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansCoverageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansCoverageInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansCoverageInput) SetFilter(v *Expression) *GetSavingsPlansCoverageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetSavingsPlansCoverageInput) SetGranularity(v string) *GetSavingsPlansCoverageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetSavingsPlansCoverageInput) SetGroupBy(v []*GroupDefinition) *GetSavingsPlansCoverageInput {
	s.GroupBy = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSavingsPlansCoverageInput) SetMaxResults(v int64) *GetSavingsPlansCoverageInput {
	s.MaxResults = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetSavingsPlansCoverageInput) SetMetrics(v []*string) *GetSavingsPlansCoverageInput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansCoverageInput) SetNextToken(v string) *GetSavingsPlansCoverageInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetSavingsPlansCoverageInput) SetSortBy(v *SortDefinition) *GetSavingsPlansCoverageInput {
	s.SortBy = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansCoverageInput) SetTimePeriod(v *DateInterval) *GetSavingsPlansCoverageInput {
	s.TimePeriod = v
	return s
}

type GetSavingsPlansCoverageOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The amount of spend that your Savings Plans covered.
	//
	// SavingsPlansCoverages is a required field
	SavingsPlansCoverages []*SavingsPlansCoverage `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansCoverageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansCoverageOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansCoverageOutput) SetNextToken(v string) *GetSavingsPlansCoverageOutput {
	s.NextToken = &v
	return s
}

// SetSavingsPlansCoverages sets the SavingsPlansCoverages field's value.
func (s *GetSavingsPlansCoverageOutput) SetSavingsPlansCoverages(v []*SavingsPlansCoverage) *GetSavingsPlansCoverageOutput {
	s.SavingsPlansCoverages = v
	return s
}

type GetSavingsPlansPurchaseRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER. If the value is LINKED, recommendations are
	// calculated for individual member accounts only.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// You can filter your recommendations by Account ID with the LINKED_ACCOUNT
	// dimension. To filter your recommendations by Account ID, specify Key as LINKED_ACCOUNT
	// and Value as the comma-separated Acount ID(s) that you want to see Savings
	// Plans purchase recommendations for.
	//
	// For GetSavingsPlansPurchaseRecommendation, the Filter doesn't include CostCategories
	// or Tags. It only includes Dimensions. With Dimensions, Key must be LINKED_ACCOUNT
	// and Value can be a single Account ID or multiple comma-separated Account
	// IDs that you want to see Savings Plans Purchase Recommendations for. AND
	// and OR operators are not supported.
	Filter *Expression `type:"structure"`

	// The lookback period that's used to generate the recommendation.
	//
	// LookbackPeriodInDays is a required field
	LookbackPeriodInDays *string `type:"string" required:"true" enum:"LookbackPeriodInDays"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The payment option that's used to generate these recommendations.
	//
	// PaymentOption is a required field
	PaymentOption *string `type:"string" required:"true" enum:"PaymentOption"`

	// The Savings Plans recommendation type that's requested.
	//
	// SavingsPlansType is a required field
	SavingsPlansType *string `type:"string" required:"true" enum:"SupportedSavingsPlansType"`

	// The savings plan recommendation term that's used to generate these recommendations.
	//
	// TermInYears is a required field
	TermInYears *string `type:"string" required:"true" enum:"TermInYears"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansPurchaseRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansPurchaseRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansPurchaseRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansPurchaseRecommendationInput"}
	if s.LookbackPeriodInDays == nil {
		invalidParams.Add(request.NewErrParamRequired("LookbackPeriodInDays"))
	}
	if s.PaymentOption == nil {
		invalidParams.Add(request.NewErrParamRequired("PaymentOption"))
	}
	if s.SavingsPlansType == nil {
		invalidParams.Add(request.NewErrParamRequired("SavingsPlansType"))
	}
	if s.TermInYears == nil {
		invalidParams.Add(request.NewErrParamRequired("TermInYears"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountScope sets the AccountScope field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetAccountScope(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.AccountScope = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetFilter(v *Expression) *GetSavingsPlansPurchaseRecommendationInput {
	s.Filter = v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetLookbackPeriodInDays(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.LookbackPeriodInDays = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetNextPageToken(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetPageSize(v int64) *GetSavingsPlansPurchaseRecommendationInput {
	s.PageSize = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetPaymentOption(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.PaymentOption = &v
	return s
}

// SetSavingsPlansType sets the SavingsPlansType field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetSavingsPlansType(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.SavingsPlansType = &v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetTermInYears(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.TermInYears = &v
	return s
}

type GetSavingsPlansPurchaseRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// Information that regards this specific recommendation set.
	Metadata *SavingsPlansPurchaseRecommendationMetadata `type:"structure"`

	// The token for the next set of retrievable results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// Contains your request parameters, Savings Plan Recommendations Summary, and
	// Details.
	SavingsPlansPurchaseRecommendation *SavingsPlansPurchaseRecommendation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansPurchaseRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansPurchaseRecommendationOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetSavingsPlansPurchaseRecommendationOutput) SetMetadata(v *SavingsPlansPurchaseRecommendationMetadata) *GetSavingsPlansPurchaseRecommendationOutput {
	s.Metadata = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetSavingsPlansPurchaseRecommendationOutput) SetNextPageToken(v string) *GetSavingsPlansPurchaseRecommendationOutput {
	s.NextPageToken = &v
	return s
}

// SetSavingsPlansPurchaseRecommendation sets the SavingsPlansPurchaseRecommendation field's value.
func (s *GetSavingsPlansPurchaseRecommendationOutput) SetSavingsPlansPurchaseRecommendation(v *SavingsPlansPurchaseRecommendation) *GetSavingsPlansPurchaseRecommendationOutput {
	s.SavingsPlansPurchaseRecommendation = v
	return s
}

type GetSavingsPlansUtilizationDetailsInput struct {
	_ struct{} `type:"structure"`

	// The data type.
	DataType []*string `type:"list" enum:"SavingsPlansDataType"`

	// Filters Savings Plans utilization coverage data for active Savings Plans
	// dimensions. You can filter data with the following dimensions:
	//
	//    * LINKED_ACCOUNT
	//
	//    * SAVINGS_PLAN_ARN
	//
	//    * REGION
	//
	//    * PAYMENT_OPTION
	//
	//    * INSTANCE_TYPE_FAMILY
	//
	// GetSavingsPlansUtilizationDetails uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	Filter *Expression `type:"structure"`

	// The number of items to be returned in a response. The default is 20, with
	// a minimum value of 1.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The value that you want to sort the data by.
	//
	// The following values are supported for Key:
	//
	//    * UtilizationPercentage
	//
	//    * TotalCommitment
	//
	//    * UsedCommitment
	//
	//    * UnusedCommitment
	//
	//    * NetSavings
	//
	//    * AmortizedRecurringCommitment
	//
	//    * AmortizedUpfrontCommitment
	//
	// The supported values for SortOrder are ASCENDING and DESCENDING.
	SortBy *SortDefinition `type:"structure"`

	// The time period that you want the usage and costs for. The Start date must
	// be within 13 months. The End date must be after the Start date, and before
	// the current date. Future dates can't be used as an End date.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansUtilizationDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansUtilizationDetailsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetDataType(v []*string) *GetSavingsPlansUtilizationDetailsInput {
	s.DataType = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetFilter(v *Expression) *GetSavingsPlansUtilizationDetailsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetMaxResults(v int64) *GetSavingsPlansUtilizationDetailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetNextToken(v string) *GetSavingsPlansUtilizationDetailsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetSortBy(v *SortDefinition) *GetSavingsPlansUtilizationDetailsInput {
	s.SortBy = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetTimePeriod(v *DateInterval) *GetSavingsPlansUtilizationDetailsInput {
	s.TimePeriod = v
	return s
}

type GetSavingsPlansUtilizationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// Retrieves a single daily or monthly Savings Plans utilization rate and details
	// for your account.
	//
	// SavingsPlansUtilizationDetails is a required field
	SavingsPlansUtilizationDetails []*SavingsPlansUtilizationDetail `type:"list" required:"true"`

	// The time period of the request.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`

	// The total Savings Plans utilization, regardless of time period.
	Total *SavingsPlansUtilizationAggregates `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationDetailsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetNextToken(v string) *GetSavingsPlansUtilizationDetailsOutput {
	s.NextToken = &v
	return s
}

// SetSavingsPlansUtilizationDetails sets the SavingsPlansUtilizationDetails field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetSavingsPlansUtilizationDetails(v []*SavingsPlansUtilizationDetail) *GetSavingsPlansUtilizationDetailsOutput {
	s.SavingsPlansUtilizationDetails = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetTimePeriod(v *DateInterval) *GetSavingsPlansUtilizationDetailsOutput {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetTotal(v *SavingsPlansUtilizationAggregates) *GetSavingsPlansUtilizationDetailsOutput {
	s.Total = v
	return s
}

type GetSavingsPlansUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Filters Savings Plans utilization coverage data for active Savings Plans
	// dimensions. You can filter data with the following dimensions:
	//
	//    * LINKED_ACCOUNT
	//
	//    * SAVINGS_PLAN_ARN
	//
	//    * SAVINGS_PLANS_TYPE
	//
	//    * REGION
	//
	//    * PAYMENT_OPTION
	//
	//    * INSTANCE_TYPE_FAMILY
	//
	// GetSavingsPlansUtilization uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	Filter *Expression `type:"structure"`

	// The granularity of the Amazon Web Services utillization data for your Savings
	// Plans.
	//
	// The GetSavingsPlansUtilization operation supports only DAILY and MONTHLY
	// granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// The value that you want to sort the data by.
	//
	// The following values are supported for Key:
	//
	//    * UtilizationPercentage
	//
	//    * TotalCommitment
	//
	//    * UsedCommitment
	//
	//    * UnusedCommitment
	//
	//    * NetSavings
	//
	// The supported values for SortOrder are ASCENDING and DESCENDING.
	SortBy *SortDefinition `type:"structure"`

	// The time period that you want the usage and costs for. The Start date must
	// be within 13 months. The End date must be after the Start date, and before
	// the current date. Future dates can't be used as an End date.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansUtilizationInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansUtilizationInput) SetFilter(v *Expression) *GetSavingsPlansUtilizationInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetSavingsPlansUtilizationInput) SetGranularity(v string) *GetSavingsPlansUtilizationInput {
	s.Granularity = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetSavingsPlansUtilizationInput) SetSortBy(v *SortDefinition) *GetSavingsPlansUtilizationInput {
	s.SortBy = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansUtilizationInput) SetTimePeriod(v *DateInterval) *GetSavingsPlansUtilizationInput {
	s.TimePeriod = v
	return s
}

type GetSavingsPlansUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// The amount of cost/commitment that you used your Savings Plans. You can use
	// it to specify date ranges.
	SavingsPlansUtilizationsByTime []*SavingsPlansUtilizationByTime `type:"list"`

	// The total amount of cost/commitment that you used your Savings Plans, regardless
	// of date ranges.
	//
	// Total is a required field
	Total *SavingsPlansUtilizationAggregates `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSavingsPlansUtilizationOutput) GoString() string {
	return s.String()
}

// SetSavingsPlansUtilizationsByTime sets the SavingsPlansUtilizationsByTime field's value.
func (s *GetSavingsPlansUtilizationOutput) SetSavingsPlansUtilizationsByTime(v []*SavingsPlansUtilizationByTime) *GetSavingsPlansUtilizationOutput {
	s.SavingsPlansUtilizationsByTime = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetSavingsPlansUtilizationOutput) SetTotal(v *SavingsPlansUtilizationAggregates) *GetSavingsPlansUtilizationOutput {
	s.Total = v
	return s
}

type GetTagsInput struct {
	_ struct{} `type:"structure"`

	// Use Expression to filter in various Cost Explorer APIs.
	//
	// Not all Expression types are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// There are two patterns:
	//
	//    * Simple dimension values. There are three types of simple dimension values:
	//    CostCategories, Tags, and Dimensions. Specify the CostCategories field
	//    to define a filter that acts on Cost Categories. Specify the Tags field
	//    to define a filter that acts on Cost Allocation Tags. Specify the Dimensions
	//    field to define a filter that acts on the DimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html).
	//    For each filter type, you can set the dimension name and values for the
	//    filters that you plan to use. For example, you can filter for REGION==us-east-1
	//    OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is
	//    a full name (for example, REGION==US East (N. Virginia). The corresponding
	//    Expression for this example is as follows: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", "us-west-1" ] } } As shown in the previous example,
	//    lists of dimension values are combined with OR when applying the filter.
	//    You can also set different match options to further control how the filter
	//    behaves. Not all APIs support match options. Refer to the documentation
	//    for each specific API to see what is supported. For example, you can filter
	//    for linked account names that start with "a". The corresponding Expression
	//    for this example is as follows: { "Dimensions": { "Key": "LINKED_ACCOUNT_NAME",
	//    "MatchOptions": [ "STARTS_WITH" ], "Values": [ "a" ] } }
	//
	//    * Compound Expression types with logical operations. You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. By doing this, you can filter by more
	//    advanced options. For example, you can filter by ((REGION == us-east-1
	//    OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The corresponding Expression for this example is as follows: { "And":
	//    [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
	//    "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] }
	//    } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"]
	//    }}} ] } Because each Expression can have only one operator, the service
	//    returns an error if more than one is specified. The following example
	//    shows an Expression object that creates an error: { "And": [ ... ], "Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } The following
	//    is an example of the corresponding error message: "Expression has more
	//    than one roots. Only one root operator is allowed for each expression:
	//    And, Or, Not, Dimensions, Tags, CostCategories"
	//
	// For the GetRightsizingRecommendation action, a combination of OR and NOT
	// isn't supported. OR isn't supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	//
	// For the GetReservationPurchaseRecommendation action, only NOT is supported.
	// AND and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT.
	Filter *Expression `type:"structure"`

	// This field is only used when SortBy is provided in the request. The maximum
	// number of objects that are returned for this request. If MaxResults isn't
	// specified with SortBy, the request returns 1000 results as the default value
	// for this parameter.
	//
	// For GetTags, MaxResults has an upper quota of 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The value that you want to search for.
	SearchString *string `type:"string"`

	// The value that you want to sort the data by.
	//
	// The key represents cost and usage metrics. The following values are supported:
	//
	//    * BlendedCost
	//
	//    * UnblendedCost
	//
	//    * AmortizedCost
	//
	//    * NetAmortizedCost
	//
	//    * NetUnblendedCost
	//
	//    * UsageQuantity
	//
	//    * NormalizedUsageAmount
	//
	// The supported values for SortOrder are ASCENDING and DESCENDING.
	//
	// When you use SortBy, NextPageToken and SearchString aren't supported.
	SortBy []*SortDefinition `type:"list"`

	// The key of the tag that you want to return values for.
	TagKey *string `type:"string"`

	// The start and end dates for retrieving the dimension values. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.SortBy != nil {
		for i, v := range s.SortBy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortBy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetTagsInput) SetFilter(v *Expression) *GetTagsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTagsInput) SetMaxResults(v int64) *GetTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsInput) SetNextPageToken(v string) *GetTagsInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetTagsInput) SetSearchString(v string) *GetTagsInput {
	s.SearchString = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetTagsInput) SetSortBy(v []*SortDefinition) *GetTagsInput {
	s.SortBy = v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetTagsInput) SetTagKey(v string) *GetTagsInput {
	s.TagKey = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetTagsInput) SetTimePeriod(v *DateInterval) *GetTagsInput {
	s.TimePeriod = v
	return s
}

type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The number of query results that Amazon Web Services returns at a time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The tags that match your request.
	//
	// Tags is a required field
	Tags []*string `type:"list" required:"true"`

	// The total number of query results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsOutput) SetNextPageToken(v string) *GetTagsOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetTagsOutput) SetReturnSize(v int64) *GetTagsOutput {
	s.ReturnSize = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v []*string) *GetTagsOutput {
	s.Tags = v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetTagsOutput) SetTotalSize(v int64) *GetTagsOutput {
	s.TotalSize = &v
	return s
}

type GetUsageForecastInput struct {
	_ struct{} `type:"structure"`

	// The filters that you want to use to filter your forecast. The GetUsageForecast
	// API supports filtering by the following dimensions:
	//
	//    * AZ
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * LINKED_ACCOUNT_NAME
	//
	//    * OPERATION
	//
	//    * PURCHASE_TYPE
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * USAGE_TYPE
	//
	//    * USAGE_TYPE_GROUP
	//
	//    * RECORD_TYPE
	//
	//    * OPERATING_SYSTEM
	//
	//    * TENANCY
	//
	//    * SCOPE
	//
	//    * PLATFORM
	//
	//    * SUBSCRIPTION_ID
	//
	//    * LEGAL_ENTITY_NAME
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * DATABASE_ENGINE
	//
	//    * INSTANCE_TYPE_FAMILY
	//
	//    * BILLING_ENTITY
	//
	//    * RESERVATION_ID
	//
	//    * SAVINGS_PLAN_ARN
	Filter *Expression `type:"structure"`

	// How granular you want the forecast to be. You can get 3 months of DAILY forecasts
	// or 12 months of MONTHLY forecasts.
	//
	// The GetUsageForecast operation supports only DAILY and MONTHLY granularities.
	//
	// Granularity is a required field
	Granularity *string `type:"string" required:"true" enum:"Granularity"`

	// Which metric Cost Explorer uses to create your forecast.
	//
	// Valid values for a GetUsageForecast call are the following:
	//
	//    * USAGE_QUANTITY
	//
	//    * NORMALIZED_USAGE_AMOUNT
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true" enum:"Metric"`

	// Amazon Web Services Cost Explorer always returns the mean forecast as a single
	// point. You can request a prediction interval around the mean by specifying
	// a confidence level. The higher the confidence level, the more confident Cost
	// Explorer is about the actual value falling in the prediction interval. Higher
	// confidence levels result in wider prediction intervals.
	PredictionIntervalLevel *int64 `min:"51" type:"integer"`

	// The start and end dates of the period that you want to retrieve usage forecast
	// for. The start date is included in the period, but the end date isn't included
	// in the period. For example, if start is 2017-01-01 and end is 2017-05-01,
	// then the cost and usage data is retrieved from 2017-01-01 up to and including
	// 2017-04-30 but not including 2017-05-01. The start date must be equal to
	// or later than the current date to avoid a validation error.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsageForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsageForecastInput"}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.PredictionIntervalLevel != nil && *s.PredictionIntervalLevel < 51 {
		invalidParams.Add(request.NewErrParamMinValue("PredictionIntervalLevel", 51))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetUsageForecastInput) SetFilter(v *Expression) *GetUsageForecastInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetUsageForecastInput) SetGranularity(v string) *GetUsageForecastInput {
	s.Granularity = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *GetUsageForecastInput) SetMetric(v string) *GetUsageForecastInput {
	s.Metric = &v
	return s
}

// SetPredictionIntervalLevel sets the PredictionIntervalLevel field's value.
func (s *GetUsageForecastInput) SetPredictionIntervalLevel(v int64) *GetUsageForecastInput {
	s.PredictionIntervalLevel = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetUsageForecastInput) SetTimePeriod(v *DateInterval) *GetUsageForecastInput {
	s.TimePeriod = v
	return s
}

type GetUsageForecastOutput struct {
	_ struct{} `type:"structure"`

	// The forecasts for your query, in order. For DAILY forecasts, this is a list
	// of days. For MONTHLY forecasts, this is a list of months.
	ForecastResultsByTime []*ForecastResult `type:"list"`

	// How much you're forecasted to use over the forecast period.
	Total *MetricValue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageForecastOutput) GoString() string {
	return s.String()
}

// SetForecastResultsByTime sets the ForecastResultsByTime field's value.
func (s *GetUsageForecastOutput) SetForecastResultsByTime(v []*ForecastResult) *GetUsageForecastOutput {
	s.ForecastResultsByTime = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetUsageForecastOutput) SetTotal(v *MetricValue) *GetUsageForecastOutput {
	s.Total = v
	return s
}

// One level of grouped data in the results.
type Group struct {
	_ struct{} `type:"structure"`

	// The keys that are included in this group.
	Keys []*string `type:"list"`

	// The metrics that are included in this group.
	Metrics map[string]*MetricValue `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) GoString() string {
	return s.String()
}

// SetKeys sets the Keys field's value.
func (s *Group) SetKeys(v []*string) *Group {
	s.Keys = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Group) SetMetrics(v map[string]*MetricValue) *Group {
	s.Metrics = v
	return s
}

// Represents a group when you specify a group by criteria or in the response
// to a query with a specific grouping.
type GroupDefinition struct {
	_ struct{} `type:"structure"`

	// The string that represents a key for a specified group.
	Key *string `type:"string"`

	// The string that represents the type of group.
	Type *string `type:"string" enum:"GroupDefinitionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupDefinition) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *GroupDefinition) SetKey(v string) *GroupDefinition {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *GroupDefinition) SetType(v string) *GroupDefinition {
	s.Type = &v
	return s
}

// The dollar value of the anomaly.
type Impact struct {
	_ struct{} `type:"structure"`

	// The maximum dollar value that's observed for an anomaly.
	//
	// MaxImpact is a required field
	MaxImpact *float64 `type:"double" required:"true"`

	// The cumulative dollar amount that was actually spent during the anomaly.
	TotalActualSpend *float64 `type:"double"`

	// The cumulative dollar amount that was expected to be spent during the anomaly.
	// It is calculated using advanced machine learning models to determine the
	// typical spending pattern based on historical data for a customer.
	TotalExpectedSpend *float64 `type:"double"`

	// The cumulative dollar difference between the total actual spend and total
	// expected spend. It is calculated as TotalActualSpend - TotalExpectedSpend.
	TotalImpact *float64 `type:"double"`

	// The cumulative percentage difference between the total actual spend and total
	// expected spend. It is calculated as (TotalImpact / TotalExpectedSpend) *
	// 100. When TotalExpectedSpend is zero, this field is omitted. Expected spend
	// can be zero in situations such as when you start to use a service for the
	// first time.
	TotalImpactPercentage *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Impact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Impact) GoString() string {
	return s.String()
}

// SetMaxImpact sets the MaxImpact field's value.
func (s *Impact) SetMaxImpact(v float64) *Impact {
	s.MaxImpact = &v
	return s
}

// SetTotalActualSpend sets the TotalActualSpend field's value.
func (s *Impact) SetTotalActualSpend(v float64) *Impact {
	s.TotalActualSpend = &v
	return s
}

// SetTotalExpectedSpend sets the TotalExpectedSpend field's value.
func (s *Impact) SetTotalExpectedSpend(v float64) *Impact {
	s.TotalExpectedSpend = &v
	return s
}

// SetTotalImpact sets the TotalImpact field's value.
func (s *Impact) SetTotalImpact(v float64) *Impact {
	s.TotalImpact = &v
	return s
}

// SetTotalImpactPercentage sets the TotalImpactPercentage field's value.
func (s *Impact) SetTotalImpactPercentage(v float64) *Impact {
	s.TotalImpactPercentage = &v
	return s
}

// Details about the reservations that Amazon Web Services recommends that you
// purchase.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 reservations that Amazon Web Services recommends that you
	// purchase.
	EC2InstanceDetails *EC2InstanceDetails `type:"structure"`

	// The Amazon OpenSearch Service reservations that Amazon Web Services recommends
	// that you purchase.
	ESInstanceDetails *ESInstanceDetails `type:"structure"`

	// The ElastiCache reservations that Amazon Web Services recommends that you
	// purchase.
	ElastiCacheInstanceDetails *ElastiCacheInstanceDetails `type:"structure"`

	// The MemoryDB reservations that Amazon Web Services recommends that you purchase.
	MemoryDBInstanceDetails *MemoryDBInstanceDetails `type:"structure"`

	// The Amazon RDS reservations that Amazon Web Services recommends that you
	// purchase.
	RDSInstanceDetails *RDSInstanceDetails `type:"structure"`

	// The Amazon Redshift reservations that Amazon Web Services recommends that
	// you purchase.
	RedshiftInstanceDetails *RedshiftInstanceDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceDetails) GoString() string {
	return s.String()
}

// SetEC2InstanceDetails sets the EC2InstanceDetails field's value.
func (s *InstanceDetails) SetEC2InstanceDetails(v *EC2InstanceDetails) *InstanceDetails {
	s.EC2InstanceDetails = v
	return s
}

// SetESInstanceDetails sets the ESInstanceDetails field's value.
func (s *InstanceDetails) SetESInstanceDetails(v *ESInstanceDetails) *InstanceDetails {
	s.ESInstanceDetails = v
	return s
}

// SetElastiCacheInstanceDetails sets the ElastiCacheInstanceDetails field's value.
func (s *InstanceDetails) SetElastiCacheInstanceDetails(v *ElastiCacheInstanceDetails) *InstanceDetails {
	s.ElastiCacheInstanceDetails = v
	return s
}

// SetMemoryDBInstanceDetails sets the MemoryDBInstanceDetails field's value.
func (s *InstanceDetails) SetMemoryDBInstanceDetails(v *MemoryDBInstanceDetails) *InstanceDetails {
	s.MemoryDBInstanceDetails = v
	return s
}

// SetRDSInstanceDetails sets the RDSInstanceDetails field's value.
func (s *InstanceDetails) SetRDSInstanceDetails(v *RDSInstanceDetails) *InstanceDetails {
	s.RDSInstanceDetails = v
	return s
}

// SetRedshiftInstanceDetails sets the RedshiftInstanceDetails field's value.
func (s *InstanceDetails) SetRedshiftInstanceDetails(v *RedshiftInstanceDetails) *InstanceDetails {
	s.RedshiftInstanceDetails = v
	return s
}

// The pagination token is invalid. Try again without a pagination token.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You made too many calls in a short period of time. Try again later.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCostAllocationTagsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that are returned for this request. By default,
	// the request returns 100 results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The status of cost allocation tag keys that are returned for this request.
	Status *string `type:"string" enum:"CostAllocationTagStatus"`

	// The list of cost allocation tag keys that are returned for this request.
	TagKeys []*string `min:"1" type:"list"`

	// The type of CostAllocationTag object that are returned for this request.
	// The AWSGenerated type tags are tags that Amazon Web Services defines and
	// applies to support Amazon Web Services resources for cost allocation purposes.
	// The UserDefined type tags are tags that you define, create, and apply to
	// resources.
	Type *string `type:"string" enum:"CostAllocationTagType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostAllocationTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostAllocationTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCostAllocationTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCostAllocationTagsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCostAllocationTagsInput) SetMaxResults(v int64) *ListCostAllocationTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCostAllocationTagsInput) SetNextToken(v string) *ListCostAllocationTagsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCostAllocationTagsInput) SetStatus(v string) *ListCostAllocationTagsInput {
	s.Status = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *ListCostAllocationTagsInput) SetTagKeys(v []*string) *ListCostAllocationTagsInput {
	s.TagKeys = v
	return s
}

// SetType sets the Type field's value.
func (s *ListCostAllocationTagsInput) SetType(v string) *ListCostAllocationTagsInput {
	s.Type = &v
	return s
}

type ListCostAllocationTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cost allocation tags that includes the detailed metadata for each
	// one.
	CostAllocationTags []*CostAllocationTag `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostAllocationTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostAllocationTagsOutput) GoString() string {
	return s.String()
}

// SetCostAllocationTags sets the CostAllocationTags field's value.
func (s *ListCostAllocationTagsOutput) SetCostAllocationTags(v []*CostAllocationTag) *ListCostAllocationTagsOutput {
	s.CostAllocationTags = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCostAllocationTagsOutput) SetNextToken(v string) *ListCostAllocationTagsOutput {
	s.NextToken = &v
	return s
}

type ListCostCategoryDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The date when the Cost Category was effective.
	EffectiveOn *string `min:"20" type:"string"`

	// The number of entries a paginated response contains.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostCategoryDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostCategoryDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCostCategoryDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCostCategoryDefinitionsInput"}
	if s.EffectiveOn != nil && len(*s.EffectiveOn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EffectiveOn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEffectiveOn sets the EffectiveOn field's value.
func (s *ListCostCategoryDefinitionsInput) SetEffectiveOn(v string) *ListCostCategoryDefinitionsInput {
	s.EffectiveOn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCostCategoryDefinitionsInput) SetMaxResults(v int64) *ListCostCategoryDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCostCategoryDefinitionsInput) SetNextToken(v string) *ListCostCategoryDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListCostCategoryDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// A reference to a Cost Category that contains enough information to identify
	// the Cost Category.
	CostCategoryReferences []*CostCategoryReference `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostCategoryDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCostCategoryDefinitionsOutput) GoString() string {
	return s.String()
}

// SetCostCategoryReferences sets the CostCategoryReferences field's value.
func (s *ListCostCategoryDefinitionsOutput) SetCostCategoryReferences(v []*CostCategoryReference) *ListCostCategoryDefinitionsOutput {
	s.CostCategoryReferences = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCostCategoryDefinitionsOutput) SetNextToken(v string) *ListCostCategoryDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListSavingsPlansPurchaseRecommendationGenerationInput struct {
	_ struct{} `type:"structure"`

	// The status of the recommendation generation.
	GenerationStatus *string `type:"string" enum:"GenerationStatus"`

	// The token to retrieve the next set of results.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The IDs for each specific recommendation.
	RecommendationIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSavingsPlansPurchaseRecommendationGenerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSavingsPlansPurchaseRecommendationGenerationInput) GoString() string {
	return s.String()
}

// SetGenerationStatus sets the GenerationStatus field's value.
func (s *ListSavingsPlansPurchaseRecommendationGenerationInput) SetGenerationStatus(v string) *ListSavingsPlansPurchaseRecommendationGenerationInput {
	s.GenerationStatus = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListSavingsPlansPurchaseRecommendationGenerationInput) SetNextPageToken(v string) *ListSavingsPlansPurchaseRecommendationGenerationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListSavingsPlansPurchaseRecommendationGenerationInput) SetPageSize(v int64) *ListSavingsPlansPurchaseRecommendationGenerationInput {
	s.PageSize = &v
	return s
}

// SetRecommendationIds sets the RecommendationIds field's value.
func (s *ListSavingsPlansPurchaseRecommendationGenerationInput) SetRecommendationIds(v []*string) *ListSavingsPlansPurchaseRecommendationGenerationInput {
	s.RecommendationIds = v
	return s
}

type ListSavingsPlansPurchaseRecommendationGenerationOutput struct {
	_ struct{} `type:"structure"`

	// The list of historical recommendation generations.
	GenerationSummaryList []*GenerationSummary `type:"list"`

	// The token to retrieve the next set of results.
	NextPageToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSavingsPlansPurchaseRecommendationGenerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSavingsPlansPurchaseRecommendationGenerationOutput) GoString() string {
	return s.String()
}

// SetGenerationSummaryList sets the GenerationSummaryList field's value.
func (s *ListSavingsPlansPurchaseRecommendationGenerationOutput) SetGenerationSummaryList(v []*GenerationSummary) *ListSavingsPlansPurchaseRecommendationGenerationOutput {
	s.GenerationSummaryList = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListSavingsPlansPurchaseRecommendationGenerationOutput) SetNextPageToken(v string) *ListSavingsPlansPurchaseRecommendationGenerationOutput {
	s.NextPageToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. For a list of supported resources,
	// see ResourceTag (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tag key value pairs that are associated with the resource.
	ResourceTags []*ResourceTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ListTagsForResourceOutput) SetResourceTags(v []*ResourceTag) *ListTagsForResourceOutput {
	s.ResourceTags = v
	return s
}

// Details about the MemoryDB reservations that Amazon Web Services recommends
// that you purchase.
type MemoryDBInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The node type of the recommended reservation.
	NodeType *string `type:"string"`

	// The Amazon Web Services Region of the recommended reservation.
	Region *string `type:"string"`

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryDBInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryDBInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *MemoryDBInstanceDetails) SetCurrentGeneration(v bool) *MemoryDBInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *MemoryDBInstanceDetails) SetFamily(v string) *MemoryDBInstanceDetails {
	s.Family = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *MemoryDBInstanceDetails) SetNodeType(v string) *MemoryDBInstanceDetails {
	s.NodeType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *MemoryDBInstanceDetails) SetRegion(v string) *MemoryDBInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *MemoryDBInstanceDetails) SetSizeFlexEligible(v bool) *MemoryDBInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// The aggregated value for a metric.
type MetricValue struct {
	_ struct{} `type:"structure"`

	// The actual number that represents the metric.
	Amount *string `type:"string"`

	// The unit that the metric is given in.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricValue) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *MetricValue) SetAmount(v string) *MetricValue {
	s.Amount = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricValue) SetUnit(v string) *MetricValue {
	s.Unit = &v
	return s
}

// Details for the modification recommendation.
type ModifyRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// Determines whether this instance type is the Amazon Web Services default
	// recommendation.
	TargetInstances []*TargetInstance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyRecommendationDetail) GoString() string {
	return s.String()
}

// SetTargetInstances sets the TargetInstances field's value.
func (s *ModifyRecommendationDetail) SetTargetInstances(v []*TargetInstance) *ModifyRecommendationDetail {
	s.TargetInstances = v
	return s
}

// The network field that contains a list of network metrics that are associated
// with the current instance.
type NetworkResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The network inbound throughput utilization measured in Bytes per second (Bps).
	NetworkInBytesPerSecond *string `type:"string"`

	// The network outbound throughput utilization measured in Bytes per second
	// (Bps).
	NetworkOutBytesPerSecond *string `type:"string"`

	// The network inbound packets that are measured in packets per second.
	NetworkPacketsInPerSecond *string `type:"string"`

	// The network outbound packets that are measured in packets per second.
	NetworkPacketsOutPerSecond *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkResourceUtilization) GoString() string {
	return s.String()
}

// SetNetworkInBytesPerSecond sets the NetworkInBytesPerSecond field's value.
func (s *NetworkResourceUtilization) SetNetworkInBytesPerSecond(v string) *NetworkResourceUtilization {
	s.NetworkInBytesPerSecond = &v
	return s
}

// SetNetworkOutBytesPerSecond sets the NetworkOutBytesPerSecond field's value.
func (s *NetworkResourceUtilization) SetNetworkOutBytesPerSecond(v string) *NetworkResourceUtilization {
	s.NetworkOutBytesPerSecond = &v
	return s
}

// SetNetworkPacketsInPerSecond sets the NetworkPacketsInPerSecond field's value.
func (s *NetworkResourceUtilization) SetNetworkPacketsInPerSecond(v string) *NetworkResourceUtilization {
	s.NetworkPacketsInPerSecond = &v
	return s
}

// SetNetworkPacketsOutPerSecond sets the NetworkPacketsOutPerSecond field's value.
func (s *NetworkResourceUtilization) SetNetworkPacketsOutPerSecond(v string) *NetworkResourceUtilization {
	s.NetworkPacketsOutPerSecond = &v
	return s
}

type ProvideAnomalyFeedbackInput struct {
	_ struct{} `type:"structure"`

	// A cost anomaly ID.
	//
	// AnomalyId is a required field
	AnomalyId *string `type:"string" required:"true"`

	// Describes whether the cost anomaly was a planned activity or you considered
	// it an anomaly.
	//
	// Feedback is a required field
	Feedback *string `type:"string" required:"true" enum:"AnomalyFeedbackType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvideAnomalyFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvideAnomalyFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvideAnomalyFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvideAnomalyFeedbackInput"}
	if s.AnomalyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyId"))
	}
	if s.Feedback == nil {
		invalidParams.Add(request.NewErrParamRequired("Feedback"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyId sets the AnomalyId field's value.
func (s *ProvideAnomalyFeedbackInput) SetAnomalyId(v string) *ProvideAnomalyFeedbackInput {
	s.AnomalyId = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *ProvideAnomalyFeedbackInput) SetFeedback(v string) *ProvideAnomalyFeedbackInput {
	s.Feedback = &v
	return s
}

type ProvideAnomalyFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the modified cost anomaly.
	//
	// AnomalyId is a required field
	AnomalyId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvideAnomalyFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvideAnomalyFeedbackOutput) GoString() string {
	return s.String()
}

// SetAnomalyId sets the AnomalyId field's value.
func (s *ProvideAnomalyFeedbackOutput) SetAnomalyId(v string) *ProvideAnomalyFeedbackOutput {
	s.AnomalyId = &v
	return s
}

// Details about the Amazon RDS reservations that Amazon Web Services recommends
// that you purchase.
type RDSInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string `type:"string"`

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string `type:"string"`

	// Determines whether the recommendation is for a reservation in a single Availability
	// Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string `type:"string"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string `type:"string"`

	// The license model that the recommended reservation supports.
	LicenseModel *string `type:"string"`

	// The Amazon Web Services Region of the recommended reservation.
	Region *string `type:"string"`

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDSInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RDSInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *RDSInstanceDetails) SetCurrentGeneration(v bool) *RDSInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetDatabaseEdition sets the DatabaseEdition field's value.
func (s *RDSInstanceDetails) SetDatabaseEdition(v string) *RDSInstanceDetails {
	s.DatabaseEdition = &v
	return s
}

// SetDatabaseEngine sets the DatabaseEngine field's value.
func (s *RDSInstanceDetails) SetDatabaseEngine(v string) *RDSInstanceDetails {
	s.DatabaseEngine = &v
	return s
}

// SetDeploymentOption sets the DeploymentOption field's value.
func (s *RDSInstanceDetails) SetDeploymentOption(v string) *RDSInstanceDetails {
	s.DeploymentOption = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *RDSInstanceDetails) SetFamily(v string) *RDSInstanceDetails {
	s.Family = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *RDSInstanceDetails) SetInstanceType(v string) *RDSInstanceDetails {
	s.InstanceType = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *RDSInstanceDetails) SetLicenseModel(v string) *RDSInstanceDetails {
	s.LicenseModel = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RDSInstanceDetails) SetRegion(v string) *RDSInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *RDSInstanceDetails) SetSizeFlexEligible(v bool) *RDSInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// The details and metrics for the given recommendation.
type RecommendationDetailData struct {
	_ struct{} `type:"structure"`

	// The AccountID that the recommendation is generated for.
	AccountId *string `type:"string"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER. If the value is LINKED, recommendations are
	// calculated for individual member accounts only.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// The currency code that Amazon Web Services used to generate the recommendation
	// and present potential savings.
	CurrencyCode *string `type:"string"`

	// The average value of hourly coverage over the lookback period.
	CurrentAverageCoverage *string `type:"string"`

	// The average value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentAverageHourlyOnDemandSpend *string `type:"string"`

	// The highest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMaximumHourlyOnDemandSpend *string `type:"string"`

	// The lowest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMinimumHourlyOnDemandSpend *string `type:"string"`

	// The estimated coverage of the recommended Savings Plan.
	EstimatedAverageCoverage *string `type:"string"`

	// The estimated utilization of the recommended Savings Plan.
	EstimatedAverageUtilization *string `type:"string"`

	// The estimated monthly savings amount based on the recommended Savings Plan.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// Savings Plan, over the length of the lookback period.
	EstimatedOnDemandCost *string `type:"string"`

	// The estimated On-Demand costs you expect with no additional commitment, based
	// on your usage of the selected time period and the Savings Plan you own.
	EstimatedOnDemandCostWithCurrentCommitment *string `type:"string"`

	// The estimated return on investment that's based on the recommended Savings
	// Plan that you purchased. This is calculated as estimatedSavingsAmount/estimatedSPCost*100.
	EstimatedROI *string `type:"string"`

	// The cost of the recommended Savings Plan over the length of the lookback
	// period.
	EstimatedSPCost *string `type:"string"`

	// The estimated savings amount that's based on the recommended Savings Plan
	// over the length of the lookback period.
	EstimatedSavingsAmount *string `type:"string"`

	// The estimated savings percentage relative to the total cost of applicable
	// On-Demand usage over the lookback period.
	EstimatedSavingsPercentage *string `type:"string"`

	// The existing hourly commitment for the Savings Plan type.
	ExistingHourlyCommitment *string `type:"string"`

	// The period of time that you want the usage and costs for.
	GenerationTimestamp *string `min:"20" type:"string"`

	// The recommended hourly commitment level for the Savings Plan type and the
	// configuration that's based on the usage during the lookback period.
	HourlyCommitmentToPurchase *string `type:"string"`

	// The instance family of the recommended Savings Plan.
	InstanceFamily *string `type:"string"`

	// The period of time that you want the usage and costs for.
	LatestUsageTimestamp *string `min:"20" type:"string"`

	// How many days of previous usage that Amazon Web Services considers when making
	// this recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The related hourly cost, coverage, and utilization metrics over the lookback
	// period.
	MetricsOverLookbackPeriod []*RecommendationDetailHourlyMetrics `type:"list"`

	// The unique ID that's used to distinguish Savings Plans from one another.
	OfferingId *string `type:"string"`

	// The payment option for the commitment (for example, All Upfront or No Upfront).
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// The region the recommendation is generated for.
	Region *string `type:"string"`

	// The requested Savings Plan recommendation type.
	SavingsPlansType *string `type:"string" enum:"SupportedSavingsPlansType"`

	// The term of the commitment in years.
	TermInYears *string `type:"string" enum:"TermInYears"`

	// The upfront cost of the recommended Savings Plan, based on the selected payment
	// option.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationDetailData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationDetailData) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RecommendationDetailData) SetAccountId(v string) *RecommendationDetailData {
	s.AccountId = &v
	return s
}

// SetAccountScope sets the AccountScope field's value.
func (s *RecommendationDetailData) SetAccountScope(v string) *RecommendationDetailData {
	s.AccountScope = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *RecommendationDetailData) SetCurrencyCode(v string) *RecommendationDetailData {
	s.CurrencyCode = &v
	return s
}

// SetCurrentAverageCoverage sets the CurrentAverageCoverage field's value.
func (s *RecommendationDetailData) SetCurrentAverageCoverage(v string) *RecommendationDetailData {
	s.CurrentAverageCoverage = &v
	return s
}

// SetCurrentAverageHourlyOnDemandSpend sets the CurrentAverageHourlyOnDemandSpend field's value.
func (s *RecommendationDetailData) SetCurrentAverageHourlyOnDemandSpend(v string) *RecommendationDetailData {
	s.CurrentAverageHourlyOnDemandSpend = &v
	return s
}

// SetCurrentMaximumHourlyOnDemandSpend sets the CurrentMaximumHourlyOnDemandSpend field's value.
func (s *RecommendationDetailData) SetCurrentMaximumHourlyOnDemandSpend(v string) *RecommendationDetailData {
	s.CurrentMaximumHourlyOnDemandSpend = &v
	return s
}

// SetCurrentMinimumHourlyOnDemandSpend sets the CurrentMinimumHourlyOnDemandSpend field's value.
func (s *RecommendationDetailData) SetCurrentMinimumHourlyOnDemandSpend(v string) *RecommendationDetailData {
	s.CurrentMinimumHourlyOnDemandSpend = &v
	return s
}

// SetEstimatedAverageCoverage sets the EstimatedAverageCoverage field's value.
func (s *RecommendationDetailData) SetEstimatedAverageCoverage(v string) *RecommendationDetailData {
	s.EstimatedAverageCoverage = &v
	return s
}

// SetEstimatedAverageUtilization sets the EstimatedAverageUtilization field's value.
func (s *RecommendationDetailData) SetEstimatedAverageUtilization(v string) *RecommendationDetailData {
	s.EstimatedAverageUtilization = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *RecommendationDetailData) SetEstimatedMonthlySavingsAmount(v string) *RecommendationDetailData {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedOnDemandCost sets the EstimatedOnDemandCost field's value.
func (s *RecommendationDetailData) SetEstimatedOnDemandCost(v string) *RecommendationDetailData {
	s.EstimatedOnDemandCost = &v
	return s
}

// SetEstimatedOnDemandCostWithCurrentCommitment sets the EstimatedOnDemandCostWithCurrentCommitment field's value.
func (s *RecommendationDetailData) SetEstimatedOnDemandCostWithCurrentCommitment(v string) *RecommendationDetailData {
	s.EstimatedOnDemandCostWithCurrentCommitment = &v
	return s
}

// SetEstimatedROI sets the EstimatedROI field's value.
func (s *RecommendationDetailData) SetEstimatedROI(v string) *RecommendationDetailData {
	s.EstimatedROI = &v
	return s
}

// SetEstimatedSPCost sets the EstimatedSPCost field's value.
func (s *RecommendationDetailData) SetEstimatedSPCost(v string) *RecommendationDetailData {
	s.EstimatedSPCost = &v
	return s
}

// SetEstimatedSavingsAmount sets the EstimatedSavingsAmount field's value.
func (s *RecommendationDetailData) SetEstimatedSavingsAmount(v string) *RecommendationDetailData {
	s.EstimatedSavingsAmount = &v
	return s
}

// SetEstimatedSavingsPercentage sets the EstimatedSavingsPercentage field's value.
func (s *RecommendationDetailData) SetEstimatedSavingsPercentage(v string) *RecommendationDetailData {
	s.EstimatedSavingsPercentage = &v
	return s
}

// SetExistingHourlyCommitment sets the ExistingHourlyCommitment field's value.
func (s *RecommendationDetailData) SetExistingHourlyCommitment(v string) *RecommendationDetailData {
	s.ExistingHourlyCommitment = &v
	return s
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *RecommendationDetailData) SetGenerationTimestamp(v string) *RecommendationDetailData {
	s.GenerationTimestamp = &v
	return s
}

// SetHourlyCommitmentToPurchase sets the HourlyCommitmentToPurchase field's value.
func (s *RecommendationDetailData) SetHourlyCommitmentToPurchase(v string) *RecommendationDetailData {
	s.HourlyCommitmentToPurchase = &v
	return s
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *RecommendationDetailData) SetInstanceFamily(v string) *RecommendationDetailData {
	s.InstanceFamily = &v
	return s
}

// SetLatestUsageTimestamp sets the LatestUsageTimestamp field's value.
func (s *RecommendationDetailData) SetLatestUsageTimestamp(v string) *RecommendationDetailData {
	s.LatestUsageTimestamp = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *RecommendationDetailData) SetLookbackPeriodInDays(v string) *RecommendationDetailData {
	s.LookbackPeriodInDays = &v
	return s
}

// SetMetricsOverLookbackPeriod sets the MetricsOverLookbackPeriod field's value.
func (s *RecommendationDetailData) SetMetricsOverLookbackPeriod(v []*RecommendationDetailHourlyMetrics) *RecommendationDetailData {
	s.MetricsOverLookbackPeriod = v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *RecommendationDetailData) SetOfferingId(v string) *RecommendationDetailData {
	s.OfferingId = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *RecommendationDetailData) SetPaymentOption(v string) *RecommendationDetailData {
	s.PaymentOption = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RecommendationDetailData) SetRegion(v string) *RecommendationDetailData {
	s.Region = &v
	return s
}

// SetSavingsPlansType sets the SavingsPlansType field's value.
func (s *RecommendationDetailData) SetSavingsPlansType(v string) *RecommendationDetailData {
	s.SavingsPlansType = &v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *RecommendationDetailData) SetTermInYears(v string) *RecommendationDetailData {
	s.TermInYears = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *RecommendationDetailData) SetUpfrontCost(v string) *RecommendationDetailData {
	s.UpfrontCost = &v
	return s
}

// Contains the hourly metrics for the given recommendation over the lookback
// period.
type RecommendationDetailHourlyMetrics struct {
	_ struct{} `type:"structure"`

	// The current amount of Savings Plans eligible usage that the Savings Plan
	// covered.
	CurrentCoverage *string `type:"string"`

	// The estimated coverage amount based on the recommended Savings Plan.
	EstimatedCoverage *string `type:"string"`

	// The estimated utilization for the recommended Savings Plan.
	EstimatedNewCommitmentUtilization *string `type:"string"`

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// Savings Plan, over the length of the lookback period.
	EstimatedOnDemandCost *string `type:"string"`

	// The period of time that you want the usage and costs for.
	StartTime *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationDetailHourlyMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationDetailHourlyMetrics) GoString() string {
	return s.String()
}

// SetCurrentCoverage sets the CurrentCoverage field's value.
func (s *RecommendationDetailHourlyMetrics) SetCurrentCoverage(v string) *RecommendationDetailHourlyMetrics {
	s.CurrentCoverage = &v
	return s
}

// SetEstimatedCoverage sets the EstimatedCoverage field's value.
func (s *RecommendationDetailHourlyMetrics) SetEstimatedCoverage(v string) *RecommendationDetailHourlyMetrics {
	s.EstimatedCoverage = &v
	return s
}

// SetEstimatedNewCommitmentUtilization sets the EstimatedNewCommitmentUtilization field's value.
func (s *RecommendationDetailHourlyMetrics) SetEstimatedNewCommitmentUtilization(v string) *RecommendationDetailHourlyMetrics {
	s.EstimatedNewCommitmentUtilization = &v
	return s
}

// SetEstimatedOnDemandCost sets the EstimatedOnDemandCost field's value.
func (s *RecommendationDetailHourlyMetrics) SetEstimatedOnDemandCost(v string) *RecommendationDetailHourlyMetrics {
	s.EstimatedOnDemandCost = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RecommendationDetailHourlyMetrics) SetStartTime(v string) *RecommendationDetailHourlyMetrics {
	s.StartTime = &v
	return s
}

// Details about the Amazon Redshift reservations that Amazon Web Services recommends
// that you purchase.
type RedshiftInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that Amazon Web Services recommends.
	NodeType *string `type:"string"`

	// The Amazon Web Services Region of the recommended reservation.
	Region *string `type:"string"`

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *RedshiftInstanceDetails) SetCurrentGeneration(v bool) *RedshiftInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *RedshiftInstanceDetails) SetFamily(v string) *RedshiftInstanceDetails {
	s.Family = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *RedshiftInstanceDetails) SetNodeType(v string) *RedshiftInstanceDetails {
	s.NodeType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RedshiftInstanceDetails) SetRegion(v string) *RedshiftInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *RedshiftInstanceDetails) SetSizeFlexEligible(v bool) *RedshiftInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// Your request parameters changed between pages. Try again with the old parameters
// or without a pagination token.
type RequestChangedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestChangedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestChangedException) GoString() string {
	return s.String()
}

func newErrorRequestChangedException(v protocol.ResponseMetadata) error {
	return &RequestChangedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestChangedException) Code() string {
	return "RequestChangedException"
}

// Message returns the exception's message.
func (s *RequestChangedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestChangedException) OrigErr() error {
	return nil
}

func (s *RequestChangedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestChangedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestChangedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The aggregated numbers for your reservation usage.
type ReservationAggregates struct {
	_ struct{} `type:"structure"`

	// The monthly cost of your reservation. It's amortized over the reservation
	// period.
	AmortizedRecurringFee *string `type:"string"`

	// The upfront cost of your reservation. It's amortized over the reservation
	// period.
	AmortizedUpfrontFee *string `type:"string"`

	// How much you saved due to purchasing and utilizing reservation. Amazon Web
	// Services calculates this by subtracting TotalAmortizedFee from OnDemandCostOfRIHoursUsed.
	NetRISavings *string `type:"string"`

	// How much your reservation costs if charged On-Demand rates.
	OnDemandCostOfRIHoursUsed *string `type:"string"`

	// How many reservation hours that you purchased.
	PurchasedHours *string `type:"string"`

	// The number of Amazon EC2 reservation hours that you purchased. It's converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	PurchasedUnits *string `type:"string"`

	// The cost of unused hours for your reservation.
	RICostForUnusedHours *string `type:"string"`

	// The realized savings because of purchasing and using a reservation.
	RealizedSavings *string `type:"string"`

	// The total number of reservation hours that you used.
	TotalActualHours *string `type:"string"`

	// The total number of Amazon EC2 reservation hours that you used. It's converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	TotalActualUnits *string `type:"string"`

	// The total cost of your reservation. It's amortized over the reservation period.
	TotalAmortizedFee *string `type:"string"`

	// How much you might save if you use your entire reservation.
	TotalPotentialRISavings *string `type:"string"`

	// The unrealized savings because of purchasing and using a reservation.
	UnrealizedSavings *string `type:"string"`

	// The number of reservation hours that you didn't use.
	UnusedHours *string `type:"string"`

	// The number of Amazon EC2 reservation hours that you didn't use. It's converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UnusedUnits *string `type:"string"`

	// The percentage of reservation time that you used.
	UtilizationPercentage *string `type:"string"`

	// The percentage of Amazon EC2 reservation time that you used. It's converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UtilizationPercentageInUnits *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationAggregates) GoString() string {
	return s.String()
}

// SetAmortizedRecurringFee sets the AmortizedRecurringFee field's value.
func (s *ReservationAggregates) SetAmortizedRecurringFee(v string) *ReservationAggregates {
	s.AmortizedRecurringFee = &v
	return s
}

// SetAmortizedUpfrontFee sets the AmortizedUpfrontFee field's value.
func (s *ReservationAggregates) SetAmortizedUpfrontFee(v string) *ReservationAggregates {
	s.AmortizedUpfrontFee = &v
	return s
}

// SetNetRISavings sets the NetRISavings field's value.
func (s *ReservationAggregates) SetNetRISavings(v string) *ReservationAggregates {
	s.NetRISavings = &v
	return s
}

// SetOnDemandCostOfRIHoursUsed sets the OnDemandCostOfRIHoursUsed field's value.
func (s *ReservationAggregates) SetOnDemandCostOfRIHoursUsed(v string) *ReservationAggregates {
	s.OnDemandCostOfRIHoursUsed = &v
	return s
}

// SetPurchasedHours sets the PurchasedHours field's value.
func (s *ReservationAggregates) SetPurchasedHours(v string) *ReservationAggregates {
	s.PurchasedHours = &v
	return s
}

// SetPurchasedUnits sets the PurchasedUnits field's value.
func (s *ReservationAggregates) SetPurchasedUnits(v string) *ReservationAggregates {
	s.PurchasedUnits = &v
	return s
}

// SetRICostForUnusedHours sets the RICostForUnusedHours field's value.
func (s *ReservationAggregates) SetRICostForUnusedHours(v string) *ReservationAggregates {
	s.RICostForUnusedHours = &v
	return s
}

// SetRealizedSavings sets the RealizedSavings field's value.
func (s *ReservationAggregates) SetRealizedSavings(v string) *ReservationAggregates {
	s.RealizedSavings = &v
	return s
}

// SetTotalActualHours sets the TotalActualHours field's value.
func (s *ReservationAggregates) SetTotalActualHours(v string) *ReservationAggregates {
	s.TotalActualHours = &v
	return s
}

// SetTotalActualUnits sets the TotalActualUnits field's value.
func (s *ReservationAggregates) SetTotalActualUnits(v string) *ReservationAggregates {
	s.TotalActualUnits = &v
	return s
}

// SetTotalAmortizedFee sets the TotalAmortizedFee field's value.
func (s *ReservationAggregates) SetTotalAmortizedFee(v string) *ReservationAggregates {
	s.TotalAmortizedFee = &v
	return s
}

// SetTotalPotentialRISavings sets the TotalPotentialRISavings field's value.
func (s *ReservationAggregates) SetTotalPotentialRISavings(v string) *ReservationAggregates {
	s.TotalPotentialRISavings = &v
	return s
}

// SetUnrealizedSavings sets the UnrealizedSavings field's value.
func (s *ReservationAggregates) SetUnrealizedSavings(v string) *ReservationAggregates {
	s.UnrealizedSavings = &v
	return s
}

// SetUnusedHours sets the UnusedHours field's value.
func (s *ReservationAggregates) SetUnusedHours(v string) *ReservationAggregates {
	s.UnusedHours = &v
	return s
}

// SetUnusedUnits sets the UnusedUnits field's value.
func (s *ReservationAggregates) SetUnusedUnits(v string) *ReservationAggregates {
	s.UnusedUnits = &v
	return s
}

// SetUtilizationPercentage sets the UtilizationPercentage field's value.
func (s *ReservationAggregates) SetUtilizationPercentage(v string) *ReservationAggregates {
	s.UtilizationPercentage = &v
	return s
}

// SetUtilizationPercentageInUnits sets the UtilizationPercentageInUnits field's value.
func (s *ReservationAggregates) SetUtilizationPercentageInUnits(v string) *ReservationAggregates {
	s.UtilizationPercentageInUnits = &v
	return s
}

// A group of reservations that share a set of attributes.
type ReservationCoverageGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]*string `type:"map"`

	// How much instance usage this group of reservations covered.
	Coverage *Coverage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationCoverageGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationCoverageGroup) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ReservationCoverageGroup) SetAttributes(v map[string]*string) *ReservationCoverageGroup {
	s.Attributes = v
	return s
}

// SetCoverage sets the Coverage field's value.
func (s *ReservationCoverageGroup) SetCoverage(v *Coverage) *ReservationCoverageGroup {
	s.Coverage = v
	return s
}

// A specific reservation that Amazon Web Services recommends for purchase.
type ReservationPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The account scope that Amazon Web Services recommends that you purchase this
	// instance for. For example, you can purchase this reservation for an entire
	// organization in Amazon Web Services Organizations.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// How many days of previous usage that Amazon Web Services considers when making
	// this recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The payment option for the reservation (for example, AllUpfront or NoUpfront).
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// Details about the recommended purchases.
	RecommendationDetails []*ReservationPurchaseRecommendationDetail `type:"list"`

	// A summary about the recommended purchase.
	RecommendationSummary *ReservationPurchaseRecommendationSummary `type:"structure"`

	// Hardware specifications for the service that you want recommendations for.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The term of the reservation that you want recommendations for, in years.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendation) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *ReservationPurchaseRecommendation) SetAccountScope(v string) *ReservationPurchaseRecommendation {
	s.AccountScope = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *ReservationPurchaseRecommendation) SetLookbackPeriodInDays(v string) *ReservationPurchaseRecommendation {
	s.LookbackPeriodInDays = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservationPurchaseRecommendation) SetPaymentOption(v string) *ReservationPurchaseRecommendation {
	s.PaymentOption = &v
	return s
}

// SetRecommendationDetails sets the RecommendationDetails field's value.
func (s *ReservationPurchaseRecommendation) SetRecommendationDetails(v []*ReservationPurchaseRecommendationDetail) *ReservationPurchaseRecommendation {
	s.RecommendationDetails = v
	return s
}

// SetRecommendationSummary sets the RecommendationSummary field's value.
func (s *ReservationPurchaseRecommendation) SetRecommendationSummary(v *ReservationPurchaseRecommendationSummary) *ReservationPurchaseRecommendation {
	s.RecommendationSummary = v
	return s
}

// SetServiceSpecification sets the ServiceSpecification field's value.
func (s *ReservationPurchaseRecommendation) SetServiceSpecification(v *ServiceSpecification) *ReservationPurchaseRecommendation {
	s.ServiceSpecification = v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *ReservationPurchaseRecommendation) SetTermInYears(v string) *ReservationPurchaseRecommendation {
	s.TermInYears = &v
	return s
}

// Details about your recommended reservation purchase.
type ReservationPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The account that this Reserved Instance (RI) recommendation is for.
	AccountId *string `type:"string"`

	// The average number of normalized units that you used in an hour during the
	// historical period. Amazon Web Services uses this to calculate your recommended
	// reservation purchases.
	AverageNormalizedUnitsUsedPerHour *string `type:"string"`

	// The average number of instances that you used in an hour during the historical
	// period. Amazon Web Services uses this to calculate your recommended reservation
	// purchases.
	AverageNumberOfInstancesUsedPerHour *string `type:"string"`

	// The average utilization of your instances. Amazon Web Services uses this
	// to calculate your recommended reservation purchases.
	AverageUtilization *string `type:"string"`

	// The currency code that Amazon Web Services used to calculate the costs for
	// this instance.
	CurrencyCode *string `type:"string"`

	// How long Amazon Web Services estimates that it takes for this instance to
	// start saving you money, in months.
	EstimatedBreakEvenInMonths *string `type:"string"`

	// How much Amazon Web Services estimates that you spend on On-Demand Instances
	// in a month.
	EstimatedMonthlyOnDemandCost *string `type:"string"`

	// How much Amazon Web Services estimates that this specific recommendation
	// might save you in a month.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// How much Amazon Web Services estimates that this specific recommendation
	// might save you in a month, as a percentage of your overall costs.
	EstimatedMonthlySavingsPercentage *string `type:"string"`

	// How much Amazon Web Services estimates that you might spend for all usage
	// during the specified historical period if you had a reservation.
	EstimatedReservationCostForLookbackPeriod *string `type:"string"`

	// Details about the reservations that Amazon Web Services recommends that you
	// purchase.
	InstanceDetails *InstanceDetails `type:"structure"`

	// The maximum number of normalized units that you used in an hour during the
	// historical period. Amazon Web Services uses this to calculate your recommended
	// reservation purchases.
	MaximumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The maximum number of instances that you used in an hour during the historical
	// period. Amazon Web Services uses this to calculate your recommended reservation
	// purchases.
	MaximumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The minimum number of normalized units that you used in an hour during the
	// historical period. Amazon Web Services uses this to calculate your recommended
	// reservation purchases.
	MinimumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The minimum number of instances that you used in an hour during the historical
	// period. Amazon Web Services uses this to calculate your recommended reservation
	// purchases.
	MinimumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	RecommendedNormalizedUnitsToPurchase *string `type:"string"`

	// The number of instances that Amazon Web Services recommends that you purchase.
	RecommendedNumberOfInstancesToPurchase *string `type:"string"`

	// How much purchasing this instance costs you on a monthly basis.
	RecurringStandardMonthlyCost *string `type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendationDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAccountId(v string) *ReservationPurchaseRecommendationDetail {
	s.AccountId = &v
	return s
}

// SetAverageNormalizedUnitsUsedPerHour sets the AverageNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageNormalizedUnitsUsedPerHour = &v
	return s
}

// SetAverageNumberOfInstancesUsedPerHour sets the AverageNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageNumberOfInstancesUsedPerHour = &v
	return s
}

// SetAverageUtilization sets the AverageUtilization field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageUtilization(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageUtilization = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservationPurchaseRecommendationDetail) SetCurrencyCode(v string) *ReservationPurchaseRecommendationDetail {
	s.CurrencyCode = &v
	return s
}

// SetEstimatedBreakEvenInMonths sets the EstimatedBreakEvenInMonths field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedBreakEvenInMonths(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedBreakEvenInMonths = &v
	return s
}

// SetEstimatedMonthlyOnDemandCost sets the EstimatedMonthlyOnDemandCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlyOnDemandCost(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlyOnDemandCost = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlySavingsAmount(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedMonthlySavingsPercentage sets the EstimatedMonthlySavingsPercentage field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlySavingsPercentage(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsPercentage = &v
	return s
}

// SetEstimatedReservationCostForLookbackPeriod sets the EstimatedReservationCostForLookbackPeriod field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedReservationCostForLookbackPeriod(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedReservationCostForLookbackPeriod = &v
	return s
}

// SetInstanceDetails sets the InstanceDetails field's value.
func (s *ReservationPurchaseRecommendationDetail) SetInstanceDetails(v *InstanceDetails) *ReservationPurchaseRecommendationDetail {
	s.InstanceDetails = v
	return s
}

// SetMaximumNormalizedUnitsUsedPerHour sets the MaximumNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMaximumNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MaximumNormalizedUnitsUsedPerHour = &v
	return s
}

// SetMaximumNumberOfInstancesUsedPerHour sets the MaximumNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMaximumNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MaximumNumberOfInstancesUsedPerHour = &v
	return s
}

// SetMinimumNormalizedUnitsUsedPerHour sets the MinimumNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMinimumNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MinimumNormalizedUnitsUsedPerHour = &v
	return s
}

// SetMinimumNumberOfInstancesUsedPerHour sets the MinimumNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMinimumNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MinimumNumberOfInstancesUsedPerHour = &v
	return s
}

// SetRecommendedNormalizedUnitsToPurchase sets the RecommendedNormalizedUnitsToPurchase field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecommendedNormalizedUnitsToPurchase(v string) *ReservationPurchaseRecommendationDetail {
	s.RecommendedNormalizedUnitsToPurchase = &v
	return s
}

// SetRecommendedNumberOfInstancesToPurchase sets the RecommendedNumberOfInstancesToPurchase field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecommendedNumberOfInstancesToPurchase(v string) *ReservationPurchaseRecommendationDetail {
	s.RecommendedNumberOfInstancesToPurchase = &v
	return s
}

// SetRecurringStandardMonthlyCost sets the RecurringStandardMonthlyCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecurringStandardMonthlyCost(v string) *ReservationPurchaseRecommendationDetail {
	s.RecurringStandardMonthlyCost = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetUpfrontCost(v string) *ReservationPurchaseRecommendationDetail {
	s.UpfrontCost = &v
	return s
}

// Information about this specific recommendation, such as the timestamp for
// when Amazon Web Services made a specific recommendation.
type ReservationPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// The timestamp for when Amazon Web Services made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendationMetadata) GoString() string {
	return s.String()
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *ReservationPurchaseRecommendationMetadata) SetGenerationTimestamp(v string) *ReservationPurchaseRecommendationMetadata {
	s.GenerationTimestamp = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *ReservationPurchaseRecommendationMetadata) SetRecommendationId(v string) *ReservationPurchaseRecommendationMetadata {
	s.RecommendationId = &v
	return s
}

// A summary about this recommendation, such as the currency code, the amount
// that Amazon Web Services estimates that you could save, and the total amount
// of reservation to purchase.
type ReservationPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code used for this recommendation.
	CurrencyCode *string `type:"string"`

	// The total amount that Amazon Web Services estimates that this recommendation
	// could save you in a month.
	TotalEstimatedMonthlySavingsAmount *string `type:"string"`

	// The total amount that Amazon Web Services estimates that this recommendation
	// could save you in a month, as a percentage of your costs.
	TotalEstimatedMonthlySavingsPercentage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationPurchaseRecommendationSummary) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservationPurchaseRecommendationSummary) SetCurrencyCode(v string) *ReservationPurchaseRecommendationSummary {
	s.CurrencyCode = &v
	return s
}

// SetTotalEstimatedMonthlySavingsAmount sets the TotalEstimatedMonthlySavingsAmount field's value.
func (s *ReservationPurchaseRecommendationSummary) SetTotalEstimatedMonthlySavingsAmount(v string) *ReservationPurchaseRecommendationSummary {
	s.TotalEstimatedMonthlySavingsAmount = &v
	return s
}

// SetTotalEstimatedMonthlySavingsPercentage sets the TotalEstimatedMonthlySavingsPercentage field's value.
func (s *ReservationPurchaseRecommendationSummary) SetTotalEstimatedMonthlySavingsPercentage(v string) *ReservationPurchaseRecommendationSummary {
	s.TotalEstimatedMonthlySavingsPercentage = &v
	return s
}

// A group of reservations that share a set of attributes.
type ReservationUtilizationGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]*string `type:"map"`

	// The key for a specific reservation attribute.
	Key *string `type:"string"`

	// How much you used this group of reservations.
	Utilization *ReservationAggregates `type:"structure"`

	// The value of a specific reservation attribute.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationUtilizationGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservationUtilizationGroup) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ReservationUtilizationGroup) SetAttributes(v map[string]*string) *ReservationUtilizationGroup {
	s.Attributes = v
	return s
}

// SetKey sets the Key field's value.
func (s *ReservationUtilizationGroup) SetKey(v string) *ReservationUtilizationGroup {
	s.Key = &v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *ReservationUtilizationGroup) SetUtilization(v *ReservationAggregates) *ReservationUtilizationGroup {
	s.Utilization = v
	return s
}

// SetValue sets the Value field's value.
func (s *ReservationUtilizationGroup) SetValue(v string) *ReservationUtilizationGroup {
	s.Value = &v
	return s
}

// Details for the resource.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// Details for the Amazon EC2 resource.
	EC2ResourceDetails *EC2ResourceDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) GoString() string {
	return s.String()
}

// SetEC2ResourceDetails sets the EC2ResourceDetails field's value.
func (s *ResourceDetails) SetEC2ResourceDetails(v *EC2ResourceDetails) *ResourceDetails {
	s.EC2ResourceDetails = v
	return s
}

// The specified ARN in the request doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The tag structure that contains a tag key and value.
//
// Tagging is supported only for the following Cost Explorer resource types:
// AnomalyMonitor (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalyMonitor.html),
// AnomalySubscription (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html),
// CostCategory (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html).
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The key that's associated with the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value that's associated with the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceTag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ResourceTag) SetKey(v string) *ResourceTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTag) SetValue(v string) *ResourceTag {
	s.Value = &v
	return s
}

// Resource utilization of current resource.
type ResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The utilization of current Amazon EC2 instance.
	EC2ResourceUtilization *EC2ResourceUtilization `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUtilization) GoString() string {
	return s.String()
}

// SetEC2ResourceUtilization sets the EC2ResourceUtilization field's value.
func (s *ResourceUtilization) SetEC2ResourceUtilization(v *EC2ResourceUtilization) *ResourceUtilization {
	s.EC2ResourceUtilization = v
	return s
}

// The result that's associated with a time period.
type ResultByTime struct {
	_ struct{} `type:"structure"`

	// Determines whether the result is estimated.
	Estimated *bool `type:"boolean"`

	// The groups that this time period includes.
	Groups []*Group `type:"list"`

	// The time period that the result covers.
	TimePeriod *DateInterval `type:"structure"`

	// The total amount of cost or usage accrued during the time period.
	Total map[string]*MetricValue `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultByTime) GoString() string {
	return s.String()
}

// SetEstimated sets the Estimated field's value.
func (s *ResultByTime) SetEstimated(v bool) *ResultByTime {
	s.Estimated = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *ResultByTime) SetGroups(v []*Group) *ResultByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *ResultByTime) SetTimePeriod(v *DateInterval) *ResultByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ResultByTime) SetTotal(v map[string]*MetricValue) *ResultByTime {
	s.Total = v
	return s
}

// Recommendations to rightsize resources.
type RightsizingRecommendation struct {
	_ struct{} `type:"structure"`

	// The account that this recommendation is for.
	AccountId *string `type:"string"`

	// Context regarding the current instance.
	CurrentInstance *CurrentInstance `type:"structure"`

	// The list of possible reasons why the recommendation is generated, such as
	// under- or over-utilization of specific metrics (for example, CPU, Memory,
	// Network).
	FindingReasonCodes []*string `type:"list" enum:"FindingReasonCode"`

	// The details for the modification recommendations.
	ModifyRecommendationDetail *ModifyRecommendationDetail `type:"structure"`

	// A recommendation to either terminate or modify the resource.
	RightsizingType *string `type:"string" enum:"RightsizingType"`

	// The details for termination recommendations.
	TerminateRecommendationDetail *TerminateRecommendationDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RightsizingRecommendation) SetAccountId(v string) *RightsizingRecommendation {
	s.AccountId = &v
	return s
}

// SetCurrentInstance sets the CurrentInstance field's value.
func (s *RightsizingRecommendation) SetCurrentInstance(v *CurrentInstance) *RightsizingRecommendation {
	s.CurrentInstance = v
	return s
}

// SetFindingReasonCodes sets the FindingReasonCodes field's value.
func (s *RightsizingRecommendation) SetFindingReasonCodes(v []*string) *RightsizingRecommendation {
	s.FindingReasonCodes = v
	return s
}

// SetModifyRecommendationDetail sets the ModifyRecommendationDetail field's value.
func (s *RightsizingRecommendation) SetModifyRecommendationDetail(v *ModifyRecommendationDetail) *RightsizingRecommendation {
	s.ModifyRecommendationDetail = v
	return s
}

// SetRightsizingType sets the RightsizingType field's value.
func (s *RightsizingRecommendation) SetRightsizingType(v string) *RightsizingRecommendation {
	s.RightsizingType = &v
	return s
}

// SetTerminateRecommendationDetail sets the TerminateRecommendationDetail field's value.
func (s *RightsizingRecommendation) SetTerminateRecommendationDetail(v *TerminateRecommendationDetail) *RightsizingRecommendation {
	s.TerminateRecommendationDetail = v
	return s
}

// You can use RightsizingRecommendationConfiguration to customize recommendations
// across two attributes. You can choose to view recommendations for instances
// within the same instance families or across different instance families.
// You can also choose to view your estimated savings that are associated with
// recommendations with consideration of existing Savings Plans or Reserved
// Instance (RI) benefits, or neither.
type RightsizingRecommendationConfiguration struct {
	_ struct{} `type:"structure"`

	// The option to consider RI or Savings Plans discount benefits in your savings
	// calculation. The default value is TRUE.
	//
	// BenefitsConsidered is a required field
	BenefitsConsidered *bool `type:"boolean" required:"true"`

	// The option to see recommendations within the same instance family or recommendations
	// for instances across other families. The default value is SAME_INSTANCE_FAMILY.
	//
	// RecommendationTarget is a required field
	RecommendationTarget *string `type:"string" required:"true" enum:"RecommendationTarget"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RightsizingRecommendationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RightsizingRecommendationConfiguration"}
	if s.BenefitsConsidered == nil {
		invalidParams.Add(request.NewErrParamRequired("BenefitsConsidered"))
	}
	if s.RecommendationTarget == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationTarget"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBenefitsConsidered sets the BenefitsConsidered field's value.
func (s *RightsizingRecommendationConfiguration) SetBenefitsConsidered(v bool) *RightsizingRecommendationConfiguration {
	s.BenefitsConsidered = &v
	return s
}

// SetRecommendationTarget sets the RecommendationTarget field's value.
func (s *RightsizingRecommendationConfiguration) SetRecommendationTarget(v string) *RightsizingRecommendationConfiguration {
	s.RecommendationTarget = &v
	return s
}

// Metadata for this recommendation set.
type RightsizingRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// Additional metadata that might be applicable to the recommendation.
	AdditionalMetadata *string `type:"string"`

	// The timestamp for when Amazon Web Services made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// The number of days of previous usage that Amazon Web Services considers when
	// making this recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendationMetadata) GoString() string {
	return s.String()
}

// SetAdditionalMetadata sets the AdditionalMetadata field's value.
func (s *RightsizingRecommendationMetadata) SetAdditionalMetadata(v string) *RightsizingRecommendationMetadata {
	s.AdditionalMetadata = &v
	return s
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *RightsizingRecommendationMetadata) SetGenerationTimestamp(v string) *RightsizingRecommendationMetadata {
	s.GenerationTimestamp = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *RightsizingRecommendationMetadata) SetLookbackPeriodInDays(v string) *RightsizingRecommendationMetadata {
	s.LookbackPeriodInDays = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *RightsizingRecommendationMetadata) SetRecommendationId(v string) *RightsizingRecommendationMetadata {
	s.RecommendationId = &v
	return s
}

// The summary of rightsizing recommendations
type RightsizingRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The estimated total savings resulting from modifications, on a monthly basis.
	EstimatedTotalMonthlySavingsAmount *string `type:"string"`

	// The currency code that Amazon Web Services used to calculate the savings.
	SavingsCurrencyCode *string `type:"string"`

	// The savings percentage based on the recommended modifications. It's relative
	// to the total On-Demand costs that are associated with these instances.
	SavingsPercentage *string `type:"string"`

	// The total number of instance recommendations.
	TotalRecommendationCount *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RightsizingRecommendationSummary) GoString() string {
	return s.String()
}

// SetEstimatedTotalMonthlySavingsAmount sets the EstimatedTotalMonthlySavingsAmount field's value.
func (s *RightsizingRecommendationSummary) SetEstimatedTotalMonthlySavingsAmount(v string) *RightsizingRecommendationSummary {
	s.EstimatedTotalMonthlySavingsAmount = &v
	return s
}

// SetSavingsCurrencyCode sets the SavingsCurrencyCode field's value.
func (s *RightsizingRecommendationSummary) SetSavingsCurrencyCode(v string) *RightsizingRecommendationSummary {
	s.SavingsCurrencyCode = &v
	return s
}

// SetSavingsPercentage sets the SavingsPercentage field's value.
func (s *RightsizingRecommendationSummary) SetSavingsPercentage(v string) *RightsizingRecommendationSummary {
	s.SavingsPercentage = &v
	return s
}

// SetTotalRecommendationCount sets the TotalRecommendationCount field's value.
func (s *RightsizingRecommendationSummary) SetTotalRecommendationCount(v string) *RightsizingRecommendationSummary {
	s.TotalRecommendationCount = &v
	return s
}

// The combination of Amazon Web Service, linked account, linked account name,
// Region, and usage type where a cost anomaly is observed. The linked account
// name will only be available when the account name can be identified.
type RootCause struct {
	_ struct{} `type:"structure"`

	// The member account value that's associated with the cost anomaly.
	LinkedAccount *string `type:"string"`

	// The member account name value that's associated with the cost anomaly.
	LinkedAccountName *string `type:"string"`

	// The Amazon Web Services Region that's associated with the cost anomaly.
	Region *string `type:"string"`

	// The Amazon Web Service name that's associated with the cost anomaly.
	Service *string `type:"string"`

	// The UsageType value that's associated with the cost anomaly.
	UsageType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootCause) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootCause) GoString() string {
	return s.String()
}

// SetLinkedAccount sets the LinkedAccount field's value.
func (s *RootCause) SetLinkedAccount(v string) *RootCause {
	s.LinkedAccount = &v
	return s
}

// SetLinkedAccountName sets the LinkedAccountName field's value.
func (s *RootCause) SetLinkedAccountName(v string) *RootCause {
	s.LinkedAccountName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RootCause) SetRegion(v string) *RootCause {
	s.Region = &v
	return s
}

// SetService sets the Service field's value.
func (s *RootCause) SetService(v string) *RootCause {
	s.Service = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *RootCause) SetUsageType(v string) *RootCause {
	s.UsageType = &v
	return s
}

// The amortized amount of Savings Plans purchased in a specific account during
// a specific time interval.
type SavingsPlansAmortizedCommitment struct {
	_ struct{} `type:"structure"`

	// The amortized amount of your Savings Plans commitment that was purchased
	// with either a Partial or a NoUpfront.
	AmortizedRecurringCommitment *string `type:"string"`

	// The amortized amount of your Savings Plans commitment that was purchased
	// with an Upfront or PartialUpfront Savings Plans.
	AmortizedUpfrontCommitment *string `type:"string"`

	// The total amortized amount of your Savings Plans commitment, regardless of
	// your Savings Plans purchase method.
	TotalAmortizedCommitment *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansAmortizedCommitment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansAmortizedCommitment) GoString() string {
	return s.String()
}

// SetAmortizedRecurringCommitment sets the AmortizedRecurringCommitment field's value.
func (s *SavingsPlansAmortizedCommitment) SetAmortizedRecurringCommitment(v string) *SavingsPlansAmortizedCommitment {
	s.AmortizedRecurringCommitment = &v
	return s
}

// SetAmortizedUpfrontCommitment sets the AmortizedUpfrontCommitment field's value.
func (s *SavingsPlansAmortizedCommitment) SetAmortizedUpfrontCommitment(v string) *SavingsPlansAmortizedCommitment {
	s.AmortizedUpfrontCommitment = &v
	return s
}

// SetTotalAmortizedCommitment sets the TotalAmortizedCommitment field's value.
func (s *SavingsPlansAmortizedCommitment) SetTotalAmortizedCommitment(v string) *SavingsPlansAmortizedCommitment {
	s.TotalAmortizedCommitment = &v
	return s
}

// The amount of Savings Plans eligible usage that's covered by Savings Plans.
// All calculations consider the On-Demand equivalent of your Savings Plans
// usage.
type SavingsPlansCoverage struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The amount of Savings Plans eligible usage that the Savings Plans covered.
	Coverage *SavingsPlansCoverageData `type:"structure"`

	// The time period of the request.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansCoverage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansCoverage) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *SavingsPlansCoverage) SetAttributes(v map[string]*string) *SavingsPlansCoverage {
	s.Attributes = v
	return s
}

// SetCoverage sets the Coverage field's value.
func (s *SavingsPlansCoverage) SetCoverage(v *SavingsPlansCoverageData) *SavingsPlansCoverage {
	s.Coverage = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *SavingsPlansCoverage) SetTimePeriod(v *DateInterval) *SavingsPlansCoverage {
	s.TimePeriod = v
	return s
}

// Specific coverage percentage, On-Demand costs, and spend covered by Savings
// Plans, and total Savings Plans costs for an account.
type SavingsPlansCoverageData struct {
	_ struct{} `type:"structure"`

	// The percentage of your existing Savings Plans covered usage, divided by all
	// of your eligible Savings Plans usage in an account (or set of accounts).
	CoveragePercentage *string `type:"string"`

	// The cost of your Amazon Web Services usage at the public On-Demand rate.
	OnDemandCost *string `type:"string"`

	// The amount of your Amazon Web Services usage that's covered by a Savings
	// Plans.
	SpendCoveredBySavingsPlans *string `type:"string"`

	// The total cost of your Amazon Web Services usage, regardless of your purchase
	// option.
	TotalCost *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansCoverageData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansCoverageData) GoString() string {
	return s.String()
}

// SetCoveragePercentage sets the CoveragePercentage field's value.
func (s *SavingsPlansCoverageData) SetCoveragePercentage(v string) *SavingsPlansCoverageData {
	s.CoveragePercentage = &v
	return s
}

// SetOnDemandCost sets the OnDemandCost field's value.
func (s *SavingsPlansCoverageData) SetOnDemandCost(v string) *SavingsPlansCoverageData {
	s.OnDemandCost = &v
	return s
}

// SetSpendCoveredBySavingsPlans sets the SpendCoveredBySavingsPlans field's value.
func (s *SavingsPlansCoverageData) SetSpendCoveredBySavingsPlans(v string) *SavingsPlansCoverageData {
	s.SpendCoveredBySavingsPlans = &v
	return s
}

// SetTotalCost sets the TotalCost field's value.
func (s *SavingsPlansCoverageData) SetTotalCost(v string) *SavingsPlansCoverageData {
	s.TotalCost = &v
	return s
}

// The attribute details on a specific Savings Plan.
type SavingsPlansDetails struct {
	_ struct{} `type:"structure"`

	// A group of instance types that Savings Plans applies to.
	InstanceFamily *string `type:"string"`

	// The unique ID that's used to distinguish Savings Plans from one another.
	OfferingId *string `type:"string"`

	// A collection of Amazon Web Services resources in a geographic area. Each
	// Amazon Web Services Region is isolated and independent of the other Regions.
	Region *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansDetails) GoString() string {
	return s.String()
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *SavingsPlansDetails) SetInstanceFamily(v string) *SavingsPlansDetails {
	s.InstanceFamily = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *SavingsPlansDetails) SetOfferingId(v string) *SavingsPlansDetails {
	s.OfferingId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *SavingsPlansDetails) SetRegion(v string) *SavingsPlansDetails {
	s.Region = &v
	return s
}

// Contains your request parameters, Savings Plan Recommendations Summary, and
// Details.
type SavingsPlansPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations that include the management account and member
	// accounts if the value is set to PAYER. If the value is LINKED, recommendations
	// are calculated for individual member accounts only.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// The lookback period in days that's used to generate the recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The payment option that's used to generate the recommendation.
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// Details for the Savings Plans that we recommend that you purchase to cover
	// existing Savings Plans eligible workloads.
	SavingsPlansPurchaseRecommendationDetails []*SavingsPlansPurchaseRecommendationDetail `type:"list"`

	// Summary metrics for your Savings Plans Recommendations.
	SavingsPlansPurchaseRecommendationSummary *SavingsPlansPurchaseRecommendationSummary `type:"structure"`

	// The requested Savings Plans recommendation type.
	SavingsPlansType *string `type:"string" enum:"SupportedSavingsPlansType"`

	// The Savings Plans recommendation term in years. It's used to generate the
	// recommendation.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendation) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *SavingsPlansPurchaseRecommendation) SetAccountScope(v string) *SavingsPlansPurchaseRecommendation {
	s.AccountScope = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *SavingsPlansPurchaseRecommendation) SetLookbackPeriodInDays(v string) *SavingsPlansPurchaseRecommendation {
	s.LookbackPeriodInDays = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *SavingsPlansPurchaseRecommendation) SetPaymentOption(v string) *SavingsPlansPurchaseRecommendation {
	s.PaymentOption = &v
	return s
}

// SetSavingsPlansPurchaseRecommendationDetails sets the SavingsPlansPurchaseRecommendationDetails field's value.
func (s *SavingsPlansPurchaseRecommendation) SetSavingsPlansPurchaseRecommendationDetails(v []*SavingsPlansPurchaseRecommendationDetail) *SavingsPlansPurchaseRecommendation {
	s.SavingsPlansPurchaseRecommendationDetails = v
	return s
}

// SetSavingsPlansPurchaseRecommendationSummary sets the SavingsPlansPurchaseRecommendationSummary field's value.
func (s *SavingsPlansPurchaseRecommendation) SetSavingsPlansPurchaseRecommendationSummary(v *SavingsPlansPurchaseRecommendationSummary) *SavingsPlansPurchaseRecommendation {
	s.SavingsPlansPurchaseRecommendationSummary = v
	return s
}

// SetSavingsPlansType sets the SavingsPlansType field's value.
func (s *SavingsPlansPurchaseRecommendation) SetSavingsPlansType(v string) *SavingsPlansPurchaseRecommendation {
	s.SavingsPlansType = &v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *SavingsPlansPurchaseRecommendation) SetTermInYears(v string) *SavingsPlansPurchaseRecommendation {
	s.TermInYears = &v
	return s
}

// Details for your recommended Savings Plans.
type SavingsPlansPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The AccountID the recommendation is generated for.
	AccountId *string `type:"string"`

	// The currency code that Amazon Web Services used to generate the recommendations
	// and present potential savings.
	CurrencyCode *string `type:"string"`

	// The average value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentAverageHourlyOnDemandSpend *string `type:"string"`

	// The highest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMaximumHourlyOnDemandSpend *string `type:"string"`

	// The lowest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMinimumHourlyOnDemandSpend *string `type:"string"`

	// The estimated utilization of the recommended Savings Plans.
	EstimatedAverageUtilization *string `type:"string"`

	// The estimated monthly savings amount based on the recommended Savings Plans.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// Savings Plans, over the length of the lookback period.
	EstimatedOnDemandCost *string `type:"string"`

	// The estimated On-Demand costs you expect with no additional commitment, based
	// on your usage of the selected time period and the Savings Plans you own.
	EstimatedOnDemandCostWithCurrentCommitment *string `type:"string"`

	// The estimated return on investment that's based on the recommended Savings
	// Plans that you purchased. This is calculated as estimatedSavingsAmount/ estimatedSPCost*100.
	EstimatedROI *string `type:"string"`

	// The cost of the recommended Savings Plans over the length of the lookback
	// period.
	EstimatedSPCost *string `type:"string"`

	// The estimated savings amount that's based on the recommended Savings Plans
	// over the length of the lookback period.
	EstimatedSavingsAmount *string `type:"string"`

	// The estimated savings percentage relative to the total cost of applicable
	// On-Demand usage over the lookback period.
	EstimatedSavingsPercentage *string `type:"string"`

	// The recommended hourly commitment level for the Savings Plans type and the
	// configuration that's based on the usage during the lookback period.
	HourlyCommitmentToPurchase *string `type:"string"`

	// Contains detailed information about a specific Savings Plan recommendation.
	RecommendationDetailId *string `min:"36" type:"string"`

	// Details for your recommended Savings Plans.
	SavingsPlansDetails *SavingsPlansDetails `type:"structure"`

	// The upfront cost of the recommended Savings Plans, based on the selected
	// payment option.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendationDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetAccountId(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.AccountId = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrencyCode(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrencyCode = &v
	return s
}

// SetCurrentAverageHourlyOnDemandSpend sets the CurrentAverageHourlyOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrentAverageHourlyOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrentAverageHourlyOnDemandSpend = &v
	return s
}

// SetCurrentMaximumHourlyOnDemandSpend sets the CurrentMaximumHourlyOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrentMaximumHourlyOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrentMaximumHourlyOnDemandSpend = &v
	return s
}

// SetCurrentMinimumHourlyOnDemandSpend sets the CurrentMinimumHourlyOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrentMinimumHourlyOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrentMinimumHourlyOnDemandSpend = &v
	return s
}

// SetEstimatedAverageUtilization sets the EstimatedAverageUtilization field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedAverageUtilization(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedAverageUtilization = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedMonthlySavingsAmount(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedOnDemandCost sets the EstimatedOnDemandCost field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedOnDemandCost(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedOnDemandCost = &v
	return s
}

// SetEstimatedOnDemandCostWithCurrentCommitment sets the EstimatedOnDemandCostWithCurrentCommitment field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedOnDemandCostWithCurrentCommitment(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedOnDemandCostWithCurrentCommitment = &v
	return s
}

// SetEstimatedROI sets the EstimatedROI field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedROI(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedROI = &v
	return s
}

// SetEstimatedSPCost sets the EstimatedSPCost field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedSPCost(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedSPCost = &v
	return s
}

// SetEstimatedSavingsAmount sets the EstimatedSavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedSavingsAmount(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedSavingsAmount = &v
	return s
}

// SetEstimatedSavingsPercentage sets the EstimatedSavingsPercentage field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedSavingsPercentage(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedSavingsPercentage = &v
	return s
}

// SetHourlyCommitmentToPurchase sets the HourlyCommitmentToPurchase field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetHourlyCommitmentToPurchase(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.HourlyCommitmentToPurchase = &v
	return s
}

// SetRecommendationDetailId sets the RecommendationDetailId field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetRecommendationDetailId(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.RecommendationDetailId = &v
	return s
}

// SetSavingsPlansDetails sets the SavingsPlansDetails field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetSavingsPlansDetails(v *SavingsPlansDetails) *SavingsPlansPurchaseRecommendationDetail {
	s.SavingsPlansDetails = v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetUpfrontCost(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.UpfrontCost = &v
	return s
}

// Metadata about your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// Additional metadata that might be applicable to the recommendation.
	AdditionalMetadata *string `type:"string"`

	// The timestamp that shows when the recommendations were generated.
	GenerationTimestamp *string `type:"string"`

	// The unique identifier for the recommendation set.
	RecommendationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendationMetadata) GoString() string {
	return s.String()
}

// SetAdditionalMetadata sets the AdditionalMetadata field's value.
func (s *SavingsPlansPurchaseRecommendationMetadata) SetAdditionalMetadata(v string) *SavingsPlansPurchaseRecommendationMetadata {
	s.AdditionalMetadata = &v
	return s
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *SavingsPlansPurchaseRecommendationMetadata) SetGenerationTimestamp(v string) *SavingsPlansPurchaseRecommendationMetadata {
	s.GenerationTimestamp = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *SavingsPlansPurchaseRecommendationMetadata) SetRecommendationId(v string) *SavingsPlansPurchaseRecommendationMetadata {
	s.RecommendationId = &v
	return s
}

// Summary metrics for your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code that Amazon Web Services used to generate the recommendations
	// and present potential savings.
	CurrencyCode *string `type:"string"`

	// The current total on demand spend of the applicable usage types over the
	// lookback period.
	CurrentOnDemandSpend *string `type:"string"`

	// The recommended Savings Plans cost on a daily (24 hourly) basis.
	DailyCommitmentToPurchase *string `type:"string"`

	// The estimated monthly savings amount that's based on the recommended Savings
	// Plans purchase.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// The estimated On-Demand costs you expect with no additional commitment. It's
	// based on your usage of the selected time period and the Savings Plans you
	// own.
	EstimatedOnDemandCostWithCurrentCommitment *string `type:"string"`

	// The estimated return on investment that's based on the recommended Savings
	// Plans and estimated savings.
	EstimatedROI *string `type:"string"`

	// The estimated total savings over the lookback period, based on the purchase
	// of the recommended Savings Plans.
	EstimatedSavingsAmount *string `type:"string"`

	// The estimated savings relative to the total cost of On-Demand usage, over
	// the lookback period. This is calculated as estimatedSavingsAmount/ CurrentOnDemandSpend*100.
	EstimatedSavingsPercentage *string `type:"string"`

	// The estimated total cost of the usage after purchasing the recommended Savings
	// Plans. This is a sum of the cost of Savings Plans during this term, and the
	// remaining On-Demand usage.
	EstimatedTotalCost *string `type:"string"`

	// The recommended hourly commitment that's based on the recommendation parameters.
	HourlyCommitmentToPurchase *string `type:"string"`

	// The aggregate number of Savings Plans recommendations that exist for your
	// account.
	TotalRecommendationCount *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansPurchaseRecommendationSummary) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetCurrencyCode(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.CurrencyCode = &v
	return s
}

// SetCurrentOnDemandSpend sets the CurrentOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetCurrentOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.CurrentOnDemandSpend = &v
	return s
}

// SetDailyCommitmentToPurchase sets the DailyCommitmentToPurchase field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetDailyCommitmentToPurchase(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.DailyCommitmentToPurchase = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedMonthlySavingsAmount(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedOnDemandCostWithCurrentCommitment sets the EstimatedOnDemandCostWithCurrentCommitment field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedOnDemandCostWithCurrentCommitment(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedOnDemandCostWithCurrentCommitment = &v
	return s
}

// SetEstimatedROI sets the EstimatedROI field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedROI(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedROI = &v
	return s
}

// SetEstimatedSavingsAmount sets the EstimatedSavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedSavingsAmount(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedSavingsAmount = &v
	return s
}

// SetEstimatedSavingsPercentage sets the EstimatedSavingsPercentage field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedSavingsPercentage(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedSavingsPercentage = &v
	return s
}

// SetEstimatedTotalCost sets the EstimatedTotalCost field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedTotalCost(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedTotalCost = &v
	return s
}

// SetHourlyCommitmentToPurchase sets the HourlyCommitmentToPurchase field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetHourlyCommitmentToPurchase(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.HourlyCommitmentToPurchase = &v
	return s
}

// SetTotalRecommendationCount sets the TotalRecommendationCount field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetTotalRecommendationCount(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.TotalRecommendationCount = &v
	return s
}

// The amount of savings that you're accumulating, against the public On-Demand
// rate of the usage accrued in an account.
type SavingsPlansSavings struct {
	_ struct{} `type:"structure"`

	// The savings amount that you're accumulating for the usage that's covered
	// by a Savings Plans, when compared to the On-Demand equivalent of the same
	// usage.
	NetSavings *string `type:"string"`

	// How much the amount that the usage would have cost if it was accrued at the
	// On-Demand rate.
	OnDemandCostEquivalent *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansSavings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansSavings) GoString() string {
	return s.String()
}

// SetNetSavings sets the NetSavings field's value.
func (s *SavingsPlansSavings) SetNetSavings(v string) *SavingsPlansSavings {
	s.NetSavings = &v
	return s
}

// SetOnDemandCostEquivalent sets the OnDemandCostEquivalent field's value.
func (s *SavingsPlansSavings) SetOnDemandCostEquivalent(v string) *SavingsPlansSavings {
	s.OnDemandCostEquivalent = &v
	return s
}

// The measurement of how well you're using your existing Savings Plans.
type SavingsPlansUtilization struct {
	_ struct{} `type:"structure"`

	// The total amount of Savings Plans commitment that's been purchased in an
	// account (or set of accounts).
	TotalCommitment *string `type:"string"`

	// The amount of your Savings Plans commitment that wasn't consumed from Savings
	// Plans eligible usage in a specific period.
	UnusedCommitment *string `type:"string"`

	// The amount of your Savings Plans commitment that was consumed from Savings
	// Plans eligible usage in a specific period.
	UsedCommitment *string `type:"string"`

	// The amount of UsedCommitment divided by the TotalCommitment for your Savings
	// Plans.
	UtilizationPercentage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilization) GoString() string {
	return s.String()
}

// SetTotalCommitment sets the TotalCommitment field's value.
func (s *SavingsPlansUtilization) SetTotalCommitment(v string) *SavingsPlansUtilization {
	s.TotalCommitment = &v
	return s
}

// SetUnusedCommitment sets the UnusedCommitment field's value.
func (s *SavingsPlansUtilization) SetUnusedCommitment(v string) *SavingsPlansUtilization {
	s.UnusedCommitment = &v
	return s
}

// SetUsedCommitment sets the UsedCommitment field's value.
func (s *SavingsPlansUtilization) SetUsedCommitment(v string) *SavingsPlansUtilization {
	s.UsedCommitment = &v
	return s
}

// SetUtilizationPercentage sets the UtilizationPercentage field's value.
func (s *SavingsPlansUtilization) SetUtilizationPercentage(v string) *SavingsPlansUtilization {
	s.UtilizationPercentage = &v
	return s
}

// The aggregated utilization metrics for your Savings Plans usage.
type SavingsPlansUtilizationAggregates struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. This includes the sum
	// of the upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The amount that's saved by using existing Savings Plans. Savings returns
	// both net savings from Savings Plans and also the onDemandCostEquivalent of
	// the Savings Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// Utilization is a required field
	Utilization *SavingsPlansUtilization `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilizationAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilizationAggregates) GoString() string {
	return s.String()
}

// SetAmortizedCommitment sets the AmortizedCommitment field's value.
func (s *SavingsPlansUtilizationAggregates) SetAmortizedCommitment(v *SavingsPlansAmortizedCommitment) *SavingsPlansUtilizationAggregates {
	s.AmortizedCommitment = v
	return s
}

// SetSavings sets the Savings field's value.
func (s *SavingsPlansUtilizationAggregates) SetSavings(v *SavingsPlansSavings) *SavingsPlansUtilizationAggregates {
	s.Savings = v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *SavingsPlansUtilizationAggregates) SetUtilization(v *SavingsPlansUtilization) *SavingsPlansUtilizationAggregates {
	s.Utilization = v
	return s
}

// The amount of Savings Plans utilization (in hours).
type SavingsPlansUtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. This includes the sum
	// of the upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The amount that's saved by using existing Savings Plans. Savings returns
	// both net savings from Savings Plans and also the onDemandCostEquivalent of
	// the Savings Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// The time period of the request.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// Utilization is a required field
	Utilization *SavingsPlansUtilization `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilizationByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilizationByTime) GoString() string {
	return s.String()
}

// SetAmortizedCommitment sets the AmortizedCommitment field's value.
func (s *SavingsPlansUtilizationByTime) SetAmortizedCommitment(v *SavingsPlansAmortizedCommitment) *SavingsPlansUtilizationByTime {
	s.AmortizedCommitment = v
	return s
}

// SetSavings sets the Savings field's value.
func (s *SavingsPlansUtilizationByTime) SetSavings(v *SavingsPlansSavings) *SavingsPlansUtilizationByTime {
	s.Savings = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *SavingsPlansUtilizationByTime) SetTimePeriod(v *DateInterval) *SavingsPlansUtilizationByTime {
	s.TimePeriod = v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *SavingsPlansUtilizationByTime) SetUtilization(v *SavingsPlansUtilization) *SavingsPlansUtilizationByTime {
	s.Utilization = v
	return s
}

// A single daily or monthly Savings Plans utilization rate and details for
// your account. A management account in an organization have access to member
// accounts. You can use GetDimensionValues to determine the possible dimension
// values.
type SavingsPlansUtilizationDetail struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. Includes the sum of the
	// upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from savings plans and also the onDemandCostEquivalent of the Savings
	// Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// The unique Amazon Resource Name (ARN) for a particular Savings Plan.
	SavingsPlanArn *string `type:"string"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	Utilization *SavingsPlansUtilization `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilizationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlansUtilizationDetail) GoString() string {
	return s.String()
}

// SetAmortizedCommitment sets the AmortizedCommitment field's value.
func (s *SavingsPlansUtilizationDetail) SetAmortizedCommitment(v *SavingsPlansAmortizedCommitment) *SavingsPlansUtilizationDetail {
	s.AmortizedCommitment = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *SavingsPlansUtilizationDetail) SetAttributes(v map[string]*string) *SavingsPlansUtilizationDetail {
	s.Attributes = v
	return s
}

// SetSavings sets the Savings field's value.
func (s *SavingsPlansUtilizationDetail) SetSavings(v *SavingsPlansSavings) *SavingsPlansUtilizationDetail {
	s.Savings = v
	return s
}

// SetSavingsPlanArn sets the SavingsPlanArn field's value.
func (s *SavingsPlansUtilizationDetail) SetSavingsPlanArn(v string) *SavingsPlansUtilizationDetail {
	s.SavingsPlanArn = &v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *SavingsPlansUtilizationDetail) SetUtilization(v *SavingsPlansUtilization) *SavingsPlansUtilizationDetail {
	s.Utilization = v
	return s
}

// You've reached the limit on the number of resources you can create, or exceeded
// the size of an individual resource.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Hardware specifications for the service that you want recommendations for.
type ServiceSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 hardware specifications that you want Amazon Web Services
	// to provide recommendations for.
	EC2Specification *EC2Specification `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSpecification) GoString() string {
	return s.String()
}

// SetEC2Specification sets the EC2Specification field's value.
func (s *ServiceSpecification) SetEC2Specification(v *EC2Specification) *ServiceSpecification {
	s.EC2Specification = v
	return s
}

// The details for how to sort the data.
type SortDefinition struct {
	_ struct{} `type:"structure"`

	// The key that's used to sort the data.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The order that's used to sort the data.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SortDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SortDefinition"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *SortDefinition) SetKey(v string) *SortDefinition {
	s.Key = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SortDefinition) SetSortOrder(v string) *SortDefinition {
	s.SortOrder = &v
	return s
}

type StartSavingsPlansPurchaseRecommendationGenerationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSavingsPlansPurchaseRecommendationGenerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSavingsPlansPurchaseRecommendationGenerationInput) GoString() string {
	return s.String()
}

type StartSavingsPlansPurchaseRecommendationGenerationOutput struct {
	_ struct{} `type:"structure"`

	// The estimated time for when the recommendation generation will complete.
	EstimatedCompletionTime *string `min:"20" type:"string"`

	// The start time of the recommendation generation.
	GenerationStartedTime *string `min:"20" type:"string"`

	// The ID for this specific recommendation.
	RecommendationId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSavingsPlansPurchaseRecommendationGenerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSavingsPlansPurchaseRecommendationGenerationOutput) GoString() string {
	return s.String()
}

// SetEstimatedCompletionTime sets the EstimatedCompletionTime field's value.
func (s *StartSavingsPlansPurchaseRecommendationGenerationOutput) SetEstimatedCompletionTime(v string) *StartSavingsPlansPurchaseRecommendationGenerationOutput {
	s.EstimatedCompletionTime = &v
	return s
}

// SetGenerationStartedTime sets the GenerationStartedTime field's value.
func (s *StartSavingsPlansPurchaseRecommendationGenerationOutput) SetGenerationStartedTime(v string) *StartSavingsPlansPurchaseRecommendationGenerationOutput {
	s.GenerationStartedTime = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *StartSavingsPlansPurchaseRecommendationGenerationOutput) SetRecommendationId(v string) *StartSavingsPlansPurchaseRecommendationGenerationOutput {
	s.RecommendationId = &v
	return s
}

// The recipient of AnomalySubscription notifications.
type Subscriber struct {
	_ struct{} `type:"structure"`

	// The email address or SNS Amazon Resource Name (ARN). This depends on the
	// Type.
	Address *string `min:"6" type:"string"`

	// Indicates if the subscriber accepts the notifications.
	Status *string `type:"string" enum:"SubscriberStatus"`

	// The notification delivery channel.
	Type *string `type:"string" enum:"SubscriberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subscriber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subscriber) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Subscriber) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Subscriber"}
	if s.Address != nil && len(*s.Address) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Address", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *Subscriber) SetAddress(v string) *Subscriber {
	s.Address = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Subscriber) SetStatus(v string) *Subscriber {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Subscriber) SetType(v string) *Subscriber {
	s.Type = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. For a list of supported resources,
	// see ResourceTag (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// A list of tag key-value pairs to be added to the resource.
	//
	// Each tag consists of a key and a value, and each key must be unique for the
	// resource. The following restrictions apply to resource tags:
	//
	//    * Although the maximum number of array members is 200, you can assign
	//    a maximum of 50 user-tags to one resource. The remaining are reserved
	//    for Amazon Web Services use
	//
	//    * The maximum length of a key is 128 characters
	//
	//    * The maximum length of a value is 256 characters
	//
	//    * Keys and values can only contain alphanumeric characters, spaces, and
	//    any of the following: _.:/=+@-
	//
	//    * Keys and values are case sensitive
	//
	//    * Keys and values are trimmed for any leading or trailing whitespaces
	//
	//    * Don’t use aws: as a prefix for your keys. This prefix is reserved
	//    for Amazon Web Services use
	//
	// ResourceTags is a required field
	ResourceTags []*ResourceTag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.ResourceTags == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTags"))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *TagResourceInput) SetResourceTags(v []*ResourceTag) *TagResourceInput {
	s.ResourceTags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The values that are available for a tag.
//
// If Values and Key aren't specified, the ABSENT MatchOption is applied to
// all tags. That is, it's filtered on resources with no tags.
//
// If Key is provided and Values isn't specified, the ABSENT MatchOption is
// applied to the tag Key only. That is, it's filtered on resources without
// the given tag key.
type TagValues struct {
	_ struct{} `type:"structure"`

	// The key for the tag.
	Key *string `type:"string"`

	// The match options that you can use to filter your results. MatchOptions is
	// only applicable for actions related to Cost Category. The default values
	// for MatchOptions are EQUALS and CASE_SENSITIVE.
	MatchOptions []*string `type:"list" enum:"MatchOption"`

	// The specific value of the tag.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagValues) SetKey(v string) *TagValues {
	s.Key = &v
	return s
}

// SetMatchOptions sets the MatchOptions field's value.
func (s *TagValues) SetMatchOptions(v []*string) *TagValues {
	s.MatchOptions = v
	return s
}

// SetValues sets the Values field's value.
func (s *TagValues) SetValues(v []*string) *TagValues {
	s.Values = v
	return s
}

// Details on recommended instance.
type TargetInstance struct {
	_ struct{} `type:"structure"`

	// The currency code that Amazon Web Services used to calculate the costs for
	// this instance.
	CurrencyCode *string `type:"string"`

	// Determines whether this recommendation is the defaulted Amazon Web Services
	// recommendation.
	DefaultTargetInstance *bool `type:"boolean"`

	// The expected cost to operate this instance type on a monthly basis.
	EstimatedMonthlyCost *string `type:"string"`

	// The estimated savings that result from modification, on a monthly basis.
	EstimatedMonthlySavings *string `type:"string"`

	// The expected utilization metrics for target instance type.
	ExpectedResourceUtilization *ResourceUtilization `type:"structure"`

	// Explains the actions that you might need to take to successfully migrate
	// your workloads from the current instance type to the recommended instance
	// type.
	PlatformDifferences []*string `type:"list" enum:"PlatformDifference"`

	// Details on the target instance type.
	ResourceDetails *ResourceDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetInstance) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *TargetInstance) SetCurrencyCode(v string) *TargetInstance {
	s.CurrencyCode = &v
	return s
}

// SetDefaultTargetInstance sets the DefaultTargetInstance field's value.
func (s *TargetInstance) SetDefaultTargetInstance(v bool) *TargetInstance {
	s.DefaultTargetInstance = &v
	return s
}

// SetEstimatedMonthlyCost sets the EstimatedMonthlyCost field's value.
func (s *TargetInstance) SetEstimatedMonthlyCost(v string) *TargetInstance {
	s.EstimatedMonthlyCost = &v
	return s
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *TargetInstance) SetEstimatedMonthlySavings(v string) *TargetInstance {
	s.EstimatedMonthlySavings = &v
	return s
}

// SetExpectedResourceUtilization sets the ExpectedResourceUtilization field's value.
func (s *TargetInstance) SetExpectedResourceUtilization(v *ResourceUtilization) *TargetInstance {
	s.ExpectedResourceUtilization = v
	return s
}

// SetPlatformDifferences sets the PlatformDifferences field's value.
func (s *TargetInstance) SetPlatformDifferences(v []*string) *TargetInstance {
	s.PlatformDifferences = v
	return s
}

// SetResourceDetails sets the ResourceDetails field's value.
func (s *TargetInstance) SetResourceDetails(v *ResourceDetails) *TargetInstance {
	s.ResourceDetails = v
	return s
}

// Details on termination recommendation.
type TerminateRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The currency code that Amazon Web Services used to calculate the costs for
	// this instance.
	CurrencyCode *string `type:"string"`

	// The estimated savings that result from modification, on a monthly basis.
	EstimatedMonthlySavings *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRecommendationDetail) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *TerminateRecommendationDetail) SetCurrencyCode(v string) *TerminateRecommendationDetail {
	s.CurrencyCode = &v
	return s
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *TerminateRecommendationDetail) SetEstimatedMonthlySavings(v string) *TerminateRecommendationDetail {
	s.EstimatedMonthlySavings = &v
	return s
}

// Can occur if you specify a number of tags for a resource greater than the
// maximum 50 user tags per resource.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Filters cost anomalies based on the total impact.
type TotalImpactFilter struct {
	_ struct{} `type:"structure"`

	// The upper bound dollar value that's used in the filter.
	EndValue *float64 `type:"double"`

	// The comparing value that's used in the filter.
	//
	// NumericOperator is a required field
	NumericOperator *string `type:"string" required:"true" enum:"NumericOperator"`

	// The lower bound dollar value that's used in the filter.
	//
	// StartValue is a required field
	StartValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TotalImpactFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TotalImpactFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TotalImpactFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TotalImpactFilter"}
	if s.NumericOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("NumericOperator"))
	}
	if s.StartValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StartValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndValue sets the EndValue field's value.
func (s *TotalImpactFilter) SetEndValue(v float64) *TotalImpactFilter {
	s.EndValue = &v
	return s
}

// SetNumericOperator sets the NumericOperator field's value.
func (s *TotalImpactFilter) SetNumericOperator(v string) *TotalImpactFilter {
	s.NumericOperator = &v
	return s
}

// SetStartValue sets the StartValue field's value.
func (s *TotalImpactFilter) SetStartValue(v float64) *TotalImpactFilter {
	s.StartValue = &v
	return s
}

// The cost anomaly monitor does not exist for the account.
type UnknownMonitorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownMonitorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownMonitorException) GoString() string {
	return s.String()
}

func newErrorUnknownMonitorException(v protocol.ResponseMetadata) error {
	return &UnknownMonitorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownMonitorException) Code() string {
	return "UnknownMonitorException"
}

// Message returns the exception's message.
func (s *UnknownMonitorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownMonitorException) OrigErr() error {
	return nil
}

func (s *UnknownMonitorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownMonitorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownMonitorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The cost anomaly subscription does not exist for the account.
type UnknownSubscriptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownSubscriptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownSubscriptionException) GoString() string {
	return s.String()
}

func newErrorUnknownSubscriptionException(v protocol.ResponseMetadata) error {
	return &UnknownSubscriptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownSubscriptionException) Code() string {
	return "UnknownSubscriptionException"
}

// Message returns the exception's message.
func (s *UnknownSubscriptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownSubscriptionException) OrigErr() error {
	return nil
}

func (s *UnknownSubscriptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownSubscriptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownSubscriptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Cost Explorer was unable to identify the usage unit. Provide UsageType/UsageTypeGroup
// filter selections that contain matching units, for example: hours.
type UnresolvableUsageUnitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnresolvableUsageUnitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnresolvableUsageUnitException) GoString() string {
	return s.String()
}

func newErrorUnresolvableUsageUnitException(v protocol.ResponseMetadata) error {
	return &UnresolvableUsageUnitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnresolvableUsageUnitException) Code() string {
	return "UnresolvableUsageUnitException"
}

// Message returns the exception's message.
func (s *UnresolvableUsageUnitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnresolvableUsageUnitException) OrigErr() error {
	return nil
}

func (s *UnresolvableUsageUnitException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnresolvableUsageUnitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnresolvableUsageUnitException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. For a list of supported resources,
	// see ResourceTag (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// A list of tag keys associated with tags that need to be removed from the
	// resource. If you specify a tag key that doesn't exist, it's ignored. Although
	// the maximum number of array members is 200, user-tag maximum is 50. The remaining
	// are reserved for Amazon Web Services use.
	//
	// ResourceTagKeys is a required field
	ResourceTagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.ResourceTagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetResourceTagKeys sets the ResourceTagKeys field's value.
func (s *UntagResourceInput) SetResourceTagKeys(v []*string) *UntagResourceInput {
	s.ResourceTagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAnomalyMonitorInput struct {
	_ struct{} `type:"structure"`

	// Cost anomaly monitor Amazon Resource Names (ARNs).
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`

	// The new name for the cost anomaly monitor.
	MonitorName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnomalyMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnomalyMonitorInput"}
	if s.MonitorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *UpdateAnomalyMonitorInput) SetMonitorArn(v string) *UpdateAnomalyMonitorInput {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *UpdateAnomalyMonitorInput) SetMonitorName(v string) *UpdateAnomalyMonitorInput {
	s.MonitorName = &v
	return s
}

type UpdateAnomalyMonitorOutput struct {
	_ struct{} `type:"structure"`

	// A cost anomaly monitor ARN.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalyMonitorOutput) GoString() string {
	return s.String()
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *UpdateAnomalyMonitorOutput) SetMonitorArn(v string) *UpdateAnomalyMonitorOutput {
	s.MonitorArn = &v
	return s
}

type UpdateAnomalySubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The update to the frequency value that subscribers receive notifications.
	Frequency *string `type:"string" enum:"AnomalySubscriptionFrequency"`

	// A list of cost anomaly monitor ARNs.
	MonitorArnList []*string `type:"list"`

	// The update to the subscriber list.
	Subscribers []*Subscriber `type:"list"`

	// A cost anomaly subscription Amazon Resource Name (ARN).
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`

	// The new name of the subscription.
	SubscriptionName *string `type:"string"`

	// (deprecated)
	//
	// The update to the threshold value for receiving notifications.
	//
	// This field has been deprecated. To update a threshold, use ThresholdExpression.
	// Continued use of Threshold will be treated as shorthand syntax for a ThresholdExpression.
	//
	// You can specify either Threshold or ThresholdExpression, but not both.
	//
	// Deprecated: Threshold has been deprecated in favor of ThresholdExpression
	Threshold *float64 `deprecated:"true" type:"double"`

	// The update to the Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object used to specify the anomalies that you want to generate alerts for.
	// This supports dimensions and nested expressions. The supported dimensions
	// are ANOMALY_TOTAL_IMPACT_ABSOLUTE and ANOMALY_TOTAL_IMPACT_PERCENTAGE, corresponding
	// to an anomaly’s TotalImpact and TotalImpactPercentage, respectively (see
	// Impact (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html)
	// for more details). The supported nested expression types are AND and OR.
	// The match option GREATER_THAN_OR_EQUAL is required. Values must be numbers
	// between 0 and 10,000,000,000 in string format.
	//
	// You can specify either Threshold or ThresholdExpression, but not both.
	//
	// The following are examples of valid ThresholdExpressions:
	//
	//    * Absolute threshold: { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }
	//
	//    * Percentage threshold: { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }
	//
	//    * AND two thresholds together: { "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } },
	//    { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions":
	//    [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }
	//
	//    * OR two thresholds together: { "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE",
	//    "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } },
	//    { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions":
	//    [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }
	ThresholdExpression *Expression `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalySubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalySubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnomalySubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnomalySubscriptionInput"}
	if s.SubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionArn"))
	}
	if s.Subscribers != nil {
		for i, v := range s.Subscribers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscribers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ThresholdExpression != nil {
		if err := s.ThresholdExpression.Validate(); err != nil {
			invalidParams.AddNested("ThresholdExpression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrequency sets the Frequency field's value.
func (s *UpdateAnomalySubscriptionInput) SetFrequency(v string) *UpdateAnomalySubscriptionInput {
	s.Frequency = &v
	return s
}

// SetMonitorArnList sets the MonitorArnList field's value.
func (s *UpdateAnomalySubscriptionInput) SetMonitorArnList(v []*string) *UpdateAnomalySubscriptionInput {
	s.MonitorArnList = v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *UpdateAnomalySubscriptionInput) SetSubscribers(v []*Subscriber) *UpdateAnomalySubscriptionInput {
	s.Subscribers = v
	return s
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *UpdateAnomalySubscriptionInput) SetSubscriptionArn(v string) *UpdateAnomalySubscriptionInput {
	s.SubscriptionArn = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *UpdateAnomalySubscriptionInput) SetSubscriptionName(v string) *UpdateAnomalySubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *UpdateAnomalySubscriptionInput) SetThreshold(v float64) *UpdateAnomalySubscriptionInput {
	s.Threshold = &v
	return s
}

// SetThresholdExpression sets the ThresholdExpression field's value.
func (s *UpdateAnomalySubscriptionInput) SetThresholdExpression(v *Expression) *UpdateAnomalySubscriptionInput {
	s.ThresholdExpression = v
	return s
}

type UpdateAnomalySubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// A cost anomaly subscription ARN.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalySubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnomalySubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *UpdateAnomalySubscriptionOutput) SetSubscriptionArn(v string) *UpdateAnomalySubscriptionOutput {
	s.SubscriptionArn = &v
	return s
}

// Gives a detailed description of the result of an action. It's on each cost
// allocation tag entry in the request.
type UpdateCostAllocationTagsStatusError struct {
	_ struct{} `type:"structure"`

	// An error code representing why the action failed on this entry.
	Code *string `type:"string"`

	// A message explaining why the action failed on this entry.
	Message *string `type:"string"`

	// The key for the cost allocation tag.
	TagKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostAllocationTagsStatusError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostAllocationTagsStatusError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *UpdateCostAllocationTagsStatusError) SetCode(v string) *UpdateCostAllocationTagsStatusError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *UpdateCostAllocationTagsStatusError) SetMessage(v string) *UpdateCostAllocationTagsStatusError {
	s.Message = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *UpdateCostAllocationTagsStatusError) SetTagKey(v string) *UpdateCostAllocationTagsStatusError {
	s.TagKey = &v
	return s
}

type UpdateCostAllocationTagsStatusInput struct {
	_ struct{} `type:"structure"`

	// The list of CostAllocationTagStatusEntry objects that are used to update
	// cost allocation tags status for this request.
	//
	// CostAllocationTagsStatus is a required field
	CostAllocationTagsStatus []*CostAllocationTagStatusEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostAllocationTagsStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostAllocationTagsStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCostAllocationTagsStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCostAllocationTagsStatusInput"}
	if s.CostAllocationTagsStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("CostAllocationTagsStatus"))
	}
	if s.CostAllocationTagsStatus != nil && len(s.CostAllocationTagsStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CostAllocationTagsStatus", 1))
	}
	if s.CostAllocationTagsStatus != nil {
		for i, v := range s.CostAllocationTagsStatus {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CostAllocationTagsStatus", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostAllocationTagsStatus sets the CostAllocationTagsStatus field's value.
func (s *UpdateCostAllocationTagsStatusInput) SetCostAllocationTagsStatus(v []*CostAllocationTagStatusEntry) *UpdateCostAllocationTagsStatusInput {
	s.CostAllocationTagsStatus = v
	return s
}

type UpdateCostAllocationTagsStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of UpdateCostAllocationTagsStatusError objects with error details
	// about each cost allocation tag that can't be updated. If there's no failure,
	// an empty array returns.
	Errors []*UpdateCostAllocationTagsStatusError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostAllocationTagsStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostAllocationTagsStatusOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *UpdateCostAllocationTagsStatusOutput) SetErrors(v []*UpdateCostAllocationTagsStatusError) *UpdateCostAllocationTagsStatusOutput {
	s.Errors = v
	return s
}

type UpdateCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The default value for the cost category.
	DefaultValue *string `min:"1" type:"string"`

	// The Cost Category's effective start date. It can only be a billing start
	// date (first day of the month). If the date isn't provided, it's the first
	// day of the current month. Dates can't be before the previous twelve months,
	// or in the future.
	EffectiveStart *string `min:"20" type:"string"`

	// The rule schema version in this particular Cost Category.
	//
	// RuleVersion is a required field
	RuleVersion *string `type:"string" required:"true" enum:"CostCategoryRuleVersion"`

	// The Expression object used to categorize costs. For more information, see
	// CostCategoryRule (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html).
	//
	// Rules is a required field
	Rules []*CostCategoryRule `min:"1" type:"list" required:"true"`

	// The split charge rules used to allocate your charges between your Cost Category
	// values.
	SplitChargeRules []*CostCategorySplitChargeRule `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCostCategoryDefinitionInput"}
	if s.CostCategoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CostCategoryArn"))
	}
	if s.CostCategoryArn != nil && len(*s.CostCategoryArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CostCategoryArn", 20))
	}
	if s.DefaultValue != nil && len(*s.DefaultValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultValue", 1))
	}
	if s.EffectiveStart != nil && len(*s.EffectiveStart) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EffectiveStart", 20))
	}
	if s.RuleVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleVersion"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.SplitChargeRules != nil && len(s.SplitChargeRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SplitChargeRules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SplitChargeRules != nil {
		for i, v := range s.SplitChargeRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SplitChargeRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *UpdateCostCategoryDefinitionInput) SetCostCategoryArn(v string) *UpdateCostCategoryDefinitionInput {
	s.CostCategoryArn = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *UpdateCostCategoryDefinitionInput) SetDefaultValue(v string) *UpdateCostCategoryDefinitionInput {
	s.DefaultValue = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *UpdateCostCategoryDefinitionInput) SetEffectiveStart(v string) *UpdateCostCategoryDefinitionInput {
	s.EffectiveStart = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *UpdateCostCategoryDefinitionInput) SetRuleVersion(v string) *UpdateCostCategoryDefinitionInput {
	s.RuleVersion = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateCostCategoryDefinitionInput) SetRules(v []*CostCategoryRule) *UpdateCostCategoryDefinitionInput {
	s.Rules = v
	return s
}

// SetSplitChargeRules sets the SplitChargeRules field's value.
func (s *UpdateCostCategoryDefinitionInput) SetSplitChargeRules(v []*CostCategorySplitChargeRule) *UpdateCostCategoryDefinitionInput {
	s.SplitChargeRules = v
	return s
}

type UpdateCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The Cost Category's effective start date. It can only be a billing start
	// date (first day of the month).
	EffectiveStart *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *UpdateCostCategoryDefinitionOutput) SetCostCategoryArn(v string) *UpdateCostCategoryDefinitionOutput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *UpdateCostCategoryDefinitionOutput) SetEffectiveStart(v string) *UpdateCostCategoryDefinitionOutput {
	s.EffectiveStart = &v
	return s
}

// The amount of utilization, in hours.
type UtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The groups that this utilization result uses.
	Groups []*ReservationUtilizationGroup `type:"list"`

	// The period of time that this utilization was used for.
	TimePeriod *DateInterval `type:"structure"`

	// The total number of reservation hours that were used.
	Total *ReservationAggregates `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UtilizationByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UtilizationByTime) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *UtilizationByTime) SetGroups(v []*ReservationUtilizationGroup) *UtilizationByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *UtilizationByTime) SetTimePeriod(v *DateInterval) *UtilizationByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *UtilizationByTime) SetTotal(v *ReservationAggregates) *UtilizationByTime {
	s.Total = v
	return s
}

const (
	// AccountScopePayer is a AccountScope enum value
	AccountScopePayer = "PAYER"

	// AccountScopeLinked is a AccountScope enum value
	AccountScopeLinked = "LINKED"
)

// AccountScope_Values returns all elements of the AccountScope enum
func AccountScope_Values() []string {
	return []string{
		AccountScopePayer,
		AccountScopeLinked,
	}
}

const (
	// AnomalyFeedbackTypeYes is a AnomalyFeedbackType enum value
	AnomalyFeedbackTypeYes = "YES"

	// AnomalyFeedbackTypeNo is a AnomalyFeedbackType enum value
	AnomalyFeedbackTypeNo = "NO"

	// AnomalyFeedbackTypePlannedActivity is a AnomalyFeedbackType enum value
	AnomalyFeedbackTypePlannedActivity = "PLANNED_ACTIVITY"
)

// AnomalyFeedbackType_Values returns all elements of the AnomalyFeedbackType enum
func AnomalyFeedbackType_Values() []string {
	return []string{
		AnomalyFeedbackTypeYes,
		AnomalyFeedbackTypeNo,
		AnomalyFeedbackTypePlannedActivity,
	}
}

const (
	// AnomalySubscriptionFrequencyDaily is a AnomalySubscriptionFrequency enum value
	AnomalySubscriptionFrequencyDaily = "DAILY"

	// AnomalySubscriptionFrequencyImmediate is a AnomalySubscriptionFrequency enum value
	AnomalySubscriptionFrequencyImmediate = "IMMEDIATE"

	// AnomalySubscriptionFrequencyWeekly is a AnomalySubscriptionFrequency enum value
	AnomalySubscriptionFrequencyWeekly = "WEEKLY"
)

// AnomalySubscriptionFrequency_Values returns all elements of the AnomalySubscriptionFrequency enum
func AnomalySubscriptionFrequency_Values() []string {
	return []string{
		AnomalySubscriptionFrequencyDaily,
		AnomalySubscriptionFrequencyImmediate,
		AnomalySubscriptionFrequencyWeekly,
	}
}

const (
	// ApproximationDimensionService is a ApproximationDimension enum value
	ApproximationDimensionService = "SERVICE"

	// ApproximationDimensionResource is a ApproximationDimension enum value
	ApproximationDimensionResource = "RESOURCE"
)

// ApproximationDimension_Values returns all elements of the ApproximationDimension enum
func ApproximationDimension_Values() []string {
	return []string{
		ApproximationDimensionService,
		ApproximationDimensionResource,
	}
}

const (
	// ContextCostAndUsage is a Context enum value
	ContextCostAndUsage = "COST_AND_USAGE"

	// ContextReservations is a Context enum value
	ContextReservations = "RESERVATIONS"

	// ContextSavingsPlans is a Context enum value
	ContextSavingsPlans = "SAVINGS_PLANS"
)

// Context_Values returns all elements of the Context enum
func Context_Values() []string {
	return []string{
		ContextCostAndUsage,
		ContextReservations,
		ContextSavingsPlans,
	}
}

const (
	// CostAllocationTagStatusActive is a CostAllocationTagStatus enum value
	CostAllocationTagStatusActive = "Active"

	// CostAllocationTagStatusInactive is a CostAllocationTagStatus enum value
	CostAllocationTagStatusInactive = "Inactive"
)

// CostAllocationTagStatus_Values returns all elements of the CostAllocationTagStatus enum
func CostAllocationTagStatus_Values() []string {
	return []string{
		CostAllocationTagStatusActive,
		CostAllocationTagStatusInactive,
	}
}

const (
	// CostAllocationTagTypeAwsgenerated is a CostAllocationTagType enum value
	CostAllocationTagTypeAwsgenerated = "AWSGenerated"

	// CostAllocationTagTypeUserDefined is a CostAllocationTagType enum value
	CostAllocationTagTypeUserDefined = "UserDefined"
)

// CostAllocationTagType_Values returns all elements of the CostAllocationTagType enum
func CostAllocationTagType_Values() []string {
	return []string{
		CostAllocationTagTypeAwsgenerated,
		CostAllocationTagTypeUserDefined,
	}
}

const (
	// CostCategoryInheritedValueDimensionNameLinkedAccountName is a CostCategoryInheritedValueDimensionName enum value
	CostCategoryInheritedValueDimensionNameLinkedAccountName = "LINKED_ACCOUNT_NAME"

	// CostCategoryInheritedValueDimensionNameTag is a CostCategoryInheritedValueDimensionName enum value
	CostCategoryInheritedValueDimensionNameTag = "TAG"
)

// CostCategoryInheritedValueDimensionName_Values returns all elements of the CostCategoryInheritedValueDimensionName enum
func CostCategoryInheritedValueDimensionName_Values() []string {
	return []string{
		CostCategoryInheritedValueDimensionNameLinkedAccountName,
		CostCategoryInheritedValueDimensionNameTag,
	}
}

const (
	// CostCategoryRuleTypeRegular is a CostCategoryRuleType enum value
	CostCategoryRuleTypeRegular = "REGULAR"

	// CostCategoryRuleTypeInheritedValue is a CostCategoryRuleType enum value
	CostCategoryRuleTypeInheritedValue = "INHERITED_VALUE"
)

// CostCategoryRuleType_Values returns all elements of the CostCategoryRuleType enum
func CostCategoryRuleType_Values() []string {
	return []string{
		CostCategoryRuleTypeRegular,
		CostCategoryRuleTypeInheritedValue,
	}
}

// The rule schema version in this particular Cost Category.
const (
	// CostCategoryRuleVersionCostCategoryExpressionV1 is a CostCategoryRuleVersion enum value
	CostCategoryRuleVersionCostCategoryExpressionV1 = "CostCategoryExpression.v1"
)

// CostCategoryRuleVersion_Values returns all elements of the CostCategoryRuleVersion enum
func CostCategoryRuleVersion_Values() []string {
	return []string{
		CostCategoryRuleVersionCostCategoryExpressionV1,
	}
}

const (
	// CostCategorySplitChargeMethodFixed is a CostCategorySplitChargeMethod enum value
	CostCategorySplitChargeMethodFixed = "FIXED"

	// CostCategorySplitChargeMethodProportional is a CostCategorySplitChargeMethod enum value
	CostCategorySplitChargeMethodProportional = "PROPORTIONAL"

	// CostCategorySplitChargeMethodEven is a CostCategorySplitChargeMethod enum value
	CostCategorySplitChargeMethodEven = "EVEN"
)

// CostCategorySplitChargeMethod_Values returns all elements of the CostCategorySplitChargeMethod enum
func CostCategorySplitChargeMethod_Values() []string {
	return []string{
		CostCategorySplitChargeMethodFixed,
		CostCategorySplitChargeMethodProportional,
		CostCategorySplitChargeMethodEven,
	}
}

const (
	// CostCategorySplitChargeRuleParameterTypeAllocationPercentages is a CostCategorySplitChargeRuleParameterType enum value
	CostCategorySplitChargeRuleParameterTypeAllocationPercentages = "ALLOCATION_PERCENTAGES"
)

// CostCategorySplitChargeRuleParameterType_Values returns all elements of the CostCategorySplitChargeRuleParameterType enum
func CostCategorySplitChargeRuleParameterType_Values() []string {
	return []string{
		CostCategorySplitChargeRuleParameterTypeAllocationPercentages,
	}
}

const (
	// CostCategoryStatusProcessing is a CostCategoryStatus enum value
	CostCategoryStatusProcessing = "PROCESSING"

	// CostCategoryStatusApplied is a CostCategoryStatus enum value
	CostCategoryStatusApplied = "APPLIED"
)

// CostCategoryStatus_Values returns all elements of the CostCategoryStatus enum
func CostCategoryStatus_Values() []string {
	return []string{
		CostCategoryStatusProcessing,
		CostCategoryStatusApplied,
	}
}

const (
	// CostCategoryStatusComponentCostExplorer is a CostCategoryStatusComponent enum value
	CostCategoryStatusComponentCostExplorer = "COST_EXPLORER"
)

// CostCategoryStatusComponent_Values returns all elements of the CostCategoryStatusComponent enum
func CostCategoryStatusComponent_Values() []string {
	return []string{
		CostCategoryStatusComponentCostExplorer,
	}
}

const (
	// DimensionAz is a Dimension enum value
	DimensionAz = "AZ"

	// DimensionInstanceType is a Dimension enum value
	DimensionInstanceType = "INSTANCE_TYPE"

	// DimensionLinkedAccount is a Dimension enum value
	DimensionLinkedAccount = "LINKED_ACCOUNT"

	// DimensionLinkedAccountName is a Dimension enum value
	DimensionLinkedAccountName = "LINKED_ACCOUNT_NAME"

	// DimensionOperation is a Dimension enum value
	DimensionOperation = "OPERATION"

	// DimensionPurchaseType is a Dimension enum value
	DimensionPurchaseType = "PURCHASE_TYPE"

	// DimensionRegion is a Dimension enum value
	DimensionRegion = "REGION"

	// DimensionService is a Dimension enum value
	DimensionService = "SERVICE"

	// DimensionServiceCode is a Dimension enum value
	DimensionServiceCode = "SERVICE_CODE"

	// DimensionUsageType is a Dimension enum value
	DimensionUsageType = "USAGE_TYPE"

	// DimensionUsageTypeGroup is a Dimension enum value
	DimensionUsageTypeGroup = "USAGE_TYPE_GROUP"

	// DimensionRecordType is a Dimension enum value
	DimensionRecordType = "RECORD_TYPE"

	// DimensionOperatingSystem is a Dimension enum value
	DimensionOperatingSystem = "OPERATING_SYSTEM"

	// DimensionTenancy is a Dimension enum value
	DimensionTenancy = "TENANCY"

	// DimensionScope is a Dimension enum value
	DimensionScope = "SCOPE"

	// DimensionPlatform is a Dimension enum value
	DimensionPlatform = "PLATFORM"

	// DimensionSubscriptionId is a Dimension enum value
	DimensionSubscriptionId = "SUBSCRIPTION_ID"

	// DimensionLegalEntityName is a Dimension enum value
	DimensionLegalEntityName = "LEGAL_ENTITY_NAME"

	// DimensionDeploymentOption is a Dimension enum value
	DimensionDeploymentOption = "DEPLOYMENT_OPTION"

	// DimensionDatabaseEngine is a Dimension enum value
	DimensionDatabaseEngine = "DATABASE_ENGINE"

	// DimensionCacheEngine is a Dimension enum value
	DimensionCacheEngine = "CACHE_ENGINE"

	// DimensionInstanceTypeFamily is a Dimension enum value
	DimensionInstanceTypeFamily = "INSTANCE_TYPE_FAMILY"

	// DimensionBillingEntity is a Dimension enum value
	DimensionBillingEntity = "BILLING_ENTITY"

	// DimensionReservationId is a Dimension enum value
	DimensionReservationId = "RESERVATION_ID"

	// DimensionResourceId is a Dimension enum value
	DimensionResourceId = "RESOURCE_ID"

	// DimensionRightsizingType is a Dimension enum value
	DimensionRightsizingType = "RIGHTSIZING_TYPE"

	// DimensionSavingsPlansType is a Dimension enum value
	DimensionSavingsPlansType = "SAVINGS_PLANS_TYPE"

	// DimensionSavingsPlanArn is a Dimension enum value
	DimensionSavingsPlanArn = "SAVINGS_PLAN_ARN"

	// DimensionPaymentOption is a Dimension enum value
	DimensionPaymentOption = "PAYMENT_OPTION"

	// DimensionAgreementEndDateTimeAfter is a Dimension enum value
	DimensionAgreementEndDateTimeAfter = "AGREEMENT_END_DATE_TIME_AFTER"

	// DimensionAgreementEndDateTimeBefore is a Dimension enum value
	DimensionAgreementEndDateTimeBefore = "AGREEMENT_END_DATE_TIME_BEFORE"

	// DimensionInvoicingEntity is a Dimension enum value
	DimensionInvoicingEntity = "INVOICING_ENTITY"

	// DimensionAnomalyTotalImpactAbsolute is a Dimension enum value
	DimensionAnomalyTotalImpactAbsolute = "ANOMALY_TOTAL_IMPACT_ABSOLUTE"

	// DimensionAnomalyTotalImpactPercentage is a Dimension enum value
	DimensionAnomalyTotalImpactPercentage = "ANOMALY_TOTAL_IMPACT_PERCENTAGE"
)

// Dimension_Values returns all elements of the Dimension enum
func Dimension_Values() []string {
	return []string{
		DimensionAz,
		DimensionInstanceType,
		DimensionLinkedAccount,
		DimensionLinkedAccountName,
		DimensionOperation,
		DimensionPurchaseType,
		DimensionRegion,
		DimensionService,
		DimensionServiceCode,
		DimensionUsageType,
		DimensionUsageTypeGroup,
		DimensionRecordType,
		DimensionOperatingSystem,
		DimensionTenancy,
		DimensionScope,
		DimensionPlatform,
		DimensionSubscriptionId,
		DimensionLegalEntityName,
		DimensionDeploymentOption,
		DimensionDatabaseEngine,
		DimensionCacheEngine,
		DimensionInstanceTypeFamily,
		DimensionBillingEntity,
		DimensionReservationId,
		DimensionResourceId,
		DimensionRightsizingType,
		DimensionSavingsPlansType,
		DimensionSavingsPlanArn,
		DimensionPaymentOption,
		DimensionAgreementEndDateTimeAfter,
		DimensionAgreementEndDateTimeBefore,
		DimensionInvoicingEntity,
		DimensionAnomalyTotalImpactAbsolute,
		DimensionAnomalyTotalImpactPercentage,
	}
}

const (
	// FindingReasonCodeCpuOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeCpuOverProvisioned = "CPU_OVER_PROVISIONED"

	// FindingReasonCodeCpuUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeCpuUnderProvisioned = "CPU_UNDER_PROVISIONED"

	// FindingReasonCodeMemoryOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeMemoryOverProvisioned = "MEMORY_OVER_PROVISIONED"

	// FindingReasonCodeMemoryUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeMemoryUnderProvisioned = "MEMORY_UNDER_PROVISIONED"

	// FindingReasonCodeEbsThroughputOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeEbsThroughputOverProvisioned = "EBS_THROUGHPUT_OVER_PROVISIONED"

	// FindingReasonCodeEbsThroughputUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeEbsThroughputUnderProvisioned = "EBS_THROUGHPUT_UNDER_PROVISIONED"

	// FindingReasonCodeEbsIopsOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeEbsIopsOverProvisioned = "EBS_IOPS_OVER_PROVISIONED"

	// FindingReasonCodeEbsIopsUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeEbsIopsUnderProvisioned = "EBS_IOPS_UNDER_PROVISIONED"

	// FindingReasonCodeNetworkBandwidthOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeNetworkBandwidthOverProvisioned = "NETWORK_BANDWIDTH_OVER_PROVISIONED"

	// FindingReasonCodeNetworkBandwidthUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeNetworkBandwidthUnderProvisioned = "NETWORK_BANDWIDTH_UNDER_PROVISIONED"

	// FindingReasonCodeNetworkPpsOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeNetworkPpsOverProvisioned = "NETWORK_PPS_OVER_PROVISIONED"

	// FindingReasonCodeNetworkPpsUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeNetworkPpsUnderProvisioned = "NETWORK_PPS_UNDER_PROVISIONED"

	// FindingReasonCodeDiskIopsOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeDiskIopsOverProvisioned = "DISK_IOPS_OVER_PROVISIONED"

	// FindingReasonCodeDiskIopsUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeDiskIopsUnderProvisioned = "DISK_IOPS_UNDER_PROVISIONED"

	// FindingReasonCodeDiskThroughputOverProvisioned is a FindingReasonCode enum value
	FindingReasonCodeDiskThroughputOverProvisioned = "DISK_THROUGHPUT_OVER_PROVISIONED"

	// FindingReasonCodeDiskThroughputUnderProvisioned is a FindingReasonCode enum value
	FindingReasonCodeDiskThroughputUnderProvisioned = "DISK_THROUGHPUT_UNDER_PROVISIONED"
)

// FindingReasonCode_Values returns all elements of the FindingReasonCode enum
func FindingReasonCode_Values() []string {
	return []string{
		FindingReasonCodeCpuOverProvisioned,
		FindingReasonCodeCpuUnderProvisioned,
		FindingReasonCodeMemoryOverProvisioned,
		FindingReasonCodeMemoryUnderProvisioned,
		FindingReasonCodeEbsThroughputOverProvisioned,
		FindingReasonCodeEbsThroughputUnderProvisioned,
		FindingReasonCodeEbsIopsOverProvisioned,
		FindingReasonCodeEbsIopsUnderProvisioned,
		FindingReasonCodeNetworkBandwidthOverProvisioned,
		FindingReasonCodeNetworkBandwidthUnderProvisioned,
		FindingReasonCodeNetworkPpsOverProvisioned,
		FindingReasonCodeNetworkPpsUnderProvisioned,
		FindingReasonCodeDiskIopsOverProvisioned,
		FindingReasonCodeDiskIopsUnderProvisioned,
		FindingReasonCodeDiskThroughputOverProvisioned,
		FindingReasonCodeDiskThroughputUnderProvisioned,
	}
}

const (
	// GenerationStatusSucceeded is a GenerationStatus enum value
	GenerationStatusSucceeded = "SUCCEEDED"

	// GenerationStatusProcessing is a GenerationStatus enum value
	GenerationStatusProcessing = "PROCESSING"

	// GenerationStatusFailed is a GenerationStatus enum value
	GenerationStatusFailed = "FAILED"
)

// GenerationStatus_Values returns all elements of the GenerationStatus enum
func GenerationStatus_Values() []string {
	return []string{
		GenerationStatusSucceeded,
		GenerationStatusProcessing,
		GenerationStatusFailed,
	}
}

const (
	// GranularityDaily is a Granularity enum value
	GranularityDaily = "DAILY"

	// GranularityMonthly is a Granularity enum value
	GranularityMonthly = "MONTHLY"

	// GranularityHourly is a Granularity enum value
	GranularityHourly = "HOURLY"
)

// Granularity_Values returns all elements of the Granularity enum
func Granularity_Values() []string {
	return []string{
		GranularityDaily,
		GranularityMonthly,
		GranularityHourly,
	}
}

const (
	// GroupDefinitionTypeDimension is a GroupDefinitionType enum value
	GroupDefinitionTypeDimension = "DIMENSION"

	// GroupDefinitionTypeTag is a GroupDefinitionType enum value
	GroupDefinitionTypeTag = "TAG"

	// GroupDefinitionTypeCostCategory is a GroupDefinitionType enum value
	GroupDefinitionTypeCostCategory = "COST_CATEGORY"
)

// GroupDefinitionType_Values returns all elements of the GroupDefinitionType enum
func GroupDefinitionType_Values() []string {
	return []string{
		GroupDefinitionTypeDimension,
		GroupDefinitionTypeTag,
		GroupDefinitionTypeCostCategory,
	}
}

const (
	// LookbackPeriodInDaysSevenDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysSevenDays = "SEVEN_DAYS"

	// LookbackPeriodInDaysThirtyDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysThirtyDays = "THIRTY_DAYS"

	// LookbackPeriodInDaysSixtyDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysSixtyDays = "SIXTY_DAYS"
)

// LookbackPeriodInDays_Values returns all elements of the LookbackPeriodInDays enum
func LookbackPeriodInDays_Values() []string {
	return []string{
		LookbackPeriodInDaysSevenDays,
		LookbackPeriodInDaysThirtyDays,
		LookbackPeriodInDaysSixtyDays,
	}
}

const (
	// MatchOptionEquals is a MatchOption enum value
	MatchOptionEquals = "EQUALS"

	// MatchOptionAbsent is a MatchOption enum value
	MatchOptionAbsent = "ABSENT"

	// MatchOptionStartsWith is a MatchOption enum value
	MatchOptionStartsWith = "STARTS_WITH"

	// MatchOptionEndsWith is a MatchOption enum value
	MatchOptionEndsWith = "ENDS_WITH"

	// MatchOptionContains is a MatchOption enum value
	MatchOptionContains = "CONTAINS"

	// MatchOptionCaseSensitive is a MatchOption enum value
	MatchOptionCaseSensitive = "CASE_SENSITIVE"

	// MatchOptionCaseInsensitive is a MatchOption enum value
	MatchOptionCaseInsensitive = "CASE_INSENSITIVE"

	// MatchOptionGreaterThanOrEqual is a MatchOption enum value
	MatchOptionGreaterThanOrEqual = "GREATER_THAN_OR_EQUAL"
)

// MatchOption_Values returns all elements of the MatchOption enum
func MatchOption_Values() []string {
	return []string{
		MatchOptionEquals,
		MatchOptionAbsent,
		MatchOptionStartsWith,
		MatchOptionEndsWith,
		MatchOptionContains,
		MatchOptionCaseSensitive,
		MatchOptionCaseInsensitive,
		MatchOptionGreaterThanOrEqual,
	}
}

const (
	// MetricBlendedCost is a Metric enum value
	MetricBlendedCost = "BLENDED_COST"

	// MetricUnblendedCost is a Metric enum value
	MetricUnblendedCost = "UNBLENDED_COST"

	// MetricAmortizedCost is a Metric enum value
	MetricAmortizedCost = "AMORTIZED_COST"

	// MetricNetUnblendedCost is a Metric enum value
	MetricNetUnblendedCost = "NET_UNBLENDED_COST"

	// MetricNetAmortizedCost is a Metric enum value
	MetricNetAmortizedCost = "NET_AMORTIZED_COST"

	// MetricUsageQuantity is a Metric enum value
	MetricUsageQuantity = "USAGE_QUANTITY"

	// MetricNormalizedUsageAmount is a Metric enum value
	MetricNormalizedUsageAmount = "NORMALIZED_USAGE_AMOUNT"
)

// Metric_Values returns all elements of the Metric enum
func Metric_Values() []string {
	return []string{
		MetricBlendedCost,
		MetricUnblendedCost,
		MetricAmortizedCost,
		MetricNetUnblendedCost,
		MetricNetAmortizedCost,
		MetricUsageQuantity,
		MetricNormalizedUsageAmount,
	}
}

const (
	// MonitorDimensionService is a MonitorDimension enum value
	MonitorDimensionService = "SERVICE"
)

// MonitorDimension_Values returns all elements of the MonitorDimension enum
func MonitorDimension_Values() []string {
	return []string{
		MonitorDimensionService,
	}
}

const (
	// MonitorTypeDimensional is a MonitorType enum value
	MonitorTypeDimensional = "DIMENSIONAL"

	// MonitorTypeCustom is a MonitorType enum value
	MonitorTypeCustom = "CUSTOM"
)

// MonitorType_Values returns all elements of the MonitorType enum
func MonitorType_Values() []string {
	return []string{
		MonitorTypeDimensional,
		MonitorTypeCustom,
	}
}

const (
	// NumericOperatorEqual is a NumericOperator enum value
	NumericOperatorEqual = "EQUAL"

	// NumericOperatorGreaterThanOrEqual is a NumericOperator enum value
	NumericOperatorGreaterThanOrEqual = "GREATER_THAN_OR_EQUAL"

	// NumericOperatorLessThanOrEqual is a NumericOperator enum value
	NumericOperatorLessThanOrEqual = "LESS_THAN_OR_EQUAL"

	// NumericOperatorGreaterThan is a NumericOperator enum value
	NumericOperatorGreaterThan = "GREATER_THAN"

	// NumericOperatorLessThan is a NumericOperator enum value
	NumericOperatorLessThan = "LESS_THAN"

	// NumericOperatorBetween is a NumericOperator enum value
	NumericOperatorBetween = "BETWEEN"
)

// NumericOperator_Values returns all elements of the NumericOperator enum
func NumericOperator_Values() []string {
	return []string{
		NumericOperatorEqual,
		NumericOperatorGreaterThanOrEqual,
		NumericOperatorLessThanOrEqual,
		NumericOperatorGreaterThan,
		NumericOperatorLessThan,
		NumericOperatorBetween,
	}
}

const (
	// OfferingClassStandard is a OfferingClass enum value
	OfferingClassStandard = "STANDARD"

	// OfferingClassConvertible is a OfferingClass enum value
	OfferingClassConvertible = "CONVERTIBLE"
)

// OfferingClass_Values returns all elements of the OfferingClass enum
func OfferingClass_Values() []string {
	return []string{
		OfferingClassStandard,
		OfferingClassConvertible,
	}
}

const (
	// PaymentOptionNoUpfront is a PaymentOption enum value
	PaymentOptionNoUpfront = "NO_UPFRONT"

	// PaymentOptionPartialUpfront is a PaymentOption enum value
	PaymentOptionPartialUpfront = "PARTIAL_UPFRONT"

	// PaymentOptionAllUpfront is a PaymentOption enum value
	PaymentOptionAllUpfront = "ALL_UPFRONT"

	// PaymentOptionLightUtilization is a PaymentOption enum value
	PaymentOptionLightUtilization = "LIGHT_UTILIZATION"

	// PaymentOptionMediumUtilization is a PaymentOption enum value
	PaymentOptionMediumUtilization = "MEDIUM_UTILIZATION"

	// PaymentOptionHeavyUtilization is a PaymentOption enum value
	PaymentOptionHeavyUtilization = "HEAVY_UTILIZATION"
)

// PaymentOption_Values returns all elements of the PaymentOption enum
func PaymentOption_Values() []string {
	return []string{
		PaymentOptionNoUpfront,
		PaymentOptionPartialUpfront,
		PaymentOptionAllUpfront,
		PaymentOptionLightUtilization,
		PaymentOptionMediumUtilization,
		PaymentOptionHeavyUtilization,
	}
}

const (
	// PlatformDifferenceHypervisor is a PlatformDifference enum value
	PlatformDifferenceHypervisor = "HYPERVISOR"

	// PlatformDifferenceNetworkInterface is a PlatformDifference enum value
	PlatformDifferenceNetworkInterface = "NETWORK_INTERFACE"

	// PlatformDifferenceStorageInterface is a PlatformDifference enum value
	PlatformDifferenceStorageInterface = "STORAGE_INTERFACE"

	// PlatformDifferenceInstanceStoreAvailability is a PlatformDifference enum value
	PlatformDifferenceInstanceStoreAvailability = "INSTANCE_STORE_AVAILABILITY"

	// PlatformDifferenceVirtualizationType is a PlatformDifference enum value
	PlatformDifferenceVirtualizationType = "VIRTUALIZATION_TYPE"
)

// PlatformDifference_Values returns all elements of the PlatformDifference enum
func PlatformDifference_Values() []string {
	return []string{
		PlatformDifferenceHypervisor,
		PlatformDifferenceNetworkInterface,
		PlatformDifferenceStorageInterface,
		PlatformDifferenceInstanceStoreAvailability,
		PlatformDifferenceVirtualizationType,
	}
}

const (
	// RecommendationTargetSameInstanceFamily is a RecommendationTarget enum value
	RecommendationTargetSameInstanceFamily = "SAME_INSTANCE_FAMILY"

	// RecommendationTargetCrossInstanceFamily is a RecommendationTarget enum value
	RecommendationTargetCrossInstanceFamily = "CROSS_INSTANCE_FAMILY"
)

// RecommendationTarget_Values returns all elements of the RecommendationTarget enum
func RecommendationTarget_Values() []string {
	return []string{
		RecommendationTargetSameInstanceFamily,
		RecommendationTargetCrossInstanceFamily,
	}
}

const (
	// RightsizingTypeTerminate is a RightsizingType enum value
	RightsizingTypeTerminate = "TERMINATE"

	// RightsizingTypeModify is a RightsizingType enum value
	RightsizingTypeModify = "MODIFY"
)

// RightsizingType_Values returns all elements of the RightsizingType enum
func RightsizingType_Values() []string {
	return []string{
		RightsizingTypeTerminate,
		RightsizingTypeModify,
	}
}

const (
	// SavingsPlansDataTypeAttributes is a SavingsPlansDataType enum value
	SavingsPlansDataTypeAttributes = "ATTRIBUTES"

	// SavingsPlansDataTypeUtilization is a SavingsPlansDataType enum value
	SavingsPlansDataTypeUtilization = "UTILIZATION"

	// SavingsPlansDataTypeAmortizedCommitment is a SavingsPlansDataType enum value
	SavingsPlansDataTypeAmortizedCommitment = "AMORTIZED_COMMITMENT"

	// SavingsPlansDataTypeSavings is a SavingsPlansDataType enum value
	SavingsPlansDataTypeSavings = "SAVINGS"
)

// SavingsPlansDataType_Values returns all elements of the SavingsPlansDataType enum
func SavingsPlansDataType_Values() []string {
	return []string{
		SavingsPlansDataTypeAttributes,
		SavingsPlansDataTypeUtilization,
		SavingsPlansDataTypeAmortizedCommitment,
		SavingsPlansDataTypeSavings,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// SubscriberStatusConfirmed is a SubscriberStatus enum value
	SubscriberStatusConfirmed = "CONFIRMED"

	// SubscriberStatusDeclined is a SubscriberStatus enum value
	SubscriberStatusDeclined = "DECLINED"
)

// SubscriberStatus_Values returns all elements of the SubscriberStatus enum
func SubscriberStatus_Values() []string {
	return []string{
		SubscriberStatusConfirmed,
		SubscriberStatusDeclined,
	}
}

const (
	// SubscriberTypeEmail is a SubscriberType enum value
	SubscriberTypeEmail = "EMAIL"

	// SubscriberTypeSns is a SubscriberType enum value
	SubscriberTypeSns = "SNS"
)

// SubscriberType_Values returns all elements of the SubscriberType enum
func SubscriberType_Values() []string {
	return []string{
		SubscriberTypeEmail,
		SubscriberTypeSns,
	}
}

const (
	// SupportedSavingsPlansTypeComputeSp is a SupportedSavingsPlansType enum value
	SupportedSavingsPlansTypeComputeSp = "COMPUTE_SP"

	// SupportedSavingsPlansTypeEc2InstanceSp is a SupportedSavingsPlansType enum value
	SupportedSavingsPlansTypeEc2InstanceSp = "EC2_INSTANCE_SP"

	// SupportedSavingsPlansTypeSagemakerSp is a SupportedSavingsPlansType enum value
	SupportedSavingsPlansTypeSagemakerSp = "SAGEMAKER_SP"
)

// SupportedSavingsPlansType_Values returns all elements of the SupportedSavingsPlansType enum
func SupportedSavingsPlansType_Values() []string {
	return []string{
		SupportedSavingsPlansTypeComputeSp,
		SupportedSavingsPlansTypeEc2InstanceSp,
		SupportedSavingsPlansTypeSagemakerSp,
	}
}

const (
	// TermInYearsOneYear is a TermInYears enum value
	TermInYearsOneYear = "ONE_YEAR"

	// TermInYearsThreeYears is a TermInYears enum value
	TermInYearsThreeYears = "THREE_YEARS"
)

// TermInYears_Values returns all elements of the TermInYears enum
func TermInYears_Values() []string {
	return []string{
		TermInYearsOneYear,
		TermInYearsThreeYears,
	}
}
