/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Layout;
import javax.microedition.lcdui.TaGLayout;

public class ImageItem
extends Item {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    private Image img;
    private String altText;
    private int layout;

    public ImageItem(String label, Image img, int layout, String altText) {
        super(label);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.layouts = new Layout[1];
            this.setImageImpl(img);
            this.setLayoutImpl(layout);
            this.setAltTextImpl(altText);
        }
    }

    public Image getImage() {
        return this.img;
    }

    public void setImage(Image img) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setImageImpl(img);
            this.handleContentChanged();
        }
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String text) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setAltTextImpl(text);
            this.handleContentChanged();
        }
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setLayoutImpl(layout);
            this.handleContentChanged();
        }
    }

    public void setLabel(String label) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.setLabel(label);
            this.handleContentChanged();
        }
    }

    boolean isGrouped(Item item) {
        if (item != null && item.isGroupable()) {
            return item.layouts[0] == this.layouts[0];
        }
        return false;
    }

    boolean isGroupable() {
        return true;
    }

    boolean takesFocus() {
        return false;
    }

    int getHeight() {
        if (this.layouts[0] == null) {
            return 0;
        }
        return this.layouts[0].getHeight();
    }

    int setWidth(int width) {
        if (this.layouts[0] == null) {
            return 0;
        }
        return this.layouts[0].setWidth(width);
    }

    void paint(Graphics g) {
        if (this.layouts[0] != null) {
            this.layouts[0].paint(g, true, false);
        }
    }

    private void setImageImpl(Image img) {
        if (img != null && img.isMutable()) {
            throw new IllegalArgumentException();
        }
        this.img = img;
    }

    private void setLayoutImpl(int layout) {
        int allowedLayout = 771;
        if ((layout & ~allowedLayout) != 0) {
            throw new IllegalArgumentException();
        }
        this.layout = layout;
    }

    private void setAltTextImpl(String text) {
        this.altText = text;
    }

    private void handleContentChanged() {
        if (!this.initLayoutDone() || this.layouts[0] == null) {
            return;
        }
        this.contentChanged(0, 0, ((TaGLayout)this.layouts[0]).itemContentChanged(this));
    }
}

