/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRational;
import org.jruby.ast.LiteralValue;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NumericNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.runtime.builtin.IRubyObject;

public class RationalNode
extends NumericNode
implements LiteralValue,
SideEffectFree {
    private final NumericNode numerator;
    private final NumericNode denominator;

    public RationalNode(int line, NumericNode numerator2, NumericNode denominator2) {
        super(line);
        this.numerator = numerator2;
        this.denominator = denominator2;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitRationalNode(this);
    }

    @Override
    public NumericNode negate() {
        return new RationalNode(this.getLine(), this.numerator.negate(), this.denominator);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.numerator, (Node)this.denominator);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RATIONALNODE;
    }

    public NumericNode getNumerator() {
        return this.numerator;
    }

    public NumericNode getDenominator() {
        return this.denominator;
    }

    @Override
    public IRubyObject literalValue(Ruby runtime2) {
        return RubyRational.newRationalCanonicalize(runtime2.getCurrentContext(), this.numerator.literalValue(runtime2), this.denominator.literalValue(runtime2));
    }
}

