
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 * Some of the code in this file was copied from the xine-ui project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: mutex.c 2430 2007-07-04 13:25:56Z mschwerin $
 *
 */

#include "config.h"

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "logger.h"
#include "mutex.h"

#if defined (DEBUG_THREADS)


int
_mutex_lock (pthread_mutex_t * mutex, char *file, int line)
{
    int c = 0;
    int ret;

    _log (LEVEL_DEBUG, file, line,
          "Thread '0x%X' is waiting for lock on mutex '0x%X'.",
          (int) pthread_self (), mutex);

    while ((ret = pthread_mutex_trylock (mutex)) == EBUSY) {
        if (c == 10000) {
            _log (LEVEL_FATAL, file, line,
                  "Thread '0x%X' seems to be blocked on mutex '0x%X'!",
                  (int) pthread_self (), mutex);
            abort ();
        }
        c++;
        usleep (1000);
    }

    _log (LEVEL_DEBUG, file, line,
          "Thread '0x%X' aquired lock on mutex '0x%X'.",
          (int) pthread_self (), mutex);
    _log (LEVEL_DEBUG, file, line,
          "Mutex '0x%X' has a locking count of %d.",
          mutex, mutex->__data.__count);

    return ret;
}


int
_mutex_unlock (pthread_mutex_t * mutex, char *file, int line)
{
    int ret = pthread_mutex_unlock (mutex);

    _log (LEVEL_DEBUG, file, line,
          "Thread '0x%X' released lock on mutex '0x%X'.",
          (int) pthread_self (), mutex);
    _log (LEVEL_DEBUG, file, line,
          "Mutex '0x%X' has a locking count of %d.",
          mutex, mutex->__data.__count);

    return ret;
}


#elif defined (DEBUG)


/**
 * In debug mode we try to get a lock on a mutex for 10 seconds. If locking
 * was not successful in that time, we print an error message and call
 * <code>pthread_mutex_lock</code> just to be sure. This may result in a few
 * false alarms, but at least we get an error message if the mutex is infact
 * blocked.
 */
int
_mutex_lock (pthread_mutex_t * mutex, char *file, int line)
{
    int c = 0;
    int ret;
    while ((ret = pthread_mutex_trylock (mutex)) == EBUSY) {
        if (c == 10000) {
            _log (LEVEL_FATAL, file, line,
                  "Thread '0x%X' seems to be blocked on mutex '0x%X'!",
                  (int) pthread_self (), mutex);
            ret = pthread_mutex_lock (mutex);
            _log (LEVEL_DEBUG, file, line,
                  "Thread '0x%X' was NOT blocked on mutex '0x%X' after all.",
                  (int) pthread_self (), mutex);
            _log (LEVEL_DEBUG, file, line,
                  "Wait a bit longer before screaming next time will ya!");
            return ret;
        }
        c++;
        usleep (1000);
    }
    return ret;
}


#endif
