
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: extractor.h 2583 2007-07-22 13:53:06Z mschwerin $
 *
 */

#ifndef HAVE_EXTRACTOR_H
#define HAVE_EXTRACTOR_H

#include "oxine.h"
#include "filelist.h"
#include "types.h"

#ifdef HAVE_EXTRACTOR

void extractor_init (void);
void extractor_free (void);

bool extractor_start (int num, fileitem_t ** fileitems);
bool extractor_stop (void);
void extractor_pause (void);

bool extractor_is_running (void);

filelist_t *extractor_get_list (void);

int extractor_get_length_all (void);
int extractor_get_progress_all (void);

int extractor_get_length_cur (void);
int extractor_get_progress_cur (void);

bool extractor_is_paused (void);

#endif /* HAVE_EXTRACTOR */
#endif /* HAVE_EXTRACTOR_H */
