
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: codeset.h 1591 2006-11-27 16:22:40Z mschwerin $
 */

#ifndef HAVE_CHARSET_H
#define HAVE_CHARSET_H
#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_ICONV
#include <iconv.h>
#endif

/// The reencoder structure.
typedef struct {
#ifdef HAVE_ICONV
    iconv_t id;
#else
    int id;
#endif
} recode_t;


/// Returns a string representing the current system encoding.
/**
 * @returns                     A string representing the current system
 *                              encoding. This string must be freed after use.
 */
char *get_system_encoding (void);


/// Initialize the reencoder.
/**
 * @param src_encoding          A string representing the source encoding.
 * @param dst_encoding          A string representing the destination encoding.
 */
recode_t *recode_init (const char *src_encoding, const char *dst_encoding);


/// Frees the specified reencoder structure.
/**
 * @param xr                    The reencoder structure.
 */
void recode_done (recode_t * xr);


/// Reencodes a string.
/**
 * @param xr                    The reencoder structure.
 * @param src                   The original string.
 * @returns                     The converted string. This string must be
 *                              freed after use.
 */
char *recode (recode_t * xr, const char *src);

#ifdef __cplusplus
}
#endif
#endif
