/*
 *
 * Copyright (c) 2011-2016 The University of Waikato, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This file is part of libprotoident.
 *
 * This code has been developed by the University of Waikato WAND
 * research group. For further information please see http://www.wand.net.nz/
 *
 * libprotoident is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * libprotoident is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include <string.h>

#include "libprotoident.h"
#include "proto_manager.h"
#include "proto_common.h"

/* VxWorks exposes a system-level debugger over UDP port 17185 which can be
 * exploited remotely. Most traffic I've seen trying to access this port is
 * actually critical.io poking around looking for vulnerable machines in the
 * interests of finding ISPs that are putting their customers at risk.
 *
 * So if you see this traffic, it is not necessarily bad (as long as the 
 * recipient is not responding to the probe packet!).
 */

static inline bool match_vxworks_exploit(lpi_data_t *data, lpi_module_t *mod UNUSED) {

	if (data->server_port != 17185 && data->client_port != 17185)
		return false;

	/* Payload sent by critical.io */
	if (MATCH(data->payload[0], 0x1a, 0x09, 0xfa, 0xba)) {
		if (data->payload_len[0] == 64)
			return true;
	}

	if (MATCH(data->payload[1], 0x1a, 0x09, 0xfa, 0xba)) {
		if (data->payload_len[1] == 64)
			return true;
	}
	return false;
}

static lpi_module_t lpi_vxworks_exploit = {
	LPI_PROTO_UDP_VXWORKS_EXPLOIT,
	LPI_CATEGORY_MALWARE,
	"VxWorks_Exploit",
	14,
	match_vxworks_exploit
};

void register_vxworks_exploit(LPIModuleMap *mod_map) {
	register_protocol(&lpi_vxworks_exploit, mod_map);
}

