/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Damien Vincent

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/**************************** malloc wrapper for alignment ***********************************/

#define ALIGN 32

#include <stdlib.h>

void* fame_malloc(size_t size)
{
  unsigned char *ptr, *aligned, *padding;
  
  /* Struture of fame_alloc :
   * -> byte0     = padding[0]                             --> ptr
   * -> ...
   * -> byte(n-1) = padding[n-1]
   * -> byten     = n                                      --> padding
   * -> byte(n+1) = first element of the array (aligned)   --> aligned
   * -> ...
   */  

  ptr = (unsigned char*) malloc(size+ALIGN);
  aligned = (unsigned char*) (((unsigned int)ptr & (~(ALIGN-1))) + ALIGN );
  padding = aligned - 1;
  *padding = (ALIGN-1) - ((unsigned int)ptr & (ALIGN-1));

  return ((void*)aligned);
}



void fame_free(void* aligned)
{
  unsigned char *ptr, *padding;

  /* Use char* arithmetic, as void* arithm. is illecal in ANSI C. */
  padding = ((unsigned char*)aligned) - 1;
  ptr  = padding - (*padding);

  free(ptr);
}
