#
# Funky font stuff...
#
# $Id: font.tcl,v 1.3 2011/02/17 11:25:55 rader Exp $
#

###############################################################################

proc GetFontGeom { } { 
  global font_width font_height fixed_width_font debug

  set af [.t.lb cget -font]
  set m [font metrics $af]
  set as [lindex $m 1] ;# ascent
  set ds [lindex $m 3] ;# descent
  set font_height [expr $as + $ds]
  set w1 [font measure $af "*"]
  set w2 [font measure $af "."]
  if { $w1 == $w2 } {
    set fixed_width_font 1
  } else { 
    set fixed_width_font 0
    puts "Warning!  Font is not fixed-width.  Columns will not align."
  }
  set font_width $w1
  if { $debug } { puts "GetFontGeom: $af is ${font_width}x$font_height" }
}

###############################################################################

proc CreateBoldFont { } {
  global debug

  set af [.t.lb cget -font]
  set font_descr [font actual $af]
  set fm [lindex $font_descr 1]
  set sz [lindex $font_descr 3]
  set sl [lindex $font_descr 7]

  if { $debug } { puts "CreateBoldFont: NORMAL FONT $font_descr" }
  font create bold_font -family $fm -size $sz -weight bold -slant $sl -underline 0 -overstrike 0
  if { $debug } { puts "CreateBoldFont: BOLD FONT [font actual bold_font]" }

  # FIXME there are cases where this actually produces a normal font with a different width... 
  # FIXME bail on creating a bold font when new family size weight or slant differs...
  .t.lb tag configure tag_bold -font bold_font

}

