/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Unknown;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;

class BcelAttributes {
    BcelAttributes() {
    }

    public static List readAjAttributes(String classname, Attribute[] as, ISourceContext context, IMessageHandler msgHandler) {
        ArrayList<AjAttribute> l = new ArrayList<AjAttribute>();
        AjAttribute.WeaverVersionInfo version = new AjAttribute.WeaverVersionInfo();
        for (int i = as.length - 1; i >= 0; --i) {
            Unknown u;
            String name;
            Attribute a = as[i];
            if (!(a instanceof Unknown) || !(name = (u = (Unknown)a).getName()).startsWith("org.aspectj.weaver")) continue;
            AjAttribute attr = AjAttribute.read(version, name, u.getBytes(), context, msgHandler);
            if (attr != null && attr instanceof AjAttribute.WeaverVersionInfo && (version = (AjAttribute.WeaverVersionInfo)attr).getMajorVersion() > AjAttribute.WeaverVersionInfo.getCurrentWeaverMajorVersion()) {
                throw new BCException("Unable to continue, this version of AspectJ supports classes built with weaver version " + AjAttribute.WeaverVersionInfo.toCurrentVersionString() + " but the class " + classname + " is version " + version.toString());
            }
            if (attr == null) continue;
            l.add(attr);
        }
        return l;
    }

    public static Attribute bcelAttribute(AjAttribute a, ConstantPoolGen pool) {
        int nameIndex = pool.addUtf8(a.getNameString());
        byte[] bytes = a.getBytes();
        int length = bytes.length;
        return new Unknown(nameIndex, length, bytes, pool.getConstantPool());
    }
}

