/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.eval;

import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.eval.CodeSnippetCodeStream;
import org.aspectj.org.eclipse.jdt.internal.eval.CodeSnippetScope;
import org.aspectj.org.eclipse.jdt.internal.eval.CodeSnippetThisReference;
import org.aspectj.org.eclipse.jdt.internal.eval.EvaluationConstants;
import org.aspectj.org.eclipse.jdt.internal.eval.EvaluationContext;

public class CodeSnippetMessageSend
extends MessageSend
implements ProblemReasons,
EvaluationConstants {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetMessageSend(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.codegenBinding.canBeSeenBy(this.actualReceiverType, this, currentScope)) {
            boolean isStatic = this.codegenBinding.isStatic();
            if (!isStatic && (this.bits & 0x1FE0) != 0) {
                ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                Object[] path = currentScope.getEmulationPath(targetType, true, false);
                if (path == null) {
                    currentScope.problemReporter().needImplementation();
                } else {
                    codeStream.generateOuterAccess(path, this, targetType, currentScope);
                }
            } else {
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
            }
            if (this.arguments != null) {
                int i = 0;
                int max = this.arguments.length;
                while (i < max) {
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    ++i;
                }
            }
            if (isStatic) {
                codeStream.invokestatic(this.codegenBinding);
            } else if (this.receiver.isSuper()) {
                codeStream.invokespecial(this.codegenBinding);
            } else if (this.codegenBinding.declaringClass.isInterface()) {
                codeStream.invokeinterface(this.codegenBinding);
            } else {
                codeStream.invokevirtual(this.codegenBinding);
            }
        } else {
            ((CodeSnippetCodeStream)codeStream).generateEmulationForMethod(currentScope, this.codegenBinding);
            boolean isStatic = this.codegenBinding.isStatic();
            if (!isStatic && (this.bits & 0x1FE0) != 0) {
                currentScope.problemReporter().needImplementation();
            } else {
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
            }
            if (isStatic) {
                codeStream.aconst_null();
            }
            if (this.arguments != null) {
                int argsLength = this.arguments.length;
                codeStream.generateInlinedValue(argsLength);
                codeStream.newArray(currentScope.createArrayType(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT, 3), 1));
                codeStream.dup();
                int i = 0;
                while (i < argsLength) {
                    codeStream.generateInlinedValue(i);
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    TypeBinding parameterBinding = this.codegenBinding.parameters[i];
                    if (parameterBinding.isBaseType() && parameterBinding != BaseTypes.NullBinding) {
                        ((CodeSnippetCodeStream)codeStream).generateObjectWrapperForType(this.codegenBinding.parameters[i]);
                    }
                    codeStream.aastore();
                    if (i < argsLength - 1) {
                        codeStream.dup();
                    }
                    ++i;
                }
            } else {
                codeStream.generateInlinedValue(0);
                codeStream.newArray(currentScope.createArrayType(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT, 3), 1));
            }
            ((CodeSnippetCodeStream)codeStream).invokeJavaLangReflectMethodInvoke();
            if (this.codegenBinding.returnType.isBaseType()) {
                int typeID = this.codegenBinding.returnType.id;
                if (typeID == 6) {
                    codeStream.pop();
                }
                ((CodeSnippetCodeStream)codeStream).checkcast(typeID);
                ((CodeSnippetCodeStream)codeStream).getBaseTypeValue(typeID);
            } else {
                codeStream.checkcast(this.codegenBinding.returnType);
            }
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            switch (this.codegenBinding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.codegenBinding != this.binding && this.codegenBinding.returnType.isTypeVariable()) {
            TypeVariableBinding variableReturnType = (TypeVariableBinding)this.codegenBinding.returnType;
            if (variableReturnType.firstBound != this.binding.returnType) {
                this.valueCast = this.binding.returnType;
            }
        }
        if (!(this.binding.declaringClass == this.actualReceiverType || this.actualReceiverType.isArrayType() || (currentScope.environment().options.targetJDK < 0x2E0000L || this.receiver.isImplicitThis() && this.codegenBinding.isStatic() || this.binding.declaringClass.id == 1) && this.codegenBinding.declaringClass.canBeSeenBy(currentScope))) {
            this.codegenBinding = currentScope.enclosingSourceType().getUpdatedMethodBinding(this.codegenBinding, (ReferenceBinding)this.actualReceiverType.erasure());
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = ASTNode.NotAConstant;
        this.actualReceiverType = this.receiver.resolveType(scope);
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                argumentTypes[i] = this.arguments[i].resolveType(scope);
                if (argumentTypes[i] == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? scope.getImplicitMethod(this.selector, argumentTypes, this) : scope.getMethod(this.actualReceiverType, this.selector, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding instanceof ProblemMethodBinding && ((ProblemMethodBinding)this.binding).problemId() == 2) {
                MethodBinding privateBinding;
                if (this.evaluationContext.declaringTypeName != null) {
                    this.delegateThis = scope.getField(scope.enclosingSourceType(), EvaluationConstants.DELEGATE_THIS, this);
                    if (this.delegateThis == null) {
                        this.constant = ASTNode.NotAConstant;
                        scope.problemReporter().invalidMethod(this, this.binding);
                        return null;
                    }
                } else {
                    this.constant = ASTNode.NotAConstant;
                    scope.problemReporter().invalidMethod(this, this.binding);
                    return null;
                }
                CodeSnippetScope localScope = new CodeSnippetScope(scope);
                MethodBinding methodBinding2 = privateBinding = this.receiver instanceof CodeSnippetThisReference && ((CodeSnippetThisReference)this.receiver).isImplicit ? localScope.getImplicitMethod((ReferenceBinding)this.delegateThis.type, this.selector, argumentTypes, this) : localScope.getMethod(this.delegateThis.type, this.selector, argumentTypes, this);
                if (!privateBinding.isValidBinding()) {
                    if (this.binding.declaringClass == null) {
                        if (this.actualReceiverType instanceof ReferenceBinding) {
                            this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                        } else {
                            scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
                            return null;
                        }
                    }
                    scope.problemReporter().invalidMethod(this, this.binding);
                    return null;
                }
                this.binding = privateBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    if (this.actualReceiverType instanceof ReferenceBinding) {
                        this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                    } else {
                        scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
                        return null;
                    }
                }
                scope.problemReporter().invalidMethod(this, this.binding);
                return null;
            }
        }
        if (!this.binding.isStatic() && this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0) {
            scope.problemReporter().mustUseAStaticMethod(this, this.binding);
            return null;
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                this.arguments[i].computeConversion(scope, this.binding.parameters[i], argumentTypes[i]);
                ++i;
            }
        }
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            scope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
            return null;
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        this.resolvedType = this.binding.returnType;
        return this.resolvedType;
    }
}

