/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.SimpleElementValue;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.annotation.ElementValueGen;

public class SimpleElementValueGen
extends ElementValueGen {
    private int idx;

    protected SimpleElementValueGen(int type, int idx, ConstantPoolGen cpGen) {
        super(type, cpGen);
        this.idx = idx;
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, int value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, long value) {
        super(type, cpGen);
        this.idx = cpGen.addLong(value);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, double value) {
        super(type, cpGen);
        this.idx = cpGen.addDouble(value);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, float value) {
        super(type, cpGen);
        this.idx = cpGen.addFloat(value);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, short value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, byte value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, char value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, boolean value) {
        super(type, cpGen);
        this.idx = value ? cpGen.addInteger(1) : cpGen.addInteger(0);
    }

    public SimpleElementValueGen(int type, ConstantPoolGen cpGen, String value) {
        super(type, cpGen);
        this.idx = cpGen.addUtf8(value);
    }

    public SimpleElementValueGen(SimpleElementValue value, ConstantPoolGen cpool, boolean copyPoolEntries) {
        super(value.getElementValueType(), cpool);
        if (!copyPoolEntries) {
            this.idx = value.getIndex();
        } else {
            switch (value.getElementValueType()) {
                case 115: {
                    this.idx = cpool.addUtf8(value.getValueString());
                    break;
                }
                case 73: {
                    this.idx = cpool.addInteger(value.getValueInt());
                    break;
                }
                case 66: {
                    this.idx = cpool.addInteger(value.getValueByte());
                    break;
                }
                case 67: {
                    this.idx = cpool.addInteger(value.getValueChar());
                    break;
                }
                case 74: {
                    this.idx = cpool.addLong(value.getValueLong());
                    break;
                }
                case 70: {
                    this.idx = cpool.addFloat(value.getValueFloat());
                    break;
                }
                case 68: {
                    this.idx = cpool.addDouble(value.getValueDouble());
                    break;
                }
                case 90: {
                    if (value.getValueBoolean()) {
                        this.idx = cpool.addInteger(1);
                        break;
                    }
                    this.idx = cpool.addInteger(0);
                    break;
                }
                case 83: {
                    this.idx = cpool.addInteger(value.getValueShort());
                    break;
                }
                default: {
                    throw new RuntimeException("SimpleElementValueGen class does not know how to copy this type " + this.type);
                }
            }
        }
    }

    public int getIndex() {
        return this.idx;
    }

    public String getValueString() {
        if (this.type != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 c = (ConstantUtf8)this.cpGen.getConstant(this.idx);
        return c.getBytes();
    }

    public int getValueInt() {
        if (this.type != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger c = (ConstantInteger)this.cpGen.getConstant(this.idx);
        return c.getBytes();
    }

    public String stringifyValue() {
        switch (this.type) {
            case 73: {
                ConstantInteger c = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(c.getBytes());
            }
            case 74: {
                ConstantLong j = (ConstantLong)this.cpGen.getConstant(this.idx);
                return Long.toString(j.getBytes());
            }
            case 68: {
                ConstantDouble d = (ConstantDouble)this.cpGen.getConstant(this.idx);
                return Double.toString(d.getBytes());
            }
            case 70: {
                ConstantFloat f = (ConstantFloat)this.cpGen.getConstant(this.idx);
                return Float.toString(f.getBytes());
            }
            case 83: {
                ConstantInteger s = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(s.getBytes());
            }
            case 66: {
                ConstantInteger b = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(b.getBytes());
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(ch.getBytes());
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)this.cpGen.getConstant(this.idx);
                if (bo.getBytes() == 0) {
                    return "false";
                }
                if (bo.getBytes() != 0) {
                    return "true";
                }
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)this.cpGen.getConstant(this.idx);
                return cu8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + this.type);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        switch (this.type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dos.writeShort(this.idx);
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen doesnt know how to write out type " + this.type);
            }
        }
    }
}

