/*  Singleplayer levels.
    Copyright (C) 2006  Morten Hustveit <morten@rashbox.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

static struct
{
  enum game_mode mode;
  unsigned int seed;
  unsigned int time;
  unsigned int shoot_bonus;
  unsigned int has_joker;
  unsigned char colors[7 * 8 + 7 * 7];
} levels[] =
{
  { /* 0 */
    mode : GM_TIME_ATTACK,
    seed : 0,
    time : 150,
    colors: {
      1,2,3,4,5,6,7,8,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 1 */
    mode : GM_TIME_ATTACK,
    seed : 100,
    time : 300,
    colors : {
      1,2,1,2,1,2,1,2,
       3,4,3,4,3,4,3,
      1,2,1,2,1,2,1,2,
       3,4,3,4,3,4,3,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 2 */
    mode : GM_TIME_ATTACK,
    seed : 150,
    time : 5,
    shoot_bonus : 2,
    colors : {
      1,4,2,1,3,2,4,3,
       1,0,2,0,3,0,4,
      5,1,5,2,5,3,5,4,
       0,6,0,6,0,6,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 3 */
    mode : GM_AVALANCHE,
    seed : 200,
    time : 6,
    colors: {
      1,2,1,3,1,3,1,2,
       6,7,0,0,0,7,6,
      0,0,8,0,0,8,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 9 */
    mode : GM_TIME_ATTACK,
    seed : 500,
    time : 400,
    has_joker : 1,
    colors: {
      2,3,4,3,3,4,3,2,
       2,3,9,9,9,3,2,
      6,7,5,2,3,5,7,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 10 */
    mode : GM_TIME_ATTACK,
    seed : 550,
    time : 400,
    has_joker : 1,
    colors: {
      6,2,2,3,3,2,2,6,
       1,2,8,9,6,2,1,
      5,9,7,7,7,7,9,5,
       0,2,9,5,9,2,0,
      1,2,1,2,1,2,1,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 11 */
    mode : GM_TIME_ATTACK,
    seed : 600,
    time : 400,
    colors: {
      5,4,6,4,5,6,4,5,
       1,3,2,3,1,2,3,
      4,7,5,5,7,4,5,7,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 12 */
    mode : GM_TIME_ATTACK,
    seed : 650,
    time : 400,
    colors: {
      1,1,1,5,5,5,6,6,
       0,2,2,2,7,7,6,
      0,0,0,3,3,3,8,8,
       0,0,0,0,4,4,4,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 6 */
    mode : GM_GRAVITY,
    seed : 350,
    colors: {
      7,6,7,5,6,7,5,6,
       7,6,5,7,6,5,6,
      1,2,3,1,2,3,1,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 13 */
    mode : GM_TIME_ATTACK,
    seed : 700,
    time : 400,
    colors: {
      1,2,3,4,5,6,7,0,
       0,0,0,0,0,0,8,
      0,6,5,4,3,2,1,0,
       7,0,0,0,0,0,0,
      0,8,1,2,3,4,5,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 14 */
    mode : GM_TIME_ATTACK,
    seed : 750,
    time : 400,
    colors: {
      3,1,4,1,5,1,3,1,
       4,3,5,5,3,5,4,
      0,5,0,3,0,4,0,5,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 15 */
    mode : GM_TIME_ATTACK,
    seed : 800,
    time : 400,
    colors: {
      6,7,7,8,8,7,7,6,
       1,0,0,8,0,0,1,
      0,2,0,8,8,0,2,0,
       5,2,0,8,0,2,5,
      0,0,3,4,4,3,0,0,
       0,0,0,5,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 8 */
    mode : GM_INV_GRAVITY,
    seed : 450,
    colors: {
      1,2,3,4,4,3,2,1,
       5,4,3,2,3,4,5,
      5,0,0,1,1,0,0,5,
       0,0,0,8,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 16 */
    mode : GM_TIME_ATTACK,
    seed : 850,
    time : 400,
    colors: {
      5,5,2,2,3,3,8,8,
       6,6,1,1,4,4,7,
      7,7,8,8,5,5,6,6,
       0,3,0,3,0,3,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 4 */
    mode : GM_AVALANCHE,
    seed : 250,
    time : 5,
    colors: {
      1,1,2,2,3,3,4,4,
       8,7,7,6,6,5,5,
      8,1,1,2,2,3,3,4,
       0,5,0,5,0,5,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 17 */
    mode : GM_TIME_ATTACK,
    seed : 900,
    time : 400,
    colors: {
      3,0,3,0,3,0,3,0,
       1,2,1,2,1,2,1,
      0,4,0,4,0,4,0,4,
       5,6,5,6,5,6,5,
      0,7,0,7,0,7,0,7,
       8,4,8,4,8,4,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 18 */
    mode : GM_TIME_ATTACK,
    seed : 950,
    time : 300,
    colors: {
      8,8,7,7,8,8,7,7,
       1,0,1,0,1,0,1,
      0,2,0,2,0,2,0,2,
       0,3,3,0,3,3,0,
      0,0,0,4,4,0,0,0,
       0,0,0,5,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 19 */
    mode : GM_TIME_ATTACK,
    seed : 1000,
    time : 300,
    colors: {
      0,0,5,1,1,5,0,0,
       0,0,6,2,6,0,0,
      0,0,3,3,3,3,0,0,
       0,6,5,4,5,6,0,
      8,7,0,0,0,0,7,8,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 20 */
    mode : GM_TIME_ATTACK,
    seed : 1050,
    time : 400,
    colors: {
      4,5,6,0,0,6,5,4,
       0,7,8,1,8,7,0,
      2,2,0,0,0,0,2,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 21 */
    mode : GM_TIME_ATTACK,
    seed : 1100,
    time : 300,
    has_joker : 1,
    colors: {
      9,2,1,3,3,1,2,9,
       3,4,0,5,0,4,3,
      1,7,9,0,0,9,7,1,
       2,0,0,0,0,0,2,
      0,3,0,0,0,0,3,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 22 */
    mode : GM_TIME_ATTACK,
    seed : 1150,
    time : 300,
    colors: {
      3,2,4,7,7,4,2,3,
       0,8,8,5,8,8,0,
      1,4,0,6,6,0,1,1,
       0,5,5,0,5,5,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 23 */
    mode : GM_TIME_ATTACK,
    seed : 1200,
    time : 300,
    colors: {
      2,4,6,8,8,6,5,2,
       2,4,5,7,5,4,2,
      0,2,3,5,5,3,2,0,
       0,2,3,5,3,2,0,
      0,0,1,3,3,1,0,0,
       0,0,1,3,1,0,0,
      0,0,0,1,1,0,0,0,
       0,0,0,1,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 24 */
    mode : GM_TIME_ATTACK,
    seed : 1250,
    time : 300,
    colors: {
      0,6,5,1,1,5,6,0,
       0,6,5,1,5,6,0,
      2,7,4,3,3,4,8,2,
       1,7,5,6,5,8,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 25 */
    mode : GM_TIME_ATTACK,
    seed : 1300,
    time : 400,
    colors: {
      1,0,0,0,0,0,0,1,
       2,0,0,0,0,0,2,
      3,0,0,0,0,0,0,3,
       4,0,0,0,0,0,4,
      5,0,0,0,0,0,0,5,
       6,0,0,0,0,0,6,
      7,0,0,0,0,0,0,7,
       8,0,0,0,0,0,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 5 */
    mode : GM_AVALANCHE,
    seed : 300,
    time : 10,
    colors: {
      0,1,0,2,0,3,0,4,
       8,0,7,0,6,0,5,
      0,1,0,2,0,3,0,4,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 26 */
    mode : GM_TIME_ATTACK,
    seed : 1350,
    time : 400,
    colors: {
      1,3,8,8,8,8,7,1,
       2,4,8,8,8,6,2,
      0,1,5,8,8,5,1,0,
       0,0,6,8,4,0,0,
      0,0,0,7,3,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 27 */
    mode : GM_TIME_ATTACK,
    seed : 1400,
    time : 400,
    colors: {
      3,4,1,5,5,1,4,3,
       0,8,7,6,7,8,0,
      2,5,4,0,0,5,4,2,
       0,0,3,3,3,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 28 */
    mode : GM_TIME_ATTACK,
    seed : 1450,
    time : 300,
    colors: {
      1,1,7,2,2,3,3,7,
       1,1,2,2,7,3,3,
      7,4,4,5,5,7,6,6,
       4,4,7,5,5,6,6,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 29 */
    mode : GM_TIME_ATTACK,
    seed : 1500,
    time : 400,
    colors: {
      5,6,7,8,5,6,7,8,
       3,2,1,4,3,2,1,
      5,5,6,6,5,5,6,6,
       5,0,6,0,5,0,6,
      0,7,7,8,8,7,7,0,
       0,7,0,8,0,7,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 30 */
    mode : GM_TIME_ATTACK,
    seed : 1550,
    time : 120,
    colors: {
      1,0,2,0,4,0,6,0,
       1,0,2,0,4,0,6,
      1,0,2,0,4,0,6,0,
       2,0,3,0,5,0,7,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 31 */
    mode : GM_TIME_ATTACK,
    seed : 1600,
    time : 200,
    colors: {
      7,7,2,3,3,4,5,5,
       7,2,2,3,4,4,5,
      6,6,1,8,8,7,2,2,
       6,1,1,8,7,7,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 32 */
    mode : GM_TIME_ATTACK,
    seed : 1650,
    time : 200,
    colors: {
      6,0,0,4,0,0,1,0,
       6,0,4,3,0,5,1,
      0,2,2,0,3,5,0,7,
       0,0,1,1,0,2,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 33 */
    mode : GM_TIME_ATTACK,
    seed : 1700,
    time : 300,
    colors: {
      0,5,0,8,0,0,0,4,
       2,4,3,7,0,5,6,
      0,0,6,0,2,4,3,0,
       0,2,0,0,3,0,0,
      0,1,0,0,0,0,0,0,
       5,0,0,0,0,0,0,
      3,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 34 */
    mode : GM_TIME_ATTACK,
    seed : 1750,
    time : 200,
    colors: {
      0,0,2,4,2,3,6,2,
       1,3,7,0,0,1,2,
      0,0,7,3,5,0,0,0,
       0,0,8,0,4,3,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 35 */
    mode : GM_TIME_ATTACK,
    seed : 1800,
    time : 300,
    colors: {
      1,7,1,7,1,7,1,7,
       0,0,3,0,0,4,3,
      0,0,0,6,5,4,0,0,
       5,6,1,0,0,2,0,
      0,0,0,0,0,0,6,4,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 36 */
    mode : GM_TIME_ATTACK,
    seed : 1850,
    time : 300,
    colors: {
      5,3,4,6,2,0,0,0,
       0,0,0,4,3,4,6,
      0,0,0,0,1,4,6,2,
       0,0,0,0,0,0,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 37 */
    mode : GM_AVALANCHE,
    seed : 1900,
    time : 6,
    colors: {
      0,0,3,1,2,3,0,0,
       0,0,0,1,2,0,0,
      0,0,0,1,2,0,0,0,
       0,0,0,1,2,0,0,
      4,2,4,2,4,2,4,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 38 */
    mode : GM_TIME_ATTACK,
    seed : 1950,
    time : 500,
    colors: {
      2,3,3,4,1,0,0,0,
       0,0,0,3,4,0,0,
      0,0,0,0,0,3,0,0,
       0,0,0,0,0,2,3,
      0,0,0,0,5,2,6,6,
       0,0,0,0,3,8,0,
      0,0,0,0,0,7,2,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 39 */
    mode : GM_TIME_ATTACK,
    seed : 2000,
    time : 500,
    colors: {
      7,6,5,4,6,5,7,5,
       1,2,3,2,3,1,3,
      6,3,4,6,5,3,6,5,
       0,0,0,2,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 40 */
    mode : GM_TIME_ATTACK,
    seed : 2050,
    time : 400,
    colors: {
      1,0,7,8,8,7,0,1,
       2,6,0,3,0,6,2,
      3,5,0,2,2,0,5,3,
       4,0,0,1,0,0,4,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 41 */
    mode : GM_TIME_ATTACK,
    seed : 2100,
    time : 400,
    colors: {
      4,8,3,0,0,3,8,4,
       0,0,1,2,1,0,0,
      0,0,7,6,7,6,0,0,
       0,8,2,0,2,8,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 42 */
    mode : GM_TIME_ATTACK,
    seed : 2150,
    time : 500,
    colors: {
      1,3,5,2,6,3,4,7,
       2,5,4,3,4,1,6,
      7,4,6,1,3,3,2,3,
       6,8,2,5,4,3,3,
      1,0,0,0,0,0,0,1,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 43 */
    mode : GM_GRAVITY,
    seed : 2200,
    colors: {
      0,1,3,2,2,4,1,0,
       0,6,3,2,4,5,0,
      0,0,6,7,7,5,0,0,
       0,0,8,8,8,0,0,
      0,0,0,1,1,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 44 */
    mode : GM_TIME_ATTACK,
    seed : 2250,
    time : 300,
    colors: {
      1,2,0,0,0,0,1,1,
       1,2,0,0,0,3,2,
      3,3,0,0,0,0,3,2,
       7,6,0,0,0,5,4,
      7,6,0,0,0,0,5,4,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 45 */
    mode : GM_TIME_ATTACK,
    seed : 2300,
    time : 300,
    colors: {
      7,7,7,7,7,7,7,7,
       2,6,6,6,6,6,2,
      0,3,5,5,5,5,3,0,
       0,4,4,4,4,4,0,
      0,0,5,3,3,5,0,0,
       0,0,6,2,6,0,0,
      0,0,0,7,7,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 46 */
    mode : GM_TIME_ATTACK,
    seed : 2350,
    time : 300,
    colors: {
      1,2,3,4,5,3,2,1,
       2,3,5,6,4,3,2,
      2,3,4,7,5,6,3,2,
       3,0,0,0,0,0,3,
      3,0,0,0,0,0,0,3,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 47 */
    mode : GM_TIME_ATTACK,
    seed : 2400,
    time : 300,
    colors: {
      1,0,6,7,6,7,0,1,
       5,0,4,0,3,0,2,
      5,5,4,4,3,3,2,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 48 */
    mode : GM_INV_GRAVITY,
    seed : 2450,
    colors: {
      0,0,1,0,0,1,0,0,
       0,0,2,0,2,0,0,
      0,0,3,0,0,3,0,0,
       0,4,5,0,5,3,0,
      6,7,8,6,7,8,6,7,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 49 */
    mode : GM_TIME_ATTACK,
    seed : 2500,
    time : 300,
    colors: {
      0,0,5,2,2,5,0,0,
       0,0,6,1,6,0,0,
      0,0,3,4,5,6,0,0,
       0,7,8,5,4,3,0,
      0,0,3,6,5,4,0,0,
       0,0,0,8,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 50 */
    mode : GM_TIME_ATTACK,
    seed : 2550,
    time : 300,
    colors: {
      1,2,1,2,1,2,1,2,
       3,0,0,0,0,0,3,
      1,2,1,2,1,2,1,2,
       3,0,0,0,0,0,3,
      1,2,1,2,1,2,1,2,
       3,0,0,0,0,0,3,
      1,2,1,2,1,2,1,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 51 */
    mode : GM_TIME_ATTACK,
    seed : 2600,
    time : 400,
    colors: {
      6,7,8,6,7,8,6,7,
       8,6,7,8,6,7,8,
      3,4,3,4,3,4,3,4,
       1,1,0,7,0,1,1,
      0,1,0,7,7,0,1,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 52 */
    mode : GM_TIME_ATTACK,
    seed : 2650,
    time : 300,
    colors: {
      4,1,5,3,3,4,1,4,
       5,6,2,0,2,5,6,
      5,4,2,0,0,2,4,5,
       4,2,0,0,0,2,4,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 53 */
    mode : GM_TIME_ATTACK,
    seed : 2700,
    time : 40,
    colors: {
      3,2,0,0,0,0,2,3,
       0,3,0,0,0,3,0,
      0,0,2,0,0,2,0,0,
       0,0,3,0,3,0,0,
      0,0,0,2,2,0,0,0,
       0,0,0,3,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 54 */
    mode : GM_AVALANCHE,
    seed : 2750,
    time : 8,
    colors: {
      2,3,4,5,2,3,4,5,
       4,3,2,0,4,3,2,
      0,2,3,0,0,3,3,0,
       0,2,0,0,0,2,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 55 */
    mode : GM_TIME_ATTACK,
    seed : 2800,
    time : 300,
    colors: {
      8,8,4,4,3,3,8,8,
       1,0,1,0,1,0,1,
      0,2,3,2,3,2,3,0,
       3,3,8,8,4,4,8,
      1,0,0,0,0,0,0,1,
       2,0,0,0,0,0,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 56 */
    mode : GM_TIME_ATTACK,
    seed : 2850,
    time : 200,
    colors: {
      6,2,4,0,0,0,0,6,
       0,6,4,2,0,0,6,
      0,0,0,1,3,1,3,0,
       0,0,0,0,2,2,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 57 */
    mode : GM_TIME_ATTACK,
    seed : 2900,
    time : 300,
    colors: {
      4,2,5,2,4,5,2,5,
       5,2,4,5,2,5,4,
      4,5,4,2,4,5,2,4,
       5,2,5,4,2,5,4,
      5,4,2,5,4,5,2,4,
       4,5,5,2,2,4,5,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 58 */
    mode : GM_TIME_ATTACK,
    seed : 2950,
    time : 30,
    colors: {
      0,0,0,0,1,0,0,0,
       0,0,0,2,0,0,0,
      0,0,0,0,1,0,0,0,
       0,0,0,2,0,0,0,
      0,0,0,0,1,0,0,0,
       0,0,0,2,0,0,0,
      0,0,0,0,1,0,0,0,
       0,0,0,2,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 59 */
    mode : GM_TIME_ATTACK,
    seed : 3000,
    time : 60,
    colors: {
      0,0,1,0,0,1,0,0,
       0,2,0,0,2,0,0,
      0,0,1,0,0,1,0,0,
       0,2,0,0,2,0,0,
      0,0,1,0,0,1,0,0,
       0,2,0,0,2,0,0,
      0,0,1,0,0,1,0,0,
       0,2,0,0,2,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 60 */
    mode : GM_TIME_ATTACK,
    seed : 3050,
    time : 120,
    colors: {
      0,1,0,1,0,1,0,1,
       2,0,2,0,2,0,2,
      0,1,0,1,0,1,0,1,
       2,0,2,0,2,0,2,
      0,1,0,1,0,1,0,1,
       2,0,2,0,2,0,2,
      0,1,0,1,0,1,0,1,
       2,0,2,0,2,0,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 61 */
    mode : GM_TIME_ATTACK,
    seed : 3100,
    time : 120,
    colors: {
      1,0,1,0,1,0,1,0,
       2,0,2,0,2,0,2,
      0,1,0,1,0,1,0,1,
       0,2,0,2,0,2,0,
      0,0,1,0,1,0,1,0,
       0,0,2,0,2,0,2,
      0,0,0,1,0,1,0,1,
       0,0,0,2,0,2,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 62 */
    mode : GM_TIME_ATTACK,
    seed : 3150,
    time : 300,
    colors: {
      4,1,6,1,4,1,6,1,
       6,2,4,2,4,2,4,
      2,4,1,6,1,6,1,6,
       1,6,2,4,2,4,2,
      6,2,4,1,6,1,6,1,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 63 */
    mode : GM_TIME_ATTACK,
    seed : 3200,
    time : 150,
    colors: {
      4,3,4,3,4,3,4,4,
       2,1,0,0,0,0,4,
      0,5,0,0,0,0,5,1,
       0,0,0,0,0,5,2,
      0,0,0,0,0,4,3,1,
       0,0,0,0,0,4,2,
      0,0,0,0,0,0,5,3,
       0,0,0,0,0,0,5,
      0,0,0,0,0,0,0,4,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 64 */
    mode : GM_TIME_ATTACK,
    seed : 3250,
    time : 400,
    colors: {
      4,0,4,0,4,0,4,0,
       5,0,5,0,5,0,5,
      0,6,1,6,1,6,1,6,
       0,2,0,2,0,2,0,
      0,3,0,3,0,3,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 65 */
    mode : GM_TIME_ATTACK,
    seed : 3300,
    time : 400,
    colors: {
      0,0,0,1,2,0,0,0,
       0,0,3,4,1,0,0,
      1,3,2,0,0,2,3,1,
       4,1,0,0,0,1,4,
      0,0,2,3,1,4,0,0,
       0,0,0,2,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 66 */
    mode : GM_TIME_ATTACK,
    seed : 3350,
    time : 200,
    colors: {
      0,8,8,0,0,8,8,0,
       0,7,0,0,0,7,0,
      0,8,8,5,5,8,8,0,
       0,7,0,6,0,7,0,
      0,0,0,5,5,0,0,0,
       0,0,0,6,0,0,0,
      0,8,8,5,5,8,8,0,
       0,7,0,0,0,7,0,
      0,8,8,5,5,8,8,0,
       0,7,0,6,0,7,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 67 */
    mode : GM_TIME_ATTACK,
    seed : 3400,
    time : 400,
    colors: {
      3,2,1,0,0,1,2,3,
       0,4,4,5,4,4,0,
      0,0,5,0,0,5,0,0,
       0,1,2,3,2,1,0,
      4,4,5,0,0,5,4,4,
       5,6,0,0,0,6,5,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 68 */
    mode : GM_TIME_ATTACK,
    seed : 3450,
    time : 200,
    colors: {
      1,0,5,0,0,5,0,1,
       1,6,4,0,6,4,1,
      2,0,5,0,0,5,0,2,
       2,4,6,5,4,6,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 69 */
    mode : GM_TIME_ATTACK,
    seed : 3501,
    time : 200,
    colors: {
      7,2,6,2,7,2,6,7,
       0,0,8,0,8,0,0,
      2,5,4,7,7,4,5,2,
       0,0,8,7,8,0,0,
      7,2,6,2,7,2,6,7,
       0,0,8,0,8,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 70 */
    mode : GM_GRAVITY,
    seed : 3550,
    colors: {
      1,3,2,3,1,2,3,3,
       2,1,3,2,3,1,3,
      3,3,2,1,3,3,2,1,
       3,3,3,3,2,1,3,
      3,2,1,2,1,3,3,3,
       1,3,3,3,3,3,2,
      3,2,1,3,2,3,1,3,
       3,3,2,3,1,2,3,
      3,3,3,1,2,3,1,3,
       1,3,2,3,3,3,2,
      3,2,1,3,3,3,3,3,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 71 */
    mode : GM_TIME_ATTACK,
    seed : 3600,
    time : 200,
    colors: {
      2,2,2,3,3,3,4,4,
       6,6,6,5,5,5,4,
      7,7,7,1,1,1,2,2,
       4,4,4,3,3,3,2,
      5,5,5,6,6,6,7,7,
       0,0,0,0,0,0,7,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 72 */
    mode : GM_TIME_ATTACK,
    seed : 3650,
    time : 500,
    colors: {
      4,6,5,4,5,6,4,5,
       4,4,6,4,4,5,6,
      4,6,5,4,6,5,4,6,
       6,5,4,6,5,6,4,
      1,3,2,3,1,2,3,1,
       0,0,0,2,0,0,0,
      0,0,0,3,4,0,0,0,
       0,0,0,2,0,0,0,
      0,0,0,3,4,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 73 */
    mode : GM_TIME_ATTACK,
    seed : 3700,
    time : 300,
    colors: {
      2,3,0,2,3,0,2,3,
       0,2,3,0,2,3,0,
      0,0,0,4,4,0,0,0,
       0,0,0,5,0,0,0,
      1,2,3,4,1,2,3,4,
       0,0,0,5,0,0,0,
      0,0,0,4,4,0,0,0,
       0,2,3,0,2,3,0,
      2,3,0,2,3,0,2,3,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 74 */
    mode : GM_TIME_ATTACK,
    seed : 3750,
    time : 300,
    colors: {
      6,3,0,6,3,0,0,1,
       0,7,0,0,7,7,7,
      0,0,1,0,0,0,0,1,
       0,0,2,3,0,3,2,
      0,0,0,1,5,5,1,0,
       0,0,2,3,0,3,2,
      0,0,1,0,0,0,6,0,
       6,7,0,0,0,3,7,
      0,0,0,0,0,2,1,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 75 */
    mode : GM_TIME_ATTACK,
    seed : 3800,
    time : 400,
    colors: {
      7,1,0,1,7,1,3,1,
       8,7,1,7,8,7,6,
      3,8,7,1,8,5,3,2,
       6,8,8,8,3,2,2,
      0,3,5,3,6,2,2,2,
       0,0,0,0,3,6,3,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 76 */
    mode : GM_TIME_ATTACK,
    seed : 3850,
    time : 300,
    colors: {
      0,0,0,5,6,0,0,0,
       0,0,0,7,1,2,1,
      0,0,0,5,6,0,0,0,
       1,2,1,7,0,0,0,
      0,0,0,5,6,0,0,0,
       0,0,0,7,1,2,1,
      0,0,0,5,6,0,0,0,
       1,2,1,7,0,0,0,
      0,0,0,5,6,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 77 */
    mode : GM_TIME_ATTACK,
    seed : 3900,
    time : 500,
    colors: {
      0,5,0,6,0,5,0,6,
       1,2,1,2,1,2,1,
      4,0,3,0,4,0,3,0,
       1,2,1,2,1,2,1,
      0,5,0,6,0,5,0,6,
       1,2,1,2,1,2,1,
      4,0,3,0,4,0,3,0,
       1,2,1,2,1,2,1,
      0,5,0,5,0,5,0,5,
       1,2,1,2,1,2,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 78 */
    mode : GM_TIME_ATTACK,
    seed : 3950,
    time : 200,
    colors: {
      0,0,0,0,3,4,0,0,
       0,0,0,0,6,0,0,
      0,7,8,6,2,0,0,0,
       8,5,7,5,3,4,0,
      0,4,5,4,6,2,3,0,
       4,4,5,0,0,1,4,
      0,0,0,0,0,0,2,3,
       0,0,0,0,0,0,1,
      0,0,0,0,0,0,0,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 79 */
    mode : GM_TIME_ATTACK,
    seed : 4000,
    time : 300,
    colors: {
      0,0,0,0,0,0,3,2,
       0,2,0,0,4,6,4,
      3,5,7,4,5,7,5,3,
       6,5,6,6,4,6,6,
      0,6,0,0,5,3,4,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 80 */
    mode : GM_TIME_ATTACK,
    seed : 4050,
    time : 200,
    colors: {
      0,0,1,2,2,1,0,0,
       0,1,4,4,4,1,0,
      0,1,3,1,1,3,1,0,
       2,3,4,4,4,3,2,
      2,5,1,1,1,1,5,2,
       2,5,4,4,4,5,2,
      0,3,5,1,1,5,3,0,
       0,3,4,4,4,3,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 81 */
    mode : GM_TIME_ATTACK,
    seed : 4102,
    time : 200,
    has_joker : 1,
    colors: {
      1,2,3,4,5,8,9,0,
       9,1,5,3,5,8,9,
      0,9,2,4,3,4,8,9,
       0,9,3,5,2,3,8,
      0,0,2,8,4,5,2,1,
       2,7,7,0,0,0,0,
      3,1,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 82 */
    mode : GM_TIME_ATTACK,
    seed : 4150,
    time : 300,
    colors: {
      1,2,3,5,1,2,1,2,
       1,2,4,3,2,1,2,
      1,2,1,5,4,1,2,1,
       0,0,0,3,5,2,1,
      0,0,0,0,4,3,2,1,
       0,0,0,0,5,4,2,
      0,0,0,0,0,3,5,1,
       0,0,0,0,0,4,3,
      0,0,0,0,0,0,5,4,
       0,0,0,0,0,0,3,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 83 */
    mode : GM_TIME_ATTACK,
    seed : 4200,
    time : 500,
    colors: {
      1,2,3,1,2,1,2,3,
       3,2,1,2,1,3,2,
      4,1,4,1,4,1,4,1,
       0,5,6,5,6,5,0,
      8,8,0,0,0,0,8,8,
       0,7,5,7,5,7,0,
      0,1,0,0,0,0,1,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 84 */
    mode : GM_TIME_ATTACK,
    seed : 4250,
    time : 200,
    colors: {
      5,6,0,0,0,0,0,0,
       2,3,6,3,6,3,6,
      5,6,0,0,0,0,0,0,
       2,3,6,3,6,3,6,
      5,6,0,0,0,0,0,0,
       2,3,6,3,6,3,6,
      5,6,0,0,0,0,0,0,
       2,3,6,3,6,3,6,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 85 */
    mode : GM_TIME_ATTACK,
    seed : 4300,
    time : 200,
    colors: {
      5,7,5,7,5,7,5,7,
       0,3,2,0,2,3,0,
      0,0,4,0,0,4,0,0,
       0,3,2,0,2,3,0,
      0,2,4,0,0,4,2,0,
       3,0,5,0,5,0,3,
      0,0,0,6,6,0,0,0,
       0,0,0,7,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 86 */
    mode : GM_INV_GRAVITY,
    seed : 4350,
    colors: {
      0,1,3,5,3,5,1,0,
       2,4,6,4,6,4,2,
      0,1,3,5,3,5,1,0,
       2,4,6,4,6,4,2,
      7,8,0,3,3,0,8,7,
       0,0,4,3,4,0,0,
      0,0,0,4,4,0,0,0,
       0,0,0,4,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 87 */
    mode : GM_TIME_ATTACK,
    seed : 4400,
    time : 300,
    colors: {
      0,0,2,3,2,3,0,0,
       0,3,1,4,1,3,0,
      0,0,1,5,5,1,0,0,
       0,1,4,6,4,1,0,
      0,1,5,5,5,5,1,0,
       1,4,6,4,6,4,1,
      1,5,5,5,5,5,5,1,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 88 */
    mode : GM_TIME_ATTACK,
    seed : 4450,
    time : 200,
    colors: {
      0,0,1,2,3,0,0,0,
       3,4,3,4,0,0,0,
      1,2,0,1,2,0,0,0,
       0,0,0,4,3,0,0,
      0,0,0,0,1,2,0,0,
       0,0,0,0,4,3,0,
      0,0,0,0,0,1,2,0,
       0,0,0,0,0,4,3,
      0,0,0,0,0,0,1,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 89 */
    mode : GM_TIME_ATTACK,
    seed : 4500,
    time : 120,
    colors: {
      7,0,0,5,6,0,0,0,
       5,6,0,0,7,5,0,
      0,0,7,5,0,0,6,7,
       7,5,0,6,7,5,6,
      5,0,0,7,0,0,0,5,
       7,5,6,0,7,5,6,
      5,0,0,7,6,0,0,7,
       5,0,5,0,7,0,5,
      0,7,6,0,0,5,6,7,
       6,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 90 */
    mode : GM_TIME_ATTACK,
    seed : 4550,
    time : 250,
    colors: {
      1,4,3,4,1,4,3,4,
       2,5,4,2,5,4,5,
      1,5,1,4,5,1,4,4,
       2,5,4,5,5,4,2,
      1,3,2,4,1,2,3,4,
       6,1,2,5,4,4,1,
      1,4,3,1,3,1,3,4,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 91 */
    mode : GM_TIME_ATTACK,
    seed : 4600,
    time : 500,
    colors: {
      4,7,6,4,7,6,7,4,
       1,5,4,5,1,2,5,
      1,1,2,2,3,3,6,6,
       7,8,7,8,7,8,7,
      2,1,1,3,3,5,5,6,
       2,1,1,3,4,4,5,
      0,4,3,3,4,4,4,5,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 92 */
    mode : GM_TIME_ATTACK,
    seed : 4650,
    time : 500,
    colors: {
      3,7,5,3,7,5,3,5,
       8,0,8,0,8,0,8,
      5,3,7,3,7,3,7,5,
       5,3,2,1,2,3,5,
      3,4,0,0,0,0,4,3,
       0,6,7,6,7,6,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 93 */
    mode : GM_TIME_ATTACK,
    seed : 4700,
    time : 500,
    colors: {
      0,0,0,6,5,0,0,0,
       2,0,3,7,3,0,2,
      0,1,2,6,7,2,1,0,
       0,0,4,5,4,0,0,
      2,1,2,8,8,2,1,2,
       0,0,4,1,4,0,0,
      0,1,2,3,3,2,1,0,
       2,0,0,7,0,0,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 94 */
    mode : GM_TIME_ATTACK,
    seed : 4750,
    time : 200,
    colors: {
      0,1,2,0,0,1,2,0,
       0,3,4,0,3,4,0,
      0,0,5,6,5,6,0,0,
       0,0,7,3,7,0,0,
      0,0,0,1,2,0,0,0,
       0,0,0,4,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 95 */
    mode : GM_TIME_ATTACK,
    seed : 4800,
    time : 500,
    colors: {
      0,4,5,6,7,0,1,0,
       3,0,0,0,8,0,2,
      2,0,1,2,0,1,0,3,
       1,0,8,0,2,0,4,
      8,0,7,0,0,3,0,5,
       7,0,6,5,4,0,6,
      0,6,0,0,0,0,0,7,
       0,5,4,3,2,1,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 96 */
    mode : GM_AVALANCHE,
    seed : 4850,
    time : 10,
    colors: {
      0,2,0,0,3,0,2,0,
       3,4,0,4,2,3,0,
      2,0,2,2,0,4,0,0,
       5,7,0,0,0,5,7,
      5,0,5,0,2,5,0,5,
       5,6,0,3,4,5,7,
      0,0,3,2,0,2,0,3,
       2,2,4,0,4,2,2,
      0,0,3,0,3,3,0,0,
       0,0,4,5,0,5,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 97 */
    mode : GM_TIME_ATTACK,
    seed : 4900,
    time : 200,
    colors: {
      5,3,2,0,3,3,0,0,
       4,0,4,5,0,5,0,
      5,5,5,0,5,0,4,0,
       4,1,2,3,3,4,0,
      0,2,0,2,4,3,5,0,
       1,2,3,0,1,6,6,
      0,0,0,2,4,5,1,5,
       0,5,5,1,3,2,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 98 */
    mode : GM_TIME_ATTACK,
    seed : 4950,
    time : 500,
    colors: {
      0,1,0,1,4,0,1,4,
       2,0,2,5,0,2,5,
      3,0,3,6,0,3,6,7,
       4,0,4,7,8,1,2,
      0,5,6,5,7,3,2,1,
       0,4,0,4,7,8,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  /* erikberg */
  { /* 99 */
    mode : GM_TIME_ATTACK,
    seed : 5000,
    time : 500,
    colors: {
      2,2,0,0,1,2,3,4,
       4,5,0,0,4,5,6,
      1,2,3,0,0,1,2,3,
       4,5,6,0,0,4,5,
      1,2,3,4,0,0,1,2,
       4,5,6,7,0,0,4,
      1,2,3,4,5,0,0,1,
       4,5,6,7,8,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 100 */
    mode : GM_TIME_ATTACK,
    seed : 5050,
    time : 500,
    colors: {
      1,2,3,0,0,3,2,1,
       4,5,7,6,7,5,4,
      0,7,8,0,0,8,7,0,
       0,1,2,3,2,1,0,
      0,0,4,0,0,4,0,0,
       0,0,5,6,5,0,0,
      0,0,0,7,7,0,0,0,
       0,0,0,8,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 101 */
    mode : GM_TIME_ATTACK,
    seed : 5100,
    time : 500,
    colors: {
      1,2,3,0,0,3,2,1,
       4,5,0,6,0,5,4,
      0,7,8,0,0,8,7,0,
       0,1,2,3,2,1,0,
      0,0,4,0,0,4,0,0,
       0,5,0,6,0,5,0,
      0,7,8,0,0,8,7,0,
       1,2,3,4,3,2,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 102 */
    mode : GM_TIME_ATTACK,
    seed : 5150,
    time : 500,
    colors: {
      1,0,0,0,2,3,4,5,
       6,7,0,0,0,8,1,
      2,3,4,5,0,0,0,6,
       7,8,0,0,0,1,2,
      3,0,0,0,4,5,6,7,
       8,1,0,0,0,2,3,
      4,5,6,7,0,0,0,8,
       1,2,0,0,0,3,4,
      5,0,0,0,6,7,8,1,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 103 */
    mode : GM_TIME_ATTACK,
    seed : 5200,
    time : 500,
    colors: {
      1,0,8,0,1,0,8,0,
       2,0,7,0,2,0,7,
      0,3,0,6,0,3,0,6,
       4,0,5,0,4,0,5,
      5,0,4,0,5,0,4,0,
       6,0,3,0,6,0,3,
      0,7,0,2,0,7,0,2,
       8,0,1,0,8,0,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 104 */
    mode : GM_TIME_ATTACK,
    seed : 5250,
    time : 500,
    colors: {
      1,2,1,2,1,2,1,2,
       3,4,0,0,0,3,4,
      0,6,5,0,0,6,5,0,
       0,8,7,0,8,7,0,
      2,1,2,1,2,1,2,1,
       0,0,4,3,4,0,0,
      0,0,0,5,6,0,0,0,
       0,0,8,7,8,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 105 */
    mode : GM_TIME_ATTACK,
    seed : 5300,
    time : 500,
    colors: {
      1,2,1,2,1,2,1,2,
       2,3,4,3,4,3,1,
      1,4,5,6,5,6,4,2,
       2,3,6,7,5,3,1,
      1,4,5,6,5,6,4,2,
       2,3,4,3,4,3,1,
      1,2,1,2,1,2,1,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 7 */
    mode : GM_INV_GRAVITY,
    seed : 400,
    colors: {
      8,6,7,5,6,7,5,8,
       0,0,0,4,0,0,0,
      0,0,0,4,4,0,0,0,
       0,0,3,4,3,0,0,
      0,0,6,5,5,6,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 106 */
    mode : GM_TIME_ATTACK,
    seed : 5350,
    time : 500,
    colors: {
      0,0,2,1,1,2,0,0,
       0,3,0,0,0,3,0,
      0,4,0,0,0,0,4,0,
       0,5,0,0,0,5,0,
      0,0,0,0,0,6,0,0,
       0,0,0,8,7,0,0,
      0,0,0,1,0,0,0,0,
       0,0,2,2,0,0,0,
      0,0,0,1,0,0,0,0,
       0,0,2,2,0,0,0,
      0,0,0,1,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 107 */
    mode : GM_TIME_ATTACK,
    seed : 5400,
    time : 500,
    colors: {
      1,2,3,4,5,6,7,8,
       8,7,6,5,4,3,2,
      1,2,3,4,5,6,7,8,
       7,6,5,4,3,2,1,
      1,2,3,4,5,6,7,8,
       8,7,6,5,4,3,2,
      1,2,3,4,5,6,7,8,
       7,6,5,4,3,2,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 108 */
    mode : GM_TIME_ATTACK,
    seed : 5450,
    time : 500,
    colors: {
      0,1,0,8,8,0,1,0,
       2,2,0,7,0,2,2,
      0,3,0,6,6,0,3,0,
       4,4,0,5,0,4,4,
      0,5,0,4,4,0,5,0,
       6,6,0,3,0,6,6,
      0,7,0,2,2,0,7,0,
       8,8,0,1,0,8,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 109 */
    mode : GM_TIME_ATTACK,
    seed : 5500,
    time : 500,
    colors: {
      1,2,3,0,0,3,2,1,
       5,4,0,6,0,4,5,
      0,6,0,4,4,0,6,0,
       0,1,2,3,2,1,0,
      0,0,5,4,4,5,0,0,
       0,0,7,6,7,0,0,
      0,0,0,8,8,0,0,0,
       0,0,0,1,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 110 */
    mode : GM_TIME_ATTACK,
    seed : 5550,
    time : 500,
    colors: {
      0,2,3,0,0,3,2,0,
       1,5,4,0,4,5,1,
      0,6,6,0,0,6,6,0,
       0,0,7,8,7,0,0,
      0,5,6,1,1,6,5,0,
       4,0,0,2,0,0,4,
      3,2,0,0,0,0,2,3,
       0,7,8,0,8,7,0,
      0,0,5,6,6,5,0,0,
       4,3,0,0,0,3,4,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 111 */
    mode : GM_TIME_ATTACK,
    seed : 5600,
    time : 500,
    colors: {
      1,2,0,1,1,0,2,1,
       3,0,2,3,2,0,3,
      4,0,4,5,5,4,0,4,
       5,0,6,7,6,0,5,
      6,7,0,8,8,0,7,6,
       1,8,0,1,0,8,1,
      2,3,0,2,2,0,3,2,
       4,0,3,4,3,0,4,
      5,0,5,6,6,5,0,5,
       6,0,7,8,7,0,6,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  /* espeh */
  { /* 112 */
    mode : GM_TIME_ATTACK,
    seed : 5650,
    time : 500,
    colors: {
      1,2,0,1,3,0,2,3,
       6,0,0,7,0,0,1,
      2,1,8,4,2,3,6,4,
       5,0,0,3,0,0,2,
      1,0,0,0,0,0,0,7,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 113 */
    mode : GM_TIME_ATTACK,
    seed : 5700,
    time : 500,
    colors: {
      1,0,0,0,0,0,0,8,
       2,6,0,0,0,7,1,
      6,3,5,4,2,3,2,6,
       0,4,6,7,1,8,0,
      0,0,8,2,1,6,0,0,
       0,0,4,8,7,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 114 */
    mode : GM_TIME_ATTACK,
    seed : 5750,
    time : 500,
    colors: {
      0,1,0,0,0,0,1,0,
       0,2,0,0,0,2,0,
      0,0,3,0,0,3,0,0,
       0,0,4,5,4,0,0,
      0,0,0,6,6,0,0,0,
       0,0,4,5,4,0,0,
      0,0,3,0,0,3,0,0,
       0,2,0,0,0,2,0,
      0,1,0,0,0,0,1,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 115 */
    mode : GM_AVALANCHE,
    seed : 5800,
    time : 5,
    colors: {
      0,1,0,0,5,0,0,1,
       2,3,0,6,7,0,2,
      0,4,0,0,8,0,0,3,
       1,1,2,2,3,4,5,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 116 */
    mode : GM_TIME_ATTACK,
    seed : 5850,
    time : 500,
    colors: {
      1,0,0,4,0,5,0,1,
       2,3,1,2,3,1,2,
      0,1,2,3,1,2,3,0,
       0,3,0,2,0,1,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 117 */
    mode : GM_TIME_ATTACK,
    seed : 5900,
    time : 500,
    colors: {
      1,5,8,4,8,5,4,1,
       2,3,1,2,3,1,2,
      4,1,2,3,1,2,3,4,
       5,3,5,2,5,1,5,
      0,1,0,1,0,1,0,1,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 118 */
    mode : GM_TIME_ATTACK,
    seed : 5950,
    time : 500,
    colors: {
      1,2,3,2,1,2,3,2,
       3,1,2,3,1,2,1,
      4,4,3,4,4,3,4,4,
       5,5,3,5,5,3,5,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 119 */
    mode : GM_TIME_ATTACK,
    seed : 6000,
    time : 500,
    colors: {
      0,0,1,0,0,1,0,0,
       0,8,2,0,2,8,0,
      4,5,4,5,4,5,4,5,
       0,8,2,6,2,8,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 120 */
    mode : GM_TIME_ATTACK,
    seed : 6050,
    time : 500,
    colors: {
      1,2,2,1,2,1,2,0,
       0,0,0,0,0,0,3,
      0,0,3,2,1,2,2,0,
       0,1,0,0,0,0,0,
      0,0,3,2,1,2,0,0,
       0,0,0,0,0,1,0,
      0,0,0,2,1,2,0,0,
       0,0,1,0,0,0,0,
      0,0,0,2,2,1,3,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 121 */
    mode : GM_TIME_ATTACK,
    seed : 6100,
    time : 500,
    colors: {
      7,0,0,0,0,0,0,7,
       5,0,0,0,0,0,5,
      0,3,0,0,0,0,3,0,
       7,5,0,0,0,5,7,
      0,4,0,0,0,0,4,0,
       7,0,0,0,0,0,7,
      5,0,0,0,0,0,0,5,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 122 */
    mode : GM_AVALANCHE,
    seed : 6150,
    time : 5,
    colors: {
      0,0,0,0,2,0,0,0,
       0,0,0,0,1,0,0,
      0,0,0,0,0,2,0,0,
       7,8,5,6,4,3,0,
      0,0,0,0,0,2,0,0,
       0,0,0,0,1,0,0,
      0,0,0,0,2,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 123 */
    mode : GM_TIME_ATTACK,
    seed : 6200,
    time : 500,
    colors: {
      0,0,0,6,1,0,0,0,
       0,0,0,7,0,0,0,
      0,0,0,1,8,0,0,0,
       1,2,3,5,3,2,1,
      0,0,5,4,4,5,0,0,
       0,0,0,1,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 124 */
    mode : GM_TIME_ATTACK,
    seed : 6250,
    time : 500,
    colors: {
      0,2,2,0,0,0,0,0,
       1,3,4,0,0,0,0,
      2,4,1,3,0,0,0,0,
       1,2,4,1,0,0,0,
      3,4,3,2,3,1,0,0,
       1,2,4,1,0,0,0,
      2,4,1,3,0,0,0,0,
       1,3,2,0,0,0,0,
      0,1,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 125 */
    mode : GM_TIME_ATTACK,
    seed : 6300,
    time : 500,
    colors: {
      0,0,0,3,1,3,0,0,
       0,0,0,5,6,0,0,
      0,0,0,0,3,0,0,0,
       0,0,0,6,5,0,0,
      0,0,1,0,1,0,1,0,
       0,0,4,5,6,4,0,
      0,0,0,0,3,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 126 */
    mode : GM_TIME_ATTACK,
    seed : 6350,
    time : 500,
    colors: {
      0,0,0,0,0,0,3,8,
       0,0,0,0,0,0,1,
      0,0,0,0,0,0,3,8,
       0,0,0,0,0,0,2,
      0,0,0,0,0,0,3,8,
       0,0,0,0,0,0,1,
      0,0,0,0,0,0,3,8,
       0,0,0,0,0,0,2,
      0,0,0,0,0,0,3,8,
       0,0,0,0,0,0,1,
      0,0,0,0,0,0,8,3,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 127 */
    mode : GM_TIME_ATTACK,
    seed : 6400,
    time : 500,
    colors: {
      6,0,5,0,6,0,5,0,
       1,2,0,0,2,1,0,
      0,3,0,0,0,4,0,0,
       0,3,4,3,4,0,0,
      1,5,6,5,6,5,1,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 128 */
    mode : GM_TIME_ATTACK,
    seed : 6450,
    time : 500,
    colors: {
      0,0,0,4,4,0,0,0,
       0,0,0,2,0,0,0,
      0,0,0,5,5,0,0,0,
       0,0,3,2,3,0,0,
      0,0,2,0,0,2,0,0,
       5,4,1,0,1,4,5,
      0,0,0,3,3,0,0,0,
       0,0,0,8,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 129 */
    mode : GM_TIME_ATTACK,
    seed : 6500,
    time : 500,
    colors: {
      8,6,0,5,5,0,5,7,
       2,0,0,1,0,0,3,
      8,6,0,0,0,0,5,7,
       2,1,8,0,5,3,3,
      8,6,1,2,3,1,5,7,
       0,0,0,1,0,0,0,
      0,0,0,5,5,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 130 */
    mode : GM_TIME_ATTACK,
    seed : 6550,
    time : 500,
    colors: {
      0,0,0,5,8,6,0,0,
       0,0,1,6,7,1,0,
      0,0,8,2,3,2,8,0,
       0,0,5,4,1,6,0,
      0,0,0,2,3,5,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 131 */
    mode : GM_GRAVITY,
    seed : 6600,
    colors: {
      1,0,0,0,0,0,0,8,
       8,7,6,5,4,3,2,
      2,0,0,0,0,0,0,7,
       2,3,4,5,6,7,8,
      3,0,0,0,0,0,0,6,
       1,3,5,7,5,3,1,
      4,0,0,0,0,0,0,5,
       4,3,3,1,2,2,5,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 132 */
    mode : GM_TIME_ATTACK,
    seed : 6650,
    time : 500,
    colors: {
      1,0,1,0,1,0,1,0,
       2,0,2,0,2,0,2,
      1,0,1,0,1,0,1,0,
       2,0,2,0,2,0,2,
      1,0,1,0,1,0,1,0,
       2,0,2,0,2,0,2,
      1,3,1,3,1,3,1,3,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 133 */
    mode : GM_TIME_ATTACK,
    seed : 6700,
    time : 500,
    colors: {
      0,0,0,8,7,0,0,0,
       0,0,6,5,4,0,0,
      0,0,3,2,3,5,0,0,
       0,6,7,8,7,6,0,
      1,2,1,2,1,2,1,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 134 */
    mode : GM_TIME_ATTACK,
    seed : 6750,
    time : 500,
    colors: {
      1,2,0,0,0,0,2,1,
       3,4,0,0,0,4,3,
      0,5,6,0,0,6,5,0,
       0,7,8,0,8,7,0,
      0,0,1,2,2,1,0,0,
       0,0,3,4,0,0,0,
      0,0,0,5,6,0,0,0,
       0,0,0,7,8,0,0,
      0,0,0,0,1,2,0,0,
       0,0,0,0,3,4,0,
      0,0,0,0,0,5,6,0,
       0,0,0,0,0,7,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 135 */
    mode : GM_TIME_ATTACK,
    seed : 6800,
    time : 500,
    colors: {
      0,0,0,0,0,0,1,2,
       0,0,0,0,0,3,4,
      0,0,0,0,0,5,6,0,
       0,0,0,0,7,8,0,
      0,0,0,0,1,2,0,0,
       0,0,0,3,4,0,0,
      0,0,0,5,6,1,0,0,
       0,0,7,8,8,7,0,
      0,0,1,2,0,5,6,0,
       0,3,4,0,0,3,4,
      0,5,6,0,0,0,1,2,
       7,8,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 136 */
    mode : GM_TIME_ATTACK,
    seed : 6850,
    time : 500,
    colors: {
      0,1,0,0,0,0,5,0,
       2,3,0,0,0,6,7,
      5,4,8,0,0,4,8,4,
       2,0,6,1,2,0,3,
      1,0,0,3,3,0,0,5,
       2,0,0,1,0,0,6,
      4,3,0,0,0,0,7,8,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 137 */
    mode : GM_TIME_ATTACK,
    seed : 6900,
    time : 500,
    colors: {
      1,0,0,0,0,0,0,5,
       5,4,3,2,0,0,1,
      2,0,0,0,0,0,0,6,
       6,0,0,5,4,3,2,
      3,0,0,0,0,0,0,7,
       7,8,2,1,0,0,3,
      4,0,0,0,0,0,0,8,
       8,0,0,7,2,5,4,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 138 */
    mode : GM_TIME_ATTACK,
    seed : 6950,
    time : 500,
    colors: {
      1,8,4,5,6,6,8,1,
       3,0,0,0,0,0,6,
      2,0,0,0,0,0,0,2,
       4,0,0,0,0,0,1,
      3,8,0,0,0,0,8,3,
       5,0,0,0,0,0,2,
      4,0,0,0,0,0,0,4,
       3,0,0,0,0,0,8,
      5,0,0,0,0,0,0,5,
       2,0,0,0,0,0,4,
      6,0,0,0,0,0,0,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 139 */
    mode : GM_TIME_ATTACK,
    seed : 7000,
    time : 500,
    colors: {
      1,6,0,1,1,0,6,1,
       2,5,0,1,0,5,2,
      0,3,4,0,0,4,3,0,
       0,4,3,0,3,4,0,
      0,0,5,2,2,5,0,0,
       0,0,6,1,6,0,0,
      0,0,0,7,7,0,0,0,
       8,8,8,8,8,8,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 140 */
    mode : GM_TIME_ATTACK,
    seed : 7050,
    time : 500,
    colors: {
      1,0,0,5,4,0,0,1,
       0,0,1,7,1,0,0,
      0,0,0,6,8,0,0,0,
       0,6,5,2,5,6,0,
      0,7,4,0,0,4,7,0,
       8,3,0,0,0,3,8,
      7,2,0,0,0,0,2,7,
       1,0,0,0,0,0,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 141 */
    mode : GM_TIME_ATTACK,
    seed : 7100,
    time : 500,
    colors: {
      1,0,0,1,2,0,0,1,
       2,0,0,3,0,0,2,
      1,0,0,2,1,0,0,1,
       2,0,0,3,0,0,2,
      1,0,0,1,2,0,0,1,
       2,0,0,2,0,0,2,
      1,0,0,2,1,0,0,1,
       2,0,0,3,0,0,2,
      8,7,6,5,4,3,2,1,
       1,2,3,6,5,3,7,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 142 */
    mode : GM_TIME_ATTACK,
    seed : 7150,
    time : 500,
    colors: {
      5,2,3,8,1,6,7,2,
       6,0,1,0,4,0,1,
      0,7,3,0,0,6,8,0,
       0,8,0,0,0,5,0,
      0,0,1,3,2,8,0,0,
       0,0,4,0,5,0,0,
      0,0,0,6,7,0,0,0,
       0,0,0,1,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 143 */
    mode : GM_INV_GRAVITY,
    seed : 7200,
    colors: {
      1,5,2,5,2,5,1,5,
       1,5,1,5,1,5,1,
      1,2,5,1,2,5,1,2,
       5,1,2,5,2,1,2,
      3,6,7,8,3,6,7,8,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 144 */
    mode : GM_TIME_ATTACK,
    seed : 7250,
    time : 500,
    colors: {
      3,2,0,0,0,4,8,0,
       0,4,8,3,8,0,4,
      0,8,2,4,4,2,0,8,
       4,0,3,8,8,3,4,
      3,8,0,4,3,4,8,0,
       2,4,8,0,0,3,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 145 */
    mode : GM_TIME_ATTACK,
    seed : 7300,
    time : 500,
    colors: {
      3,1,3,2,3,1,3,2,
       6,0,6,0,6,0,6,
      1,3,2,3,1,3,2,3,
       0,6,0,6,0,6,0,
      3,1,3,2,3,1,3,2,
       6,0,6,0,6,0,6,
      1,3,2,3,1,3,2,3,
       0,6,0,6,0,6,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 146 */
    mode : GM_TIME_ATTACK,
    seed : 7350,
    time : 500,
    colors: {
      1,2,0,1,2,0,2,1,
       3,0,3,4,1,0,3,
      4,5,2,1,3,4,5,4,
       6,5,6,5,6,5,6,
      0,0,0,1,2,0,0,0,
       0,0,3,4,1,0,0,
      6,5,2,1,3,4,5,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 147 */
    mode : GM_TIME_ATTACK,
    seed : 7400,
    time : 500,
    colors: {
      4,6,3,1,2,3,6,4,
       5,7,2,3,1,7,5,
      7,4,3,1,2,3,4,7,
       5,7,0,0,0,7,5,
      6,0,0,0,0,0,0,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 148 */
    mode : GM_TIME_ATTACK,
    seed : 7451,
    time : 500,
    colors: {
      2,3,7,6,5,6,3,2,
       1,3,5,6,7,3,1,
      2,2,3,7,6,3,2,2,
       1,2,3,5,3,2,1,
      4,2,1,3,3,1,2,1,
       3,3,3,3,3,3,2,
      0,0,0,0,0,0,3,1,
       0,0,0,0,0,0,3,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 149 */
    mode : GM_TIME_ATTACK,
    seed : 7500,
    time : 500,
    colors: {
      7,8,4,0,4,7,8,0,
       7,3,1,3,1,7,3,
      0,2,0,3,0,2,4,0,
       1,0,0,7,8,3,0,
      0,7,8,0,7,0,0,0,
       0,7,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 150 */
    mode : GM_TIME_ATTACK,
    seed : 7550,
    time : 500,
    colors: {
      1,6,1,6,1,6,1,6,
       5,0,0,0,0,0,5,
      1,0,0,0,0,0,0,6,
       6,0,0,0,0,0,1,
      1,0,0,0,0,0,0,6,
       6,0,0,0,0,0,1,
      1,0,0,0,0,0,0,6,
       6,0,0,0,0,0,1,
      1,5,6,1,6,1,5,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 151 */
    mode : GM_TIME_ATTACK,
    seed : 7600,
    time : 500,
    colors: {
      1,6,1,6,1,6,1,6,
       5,2,3,2,3,3,5,
      1,0,0,0,0,0,2,6,
       6,3,0,0,0,3,1,
      1,2,0,0,0,0,2,6,
       6,3,0,0,0,3,1,
      1,2,0,0,0,0,2,6,
       6,3,2,3,2,3,1,
      1,5,6,1,6,1,5,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 152 */
    mode : GM_TIME_ATTACK,
    seed : 7650,
    time : 500,
    colors: {
      1,6,1,6,1,6,1,6,
       5,2,3,2,3,3,5,
      1,7,8,7,8,7,2,6,
       6,3,4,0,8,3,1,
      1,2,8,0,0,7,2,6,
       6,3,7,0,8,3,1,
      1,2,8,7,4,7,2,6,
       6,3,2,3,2,3,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 153 */
    mode : GM_TIME_ATTACK,
    seed : 7700,
    time : 500,
    colors: {
      0,0,1,4,5,1,0,0,
       4,2,6,0,7,2,5,
      0,6,4,0,0,5,7,0,
       4,1,6,0,7,1,5,
      6,0,2,4,5,2,0,7,
       4,0,6,0,7,0,5,
      0,6,4,0,0,5,7,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 154 */
    mode : GM_TIME_ATTACK,
    seed : 7750,
    time : 500,
    colors: {
      0,3,6,0,4,0,3,5,
       2,5,0,1,0,2,5,
      0,3,6,0,4,0,3,6,
       0,5,0,1,0,2,0,
      0,0,6,0,4,0,3,0,
       0,5,0,1,0,2,0,
      1,2,3,4,5,6,7,8,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 155 */
    mode : GM_TIME_ATTACK,
    seed : 7800,
    time : 500,
    colors: {
      0,0,0,0,0,1,0,1,
       0,0,0,2,0,4,2,
      0,0,0,0,3,0,3,0,
       0,0,4,0,4,7,4,
      0,0,0,5,0,5,0,5,
       0,1,0,6,8,6,0,
      0,0,2,1,7,0,7,0,
       0,1,3,0,0,0,0,
      0,4,0,4,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 156 */
    mode : GM_TIME_ATTACK,
    seed : 7850,
    time : 500,
    colors: {
      4,3,6,5,1,5,6,0,
       5,0,1,8,2,0,3,
      0,6,2,0,7,6,5,4,
       1,7,0,0,0,1,2,
      0,2,8,5,6,3,4,0,
       1,0,0,1,0,0,5,
      2,8,7,6,2,8,7,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 157 */
    mode : GM_TIME_ATTACK,
    seed : 7900,
    time : 500,
    colors: {
      0,6,7,7,6,5,6,0,
       5,1,8,2,3,4,7,
      4,2,6,1,8,4,3,8,
       3,7,5,2,7,5,2,
      0,8,4,3,1,6,6,1,
       0,1,3,4,5,7,8,
      0,0,2,2,1,8,7,0,
       0,0,3,4,5,6,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 158 */
    mode : GM_TIME_ATTACK,
    seed : 7950,
    time : 500,
    colors: {
      0,0,0,0,0,5,1,0,
       0,0,0,0,4,6,0,
      1,4,1,4,1,3,0,0,
       2,5,2,5,2,4,0,
      3,6,3,6,3,5,6,0,
       0,0,0,0,0,1,2,
      0,0,0,0,0,0,3,4,
       0,0,0,0,0,0,5,
      0,0,0,0,0,0,0,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 159 */
    mode : GM_TIME_ATTACK,
    seed : 8000,
    time : 500,
    colors: {
      1,2,0,0,0,0,5,4,
       3,6,0,0,0,3,4,
      4,5,3,0,0,4,2,1,
       1,2,4,0,2,5,6,
      0,6,5,3,3,2,1,0,
       0,1,2,4,4,5,0,
      0,0,6,5,2,1,0,0,
       0,0,0,3,4,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 160 */
    mode : GM_TIME_ATTACK,
    seed : 8050,
    time : 500,
    colors: {
      0,0,0,7,0,0,0,0,
       0,0,6,8,5,0,0,
      0,0,0,5,7,4,6,0,
       8,7,4,0,8,7,8,
      4,5,8,0,7,4,0,0,
       0,6,7,8,5,0,0,
      8,7,8,4,7,6,0,0,
       0,0,0,5,8,7,8,
      0,0,0,6,7,5,6,0,
       7,8,7,8,4,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 161 */
    mode : GM_TIME_ATTACK,
    seed : 8100,
    time : 500,
    colors: {
      4,5,4,1,1,6,5,1,
       6,1,6,1,4,1,6,
      4,1,1,4,5,1,1,4,
       6,4,6,1,6,1,5,
      4,1,1,5,1,5,6,1,
       5,6,4,6,4,1,1,
      1,1,1,5,1,5,1,1,
       4,6,4,1,1,6,4,
      0,0,0,5,6,4,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 162 */
    mode : GM_TIME_ATTACK,
    seed : 8150,
    time : 500,
    colors: {
      6,5,6,1,1,3,4,3,
       3,3,1,2,1,5,5,
      3,4,3,1,1,5,6,5,
       3,3,5,7,7,5,5,
      5,1,1,7,8,7,1,2,
       1,2,1,7,7,3,3,
      3,1,1,7,1,3,4,3,
       4,5,6,0,2,3,3,
      0,0,0,0,0,4,5,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 163 */
    mode : GM_TIME_ATTACK,
    seed : 8200,
    time : 500,
    colors: {
      4,5,6,1,2,6,3,4,
       0,4,0,0,5,0,4,
      0,5,0,5,4,0,0,6,
       0,6,4,6,5,0,5,
      4,5,0,0,0,6,4,0,
       0,4,6,5,4,0,5,
      6,5,0,0,6,0,4,6,
       0,4,6,0,4,5,0,
      6,5,0,4,0,0,6,0,
       0,4,0,6,4,5,4,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 164 */
    mode : GM_TIME_ATTACK,
    seed : 8250,
    time : 500,
    colors: {
      1,2,4,5,4,5,4,5,
       0,3,6,7,6,7,6,
      0,0,1,4,5,4,5,4,
       0,0,2,3,6,7,6,
      0,0,0,0,1,4,5,4,
       0,0,0,0,2,3,6,
      0,0,0,0,0,0,1,4,
       0,0,0,0,0,0,2,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 165 */
    mode : GM_TIME_ATTACK,
    seed : 8300,
    time : 500,
    colors: {
      6,5,3,4,5,3,5,6,
       3,4,1,2,1,4,3,
      5,6,2,0,0,2,6,5,
       4,1,0,0,0,1,4,
      3,2,0,0,0,0,2,3,
       1,0,0,0,0,0,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 166 */
    mode : GM_TIME_ATTACK,
    seed : 8350,
    time : 500,
    colors: {
      3,0,0,1,2,0,0,3,
       4,0,5,4,3,0,4,
      5,6,7,0,0,5,6,7,
       8,1,0,0,0,8,1,
      0,0,5,4,3,2,0,0,
       0,0,1,2,6,0,0,
      1,3,2,0,0,4,6,5,
       4,5,0,0,0,1,2,
      0,0,7,8,7,8,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 167 */
    mode : GM_TIME_ATTACK,
    seed : 8400,
    time : 500,
    has_joker : 1,
    colors: {
      0,2,3,4,1,2,3,0,
       1,7,7,5,7,7,4,
      3,0,7,0,0,7,0,3,
       2,1,9,8,9,1,2,
      0,0,0,5,6,0,0,0,
       1,7,8,0,8,7,1,
      0,0,4,0,0,4,0,0,
       0,0,3,1,3,0,0,
      0,0,2,5,5,2,0,0,
       7,8,0,6,0,8,7,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 168 */
    mode : GM_TIME_ATTACK,
    seed : 8450,
    time : 500,
    colors: {
      7,6,8,1,2,7,8,6,
       8,7,6,7,3,6,7,
      0,0,0,0,1,4,0,0,
       6,7,8,2,5,6,8,
      7,8,6,3,6,8,7,6,
       0,0,0,4,1,0,0,
      6,7,8,7,5,2,0,0,
       8,6,2,8,6,3,0,
      0,0,0,4,0,4,0,0,
       0,0,0,6,5,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 169 */
    mode : GM_TIME_ATTACK,
    seed : 8500,
    time : 500,
    colors: {
      0,2,3,0,0,0,0,0,
       0,5,4,7,0,0,0,
      0,2,3,6,7,0,0,0,
       0,0,0,5,6,0,0,
      0,0,0,7,0,7,6,0,
       0,0,6,2,2,5,6,
      0,2,5,3,3,0,7,5,
       8,1,4,5,0,0,0,
      0,0,0,0,1,3,0,0,
       0,0,0,0,2,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 170 */
    mode : GM_TIME_ATTACK,
    seed : 8550,
    time : 500,
    colors: {
      0,1,0,0,6,7,0,0,
       0,2,0,5,0,8,0,
      0,0,3,4,0,0,1,0,
       0,8,7,6,0,0,2,
      0,1,0,0,5,4,3,0,
       2,0,5,6,0,0,4,
      0,3,4,0,7,1,2,0,
       0,5,1,0,8,0,3,
      7,6,0,2,0,0,0,4,
       0,0,0,3,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 171 */
    mode : GM_TIME_ATTACK,
    seed : 8600,
    time : 500,
    colors: {
      7,0,0,1,1,0,0,7,
       2,1,2,2,2,1,2,
      7,0,0,3,3,0,0,7,
       2,1,4,4,4,1,2,
      7,0,0,5,5,0,0,7,
       2,1,6,6,6,1,2,
      7,0,0,7,7,0,0,7,
       2,1,8,8,8,1,2,
      7,0,0,1,1,0,0,7,
       8,2,0,0,0,2,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 172 */
    mode : GM_TIME_ATTACK,
    seed : 8650,
    time : 500,
    colors: {
      1,1,0,7,7,0,1,1,
       2,2,1,2,1,2,2,
      3,3,0,7,7,0,3,3,
       4,4,1,2,1,4,4,
      5,5,0,7,7,0,5,5,
       6,6,1,2,1,6,6,
      7,7,0,7,7,0,7,7,
       8,8,1,2,1,8,8,
      1,1,0,7,7,0,1,1,
       0,0,0,7,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 173 */
    mode : GM_TIME_ATTACK,
    seed : 8700,
    time : 500,
    colors: {
      1,2,0,0,0,0,2,1,
       1,2,3,0,3,2,1,
      8,8,2,3,3,2,8,8,
       7,7,4,3,4,7,7,
      8,8,5,4,4,5,8,8,
       0,1,5,4,5,1,0,
      0,0,2,5,5,2,0,0,
       0,0,3,5,3,0,0,
      0,0,0,1,1,0,0,0,
       0,0,0,2,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 174 */
    mode : GM_TIME_ATTACK,
    seed : 8750,
    time : 500,
    colors: {
      7,6,7,6,7,6,7,0,
       8,4,8,4,8,4,8,
      0,2,0,0,0,7,6,0,
       0,1,0,0,4,8,0,
      0,0,2,0,7,6,0,0,
       0,0,1,4,8,0,0,
      0,0,7,6,0,0,0,0,
       7,4,7,8,7,6,7,
      4,8,4,6,4,8,4,8,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 175 */
    mode : GM_TIME_ATTACK,
    seed : 8800,
    time : 500,
    colors: {
      4,5,4,5,4,5,4,5,
       6,0,6,0,6,0,6,
      0,8,8,8,8,8,8,0,
       2,1,0,0,0,1,4,
      0,3,1,0,0,1,3,0,
       0,4,1,0,1,2,0,
      0,0,2,1,1,4,0,0,
       0,0,3,1,3,0,0,
      0,0,0,4,2,0,0,0,
       0,0,0,7,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 176 */
    mode : GM_TIME_ATTACK,
    seed : 8850,
    time : 500,
    colors: {
      0,0,0,1,2,0,0,0,
       0,0,5,0,3,5,6,
      0,0,0,5,4,0,0,0,
       1,2,6,0,2,0,0,
      0,0,0,7,8,0,0,0,
       0,0,5,0,1,5,6,
      0,0,0,3,2,0,0,0,
       1,2,4,0,2,0,0,
      0,0,0,5,6,0,0,0,
       0,0,0,0,7,0,0,
      0,0,0,0,8,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 177 */
    mode : GM_TIME_ATTACK,
    seed : 8900,
    time : 500,
    colors: {
      1,2,3,4,1,2,3,4,
       0,0,6,5,6,0,0,
      0,0,7,8,7,8,0,0,
       0,0,6,5,6,0,0,
      0,0,7,8,7,8,0,0,
       0,0,6,5,6,0,0,
      1,2,3,4,1,2,3,4,
       0,0,7,7,7,0,0,
      0,0,0,8,8,0,0,0,
       0,0,0,8,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 178 */
    mode : GM_TIME_ATTACK,
    seed : 8950,
    time : 500,
    colors: {
      0,1,2,3,0,6,7,0,
       4,5,4,1,4,5,4,
      6,7,6,7,2,6,7,3,
       4,5,4,0,3,1,2,
      0,0,0,0,4,0,0,0,
       0,0,0,5,4,5,4,
      0,4,5,3,6,7,6,7,
       6,7,6,7,4,5,4,
      0,4,5,4,2,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 179 */
    mode : GM_TIME_ATTACK,
    seed : 9000,
    time : 500,
    colors: {
      0,3,0,1,5,5,0,2,
       2,3,2,1,3,3,2,
      1,2,7,2,0,4,6,6,
       1,8,7,3,3,4,5,
      0,8,0,6,0,5,0,5,
       3,1,1,6,5,0,4,
      3,0,7,2,7,7,4,1,
       4,7,3,2,3,3,1,
      0,4,3,6,0,4,4,8,
       0,5,5,6,7,7,8,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 180 */
    mode : GM_TIME_ATTACK,
    seed : 9050,
    time : 500,
    colors: {
      2,0,0,1,2,0,0,7,
       1,4,5,6,0,0,8,
      2,0,0,4,5,6,7,0,
       1,4,5,6,0,0,8,
      2,0,0,4,5,6,7,0,
       1,4,5,6,0,0,8,
      2,0,0,4,5,6,7,0,
       1,4,5,6,0,0,8,
      2,0,0,4,5,6,7,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 181 */
    mode : GM_TIME_ATTACK,
    seed : 9100,
    time : 500,
    colors: {
      1,2,3,0,0,1,2,3,
       0,0,4,0,4,0,0,
      0,0,0,5,5,0,0,0,
       0,1,7,6,7,1,0,
      1,2,0,0,0,0,2,1,
       0,8,7,8,7,8,0,
      2,3,1,0,0,1,3,2,
       0,0,2,3,2,0,0,
      0,7,8,4,4,8,7,0,
       0,0,0,1,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 182 */
    mode : GM_TIME_ATTACK,
    seed : 9150,
    time : 500,
    colors: {
      0,5,6,7,1,3,0,0,
       0,0,5,2,4,0,0,
      0,0,3,1,5,6,7,0,
       0,0,4,2,0,5,0,
      0,5,6,7,1,3,0,0,
       0,0,5,2,4,0,0,
      0,0,3,1,5,6,7,0,
       0,0,4,2,0,5,0,
      0,5,6,7,1,3,0,0,
       0,0,5,2,4,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 183 */
    mode : GM_TIME_ATTACK,
    seed : 9200,
    time : 500,
    colors: {
      1,2,3,7,7,3,2,1,
       2,8,0,7,0,8,2,
      1,8,8,7,7,8,8,1,
       6,6,8,8,8,6,6,
      5,6,6,8,8,6,6,5,
       5,0,7,8,7,0,5,
      5,0,0,7,7,0,0,5,
       4,4,4,7,4,4,4,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 184 */
    mode : GM_TIME_ATTACK,
    seed : 9250,
    time : 500,
    colors: {
      1,4,2,1,1,4,2,1,
       1,3,1,1,1,3,1,
      1,2,1,0,0,1,2,1,
       7,1,1,1,1,1,7,
      4,0,1,0,0,1,0,4,
       2,3,1,0,1,3,2,
      3,4,1,1,1,1,4,3,
       2,7,0,1,0,7,2,
      1,1,0,0,0,0,1,1,
       1,0,0,0,0,0,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 185 */
    mode : GM_TIME_ATTACK,
    seed : 9300,
    time : 500,
    colors: {
      7,0,2,1,3,2,0,7,
       7,1,8,2,8,1,7,
      0,7,6,7,7,6,7,0,
       0,8,7,8,7,8,0,
      0,0,7,7,7,7,0,0,
       0,0,8,7,8,0,0,
      0,0,7,1,1,7,0,0,
       0,7,0,0,0,7,0,
      7,8,0,0,0,0,8,7,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 186 */
    mode : GM_TIME_ATTACK,
    seed : 9350,
    time : 500,
    colors: {
      0,0,0,2,3,0,0,0,
       0,0,4,1,4,0,0,
      0,0,1,2,3,1,0,0,
       0,0,4,1,4,0,0,
      1,2,3,2,3,2,1,2,
       0,4,1,4,1,4,0,
      0,3,2,0,0,2,3,0,
       0,4,1,4,1,4,0,
      0,3,2,0,0,2,3,0,
       0,4,1,4,1,4,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 187 */
    mode : GM_TIME_ATTACK,
    seed : 9400,
    time : 500,
    colors: {
      0,2,3,4,3,2,4,0,
       2,1,6,7,6,1,2,
      1,0,1,2,3,1,0,1,
       1,5,1,4,1,3,1,
      2,0,4,1,1,5,0,2,
       3,1,3,1,4,1,3,
      2,1,1,2,3,1,1,3,
       1,0,1,4,1,0,1,
      1,3,2,1,1,3,4,1,
       4,0,3,4,2,0,3,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 188 */
    mode : GM_TIME_ATTACK,
    seed : 9450,
    time : 500,
    colors: {
      0,0,4,1,1,4,0,0,
       0,1,2,3,2,1,0,
      0,1,0,4,5,0,1,0,
       4,3,0,6,0,3,4,
      0,1,2,4,5,2,1,0,
       1,3,0,6,0,3,1,
      0,1,2,4,5,2,1,0,
       4,3,0,6,0,3,4,
      0,1,2,3,2,3,1,0,
       0,4,1,1,4,1,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 189 */
    mode : GM_TIME_ATTACK,
    seed : 9500,
    time : 500,
    colors: {
      1,2,5,4,2,1,2,3,
       4,1,3,0,3,1,4,
      0,0,4,0,0,4,0,0,
       4,3,5,6,5,3,4,
      1,2,1,2,1,2,1,2,
       0,3,0,0,0,3,0,
      0,6,4,5,4,5,6,0,
       5,0,0,7,0,0,5,
      6,0,0,0,0,0,0,6,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 190 */
    mode : GM_TIME_ATTACK,
    seed : 9550,
    time : 500,
    colors: {
      1,1,2,3,3,4,5,5,
       6,7,7,8,1,1,2,
      0,3,3,0,0,4,4,0,
       5,5,7,8,7,6,6,
      1,1,0,2,2,0,3,3,
       8,7,6,5,4,2,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 191 */
    mode : GM_TIME_ATTACK,
    seed : 9600,
    time : 500,
    colors: {
      1,1,0,2,2,0,3,3,
       0,4,5,6,7,8,0,
      1,1,0,2,2,0,3,3,
       0,8,7,6,5,4,0,
      4,4,0,1,1,0,8,8,
       0,2,3,0,5,6,0,
      0,0,4,0,0,4,0,0,
       0,3,0,0,0,3,0,
      0,2,0,0,0,0,2,0,
       1,8,0,0,0,8,1,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 192 */
    mode : GM_TIME_ATTACK,
    seed : 9650,
    time : 500,
    colors: {
      8,7,6,5,4,3,2,1,
       0,1,2,0,7,8,0,
      0,3,0,4,1,0,2,0,
       0,5,6,0,3,4,0,
      8,7,6,5,4,3,2,1,
       0,1,2,0,7,8,0,
      0,3,0,4,1,0,2,0,
       0,5,6,0,3,4,0,
      8,7,6,5,4,3,2,1,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 193 */
    mode : GM_TIME_ATTACK,
    seed : 9700,
    time : 500,
    colors: {
      1,2,3,4,5,6,7,8,
       7,6,5,4,3,2,1,
      0,1,2,3,4,5,6,0,
       0,5,4,3,2,1,0,
      0,0,1,2,3,4,0,0,
       0,0,3,2,1,0,0,
      0,0,0,1,2,0,0,0,
       0,0,0,1,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 194 */
    mode : GM_TIME_ATTACK,
    seed : 9750,
    time : 500,
    colors: {
      8,7,6,5,8,7,6,5,
       4,3,2,0,4,3,2,
      0,1,8,0,0,1,8,0,
       0,7,0,0,0,7,0,
      0,0,8,7,6,5,0,0,
       0,0,4,3,2,0,0,
      0,0,0,1,8,0,0,0,
       0,0,0,7,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 195 */
    mode : GM_TIME_ATTACK,
    seed : 9800,
    time : 500,
    colors: {
      0,0,8,7,6,5,0,0,
       0,0,4,3,2,0,0,
      0,0,0,1,8,0,0,0,
       0,0,0,7,0,0,0,
      8,7,6,5,8,7,6,5,
       4,3,2,0,4,3,2,
      0,1,8,0,0,1,8,0,
       0,7,0,0,0,7,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 196 */
    mode : GM_TIME_ATTACK,
    seed : 9850,
    time : 500,
    colors: {
      0,1,2,0,0,1,2,0,
       3,4,5,0,3,4,5,
      0,6,7,1,2,6,7,0,
       1,2,3,4,5,1,2,
      3,4,5,6,7,3,4,5,
       6,7,1,2,1,6,7,
      0,0,2,0,0,2,0,0,
       0,1,0,0,0,1,0,
      0,0,2,0,0,2,0,0,
       0,0,1,2,1,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 197 */
    mode : GM_AVALANCHE,
    seed : 9900,
    time : 5,
    colors: {
      1,2,3,4,0,0,0,0,
       5,6,7,0,0,0,0,
      1,2,3,4,0,0,0,0,
       0,0,0,1,2,3,4,
      0,0,0,0,5,6,7,0,
       0,0,0,1,2,3,4,
      1,2,3,4,0,0,0,0,
       5,6,7,0,0,0,0,
      1,2,3,4,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 198 */
    mode : GM_TIME_ATTACK,
    seed : 9950,
    time : 500,
    colors: {
      1,2,3,4,5,6,7,8,
       7,6,5,4,3,2,1,
      8,1,2,3,4,5,6,7,
       1,7,6,5,4,3,2,
      7,8,1,2,3,4,5,6,
       2,1,7,6,5,4,3,
      6,7,8,1,2,3,4,5,
       3,2,1,7,6,5,4,
      5,6,7,8,1,2,3,4,
       4,3,2,1,7,6,5,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 199 */
    mode : GM_TIME_ATTACK,
    seed : 10000,
    time : 600,
    colors: {
      1,2,7,1,4,4,6,3,
       7,4,5,3,3,5,2,
      7,2,5,8,6,4,6,0,
       1,2,3,4,5,6,7,
      8,7,6,5,3,2,5,1,
       2,5,4,2,5,4,2,
      7,4,5,6,3,4,2,3,
       2,3,4,7,6,5,3,
      7,4,5,2,3,4,1,4,
       4,5,3,6,2,4,2,
      1,4,1,0,0,3,4,2,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  },
  { /* 200 */
    mode : GM_AVALANCHE,
    seed : 10051,
    time : 3,
    colors: {
      1,2,3,4,5,6,7,8,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,
    },
  }
};
