// generated by ../../../../tools/tube_transfer.py
// tube: 12AY7
// plate current function: triode
// mu: 44.16
// kx: 1.11
// kg1: 1192.4
// kg2: 0
// kp: 409.96
// kvb: 300
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_12AY7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	211.25744136465542,211.13846999615515,211.01935267310878,210.90008968063967,210.7806813033254,
	210.66112782519676,210.54142952973618,210.42158669987649,210.3015996179998,210.18146856593611,
	210.06119382496232,209.94077567580092,209.820214398619,209.69951027302744,209.5786635780794,
	209.45767459226983,209.3365435935343,209.21527085924797,209.09385666622512,208.97230129071812,
	208.8506050084165,208.72876809444634,208.6067908233697,208.48467346918363,208.36241630531984,
	208.2400196046438,208.11748363945426,207.99480868148294,207.87199500189357,207.74904287128172,
	207.62595255967435,207.50272433652916,207.37935847073442,207.2558552306087,207.13221488390005,
	207.00843769778623,206.88452393887428,206.76047387320014,206.63628776622855,206.5119658828529,
	206.387508487395,206.2629158436049,206.13818821466103,206.0133258631698,205.88832905116584,
	205.76319804011175,205.63793309089826,205.51253446384425,205.3870024186966,205.2613372146307,
	205.13553911024988,205.00960836358647,204.88354523210094,204.7573499726829,204.63102284165075,
	204.50456409475228,204.37797398716455,204.2512527734946,204.12440070777933,203.99741804348605,
	203.8703050335127,203.74306193018825,203.61568898527315,203.48818644995958,203.36055457487197,
	203.23279361006738,203.104903805036,202.97688540870163,202.84873866942203,202.72046383498972,
	202.59206115263225,202.46353086901286,202.3348732302311,202.2060884818234,202.0771768687634,
	201.948138635463,201.81897402577295,201.68968328298297,201.5602666498232,201.43072436846433,
	201.3010566805184,201.17126382703995,201.04134604852604,200.91130358491765,200.7811366756,
	200.65084555940376,200.52043047460538,200.38989165892818,200.2592293495433,200.1284437830702,
	199.99753519557777,199.86650382258514,199.73534989906267,199.60407365943237,199.47267533756963,
	199.34115516680336,199.20951337991744,199.07775020915145,198.94586588620157,198.81386064222193,
	198.68173470782492,198.54948831308306,198.41712168752906,198.28463506015785,198.15202865942666,
	198.01930271325668,197.886457449034,197.75349309361053,197.62040987330508,197.48720801390476,
	197.3538877406656,197.22044927831402,197.08689285104793,196.9532186825376,196.819426995927,
	196.685518013835,196.55149195835634,196.41734905106287,196.28308951300494,196.14871356471215,
	196.014221426195,195.87961331694555,195.74488945593941,195.61005006163623,195.47509535198117,
	195.34002554440627,195.20484085583152,195.06954150266637,194.93412770081048,194.79859966565547,
	194.66295761208607,194.52720175448138,194.3913323067159,194.25534948216136,194.11925349368747,
	193.98304455366352,193.84672287395983,193.71028866594867,193.5737421405059,193.4370835080122,
	193.30031297835438,193.16343076092687,193.02643706463283,192.88933209788573,192.75211606861055,
	192.61478918424527,192.47735165174217,192.3398036775693,192.20214546771174,192.0643772276731,
	191.92649916247672,191.78851147666737,191.6504143743124,191.51220805900329,191.37389273385705,
	191.23546860151757,191.09693586415702,190.95829472347745,190.81954538071207,190.68068803662666,
	190.54172289152115,190.40265014523095,190.2634699971284,190.12418264612444,189.98478829066954,
	189.84528712875593,189.7056793579183,189.56596517523568,189.42614477733292,189.286218360382,
	189.14618612010358,189.00604825176853,188.86580495019933,188.72545640977148,188.58500282441528,
	188.44444438761704,188.30378129242072,188.16301373142926,188.02214189680635,187.88116598027764,
	187.74008617313254,187.59890266622546,187.4576156499775,187.31622531437782,187.17473184898523,
	187.03313544292985,186.89143628491433,186.74963456321564,186.60773046568644,186.46572417975662,
	186.32361589243487,186.18140579031024,186.0390940595535,185.896680885919,185.7541664547459,
	185.61155095095972,185.46883455907405,185.32601746319216,185.18309984700815,185.04008189380886,
	184.8969637864753,184.75374570748403,184.61042783890903,184.4670103624231,184.32349345929927,
	184.17987731041245,184.03616209624118,183.8923479968688,183.74843519198532,183.60442386088891,
	183.4603141824873,183.31610633529945,183.17180049745724,183.02739684670675,182.88289556041002,
	182.7382968155466,182.59360078871495,182.44880765613425,182.30391759364585,182.15893077671458,
	182.01384738043083,181.86866757951177,181.7233915483028,181.57801946077947,181.43255149054892,
	181.28698781085117,181.14132859456117,180.99557401419,180.84972424188652,180.70377944943897,
	180.5577398082767,180.41160548947136,180.26537666373886,180.1190535014407,179.97263617258562,
	179.82612484683108,179.67951969348502,179.53282088150726,179.38602857951122,179.23914295576526,
	179.0921641781945,178.9450924143823,178.79792783157163,178.65067059666703,178.50332087623588,
	178.35587883651004,178.2083446433876,178.06071846243404,177.91300045888434,177.765190797644,
	177.61728964329114,177.46929716007756,177.3212135119307,177.17303886245506,177.0247733749337,
	176.87641721232998,176.727970537289,176.57943351213916,176.43080629889383,176.28208905925283,
	176.13328195460397,175.9843851460249,175.8353987942841,175.68632305984318,175.53715810285772,
	175.38790408317945,175.23856116035742,175.08912949363966,174.9396092419749,174.7900005640139,
	174.64030361811118,174.49051856232657,174.34064555442666,174.1906847518865,174.04063631189103,
	173.89050039133681,173.7402771468334,173.58996673470506,173.43956931099217,173.28908503145297,
	173.13851405156504,172.98785652652674,172.83711261125902,172.68628246040666,172.53536622834014,
	172.38436406915693,172.23327613668332,172.08210258447568,171.9308435658223,171.77949923374476,
	171.6280697409994,171.4765552400792,171.32495588321507,171.1732718223774,171.02150320927788,
	170.8696501953706,170.71771293185398,170.56569156967223,170.41358625951682,170.26139715182802,
	170.10912439679663,169.95676814436536,169.8043285442303,169.6518057458427,169.49919989841032,
	169.34651115089923,169.19373965203494,169.0408855503043,168.88794899395697,168.73493013100682,
	168.58182910923367,168.4286460761846,168.27538117917578,168.12203456529377,167.96860638139708,
	167.8150967741179,167.66150588986352,167.50783387481758,167.3540808749423,167.20024703597934,
	167.04633250345162,166.89233742266484,166.73826193870912,166.58410619646037,166.42987034058172,
	166.2755545155254,166.12115886553406,165.9666835346422,165.8121286666779,165.65749440526434,
	165.5027808938211,165.34798827556614,165.1931166935166,165.0381662904912,164.88313720911114,
	164.7280295918018,164.57284358079434,164.4175793181272,164.2622369456476,164.10681660501294,
	163.9513184376927,163.79574258496945,163.64008918794082,163.48435838752076,163.3285503244411,
	163.17266513925324,163.01670297232948,162.86066396386454,162.70454825387725,162.5483559822119,
	162.39208728853976,162.23574231236088,162.07932119300517,161.92282406963412,161.76625108124256,
	161.60960236665971,161.45287806455113,161.29607831341983,161.13920325160814,160.982253017299,
	160.82522774851768,160.668127583133,160.51095265885908,160.35370311325673,160.19637908373517,
	160.03898070755318,159.88150812182096,159.72396146350135,159.56634086941168,159.40864647622487,
	159.25087842047128,159.09303683854012,158.93512186668084,158.77713364100475,158.61907229748655,
	158.46093797196573,158.30273080014823,158.14445091760774,157.98609845978737,157.82767356200122,
	157.6691763594355,157.5106069871507,157.35196558008232,157.19325227304302,157.03446720072372,
	156.87561049769528,156.71668229840998,156.55768273720304,156.39861194829405,156.2394700657885,
	156.0802572236794,155.9209735558486,155.76161919606844,155.60219427800294,155.44269893520993,
	155.28313330114185,155.1234975091478,154.96379169247453,154.8040159842686,154.64417051757718,
	154.48425542534991,154.32427084044045,154.1642168956078,154.00409372351808,153.84390145674558,
	153.68364022777456,153.5233101690008,153.362911412733,153.20244409119417,153.0419083365233,
	152.88130428077682,152.7206320559299,152.5598917938784,152.39908362643985,152.23820768535523,
	152.07726410229043,151.91625300883786,151.7551745365176,151.59402881677929,151.43281598100333,
	151.27153616050256,151.1101894865238,150.94877609024905,150.78729610279717,150.62574965522566,
	150.46413687853163,150.3024579036536,150.14071286147296,149.97890188281548,149.81702509845277,
	149.6550826391037,149.493074635436,149.33100121806788,149.16886251756924,149.00665866446326,
	148.84438978922802,148.682056022298,148.5196574940654,148.3571943348816,148.19466667505904,
	148.03207464487224,147.86941837455973,147.70669799432514,147.543913634339,147.38106542474003,
	147.2181534956369,147.05517797710945,146.89213899921026,146.72903669196623,146.5658711853801,
	146.40264260943178,146.23935109407998,146.07599676926367,145.91257976490365,145.74910021090386,
	145.5855582371531,145.42195397352634,145.2582875498864,145.09455909608536,144.93076874196592,
	144.76691661736314,144.60300285210585,144.43902757601808,144.27499091892065,144.11089301063265,
	143.94673398097282,143.7825139597614,143.61823307682099,143.45389146197894,143.28948924506795,
	143.12502655592823,142.96050352440872,142.79592028036856,142.63127695367874,142.46657367422353,
	142.30181057190194,142.1369877766293,141.9721054183388,141.80716362698297,141.64216253253494,
	141.47710226499038,141.31198295436872,141.14680473071476,140.9815677241001,140.81627206462483,
	140.65091788241872,140.48550530764305,140.32003447049212,140.15450550119436,139.98891853001436,
	139.82327368725404,139.65757110325444,139.49181090839681,139.32599323310467,139.16011820784487,
	138.99418596312944,138.82819662951687,138.66215033761378,138.49604721807628,138.32988740161178,
	138.1636710189803,137.997398200996,137.83106907852869,137.66468378250556,137.49824244391252,
	137.3317451937957,137.16519216326319,136.9985834834864,136.83191928570167,136.66519970121175,
	136.49842486138738,136.33159489766896,136.1647099415677,135.99777012466782,135.8307755786273,
	135.66372643518017,135.49662282613747,135.3294648833893,135.16225273890606,134.99498652473994,
	134.82766637302697,134.66029241598793,134.49286478593038,134.32538361525005,134.15784903643254,
	133.99026118205472,133.82262018478636,133.65492617739184,133.48717929273155,133.31937966376367,
	133.15152742354556,132.9836227052355,132.81566564209422,132.64765636748655,132.47959501488305,
	132.31148171786143,132.1433166101085,131.9750998254215,131.80683149770974,131.6385117609965,
	131.47014074942032,131.3017185972369,131.13324543882067,130.96472140866632,130.7961466413906,
	130.62752127173394,130.45884543456222,130.29011926486808,130.12134289777316,129.95251646852932,
	129.78364011252057,129.61471396526483,129.44573816241524,129.27671283976252,129.10763813323618,
	128.93851417890636,128.76934111298584,128.60011907183147,128.4308481919462,128.2615286099806,
	128.09216046273482,127.92274388716042,127.7532790203621,127.58376599959946,127.41420496228898,
	127.2445960460058,127.07493938848549,126.90523512762617,126.73548340149014,126.56568434830594,
	126.39583810647015,126.22594481454948,126.05600461128263,125.88601763558225,125.71598402653694,
	125.54590392341329,125.37577746565789,125.20560479289932,125.03538604495037,124.86512136180993,
	124.69481088366527,124.52445475089407,124.35405310406662,124.18360608394805,124.01311383150048,
	123.84257648788517,123.67199419446509,123.50136709280696,123.33069532468345,123.15997903207595,
	122.98921835717668,122.81841344239119,122.64756443034082,122.47667146386515,122.30573468602455,
	122.13475424010292,121.96373026961008,121.79266291828453,121.62155233009622,121.45039864924924,
	121.27920202018454,121.10796258758299,120.93668049636807,120.76535589170898,120.59398891902357,
	120.42257972398147,120.25112845250715,120.07963525078323,119.90810026525361,119.7365236426269,
	119.56490552987977,119.39324607426049,119.22154542329237,119.04980372477753,118.87802112680038,
	118.70619777773179,118.53433382623257,118.36242942125772,118.19048471206045,118.01849984819623,
	117.84647497952726,117.67441025622666,117.50230582878315,117.3301618480055,117.15797846502737,
	116.98575583131209,116.81349409865776,116.6411934192022,116.46885394542838,116.29647583016973,
	116.12405922661571,115.95160428831761,115.77911116919425,115.60658002353819,115.43401100602188,
	115.26140427170412,115.08875997603666,114.91607827487084,114.74335932446479,114.57060328149053,
	114.39781030304152,114.22498054664015,114.05211417024572,113.87921133226274,113.70627219154905,
	113.53329690742483,113.36028563968125,113.18723854858989,113.01415579491231,112.84103753990978,
	112.66788394535358,112.49469517353546,112.32147138727852,112.14821274994851,111.97491942546534,
	111.8015915783152,111.62822937356277,111.45483297686442,111.28140255448115,111.10793827329248,
	110.93444030081058,110.76090880519517,110.58734395526852,110.41374592053131,110.24011487117895,
	110.06645097811847,109.89275441298595,109.71902534816465,109.54526395680378,109.37147041283798,
	109.19764489100729,109.02378756687816,108.84989861686492,108.67597821825227,108.50202654921846,
	108.32804378885916,108.15403011721271,107.9799857152856,107.80591076507946,107.63180544961878,
	107.45766995297969,107.28350446031968,107.10930915790881,106.93508423316159,106.76082987467035,
	106.58654627223973,106.41223361692255,106.23789210105696,106.06352191830487,105.88912326369203,
	105.71469633364953,105.54024132605674,105.36575844028604,105.19124787724913,105.01670983944506,
	104.84214453101028,104.66755215777023,104.4929329272932,104.31828704894598,104.14361473395195,
	103.96891619545097,103.79419164856178,103.6194413104468,103.44466540037924,103.26986413981288,
	103.09503775245447,102.9201864643389,102.74531050390716,102.57041010208754,102.39548549237935,
	102.22053691094062,102.04556459667853,101.87056879134356,101.69554973962714,101.5205076892632,
	101.3454428911334,101.17035559937656,100.99524607150208,100.82011456850802,100.64496135500326,
	100.46978669933486,100.29459087371981,100.11937415438221,99.94413682169534,99.76887916032967,
	99.593601459406,99.41830401265484,99.24298711858172,99.06765108063897,98.89229620740392,
	98.71692281276407,98.54153121610922,98.3661217425311,98.19069472303048,98.01525049473238,
	97.83978940110929,97.6643117922132,97.48881802491616,97.31330846316044,97.13778347821771,
	96.96224344895877,96.78668876213283,96.61111981265806,96.43553700392282,96.25994074809844,
	96.08433146646404,95.90870958974344,95.73307555845496,95.55742982327459,95.38177284541273,
	95.20610509700526,95.03042706151939,94.8547392341748,94.67904212238068,94.50333624618916,
	94.32762213876585,94.1519003468779,93.97617143140064,93.8004359678427,93.6246945468912,
	93.448947774977,93.273196274861,93.09744068624222,92.92168166638852,92.74591989079036,
	92.57015605383906,92.39439086952954,92.2186250721893,92.0428594172337,91.86709468194908,
	91.6913316663044,91.51557119379183,91.33981411229844,91.16406129500884,90.98831364134044,
	90.81257207791208,90.63683755954715,90.4611110703126,90.28539362459433,90.10968626821074,
	89.93399007956504,89.75830617083793,89.58263568922172,89.40697981819673,89.23133977885188,
	89.05571683125001,88.88011227583986,88.70452745491518,88.52896375412382,88.35342260402321,
	88.17790548169398,88.0024139123999,87.8269494713047,87.65151378524368,87.4761085345517,
	87.30073545494885,87.12539633948512,86.95009304054511,86.77482747191392,86.59960161090571,
	86.42441750055528,86.24927725187432,86.07418304617312,85.89913713744822,85.72414185483744,
	85.5491996051425,85.37431287541975,85.19948423564007,85.02471634141757,84.85001193680782,
	84.67537385717532,84.5008050321302,84.32630848853393,84.15188735357329,83.97754485790183,
	83.80328433884829,83.62910924368983,83.45502313298954,83.28102968399546,83.10713269409945,
	82.93333608435313,82.75964390303801,82.5860603292865,82.41258967674977,82.23923639730855,
	82.06600508482187,81.89290047890856,81.71992746875566,81.54709109694734,81.3743965633073,
	81.2018492287471,81.02945461911192,80.85721842901471,80.68514652564932,80.51324495257167,
	80.34151993343785,80.1699778756872,79.99862537415707,79.8274692146162,79.65651637720104,
	79.48577403974065,79.31524958095302,79.14495058349597,78.97488483685443,78.80506034004486,
	78.63548530411735,78.46616815443458,78.29711753270614,78.12834229875574,77.95985153199913,
	77.79165453260823,77.62376082233789,77.45618014499053,77.28892246649347,77.1219979745637,
	76.95541707793461,76.78919040511866,76.62332880268133,76.45784333300035,76.29274527148571,
	76.12804610323629,75.96375751910963,75.79989141118254,75.63645986758132,75.47347516666167,
	75.31094977052095,75.14889631782603,74.98732761594307,74.82625663235807,74.66569648537869,
	74.50566043411237,74.3461618677175,74.18721429392801,74.0288313268568,73.87102667408482,
	73.71381412304886,73.5572075267439,73.40122078876053,73.24586784768267,73.09116266087486,
	72.93711918769291,72.7837513721565,72.63107312512663,72.47909830603501,72.32784070421695,
	72.17731401990301,72.02753184492916,71.87850764322765,71.73025473116553,71.58278625779845,
	71.43611518511246,71.29025426832605,71.14521603632795,71.00101277232618,70.8576564947846,
	70.71515893872373,70.57353153746075,70.43278540486334,70.29293131819011,70.15397970158743,
	70.01594061031028,69.87882371573083,69.74263829119481,69.60739319878095,69.47309687701468,
	69.3397573295813,69.20738211507846,69.07597833784295,68.94555263987917,68.81611119391191,
	68.6876596975792,68.56020336877475,68.43374694214312,68.30829466672536,68.18385030474543,
	68.06041713152365,67.93799793649585,67.81659502531397,67.69621022299641,67.57684487809355,
	67.45849986782949,67.34117560417623,67.22487204081428,67.10958868093043,66.99532458580065,
	66.88207838410459,66.76984828191615,66.65863207331398,66.54842715155435,66.43923052074955,
	66.33103880799432,66.22384827588334,66.11765483536402,66.0124540588701,65.90824119368166,
	65.80501117546108,65.70275864191395,65.60147794652796,65.50116317234368,65.40180814571433,
	65.3034064500139,65.20595143925526,65.10943625158298,65.01385382260769,64.91919689855209,
	64.82545804918061,64.73262968048806,64.64070404712433,64.54967326453583,64.45952932080527,
	64.37026408817546,64.28186933424307,64.19433673281242,64.10765787439975,64.02182427638145,
	63.93682739278073,63.852658623689464,63.76930932432333,63.686770813709465,63.60503438300779,
	63.524091303468026,63.443932834025375,63.3645502285392,63.28593474267996,63.2080776404698,
	63.13097020048394,63.054603721719594,62.978969529140585,62.90405897890554,62.82986346328842,
	62.75637441530007,62.68358331302052,62.61148168365033,62.54006110729168,62.469313220467775,
	62.39922971939071,62.32980236298724,62.261022975691944,62.19288345001737,62.12537574891052,
	62.05849190790505,61.992224037077946,61.926564322820084,61.86150502942902,61.797038500532906,
	61.7331571603535,61.66985351481678,61.60712015251865,61.544949745553645,61.48333505021393,
	61.422268907565694,61.36174424391001,61.301754071134475,61.24229148696241,61.183349675105475,
	61.12492190532583,61.06700153341328,61.00958200108291,60.95265683579868,60.89621965052729,
	60.840264143427746,60.78478409748086,60.72977338006271,60.67522594246675,60.62113581937791,
	60.56749712830285,60.51430406894666,60.46155092261813,60.40923205146595,60.35734189782298,
	60.30587498345054,60.254825908771934,60.204189352083205,60.15396006874299,60.10413289034432,
	60.05470272386999,60.0056645508339,59.95701342640982,59.90874447854983,59.86085290709366,
	59.813333982870745,59.76618304679639,59.71939550896333,59.67296684773006,59.62689260880707,
	59.58116840434209,59.53578991200539,59.49075287407615,59.44605309653069,59.4016864481334,
	59.35764885953125,59.313936322352454,59.27054488830999,59.227470668310566,59.18470983156975,
	59.14225860473329,59.10011327100583,59.0582701692867,59.01672569331359,58.97547629081442,
	58.9345184626676,58.89384876207103,58.85346379372002,58.8133602129945,58.77353472515563,
	58.73398408455173,58.694705093834436,58.655694603184024,58.616949509545364,58.578466755873315,
	58.54024333038866,58.502276265844,58.464562638799755,58.42709956891056,58.389884218221916,
	58.35291379047686,58.31618553043292,58.279696723189446,58.24344469352473,58.20742680524374,
	58.17164046053529,58.136083099339835,58.10075219872672,58.06564527228157,58.030759869503356,
	57.99609357521126,57.961644008960924,57.927408824470554,57.89338570905616,57.85957238307632,
	57.82596659938601,57.79256614279973,57.759368829563435,57.726372506835595,57.693575052176826,
	57.66097437304832,57.62856840631881,57.596355117780064,57.564332501670414,57.53249858020692,
	57.500851403125296,57.46938904722795,57.43810961593979,57.40701123887192,57.37609207139282,
	57.34535029420702,57.31478411294133,57.28439175773798,57.25417148285539,57.22412156627563,
	57.194240309318744,57.164526036264235,57.13497709397895,57.10559185155155,57.07636869993363,
	57.047306051586965,57.01840234013726,56.9896560200338,56.96106556621527,56.93262947378144,
	56.90434625765645,56.87621445233093,56.84823261145986,56.820399307619624,56.79271313199164,
	56.765172694067374,56.737776621359004,56.71052355911462,56.68341217003896,56.656441134018905,
	56.62960914785374,56.60291492499042,56.57635719526321,56.549934704638325,56.52364621496259,
	56.49749050371701,56.47146636377439,56.44557260316126,56.419808044824116,56.39417152639956,
	56.36866189998876,56.34327803193558,56.3180188026088,56.29288310618794,56.26786985045318,
	56.24297795657847,56.21820635892872,56.19355400486015,56.169019854524315,56.14460288067553,
	56.120302068481536,56.09611641533743,56.07204493068305,56.04808663582318,56.02424056375108,
	56.000505758974995,55.9768812773476,55.95336618589846,55.9299595626693,55.90666049655208,
	55.88346808712982,55.860381444520286,55.83739968922216,55.814521951963876,55.79174737355505,
	55.76907510474042,55.746504306056266,55.72403414768916,55.70166380933723,55.679392480073645,
	55.657219358212465,55.6351436511767,55.61316457536858,55.591281356041975,55.569493227177006,
	55.54779943135663,55.5261992196454,55.50469185147007,55.483276594502314,55.46195272454346,
	55.440719525410735,55.41957628882586,55.39852231430514,55.37755690905149,55.356679387848224,
	55.33588907295449,55.315185294002454,55.2945673878963,55.2740346987125,55.25358657760213,
	55.233222382694414,55.21294147900206,55.1927432383279,55.1726270391733,55.1525922666477,
	55.132638312379925,55.1127645744307,55.09297045720656,55.07325537137529,55.0536187337825,
	55.03405996736968,55.01457850109342,54.995173769846026,54.975845214377195,54.95659228121718,
	54.93741442260092,54.918311096393445,54.89928176601649,54.880325900376164,54.86144297379177,
	54.842632465925696,54.823893861714524,54.805226651300984,54.78663032996713,54.76810439806845,
	54.74964836096901,54.73126172897756,54.71294401728466,54.69469474590078,54.67651343959524,
	54.65839962783606,54.640352844730984,54.62237262896898,54.604458523763014,54.58661007679335,
	54.56882684015194,54.55110837028751,54.53345422795155,54.51586397814501,54.49833719006587,
	54.480873437057426,54.463472296557406,54.4461333500478,54.42885618300532,54.41164038485286,
	54.39448554891132,54.377391272352455,54.36035715615215,54.34338280502908,54.32646782746285,
	54.30961183555185,54.29281444503594,54.2760752752361,54.25939394901168,54.242770092718196,
	54.226203336165995,54.20969331257923,54.193239658555584,54.176842014026484,54.160500022217995,
	54.14421332961211,54.127981585908636,54.11180444398777,54.09568155987297,54.07961259269445,
	54.0635972046533,54.047635060985854,54.03172582992874,54.01586918268443,54.00006479338711,
	53.984312339069255,53.968611499628366,53.95296195779447,53.937363399097855,53.92181551183729,
	53.90631798704884,53.89087051847481,53.875472802533416,53.86012453828868,53.844825427420716,
	53.829575174196584,53.81437348544142,53.79922007050997,53.78411464125842,53.7690569120169,
	53.75404659956193,53.739083423089596,53.724167104188936,53.709297366815576,53.69447393726597,
	53.67969654415175,53.66496491837459,53.650278793101116,53.635637903738655,53.62104198791069,
	53.606490785433124,53.59198403829065,53.57752149061337,53.56310288865383,53.54872798076438,
	53.53439651737469,53.520108250969706,53.505862936067686,53.49166032919887,53.47750018888401,
	53.463382275613434,53.44930635182636,53.43527218189036,53.4212795320812,53.4073281705629,
	53.39341786736801,53.379548394378126,53.365719525304776,53.35193103567044,53.338182702789744,
	53.324474305751096,53.31080562539836,53.29717644431283,53.283586546795476,53.27003571884929,
	53.256523748162024,53.24305042408896,53.22961553763599,53.21621888144295,53.202860249767035,
	53.1895394384665,53.17625624498453,53.163010468333425,53.14980190907871,53.13663036932372,
	53.123495652694224,53.11039756432328,53.09733591083619,53.08431050033584,53.07132114238799,
	53.05836764800682,53.04544982964074,53.03256750115824,53.019720477833985,53.00690857633509,
	52.99413161470742,52.981389412362304,52.96868179006309,52.95600856991221,52.943369575338075,
	52.93076463108232,52.91819356318719,52.90565619898294,52.89315236707554,52.880681897334384,
	52.86824462088037,52.85584037007376,52.84346897850248,52.83113028097056,52.818824113486414,
	52.80655031325157,52.794308718649454,52.78209916923409,52.76992150571925,52.75777556996754,
	52.745661204979626,52.73357825488359,52.72152656492447,52.70950598145383,52.697516351919546,
	52.68555752485557,52.67362934987192,52.66173167764484,52.649864359906836,52.63802724943709,
	52.626220200051804,52.61444306658118,52.60269570491577,52.59097797191116,52.57928972543788,
	52.56763082435714,52.55600112851179,52.54440049871747,52.53282879675393,52.52128588535612,
	52.5097716282059,52.498285889923324,52.486828536058326,52.475399433082465,52.46399844838064,
	52.45262545024297,52.4412803078568,52.42996289129873,52.41867307152681,52.40741072037262,
	52.39617571053373,52.384967915566,52.373787209876085,52.362633468714,52.351506568165746,
	52.340406385145954,52.32933279739076,52.31828568345067,52.307264922683416,52.296270395247056,
	52.285301982093046,52.27435956495937,52.26344302636384,52.252552249597294,52.24168711871707,
	52.23084751854045,52.2200333346381,52.20924445332771,52.19848076166767,52.1877421474507,
	52.1770284991977,52.16633970615155,52.155675658271086,52.145036246224976,52.13442136138585,
	52.12383089582433,52.11326474230321,52.10272279427168,52.09220494585954,52.0817110918717,
	52.071241127782315,52.06079494972949,52.0503724545096,52.03997353957193,52.029598103013306,
	52.01924604357275,52.008917260626134,51.998611654181076,51.988329124871726,51.97806957395355,
	51.96783290329841,51.95761901538948,51.94742781331627,51.937259200769674,51.92711308203727,
	51.91698936199829,51.9068879461189,51.896808740447646,51.88675165161048,51.876716586806424,
	51.86670345380278,51.856712160930684,51.846742617080544,51.83679473169771,51.82686841477786,
	51.81696357686285,51.80708012903624,51.7972179829191,51.78737705066572,51.777557244959425,
	51.767758479008386,51.75798066654158,51.74822372180464,51.738487559536125,51.72877209504654,
	51.719077244082776,51.709402922917306,51.699749048319426,51.690115537551456,51.680502308364865,
	51.67090927899653,51.661336368165045,51.65178349506689,51.642250579372906,51.632737541224515,
	51.62324430123028,51.613770780462154,51.604316900452176,51.59488258318868,51.58546775111307,
	51.57607232711634,51.566696234535534,51.55733939715051,51.54800173918052,51.53868318528102,
	51.52938366054018,51.52010309047587,51.510841401032245,51.501598518576685,51.492374369896574,
	51.48316888219618,51.473981983093545,51.464813600617425,51.45566366320425,51.44653209968876,
	51.43741883933121,51.42832381175799,51.419246947008936,51.41018817568148,51.40114742809611,
	51.39212463595989,51.38311973069931,51.37413264427893,51.36516330905936,51.35621165776469,
	51.34727762349542,51.338361139722515,51.32946214028476,51.32058055938602,51.311716331592734,
	51.30286939183115,51.294039675384816,51.28522711789207,51.27643165534332,51.26765322407874,
	51.25889176078561,51.25014720249587,51.24141948658378,51.23270855076321,51.22401433308561,
	51.21533677193731,51.20667580603727,51.198031374434706,51.189403416506764,51.180791871956245,
	51.172196680809236,51.16361778341294,51.15505512043334,51.14650863285296,51.137978261968776,
	51.12946394938986,51.120965637035326,51.11248326713211,51.10401678221288,51.09556612511385,
	51.08713123899738,51.07871206725696,51.07030855364709,51.06192064219768,51.05354827723191,
	51.04519140336421,51.036849965498284,51.028523908825065,51.0202131788209,51.01191772124545,
	51.00363748213989,50.995372407824796,50.98712244489854,50.97888754023514,50.97066764098255,
	50.96246269456075,50.95427264865995,50.9460974512387,50.937937050522194,50.92979139500033,
	50.92166043342612,50.91354411481377,50.905442388437,50.89735520382735,50.88928251077241,
	50.88122425931406,50.873180399747,50.86515088261677,50.85713565871835,50.84913467909436,
	50.84114789503348,50.833175258068856,50.825216719976396,50.81727223277329,50.809341748716356,
	50.8014252203005,50.79352260025712,50.785633841552624,50.777758897386846,50.76989772119153,
	50.762050266628925,50.75421648759007,50.746396338193556,50.7385897727839,50.73079674593013,
	50.72301721242434,50.71525112728024,50.707498445731744,50.69975912323159,50.69203311544983,
	50.684320378272595,50.676620867800544,50.66893454034762,50.66126135243968,50.653601260813026,
	50.64595422241326,50.638320194393806,50.630699134114664,50.623090999141034,50.615495747242115,
	50.60791333638977,50.60034372475723,50.59278687071785,50.58524273284388,50.57771126990517,
	50.570192440867956,50.562686204893616,50.55519252133748,50.54771134974762,50.54024264986364,
	50.532786381615445,50.52534250512211,50.517910980690736,50.51049176881521,50.503084830175084,
	50.49569012563449,50.48830761624085,50.48093726322395,50.47357902799466,50.466232872143856,
	50.45889875744142,50.451576645834955,50.44426649944893,50.4369682805834,50.42968195171303,
	50.42240747548607,50.4151448147232,50.40789393241652,50.40065479172865,50.39342735599142,
	50.38621158870512,50.37900745353732,50.37181491432194,50.3646339350582,50.35746447990968,
	50.3503065132033,50.34315999942831,50.336024903235426,50.32890118943573,50.32178882298517,
	50.31468776904086,50.30759799287609,50.30051945993419,50.29345213581426,50.2863959862702,
	50.27935097720974,50.27231707469364,50.2652942449347,50.25828245429696,50.25128166929472,
	50.24429185659162,50.23731298299998,50.23034501547962,50.22338792113731,50.21644166722567,
	50.20950622114246,50.20258155042965,50.19566762277267,50.18876440599945,50.181871868079774,
	50.17498997712428,50.16811870138375,50.16125800924824,50.1544078692464,50.147568250044465,
	50.140739120445666,50.13392044938933,50.127112205950134,50.120314359337335,50.11352687889403,
	50.10674973409625,50.09998289455239,50.093226330002366,50.08648001031684,50.079743905496514,
	50.073017985671406,50.0663022211001,50.05959658216899,50.05290103939161,50.04621556340786,
	50.0395401249834,50.03287469500874,50.0262192444988,50.019573744592,50.01293816654964,
	50.006312481755266,49.99969666171392,49.99309067805146,49.98649450251389,49.97990810696678,
	49.97333146339446,49.96676454389946,49.96020732070181,49.953659766138394,49.94712185266235,
	49.940593552842344,49.934074839362,49.92756568501927,49.9210660627257,49.91457594550598,
	49.908095306497174,49.90162411894816,49.895162356219046,49.88870999178049,49.88226699921315,
	49.87583335220712,49.86940902456124,49.86299399018252,49.856588223085666,49.850191697392354,
	49.843804387330714,49.83742626723479,49.8310573115439,49.824697494802066,49.81834679165752,
	49.81200517686209,49.805672625270674,49.7993491118406,49.79303461163122,49.786729099803274,
	49.78043255161832,49.77414494243826,49.7678662477248,49.761596443038876,49.75533550404016,
	49.7490834064865,49.74284012623348,49.73660563923379,49.73037992153678,49.72416294928795,
	49.71795469872842,49.71175514619443,49.70556426811683,49.69938204102066,49.69320844152448,
	49.687043446340084,49.68088703227188,49.67473917621639,49.66859985516196,49.66246904618799,
	49.65634672646467,49.65023287325245,49.644127463901555,49.638030475851565,49.63194188663085,
	49.625861673856214,49.619789815232394,49.61372628855164,49.60767107169318,49.60162414262283,
	49.5955854793926,49.589555060140114,49.5835328630883,49.57751886654489,49.57151304890199,
	49.565515388635646,49.559525864305456,49.55354445455405,49.54757113810678,49.54160589377124,
	49.53564870043681,49.52969953707433,49.52375838273558,49.517825216553,49.511900017739165,
	49.50598276558644,49.50007343946653,49.494172018830156,49.48827848320657,49.48239281220323,
	49.47651498550536,49.470644982875584,49.464782784153535,49.45892836925544,49.45308171817381,
	49.44724281097696,49.441411627808684,49.43558814888792,49.429772354508295,49.42396422503778,
	49.41816374091836,49.412370882665606,49.40658563086836,49.40080796618838,49.395037869359875,
	49.38927532118929,49.38352030255486,49.37777279440631,49.37203277776439,49.3663002337207,
	49.360575143437245,49.35485748814601,49.34914724914879,49.34344440781675,49.33774894559004,
	49.33206084397758,49.326380084556625,49.32070664897247,49.315040518938126,49.30938167623398,
	49.30373010270747,49.29808578027275,49.29244869091037,49.286818816666994,49.281196139655,
	49.275580642052255,49.269972306101735,49.264371114111206,49.258777048453,49.25319009156356,
	49.2476102259433,49.24203743415613,49.23647169882931,49.23091300265305,49.225361328380174,
	49.21981665882596,49.21427897686771,49.208748265444534,49.20322450755702,49.19770768626693,
	49.19219778469698,49.18669478603042,49.18119867351091,49.175709430442105,49.17022704018743,
	49.16475148616981,49.15928275187135,49.15382082083307,49.14836567665462,49.14291730299404,
	49.13747568356748,49.13204080214885,49.12661264256966,49.12119118871869,49.115776424541735,
	49.11036833404133,49.10496690127649,49.099572110362466,49.09418394547045,49.088802390809384,
	49.08342743069657,49.07805904945249,49.07269723146958,49.06734196119502,49.061993223130294,
	49.056651001831156,49.05131528190726,49.045986048021895,49.04066328489182,49.03534697728693,
	49.030037110030115,49.02473366799694,49.01943663611537,49.014145999365674,49.008861742780034,
	49.00358385144237,48.998312310488124,48.99304710510403,48.98778822052782,48.98253564204802,
	48.97728935500375,48.97204934478449,48.966815596829804,48.961588096629164,48.95636682972168,
	48.951151781695934,48.94594293818969,48.940740284889756,48.935543807531666,48.930353491899524,
	48.92516932382579,48.919991289191,48.91481937392368,48.909653563999925,48.90449384544341,
	48.899340204325036,48.894192626762774,48.88905109892137,48.88391560701234,48.87878613729351,
	48.87366267606899,48.86854520968888,48.86343372454912,48.85832820709123,48.853228643802154,
	48.848135021214055,48.84304732590412,48.83796554449429,48.832889663651166,48.82781967008579,
	48.82275555055335,48.81769729185312,48.8126448808282,48.80759830436532,48.802557549394685,
	48.79752260288975,48.79249345186702,48.78747008338591,48.782452484548564,48.77744064249959,
	48.77243454442593,48.767434177556694,48.76243952916293,48.75745058655748,48.75246733709483,
	48.747489768170766,48.74251786722243,48.73755162172795,48.73259101920641,48.727636047217544,
	48.722686693361624,48.71774294527931,48.712804790651425,48.707872217198855,48.70294521268223,
	48.69802376490194,48.69310786169786,48.688197490949165,48.6832926405742,48.678393298530374,
	48.67349945281385,48.66861109145945,48.663728202540604,48.65885077416896,48.65397879449445,
	48.64911225170492,48.64425113402611,48.63939542972152,48.63454512709209,48.62970021447615,
	48.62486068024931,48.62002651282418,48.6151977006503,48.61037423221399,48.6055560960381,
	48.60074328068199,48.59593577474126,48.59113356684767,48.58633664566899,48.581544999908786,
	48.57675861830635,48.57197748963646,48.56720160270936,48.562430946370455,48.5576655095003,
	48.552905281014425,48.548150249863085,48.54340040503128,48.538655735538484,48.53391623043852,
	48.5291818788195,48.524452669803644,48.51972859254704,48.51500963623964,48.51029579010509,
	48.50558704340056,48.500883385416564,48.49618480547693,48.49149129293859,48.48680283719148,
	48.482119427658375,48.47744105379475,48.47276770508871,48.46809937106079,48.46343604126381,
	48.45877770528284,48.45412435273498,48.449475973269244,48.44483255656643,48.4401940923391,
	48.43556057033122,48.43093198031826,48.42630831210695,48.42168955553517,48.41707570047184,
	48.412466736816825,48.40786265450071,48.40326344348476,48.39866909376084,48.39407959535112,
	48.38949493830814,48.384915112714616,48.38034010868323,48.37576991635672,48.371204525907494,
	48.36664392753779,48.3620881114793,48.35753706799327,48.35299078737019,48.34844925992985,
	48.3439124760211,48.33938042602179,48.33485310033868,48.33033048940717,48.32581258369148,
	48.32129937368424,48.31679084990653,48.31228700290777,48.30778782326551,48.30329330158546,
	48.29880342850126,48.294318194674396,48.28983759079418,48.28536160757749,48.28089023576881,
	48.27642346614002,48.2719612894903,48.2675036966461,48.26305067846094,48.25860222581537,
	48.254158329616814,48.24971898079947,48.24528417032432,48.24085388917884,48.23642812837697,
	48.232006878959126,48.22759013199197,48.223177878568265,48.21877010980694,48.21436681685285,
	48.209967990876734,48.20557362307513,48.20118370467019,48.19679822690972,48.19241718106691,
	48.188040558440406,48.183668350354104,48.179300548157116,48.17493714322356,48.17057812695264,
	48.16622349076838,48.16187322611971,48.15752732448015,48.15318577734786,48.148848576245584,
	48.144515712720406,48.14018717834382,48.13586296471147,48.131543063443246,48.127227466183015,
	48.122916164598635,48.11860915038185,48.11430641524821,48.11000795093684,48.105713749210636,
	48.101423801855894
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	211.25744136465542,211.13846999615515,211.01935267310884,210.90008968063967,210.78068130332542,
	210.66112782519676,210.5414295297362,210.42158669987649,210.30159961799984,210.18146856593611,
	210.06119382496232,209.94077567580092,209.82021439861902,209.69951027302744,209.5786635780794,
	209.45767459226985,209.3365435935343,209.21527085924797,209.09385666622512,208.97230129071815,
	208.8506050084165,208.72876809444634,208.6067908233697,208.48467346918366,208.3624163053198,
	208.2400196046438,208.11748363945432,207.99480868148294,207.87199500189357,207.74904287128172,
	207.62595255967435,207.50272433652916,207.37935847073442,207.2558552306087,207.13221488390002,
	207.00843769778623,206.88452393887434,206.76047387320014,206.63628776622855,206.5119658828529,
	206.387508487395,206.26291584360493,206.13818821466103,206.01332586316988,205.88832905116584,
	205.76319804011175,205.6379330908983,205.51253446384425,205.38700241869662,205.2613372146307,
	205.1355391102499,205.00960836358647,204.88354523210097,204.75734997268293,204.6310228416508,
	204.5045640947523,204.37797398716455,204.25125277349463,204.12440070777933,203.99741804348605,
	203.8703050335127,203.74306193018828,203.61568898527318,203.4881864499596,203.360554574872,
	203.2327936100674,203.104903805036,202.97688540870166,202.84873866942203,202.72046383498972,
	202.59206115263225,202.46353086901286,202.33487323023115,202.20608848182343,202.0771768687634,
	201.9481386354631,201.818974025773,201.68968328298303,201.56026664982323,201.43072436846438,
	201.30105668051849,201.17126382703998,201.0413460485261,200.91130358491768,200.7811366756001,
	200.65084555940382,200.5204304746054,200.38989165892826,200.25922934954338,200.12844378307028,
	199.9975351955779,199.86650382258526,199.7353498990627,199.60407365943246,199.4726753375697,
	199.34115516680345,199.20951337991752,199.07775020915147,198.9458658862017,198.813860642222,
	198.68173470782506,198.54948831308312,198.41712168752923,198.284635060158,198.15202865942678,
	198.01930271325685,197.88645744903414,197.75349309361064,197.62040987330528,197.48720801390493,
	197.35388774066575,197.22044927831425,197.08689285104808,196.95321868253777,196.81942699592722,
	196.68551801383524,196.55149195835656,196.4173490510631,196.28308951300517,196.14871356471244,
	196.01422142619523,195.8796133169458,195.7448894559397,195.6100500616365,195.47509535198145,
	195.3400255444066,195.20484085583186,195.0695415026667,194.9341277008108,194.79859966565584,
	194.66295761208644,194.5272017544817,194.3913323067163,194.25534948216176,194.1192534936879,
	193.983044553664,193.84672287396032,193.71028866594918,193.5737421405064,193.43708350801273,
	193.30031297835495,193.16343076092753,193.02643706463346,192.88933209788632,192.7521160686112,
	192.61478918424592,192.4773516517429,192.3398036775701,192.20214546771257,192.0643772276739,
	191.9264991624775,191.78851147666822,191.65041437431327,191.51220805900428,191.37389273385804,
	191.23546860151856,191.09693586415804,190.95829472347862,190.81954538071318,190.68068803662786,
	190.54172289152237,190.40265014523223,190.26346999712976,190.12418264612577,189.98478829067102,
	189.84528712875746,189.70567935791985,189.56596517523735,189.42614477733466,189.2862183603838,
	189.14618612010548,189.00604825177044,188.86580495020124,188.72545640977356,188.58500282441747,
	188.4444443876193,188.30378129242305,188.16301373143168,188.02214189680888,187.88116598028031,
	187.7400861731353,187.59890266622833,187.45761564998043,187.3162253143809,187.17473184898844,
	187.0331354429332,186.89143628491786,186.7496345632193,186.60773046569017,186.4657241797605,
	186.32361589243897,186.18140579031444,186.03909405955793,185.8966808859236,185.75416645475062,
	185.61155095096467,185.46883455907923,185.32601746319753,185.18309984701372,185.04008189381466,
	184.8969637864813,184.75374570749028,184.61042783891563,184.4670103624299,184.32349345930632,
	184.1798773104198,184.03616209624877,183.89234799687677,183.74843519199362,183.60442386089753,
	183.46031418249623,183.31610633530875,183.1718004974669,183.0273968467168,182.88289556042048,
	182.73829681555748,182.59360078872626,182.44880765614604,182.30391759365813,182.15893077672735,
	182.01384738044413,181.86866757952558,181.72339154831715,181.57801946079442,181.43255149056444,
	181.28698781086734,181.14132859457797,180.99557401420745,180.84972424190468,180.70377944945793,
	180.55773980829636,180.41160548949188,180.2653766637602,180.11905350146287,179.97263617260867,
	179.82612484685504,179.67951969350995,179.53282088153324,179.38602857953822,179.23914295579334,
	179.0921641782237,178.9450924144126,178.7979278316032,178.65067059669985,178.50332087627004,
	178.35587883654554,178.20834464342454,178.06071846247252,177.91300045892433,177.76519079768562,
	177.61728964333443,177.4692971601226,177.32121351197753,177.17303886250374,177.02477337498436,
	176.87641721238268,176.72797053734382,176.57943351219615,176.43080629895312,176.28208905931444,
	176.13328195466815,175.98438514609165,175.83539879435358,175.68632305991537,175.53715810293284,
	175.38790408325758,175.23856116043865,175.08912949372416,174.93960924206277,174.79000056410533,
	174.64030361820627,174.49051856242545,174.34064555452954,174.1906847519935,174.04063631200233,
	173.89050039145258,173.74027714695382,173.58996673483026,173.43956931112237,173.28908503158846,
	173.13851405170595,172.9878565266733,172.83711261141147,172.68628246056517,172.53536622850504,
	172.38436406932846,172.23327613686166,172.08210258466124,171.93084356601528,171.77949923394544,
	171.62806974120812,171.47655524029636,171.32495588344094,171.17327182261238,171.0215032095222,
	170.8696501956247,170.7177129321183,170.56569156994715,170.4135862598027,170.26139715212543,
	170.10912439710594,169.9567681446871,169.80432854456487,169.65180574619066,169.49919989877228,
	169.34651115127568,169.19373965242644,169.0408855507115,168.88794899438054,168.73493013144733,
	168.58182910969182,168.42864607666115,168.27538117967137,168.1220345658092,167.9686063819332,
	167.8150967746755,167.6615058904434,167.50783387542077,167.35408087556962,167.20024703663177,
	167.04633250413016,166.89233742337063,166.7382619394432,166.5841061972238,166.42987034137576,
	166.27555451635118,166.12115886639293,165.96668353553548,165.81212866760694,165.65749440623054,
	165.5027808948261,165.3479882766113,165.19311669460365,165.0381662916217,164.88313721028695,
	164.72802959302467,164.5728435820662,164.41757931944997,164.2622369470233,164.10681660644372,
	163.95131843918074,163.79574258651706,163.64008918955037,163.48435838919477,163.32855032618212,
	163.17266514106393,163.01670297421262,162.86066396582305,162.70454825591412,162.5483559843303,
	162.39208729074298,162.23574231465227,162.07932119538822,161.92282407211255,161.76625108382015,
	161.60960236934045,161.45287806733913,161.29607831631938,161.1392032546237,160.98225302043522,
	160.82522775177935,160.66812758652515,160.5109526623869,160.35370311692571,160.1963790875509,
	160.03898071152156,159.88150812594802,159.72396146779357,159.56634087387553,159.4086464808673,
	159.25087842529936,159.09303684356132,158.93512187190285,158.77713364643557,158.61907230313457,
	158.46093797783965,158.302730806257,158.1444509239608,157.98609846639448,157.82767356887248,
	157.66917636658158,157.51060699458247,157.3519655878112,157.19325228108087,157.03446720908295,
	156.87561050638868,156.71668230745098,156.55768274660542,156.3986119580723,156.23947007595766,
	156.08025723425504,155.920973566847,155.7616192075064,155.6021942898981,155.44269894758054,
	155.28313331400688,155.123497522527,154.96379170638852,154.80401599873863,154.64417053262545,
	154.48425544099956,154.32427085671551,154.16421691253325,154.00409374111987,153.84390147505067,
	153.68364024681108,153.523310188798,153.36291143332122,153.20244411260495,153.04190835878953,
	152.8813043039326,152.7206320800108,152.55989181892133,152.3990836524832,152.23820771243896,
	152.07726413045611,151.91625303812864,151.7551745669784,151.59402884845682,151.43281601394614,
	151.27153619476124,151.11018952215073,150.94877612729888,150.7872961413268,150.6257496952941,
	150.46413692020022,150.30245794698627,150.14071290653607,149.9789019296782,149.81702514718683,
	149.65508268978377,149.49307468813984,149.33100127287614,149.16886257456594,149.0066587237357,
	148.84438985086703,148.682056086398,148.51965756072457,148.35719440420203,148.19466674714695,
	148.03207471983802,147.86941845251818,147.7066980753957,147.54391371864577,147.38106551241216,
	147.2181535868086,147.05517807192038,146.8921390978055,146.7290367944968,146.565871292003,
	146.4026427203102,146.23935120938367,146.07599688916915,145.9125798895944,145.74910034057075,
	145.58555837199467,145.42195411374882,145.25828769570452,145.0945592477222,144.93076889965351,
	144.7669167813428,144.60300302262849,144.43902775334465,144.2749911033224,144.11089320239168,
	143.9467341803825,143.78251416712675,143.6182332924593,143.45389168621995,143.28948947825475,
	143.12502679841742,142.96050377657116,142.7959205425899,142.63127722635997,142.46657395778158,
	142.3018108667705,142.1369880832592,141.97210573719886,141.80716395856072,141.64216287733726,
	141.47710262354443,141.31198332722258,141.14680511843844,140.9815681272862,140.8162724838896,
	140.650918318403,140.48550576101317,140.3200349419409,140.1545059914423,139.9889190398106,
	139.82327421737762,139.6575716545153,139.4918114816373,139.3259938292006,139.16011882770695,
	138.99418660770456,138.82819729978974,138.66215103460823,138.49604794285707,138.3298881552859,
	138.1636718026989,137.99739901595598,137.83106992597465,137.66468466373172,137.49824336026455,
	137.33174614667286,137.1651931541205,136.99858451383673,136.8319203571181,136.66520081533005,
	136.4984260199085,136.33159610236135,136.16471119427047,135.997771427293,135.83077693316326,
	135.6637278436943,135.49662429077952,135.32946640639454,135.1622543225987,134.9949881715368,
	134.82766808544088,134.66029419663187,134.4928666375213,134.325385540613,134.15785103850502,
	133.990263263891,133.82262234956244,133.65492842840993,133.4871816334254,133.3193820977036,
	133.1515299544439,132.98362533695234,132.81566837864332,132.64765921304118,132.47959797378263,
	132.31148479461805,132.14331980941364,131.9751031521534,131.80683495694066,131.63851535800043,
	131.47014448968122,131.3017224864567,131.1332494829281,130.9647256138261,130.7961510140125,
	130.62752581848284,130.45885016236792,130.29012418093617,130.12134800959566,129.95252178389632,
	129.78364563953198,129.6147197123426,129.4457441383164,129.2767190535922,129.10764459446162,
	128.93852089737143,128.76934809892563,128.60012633588823,128.43085574518526,128.26153646390725,
	128.0921686293119,127.92275237882642,127.75328785004996,127.58377518075636,127.41421450889675,
	127.24460597260203,127.07494971018592,126.9052458601473,126.73549456117331,126.56569595214205,
	126.39585017212558,126.22595736039285,126.05601765641268,125.88603119985684,125.71599813060331,
	125.54591858873933,125.37579271456465,125.20562064859507,125.03540253156577,124.86513850443464,
	124.69482870838607,124.52447328483441,124.3540723754279,124.18362612205229,124.01313466683484,
	123.84259815214845,123.67201672061552,123.5013905151123,123.33071967877326,123.1600043549953,
	122.9892446874425,122.81844082005071,122.64759289703235,122.4767010628812,122.30576546237761,
	122.1347862405936,121.96376354289819,121.79269751496287,121.62158830276724,121.4504360526049,
	121.27924091108932,121.10800302515989,120.93672254208848,120.76539960948581,120.59403437530811,
	120.42262698786422,120.25117759582247,120.07968634821832,119.90815339446165,119.73657888434481,
	119.56496296805054,119.39330579616043,119.22160751966334,119.04986828996441,118.87808825889421,
	118.70626757871813,118.53440640214626,118.36250488234334,118.19056317293946,118.0185814280405,
	117.84655980223967,117.67449845062872,117.50239752881002,117.33025719290899,117.15807759958666,
	116.9858589060531,116.81360127008087,116.64130485001937,116.46896980480939,116.29659629399826,
	116.12418447775568,115.9517345168897,115.77924657286391,115.60672080781471,115.43415738456925,
	115.26155646666447,115.08891821836617,114.9162428046894,114.74353039141907,114.57078114513163,
	114.39799523321754,114.22517282390436,114.05231408628075,113.87941919032166,113.7064883069139,
	113.53352160788323,113.360519266022,113.18748145511805,113.01440834998463,112.84130012649152,
	112.66815696159718,112.49497903338205,112.32176652108346,112.1485196051314,111.9752384671859,
	111.80192329017575,111.62857425833872,111.45519155726328,111.28177537393182,111.10832589676563,
	110.93484331567151,110.76132782209018,110.58777960904658,110.41419887120189,110.24058580490782,
	110.06694060826275,109.89326348117011,109.71955462539889,109.54581424464665,109.37204254460471,
	109.19823973302616,109.02440601979596,108.85054161700432,108.6766467390225,108.5027216025816,
	108.32876642685449,108.15478143354068,107.9807668469548,107.80672289411801,107.63264980485337,
	107.45854781188454,107.28441715093862,107.1102580608525,106.93607078368383,106.76185556482575,
	106.58761265312647,106.41334230101323,106.23904476462106,106.06472030392642,105.89036918288635,
	105.71599166958244,105.54158803637098,105.3671585600379,105.19270352196112,105.01822320827787,
	104.84371791005911,104.66918792349045,104.49463355006,104.32005509675368,104.14545287625782,
	103.9708272071697,103.7961784142159,103.62150682847947,103.44681278763554,103.272096636196,
	103.09735872576353,102.9225994152956,102.74781907137833,102.57301806851093,102.39819678940098,
	102.22335562527111,102.04849497617731,101.87361525133933,101.69871686948376,101.52380025920021,
	101.34886585931093,101.17391411925458,100.99894549948439,100.8239604718818,100.64895952018517,
	100.47394314043538,100.29891184143763,100.12386614524111,99.94880658763637,99.77373371867186,
	99.5986481031892,99.423550321379,99.24844096935728,99.07332065976345,98.89819002238045,
	98.72304970477795,98.54790037297944,98.37274271215404,98.19757742733356,98.02240524415632,
	97.8472269096379,97.67204319297034,97.49685488635029,97.32166280583743,97.1464677922439,
	96.97127071205588,96.7960724583883,96.6208739519739,96.4456761421874,96.27048000810629,
	96.09528655960901,95.92009683851211,95.74491191974685,95.56973291257744,95.39456096186116,
	95.21939724935213,95.04424299504998,94.86909945859439,94.69396794070705,94.5188497846822,
	94.34374637792706,94.16865915355336,93.9935895920215,93.8185392228384,93.6435096263103,
	93.46850243535222,93.29351933735477,93.11856207610971,92.943632453796,92.76873233302668,
	92.59386363895844,92.41902836146467,92.2442285573729,92.06946635276815,91.89474394536248,
	91.72006360693217,91.5454276858227,91.37083860952289,91.19629888730809,91.02181111295323,
	90.84737796751597,90.67300222218995,90.49868674122833,90.3244344849371,90.15024851273812,
	89.97613198630101,89.80208817274303,89.62812044789601,89.45423229963859,89.28042733129415,
	89.10670926508278,88.93308194564723,88.75954934362146,88.58611555925971,88.41278482611405,
	88.23956151475787,88.06645013655076,87.89345534743983,87.72058195179213,87.54783490625115,
	87.37521932361207,87.20274047670694,87.03040380229301,86.85821490493466,86.68617956086973,
	86.51430372185042,86.3425935189472,86.17105526630445,85.99969546483526,85.82852080584135,
	85.65753817454494,85.48675465351634,85.3161775259818,85.14581427899475,84.97567260645243,
	84.80576041193918,84.63608581137714,84.46665713546369,84.29748293187454,84.12857196721039,
	83.9599332286646,83.79157592538812,83.62350948952812,83.45574357691505,83.28828806737381,
	83.1211530646331,82.95434889580747,82.78788611042647,82.62177547898497,82.45602799098883,
	82.29065485247139,82.12566748295559,81.96107751183759,81.79689677416901,81.63313730581623,
	81.4698113379753,81.30693129102396,81.14450976769373,80.9825595455464,80.82109356874254,
	80.66012493909176,80.49966690637696,80.33973285794863,80.18033630758798,80.02149088364115,
	79.86321031643108,79.70550842495699,79.54839910289556,79.39189630392279,79.23601402637853,
	79.0807662973021,78.92616715586996,78.77223063627213,78.61897075006824,78.4664014680685,
	78.31453670178892,78.16339028453503,78.01297595217137,77.86330732363822,77.71439788128053,
	77.56626095105685,77.41890968269828,77.27235702989086,77.12661573055532,76.98169828729993,
	76.83761694812328,76.69438368744302,76.55201018752724,76.41050782040386,76.26988763032105,
	76.13016031683148,75.99133621856826,75.85342529777942,75.71643712568219,75.58038086869556,
	75.44526527560407,75.31109866570159,75.17788891795719,75.04564346124104,74.91436926564137,
	74.78407283489743,74.65476019996785,74.5264369137469,74.39910804693466,74.2727781850622,
	74.1474514266648,74.0231313825921,73.89982117643721,73.777523446062,73.6562403461901,
	73.53597355203519,73.41672426392664,73.2984932128918,73.18128066714966,73.06508643946785,
	72.94990989533275,72.83574996187934,72.72260513752644,72.6104735022612,72.49935272851617,
	72.3892400925816,72.2801324864952,72.172026430353,72.06491808498424,71.95880326493517,
	71.85367745170755,71.74953580719918,71.64637318729572,71.5441841555648,71.44296299700606,
	71.34270373181232,71.24340012910027,71.14504572057119,71.04763381406478,70.9511575069721,
	70.8556096994756,70.7609831075879,70.66727027596265,70.5744635904536,70.48255529040107,
	70.39153748062664,70.30140214311973,70.2121411484022,70.12374626655858,70.03620917792239,
	69.94952148341035,69.86367471449869,69.77866034283676,69.69446978949581,69.61109443385128,
	69.52852562209871,69.44675467540522,69.36577289769849,69.2855715830974,69.20614202298856,
	69.12747551275469,69.0495633581602,68.97239688140195,68.89596742683155,68.82026636635798,
	68.74528510453834,68.67101508336576,68.59744778676324,68.52457474479296,68.45238753758976,
	68.38087779902934,68.31003722013956,68.23985755226528,68.17033060999584,68.10144827386497,
	68.03320249283209,67.96558528655486,67.89858874746179,67.83220504263397,67.76642641550475,
	67.70124518738604,67.63665375882964,67.5726446108318,67.5092103058889,67.44634348891205,
	67.38403688800841,67.32228331513564,67.26107566663761,67.20040692366709,67.14027015250282,
	67.08065850476643,67.0215652175324,66.9629836134188,66.90490710045418,66.84732917201264,
	66.79024340660206,66.73364346760056,66.6775231029302,66.62187614467256,66.56669650863033,
	66.51197819383893,66.4577152820317,66.40390193706288,66.35053240429109,66.29760100992712,
	66.24510216034871,66.1930303413857,66.14138011757768,66.09014613140751,66.0393231025123,
	65.98890582687515,65.938889175999,65.88926809606494,65.84003760707736,65.79119280199701,
	65.74272884586416,65.69464097491348,65.64692449568184,65.59957478411087,65.55258728464518,
	65.50595750932764,65.4596810368932,65.4137535118616,65.36817064363073,65.32292820557112,
	65.27802203412237,65.23344802789286,65.18920214676277,65.14528041099149,65.10167890033023,
	65.0583937531399,65.0154211655152,64.97275739041523,64.93039873680115,64.88834156878134,
	64.84658230476411,64.80511741661884,64.76394342884525,64.72305691775162,64.68245451064182,
	64.64213288501146,64.60208876775347,64.56231893437315,64.52282020821282,64.48358945968627,
	64.44462360552309,64.40591960802287,64.36747447431955,64.32928525565566,64.29134904666677,
	64.25366298467598,64.21622424899867,64.17903006025715,64.14207767970557,64.10536440856482,
	64.06888758736756,64.03264459531317,63.99663284963263,63.96084980496337,63.925292952733805,
	63.88995982055777,63.85484797163849,63.81995500418222,63.785278550821346,63.75081627804684,
	63.71656588565017,63.68252510617424,63.64869170437355,63.61506347668339,63.58163825069779,
	63.548413884656384,63.51538826693985,63.482559315574086,63.44992497774256,63.417483229307315,
	63.38523207433787,63.353169544648566,63.32129369934352,63.289602624369806,63.258094432078124,
	63.22676726079132,63.19561927438016,63.164648661846826,63.13385363691544,63.10323243762985,
	63.07278332595853,63.042504587406306,63.012394530633046,62.98245148707888,62.95267381059626,
	62.923059877088306,62.89360808415361,62.86431685073741,62.83518461678879,62.8062098429239,
	62.77739101009539,62.74872661926749,62.7202151910968,62.691855265618905,62.663645401940386,
	62.63558417792228,62.60767018994071,62.57990205250623,62.55227839803777,62.524797876565565,
	62.497459155454315,62.47026091913157,62.44320186882062,62.416280722278415,62.38949621353772,
	62.362847092654185,62.33633212545763,62.309950093307776,62.28369979285435,62.25758003580125,
	62.23158964867498,62.20572747259706,62.179992363060435,62.15438318970991,62.12889883612625,
	62.10353819961408,62.0783001909937,62.053183734396114,62.02818776706204,62.00331123914421,
	61.978553113513044,61.95391236556578,61.92938798303897,61.90497896582407,61.88068432578627,
	61.85650308658647,61.83243428350631,61.80847696327613,61.78463018390599,61.76089301451957,
	61.73726453519077,61.71374383678319,61.690330020792516,61.66702219919121,61.643819494276194,
	61.620721038518866,61.59772597441782,61.57483345435395,61.55204264044807,61.52935270442078,
	61.50676282745496,61.484272200060346,61.46188002194029,61.43958550186109,61.417387857523224,
	61.395286315434696,61.37328011078678,61.35136848733149,61.3295506972612,61.307826001090405,
	61.28619366753914,61.2646529734186,61.24320320351844,61.221843650496,61.20057361476733,
	61.1793924044,61.15829933500772,61.13729372964646,61.116374918712495,61.09554223984199,
	61.07479503781227,61.05413266444447,61.033554478508115,61.01305984562693,60.9926481381862,
	60.97231873524179,60.95207102243044,60.93190439188155,60.91181824213032,60.89181197803242,
	60.87188501067972,60.85203675731774,60.832266641264006,60.81257409182797,60.79295854423208,
	60.77341943953404,60.753956224550414,60.73456835178124,60.715255279336084,60.69601647086089,
	60.676851395466265,60.65775952765672,60.638740347261056,60.619793339363774,60.60091799423763,
	60.582113807277075,60.563380278932854,60.54471691464754,60.526123224792016,60.507598724603035,
	60.48914293412153,60.47075537813218,60.452435586103405,60.43418309212877,60.415997434869,
	60.397878157494816,60.379824807630776,60.36183693729994,60.34391410286921,60.326055864995666,
	60.30826178857356,60.290531442682216,60.27286440053453,60.25526023942643,60.237718540686934,
	60.22023888962896,60.202820875500954,60.18546409143904,60.16816813442006,60.15093260521519,
	60.13375710834422,60.1166412520306,60.09958464815697,60.08258691222143,60.06564766329451,
	60.04876652397661,60.03194312035607,60.01517708196801,59.99846804175349,59.981815636019476,
	59.96521950439924,59.94867928981343,59.932194638431504,59.915765199633945,59.89939062597487,
	59.88307057314508,59.866804699935905,59.8505926682032,59.83443414283212,59.818328791702285,
	59.80227628565343,59.78627629845142,59.77032850675504,59.75443259008286,59.738588230780834,
	59.72279511399024,59.70705292761604,59.691361362295716,59.67572011136856,59.660128870845234,
	59.64458733937795,59.62909521823087,59.61365221125102,59.5982580248396,59.58291236792354,
	59.56761495192761,59.55236549074681,59.53716370071922,59.522009300598974,59.50690201152992,
	59.49184155701939,59.47682766291244,59.46186005736638,59.4469384708256,59.432062635996836,
	59.41723228782469,59.402447163467414,59.38770700227317,59.37301154575645,59.35836053757491,
	59.34375372350635,59.32919085142625,59.314671671285254,59.30019593507111,59.285763396852644,
	59.27137381265801,59.25702694052143,59.242722540445,59.228460374377995,59.2142402061966,
	59.20006180168355,59.18592492850846,59.171829356208086,59.157774856166945,59.143761201598245,
	59.12978816752482,59.11585553076074,59.10196306989261,59.08811056526152,59.07429779894504,
	59.0605245547395,59.04679061814242,59.033095776335195,59.01943981816606,59.005822534133166,
	58.99224371636792,58.97870315861847,58.965200656233456,58.951736006145985,58.93830900685773,
	58.92491945842321,58.91156716243433,58.89825192200507,58.88497354175646,58.871731827801455,
	58.85852658773036,58.84535763059612,58.832224766900026,58.81912780857746,58.80606656898377,
	58.79304086288046,58.780050506421425,58.767095317139365,58.75417511393244,58.741289717051025,
	58.72843894808454,58.715622629948626,58.70284058687232,58.690092644385366,58.67737862930588,
	58.66469836972781,58.652051695008964,58.639438435758784,58.62685842382655,58.61431149228954,
	58.60179747544142,58.58931620878076,58.57686752899962,58.56445127397238,58.55206728274456,
	58.53971539552192,58.52739545365944,58.51510729965088,58.50285077711781,58.49062573079948,
	58.478432006542135,58.46626945128899,58.454137913069964,58.44203724099177,58.42996728522785,
	58.41792789700873,58.405918928612245,58.393940233353966,58.3819916655778,58.370073080646506,
	58.358184334932496,58.34632528580877,58.33449579163962,58.32269571177191,58.31092490652608,
	58.29918323718745,58.287470565997495,58.275786756145344,58.26413167175924,58.2525051778982,
	58.24090714054371,58.22933742659151,58.217795903843495,58.2062824409997,58.19479690765033,
	58.18333917426794,58.171909112199664,58.16050659365951,58.14913149172076,58.1377836803085,
	58.126463034192135,58.11516942897798,58.103902741102104,58.09266284782304,58.081449627214674,
	58.070262958159184,58.05910272034008,58.047968794235345,58.03686106111046,58.025779403011846,
	58.01472370275998,58.00369384394291,57.99268971090974,57.9817111887639,57.970758163357075,
	57.95983052128261,57.948928149869374,57.93805093717542,57.927198771981935,57.91637154378713,
	57.905569142800175,57.8947914599353,57.884038386805855,57.873309815718436,57.86260563966724,
	57.85192575232813,57.84127004805318,57.83063842186496,57.82003076945096,57.809446987158246,
	57.79888697198781,57.78835062158938,57.777837834256005,57.76734850891873,57.756882545141536,
	57.74643984311598,57.73602030365622,57.725623828193896,57.715250318773094,57.704899678045436,
	57.69457180926512,57.68426661628404,57.67398400354705,57.66372387608711,57.653486139520574,
	57.64327070004256,57.63307746442224,57.62290633999832,57.61275723467452,57.602630056914975,
	57.592524715739934,57.582441120721114,57.572379181977645,57.56233881017145,57.552319916503166,
	57.54232241270782,57.53234621105065,57.52239122432285,57.512457365837705,57.50254454942619,
	57.49265268943317,57.482781700713275,57.47293149862698,57.46310199903672,57.45329311830284,
	57.443504773280004,57.43373688131314,57.42398936023377,57.41426212835628,57.40455510447416,
	57.39486820785641,57.38520135824379,57.37555447584529,57.36592748133459,57.3563202958464,
	57.346732840973125,57.337165038761285,57.32761681170804,57.3180880827579,57.30857877529929,
	57.299088813161184,57.28961812060985,57.28016662234548,57.27073424349907,57.26132090962908,
	57.251926546718266,57.24255108117055,57.23319443980792,57.2238565498672,57.214537338997125,
	57.20523673525514,57.19595466710451,57.186691063411274,57.17744585344121,57.16821896685709,
	57.15901033371553,57.149819884464236,57.14064754993913,57.13149326136151,57.122356950335266,
	57.113238548843995,57.104137989248365,57.09505520428332,57.085990127055354,57.07694269103988,
	57.0679128300785,57.05890047837644,57.049905570499874,57.04092804137335,57.03196782627726,
	57.02302486084519,57.014099081061566,57.005190423258945,56.99629882411571,56.98742422065353,
	56.97856655023488,56.9697257505608,56.96090175966823,56.952094515927904,56.943303958041845,
	56.934530025041056,56.92577265628324,56.917031791450476,56.908307370546936,56.899599333896695,
	56.89090762214144,56.88223217623826,56.8735729374575,56.86492984738051,56.8563028478975,
	56.8476918812055,56.8390968898061,56.83051781650344,56.82195460440208,56.81340719690498,
	56.80487553771139,56.7963595708148,56.787859240501064,56.77937449134624,56.77090526821469,
	56.76245151625711,56.75401318090852,56.745590207886515,56.73718254318905,56.7287901330928,
	56.720412924151155,56.71205086319242,56.70370389731786,56.69537197389994,56.68705504058054,
	56.678753045268984,56.6704659361405,56.66219366163415,56.65393617045133,56.645693411553836,
	56.63746533416225,56.62925188775415,56.621053022062426,56.61286868707358,56.60469883302607,
	56.59654341040863,56.588402369958644,56.58027566266043,56.572163239743716,56.564065052681954,
	56.555981053190806,56.54791119322647,56.5398554249841,56.531813700896365,56.523785973631824,
	56.51577219609332,56.50777232141662,56.49978630296875,56.491814094346616,56.48385564937543,
	56.47591092210731,56.46797986680406,56.4600624379991,56.45215859040011,56.44426827895215,
	56.43639145881991,56.42852808538646,56.42067811425159,56.41284150123073,56.40501820235329,
	56.39720817386155,56.38941137220912,56.38162775405969,56.37385727628567,56.36609989596694,
	56.358355570389406,56.35062425704385,56.3429059136245,56.33520049802788,56.327507968351455,
	56.31982828289239,56.31216140014636,56.304507278806156,56.296865877760666,56.289237156093485,
	56.2816210730818,56.27401758819511,56.2664266610941,56.25884825162947,56.25128231984063,
	56.24372882595472,56.236187730385296,56.22865899373127,56.221142576775776,56.213638440484964,
	56.20614654600694,56.19866685467063,56.191199327984684,56.18374392763638,56.17630061549054,
	56.16886935358844,56.16145010414668,56.154042829556275,56.14664749238142,56.139264055358545,
	56.13189248139529,56.12453273356937,56.11718477512766,56.10984856948515,56.10252408022385,
	56.09521127109188,56.08791010600248,56.08062054903294,56.07334256442374,56.06607611657743,
	56.0588211700578,56.051577689588804,56.04434564005375,56.03712498649417,56.02991569410906,
	56.02271772825385,56.015531054439506,56.008355638331594,56.001191445749356,55.99403844266492,
	55.986896595202225,55.9797658696363,55.97264623239221,55.96553765004434,55.95844008931542,
	55.95135351707569,55.944277900342065,55.9372132062772,55.93015940218874,55.92311645552847,
	55.916084333891376,55.90906300501493,55.902052436778206,55.89505259720113,55.88806345444355,
	55.88108497680455,55.87411713272159,55.867159890769706,55.86021321966074,55.853277088242606,
	55.84635146549839,55.83943632054566,55.83253162263576,55.82563734115286,55.81875344561345,
	55.811879905665336,55.80501669108711,55.798163771787245,55.79132111780346,55.784488699302,
	55.7776664865768,55.7708544500489,55.76405256026559,55.757260787899895,55.75047910374966,
	55.74370747873695,55.73694588390744,55.73019429042948,55.723452669593726,55.716720992812164,
	55.70999923161767,55.70328735766318,55.69658534272107,55.689893158682565,55.68321077755693,
	55.67653817147098,55.66987531266834,55.663222173508785,55.656578726467686,55.64994494413528,
	55.643320799216085,55.636706264528314,55.63010131300314,55.623505917684206,55.61692005172689,
	55.610343688397826,55.60377680107418,55.59721936324306,55.59067134850106,55.58413273055344,
	55.57760348321375,55.571083580403105,55.56457299614965,55.55807170458797,55.551579679958564,
	55.54509689660719,55.538623328984386,55.53215895164483,55.52570373924684,55.5192576665518,
	55.51282070842357,55.50639283982798,55.49997403583234,55.49356427160474,55.48716352241368,
	55.480771763627445,55.474388970713576,55.46801511923839,55.46165018486642,55.45529414335989,
	55.44894697057824,55.442608642477566,55.436279135110134,55.42995842462388,55.423646487261884,
	55.41734329936191,55.41104883735582,55.4047630777692,55.398485997220824,55.39221757242212,
	55.38595778017671,55.37970659737997,55.37346400101855,55.367229968169795,55.36100447600144,
	55.354787501770986,55.348579022825334,55.342379016600304,55.336187460620124,55.33000433249703,
	55.32382960993083,55.31766327070832,55.311505292703075,55.305355653874734,55.29921433226874,
	55.29308130601582,55.28695655333168,55.28084005251631,55.27473178195383,55.268631720111856,
	55.26253984554123,55.256456136875464,55.25038057283045,55.24431313220393,55.23825379387512,
	55.232202536804316,55.226159340032495,55.22012418268081,55.21409704395035,55.20807790312163,
	55.20206673955409,55.19606353268601,55.190068262033755,55.18408090719164,55.17810144783144,
	55.17212986370193,55.166166134628725,55.160210240513614,55.154262161334394,55.148321877144404,
	55.14238936807217,55.136464614321,55.13054759616866,55.12463829396697,55.118736688141425,
	55.11284275919094,55.106956487687306,55.10107785427498,55.09520683967068,55.089343424663,
	55.08348759011206,55.077639316949224,55.07179858617673,55.06596537886721,55.06013967616358,
	55.05432145927841,55.04851070949391,55.04270740816131,55.03691153670072,55.031123076600615,
	55.025342009417685,55.019568316776386,55.01380198036864,55.008042981953544,55.002291303356955,
	54.99654692647128,54.99080983325509,54.985080005732826,54.979357425994436,54.973642076195134,
	54.967933938555,54.96223299535876,54.956539228955414,54.95085262175795,54.94517315624301,
	54.93950081495067,54.93383558048403,54.92817743550894,54.922526362753814,54.916882345009164,
	54.911245365127414,54.905615406022555,54.8999924506699,54.89437648210577,54.888767483427195,
	54.883165437791625,54.87757032841668,54.871982138579824,54.866400851618096,54.86082645092791,
	54.85525891996461,54.849698242242354,54.84414440133371,54.83859738086951,54.833057164538474,
	54.827523736086995,54.82199707931885,54.81647717809493,54.810964016333,54.80545757800743,
	54.799957847148825,54.794464807843994,54.788978444235454,54.783498740521324,54.77802568095495,
	54.77255924984481,54.767099431554136,54.76164621050064,54.75619957115636,54.75075949804733,
	54.745325975753495,54.7398989889081,54.73447852219792,54.72906456036264,54.72365708819481,
	54.71825609053953,54.71286155229417,54.707473458408316,54.70209179388328,54.69671654377205,
	54.691347693178955,54.68598522725955,54.68062913122019,54.67527939031804,54.66993598986061,
	54.664598915205694,54.65926815176111,54.653943684984405,54.64862550038272,54.64331358351247,
	54.63800791997926,54.632708495437484,54.62741529559029,54.62212830618922,54.61684751303413,
	54.6115729019728,54.60630445890085,54.60104216976151,54.59578602054539,54.59053599729023,
	54.5852920860808,54.58005427304853,54.5748225443715,54.56959688627403,54.56437728502664,
	54.55916372694573,54.55395619839348,54.54875468577754,54.543559175550925,54.53836965421178,
	54.53318610830311,54.52800852441276,54.522836889172986,54.51767118926048,54.51251141139603,
	54.507357542344394,54.50220956891408,54.49706747795713,54.49193125636904,54.48680089108845,
	54.48167636909701,54.47655767741916,54.47144480312198,54.466337733315044,54.461236455150114,
	54.4561409558211,54.45105122256371,54.4459672426555,54.44088900341544,54.43581649220389,
	54.43074969642245,54.42568860351363,54.420633200960836,54.41558347628806,54.41053941705984,
	54.40550101088095,54.40046824539634,54.39544110829089,54.390419587289294,54.38540367015584,
	54.38039334469425,54.375388598747584,54.370389420197974,54.36539579696648,54.36040771701301,
	54.35542516833604,54.35044813897249,54.345476616997644,54.34051059052485,54.33555004770541,
	54.33059497672852,54.32564536582093,54.32070120324694,54.315762477308205,54.3108291763435,
	54.305901288728634,54.30097880287632,54.29606170723592,54.291149990293384,54.28624364057113,
	54.281342646627735,54.27644699705792,54.27155668049236,54.26667168559749,54.26179200107551,
	54.256917615663966,54.25204851813588,54.24718469729947,54.24232614199799,54.23747284110959,
	54.23262478354729,54.227781958258625,54.22294435422573,54.21811196046502,54.2132847660271,
	54.20846275999673,54.203645931492474,54.1988342696668,54.194027763688645,54.189226402812324,
	54.18443017627313,54.17963907335725,54.17485308338395,54.17007219570551,54.16529639970701,
	54.16052568480618,54.155760040453444,54.15099945613149,54.14624392135545,54.141493425672536,
	54.136747958662085,54.132007509935235,54.127272069135,54.122541625936,54.11781617004437,
	54.11309569119766,54.10838017916471,54.10366962374546,54.098964014770914,54.09426334210297,
	54.08956759563422,54.084876765288,54.08019084101815,54.07550981280887,54.07083367067468,
	54.06616240466024,54.061496004840265,54.05683446131938,54.05217776423204,54.04752590374231,
	54.04287887004393,54.03823665335996,54.0335992439429,54.0289666320744,54.02433880806523,
	54.019715762255174,54.015097485012824,54.010483966735556,54.00587519784941,54.001271168808906,
	53.99667187009702,53.992077292225005,53.98748742573236,53.982902261186624,53.97832178918328,
	53.97374600034575,53.969174885325145,53.964608434800255,53.96004663947739,53.955489490090315,
	53.95093697740009,53.94638909219502,53.94184582529047,53.937307167528864,53.93277310977953,
	53.92824364293857,53.92371875792873,53.91919844569944,53.91468269722654,53.910171503512295,
	53.90566485558525,53.901162744500084,53.89666516133763,53.89217209720464,53.88768354323377,
	53.883199490583436,53.878719930437775,53.87424485400646,53.869774252524685,53.86530811725297,
	53.86084643947722,53.856389210508446,53.85193642168278,53.84748806436138,53.84304412993028,
	53.83860460980033,53.834169495407096,53.82973877821079,53.825312449696106,53.82089050137223,
	53.81647292477261,53.81205971145504,53.80765085300138,53.803246341017626,53.798846167133725,
	53.794450323003495,53.79005880030458,53.785671590738296,53.7812886860296,53.77691007792698,
	53.77253575820233,53.76816571865094,53.76379995109133,53.759438447365206,53.755081199337354,
	53.75072819889562,53.74637943795069,53.7420349084361,53.73769460230816,53.733358511545845,
	53.72902662815066,53.72469894414667,53.720375451580274,53.716056142520266,53.711741009057675,
	53.70743004330561,53.703123237399396,53.69882058349623,53.69452207377529,53.69022770043757,
	53.68593745570583,53.681651331824504,53.67736932105962,53.67309141569871,53.66881760805073,
	53.66454789044604,53.660282255236254,53.65602069479416,53.6517632015137,53.64750976780987,
	53.64326038611861
	}}
};
table1d_imp<2001> tubetable2_12AY7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	59862.95462879426,59710.61019340378,59558.982682759466,59408.06780595269,59257.86130344113,
	59108.35894679649,58959.55653843578,58811.449911379284,58664.03492898819,58517.30748472413,
	58371.26350189252,58225.898933403696,58081.20976152711,57937.19199764805,57793.84168203753,
	57651.154883600364,57509.12769965586,57367.75625569777,57227.03670516716,57086.96522921704,
	56947.53803649364,56808.75136291256,56670.601471429116,56533.08465182648,56396.197220489405,
	56259.935520195424,56124.295919896125,55989.27481450403,55854.86862468599,55721.07379665158,
	55587.88680194282,55455.30413723854,55323.32232413976,55191.93790898106,55061.14746261971,
	54930.947580241176,54801.33488116903,54672.30600866008,54543.85762972009,54415.98643491188,
	54288.68913816079,54161.96247657387,54035.80321024966,53910.2081220941,53785.174017641955,
	53660.697724870675,53536.77609402395,53413.40599743355,53290.58432934359,53168.30800573215,
	53046.57396414333,52925.37916351416,52804.72058400231,52684.59522682012,52565.000114062765,
	52445.93228854953,52327.38881365446,52209.366773148664,52091.863271030306,51974.87543137226,
	51858.40039816228,51742.43533514464,51626.977425662604,51512.023872506186,51397.57189776294,
	51283.6187426568,51170.16166740657,51057.197951070564,50944.724891405036,50832.739804710836,
	50721.24002569418,50610.22290731825,50499.68582066247,50389.62615478275,50280.04131656693,
	50170.92873059932,50062.285839021475,49954.11010139497,49846.39899456882,49739.1500125413,
	49632.360666328794,49526.02848383498,49420.15100971654,49314.72580525782,49209.75044823944,
	49105.222532809785,49001.13966936251,48897.49948440775,48794.29962044909,48691.53773586062,
	48589.211504764615,48487.31861691115,48385.85677755727,48284.82370734584,48184.21714219372,
	48084.0348331686,47984.27454637702,47884.93406284599,47786.01117841213,47687.50370360699,
	47589.40946354553,47491.72629781518,47394.45206036533,47297.58461939694,47201.1218572569,
	47105.061670329334,47009.40196892862,46914.140677193995,46819.275732983966,46724.805087778324,
	46630.72670656541,46537.03856774862,46443.738663039905,46350.8249973641,46258.29558875424,
	46166.14846825784,46074.38167983475,45982.99328026274,45891.98133904302,45801.34393830053,
	45711.07917269357,45621.18514931491,45531.65998760533,45442.50181925647,45353.70878812154,
	45265.279050124955,45177.21077316951,45089.502137050964,45002.15133336937,44915.15656543738,
	44828.51604819759,44742.22800813546,44656.29068319209,44570.70232268003,44485.46118720159,
	44400.56554856178,44316.013689688676,44231.803904550456,44147.934498072296,44064.40378605806,
	43981.21009511015,43898.35176254779,43815.82713633337,43733.63457498705,43651.772447516516,
	43570.239133336705,43489.03302219356,43408.1525140888,43327.59601920668,43247.3619578397,
	43167.448760310865,43087.85486690449,43008.57872779614,42929.61880297286,42850.97356217008,
	42772.641484794854,42694.62105986222,42616.91078591767,42539.509170975,42462.41473244538,
	42385.62599706714,42309.14150084458,42232.95978897346,42157.079415782675,42081.498944661565,
	42006.21694800038,41931.23200712139,41856.542712217386,41782.14766228992,41708.04546507846,
	41634.234737008366,41560.71410312066,41487.48219701498,41414.53766078636,41341.87914496583,
	41269.505308459775,41197.41481849073,41125.60635053657,41054.0785882766,40982.83022352675,
	40911.85995618735,40841.16649418366,40770.748553409714,40700.60485766968,40630.73413862569,
	40561.135135740195,40491.80659622204,40422.74727496996,40353.9559345209,40285.43134499487,
	40217.17228404195,40149.17753679061,40081.445895792174,40013.97616097398,39946.76713958108,
	39879.81764613095,39813.126502361236,39746.692537175964,39680.514586599995,39614.59149372799,
	39548.92210867317,39483.50528852262,39418.339897283025,39353.424805838695,39288.75889190065,
	39224.34103996009,39160.17014123988,39096.2450936505,39032.564801742046,38969.128176659906,
	38905.93413609854,38842.98160425426,38780.26951178538,38717.79679576144,38655.5623996253,
	38593.56527314486,38531.804372372026,38470.278659599084,38408.987103315674,38347.928678166165,
	38287.10236490816,38226.50715037106,38166.14202741347,38106.005994882835,38046.0980575745,
	37986.417226190904,37926.96251730309,37867.73295330777,37808.72756238965,37749.94537848345,
	37691.3854412316,37633.04679594788,37574.928493579515,37517.02959066761,37459.349149309535,
	37401.88623712184,37344.63992720296,37287.609298097,37230.79343375553,37174.19142350203,
	37117.802361996575,37061.62534919854,37005.65949033203,36949.90389584888,36894.35768139792,
	36839.01996778384,36783.88988093907,36728.96655188441,36674.2491166982,36619.73671648166,
	36565.42849732436,36511.323610273146,36457.42121129768,36403.72046125711,36350.22052586895,
	36296.92057567627,36243.819786015905,36190.91733698607,36138.212413415145,36085.704204831294,
	36033.391905428754,35981.2747140395,35929.351834103385,35877.62247363376,35826.08584519057,
	35774.7411658505,35723.5876571748,35672.62454518238,35621.85106031794,35571.26643742598,
	35520.86991571947,35470.66073875129,35420.63815438739,35370.801414776826,35321.149776325794,
	35271.6824996668,35222.39884963275,35173.29809523043,35124.37950961228,35075.64237004832,
	35027.08595790043,34978.70955859618,34930.51246160072,34882.4939603934,34834.65335243708,
	34786.98993915714,34739.503025911996,34692.19192196971,34645.05594048291,34598.09439846108,
	34551.306616748014,34504.69191999614,34458.24963664145,34411.97909888045,34365.87964264409,
	34319.9506075743,34274.19133700099,34228.601177916986,34183.1794809544,34137.925600362054,
	34092.83889398187,34047.91872322549,34003.16445305195,33958.57545194238,33914.1510918824,
	33869.89074833491,33825.793800218155,33781.85962988779,33738.087623108695,33694.47716903839,
	33651.027660202606,33607.738492474295,33564.60906505116,33521.638780436995,33478.82704441827,
	33436.17326604268,33393.67685760142,33351.33723460495,33309.15381576436,33267.12602297087,
	33225.253281274636,33183.5350188653,33141.97066705217,33100.559660243314,33059.30143592691,
	33018.19543465091,32977.241100004416,32936.437878596815,32895.78522004074,32855.282576929814,
	32814.92940482281,32774.72516222399,32734.669310563113,32694.761314177325,32655.00064029346,
	32615.38675900964,32575.919143276376,32536.597268877347,32497.420614415623,32458.38866129024,
	32419.500893682125,32380.756798535756,32342.155865540604,32303.697587114522,32265.381458386546,
	32227.206977179434,32189.173643993094,32151.28096198576,32113.528436959354,32075.915577341875,
	32038.44189417086,32001.106901075593,31963.910114262984,31926.85105249903,31889.9292370944,
	31853.144191886528,31816.49544322496,31779.982519954778,31743.604953401264,31707.36227735261,
	31671.254028046566,31635.279744153508,31599.43896676072,31563.731239358927,31528.156107824132,
	31492.713120404922,31457.401827705395,31422.221782673172,31387.17254058013,31352.253659012014,
	31317.46469785101,31282.80521926142,31248.274787676335,31213.872969781645,31179.599334503186,
	31145.45345299092,31111.43489860651,31077.543246906942,31043.77807563245,31010.138964692927,
	30976.625496151042,30943.237254211203,30909.97382520589,30876.83479758038,30843.819761879735,
	30810.92831073705,30778.160038857124,30745.514543005484,30712.991421993942,30680.59027666874,
	30648.31070989442,30616.152326545835,30584.114733489452,30552.19753957614,30520.40035562266,
	30488.72279440393,30457.164470637716,30425.725000972423,30394.404003974316,30363.201100116945,
	30332.11591176558,30301.148063167893,30270.29718043982,30239.56289155367,30208.94482632817,
	30178.442616412085,30148.05589527643,30117.78429820011,30087.627462259446,30057.585026314886,
	30027.65663100097,29997.841918713064,29968.1405335968,29938.55212153596,29909.076330141506,
	29879.712808739692,29850.461208360786,29821.321181727755,29792.29238324487,29763.374468987113,
	29734.567096687624,29705.86992572909,29677.282617130026,29648.80483353439,29620.436239202456,
	29592.17649999813,29564.025283378236,29535.982258382446,29508.04709562206,29480.219467269835,
	29452.499047048605,29424.885510221335,29397.378533580373,29369.977795436876,29342.682975610456,
	29315.49375541914,29288.40981766856,29261.430846641306,29234.55652808794,29207.786549215747,
	29181.120598678965,29154.558366568417,29128.099544401906,29101.743825114096,29075.490903045833,
	29049.340473935128,29023.29223490716,28997.345884464143,28971.501122474965,28945.757650166357,
	28920.115170113426,28894.57338622845,28869.13200375344,28843.790729247787,28818.54927058155,
	28793.40733692364,28768.364638733925,28743.420887753047,28718.575796992634,28693.82908072716,
	28669.18045448329,28644.629635031677,28620.176340376664,28595.82028974808,28571.561203590918,
	28547.39880355714,28523.332812497065,28499.362954447464,28475.488954626504,28451.71053942158,
	28428.027436382195,28404.439374208883,28380.946082747083,28357.54729297627,28334.24273700158,
	28311.032148044844,28287.915260436464,28264.891809605884,28241.961532072648,28219.124165439538,
	28196.37944838043,28173.727120635438,28151.16692300009,28128.698597316346,28106.321886465976,
	28084.03653436071,28061.84228593275,28039.738887129424,28017.726084900765,27995.803627193884,
	27973.9712629441,27952.22874206547,27930.57581544305,27909.012234925416,27887.537753314544,
	27866.152124359072,27844.85510274475,27823.64644408793,27802.525904926126,27781.493242708453,
	27760.548215790786,27739.6905834252,27718.920105751695,27698.23654379205,27677.639659439086,
	27657.129215451383,27636.704975442073,27616.366703874573,27596.114166050596,27575.94712810537,
	27555.86535699767,27535.86862050291,27515.956687204867,27496.129326487346,27476.386308527337,
	27456.727404285633,27437.15238549993,27417.66102467756,27398.25309508581,27378.92837074602,
	27359.686626424762,27340.527637625986,27321.451180583586,27302.457032253576,27283.54497030686,
	27264.71477311985,27245.966219768576,27227.299090020206,27208.713164325676,27190.2082238112,
	27171.784050271774,27153.44042616219,27135.177134591057,27116.993959311618,27098.890684714723,
	27080.867095822206,27062.92297827746,27045.058118339133,27027.272302873243,27009.56531934619,
	26991.93695581566,26974.3870009249,26956.915243894342,26939.521474513836,26922.205483135283,
	26904.967060666488,26887.805998561496,26870.722088814728,26853.715123952843,26836.78489702713,
	26819.93120160716,26803.153831771677,26786.452582103317,26769.827247678913,26753.2776240634,
	26736.803507302462,26720.404693914796,26704.080980884723,26687.832165655243,26671.658046119504,
	26655.55842061529,26639.533087916225,26623.581847224385,26607.704498164592,26591.900840775103,
	26576.170675501264,26560.513803188245,26544.930025073318,26529.419142779057,26513.980958305772,
	26498.61527402367,26483.321892667052,26468.100617325083,26452.9512514361,26437.87359877978,
	26422.867463469815,26407.932649946473,26393.068962969293,26378.276207611107,26363.554189248076,
	26348.90271355615,26334.32158649995,26319.810614328635,26305.369603566534,26290.99836100735,
	26276.69669370606,26262.46440897218,26248.30131436184,26234.207217671545,26220.18192693009,
	26206.225250392003,26192.33699652982,26178.516974026807,26164.764991770273,26151.080858844325,
	26137.46438452155,26123.91537825763,26110.43364968211,26097.019008593135,26083.671264948858,
	26070.39022886076,26057.17571058606,26044.027520521136,26030.945469193743,26017.929367256416,
	26004.97902547838,25992.09425473879,25979.274866020198,25966.52067039968,25953.83147904357,
	25941.207103198303,25928.647354185327,25916.15204339142,25903.7209822638,25891.35398230112,
	25879.050855047462,25866.81141208436,25854.635465023934,25842.522825501208,25830.47330516734,
	25818.48671568254,25806.562868707784,25794.70157589896,25782.90264889819,25771.165899327694,
	25759.491138782454,25747.87817882168,25736.32683096293,25724.836906674216,25713.408217367138,
	25702.040574388837,25690.733789014692,25679.48767244249,25668.30203578309,25657.176690054443,
	25646.111446173796,25635.106114950297,25624.160507077588,25613.274433126673,25602.447703538885,
	25591.680128617252,25580.971518520262,25570.32168325418,25559.730432665907,25549.197576434115,
	25538.722924063968,25528.30628487792,25517.94746800913,25507.646282393813,25497.402536763453,
	25487.21603963796,25477.086599316888,25467.014023873635,25456.99812114623,25447.038698731012,
	25437.135563974134,25427.288523964246,25417.497385525272,25407.761955208065,25398.082039283378,
	25388.457443733332,25378.887974244935,25369.37343620115,25359.913634673412,25350.508374414334,
	25341.157459849535,25331.860695069772,25322.617883823026,25313.42882950655,25304.293335159324,
	25295.211203453768,25286.18223668749,25277.206236775663,25268.283005242844,25259.41234321493,
	25250.594051410444,25241.827930133546,25233.113779264353,25224.45139825163,25215.840586104092,
	25207.281141382442,25198.77286219025,25190.31554616607,25181.90899047486,25173.552991798995,
	25165.247346330245,25156.991849760434,25148.78629727315,25140.630483535097,25132.524202686574,
	25124.46724833286,25116.45941353576,25108.500490803388,25100.590272082194,25092.7285487466,
	25084.91511159078,25077.149750818557,25069.432256033888,25061.762416231824,25054.1400197885,
	25046.56485445119,25039.03670732894,25031.55536488236,25024.120612913197,25016.7322365548,
	25009.390020261617,25002.093747798284,24994.843202230342,24987.638165911812,24980.478420475905,
	24973.36374682353,24966.29392511205,24959.26873474467,24952.28795435833,24945.351361812758,
	24938.45873417853,24931.609847725533,24924.804477910337,24918.04239936486,24911.32338588339,
	24904.647210410272,24898.013645026735,24891.422460938542,24884.873428463176,24878.366317015,
	24871.90089509271,24865.476930265842,24859.09418915966,24852.752437441864,24846.451439807217,
	24840.19095996308,24833.970760614746,24827.79060344933,24821.6502491206,24815.549457232693,
	24809.487986324453,24803.465593852263,24797.482036173824,24791.537068530226,24785.630445029157,
	24779.76191862629,24773.93124110784,24768.13816307144,24762.382433907485,24756.663801779225,
	24750.98201360415,24745.336815032486,24739.727950427678,24734.155162844923,24728.618194010018,
	24723.11678429745,24717.650672707652,24712.21959684514,24706.82329289446,24701.461495597323,
	24696.133938227485,24690.840352566775,24685.580468879918,24680.354015888213,24675.160720744276,
	24670.00030900455,24664.872504602874,24659.77702982181,24654.713605265366,24649.681949829235,
	24644.68178067218,24639.71281318597,24634.774760964996,24629.86733577503,24624.990247522685,
	24620.1432042225,24615.325911964665,24610.538074883272,24605.77939512077,24601.04957279641,
	24596.34830596994,24591.675290608706,24587.030220551205,24582.412787471825,24577.82268084578,
	24573.259587912627,24568.723193639507,24564.21318068546,24559.729229364406,24555.271017608247,
	24550.83822093043,24546.43051238928,24542.047562551426,24537.689039455352,24533.354608575908,
	24529.04393278798,24524.7566723325,24520.492484781476,24516.251025004643,24512.03194513718,
	24507.83489454778,24503.659519808665,24499.50546466748,24495.372370019355,24491.259873882427,
	24487.167611374265,24483.095214691704,24479.04231309195,24475.008532878506,24470.993497388074,
	24466.996826981864,24463.018139041986,24459.05704796966,24455.113165189767,24451.186099159702,
	24447.27545538314,24443.3808364308,24439.501841966,24435.638068778062,24431.789110822305,
	24427.954559268306,24424.13400255612,24420.327026460818,24416.533214168478,24412.75214635945,
	24408.98340130464,24405.22655497231,24401.48118114658,24397.746851558604,24394.02313603225,
	24390.309602643072,24386.605817890835,24382.911346890513,24379.225753576557,24375.548600925973,
	24371.879451197863,24368.217866191924,24364.563407526166,24360.91563693248,24357.274116575034,
	24353.638409386775,24350.008079429183,24346.38269227219,24342.761815397498,24339.145018622203,
	24335.531874547556,24331.921959028943,24328.314851667994,24324.71013632906,24321.107401676563,
	24317.506241734758,24313.90625646969,24310.307052391363,24306.70824317588,24303.109450307264,
	24299.5103037366,24295.91044255732,24292.309515697598,24288.707182622482,24285.103114049958,
	24281.496992675213,24277.888513901235,24274.277386574,24270.663333718217,24267.046093272056,
	24263.425418816958,24259.801080298632,24256.17286473701,24252.54057691999,24248.90404007941,
	24245.263096542247,24241.61760835602,24237.96745788253,24234.312548357768,24230.652804410805,
	24226.988172540823,24223.318621547736,24219.644142910714,24215.964751112693,24212.28048390772,
	24208.59140252678,24204.897591818342,24201.199160324355,24197.496240285054,24193.788987573862,
	24190.077581558828,24186.362224890385,24182.64314321461,24178.920584810465,24175.19482015393,
	24171.466141406156,24167.734861829624,24164.001315133202,24160.265854746576,24156.52885302928,
	24152.79070041591,24149.051804500203,24145.312589064764,24141.573493056825,24137.834969517953,
	24134.097484471415,24130.361515770943,24126.62755192092,24122.896090866576,24119.167638766456,
	24115.442708749906,24111.72181966523,24108.005494826073,24104.294260759394,24100.58864596368,
	24096.889179680704,24093.196390685058,24089.51080610221,24085.83295025144,24082.163343527034,
	24078.502501312392,24074.8509329421,24071.20914070427,24067.577618894116,24063.956852917247,
	24060.347318448134,24056.74948064078,24053.1637933992,24049.590698704877,24046.030626000003,
	24042.483991634228,24038.951198366078,24035.432634924822,24031.92867562941,24028.439680063802,
	24024.965992808964,24021.507943227654,24018.065845300793,24014.639997517377,24011.23068280816,
	24007.838168529157,24004.462706485963,24001.104533001708,23997.763869023798,23994.440920263736,
	23991.13587737375,23987.848916154035,23984.580197787614,23981.32986910157,23978.098062851885,
	23974.884898029508,23971.690480184327,23968.514901765888,23965.358242480048,23962.220569653142,
	23959.10193861194,23956.00239306613,23952.921965501875,23949.86067757605,23946.81854051608,
	23943.795555519235,23940.79171415404,23937.806998757438,23934.84138283423,23931.89483144749,
	23928.967301609682,23926.058742662975,23923.16909666025,23920.298298732338,23917.446277452356,
	23914.612955191657,23911.79824846396,23909.002068265727,23906.2243204031,23903.464905812354,
	23900.72372086782,23898.000657683588,23895.295604401774,23892.608445474525,23889.9390619329,
	23887.287331645504,23884.653129573217,23882.036328004346,23879.436796789654,23876.854403560377,
	23874.289013943613,23871.740491760895,23869.20869922522,23866.693497123146,23864.194744993038,
	23861.71230129022,23859.246023549757,23856.795768534383,23854.361392380404,23851.9427507348,
	23849.539698880948,23847.152091865755,23844.779784609516,23842.422632018894,23840.080489088472,
	23837.753210996696,23835.440653197697,23833.142671505415,23830.859122175338,23828.589861977438,
	23826.33474826744,23824.093639053037,23821.866393052835,23819.652869753994,23817.4529294653,
	23815.26643336462,23813.093243546868,23810.9332230613,23808.786235953878,23806.652147297915,
	23804.530823231802,23802.422130982657,23800.32593889715,23798.242116462352,23796.17053432805,
	23794.11106432771,23792.063579492507,23790.027954068846,23788.00406352957,23785.99178458633,
	23783.990995200253,23782.00157458435,23780.023403218605,23778.056362845287,23776.100336480267,
	23774.155208410662,23772.220864197123,23770.29719067595,23768.384075953127,23766.48140940751,
	23764.58908168557,23762.706984696386,23760.8350116072,23758.97305684356,23757.121016074037,
	23755.27878621027,23753.446265399576,23751.623353012328,23749.809949639508,23748.005957079848,
	23746.21127833376,23744.425817590247,23742.649480221073,23740.88217276736,23739.123802930553,
	23737.374279562748,23735.633512652716,23733.901413317042,23732.177893789256,23730.462867406957,
	23728.756248600144,23727.057952880263,23725.367896827684,23723.68599808088,23722.012175322794,
	23720.346348270188,23718.68843765974,23717.038365240383,23715.396053753047,23713.761426928228,
	23712.134409465627,23710.514927027183,23708.902906223888,23707.298274600034,23705.70096062936,
	23704.110893693567,23702.52800407723,23700.952222954573,23699.383482373738,23697.821715251754,
	23696.266855358917,23694.718837306475,23693.17759653806,23691.643069315825,23690.11519271304,
	23688.593904598038,23687.079143627332,23685.570849231273,23684.06896160743,23682.573421707948,
	23681.084171224855,23679.601152586838,23678.12430894725,23676.653584167605,23675.18892281626,
	23673.73027015325,23672.27757212199,23670.830775336995,23669.38982708124,23667.954675287234,
	23666.525268538702,23665.10155604757,23663.683487660182,23662.271013834466,23660.864085640875,
	23659.46265474974,23658.066673421985,23656.676094505478,23655.290871416175,23653.910958143155,
	23652.536309229054,23651.166879772925,23649.80262540992,23648.44350231357,23647.08946718452,
	23645.74047724095,23644.39649021613,23643.05746434735,23641.72335836702,23640.394131502133,
	23639.069743456468,23637.75015441984,23636.43532504156,23635.125216441324,23633.81979019383,
	23632.519008321306,23631.222833291307,23629.93122800663,23628.644155804333,23627.361580444274,
	23626.083466105178,23624.809777379087,23623.54047926573,23622.27553716398,23621.01491687148,
	23619.75858457273,23618.50650683877,23617.258650620144,23616.014983240264,23614.77547239351,
	23613.54008613364,23612.308792875712,23611.081561387837,23609.858360786035,23608.63916053106,
	23607.423930422407,23606.21264059115,23605.005261501974,23603.8017639418,23602.60211902268,
	23601.406298164395,23600.214273105357,23599.02601588968,23597.84149886525,23596.660694680093,
	23595.48357627312,23594.31011687974,23593.140290019248,23591.974069496697,23590.81142939199,
	23589.6523440662,23588.496788149845,23587.344736542524,23586.196164407196,23585.051047169374,
	23583.909360514375,23582.77108037558,23581.636182942962,23580.504644652134,23579.37644218151,
	23578.25155245774,23577.129952633353,23576.01162010499,23574.896532502404,23573.784667672826,
	23572.67600370088,23571.570518886732,23570.468191755517,23569.369001045845,23568.27292571373,
	23567.179944921805,23566.090038045757,23565.003184665078,23563.919364565016,23562.838557726587,
	23561.760744335646,23560.685904771693,23559.61401960056,23558.545069590582,23557.479035690412,
	23556.415899036416,23555.355640949772,23554.2982429321,23553.24368666297,23552.19195400208,
	23551.143026980655,23550.096887803982,23549.053518846235,23548.01290265346,23546.975021931205,
	23545.939859555845,23544.90739856099,23543.877622145716,23542.85051365879,23541.826056616705,
	23540.804234677413,23539.78503166182,23538.768431536344,23537.754418416596,23536.742976564594,
	23535.73409039191,23534.72774444643,23533.72392342523,23532.722612157817,23531.723795620703,
	23530.727458919228,23529.73358729621,23528.742166131637,23527.753180934887,23526.76661734253,
	23525.7824611259,23524.80069817835,23523.82131452287,23522.84429630832,23521.86962979656,
	23520.897301384222,23519.927297578502,23518.959605010805,23517.99421042488,23517.0311006871,
	23516.070262772766,23515.111683774136,23514.15535089008,23513.201251435075,23512.249372837254,
	23511.299702623775,23510.35222843213,23509.40693801151,23508.46381920534,23507.522859969326,
	23506.584048356584,23505.647372525615,23504.712820730674,23503.780381325527,23502.850042765687,
	23501.92179360135,23500.995622475537,23500.071518130662,23499.149469399814,23498.22946520635,
	23497.31149457251,23496.39554660443,23495.481610502633,23494.569675550847,23493.659731123946,
	23492.751766685655,23491.845771783475,23490.94173604567,23490.039649190006,23489.13950101381,
	23488.241281400595,23487.34498031148,23486.45058778876,23485.55809395718,23484.66748901692,
	23483.778763244114,23482.891907000027,23482.0069107121,23481.12376489098,23480.242460123467,
	23479.362987056455,23478.485336426853,23477.6094990388,23476.735465760656,23475.863227538666,
	23474.992775387353,23474.124100393856,23473.257193708483,23472.392046553614,23471.528650218304,
	23470.666996056974,23469.80707549243,23468.94888001001,23468.09240115805,23467.23763055686,
	23466.38455988296,23465.533180877217,23464.683485344114,23463.835465147244,23462.98911221267,
	23462.14441852822,23461.30137614032,23460.45997714763,23459.620213717724,23458.78207807381,
	23457.945562490782,23457.110659307702,23456.27736091286,23455.445659753255,23454.615548334037,
	23453.787019211806,23452.96006499709,23452.13467835185,23451.310852000577,23450.48857870386,
	23449.667851292113,23448.84866263734,23448.03100566107,23447.21487334158,23446.400258702037,
	23445.5871548201,23444.77555481726,23443.965451868917,23443.15683919349,23442.349710061095,
	23441.544057785228,23440.739875732837,23439.937157309683,23439.135895972337,23438.33608522403,
	23437.537718606774,23436.740789706768,23435.945292171877,23435.15121967048,23434.35856592618,
	23433.56732470569,23432.777489817796,23431.989055111644,23431.202014478036,23430.416361853597,
	23429.63209121088,23428.849196567855,23428.0676719763,23427.28751153624,23426.50870938167,
	23425.73125968691,23424.95515666947,23424.180394577656,23423.40696770452,23422.63487037923,
	23421.864096965182,23421.09464187096,23420.326499532355,23419.559664429264,23418.794131077335,
	23418.029894020863,23417.26694784672,23416.505287177155,23415.744906667962,23414.98580100631,
	23414.22796492024,23413.47139316465,23412.71608053559,23411.962021858188,23411.209211991125,
	23410.457645828763,23409.707318290963,23408.95822433981,23408.210358962824,23407.46371718506,
	23406.718294052964,23405.974084655933,23405.23108410506,23404.48928755008,23403.748690164597,
	23403.00928715538,23402.271073766988,23401.534045252884,23400.798196918255,23400.063524084737,
	23399.33002210602,23398.597686369743,23397.866512283133,23397.136495287075,23396.40763084784,
	23395.679914464574,23394.953341656008,23394.227907976518,23393.503609004438,23392.780440340346,
	23392.058397622797,23391.337476502376,23390.61767266348,23389.898981824597,23389.181399710564,
	23388.46492208849,23387.749544751212,23387.035263499176,23386.32207417659,23385.60997264382,
	23384.898954789496,23384.189016524357,23383.480153780652,23382.77236252136,23382.065638728785,
	23381.359978411536,23380.655377595438,23379.951832337647,23379.24933871154,23378.54789282275,
	23377.847490787655,23377.148128750487,23376.4498028862,23375.752509377126,23375.056244434993,
	23374.361004295297,23373.666785216486,23372.973583469957,23372.28139535266,23371.59021718759,
	23370.900045313196,23370.21087609037,23369.522705900796,23368.83553114606,23368.149348250954,
	23367.46415365608,23366.779943824866,23366.096715239557,23365.414464402067,23364.7331878341,
	23364.052882083077,23363.37354370328,23362.69516928238,23362.017755405133,23361.34129870522,
	23360.665795810884,23359.991243376004,23359.31763808306,23358.644976618783,23357.973255690762,
	23357.302472031784,23356.63262239113,23355.963703525344,23355.295712216743,23354.628645273988,
	23353.962499506244,23353.29727174568,23352.632958846396,23351.969557680866,23351.307065123834,
	23350.645478089988,23349.984793490403,23349.325008257816,23348.66611935028,23348.00812373094,
	23347.351018382746,23346.6948003122,23346.039466531303,23345.385014067506,23344.731439975465,
	23344.078741310383,23343.42691515804,23342.77595861221,23342.12586877461,23341.476642776874,
	23340.82827776032,23340.180770871386,23339.534119285447,23338.88832017958,23338.24337076331,
	23337.5992682379,23336.956009840684,23336.31359280726,23335.6720143956,23335.031271879547,
	23334.391362536924,23333.752283667476,23333.11403258836,23332.47660662153,23331.8400031037,
	23331.204219392173,23330.569252851856,23329.935100863877,23329.301760835613,23328.669230125015,
	23328.037506200024,23327.406586478915,23326.776468402848,23326.147149433473,23325.518627040947,
	23324.890898709054,23324.263961934208,23323.637814217465,23323.012453091895,23322.38787608163,
	23321.764080734072,23321.141064611336,23320.518825278927,23319.897360318126,23319.27666732268,
	23318.656743903768,23318.03758766804,23317.419196255472,23316.801567297116,23316.184698449,
	23315.568587375947,23314.95323175075,23314.3386292604,23313.72477759836,23313.11167447674,
	23312.499317616548,23311.88770474144,23311.276833602413,23310.666701941554,23310.057307531886,
	23309.448648135636,23308.840721547946,23308.233525555126,23307.62705797054,23307.021316602746,
	23306.41629928519,23305.812003848958,23305.208428139584,23304.605570023512,23304.003427353186,
	23303.401998016907,23302.801279897347,23302.20127089155,23301.601968908562,23301.003371859035,
	23300.405477678833,23299.80828429687,23299.21178966289,23298.61599172793,23298.020888458253,
	23297.42647782767,23296.832757817487,23296.23972642797,23295.64738165058,23295.05572150366,
	23294.46474400732,23293.87444718557,23293.284829081593,23292.695887744103,23292.10762122338,
	23291.52002758709,23290.9331049135,23290.346851277827,23289.761264773275,23289.176343502597,
	23288.59208557236,23288.00848910559,23287.42555221237,23286.843273041457,23286.261649734497,
	23285.680680432753,23285.10036329857,23284.520696501346,23283.941678219486,23283.363306627904,
	23282.785579926356,23282.20849630784,23281.632053982008,23281.056251167138,23280.48108608281,
	23279.90655696286,23279.33266204426,23278.759399570543,23278.1867678026,23277.614764997208,
	23277.043389428625,23276.472639370542,23275.902513110203,23275.33300893511,23274.764125146205,
	23274.195860052492,23273.62821196993,23273.061179215634,23272.49476012251,23271.92895302225,
	23271.36375625764,23270.799168185218,23270.235187154656,23269.671811535634,23269.109039701576,
	23268.546870021404,23267.98530089107,23267.42433069198,23266.863957830796,23266.304180714018,
	23265.74499775257,23265.186407361864,23264.62840796911,23264.07099800876,23263.51417591823,
	23262.957940147997,23262.40228914261,23261.84722136918,23261.292735285686,23260.73882936223,
	23260.18550209337,23259.63275194184,23259.080577410718,23258.528976993897,23257.977949194552,
	23257.427492520474,23256.87760549147,23256.328286621258,23255.77953445036,23255.23134750051,
	23254.683724316335,23254.136663445068,23253.590163433368,23253.044222849683,23252.49884024032,
	23251.954014191797,23251.40974327195,23250.866026059775,23250.322861147702,23249.780247120678,
	23249.23818258472,23248.696666141397,23248.155696399615,23247.615271972067,23247.075391485734,
	23246.536053565273,23245.997256836457,23245.458999940503,23244.921281526797,23244.384100233907,
	23243.847454717823,23243.311343638947,23242.77576566099,23242.240719456735,23241.7062036983,
	23241.17221706606,23240.638758242967,23240.10582592665,23239.57341880492,23239.04153558019,
	23238.51017496226,23237.979335664953,23237.449016394,23236.91921587926,23236.389932842776,
	23235.861166019647,23235.33291414308,23234.805175954705,23234.277950197542,23233.75123562939,
	23233.225031000104,23232.69933507371,23232.174146610923,23231.64946438458,23231.125287169278,
	23230.60161374686,23230.078442899143,23229.555773413296,23229.03360408732,23228.51193371715,
	23227.99076110491,23227.47008505781,23226.94990438969,23226.43021791395,23225.911024454974,
	23225.392322835953,23224.874111884663,23224.356390439792,23223.83915733417,23223.32241142414,
	23222.806151540946,23222.29037654806,23221.775085293502,23221.26027663831,23220.745949457592,
	23220.232102603386,23219.7187349675,23219.205845412853,23218.69343282393,23218.181496091995,
	23217.670034103,23217.159045746546,23216.64852993394,23216.13848555784,23215.62891152289,
	23215.119806741583,23214.61117013522,23214.103000609928,23213.595297093918,23213.08805851225,
	23212.58128380023,23212.074971888716,23211.569121714612,23211.06373222297,23210.558802349373,
	23210.054331058447,23209.55031728965,23209.04676001409,23208.543658181512,23208.041010765886,
	23207.538816724267,23207.037075042215,23206.53578468277,23206.034944635194,23205.53455387915,
	23205.03461139899,23204.53511619612,23204.036067251418,23203.537463572055,23203.039304153295,
	23202.541588000702,23202.044314134313,23201.547481548278,23201.051089275872,23200.55513632077,
	23200.059621712247,23199.56454448052,23199.069903649644,23198.575698256154,23198.081927333256,
	23197.588589924624,23197.09568506776,23196.603211818056,23196.111169212178,23195.619556315993,
	23195.128372181847,23194.6376158678,23194.147286437303,23193.657382958365,23193.167904500937,
	23192.67885013651,23192.190218945856,23191.70200999969,23191.214222387316,23190.72685519349,
	23190.23990750069,23189.753378413192,23189.26726701844,23188.781572411095,23188.29629370565,
	23187.81142998951,23187.326980385013,23186.84294399463,23186.359319935436,23185.87610732471,
	23185.39330527893,23184.91091292476,23184.42892938347,23183.94735378364,23183.466185264097,
	23182.98542295613,23182.50506598985,23182.025113517582,23181.545564671378,23181.066418607243,
	23180.587674465933,23180.109331408832,23179.631388587197,23179.15384515679,23178.67670027808,
	23178.199953112216,23177.72360283365,23177.247648606117,23176.772089598664,23176.296924989845,
	23175.822153954978,23175.347775674265,23174.87378933547,23174.400194119076,23173.926989216867,
	23173.45417380671,23172.981747097154,23172.509708285015,23172.038056557827,23171.56679112487,
	23171.09591118827,23170.625415955787,23170.155304637403,23169.685576440137,23169.216230581405,
	23168.747266283164,23168.27868275429,23167.810479229804,23167.34265492229,23166.875209072787,
	23166.408140899806,23165.94144963682,23165.47513452562,23165.009194795406,23164.54362969077,
	23164.07843845184,23163.613620321124,23163.149174556704,23162.685100391493,23162.221397090143,
	23161.75806389873,23161.29510008124,23160.832504895916,23160.370277595113,23159.90841745337,
	23159.44692373391,23158.98579570882,23158.52503263395,23158.064633794973,23157.604598471844,
	23157.14492592979,23156.6856154589,23156.226666337145,23155.76807785091,23155.30984928349,
	23154.851979928444,23154.394469074,23153.937316014846,23153.480520046844,23153.0240804738,
	23152.56799659352,23152.11226769651,23151.656893099458,23151.201872103386,23150.747204024254,
	23150.292888168467,23149.838923853382,23149.385310388465,23148.932047092898,23148.479133289806,
	23148.026568299138,23147.57435144288,23147.122482052026,23146.67095944947,23146.219782971588,
	23145.768951937745,23145.318465699944,23144.868323582792,23144.41852492708,23143.96906907086,
	23143.519955361146,23143.07118314086,23142.62275175831,23142.174660562298,23141.726908898003,
	23141.279496122577,23140.832421587536,23140.385684655004,23139.939284673073,23139.49322101066,
	23139.047493022746,23138.602100085966,23138.157041552837,23137.712316801342,23137.267925195472,
	23136.82386610929,23136.38013891538,23135.936742997103,23135.493677714006,23135.050942463102,
	23134.60853661682,23134.16645956245,23133.724710682756,23133.28328936407,23132.842194997695,
	23132.401426969536,23131.960984670073,23131.520867505107,23131.08107486236,23130.64160613949,
	23130.202460730543,23129.76363805416,23129.32513749554,23128.886958467727,23128.449100372287,
	23128.011562631164,23127.5743446314,23127.137445805805,23126.700865554707,23126.26460330317,
	23125.828658453724,23125.393030443916,23124.95771868542,23124.522722588245,23124.0880415948,
	23123.65367512775,23123.2196226031,23122.785883455155,23122.352457122597,23121.919343023634,
	23121.486540601833,23121.054049283433,23120.621868516882,23120.18999773243,23119.758436375632,
	23119.327183885624,23118.896239709848,23118.465603284476,23118.035274062226,23117.605251491204,
	23117.175535020466,23116.7461241038,23116.31701819397,23115.888216738647,23115.459719196337,
	23115.031525038412,23114.603633704446,23114.176044671454,23113.748757390906,23113.321771329076,
	23112.895085955388,23112.468700730788,23112.042615127593,23111.616828613238,23111.191340666883,
	23110.766150749,23110.341258338933,23109.916662925396,23109.49236396907,23109.068360950347,
	23108.644653355255,23108.22124067303,23107.798122362485,23107.375297933126,23106.952766859853,
	23106.530528627347,23106.108582734352,23105.686928666393,23105.265565911326,23104.844493967837,
	23104.423712332984,23104.003220492923,23103.583017952653,23103.16310420749,23102.743478757802,
	23102.324141112884,23101.905090774464,23101.486327234757,23101.06785000536,23100.649658602237,
	23100.231752517226,23099.814131280506,23099.396794387532,23098.979741357594,23098.56297170163,
	23098.14648493367,23097.73028057696,23097.314358144893,23096.898717151555,23096.483357127894,
	23096.068277589937,23095.653478060805,23095.238958070062,23094.82471712952,23094.41075478048,
	23093.997070548714,23093.58366395652,23093.170534544737,23092.75768183387,23092.34510537062,
	23091.932804677148,23091.520779297927,23091.10902876818,23090.69755262615,23090.28635040383,
	23089.87542165349,23089.464765909404,23089.054382724276,23088.644271629397,23088.234432183155,
	23087.82486392134,23087.415566399217,23087.0065391637,23086.597781775527,23086.18929376666,
	23085.781074704348,23085.373124137586,23084.965441621138,23084.558026712737,23084.15087898092,
	23083.743997967755,23083.337383240178,23082.9310343579,23082.5249508824,23082.11913238732,
	23081.71357842293,23081.308288561006,23080.90326237949,23080.498499429224,23080.09399928108,
	23079.68976151576,23079.28578569495,23078.882071404714,23078.47861820548,23078.075425676398,
	23077.672493393547,23077.269820935944,23076.86740787722,23076.465253801958,23076.06335828285,
	23075.661720907803,23075.26034126658,23074.859218921985,23074.458353477912,23074.05774450731,
	23073.657391606688,23073.2572943557,23072.857452356784,23072.457865184002,23072.058532431583,
	23071.659453702385,23071.260628580996,23070.86205665522,23070.463737533668,23070.065670809225,
	23069.667856074288,23069.270292929825,23068.872980976386,23068.4759198132,23068.079109038525,
	23067.682548259887,23067.286237081466,23066.890175100183,23066.494361932924,23066.098797177452,
	23065.703480444117,23065.30841132912,23064.91358946647,23064.519014450965,23064.124685894687,
	23063.730603401407
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	59862.95462879426,59710.61019340378,59558.982682759866,59408.067805951454,59257.86130344198,
	59108.35894679649,58959.55653843587,58811.449911379284,58664.034928988345,58517.30748472413,
	58371.26350189252,58225.898933403696,58081.209761526516,57937.19199764916,57793.84168203753,
	57651.15488359971,57509.12769965569,57367.75625569777,57227.03670516716,57086.965229216265,
	56947.53803649364,56808.75136291261,56670.601471429116,56533.08465182574,56396.197220489594,
	56259.93552019591,56124.29591989562,55989.27481450403,55854.8686246859,55721.07379665158,
	55587.88680194151,55455.30413723854,55323.322324139655,55191.93790898169,55061.14746261961,
	54930.947580241336,54801.33488116841,54672.30600866011,54543.85762972009,54415.98643491188,
	54288.68913816079,54161.96247657318,54035.80321024967,53910.20812209457,53785.17401764182,
	53660.697724870675,53536.77609402449,53413.405997433554,53290.58432934298,53168.30800573215,
	53046.573964143805,52925.37916351405,52804.72058400278,52684.59522681971,52565.000114062124,
	52445.932288549586,52327.388813654514,52209.36677314843,52091.86327103007,51974.87543137237,
	51858.400398162834,51742.435335144066,51626.97742566203,51512.02387250669,51397.57189776297,
	51283.61874265712,51170.16166740601,51057.197951070644,50944.72489140524,50832.73980471098,
	50721.24002569424,50610.2229073185,50499.68582066333,50389.626154783975,50280.04131656713,
	50170.92873059953,50062.285839021766,49954.11010139494,49846.39899456944,49739.15001254119,
	49632.360666329296,49526.028483834394,49420.15100971601,49314.72580525739,49209.750448239356,
	49105.22253280996,49001.13966936247,48897.49948440793,48794.29962044914,48691.53773586066,
	48589.21150476573,48487.318616911616,48385.856777557085,48284.823707345706,48184.21714219402,
	48084.03483316933,47984.27454637779,47884.93406284657,47786.01117841228,47687.503703607406,
	47589.40946354567,47491.7262978153,47394.45206036568,47297.58461939692,47201.12185725726,
	47105.06167032953,47009.401968928796,46914.140677193755,46819.27573298451,46724.80508777838,
	46630.7267065655,46537.03856774817,46443.73866304027,46350.82499736425,46258.2955887544,
	46166.14846825719,46074.38167983341,45982.99328026255,45891.98133904319,45801.34393830081,
	45711.07917269252,45621.18514931516,45531.65998760511,45442.50181925602,45353.70878812174,
	45265.2790501241,45177.210773169216,45089.50213705156,45002.15133336945,44915.156565437974,
	44828.516048198006,44742.22800813568,44656.29068319163,44570.702322679834,44485.461187201836,
	44400.5655485616,44316.013689689506,44231.80390455097,44147.93449807194,44064.403786058225,
	43981.21009511045,43898.35176254821,43815.82713633317,43733.63457498721,43651.772447516574,
	43570.23913333652,43489.0330221935,43408.15251408871,43327.596019207216,43247.36195783947,
	43167.44876031066,43087.85486690462,43008.578727796164,42929.618802972785,42850.9735621694,
	42772.64148479544,42694.6210598624,42616.910785917484,42539.509170975194,42462.41473244496,
	42385.625997067626,42309.14150084445,42232.95978897336,42157.07941578272,42081.49894466143,
	42006.216947999805,41931.232007121005,41856.54271221738,41782.14766228954,41708.04546507845,
	41634.23473700827,41560.71410312093,41487.482197014826,41414.537660786555,41341.87914496607,
	41269.50530845957,41197.414818490324,41125.60635053619,41054.07858827639,40982.83022352703,
	40911.85995618722,40841.16649418383,40770.74855340964,40700.60485766919,40630.734138626,
	40561.135135740304,40491.80659622212,40422.74727496988,40353.955934520316,40285.431344994766,
	40217.172284041764,40149.177536789924,40081.44589579264,40013.976160973165,39946.76713958051,
	39879.81764613042,39813.12650236038,39746.69253717498,39680.51458660031,39614.591493727734,
	39548.9221086735,39483.50528852238,39418.3398972828,39353.42480583835,39288.75889190057,
	39224.3410399597,39160.17014123909,39096.24509364967,39032.56480174111,38969.12817665982,
	38905.93413609804,38842.98160425451,38780.26951178515,38717.796795760805,38655.56239962479,
	38593.565273144995,38531.804372371975,38470.278659598844,38408.987103315325,38347.92867816531,
	38287.102364907594,38226.50715037066,38166.142027412905,38106.0059948824,38046.09805757374,
	37986.417226190766,37926.962517302585,37867.732953306986,37808.727562389235,37749.945378482684,
	37691.385441230625,37633.04679594717,37574.928493578846,37517.029590666876,37459.3491493087,
	37401.8862371204,37344.639927201904,37287.60929809587,37230.793433754276,37174.19142350081,
	37117.80236199562,37061.62534919725,37005.65949033023,36949.90389584769,36894.35768139624,
	36839.01996778256,36783.88988093757,36728.96655188294,36674.24911669652,36619.73671647938,
	36565.4284973224,36511.323610271276,36457.42121129553,36403.72046125482,36350.22052586672,
	36296.92057567408,36243.81978601336,36190.917336983824,36138.21241341261,36085.704204828355,
	36033.391905425306,35981.27471403668,35929.35183410043,35877.62247363063,35826.08584518718,
	35774.74116584704,35723.587657171534,35672.62454517836,35621.851060313966,35571.26643742215,
	35520.86991571483,35470.660738746905,35420.63815438253,35370.80141477245,35321.14977632085,
	35271.68249966121,35222.39884962716,35173.298095225124,35124.37950960667,35075.64237004222,
	35027.085957894,34978.70955858933,34930.51246159423,34882.493960385735,34834.65335242918,
	34786.98993914886,34739.5030259036,34692.19192196143,34645.05594047412,34598.094398451685,
	34551.3066167382,34504.69191998577,34458.249636630986,34411.97909886964,34365.879642632724,
	34319.95060756319,34274.19133698918,34228.60117790459,34183.17948094133,34137.925600348695,
	34092.83889396778,34047.9187232108,34003.16445303645,33958.57545192681,33914.151091866406,
	33869.89074831794,33825.79380020079,33781.85962986909,33738.087623089596,33694.47716901854,
	33651.027660182255,33607.73849245303,33564.60906502874,33521.638780414054,33478.82704439417,
	33436.17326601744,33393.67685757532,33351.33723457754,33309.15381573624,33267.1260229414,
	33225.25328124419,33183.53501883358,33141.970667019064,33100.55966020917,33059.30143589136,
	33018.19543461403,32977.2410999663,32936.43787855733,32895.785219999336,32855.2825768867,
	32814.92940477861,32774.72516217789,32734.669310515153,32694.761314127292,32655.000640241815,
	32615.386758956047,32575.919143220166,32536.59726881971,32497.420614355447,32458.388661227473,
	32419.500893617078,32380.756798468257,32342.15586547035,32303.69758704141,32265.381458310658,
	32227.206977101083,32189.17364391152,32151.280961900935,32113.5284368712,32075.915577250787,
	32038.44189407594,32001.106900976712,31963.910114160604,31926.851052393096,31889.92923698402,
	31853.14419177196,31816.495443106418,31779.982519831363,31743.60495327266,31707.36227721946,
	31671.254027908257,31635.279744010182,31599.438966612255,31563.731239204633,31528.156107663755,
	31492.7131202386,31457.401827533176,31422.221782493903,31387.172540394156,31352.253658819303,
	31317.46469765074,31282.80521905351,31248.274787460527,31213.872969557637,31179.599334270737,
	31145.45345274961,31111.434898355823,31077.54324664696,31043.778075362978,31010.138964413163,
	30976.62549586025,30943.23725390989,30909.97382489328,30876.834797255946,30843.819761543215,
	30810.92831038742,30778.160038494592,30745.514542629287,30712.99142160394,30680.59027626317,
	30648.310709474186,30616.152326109488,30584.114733036953,30552.197539106466,30520.40035513569,
	30488.722793898753,30457.16447011323,30425.72500042862,30394.404003410455,30363.201099531467,
	30332.115911158682,30301.148062537955,30270.297179786117,30239.562890875954,30208.94482562478,
	30178.442615682474,30148.05589451943,30117.784297415186,30087.627461445278,30057.585025470216,
	30027.656630124813,29997.84191780403,29968.14053265398,29938.5521205581,29909.0763291271,
	29879.712807687567,29850.461207269553,29821.321180595445,29792.29238207073,29763.37446776899,
	29734.56709542457,29705.869924419138,29677.28261577127,29648.80483212524,29620.436237741127,
	29592.176498482055,29564.02528180606,29535.98225675187,29508.04709393095,29480.21946551596,
	29452.499045229357,29424.885508334693,29397.37853162391,29369.977793407717,29342.68297350614,
	29315.493753236755,29288.409815405113,29261.430844294515,29234.55652565388,29207.786546691554,
	29181.12059606138,29154.558363854052,29128.099541586857,29101.74382219468,29075.490900018496,
	29049.34047079609,29023.292231651878,28997.34588108801,28971.501118973716,28945.757646536153,
	28920.11516634876,28894.57338232485,28869.131999705125,28843.790725050225,28818.54926622833,
	28793.407332409945,28768.364634053374,28743.42088289949,28718.575791959644,28693.82907550821,
	28669.180449071373,28644.629629419775,28620.17633455764,28595.820283713707,28571.5611973336,
	28547.398797069112,28523.332805769147,28499.36294747135,28475.488947392536,28451.71053192059,
	28428.027428604,28404.43936614339,28380.946074383795,28357.547284303884,28334.242728009023,
	28311.032138719955,28287.915250767153,28264.891799579305,28241.961521676047,28219.12415465833,
	28196.37943720112,28173.727109043328,28151.16691097954,28128.69858485167,28106.32187354096,
	28084.03652095776,28061.842272034566,28039.73887271712,28017.726069955752,27995.803611696614,
	27973.97124687368,27952.22872540095,27930.575798162423,27909.012217005402,27887.53773473176,
	27866.152105088477,27844.855082761806,27823.6464233655,27802.5258834361,27781.49322042322,
	27760.548192680664,27739.69055945922,27718.920080898257,27698.23651801778,27677.639632709906,
	27657.129187731316,27636.70494669479,27616.366674061428,27596.11413513194,27575.947096039974,
	27555.865323742593,27535.86858601391,27515.95665143578,27496.129289390585,27476.386270052728,
	27456.72736438192,27437.15234411355,27417.660981752804,27398.253050565327,27378.92832457005,
	27359.686578530902,27340.52758795025,27321.451129058645,27302.456978810686,27283.544914873357,
	27264.714715621234,27245.966160127067,27227.299028155285,27208.713100153676,27190.208157245088,
	27171.78398122129,27153.440354533617,27135.177060287482,27116.993882231913,27098.890604754088,
	27080.867012871728,27062.922892224055,27045.058029065563,27027.27221025771,27009.565223262278,
	26991.936856131633,26974.386897504268,26956.91513659548,26939.52136318954,26922.205367633003,
	26904.96694082692,26887.805874219885,26870.721959799834,26853.714990086533,26836.784758124853,
	26819.931057476868,26803.153682214157,26786.452426911164,26769.82708663696,26753.277456948123,
	26736.803333881802,26720.40451394716,26704.080794119698,26687.831971832224,26671.657844967674,
	26655.55821185375,26639.532871252533,26623.581622355538,26607.704264774467,26591.900598536267,
	26576.170424072676,26560.51354221625,26544.92975418979,26529.41886160193,26513.98066643733,
	26498.61497105122,26483.321578160838,26468.100290839186,26452.950912506964,26437.873246925497,
	26422.867098188664,26407.932270717705,26393.068569251533,26378.27579884124,26363.553764841326,
	26348.902272903677,26334.32112896944,26319.8101392624,26305.369110281,26290.99784879142,
	26276.696161820622,26262.463856648414,26248.30074080072,26234.206622041627,26220.181308367635,
	26206.224607998105,26192.336329369497,26178.516281128374,26164.764272122782,26151.08011139636,
	26137.463608179976,26123.91457188454,26110.432812095034,26097.018138561703,26083.670361193123,
	26070.389290049185,26057.17473533396,26044.02650738799,26030.944416681,26017.928273805126,
	26004.977889466554,25992.093074479155,25979.27363975696,25966.51939630694,25953.830155220785,
	25941.205727668526,25928.645924891003,25916.150558192294,25903.71943893232,25891.352378519838,
	25879.049188404977,25866.809680070735,25854.633665027213,25842.52095480398,25830.47136094136,
	25818.484694984072,25806.56076847362,25794.699392940598,25782.900379897805,25771.163540831916,
	25759.48868719641,25747.875630404564,25736.324181820368,25724.834152753192,25713.405354448525,
	25702.037598080602,25690.730694745835,25679.484455454287,25668.298691121876,25657.17321256344,
	25646.107830484798,25635.102355474897,25624.156597998088,25613.27036838614,25602.443476831773,
	25591.675733378972,25580.966947916124,25570.316930168716,25559.725489690372,25549.19243585538,
	25538.717577850788,25528.300724668527,25517.94168509734,25507.640267714793,25497.396280878063,
	25487.209532718254,25477.07983112951,25467.006983762847,25456.990798016486,25447.031081028752,
	25437.127639668666,25427.28028052819,25417.488809913626,25407.753033836656,25398.07275800665,
	25388.447787821493,25378.87792835867,25369.36298436706,25359.902760257704,25350.49706009522,
	25341.14568758887,25331.848446083004,25322.60513854857,25313.415567573673,25304.27953535429,
	25295.19684368511,25286.167293949562,25277.190687111262,25268.266823703205,25259.395503818774,
	25250.576527102385,25241.809692737934,25233.0947994404,25224.431645444907,25215.820028496502,
	25207.259745839685,25198.750594208457,25190.29236981464,25181.88486833808,25173.527884914885,
	25165.221214127,25156.96464999055,25148.757985944623,25140.601014839405,25132.493528924788,
	25124.435319838467,25116.426178593505,25108.465895566085,25100.55426048367,25092.69106241117,
	25084.876089738922,25077.10913016968,25069.389970704455,25061.718397629706,25054.09419650283,
	25046.51715213919,25038.9870485963,25031.503669160826,25024.0667963326,25016.67621180958,
	25009.331696473477,25002.033030372524,24994.779992706655,24987.57236181051,24980.409915136937,
	24973.292429240173,24966.219679758113,24959.19144139523,24952.207487903343,24945.267592064847,
	24938.371525672068,24931.51905950969,24924.709963333582,24917.944005852314,24911.22095470522,
	24904.54057644251,24897.902636503426,24891.30689919485,24884.75312766831,24878.241083897985,
	24871.770528657125,24865.34122149459,24858.95292071028,24852.605383330367,24846.298365083007,
	24840.031620371305,24833.80490224798,24827.61796238819,24821.470551062474,24815.362417108434,
	24809.29330790331,24803.262969334133,24797.271145768773,24791.31758002544,24785.402013343624,
	24779.524185351493,24773.683834035517,24767.880695707918,24762.114504974972,24756.384994702817,
	24750.691895986092,24745.034938112345,24739.413848529588,24733.82835281067,24728.278174618838,
	24722.76303567399,24717.28265571537,24711.83675246809,24706.4250416071,24701.04723672145,
	24695.703049278993,24690.392188591402,24685.114361779102,24679.869273736043,24674.65662709581,
	24669.4761221975,24664.327457052736,24659.210327313125,24654.124426238966,24649.069444669087,
	24644.045070990887,24639.05099111391,24634.086888442427,24629.1524438527,24624.247335670025,
	24619.37123964916,24614.52382895717,24609.70477415939,24604.913743207755,24600.150401433657,
	24595.414411543716,24590.7054336204,24586.023125126158,24581.367140914088,24576.737133241964,
	24572.13275179347,24567.553643705145,24562.999453600227,24558.46982362842,24553.964393515977,
	24549.482800620004,24545.024679996244,24540.58966447184,24536.177384730574,24531.787469407875,
	24527.41954519641,24523.07323696414,24518.7481678839,24514.443959576223,24510.16023226629,
	24505.896604953512,24501.65269559738,24497.428121318437,24493.222498613897,24489.035443591416,
	24484.866572219133,24480.715500592913,24476.581845222616,24472.465223335264,24468.36525319915,
	24464.281554464,24460.213748523387,24456.161458894592,24452.124311618434,24448.1019356787,
	24444.093963440748,24440.100031108006,24436.119779198933,24432.15285304008,24428.19890327728,
	24424.25758640315,24420.328565299616,24416.411509795318,24412.50609723555,24408.612013063677,
	24404.72895141102,24400.85661569733,24396.994719233488,24393.142985830593,24389.301150408643,
	24385.468959602906,24381.646172368717,24377.832560575855,24374.02790959507,24370.232018868996,
	24366.44470246975,24362.665789631403,24358.895125264626,24355.13257043874,24351.378002838013,
	24347.631317181604,24343.89242560525,24340.16125800437,24336.437762331494,24332.721904847825,
	24329.01367032217,24325.31306218056,24321.620102597153,24317.934832529114,24314.25731169224,
	24310.58761847423,24306.92584978542,24303.27212084851,24299.62656492019,24295.98933295281,
	24292.360593190577,24288.74053070307,24285.129346857,24281.527258728256,24277.934498456212,
	24274.351312542243,24270.777961095544,24267.214717030154,24263.661865215323,24260.119701586496,
	24256.58853221458,24253.068672347024,24249.56044541752,24246.06418203281,24242.580218942272,
	24239.108897993145,24235.650565077933,24232.20556907994,24228.774260819675,24225.356992009565,
	24221.95411422011,24218.565977864804,24215.192931204212,24211.83531937856,24208.493483467806,
	24205.16775958695,24201.85847802017,24198.56596239023,24195.290528877187,24192.03248547832,
	24188.792131317437,24185.56975600238,24182.365639035077,24179.180049270148,24176.013244428625,
	24172.865470661967,24169.73696216953,24166.627940867067,24163.538616106805,24160.469184448142,
	24157.419829477993,24154.390721675674,24151.38201832871,24148.39386348836,24145.426387970525,
	24142.479709394942,24139.553932263912,24136.64914807422,24133.765435465575,24130.902860399074,
	24128.06147636195,24125.24132460137,24122.44243438127,24119.664823260155,24116.908497387227,
	24114.173451818133,24111.459670842814,24108.767128326213,24106.095788061262,24103.445604128665,
	24100.81652126381,24098.208475229665,24095.621393192036,24093.055194096156,24090.509789046355,
	24087.985081680472,24085.48096854694,24082.997339474936,24080.534077941607,24078.091061434247,
	24075.66816180688,24073.265245627746,24070.882174523686,24068.51880551125,24066.174991324453,
	24063.850580728165,24061.545418829784,24059.2593473727,24056.992205026523,24054.74382766551,
	24052.514048635436,24050.302699012303,24048.10960785221,24045.934602424928,24043.77750844721,
	24041.638150297636,24039.516351225808,24037.411933551335,24035.324718853164,24033.25452814826,
	24031.201182065943,24029.16450100629,24027.144305293856,24025.14041532588,24023.152651706412,
	24021.18083537624,24019.224787732826,24017.28433074731,24015.359287068317,24013.449480124214,
	24011.554734214624,24009.67487459819,24007.80972757587,24005.95912056204,24004.122882155934,
	24002.300842208846,24000.49283187728,23998.69868368331,23996.918231559386,23995.1513108979,
	23993.39775858941,23991.657413059776,23989.930114307102,23988.21570392693,23986.514025140226,
	23984.824922818716,23983.14824350177,23981.483835415835,23979.83154848931,23978.19123436285,
	23976.562746401214,23974.94593969901,23973.340671086586,23971.746799133267,23970.164184150093,
	23968.592688187608,23967.0321750352,23965.482510218655,23963.943560992786,23962.41519633815,
	23960.897286952008,23959.38970524104,23957.89232531034,23956.405022955707,23954.927675649225,
	23953.460162529118,23952.002364386874,23950.55416365361,23949.115444383613,23947.6860922449,
	23946.26599449829,23944.85503998391,23943.453119107653,23942.060123819865,23940.67594760284,
	23939.30048545135,23937.93363385644,23936.57529078701,23935.225355672323,23933.883729385674,
	23932.550314223197,23931.225013889958,23929.907733476884,23928.598379447623,23927.296859617156,
	23926.003083134496,23924.716960463622,23923.438403366763,23922.167324887087,23920.903639326865,
	23919.64726223208,23918.398110375958,23917.156101739896,23915.921155493063,23914.693191979444,
	23913.47213269793,23912.257900284872,23911.050418497674,23909.849612199203,23908.655407337985,
	23907.46773093398,23906.28651106151,23905.11167683367,23903.94315838468,23902.780886854318,
	23901.624794373194,23900.47481404817,23899.330879945363,23898.192927072763,23897.060891371646,
	23895.934709696045,23894.81431980165,23893.699660328926,23892.590670791982,23891.487291561403,
	23890.389463852443,23889.29712971282,23888.21023200575,23887.12871440029,23886.052521356498,
	23884.981598113714,23883.915890676675,23882.855345805652,23881.799910999573,23880.749534490675,
	23879.70416522803,23878.663752868622,23877.62824776091,23876.597600940928,23875.571764116998,
	23874.550689659165,23873.534330585786,23872.522640562234,23871.515573881374,23870.513085454586,
	23869.515130807722,23868.52166606389,23867.53264794134,23866.548033734893,23865.567781316444,
	23864.591849117616,23863.620196124735,23862.65278187197,23861.689566427573,23860.73051038752,
	23859.77557486845,23858.824721498728,23857.87791240938,23856.93511022632,23855.99627806498,
	23855.06137951538,23854.130378644742,23853.2032399857,23852.27992852317,23851.36040969547,
	23850.444649383673,23849.53261390634,23848.624270007378,23847.719584857612,23846.818526041625,
	23845.921061554604,23845.027159794892,23844.13678955571,23843.249920024624,23842.366520772885,
	23841.486561748625,23840.61001327649,23839.736846043594,23838.86703110412,23838.000539864945,
	23837.13734408536,23836.27741586809,23835.420727658617,23834.567252234992,23833.716962707957,
	23832.86983251125,23832.02583539854,23831.184945438752,23830.34713701171,23829.512384806316,
	23828.680663806,23827.851949297146,23827.026216854163,23826.203442342437,23825.383601910777,
	23824.56667198603,23823.752629274135,23822.941450745457,23822.13311364712,23821.32759548144,
	23820.52487401669,23819.72492727336,23818.92773352437,23818.13327129412,23817.341519348473,
	23816.552456697216,23815.76606258571,23814.982316498543,23814.201198145638,23813.422687467333,
	23812.64676463014,23811.87341002071,23811.102604242864,23810.334328118457,23809.568562678724,
	23808.805289166114,23808.044489027317,23807.286143917576,23806.530235685208,23805.77674637955,
	23805.02565824769,23804.27695372732,23803.53061544183,23802.786626207635,23802.04496902266,
	23801.305627067297,23800.568583699634,23799.833822459746,23799.1013270567,23798.371081374204,
	23797.643069465557,23796.917275553384,23796.193684023005,23795.472279422185,23794.75304646674,
	23794.03597001995,23793.321035112695,23792.6082269217,23791.897530783164,23791.18893217777,
	23790.48241674024,23789.77797024696,23789.075578623087,23788.375227935052,23787.676904386728,
	23786.980594327368,23786.286284240283,23785.5939607425,23784.90361058639,23784.215220658247,
	23783.528777969535,23782.844269667585,23782.161683020382,23781.481005424816,23780.802224398903,
	23780.125327584537,23779.45030274483,23778.77713776329,23778.105820632936,23777.436339472282,
	23776.768682513288,23776.102838093753,23775.438794673275,23774.776540813746,23774.116065192557,
	23773.45735658912,23772.800403893645,23772.145196098783,23771.491722300267,23770.839971701535,
	23770.18993359996,23769.54159739868,23768.894952597435,23768.249988792497,23767.60669567843,
	23766.96506304407,23766.325080772298,23765.686738841734,23765.050027318466,23764.414936361754,
	23763.781456219844,23763.149577230513,23762.519289817796,23761.89058449302,23761.26345185501,
	23760.6378825822,23760.01386744204,23759.391397278298,23758.770463025558,23758.15105568953,
	23757.53316635916,23756.916786202528,23756.30190647012,23755.688518478997,23755.076613631103,
	23754.466183400546,23753.857219333655,23753.24971305515,23752.643656256823,23752.03904070838,
	23751.435858246674,23750.83410077731,23750.233760277653,23749.63482879558,23749.037298442378,
	23748.44116140226,23747.846409917936,23747.2530363043,23746.66103293904,23746.07039226424,
	23745.4811067815,23744.893169064602,23744.30657173994,23743.72130749993,23743.137369096945,
	23742.554749342722,23741.973441107693,23741.393437323743,23740.814730979157,23740.237315121023,
	23739.66118285103,23739.086327326055,23738.51274176309,23737.94041943456,23737.3693536598,
	23736.799537821094,23736.230965344766,23735.663629719118,23735.0975244811,23734.53264321585,
	23733.968979565307,23733.40652721578,23732.845279911948,23732.28523143516,23731.726375633345,
	23731.16870638667,23730.612217630292,23730.05690334693,23729.50275756631,23728.94977436671,
	23728.39794786395,23727.84727222783,23727.297741670896,23726.749350451853,23726.202092867657,
	23725.65596326694,23725.110956035584,23724.56706560392,23724.024286447166,23723.482613079537,
	23722.942040056423,23722.402561978695,23721.864173482812,23721.326869248238,23720.790643993976,
	23720.25549248008,23719.721409501482,23719.18838989697,23718.656428538263,23718.125520339057,
	23717.59566025154,23717.066843260025,23716.53906439135,23716.01231870627,23715.4866013001,
	23714.961907307043,23714.438231896595,23713.915570268535,23713.39391766565,23712.873269357704,
	23712.35362064974,23711.83496688762,23711.317303443575,23710.800625718235,23710.284929161364,
	23709.77020923975,23709.25646146006,23708.743681356704,23708.23186449972,23707.721006492826,
	23707.21110295854,23706.70214956256,23706.194141997727,23705.687075983104,23705.180947271438,
	23704.67575164467,23704.171484912848,23703.66814291783,23703.165721523113,23702.664216633162,
	23702.16362416792,23701.663940080325,23701.165160352586,23700.66728099537,23700.170298041212,
	23699.674207556567,23699.179005625607,23698.684688370784,23698.191251928703,23697.698692471327,
	23697.20700619081,23696.716189304083,23696.226238064675,23695.73714873376,23695.248917609624,
	23694.761541014803,23694.275015288404,23693.78933680171,23693.304501945953,23692.8205071369,
	23692.337348814603,23691.855023445132,23691.373527509037,23690.892857520852,23690.413010007516,
	23689.933981526887,23689.45576865521,23688.978367991083,23688.501776157314,23688.025989797858,
	23687.55100557284,23687.07682016935,23686.603430297626,23686.130832683117,23685.659024075645,
	23685.188001243696,23684.717760980933,23684.248300099287,23683.77961542547,23683.311703811218,
	23682.844562126626,23682.378187265385,23681.91257613616,23681.447725665097,23680.98363280432,
	23680.520294522456,23680.057707804022,23679.595869649787,23679.13477709137,23678.67442716765,
	23678.21481693679,23677.755943479722,23677.297803891874,23676.840395285926,23676.38371479601,
	23675.927759569477,23675.47252677814,23675.018013598947,23674.564217234907,23674.111134906667,
	23673.658763846823,23673.207101309035,23672.756144559396,23672.30589087922,23671.856337574656,
	23671.4074819599,23670.959321366463,23670.51185314736,23670.06507466258,23669.618983293225,
	23669.173576435736,23668.728851502092,23668.28480591628,23667.841437117957,23667.398742569043,
	23666.956719738308,23666.515366113388,23666.07467918795,23665.634656484548,23665.195295529727,
	23664.756593871036,23664.31854906282,23663.88115868212,23663.44442030745,23663.00833154718,
	23662.572890011088,23662.13809332781,23661.703939136805,23661.27042509739,23660.837548874464,
	23660.405308150122,23659.97370061809,23659.542723988445,23659.112375978897,23658.682654322347,
	23658.25355677344,23657.825081077837,23657.397225017292,23656.96998637077,23656.54336293368,
	23656.11735252102,23655.69195294719,23655.267162047745,23654.84297766739,23654.419397662154,
	23653.996419901312,23653.57404226577,23653.15226264773,23652.731078949382,23652.310489087544,
	23651.890490991176,23651.47108259189,23651.05226184193,23650.634026700947,23650.216375143238,
	23649.79930514856,23649.382814712604,23648.966901835287,23648.551564534857,23648.136800836757,
	23647.72260877458,23647.30898639789,23646.89593176524,23646.48344293739,23646.071517997254,
	23645.660155032205,23645.249352143674,23644.839107434615,23644.42941902009,23644.020285039656,
	23643.611703624432,23643.203672921947,23642.796191094305,23642.389256300085,23641.982866722752,
	23641.57702055153,23641.171715971497,23640.766951197595,23640.362724440067,23639.959033926196,
	23639.55587788477,23639.153254556728,23638.751162203,23638.349599073106,23637.948563439808,
	23637.54805357915,23637.148067787537,23636.74860434864,23636.349661569853,23635.951237768833,
	23635.553331258398,23635.15594038051,23634.759063462752,23634.36269885481,23633.966844917348,
	23633.571500010803,23633.17666249964,23632.782330770555,23632.38850321902,23631.99517822593,
	23631.60235420431,23631.210029563823,23630.818202724782,23630.42687211536,23630.036036168894,
	23629.645693338844,23629.255842058537,23628.866480801364,23628.477608027126,23628.089222208924,
	23627.701321830296,23627.313905384646,23626.92697135704,23626.540518260586,23626.154544604786,
	23625.769048898113,23625.384029678797,23624.999485472912,23624.615414818414,23624.23181626507,
	23623.84868836618,23623.466029679865,23623.083838774008,23622.702114227028,23622.32085461429,
	23621.94005852396,23621.55972455819,23621.17985130972,23620.80043739383,23620.421481416714,
	23620.04298200474,23619.6649377841,23619.287347395093,23618.910209468188,23618.5335226602,
	23618.157285614077,23617.781497000407,23617.40615547899,23617.03125972205,23616.65680841019,
	23616.28280022569,23615.909233863007,23615.536108014763,23615.16342138426,23614.79117268778,
	23614.419360633816,23614.04798393932,23613.677041337065,23613.306531561582,23612.93645334644,
	23612.566805434548,23612.197586583512,23611.828795540303,23611.46043107108,23611.092491938,
	23610.72497692603,23610.357884802488,23609.991214355152,23609.62496437039,23609.25913363774,
	23608.893720971806,23608.52872516838,23608.164145041523,23607.799979405176,23607.436227078077,
	23607.072886897786,23606.70995768831,23606.347438289085,23605.98532754093,23605.623624294163,
	23605.262327402463,23604.901435717253,23604.54094810717,23604.18086344115,23603.821180587653,
	23603.461898425223,23603.103015845023,23602.744531722652,23602.386444960142,23602.028754449606,
	23601.671459094734,23601.31455780317,23600.958049488,23600.601933065886,23600.24620745426,
	23599.890871587344,23599.5359243892,23599.18136479101,23598.82719174525,23598.47340418557,
	23598.120001067968,23597.76698133991,23597.41434396424,23597.062087903152,23596.710212122674,
	23596.35871559233,23596.007597291984,23595.65685619829,23595.306491296105,23594.956501575074,
	23594.606886027614,23594.2576436525,23593.908773451858,23593.5602744313,23593.212145600777,
	23592.864385972247,23592.516994564856,23592.16997040546,23591.823312507502,23591.47701991861,
	23591.131091665462,23590.785526788917,23590.440324327505,23590.09548332963,23589.751002849924,
	23589.406881936316,23589.063119651353,23588.719715061303,23588.37666722536,23588.033975216884,
	23587.691638109376,23587.349654984824,23587.008024911986,23586.666746990308,23586.32582030132,
	23585.985243945557,23585.645017008297,23585.305138593827,23584.965607808586,23584.62642376403,
	23584.287585563117,23583.949092325765,23583.61094316739,23583.27313720996,23582.935673579235,
	23582.598551406216,23582.26176982107,23581.925327958394,23581.589224959982,23581.253459969485,
	23580.918032132642,23580.58294059853,23580.24818451552,23579.913763048855,23579.579675354486,
	23579.245920590405,23578.91249793561,23578.579406545774,23578.24664560426,23577.914214278157,
	23577.582111750777,23577.250337213194,23576.91888984205,23576.58776882576,23576.256973360785,
	23575.92650264303,23575.59635586998,23575.26653224703,23574.937030966583,23574.60785124977,
	23574.278992304655,23573.950453344372,23573.62223357917,23573.294332244703,23572.966748547493,
	23572.639481727834,23572.312531008276,23571.985895616825,23571.659574797588,23571.333567782087,
	23571.007873811224,23570.6824921353,23570.35742199461,23570.032662637626,23569.708213328468,
	23569.384073308767,23569.06024184663,23568.73671819921,23568.41350162659,23568.090591401036,
	23567.767986791983,23567.4456870607,23567.123691500892,23566.801999375995,23566.480609971393,
	23566.15952256609,23565.838736449652,23565.518250909598,23565.198065241977,23564.8781787317,
	23564.55859067503,23564.23930038391,23563.920307144737,23563.601610274072,23563.283209064717,
	23562.965102839244,23562.647290901466,23562.329772568577,23562.012547157377,23561.695613990352,
	23561.378972387574,23561.06262166481,23560.74656116573,23560.430790207676,23560.11530812662,
	23559.800114252248,23559.485207926766,23559.170588488185,23558.856255278253,23558.542207638744,
	23558.22844492081,23557.914966468143,23557.601771632802,23557.28885977198,23556.976230236967,
	23556.663882385612,23556.351815576993,23556.040029182077,23555.72852255934,23555.41729507803,
	23555.10634610668,23554.795675014622,23554.485281183705,23554.17516398758,23553.865322793397,
	23553.555757001945,23553.24646597777,23552.93744911864,23552.62870580287,23552.320235428975,
	23552.012037374825,23551.70411105125,23551.396455837992,23551.08907114505,23550.781956374776,
	23550.4751109177,23550.168534186832,23549.86222558408,23549.556184512294,23549.25041039623,
	23548.94490264365,23548.639660664965,23548.334683880046,23548.029971709988,23547.725523567413,
	23547.42133888465,23547.117417080077,23546.81375758559,23546.510359821477,23546.20722322701,
	23545.904347234562,23545.601731276165,23545.29937478976,23544.997277214057,23544.695437989347,
	23544.393856555995,23544.092532359962,23543.79146484018,23543.490653465316,23543.19009766561,
	23542.88979689739,23542.589750620416,23542.289958282978,23541.990419351725,23541.69113327811,
	23541.392099526325,23541.093317555933,23540.794786830065,23540.496506827487,23540.198477010385,
	23539.900696839184,23539.60316579935,23539.305883361074,23539.00884899655,23538.71206217988,
	23538.415522398907,23538.11922913276,23537.82318185371,23537.52738006011,23537.231823231476,
	23536.93651085709,23536.641442421107,23536.346617413485,23536.0520353464,23535.757695688586,
	23535.463597947703,23535.169741624126,23534.876126212926,23534.58275121061,23534.289616132675,
	23533.99672047583,23533.70406374837,23533.411645454496,23533.11946510383,23532.82752220287,
	23532.535816278938,23532.244346828345,23531.95311338114,23531.662115441126,23531.3713525438,
	23531.08082419298,23530.790529920316,23530.500469243085,23530.210641690734,23529.921046791278,
	23529.631684063886,23529.342553043814,23529.05365326785,23528.76498426056,23528.476545549787,
	23528.188336697873,23527.900357213442,23527.612606644736,23527.325084527776,23527.037790413116,
	23526.75072383416,23526.46388434369,23526.17727148704,23525.890884806613,23525.604723850898,
	23525.31878816949,23525.033077321044,23524.747590846433,23524.46232831979,23524.177289280204,
	23523.892473282485,23523.60787989573,23523.323508678357,23523.039359188475,23522.755430989255,
	23522.471723644165,23522.188236721206,23521.904969783096,23521.62192240399,23521.339094150473,
	23521.05648459487,23520.77409331026,23520.49191986212,23520.209963833935,23519.928224799056,
	23519.646702331633,23519.36539601631,23519.084305431334,23518.803430157885,23518.522769776682,
	23518.242323878094,23517.96209203504,23517.682073845503,23517.40226889323,23517.122676768722,
	23516.843297056617,23516.564129361435,23516.285173256347,23516.006428359964,23515.72789424631,
	23515.44957052908,23515.17145678751,23514.893552632464,23514.61585766037,23514.338371477912,
	23514.061093684144,23513.784023882883,23513.507161671034,23513.230506673604,23512.954058484494,
	23512.677816715277,23512.401780970507,23512.12595087511,23511.850326030934,23511.5749060499,
	23511.29969055418,23511.024679150727,23510.749871463307,23510.475267103648,23510.200865692503,
	23509.92666685714,23509.65267021095,23509.378875379425,23509.105281984193,23508.831889656445,
	23508.558698009365,23508.285706686795,23508.012915298637,23507.740323493443,23507.467930875737,
	23507.19573710731,23506.923741792958,23506.65194458293,23506.380345114278,23506.10894300399,
	23505.837737910635,23505.566729460923,23505.295917283274,23505.025301038913,23504.75488035839,
	23504.484654876735,23504.214624252716,23503.944788122335,23503.675146122645,23503.405697905742,
	23503.136443133277,23502.867381434415,23502.598512467004,23502.329835870823,23502.061351313976,
	23501.79305843774,23501.52495689762,23501.257046344756,23500.989326436676,23500.7217968305,
	23500.45445718402,23500.187307160537,23499.920346408482,23499.653574592132,23499.386991375635,
	23499.120596419816,23498.8543893795,23498.588369931433,23498.32253774107,23498.05689245896,
	23497.791433765728,23497.526161331265,23497.26107481093,23496.996173875767,23496.73145821739,
	23496.466927478326,23496.20258135128,23495.9384195019,23495.674441609903,23495.410647337074,
	23495.147036378392,23494.883608395157,23494.620363075464,23494.357300098545,23494.09441913587,
	23493.831719869868,23493.569201991595,23493.306865166967,23493.04470909121,23492.782733458997,
	23492.520937932484,23492.259322204918,23491.997885975452,23491.73662892208,23491.475550724783,
	23491.21465109035,23490.953929699826,23490.693386247927,23490.433020421086,23490.172831917815,
	23489.91282042237,23489.65298564327,23489.393327267055,23489.133844996068,23488.87453852206,
	23488.615407541358,23488.356451758144,23488.097670863346,23487.83906457359,23487.58063257904,
	23487.322374573403,23487.064290270628,23486.806379379006,23486.548641593803,23486.291076625497,
	23486.033684175298,23485.77646395215,23485.51941566163,23485.262539018244,23485.00583372502,
	23484.749299500665,23484.492936050163,23484.236743074067,23483.980720297026,23483.72486743806,
	23483.4691842032,23483.213670305202,23482.95832546171,23482.703149391404,23482.4481418027,
	23482.193302425723,23481.938630962362,23481.684127149063,23481.429790697643,23481.17562133081,
	23480.921618779656,23480.667782744636,23480.414112966166,23480.16060915221,23479.907271040687,
	23479.65409835646,23479.4010908202,23479.148248157497,23478.895570099234,23478.64305637678,
	23478.39070670875,23478.13852082809,23477.886498471726,23477.63463936684,23477.382943244906,
	23477.131409835718,23476.880038877207,23476.628830092082,23476.377783224707,23476.126898013616,
	23475.87617418513,23475.625611480697,23475.375209637554,23475.124968387263,23474.87488747548,
	23474.624966644195,23474.37520562592,23474.125604164146,23473.876161993496,23473.626878867202,
	23473.377754520014,23473.128788704333,23472.87998115826,23472.631331614586,23472.382839833826,
	23472.134505557984,23471.886328533797,23471.638308507332,23471.390445219466,23471.142738435035,
	23470.895187895763,23470.647793343443,23470.400554547286,23470.15347123697,23469.906543167854,
	23469.659770097154,23469.41315178542,23469.16668797318,23468.920378424427,23468.67422288649,
	23468.428221119826,23468.18237288251,23467.936677920086,23467.69113599891,23467.445746871166,
	23467.200510307848
	}}
};
