/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Tank;

public class TankEncoder {
    public static void encode(Entity entity, Writer writer) throws IOException {
        Tank tank = (Tank)entity;
        if (null == entity) {
            throw new IllegalArgumentException("The entity is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<hasNoTurret value=\"");
        writer.write(tank.hasNoTurret() ? "true" : "false");
        writer.write("\" /><stunnedTurns value=\"");
        int n = tank.getStunnedTurns();
        writer.write(String.valueOf(n));
        writer.write("\" /><moveHit value=\"");
        writer.write(tank.isMovementHit() ? "true" : "false");
        writer.write("\" /><moveHitPending value=\"");
        writer.write(tank.isMovementHitPending() ? "true" : "false");
        if (tank.isTurretLocked()) {
            writer.write("\" /><facing value=\"");
            n = tank.getFacing();
            writer.write(String.valueOf(n));
            writer.write("\" /><turretFacing value=\"");
            n = tank.getSecondaryFacing();
            writer.write(String.valueOf(n));
            writer.write("\" /><turretLocked value=\"true");
        }
        writer.write("\" />");
    }

    public static Entity decode(ParsedXML parsedXML, IGame iGame) {
        Tank tank = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The Tank node is null.");
        }
        String string = parsedXML.getAttribute("name");
        if (!parsedXML.getName().equals("class") || null == string || !string.equals("Tank")) {
            throw new IllegalStateException("Not passed an Tank node.");
        }
        tank = new Tank();
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            String string2 = parsedXML2.getName();
            if (null == string2) continue;
            if (string2.equals("stunnedTurns")) {
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode the stunnedTurns for a Tank unit.");
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                tank.setStunnedTurns(n);
                continue;
            }
            if (string2.equals("hasNoTurret")) {
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode hasNoTurret for a Tank unit.");
                }
                if (string.equals("true")) {
                    tank.setHasNoTurret(true);
                    continue;
                }
                tank.setHasNoTurret(false);
                continue;
            }
            if (string2.equals("moveHit")) {
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode moveHit for a Tank unit.");
                }
                if (!string.equals("true")) continue;
                tank.immobilize();
                tank.applyDamage();
                continue;
            }
            if (string2.equals("moveHitPending")) {
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode moveHitPending for a Tank unit.");
                }
                if (!string.equals("true")) continue;
                tank.immobilize();
                continue;
            }
            if (string2.equals("facing")) {
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode the facing for a Tank unit.");
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                tank.setFacing(n);
                continue;
            }
            if (string2.equals("turretFacing")) {
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode the turret's secondaryFacing for a Tank unit.");
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                tank.setSecondaryFacing(n);
                continue;
            }
            if (!string2.equals("turretLocked")) continue;
            string = parsedXML2.getAttribute("value");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode turretLocked for a Tank unit.");
            }
            if (!string.equals("true")) continue;
            tank.lockTurret();
        }
        return tank;
    }
}

