/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import megamek.common.net.ConnectedEvent;
import megamek.common.net.ConnectionEvent;
import megamek.common.net.ConnectionListener;
import megamek.common.net.DisconnectedEvent;
import megamek.common.net.IConnection;
import megamek.common.net.Packet;
import megamek.common.net.PacketReceivedEvent;
import megamek.common.net.marshall.PacketMarshaller;
import megamek.common.net.marshall.PacketMarshallerFactory;
import megamek.common.util.CircularIntegerBuffer;
import megamek.debug.Assert;

public abstract class AbstractConnection
implements IConnection {
    private static PacketMarshallerFactory marshallerFactory = PacketMarshallerFactory.getInstance();
    private static final int DEFAULT_MARSHALLING = 0;
    private String host;
    private int port;
    private boolean open;
    private Socket socket;
    private int id;
    private long bytesSent;
    private long bytesReceived;
    private SendQueue sendQueue = new SendQueue();
    private Vector<ConnectionListener> connectionListeners = new Vector();
    private CircularIntegerBuffer debugLastFewCommandsSent = new CircularIntegerBuffer(50);
    private CircularIntegerBuffer debugLastFewCommandsReceived = new CircularIntegerBuffer(50);
    protected int marshallingType;
    private PacketMarshaller marshaller;
    private boolean zipData = true;

    public AbstractConnection(String string, int n, int n2) {
        this.host = string;
        this.port = n;
        this.id = n2;
        this.setMarshallingType(0);
    }

    public AbstractConnection(Socket socket, int n) {
        this.socket = socket;
        this.id = n;
        this.setMarshallingType(0);
    }

    public boolean isServer() {
        return this.host == null;
    }

    protected int getMarshallingType() {
        return this.marshallingType;
    }

    protected void setMarshallingType(int n) {
        PacketMarshaller packetMarshaller = marshallerFactory.getMarshaller(n);
        Assert.assertTrue(packetMarshaller != null, "Unknown marshalling type");
        this.marshallingType = n;
        this.marshaller = packetMarshaller;
    }

    public synchronized boolean open() {
        if (!this.open) {
            if (this.socket == null) {
                try {
                    this.socket = new Socket(this.host, this.port);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            this.open = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            System.err.print(this.getConnectionTypeAbbrevation());
            this.sendQueue.reportContents();
            this.sendQueue.finish();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                System.err.print("Error closing connection #");
                System.err.print(this.getId());
                System.err.print(": ");
                System.err.println(iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.socket = null;
        }
        this.processConnectionEvent(new DisconnectedEvent(this));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getInetAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress().toString();
        }
        return "Unknown";
    }

    public boolean isCompressed() {
        return this.zipData;
    }

    public void setCompression(boolean bl) {
        this.zipData = bl;
    }

    public void send(Packet packet) {
        this.sendQueue.addPacket(new SendPacket(packet));
    }

    public synchronized void sendNow(SendPacket sendPacket) {
        try {
            this.sendNetworkPacket(sendPacket.getData(), sendPacket.isCompressed());
            this.debugLastFewCommandsSent.push(sendPacket.getCommand());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean hasPending() {
        return this.sendQueue.hasPending();
    }

    public synchronized long bytesSent() {
        return this.bytesSent;
    }

    public synchronized long bytesReceived() {
        return this.bytesReceived;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.addElement(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.removeElement(connectionListener);
    }

    protected void reportSendException(Exception exception, SendPacket sendPacket) {
        System.err.print(this.getConnectionTypeAbbrevation());
        System.err.print(" error sending command #");
        System.err.print(sendPacket.getCommand());
        System.err.print(": ");
        System.err.println(exception.getMessage());
        this.reportLastCommands();
    }

    protected void reportReceiveException(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        this.reportReceiveException(exception, stringBuffer);
        System.err.println(stringBuffer);
    }

    protected void reportReceiveException(Exception exception, StringBuffer stringBuffer) {
        System.err.print(this.getConnectionTypeAbbrevation());
        System.err.print(" error reading command: ");
        System.err.println(exception.getMessage());
        this.reportLastCommands();
    }

    protected void reportLastCommands() {
        this.reportLastCommands(true);
        System.err.println();
        this.reportLastCommands(false);
        System.err.println();
        this.sendQueue.reportContents();
    }

    protected void reportLastCommands(boolean bl) {
        CircularIntegerBuffer circularIntegerBuffer = bl ? this.debugLastFewCommandsSent : this.debugLastFewCommandsReceived;
        System.err.print("    Last ");
        System.err.print(circularIntegerBuffer.length());
        System.err.print(" commands that were ");
        System.err.print(bl ? "sent" : "received");
        System.err.print(" (oldest first): ");
        System.err.println(circularIntegerBuffer);
    }

    protected String getConnectionTypeAbbrevation() {
        return this.isServer() ? "s:" : "c:";
    }

    protected InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public synchronized long update() {
        this.flush();
        try {
            INetworkPacket iNetworkPacket;
            while ((iNetworkPacket = this.readNetworkPacket()) != null) {
                this.processPacket(iNetworkPacket);
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException during AbstractConnection#update()");
            this.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.reportReceiveException(exception);
            this.close();
        }
        return 50L;
    }

    public synchronized void flush() {
        this.doFlush();
    }

    protected synchronized void doFlush() {
        SendPacket sendPacket = null;
        try {
            while ((sendPacket = this.sendQueue.getPacket()) != null) {
                this.processPacket(sendPacket);
            }
        }
        catch (Exception exception) {
            this.reportSendException(exception, sendPacket);
            this.close();
        }
    }

    protected void processPacket(INetworkPacket iNetworkPacket) throws Exception {
        PacketMarshaller packetMarshaller = marshallerFactory.getMarshaller(iNetworkPacket.getMarshallingType());
        Assert.assertTrue(packetMarshaller != null, "Unknown marshalling type");
        Packet packet = null;
        byte[] byArray = iNetworkPacket.getData();
        this.bytesReceived += (long)byArray.length;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = iNetworkPacket.isCompressed() ? new GZIPInputStream(byteArrayInputStream) : byteArrayInputStream;
        if (packetMarshaller != null && (packet = packetMarshaller.unmarshall(inputStream)) != null) {
            this.debugLastFewCommandsReceived.push(packet.getCommand());
            this.processConnectionEvent(new PacketReceivedEvent((Object)this, packet));
        }
    }

    protected void processPacket(SendPacket sendPacket) throws Exception {
        this.sendNow(sendPacket);
    }

    protected abstract INetworkPacket readNetworkPacket() throws Exception;

    protected abstract void sendNetworkPacket(byte[] var1, boolean var2) throws Exception;

    protected void processConnectionEvent(ConnectionEvent connectionEvent) {
        Enumeration<ConnectionListener> enumeration = this.connectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionListener connectionListener = enumeration.nextElement();
            switch (connectionEvent.getType()) {
                case 0: {
                    connectionListener.connected((ConnectedEvent)connectionEvent);
                    break;
                }
                case 1: {
                    connectionListener.disconnected((DisconnectedEvent)connectionEvent);
                    break;
                }
                case 2: {
                    connectionListener.packetReceived((PacketReceivedEvent)connectionEvent);
                }
            }
        }
    }

    protected static interface INetworkPacket {
        public int getMarshallingType();

        public byte[] getData();

        public boolean isCompressed();
    }

    private class SendPacket
    implements INetworkPacket {
        byte[] data;
        boolean zipped = false;
        int command;

        public SendPacket(Packet packet) {
            this.command = packet.getCommand();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                OutputStream outputStream;
                if (AbstractConnection.this.zipData && packet.getData() != null) {
                    outputStream = new GZIPOutputStream(byteArrayOutputStream);
                    this.zipped = true;
                } else {
                    outputStream = byteArrayOutputStream;
                }
                AbstractConnection.this.marshaller.marshall(packet, outputStream);
                outputStream.close();
                this.data = byteArrayOutputStream.toByteArray();
                AbstractConnection.this.bytesSent += this.data.length;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getMarshallingType() {
            return AbstractConnection.this.marshallingType;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean isCompressed() {
            return this.zipped;
        }

        public int getCommand() {
            return this.command;
        }
    }

    private static class SendQueue {
        private Vector<SendPacket> queue = new Vector();
        private boolean finished = false;

        private SendQueue() {
        }

        public synchronized void addPacket(SendPacket sendPacket) {
            this.queue.addElement(sendPacket);
            this.notifyAll();
        }

        public synchronized void finish() {
            this.queue.removeAllElements();
            this.finished = true;
            this.notifyAll();
        }

        public synchronized SendPacket getPacket() {
            SendPacket sendPacket = null;
            if (!this.hasPending()) {
                return null;
            }
            if (!this.finished) {
                sendPacket = this.queue.elementAt(0);
                this.queue.removeElementAt(0);
            }
            return sendPacket;
        }

        public synchronized boolean hasPending() {
            return this.queue.size() > 0;
        }

        public void reportContents() {
            System.err.print("Contents of Send Queue: ");
            for (SendPacket sendPacket : this.queue) {
                System.err.print(sendPacket.command);
            }
            System.err.println();
        }
    }
}

