/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import megamek.client.ui.Messages;
import megamek.client.ui.swing.ClientGUI;
import megamek.common.PlanetaryConditions;

public class PlanetaryConditionsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4426594323169113468L;
    private ClientGUI client;
    private PlanetaryConditions conditions;
    private JLabel labLight = new JLabel(Messages.getString("PlanetaryConditionsDialog.labLight"), 4);
    private JComboBox choLight = new JComboBox();
    private JLabel labWeather = new JLabel(Messages.getString("PlanetaryConditionsDialog.labWeather"), 4);
    private JComboBox choWeather = new JComboBox();
    private JLabel labWind = new JLabel(Messages.getString("PlanetaryConditionsDialog.labWind"), 4);
    private JComboBox choWind = new JComboBox();
    private JLabel labAtmosphere = new JLabel(Messages.getString("PlanetaryConditionsDialog.labAtmosphere"), 4);
    private JComboBox choFog = new JComboBox();
    private JLabel labFog = new JLabel(Messages.getString("PlanetaryConditionsDialog.labFog"), 4);
    private JComboBox choAtmosphere = new JComboBox();
    private JCheckBox cBlowingSands = new JCheckBox(Messages.getString("PlanetaryConditionsDialog.BlowingSands"));
    private JCheckBox cShiftWindDir = new JCheckBox(Messages.getString("PlanetaryConditionsDialog.shiftWindDir"));
    private JCheckBox cShiftWindStr = new JCheckBox(Messages.getString("PlanetaryConditionsDialog.shiftWindStr"));
    private JTextField fldTemp = new JTextField(4);
    private JLabel labTemp = new JLabel(Messages.getString("PlanetaryConditionsDialog.labTemp"), 4);
    private JTextField fldGrav = new JTextField(4);
    private JLabel labGrav = new JLabel(Messages.getString("PlanetaryConditionsDialog.labGrav"), 4);
    private JCheckBox cEMI = new JCheckBox(Messages.getString("PlanetaryConditionsDialog.EMI"));
    private JCheckBox cTerrainAffected = new JCheckBox(Messages.getString("PlanetaryConditionsDialog.TerrainAffected"));
    private JPanel panButtons = new JPanel();
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private JPanel panOptions = new JPanel();

    private void init(JFrame jFrame, PlanetaryConditions planetaryConditions) {
        this.conditions = (PlanetaryConditions)planetaryConditions.clone();
        this.setupConditions();
        this.setupButtons();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.panOptions, gridBagConstraints);
        this.add(this.panOptions);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlanetaryConditionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setSize(this.getSize().width, Math.max(this.getSize().height, 400));
        this.setResizable(true);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - this.getSize().width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - this.getSize().height / 2);
    }

    public PlanetaryConditionsDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("PlanetaryConditionsDialog.title"), true);
        this.client = clientGUI;
        this.init(clientGUI.frame, clientGUI.getClient().game.getPlanetaryConditions());
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    private void setupConditions() {
        this.refreshConditions();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labTemp, gridBagConstraints);
        this.panOptions.add(this.labTemp);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldTemp, gridBagConstraints);
        this.panOptions.add(this.fldTemp);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labLight, gridBagConstraints);
        this.panOptions.add(this.labLight);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choLight, gridBagConstraints);
        this.panOptions.add(this.choLight);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labWeather, gridBagConstraints);
        this.panOptions.add(this.labWeather);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choWeather, gridBagConstraints);
        this.panOptions.add(this.choWeather);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labWind, gridBagConstraints);
        this.panOptions.add(this.labWind);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choWind, gridBagConstraints);
        this.panOptions.add(this.choWind);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labAtmosphere, gridBagConstraints);
        this.panOptions.add(this.labAtmosphere);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choAtmosphere, gridBagConstraints);
        this.panOptions.add(this.choAtmosphere);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labFog, gridBagConstraints);
        this.panOptions.add(this.labFog);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choFog, gridBagConstraints);
        this.panOptions.add(this.choFog);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cBlowingSands, gridBagConstraints);
        this.panOptions.add(this.cBlowingSands);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cShiftWindDir, gridBagConstraints);
        this.panOptions.add(this.cShiftWindDir);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cShiftWindStr, gridBagConstraints);
        this.panOptions.add(this.cShiftWindStr);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labGrav, gridBagConstraints);
        this.panOptions.add(this.labGrav);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldGrav, gridBagConstraints);
        this.panOptions.add(this.fldGrav);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cEMI, gridBagConstraints);
        this.panOptions.add(this.cEMI);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cTerrainAffected, gridBagConstraints);
        this.panOptions.add(this.cTerrainAffected);
    }

    public void update(PlanetaryConditions planetaryConditions) {
        this.conditions = (PlanetaryConditions)planetaryConditions.clone();
        this.refreshConditions();
    }

    private void refreshConditions() {
        int n;
        this.choLight.removeAllItems();
        for (n = 0; n < PlanetaryConditions.L_SIZE; ++n) {
            this.choLight.addItem(PlanetaryConditions.getLightDisplayableName(n));
        }
        this.choLight.setSelectedIndex(this.conditions.getLight());
        this.choWeather.removeAllItems();
        for (n = 0; n < PlanetaryConditions.WE_SIZE; ++n) {
            this.choWeather.addItem(PlanetaryConditions.getWeatherDisplayableName(n));
        }
        this.choWeather.setSelectedIndex(this.conditions.getWeather());
        this.choWind.removeAllItems();
        for (n = 0; n < PlanetaryConditions.WI_SIZE; ++n) {
            this.choWind.addItem(PlanetaryConditions.getWindDisplayableName(n));
        }
        this.choWind.setSelectedIndex(this.conditions.getWindStrength());
        this.choAtmosphere.removeAllItems();
        for (n = 0; n < PlanetaryConditions.ATMO_SIZE; ++n) {
            this.choAtmosphere.addItem(PlanetaryConditions.getAtmosphereDisplayableName(n));
        }
        this.choAtmosphere.setSelectedIndex(this.conditions.getAtmosphere());
        this.choFog.removeAllItems();
        for (n = 0; n < PlanetaryConditions.FOG_SIZE; ++n) {
            this.choFog.addItem(PlanetaryConditions.getFogDisplayableName(n));
        }
        this.choFog.setSelectedIndex(this.conditions.getFog());
        this.cBlowingSands.setSelected(this.conditions.isSandBlowing());
        this.cShiftWindDir.setSelected(this.conditions.shiftingWindDirection());
        this.cShiftWindStr.setSelected(this.conditions.shiftingWindStrength());
        this.fldTemp.setText(Integer.toString(this.conditions.getTemperature()));
        this.fldGrav.setText(Float.toString(this.conditions.getGravity()));
        this.cEMI.setSelected(this.conditions.hasEMI());
        this.cTerrainAffected.setSelected(this.conditions.isTerrainAffected());
    }

    public void send() {
        this.conditions.setLight(this.choLight.getSelectedIndex());
        this.conditions.setWeather(this.choWeather.getSelectedIndex());
        this.conditions.setWindStrength(this.choWind.getSelectedIndex());
        this.conditions.setAtmosphere(this.choAtmosphere.getSelectedIndex());
        this.conditions.setFog(this.choFog.getSelectedIndex());
        this.conditions.setBlowingSand(this.cBlowingSands.isSelected());
        this.conditions.setShiftingWindDirection(this.cShiftWindDir.isSelected());
        this.conditions.setShiftingWindStrength(this.cShiftWindStr.isSelected());
        this.conditions.setTemperature(Integer.parseInt(this.fldTemp.getText()));
        this.conditions.setGravity(Float.parseFloat(this.fldGrav.getText()));
        this.conditions.setEMI(this.cEMI.isSelected());
        this.conditions.setTerrainAffected(this.cTerrainAffected.isSelected());
        this.client.getClient().sendPlanetaryConditions(this.conditions);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOkay) {
            int n = 25;
            float f = 1.0f;
            try {
                n = Integer.parseInt(this.fldTemp.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.EnterValidTemperature"), Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), 0);
                return;
            }
            try {
                f = Float.parseFloat(this.fldGrav.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.EnterValidGravity"), Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), 0);
                return;
            }
            if (n > 200 || n < -200) {
                JOptionPane.showMessageDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.EnterValidTemperature"), Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), 0);
                return;
            }
            if ((double)f < 0.1 || (double)f > 10.0) {
                JOptionPane.showMessageDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.EnterValidGravity"), Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), 0);
                return;
            }
            int n2 = this.choWind.getSelectedIndex();
            int n3 = this.choAtmosphere.getSelectedIndex();
            if (n3 == 0 && n2 > 0) {
                JOptionPane.showMessageDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.VacuumWind"), Messages.getString("PlanetaryConditionsDialog.Incompatible"), 0);
                return;
            }
            if (n3 == 1 && n2 > 4) {
                JOptionPane.showMessageDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.TraceWind"), Messages.getString("PlanetaryConditionsDialog.Incompatible"), 0);
                return;
            }
            if (n3 == 2 && n2 > 5) {
                JOptionPane.showMessageDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.ThinWind"), Messages.getString("PlanetaryConditionsDialog.Incompatible"), 0);
                return;
            }
            if (this.client != null) {
                this.send();
            }
        } else if (actionEvent.getSource() == this.butCancel) {
            this.refreshConditions();
        }
        this.setVisible(false);
    }
}

