.\" Copyright (c) 1994, 2008, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH rgb 1 2008-06-05 __xorgversion__
.IX "rgb" "" "\f3rgb\fP(1) \(em build colorname database" ""
.IX "color" "build" "color" "building the colorname database \(em \f3rgb\fP(1)" ""
.SH NAME
rgb \- build the color name database
.SH SYNOPSIS
.B rgb
[
.I dbname
]
.SH DESCRIPTION
.B rgb
reads from standard input lines of the form:
.PP
.nf
.I
	red\ \ green\ \ blue\ \ \ \ \ \ name
.fi
.PP
where
.I red
/
.I green
/
.I blue
are decimal values between the range 0 to 255, and
.I name
is a description of the color.
.B rgb
then builds a color name database in
.B __RGB_DB_TYPE__
format.
The color name database provides a mapping between ASCII color names
and RGB color values.
It is useful for increasing the portability of color programs.
The input source for the database is in
.BR __RGB_DB__.txt .
.B rgb.txt
is compiled into the __RGB_DB_TYPE__ files
.IR "__RGB_DB_FILES__" .
When the server first starts up, it consults the contents of these
files to build an internal representation of their contents.
This internal representation is consulted to map color names to color values.
.PP
.B rgb
uses the default color name database of
.BR __RGB_DB__.txt .
.SH OPTIONS
.IP "\fIdbname" 1i
Color name database.
.SH EXAMPLES
example% \fBrgb rgb < __RGB_DB__.txt\fP
.PP
example% \fBcat __RGB_DB__.txt\fP
.SH FILES
.PD 0
.TP
.B __RGB_DB__.txt
color name database source.
Maps color names to RGB color values.
.TP
.B __RGB_DB_DIR__/__RGB_DB_FILES__
__RGB_DB_TYPE__ files containing color name to RGB mapping.
.PD
.SH SEE ALSO
.BR cat (1),
.BR __RGB_DB_TYPE__ (3)
