// Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
// or more contributor license agreements. Licensed under the Elastic License;
// you may not use this file except in compliance with the Elastic License.

// go run gen.go
// MACHINE GENERATED BY THE ABOVE COMMAND; DO NOT EDIT.

package fields

var IpfixFields = FieldDict{
	// Field 0: Reserved
	Key{EnterpriseID: 0, FieldID: 1}:  {Name: "octetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 2}:  {Name: "packetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 3}:  {Name: "deltaFlowCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 4}:  {Name: "protocolIdentifier", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 5}:  {Name: "ipClassOfService", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 6}:  {Name: "tcpControlBits", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 7}:  {Name: "sourceTransportPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 8}:  {Name: "sourceIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 9}:  {Name: "sourceIPv4PrefixLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 10}: {Name: "ingressInterface", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 11}: {Name: "destinationTransportPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 12}: {Name: "destinationIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 13}: {Name: "destinationIPv4PrefixLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 14}: {Name: "egressInterface", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 15}: {Name: "ipNextHopIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 16}: {Name: "bgpSourceAsNumber", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 17}: {Name: "bgpDestinationAsNumber", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 18}: {Name: "bgpNextHopIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 19}: {Name: "postMCastPacketDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 20}: {Name: "postMCastOctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 21}: {Name: "flowEndSysUpTime", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 22}: {Name: "flowStartSysUpTime", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 23}: {Name: "postOctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 24}: {Name: "postPacketDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 25}: {Name: "minimumIpTotalLength", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 26}: {Name: "maximumIpTotalLength", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 27}: {Name: "sourceIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 28}: {Name: "destinationIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 29}: {Name: "sourceIPv6PrefixLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 30}: {Name: "destinationIPv6PrefixLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 31}: {Name: "flowLabelIPv6", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 32}: {Name: "icmpTypeCodeIPv4", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 33}: {Name: "igmpType", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 34}: {Name: "samplingInterval", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 35}: {Name: "samplingAlgorithm", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 36}: {Name: "flowActiveTimeout", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 37}: {Name: "flowIdleTimeout", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 38}: {Name: "engineType", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 39}: {Name: "engineId", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 40}: {Name: "exportedOctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 41}: {Name: "exportedMessageTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 42}: {Name: "exportedFlowRecordTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 43}: {Name: "ipv4RouterSc", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 44}: {Name: "sourceIPv4Prefix", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 45}: {Name: "destinationIPv4Prefix", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 46}: {Name: "mplsTopLabelType", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 47}: {Name: "mplsTopLabelIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 48}: {Name: "samplerId", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 49}: {Name: "samplerMode", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 50}: {Name: "samplerRandomInterval", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 51}: {Name: "classId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 52}: {Name: "minimumTTL", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 53}: {Name: "maximumTTL", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 54}: {Name: "fragmentIdentification", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 55}: {Name: "postIpClassOfService", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 56}: {Name: "sourceMacAddress", Decoder: MacAddress},
	Key{EnterpriseID: 0, FieldID: 57}: {Name: "postDestinationMacAddress", Decoder: MacAddress},
	Key{EnterpriseID: 0, FieldID: 58}: {Name: "vlanId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 59}: {Name: "postVlanId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 60}: {Name: "ipVersion", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 61}: {Name: "flowDirection", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 62}: {Name: "ipNextHopIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 63}: {Name: "bgpNextHopIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 64}: {Name: "ipv6ExtensionHeaders", Decoder: Unsigned32},
	// Field 65-69: Assigned for NetFlow v9 compatibility
	Key{EnterpriseID: 0, FieldID: 70}: {Name: "mplsTopLabelStackSection", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 71}: {Name: "mplsLabelStackSection2", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 72}: {Name: "mplsLabelStackSection3", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 73}: {Name: "mplsLabelStackSection4", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 74}: {Name: "mplsLabelStackSection5", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 75}: {Name: "mplsLabelStackSection6", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 76}: {Name: "mplsLabelStackSection7", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 77}: {Name: "mplsLabelStackSection8", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 78}: {Name: "mplsLabelStackSection9", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 79}: {Name: "mplsLabelStackSection10", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 80}: {Name: "destinationMacAddress", Decoder: MacAddress},
	Key{EnterpriseID: 0, FieldID: 81}: {Name: "postSourceMacAddress", Decoder: MacAddress},
	Key{EnterpriseID: 0, FieldID: 82}: {Name: "interfaceName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 83}: {Name: "interfaceDescription", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 84}: {Name: "samplerName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 85}: {Name: "octetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 86}: {Name: "packetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 87}: {Name: "flagsAndSamplerId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 88}: {Name: "fragmentOffset", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 89}: {Name: "forwardingStatus", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 90}: {Name: "mplsVpnRouteDistinguisher", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 91}: {Name: "mplsTopLabelPrefixLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 92}: {Name: "srcTrafficIndex", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 93}: {Name: "dstTrafficIndex", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 94}: {Name: "applicationDescription", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 95}: {Name: "applicationId", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 96}: {Name: "applicationName", Decoder: String},
	// Field 97: Assigned for NetFlow v9 compatibility
	Key{EnterpriseID: 0, FieldID: 98}:  {Name: "postIpDiffServCodePoint", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 99}:  {Name: "multicastReplicationFactor", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 100}: {Name: "className", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 101}: {Name: "classificationEngineId", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 102}: {Name: "layer2packetSectionOffset", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 103}: {Name: "layer2packetSectionSize", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 104}: {Name: "layer2packetSectionData", Decoder: OctetArray},
	// Field 105-127: Assigned for NetFlow v9 compatibility
	Key{EnterpriseID: 0, FieldID: 128}: {Name: "bgpNextAdjacentAsNumber", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 129}: {Name: "bgpPrevAdjacentAsNumber", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 130}: {Name: "exporterIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 131}: {Name: "exporterIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 132}: {Name: "droppedOctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 133}: {Name: "droppedPacketDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 134}: {Name: "droppedOctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 135}: {Name: "droppedPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 136}: {Name: "flowEndReason", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 137}: {Name: "commonPropertiesId", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 138}: {Name: "observationPointId", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 139}: {Name: "icmpTypeCodeIPv6", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 140}: {Name: "mplsTopLabelIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 141}: {Name: "lineCardId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 142}: {Name: "portId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 143}: {Name: "meteringProcessId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 144}: {Name: "exportingProcessId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 145}: {Name: "templateId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 146}: {Name: "wlanChannelId", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 147}: {Name: "wlanSSID", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 148}: {Name: "flowId", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 149}: {Name: "observationDomainId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 150}: {Name: "flowStartSeconds", Decoder: DateTimeSeconds},
	Key{EnterpriseID: 0, FieldID: 151}: {Name: "flowEndSeconds", Decoder: DateTimeSeconds},
	Key{EnterpriseID: 0, FieldID: 152}: {Name: "flowStartMilliseconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 153}: {Name: "flowEndMilliseconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 154}: {Name: "flowStartMicroseconds", Decoder: DateTimeMicroseconds},
	Key{EnterpriseID: 0, FieldID: 155}: {Name: "flowEndMicroseconds", Decoder: DateTimeMicroseconds},
	Key{EnterpriseID: 0, FieldID: 156}: {Name: "flowStartNanoseconds", Decoder: DateTimeNanoseconds},
	Key{EnterpriseID: 0, FieldID: 157}: {Name: "flowEndNanoseconds", Decoder: DateTimeNanoseconds},
	Key{EnterpriseID: 0, FieldID: 158}: {Name: "flowStartDeltaMicroseconds", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 159}: {Name: "flowEndDeltaMicroseconds", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 160}: {Name: "systemInitTimeMilliseconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 161}: {Name: "flowDurationMilliseconds", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 162}: {Name: "flowDurationMicroseconds", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 163}: {Name: "observedFlowTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 164}: {Name: "ignoredPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 165}: {Name: "ignoredOctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 166}: {Name: "notSentFlowTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 167}: {Name: "notSentPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 168}: {Name: "notSentOctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 169}: {Name: "destinationIPv6Prefix", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 170}: {Name: "sourceIPv6Prefix", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 171}: {Name: "postOctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 172}: {Name: "postPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 173}: {Name: "flowKeyIndicator", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 174}: {Name: "postMCastPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 175}: {Name: "postMCastOctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 176}: {Name: "icmpTypeIPv4", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 177}: {Name: "icmpCodeIPv4", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 178}: {Name: "icmpTypeIPv6", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 179}: {Name: "icmpCodeIPv6", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 180}: {Name: "udpSourcePort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 181}: {Name: "udpDestinationPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 182}: {Name: "tcpSourcePort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 183}: {Name: "tcpDestinationPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 184}: {Name: "tcpSequenceNumber", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 185}: {Name: "tcpAcknowledgementNumber", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 186}: {Name: "tcpWindowSize", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 187}: {Name: "tcpUrgentPointer", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 188}: {Name: "tcpHeaderLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 189}: {Name: "ipHeaderLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 190}: {Name: "totalLengthIPv4", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 191}: {Name: "payloadLengthIPv6", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 192}: {Name: "ipTTL", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 193}: {Name: "nextHeaderIPv6", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 194}: {Name: "mplsPayloadLength", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 195}: {Name: "ipDiffServCodePoint", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 196}: {Name: "ipPrecedence", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 197}: {Name: "fragmentFlags", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 198}: {Name: "octetDeltaSumOfSquares", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 199}: {Name: "octetTotalSumOfSquares", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 200}: {Name: "mplsTopLabelTTL", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 201}: {Name: "mplsLabelStackLength", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 202}: {Name: "mplsLabelStackDepth", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 203}: {Name: "mplsTopLabelExp", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 204}: {Name: "ipPayloadLength", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 205}: {Name: "udpMessageLength", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 206}: {Name: "isMulticast", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 207}: {Name: "ipv4IHL", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 208}: {Name: "ipv4Options", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 209}: {Name: "tcpOptions", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 210}: {Name: "paddingOctets", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 211}: {Name: "collectorIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 212}: {Name: "collectorIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 213}: {Name: "exportInterface", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 214}: {Name: "exportProtocolVersion", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 215}: {Name: "exportTransportProtocol", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 216}: {Name: "collectorTransportPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 217}: {Name: "exporterTransportPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 218}: {Name: "tcpSynTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 219}: {Name: "tcpFinTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 220}: {Name: "tcpRstTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 221}: {Name: "tcpPshTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 222}: {Name: "tcpAckTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 223}: {Name: "tcpUrgTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 224}: {Name: "ipTotalLength", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 225}: {Name: "postNATSourceIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 226}: {Name: "postNATDestinationIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 227}: {Name: "postNAPTSourceTransportPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 228}: {Name: "postNAPTDestinationTransportPort", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 229}: {Name: "natOriginatingAddressRealm", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 230}: {Name: "natEvent", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 231}: {Name: "initiatorOctets", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 232}: {Name: "responderOctets", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 233}: {Name: "firewallEvent", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 234}: {Name: "ingressVRFID", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 235}: {Name: "egressVRFID", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 236}: {Name: "VRFname", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 237}: {Name: "postMplsTopLabelExp", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 238}: {Name: "tcpWindowScale", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 239}: {Name: "biflowDirection", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 240}: {Name: "ethernetHeaderLength", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 241}: {Name: "ethernetPayloadLength", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 242}: {Name: "ethernetTotalLength", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 243}: {Name: "dot1qVlanId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 244}: {Name: "dot1qPriority", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 245}: {Name: "dot1qCustomerVlanId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 246}: {Name: "dot1qCustomerPriority", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 247}: {Name: "metroEvcId", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 248}: {Name: "metroEvcType", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 249}: {Name: "pseudoWireId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 250}: {Name: "pseudoWireType", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 251}: {Name: "pseudoWireControlWord", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 252}: {Name: "ingressPhysicalInterface", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 253}: {Name: "egressPhysicalInterface", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 254}: {Name: "postDot1qVlanId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 255}: {Name: "postDot1qCustomerVlanId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 256}: {Name: "ethernetType", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 257}: {Name: "postIpPrecedence", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 258}: {Name: "collectionTimeMilliseconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 259}: {Name: "exportSctpStreamId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 260}: {Name: "maxExportSeconds", Decoder: DateTimeSeconds},
	Key{EnterpriseID: 0, FieldID: 261}: {Name: "maxFlowEndSeconds", Decoder: DateTimeSeconds},
	Key{EnterpriseID: 0, FieldID: 262}: {Name: "messageMD5Checksum", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 263}: {Name: "messageScope", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 264}: {Name: "minExportSeconds", Decoder: DateTimeSeconds},
	Key{EnterpriseID: 0, FieldID: 265}: {Name: "minFlowStartSeconds", Decoder: DateTimeSeconds},
	Key{EnterpriseID: 0, FieldID: 266}: {Name: "opaqueOctets", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 267}: {Name: "sessionScope", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 268}: {Name: "maxFlowEndMicroseconds", Decoder: DateTimeMicroseconds},
	Key{EnterpriseID: 0, FieldID: 269}: {Name: "maxFlowEndMilliseconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 270}: {Name: "maxFlowEndNanoseconds", Decoder: DateTimeNanoseconds},
	Key{EnterpriseID: 0, FieldID: 271}: {Name: "minFlowStartMicroseconds", Decoder: DateTimeMicroseconds},
	Key{EnterpriseID: 0, FieldID: 272}: {Name: "minFlowStartMilliseconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 273}: {Name: "minFlowStartNanoseconds", Decoder: DateTimeNanoseconds},
	Key{EnterpriseID: 0, FieldID: 274}: {Name: "collectorCertificate", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 275}: {Name: "exporterCertificate", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 276}: {Name: "dataRecordsReliability", Decoder: Boolean},
	Key{EnterpriseID: 0, FieldID: 277}: {Name: "observationPointType", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 278}: {Name: "newConnectionDeltaCount", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 279}: {Name: "connectionSumDurationSeconds", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 280}: {Name: "connectionTransactionId", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 281}: {Name: "postNATSourceIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 282}: {Name: "postNATDestinationIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 283}: {Name: "natPoolId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 284}: {Name: "natPoolName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 285}: {Name: "anonymizationFlags", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 286}: {Name: "anonymizationTechnique", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 287}: {Name: "informationElementIndex", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 288}: {Name: "p2pTechnology", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 289}: {Name: "tunnelTechnology", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 290}: {Name: "encryptedTechnology", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 291}: {Name: "basicList", Decoder: BasicList},
	Key{EnterpriseID: 0, FieldID: 292}: {Name: "subTemplateList", Decoder: SubTemplateList},
	Key{EnterpriseID: 0, FieldID: 293}: {Name: "subTemplateMultiList", Decoder: SubTemplateMultiList},
	Key{EnterpriseID: 0, FieldID: 294}: {Name: "bgpValidityState", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 295}: {Name: "IPSecSPI", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 296}: {Name: "greKey", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 297}: {Name: "natType", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 298}: {Name: "initiatorPackets", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 299}: {Name: "responderPackets", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 300}: {Name: "observationDomainName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 301}: {Name: "selectionSequenceId", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 302}: {Name: "selectorId", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 303}: {Name: "informationElementId", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 304}: {Name: "selectorAlgorithm", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 305}: {Name: "samplingPacketInterval", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 306}: {Name: "samplingPacketSpace", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 307}: {Name: "samplingTimeInterval", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 308}: {Name: "samplingTimeSpace", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 309}: {Name: "samplingSize", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 310}: {Name: "samplingPopulation", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 311}: {Name: "samplingProbability", Decoder: Float64},
	Key{EnterpriseID: 0, FieldID: 312}: {Name: "dataLinkFrameSize", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 313}: {Name: "ipHeaderPacketSection", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 314}: {Name: "ipPayloadPacketSection", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 315}: {Name: "dataLinkFrameSection", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 316}: {Name: "mplsLabelStackSection", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 317}: {Name: "mplsPayloadPacketSection", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 318}: {Name: "selectorIdTotalPktsObserved", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 319}: {Name: "selectorIdTotalPktsSelected", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 320}: {Name: "absoluteError", Decoder: Float64},
	Key{EnterpriseID: 0, FieldID: 321}: {Name: "relativeError", Decoder: Float64},
	Key{EnterpriseID: 0, FieldID: 322}: {Name: "observationTimeSeconds", Decoder: DateTimeSeconds},
	Key{EnterpriseID: 0, FieldID: 323}: {Name: "observationTimeMilliseconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 324}: {Name: "observationTimeMicroseconds", Decoder: DateTimeMicroseconds},
	Key{EnterpriseID: 0, FieldID: 325}: {Name: "observationTimeNanoseconds", Decoder: DateTimeNanoseconds},
	Key{EnterpriseID: 0, FieldID: 326}: {Name: "digestHashValue", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 327}: {Name: "hashIPPayloadOffset", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 328}: {Name: "hashIPPayloadSize", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 329}: {Name: "hashOutputRangeMin", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 330}: {Name: "hashOutputRangeMax", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 331}: {Name: "hashSelectedRangeMin", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 332}: {Name: "hashSelectedRangeMax", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 333}: {Name: "hashDigestOutput", Decoder: Boolean},
	Key{EnterpriseID: 0, FieldID: 334}: {Name: "hashInitialiserValue", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 335}: {Name: "selectorName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 336}: {Name: "upperCILimit", Decoder: Float64},
	Key{EnterpriseID: 0, FieldID: 337}: {Name: "lowerCILimit", Decoder: Float64},
	Key{EnterpriseID: 0, FieldID: 338}: {Name: "confidenceLevel", Decoder: Float64},
	Key{EnterpriseID: 0, FieldID: 339}: {Name: "informationElementDataType", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 340}: {Name: "informationElementDescription", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 341}: {Name: "informationElementName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 342}: {Name: "informationElementRangeBegin", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 343}: {Name: "informationElementRangeEnd", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 344}: {Name: "informationElementSemantics", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 345}: {Name: "informationElementUnits", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 346}: {Name: "privateEnterpriseNumber", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 347}: {Name: "virtualStationInterfaceId", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 348}: {Name: "virtualStationInterfaceName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 349}: {Name: "virtualStationUUID", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 350}: {Name: "virtualStationName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 351}: {Name: "layer2SegmentId", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 352}: {Name: "layer2OctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 353}: {Name: "layer2OctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 354}: {Name: "ingressUnicastPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 355}: {Name: "ingressMulticastPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 356}: {Name: "ingressBroadcastPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 357}: {Name: "egressUnicastPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 358}: {Name: "egressBroadcastPacketTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 359}: {Name: "monitoringIntervalStartMilliSeconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 360}: {Name: "monitoringIntervalEndMilliSeconds", Decoder: DateTimeMilliseconds},
	Key{EnterpriseID: 0, FieldID: 361}: {Name: "portRangeStart", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 362}: {Name: "portRangeEnd", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 363}: {Name: "portRangeStepSize", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 364}: {Name: "portRangeNumPorts", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 365}: {Name: "staMacAddress", Decoder: MacAddress},
	Key{EnterpriseID: 0, FieldID: 366}: {Name: "staIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 367}: {Name: "wtpMacAddress", Decoder: MacAddress},
	Key{EnterpriseID: 0, FieldID: 368}: {Name: "ingressInterfaceType", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 369}: {Name: "egressInterfaceType", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 370}: {Name: "rtpSequenceNumber", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 371}: {Name: "userName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 372}: {Name: "applicationCategoryName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 373}: {Name: "applicationSubCategoryName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 374}: {Name: "applicationGroupName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 375}: {Name: "originalFlowsPresent", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 376}: {Name: "originalFlowsInitiated", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 377}: {Name: "originalFlowsCompleted", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 378}: {Name: "distinctCountOfSourceIPAddress", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 379}: {Name: "distinctCountOfDestinationIPAddress", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 380}: {Name: "distinctCountOfSourceIPv4Address", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 381}: {Name: "distinctCountOfDestinationIPv4Address", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 382}: {Name: "distinctCountOfSourceIPv6Address", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 383}: {Name: "distinctCountOfDestinationIPv6Address", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 384}: {Name: "valueDistributionMethod", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 385}: {Name: "rfc3550JitterMilliseconds", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 386}: {Name: "rfc3550JitterMicroseconds", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 387}: {Name: "rfc3550JitterNanoseconds", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 388}: {Name: "dot1qDEI", Decoder: Boolean},
	Key{EnterpriseID: 0, FieldID: 389}: {Name: "dot1qCustomerDEI", Decoder: Boolean},
	Key{EnterpriseID: 0, FieldID: 390}: {Name: "flowSelectorAlgorithm", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 391}: {Name: "flowSelectedOctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 392}: {Name: "flowSelectedPacketDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 393}: {Name: "flowSelectedFlowDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 394}: {Name: "selectorIDTotalFlowsObserved", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 395}: {Name: "selectorIDTotalFlowsSelected", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 396}: {Name: "samplingFlowInterval", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 397}: {Name: "samplingFlowSpacing", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 398}: {Name: "flowSamplingTimeInterval", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 399}: {Name: "flowSamplingTimeSpacing", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 400}: {Name: "hashFlowDomain", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 401}: {Name: "transportOctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 402}: {Name: "transportPacketDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 403}: {Name: "originalExporterIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 404}: {Name: "originalExporterIPv6Address", Decoder: Ipv6Address},
	Key{EnterpriseID: 0, FieldID: 405}: {Name: "originalObservationDomainId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 406}: {Name: "intermediateProcessId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 407}: {Name: "ignoredDataRecordTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 408}: {Name: "dataLinkFrameType", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 409}: {Name: "sectionOffset", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 410}: {Name: "sectionExportedOctets", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 411}: {Name: "dot1qServiceInstanceTag", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 412}: {Name: "dot1qServiceInstanceId", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 413}: {Name: "dot1qServiceInstancePriority", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 414}: {Name: "dot1qCustomerSourceMacAddress", Decoder: MacAddress},
	Key{EnterpriseID: 0, FieldID: 415}: {Name: "dot1qCustomerDestinationMacAddress", Decoder: MacAddress},
	// Field 416:
	Key{EnterpriseID: 0, FieldID: 417}: {Name: "postLayer2OctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 418}: {Name: "postMCastLayer2OctetDeltaCount", Decoder: Unsigned64},
	// Field 419:
	Key{EnterpriseID: 0, FieldID: 420}: {Name: "postLayer2OctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 421}: {Name: "postMCastLayer2OctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 422}: {Name: "minimumLayer2TotalLength", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 423}: {Name: "maximumLayer2TotalLength", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 424}: {Name: "droppedLayer2OctetDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 425}: {Name: "droppedLayer2OctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 426}: {Name: "ignoredLayer2OctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 427}: {Name: "notSentLayer2OctetTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 428}: {Name: "layer2OctetDeltaSumOfSquares", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 429}: {Name: "layer2OctetTotalSumOfSquares", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 430}: {Name: "layer2FrameDeltaCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 431}: {Name: "layer2FrameTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 432}: {Name: "pseudoWireDestinationIPv4Address", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 433}: {Name: "ignoredLayer2FrameTotalCount", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 434}: {Name: "mibObjectValueInteger", Decoder: Signed32},
	Key{EnterpriseID: 0, FieldID: 435}: {Name: "mibObjectValueOctetString", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 436}: {Name: "mibObjectValueOID", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 437}: {Name: "mibObjectValueBits", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 438}: {Name: "mibObjectValueIPAddress", Decoder: Ipv4Address},
	Key{EnterpriseID: 0, FieldID: 439}: {Name: "mibObjectValueCounter", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 440}: {Name: "mibObjectValueGauge", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 441}: {Name: "mibObjectValueTimeTicks", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 442}: {Name: "mibObjectValueUnsigned", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 443}: {Name: "mibObjectValueTable", Decoder: SubTemplateList},
	Key{EnterpriseID: 0, FieldID: 444}: {Name: "mibObjectValueRow", Decoder: SubTemplateList},
	Key{EnterpriseID: 0, FieldID: 445}: {Name: "mibObjectIdentifier", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 446}: {Name: "mibSubIdentifier", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 447}: {Name: "mibIndexIndicator", Decoder: Unsigned64},
	Key{EnterpriseID: 0, FieldID: 448}: {Name: "mibCaptureTimeSemantics", Decoder: Unsigned8},
	Key{EnterpriseID: 0, FieldID: 449}: {Name: "mibContextEngineID", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 450}: {Name: "mibContextName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 451}: {Name: "mibObjectName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 452}: {Name: "mibObjectDescription", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 453}: {Name: "mibObjectSyntax", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 454}: {Name: "mibModuleName", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 455}: {Name: "mobileIMSI", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 456}: {Name: "mobileMSISDN", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 457}: {Name: "httpStatusCode", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 458}: {Name: "sourceTransportPortsLimit", Decoder: Unsigned16},
	Key{EnterpriseID: 0, FieldID: 459}: {Name: "httpRequestMethod", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 460}: {Name: "httpRequestHost", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 461}: {Name: "httpRequestTarget", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 462}: {Name: "httpMessageVersion", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 463}: {Name: "natInstanceID", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 464}: {Name: "internalAddressRealm", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 465}: {Name: "externalAddressRealm", Decoder: OctetArray},
	Key{EnterpriseID: 0, FieldID: 466}: {Name: "natQuotaExceededEvent", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 467}: {Name: "natThresholdEvent", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 468}: {Name: "httpUserAgent", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 469}: {Name: "httpContentType", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 470}: {Name: "httpReasonPhrase", Decoder: String},
	Key{EnterpriseID: 0, FieldID: 471}: {Name: "maxSessionEntries", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 472}: {Name: "maxBIBEntries", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 473}: {Name: "maxEntriesPerUser", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 474}: {Name: "maxSubscribers", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 475}: {Name: "maxFragmentsPendingReassembly", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 476}: {Name: "addressPoolHighThreshold", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 477}: {Name: "addressPoolLowThreshold", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 478}: {Name: "addressPortMappingHighThreshold", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 479}: {Name: "addressPortMappingLowThreshold", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 480}: {Name: "addressPortMappingPerUserHighThreshold", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 481}: {Name: "globalAddressMappingHighThreshold", Decoder: Unsigned32},
	Key{EnterpriseID: 0, FieldID: 482}: {Name: "vpnIdentifier", Decoder: OctetArray},
	// Field 483-32767: Unassigned
}

func init() {
	if err := RegisterGlobalFields(IpfixFields); err != nil {
		panic(err)
	}
}
