/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class LongestCommonSubsequenceTest {
    private static LongestCommonSubsequence subject;

    @BeforeAll
    public static void setup() {
        subject = new LongestCommonSubsequence();
    }

    @Test
    public void testGettingLogestCommonSubsequenceNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.logestCommonSubsequence(null, null));
    }

    @Test
    public void testGettingLogestCommonSubsequenceNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.logestCommonSubsequence(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingLogestCommonSubsequenceStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.logestCommonSubsequence((CharSequence)" ", null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceApplyNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.apply(null, null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceApplyNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.apply(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingLongestCommonSubsequenceApplyStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.apply((CharSequence)" ", null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.longestCommonSubsequence(null, null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.longestCommonSubsequence(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingLongestCommonSubsequenceStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> subject.longestCommonSubsequence((CharSequence)" ", null));
    }

    @Test
    @Deprecated
    public void testLogestCommonSubsequence() {
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)"right")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"frog", (CharSequence)"fog")).isEqualTo((Object)"fog");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"fly", (CharSequence)"ant")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo((Object)"h");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp")).isEqualTo((Object)"ABC Corp");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc.")).isEqualTo((Object)"D  H Enterprises Inc");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness")).isEqualTo((Object)"My Gym Childrens Fitness");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA")).isEqualTo((Object)"PENNSYLVNIA");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)"right")).isEqualTo((Object)"t");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"leettteft", (CharSequence)"ritttght")).isEqualTo((Object)"tttt");
        Assertions.assertThat((CharSequence)subject.logestCommonSubsequence((CharSequence)"the same string", (CharSequence)"the same string")).isEqualTo((Object)"the same string");
    }

    @Test
    public void testLongestCommonSubsequence() {
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"left", (CharSequence)"")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"", (CharSequence)"right")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"frog", (CharSequence)"fog")).isEqualTo((Object)"fog");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"fly", (CharSequence)"ant")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo((Object)"h");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp")).isEqualTo((Object)"ABC Corp");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc.")).isEqualTo((Object)"D  H Enterprises Inc");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness")).isEqualTo((Object)"My Gym Childrens Fitness");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA")).isEqualTo((Object)"PENNSYLVNIA");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"left", (CharSequence)"right")).isEqualTo((Object)"t");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"leettteft", (CharSequence)"ritttght")).isEqualTo((Object)"tttt");
        Assertions.assertThat((CharSequence)subject.longestCommonSubsequence((CharSequence)"the same string", (CharSequence)"the same string")).isEqualTo((Object)"the same string");
    }

    @Test
    public void testLongestCommonSubsequenceApply() {
        Assertions.assertThat((Integer)subject.apply((CharSequence)"", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"left", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"", (CharSequence)"right")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"frog", (CharSequence)"fog")).isEqualTo(3);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"fly", (CharSequence)"ant")).isEqualTo(0);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo(1);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp")).isEqualTo(8);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc.")).isEqualTo(20);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness")).isEqualTo(24);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA")).isEqualTo(11);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"left", (CharSequence)"right")).isEqualTo(1);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"leettteft", (CharSequence)"ritttght")).isEqualTo(4);
        Assertions.assertThat((Integer)subject.apply((CharSequence)"the same string", (CharSequence)"the same string")).isEqualTo(15);
    }
}

