/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaccardSimilarity;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JaccardSimilarityTest {
    private static JaccardSimilarity classBeingTested;

    @BeforeAll
    public static void setUp() {
        classBeingTested = new JaccardSimilarity();
    }

    @Test
    public void testGettingJaccardSimilarity() {
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)""));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)""));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)"right"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.75, (Double)classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.2222222222222222, (Double)classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.6363636363636364, (Double)classBeingTested.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.7647058823529411, (Double)classBeingTested.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.8888888888888888, (Double)classBeingTested.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.9, (Double)classBeingTested.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.125, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)"right"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.125, (Double)classBeingTested.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test
    public void testGettingJaccardSimilarityNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, null));
    }

    @Test
    public void testGettingJaccardSimilarityNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingJaccardSimilarityStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply((CharSequence)" ", null));
    }
}

