/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.text.lookup.FileStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileStringLookupTest {
    @Test
    public void testBadCharsetName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileStringLookup.INSTANCE.lookup("BAD_CHARSET_NAME:src/test/resources/org/apache/commons/text/document.properties"));
    }

    @Test
    public void testBadDocumentPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileStringLookup.INSTANCE.lookup("BAD_CHARSET_NAME:src/test/resources/DOCUMENT_NOT_FOUND.TXT"));
    }

    @Test
    public void testMissingFilePart() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileStringLookup.INSTANCE.lookup(StandardCharsets.UTF_8.name()));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)FileStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() throws Exception {
        byte[] expectedBytes = Files.readAllBytes(Paths.get("src/test/resources/org/apache/commons/text/document.properties", new String[0]));
        String expectedString = new String(expectedBytes, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expectedString, (Object)FileStringLookup.INSTANCE.lookup("UTF-8:src/test/resources/org/apache/commons/text/document.properties"));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)FileStringLookup.INSTANCE.toString().isEmpty());
    }
}

