/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.framework.AliasMapper;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class EquinoxConfiguration
implements EnvironmentInfo {
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_OS_LINUX = "Linux";
    private static final String INTERNAL_OS_MACOSX = "Mac OS";
    private static final String INTERNAL_OS_AIX = "AIX";
    private static final String INTERNAL_OS_HPUX = "HP-UX";
    private static final String INTERNAL_OS_QNX = "QNX";
    private static final String INTERNAL_OS_OS400 = "OS/400";
    private static final String INTERNAL_OS_OS390 = "OS/390";
    private static final String INTERNAL_OS_ZOS = "z/OS";
    private static final String INTERNAL_ARCH_I386 = "i386";
    private static final String INTERNAL_AMD64 = "amd64";
    public static final String VARIABLE_DELIM_STRING = "$";
    public static final char VARIABLE_DELIM_CHAR = '$';
    private final Map<String, Object> initialConfig;
    private final Properties configuration;
    private final Debug debug;
    private final DebugOptions debugOptions;
    private final HookRegistry hookRegistry;
    private final AliasMapper aliasMapper = new AliasMapper();
    private volatile String[] allArgs;
    private volatile String[] frameworkArgs;
    private volatile String[] appArgs;
    private final boolean inDevelopmentMode;
    private final File devLocation;
    private final Object devMonitor = new Object();
    private String[] devDefaultClasspath;
    private Dictionary<String, String> devProperties = null;
    private long devLastModified = 0L;
    public final boolean contextBootDelegation;
    public final boolean compatibilityBootDelegation;
    public final List<String> LIB_EXTENSIONS;
    public final List<String> ECLIPSE_LIB_VARIANTS;
    public final boolean COPY_NATIVES;
    public final List<String> ECLIPSE_NL_JAR_VARIANTS;
    public final boolean DEFINE_PACKAGE_ATTRIBUTES;
    public final boolean BUNDLE_SET_TCCL;
    public final int BSN_VERSION;
    public static final int BSN_VERSION_SINGLE = 1;
    public static final int BSN_VERSION_MULTIPLE = 2;
    public static final int BSN_VERSION_MANAGED = 3;
    public final boolean throwErrorOnFailedStart;
    public final boolean CLASS_CERTIFICATE;
    public final boolean PARALLEL_CAPABLE;
    public static final String PROP_JVM_OS_ARCH = "os.arch";
    public static final String PROP_JVM_OS_NAME = "os.name";
    public static final String PROP_JVM_OS_VERSION = "os.version";
    public static final String PROP_JVM_SPEC_VERSION = "java.specification.version";
    public static final String PROP_JVM_SPEC_NAME = "java.specification.name";
    public static final String PROP_J2ME_MICROEDITION_CONFIGURATION = "microedition.configuration";
    public static final String PROP_J2ME_MICROEDITION_PROFILES = "microedition.profiles";
    public static final String PROP_SETPERMS_CMD = "osgi.filepermissions.command";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEBUG_VERBOSE = "osgi.debug.verbose";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_USE_SYSTEM_PROPERTIES = "osgi.framework.useSystemProperties";
    public static final String PROP_FRAMEWORK = "osgi.framework";
    public static final String ECLIPSE_FRAMEWORK_VENDOR = "Eclipse";
    public static final String PROP_OSGI_JAVA_PROFILE = "osgi.java.profile";
    public static final String PROP_OSGI_JAVA_PROFILE_NAME = "osgi.java.profile.name";
    public static final String PROP_OSGI_JAVA_PROFILE_BOOTDELEGATION = "osgi.java.profile.bootdelegation";
    public static final String PROP_OSGI_BOOTDELEGATION_IGNORE = "ignore";
    public static final String PROP_OSGI_BOOTDELEGATION_OVERRIDE = "override";
    public static final String PROP_OSGI_BOOTDELEGATION_NONE = "none";
    public static final String PROP_CONTEXT_BOOTDELEGATION = "osgi.context.bootdelegation";
    public static final String PROP_COMPATIBILITY_BOOTDELEGATION = "osgi.compatibility.bootdelegation";
    public static final String PROP_COMPATIBILITY_ERROR_FAILED_START = "osgi.compatibility.errorOnFailedStart";
    public static final String PROP_COMPATIBILITY_START_LAZY = "osgi.compatibility.eagerStart.LazyActivation";
    public static final String PROP_OSGI_OS = "osgi.os";
    public static final String PROP_OSGI_WS = "osgi.ws";
    public static final String PROP_OSGI_ARCH = "osgi.arch";
    public static final String PROP_OSGI_NL = "osgi.nl";
    public static final String PROP_OSGI_NL_USER = "osgi.nl.user";
    public static final String PROP_ROOT_LOCALE = "equinox.root.locale";
    public static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    public static final String PARENT_CLASSLOADER_FWK = "fwk";
    public static final String PROP_CONTEXTCLASSLOADER_PARENT = "osgi.contextClassLoaderParent";
    public static final String CONTEXTCLASSLOADER_PARENT_APP = "app";
    public static final String CONTEXTCLASSLOADER_PARENT_EXT = "ext";
    public static final String CONTEXTCLASSLOADER_PARENT_BOOT = "boot";
    public static final String CONTEXTCLASSLOADER_PARENT_FWK = "fwk";
    public static final String PROP_FRAMEWORK_LIBRARY_EXTENSIONS = "osgi.framework.library.extensions";
    public static final String PROP_COPY_NATIVES = "osgi.classloader.copy.natives";
    public static final String PROP_DEFINE_PACKAGES = "osgi.classloader.define.packages";
    public static final String PROP_BUNDLE_SETTCCL = "eclipse.bundle.setTCCL";
    public static final String PROP_EQUINOX_SECURITY = "eclipse.security";
    public static final String PROP_FILE_LIMIT = "osgi.bundlefile.limit";
    public static final String PROP_CLASS_CERTIFICATE_SUPPORT = "osgi.support.class.certificate";
    public static final String PROP_CLASS_LOADER_TYPE = "osgi.classloader.type";
    public static final String CLASS_LOADER_TYPE_PARALLEL = "parallel";
    public static final String PROP_FORCED_RESTART = "osgi.forcedRestart";
    public static final String PROP_IGNORE_USER_CONFIGURATION = "eclipse.ignoreUserConfiguration";
    public static final String PROPERTY_STRICT_BUNDLE_ENTRY_PATH = "osgi.strictBundleEntryPath";
    public static final String PROP_CHECK_CONFIGURATION = "osgi.checkConfiguration";
    private final boolean inCheckConfigurationMode;
    public static final String DEFAULT_STATE_SAVE_DELAY_INTERVAL = "30000";
    public static final String PROP_STATE_SAVE_DELAY_INTERVAL = "eclipse.stateSaveDelayInterval";
    public static final String PROP_MODULE_LOCK_TIMEOUT = "osgi.module.lock.timeout";
    private static final Collection<String> populateInitConfig = Arrays.asList("osgi.arch", "osgi.os", "osgi.ws", "osgi.nl", "org.osgi.framework.os.name", "org.osgi.framework.os.version", "org.osgi.framework.processor", "org.osgi.framework.language");
    private static final Object NULL_CONFIG = new Object(){

        public String toString() {
            return "null";
        }
    };

    EquinoxConfiguration(Map<String, ?> initialConfiguration, HookRegistry hookRegistry) {
        this.initialConfig = initialConfiguration == null ? new HashMap<String, Object>(0) : new HashMap(initialConfiguration);
        this.hookRegistry = hookRegistry;
        Object useSystemPropsValue = this.initialConfig.get(PROP_USE_SYSTEM_PROPERTIES);
        boolean useSystemProps = useSystemPropsValue == null ? false : Boolean.parseBoolean(useSystemPropsValue.toString());
        this.configuration = useSystemProps ? System.getProperties() : new Properties();
        for (Map.Entry<String, Object> initialEntry : this.initialConfig.entrySet()) {
            if (initialEntry.getValue() == null) {
                this.configuration.put(initialEntry.getKey(), NULL_CONFIG);
                continue;
            }
            this.configuration.put(initialEntry.getKey(), initialEntry.getValue());
        }
        EquinoxConfiguration.initializeProperties(this.configuration, this.aliasMapper);
        for (String initialKey : populateInitConfig) {
            String value = this.configuration.getProperty(initialKey);
            if (value == null) continue;
            this.initialConfig.put(initialKey, value);
        }
        this.debugOptions = new FrameworkDebugOptions(this);
        this.debug = new Debug(this.debugOptions);
        String osgiDev = this.configuration.getProperty(PROP_DEV);
        File f = null;
        boolean devMode = false;
        if (osgiDev != null) {
            try {
                devMode = true;
                URL location = new URL(osgiDev);
                if ("file".equals(location.getProtocol())) {
                    f = new File(location.getFile());
                    this.devLastModified = f.lastModified();
                }
                try {
                    this.loadDevProperties(location.openStream());
                    devMode = true;
                }
                catch (IOException iOException) {}
            }
            catch (MalformedURLException malformedURLException) {
                this.devDefaultClasspath = EquinoxConfiguration.getArrayFromList(osgiDev);
            }
        }
        this.inDevelopmentMode = devMode;
        this.devLocation = f;
        this.contextBootDelegation = "true".equals(this.configuration.getProperty(PROP_CONTEXT_BOOTDELEGATION, "true"));
        this.compatibilityBootDelegation = "true".equals(this.configuration.getProperty(PROP_COMPATIBILITY_BOOTDELEGATION));
        this.COPY_NATIVES = Boolean.valueOf(this.configuration.getProperty(PROP_COPY_NATIVES));
        String[] libExtensions = ManifestElement.getArrayFromList(this.configuration.getProperty(PROP_FRAMEWORK_LIBRARY_EXTENSIONS, this.configuration.getProperty("org.osgi.framework.library.extensions", EquinoxConfiguration.getOSLibraryExtDefaults())), ",");
        int i = 0;
        while (i < libExtensions.length) {
            if (libExtensions[i].length() > 0 && libExtensions[i].charAt(0) != '.') {
                libExtensions[i] = String.valueOf('.') + libExtensions[i];
            }
            ++i;
        }
        this.LIB_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(libExtensions));
        this.ECLIPSE_LIB_VARIANTS = EquinoxConfiguration.buildEclipseLibraryVariants(this.getWS(), this.getOS(), this.getOSArch(), this.getNL());
        this.ECLIPSE_NL_JAR_VARIANTS = EquinoxConfiguration.buildNLJarVariants(this.getNL());
        this.DEFINE_PACKAGE_ATTRIBUTES = !"noattributes".equals(this.configuration.getProperty(PROP_DEFINE_PACKAGES));
        String bsnVersion = this.configuration.getProperty("org.osgi.framework.bsnversion");
        this.BSN_VERSION = "single".equals(bsnVersion) ? 1 : ("multiple".equals(bsnVersion) ? 2 : 3);
        this.BUNDLE_SET_TCCL = "true".equals(this.getConfiguration(PROP_BUNDLE_SETTCCL, "true"));
        this.throwErrorOnFailedStart = "true".equals(this.getConfiguration(PROP_COMPATIBILITY_ERROR_FAILED_START, "true"));
        this.CLASS_CERTIFICATE = Boolean.valueOf(this.getConfiguration(PROP_CLASS_CERTIFICATE_SUPPORT, "true"));
        this.PARALLEL_CAPABLE = CLASS_LOADER_TYPE_PARALLEL.equals(this.getConfiguration(PROP_CLASS_LOADER_TYPE));
        this.inCheckConfigurationMode = Boolean.valueOf(this.getConfiguration(PROP_CHECK_CONFIGURATION, Boolean.toString(devMode)));
        if (this.inCheckConfigurationMode && this.getConfiguration(PROP_CHECK_CONFIGURATION) == null) {
            this.setConfiguration(PROP_CHECK_CONFIGURATION, "true");
        }
    }

    public Map<String, Object> getInitialConfig() {
        return Collections.unmodifiableMap(this.initialConfig);
    }

    private static List<String> buildEclipseLibraryVariants(String ws, String os, String arch, String nl) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + ws + "/");
        result.add("os/" + os + "/" + arch + "/");
        result.add("os/" + os + "/");
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return Collections.unmodifiableList(result);
    }

    private static List<String> buildNLJarVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result;
    }

    private static String getOSLibraryExtDefaults() {
        String os = System.getProperty(PROP_JVM_OS_NAME);
        return os == null || !os.startsWith(INTERNAL_OS_MACOSX) ? null : "dylib,jnilib";
    }

    public boolean inCheckConfigurationMode() {
        return this.inCheckConfigurationMode;
    }

    @Override
    public boolean inDevelopmentMode() {
        return this.inDevelopmentMode;
    }

    @Override
    public boolean inDebugMode() {
        return this.debugOptions.isDebugEnabled();
    }

    @Override
    public String[] getCommandLineArgs() {
        return this.allArgs;
    }

    @Override
    public String[] getFrameworkArgs() {
        return this.frameworkArgs;
    }

    @Override
    public String[] getNonFrameworkArgs() {
        return this.appArgs;
    }

    @Override
    public String getOSArch() {
        return this.configuration.getProperty(PROP_OSGI_ARCH);
    }

    @Override
    public String getNL() {
        return this.configuration.getProperty(PROP_OSGI_NL);
    }

    @Override
    public String getOS() {
        return this.configuration.getProperty(PROP_OSGI_OS);
    }

    @Override
    public String getWS() {
        return this.configuration.getProperty(PROP_OSGI_WS);
    }

    public void setAllArgs(String[] allArgs) {
        this.allArgs = allArgs;
    }

    public void setAppArgs(String[] appArgs) {
        this.appArgs = appArgs;
    }

    public void setFrameworkArgs(String[] frameworkArgs) {
        this.frameworkArgs = frameworkArgs;
    }

    public static String guessWS(String osName) {
        if (osName.equals("win32")) {
            return "win32";
        }
        if (osName.equals("linux")) {
            return "gtk";
        }
        if (osName.equals("macosx")) {
            return "cocoa";
        }
        if (osName.equals("hpux")) {
            return "motif";
        }
        if (osName.equals("aix")) {
            return "motif";
        }
        if (osName.equals("solaris")) {
            return "gtk";
        }
        if (osName.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    public static String guessOS(String osName) {
        if (osName.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_SUNOS)) {
            return "solaris";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_LINUX)) {
            return "linux";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_QNX)) {
            return "qnx";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_AIX)) {
            return "aix";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_HPUX)) {
            return "hpux";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_OS400)) {
            return "os/400";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_OS390)) {
            return "os/390";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_ZOS)) {
            return "z/os";
        }
        if (osName.regionMatches(true, 0, INTERNAL_OS_MACOSX, 0, INTERNAL_OS_MACOSX.length())) {
            return "macosx";
        }
        return "unknown";
    }

    public String getConfiguration(String key) {
        return this.configuration.getProperty(key);
    }

    public String getConfiguration(String key, String defaultValue) {
        String result = this.getConfiguration(key);
        return result == null ? defaultValue : result;
    }

    public String setConfiguration(String key, String value) {
        Object result = this.configuration.put(key, value);
        return result instanceof String ? (String)result : null;
    }

    public String clearConfiguration(String key) {
        Object result = this.configuration.remove(key);
        this.configuration.put(key, NULL_CONFIG);
        return result instanceof String ? (String)result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getConfiguration() {
        Properties properties = this.configuration;
        synchronized (properties) {
            HashMap<String, String> result = new HashMap<String, String>(this.configuration.size());
            for (Object key : this.configuration.keySet()) {
                if (!(key instanceof String)) continue;
                String skey = (String)key;
                result.put(skey, this.configuration.getProperty(skey));
            }
            return result;
        }
    }

    public Debug getDebug() {
        return this.debug;
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public HookRegistry getHookRegistry() {
        return this.hookRegistry;
    }

    @Override
    public String getProperty(String key) {
        String result = this.getConfiguration(key);
        return result == null && !this.configuration.containsKey(key) ? System.getProperty(key) : result;
    }

    @Override
    public String setProperty(String key, String value) {
        if (value == null) {
            return this.clearConfiguration(key);
        }
        return this.setConfiguration(key, value);
    }

    public AliasMapper getAliasMapper() {
        return this.aliasMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevProperties() {
        if (this.devLocation == null) {
            return;
        }
        Object object = this.devMonitor;
        synchronized (object) {
            if (this.devLocation.lastModified() == this.devLastModified) {
                return;
            }
            try {
                this.loadDevProperties(new FileInputStream(this.devLocation));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            this.devLastModified = this.devLocation.lastModified();
        }
    }

    private static String[] getDevClassPath(String id, Dictionary<String, String> properties, String[] defaultClasspath) {
        String entry;
        String[] result = null;
        if (id != null && properties != null && (entry = properties.get(id)) != null) {
            result = EquinoxConfiguration.getArrayFromList(entry);
        }
        if (result == null) {
            result = defaultClasspath;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDevClassPath(String id, Dictionary<String, String> properties) {
        if (properties == null) {
            Object object = this.devMonitor;
            synchronized (object) {
                this.updateDevProperties();
                return EquinoxConfiguration.getDevClassPath(id, this.devProperties, this.devDefaultClasspath);
            }
        }
        return EquinoxConfiguration.getDevClassPath(id, properties, EquinoxConfiguration.getArrayFromList(properties.get("*")));
    }

    public String[] getDevClassPath(String id) {
        return this.getDevClassPath(id, null);
    }

    private static String[] getArrayFromList(String prop) {
        return ManifestElement.getArrayFromList(prop, ",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDevProperties(InputStream input) {
        Properties props;
        block18: {
            props = new Properties();
            try {
                try {
                    props.load(input);
                }
                catch (IOException iOException) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        Properties result = props;
        Object object = this.devMonitor;
        synchronized (object) {
            this.devProperties = result;
            if (this.devProperties != null) {
                this.devDefaultClasspath = EquinoxConfiguration.getArrayFromList(this.devProperties.get("*"));
            }
        }
    }

    void mergeConfiguration(Properties source) {
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = source.getProperty(key);
            if (this.getConfiguration(key) == null) {
                this.setProperty(key, value);
                this.initialConfig.put(key, value);
                continue;
            }
            this.initialConfig.put(key, this.getConfiguration(key));
        }
    }

    private static void initializeStateSaveDelayIntervalProperty(Properties configuration) {
        if (!configuration.containsKey(PROP_STATE_SAVE_DELAY_INTERVAL)) {
            configuration.setProperty(PROP_STATE_SAVE_DELAY_INTERVAL, DEFAULT_STATE_SAVE_DELAY_INTERVAL);
        }
        try {
            Long.parseLong(configuration.getProperty(PROP_STATE_SAVE_DELAY_INTERVAL));
        }
        catch (NumberFormatException numberFormatException) {
            configuration.setProperty(PROP_STATE_SAVE_DELAY_INTERVAL, DEFAULT_STATE_SAVE_DELAY_INTERVAL);
        }
    }

    private static void initializeProperties(Properties configuration, AliasMapper aliasMapper) {
        String archValue;
        String wsValue;
        String nlValue;
        if (configuration.get(PROP_FRAMEWORK) == null || configuration.get("osgi.install.area") == null) {
            URL url;
            ProtectionDomain pd = EquinoxConfiguration.class.getProtectionDomain();
            CodeSource cs = pd == null ? null : pd.getCodeSource();
            URL uRL = url = cs == null ? null : cs.getLocation();
            if (url == null) {
                IOException cause = null;
                URL java6Profile = EquinoxConfiguration.class.getResource("/JavaSE-1.6.profile");
                if (java6Profile != null && "jar".equals(java6Profile.getProtocol())) {
                    try {
                        url = ((JarURLConnection)java6Profile.openConnection()).getJarFileURL();
                    }
                    catch (IOException e) {
                        cause = e;
                    }
                }
                if (url == null) {
                    throw new IllegalArgumentException(NLS.bind(Msg.ECLIPSE_STARTUP_PROPS_NOT_SET, "osgi.framework, osgi.install.area"), cause);
                }
            }
            if (configuration.get(PROP_FRAMEWORK) == null) {
                String externalForm = EquinoxConfiguration.getFrameworkPath(url.toExternalForm(), false);
                configuration.put(PROP_FRAMEWORK, externalForm);
            }
            if (configuration.get("osgi.install.area") == null) {
                String filePart = EquinoxConfiguration.getFrameworkPath(url.getFile(), true);
                configuration.put("osgi.install.area", filePart);
            }
        }
        configuration.put(PROP_FRAMEWORK, EquinoxConfiguration.decode(configuration.getProperty(PROP_FRAMEWORK)));
        configuration.put("osgi.install.area", EquinoxConfiguration.decode(configuration.getProperty("osgi.install.area")));
        configuration.put("org.osgi.framework.vendor", ECLIPSE_FRAMEWORK_VENDOR);
        String value = configuration.getProperty("org.osgi.framework.processor");
        if (value == null && (value = System.getProperty(PROP_JVM_OS_ARCH)) != null) {
            configuration.put("org.osgi.framework.processor", aliasMapper.getCanonicalProcessor(value));
        }
        if ((value = configuration.getProperty("org.osgi.framework.os.name")) == null && (value = System.getProperty(PROP_JVM_OS_NAME)) != null) {
            configuration.put("org.osgi.framework.os.name", aliasMapper.getCanonicalOSName(value));
        }
        if ((value = configuration.getProperty("org.osgi.framework.os.version")) == null && (value = System.getProperty(PROP_JVM_OS_VERSION)) != null) {
            int space = value.indexOf(32);
            if (space > 0) {
                value = value.substring(0, space);
            }
            int major = 0;
            int minor = 0;
            int micro = 0;
            String qualifier = "";
            try {
                StringTokenizer st = new StringTokenizer(value, ".", true);
                major = EquinoxConfiguration.parseVersionInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    minor = EquinoxConfiguration.parseVersionInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        micro = EquinoxConfiguration.parseVersionInt(st.nextToken());
                        if (st.hasMoreTokens()) {
                            st.nextToken();
                            qualifier = st.nextToken();
                        }
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            try {
                value = new Version(major, minor, micro, qualifier).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                value = new Version(major, minor, micro).toString();
            }
            configuration.put("org.osgi.framework.os.version", value);
        }
        if ((value = configuration.getProperty("org.osgi.framework.language")) == null) {
            configuration.put("org.osgi.framework.language", Locale.getDefault().getLanguage());
        }
        configuration.put("org.osgi.supports.framework.fragment", "true");
        configuration.put("org.osgi.supports.framework.requirebundle", "true");
        configuration.put("org.osgi.supports.framework.extension", "true");
        if ("onFirstInit".equals(configuration.get("org.osgi.framework.storage.clean"))) {
            configuration.put(PROP_CLEAN, "true");
        }
        if ((nlValue = configuration.getProperty(PROP_OSGI_NL)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(nlValue, "_");
            int segments = tokenizer.countTokens();
            try {
                Locale userLocale = null;
                switch (segments) {
                    case 1: {
                        userLocale = new Locale(tokenizer.nextToken(), "");
                        break;
                    }
                    case 2: {
                        userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
                        break;
                    }
                    case 3: {
                        userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
                        break;
                    }
                    default: {
                        System.err.println(NLS.bind(Msg.error_badNL, nlValue));
                        userLocale = Locale.getDefault();
                    }
                }
                Locale.setDefault(userLocale);
                configuration.put(PROP_OSGI_NL_USER, nlValue);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        nlValue = Locale.getDefault().toString();
        configuration.put(PROP_OSGI_NL, nlValue);
        String osValue = configuration.getProperty(PROP_OSGI_OS);
        if (osValue == null) {
            osValue = EquinoxConfiguration.guessOS(System.getProperty(PROP_JVM_OS_NAME));
            configuration.put(PROP_OSGI_OS, osValue);
        }
        if ((wsValue = configuration.getProperty(PROP_OSGI_WS)) == null) {
            wsValue = EquinoxConfiguration.guessWS(osValue);
            configuration.put(PROP_OSGI_WS, wsValue);
        }
        if ((archValue = configuration.getProperty(PROP_OSGI_ARCH)) == null) {
            String name = System.getProperty(PROP_JVM_OS_ARCH);
            archValue = name.equalsIgnoreCase(INTERNAL_ARCH_I386) ? "x86" : (name.equalsIgnoreCase(INTERNAL_AMD64) ? "x86_64" : name);
            configuration.put(PROP_OSGI_ARCH, archValue);
        }
        EquinoxConfiguration.initializeStateSaveDelayIntervalProperty(configuration);
        String consoleProp = configuration.getProperty("osgi.console");
        String string = consoleProp = consoleProp == null ? null : consoleProp.trim();
        if (consoleProp == null || consoleProp.length() > 0) {
            configuration.put("gosh.args", "--nointeractive");
        } else {
            configuration.put("gosh.args", "--noshutdown");
        }
    }

    private static String getFrameworkPath(String path, boolean parent) {
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        if (path.endsWith("org.eclipse.osgi/bin/")) {
            path = path.substring(0, path.length() - "bin/".length());
        }
        if (parent) {
            int lastSlash = path.lastIndexOf(47);
            return lastSlash == -1 ? "/" : path.substring(0, lastSlash);
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseVersionInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException v0) {
            sb = new StringBuffer(value.length());
            chars = value.toCharArray();
            i = 0;
            ** while (i < chars.length)
        }
lbl-1000:
        // 1 sources

        {
            if (!Character.isDigit(chars[i])) break;
            sb.append(chars[i]);
            ++i;
            continue;
        }
lbl13:
        // 2 sources

        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return 0;
    }

    public static String decode(String urlString) {
        if (urlString.indexOf(43) >= 0) {
            int len = urlString.length();
            StringBuffer buf = new StringBuffer(len);
            int i = 0;
            while (i < len) {
                char c = urlString.charAt(i);
                if (c == '+') {
                    buf.append("%2B");
                } else {
                    buf.append(c);
                }
                ++i;
            }
            urlString = buf.toString();
        }
        try {
            return URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return urlString;
        }
    }

    public String substituteVars(String path) {
        return this.substituteVars(path, false);
    }

    public String substituteVars(String path, boolean preserveDelimiters) {
        StringBuffer buf = new StringBuffer(path.length());
        StringTokenizer st = new StringTokenizer(path, VARIABLE_DELIM_STRING, true);
        boolean varStarted = false;
        String var = null;
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if (VARIABLE_DELIM_STRING.equals(tok)) {
                if (!varStarted) {
                    varStarted = true;
                    var = "";
                    continue;
                }
                String prop = null;
                if (var != null && var.length() > 0) {
                    prop = this.getProperty(var);
                }
                if (prop == null) {
                    try {
                        Method getenv = System.class.getMethod("getenv", String.class);
                        prop = (String)getenv.invoke(null, var);
                    }
                    catch (Throwable throwable) {}
                }
                if (prop != null) {
                    buf.append(prop);
                } else {
                    if (preserveDelimiters) {
                        buf.append('$');
                    }
                    buf.append(var == null ? "" : var);
                    if (preserveDelimiters) {
                        buf.append('$');
                    }
                }
                varStarted = false;
                var = null;
                continue;
            }
            if (!varStarted) {
                buf.append(tok);
                continue;
            }
            var = tok;
        }
        if (var != null) {
            buf.append('$').append(var);
        }
        return buf.toString();
    }
}

