/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.workqueue;

import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.workqueue.WorkDispatcher;

public class WorkQueue
extends Thread {
    private static final boolean DEBUG = false;
    private Queued head = null;
    private Queued tail = null;
    private volatile boolean stopping = false;

    public WorkQueue(String threadName) {
        super(threadName);
    }

    public void closeAndJoin() {
        this.stopping = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            while (true) {
                Queued item;
                if ((item = this.dequeueWork()) == null) {
                    return;
                }
                item.dispatch();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
    }

    public synchronized void enqueueWork(WorkDispatcher d, int a, Object o) {
        if (!this.isAlive()) {
            throw new IllegalStateException("work thread is not alive");
        }
        Queued item = new Queued(d, a, o);
        if (this.head == null) {
            this.head = item;
            this.tail = item;
        } else {
            this.tail.next = item;
            this.tail = item;
        }
        this.notify();
    }

    private synchronized Queued dequeueWork() {
        while (!this.stopping && this.head == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.stopping && this.head == null) {
            return null;
        }
        Queued item = this.head;
        this.head = item.next;
        if (this.head == null) {
            this.tail = null;
        }
        return item;
    }

    private static class Queued {
        private final WorkDispatcher dispatcher;
        private final int action;
        private final Object object;
        Queued next;

        Queued(WorkDispatcher d, int a, Object o) {
            this.dispatcher = d;
            this.action = a;
            this.object = o;
            this.next = null;
        }

        void dispatch() {
            try {
                this.dispatcher.dispatchWork(this.action, this.object);
            }
            catch (Throwable t) {
                t.printStackTrace();
                Log.log(1, "[SCR] Error dispatching work ", t);
            }
        }
    }
}

