/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import net.jini.security.proxytrust.UntrustedObjectSecurityContext;

public final class BasicUntrustedObjectSecurityContext
implements UntrustedObjectSecurityContext {
    private static final CodeSource emptyCS = new CodeSource(null, (Certificate[])null);
    private static final ProtectionDomain emptyPD = new ProtectionDomain(emptyCS, null, null, null);
    private final Permission[] permissions;
    private final ProtectionDomain restrictedPD;

    public BasicUntrustedObjectSecurityContext(Permission[] permissions) {
        if (permissions == null || permissions.length == 0) {
            this.permissions = new Permission[0];
            this.restrictedPD = emptyPD;
        } else {
            this.permissions = (Permission[])permissions.clone();
            Permissions pc = new Permissions();
            int i = this.permissions.length;
            while (--i >= 0) {
                Permission p = this.permissions[i];
                if (p == null) {
                    throw new NullPointerException("permission cannot be null");
                }
                ((PermissionCollection)pc).add(p);
            }
            this.restrictedPD = new ProtectionDomain(emptyCS, pc, null, null);
        }
    }

    public SecurityContext getContext() {
        final AccessControlContext acc0 = AccessController.getContext();
        AccessControlContext racc = (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DomainCombiner comb0 = acc0.getDomainCombiner();
                AccessControlContext acc1 = new AccessControlContext(acc0, new Combiner(comb0));
                AccessControlContext acc2 = (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return AccessController.getContext();
                    }
                }, acc1);
                return new AccessControlContext(acc2, comb0);
            }
        });
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getContext();
            }
        }, racc);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BasicUntrustedObjectAccessController{");
        for (int i = 0; i < this.permissions.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.permissions[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicUntrustedObjectSecurityContext)) {
            return false;
        }
        Permission[] otherPerms = ((BasicUntrustedObjectSecurityContext)obj).permissions;
        if (this.permissions.length != otherPerms.length) {
            return false;
        }
        otherPerms = (Permission[])otherPerms.clone();
        int i = this.permissions.length;
        block0: while (--i >= 0) {
            Permission p = this.permissions[i];
            for (int j = i; j >= 0; --j) {
                if (!p.equals(otherPerms[j])) continue;
                otherPerms[j] = otherPerms[i];
                continue block0;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i = this.permissions.length;
        while (--i >= 0) {
            hash += this.permissions[i].hashCode();
        }
        return hash;
    }

    private class Combiner
    implements DomainCombiner {
        private final DomainCombiner combiner;

        Combiner(DomainCombiner combiner) {
            this.combiner = combiner;
        }

        public ProtectionDomain[] combine(ProtectionDomain[] current, ProtectionDomain[] assigned) {
            if (this.combiner != null) {
                return this.combiner.combine(new ProtectionDomain[]{BasicUntrustedObjectSecurityContext.this.restrictedPD}, assigned);
            }
            if (assigned == null) {
                return new ProtectionDomain[]{BasicUntrustedObjectSecurityContext.this.restrictedPD};
            }
            ProtectionDomain[] pds = new ProtectionDomain[assigned.length + 1];
            pds[0] = BasicUntrustedObjectSecurityContext.this.restrictedPD;
            System.arraycopy(assigned, 0, pds, 1, assigned.length);
            return pds;
        }
    }
}

