/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import com.sun.jini.logging.Levels;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;
import net.jini.config.Utilities;

public abstract class AbstractConfiguration
implements Configuration {
    private static final String[] reservedNames = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Logger logger = Logger.getLogger("net.jini.config");

    protected AbstractConfiguration() {
    }

    public Object getEntry(String component, String name, Class type) throws ConfigurationException {
        return this.getEntryInternal(component, name, type, NO_DEFAULT, NO_DATA);
    }

    public Object getEntry(String component, String name, Class type, Object defaultValue) throws ConfigurationException {
        return this.getEntryInternal(component, name, type, defaultValue, NO_DATA);
    }

    public Object getEntry(String component, String name, Class type, Object defaultValue, Object data) throws ConfigurationException {
        return this.getEntryInternal(component, name, type, defaultValue, data);
    }

    protected abstract Object getEntryInternal(String var1, String var2, Class var3, Object var4) throws ConfigurationException;

    private Object getEntryInternal(String component, String name, Class type, Object defaultValue, Object data) throws ConfigurationException {
        ConfigurationException configEx;
        if (component == null) {
            throw new NullPointerException("component cannot be null");
        }
        if (!AbstractConfiguration.validQualifiedIdentifier(component)) {
            throw new IllegalArgumentException("component must be a valid qualified identifier");
        }
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (!AbstractConfiguration.validIdentifier(name)) {
            throw new IllegalArgumentException("name must be a valid identifier");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (defaultValue != NO_DEFAULT && (type.isPrimitive() ? defaultValue == null || Utilities.getPrimitiveType(defaultValue.getClass()) != type : defaultValue != null && !type.isAssignableFrom(defaultValue.getClass()))) {
            throw new IllegalArgumentException("defaultValue is of wrong type");
        }
        try {
            Class<Object> resultType;
            Object result = this.getEntryInternal(component, name, type, data);
            if (result instanceof Primitive) {
                resultType = ((Primitive)result).getType();
                result = ((Primitive)result).getValue();
            } else {
                resultType = result != null ? result.getClass() : null;
            }
            if (resultType == null ? type.isPrimitive() : !type.isAssignableFrom(resultType)) {
                throw new ConfigurationException("entry for component " + component + ", name " + name + " is of wrong type: " + Utilities.typeString(resultType));
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "{0}, component {1}, name {2}{3,choice,0#|1#, data {4}}: returns {5}", new Object[]{this, component, name, new Double(data == NO_DATA ? 0.0 : 1.0), data, result});
            }
            return result;
        }
        catch (NoSuchEntryException e) {
            if (defaultValue == NO_DEFAULT) {
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "{0}, component {1}, name {2}: entry not found", new Object[]{this, component, name});
                }
                throw e;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: returns default {3}", new Object[]{this, component, name, defaultValue});
            }
            return defaultValue;
        }
        catch (ConfigurationException e) {
            configEx = e;
        }
        catch (RuntimeException e) {
            configEx = new ConfigurationException("problem getting entry for component " + component + ", name " + name, e);
        }
        if (logger.isLoggable(Levels.FAILED)) {
            this.logThrow("getEntry", "{0}, component {1}, name {2}{3,choice,0#|1#, data {4}}: throws", new Object[]{this, component, name, new Double(data == NO_DATA ? 0.0 : 1.0), data}, configEx);
        }
        throw configEx;
    }

    void logThrow(String method, String msg, Object[] msgParams, Throwable t) {
        LogRecord r = new LogRecord(Levels.FAILED, msg);
        r.setLoggerName(logger.getName());
        r.setSourceClassName(this.getClass().getName());
        r.setSourceMethodName(method);
        r.setParameters(msgParams);
        r.setThrown(t);
        logger.log(r);
    }

    protected static boolean validIdentifier(String name) {
        if (name == null || name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = name.length();
        while (--i > 0) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return Arrays.binarySearch(reservedNames, name) < 0;
    }

    protected static boolean validQualifiedIdentifier(String name) {
        int dot;
        if (name == null) {
            return false;
        }
        int offset = 0;
        do {
            String id;
            if (!AbstractConfiguration.validIdentifier(id = name.substring(offset, (dot = name.indexOf(46, offset)) < 0 ? name.length() : dot))) {
                return false;
            }
            offset = dot + 1;
        } while (dot >= 0);
        return true;
    }

    public static final class Primitive {
        private final Object value;
        private final Class type;

        public Primitive(Object value) {
            this.value = value;
            Class clazz = this.type = value != null ? Utilities.getPrimitiveType(value.getClass()) : null;
            if (this.type == null) {
                throw new IllegalArgumentException("value is not a primitive: " + value);
            }
        }

        public Object getValue() {
            return this.value;
        }

        public Class getType() {
            return this.type;
        }

        public String toString() {
            return "Primitive[(" + this.type + ") " + this.value + "]";
        }

        public boolean equals(Object obj) {
            return obj instanceof Primitive && this.value.equals(((Primitive)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

