/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.InputStream;
import java.net.URL;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.FontMetrics;
import netscape.application.Image;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Deserializer;
import netscape.util.Encoder;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class Font
implements Codable {
    FontMetrics _metrics;
    String _name;
    URL _url;
    Bitmap _glyphsImage;
    Vector _glyphVector;
    Vector _widthsVector;
    Hashtable _description;
    java.awt.Font _awtFont;
    int _type = 0;
    int _widthsArrayBase;
    int[] _widthsArray;
    static final int INVALID = 0;
    static final int AWT = 1;
    static final int DOWNLOADED = 2;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    static final String FAMILY = "Family";
    static final String STYLE = "Style";
    static final String SIZE = "Size";
    static final String WIDTHS = "Widths";
    static final String DESCRIPTION = "Description";
    static final String GLYPHS = "glyphs.gif";
    static final String NAME_KEY = "name";
    static final String STYLE_KEY = "style";
    static final String SIZE_KEY = "size";
    private static Class fontClass;

    private static Class fontClass() {
        if (fontClass == null) {
            fontClass = new Font().getClass();
        }
        return fontClass;
    }

    public Font() {
    }

    public Font(String string, int n, int n2) {
        this();
        this._awtFont = new java.awt.Font(string, n, n2);
        this._name = string;
        if (this._awtFont != null) {
            this._type = 1;
        }
    }

    public static Font defaultFont() {
        return Font.fontNamed("Helvetica", 0, 12);
    }

    public static synchronized Font fontNamed(String string, int n, int n2) {
        if (string == null || n2 == 0) {
            return null;
        }
        String string2 = string + "." + n + "." + n2;
        Application application = Application.application();
        Font font = (Font)application.fontByName.get(string2);
        if (font != null) {
            return font;
        }
        font = new Font(string, n, n2);
        if (!font.isValid()) {
            return null;
        }
        application.fontByName.put(string2, font);
        return font;
    }

    public static Font fontNamed(String string) {
        int n;
        String[] stringArray = Font.stringsForString(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string2 = stringArray[0];
        if (string2.equals("Default")) {
            return Font.defaultFont();
        }
        if (string2.length() == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            Application application = Application.application();
            URL uRL = application._appResources.urlForFontNamed(string2);
            return Font.getFontFromURL(uRL, string2);
        }
        String string3 = stringArray[1];
        char c = string3.charAt(0);
        if (c == 'P' || c == 'p') {
            n = 0;
        } else if (c == 'B' || c == 'b') {
            n = 1;
        } else if (c == 'I' || c == 'i') {
            n = 2;
        } else {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        int n2 = Font.parseInt(stringArray[2]);
        if (n2 < 0) {
            n2 = 0;
        }
        return Font.fontNamed(string2, n, n2);
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static String[] stringsForString(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(58) == -1) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == ':') {
                vector.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        vector.addElement(stringBuffer.toString());
        n = vector.count();
        String[] stringArray = new String[n];
        n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    synchronized void nameFont(String string, Font font) {
        Application.application().fontByName.put(string, font);
    }

    static synchronized Font getFontFromURL(URL uRL, String string) {
        Font font;
        Application application = Application.application();
        if (uRL == null) {
            return null;
        }
        if (string != null && (font = (Font)application.fontByName.get(string)) != null) {
            return font;
        }
        font = new Font(uRL, string);
        if (!font.isValid()) {
            return null;
        }
        application.fontByName.put(string, font);
        return font;
    }

    Font(URL uRL, String string) {
        this();
        URL uRL2;
        this._url = uRL;
        this._name = string;
        this._type = 2;
        this._glyphVector = new Vector();
        this._widthsVector = new Vector();
        try {
            uRL2 = new URL(uRL, this._name + ".font/" + DESCRIPTION);
        }
        catch (Exception exception) {
            System.err.println("Font.init() - Trouble creating font description URL " + uRL + this._name + ".font/" + DESCRIPTION + " : " + exception);
            this._type = 0;
            return;
        }
        try {
            InputStream inputStream = uRL2.openStream();
            Deserializer deserializer = new Deserializer(inputStream);
            this._description = (Hashtable)deserializer.readObject();
            this._loadWidths();
        }
        catch (Exception exception) {
            System.err.println("Font.init() - Trouble retrieving font description URL " + uRL2);
            exception.printStackTrace(System.err);
            this._type = 0;
            return;
        }
        this._loadGlyphs(uRL);
    }

    void _loadWidths() {
        if (this._description == null) {
            return;
        }
        Object[] objectArray = (Object[])this._description.get(WIDTHS);
        if (objectArray == null) {
            System.err.println("Font._loadWidths() - No widths information for " + this._name);
            return;
        }
        this._widthsArrayBase = Font.parseInt((String)objectArray[0]);
        int n = objectArray.length - 1;
        this._widthsArray = new int[this._widthsArrayBase + n];
        int n2 = 0;
        while (n2 < this._widthsArrayBase) {
            this._widthsArray[n2] = 0;
            ++n2;
        }
        n2 = 1;
        int n3 = this._widthsArrayBase;
        while (n2 < n) {
            this._widthsArray[n3] = Font.parseInt((String)objectArray[n2]);
            ++n2;
            ++n3;
        }
        if (this._widthsArray[32] == 0) {
            this._widthsArray[32] = 5;
        }
    }

    java.awt.Image croppedImage(int n, int n2, int n3, int n4) {
        java.awt.Image image = AWTCompatibility.awtApplet().createImage(new FilteredImageSource(this._glyphsImage.awtImage.getSource(), new CropImageFilter(n, n2, n3, n4)));
        return image;
    }

    void _loadGlyphs(URL uRL) {
        URL uRL2;
        try {
            uRL2 = new URL(uRL, this._name + ".font/" + GLYPHS);
        }
        catch (Exception exception) {
            System.err.println("Font.init() - Trouble creating font glyph URL " + uRL + this._name + ".font/" + GLYPHS + " : " + exception);
            this._type = 0;
            return;
        }
        this._glyphsImage = Bitmap.bitmapFromURL(uRL2);
        this._glyphsImage.loadData();
        if (this._glyphsImage == null || !this._glyphsImage.isValid()) {
            System.err.println("Font._loadGlyphs() - Trouble loading glyphs for " + this._name);
            return;
        }
        this._glyphsImage.loadData();
        int n = this._widthsArrayBase;
        int n2 = 0;
        while (n < this._widthsArray.length) {
            java.awt.Image image = this.croppedImage(n2, 0, this._widthsArray[n], this._glyphsImage.height());
            this._glyphVector.addElement(AWTCompatibility.bitmapForAWTImage(image));
            Image image2 = (Image)this._glyphVector.lastElement();
            n2 += this._widthsArray[n];
            ++n;
        }
    }

    boolean isValid() {
        return this._type != 0;
    }

    boolean wasDownloaded() {
        return this._type == 2;
    }

    public FontMetrics fontMetrics() {
        if (this._metrics == null) {
            this._metrics = new FontMetrics(this);
        }
        return this._metrics;
    }

    public String family() {
        if (this._type == 0) {
            return "";
        }
        if (this._awtFont != null) {
            return this._awtFont.getFamily();
        }
        return (String)this._description.get(FAMILY);
    }

    public String name() {
        if (this._type == 0) {
            return "";
        }
        return this._name;
    }

    public int style() {
        if (this._type == 0) {
            return -1;
        }
        if (this._awtFont != null) {
            return this._awtFont.getStyle();
        }
        return Font.parseInt((String)this._description.get(STYLE));
    }

    public int size() {
        if (this._type == 0) {
            return -1;
        }
        if (this._awtFont != null) {
            return this._awtFont.getSize();
        }
        return Font.parseInt((String)this._description.get(SIZE));
    }

    public boolean isPlain() {
        return this.style() == 0;
    }

    public boolean isBold() {
        return (this.style() & 1) > 0;
    }

    public boolean isItalic() {
        return (this.style() & 2) > 0;
    }

    Vector glyphVector() {
        return this._glyphVector;
    }

    String _stringValueFromDescription(String string) {
        if (string == null || this._description == null) {
            return "";
        }
        return (String)this._description.get(string);
    }

    int _intValueFromDescription(String string) {
        if (string == null || this._description == null) {
            return 0;
        }
        return Font.parseInt((String)this._description.get(string));
    }

    public String toString() {
        if (this._type == 0 || this.wasDownloaded()) {
            return this._name;
        }
        String string = this.isBold() ? (this.isItalic() ? "BoldItalic" : "Bold") : (this.isItalic() ? "Italic" : "Plain");
        return this.family() + ":" + string + ":" + this.size();
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Font", 1);
        classInfo.addField(NAME_KEY, (byte)16);
        classInfo.addField(STYLE_KEY, (byte)8);
        classInfo.addField(SIZE_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeString(NAME_KEY, this.name());
        encoder.encodeInt(STYLE_KEY, this.style());
        encoder.encodeInt(SIZE_KEY, this.size());
    }

    public void decode(Decoder decoder) throws CodingException {
        String string = decoder.decodeString(NAME_KEY);
        int n = decoder.decodeInt(STYLE_KEY);
        int n2 = decoder.decodeInt(SIZE_KEY);
        Font font = Font.fontNamed(string, n, n2);
        if (this.getClass() == Font.fontClass()) {
            decoder.replaceObject(font);
            return;
        }
        this._name = font._name;
        this._type = font._type;
        this._awtFont = font._awtFont;
        this.nameFont(this._name, this);
    }

    public void finishDecoding() throws CodingException {
    }
}

