/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.Array;
import org.jquantlib.math.SampledCurve;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.BoundaryConditionSet;
import org.jquantlib.methods.finitedifferences.NullCondition;
import org.jquantlib.methods.finitedifferences.StandardSystemFiniteDifferenceModel;
import org.jquantlib.methods.finitedifferences.StepCondition;
import org.jquantlib.methods.finitedifferences.StepConditionSet;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.pricingengines.results.Results;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDVanillaEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public abstract class FDStepConditionEngine
extends FDVanillaEngine {
    protected StepCondition<Array> stepCondition;
    protected SampledCurve prices;
    protected TridiagonalOperator controlOperator;
    protected List<BoundaryCondition<TridiagonalOperator>> controlBCs = new ArrayList<BoundaryCondition<TridiagonalOperator>>();
    protected SampledCurve controlPrices;

    public FDStepConditionEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        super(process, timeSteps, gridPoints, timeDependent);
        this.controlPrices = new SampledCurve(gridPoints);
    }

    protected abstract void initializeStepCondition();

    @Override
    protected void calculate(Results r) {
        OneAssetOptionResults results = (OneAssetOptionResults)r;
        this.setGridLimits();
        this.initializeInitialCondition();
        this.initializeOperator();
        this.initializeBoundaryConditions();
        this.initializeStepCondition();
        ArrayList<TridiagonalOperator> operatorSet = new ArrayList<TridiagonalOperator>();
        List<Array> arraySet = new ArrayList<Array>();
        BoundaryConditionSet<BoundaryCondition<TridiagonalOperator>> bcSet = new BoundaryConditionSet<BoundaryCondition<TridiagonalOperator>>();
        StepConditionSet<Array> conditionSet = new StepConditionSet<Array>();
        this.prices = new SampledCurve(this.intrinsicValues);
        this.controlPrices = new SampledCurve(this.intrinsicValues);
        this.controlOperator = new TridiagonalOperator(this.finiteDifferenceOperator);
        this.controlBCs.add((BoundaryCondition<TridiagonalOperator>)this.bcS.get(0));
        this.controlBCs.add((BoundaryCondition<TridiagonalOperator>)this.bcS.get(1));
        operatorSet.add(this.finiteDifferenceOperator);
        operatorSet.add(this.controlOperator);
        arraySet.add(this.prices.values());
        arraySet.add(this.controlPrices.values());
        bcSet.push_back(this.bcS);
        bcSet.push_back(this.controlBCs);
        conditionSet.push_back(this.stepCondition);
        conditionSet.push_back(new NullCondition());
        StandardSystemFiniteDifferenceModel model = new StandardSystemFiniteDifferenceModel(operatorSet, bcSet);
        arraySet = model.rollback(arraySet, this.getResidualTime(), 0.0, this.timeSteps, conditionSet);
        this.prices.setValues(new Array(arraySet.get(0)));
        this.controlPrices.setValues(new Array(arraySet.get(1)));
        StrikedTypePayoff striked_payoff = (StrikedTypePayoff)this.payoff;
        if (striked_payoff == null) {
            throw new IllegalStateException("non-striked payoff given");
        }
        double variance = this.process.blackVolatility().getLink().blackVariance(this.exerciseDate, striked_payoff.strike());
        double dividendDiscount = this.process.dividendYield().getLink().discount(this.exerciseDate);
        double riskFreeDiscount = this.process.riskFreeRate().getLink().discount(this.exerciseDate);
        double spot = this.process.stateVariable().getLink().evaluate();
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(striked_payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        results.value = this.prices.valueAtCenter() - this.controlPrices.valueAtCenter() + black.value();
        results.delta = this.prices.firstDerivativeAtCenter() - this.controlPrices.firstDerivativeAtCenter() + black.delta(spot);
        results.gamma = this.prices.secondDerivativeAtCenter() - this.controlPrices.secondDerivativeAtCenter() + black.gamma(spot);
        results.addAdditionalResult("priceCurve", this.prices);
    }
}

