/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Array;

public class Matrix {
    double[][] data;
    int columns;
    int rows;

    public Matrix() {
        this.data = new double[0][0];
        this.columns = 0;
        this.rows = 0;
    }

    public Matrix(int pRows, int pColumns) {
        this.columns = pColumns;
        this.rows = pRows;
        this.data = new double[this.columns][this.rows];
    }

    public Matrix(int pRows, int pColumns, double value) {
        this.columns = pColumns;
        this.rows = pRows;
        this.data = new double[this.columns][this.rows];
        for (int i = 0; i < this.data.length; ++i) {
            if (i == 0) {
                for (int j = 0; j < this.data[i].length; ++j) {
                    this.data[i][j] = value;
                }
                continue;
            }
            System.arraycopy(this.data[i - 1], 0, this.data[i], 0, this.rows);
        }
    }

    public Matrix(Matrix m) {
        this.columns = m.columns;
        this.rows = m.rows;
        this.data = new double[this.columns][this.rows];
        for (int i = 0; i < this.data.length; ++i) {
            System.arraycopy(m.data[i], 0, this.data[i], 0, this.rows);
        }
    }

    public Matrix(double[][] A, int m, int n) {
        this.data = A;
        this.columns = m;
        this.rows = n;
    }

    public double get(int i, int j) {
        return this.data[i][j];
    }

    public void set(int i, int j, double value) {
        this.data[i][j] = value;
    }

    public Matrix operatorEquals(Matrix right) {
        Matrix left = this;
        if (left.columns != right.columns || left.rows != right.rows) {
            return null;
        }
        for (int i = 0; i < this.data.length; ++i) {
            System.arraycopy(right.data[i], 0, left.data[i], 0, this.rows);
        }
        return left;
    }

    public Matrix operatorPlusEqual(Matrix right) {
        if (this.columns != right.columns || this.rows != right.rows) {
            throw new RuntimeException("Rows and Columns must be the same for Matrix Addition.");
        }
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                double[] dArray = this.data[i];
                int n = j;
                dArray[n] = dArray[n] + right.data[i][j];
            }
        }
        return this;
    }

    public Matrix operatorMinusEqual(Matrix right) {
        if (this.columns != right.columns || this.rows != right.rows) {
            throw new RuntimeException("Rows and Columns must be the same for Matrix Addition.");
        }
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                double[] dArray = this.data[i];
                int n = j;
                dArray[n] = dArray[n] - right.data[i][j];
            }
        }
        return this;
    }

    public Matrix operatorMultiplyEqual(double d) {
        for (int i = 0; i < this.columns; ++i) {
            int j = 0;
            while (j < this.rows) {
                double[] dArray = this.data[i];
                int n = j++;
                dArray[n] = dArray[n] * d;
            }
        }
        return this;
    }

    public Matrix operatorDivideEqual(double d) {
        for (int i = 0; i < this.columns; ++i) {
            int j = 0;
            while (j < this.rows) {
                double[] dArray = this.data[i];
                int n = j++;
                dArray[n] = dArray[n] / d;
            }
        }
        return this;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public boolean empty() {
        return this.rows == 0 || this.columns == 0;
    }

    public void swap(Matrix right) {
        Matrix left = this;
        if (left.columns != right.columns || left.rows != right.rows) {
            return;
        }
        double[] da = new double[this.rows];
        for (int i = 0; i < this.data.length; ++i) {
            System.arraycopy(right.data[i], 0, da, 0, this.rows);
            System.arraycopy(left.data[i], 0, right.data[i], 0, this.rows);
            System.arraycopy(da, 0, left.data[i], 0, this.rows);
        }
    }

    public Matrix operatorPlus(Matrix left, Matrix right) {
        if (left.columns != right.columns || left.rows != right.rows) {
            throw new RuntimeException("right and left matrix must be the same size.");
        }
        Matrix result = new Matrix(left);
        result.operatorPlusEqual(right);
        return result;
    }

    public Matrix operatorMinus(Matrix left, Matrix right) {
        if (left.columns != right.columns || left.rows != right.rows) {
            throw new RuntimeException("right and left matrix must be the same size.");
        }
        Matrix result = new Matrix(left);
        result.operatorMinusEqual(right);
        return result;
    }

    public Matrix operatorMultiply(double scale, Matrix right) {
        Matrix result = new Matrix(right);
        result.operatorMultiplyEqual(scale);
        return result;
    }

    public Matrix operatorMultiply(Matrix left, double scale) {
        Matrix result = new Matrix(left);
        result.operatorMultiplyEqual(scale);
        return result;
    }

    public Matrix operatorDivide(Matrix numerator, double denominator) {
        Matrix result = new Matrix(numerator);
        result.operatorDivideEqual(denominator);
        return result;
    }

    public Array operatorMultiply(Array left, Matrix right) {
        if (left.size() != right.rows) {
            throw new RuntimeException("array size must equal matrix row count for multiplication");
        }
        Array result = new Array(right.columns);
        for (int i = 0; i < right.columns; ++i) {
            result.set(i, Array.dotProduct(left.getData(), right.data[i]));
        }
        return result;
    }

    public Array operatorMultiply(Matrix left, Array right) {
        Matrix newLeft = this.transpose(left);
        return this.operatorMultiply(right, newLeft);
    }

    public Matrix transpose(Matrix matrix) {
        Matrix transposed = new Matrix(matrix.columns, matrix.rows);
        for (int i = 0; i < matrix.data.length; ++i) {
            double[] ds = this.data[i];
            for (int j = 0; j < ds.length; ++j) {
                transposed.data[j][i] = ds[j];
            }
        }
        return transposed;
    }

    public Matrix operatorMultiply(Matrix left, Matrix right) {
        if (right.rows != left.columns) {
            throw new RuntimeException("Can't Multiply unless left.columns = right.rows");
        }
        Matrix result = new Matrix(right.columns, left.rows);
        for (int i = 0; i < left.rows; ++i) {
            double[] dtemp = new double[left.columns];
            for (int k = 0; k < left.columns; ++k) {
                dtemp[k] = left.data[k][i];
            }
            for (int j = 0; j < right.rows; ++j) {
                result.data[i][j] = Array.dotProduct(dtemp, right.data[j]);
            }
        }
        return result;
    }

    public Matrix outerProduct(Array v1, Array v2) {
        if (v1.size() != v2.size()) {
            throw new RuntimeException("Arrays must be the same size to do a cross product");
        }
        Matrix result = new Matrix(v1.size(), v2.size());
        for (int i = 0; i < v1.getData().length; ++i) {
            for (int j = 0; j < v2.getData().length; ++j) {
                result.data[i][j] = v1.getData()[i] * v2.getData()[j];
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[\n");
        for (int i = 0; i < this.rows; ++i) {
            sb.append("[");
            for (int j = 0; j < this.columns; ++j) {
                sb.append(this.get(j, i)).append("  , ");
            }
            sb.append("]\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    public double[][] getRawData() {
        return this.data;
    }
}

