/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Taiwan
extends DelegateCalendar {
    private static final Taiwan TSE_Calendar = new Taiwan(Market.TSE);

    private Taiwan(Market market) {
        TaiwanTSECalendar delegate;
        switch (market) {
            case TSE: {
                delegate = new TaiwanTSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Taiwan getCalendar(Market market) {
        switch (market) {
            case TSE: {
                return TSE_Calendar;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class TaiwanTSECalendar
    extends WesternCalendar {
        private TaiwanTSECalendar() {
        }

        @Override
        public String getName() {
            return "Taiwan stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            if (this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 28 && m == Month.FEBRUARY || d == 1 && m == Month.MAY && y != 2005 || d == 10 && m == Month.OCTOBER) {
                return false;
            }
            if (y == 2002 && (d >= 9 && d <= 17 && m == Month.FEBRUARY || d == 5 && m == Month.APRIL)) {
                return false;
            }
            if (y == 2003 && (d >= 31 && m == Month.JANUARY || d <= 5 && m == Month.FEBRUARY || d == 4 && m == Month.JUNE || d == 11 && m == Month.SEPTEMBER)) {
                return false;
            }
            if (y == 2004 && (d >= 21 && d <= 26 && m == Month.JANUARY || d == 22 && m == Month.JUNE || d == 28 && m == Month.SEPTEMBER)) {
                return false;
            }
            if (y == 2005 && (d >= 4 && d <= 13 && m == Month.FEBRUARY || d == 5 && m == Month.APRIL || d == 2 && m == Month.MAY)) {
                return false;
            }
            if (y == 2006 && (d >= 28 && m == Month.JANUARY || d <= 5 && m == Month.FEBRUARY || d == 5 && m == Month.APRIL || d == 31 && m == Month.MAY || d == 6 && m == Month.OCTOBER)) {
                return false;
            }
            if (y == 2007 && (d >= 17 && d <= 25 && m == Month.FEBRUARY || d == 5 && m == Month.APRIL || d == 6 && m == Month.APRIL || d == 18 && m == Month.JUNE || d == 19 && m == Month.JUNE || d == 24 && m == Month.SEPTEMBER || d == 25 && m == Month.SEPTEMBER)) {
                return false;
            }
            return y != 2008 || (d < 4 || d > 11 || m != Month.FEBRUARY) && (d != 4 || m != Month.APRIL);
        }
    }

    public static enum Market {
        TSE;

    }
}

