/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.examples;

import org.jquantlib.Configuration;
import org.jquantlib.instruments.Option;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.DateGenerationRule;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.StopClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertibleBonds {
    private static final Logger logger = LoggerFactory.getLogger(ConvertibleBonds.class);

    public ConvertibleBonds() {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        logger.info("\n\n::::: " + ConvertibleBonds.class.getSimpleName() + " :::::");
    }

    public void run() {
        StopClock clock = new StopClock();
        clock.startClock();
        Option.Type type = Option.Type.PUT;
        double underlying = 36.0;
        double spreadRate = 0.005;
        double dividendYield = 0.02;
        double riskFreeRate = 0.06;
        double volatility = 0.2;
        Integer settlementDays = 3;
        Integer length = 5;
        double redemption = 100.0;
        double conversionRatio = redemption / underlying;
        NullCalendar calendar = new NullCalendar();
        Date today = calendar.adjust(DateFactory.getFactory().getTodaysDate(), BusinessDayConvention.FOLLOWING);
        Configuration.getSystemConfiguration(null).getGlobalSettings().setEvaluationDate(today);
        Date settlementDate = calendar.advance(today, settlementDays, TimeUnit.DAYS);
        Date exerciseDate = calendar.advance(settlementDate, length, TimeUnit.YEARS);
        Date issueDate = calendar.advance(exerciseDate, -length.intValue(), TimeUnit.YEARS);
        BusinessDayConvention convention = BusinessDayConvention.MODIFIED_FOLLOWING;
        Frequency frequency = Frequency.ANNUAL;
        Schedule schedule = new Schedule(issueDate, exerciseDate, new Period(frequency), calendar, convention, convention, DateGenerationRule.BACKWARD, false, Date.NULL_DATE, Date.NULL_DATE);
        clock.stopClock();
        clock.log();
    }

    public static void main(String[] args) {
        new ConvertibleBonds().run();
    }
}

