;; Example 3-6  Planetary System

(use gl)
(use gl.glut)

(define *year* 0)
(define *day* 0)

(define (init)
  (gl-clear-color 0.0 0.0 0.0 0.0)
  (gl-shade-model GL_FLAT)
  )

(define (disp)
  (gl-clear GL_COLOR_BUFFER_BIT)
  (gl-color '#f32(1.0 1.0 1.0))

  (gl-push-matrix)
  (glut-wire-sphere 1.0 20 16)          ;sun
  (gl-rotate *year* 0.0 1.0 0.0)
  (gl-translate 2.0 0.0 0.0)
  (gl-rotate *day* 0.0 1.0 0.0)
  (glut-wire-sphere 0.2 10 8)           ;planet
  (gl-pop-matrix)
  (glut-swap-buffers)
  )

(define (reshape w h)
  (gl-viewport 0 0 w h)
  (gl-matrix-mode GL_PROJECTION)
  (gl-load-identity)
  (glu-perspective 60.0 (/ w h) 1.0 20.0)
  (gl-matrix-mode GL_MODELVIEW)
  (gl-load-identity)
  (glu-look-at 0.0 0.0 5.0 0.0 0.0 0.0 0.0 1.0 0.0)
  )

(define (keyboard key x y)
  (cond ((= key (char->integer #\d))
         (set! *day* (modulo (+ *day* 10) 360))
         (glut-post-redisplay))
        ((= key (char->integer #\D))
         (set! *day* (modulo (- *day* 10) 360))
         (glut-post-redisplay))
        ((= key (char->integer #\y))
         (set! *year* (modulo (+ *year* 5) 360))
         (glut-post-redisplay))
        ((= key (char->integer #\Y))
         (set! *year* (modulo (- *year* 5) 360))
         (glut-post-redisplay))
        ((= key 27) (exit 0))
        ))

(define (main args)
  (glut-init args)
  (glut-init-display-mode (logior GLUT_DOUBLE GLUT_RGB))
  (glut-init-window-size 500 500)
  (glut-init-window-position 100 100)
  (glut-create-window *program-name*)
  (init)
  (glut-display-func disp)
  (glut-reshape-func reshape)
  (glut-keyboard-func keyboard)
  (glut-main-loop)
  0)
