/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.MicroLayouts;
import javax.swing.UIDefaults;

public final class MicroLayoutPolicies {
    private MicroLayoutPolicies() {
    }

    public static MicroLayoutPolicy getDefaultPlasticPolicy() {
        return new DefaultPlasticPolicy();
    }

    public static MicroLayoutPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    private static final class DefaultPlasticPolicy
    implements MicroLayoutPolicy {
        private DefaultPlasticPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean isClassic = !SystemUtils.IS_LAF_WINDOWS_XP_ENABLED;
            boolean is6OrLater = SystemUtils.IS_OS_WINDOWS_6_OR_LATER;
            boolean isLowRes = SystemUtils.IS_LOW_RESOLUTION;
            boolean isPlasticXP = lafName.equals("JGoodies Plastic XP");
            if (isPlasticXP) {
                if (is6OrLater) {
                    return isClassic ? MicroLayouts.createPlasticXPVistaClassicMicroLayout() : MicroLayouts.createPlasticXPVistaMicroLayout();
                }
                return isLowRes ? MicroLayouts.createPlasticXPLowResMicroLayout() : MicroLayouts.createPlasticXPHiResMicroLayout();
            }
            if (is6OrLater) {
                return isClassic ? MicroLayouts.createPlasticVistaClassicMicroLayout() : MicroLayouts.createPlasticVistaMicroLayout();
            }
            return isLowRes ? MicroLayouts.createPlasticLowResMicroLayout() : MicroLayouts.createPlasticHiResMicroLayout();
        }
    }

    private static final class DefaultWindowsPolicy
    implements MicroLayoutPolicy {
        private DefaultWindowsPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean isClassic = !SystemUtils.IS_LAF_WINDOWS_XP_ENABLED;
            boolean isVista = SystemUtils.IS_OS_WINDOWS_6_OR_LATER;
            boolean isLowRes = SystemUtils.IS_LOW_RESOLUTION;
            if (isClassic) {
                return isLowRes ? MicroLayouts.createWindowsClassicLowResMicroLayout() : MicroLayouts.createWindowsClassicHiResMicroLayout();
            }
            if (isVista) {
                return isLowRes ? MicroLayouts.createWindowsVistaLowResMicroLayout() : MicroLayouts.createWindowsVistaHiResMicroLayout();
            }
            return isLowRes ? MicroLayouts.createWindowsXPLowResMicroLayout() : MicroLayouts.createWindowsXPHiResMicroLayout();
        }
    }
}

