/*
 * Decompiled with CFR 0.152.
 */
package util.ui.persona;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import tvbrowser.core.Settings;
import util.ui.UiUtilities;
import util.ui.persona.PersonaBackgroundPanel;
import util.ui.persona.PersonaInfo;
import util.ui.persona.PersonaListener;

public final class Persona {
    private static Persona mInstance;
    private HashMap<String, PersonaInfo> mPersonaMap;
    private static final String PERSONA_DIR = "personas";
    private static final int mBorderWidth = 9;
    private static final int mBorderHeight = 4;
    private String mDetailURL;
    private String mId;
    private String mName;
    private String mDescription;
    private BufferedImage mHeaderImage;
    private BufferedImage mFooterImage;
    private Color mTextColor;
    private Color mShadowColor;
    private Color mAccentColor;
    public static final String NAME_KEY = "name";
    public static final String DESCRIPTION_KEY = "description";
    public static final String HEADER_IMAGE_KEY = "headerImage";
    public static final String FOOTER_IMAGE_KEY = "footerImage";
    public static final String TEXT_COLOR_KEY = "textColor";
    public static final String SHADOW_COLOR_KEY = "shadowColor";
    public static final String ACCENT_COLOR_KEY = "accentColor";
    public static final String DETAIL_URL_KEY = "detailURL";
    public static final String USER_PERSONA = "{user.persona}";
    public static final String TVB_PERSONA = "{tvb.persona}";
    private ArrayList<PersonaListener> mPersonaListenerList;

    private Persona() {
        mInstance = this;
        this.mPersonaMap = new HashMap(1);
        this.mPersonaListenerList = new ArrayList();
        this.loadPersonas();
        this.applyPersona();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPersonaListener(PersonaListener listener) {
        ArrayList<PersonaListener> arrayList = this.mPersonaListenerList;
        synchronized (arrayList) {
            this.mPersonaListenerList.add(listener);
        }
    }

    @Deprecated(since="3.3.4")
    public void removePersonaListerner(PersonaListener listener) {
        this.removePersonaListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersonaListener(PersonaListener listener) {
        ArrayList<PersonaListener> arrayList = this.mPersonaListenerList;
        synchronized (arrayList) {
            this.mPersonaListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPersona() {
        String id = Settings.LookAndFeel.PERSONA_SELECTED.getString();
        if (Settings.LookAndFeel.PERSONA_RANDOM.getBoolean() && this.mPersonaMap.size() > 2) {
            PersonaInfo[] installedPersonas = this.getInstalledPersonas();
            int index = 0;
            while (installedPersonas[index = (int)(Math.random() * (double)installedPersonas.length)].getId().equals("51b73c81-7d61-4626-b230-89627c9f5ce7") || installedPersonas[index].getId().equals("eb365437-e702-4c05-98c2-db5834bb4fa3")) {
            }
            id = installedPersonas[index].getId();
        }
        try {
            PersonaInfo personaInfo = this.mPersonaMap.get(id);
            if (personaInfo == null) {
                Settings.LookAndFeel.PERSONA_SELECTED.setString(new PersonaInfo().getId());
                personaInfo = this.mPersonaMap.get(Settings.LookAndFeel.PERSONA_SELECTED.getString());
            }
            if (personaInfo != null) {
                this.mId = personaInfo.getId();
                this.mName = personaInfo.getName();
                this.mDescription = personaInfo.getDescription();
                this.mHeaderImage = personaInfo.getHeaderImage();
                this.mFooterImage = personaInfo.getFooterImage();
                this.mTextColor = personaInfo.getTextColor();
                this.mShadowColor = personaInfo.getShadowColor();
                this.mAccentColor = personaInfo.getAccentColor();
                this.mDetailURL = personaInfo.getDetailURL();
            } else {
                this.mId = "DUMMY";
                this.mName = "Standard";
                this.mDescription = "Standard";
                this.mHeaderImage = null;
                this.mFooterImage = null;
                this.mTextColor = null;
                this.mShadowColor = null;
                this.mAccentColor = null;
                this.mDetailURL = "https://www.tvbrowser.org";
            }
            ArrayList<PersonaListener> arrayList = this.mPersonaListenerList;
            synchronized (arrayList) {
                for (PersonaListener listener : this.mPersonaListenerList) {
                    listener.updatePersona();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void loadPersonas() {
        try {
            this.mPersonaMap.clear();
            PersonaInfo defaultInfo = new PersonaInfo();
            this.mPersonaMap.put(defaultInfo.getId(), defaultInfo);
            defaultInfo = new PersonaInfo(true);
            this.mPersonaMap.put(defaultInfo.getId(), defaultInfo);
            this.checkDir(new File(PERSONA_DIR));
            this.checkDir(new File(Settings.getUserSettingsDirName(), PERSONA_DIR));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void checkDir(File parentDir) {
        if (parentDir.isDirectory()) {
            File[] dirs;
            for (File dir : dirs = parentDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                File test = new File(dir.getAbsolutePath(), "persona.prop");
                if (!test.isFile()) continue;
                try {
                    PersonaInfo info = new PersonaInfo(test);
                    this.mPersonaMap.put(dir.getAbsoluteFile().getName(), info);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public static Persona getInstance() {
        if (mInstance == null) {
            new Persona();
        }
        return mInstance;
    }

    public BufferedImage getHeaderImage() {
        return this.mHeaderImage;
    }

    public BufferedImage getFooterImage() {
        return this.mFooterImage;
    }

    public Color getTextColor() {
        return this.mTextColor;
    }

    public Color getShadowColor() {
        return this.mShadowColor;
    }

    public Color getAccentColor() {
        return this.mAccentColor;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getDetailURL() {
        return this.mDetailURL;
    }

    public JMenu createPersonaMenu() {
        PersonaMenu menu = new PersonaMenu();
        menu.updatePersona();
        return menu;
    }

    public PersonaInfo[] getInstalledPersonas() {
        PersonaInfo[] installedPersonas = this.mPersonaMap.values().toArray(new PersonaInfo[this.mPersonaMap.size()]);
        Arrays.sort(installedPersonas, new Comparator<PersonaInfo>(){

            @Override
            public int compare(PersonaInfo o1, PersonaInfo o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return installedPersonas;
    }

    public void updatePersona(String id) {
        PersonaInfo info;
        if (id != null && (info = this.mPersonaMap.get(id)) != null && info.isEditable()) {
            info.load();
            if (id.equals(this.mId)) {
                this.applyPersona();
            }
        }
    }

    public String getId() {
        return this.mId;
    }

    public static File getUserPersonaDir() {
        return new File(Settings.getUserSettingsDirName(), PERSONA_DIR);
    }

    public PersonaInfo getPersonaInfo(String id) {
        return this.mPersonaMap.get(id);
    }

    public void activatePersona(PersonaInfo info) {
        if (info != null && this.mPersonaMap.get(info.getId()) != null) {
            if (!info.getId().equals("eb365437-e702-4c05-98c2-db5834bb4fa3")) {
                Settings.LookAndFeel.PERSONA_SELECTED.setString(info.getId());
                Settings.LookAndFeel.PERSONA_RANDOM.setBoolean(false);
            } else {
                Settings.LookAndFeel.PERSONA_RANDOM.setBoolean(true);
            }
            this.applyPersona();
        }
    }

    public boolean removePersona(PersonaInfo info) {
        if (!(info == null || info.isSelectedPersona() || info.getId().equals("51b73c81-7d61-4626-b230-89627c9f5ce7") || info.getId().equals("eb365437-e702-4c05-98c2-db5834bb4fa3"))) {
            return this.mPersonaMap.remove(info.getId()) != null;
        }
        return false;
    }

    public static void paintButton(Graphics g, JButton b) {
        Color c = Persona.testPersonaForegroundAgainst(Persona.getInstance().getAccentColor());
        Color textColor = Persona.getInstance().getTextColor();
        int alpha = c.getAlpha();
        if ((b.getModel().isArmed() || b.getModel().isRollover() || b.isFocusOwner()) && UiUtilities.isBrightnessSimilarForColors(c = UIManager.getColor("List.selectionBackground"), textColor, 84)) {
            textColor = UIManager.getColor("List.selectionForeground");
        }
        if (b.getModel().isPressed()) {
            alpha -= 50;
        } else if (b.isFocusOwner() && !b.getModel().isRollover()) {
            alpha -= 100;
        }
        g.setColor(Persona.getInstance().getTextColor());
        g.draw3DRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, !b.getModel().isPressed());
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
        g.fillRect(1, 1, b.getWidth() - 2, b.getHeight() - 2);
        Icon icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        FontMetrics metrics = g.getFontMetrics(b.getFont());
        int textWidth = metrics.stringWidth(b.getText());
        int baseLine = b.getHeight() / 2 + metrics.getMaxDescent() + 1;
        int iconTextLength = (icon != null ? icon.getIconWidth() + b.getIconTextGap() : 0) + textWidth;
        int iconX = b.getWidth() / 2 - iconTextLength / 2;
        if (icon != null) {
            int iconY = b.getHeight() / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(b, g, iconX, iconY);
            iconX = iconX + icon.getIconWidth() + b.getIconTextGap();
        }
        if (!b.isEnabled()) {
            textColor = Color.lightGray;
        }
        if (!Persona.getInstance().getShadowColor().equals(textColor) && Persona.getInstance().getTextColor().equals(textColor)) {
            g.setColor(Persona.getInstance().getShadowColor());
            g.drawString(b.getText(), iconX + 1, baseLine + 1);
        }
        g.setColor(textColor);
        g.drawString(b.getText(), iconX, baseLine);
    }

    public static Color testPersonaForegroundAgainst(Color c) {
        int test = UiUtilities.getBrightnessValueForColor(Persona.getInstance().getTextColor());
        int alpha = 100;
        if (test <= 12) {
            c = Color.white;
            alpha = 200;
        } else if (test <= 16) {
            c = c.brighter().brighter().brighter().brighter().brighter().brighter();
            alpha = 200;
        } else if (test <= 24) {
            c = c.brighter().brighter().brighter();
            alpha = 160;
        } else if (test <= 39) {
            c = c.brighter().brighter();
            alpha = 140;
        } else if (test <= 57) {
            alpha = 120;
        } else if (test <= 67) {
            c = c.darker();
            alpha = 120;
        } else if (test <= 80) {
            c = c.darker().darker();
            alpha = 120;
        } else if (test <= 86) {
            c = c.darker().darker().darker();
            alpha = 100;
        } else if (test <= 92) {
            c = c.darker().darker().darker().darker();
            alpha = 100;
        } else {
            c = Color.black;
            alpha = 100;
        }
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        return c;
    }

    public static JPanel createPersonaBackgroundPanel() {
        return new PersonaBackgroundPanel();
    }

    public static JButton createPersonaButton(String text) {
        return Persona.createPersonaButton(text, null);
    }

    public static JButton createPersonaButton(String text, Icon icon) {
        JButton button = new JButton(text, icon){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
                    Persona.paintButton(g, this);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        if (button != null && Persona.getInstance().getHeaderImage() != null) {
            button.setBorder(BorderFactory.createEmptyBorder(4, 9, 4, 9));
            button.setRolloverEnabled(true);
            button.setOpaque(false);
        }
        return button;
    }

    public static Border getPersonaButtonBorder() {
        return BorderFactory.createEmptyBorder(4, 9, 4, 9);
    }

    private static class PersonaMenu
    extends JMenu
    implements PersonaListener {
        private static boolean mOriginalOpaqueState;
        private static Color mOriginalBackgroundColor;

        public PersonaMenu() {
            Persona.getInstance().registerPersonaListener(this);
            mOriginalOpaqueState = this.isOpaque();
            mOriginalBackgroundColor = this.getBackground();
        }

        @Override
        protected void fireStateChanged() {
            if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
                this.setBackground(new Color(0, 0, 0, 0));
                ButtonModel m = this.getModel();
                if (m.isPressed() && m.isArmed()) {
                    this.setOpaque(true);
                } else if (m.isSelected()) {
                    this.setOpaque(true);
                } else if (this.isRolloverEnabled() && m.isRollover()) {
                    this.setOpaque(true);
                } else {
                    this.setOpaque(false);
                }
            }
            super.fireStateChanged();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
                if (this.isOpaque()) {
                    g.setColor(UIManager.getColor("List.selectionBackground"));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                FontMetrics metrics = g.getFontMetrics(this.getFont());
                int textWidth = metrics.stringWidth(this.getText());
                int x = this.getWidth() / 2 - textWidth / 2;
                int y = this.getHeight() - metrics.getDescent() - this.getInsets().bottom;
                int mnemonicIndex = this.getText().toUpperCase().indexOf(KeyEvent.getKeyText(this.getMnemonic()));
                String test = this.getText().substring(0, mnemonicIndex + 1);
                int mnemonicWidth = metrics.stringWidth(KeyEvent.getKeyText(this.getMnemonic()));
                int start = metrics.stringWidth(test) - mnemonicWidth;
                if (!Persona.getInstance().getShadowColor().equals(Persona.getInstance().getTextColor()) && !this.isOpaque()) {
                    g.setColor(Persona.getInstance().getShadowColor());
                    g.drawString(this.getText(), x + 1, y + 1);
                    g.drawString(this.getText(), x + 2, y + 2);
                    g.drawLine(x + start + 1, y + 2, x + start + mnemonicWidth, y + 2);
                    g.drawLine(x + start + 1, y + 3, x + start + mnemonicWidth, y + 3);
                }
                if (!this.isOpaque()) {
                    g.setColor(Persona.getInstance().getTextColor());
                } else {
                    g.setColor(UIManager.getColor("List.selectionForeground"));
                }
                g.drawString(this.getText(), x, y);
                g.drawLine(x + start, y + 1, x + start + mnemonicWidth - 1, y + 1);
            } else {
                super.paintComponent(g);
            }
        }

        @Override
        public void updatePersona() {
            if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
                this.setBackground(new Color(0, 0, 0, 0));
                this.setOpaque(false);
            } else {
                this.setBackground(mOriginalBackgroundColor);
                this.setOpaque(mOriginalOpaqueState);
            }
        }
    }
}

