/*
 * Decompiled with CFR 0.152.
 */
package util.ui.login;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class LoginDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(LoginDialog.class);
    private int mReturnValue = 2;
    private String mUsername;
    private String mPassword;
    private boolean mStore;
    private JTextField mNameField;
    private JPasswordField mPasswordField;
    private JCheckBox mStorePassword;

    public LoginDialog(Window owner, String username, String password, boolean storePassword) {
        super(owner);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.mUsername = username;
        this.mPassword = password;
        this.mStore = storePassword;
        this.createGui();
    }

    private void createGui() {
        this.setTitle(mLocalizer.msg("login", "Login"));
        UiUtilities.registerForClosing(this);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout((LayoutManager)new FormLayout("5dlu, pref, 3dlu, fill:100dlu:grow(0.5), pref, 5dlu", "30dlu, 5dlu, pref, 3dlu, pref, 3dlu, pref, fill:pref:grow, pref, 5dlu"));
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel((LayoutManager)new FormLayout("7dlu, pref, fill:pref:grow", "7dlu, center:21dlu, 2dlu, 1px"));
        panel.setOpaque(true);
        panel.setBackground(Color.WHITE);
        panel.setForeground(Color.BLACK);
        JLabel top = new JLabel(mLocalizer.msg("title", "Login"));
        top.setFont(top.getFont().deriveFont(1, 20.0f));
        panel.add((Component)top, cc.xy(2, 2));
        JPanel black = new JPanel();
        black.setBackground(Color.BLACK);
        panel.add((Component)black, cc.xyw(1, 4, 3));
        content.add((Component)panel, cc.xyw(1, 1, 6));
        JLabel name = new JLabel(mLocalizer.msg("user", "Username") + ":");
        content.add((Component)name, cc.xy(2, 3));
        this.mNameField = new JTextField();
        content.add((Component)this.mNameField, cc.xy(4, 3));
        this.mNameField.setText(this.mUsername);
        JLabel password = new JLabel(mLocalizer.msg("password", "Password") + ":");
        content.add((Component)password, cc.xy(2, 5));
        this.mPasswordField = new JPasswordField();
        content.add((Component)this.mPasswordField, cc.xy(4, 5));
        this.mPasswordField.setText(this.mPassword);
        this.mStorePassword = new JCheckBox(mLocalizer.msg("storePassword", "Store Password"));
        content.add((Component)this.mStorePassword, cc.xy(4, 7));
        this.mStorePassword.setSelected(this.mStore);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> {
            this.mReturnValue = 0;
            this.setVisible(false);
        });
        this.getRootPane().setDefaultButton(ok);
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(e -> this.close());
        builder.addButton((JComponent[])new JButton[]{ok, cancel});
        content.add((Component)builder.getPanel(), cc.xyw(1, 9, 5));
        this.setSize(Sizes.dialogUnitXAsPixel((int)200, (Component)this), Sizes.dialogUnitYAsPixel((int)140, (Component)this));
    }

    @Override
    public void close() {
        this.mReturnValue = 2;
        this.setVisible(false);
    }

    public int askLogin() {
        UiUtilities.centerAndShow(this);
        return this.mReturnValue;
    }

    public String getUsername() {
        return this.mNameField.getText();
    }

    public String getPassword() {
        return new String(this.mPasswordField.getPassword());
    }

    public boolean storePasswords() {
        return this.mStorePassword.isSelected();
    }
}

