/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import util.ui.UiUtilities;

public class SingleAndDoubleClickTreeUI
extends BasicTreeUI
implements MouseListener {
    public static final int EXPAND_AND_COLLAPSE = 0;
    public static final int AUTO_COLLAPSE_EXPAND = 1;
    private static final int CLICK_WAIT_TIME = 150;
    private Thread mClickedThread;
    private long mMousePressedTime;
    private boolean mWasExpanded;
    private TreePath mLastSelectionPath;
    private int mType;
    private Icon mCollapsedIcon;
    private Icon mExpandedIcon;

    public SingleAndDoubleClickTreeUI(int type, TreePath selectedPath) {
        this.mType = type;
        this.mLastSelectionPath = selectedPath;
        if (UiUtilities.isGTKLookAndFeel()) {
            this.mCollapsedIcon = new Icon(){

                @Override
                public int getIconHeight() {
                    return 6;
                }

                @Override
                public int getIconWidth() {
                    return 6;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int[] xPoints = new int[]{x + 1, x + 1, x + 6};
                    int[] yPoints = new int[]{y, y + 6, y + 3};
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.gray);
                    g.fillPolygon(xPoints, yPoints, 3);
                    g.setColor(Color.darkGray);
                    g.drawPolygon(xPoints, yPoints, 3);
                }
            };
            this.mExpandedIcon = new Icon(){

                @Override
                public int getIconHeight() {
                    return 5;
                }

                @Override
                public int getIconWidth() {
                    return 7;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int[] xPoints = new int[]{x + 1, x + 4, x + 7};
                    int[] yPoints = new int[]{y, y + 5, y};
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.gray);
                    g.fillPolygon(xPoints, yPoints, 3);
                    g.setColor(Color.darkGray);
                    g.drawPolygon(xPoints, yPoints, 3);
                }
            };
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return this;
    }

    public void setLastSelectedPath(TreePath path) {
        this.mLastSelectionPath = path;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isConsumed()) {
            TreePath path;
            if (!this.tree.isFocusOwner()) {
                this.tree.requestFocusInWindow();
            }
            if ((path = this.getClosestPathForLocation(this.tree, e.getX(), e.getY())) != null && this.getPathBounds(this.tree, path).contains(e.getPoint())) {
                this.tree.setSelectionPath(path);
            }
            this.mMousePressedTime = e.getWhen();
            this.checkForClickInExpandControl(this.getClosestPathForLocation(this.tree, e.getX(), e.getY()), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed()) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                final TreePath path = this.getClosestPathForLocation(this.tree, e.getX(), e.getY());
                if (path != null && !((DefaultMutableTreeNode)path.getLastPathComponent()).isLeaf() && (this.mType == 0 && e.getWhen() - this.mMousePressedTime < 150L || this.mType != 0) && this.getPathBounds(this.tree, path).contains(e.getPoint())) {
                    if (this.mClickedThread == null || !this.mClickedThread.isAlive()) {
                        this.mClickedThread = new Thread("Single click tree UI double click"){

                            @Override
                            public void run() {
                                if (!SingleAndDoubleClickTreeUI.this.tree.isExpanded(path)) {
                                    SingleAndDoubleClickTreeUI.this.tree.expandPath(path);
                                    SingleAndDoubleClickTreeUI.this.mWasExpanded = true;
                                    if (SingleAndDoubleClickTreeUI.this.mType == 1 && SingleAndDoubleClickTreeUI.this.mLastSelectionPath != null && !SingleAndDoubleClickTreeUI.this.mLastSelectionPath.isDescendant(path) && !path.isDescendant(SingleAndDoubleClickTreeUI.this.mLastSelectionPath)) {
                                        SingleAndDoubleClickTreeUI.this.tree.collapsePath(SingleAndDoubleClickTreeUI.this.mLastSelectionPath);
                                    }
                                } else if (SingleAndDoubleClickTreeUI.this.mLastSelectionPath != null && SingleAndDoubleClickTreeUI.this.tree.getSelectionPath().equals(SingleAndDoubleClickTreeUI.this.mLastSelectionPath)) {
                                    SingleAndDoubleClickTreeUI.this.tree.collapsePath(path);
                                    SingleAndDoubleClickTreeUI.this.mWasExpanded = false;
                                }
                                SingleAndDoubleClickTreeUI.this.tree.setSelectionPath(path);
                                SingleAndDoubleClickTreeUI.this.mLastSelectionPath = path;
                                try {
                                    Thread.sleep(300L);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                SingleAndDoubleClickTreeUI.this.mWasExpanded = false;
                            }
                        };
                        this.mClickedThread.start();
                    } else if (!this.mWasExpanded && this.mLastSelectionPath != null && this.tree.getSelectionPath().equals(this.mLastSelectionPath)) {
                        this.tree.collapsePath(path);
                    }
                } else {
                    this.mLastSelectionPath = path;
                }
            }
            e.consume();
        }
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        if (!UiUtilities.isGTKLookAndFeel()) {
            super.paintHorizontalLine(g, c, y, left, right);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (!UiUtilities.isGTKLookAndFeel()) {
            super.paintVerticalLine(g, c, x, top, bottom);
        }
    }

    @Override
    public Icon getCollapsedIcon() {
        return this.mCollapsedIcon != null ? this.mCollapsedIcon : super.getCollapsedIcon();
    }

    @Override
    public Icon getExpandedIcon() {
        return this.mExpandedIcon != null ? this.mExpandedIcon : super.getExpandedIcon();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

