/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.core.Settings;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SendToPluginDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(SendToPluginDialog.class);
    private Program[] mPrograms;
    private JComboBox<ProgramReceiveIf> mPluginList;
    private JComboBox<ProgramReceiveTarget> mTargetList;
    private ProgramReceiveIf mCaller;
    private ProgramReceiveTarget mCallerTarget;
    private JRadioButton mTypeAdd;
    private JRadioButton mTypeRemove;
    private int mSendType;

    public SendToPluginDialog(ProgramReceiveIf caller, Window owner, Program[] prg) {
        this(caller, null, owner, prg);
    }

    public SendToPluginDialog(ProgramReceiveIf caller, ProgramReceiveTarget callerTarget, Window owner, Program[] prg) {
        super(owner);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.mPrograms = prg;
        this.mCaller = caller;
        this.mCallerTarget = callerTarget;
        this.createDialog(owner);
    }

    private void createDialog(Window parent) {
        this.setTitle(LOCALIZER.msg("title", "Send to other Plugin"));
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,0dlu:grow,5dlu"));
        pb.border(Borders.DIALOG);
        pb.addSeparatorRowFull(false, LOCALIZER.msg("sendTo", "Send {0} programs to", this.mPrograms.length));
        this.mSendType = 0;
        this.mTypeAdd = new JRadioButton(LOCALIZER.msg("add", "Add"), true);
        this.mTypeAdd.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.mSendType = 1;
            }
        });
        this.mTypeRemove = new JRadioButton(LOCALIZER.msg("remove", "Remove"));
        this.mTypeRemove.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.mSendType = 2;
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mTypeAdd);
        bg.add(this.mTypeRemove);
        EnhancedPanelBuilder sending = new EnhancedPanelBuilder(new FormLayout("5dlu,0dlu:grow,5dlu"));
        sending.addSeparatorRowFull(LOCALIZER.msg("type", "Type of sending"));
        sending.addRow(this.mTypeAdd, 2);
        sending.addRow(false, (Component)this.mTypeRemove, 2);
        JPanel sendingPanel = sending.getPanel();
        ProgramReceiveIf[] installedPluginArr = Plugin.getPluginManager().getReceiveIfs(this.mCaller, this.mCallerTarget);
        Arrays.sort(installedPluginArr, new ObjectComparator());
        this.mPluginList = new JComboBox<ProgramReceiveIf>(installedPluginArr);
        pb.addRow(this.mPluginList, 2);
        pb.addSeparatorRowFull(LOCALIZER.msg("target", "Target:"));
        this.mTargetList = new JComboBox<ProgramReceiveTarget>(installedPluginArr[0].getProgramReceiveTargets());
        this.mTargetList.addItemListener(e -> {
            int eventType = ((ProgramReceiveTarget)e.getItem()).getSupportedEventType();
            if (e.getStateChange() == 1) {
                sendingPanel.setVisible(eventType == 3);
            } else {
                this.mSendType = eventType;
            }
        });
        pb.addRow(this.mTargetList, 2);
        pb.addRowFull(false, (Component)sendingPanel);
        sendingPanel.setVisible(installedPluginArr[0].canReceiveProgramsWithTarget() && this.mTargetList.getItemCount() > 1);
        this.mTargetList.setEnabled(installedPluginArr[0].canReceiveProgramsWithTarget() && this.mTargetList.getItemCount() > 1);
        this.mPluginList.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.mSendType = 0;
                ProgramReceiveTarget[] targets = ((ProgramReceiveIf)e.getItem()).getProgramReceiveTargets();
                this.mTargetList.removeAllItems();
                if (((ProgramReceiveIf)e.getItem()).canReceiveProgramsWithTarget()) {
                    for (ProgramReceiveTarget target : targets) {
                        if (target.equals(this.mCallerTarget)) continue;
                        this.mTargetList.addItem(target);
                    }
                    this.mTargetList.setEnabled(targets.length > 1);
                    if (this.mTargetList.getModel().getSize() > 0) {
                        sendingPanel.setVisible(((ProgramReceiveTarget)this.mTargetList.getModel().getElementAt(0)).getSupportedEventType() == 3);
                    }
                    if (sendingPanel.isVisible()) {
                        this.mTypeAdd.setSelected(true);
                        this.mSendType = 1;
                    } else {
                        this.mSendType = targets[0].getSupportedEventType();
                    }
                } else if (targets != null && targets.length > 0) {
                    this.mTargetList.addItem(targets[0]);
                    this.mTargetList.setEnabled(false);
                }
                this.mTargetList.repaint();
            }
        });
        String lastUsedPlugin = Settings.Plugins.RECEIVE_PLUGIN_USED_LAST.getString();
        if (lastUsedPlugin != null) {
            for (ProgramReceiveIf programReceiveIf : installedPluginArr) {
                if (!programReceiveIf.getId().equals(lastUsedPlugin)) continue;
                this.mPluginList.setSelectedItem(programReceiveIf);
                String lastUsedTarget = Settings.Plugins.RECEIVE_TARGET_USED_LAST.getString();
                if (lastUsedTarget == null) continue;
                for (ProgramReceiveTarget target : programReceiveIf.getProgramReceiveTargets()) {
                    if (!target.getTargetId().equals(lastUsedTarget)) continue;
                    this.mTargetList.setSelectedItem(lastUsedTarget);
                }
            }
        }
        JButton sendButton = new JButton(LOCALIZER.msg("send", "Send"));
        sendButton.addActionListener(evt -> {
            this.send();
            this.setVisible(false);
        });
        sendButton.setEnabled(this.mPrograms.length > 0);
        JButton cancelButton = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancelButton.addActionListener(e -> this.setVisible(false));
        ButtonBarBuilder buttonBuilder = new ButtonBarBuilder();
        buttonBuilder.addGlue();
        buttonBuilder.addButton((JComponent[])new JButton[]{sendButton, cancelButton});
        pb.addRowFull("fill:10dlu:grow,default", (Component)buttonBuilder.getPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)pb.getPanel(), "Center");
        Settings.layoutWindow("util.sendToDialog", this, new Dimension(Sizes.dialogUnitXAsPixel((int)220, (Component)this), Sizes.dialogUnitYAsPixel((int)125, (Component)this)), parent);
        UiUtilities.registerForClosing(this);
        this.getRootPane().setDefaultButton(sendButton);
    }

    protected void send() {
        int result = 0;
        ProgramReceiveIf plug = (ProgramReceiveIf)this.mPluginList.getSelectedItem();
        if (this.mPrograms.length > 5) {
            result = JOptionPane.showConfirmDialog(this, LOCALIZER.msg("AskBeforeSend", "Are you really sure to send {0} programs\nto \"{1}\"?", this.mPrograms.length, plug.toString()), LOCALIZER.msg("Attention", "Attention"), 0, 2);
        }
        if (result == 0) {
            ProgramReceiveTarget target = (ProgramReceiveTarget)this.mTargetList.getSelectedItem();
            plug.receivePrograms(this.mSendType, this.mPrograms, target);
            Settings.Plugins.RECEIVE_PLUGIN_USED_LAST.setString(plug.getId());
            Settings.Plugins.RECEIVE_TARGET_USED_LAST.setString(target.getTargetId());
        }
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    private static class ObjectComparator
    implements Comparator<ProgramReceiveIf> {
        private ObjectComparator() {
        }

        @Override
        public int compare(ProgramReceiveIf o1, ProgramReceiveIf o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

