/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.Borders;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.WindowClosingIf;

public class OkayCancelDialog
extends JDialog
implements WindowClosingIf {
    private JButton mOk;
    private boolean mOkWasPressed;

    public OkayCancelDialog(Window parent, String title, JComponent message, String help, boolean okayEnabled) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(title);
        this.mOkWasPressed = false;
        this.mOk = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOk.setEnabled(okayEnabled);
        this.mOk.addActionListener(e -> {
            this.mOkWasPressed = true;
            this.close();
        });
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(e -> this.close());
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder("100dlu:grow,default,5dlu,default");
        pb.border(Borders.DIALOG);
        if (help != null && !help.isBlank()) {
            pb.addLabelRowFull(false, "<html>" + help + "</html>");
        }
        pb.addRowFull("fill:10dlu:grow", (Component)message);
        pb.addRowFull(new JSeparator(0));
        pb.addRow(cancel, 2);
        pb.add(this.mOk, 4);
        this.setContentPane(pb.getPanel());
        this.getRootPane().setDefaultButton(this.mOk);
        this.setDefaultCloseOperation(2);
    }

    public void setOkayEnabled(boolean enabled) {
        this.mOk.setEnabled(enabled);
    }

    public boolean getOkWasPressed() {
        return this.mOkWasPressed;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

