/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DuplicateChannelNameCounter;
import util.ui.ChannelLabel;

public class ChannelListCellRenderer
extends DefaultListCellRenderer {
    private ChannelLabel mChannel;
    private DuplicateChannelNameCounter mChannelCounter;
    private boolean mChannelIconsVisible;
    private boolean mTextVisible;
    private boolean mDefaultValues;
    private boolean mShowCountry;
    private boolean mShowJointChannelInfo;
    private boolean mPaintChannelBackgroundColor;
    private Channel[] mChannels;
    private JPanel mSeparator;

    public ChannelListCellRenderer() {
        this(true, false, false);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible) {
        this(channelIconsVisible, false, false, false);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible) {
        this(channelIconsVisible, textVisible, false);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible, boolean defaultValues) {
        this(channelIconsVisible, textVisible, defaultValues, false);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible, boolean defaultValues, boolean showCountry) {
        this(channelIconsVisible, textVisible, defaultValues, showCountry, false);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible, boolean defaultValues, boolean showCountry, boolean showJointChannelName) {
        this(channelIconsVisible, textVisible, defaultValues, showCountry, null, showJointChannelName);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible, boolean defaultValues, boolean showCountry, boolean showJointChannelName, boolean paintChannelBackgroundColor) {
        this(channelIconsVisible, textVisible, defaultValues, showCountry, null, showJointChannelName, paintChannelBackgroundColor);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible, boolean defaultValues, boolean showCountry, Channel[] channels) {
        this(channelIconsVisible, textVisible, defaultValues, showCountry, channels, false);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible, boolean defaultValues, boolean showCountry, Channel[] channels, boolean showJointChannelInfo) {
        this(channelIconsVisible, textVisible, defaultValues, showCountry, channels, showJointChannelInfo, false);
    }

    public ChannelListCellRenderer(boolean channelIconsVisible, boolean textVisible, boolean defaultValues, boolean showCountry, Channel[] channels, boolean showJointChannelInfo, boolean paintChannelBackgroundColor) {
        this.mChannelIconsVisible = channelIconsVisible;
        this.mTextVisible = textVisible;
        this.mDefaultValues = defaultValues;
        this.mShowCountry = showCountry;
        this.mChannels = channels;
        this.mShowJointChannelInfo = showJointChannelInfo;
        this.mSeparator = new JPanel((LayoutManager)new FormLayout("0dlu:grow", "3dlu,default,3dlu"));
        this.mSeparator.add((Component)new JSeparator(0), CC.xy((int)1, (int)2));
        this.mSeparator.setOpaque(false);
        this.mPaintChannelBackgroundColor = paintChannelBackgroundColor;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof Channel) {
            if (this.mChannel == null) {
                this.mChannel = new ChannelLabel(this.mChannelIconsVisible, this.mTextVisible, this.mDefaultValues, false, this.mShowJointChannelInfo, false);
            }
            if (this.mShowCountry) {
                if (this.mChannelCounter == null) {
                    this.mChannelCounter = new DuplicateChannelNameCounter(ChannelList.getAvailableChannels());
                }
                if (value instanceof Channel) {
                    this.mChannel.setShowCountry(this.mChannelCounter.isDuplicate((Channel)value));
                    this.mChannel.setShowService(this.mChannelCounter.isDuplicateIncludingCountry((Channel)value));
                }
            }
            if (value instanceof Channel) {
                boolean found;
                this.mChannel.setChannel((Channel)value);
                this.mChannel.setOpaque(isSelected || this.mPaintChannelBackgroundColor && ((Channel)value).isUsingUserBackgroundColor());
                this.mChannel.setBackground(label.getBackground());
                this.mChannel.setForeground(label.getForeground());
                if (this.mPaintChannelBackgroundColor && ((Channel)value).isUsingUserBackgroundColor() && !isSelected) {
                    this.mChannel.setBackground(((Channel)value).getUserBackgroundColor());
                }
                boolean bl = found = this.mChannels == null;
                if (this.mChannels != null) {
                    for (Channel mChannel2 : this.mChannels) {
                        Channel channel = Channel.getChannelForChannel(mChannel2);
                        if (!channel.equals(value)) continue;
                        found = true;
                        break;
                    }
                }
                this.mChannel.setEnabled(found);
                return this.mChannel;
            }
        } else if (value instanceof String && "##SEPARATOR##".equals(value)) {
            return this.mSeparator;
        }
        return label;
    }

    public Component getListComponent() {
        return this.mChannel;
    }

    public void setChannels(Channel[] channels) {
        this.mChannels = channels;
    }
}

