/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Channel;
import devplugin.Plugin;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import util.i18n.Localizer;
import util.ui.OrderChooser;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItemList;

public class ChannelChooserDlg
extends JDialog
implements WindowClosingIf {
    private Channel[] mResultChannelArr;
    private Channel[] mChannelArr;
    private OrderChooser<Channel> mChannelOrderChooser;
    private SelectableItemList<Channel> mChannelItemList;
    public static final int ORDER_CHOOSER = 0;
    public static final int SELECTABLE_ITEM_LIST = 1;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelChooserDlg.class);

    public ChannelChooserDlg(Window parent, Channel[] channelArr, String description) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(channelArr, description, 0);
    }

    public ChannelChooserDlg(Window parent, Channel[] channelArr, String description, int type) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(channelArr, description, type);
    }

    private void init(Channel[] channelArr, String description, int type) {
        this.setTitle(mLocalizer.msg("chooseChannels", "choose channels"));
        UiUtilities.registerForClosing(this);
        if (channelArr == null) {
            this.mChannelArr = new Channel[0];
            this.mResultChannelArr = new Channel[0];
        } else {
            this.mChannelArr = channelArr;
            this.mResultChannelArr = channelArr;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        FormLayout layout = new FormLayout("fill:pref:grow", "");
        contentPane.setLayout((LayoutManager)layout);
        contentPane.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        if (type == 0) {
            this.mChannelOrderChooser = new OrderChooser<Channel>(this.mResultChannelArr, Plugin.getPluginManager().getSubscribedChannels());
            this.mChannelItemList = null;
        } else {
            this.mChannelItemList = new SelectableItemList<Channel>(this.mResultChannelArr, Plugin.getPluginManager().getSubscribedChannels());
            this.mChannelOrderChooser = null;
        }
        int pos = 1;
        layout.appendRow(RowSpec.decode((String)"fill:default:grow"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        if (this.mChannelOrderChooser != null) {
            contentPane.add(this.mChannelOrderChooser, cc.xy(1, pos));
        } else {
            contentPane.add(this.mChannelItemList, cc.xy(1, pos));
        }
        pos += 2;
        if (description != null) {
            JLabel lb = new JLabel(description);
            layout.appendRow(RowSpec.decode((String)"pref"));
            layout.appendRow(RowSpec.decode((String)"3dlu"));
            contentPane.add((Component)lb, cc.xy(1, pos));
            pos += 2;
        }
        JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
        JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        okBt.addActionListener(event -> {
            List<Channel> listChannel = this.mChannelOrderChooser != null ? this.mChannelOrderChooser.getOrderList() : this.mChannelItemList.getSelectionList();
            this.mResultChannelArr = new Channel[listChannel.size()];
            for (int i = 0; i < listChannel.size(); ++i) {
                this.mResultChannelArr[i] = listChannel.get(i);
            }
            this.setVisible(false);
        });
        cancelBt.addActionListener(event -> {
            this.mResultChannelArr = null;
            this.setVisible(false);
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton((JComponent[])new JButton[]{okBt, cancelBt});
        layout.appendRow(RowSpec.decode((String)"pref"));
        contentPane.add((Component)builder.getPanel(), cc.xy(1, pos));
        this.pack();
    }

    public Channel[] getChannels() {
        if (this.mResultChannelArr == null) {
            return this.mChannelArr;
        }
        return this.mResultChannelArr;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

